/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class WindowAnnotationManager {
    private IWorkbenchWindow fWindow;
    private Map fAnnotationManagers;
    private IPartListener2 fPartListener;
    private AbstractTextSearchResult fSearchResult;

    public WindowAnnotationManager(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fAnnotationManagers = new HashMap();
        this.initEditors();
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.stopHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.stopHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.fWindow.getPartService().addPartListener(this.fPartListener);
    }

    private void startHighlighting(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        EditorAnnotationManager mgr = (EditorAnnotationManager)this.fAnnotationManagers.get(editor);
        if (mgr == null) {
            mgr = new EditorAnnotationManager(editor);
            this.fAnnotationManagers.put(editor, mgr);
            mgr.setSearchResult(this.fSearchResult);
        }
    }

    private void initEditors() {
        IWorkbenchPage[] pages = this.fWindow.getPages();
        int i = 0;
        while (i < pages.length) {
            IEditorReference[] editors = pages[i].getEditorReferences();
            int j = 0;
            while (j < editors.length) {
                IEditorPart editor = editors[j].getEditor(false);
                if (editor != null && pages[i].isPartVisible((IWorkbenchPart)editor)) {
                    this.startHighlighting(editor);
                }
                ++j;
            }
            ++i;
        }
    }

    private void stopHighlighting(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        EditorAnnotationManager mgr = (EditorAnnotationManager)this.fAnnotationManagers.remove(editor);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    private IEditorPart getEditor(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            return ((IEditorReference)partRef).getEditor(false);
        }
        return null;
    }

    void dispose() {
        this.fWindow.getPartService().removePartListener(this.fPartListener);
        Iterator mgrs = this.fAnnotationManagers.values().iterator();
        while (mgrs.hasNext()) {
            EditorAnnotationManager mgr = (EditorAnnotationManager)mgrs.next();
            mgr.dispose();
        }
        this.fAnnotationManagers = null;
    }

    void setSearchResult(AbstractTextSearchResult result) {
        this.fSearchResult = result;
        Iterator mgrs = this.fAnnotationManagers.values().iterator();
        while (mgrs.hasNext()) {
            EditorAnnotationManager mgr = (EditorAnnotationManager)mgrs.next();
            mgr.setSearchResult(result);
        }
    }
}

