/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.internal.protocol.bundleentry.Handler;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class AbstractBundleData
implements BundleData {
    protected AbstractFrameworkAdaptor adaptor;
    protected Dictionary manifest = null;
    protected Bundle bundle;
    protected long id;
    private String location;
    private String fileName;
    private String[] nativePaths;
    private int generation = 1;
    private int startLevel = -1;
    private int status = 0;
    private boolean reference;
    private String symbolicName;
    private Version version;
    private String activator;
    private String classpath;
    private String executionEnvironment;
    private String dynamicImports;
    private boolean fragment = false;

    public AbstractBundleData(AbstractFrameworkAdaptor adaptor, long id) {
        this.adaptor = adaptor;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getManifest() throws BundleException {
        if (this.manifest == null) {
            AbstractBundleData abstractBundleData = this;
            synchronized (abstractBundleData) {
                if (this.manifest == null) {
                    URL url = this.getEntry("META-INF/MANIFEST.MF");
                    if (url == null) {
                        throw new BundleException(AdaptorMsg.formatter.getString("MANIFEST_NOT_FOUND_EXCEPTION", (Object)"META-INF/MANIFEST.MF", (Object)this.getLocation()));
                    }
                    try {
                        this.manifest = Headers.parseManifest((InputStream)url.openStream());
                    }
                    catch (IOException e) {
                        throw new BundleException(AdaptorMsg.formatter.getString("MANIFEST_NOT_FOUND_EXCEPTION", (Object)"META-INF/MANIFEST.MF", (Object)this.getLocation()), (Throwable)e);
                    }
                }
            }
        }
        return this.manifest;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getBundleID() {
        return this.id;
    }

    public URL getEntry(String path) {
        BundleEntry entry = this.getBaseBundleFile().getEntry(path);
        if (entry == null) {
            return null;
        }
        try {
            return new URL(null, AbstractBundleData.getBundleEntryURL(this.id, path), new Handler(entry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Enumeration getEntryPaths(String path) {
        return this.getBaseBundleFile().getEntryPaths(path);
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] bundleclasspath) {
        return this.getAdaptor().getElementFactory().createClassLoader(delegate, domain, bundleclasspath, this);
    }

    public abstract File createGenerationDir();

    public abstract BundleFile getBaseBundleFile();

    public AbstractFrameworkAdaptor getAdaptor() {
        return this.adaptor;
    }

    public static String getBundleEntryURL(long id, String path) {
        StringBuffer url = new StringBuffer("bundleentry");
        url.append("://").append(id);
        if (path.length() == 0 || path.charAt(0) != '/') {
            url.append('/');
        }
        url.append(path);
        return url.toString();
    }

    public static String parseSymbolicName(Dictionary manifest) {
        String symbolicNameEntry = (String)manifest.get("Bundle-SymbolicName");
        if (symbolicNameEntry == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameEntry)[0].getValue();
        }
        catch (BundleException bundleException) {
            return null;
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[] getNativePaths() {
        return this.nativePaths;
    }

    public String getNativePathsString() {
        if (this.nativePaths == null || this.nativePaths.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.nativePaths.length) {
            sb.append(this.nativePaths[i]);
            if (i < this.nativePaths.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        return sb.toString();
    }

    public void setNativePaths(String[] nativePaths) {
        this.nativePaths = nativePaths;
    }

    public void setNativePaths(String nativePaths) {
        if (nativePaths == null) {
            return;
        }
        ArrayList<String> result = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(nativePaths, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            result.add(path);
        }
        this.setNativePaths(result.toArray(new String[result.size()]));
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getActivator() {
        return this.activator;
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public void setClassPath(String classpath) {
        this.classpath = classpath;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getDynamicImports() {
        return this.dynamicImports;
    }

    public void setDynamicImports(String dynamicImports) {
        this.dynamicImports = dynamicImports;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }
}

