/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;

class DefaultPermissionStorage
implements PermissionStorage {
    protected File permissionDir;
    protected Hashtable permissionFiles;
    protected File defaultData;
    protected static final int PERMISSIONDATA_VERSION_1 = 1;
    protected static final int PERMISSIONDATA_VERSION = 1;

    protected DefaultPermissionStorage(DefaultAdaptor adaptor) throws IOException {
        this.permissionDir = new File(adaptor.getBundleStoreRootDir(), "permdata");
        this.permissionFiles = new Hashtable();
        if (!this.permissionDir.exists() && !this.permissionDir.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Unable to create directory: " + this.permissionDir.getPath()));
            }
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        this.defaultData = new File(this.permissionDir, ".default");
        this.loadLocations();
    }

    public synchronized String[] getLocations() throws IOException {
        int size = this.permissionFiles.size();
        if (size == 0) {
            return null;
        }
        String[] locations = new String[size];
        Enumeration keysEnum = this.permissionFiles.keys();
        int i = 0;
        while (i < size) {
            locations[i] = (String)keysEnum.nextElement();
            ++i;
        }
        return locations;
    }

    public synchronized String[] getPermissionData(String location) throws IOException {
        File file;
        if (location == null) {
            file = this.defaultData;
        } else {
            file = (File)this.permissionFiles.get(location);
            if (file == null) {
                return null;
            }
        }
        try {
            return this.readData(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public synchronized void setPermissionData(String location, String[] data) throws IOException {
        if (location == null) {
            File file = this.defaultData;
            if (data == null) {
                ReliableFile.delete(this.defaultData);
            } else {
                this.save(this.defaultData, null, data);
            }
        } else {
            File file = (File)this.permissionFiles.get(location);
            if (data == null) {
                if (file == null) {
                    return;
                }
                this.permissionFiles.remove(location);
                ReliableFile.delete(file);
            } else {
                file = this.save(file, location, data);
                this.permissionFiles.put(location, file);
            }
        }
    }

    protected void loadLocations() throws IOException {
        String[] list = this.permissionDir.list();
        if (list == null) {
            return;
        }
        int len = list.length;
        int i = 0;
        while (i < len) {
            String name = list[i];
            if (!(name.endsWith(".new") || name.endsWith(".bak") || name.endsWith(".tmp"))) {
                File file = new File(this.permissionDir, name);
                try {
                    String location = this.readLocation(file);
                    if (location != null) {
                        this.permissionFiles.put(location, file);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLocation(File file) throws IOException {
        DataInputStream in;
        block6: {
            String string;
            in = new DataInputStream(new ReliableFileInputStream(file));
            try {
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        String location;
                        boolean locationPresent = in.readBoolean();
                        if (!locationPresent) break block6;
                        string = location = in.readUTF();
                        Object var6_7 = null;
                        break;
                    }
                    default: {
                        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return string;
        }
        Object var6_9 = null;
        in.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readData(File file) throws IOException {
        String[] stringArray;
        DataInputStream in;
        block8: {
            in = new DataInputStream(new ReliableFileInputStream(file));
            try {
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        boolean locationPresent = in.readBoolean();
                        if (locationPresent) {
                            in.readUTF();
                        }
                        int size = in.readInt();
                        String[] data = new String[size];
                        int i = 0;
                        while (true) {
                            if (i >= size) {
                                stringArray = data;
                                Object var8_9 = null;
                                break block8;
                            }
                            data[i] = in.readUTF();
                            ++i;
                        }
                    }
                    default: {
                        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                in.close();
                throw throwable;
            }
        }
        in.close();
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File save(File file, String location, String[] data) throws IOException {
        if (file == null) {
            file = File.createTempFile("perm", "", this.permissionDir);
            file.delete();
        }
        int size = data.length;
        DataOutputStream out = new DataOutputStream(new ReliableFileOutputStream(file));
        try {
            out.writeInt(1);
            if (location == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(location);
            }
            out.writeInt(size);
            int i = 0;
            while (i < size) {
                out.writeUTF(data[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            out.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        out.close();
        return file;
    }
}

