/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.editor.ColourJFrame;
import org.emboss.jemboss.editor.Consensus;
import org.emboss.jemboss.editor.ConsensusOptions;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.IDTableJFrame;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.MatrixJFrame;
import org.emboss.jemboss.editor.Paste;
import org.emboss.jemboss.editor.PatternJFrame;
import org.emboss.jemboss.editor.PrettyPlotJFrame;
import org.emboss.jemboss.editor.PrintAlignment;
import org.emboss.jemboss.editor.PrintAlignmentImage;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceProperties;
import org.emboss.jemboss.editor.SequenceReader;
import org.emboss.jemboss.editor.SequenceSaver;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class AlignJFrame
extends JFrame {
    private Vector graphicSequence;
    protected JScrollPane jspSequence;
    protected static GraphicSequenceCollection gsc;
    private static Matrix mat;
    private PrettyPlotJFrame ppj = null;
    protected static JTextField statusField;
    private File sequenceFile = null;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    protected JCheckBoxMenuItem residueColor;
    protected Hashtable currentColour;
    protected boolean useExitMenu = false;
    protected JMenuBar menuBar;

    public AlignJFrame(Vector vector) {
        this();
        if (vector != null && vector.size() > 0) {
            this.openMethod(vector);
        }
    }

    public AlignJFrame(File file) {
        this();
        SequenceReader sequenceReader = new SequenceReader(file);
        this.sequenceFile = sequenceReader.getSequenceFile();
        this.openMethod(sequenceReader.getSequenceVector());
        this.setTitle("Jemboss Alignment Viewer    :: " + this.sequenceFile.getName());
    }

    public AlignJFrame(String string, String string2) {
        this();
        SequenceReader sequenceReader = new SequenceReader(string);
        this.sequenceFile = null;
        this.openMethod(sequenceReader.getSequenceVector());
        this.setTitle("Jemboss Alignment Viewer    :: " + string2);
    }

    public AlignJFrame() {
        this(false);
    }

    public AlignJFrame(boolean bl) {
        super("Jemboss Alignment Editor");
        JMenuItem jMenuItem;
        this.useExitMenu = bl;
        final Dimension dimension = this.getToolkit().getScreenSize();
        int n = 10;
        mat = new Matrix("resources/resources.jar", "EBLOSUM62");
        this.jspSequence = new JScrollPane();
        this.jspSequence.getViewport().setBackground(Color.white);
        final JButton jButton = new JButton("Lock");
        this.jspSequence.setCorner("LOWER_LEFT_CORNER", jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jButton.getText().equals("Lock")) {
                    gsc.setSequenceLock(true);
                    jButton.setText("Unlock");
                } else {
                    gsc.setSequenceLock(false);
                    jButton.setText("Lock");
                }
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        final JMenuItem jMenuItem2 = new JMenuItem("Consensus");
        final JMenuItem jMenuItem3 = new JMenuItem("Consensus plot");
        JMenuItem jMenuItem4 = new JMenuItem("Open...");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceReader sequenceReader = new SequenceReader();
                if (sequenceReader.isReading()) {
                    AlignJFrame.this.sequenceFile = sequenceReader.getSequenceFile();
                    AlignJFrame.this.openMethod(sequenceReader.getSequenceVector());
                    jMenuItem2.setText("Calculate consensus");
                    jMenuItem3.setText("Calculate consensus plot");
                    AlignJFrame.this.setTitle("Jemboss Alignment Viewer    :: " + AlignJFrame.this.sequenceFile.getName());
                }
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Save As...");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SequenceSaver(gsc.getSequenceCollection(), AlignJFrame.this.sequenceFile);
            }
        });
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Save Consensus");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector<Sequence> vector = new Vector<Sequence>();
                vector.add(gsc.getConsensusSequence());
                new SequenceSaver(vector);
            }
        });
        jMenu.add(jMenuItem6);
        JMenu jMenu2 = new JMenu("Print");
        jMenu.add(jMenu2);
        JMenuItem jMenuItem7 = new JMenuItem("Print Postscript...");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PrintAlignment(gsc);
            }
        });
        jMenu2.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Print Image Files (png/jpeg)...");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                printAlignmentImage.print();
            }
        });
        jMenu2.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Print to Single Image File...");
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                String string = printAlignmentImage.showOptions(true);
                printAlignmentImage.print(string, 0.0, 0.0, 0.0, 0.0);
            }
        });
        jMenu2.add(jMenuItem9);
        JMenu jMenu3 = new JMenu("Print Preview");
        jMenu.add(jMenu3);
        JMenuItem jMenuItem10 = new JMenuItem("Multiple Pages...");
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                printAlignmentImage.printPreview();
            }
        });
        jMenu3.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Single Page...");
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                String string = printAlignmentImage.showOptions(false);
                printAlignmentImage.printSinglePagePreview();
            }
        });
        jMenu3.add(jMenuItem11);
        jMenu.add(new JSeparator());
        if (!bl) {
            jMenuItem = new JMenuItem("Close");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AlignJFrame.this.dispose();
                }
            });
            jMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Exit");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jMenu.add(jMenuItem);
        }
        this.menuBar.add(jMenu);
        jMenuItem = new JMenu("Edit");
        this.menuBar.add((JMenu)jMenuItem);
        JMenuItem jMenuItem12 = new JMenuItem("Insert Annotation Sequence");
        ((JMenu)jMenuItem).add(jMenuItem12);
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPanel scrollPanel = new ScrollPanel(new BorderLayout());
                Box box = Box.createVerticalBox();
                JRadioButton jRadioButton = new JRadioButton("Read from File");
                JRadioButton jRadioButton2 = new JRadioButton("Cut and Paste");
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                jRadioButton2.setSelected(true);
                box.add(jRadioButton);
                box.add(jRadioButton2);
                scrollPanel.add((Component)box, "Center");
                int n = JOptionPane.showConfirmDialog(null, scrollPanel, "Cut and Paste/Read from File", 2, 3);
                if (n == 0) {
                    Serializable serializable;
                    SequenceReader sequenceReader = null;
                    if (jRadioButton.isSelected()) {
                        sequenceReader = new SequenceReader();
                    } else {
                        serializable = new Paste();
                        n = JOptionPane.showConfirmDialog(null, serializable, "Cut and Paste", 2, 3);
                        if (n == 0) {
                            sequenceReader = new SequenceReader(serializable.getSequence());
                        }
                    }
                    if (sequenceReader != null && sequenceReader.isReading()) {
                        AlignJFrame.this.sequenceFile = sequenceReader.getSequenceFile();
                        gsc.addAnnotationSequence(sequenceReader.getSequence(0));
                        serializable = gsc.getPanelSize();
                        gsc.setPreferredSize((Dimension)serializable);
                        gsc.setNamePanelWidth(gsc.getNameWidth());
                        AlignJFrame.this.jspSequence.setViewportView(gsc);
                    }
                }
            }
        });
        JMenuItem jMenuItem13 = new JMenuItem("Trim Sequences");
        ((JMenu)jMenuItem).add(jMenuItem13);
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPanel scrollPanel = new ScrollPanel(new BorderLayout());
                Box box = Box.createHorizontalBox();
                TextFieldInt textFieldInt = new TextFieldInt();
                textFieldInt.setValue(1);
                TextFieldInt textFieldInt2 = new TextFieldInt();
                textFieldInt2.setValue(gsc.getMaxSeqLength());
                box.add(textFieldInt);
                box.add(new JLabel(" start "));
                box.add(textFieldInt2);
                box.add(new JLabel(" end"));
                scrollPanel.add((Component)box, "Center");
                int n = JOptionPane.showConfirmDialog(null, scrollPanel, "Select Sequence Range to Use", 2, 3);
                if (n == 0) {
                    Vector vector = gsc.getSequenceCollection();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Sequence sequence = (Sequence)enumeration.nextElement();
                        sequence.trim(textFieldInt.getValue(), textFieldInt2.getValue());
                    }
                    gsc.setMaxSeqLength();
                    gsc.repaint();
                }
            }
        });
        JMenuItem jMenuItem14 = new JMenuItem("Unlock All Sequences");
        ((JMenu)jMenuItem).add(jMenuItem14);
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setSequenceLock(false);
            }
        });
        JMenu jMenu4 = new JMenu("View");
        jMenu4.setMnemonic(86);
        JMenuItem jMenuItem15 = new JMenuItem("Find pattern");
        jMenu4.add(jMenuItem15);
        final PatternJFrame patternJFrame = new PatternJFrame();
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Point point = AlignJFrame.this.getLocationOnScreen();
                point.y -= patternJFrame.getHeight();
                if ((double)(point.y + patternJFrame.getHeight()) > dimension.getHeight()) {
                    point.x = (int)(dimension.getWidth() - (double)patternJFrame.getHeight());
                }
                patternJFrame.setLocation(point);
                patternJFrame.setGraphic(gsc);
                patternJFrame.setVisible(true);
                patternJFrame.toFront();
            }
        });
        jMenu4.add(new JSeparator());
        JMenuItem jMenuItem16 = new JMenuItem("Matrix Display");
        jMenu4.add(jMenuItem16);
        final MatrixJFrame matrixJFrame = new MatrixJFrame(mat, statusField, this);
        jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                matrixJFrame.setMatrix(mat);
                matrixJFrame.setVisible(true);
                matrixJFrame.toFront();
            }
        });
        JMenuItem jMenuItem17 = new JMenuItem("Colour Display");
        jMenu4.add(jMenuItem17);
        final ColourJFrame colourJFrame = new ColourJFrame(this);
        jMenuItem17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Point point = AlignJFrame.this.getLocationOnScreen();
                point.x += AlignJFrame.this.getWidth();
                if ((double)(point.x + colourJFrame.getWidth()) > dimension.getWidth()) {
                    point.x = (int)(dimension.getWidth() - (double)colourJFrame.getWidth());
                }
                colourJFrame.setLocation(point);
                colourJFrame.setCurrentColour(AlignJFrame.this.currentColour);
                colourJFrame.setVisible(true);
                colourJFrame.toFront();
            }
        });
        jMenu4.add(new JSeparator());
        this.colourMenus(jMenu4);
        JMenuItem jMenuItem18 = new JMenuItem("Colour Identical/Matches");
        jMenu4.add(jMenuItem18);
        jMenu4.add(new JSeparator());
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Draw boxes", false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setDrawBoxes(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu4.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Colour boxes", true);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setDrawColor(jCheckBoxMenuItem2.isSelected());
            }
        });
        jMenu4.add(jCheckBoxMenuItem2);
        jMenuItem18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AlignJFrame.this.ppj == null) {
                    AlignJFrame.this.ppj = new PrettyPlotJFrame(gsc);
                } else {
                    AlignJFrame.this.ppj.setGraphicSequenceCollection(gsc);
                }
                gsc.setMatrix(mat);
                AlignJFrame.this.ppj.setVisible(true);
            }
        });
        this.menuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu("Calculate");
        this.menuBar.add(jMenu5);
        final ConsensusOptions consensusOptions = new ConsensusOptions(this.jspSequence);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlignJFrame.this.setCursor(AlignJFrame.this.cbusy);
                gsc.deleteSequence("Consensus");
                float f = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
                float f2 = 0.0f;
                try {
                    f2 = consensusOptions.getPlurality();
                }
                catch (NumberFormatException numberFormatException) {
                    f2 = f / 2.0f;
                }
                float f3 = 0.0f;
                try {
                    f3 = consensusOptions.getCase();
                }
                catch (NumberFormatException numberFormatException) {
                    f3 = f / 2.0f;
                }
                Consensus consensus = new Consensus(mat, gsc.getSequenceCollection(), f2, f3, consensusOptions.getIdentity());
                int n = gsc.getFontSize();
                gsc.addSequence(consensus.getConsensusSequence(), true, 0, n);
                Dimension dimension = gsc.getPanelSize();
                gsc.setPreferredSize(dimension);
                gsc.setNamePanelWidth(gsc.getNameWidth());
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.setCursor(AlignJFrame.this.cdone);
                jMenuItem2.setText("Recalculate consensus");
            }
        });
        jMenu5.add(jMenuItem2);
        JMenuItem jMenuItem19 = new JMenuItem("Set consensus options...");
        jMenuItem19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Vector vector = gsc.getSequenceCollection();
                    float f = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
                    consensusOptions.setCase(f / 2.0f);
                    consensusOptions.setPlurality(f / 2.0f);
                    consensusOptions.setGraphicSequenceCollection(gsc);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                consensusOptions.setMatrix(mat);
                consensusOptions.setVisible(true);
            }
        });
        jMenu5.add(jMenuItem19);
        jMenu5.add(new JSeparator());
        JMenuItem jMenuItem20 = new JMenuItem("Identity table");
        jMenuItem20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDTableJFrame iDTableJFrame = new IDTableJFrame(gsc.getSequenceCollection());
                iDTableJFrame.setVisible(true);
            }
        });
        jMenu5.add(jMenuItem20);
        jMenu5.add(new JSeparator());
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlignJFrame.this.setCursor(AlignJFrame.this.cbusy);
                gsc.showConsensusPlot(mat, 2);
                AlignJFrame.this.setCursor(AlignJFrame.this.cdone);
                jMenuItem3.setText("Recalculate Consensus plot");
            }
        });
        jMenu5.add(jMenuItem3);
        jMenu5.add(new JSeparator());
        JMenuItem jMenuItem21 = new JMenuItem("Sort by ID");
        jMenu5.add(jMenuItem21);
        jMenuItem21.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.idSort();
                AlignJFrame.this.jspSequence.setViewportView(gsc);
            }
        });
        String[] stringArray = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem("12");
        this.menuBar.add(jComboBox);
        jComboBox.setEditable(true);
        Dimension dimension2 = new Dimension(50, 20);
        jComboBox.setPreferredSize(dimension2);
        jComboBox.setMaximumSize(dimension2);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getSelectedItem();
                if (gsc != null) {
                    gsc.setFontSizeForCollection(Integer.parseInt(string));
                }
            }
        });
        this.setJMenuBar(this.menuBar);
        JMenu jMenu6 = new JMenu("Help");
        this.menuBar.add(jMenu6);
        JMenuItem jMenuItem22 = new JMenuItem("About");
        jMenu6.add(jMenuItem22);
        jMenuItem22.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                try {
                    URL uRL = classLoader.getResource("resources/readmeAlign.html");
                    new Browser(uRL, "resources/readmeAlign.html");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Jemboss Alignment Viewer Guide not found!", "Error", 0);
                }
            }
        });
        Dimension dimension3 = new Dimension(700, 300);
        this.jspSequence.setPreferredSize(dimension3);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.jspSequence, "Center");
        jPanel.add((Component)this.jspSequence, "Center");
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        statusField.setBorder(compoundBorder);
        statusField.setEditable(false);
        statusField.setText("Current matrix: " + mat.getCurrentMatrixName());
        jPanel.add((Component)statusField, "South");
        this.addWindowListener(new winExit());
        this.pack();
        this.setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 3, (int)(dimension.getHeight() - (double)this.getHeight()) / 3);
    }

    public static float getTotalWeight(Vector vector) {
        float f = 0.0f;
        vector = gsc.getSequenceCollection();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (sequence.getName().equals("Consensus")) continue;
            f += sequence.getWeight();
        }
        return f;
    }

    public void setMatrix(Matrix matrix) {
        mat = matrix;
    }

    public void repaintSequences(Hashtable hashtable) {
        gsc.setColorScheme(hashtable);
        gsc.repaint();
    }

    protected void openMethod(Vector vector) {
        gsc = new GraphicSequenceCollection(vector, this.jspSequence, true, false, true, true, statusField);
        gsc.setColorScheme(SequenceProperties.residueColor);
        this.currentColour = (Hashtable)SequenceProperties.residueColor.clone();
        this.residueColor.setSelected(true);
        this.jspSequence.setViewportView(gsc);
        this.colourScheme("Residue colour");
    }

    protected void colourScheme(String string) {
        String string2 = statusField.getText();
        int n = string2.indexOf("Colour Scheme: ");
        if (n > -1) {
            statusField.setText(string2.substring(0, n) + "Colour Scheme: " + string);
        } else {
            statusField.setText(string2 + "              " + "Colour Scheme: " + string);
        }
    }

    private void colourMenus(JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Colour by Property");
        jMenu.add(jMenu2);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Red=acidic, Blue=basic");
        jMenu2.add(jCheckBoxMenuItem);
        buttonGroup.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.acidColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.acidColor;
                AlignJFrame.this.colourScheme("Red=acidic, Blue=basic");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Red=polar");
        jMenu2.add(jCheckBoxMenuItem2);
        buttonGroup.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.polarColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.polarColor;
                AlignJFrame.this.colourScheme("Red=polar");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Red=Hydrophobic");
        jMenu2.add(jCheckBoxMenuItem3);
        buttonGroup.add(jCheckBoxMenuItem3);
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.hydrophobicColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.hydrophobicColor;
                AlignJFrame.this.colourScheme("Red=Hydrophobic");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Red=Aromatic, Blue=Aliphatic");
        jMenu2.add(jCheckBoxMenuItem4);
        buttonGroup.add(jCheckBoxMenuItem4);
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.aromaticColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.aromaticColor;
                AlignJFrame.this.colourScheme("Red=Aromatic, Blue=Aliphatic");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("Red=Surface, Blue=Buried");
        jMenu2.add(jCheckBoxMenuItem5);
        buttonGroup.add(jCheckBoxMenuItem5);
        jCheckBoxMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.surfaceColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.surfaceColor;
                AlignJFrame.this.colourScheme("Red=Surface, Blue=Buried");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("Red=Positive, Blue=Negative");
        jMenu2.add(jCheckBoxMenuItem6);
        buttonGroup.add(jCheckBoxMenuItem6);
        jCheckBoxMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.chargeColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.chargeColor;
                AlignJFrame.this.colourScheme("Red=Positive, Blue=Negative");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem7 = new JCheckBoxMenuItem("Red=Tiny, Green=Small, Blue=Large");
        jMenu2.add(jCheckBoxMenuItem7);
        buttonGroup.add(jCheckBoxMenuItem7);
        jCheckBoxMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.sizeColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.sizeColor;
                AlignJFrame.this.colourScheme("Red=Tiny, Green=Small, Blue=Large");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem8 = new JCheckBoxMenuItem("Taylor Colour");
        jMenu.add(jCheckBoxMenuItem8);
        buttonGroup.add(jCheckBoxMenuItem8);
        jCheckBoxMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.taylorColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.taylorColor;
                AlignJFrame.this.colourScheme("Taylor");
            }
        });
        this.residueColor = new JCheckBoxMenuItem("Residue Colour");
        jMenu.add(this.residueColor);
        buttonGroup.add(this.residueColor);
        this.residueColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.residueColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.residueColor;
                AlignJFrame.this.colourScheme("Residue");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem9 = new JCheckBoxMenuItem("Rasmol Colour");
        jMenu.add(jCheckBoxMenuItem9);
        buttonGroup.add(jCheckBoxMenuItem9);
        jCheckBoxMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.rasmolColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.rasmolColor;
                AlignJFrame.this.colourScheme("Rasmol");
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem10 = new JCheckBoxMenuItem("Nucleotide Colour");
        jMenu.add(jCheckBoxMenuItem10);
        buttonGroup.add(jCheckBoxMenuItem10);
        jCheckBoxMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gsc.setColorScheme(SequenceProperties.baseColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.baseColor;
                AlignJFrame.this.colourScheme("Nucleotide");
            }
        });
        jMenu.add(new JSeparator());
    }

    private static Color resolveColor(String[] stringArray, int n) {
        if (stringArray[n].equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (stringArray[n].equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (stringArray[n].equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (stringArray[n].equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (stringArray[n].equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (stringArray[n].equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (stringArray[n].equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (stringArray[n].equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (stringArray[n].equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (stringArray[n].equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (stringArray[n].equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (stringArray[n].equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (stringArray[n].equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (stringArray[n].equalsIgnoreCase("black")) {
            return Color.black;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        AlignJFrame alignJFrame = null;
        if (stringArray.length > 0) {
            Object object;
            int n;
            Object object2;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("-help") <= -1) continue;
                System.out.println("\n                  Jemboss Alignment Editor\n\nDESCRIPTION\nThe Jemboss Alignment Editor can be used interactively to\nedit a sequence alignment (read in fasta or MSF format). It can\nalso be used from the command line to produce image files\nof the alignment.\n\nUSAGE\njava org/emboss/jemboss/editor/AlignJFrame file [options]\n\nfile       This is the multiple sequence alignment in\n           fasta or MSF format.\n\nOPTIONS\n-calc      Calculate consensus and display under the alignment.\n           The following 3 flags can be used to define values\n           used in the calculations.\n           -plu       (plurality) minimum positive match score\n                      value for there to be a consensus.\n           -numid     minimum number of identities for there to\n                      be a consensus.\n           -case      minimum positive match score for setting\n                      the consensus to upper-case.\n-color     Used to define a colour scheme, below is the list of\n           available colour schemes:\n           taylor\n           residue\n           rasmol\n           acid\n           polar\n           hydrophobic\n           aromatic\n           surface\n           charge\n           size\n           base\n\n       java org.emboss.jemboss.editor.AlignJFrame file -color size\n\n-font      Set the font size.\n-id        Display a percentage ID pair table.\n-noshow    Turns of the alignment display.\n-nres      Number of residues to each line is a print out.\n-pretty    EMBOSS prettyplot colour scheme. The -matrix flag option\n           can be used to define a scoring matrix for identifying\n           positive matches.\n           -noBox         switch off box drawing around identical and\n                          positive matches.\n           -minID         define the minimum number of identities. The\n                          default for this is the number of sequences\n                          in the file.\n           -match         define a threshold value for the number of\n                          positive matches, the default is half the\n                          total wgt.\n           -colID         define a lettering colour for the identities.\n           -colIDBack     define a background colour for identities.\n           -colMatch      define a lettering  colour for positive matches.\n           -colMatchBack  define a background colour for positive\n                           matches.\n           Available colour options:\n           red, blue, cyan, darkGray, gray , green, lightGray,\n           magenta , orange, pink, white, yellow, black\n-print     Print the alignment image. The following 2 flags can be\n           used along with the print flag\n           -prefix     prefix for image output file.\n           -onePage    fit the alignment to one page. This option must be\n                       be used with the -nres flag to define the residues\n                       per line.\n           -type       png or jpeg (default is jpeg).\n           -antialias  turn anti-aliasing on.\n           -landscape  Print as landscape (the default is portrait).\n           -margin     Define the left, right, top and bottom margin\n                       (in cm).\n       java org.emboss.jemboss.editor.AlignJFrame file -matrix EBLOSUM62 \\\n                -noshow -print -margin 0.5 0.5 0.5 0.5\n\n-matrix    To define a scoring matrix. Used with the -pretty and -calc\n           option.\n-list      List the available scoring matrix files.\n\nEXAMPLE\njava org.emboss.jemboss.editor.AlignJFrame file -matrix EBLOSUM80 \\\n                             -pretty -noshow -id -print -type png\n\njava org.emboss.jemboss.editor.AlignJFrame file -matrix EPAM250 \\\n                -pretty -colIDBack black -colID white -print \\\n                -margin 0.5 0.5 0.5 0.0 -noshow\n");
                System.exit(0);
            }
            File file = new File(stringArray[0]);
            if (file.canRead()) {
                alignJFrame = new AlignJFrame(true);
                object2 = new SequenceReader(file);
                ((SequenceReader)object2).getSequenceFile();
                alignJFrame.openMethod(((SequenceReader)object2).getSequenceVector());
                alignJFrame.setTitle("Jemboss Alignment Viewer    :: " + file.getName());
                gsc.setMatrix(mat);
            }
            object2 = "output";
            String string = "jpeg";
            boolean bl = true;
            boolean bl2 = false;
            int n2 = 0;
            float f = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
            double d = -0.5;
            double d2 = -0.5;
            double d3 = -0.5;
            double d4 = -0.5;
            float f2 = f / 2.0f;
            float f3 = f / 2.0f;
            int n3 = 0;
            int n4 = gsc.getNumberSequences();
            float f4 = f / 2.0f;
            Object object3 = Color.red;
            Object object4 = Color.blue;
            Object object5 = Color.white;
            Object object6 = Color.white;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].indexOf("-matrix") > -1) {
                    mat = new Matrix("resources/resources.jar", stringArray[n + 1]);
                    gsc.setMatrix(mat);
                    statusField.setText("Current matrix: " + stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-plu") > -1) {
                    f2 = Float.parseFloat(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-match") > -1) {
                    f4 = Float.parseFloat(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-case") > -1) {
                    f3 = Float.parseFloat(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-numid") > -1) {
                    n3 = Integer.parseInt(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-colIDBack") > -1) {
                    object = AlignJFrame.resolveColor(stringArray, n + 1);
                    if (object == null) continue;
                    object5 = object;
                    continue;
                }
                if (stringArray[n].indexOf("-colMatchBack") > -1) {
                    object = AlignJFrame.resolveColor(stringArray, n + 1);
                    if (object == null) continue;
                    object6 = object;
                    continue;
                }
                if (stringArray[n].indexOf("-colMatch") > -1) {
                    object = AlignJFrame.resolveColor(stringArray, n + 1);
                    if (object == null) continue;
                    object4 = object;
                    continue;
                }
                if (stringArray[n].indexOf("-colID") > -1) {
                    object = AlignJFrame.resolveColor(stringArray, n + 1);
                    if (object == null) continue;
                    object3 = object;
                    continue;
                }
                if (stringArray[n].indexOf("-minID") > -1) {
                    n4 = Integer.parseInt(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-noBox") > -1) {
                    bl3 = false;
                    continue;
                }
                if (stringArray[n].indexOf("-font") > -1) {
                    gsc.setFontSizeForCollection(Integer.parseInt(stringArray[n + 1]));
                    continue;
                }
                if (stringArray[n].indexOf("-landscape") > -1) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[n].indexOf("-margin") > -1) {
                    d = Double.parseDouble(stringArray[n + 1]);
                    d2 = Double.parseDouble(stringArray[n + 2]);
                    d3 = Double.parseDouble(stringArray[n + 3]);
                    d4 = Double.parseDouble(stringArray[n + 4]);
                    continue;
                }
                if (stringArray[n].indexOf("-onePage") > -1) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[n].indexOf("-antialias") <= -1) continue;
                bl6 = true;
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].indexOf("-color") > -1) {
                    if (stringArray[++n].startsWith("taylor")) {
                        gsc.setColorScheme(SequenceProperties.taylorColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("residue")) {
                        gsc.setColorScheme(SequenceProperties.residueColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("rasmol")) {
                        gsc.setColorScheme(SequenceProperties.rasmolColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("acid")) {
                        gsc.setColorScheme(SequenceProperties.acidColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("polar")) {
                        gsc.setColorScheme(SequenceProperties.polarColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("hydro")) {
                        gsc.setColorScheme(SequenceProperties.hydrophobicColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("aromatic")) {
                        gsc.setColorScheme(SequenceProperties.aromaticColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("surface")) {
                        gsc.setColorScheme(SequenceProperties.surfaceColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("charge")) {
                        gsc.setColorScheme(SequenceProperties.chargeColor);
                        continue;
                    }
                    if (stringArray[n].startsWith("size")) {
                        gsc.setColorScheme(SequenceProperties.sizeColor);
                        continue;
                    }
                    if (!stringArray[n].startsWith("base")) continue;
                    gsc.setColorScheme(SequenceProperties.baseColor);
                    continue;
                }
                if (stringArray[n].indexOf("-calc") > -1) {
                    object = new Consensus(mat, gsc.getSequenceCollection(), f2, f3, n3);
                    int n5 = gsc.getFontSize();
                    gsc.addSequence(((Consensus)object).getConsensusSequence(), true, 5, n5);
                    Dimension dimension = gsc.getPanelSize();
                    gsc.setPreferredSize(dimension);
                    gsc.setNamePanelWidth(gsc.getNameWidth());
                    continue;
                }
                if (stringArray[n].indexOf("-list") > -1) {
                    System.out.println("AVAILABLE DATABASES:\n" + mat.getKeyNamesString());
                    continue;
                }
                if (stringArray[n].indexOf("-id") > -1) {
                    object = new IDTableJFrame(gsc.getSequenceCollection());
                    ((IDTableJFrame)object).printTable();
                    continue;
                }
                if (stringArray[n].indexOf("-noshow") > -1) {
                    bl = false;
                    continue;
                }
                if (stringArray[n].indexOf("-print") > -1) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n].indexOf("-nres") > -1) {
                    n2 = Integer.parseInt(stringArray[n + 1]);
                    continue;
                }
                if (stringArray[n].indexOf("-pretty") > -1) {
                    object = new PrettyPlotJFrame(n4, f4, (Color)object3, (Color)object4, (Color)object5, (Color)object6, bl3);
                    gsc.setPrettyPlot(true, (PrettyPlotJFrame)object);
                    gsc.setDrawBoxes(false);
                    gsc.setDrawColor(false);
                    continue;
                }
                if (stringArray[n].indexOf("-preview") > -1) {
                    object = new PrintAlignmentImage(gsc);
                    ((PrintAlignmentImage)object).printPreview();
                    bl = true;
                    continue;
                }
                if (stringArray[n].indexOf("-type") > -1) {
                    if (stringArray[n + 1].equalsIgnoreCase("png") || stringArray[n + 1].equalsIgnoreCase("jpeg")) {
                        string = stringArray[n + 1];
                        continue;
                    }
                    System.out.println("UNKOWN PRINT FORMAT: " + stringArray[n + 1] + " reverting to default format " + string);
                    continue;
                }
                if (stringArray[n].indexOf("-prefix") <= -1) continue;
                object2 = stringArray[n + 1];
            }
            if (bl2) {
                if (bl5) {
                    PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                    if (bl6) {
                        printAlignmentImage.setAntiAlias(true);
                    }
                    printAlignmentImage.print(n2, string, (String)object2, d, d2, d3, d4);
                } else {
                    PrintAlignmentImage printAlignmentImage = new PrintAlignmentImage(gsc);
                    if (bl6) {
                        printAlignmentImage.setAntiAlias(true);
                    }
                    printAlignmentImage.print(n2, string, (String)object2, bl4, d, d2, d3, d4);
                }
            }
            if (!bl) {
                System.exit(0);
            }
        } else {
            alignJFrame = new AlignJFrame(true);
        }
        alignJFrame.setVisible(true);
    }

    static {
        statusField = new JTextField();
    }

    class winExit
    extends WindowAdapter {
        winExit() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AlignJFrame.this.dispose();
        }
    }
}

