/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

class ColourMenu
extends JMenu {
    protected Border unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
    protected Border selectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Border activeBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Hashtable panes;
    protected ColorPane selected;

    public ColourMenu(String string) {
        super(string);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridLayout(8, 8));
        this.panes = new Hashtable();
        int[] nArray = new int[]{0, 128, 192, 255};
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    Color color = new Color(nArray[i], nArray[j], nArray[k]);
                    ColorPane colorPane = new ColorPane(color);
                    jPanel.add(colorPane);
                    this.panes.put(color, colorPane);
                }
            }
        }
        this.add(jPanel);
    }

    public void setColor(Color color) {
        Object v = this.panes.get(color);
        if (v == null) {
            return;
        }
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = (ColorPane)v;
        this.selected.setSelected(true);
    }

    public Color getColor() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getColor();
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    class ColorPane
    extends JPanel
    implements MouseListener {
        protected Color col;
        protected boolean selected;

        public ColorPane(Color color) {
            this.col = color;
            this.setBackground(color);
            this.setBorder(ColourMenu.this.unselectedBorder);
            String string = "R " + color.getRed() + ", G " + color.getGreen() + ", B " + color.getBlue();
            this.setToolTipText(string);
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.col;
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            if (this.selected) {
                this.setBorder(ColourMenu.this.selectedBorder);
            } else {
                this.setBorder(ColourMenu.this.unselectedBorder);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColourMenu.this.setColor(this.col);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColourMenu.this.doSelection();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.setBorder(ColourMenu.this.activeBorder);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setBorder(this.selected ? ColourMenu.this.selectedBorder : ColourMenu.this.unselectedBorder);
        }
    }
}

