/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.Sequence;

public class PlotConsensus
extends JPanel {
    private float[] sumscore;
    private int numbins;
    private int interval;
    private float ymin = 0.0f;
    private float ymax = 0.0f;
    private GraphicSequenceCollection viewPane = null;

    public PlotConsensus(File file, Vector vector, int n, int n2, GraphicSequenceCollection graphicSequenceCollection) {
        this.interval = n2;
        this.viewPane = graphicSequenceCollection;
        System.out.println("viewPane ");
        Matrix matrix = new Matrix(file);
        this.createPlot(matrix, vector, n);
    }

    public PlotConsensus(File file, Vector vector, int n, int n2) {
        this.interval = n2;
        Matrix matrix = new Matrix(file);
        this.createPlot(matrix, vector, n);
    }

    public PlotConsensus(String string, String string2, Vector vector, int n, int n2) {
        this(new Matrix(string, string2), vector, n, n2);
    }

    public PlotConsensus(Matrix matrix, Vector vector, int n, int n2, GraphicSequenceCollection graphicSequenceCollection) {
        this.viewPane = graphicSequenceCollection;
        this.interval = n2;
        this.createPlot(matrix, vector, n);
    }

    public PlotConsensus(Matrix matrix, Vector vector, int n, int n2) {
        this.interval = n2;
        this.createPlot(matrix, vector, n);
    }

    private void createPlot(Matrix matrix, Vector vector, int n) {
        int n2;
        int[][] nArray = matrix.getMatrix();
        int n3 = vector.size();
        int n4 = this.getMaxSequenceLength(vector);
        int n5 = matrix.getIDimension();
        this.numbins = n4;
        this.sumscore = new float[this.numbins];
        float[] fArray = new float[this.numbins];
        float[] fArray2 = new float[this.numbins];
        int n6 = n / 2;
        float[][] fArray3 = new float[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                String string = this.getResidue(vector, n8, n2);
                int n9 = matrix.getMatrixIndex(string);
                for (n7 = n8 + 1; n7 < n3; ++n7) {
                    String string2 = this.getResidue(vector, n7, n2);
                    int n10 = matrix.getMatrixIndex(string2);
                    if (n9 < 0 || n10 < 0) continue;
                    float f = (float)nArray[n9][n10] * this.getSequenceWeight(vector, n7) + fArray3[n8][n2];
                    float f2 = (float)nArray[n9][n10] * this.getSequenceWeight(vector, n8) + fArray3[n7][n2];
                    fArray3[n8][n2] = f;
                    fArray3[n7][n2] = f2;
                }
            }
            if (n2 < n - 1) continue;
            n8 = n2 + 1;
            n7 = n2 - n + 1;
            int n11 = n7 + n6;
            for (int i = 0; i < n3; ++i) {
                for (int j = n7; j < n8; ++j) {
                    int n12 = n11;
                    this.sumscore[n12] = this.sumscore[n12] + fArray3[i][j];
                }
            }
        }
        for (n2 = 0; n2 < this.numbins; ++n2) {
            this.sumscore[n2] = this.sumscore[n2] / (float)(n3 * (n3 - 1) * n * n);
            if (this.ymax < this.sumscore[n2]) {
                this.ymax = this.sumscore[n2];
            }
            if (!(this.ymin > this.sumscore[n2])) continue;
            this.ymin = this.sumscore[n2];
        }
        this.setPlotSize();
    }

    public void setPlotSize() {
        this.setPreferredSize(new Dimension(this.numbins * this.interval, (int)(this.ymax - this.ymin + 1.0f) * this.interval));
    }

    public String getResidue(Vector vector, int n, int n2) {
        String string = "-";
        try {
            string = ((Sequence)vector.get(n)).getSequence().substring(n2, n2 + 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    public float getSequenceWeight(Vector vector, int n) {
        return ((Sequence)vector.get(n)).getWeight();
    }

    public int getMaxSequenceLength(Vector vector) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (n >= sequence.getLength()) continue;
            n = sequence.getLength();
        }
        return n;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        float f = 2.0f / (this.ymax - this.ymin);
        float f2 = f * this.ymax * (float)this.interval;
        int n = 0;
        int n2 = this.numbins;
        if (this.viewPane != null) {
            Rectangle rectangle = this.viewPane.getViewRect();
            n = rectangle.x / this.interval - 2;
            if (n < 0) {
                n = 0;
            }
            if ((n2 = n + rectangle.width / this.interval + 4) > this.numbins) {
                n2 = this.numbins;
            }
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(0, (int)(f * this.ymax * (float)this.interval), this.numbins * this.interval, (int)(f * this.ymax * (float)this.interval));
        graphics.setColor(Color.red);
        int n3 = n;
        while (n3 + 1 < n2) {
            int n4 = (int)(f2 - f * this.sumscore[n3] * (float)this.interval);
            int n5 = (int)(f2 - f * this.sumscore[n3 + 1] * (float)this.interval);
            graphics.drawLine((int)(((double)n3 + 0.5) * (double)this.interval), n4, (int)(((double)n3 + 1.5) * (double)this.interval), n5);
            ++n3;
        }
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public static void main(String[] stringArray) {
        Vector<Sequence> vector = new Vector<Sequence>();
        vector.add(new Sequence("MHQDGISSMNQLGGLFVNGRP"));
        vector.add(new Sequence("-MQNSHSGVNQLGGVFVNGRP"));
        vector.add(new Sequence("STPLGQGRVNQLGGVFINGRP"));
        vector.add(new Sequence("STPLGQGRVNQLGGVFINGRP"));
        vector.add(new Sequence("-MEQTYGEVNQLGGVFVNGRP"));
        int n = 2;
        int n2 = 10;
        Matrix matrix = new Matrix("resources/resources.jar", "EDNAFULL");
        PlotConsensus plotConsensus = new PlotConsensus(matrix, vector, n, n2);
        JFrame jFrame = new JFrame("Plot Consensus");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        jPanel.add(plotConsensus);
        jPanel.setPreferredSize(plotConsensus.getPreferredSize());
        jFrame.setSize(plotConsensus.getPreferredSize());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

