/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

public class Sequence {
    private String name;
    protected String seq;
    protected int length;
    private float wt;
    private String id;
    private boolean protein;

    public Sequence(String string, String string2, int n, float f) {
        this.name = string;
        this.seq = string2;
        this.length = n;
        this.wt = f;
        int n2 = string.indexOf(" ");
        this.id = n2 > 0 ? string.substring(0, n2) : string;
    }

    public Sequence(String string, String string2, int n) {
        this(string, string2, n, 1.0f);
    }

    public Sequence(String string, String string2) {
        this(string, string2, string2.length());
    }

    public Sequence(String string) {
        this(new String(""), string);
    }

    public Sequence(String string, float f) {
        this(new String(""), string, string.length(), f);
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getSequence() {
        return this.seq;
    }

    public String getResidueAt(int n) {
        return this.seq.substring(n, n + 1);
    }

    public int getLength() {
        return this.length;
    }

    public float getWeight() {
        return this.wt;
    }

    public String getResidue(int n) {
        return this.seq.substring(n, n + 1);
    }

    public void insertResidue(String string, int n) {
        this.seq = this.seq.substring(0, n) + string + this.seq.substring(n);
        ++this.length;
    }

    public void deleteResidue(int n) {
        this.seq = this.seq.substring(0, n) + this.seq.substring(n + 1);
        --this.length;
    }

    public void trim(int n, int n2) {
        this.seq = this.seq.substring(n - 1, n2);
        this.length = n2 - n + 1;
    }

    public void appendToSequence(String string) {
        this.seq = this.seq + string;
        this.length += string.length();
    }

    public void reverseSequence() {
        char[] cArray = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            cArray[i] = this.seq.charAt(this.length - i - 1);
        }
        this.seq = new String(cArray);
    }

    public void reverseComplementSequence() {
        char[] cArray = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            cArray[i] = this.complement(this.seq.charAt(this.length - i - 1));
        }
        this.seq = new String(cArray);
    }

    public void setType(boolean bl) {
        this.protein = bl;
    }

    public void setWeight(float f) {
        this.wt = f;
    }

    public boolean isProtein() {
        return this.protein;
    }

    public void complementSequence() {
        char[] cArray = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            cArray[i] = this.complement(this.seq.charAt(i));
        }
        this.seq = new String(cArray);
    }

    private char complement(char c) {
        if (c == 't') {
            return 'a';
        }
        if (c == 'T') {
            return 'A';
        }
        if (c == 'a') {
            return 't';
        }
        if (c == 'A') {
            return 'T';
        }
        if (c == 'g') {
            return 'c';
        }
        if (c == 'G') {
            return 'C';
        }
        if (c == 'c') {
            return 'g';
        }
        if (c == 'C') {
            return 'G';
        }
        return c;
    }

    public static void main(String[] stringArray) {
        new Sequence("Seq", "ACTATACAG", 9);
    }
}

