/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class FileEditorDisplay
extends JTextPane {
    private byte[] pngContent = null;
    private String filename;
    static /* synthetic */ Class class$java$lang$String;

    public FileEditorDisplay(String string) {
        this.filename = string;
        this.initStylesForTextPane();
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2.concat(string3 + "\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + string);
        }
        if (string.endsWith(".html")) {
            this.setText(string2, "html");
        } else if (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".gif") || string.toLowerCase().endsWith(".jpeg") || string.endsWith(".tif")) {
            this.setText(string2, "png");
        } else if (string.toLowerCase().endsWith(".z") || string.toLowerCase().endsWith(".gz") || string.toLowerCase().endsWith(".zip") || string.toLowerCase().endsWith(".tar") || string.toLowerCase().endsWith(".ppt") || string.toLowerCase().endsWith(".doc") || string.toLowerCase().endsWith(".ps")) {
            this.setText("Jemboss Cannot display " + string, "regular");
        } else {
            this.setText(string2, "regular");
        }
    }

    public FileEditorDisplay(String string, Object object) {
        this.filename = string;
        this.initStylesForTextPane();
        if (object.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = FileEditorDisplay.class$("java.lang.String")) : class$java$lang$String)) {
            if (!string.endsWith(".html")) {
                this.setText((String)object, "regular");
            } else {
                this.setText((String)object, "html");
            }
        } else if (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".gif") || string.toLowerCase().endsWith(".jpeg") || string.endsWith(".tif")) {
            ImageIcon imageIcon = new ImageIcon((byte[])object);
            this.insertIcon(imageIcon);
            this.pngContent = (byte[])object;
        } else if (string.toLowerCase().endsWith(".z") || string.toLowerCase().endsWith(".gz") || string.toLowerCase().endsWith(".zip") || string.toLowerCase().endsWith(".tar") || string.toLowerCase().endsWith(".ppt") || string.toLowerCase().endsWith(".doc") || string.toLowerCase().endsWith(".ps")) {
            this.setText("Jemboss Cannot display " + string, "regular");
        } else {
            try {
                this.setText(new String((byte[])object), "regular");
            }
            catch (Exception exception) {
                this.setText("Cannot display " + string, "regular");
            }
        }
    }

    public void setSize(Dimension dimension) {
        if (dimension.width < this.getParent().getSize().width) {
            dimension.width = this.getParent().getSize().width;
        }
        super.setSize(dimension);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void setText(String string, String string2) {
        Document document = this.getDocument();
        if (string2.equalsIgnoreCase("regular")) {
            try {
                document.insertString(0, string, this.getStyle("regular"));
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Couldn't insert initial text.");
            }
        } else if (string2.equalsIgnoreCase("sequence")) {
            try {
                String string3 = this.findHeader(string);
                document.insertString(document.getLength(), string3, this.getStyle("bold"));
                for (int i = string3.length(); i < string.length(); ++i) {
                    String string4 = new String("darkGray ");
                    if (string.substring(i, i + 1).equalsIgnoreCase("A")) {
                        string4 = "green";
                    } else if (string.substring(i, i + 1).equalsIgnoreCase("T")) {
                        string4 = "red";
                    } else if (string.substring(i, i + 1).equalsIgnoreCase("G")) {
                        string4 = "black";
                    } else if (string.substring(i, i + 1).equalsIgnoreCase("C")) {
                        string4 = "blue";
                    }
                    document.insertString(document.getLength(), string.substring(i, i + 1), this.getStyle(string4));
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Couldn't insert initial text.");
            }
        } else if (string2.equalsIgnoreCase("png")) {
            ImageIcon imageIcon = new ImageIcon(this.filename, this.filename);
            this.insertIcon(imageIcon);
            this.pngContent = this.loadPNGContent(this.filename);
        } else if (string2.equalsIgnoreCase("html")) {
            this.setContentType("text/html");
            this.setText(string);
            this.setEditable(false);
        }
    }

    private byte[] loadPNGContent(String string) {
        int n = 0;
        byte[] byArray = new byte[1];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (true) {
                dataInputStream.readByte();
                ++n;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n > 0) {
            try {
                byArray = new byte[n];
                FileInputStream fileInputStream = new FileInputStream(string);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                n = 0;
                while (true) {
                    byArray[n] = dataInputStream.readByte();
                    ++n;
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public byte[] getPNGContent() {
        return this.pngContent;
    }

    protected void initStylesForTextPane() {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "monospaced");
        Style style3 = this.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        style3 = this.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        style3 = this.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = this.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
        style3 = this.addStyle("red", style2);
        StyleConstants.setForeground(style3, Color.red);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("green", style2);
        StyleConstants.setForeground(style3, Color.green);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("blue", style2);
        StyleConstants.setForeground(style3, Color.blue);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("orange", style2);
        StyleConstants.setForeground(style3, Color.orange);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("black", style2);
        StyleConstants.setForeground(style3, Color.black);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("darkGray", style2);
        StyleConstants.setForeground(style3, Color.darkGray);
        StyleConstants.setBold(style3, true);
        StyleConstants.setFontFamily(style, "monospaced");
        style3 = this.addStyle("icon", style2);
        StyleConstants.setAlignment(style3, 1);
    }

    private String findHeader(String string) {
        String string2;
        block4: {
            string2 = "";
            String string3 = "";
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            try {
                String string4 = bufferedReader.readLine();
                if (string4.startsWith(">")) {
                    string2 = string4;
                    break block4;
                }
                string3 = string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                    string3 = string3.concat("\n" + string4);
                    if (!string4.equals("//") && !string4.startsWith("SQ ") && !string4.endsWith("..")) continue;
                    string2 = string3;
                    break;
                }
            }
            catch (IOException iOException) {
                System.out.println("Cannot read " + string);
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

