package bilab;

//import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*; 
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.ISelectionListener;

import scigol.accessor;




@Sophistication(Sophistication.Developer)
public abstract class ViewerBase extends Viewer implements ISelectionListener
{
  // all subclasses are required to have this constructor (which we'll look for via reflection)
  /* public abstract ViewerBase ViewerBase(Composite parent); */
  
  @accessor
  @Summary("is this viewer in-line or does is use an external viewer component?")
  public boolean get_IsExternal() { return false; }
  
  
  public abstract void dispose();
  
  public abstract Point preferedSize();
  public abstract Point maximumSize();
  
  @accessor
  public abstract String get_title();

  @accessor
  public abstract String get_description();

  
  // provide some default implementations for convenience
  
  
  public void setSelection(ISelection selection, boolean reveal)
  {
  }
  
  
  public ISelection getSelection()
  {
    return StructuredSelection.EMPTY;
  }
  
  
  protected static Composite optionalControlsComposite(Composite parent)
  {
    OverlayingComposite overlay = new OverlayingComposite(parent, SWT.NONE);

    Button arrow = new Button(overlay,SWT.ARROW | SWT.DOWN);
    //arrow.setText("Arrow");
    
    
    return overlay;
  }
  
  
  
  
  
  // a Composite that positions its first child on top of the second
  private static class OverlayingComposite extends Composite
  {
    public OverlayingComposite(Composite parent, int style)
    {
      super(parent, style);
      Display display = Display.getCurrent();
      this.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
      addControlListener(new ResizeControlListener(this));
    }
    
    // returns size encompasing all children
    public Point computeSize(int wHint, int hHint, boolean changed) 
    {
      Control[] children = getChildren();
      if (children.length == 0)
        return new Point(SWT.MAX, SWT.MAX);

      Point size = new Point(0,0);
      for(Control c : children) {
        Point csize = c.computeSize(wHint, hHint, changed);
        if (csize.x > size.x) size.x = csize.x;
        if (csize.y > size.y) size.y = csize.y;
      }
      return size;
    }

    public Point computeSize(int wHint, int hHint)
    {
      return computeSize(wHint, hHint, false);
    }
    
    
    
    public void layout()
    {
      // put all the children on top of each other
      Rectangle b = getBounds();
      for(Control c : getChildren()) {
        Point size = c.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
        c.setBounds(b.x,b.y, Math.min(size.x,b.width), Math.min(size.y,b.height));
      }
    }
    
    
    
    private static class ResizeControlListener implements ControlListener
    {
      public ResizeControlListener(OverlayingComposite overlayingComposite)
      {
        c = overlayingComposite;
      }
      
      public void controlResized(ControlEvent e)
      {
        c.layout();
      }
      
      public void controlMoved(ControlEvent e)
      {
      
      }
      
      private OverlayingComposite c;
      
    };
    
  };
  
  
  
}


