.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "BEGIN" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
BEGIN \- Begins a transaction in chained mode
.SH SYNOPSIS
.sp
.nf
  
BEGIN [ WORK | TRANSACTION ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBWORK\fR
.TP
\fBTRANSACTION\fR
Optional keywords. They have no effect.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBBEGIN\fR
This signifies that a new transaction has been started.
.TP
\fBNOTICE: BEGIN: already a transaction in progress\fR
This indicates that a transaction was already in progress.
The current transaction is not affected.
.PP
.SH "DESCRIPTION"
.PP
By default, Postgres executes transactions
in \fIunchained mode\fR
(also known as ``autocommit'' in other database
systems).
In other words, each user statement is executed in its own transaction
and a commit is implicitly performed at the end of the statement
(if execution was successful, otherwise a rollback is done).
\fBBEGIN\fR initiates a user transaction in chained mode,
i.e., all user statements after \fBBEGIN\fR command will
be executed in a single transaction until an explicit 
COMMIT [\fBcommit\fR(l)],
ROLLBACK [\fBrollback\fR(l)],
or execution abort. Statements in chained mode are executed much faster, 
because transaction start/commit requires significant CPU and disk 
activity. Execution of multiple statements inside a transaction
is also required for consistency when changing several
related tables.
.PP
The default transaction isolation level in
Postgres
is READ COMMITTED, where queries inside the transaction see only changes
committed before query execution. So, you have to use 
\fBSET TRANSACTION ISOLATION LEVEL SERIALIZABLE\fR
just after \fBBEGIN\fR if you need more rigorous transaction isolation. 
In SERIALIZABLE mode queries will see only changes committed before
the entire
transaction began (actually, before execution of the first DML statement
in a serializable transaction).
.PP
If the transaction is committed, Postgres 
will ensure either that all updates are done or else that none of
them are done. Transactions have the standard ACID
(atomic, consistent, isolatable, and durable) property.
.SS "NOTES"
.PP
Refer to LOCK [\fBlock\fR(l)]
for further information
about locking tables inside a transaction.
.PP
Use COMMIT [\fBcommit\fR(l)]
or
ROLLBACK [\fBrollback\fR(l)]
to terminate a transaction.
.SH "USAGE"
.PP
To begin a user transaction:
.sp
.nf
BEGIN WORK;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBBEGIN\fR
is a Postgres language extension.
There is no explicit \fBBEGIN\fR
command in SQL92;
transaction initiation is always implicit and it terminates either 
with a \fBCOMMIT\fR or \fBROLLBACK\fR statement.
.sp
.RS
.B "Note:"
Many relational database systems offer an autocommit feature as a
convenience.
.RE
.sp
.PP
Incidentally, the BEGIN keyword is used for a different
purpose in embedded SQL. You are advised to be careful about the transaction
semantics when porting database applications.
.PP
SQL92 also requires SERIALIZABLE to be the default
transaction isolation level.
