.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CLOSE" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
CLOSE \- close a cursor
.SH SYNOPSIS
.sp
.nf
CLOSE \fIcursor\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIcursor\fB\fR
The name of an open cursor to close.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCLOSE\fR
Message returned if the cursor is successfully closed.
.TP
\fBNOTICE PerformPortalClose: portal "\fIcursor\fB" not found\fR
This warning is given if
\fIcursor\fR is not
declared or has already been closed.
.PP
.SH "DESCRIPTION"
.PP
\fBCLOSE\fR frees the resources associated with an open cursor.
After the cursor is closed, no subsequent operations
are allowed on it. A cursor should be closed when it is
no longer needed.
.PP
An implicit close is executed for every open cursor when a
transaction is terminated by \fBCOMMIT\fR
or \fBROLLBACK\fR.
.SS "NOTES"
.PP
Postgres does not have
an explicit \fBOPEN\fR cursor statement;
a cursor is considered open when it is declared.
Use the \fBDECLARE\fR statement to declare a cursor.
.SH "USAGE"
.PP
Close the cursor liahona:
.sp
.nf
CLOSE liahona;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCLOSE\fR is fully compatible with SQL92.
