.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP FUNCTION" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP FUNCTION \- remove a user-defined function
.SH SYNOPSIS
.sp
.nf
DROP FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing function.
.TP
\fB\fItype\fB\fR
The type of the function's parameters.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
Message returned if the command completes successfully.
.TP
\fBNOTICE RemoveFunction: Function "\fIname\fB" ("\fItypes\fB") does not exist\fR
This message is given if the function specified does not
exist in the current database.
.PP
.SH "DESCRIPTION"
.PP
DROP FUNCTION will remove the definition of an existing
function. To execute this command the user must be the
owner of the function. The input argument types to the
function must be specified, since several different functions
may exist with the same name and different argument lists.
.SH "NOTES"
.PP
Refer to
\fBcreate_function\fR(l)
for information on creating functions.
.PP
No checks are made to ensure that types, operators, access
methods, or triggers that rely on the function have been removed first.
.SH "EXAMPLES"
.PP
This command removes the square root function:
.sp
.nf
DROP FUNCTION sqrt(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBDROP FUNCTION\fR statement is defined in SQL99. One of its syntax forms is:
.sp
.nf
DROP FUNCTION \fIname\fR (\fIarg\fR, ...) { RESTRICT | CASCADE }
.sp
.fi
where CASCADE specifies dropping all objects that
depend on the function and RESTRICT refuses to
drop the function if dependent objects exist.
.SH "SEE ALSO"
\fBcreate_function\fR(l)

