.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP LANGUAGE" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP LANGUAGE \- remove a user-defined procedural language
.SH SYNOPSIS
.sp
.nf
DROP [ PROCEDURAL ] LANGUAGE \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing procedural language. For backward
compatibility, the name may be enclosed by single quotes.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
This message is returned if the language is successfully dropped.
.TP
\fBERROR: Language "\fIname\fB" doesn't exist\fR
This message occurs if a language called
\fIname\fR is
not found in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP PROCEDURAL LANGUAGE\fR will remove the definition
of the previously registered procedural language called
\fIname\fR.
.SS "NOTES"
.PP
The \fBDROP PROCEDURAL LANGUAGE\fR statement is
a PostgreSQL language extension.
.PP
Refer to
CREATE LANGUAGE [\fBcreate_language\fR(l)]
for information on how to create procedural languages.
.PP
No checks are made if functions or trigger procedures registered
in this language still exist. To re-enable them without having
to drop and recreate all the functions, the pg_proc's prolang
attribute of the functions must be adjusted to the new object
ID of the recreated pg_language entry for the PL.
.SH "USAGE"
.PP
This command removes the PL/Sample language:
.sp
.nf
DROP LANGUAGE plsample;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP PROCEDURAL LANGUAGE\fR in 
SQL92.
