.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "GRANT" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
GRANT \- define access privileges
.SH SYNOPSIS
.sp
.nf
GRANT { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }
    ON [ TABLE ] \fIobjectname\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...]
.sp
.fi
.SH "DESCRIPTION"
.PP
The \fBGRANT\fR command gives specific permissions on
an object (table, view, sequence) to one or more users or groups of users.
These permissions are added to those already granted, if any.
.PP
The key word PUBLIC indicates that the
privileges are to be granted to all users, including those that may
be created later. PUBLIC may be thought of as an
implicitly defined group that always includes all users.
Note that any particular user will have the sum
of privileges granted directly to him, privileges granted to any group he
is presently a member of, and privileges granted to
PUBLIC.
.PP
Users other than the creator do not have any access privileges
to an object unless the creator grants permissions.
There is no need to grant privileges to the creator of an object,
as the creator automatically holds all privileges, and can also
drop the object. (The creator could, however, choose to revoke
some of his own privileges for safety. Note that the ability to
grant and revoke privileges is inherent in the creator and cannot
be lost.)
.PP
The possible privileges are:
.TP
\fBSELECT\fR
Allows SELECT [\fBselect\fR(l)] from any column of the
specified table, view, or sequence. Also allows the use of
COPY [\fBcopy\fR(l)] FROM.
.TP
\fBINSERT\fR
Allows INSERT [\fBinsert\fR(l)] of a new row into the
specified table. Also allows COPY [\fBcopy\fR(l)] TO.
.TP
\fBUPDATE\fR
Allows UPDATE [\fBupdate\fR(l)] of any column of the
specified table. SELECT ... FOR UPDATE
also requires this privilege (besides the
SELECT privilege). For sequences, this
privilege allows the use of \fBnextval\fR,
\fBcurrval\fR and \fBsetval\fR.
.TP
\fBDELETE\fR
Allows the DELETE [\fBdelete\fR(l)] of a row from the
specified table.
.TP
\fBRULE\fR
Allows the creation of a rule on the table/view. (See CREATE RULE [\fBcreate_rule\fR(l)] statement).
.TP
\fBREFERENCES\fR
To create a table with a foreign key constraint, it is
necessary to have this privilege on the table with the primary
key.
.TP
\fBTRIGGER\fR
Allows the creation of a trigger on the specified table. (See
CREATE TRIGGER [\fBcreate_trigger\fR(l)] statement).
.TP
\fBALL PRIVILEGES\fR
Grant all of the above privileges at once. The
PRIVILEGES key word is optional, but it is
required by strict SQL.
.PP
The privileges required by other commands are listed on the
reference page of the respective command.
.SH "NOTES"
.PP
Currently, to grant privileges in PostgreSQL
to only a few columns, you must
create a view having the desired columns and then grant privileges
to that view.
.PP
Use \fBpsql\fR(1)'s \fB\\z\fR command
to obtain information about privileges
on existing objects:
.sp
.nf
          Database    = lusitania
   +------------------+---------------------------------------------+
   |  Relation        |        Grant/Revoke Permissions             |
   +------------------+---------------------------------------------+
   | mytable          | {"=rw","miriam=arwdRxt","group todos=rw"}   |
   +------------------+---------------------------------------------+
   Legend:
         uname=arwR -- privileges granted to a user
   group gname=arwR -- privileges granted to a group
              =arwR -- privileges granted to PUBLIC

                  r -- SELECT ("read")
                  w -- UPDATE ("write")
                  a -- INSERT ("append")
                  d -- DELETE
                  R -- RULE
                  x -- REFERENCES
                  t -- TRIGGER
            arwdRxt -- ALL PRIVILEGES
.sp
.fi
.PP
The REVOKE [\fBrevoke\fR(l)] command is used to revoke access
privileges.
.SH "EXAMPLES"
.PP
Grant insert privilege to all users on table films:
.sp
.nf
GRANT INSERT ON films TO PUBLIC;
.sp
.fi
.PP
Grant all privileges to user manuel on view kinds:
.sp
.nf
GRANT ALL PRIVILEGES ON kinds TO manuel;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The PRIVILEGES key word in ALL
PRIVILEGES is required. SQL does not
support setting the privileges on more than one table per command.
.PP
The SQL92 syntax for GRANT allows setting
privileges for individual columns within a table, and allows
setting a privilege to grant the same privileges to others:
.sp
.nf
GRANT \fIprivilege\fR [, ...]
    ON \fIobject\fR [ ( \fIcolumn\fR [, ...] ) ] [, ...]
    TO { PUBLIC | \fIusername\fR [, ...] } [ WITH GRANT OPTION ]
.sp
.fi
.PP
SQL allows to grant the USAGE privilege on
other kinds of objects: CHARACTER SET, COLLATION, TRANSLATION, DOMAIN.
.PP
The TRIGGER privilege was introduced in SQL99. The RULE privilege
is a PostgreSQL extension.
.SH "SEE ALSO"
.PP
\fBrevoke\fR(l)
