.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "LOCK" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
LOCK \- explicitly lock a table
.SH SYNOPSIS
.sp
.nf
LOCK [ TABLE ] \fIname\fR [, ...]
LOCK [ TABLE ] \fIname\fR [, ...] IN \fIlockmode\fR MODE

where \fIlockmode\fR is one of:

	ACCESS SHARE | ROW SHARE | ROW EXCLUSIVE | SHARE UPDATE EXCLUSIVE |
	SHARE | SHARE ROW EXCLUSIVE | EXCLUSIVE | ACCESS EXCLUSIVE
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing table to lock.
.TP
\fBACCESS SHARE MODE\fR
.sp
.RS
.B "Note:"
This lock mode is acquired automatically over tables being queried.
.RE
.sp
This is the least restrictive lock mode. It conflicts only with
ACCESS EXCLUSIVE mode. It is used to protect a table from being
modified by concurrent \fBALTER TABLE\fR, 
\fBDROP TABLE\fR and \fBVACUUM FULL\fR
commands.
.TP
\fBROW SHARE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBSELECT...FOR UPDATE\fR.
While it is a shared lock, may be upgraded later to a ROW EXCLUSIVE lock.
.RE
.sp
Conflicts with EXCLUSIVE and ACCESS EXCLUSIVE lock modes.
.TP
\fBROW EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBUPDATE\fR, 
\fBDELETE\fR, and \fBINSERT\fR
statements.
.RE
.sp
Conflicts with SHARE, SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes.
.TP
\fBSHARE UPDATE EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBVACUUM\fR (without
\fBFULL\fR).
.RE
.sp
Conflicts with SHARE UPDATE EXCLUSIVE, SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and
ACCESS EXCLUSIVE modes. This mode protects a table against
concurrent schema changes and VACUUMs.
.TP
\fBSHARE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBCREATE INDEX\fR.
Share-locks the entire table.
.RE
.sp
Conflicts with ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE,
SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes. This mode protects a table against
concurrent data updates.
.TP
\fBSHARE ROW EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
This is like EXCLUSIVE MODE, but allows ROW SHARE locks
by others.
.RE
.sp
Conflicts with ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE, SHARE,
SHARE ROW EXCLUSIVE, EXCLUSIVE and ACCESS EXCLUSIVE modes.
.TP
\fBEXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
This mode is yet more restrictive than SHARE ROW EXCLUSIVE. 
It blocks all concurrent ROW SHARE/SELECT...FOR UPDATE queries.
.RE
.sp
Conflicts with ROW SHARE, ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE,
SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and ACCESS EXCLUSIVE modes.
.TP
\fBACCESS EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBALTER TABLE\fR,
\fBDROP TABLE\fR, \fBVACUUM FULL\fR
statements.
This is the most restrictive lock mode which
protects a locked table from any concurrent operations.
.RE
.sp
.sp
.RS
.B "Note:"
This lock mode is also acquired by an unqualified
\fBLOCK TABLE\fR (i.e., the command without an explicit
lock mode option).
.RE
.sp
Conflicts with all lock modes.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBLOCK TABLE\fR
The lock was successfully applied.
.TP
\fBERROR \fIname\fB: Table does not exist.\fR
Message returned if \fIname\fR
does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBLOCK TABLE\fR controls concurrent access to a table
for the duration of a transaction.
PostgreSQL always uses the least restrictive
lock mode whenever possible. \fBLOCK TABLE\fR 
provides for cases when you might need more restrictive locking.
.PP
RDBMS locking uses the following terminology:
.TP
\fBEXCLUSIVE\fR
An exclusive lock prevents other locks of the same type from being
granted. (Note: ROW EXCLUSIVE mode does not follow this naming
convention perfectly, since it is shared at the level of the table;
it is exclusive only with respect to specific rows that are being
updated.)
.TP
\fBSHARE\fR
A shared lock allows others to also hold the same type of lock,
but prevents the corresponding EXCLUSIVE lock from being granted.
.TP
\fBACCESS\fR
Locks table schema.
.TP
\fBROW\fR
Locks individual rows.
.PP
.PP
For example, an application runs a transaction at READ COMMITTED isolation
level and needs to ensure the existence of data in a table for the
duration of the
transaction. To achieve this you could use SHARE lock mode over the
table before querying. This will protect data from concurrent changes 
and provide any further read operations over the table with data in their 
actual current state, because SHARE lock mode conflicts with any ROW EXCLUSIVE 
one acquired by writers, and your
\fBLOCK TABLE \fIname\fB IN SHARE MODE\fR
statement will wait until any concurrent write operations commit or rollback.
.sp
.RS
.B "Note:"
To read data in their real current state when running a transaction
at the SERIALIZABLE isolation level you have to execute a LOCK TABLE
statement before executing any DML statement, when the transaction defines
what concurrent changes will be visible to itself.
.RE
.sp
.PP
In addition to the requirements above, if a transaction is going to
change data in a table, then SHARE ROW EXCLUSIVE lock mode should
be acquired to prevent deadlock conditions when two concurrent
transactions attempt to lock the table in SHARE mode and then
try to change data in this table, both (implicitly) acquiring 
ROW EXCLUSIVE lock mode that conflicts with a concurrent SHARE lock.
.PP
To continue with the deadlock (when two transaction wait for one another)
issue raised above, you should follow two general rules to prevent 
deadlock conditions:
.TP 0.2i
\(bu
Transactions have to acquire locks on the same objects in the same order.

For example, if one application updates row R1 and than updates 
row R2 (in the same transaction) then the second application shouldn't 
update row R2 if it's going to update row R1 later (in a single transaction). 
Instead, it should update rows R1 and R2 in the same order as the first 
application.
.TP 0.2i
\(bu
Transactions should acquire two conflicting lock modes only if
one of them is self-conflicting (i.e., may be held by one
transaction at time only). If multiple lock modes are involved,
then transactions should always acquire the most restrictive mode first.

An example for this rule was given previously when discussing the 
use of SHARE ROW EXCLUSIVE mode rather than SHARE mode.
.sp
.RS
.B "Note:"
PostgreSQL does detect deadlocks and will
rollback at least one waiting transaction to resolve the deadlock. 
.PP
.RE
.sp
.PP
When locking multiple tables, the command LOCK a, b; is equivalent to LOCK
a; LOCK b;. The tables are locked one-by-one in the order specified in the
\fBLOCK\fR command.
.PP
.SS "NOTES"
.PP
\fBLOCK\fR is a PostgreSQL
language extension.
.PP
Except for ACCESS SHARE, ACCESS EXCLUSIVE, and SHARE UPDATE EXCLUSIVE lock
modes, the PostgreSQL lock modes and the
\fBLOCK TABLE\fR syntax are compatible with those
present in Oracle.
.PP
\fBLOCK\fR works only inside transactions.
.SH "USAGE"
.PP
Illustrate a SHARE lock on a primary key table when going to perform
inserts into a foreign key table:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE MODE;
SELECT id FROM films 
    WHERE name = 'Star Wars: Episode I - The Phantom Menace';
-- Do ROLLBACK if record was not returned
INSERT INTO films_user_comments VALUES 
    (_id_, 'GREAT! I was waiting for it for so long!');
COMMIT WORK;
   
.sp
.fi
.PP
Take a SHARE ROW EXCLUSIVE lock on a primary key table when going to perform
a delete operation:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE ROW EXCLUSIVE MODE;
DELETE FROM films_user_comments WHERE id IN
    (SELECT id FROM films WHERE rating < 5);
DELETE FROM films WHERE rating < 5;
COMMIT WORK;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBLOCK TABLE\fR in SQL92,
which instead uses \fBSET TRANSACTION\fR to specify
concurrency levels on transactions. We support that too; see
SET TRANSACTION [\fBset_transaction\fR(l)] for details.
