.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SELECT" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
SELECT \- retrieve rows from a table or view
.SH SYNOPSIS
.sp
.nf
SELECT [ ALL | DISTINCT [ ON ( \fIexpression\fR [, ...] ) ] ]
    * | \fIexpression\fR [ AS \fIoutput_name\fR ] [, ...]
    [ FROM \fIfrom_item\fR [, ...] ]
    [ WHERE \fIcondition\fR ]
    [ GROUP BY \fIexpression\fR [, ...] ]
    [ HAVING \fIcondition\fR [, ...] ]
    [ { UNION | INTERSECT | EXCEPT } [ ALL ] \fIselect\fR ]
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ FOR UPDATE [ OF \fItablename\fR [, ...] ] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]

where \fIfrom_item\fR can be:

[ ONLY ] \fItable_name\fR [ * ]
    [ [ AS ] \fIalias\fR [ ( \fIcolumn_alias_list\fR ) ] ]
|
( \fIselect\fR )
    [ AS ] \fIalias\fR [ ( \fIcolumn_alias_list\fR ) ]
|
\fIfrom_item\fR [ NATURAL ] \fIjoin_type\fR \fIfrom_item\fR
    [ ON \fIjoin_condition\fR | USING ( \fIjoin_column_list\fR ) ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIexpression\fB\fR
The name of a table's column or an expression.
.TP
\fB\fIoutput_name\fB\fR
Specifies another name for an output column using
the AS clause. This name is primarily used to label the column
for display. It can also be used to refer to the column's value in
ORDER BY and GROUP BY clauses. But the
\fIoutput_name\fR
cannot be used in the WHERE or HAVING clauses; write out the
expression instead.
.TP
\fB\fIfrom_item\fB\fR
A table reference, sub-SELECT, or JOIN clause. See below for details.
.TP
\fB\fIcondition\fB\fR
A boolean expression giving a result of true or false.
See the WHERE and HAVING clause descriptions below.
.TP
\fB\fIselect\fB\fR
A select statement with all features except the ORDER BY, FOR UPDATE,
and LIMIT clauses (even those can be used when the select is
parenthesized).
.PP
.PP
FROM items can contain:
.TP
\fB\fItable_name\fB\fR
The name of an existing table or view. If ONLY is specified, only that
table is scanned. If ONLY is not specified, the table and all its
descendant tables (if any) are scanned. * can be appended to the
table name to indicate that descendant tables are to be scanned,
but in the current version, this is the default behavior.
(In releases before 7.1, ONLY was the default behavior.)
.TP
\fB\fIalias\fB\fR
A substitute name for the preceding
\fItable_name\fR.
An alias is used for brevity or to eliminate ambiguity for self-joins
(where the same table is scanned multiple times). If an alias is
written, a column alias list can also be written to provide
substitute names for one or more columns of the table.
.TP
\fB\fIselect\fB\fR
A sub-SELECT can appear in the FROM clause. This acts as though
its output were created as a temporary table for the duration of
this single SELECT command. Note that the sub-SELECT must be
surrounded by parentheses, and an alias \fBmust\fR
be provided for it.
.TP
\fB\fIjoin_type\fB\fR
One of
\fB[ INNER ] JOIN\fR,
\fBLEFT [ OUTER ] JOIN\fR,
\fBRIGHT [ OUTER ] JOIN\fR,
\fBFULL [ OUTER ] JOIN\fR, or
\fBCROSS JOIN\fR.
For INNER and OUTER join types, exactly one of NATURAL,
ON \fIjoin_condition\fR, or
USING ( \fIjoin_column_list\fR )
must appear. For CROSS JOIN, none of these items may appear.
.TP
\fB\fIjoin_condition\fB\fR
A qualification condition. This is similar to the WHERE condition
except that it only applies to the two from_items being joined in
this JOIN clause.
.TP
\fB\fIjoin_column_list\fB\fR
A USING column list ( a, b, ... ) is shorthand for the ON condition
left_table.a = right_table.a AND left_table.b = right_table.b ...
.PP
.SS "OUTPUTS"
.PP
.TP
\fBRows\fR
The complete set of rows resulting from the query specification.
.TP
\fB\fIcount\fB\fR
The count of rows returned by the query.
.PP
.SH "DESCRIPTION"
.PP
\fBSELECT\fR will return rows from one or more tables.
Candidates for selection are rows which satisfy the WHERE condition;
if WHERE is omitted, all rows are candidates.
(See WHERE Clause [\fBselect\fR(l)].)
.PP
Actually, the returned rows are not directly the rows produced by the
FROM/WHERE/GROUP BY/HAVING clauses; rather, the output rows are formed
by computing the SELECT output expressions for each selected row.
\fB*\fR can be written in the output list as a shorthand
for all the columns of the selected rows. Also, one can write
\fItable_name\fR\fB.*\fR
as a shorthand for the columns coming from just that table.
.PP
\fBDISTINCT\fR will eliminate duplicate rows from the
result.
\fBALL\fR (the default) will return all candidate rows,
including duplicates.
.PP
\fBDISTINCT ON\fR eliminates rows that match on all the
specified expressions, keeping only the first row of each set of
duplicates. The DISTINCT ON expressions are interpreted using the
same rules as for ORDER BY items; see below.
Note that the ``first row'' of each set is unpredictable
unless \fBORDER BY\fR is used to ensure that the desired
row appears first. For example,
.sp
.nf
        SELECT DISTINCT ON (location) location, time, report
        FROM weatherReports
        ORDER BY location, time DESC;
   
.sp
.fi
retrieves the most recent weather report for each location. But if
we had not used ORDER BY to force descending order of time values
for each location, we'd have gotten a report of unpredictable age
for each location.
.PP
The GROUP BY clause allows a user to divide a table
into groups of rows that match on one or more values.
(See GROUP BY Clause [\fBselect\fR(l)].)
.PP
The HAVING clause allows selection of only those groups of rows
meeting the specified condition.
(See HAVING Clause [\fBselect\fR(l)].)
.PP
The ORDER BY clause causes the returned rows to be sorted in a specified
order. If ORDER BY is not given, the rows are returned in whatever order
the system finds cheapest to produce.
(See ORDER BY Clause [\fBselect\fR(l)].)
.PP
SELECT queries can be combined using UNION, INTERSECT, and EXCEPT
operators. Use parentheses if necessary to determine the ordering
of these operators.
.PP
The UNION operator computes the collection of rows
returned by the queries involved.
Duplicate rows are eliminated unless ALL is specified.
(See UNION Clause [\fBselect\fR(l)].)
.PP
The INTERSECT operator computes the rows that are common to both queries.
Duplicate rows are eliminated unless ALL is specified.
(See INTERSECT Clause [\fBselect\fR(l)].)
.PP
The EXCEPT operator computes the rows returned by the first query but
not the second query.
Duplicate rows are eliminated unless ALL is specified.
(See EXCEPT Clause [\fBselect\fR(l)].)
.PP
The FOR UPDATE clause allows the SELECT statement to perform 
exclusive locking of selected rows.
.PP
The LIMIT clause allows a subset of the rows produced by the query
to be returned to the user.
(See LIMIT Clause [\fBselect\fR(l)].)
.PP
You must have SELECT privilege to a table to read its values
(See the \fBGRANT\fR/\fBREVOKE\fR statements).
.SS "FROM CLAUSE"
.PP
The FROM clause specifies one or more source tables for the SELECT.
If multiple sources are specified, the result is conceptually the
Cartesian product of all the rows in all the sources --- but usually
qualification conditions are added to restrict the returned rows to
a small subset of the Cartesian product.
.PP
When a FROM item is a simple table name, it implicitly includes rows
from sub-tables (inheritance children) of the table.
\fBONLY\fR will
suppress rows from sub-tables of the table. Before
PostgreSQL 7.1,
this was the default result, and adding sub-tables was done
by appending \fB*\fR to the table name.
This old behaviour is available via the command 
\fBSET SQL_Inheritance TO OFF;\fR
.PP
A FROM item can also be a parenthesized sub-SELECT (note that an
alias clause is required for a sub-SELECT!). This is an extremely
handy feature since it's the only way to get multiple levels of
grouping, aggregation, or sorting in a single query.
.PP
Finally, a FROM item can be a JOIN clause, which combines two simpler
FROM items. (Use parentheses if necessary to determine the order
of nesting.)
.PP
A CROSS JOIN or INNER JOIN is a simple Cartesian product,
the same as you get from listing the two items at the top level of FROM.
CROSS JOIN is equivalent to INNER JOIN ON (TRUE), that is, no rows are
removed by qualification. These join types are just a notational
convenience, since they do nothing you couldn't do with plain FROM and
WHERE.
.PP
LEFT OUTER JOIN returns all rows in the qualified Cartesian product
(i.e., all combined rows that pass its ON condition), plus one copy of each
row in the left-hand table for which there was no right-hand row that
passed the ON condition. This left-hand row is extended to the full
width of the joined table by inserting NULLs for the right-hand columns.
Note that only the JOIN's own ON or USING condition is considered while
deciding which rows have matches. Outer ON or WHERE conditions are
applied afterwards.
.PP
Conversely, RIGHT OUTER JOIN returns all the joined rows, plus one row
for each unmatched right-hand row (extended with nulls on the left).
This is just a notational
convenience, since you could convert it to a LEFT OUTER JOIN by switching
the left and right inputs.
.PP
FULL OUTER JOIN returns all the joined rows, plus one row for each
unmatched left-hand row (extended with nulls on the right), plus one row
for each unmatched right-hand row (extended with nulls on the left).
.PP
For all the JOIN types except CROSS JOIN, you must write exactly one of
ON \fIjoin_condition\fR,
USING ( \fIjoin_column_list\fR ),
or NATURAL. ON is the most general case: you can write any qualification
expression involving the two tables to be joined.
A USING column list ( a, b, ... ) is shorthand for the ON condition
left_table.a = right_table.a AND left_table.b = right_table.b ...
Also, USING implies that only one of each pair of equivalent columns will
be included in the JOIN output, not both. NATURAL is shorthand for
a USING list that mentions all similarly-named columns in the tables.
.SS "WHERE CLAUSE"
.PP
The optional WHERE condition has the general form:
.sp
.nf
WHERE \fIboolean_expr\fR
    
.sp
.fi
\fIboolean_expr\fR
can consist of any expression which evaluates to a boolean value.
In many cases, this expression will be:
.sp
.nf
     \fIexpr\fR \fIcond_op\fR \fIexpr\fR
    
.sp
.fi
or
.sp
.nf
     \fIlog_op\fR \fIexpr\fR
    
.sp
.fi
where \fIcond_op\fR
can be one of: =, <, <=, >, >= or <>,
a conditional operator like ALL, ANY, IN, LIKE, or a
locally defined operator, 
and \fIlog_op\fR can be one 
of: AND, OR, NOT.
SELECT will ignore all rows for which the WHERE condition does not return
TRUE.
.SS "GROUP BY CLAUSE"
.PP
GROUP BY specifies a grouped table derived by the application
of this clause:
.sp
.nf
GROUP BY \fIexpression\fR [, ...]
    
.sp
.fi
.PP
GROUP BY will condense into a single row all selected rows that share the
same values for the grouped columns. Aggregate functions, if any,
are computed across all rows making up each group, producing a
separate value for each group (whereas without GROUP BY, an
aggregate produces a single value computed across all the selected
rows). When GROUP BY is present, it is not valid for the SELECT
output expression(s) to refer to
ungrouped columns except within aggregate functions, since there
would be more than one possible value to return for an ungrouped column.
.PP
A GROUP BY item can be an input column name, or the name or ordinal
number of an output column (SELECT expression), or it can be an arbitrary
expression formed from input-column values. In case of ambiguity, a GROUP
BY name will 
be interpreted as an input-column name rather than an output column name.
.SS "HAVING CLAUSE"
.PP
The optional HAVING condition has the general form:
.sp
.nf
HAVING \fIboolean_expr\fR
    
.sp
.fi
where \fIboolean_expr\fR is the same
as specified for the WHERE clause.
.PP
HAVING specifies a grouped table derived by the elimination
of group rows that do not satisfy the
\fIboolean_expr\fR.
HAVING is different from WHERE:
WHERE filters individual rows before application of GROUP BY,
while HAVING filters group rows created by GROUP BY.
.PP
Each column referenced in 
\fIboolean_expr\fR shall unambiguously
reference a grouping column, unless the reference appears within an
aggregate function.
.SS "ORDER BY CLAUSE"
.PP
.sp
.nf
ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...]
    
.sp
.fi
.PP
An ORDER BY item can be the name or ordinal
number of an output column (SELECT expression), or it can be an arbitrary
expression formed from input-column values. In case of ambiguity, an
ORDER BY name will be interpreted as an output-column name.
.PP
The ordinal number refers to the ordinal (left-to-right) position
of the result column. This feature makes it possible to define an ordering
on the basis of a column that does not have a proper name.
This is never absolutely necessary because it is always possible
to assign a name to a result column using the AS clause, e.g.:
.sp
.nf
SELECT title, date_prod + 1 AS newlen FROM films ORDER BY newlen;
    
.sp
.fi
.PP
It is also possible to ORDER BY
arbitrary expressions (an extension to SQL92),
including fields that do not appear in the
SELECT result list.
Thus the following statement is legal:
.sp
.nf
SELECT name FROM distributors ORDER BY code;
    
.sp
.fi
A limitation of this feature is that an ORDER BY clause applying to the
result of a UNION, INTERSECT, or EXCEPT query may only specify an output
column name or number, not an expression.
.PP
Note that if an ORDER BY item is a simple name that matches both
a result column name and an input column name, ORDER BY will interpret
it as the result column name. This is the opposite of the choice that
GROUP BY will make in the same situation. This inconsistency is
mandated by the SQL92 standard.
.PP
Optionally one may add the keyword DESC (descending)
or ASC (ascending) after each column name in the ORDER BY clause.
If not specified, ASC is assumed by default. Alternatively, a
specific ordering operator name may be specified. ASC is equivalent
to USING < and DESC is equivalent to USING >.
.PP
The null value sorts higher than any other value in a domain. In other
words, with ascending sort order nulls sort at the end and with
descending sort order nulls sort at the beginning.
.SS "UNION CLAUSE"
.PP
.sp
.nf
\fItable_query\fR UNION [ ALL ] \fItable_query\fR
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    
.sp
.fi
where
\fItable_query\fR
specifies any select expression without an ORDER BY, FOR UPDATE,
or LIMIT clause. (ORDER BY and LIMIT can be attached to a sub-expression
if it is enclosed in parentheses. Without parentheses, these clauses
will be taken to apply to the result of the UNION, not to its right-hand
input expression.)
.PP
The UNION operator computes the collection (set union) of the rows
returned by the queries involved.
The two SELECTs that represent the direct operands of the UNION must
produce the same number of columns, and corresponding columns must be
of compatible data types.
.PP
The result of UNION does not contain any duplicate rows
unless the ALL option is specified. ALL prevents elimination of
duplicates.
.PP
Multiple UNION operators in the same SELECT statement are
evaluated left to right, unless otherwise indicated by parentheses.
.PP
Currently, FOR UPDATE may not be specified either for a UNION result
or for the inputs of a UNION.
.SS "INTERSECT CLAUSE"
.PP
.sp
.nf
\fItable_query\fR INTERSECT [ ALL ] \fItable_query\fR
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    
.sp
.fi
where
\fItable_query\fR
specifies any select expression without an ORDER BY, FOR UPDATE,
or LIMIT clause.
.PP
INTERSECT is similar to UNION, except that it produces only rows that
appear in both query outputs, rather than rows that appear in either.
.PP
The result of INTERSECT does not contain any duplicate rows
unless the ALL option is specified. With ALL, a row that has
m duplicates in L and n duplicates in R will appear min(m,n) times.
.PP
Multiple INTERSECT operators in the same SELECT statement are
evaluated left to right, unless parentheses dictate otherwise.
INTERSECT binds more tightly than UNION --- that is,
A UNION B INTERSECT C will be read as 
A UNION (B INTERSECT C) unless otherwise specified by parentheses.
.SS "EXCEPT CLAUSE"
.PP
.sp
.nf
\fItable_query\fR EXCEPT [ ALL ] \fItable_query\fR
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    
.sp
.fi
where
\fItable_query\fR
specifies any select expression without an ORDER BY, FOR UPDATE,
or LIMIT clause.
.PP
EXCEPT is similar to UNION, except that it produces only rows that
appear in the left query's output but not in the right query's output.
.PP
The result of EXCEPT does not contain any duplicate rows
unless the ALL option is specified. With ALL, a row that has
m duplicates in L and n duplicates in R will appear max(m-n,0) times.
.PP
Multiple EXCEPT operators in the same SELECT statement are
evaluated left to right, unless parentheses dictate otherwise.
EXCEPT binds at the same level as UNION.
.SS "LIMIT CLAUSE"
.PP
.sp
.nf
    LIMIT { \fIcount\fR | ALL }
    OFFSET \fIstart\fR
    
.sp
.fi
where
\fIcount\fR specifies the
maximum number of rows to return, and
\fIstart\fR specifies the
number of rows to skip before starting to return rows.
.PP
LIMIT allows you to retrieve just a portion of the rows that are generated
by the rest of the query. If a limit count is given, no more than that
many rows will be returned. If an offset is given, that many rows will
be skipped before starting to return rows.
.PP
When using LIMIT, it is a good idea to use an ORDER BY clause that
constrains the result rows into a unique order. Otherwise you will get
an unpredictable subset of the query's rows---you may be asking for
the tenth through twentieth rows, but tenth through twentieth in what
ordering? You don't know what ordering unless you specify ORDER BY.
.PP
As of PostgreSQL 7.0, the
query optimizer takes LIMIT into account when generating a query plan,
so you are very likely to get different plans (yielding different row
orders) depending on what you use for LIMIT and OFFSET. Thus, using
different LIMIT/OFFSET values to select different subsets of a query
result \fBwill give inconsistent results\fR unless
you enforce a predictable result ordering with ORDER BY. This is not
a bug; it is an inherent consequence of the fact that SQL does not
promise to deliver the results of a query in any particular order
unless ORDER BY is used to constrain the order.
.SH "USAGE"
.PP
To join the table films with the table
distributors:
.sp
.nf
SELECT f.title, f.did, d.name, f.date_prod, f.kind
    FROM distributors d, films f
    WHERE f.did = d.did

           title           | did |   name           | date_prod  | kind
---------------------------+-----+------------------+------------+----------
 The Third Man             | 101 | British Lion     | 1949-12-23 | Drama
 The African Queen         | 101 | British Lion     | 1951-08-11 | Romantic
 Une Femme est une Femme   | 102 | Jean Luc Godard  | 1961-03-12 | Romantic
 Vertigo                   | 103 | Paramount        | 1958-11-14 | Action
 Becket                    | 103 | Paramount        | 1964-02-03 | Drama
 48 Hrs                    | 103 | Paramount        | 1982-10-22 | Action
 War and Peace             | 104 | Mosfilm          | 1967-02-12 | Drama
 West Side Story           | 105 | United Artists   | 1961-01-03 | Musical
 Bananas                   | 105 | United Artists   | 1971-07-13 | Comedy
 Yojimbo                   | 106 | Toho             | 1961-06-16 | Drama
 There's a Girl in my Soup | 107 | Columbia         | 1970-06-11 | Comedy
 Taxi Driver               | 107 | Columbia         | 1975-05-15 | Action
 Absence of Malice         | 107 | Columbia         | 1981-11-15 | Action
 Storia di una donna       | 108 | Westward         | 1970-08-15 | Romantic
 The King and I            | 109 | 20th Century Fox | 1956-08-11 | Musical
 Das Boot                  | 110 | Bavaria Atelier  | 1981-11-11 | Drama
 Bed Knobs and Broomsticks | 111 | Walt Disney      |            | Musical
(17 rows)
.sp
.fi
.PP
To sum the column len of all films and group
the results by kind:
.sp
.nf
SELECT kind, SUM(len) AS total FROM films GROUP BY kind;

   kind   | total
----------+-------
 Action   | 07:34
 Comedy   | 02:58
 Drama    | 14:28
 Musical  | 06:42
 Romantic | 04:38
(5 rows)
.sp
.fi
.PP
To sum the column len of all films, group
the results by kind and show those group totals
that are less than 5 hours:
.sp
.nf
SELECT kind, SUM(len) AS total
    FROM films
    GROUP BY kind
    HAVING SUM(len) < INTERVAL '5 hour';

 kind     | total
----------+-------
 Comedy   | 02:58
 Romantic | 04:38
(2 rows)
.sp
.fi
.PP
The following two examples are identical ways of sorting the individual
results according to the contents of the second column
(name):
.sp
.nf
SELECT * FROM distributors ORDER BY name;
SELECT * FROM distributors ORDER BY 2;

 did |       name
-----+------------------
 109 | 20th Century Fox
 110 | Bavaria Atelier
 101 | British Lion
 107 | Columbia
 102 | Jean Luc Godard
 113 | Luso films
 104 | Mosfilm
 103 | Paramount
 106 | Toho
 105 | United Artists
 111 | Walt Disney
 112 | Warner Bros.
 108 | Westward
(13 rows)
.sp
.fi
.PP
This example shows how to obtain the union of the tables
distributors and
actors, restricting the results to those that begin
with letter W in each table. Only distinct rows are wanted, so the
ALL keyword is omitted:
.sp
.nf
distributors:               actors:
 did |     name              id |     name
-----+--------------        ----+----------------
 108 | Westward               1 | Woody Allen
 111 | Walt Disney            2 | Warren Beatty
 112 | Warner Bros.           3 | Walter Matthau
 ...                         ...

SELECT distributors.name
    FROM   distributors
    WHERE  distributors.name LIKE 'W%'
UNION
SELECT actors.name
    FROM   actors
    WHERE  actors.name LIKE 'W%';

      name
----------------
 Walt Disney
 Walter Matthau
 Warner Bros.
 Warren Beatty
 Westward
 Woody Allen
.sp
.fi
.SH "COMPATIBILITY"
.SS "EXTENSIONS"
.PP
PostgreSQL allows one to omit 
the \fBFROM\fR clause from a query. This feature
was retained from the original PostQuel query language. It has
a straightforward use to compute the results of simple constant
expressions:
.sp
.nf
SELECT 2+2;

 ?column?
----------
        4
  
.sp
.fi
Some other DBMSes cannot do this except by introducing a dummy one-row
table to do the select from. A less obvious use is to abbreviate a
normal select from one or more tables:
.sp
.nf
SELECT distributors.* WHERE distributors.name = 'Westward';

 did | name
-----+----------
 108 | Westward
  
.sp
.fi
This works because an implicit FROM item is added for each table that is
referenced in the query but not mentioned in FROM. While this is a convenient
shorthand, it's easy to misuse. For example, the query
.sp
.nf
SELECT distributors.* FROM distributors d;
  
.sp
.fi
is probably a mistake; most likely the user meant
.sp
.nf
SELECT d.* FROM distributors d;
  
.sp
.fi
rather than the unconstrained join
.sp
.nf
SELECT distributors.* FROM distributors d, distributors distributors;
  
.sp
.fi
that he will actually get. To help detect this sort of mistake,
PostgreSQL 7.1
and later will warn if the implicit-FROM feature is used in a query that also
contains an explicit FROM clause.
.SS "SQL92"
.PP
.SS "SELECT CLAUSE"
.PP
In the SQL92 standard, the optional keyword AS
is just noise and can be 
omitted without affecting the meaning.
The PostgreSQL parser requires this keyword when
renaming output columns because the type extensibility features lead to
parsing ambiguities
in this context. AS is optional in FROM items, however.
.PP
The DISTINCT ON phrase is not part of SQL92.
Nor are LIMIT and OFFSET.
.PP
In SQL92, an ORDER BY clause may only use result
column names or numbers, while a GROUP BY clause may only use input
column names.
PostgreSQL extends each of these clauses to
allow the other choice as well (but it uses the standard's interpretation
if there is ambiguity).
PostgreSQL also allows both clauses to specify
arbitrary expressions. Note that names appearing in an expression will
always be taken as input-column names, not as result-column names.
.SS "UNION/INTERSECT/EXCEPT CLAUSE"
.PP
The SQL92 syntax for UNION/INTERSECT/EXCEPT allows an
additional CORRESPONDING BY option:
.sp
.nf
 
\fItable_query\fR UNION [ALL]
    [CORRESPONDING [BY (\fIcolumn\fR [,...])]]
    \fItable_query\fR
     
.sp
.fi
.PP
The CORRESPONDING BY clause is not supported by
PostgreSQL.
