.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "UPDATE" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
UPDATE \- update rows of a table
.SH SYNOPSIS
.sp
.nf
UPDATE [ ONLY ] \fItable\fR SET \fIcol\fR = \fIexpression\fR [, ...]
    [ FROM \fIfromlist\fR ]
    [ WHERE \fIcondition\fR ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable\fB\fR
The name of an existing table.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
.TP
\fB\fIexpression\fB\fR
A valid expression or value to assign to column.
.TP
\fB\fIfromlist\fB\fR
A PostgreSQL
non-standard extension to allow columns
from other tables to appear in the WHERE condition.
.TP
\fB\fIcondition\fB\fR
Refer to the SELECT statement for a further description
of the WHERE clause.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBUPDATE \fI#\fB\fR
Message returned if successful.
The \fI#\fR
means the number of rows updated.
If \fI#\fR
is 0 no rows are updated.
.PP
.SH "DESCRIPTION"
.PP
\fBUPDATE\fR changes the values of the columns specified for
all rows which satisfy condition. Only the columns 
to be modified need appear as columns in the statement.
.PP
Array references use the same syntax found in
SELECT [\fBselect\fR(l)].
That is, either single array elements, a range of array
elements or the entire array may be replaced with a single
query.
.PP
You must have write access to the table in order to modify
it, as well as read access to any table whose values are
mentioned in the WHERE condition.
.PP
By default UPDATE will update tuples in the table specified 
and all its sub-tables. If you wish to only update the
specific table mentioned, you should use the ONLY clause.
.SH "USAGE"
.PP
Change word Drama with Dramatic on column \fBkind\fR:
.sp
.nf
UPDATE films 
SET kind = 'Dramatic' 
WHERE kind = 'Drama';
SELECT * 
FROM films 
WHERE kind = 'Dramatic' OR kind = 'Drama';

 code  |     title     | did | date_prod  |   kind   | len
-------+---------------+-----+------------+----------+-------
 BL101 | The Third Man | 101 | 1949-12-23 | Dramatic | 01:44
 P_302 | Becket        | 103 | 1964-02-03 | Dramatic | 02:28
 M_401 | War and Peace | 104 | 1967-02-12 | Dramatic | 05:57
 T_601 | Yojimbo       | 106 | 1961-06-16 | Dramatic | 01:50
 DA101 | Das Boot      | 110 | 1981-11-11 | Dramatic | 02:29
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 defines a different syntax for
the positioned UPDATE statement:
.sp
.nf
UPDATE \fItable\fR SET \fIcolumn\fR = \fIexpression\fR [, ...]
    WHERE CURRENT OF \fIcursor\fR
    
.sp
.fi
where \fIcursor\fR
identifies an open cursor.
