.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE LANGUAGE" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE LANGUAGE \- define a new procedural language
.SH SYNOPSIS
.sp
.nf
CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE \fIlangname\fR
    HANDLER \fIcall_handler\fR [ VALIDATOR \fIvalfunction\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
Using \fBCREATE LANGUAGE\fR, a
PostgreSQL user can register a new
procedural language with a PostgreSQL
database. Subsequently, functions and trigger procedures can be
defined in this new language. The user must have the
PostgreSQL superuser privilege to
register a new language.
.PP
\fBCREATE LANGUAGE\fR effectively associates the
language name with a call handler that is responsible for executing
functions written in the language. Refer to the
\fIProgrammer's Guide\fR for more information
about language call handlers.
.PP
Note that procedural languages are local to individual databases.
To make a language available in all databases by default, it should
be installed into the template1 database.
.SH "PARAMETERS"
.TP
\fBTRUSTED\fR
TRUSTED specifies that the call handler for
the language is safe, that is, it does not offer an
unprivileged user any functionality to bypass access
restrictions. If this keyword is omitted when registering the
language, only users with the
PostgreSQL superuser privilege can
use this language to create new functions.
.TP
\fBPROCEDURAL\fR
This is a noise word.
.TP
\fB\fIlangname\fB\fR
The name of the new procedural language. The language name is
case insensitive. A procedural language cannot override one of
the built-in languages of PostgreSQL.

For backward compatibility, the name may be enclosed by single
quotes.
.TP
\fBHANDLER \fIcall_handler\fB\fR
\fIcall_handler\fR is
the name of a previously registered function that will be
called to execute the procedural language functions. The call
handler for a procedural language must be written in a compiled
language such as C with version 1 call convention and
registered with PostgreSQL as a
function taking no arguments and returning the
\fBlanguage_handler\fR type, a placeholder type that is
simply used to identify the function as a call handler.
.TP
\fBVALIDATOR \fIvalfunction\fB\fR
\fIvalfunction\fR is the
name of a previously registered function that will be called
when a new function in the language is created, to validate the
new function.
If no
validator function is specified, then a new function will not
be checked when it is created.
The validator function must take one argument of
type \fBoid\fR, which will be the OID of the
to-be-created function, and will typically return \fBvoid\fR.

A validator function would typically inspect the function body
for syntactical correctness, but it can also look at other
properties of the function, for example if the language cannot
handle certain argument types. To signal an error, the
validator function should use the \fBelog()\fR
function. The return value of the function is ignored.
.SH "DIAGNOSTICS"
.sp
.nf
CREATE LANGUAGE
.sp
.fi
.PP
This message is returned if the language is successfully
created.
.sp
.nf
ERROR:  PL handler function \fIfuncname\fR() doesn't exist
.sp
.fi
.PP
This error is returned if the function \fIfuncname\fR() is not found.
.SH "NOTES"
.PP
This command normally should not be executed directly by users.
For the procedural languages supplied in the
PostgreSQL distribution, the \fBcreatelang\fR(1) script should be used, which will also
install the correct call handler. (\fBcreatelang\fR
will call \fBCREATE LANGUAGE\fR internally.)
.PP
In PostgreSQL versions before 7.3, it was
necessary to declare handler functions as returning the placeholder
type \fBopaque\fR, rather than \fBlanguage_handler\fR.
To support loading 
of old dump files, \fBCREATE LANGUAGE\fR will accept a function
declared as returning \fBopaque\fR, but it will issue a NOTICE and
change the function's declared return type to \fBlanguage_handler\fR.
.PP
Use the CREATE FUNCTION [\fBcreate_function\fR(l)] command to create a new
function.
.PP
Use DROP LANGUAGE [\fBdrop_language\fR(l)], or better yet the \fBdroplang\fR(1) script, to drop procedural languages.
.PP
The system catalog \fBpg_language\fR records
information about the currently installed procedural languages.
.sp
.nf
        Table "pg_language"
   Attribute   |   Type    | Modifier
---------------+-----------+----------
 lanname       | name      |
 lanispl       | boolean   |
 lanpltrusted  | boolean   |
 lanplcallfoid | oid       |
 lanvalidator  | oid       |
 lanacl        | aclitem[] |

   lanname   | lanispl | lanpltrusted | lanplcallfoid | lanvalidator | lanacl
-------------+---------+--------------+---------------+--------------+--------
 internal    | f       | f            |             0 |         2246 |
 c           | f       | f            |             0 |         2247 |
 sql         | f       | t            |             0 |         2248 | {=U}
.sp
.fi
.PP
At present, with the exception of the permissions, the definition 
of a procedural language cannot be changed once it has been created.
.PP
To be able to use a procedural language, a user must be granted the
USAGE privilege. The
\fBcreatelang\fR program automatically grants
permissions to everyone if the language is known to be trusted.
.SH "EXAMPLES"
.PP
The following two commands executed in sequence will register a new
procedural language and the associated call handler.
.sp
.nf
CREATE FUNCTION plsample_call_handler () RETURNS language_handler
    AS '$libdir/plsample'
    LANGUAGE C;
CREATE LANGUAGE plsample
    HANDLER plsample_call_handler;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE LANGUAGE\fR is a
PostgreSQL extension.
.SH "HISTORY"
.PP
The \fBCREATE LANGUAGE\fR command first appeared in
PostgreSQL 6.3.
.SH "SEE ALSO"
.PP
\fBcreatelang\fR(1), \fBcreate_function\fR(l), \fBdroplang\fR(1), \fBdrop_language\fR(l), \fBgrant\fR(l), \fBrevoke\fR(l), \fIPostgreSQL Programmer's Guide\fR

