.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER DOMAIN" "" "2007-09-16" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DOMAIN \- change the definition of a domain

.SH SYNOPSIS
.sp
.nf
ALTER DOMAIN \fIname\fR
    { SET DEFAULT \fIexpression\fR | DROP DEFAULT }
ALTER DOMAIN \fIname\fR
    { SET | DROP } NOT NULL
ALTER DOMAIN \fIname\fR
    ADD \fIdomain_constraint\fR
ALTER DOMAIN \fIname\fR
    DROP CONSTRAINT \fIconstraint_name\fR [ RESTRICT | CASCADE ]
ALTER DOMAIN \fIname\fR
    OWNER TO \fInew_owner\fR 
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DOMAIN\fR changes the definition of an existing domain.
There are several sub-forms:
.TP
\fBSET/DROP DEFAULT\fR
These forms set or remove the default value for a domain. Note
that defaults only apply to subsequent \fBINSERT\fR
commands; they do not affect rows already in a table using the domain.
.TP
\fBSET/DROP NOT NULL\fR
These forms change whether a domain is marked to allow NULL
values or to reject NULL values. You may only SET NOT NULL
when the columns using the domain contain no null values.
.TP
\fBADD \fIdomain_constraint\fB\fR
This form adds a new constraint to a domain using the same syntax as
CREATE DOMAIN [\fBcreate_domain\fR(l)].
This will only succeed if all columns using the domain satisfy the
new constraint.
.TP
\fBDROP CONSTRAINT\fR
This form drops constraints on a domain.
.TP
\fBOWNER\fR
This form changes the owner of the domain to the specified user.
.PP
You must own the domain to use \fBALTER DOMAIN\fR; except for
\fBALTER DOMAIN OWNER\fR, which may only be executed by a superuser.
.PP
.SH "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing domain to
alter.
.TP
\fB\fIdomain_constraint\fB\fR
New domain constraint for the domain.
.TP
\fB\fIconstraint_name\fB\fR
Name of an existing constraint to drop.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the constraint.
.TP
\fBRESTRICT\fR
Refuse to drop the constraint if there are any dependent
objects. This is the default behavior.
.TP
\fB\fInew_owner\fB\fR
The user name of the new owner of the domain.
.PP
.SH "EXAMPLES"
.PP
To add a NOT NULL constraint to a domain:
.sp
.nf
ALTER DOMAIN zipcode SET NOT NULL;
   
.sp
.fi
To remove a NOT NULL constraint from a domain:
.sp
.nf
ALTER DOMAIN zipcode DROP NOT NULL;
   
.sp
.fi
.PP
To add a check constraint to a domain:
.sp
.nf
ALTER DOMAIN zipcode ADD CONSTRAINT zipchk CHECK (char_length(VALUE) = 5);
   
.sp
.fi
.PP
To remove a check constraint from a domain:
.sp
.nf
ALTER DOMAIN zipcode DROP CONSTRAINT zipchk;
   
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER DOMAIN\fR statement is compatible with SQL99,
except for the OWNER variant, which is a
PostgreSQL extension.
