.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE DATABASE" "" "2009-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE DATABASE \- create a new database

.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR
    [ [ WITH ] [ OWNER [=] \fIdbowner\fR ]
           [ LOCATION [=] '\fIdbpath\fR' ]
           [ TEMPLATE [=] \fItemplate\fR ]
           [ ENCODING [=] \fIencoding\fR ] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new
PostgreSQL database.
.PP
To create a database, you must be a superuser or have the special
CREATEDB privilege.
See CREATE USER [\fBcreate_user\fR(l)].
.PP
Normally, the creator becomes the owner of the new database.
Superusers can create databases owned by other users using the
OWNER clause. They can even create databases owned by
users with no special privileges. Non-superusers with CREATEDB
privilege can only create databases owned by themselves.
.PP
An alternative location can be specified in order to,
for example, store the database on a different disk.
The path must have been prepared with the 
initlocation [\fBinitlocation\fR(1)]
command.
.PP
If the path name does not contain a slash, it is interpreted
as an environment variable name, which must be known to the
server process. This way the database administrator can
exercise control over locations in which databases can be created.
(A customary choice is, e.g., \fBPGDATA2\fR.)
If the server is compiled with ALLOW_ABSOLUTE_DBPATHS
(not so by default), absolute path names, as identified by
a leading slash
(e.g., \fI/usr/local/pgsql/data\fR),
are allowed as well.
In either case, the final path name must be absolute and must not
contain any single quotes.
.PP
By default, the new database will be created by cloning the standard
system database template1. A different template can be
specified by writing TEMPLATE
\fIname\fR. In particular,
by writing TEMPLATE template0, you can create a virgin
database containing only the standard objects predefined by your
version of PostgreSQL. This is useful
if you wish to avoid copying
any installation-local objects that may have been added to
template1. 
.PP
The optional encoding parameter allows selection of the database
encoding. When not specified, it defaults to the encoding used by
the selected template database.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbowner\fB\fR
The name of the database user who will own the new database,
or DEFAULT to use the default (namely, the
user executing the command).
.TP
\fB\fIdbpath\fB\fR
An alternate file-system location in which to store the new database,
specified as a string literal;
or DEFAULT to use the default location.
.TP
\fB\fItemplate\fB\fR
The name of the template from which to create the new database,
or DEFAULT to use the default template
(template1).
.TP
\fB\fIencoding\fB\fR
Character set encoding to use in the new database. Specify
a string constant (e.g., 'SQL_ASCII'),
or an integer encoding number, or DEFAULT
to use the default encoding.
.PP
Optional parameters can be written in any order, not only the order
illustrated above.
.PP
.SH "NOTES"
.PP
\fBCREATE DATABASE\fR cannot be executed inside a transaction
block.
.PP
Errors along the line of ``could not initialize database directory''
are most likely related to insufficient permissions on the data
directory, a full disk, or other file system problems. When using an
alternate location, the user under
which the database server is running must have access to the location.
.PP
Use DROP DATABASE [\fBdrop_database\fR(l)] to remove a database.
.PP
The program createdb [\fBcreatedb\fR(1)] is a
wrapper program around this command, provided for convenience.
.PP
There are security issues involved with using alternate database
locations specified with absolute path names; this is why the feature
is not enabled by default. See [XRef to MANAGE-AG-ALTERNATE-LOCS] for more information.
.PP
Although it is possible to copy a database other than template1
by specifying its name as the template, this is not (yet) intended as
a general-purpose ``\fBCOPY DATABASE\fR'' facility.
We recommend that databases used as templates be treated as read-only.
See [XRef to MANAGE-AG-TEMPLATEDBS] for more information.
.SH "EXAMPLES"
.PP
To create a new database:
.sp
.nf
CREATE DATABASE lusiadas;
.sp
.fi
.PP
To create a new database in an alternate area
\fI~/private_db\fR, execute the following from the
shell:
.sp
.nf
mkdir private_db
initlocation ~/private_db
.sp
.fi
Then execute the following from within a
\fBpsql\fR session:
.sp
.nf
CREATE DATABASE elsewhere WITH LOCATION '/home/olly/private_db';
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBCREATE DATABASE\fR statement in the SQL
standard. Databases are equivalent to catalogs, whose creation is
implementation-defined.
