.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TABLE AS" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE AS \- define a new table from the results of a query

.SH SYNOPSIS
.sp
.nf
CREATE [ [ GLOBAL | LOCAL ] { TEMPORARY | TEMP } ] TABLE \fItable_name\fR [ (\fIcolumn_name\fR [, ...] ) ] [ [ WITH | WITHOUT ] OIDS ]
    AS \fIquery\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE AS\fR creates a table and fills it
with data computed by a \fBSELECT\fR command or an
\fBEXECUTE\fR that runs a prepared
\fBSELECT\fR command. The table columns have the
names and data types associated with the output columns of the
\fBSELECT\fR (except that you can override the column
names by giving an explicit list of new column names).
.PP
\fBCREATE TABLE AS\fR bears some resemblance to
creating a view, but it is really quite different: it creates a new
table and evaluates the query just once to fill the new table
initially. The new table will not track subsequent changes to the
source tables of the query. In contrast, a view re-evaluates its
defining \fBSELECT\fR statement whenever it is
queried.
.SH "PARAMETERS"
.TP
\fBGLOBAL or LOCAL\fR
Ignored for compatibility. Refer to CREATE TABLE [\fBcreate_table\fR(l)] for
details.
.PP
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table.
Refer to CREATE TABLE [\fBcreate_table\fR(l)] for details.
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of the table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column in the new table. If column names are not
provided, they are taken from the output column names of the
query. If the table is created from an
\fBEXECUTE\fR command, a column name list cannot be
specified.
.TP
\fBWITH OIDS\fR
.TP
\fBWITHOUT OIDS\fR
This optional clause specifies whether the table created by
\fBCREATE TABLE AS\fR should include OIDs. If
neither form of this clause is specified, the value of the
default_with_oids configuration parameter is
used.
.TP
\fB\fIquery\fB\fR
A query statement (that is, a \fBSELECT\fR command
or an \fBEXECUTE\fR command that runs a prepared
\fBSELECT\fR command). Refer to SELECT [\fBselect\fR(l)] or EXECUTE [\fBexecute\fR(l)],
respectively, for a description of the allowed syntax.
.SH "NOTES"
.PP
This command is functionally similar to SELECT INTO [\fBselect_into\fR(l)], but it is
preferred since it is less likely to be confused with other uses of
the \fBSELECT INTO\fR syntax. Furthermore, \fBCREATE
TABLE AS\fR offers a superset of the functionality offered
by \fBSELECT INTO\fR.
.PP
Prior to PostgreSQL 8.0, \fBCREATE
TABLE AS\fR always included OIDs in the table it
produced. As of PostgresSQL 8.0,
the \fBCREATE TABLE AS\fR command allows the user to
explicitly specify whether OIDs should be included. If the
presence of OIDs is not explicitly specified,
the default_with_oids configuration variable is
used. While this variable currently defaults to true, the default
value may be changed in the future. Therefore, applications that
require OIDs in the table created by \fBCREATE TABLE
AS\fR should explicitly specify WITH
OIDS to ensure compatibility with future versions
of PostgreSQL.
.SH "EXAMPLES"
.PP
Create a new table films_recent consisting of only
recent entries from the table films:
.sp
.nf
CREATE TABLE films_recent AS
  SELECT * FROM films WHERE date_prod >= '2002-01-01';
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE TABLE AS\fR is specified by the SQL:2003
standard. There are some small differences between the definition
of the command in SQL:2003 and its implementation in
PostgreSQL:
.TP 0.2i
\(bu
The standard requires parentheses around the subquery clause; in
PostgreSQL, these parentheses are
optional.
.TP 0.2i
\(bu
The standard defines an ON COMMIT clause;
this is not currently implemented by PostgreSQL.
.TP 0.2i
\(bu
The standard defines a WITH DATA clause;
this is not currently implemented by PostgreSQL.
.PP
.SH "SEE ALSO"
CREATE TABLE [\fBcreate_table\fR(l)], EXECUTE [\fBexecute\fR(l)], SELECT [\fBselect\fR(l)], SELECT INTO [\fBselect_into\fR(l)]
