.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE LANGUAGE" "" "2010-12-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE LANGUAGE \- define a new procedural language

.SH SYNOPSIS
.sp
.nf
CREATE [ PROCEDURAL ] LANGUAGE \fIname\fR
CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE \fIname\fR
    HANDLER \fIcall_handler\fR [ VALIDATOR \fIvalfunction\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
Using \fBCREATE LANGUAGE\fR, a
PostgreSQL user can register a new
procedural language with a PostgreSQL
database. Subsequently, functions and trigger procedures can be
defined in this new language. The user must have the
PostgreSQL superuser privilege to
register a new language.
.PP
\fBCREATE LANGUAGE\fR effectively associates the
language name with a call handler that is responsible for executing
functions written in the language. Refer to the documentation
for more information about language call handlers.
.PP
There are two forms of the \fBCREATE LANGUAGE\fR command.
In the first form, the user supplies just the name of the desired
language, and the PostgreSQL server consults
the \fBpg_pltemplate\fR
system catalog to determine the correct parameters. In the second form,
the user supplies the language parameters along with the language name.
The second form can be used to create a language that is not defined in
\fBpg_pltemplate\fR, but this approach is considered obsolescent.
.PP
When the server finds an entry in the \fBpg_pltemplate\fR catalog
for the given language name, it will use the catalog data even if the
command includes language parameters. This behavior simplifies loading of
old dump files, which are likely to contain out-of-date information
about language support functions.
.SH "PARAMETERS"
.TP
\fBTRUSTED\fR
TRUSTED specifies that the call handler for
the language is safe, that is, it does not offer an
unprivileged user any functionality to bypass access
restrictions. If this key word is omitted when registering the
language, only users with the
PostgreSQL superuser privilege can
use this language to create new functions.
.TP
\fBPROCEDURAL\fR
This is a noise word.
.TP
\fB\fIname\fB\fR
The name of the new procedural language. The language name is
case insensitive. The name must be unique among the languages
in the database.

For backward compatibility, the name may be enclosed by single
quotes.
.TP
\fBHANDLER \fIcall_handler\fB\fR
\fIcall_handler\fR is
the name of a previously registered function that will be
called to execute the procedural language functions. The call
handler for a procedural language must be written in a compiled
language such as C with version 1 call convention and
registered with PostgreSQL as a
function taking no arguments and returning the
\fBlanguage_handler\fR type, a placeholder type that is
simply used to identify the function as a call handler.
.TP
\fBVALIDATOR \fIvalfunction\fB\fR
\fIvalfunction\fR is the
name of a previously registered function that will be called
when a new function in the language is created, to validate the
new function.
If no
validator function is specified, then a new function will not
be checked when it is created.
The validator function must take one argument of
type \fBoid\fR, which will be the OID of the
to-be-created function, and will typically return \fBvoid\fR.

A validator function would typically inspect the function body
for syntactical correctness, but it can also look at other
properties of the function, for example if the language cannot
handle certain argument types. To signal an error, the
validator function should use the \fBereport()\fR
function. The return value of the function is ignored.
.PP
The TRUSTED option and the support function name(s) are
ignored if the server has an entry for the specified language
name in \fBpg_pltemplate\fR.
.PP
.SH "NOTES"
.PP
The \fBcreatelang\fR(1) program is a simple wrapper around
the \fBCREATE LANGUAGE\fR command. It eases
installation of procedural languages from the shell command line.
.PP
Use DROP LANGUAGE [\fBdrop_language\fR(l)], or better yet the \fBdroplang\fR(1) program, to drop procedural languages.
.PP
The system catalog \fBpg_language\fR (see the documentation) records information about the
currently installed languages. Also, \fBcreatelang\fR
has an option to list the installed languages.
.PP
To create functions in a procedural language, a user must have the
USAGE privilege for the language. By default,
USAGE is granted to PUBLIC (i.e., everyone)
for trusted languages. This may be revoked if desired.
.PP
Procedural languages are local to individual databases.
However, a language can be installed into the template1
database, which will cause it to be available automatically in
all subsequently-created databases.
.PP
The call handler function and the validator function (if any)
must already exist if the server does not have an entry for the language
in \fBpg_pltemplate\fR. But when there is an entry,
the functions need not already exist;
they will be automatically defined if not present in the database.
(This can result in \fBCREATE LANGUAGE\fR failing, if the
shared library that implements the language is not available in
the installation.)
.PP
In PostgreSQL versions before 7.3, it was
necessary to declare handler functions as returning the placeholder
type \fBopaque\fR, rather than \fBlanguage_handler\fR.
To support loading 
of old dump files, \fBCREATE LANGUAGE\fR will accept a function
declared as returning \fBopaque\fR, but it will issue a notice and
change the function's declared return type to \fBlanguage_handler\fR.
.SH "EXAMPLES"
.PP
The preferred way of creating any of the standard procedural languages
is just:
.sp
.nf
CREATE LANGUAGE plpgsql;
.sp
.fi
.PP
For a language not known in the \fBpg_pltemplate\fR catalog, a
sequence such as this is needed:
.sp
.nf
CREATE FUNCTION plsample_call_handler() RETURNS language_handler
    AS '$libdir/plsample'
    LANGUAGE C;
CREATE LANGUAGE plsample
    HANDLER plsample_call_handler;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE LANGUAGE\fR is a
PostgreSQL extension.
.SH "SEE ALSO"
ALTER LANGUAGE [\fBalter_language\fR(l)], CREATE FUNCTION [\fBcreate_function\fR(l)], DROP LANGUAGE [\fBdrop_language\fR(l)], GRANT [\fBgrant\fR(l)], REVOKE [\fBrevoke\fR(l)], createlang [\fBcreatelang\fR(1)], droplang [\fBdroplang\fR(1)]
