.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER TABLE" "" "2007-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TABLE \- change the definition of a table

.SH SYNOPSIS
.sp
.nf
ALTER TABLE [ ONLY ] \fIname\fR [ * ]
    \fIaction\fR [, ... ]
ALTER TABLE [ ONLY ] \fIname\fR [ * ]
    RENAME [ COLUMN ] \fIcolumn\fR TO \fInew_column\fR
ALTER TABLE \fIname\fR
    RENAME TO \fInew_name\fR
ALTER TABLE \fIname\fR
    SET SCHEMA \fInew_schema\fR

where \fIaction\fR is one of:

    ADD [ COLUMN ] \fIcolumn\fR \fItype\fR [ \fIcolumn_constraint\fR [ ... ] ]
    DROP [ COLUMN ] \fIcolumn\fR [ RESTRICT | CASCADE ]
    ALTER [ COLUMN ] \fIcolumn\fR TYPE \fItype\fR [ USING \fIexpression\fR ]
    ALTER [ COLUMN ] \fIcolumn\fR SET DEFAULT \fIexpression\fR
    ALTER [ COLUMN ] \fIcolumn\fR DROP DEFAULT
    ALTER [ COLUMN ] \fIcolumn\fR { SET | DROP } NOT NULL
    ALTER [ COLUMN ] \fIcolumn\fR SET STATISTICS \fIinteger\fR
    ALTER [ COLUMN ] \fIcolumn\fR SET STORAGE { PLAIN | EXTERNAL | EXTENDED | MAIN }
    ADD \fItable_constraint\fR
    DROP CONSTRAINT \fIconstraint_name\fR [ RESTRICT | CASCADE ]
    DISABLE TRIGGER [ \fItrigger_name\fR | ALL | USER ]
    ENABLE TRIGGER [ \fItrigger_name\fR | ALL | USER ]
    CLUSTER ON \fIindex_name\fR
    SET WITHOUT CLUSTER
    SET WITHOUT OIDS
    OWNER TO \fInew_owner\fR
    SET TABLESPACE \fInew_tablespace\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER TABLE\fR changes the definition of an existing table.
There are several subforms:
.TP
\fBADD COLUMN\fR
This form adds a new column to the table, using the same syntax as
CREATE TABLE [\fBcreate_table\fR(l)].
.TP
\fBDROP COLUMN\fR
This form drops a column from a table. Indexes and
table constraints involving the column will be automatically
dropped as well. You will need to say CASCADE if
anything outside the table depends on the column, for example,
foreign key references or views.
.TP
\fBALTER COLUMN TYPE\fR
This form changes the type of a column of a table. Indexes and
simple table constraints involving the column will be automatically
converted to use the new column type by reparsing the originally
supplied expression. The optional USING
clause specifies how to compute the new column value from the old;
if omitted, the default conversion is the same as an assignment
cast from old data type to new. A USING
clause must be provided if there is no implicit or assignment
cast from old to new type.
.TP
\fBSET/DROP DEFAULT\fR
These forms set or remove the default value for a column.
The default values only apply to subsequent \fBINSERT\fR
commands; they do not cause rows already in the table to change.
Defaults may also be created for views, in which case they are
inserted into \fBINSERT\fR statements on the view before
the view's ON INSERT rule is applied.
.TP
\fBSET/DROP NOT NULL\fR
These forms change whether a column is marked to allow null
values or to reject null values. You can only use SET
NOT NULL when the column contains no null values.
.TP
\fBSET STATISTICS\fR
This form
sets the per-column statistics-gathering target for subsequent
ANALYZE [\fBanalyze\fR(l)] operations.
The target can be set in the range 0 to 1000; alternatively, set it
to -1 to revert to using the system default statistics
target (default_statistics_target).
For more information on the use of statistics by the
PostgreSQL query planner, refer to
the documentation.

.TP
\fBSET STORAGE\fR
This form sets the storage mode for a column. This controls whether this
column is held inline or in a supplementary table, and whether the data
should be compressed or not. PLAIN must be used
for fixed-length values such as \fBinteger\fR and is
inline, uncompressed. MAIN is for inline,
compressible data. EXTERNAL is for external,
uncompressed data, and EXTENDED is for external,
compressed data. EXTENDED is the default for most
data types that support non-PLAIN storage.
Use of EXTERNAL will
make substring operations on \fBtext\fR and \fBbytea\fR
columns faster, at the penalty of increased storage space. Note that
SET STORAGE doesn't itself change anything in the table,
it just sets the strategy to be pursued during future table updates.
See the documentation for more information.
.TP
\fBADD \fItable_constraint\fB\fR
This form adds a new constraint to a table using the same syntax as
CREATE TABLE [\fBcreate_table\fR(l)]. 
.TP
\fBDROP CONSTRAINT\fR
This form drops the specified constraint on a table.
.TP
\fBDISABLE/ENABLE TRIGGER\fR
These forms disable or enable trigger(s) belonging to the table.
A disabled trigger is still known to the system, but is not executed
when its triggering event occurs. For a deferred trigger, the enable
status is checked when the event occurs, not when the trigger function
is actually executed. One may disable or enable a single
trigger specified by name, or all triggers on the table, or only
user triggers (this option excludes triggers that are used to implement
foreign key constraints). Disabling or enabling constraint triggers
requires superuser privileges; it should be done with caution since
of course the integrity of the constraint cannot be guaranteed if the
triggers are not executed.
.TP
\fBCLUSTER\fR
This form selects the default index for future 
CLUSTER [\fBcluster\fR(l)]
operations. It does not actually re-cluster the table.
.TP
\fBSET WITHOUT CLUSTER\fR
This form removes the most recently used
CLUSTER [\fBcluster\fR(l)]
index specification from the table. This affects
future cluster operations that don't specify an index.
.TP
\fBSET WITHOUT OIDS\fR
This form removes the oid system column from the
table. This is exactly equivalent to
DROP COLUMN oid RESTRICT,
except that it will not complain if there is already no
oid column.

Note that there is no variant of \fBALTER TABLE\fR
that allows OIDs to be restored to a table once they have been
removed.
.TP
\fBOWNER\fR
This form changes the owner of the table, sequence, or view to the
specified user.
.TP
\fBSET TABLESPACE\fR
This form changes the table's tablespace to the specified tablespace and
moves the data file(s) associated with the table to the new tablespace.
Indexes on the table, if any, are not moved; but they can be moved
separately with additional SET TABLESPACE commands.
See also 
CREATE TABLESPACE [\fBcreate_tablespace\fR(l)].
.TP
\fBRENAME\fR
The RENAME forms change the name of a table
(or an index, sequence, or view) or the name of an individual column in
a table. There is no effect on the stored data.
.TP
\fBSET SCHEMA\fR
This form moves the table into another schema. Associated indexes,
constraints, and SERIAL-column sequences are moved as well.
.PP
.PP
All the actions except RENAME and SET SCHEMA
can be combined into
a list of multiple alterations to apply in parallel. For example, it
is possible to add several columns and/or alter the type of several
columns in a single command. This is particularly useful with large
tables, since only one pass over the table need be made.
.PP
You must own the table to use \fBALTER TABLE\fR.
To change the schema of a table, you must also have
CREATE privilege on the new schema.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the table's schema. (These restrictions enforce that altering the owner
doesn't do anything you couldn't do by dropping and recreating the table.
However, a superuser can alter ownership of any table anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing table to
alter. If ONLY is specified, only that table is
altered. If ONLY is not specified, the table and all
its descendant tables (if any) are updated. * can be
appended to the table name to indicate that descendant tables are
to be altered, but in the current version, this is the default
behavior. (In releases before 7.1, ONLY was the
default behavior. The default can be altered by changing the
configuration parameter sql_inheritance.)
.TP
\fB\fIcolumn\fB\fR
Name of a new or existing column.
.TP
\fB\fInew_column\fB\fR
New name for an existing column.
.TP
\fB\fInew_name\fB\fR
New name for the table.
.TP
\fB\fItype\fB\fR
Data type of the new column, or new data type for an existing
column.
.TP
\fB\fItable_constraint\fB\fR
New table constraint for the table.
.TP
\fB\fIconstraint_name\fB\fR
Name of an existing constraint to drop.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the dropped column
or constraint (for example, views referencing the column).
.TP
\fBRESTRICT\fR
Refuse to drop the column or constraint if there are any dependent
objects. This is the default behavior.
.TP
\fB\fItrigger_name\fB\fR
Name of a single trigger to disable or enable.
.TP
\fBALL\fR
Disable or enable all triggers belonging to the table.
(This requires superuser privilege if any of the triggers are for
foreign key constraints.)
.TP
\fBUSER\fR
Disable or enable all triggers belonging to the table except for
foreign key constraint triggers.
.TP
\fB\fIindex_name\fB\fR
The index name on which the table should be marked for clustering.
.TP
\fB\fInew_owner\fB\fR
The user name of the new owner of the table.
.TP
\fB\fInew_tablespace\fB\fR
The name of the tablespace to which the table will be moved.
.TP
\fB\fInew_schema\fB\fR
The name of the schema to which the table will be moved.
.SH "NOTES"
.PP
The key word COLUMN is noise and can be omitted.
.PP
When a column is added with ADD COLUMN, all existing
rows in the table are initialized with the column's default value
(NULL if no DEFAULT clause is specified).
.PP
Adding a column with a non-null default or changing the type of an
existing column will require the entire table to be rewritten. This
may take a significant amount of time for a large table; and it will
temporarily require double the disk space.
.PP
Adding a CHECK or NOT NULL constraint requires
scanning the table to verify that existing rows meet the constraint.
.PP
The main reason for providing the option to specify multiple changes
in a single \fBALTER TABLE\fR is that multiple table scans or
rewrites can thereby be combined into a single pass over the table.
.PP
The DROP COLUMN form does not physically remove
the column, but simply makes it invisible to SQL operations. Subsequent
insert and update operations in the table will store a null value for the
column. Thus, dropping a column is quick but it will not immediately
reduce the on-disk size of your table, as the space occupied 
by the dropped column is not reclaimed. The space will be
reclaimed over time as existing rows are updated.
.PP
The fact that ALTER TYPE requires rewriting the whole table
is sometimes an advantage, because the rewriting process eliminates
any dead space in the table. For example, to reclaim the space occupied
by a dropped column immediately, the fastest way is
.sp
.nf
ALTER TABLE table ALTER COLUMN anycol TYPE anytype;
.sp
.fi
where anycol is any remaining table column and
anytype is the same type that column already has.
This results in no semantically-visible change in the table,
but the command forces rewriting, which gets rid of no-longer-useful
data.
.PP
The USING option of ALTER TYPE can actually
specify any expression involving the old values of the row; that is, it
can refer to other columns as well as the one being converted. This allows
very general conversions to be done with the ALTER TYPE
syntax. Because of this flexibility, the USING
expression is not applied to the column's default value (if any); the
result might not be a constant expression as required for a default.
This means that when there is no implicit or assignment cast from old to
new type, ALTER TYPE may fail to convert the default even
though a USING clause is supplied. In such cases,
drop the default with DROP DEFAULT, perform the ALTER
TYPE, and then use SET DEFAULT to add a suitable new
default. Similar considerations apply to indexes and constraints involving
the column.
.PP
If a table has any descendant tables, it is not permitted to add,
rename, or change the type of a column in the parent table without doing
the same to the descendants. That is, \fBALTER TABLE ONLY\fR
will be rejected. This ensures that the descendants always have
columns matching the parent.
.PP
A recursive DROP COLUMN operation will remove a
descendant table's column only if the descendant does not inherit
that column from any other parents and never had an independent
definition of the column. A nonrecursive DROP
COLUMN (i.e., \fBALTER TABLE ONLY ... DROP
COLUMN\fR) never removes any descendant columns, but
instead marks them as independently defined rather than inherited.
.PP
The TRIGGER, CLUSTER, OWNER,
and TABLESPACE actions never recurse to descendant tables;
that is, they always act as though ONLY were specified.
Adding a constraint can recurse only for CHECK constraints.
.PP
Changing any part of a system catalog table is not permitted.
.PP
Refer to CREATE TABLE [\fBcreate_table\fR(l)] for a further description of valid
parameters. the documentation has further information on
inheritance.
.SH "EXAMPLES"
.PP
To add a column of type \fBvarchar\fR to a table:
.sp
.nf
ALTER TABLE distributors ADD COLUMN address varchar(30);
.sp
.fi
.PP
To drop a column from a table:
.sp
.nf
ALTER TABLE distributors DROP COLUMN address RESTRICT;
.sp
.fi
.PP
To change the types of two existing columns in one operation:
.sp
.nf
ALTER TABLE distributors
    ALTER COLUMN address TYPE varchar(80),
    ALTER COLUMN name TYPE varchar(100);
.sp
.fi
.PP
To change an integer column containing UNIX timestamps to \fBtimestamp
with time zone\fR via a USING clause:
.sp
.nf
ALTER TABLE foo
    ALTER COLUMN foo_timestamp TYPE timestamp with time zone
    USING
        timestamp with time zone 'epoch' + foo_timestamp * interval '1 second';
.sp
.fi
.PP
To rename an existing column:
.sp
.nf
ALTER TABLE distributors RENAME COLUMN address TO city;
.sp
.fi
.PP
To rename an existing table:
.sp
.nf
ALTER TABLE distributors RENAME TO suppliers;
.sp
.fi
.PP
To add a not-null constraint to a column:
.sp
.nf
ALTER TABLE distributors ALTER COLUMN street SET NOT NULL;
.sp
.fi
To remove a not-null constraint from a column:
.sp
.nf
ALTER TABLE distributors ALTER COLUMN street DROP NOT NULL;
.sp
.fi
.PP
To add a check constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT zipchk CHECK (char_length(zipcode) = 5);
.sp
.fi
.PP
To remove a check constraint from a table and all its children:
.sp
.nf
ALTER TABLE distributors DROP CONSTRAINT zipchk;
.sp
.fi
.PP
To add a foreign key constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT distfk FOREIGN KEY (address) REFERENCES addresses (address) MATCH FULL;
.sp
.fi
.PP
To add a (multicolumn) unique constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT dist_id_zipcode_key UNIQUE (dist_id, zipcode);
.sp
.fi
.PP
To add an automatically named primary key constraint to a table, noting
that a table can only ever have one primary key:
.sp
.nf
ALTER TABLE distributors ADD PRIMARY KEY (dist_id);
.sp
.fi
.PP
To move a table to a different tablespace:
.sp
.nf
ALTER TABLE distributors SET TABLESPACE fasttablespace;
.sp
.fi
.PP
To move a table to a different schema:
.sp
.nf
ALTER TABLE myschema.distributors SET SCHEMA yourschema;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The ADD, DROP, and SET DEFAULT
forms conform with the SQL standard. The other forms are
PostgreSQL extensions of the SQL standard.
Also, the ability to specify more than one manipulation in a single
\fBALTER TABLE\fR command is an extension.
.PP
\fBALTER TABLE DROP COLUMN\fR can be used to drop the only
column of a table, leaving a zero-column table. This is an
extension of SQL, which disallows zero-column tables.
