/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_REFERENCE = 290,
     SQL_RETURNED_LENGTH = 291,
     SQL_RETURNED_OCTET_LENGTH = 292,
     SQL_SCALE = 293,
     SQL_SECTION = 294,
     SQL_SHORT = 295,
     SQL_SIGNED = 296,
     SQL_SQL = 297,
     SQL_SQLERROR = 298,
     SQL_SQLPRINT = 299,
     SQL_SQLWARNING = 300,
     SQL_START = 301,
     SQL_STOP = 302,
     SQL_STRUCT = 303,
     SQL_UNSIGNED = 304,
     SQL_VALUE = 305,
     SQL_VAR = 306,
     SQL_WHENEVER = 307,
     S_ADD = 308,
     S_AND = 309,
     S_ANYTHING = 310,
     S_AUTO = 311,
     S_CONST = 312,
     S_DEC = 313,
     S_DIV = 314,
     S_DOTPOINT = 315,
     S_EQUAL = 316,
     S_EXTERN = 317,
     S_INC = 318,
     S_LSHIFT = 319,
     S_MEMPOINT = 320,
     S_MEMBER = 321,
     S_MOD = 322,
     S_MUL = 323,
     S_NEQUAL = 324,
     S_OR = 325,
     S_REGISTER = 326,
     S_RSHIFT = 327,
     S_STATIC = 328,
     S_SUB = 329,
     S_VOLATILE = 330,
     S_TYPEDEF = 331,
     TYPECAST = 332,
     ABORT_P = 333,
     ABSOLUTE_P = 334,
     ACCESS = 335,
     ACTION = 336,
     ADD = 337,
     ADMIN = 338,
     AFTER = 339,
     AGGREGATE = 340,
     ALL = 341,
     ALSO = 342,
     ALTER = 343,
     ANALYSE = 344,
     ANALYZE = 345,
     AND = 346,
     ANY = 347,
     ARRAY = 348,
     AS = 349,
     ASC = 350,
     ASSERTION = 351,
     ASSIGNMENT = 352,
     ASYMMETRIC = 353,
     AT = 354,
     AUTHORIZATION = 355,
     BACKWARD = 356,
     BEFORE = 357,
     BEGIN_P = 358,
     BETWEEN = 359,
     BIGINT = 360,
     BINARY = 361,
     BIT = 362,
     BOOLEAN_P = 363,
     BOTH = 364,
     BY = 365,
     CACHE = 366,
     CALLED = 367,
     CASCADE = 368,
     CASE = 369,
     CAST = 370,
     CHAIN = 371,
     CHAR_P = 372,
     CHARACTER = 373,
     CHARACTERISTICS = 374,
     CHECK = 375,
     CHECKPOINT = 376,
     CLASS = 377,
     CLOSE = 378,
     CLUSTER = 379,
     COALESCE = 380,
     COLLATE = 381,
     COLUMN = 382,
     COMMENT = 383,
     COMMIT = 384,
     COMMITTED = 385,
     CONNECTION = 386,
     CONSTRAINT = 387,
     CONSTRAINTS = 388,
     CONVERSION_P = 389,
     CONVERT = 390,
     COPY = 391,
     CREATE = 392,
     CREATEDB = 393,
     CREATEROLE = 394,
     CREATEUSER = 395,
     CROSS = 396,
     CSV = 397,
     CURRENT_DATE = 398,
     CURRENT_ROLE = 399,
     CURRENT_TIME = 400,
     CURRENT_TIMESTAMP = 401,
     CURRENT_USER = 402,
     CURSOR = 403,
     CYCLE = 404,
     DATABASE = 405,
     DAY_P = 406,
     DEALLOCATE = 407,
     DEC = 408,
     DECIMAL_P = 409,
     DECLARE = 410,
     DEFAULT = 411,
     DEFAULTS = 412,
     DEFERRABLE = 413,
     DEFERRED = 414,
     DEFINER = 415,
     DELETE_P = 416,
     DELIMITER = 417,
     DELIMITERS = 418,
     DESC = 419,
     DISABLE_P = 420,
     DISTINCT = 421,
     DO = 422,
     DOMAIN_P = 423,
     DOUBLE_P = 424,
     DROP = 425,
     EACH = 426,
     ELSE = 427,
     ENABLE_P = 428,
     ENCODING = 429,
     ENCRYPTED = 430,
     END_P = 431,
     ESCAPE = 432,
     EXCEPT = 433,
     EXCLUSIVE = 434,
     EXCLUDING = 435,
     EXECUTE = 436,
     EXISTS = 437,
     EXPLAIN = 438,
     EXTERNAL = 439,
     EXTRACT = 440,
     FALSE_P = 441,
     FETCH = 442,
     FIRST_P = 443,
     FLOAT_P = 444,
     FOR = 445,
     FORCE = 446,
     FOREIGN = 447,
     FORWARD = 448,
     FREEZE = 449,
     FROM = 450,
     FULL = 451,
     FUNCTION = 452,
     GET = 453,
     GLOBAL = 454,
     GRANT = 455,
     GRANTED = 456,
     GREATEST = 457,
     GROUP_P = 458,
     HANDLER = 459,
     HAVING = 460,
     HEADER = 461,
     HOLD = 462,
     HOUR_P = 463,
     ILIKE = 464,
     IMMEDIATE = 465,
     IMMUTABLE = 466,
     IMPLICIT_P = 467,
     IN_P = 468,
     INCLUDING = 469,
     INCREMENT = 470,
     INDEX = 471,
     INHERIT = 472,
     INHERITS = 473,
     INITIALLY = 474,
     INNER_P = 475,
     INOUT = 476,
     INPUT_P = 477,
     INSENSITIVE = 478,
     INSERT = 479,
     INSTEAD = 480,
     INT_P = 481,
     INTEGER = 482,
     INTERSECT = 483,
     INTERVAL = 484,
     INTO = 485,
     INVOKER = 486,
     IS = 487,
     ISNULL = 488,
     ISOLATION = 489,
     JOIN = 490,
     KEY = 491,
     LANCOMPILER = 492,
     LANGUAGE = 493,
     LARGE_P = 494,
     LAST_P = 495,
     LEADING = 496,
     LEAST = 497,
     LEFT = 498,
     LEVEL = 499,
     LIKE = 500,
     LIMIT = 501,
     LISTEN = 502,
     LOAD = 503,
     LOCAL = 504,
     LOCALTIME = 505,
     LOCALTIMESTAMP = 506,
     LOCATION = 507,
     LOCK_P = 508,
     LOGIN_P = 509,
     MATCH = 510,
     MAXVALUE = 511,
     MINUTE_P = 512,
     MINVALUE = 513,
     MODE = 514,
     MONTH_P = 515,
     MOVE = 516,
     NAMES = 517,
     NATIONAL = 518,
     NATURAL = 519,
     NCHAR = 520,
     NEW = 521,
     NEXT = 522,
     NO = 523,
     NOCREATEDB = 524,
     NOCREATEROLE = 525,
     NOCREATEUSER = 526,
     NOINHERIT = 527,
     NOLOGIN_P = 528,
     NONE = 529,
     NOSUPERUSER = 530,
     NOT = 531,
     NOTHING = 532,
     NOTIFY = 533,
     NOTNULL = 534,
     NOWAIT = 535,
     NULL_P = 536,
     NULLIF = 537,
     NUMERIC = 538,
     OBJECT_P = 539,
     OF = 540,
     OFF = 541,
     OFFSET = 542,
     OIDS = 543,
     OLD = 544,
     ON = 545,
     ONLY = 546,
     OPERATOR = 547,
     OPTION = 548,
     OR = 549,
     ORDER = 550,
     OUT_P = 551,
     OUTER_P = 552,
     OVERLAPS = 553,
     OVERLAY = 554,
     OWNER = 555,
     PARTIAL = 556,
     PASSWORD = 557,
     PLACING = 558,
     POSITION = 559,
     PRECISION = 560,
     PRESERVE = 561,
     PREPARE = 562,
     PREPARED = 563,
     PRIMARY = 564,
     PRIOR = 565,
     PRIVILEGES = 566,
     PROCEDURAL = 567,
     PROCEDURE = 568,
     QUOTE = 569,
     READ = 570,
     REAL = 571,
     RECHECK = 572,
     REFERENCES = 573,
     REINDEX = 574,
     RELATIVE_P = 575,
     RELEASE = 576,
     RENAME = 577,
     REPEATABLE = 578,
     REPLACE = 579,
     RESET = 580,
     RESTART = 581,
     RESTRICT = 582,
     RETURNS = 583,
     REVOKE = 584,
     RIGHT = 585,
     ROLE = 586,
     ROLLBACK = 587,
     ROW = 588,
     ROWS = 589,
     RULE = 590,
     SAVEPOINT = 591,
     SCHEMA = 592,
     SCROLL = 593,
     SECOND_P = 594,
     SECURITY = 595,
     SELECT = 596,
     SEQUENCE = 597,
     SERIALIZABLE = 598,
     SESSION = 599,
     SESSION_USER = 600,
     SET = 601,
     SETOF = 602,
     SHARE = 603,
     SHOW = 604,
     SIMILAR = 605,
     SIMPLE = 606,
     SMALLINT = 607,
     SOME = 608,
     STABLE = 609,
     START = 610,
     STATEMENT = 611,
     STATISTICS = 612,
     STDIN = 613,
     STDOUT = 614,
     STORAGE = 615,
     STRICT_P = 616,
     SUBSTRING = 617,
     SUPERUSER_P = 618,
     SYMMETRIC = 619,
     SYSID = 620,
     SYSTEM_P = 621,
     TABLE = 622,
     TABLESPACE = 623,
     TEMP = 624,
     TEMPLATE = 625,
     TEMPORARY = 626,
     THEN = 627,
     TIME = 628,
     TIMESTAMP = 629,
     TO = 630,
     TOAST = 631,
     TRAILING = 632,
     TRANSACTION = 633,
     TREAT = 634,
     TRIGGER = 635,
     TRIM = 636,
     TRUE_P = 637,
     TRUNCATE = 638,
     TRUSTED = 639,
     TYPE_P = 640,
     UNCOMMITTED = 641,
     UNENCRYPTED = 642,
     UNION = 643,
     UNIQUE = 644,
     UNKNOWN = 645,
     UNLISTEN = 646,
     UNTIL = 647,
     UPDATE = 648,
     USER = 649,
     USING = 650,
     VACUUM = 651,
     VALID = 652,
     VALIDATOR = 653,
     VALUES = 654,
     VARCHAR = 655,
     VARYING = 656,
     VERBOSE = 657,
     VIEW = 658,
     VOLATILE = 659,
     WHEN = 660,
     WHERE = 661,
     WITH = 662,
     WITHOUT = 663,
     WORK = 664,
     WRITE = 665,
     YEAR_P = 666,
     ZONE = 667,
     UNIONJOIN = 668,
     IDENT = 669,
     SCONST = 670,
     Op = 671,
     CSTRING = 672,
     CVARIABLE = 673,
     CPP_LINE = 674,
     IP = 675,
     BCONST = 676,
     XCONST = 677,
     ICONST = 678,
     PARAM = 679,
     FCONST = 680,
     POSTFIXOP = 681,
     UMINUS = 682
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_REFERENCE 290
#define SQL_RETURNED_LENGTH 291
#define SQL_RETURNED_OCTET_LENGTH 292
#define SQL_SCALE 293
#define SQL_SECTION 294
#define SQL_SHORT 295
#define SQL_SIGNED 296
#define SQL_SQL 297
#define SQL_SQLERROR 298
#define SQL_SQLPRINT 299
#define SQL_SQLWARNING 300
#define SQL_START 301
#define SQL_STOP 302
#define SQL_STRUCT 303
#define SQL_UNSIGNED 304
#define SQL_VALUE 305
#define SQL_VAR 306
#define SQL_WHENEVER 307
#define S_ADD 308
#define S_AND 309
#define S_ANYTHING 310
#define S_AUTO 311
#define S_CONST 312
#define S_DEC 313
#define S_DIV 314
#define S_DOTPOINT 315
#define S_EQUAL 316
#define S_EXTERN 317
#define S_INC 318
#define S_LSHIFT 319
#define S_MEMPOINT 320
#define S_MEMBER 321
#define S_MOD 322
#define S_MUL 323
#define S_NEQUAL 324
#define S_OR 325
#define S_REGISTER 326
#define S_RSHIFT 327
#define S_STATIC 328
#define S_SUB 329
#define S_VOLATILE 330
#define S_TYPEDEF 331
#define TYPECAST 332
#define ABORT_P 333
#define ABSOLUTE_P 334
#define ACCESS 335
#define ACTION 336
#define ADD 337
#define ADMIN 338
#define AFTER 339
#define AGGREGATE 340
#define ALL 341
#define ALSO 342
#define ALTER 343
#define ANALYSE 344
#define ANALYZE 345
#define AND 346
#define ANY 347
#define ARRAY 348
#define AS 349
#define ASC 350
#define ASSERTION 351
#define ASSIGNMENT 352
#define ASYMMETRIC 353
#define AT 354
#define AUTHORIZATION 355
#define BACKWARD 356
#define BEFORE 357
#define BEGIN_P 358
#define BETWEEN 359
#define BIGINT 360
#define BINARY 361
#define BIT 362
#define BOOLEAN_P 363
#define BOTH 364
#define BY 365
#define CACHE 366
#define CALLED 367
#define CASCADE 368
#define CASE 369
#define CAST 370
#define CHAIN 371
#define CHAR_P 372
#define CHARACTER 373
#define CHARACTERISTICS 374
#define CHECK 375
#define CHECKPOINT 376
#define CLASS 377
#define CLOSE 378
#define CLUSTER 379
#define COALESCE 380
#define COLLATE 381
#define COLUMN 382
#define COMMENT 383
#define COMMIT 384
#define COMMITTED 385
#define CONNECTION 386
#define CONSTRAINT 387
#define CONSTRAINTS 388
#define CONVERSION_P 389
#define CONVERT 390
#define COPY 391
#define CREATE 392
#define CREATEDB 393
#define CREATEROLE 394
#define CREATEUSER 395
#define CROSS 396
#define CSV 397
#define CURRENT_DATE 398
#define CURRENT_ROLE 399
#define CURRENT_TIME 400
#define CURRENT_TIMESTAMP 401
#define CURRENT_USER 402
#define CURSOR 403
#define CYCLE 404
#define DATABASE 405
#define DAY_P 406
#define DEALLOCATE 407
#define DEC 408
#define DECIMAL_P 409
#define DECLARE 410
#define DEFAULT 411
#define DEFAULTS 412
#define DEFERRABLE 413
#define DEFERRED 414
#define DEFINER 415
#define DELETE_P 416
#define DELIMITER 417
#define DELIMITERS 418
#define DESC 419
#define DISABLE_P 420
#define DISTINCT 421
#define DO 422
#define DOMAIN_P 423
#define DOUBLE_P 424
#define DROP 425
#define EACH 426
#define ELSE 427
#define ENABLE_P 428
#define ENCODING 429
#define ENCRYPTED 430
#define END_P 431
#define ESCAPE 432
#define EXCEPT 433
#define EXCLUSIVE 434
#define EXCLUDING 435
#define EXECUTE 436
#define EXISTS 437
#define EXPLAIN 438
#define EXTERNAL 439
#define EXTRACT 440
#define FALSE_P 441
#define FETCH 442
#define FIRST_P 443
#define FLOAT_P 444
#define FOR 445
#define FORCE 446
#define FOREIGN 447
#define FORWARD 448
#define FREEZE 449
#define FROM 450
#define FULL 451
#define FUNCTION 452
#define GET 453
#define GLOBAL 454
#define GRANT 455
#define GRANTED 456
#define GREATEST 457
#define GROUP_P 458
#define HANDLER 459
#define HAVING 460
#define HEADER 461
#define HOLD 462
#define HOUR_P 463
#define ILIKE 464
#define IMMEDIATE 465
#define IMMUTABLE 466
#define IMPLICIT_P 467
#define IN_P 468
#define INCLUDING 469
#define INCREMENT 470
#define INDEX 471
#define INHERIT 472
#define INHERITS 473
#define INITIALLY 474
#define INNER_P 475
#define INOUT 476
#define INPUT_P 477
#define INSENSITIVE 478
#define INSERT 479
#define INSTEAD 480
#define INT_P 481
#define INTEGER 482
#define INTERSECT 483
#define INTERVAL 484
#define INTO 485
#define INVOKER 486
#define IS 487
#define ISNULL 488
#define ISOLATION 489
#define JOIN 490
#define KEY 491
#define LANCOMPILER 492
#define LANGUAGE 493
#define LARGE_P 494
#define LAST_P 495
#define LEADING 496
#define LEAST 497
#define LEFT 498
#define LEVEL 499
#define LIKE 500
#define LIMIT 501
#define LISTEN 502
#define LOAD 503
#define LOCAL 504
#define LOCALTIME 505
#define LOCALTIMESTAMP 506
#define LOCATION 507
#define LOCK_P 508
#define LOGIN_P 509
#define MATCH 510
#define MAXVALUE 511
#define MINUTE_P 512
#define MINVALUE 513
#define MODE 514
#define MONTH_P 515
#define MOVE 516
#define NAMES 517
#define NATIONAL 518
#define NATURAL 519
#define NCHAR 520
#define NEW 521
#define NEXT 522
#define NO 523
#define NOCREATEDB 524
#define NOCREATEROLE 525
#define NOCREATEUSER 526
#define NOINHERIT 527
#define NOLOGIN_P 528
#define NONE 529
#define NOSUPERUSER 530
#define NOT 531
#define NOTHING 532
#define NOTIFY 533
#define NOTNULL 534
#define NOWAIT 535
#define NULL_P 536
#define NULLIF 537
#define NUMERIC 538
#define OBJECT_P 539
#define OF 540
#define OFF 541
#define OFFSET 542
#define OIDS 543
#define OLD 544
#define ON 545
#define ONLY 546
#define OPERATOR 547
#define OPTION 548
#define OR 549
#define ORDER 550
#define OUT_P 551
#define OUTER_P 552
#define OVERLAPS 553
#define OVERLAY 554
#define OWNER 555
#define PARTIAL 556
#define PASSWORD 557
#define PLACING 558
#define POSITION 559
#define PRECISION 560
#define PRESERVE 561
#define PREPARE 562
#define PREPARED 563
#define PRIMARY 564
#define PRIOR 565
#define PRIVILEGES 566
#define PROCEDURAL 567
#define PROCEDURE 568
#define QUOTE 569
#define READ 570
#define REAL 571
#define RECHECK 572
#define REFERENCES 573
#define REINDEX 574
#define RELATIVE_P 575
#define RELEASE 576
#define RENAME 577
#define REPEATABLE 578
#define REPLACE 579
#define RESET 580
#define RESTART 581
#define RESTRICT 582
#define RETURNS 583
#define REVOKE 584
#define RIGHT 585
#define ROLE 586
#define ROLLBACK 587
#define ROW 588
#define ROWS 589
#define RULE 590
#define SAVEPOINT 591
#define SCHEMA 592
#define SCROLL 593
#define SECOND_P 594
#define SECURITY 595
#define SELECT 596
#define SEQUENCE 597
#define SERIALIZABLE 598
#define SESSION 599
#define SESSION_USER 600
#define SET 601
#define SETOF 602
#define SHARE 603
#define SHOW 604
#define SIMILAR 605
#define SIMPLE 606
#define SMALLINT 607
#define SOME 608
#define STABLE 609
#define START 610
#define STATEMENT 611
#define STATISTICS 612
#define STDIN 613
#define STDOUT 614
#define STORAGE 615
#define STRICT_P 616
#define SUBSTRING 617
#define SUPERUSER_P 618
#define SYMMETRIC 619
#define SYSID 620
#define SYSTEM_P 621
#define TABLE 622
#define TABLESPACE 623
#define TEMP 624
#define TEMPLATE 625
#define TEMPORARY 626
#define THEN 627
#define TIME 628
#define TIMESTAMP 629
#define TO 630
#define TOAST 631
#define TRAILING 632
#define TRANSACTION 633
#define TREAT 634
#define TRIGGER 635
#define TRIM 636
#define TRUE_P 637
#define TRUNCATE 638
#define TRUSTED 639
#define TYPE_P 640
#define UNCOMMITTED 641
#define UNENCRYPTED 642
#define UNION 643
#define UNIQUE 644
#define UNKNOWN 645
#define UNLISTEN 646
#define UNTIL 647
#define UPDATE 648
#define USER 649
#define USING 650
#define VACUUM 651
#define VALID 652
#define VALIDATOR 653
#define VALUES 654
#define VARCHAR 655
#define VARYING 656
#define VERBOSE 657
#define VIEW 658
#define VOLATILE 659
#define WHEN 660
#define WHERE 661
#define WITH 662
#define WITHOUT 663
#define WORK 664
#define WRITE 665
#define YEAR_P 666
#define ZONE 667
#define UNIONJOIN 668
#define IDENT 669
#define SCONST 670
#define Op 671
#define CSTRING 672
#define CVARIABLE 673
#define CPP_LINE 674
#define IP 675
#define BCONST 676
#define XCONST 677
#define ICONST 678
#define PARAM 679
#define FCONST 680
#define POSTFIXOP 681
#define UMINUS 682




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 311 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1250 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1262 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   56378

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  448
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  526
/* YYNRULES -- Number of rules. */
#define YYNRULES  2018
/* YYNRULES -- Number of states. */
#define YYNSTATES  3353

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   683

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   434,     2,     2,
     439,   440,   432,   430,   446,   431,   441,   433,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   447,   442,
     427,   426,   428,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   437,     2,   438,   435,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   443,     2,   444,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   429,   436,   445
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   240,   242,   243,   246,   250,
     254,   256,   258,   260,   262,   264,   266,   268,   270,   272,
     274,   278,   282,   285,   288,   291,   294,   298,   302,   308,
     314,   320,   325,   331,   337,   342,   346,   350,   356,   363,
     365,   367,   371,   378,   383,   385,   386,   389,   390,   392,
     394,   396,   398,   400,   402,   405,   409,   413,   417,   421,
     425,   428,   434,   437,   440,   444,   448,   450,   454,   456,
     458,   460,   464,   467,   470,   473,   475,   477,   479,   481,
     483,   485,   487,   489,   491,   493,   497,   504,   506,   508,
     510,   512,   513,   515,   517,   520,   524,   529,   533,   536,
     539,   543,   548,   552,   555,   560,   562,   564,   566,   568,
     570,   575,   580,   582,   586,   590,   595,   602,   609,   616,
     623,   628,   635,   638,   643,   647,   651,   655,   659,   663,
     667,   671,   675,   679,   683,   685,   689,   693,   697,   701,
     704,   706,   708,   709,   712,   713,   716,   726,   728,   730,
     732,   734,   736,   739,   740,   742,   744,   748,   752,   754,
     756,   760,   764,   768,   773,   775,   776,   779,   780,   784,
     785,   787,   788,   800,   813,   815,   817,   820,   823,   826,
     829,   830,   832,   833,   835,   839,   841,   843,   845,   849,
     852,   853,   857,   859,   861,   864,   866,   869,   873,   878,
     881,   887,   889,   892,   895,   898,   902,   905,   908,   909,
     913,   915,   920,   926,   933,   945,   949,   950,   954,   956,
     958,   961,   964,   965,   967,   969,   972,   975,   976,   980,
     984,   987,   989,   991,   994,   997,  1002,  1003,  1006,  1009,
    1010,  1014,  1019,  1024,  1025,  1028,  1029,  1034,  1035,  1036,
    1045,  1049,  1053,  1055,  1059,  1060,  1064,  1066,  1068,  1074,
    1079,  1082,  1083,  1086,  1088,  1091,  1095,  1098,  1101,  1104,
    1107,  1111,  1115,  1117,  1118,  1124,  1134,  1136,  1137,  1139,
    1142,  1145,  1146,  1149,  1150,  1156,  1158,  1159,  1166,  1169,
    1170,  1174,  1189,  1209,  1211,  1213,  1215,  1219,  1225,  1227,
    1229,  1231,  1235,  1236,  1238,  1239,  1241,  1243,  1245,  1249,
    1250,  1252,  1254,  1255,  1258,  1260,  1263,  1265,  1268,  1271,
    1273,  1276,  1279,  1286,  1295,  1299,  1304,  1309,  1314,  1320,
    1324,  1328,  1330,  1334,  1338,  1340,  1342,  1344,  1346,  1359,
    1361,  1365,  1370,  1378,  1383,  1386,  1388,  1389,  1391,  1392,
    1400,  1405,  1407,  1409,  1411,  1413,  1415,  1417,  1419,  1421,
    1423,  1427,  1429,  1432,  1435,  1439,  1443,  1449,  1454,  1459,
    1463,  1468,  1472,  1476,  1479,  1484,  1487,  1489,  1491,  1493,
    1495,  1498,  1501,  1503,  1505,  1507,  1510,  1513,  1515,  1518,
    1521,  1523,  1525,  1532,  1542,  1550,  1560,  1569,  1578,  1585,
    1595,  1603,  1614,  1622,  1624,  1626,  1628,  1630,  1632,  1634,
    1636,  1638,  1640,  1642,  1644,  1646,  1654,  1662,  1673,  1676,
    1678,  1680,  1682,  1686,  1688,  1690,  1692,  1694,  1696,  1699,
    1702,  1705,  1708,  1711,  1714,  1716,  1720,  1722,  1725,  1729,
    1730,  1732,  1736,  1739,  1746,  1753,  1757,  1758,  1762,  1763,
    1776,  1778,  1779,  1782,  1783,  1785,  1789,  1792,  1795,  1800,
    1802,  1805,  1806,  1816,  1824,  1827,  1828,  1832,  1835,  1837,
    1841,  1845,  1849,  1852,  1855,  1857,  1859,  1861,  1863,  1866,
    1868,  1872,  1874,  1876,  1878,  1883,  1885,  1888,  1893,  1899,
    1901,  1903,  1905,  1907,  1911,  1915,  1918,  1921,  1924,  1927,
    1929,  1932,  1933,  1939,  1941,  1944,  1946,  1947,  1953,  1961,
    1963,  1965,  1973,  1975,  1979,  1983,  1987,  1989,  1993,  2005,
    2016,  2019,  2020,  2029,  2034,  2039,  2044,  2046,  2048,  2050,
    2051,  2061,  2068,  2075,  2083,  2090,  2097,  2107,  2114,  2121,
    2128,  2137,  2146,  2153,  2160,  2162,  2163,  2173,  2180,  2188,
    2195,  2202,  2209,  2219,  2226,  2233,  2240,  2248,  2258,  2268,
    2275,  2282,  2289,  2290,  2305,  2307,  2309,  2313,  2317,  2319,
    2321,  2323,  2325,  2327,  2329,  2331,  2332,  2334,  2336,  2338,
    2340,  2342,  2344,  2345,  2352,  2355,  2358,  2361,  2364,  2367,
    2371,  2375,  2378,  2381,  2384,  2387,  2391,  2394,  2400,  2405,
    2409,  2413,  2417,  2419,  2421,  2422,  2426,  2429,  2432,  2434,
    2438,  2441,  2443,  2444,  2452,  2462,  2465,  2471,  2475,  2477,
    2480,  2484,  2488,  2492,  2496,  2500,  2504,  2508,  2512,  2517,
    2521,  2525,  2527,  2528,  2534,  2540,  2545,  2548,  2549,  2554,
    2558,  2565,  2570,  2577,  2584,  2590,  2598,  2600,  2601,  2612,
    2617,  2620,  2622,  2627,  2633,  2639,  2642,  2647,  2649,  2651,
    2653,  2654,  2656,  2657,  2659,  2660,  2664,  2665,  2670,  2672,
    2674,  2676,  2678,  2680,  2682,  2683,  2688,  2693,  2696,  2698,
    2706,  2711,  2715,  2717,  2720,  2726,  2729,  2730,  2736,  2740,
    2741,  2744,  2747,  2750,  2754,  2756,  2760,  2762,  2765,  2767,
    2768,  2775,  2783,  2784,  2787,  2790,  2793,  2797,  2798,  2801,
    2804,  2806,  2808,  2812,  2816,  2818,  2821,  2826,  2831,  2833,
    2835,  2844,  2849,  2854,  2859,  2862,  2864,  2865,  2869,  2873,
    2878,  2883,  2888,  2893,  2896,  2898,  2900,  2901,  2903,  2904,
    2906,  2912,  2914,  2915,  2917,  2918,  2922,  2924,  2928,  2932,
    2935,  2938,  2940,  2945,  2950,  2953,  2956,  2961,  2963,  2964,
    2966,  2968,  2970,  2974,  2975,  2978,  2979,  2984,  2989,  2993,
    2995,  2996,  2999,  3000,  3003,  3004,  3008,  3010,  3012,  3015,
    3017,  3020,  3026,  3033,  3039,  3041,  3044,  3046,  3051,  3055,
    3060,  3064,  3070,  3075,  3081,  3086,  3092,  3095,  3100,  3102,
    3105,  3108,  3111,  3113,  3115,  3116,  3121,  3124,  3126,  3129,
    3132,  3137,  3139,  3142,  3143,  3145,  3149,  3152,  3155,  3159,
    3165,  3172,  3176,  3181,  3182,  3184,  3188,  3192,  3196,  3200,
    3204,  3208,  3210,  3212,  3214,  3216,  3218,  3220,  3222,  3225,
    3231,  3234,  3236,  3238,  3240,  3242,  3244,  3246,  3248,  3250,
    3252,  3254,  3256,  3259,  3262,  3265,  3268,  3271,  3273,  3277,
    3278,  3284,  3288,  3289,  3295,  3299,  3300,  3302,  3304,  3306,
    3308,  3314,  3317,  3319,  3321,  3323,  3325,  3331,  3334,  3337,
    3340,  3342,  3346,  3350,  3353,  3355,  3356,  3360,  3361,  3367,
    3370,  3376,  3379,  3381,  3385,  3389,  3390,  3392,  3394,  3396,
    3398,  3400,  3402,  3406,  3410,  3414,  3418,  3422,  3426,  3430,
    3431,  3433,  3437,  3443,  3446,  3449,  3453,  3457,  3461,  3465,
    3469,  3473,  3477,  3481,  3485,  3489,  3492,  3495,  3499,  3503,
    3506,  3510,  3516,  3521,  3528,  3532,  3538,  3543,  3550,  3555,
    3562,  3568,  3576,  3579,  3583,  3586,  3591,  3595,  3600,  3604,
    3609,  3613,  3618,  3624,  3631,  3639,  3646,  3654,  3661,  3669,
    3673,  3678,  3683,  3690,  3693,  3695,  3699,  3702,  3706,  3710,
    3714,  3718,  3722,  3726,  3730,  3734,  3738,  3742,  3745,  3748,
    3754,  3761,  3769,  3771,  3773,  3776,  3781,  3783,  3785,  3787,
    3790,  3793,  3796,  3798,  3802,  3807,  3813,  3819,  3824,  3826,
    3828,  3833,  3835,  3840,  3842,  3847,  3849,  3854,  3856,  3858,
    3860,  3862,  3869,  3874,  3879,  3884,  3889,  3896,  3902,  3908,
    3914,  3919,  3926,  3931,  3938,  3943,  3948,  3953,  3958,  3962,
    3968,  3970,  3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,
    3988,  3990,  3992,  3994,  3996,  3998,  4003,  4005,  4010,  4012,
    4017,  4019,  4022,  4024,  4027,  4029,  4033,  4037,  4038,  4042,
    4044,  4046,  4050,  4054,  4058,  4060,  4062,  4064,  4066,  4068,
    4070,  4072,  4074,  4079,  4083,  4086,  4090,  4091,  4095,  4099,
    4102,  4105,  4107,  4108,  4111,  4114,  4118,  4121,  4123,  4125,
    4129,  4135,  4138,  4140,  4145,  4148,  4149,  4151,  4152,  4154,
    4157,  4160,  4163,  4167,  4173,  4175,  4178,  4179,  4182,  4184,
    4185,  4189,  4191,  4195,  4197,  4199,  4203,  4211,  4213,  4216,
    4221,  4223,  4227,  4232,  4237,  4241,  4243,  4245,  4247,  4249,
    4251,  4253,  4257,  4259,  4262,  4264,  4268,  4270,  4272,  4274,
    4276,  4278,  4280,  4282,  4285,  4287,  4290,  4294,  4301,  4303,
    4305,  4307,  4309,  4311,  4313,  4315,  4317,  4319,  4321,  4323,
    4325,  4328,  4330,  4332,  4334,  4336,  4339,  4342,  4344,  4346,
    4348,  4350,  4352,  4354,  4356,  4358,  4361,  4364,  4366,  4368,
    4370,  4372,  4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,
    4394,  4398,  4401,  4404,  4408,  4416,  4418,  4420,  4423,  4426,
    4428,  4429,  4431,  4435,  4437,  4440,  4441,  4444,  4445,  4448,
    4449,  4451,  4455,  4460,  4464,  4466,  4468,  4470,  4473,  4474,
    4482,  4486,  4489,  4491,  4493,  4495,  4496,  4502,  4503,  4508,
    4511,  4513,  4516,  4517,  4519,  4523,  4527,  4531,  4535,  4536,
    4541,  4547,  4553,  4554,  4556,  4558,  4560,  4562,  4565,  4568,
    4571,  4573,  4576,  4577,  4585,  4586,  4592,  4593,  4598,  4601,
    4604,  4606,  4608,  4610,  4612,  4614,  4616,  4618,  4620,  4622,
    4624,  4626,  4632,  4635,  4637,  4641,  4644,  4647,  4651,  4652,
    4658,  4660,  4661,  4667,  4670,  4673,  4675,  4677,  4679,  4682,
    4685,  4689,  4691,  4694,  4697,  4701,  4705,  4710,  4713,  4715,
    4718,  4720,  4722,  4725,  4728,  4732,  4734,  4736,  4738,  4740,
    4741,  4743,  4747,  4752,  4753,  4756,  4757,  4759,  4762,  4766,
    4769,  4771,  4773,  4775,  4776,  4778,  4780,  4784,  4785,  4790,
    4793,  4796,  4798,  4800,  4801,  4803,  4805,  4807,  4809,  4812,
    4816,  4817,  4819,  4822,  4824,  4829,  4834,  4835,  4837,  4840,
    4842,  4844,  4848,  4850,  4852,  4857,  4862,  4867,  4872,  4874,
    4875,  4879,  4883,  4888,  4890,  4894,  4898,  4903,  4905,  4909,
    4913,  4915,  4922,  4924,  4928,  4932,  4939,  4941,  4945,  4949,
    4951,  4953,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,
    4971,  4973,  4975,  4977,  4979,  4984,  4989,  4991,  4993,  4998,
    5003,  5007,  5008,  5016,  5018,  5019,  5020,  5028,  5032,  5037,
    5041,  5043,  5045,  5047,  5050,  5054,  5060,  5063,  5069,  5072,
    5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,
    5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,
    5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,
    5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,
    5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,
    5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,
    5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,
    5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,
    5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,
    5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,
    5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,
    5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,
    5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,
    5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,
    5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,
    5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,
    5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,
    5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,
    5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,
    5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,
    5474,  5476,  5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,
    5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,
    5514,  5516,  5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,
    5534,  5536,  5538,  5540,  5542,  5544,  5546,  5548,  5550,  5552,
    5554,  5556,  5558,  5560,  5562,  5564,  5566,  5568,  5570,  5572,
    5574,  5576,  5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,
    5594,  5596,  5598,  5600,  5602,  5604,  5606,  5608,  5610,  5612,
    5614,  5616,  5618,  5620,  5622,  5624,  5626,  5628,  5630,  5632,
    5634,  5636,  5638,  5640,  5642,  5644,  5646,  5648,  5650,  5652,
    5654,  5656,  5658,  5660,  5662,  5664,  5666,  5668,  5670,  5672,
    5674,  5676,  5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,
    5694,  5696,  5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,
    5714,  5716,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,
    5734,  5736,  5738,  5740,  5742,  5744,  5746,  5748,  5750,  5752,
    5754,  5756,  5758,  5760,  5762,  5764,  5766,  5768,  5770,  5772,
    5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,
    5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,
    5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,
    5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,
    5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,
    5874,  5876,  5878,  5880,  5884,  5886,  5887,  5889,  5892,  5894,
    5897,  5899,  5901,  5904,  5907,  5909,  5911,  5913,  5915,  5917,
    5919,  5922,  5926,  5928,  5931,  5933,  5937,  5939,  5943,  5945,
    5947,  5949,  5951,  5953,  5955,  5957,  5959,  5961,  5963,  5965,
    5967,  5969,  5971,  5973,  5975,  5977,  5979,  5981,  5983,  5985,
    5987,  5989,  5991,  5993,  5995,  5997,  5999,  6001,  6003,  6005,
    6007,  6009,  6011,  6013,  6015,  6017,  6019,  6021,  6023,  6025,
    6027,  6029,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,
    6047,  6049,  6051,  6053,  6055,  6057,  6059,  6061,  6063
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     449,     0,    -1,   450,    -1,    -1,   450,   451,    -1,   959,
     452,   453,   442,    -1,   959,   453,   442,    -1,   959,   852,
      -1,   860,    -1,   972,    -1,   419,    -1,   443,    -1,   444,
      -1,    99,   838,    -1,   671,    -1,   672,    -1,   677,    -1,
     629,    -1,   464,    -1,   646,    -1,   647,    -1,   540,    -1,
     488,    -1,   459,    -1,   458,    -1,   460,    -1,   682,    -1,
     487,    -1,   496,    -1,   680,    -1,   591,    -1,   484,    -1,
     497,    -1,   533,    -1,   568,    -1,   638,    -1,   679,    -1,
     676,    -1,   615,    -1,   463,    -1,   544,    -1,   576,    -1,
     454,    -1,   467,    -1,   539,    -1,   506,    -1,   551,    -1,
     554,    -1,   457,    -1,   667,    -1,   702,    -1,   570,    -1,
     695,    -1,   569,    -1,   640,    -1,   466,    -1,   581,    -1,
     549,    -1,   461,    -1,   656,    -1,   582,    -1,   553,    -1,
     567,    -1,   462,    -1,   675,    -1,   688,    -1,   588,    -1,
     594,    -1,   605,    -1,   609,    -1,   691,    -1,   658,    -1,
     666,    -1,   697,    -1,   657,    -1,   641,    -1,   633,    -1,
     635,    -1,   632,    -1,   644,    -1,   595,    -1,   606,    -1,
     648,    -1,   705,    -1,   660,    -1,   587,    -1,   659,    -1,
     701,    -1,   681,    -1,   471,    -1,   482,    -1,   483,    -1,
     665,    -1,   914,    -1,   837,    -1,   850,    -1,   851,    -1,
     915,    -1,   892,    -1,   912,    -1,   893,    -1,   896,    -1,
     901,    -1,   923,    -1,   916,    -1,   902,    -1,   911,    -1,
     930,    -1,   932,    -1,   926,    -1,   919,    -1,   933,    -1,
     936,    -1,   938,    -1,   137,   331,   835,   455,   456,    -1,
     407,    -1,    -1,   302,   825,    -1,   175,   302,   825,    -1,
     387,   302,   825,    -1,   363,    -1,   275,    -1,   217,    -1,
     272,    -1,   138,    -1,   269,    -1,   139,    -1,   270,    -1,
     254,    -1,   273,    -1,   131,   246,   827,    -1,   397,   392,
     825,    -1,   394,   812,    -1,   365,   826,    -1,    83,   812,
      -1,   331,   812,    -1,   213,   331,   812,    -1,   213,   203,
     812,    -1,   137,   394,   835,   455,   456,    -1,    88,   331,
     835,   455,   456,    -1,    88,   331,   835,   346,   472,    -1,
      88,   331,   835,   483,    -1,    88,   394,   835,   455,   456,
      -1,    88,   394,   835,   346,   472,    -1,    88,   394,   835,
     483,    -1,   170,   331,   812,    -1,   170,   394,   812,    -1,
     137,   203,   835,   455,   456,    -1,    88,   203,   835,   465,
     394,   812,    -1,    82,    -1,   170,    -1,   170,   203,   812,
      -1,   137,   337,   468,   100,   835,   469,    -1,   137,   337,
     945,   469,    -1,   945,    -1,    -1,   469,   470,    -1,    -1,
     506,    -1,   609,    -1,   539,    -1,   554,    -1,   594,    -1,
     665,    -1,   346,   472,    -1,   346,   249,   472,    -1,   346,
     344,   472,    -1,   473,   375,   474,    -1,   473,   445,   474,
      -1,   373,   412,   479,    -1,   378,   663,    -1,   344,   119,
      94,   378,   663,    -1,   262,   480,    -1,   331,   481,    -1,
     344,   100,   481,    -1,   344,   100,   156,    -1,   945,    -1,
     473,   441,   945,    -1,   475,    -1,   156,    -1,   477,    -1,
     475,   446,   477,    -1,   315,   386,    -1,   315,   130,    -1,
     323,   315,    -1,   343,    -1,   478,    -1,   833,    -1,   945,
      -1,   382,    -1,   186,    -1,   290,    -1,   286,    -1,   833,
      -1,   966,    -1,   763,   830,   765,    -1,   763,   439,   826,
     440,   830,   765,    -1,   156,    -1,   249,    -1,   830,    -1,
     156,    -1,    -1,   945,    -1,   830,    -1,   349,   473,    -1,
     349,   373,   412,    -1,   349,   378,   234,   244,    -1,   349,
     344,   100,    -1,   349,    86,    -1,   325,   473,    -1,   325,
     373,   412,    -1,   325,   378,   234,   244,    -1,   325,   344,
     100,    -1,   325,    86,    -1,   346,   133,   485,   486,    -1,
      86,    -1,   812,    -1,   159,    -1,   210,    -1,   121,    -1,
      88,   367,   736,   489,    -1,    88,   216,   736,   491,    -1,
     490,    -1,   489,   446,   490,    -1,    82,   645,   511,    -1,
      88,   645,   945,   493,    -1,    88,   645,   945,   170,   276,
     281,    -1,    88,   645,   945,   346,   276,   281,    -1,    88,
     645,   945,   346,   357,   826,    -1,    88,   645,   945,   346,
     360,   945,    -1,   170,   645,   945,   494,    -1,    88,   645,
     945,   385,   741,   495,    -1,    82,   518,    -1,   170,   132,
     813,   494,    -1,   346,   408,   288,    -1,   137,   376,   367,
      -1,   124,   290,   813,    -1,   346,   408,   124,    -1,   173,
     380,   813,    -1,   173,   380,    86,    -1,   173,   380,   394,
      -1,   165,   380,   813,    -1,   165,   380,    86,    -1,   165,
     380,   394,    -1,   492,    -1,   491,   446,   492,    -1,   300,
     375,   835,    -1,   346,   368,   813,    -1,   346,   156,   766,
      -1,   170,   156,    -1,   113,    -1,   327,    -1,    -1,   395,
     766,    -1,    -1,   123,   813,    -1,   136,   502,   811,   503,
     498,   499,   504,   455,   500,    -1,   375,    -1,   195,    -1,
     830,    -1,   358,    -1,   359,    -1,   500,   501,    -1,    -1,
     106,    -1,   288,    -1,   162,   678,   830,    -1,   281,   678,
     830,    -1,   142,    -1,   206,    -1,   314,   678,   825,    -1,
     177,   678,   825,    -1,   191,   314,   521,    -1,   191,   276,
     281,   521,    -1,   106,    -1,    -1,   407,   288,    -1,    -1,
     505,   163,   830,    -1,    -1,   395,    -1,    -1,   137,   507,
     367,   811,   439,   508,   440,   528,   529,   530,   531,    -1,
     137,   507,   367,   811,   285,   811,   439,   508,   440,   529,
     530,   531,    -1,   371,    -1,   369,    -1,   249,   371,    -1,
     249,   369,    -1,   199,   371,    -1,   199,   369,    -1,    -1,
     509,    -1,    -1,   510,    -1,   509,   446,   510,    -1,   511,
      -1,   516,    -1,   518,    -1,   945,   741,   512,    -1,   512,
     513,    -1,    -1,   132,   813,   514,    -1,   514,    -1,   515,
      -1,   276,   281,    -1,   281,    -1,   389,   532,    -1,   309,
     236,   532,    -1,   120,   439,   766,   440,    -1,   156,   767,
      -1,   318,   811,   520,   523,   524,    -1,   158,    -1,   276,
     158,    -1,   219,   159,    -1,   219,   210,    -1,   245,   811,
     517,    -1,   214,   157,    -1,   180,   157,    -1,    -1,   132,
     813,   519,    -1,   519,    -1,   120,   439,   766,   440,    -1,
     389,   439,   521,   440,   532,    -1,   309,   236,   439,   521,
     440,   532,    -1,   192,   236,   439,   521,   440,   318,   811,
     520,   523,   524,   564,    -1,   439,   521,   440,    -1,    -1,
     521,   446,   522,    -1,   522,    -1,   945,    -1,   255,   196,
      -1,   255,   301,    -1,    -1,   525,    -1,   526,    -1,   525,
     526,    -1,   526,   525,    -1,    -1,   290,   161,   527,    -1,
     290,   393,   527,    -1,   268,    81,    -1,   327,    -1,   113,
      -1,   346,   156,    -1,   346,   281,    -1,   218,   439,   810,
     440,    -1,    -1,   407,   288,    -1,   408,   288,    -1,    -1,
     290,   129,   170,    -1,   290,   129,   161,   334,    -1,   290,
     129,   306,   334,    -1,    -1,   368,   813,    -1,    -1,   395,
     216,   368,   813,    -1,    -1,    -1,   137,   507,   367,   811,
     536,   535,   534,   705,    -1,   407,   288,    94,    -1,   408,
     288,    94,    -1,    94,    -1,   439,   537,   440,    -1,    -1,
     537,   446,   538,    -1,   538,    -1,   945,    -1,   137,   507,
     342,   811,   541,    -1,    88,   342,   811,   541,    -1,   541,
     542,    -1,    -1,   111,   832,    -1,   149,    -1,   268,   149,
      -1,   215,   543,   832,    -1,   256,   832,    -1,   258,   832,
      -1,   268,   256,    -1,   268,   258,    -1,   355,   455,   832,
      -1,   326,   455,   832,    -1,   110,    -1,    -1,   137,   545,
     550,   238,   481,    -1,   137,   545,   550,   238,   481,   204,
     546,   547,   548,    -1,   384,    -1,    -1,   813,    -1,   813,
     586,    -1,   398,   546,    -1,    -1,   237,   830,    -1,    -1,
     170,   550,   238,   830,   494,    -1,   312,    -1,    -1,   137,
     368,   813,   552,   252,   825,    -1,   300,   813,    -1,    -1,
     170,   368,   813,    -1,   137,   380,   813,   555,   556,   290,
     811,   558,   181,   313,   813,   439,   561,   440,    -1,   137,
     132,   380,   813,    84,   556,   290,   811,   563,   564,   190,
     171,   333,   181,   313,   819,   439,   561,   440,    -1,   102,
      -1,    84,    -1,   557,    -1,   557,   294,   557,    -1,   557,
     294,   557,   294,   557,    -1,   224,    -1,   161,    -1,   393,
      -1,   190,   559,   560,    -1,    -1,   171,    -1,    -1,   333,
      -1,   356,    -1,   562,    -1,   561,   446,   562,    -1,    -1,
     834,    -1,   945,    -1,    -1,   195,   811,    -1,   565,    -1,
     565,   566,    -1,   566,    -1,   566,   565,    -1,   276,   158,
      -1,   158,    -1,   219,   210,    -1,   219,   159,    -1,   170,
     380,   813,   290,   811,   494,    -1,   137,    96,   813,   120,
     439,   766,   440,   564,    -1,   170,    96,   813,    -1,   137,
      85,   819,   572,    -1,   137,   292,   772,   572,    -1,   137,
     385,   585,   572,    -1,   137,   385,   585,    94,   571,    -1,
     439,   739,   440,    -1,   439,   573,   440,    -1,   574,    -1,
     573,   446,   574,    -1,   948,   426,   575,    -1,   948,    -1,
     624,    -1,   775,    -1,   833,    -1,   137,   292,   122,   585,
     579,   190,   385,   741,   395,   815,    94,   577,    -1,   578,
      -1,   577,   446,   578,    -1,   292,   826,   637,   580,    -1,
     292,   826,   637,   439,   636,   440,   580,    -1,   197,   826,
     819,   617,    -1,   360,   741,    -1,   156,    -1,    -1,   317,
      -1,    -1,   170,   292,   122,   585,   395,   815,   494,    -1,
     170,   583,   584,   494,    -1,   367,    -1,   342,    -1,   403,
      -1,   216,    -1,   385,    -1,   168,    -1,   134,    -1,   337,
      -1,   585,    -1,   584,   446,   585,    -1,   945,    -1,   945,
     586,    -1,   441,   816,    -1,   586,   441,   816,    -1,   383,
     712,   810,    -1,   187,   589,   590,   813,   908,    -1,   187,
     589,   813,   908,    -1,   187,   590,   813,   908,    -1,   187,
     813,   908,    -1,   187,   589,   590,   813,    -1,   187,   589,
     813,    -1,   187,   590,   813,    -1,   187,   813,    -1,   261,
     589,   590,   813,    -1,   261,   813,    -1,   267,    -1,   310,
      -1,   188,    -1,   240,    -1,    79,   827,    -1,   320,   827,
      -1,   827,    -1,    86,    -1,   193,    -1,   193,   827,    -1,
     193,    86,    -1,   101,    -1,   101,   827,    -1,   101,    86,
      -1,   213,    -1,   195,    -1,   128,   290,   592,   813,   232,
     593,    -1,   128,   290,    85,   819,   439,   634,   440,   232,
     593,    -1,   128,   290,   197,   819,   617,   232,   593,    -1,
     128,   290,   292,   772,   439,   636,   440,   232,   593,    -1,
     128,   290,   380,   813,   290,   585,   232,   593,    -1,   128,
     290,   335,   813,   290,   585,   232,   593,    -1,   128,   290,
     335,   813,   232,   593,    -1,   128,   290,   292,   122,   585,
     395,   815,   232,   593,    -1,   128,   290,   239,   284,   832,
     232,   593,    -1,   128,   290,   115,   439,   741,    94,   741,
     440,   232,   593,    -1,   128,   290,   550,   238,   585,   232,
     593,    -1,   127,    -1,   150,    -1,   337,    -1,   216,    -1,
     342,    -1,   367,    -1,   168,    -1,   385,    -1,   403,    -1,
     134,    -1,   830,    -1,   281,    -1,   200,   596,   290,   599,
     375,   600,   602,    -1,   329,   596,   290,   599,   195,   600,
     494,    -1,   329,   200,   293,   190,   596,   290,   599,   195,
     600,   494,    -1,    86,   311,    -1,    86,    -1,   597,    -1,
     598,    -1,   597,   446,   598,    -1,   341,    -1,   318,    -1,
     137,    -1,   945,    -1,   810,    -1,   367,   810,    -1,   197,
     603,    -1,   150,   812,    -1,   238,   812,    -1,   337,   812,
      -1,   368,   812,    -1,   601,    -1,   600,   446,   601,    -1,
     835,    -1,   203,   835,    -1,   407,   200,   293,    -1,    -1,
     604,    -1,   603,   446,   604,    -1,   819,   617,    -1,   200,
     597,   375,   812,   607,   608,    -1,   329,   597,   195,   812,
     608,   494,    -1,   407,    83,   293,    -1,    -1,   201,   110,
     835,    -1,    -1,   137,   610,   216,   817,   290,   811,   611,
     439,   612,   440,   531,   738,    -1,   389,    -1,    -1,   395,
     815,    -1,    -1,   613,    -1,   612,   446,   613,    -1,   945,
     614,    -1,   769,   614,    -1,   439,   766,   440,   614,    -1,
     585,    -1,   395,   585,    -1,    -1,   137,   616,   197,   819,
     617,   328,   623,   625,   628,    -1,   137,   616,   197,   819,
     617,   625,   628,    -1,   294,   324,    -1,    -1,   439,   618,
     440,    -1,   439,   440,    -1,   619,    -1,   618,   446,   619,
      -1,   620,   622,   624,    -1,   622,   620,   624,    -1,   622,
     624,    -1,   620,   624,    -1,   624,    -1,   213,    -1,   296,
      -1,   221,    -1,   213,   296,    -1,   830,    -1,   830,   446,
     830,    -1,   947,    -1,   624,    -1,   741,    -1,   946,   586,
     434,   385,    -1,   627,    -1,   625,   627,    -1,   112,   290,
     281,   222,    -1,   328,   281,   290,   281,   222,    -1,   361,
      -1,   211,    -1,   354,    -1,   404,    -1,   184,   340,   160,
      -1,   184,   340,   231,    -1,   340,   160,    -1,   340,   231,
      -1,    94,   621,    -1,   238,   481,    -1,   626,    -1,   407,
     572,    -1,    -1,    88,   197,   604,   630,   631,    -1,   626,
      -1,   630,   626,    -1,   327,    -1,    -1,   170,   197,   819,
     617,   494,    -1,   170,    85,   819,   439,   634,   440,   494,
      -1,   741,    -1,   432,    -1,   170,   292,   772,   439,   636,
     440,   494,    -1,   741,    -1,   741,   446,   741,    -1,   274,
     446,   741,    -1,   741,   446,   274,    -1,   772,    -1,   945,
     441,   637,    -1,   137,   115,   439,   741,    94,   741,   440,
     407,   197,   604,   639,    -1,   137,   115,   439,   741,    94,
     741,   440,   408,   197,   639,    -1,    94,    97,    -1,    -1,
     170,   115,   439,   741,    94,   741,   440,   494,    -1,   319,
     642,   811,   643,    -1,   319,   366,   813,   643,    -1,   319,
     150,   813,   643,    -1,   216,    -1,   367,    -1,   191,    -1,
      -1,    88,    85,   819,   439,   634,   440,   322,   375,   813,
      -1,    88,   134,   585,   322,   375,   813,    -1,    88,   150,
     814,   322,   375,   814,    -1,    88,   197,   819,   617,   322,
     375,   813,    -1,    88,   203,   835,   322,   375,   835,    -1,
      88,   238,   813,   322,   375,   813,    -1,    88,   292,   122,
     585,   395,   815,   322,   375,   813,    -1,    88,   337,   813,
     322,   375,   813,    -1,    88,   367,   736,   322,   375,   813,
      -1,    88,   216,   736,   322,   375,   813,    -1,    88,   367,
     736,   322,   645,   813,   375,   813,    -1,    88,   380,   813,
     290,   736,   322,   375,   813,    -1,    88,   394,   835,   322,
     375,   835,    -1,    88,   368,   813,   322,   375,   813,    -1,
     127,    -1,    -1,    88,    85,   819,   439,   634,   440,   346,
     337,   813,    -1,    88,   168,   585,   346,   337,   813,    -1,
      88,   197,   819,   617,   346,   337,   813,    -1,    88,   342,
     736,   346,   337,   813,    -1,    88,   367,   736,   346,   337,
     813,    -1,    88,   385,   585,   346,   337,   813,    -1,    88,
      85,   819,   439,   634,   440,   300,   375,   835,    -1,    88,
     134,   585,   300,   375,   835,    -1,    88,   150,   814,   300,
     375,   835,    -1,    88,   168,   814,   300,   375,   835,    -1,
      88,   197,   819,   617,   300,   375,   835,    -1,    88,   292,
     637,   439,   636,   440,   300,   375,   835,    -1,    88,   292,
     122,   585,   395,   815,   300,   375,   835,    -1,    88,   337,
     813,   300,   375,   835,    -1,    88,   385,   585,   300,   375,
     835,    -1,    88,   368,   813,   300,   375,   835,    -1,    -1,
     137,   616,   335,   813,    94,   649,   290,   654,   375,   811,
     738,   167,   655,   650,    -1,   277,    -1,   652,    -1,   439,
     651,   440,    -1,   651,   442,   653,    -1,   653,    -1,   705,
      -1,   691,    -1,   701,    -1,   695,    -1,   657,    -1,   652,
      -1,    -1,   341,    -1,   393,    -1,   161,    -1,   224,    -1,
     225,    -1,    87,    -1,    -1,   170,   335,   813,   290,   811,
     494,    -1,   278,   811,    -1,   247,   811,    -1,   391,   811,
      -1,   391,   432,    -1,    78,   661,    -1,   103,   661,   664,
      -1,   355,   378,   664,    -1,   129,   661,    -1,   176,   661,
      -1,   332,   661,    -1,   336,   945,    -1,   321,   336,   945,
      -1,   321,   945,    -1,   332,   661,   375,   336,   945,    -1,
     332,   661,   375,   945,    -1,   307,   378,   830,    -1,   129,
     308,   830,    -1,   332,   308,   830,    -1,   409,    -1,   378,
      -1,    -1,   234,   244,   476,    -1,   315,   291,    -1,   315,
     410,    -1,   662,    -1,   663,   446,   662,    -1,   663,   662,
      -1,   663,    -1,    -1,   137,   507,   403,   811,   520,    94,
     705,    -1,   137,   294,   324,   507,   403,   811,   520,    94,
     705,    -1,   248,   818,    -1,   137,   150,   814,   407,   668,
      -1,   137,   150,   814,    -1,   669,    -1,   668,   669,    -1,
     368,   670,   813,    -1,   368,   670,   156,    -1,   252,   670,
     830,    -1,   252,   670,   156,    -1,   370,   670,   813,    -1,
     370,   670,   156,    -1,   174,   670,   831,    -1,   174,   670,
     156,    -1,   131,   246,   670,   826,    -1,   300,   670,   813,
      -1,   300,   670,   156,    -1,   426,    -1,    -1,    88,   150,
     814,   455,   673,    -1,    88,   150,   814,   346,   472,    -1,
      88,   150,   814,   483,    -1,   673,   674,    -1,    -1,   131,
     246,   670,   826,    -1,   170,   150,   814,    -1,   137,   168,
     585,   678,   741,   512,    -1,    88,   168,   585,   493,    -1,
      88,   168,   585,   170,   276,   281,    -1,    88,   168,   585,
     346,   276,   281,    -1,    88,   168,   585,    82,   518,    -1,
      88,   168,   585,   170,   132,   813,   494,    -1,    94,    -1,
      -1,   137,   579,   134,   585,   190,   830,   375,   830,   195,
     585,    -1,   124,   817,   290,   811,    -1,   124,   811,    -1,
     124,    -1,   396,   685,   686,   684,    -1,   396,   685,   686,
     684,   811,    -1,   396,   685,   686,   684,   682,    -1,   683,
     684,    -1,   683,   684,   811,   687,    -1,    90,    -1,    89,
      -1,   402,    -1,    -1,   196,    -1,    -1,   194,    -1,    -1,
     439,   812,   440,    -1,    -1,   183,   690,   684,   689,    -1,
     705,    -1,   691,    -1,   701,    -1,   695,    -1,   702,    -1,
     683,    -1,    -1,   224,   230,   811,   692,    -1,   399,   439,
     807,   440,    -1,   156,   399,    -1,   705,    -1,   439,   693,
     440,   399,   439,   807,   440,    -1,   439,   693,   440,   705,
      -1,   693,   446,   694,    -1,   694,    -1,   945,   799,    -1,
     161,   195,   736,   696,   738,    -1,   395,   729,    -1,    -1,
     253,   712,   810,   698,   700,    -1,   213,   699,   259,    -1,
      -1,    80,   348,    -1,   333,   348,    -1,   333,   179,    -1,
     348,   393,   179,    -1,   348,    -1,   348,   333,   179,    -1,
     179,    -1,    80,   179,    -1,   280,    -1,    -1,   393,   736,
     346,   803,   728,   738,    -1,   155,   813,   703,   148,   704,
     190,   705,    -1,    -1,   703,   106,    -1,   703,   223,    -1,
     703,   338,    -1,   703,   268,   338,    -1,    -1,   407,   207,
      -1,   408,   207,    -1,   707,    -1,   706,    -1,   439,   707,
     440,    -1,   439,   706,   440,    -1,   709,    -1,   708,   716,
      -1,   708,   715,   725,   720,    -1,   708,   715,   719,   726,
      -1,   709,    -1,   706,    -1,   341,   714,   801,   710,   728,
     738,   723,   724,    -1,   708,   388,   713,   708,    -1,   708,
     228,   713,   708,    -1,   708,   178,   713,   708,    -1,   230,
     711,    -1,   908,    -1,    -1,   371,   712,   811,    -1,   369,
     712,   811,    -1,   249,   371,   712,   811,    -1,   249,   369,
     712,   811,    -1,   199,   371,   712,   811,    -1,   199,   369,
     712,   811,    -1,   367,   811,    -1,   811,    -1,   367,    -1,
      -1,    86,    -1,    -1,   166,    -1,   166,   290,   439,   777,
     440,    -1,    86,    -1,    -1,   716,    -1,    -1,   295,   110,
     717,    -1,   718,    -1,   717,   446,   718,    -1,   766,   395,
     775,    -1,   766,    95,    -1,   766,   164,    -1,   766,    -1,
     246,   721,   287,   722,    -1,   287,   722,   246,   721,    -1,
     246,   721,    -1,   287,   722,    -1,   246,   721,   446,   722,
      -1,   719,    -1,    -1,   766,    -1,    86,    -1,   766,    -1,
     203,   110,   777,    -1,    -1,   205,   766,    -1,    -1,   190,
     393,   727,   700,    -1,   190,   348,   727,   700,    -1,   190,
     315,   291,    -1,   725,    -1,    -1,   285,   812,    -1,    -1,
     195,   729,    -1,    -1,   729,   446,   730,    -1,   730,    -1,
     736,    -1,   736,   732,    -1,   737,    -1,   737,   732,    -1,
     737,    94,   439,   739,   440,    -1,   737,    94,   945,   439,
     739,   440,    -1,   737,   945,   439,   739,   440,    -1,   706,
      -1,   706,   732,    -1,   731,    -1,   439,   731,   440,   732,
      -1,   439,   731,   440,    -1,   730,   141,   235,   730,    -1,
     730,   413,   730,    -1,   730,   733,   235,   730,   735,    -1,
     730,   235,   730,   735,    -1,   730,   264,   733,   235,   730,
      -1,   730,   264,   235,   730,    -1,    94,   945,   439,   812,
     440,    -1,    94,   945,    -1,   945,   439,   812,   440,    -1,
     945,    -1,   196,   734,    -1,   243,   734,    -1,   330,   734,
      -1,   220,    -1,   297,    -1,    -1,   395,   439,   812,   440,
      -1,   290,   766,    -1,   811,    -1,   811,   432,    -1,   291,
     811,    -1,   291,   439,   811,   440,    -1,   769,    -1,   406,
     766,    -1,    -1,   740,    -1,   739,   446,   740,    -1,   945,
     741,    -1,   744,   742,    -1,   347,   744,   742,    -1,   744,
      93,   437,   826,   438,    -1,   347,   744,    93,   437,   826,
     438,    -1,   437,   438,   742,    -1,   437,   743,   438,   742,
      -1,    -1,   826,    -1,   439,   743,   440,    -1,   743,   430,
     743,    -1,   743,   431,   743,    -1,   743,   432,   743,    -1,
     743,   433,   743,    -1,   743,   434,   743,    -1,   825,    -1,
     945,    -1,   746,    -1,   762,    -1,   747,    -1,   751,    -1,
     755,    -1,   763,   765,    -1,   763,   439,   826,   440,   765,
      -1,   946,   586,    -1,   746,    -1,   762,    -1,   747,    -1,
     752,    -1,   756,    -1,   946,    -1,   226,    -1,   227,    -1,
     352,    -1,   105,    -1,   316,    -1,   189,   748,    -1,   169,
     305,    -1,   154,   750,    -1,   153,   750,    -1,   283,   749,
      -1,   108,    -1,   439,   826,   440,    -1,    -1,   439,   826,
     446,   826,   440,    -1,   439,   826,   440,    -1,    -1,   439,
     826,   446,   826,   440,    -1,   439,   826,   440,    -1,    -1,
     753,    -1,   754,    -1,   753,    -1,   754,    -1,   107,   760,
     439,   826,   440,    -1,   107,   760,    -1,   757,    -1,   758,
      -1,   757,    -1,   758,    -1,   759,   439,   826,   440,   761,
      -1,   759,   761,    -1,   118,   760,    -1,   117,   760,    -1,
     400,    -1,   263,   118,   760,    -1,   263,   117,   760,    -1,
     265,   760,    -1,   401,    -1,    -1,   118,   346,   945,    -1,
      -1,   374,   439,   826,   440,   764,    -1,   374,   764,    -1,
     373,   439,   826,   440,   764,    -1,   373,   764,    -1,   229,
      -1,   407,   373,   412,    -1,   408,   373,   412,    -1,    -1,
     411,    -1,   260,    -1,   151,    -1,   208,    -1,   257,    -1,
     339,    -1,   411,   375,   260,    -1,   151,   375,   208,    -1,
     151,   375,   257,    -1,   151,   375,   339,    -1,   208,   375,
     257,    -1,   257,   375,   339,    -1,   208,   375,   339,    -1,
      -1,   768,    -1,   766,    77,   741,    -1,   766,    99,   373,
     412,   766,    -1,   430,   766,    -1,   431,   766,    -1,   766,
     430,   766,    -1,   766,   431,   766,    -1,   766,   432,   766,
      -1,   766,   433,   766,    -1,   766,   434,   766,    -1,   766,
     435,   766,    -1,   766,   427,   766,    -1,   766,   428,   766,
      -1,   766,   426,   766,    -1,   766,   774,   766,    -1,   774,
     766,    -1,   766,   774,    -1,   766,    91,   766,    -1,   766,
     294,   766,    -1,   276,   766,    -1,   766,   245,   766,    -1,
     766,   245,   766,   177,   766,    -1,   766,   276,   245,   766,
      -1,   766,   276,   245,   766,   177,   766,    -1,   766,   209,
     766,    -1,   766,   209,   766,   177,   766,    -1,   766,   276,
     209,   766,    -1,   766,   276,   209,   766,   177,   766,    -1,
     766,   350,   375,   766,    -1,   766,   350,   375,   766,   177,
     766,    -1,   766,   276,   350,   375,   766,    -1,   766,   276,
     350,   375,   766,   177,   766,    -1,   766,   233,    -1,   766,
     232,   281,    -1,   766,   279,    -1,   766,   232,   276,   281,
      -1,   766,   232,   382,    -1,   766,   232,   276,   382,    -1,
     766,   232,   186,    -1,   766,   232,   276,   186,    -1,   766,
     232,   390,    -1,   766,   232,   276,   390,    -1,   766,   232,
     166,   195,   766,    -1,   766,   232,   285,   439,   779,   440,
      -1,   766,   232,   276,   285,   439,   779,   440,    -1,   766,
     104,   800,   767,    91,   767,    -1,   766,   276,   104,   800,
     767,    91,   767,    -1,   766,   104,   364,   767,    91,   767,
      -1,   766,   276,   104,   364,   767,    91,   767,    -1,   766,
     213,   790,    -1,   766,   276,   213,   790,    -1,   766,   776,
     771,   706,    -1,   766,   776,   771,   439,   766,   440,    -1,
     389,   706,    -1,   768,    -1,   767,    77,   741,    -1,   431,
     767,    -1,   767,   430,   767,    -1,   767,   431,   767,    -1,
     767,   432,   767,    -1,   767,   433,   767,    -1,   767,   434,
     767,    -1,   767,   435,   767,    -1,   767,   427,   767,    -1,
     767,   428,   767,    -1,   767,   426,   767,    -1,   767,   416,
     767,    -1,   774,   767,    -1,   767,   774,    -1,   767,   232,
     166,   195,   767,    -1,   767,   232,   285,   439,   767,   440,
      -1,   767,   232,   276,   285,   439,   767,   440,    -1,   796,
      -1,   820,    -1,   424,   799,    -1,   439,   766,   440,   799,
      -1,   791,    -1,   769,    -1,   706,    -1,   182,   706,    -1,
      93,   706,    -1,    93,   781,    -1,   770,    -1,   819,   439,
     440,    -1,   819,   439,   777,   440,    -1,   819,   439,    86,
     777,   440,    -1,   819,   439,   166,   777,   440,    -1,   819,
     439,   432,   440,    -1,   143,    -1,   145,    -1,   145,   439,
     826,   440,    -1,   146,    -1,   146,   439,   826,   440,    -1,
     250,    -1,   250,   439,   826,   440,    -1,   251,    -1,   251,
     439,   826,   440,    -1,   144,    -1,   147,    -1,   345,    -1,
     394,    -1,   115,   439,   766,    94,   741,   440,    -1,   185,
     439,   778,   440,    -1,   299,   439,   783,   440,    -1,   304,
     439,   785,   440,    -1,   362,   439,   786,   440,    -1,   379,
     439,   766,    94,   741,   440,    -1,   381,   439,   109,   789,
     440,    -1,   381,   439,   241,   789,   440,    -1,   381,   439,
     377,   789,   440,    -1,   381,   439,   789,   440,    -1,   135,
     439,   766,   395,   585,   440,    -1,   135,   439,   777,   440,
      -1,   282,   439,   766,   446,   766,   440,    -1,   125,   439,
     777,   440,    -1,   202,   439,   777,   440,    -1,   242,   439,
     777,   440,    -1,   333,   439,   777,   440,    -1,   333,   439,
     440,    -1,   439,   777,   446,   766,   440,    -1,    92,    -1,
     353,    -1,    86,    -1,   416,    -1,   773,    -1,   430,    -1,
     431,    -1,   432,    -1,   434,    -1,   435,    -1,   433,    -1,
     427,    -1,   428,    -1,   426,    -1,   416,    -1,   292,   439,
     637,   440,    -1,   772,    -1,   292,   439,   637,   440,    -1,
     772,    -1,   292,   439,   637,   440,    -1,   245,    -1,   276,
     245,    -1,   209,    -1,   276,   209,    -1,   766,    -1,   777,
     446,   766,    -1,   782,   195,   766,    -1,    -1,   779,   446,
     741,    -1,   741,    -1,   781,    -1,   780,   446,   781,    -1,
     437,   777,   438,    -1,   437,   780,   438,    -1,   966,    -1,
     411,    -1,   260,    -1,   151,    -1,   208,    -1,   257,    -1,
     339,    -1,   830,    -1,   766,   784,   787,   788,    -1,   766,
     784,   787,    -1,   303,   766,    -1,   767,   213,   767,    -1,
      -1,   766,   787,   788,    -1,   766,   788,   787,    -1,   766,
     787,    -1,   766,   788,    -1,   777,    -1,    -1,   195,   766,
      -1,   190,   766,    -1,   766,   195,   777,    -1,   195,   777,
      -1,   777,    -1,   706,    -1,   439,   777,   440,    -1,   114,
     795,   792,   794,   176,    -1,   792,   793,    -1,   793,    -1,
     405,   766,   372,   766,    -1,   172,   766,    -1,    -1,   766,
      -1,    -1,   809,    -1,   809,   798,    -1,   441,   816,    -1,
     441,   432,    -1,   437,   766,   438,    -1,   437,   766,   447,
     766,   438,    -1,   797,    -1,   798,   797,    -1,    -1,   799,
     797,    -1,    98,    -1,    -1,   801,   446,   802,    -1,   802,
      -1,   766,    94,   948,    -1,   766,    -1,   432,    -1,   803,
     446,   806,    -1,   439,   804,   440,   426,   439,   805,   440,
      -1,   806,    -1,   945,   799,    -1,   945,   799,   446,   804,
      -1,   766,    -1,   766,   446,   805,    -1,   945,   799,   426,
     766,    -1,   945,   799,   426,   156,    -1,   807,   446,   808,
      -1,   808,    -1,   766,    -1,   156,    -1,   836,    -1,   945,
      -1,   811,    -1,   810,   446,   811,    -1,   809,    -1,   809,
     798,    -1,   813,    -1,   812,   446,   813,    -1,   945,    -1,
     945,    -1,   945,    -1,   948,    -1,   945,    -1,   830,    -1,
     947,    -1,   809,   798,    -1,   834,    -1,   745,   830,    -1,
     763,   830,   765,    -1,   763,   439,   826,   440,   830,   765,
      -1,   382,    -1,   186,    -1,   281,    -1,   962,    -1,   423,
      -1,   425,    -1,   421,    -1,   422,    -1,   415,    -1,   821,
      -1,   963,    -1,   826,    -1,   431,   826,    -1,   821,    -1,
     965,    -1,   822,    -1,   828,    -1,   431,   822,    -1,   431,
     821,    -1,   825,    -1,   825,    -1,   963,    -1,   821,    -1,
     825,    -1,   963,    -1,   822,    -1,   821,    -1,   431,   822,
      -1,   431,   821,    -1,   963,    -1,   825,    -1,   832,    -1,
     825,    -1,   822,    -1,   821,    -1,   823,    -1,   824,    -1,
     963,    -1,   945,    -1,   289,    -1,   266,    -1,     9,   375,
     838,   844,   845,    -1,     9,   375,   156,    -1,     9,   846,
      -1,   150,   838,    -1,   814,   841,   843,    -1,   839,   447,
     840,   843,   433,   814,   849,    -1,   825,    -1,   848,    -1,
     966,   965,    -1,   416,   842,    -1,   840,    -1,    -1,   945,
      -1,   945,   441,   842,    -1,   420,    -1,   447,   826,    -1,
      -1,    94,   838,    -1,    -1,   394,   846,    -1,    -1,   847,
      -1,   847,   433,   847,    -1,   847,    25,   110,   847,    -1,
     847,   395,   847,    -1,   835,    -1,   830,    -1,   965,    -1,
     416,   945,    -1,    -1,   155,   813,   703,   148,   704,   190,
     900,    -1,   152,   307,   900,    -1,   152,   900,    -1,   853,
      -1,   867,    -1,   854,    -1,    -1,   872,   875,   855,   888,
     442,    -1,    -1,   875,   856,   888,   442,    -1,   878,   442,
      -1,   832,    -1,   446,   832,    -1,    -1,   765,    -1,   411,
     375,   257,    -1,   411,   375,   339,    -1,   151,   375,   151,
      -1,   260,   375,   260,    -1,    -1,   862,   861,   864,   863,
      -1,   959,   103,   155,    39,   442,    -1,   959,   176,   155,
      39,   442,    -1,    -1,   865,    -1,   419,    -1,   869,    -1,
     867,    -1,   865,   869,    -1,   865,   867,    -1,   865,   419,
      -1,   869,    -1,   866,   869,    -1,    -1,    76,   868,   875,
     891,   949,   742,   442,    -1,    -1,   872,   875,   870,   888,
     442,    -1,    -1,   875,   871,   888,   442,    -1,   878,   442,
      -1,   873,   874,    -1,   873,    -1,   874,    -1,    62,    -1,
      73,    -1,    71,    -1,    56,    -1,    57,    -1,    75,    -1,
     884,    -1,   880,    -1,   876,    -1,   949,   439,   857,   858,
     440,    -1,   949,   859,    -1,   882,    -1,    20,   944,   877,
      -1,    20,   877,    -1,    20,   944,    -1,   443,   970,   444,
      -1,    -1,   882,   879,   443,   866,   444,    -1,   878,    -1,
      -1,   883,   881,   443,   866,   444,    -1,    48,   944,    -1,
     388,   944,    -1,    48,    -1,   388,    -1,   885,    -1,   887,
     886,    -1,    49,    40,    -1,    49,    40,   226,    -1,    49,
      -1,    49,   226,    -1,    49,    29,    -1,    49,    29,   226,
      -1,    49,    29,    29,    -1,    49,    29,    29,   226,    -1,
      49,   117,    -1,    40,    -1,    40,   226,    -1,   226,    -1,
      29,    -1,    29,   226,    -1,    29,    29,    -1,    29,    29,
     226,    -1,     5,    -1,   117,    -1,   169,    -1,    41,    -1,
      -1,   889,    -1,   888,   446,   889,    -1,   891,   950,   742,
     890,    -1,    -1,   426,   971,    -1,    -1,   432,    -1,   432,
     432,    -1,   155,   356,   966,    -1,    19,   894,    -1,   895,
      -1,    13,    -1,    86,    -1,    -1,   838,    -1,   156,    -1,
     181,   210,   899,    -1,    -1,   181,   900,   897,   898,    -1,
     904,   908,    -1,   908,   904,    -1,   904,    -1,   908,    -1,
      -1,   848,    -1,   417,    -1,   813,    -1,   848,    -1,    22,
     813,    -1,    33,   813,   903,    -1,    -1,   904,    -1,   395,
     909,    -1,   905,    -1,   395,   907,    18,   967,    -1,   230,
     907,    18,   967,    -1,    -1,    42,    -1,   230,   958,    -1,
     906,    -1,   910,    -1,   910,   446,   909,    -1,   833,    -1,
     962,    -1,   307,   900,   195,   899,    -1,    17,   222,   813,
     905,    -1,    17,   913,   813,   905,    -1,    17,   913,   813,
     906,    -1,    34,    -1,    -1,     3,    18,   967,    -1,   152,
      18,   967,    -1,   198,    18,   967,   917,    -1,   918,    -1,
     917,   446,   918,    -1,   965,   426,   922,    -1,   346,    18,
     967,   920,    -1,   921,    -1,   920,   446,   921,    -1,   922,
     426,   828,    -1,    12,    -1,   198,    18,   967,    50,   828,
     924,    -1,   925,    -1,   924,   446,   925,    -1,   965,   426,
     929,    -1,   346,    18,   967,    50,   828,   927,    -1,   928,
      -1,   927,   446,   928,    -1,   929,   426,   829,    -1,     8,
      -1,    14,    -1,    15,    -1,    16,    -1,    26,    -1,    27,
      -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,   305,
      -1,    36,    -1,    37,    -1,    38,    -1,   385,    -1,   346,
       4,   426,   931,    -1,   346,     4,   375,   931,    -1,   290,
      -1,   286,    -1,   346,    10,   375,   895,    -1,   346,    10,
     426,   895,    -1,   346,    10,   895,    -1,    -1,   385,   934,
     949,   232,   875,   742,   935,    -1,    35,    -1,    -1,    -1,
      51,   937,   948,   232,   875,   742,   935,    -1,    52,    43,
     939,    -1,    52,   276,    21,   939,    -1,    52,    45,   939,
      -1,    11,    -1,    44,    -1,    47,    -1,    24,   813,    -1,
      23,   375,   813,    -1,   167,   813,   439,   960,   440,    -1,
     167,     6,    -1,     7,   813,   439,   960,   440,    -1,     7,
     813,    -1,   941,    -1,   942,    -1,     6,    -1,     7,    -1,
       8,    -1,    11,    -1,    12,    -1,    14,    -1,    15,    -1,
      16,    -1,    21,    -1,    23,    -1,    24,    -1,    25,    -1,
      26,    -1,    27,    -1,    28,    -1,    30,    -1,    31,    -1,
      32,    -1,    36,    -1,    37,    -1,    38,    -1,    39,    -1,
      43,    -1,    44,    -1,    45,    -1,    47,    -1,    50,    -1,
       9,    -1,    17,    -1,    19,    -1,    33,    -1,    51,    -1,
      52,    -1,     5,    -1,    29,    -1,    34,    -1,    40,    -1,
      48,    -1,    41,    -1,    49,    -1,   948,    -1,   966,    -1,
     952,    -1,   955,    -1,   940,    -1,   951,    -1,   117,    -1,
     966,    -1,   952,    -1,   940,    -1,   943,    -1,   951,    -1,
     966,    -1,   952,    -1,   956,    -1,   940,    -1,   951,    -1,
     950,    -1,   943,    -1,   117,    -1,   222,    -1,   226,    -1,
     388,    -1,   375,    -1,   951,    -1,   953,    -1,   966,    -1,
     955,    -1,   956,    -1,   941,    -1,   949,    -1,   957,    -1,
     954,    -1,   942,    -1,    56,    -1,    57,    -1,    62,    -1,
      71,    -1,    73,    -1,    76,    -1,    75,    -1,   953,    -1,
     954,    -1,   151,    -1,   208,    -1,   257,    -1,   260,    -1,
     339,    -1,   411,    -1,    78,    -1,    79,    -1,    80,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    85,    -1,
      87,    -1,    88,    -1,    96,    -1,    97,    -1,    99,    -1,
     101,    -1,   102,    -1,   103,    -1,   110,    -1,   111,    -1,
     113,    -1,   116,    -1,   119,    -1,   121,    -1,   122,    -1,
     123,    -1,   124,    -1,   128,    -1,   129,    -1,   130,    -1,
     131,    -1,   133,    -1,   134,    -1,   136,    -1,   138,    -1,
     139,    -1,   140,    -1,   142,    -1,   148,    -1,   149,    -1,
     150,    -1,   152,    -1,   155,    -1,   157,    -1,   159,    -1,
     161,    -1,   162,    -1,   163,    -1,   165,    -1,   168,    -1,
     169,    -1,   170,    -1,   171,    -1,   173,    -1,   174,    -1,
     175,    -1,   177,    -1,   180,    -1,   179,    -1,   181,    -1,
     183,    -1,   187,    -1,   188,    -1,   191,    -1,   193,    -1,
     197,    -1,   199,    -1,   201,    -1,   204,    -1,   206,    -1,
     207,    -1,   210,    -1,   211,    -1,   212,    -1,   214,    -1,
     215,    -1,   216,    -1,   217,    -1,   218,    -1,   223,    -1,
     224,    -1,   225,    -1,   234,    -1,   236,    -1,   237,    -1,
     238,    -1,   239,    -1,   240,    -1,   244,    -1,   247,    -1,
     248,    -1,   249,    -1,   252,    -1,   253,    -1,   254,    -1,
     255,    -1,   256,    -1,   258,    -1,   259,    -1,   261,    -1,
     262,    -1,   267,    -1,   268,    -1,   269,    -1,   270,    -1,
     271,    -1,   272,    -1,   273,    -1,   275,    -1,   277,    -1,
     278,    -1,   280,    -1,   284,    -1,   285,    -1,   288,    -1,
     292,    -1,   293,    -1,   300,    -1,   301,    -1,   302,    -1,
     307,    -1,   308,    -1,   306,    -1,   310,    -1,   311,    -1,
     312,    -1,   313,    -1,   314,    -1,   315,    -1,   317,    -1,
     319,    -1,   320,    -1,   321,    -1,   322,    -1,   323,    -1,
     324,    -1,   325,    -1,   326,    -1,   327,    -1,   328,    -1,
     329,    -1,   331,    -1,   332,    -1,   334,    -1,   335,    -1,
     336,    -1,   337,    -1,   338,    -1,   342,    -1,   343,    -1,
     344,    -1,   346,    -1,   348,    -1,   349,    -1,   351,    -1,
     354,    -1,   355,    -1,   356,    -1,   357,    -1,   358,    -1,
     359,    -1,   360,    -1,   363,    -1,   361,    -1,   366,    -1,
     365,    -1,   368,    -1,   369,    -1,   370,    -1,   371,    -1,
     376,    -1,   378,    -1,   380,    -1,   383,    -1,   384,    -1,
     385,    -1,   386,    -1,   387,    -1,   390,    -1,   391,    -1,
     392,    -1,   393,    -1,   396,    -1,   397,    -1,   399,    -1,
     401,    -1,   403,    -1,   407,    -1,   408,    -1,   409,    -1,
     410,    -1,   412,    -1,   105,    -1,   107,    -1,   118,    -1,
     125,    -1,   135,    -1,   153,    -1,   154,    -1,   182,    -1,
     185,    -1,   189,    -1,   202,    -1,   221,    -1,   227,    -1,
     229,    -1,   242,    -1,   263,    -1,   265,    -1,   274,    -1,
     282,    -1,   283,    -1,   296,    -1,   299,    -1,   304,    -1,
     305,    -1,   316,    -1,   333,    -1,   347,    -1,   352,    -1,
     362,    -1,   373,    -1,   374,    -1,   379,    -1,   381,    -1,
     400,    -1,   100,    -1,   104,    -1,   106,    -1,   141,    -1,
     194,    -1,   196,    -1,   209,    -1,   220,    -1,   232,    -1,
     233,    -1,   235,    -1,   243,    -1,   245,    -1,   264,    -1,
     279,    -1,   297,    -1,   298,    -1,   330,    -1,   350,    -1,
     402,    -1,    86,    -1,    89,    -1,    90,    -1,    91,    -1,
      92,    -1,    93,    -1,    94,    -1,    95,    -1,    98,    -1,
     109,    -1,   114,    -1,   115,    -1,   120,    -1,   126,    -1,
     127,    -1,   132,    -1,   137,    -1,   143,    -1,   145,    -1,
     146,    -1,   144,    -1,   147,    -1,   156,    -1,   158,    -1,
     164,    -1,   166,    -1,   167,    -1,   172,    -1,   176,    -1,
     178,    -1,   186,    -1,   190,    -1,   192,    -1,   195,    -1,
     200,    -1,   203,    -1,   205,    -1,   213,    -1,   219,    -1,
     228,    -1,   230,    -1,   241,    -1,   246,    -1,   266,    -1,
     276,    -1,   281,    -1,   286,    -1,   287,    -1,   289,    -1,
     290,    -1,   291,    -1,   294,    -1,   295,    -1,   309,    -1,
     318,    -1,   341,    -1,   345,    -1,   353,    -1,   364,    -1,
     367,    -1,   372,    -1,   377,    -1,   382,    -1,   389,    -1,
     394,    -1,   395,    -1,   405,    -1,   406,    -1,   961,    -1,
     958,   446,   961,    -1,    46,    -1,    -1,   970,    -1,   965,
     964,    -1,   965,    -1,   965,   964,    -1,   965,    -1,   965,
      -1,    26,   965,    -1,    26,   813,    -1,   418,    -1,   414,
      -1,   417,    -1,   813,    -1,   848,    -1,   973,    -1,   439,
     440,    -1,   439,   969,   440,    -1,   968,    -1,   969,   968,
      -1,   971,    -1,   970,   446,   971,    -1,   969,    -1,   443,
     970,   444,    -1,   973,    -1,   439,    -1,   440,    -1,   446,
      -1,   442,    -1,   414,    -1,   417,    -1,   821,    -1,   822,
      -1,   825,    -1,   432,    -1,   430,    -1,   431,    -1,   433,
      -1,   434,    -1,   281,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    59,    -1,    60,
      -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,    66,
      -1,    65,    -1,    67,    -1,    68,    -1,    69,    -1,    70,
      -1,    71,    -1,    72,    -1,    73,    -1,    74,    -1,    76,
      -1,    75,    -1,     5,    -1,    20,    -1,   208,    -1,   226,
      -1,    29,    -1,   257,    -1,   260,    -1,   339,    -1,    40,
      -1,    41,    -1,    48,    -1,    49,    -1,   411,    -1,   117,
      -1,   189,    -1,   375,    -1,   388,    -1,   400,    -1,   437,
      -1,   438,    -1,   426,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   603,   603,   605,   606,   609,   610,   611,   617,   618,
     619,   620,   621,   624,   636,   637,   638,   639,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,   672,
     673,   674,   675,   676,   677,   678,   679,   680,   681,   682,
     683,   684,   685,   686,   687,   688,   689,   690,   691,   692,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   703,
     704,   705,   706,   707,   708,   709,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   736,   737,   738,   739,   740,
     741,   742,   743,   744,   750,   760,   764,   772,   780,   784,
     795,   805,   809,   816,   823,   829,   837,   847,   853,   862,
     869,   875,   884,   891,   912,   916,   917,   926,   927,   928,
     929,   930,   931,   932,   933,   934,   935,   936,   937,   938,
     939,   940,   941,   942,   943,   944,   945,   946,   956,   970,
     974,   976,   986,   989,   991,  1001,  1011,  1021,  1031,  1035,
    1036,  1045,  1056,  1058,  1062,  1063,  1066,  1067,  1074,  1075,
    1076,  1077,  1078,  1079,  1092,  1094,  1096,  1100,  1102,  1104,
    1106,  1108,  1110,  1112,  1114,  1116,  1120,  1121,  1125,  1127,
    1131,  1133,  1137,  1138,  1139,  1140,  1143,  1144,  1145,  1148,
    1149,  1150,  1151,  1161,  1162,  1163,  1165,  1167,  1169,  1173,
    1174,  1175,  1178,  1179,  1182,  1184,  1186,  1188,  1190,  1194,
    1196,  1198,  1200,  1202,  1206,  1210,  1212,  1216,  1217,  1223,
    1234,  1236,  1242,  1243,  1247,  1251,  1254,  1257,  1260,  1263,
    1266,  1269,  1272,  1275,  1278,  1281,  1284,  1287,  1290,  1293,
    1296,  1299,  1302,  1305,  1309,  1310,  1316,  1319,  1324,  1325,
    1328,  1329,  1330,  1333,  1334,  1344,  1358,  1363,  1364,  1372,
    1373,  1374,  1377,  1378,  1381,  1382,  1383,  1385,  1387,  1388,
    1389,  1391,  1393,  1395,  1400,  1401,  1404,  1405,  1412,  1415,
    1418,  1419,  1429,  1432,  1442,  1443,  1444,  1445,  1446,  1447,
    1448,  1452,  1455,  1457,  1459,  1463,  1464,  1465,  1468,  1474,
    1475,  1478,  1480,  1481,  1495,  1497,  1499,  1501,  1503,  1505,
    1507,  1522,  1523,  1524,  1525,  1528,  1535,  1536,  1537,  1544,
    1546,  1550,  1552,  1554,  1556,  1561,  1562,  1565,  1567,  1571,
    1574,  1576,  1582,  1585,  1586,  1587,  1588,  1589,  1592,  1596,
    1600,  1601,  1602,  1603,  1604,  1607,  1610,  1613,  1614,  1615,
    1618,  1619,  1620,  1621,  1624,  1625,  1628,  1629,  1638,  1637,
    1655,  1656,  1657,  1661,  1664,  1667,  1669,  1673,  1684,  1688,
    1692,  1693,  1696,  1698,  1700,  1702,  1704,  1706,  1708,  1710,
    1712,  1714,  1718,  1719,  1730,  1732,  1737,  1738,  1745,  1746,
    1749,  1752,  1754,  1757,  1760,  1764,  1765,  1775,  1779,  1780,
    1794,  1805,  1810,  1818,  1819,  1822,  1824,  1826,  1830,  1831,
    1832,  1835,  1838,  1841,  1842,  1845,  1846,  1849,  1851,  1854,
    1857,  1858,  1861,  1862,  1865,  1866,  1873,  1874,  1883,  1885,
    1889,  1891,  1895,  1906,  1914,  1929,  1931,  1933,  1935,  1939,
    1943,  1947,  1948,  1951,  1952,  1956,  1957,  1958,  1961,  1968,
    1969,  1972,  1974,  1976,  1978,  1982,  1983,  1986,  1987,  1990,
    2002,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2016,
    2018,  2022,  2023,  2026,  2027,  2036,  2051,  2056,  2061,  2066,
    2071,  2076,  2081,  2086,  2091,  2093,  2097,  2098,  2099,  2100,
    2101,  2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,
    2113,  2114,  2117,  2119,  2121,  2123,  2125,  2127,  2129,  2131,
    2133,  2135,  2137,  2141,  2142,  2143,  2144,  2145,  2146,  2147,
    2148,  2149,  2150,  2153,  2154,  2164,  2168,  2172,  2179,  2180,
    2181,  2184,  2186,  2190,  2191,  2192,  2193,  2196,  2198,  2200,
    2202,  2204,  2206,  2208,  2212,  2214,  2218,  2219,  2222,  2227,
    2230,  2232,  2236,  2245,  2250,  2254,  2255,  2258,  2259,  2271,
    2276,  2277,  2280,  2283,  2286,  2287,  2290,  2292,  2294,  2298,
    2299,  2300,  2303,  2306,  2311,  2312,  2315,  2317,  2321,  2323,
    2327,  2328,  2329,  2330,  2331,  2334,  2335,  2336,  2337,  2340,
    2342,  2346,  2348,  2358,  2360,  2365,  2367,  2372,  2374,  2376,
    2378,  2380,  2382,  2384,  2386,  2388,  2390,  2393,  2395,  2397,
    2401,  2402,  2406,  2410,  2411,  2414,  2415,  2428,  2432,  2436,
    2437,  2441,  2445,  2447,  2449,  2451,  2456,  2458,  2462,  2465,
    2470,  2471,  2475,  2486,  2488,  2490,  2494,  2495,  2498,  2499,
    2510,  2512,  2514,  2516,  2518,  2520,  2522,  2524,  2526,  2528,
    2530,  2532,  2534,  2536,  2540,  2541,  2551,  2553,  2555,  2557,
    2559,  2561,  2571,  2573,  2575,  2577,  2579,  2581,  2583,  2585,
    2587,  2589,  2601,  2600,  2610,  2611,  2612,  2616,  2618,  2622,
    2623,  2624,  2625,  2626,  2629,  2630,  2634,  2635,  2636,  2637,
    2640,  2641,  2642,  2645,  2657,  2661,  2665,  2667,  2680,  2681,
    2682,  2683,  2684,  2685,  2686,  2687,  2688,  2689,  2690,  2691,
    2692,  2693,  2696,  2697,  2698,  2702,  2704,  2705,  2709,  2710,
    2711,  2715,  2716,  2726,  2728,  2740,  2752,  2754,  2758,  2760,
    2764,  2766,  2768,  2770,  2772,  2774,  2776,  2778,  2780,  2782,
    2784,  2788,  2789,  2800,  2804,  2806,  2811,  2812,  2816,  2826,
    2837,  2844,  2846,  2848,  2850,  2852,  2856,  2857,  2861,  2875,
    2877,  2879,  2892,  2894,  2896,  2900,  2902,  2906,  2907,  2910,
    2911,  2914,  2915,  2918,  2919,  2922,  2925,  2936,  2941,  2942,
    2943,  2944,  2945,  2949,  2950,  2999,  3003,  3005,  3007,  3009,
    3011,  3015,  3017,  3021,  3033,  3037,  3038,  3040,  3044,  3047,
    3050,  3051,  3052,  3053,  3054,  3055,  3056,  3057,  3060,  3061,
    3071,  3085,  3116,  3117,  3118,  3119,  3120,  3123,  3127,  3128,
    3138,  3140,  3144,  3146,  3150,  3152,  3154,  3156,  3160,  3161,
    3164,  3168,  3170,  3172,  3176,  3181,  3182,  3192,  3194,  3196,
    3198,  3200,  3202,  3204,  3206,  3210,  3211,  3214,  3215,  3218,
    3220,  3222,  3225,  3228,  3229,  3232,  3236,  3237,  3240,  3242,
    3244,  3246,  3250,  3252,  3254,  3256,  3258,  3262,  3263,  3266,
    3267,  3270,  3280,  3283,  3286,  3289,  3292,  3294,  3296,  3300,
    3301,  3305,  3306,  3317,  3318,  3321,  3322,  3332,  3334,  3336,
    3338,  3340,  3342,  3344,  3346,  3348,  3350,  3352,  3373,  3375,
    3377,  3379,  3381,  3383,  3385,  3389,  3391,  3393,  3395,  3399,
    3400,  3401,  3402,  3406,  3407,  3417,  3419,  3423,  3425,  3427,
    3429,  3433,  3436,  3437,  3440,  3442,  3446,  3459,  3461,  3463,
    3465,  3470,  3476,  3483,  3490,  3491,  3492,  3493,  3494,  3495,
    3496,  3497,  3498,  3501,  3502,  3503,  3504,  3505,  3506,  3508,
    3510,  3514,  3515,  3516,  3517,  3518,  3521,  3529,  3531,  3533,
    3535,  3537,  3539,  3541,  3543,  3545,  3547,  3549,  3553,  3556,
    3559,  3561,  3564,  3567,  3569,  3572,  3580,  3581,  3584,  3585,
    3588,  3592,  3601,  3602,  3605,  3606,  3609,  3613,  3617,  3619,
    3621,  3623,  3625,  3627,  3631,  3634,  3637,  3640,  3643,  3645,
    3647,  3649,  3653,  3657,  3659,  3662,  3665,  3666,  3667,  3668,
    3669,  3670,  3671,  3672,  3673,  3674,  3675,  3676,  3677,  3678,
    3704,  3706,  3708,  3719,  3721,  3723,  3725,  3727,  3729,  3731,
    3733,  3735,  3737,  3739,  3741,  3743,  3745,  3747,  3749,  3751,
    3753,  3755,  3757,  3759,  3761,  3763,  3765,  3767,  3769,  3771,
    3773,  3775,  3777,  3779,  3781,  3783,  3794,  3796,  3798,  3800,
    3802,  3804,  3806,  3808,  3810,  3812,  3814,  3816,  3818,  3820,
    3822,  3824,  3826,  3828,  3840,  3842,  3844,  3846,  3848,  3850,
    3852,  3854,  3856,  3858,  3860,  3862,  3864,  3866,  3868,  3870,
    3872,  3874,  3886,  3888,  3890,  3892,  3894,  3896,  3898,  3900,
    3902,  3904,  3906,  3918,  3920,  3922,  3924,  3926,  3928,  3930,
    3932,  3934,  3936,  3938,  3940,  3942,  3944,  3946,  3948,  3950,
    3952,  3954,  3956,  3958,  3960,  3962,  3964,  3967,  3969,  3971,
    3973,  3975,  3977,  3979,  3981,  3983,  3985,  3990,  3992,  3994,
    3998,  3999,  4000,  4003,  4004,  4007,  4008,  4009,  4010,  4011,
    4012,  4013,  4014,  4015,  4018,  4019,  4022,  4023,  4026,  4027,
    4028,  4029,  4030,  4031,  4034,  4036,  4040,  4043,  4046,  4048,
    4052,  4053,  4057,  4058,  4064,  4065,  4066,  4067,  4068,  4069,
    4070,  4071,  4075,  4077,  4082,  4086,  4089,  4092,  4094,  4096,
    4098,  4100,  4103,  4106,  4110,  4114,  4116,  4118,  4122,  4124,
    4131,  4135,  4137,  4141,  4145,  4148,  4151,  4152,  4155,  4156,
    4160,  4161,  4162,  4163,  4166,  4167,  4171,  4172,  4175,  4176,
    4185,  4187,  4192,  4194,  4196,  4201,  4203,  4227,  4231,  4240,
    4251,  4259,  4269,  4271,  4275,  4277,  4281,  4282,  4292,  4293,
    4296,  4298,  4302,  4304,  4308,  4310,  4315,  4316,  4317,  4318,
    4319,  4321,  4323,  4325,  4333,  4335,  4337,  4339,  4341,  4343,
    4345,  4347,  4351,  4352,  4353,  4354,  4355,  4366,  4367,  4370,
    4371,  4374,  4382,  4385,  4393,  4394,  4403,  4412,  4424,  4425,
    4428,  4429,  4430,  4433,  4434,  4435,  4436,  4437,  4440,  4441,
    4444,  4445,  4446,  4447,  4448,  4449,  4452,  4454,  4461,  4477,
    4479,  4482,  4484,  4488,  4496,  4512,  4519,  4525,  4537,  4546,
    4547,  4550,  4551,  4552,  4555,  4556,  4559,  4560,  4563,  4564,
    4567,  4569,  4571,  4573,  4577,  4584,  4607,  4639,  4649,  4656,
    4696,  4698,  4705,  4707,  4708,  4713,  4711,  4726,  4725,  4738,
    4744,  4746,  4747,  4750,  4751,  4752,  4753,  4754,  4761,  4760,
    4770,  4772,  4774,  4775,  4776,  4779,  4780,  4781,  4782,  4783,
    4786,  4787,  4791,  4790,  4851,  4849,  4864,  4863,  4876,  4882,
    4886,  4890,  4896,  4897,  4898,  4899,  4902,  4903,  4906,  4914,
    4931,  4939,  4962,  5056,  5090,  5092,  5094,  5098,  5102,  5101,
    5152,  5154,  5153,  5168,  5174,  5181,  5186,  5189,  5190,  5193,
    5194,  5195,  5196,  5197,  5198,  5199,  5207,  5215,  5218,  5219,
    5220,  5221,  5222,  5223,  5231,  5239,  5240,  5241,  5244,  5245,
    5248,  5250,  5254,  5325,  5326,  5333,  5334,  5335,  5341,  5350,
    5353,  5354,  5355,  5356,  5359,  5360,  5366,  5380,  5379,  5397,
    5398,  5399,  5400,  5401,  5404,  5406,  5410,  5411,  5418,  5423,
    5425,  5426,  5429,  5430,  5433,  5440,  5447,  5447,  5449,  5450,
    5453,  5453,  5455,  5465,  5474,  5480,  5486,  5492,  5500,  5501,
    5513,  5523,  5534,  5538,  5539,  5542,  5547,  5551,  5552,  5555,
    5562,  5569,  5573,  5574,  5577,  5580,  5584,  5585,  5588,  5595,
    5596,  5597,  5598,  5599,  5600,  5601,  5602,  5603,  5604,  5605,
    5606,  5607,  5608,  5609,  5639,  5640,  5643,  5644,  5651,  5652,
    5653,  5660,  5659,  5718,  5719,  5726,  5725,  5794,  5800,  5806,
    5814,  5820,  5826,  5832,  5838,  5844,  5850,  5856,  5862,  5873,
    5874,  5877,  5878,  5879,  5880,  5881,  5882,  5883,  5884,  5885,
    5886,  5887,  5888,  5889,  5890,  5891,  5892,  5893,  5894,  5895,
    5896,  5897,  5898,  5899,  5900,  5901,  5902,  5903,  5906,  5907,
    5908,  5909,  5910,  5911,  5915,  5916,  5917,  5918,  5919,  5920,
    5921,  5924,  5940,  5941,  5942,  5943,  5944,  5945,  5950,  5951,
    5952,  5953,  5954,  5959,  5960,  5961,  5962,  5963,  5969,  5970,
    5971,  5972,  5973,  5974,  5975,  5976,  5977,  5980,  5981,  5982,
    5983,  5986,  5987,  5988,  5989,  5992,  5993,  5994,  5995,  5996,
    5997,  5998,  6016,  6016,  6018,  6019,  6020,  6021,  6022,  6023,
    6026,  6027,  6028,  6029,  6030,  6031,  6032,  6033,  6034,  6035,
    6036,  6037,  6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,
    6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,
    6056,  6057,  6058,  6059,  6060,  6061,  6062,  6063,  6064,  6066,
    6067,  6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6076,
    6077,  6078,  6079,  6080,  6081,  6082,  6083,  6084,  6085,  6086,
    6087,  6088,  6089,  6090,  6091,  6092,  6093,  6094,  6095,  6097,
    6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,  6106,  6107,
    6108,  6109,  6110,  6111,  6112,  6113,  6114,  6115,  6116,  6117,
    6118,  6119,  6120,  6121,  6122,  6124,  6125,  6127,  6128,  6129,
    6130,  6131,  6132,  6133,  6134,  6135,  6136,  6137,  6138,  6139,
    6140,  6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,  6149,
    6150,  6151,  6152,  6153,  6154,  6155,  6156,  6157,  6158,  6159,
    6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,  6169,
    6170,  6171,  6172,  6173,  6174,  6175,  6177,  6178,  6179,  6180,
    6181,  6182,  6183,  6184,  6185,  6186,  6187,  6188,  6189,  6190,
    6191,  6192,  6193,  6194,  6195,  6196,  6197,  6198,  6199,  6200,
    6201,  6202,  6203,  6204,  6205,  6206,  6207,  6208,  6209,  6210,
    6211,  6212,  6213,  6214,  6215,  6216,  6217,  6218,  6219,  6221,
    6235,  6236,  6240,  6241,  6242,  6243,  6244,  6245,  6246,  6247,
    6248,  6249,  6253,  6254,  6255,  6256,  6257,  6258,  6259,  6260,
    6261,  6262,  6263,  6264,  6265,  6266,  6267,  6268,  6269,  6270,
    6271,  6272,  6273,  6274,  6288,  6289,  6290,  6291,  6292,  6293,
    6294,  6295,  6296,  6297,  6298,  6299,  6300,  6301,  6302,  6303,
    6304,  6305,  6306,  6307,  6317,  6318,  6319,  6320,  6321,  6322,
    6323,  6324,  6325,  6326,  6327,  6328,  6329,  6330,  6331,  6332,
    6333,  6334,  6335,  6336,  6337,  6338,  6339,  6340,  6341,  6342,
    6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,
    6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,
    6363,  6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,  6372,
    6373,  6374,  6375,  6376,  6377,  6381,  6382,  6386,  6387,  6388,
    6389,  6390,  6394,  6394,  6397,  6400,  6401,  6404,  6406,  6411,
    6421,  6428,  6429,  6430,  6433,  6462,  6463,  6466,  6468,  6476,
    6477,  6478,  6482,  6483,  6487,  6488,  6491,  6492,  6495,  6496,
    6497,  6498,  6499,  6502,  6503,  6504,  6505,  6506,  6507,  6508,
    6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,  6517,  6518,
    6519,  6520,  6521,  6522,  6523,  6524,  6525,  6526,  6527,  6528,
    6529,  6530,  6531,  6532,  6533,  6534,  6535,  6536,  6537,  6538,
    6539,  6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,
    6549,  6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", 
  "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", 
  "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", 
  "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", 
  "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", "SQL_WHENEVER", "S_ADD", 
  "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", "S_DEC", "S_DIV", 
  "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", "S_LSHIFT", "S_MEMPOINT", 
  "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", "S_OR", "S_REGISTER", 
  "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", "S_TYPEDEF", "TYPECAST", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", 
  "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", "CONVERT", 
  "COPY", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", 
  "CSV", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", 
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", 
  "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", 
  "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", "DISTINCT", "DO", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER", "HOLD", 
  "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", 
  "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", 
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", 
  "LOCATION", "LOCK_P", "LOGIN_P", "MATCH", "MAXVALUE", "MINUTE_P", 
  "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", 
  "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", 
  "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", 
  "STRICT_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", 
  "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", 
  "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", 
  "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR_P", "ZONE", 
  "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", "FCONST", 
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", 
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", "'}'", 
  "\"=\"", "','", "':'", "$accept", "prog", "statements", "statement", 
  "opt_at", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", 
  "add_drop", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list_or_default", "var_list", "iso_level", "var_value", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableShowStmt", "VariableResetStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "like_including_defaults", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWithOids", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "WithOidsAs", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_validator", 
  "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", "oper_argtypes", 
  "any_operator", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseStmt", "AlterDatabaseSetStmt", "alterdb_opt_list", 
  "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt", "AlterDomainStmt", 
  "opt_as", "CreateConversionStmt", "ClusterStmt", "VacuumStmt", 
  "AnalyzeStmt", "analyze_keyword", "opt_verbose", "opt_full", 
  "opt_freeze", "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "opt_analyze", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "locked_rels_list", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "target_list", "target_el", "update_target_list", "inf_col_list", 
  "inf_val_list", "update_target_el", "insert_target_list", 
  "insert_target_el", "relation_name", "qualified_name_list", 
  "qualified_name", "name_list", "name", "database_name", "access_method", 
  "attr_name", "index_name", "file_name", "func_name", "AexprConst", 
  "Iconst", "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", 
  "IntConst", "IntConstVar", "AllConstVar", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "RoleId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", "var_type", 
  "enum_type", "enum_definition", "struct_union_type_with_symbol", "@9", 
  "struct_union_type", "@10", "s_struct_union_symbol", "s_struct_union", 
  "simple_type", "unsigned_type", "signed_type", "opt_signed", 
  "variable_list", "variable", "opt_initializer", "opt_pointer", 
  "ECPGDeclare", "ECPGDisconnect", "dis_name", "connection_object", 
  "ECPGExecute", "@11", "execute_rest", "execstring", "prepared_name", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "ecpg_into", 
  "using_list", "UsingConst", "ECPGPrepare", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,    61,    60,    62,   681,
      43,    45,    42,    47,    37,    94,   682,    91,    93,    40,
      41,    46,    59,   123,   125,   683,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   448,   449,   450,   450,   451,   451,   451,   451,   451,
     451,   451,   451,   452,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   453,   453,   454,   455,   455,   456,   456,   456,
     456,   456,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   456,   456,   456,   456,   457,   458,
     459,   459,   460,   459,   459,   461,   462,   463,   464,   465,
     465,   466,   467,   467,   468,   468,   469,   469,   470,   470,
     470,   470,   470,   470,   471,   471,   471,   472,   472,   472,
     472,   472,   472,   472,   472,   472,   473,   473,   474,   474,
     475,   475,   476,   476,   476,   476,   477,   477,   477,   478,
     478,   478,   478,   479,   479,   479,   479,   479,   479,   480,
     480,   480,   481,   481,   482,   482,   482,   482,   482,   483,
     483,   483,   483,   483,   484,   485,   485,   486,   486,   487,
     488,   488,   489,   489,   490,   490,   490,   490,   490,   490,
     490,   490,   490,   490,   490,   490,   490,   490,   490,   490,
     490,   490,   490,   490,   491,   491,   492,   492,   493,   493,
     494,   494,   494,   495,   495,   496,   497,   498,   498,   499,
     499,   499,   500,   500,   501,   501,   501,   501,   501,   501,
     501,   501,   501,   501,   502,   502,   503,   503,   504,   504,
     505,   505,   506,   506,   507,   507,   507,   507,   507,   507,
     507,   508,   508,   509,   509,   510,   510,   510,   511,   512,
     512,   513,   513,   513,   514,   514,   514,   514,   514,   514,
     514,   515,   515,   515,   515,   516,   517,   517,   517,   518,
     518,   519,   519,   519,   519,   520,   520,   521,   521,   522,
     523,   523,   523,   524,   524,   524,   524,   524,   525,   526,
     527,   527,   527,   527,   527,   528,   528,   529,   529,   529,
     530,   530,   530,   530,   531,   531,   532,   532,   534,   533,
     535,   535,   535,   536,   536,   537,   537,   538,   539,   540,
     541,   541,   542,   542,   542,   542,   542,   542,   542,   542,
     542,   542,   543,   543,   544,   544,   545,   545,   546,   546,
     547,   547,   548,   548,   549,   550,   550,   551,   552,   552,
     553,   554,   554,   555,   555,   556,   556,   556,   557,   557,
     557,   558,   558,   559,   559,   560,   560,   561,   561,   561,
     562,   562,   563,   563,   564,   564,   564,   564,   565,   565,
     566,   566,   567,   568,   569,   570,   570,   570,   570,   571,
     572,   573,   573,   574,   574,   575,   575,   575,   576,   577,
     577,   578,   578,   578,   578,   579,   579,   580,   580,   581,
     582,   583,   583,   583,   583,   583,   583,   583,   583,   584,
     584,   585,   585,   586,   586,   587,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   589,   589,   589,   589,
     589,   589,   589,   589,   589,   589,   589,   589,   589,   589,
     590,   590,   591,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   592,   592,   592,   592,   592,
     592,   592,   592,   593,   593,   594,   595,   595,   596,   596,
     596,   597,   597,   598,   598,   598,   598,   599,   599,   599,
     599,   599,   599,   599,   600,   600,   601,   601,   602,   602,
     603,   603,   604,   605,   606,   607,   607,   608,   608,   609,
     610,   610,   611,   611,   612,   612,   613,   613,   613,   614,
     614,   614,   615,   615,   616,   616,   617,   617,   618,   618,
     619,   619,   619,   619,   619,   620,   620,   620,   620,   621,
     621,   622,   623,   624,   624,   625,   625,   626,   626,   626,
     626,   626,   626,   626,   626,   626,   626,   627,   627,   627,
     628,   628,   629,   630,   630,   631,   631,   632,   633,   634,
     634,   635,   636,   636,   636,   636,   637,   637,   638,   638,
     639,   639,   640,   641,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   645,   645,   646,   646,   646,   646,
     646,   646,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   649,   648,   650,   650,   650,   651,   651,   652,
     652,   652,   652,   652,   653,   653,   654,   654,   654,   654,
     655,   655,   655,   656,   657,   658,   659,   659,   660,   660,
     660,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   661,   661,   661,   662,   662,   662,   663,   663,
     663,   664,   664,   665,   665,   666,   667,   667,   668,   668,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   670,   670,   671,   672,   672,   673,   673,   674,   675,
     676,   677,   677,   677,   677,   677,   678,   678,   679,   680,
     680,   680,   681,   681,   681,   682,   682,   683,   683,   684,
     684,   685,   685,   686,   686,   687,   687,   688,   689,   689,
     689,   689,   689,   690,   690,   691,   692,   692,   692,   692,
     692,   693,   693,   694,   695,   696,   696,   697,   698,   698,
     699,   699,   699,   699,   699,   699,   699,   699,   700,   700,
     701,   702,   703,   703,   703,   703,   703,   704,   704,   704,
     705,   705,   706,   706,   707,   707,   707,   707,   708,   708,
     709,   709,   709,   709,   710,   710,   710,   711,   711,   711,
     711,   711,   711,   711,   711,   712,   712,   713,   713,   714,
     714,   714,   714,   715,   715,   716,   717,   717,   718,   718,
     718,   718,   719,   719,   719,   719,   719,   720,   720,   721,
     721,   722,   723,   723,   724,   724,   725,   725,   725,   726,
     726,   727,   727,   728,   728,   729,   729,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   731,   731,
     731,   731,   731,   731,   731,   732,   732,   732,   732,   733,
     733,   733,   733,   734,   734,   735,   735,   736,   736,   736,
     736,   737,   738,   738,   739,   739,   740,   741,   741,   741,
     741,   742,   742,   742,   743,   743,   743,   743,   743,   743,
     743,   743,   743,   744,   744,   744,   744,   744,   744,   744,
     744,   745,   745,   745,   745,   745,   746,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   748,   748,
     749,   749,   749,   750,   750,   750,   751,   751,   752,   752,
     753,   754,   755,   755,   756,   756,   757,   758,   759,   759,
     759,   759,   759,   759,   760,   760,   761,   761,   762,   762,
     762,   762,   763,   764,   764,   764,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   767,   767,   767,   767,   767,   767,
     767,   767,   767,   767,   767,   767,   767,   767,   767,   767,
     767,   767,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   769,   769,   769,   769,   769,   769,   769,
     769,   769,   769,   769,   769,   769,   769,   769,   769,   769,
     769,   769,   769,   769,   769,   769,   769,   769,   769,   769,
     769,   769,   769,   769,   769,   769,   769,   770,   770,   770,
     771,   771,   771,   772,   772,   773,   773,   773,   773,   773,
     773,   773,   773,   773,   774,   774,   775,   775,   776,   776,
     776,   776,   776,   776,   777,   777,   778,   778,   779,   779,
     780,   780,   781,   781,   782,   782,   782,   782,   782,   782,
     782,   782,   783,   783,   784,   785,   785,   786,   786,   786,
     786,   786,   786,   787,   788,   789,   789,   789,   790,   790,
     791,   792,   792,   793,   794,   794,   795,   795,   796,   796,
     797,   797,   797,   797,   798,   798,   799,   799,   800,   800,
     801,   801,   802,   802,   802,   803,   803,   803,   804,   804,
     805,   805,   806,   806,   807,   807,   808,   808,   809,   809,
     810,   810,   811,   811,   812,   812,   813,   814,   815,   816,
     817,   818,   819,   819,   820,   820,   820,   820,   820,   820,
     820,   820,   821,   822,   823,   824,   825,   826,   826,   827,
     827,   828,   828,   829,   829,   829,   829,   829,   830,   830,
     831,   831,   831,   832,   832,   832,   832,   832,   833,   833,
     834,   834,   834,   834,   834,   834,   835,   836,   836,   837,
     837,   837,   837,   838,   838,   838,   838,   839,   840,   841,
     841,   842,   842,   842,   843,   843,   844,   844,   845,   845,
     846,   846,   846,   846,   847,   847,   848,   849,   849,   850,
     851,   851,   852,   853,   853,   855,   854,   856,   854,   854,
     857,   858,   858,   859,   859,   859,   859,   859,   861,   860,
     862,   863,   864,   864,   864,   865,   865,   865,   865,   865,
     866,   866,   868,   867,   870,   869,   871,   869,   869,   872,
     872,   872,   873,   873,   873,   873,   874,   874,   875,   875,
     875,   875,   875,   875,   876,   876,   876,   877,   879,   878,
     880,   881,   880,   882,   882,   883,   883,   884,   884,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   886,   886,
     886,   886,   886,   886,   886,   886,   886,   886,   887,   887,
     888,   888,   889,   890,   890,   891,   891,   891,   892,   893,
     894,   894,   894,   894,   895,   895,   896,   897,   896,   898,
     898,   898,   898,   898,   899,   899,   900,   900,   901,   902,
     903,   903,   904,   904,   905,   906,   907,   907,   908,   908,
     909,   909,   910,   910,   911,   912,   912,   912,   913,   913,
     914,   915,   916,   917,   917,   918,   919,   920,   920,   921,
     922,   923,   924,   924,   925,   926,   927,   927,   928,   929,
     929,   929,   929,   929,   929,   929,   929,   929,   929,   929,
     929,   929,   929,   929,   930,   930,   931,   931,   932,   932,
     932,   934,   933,   935,   935,   937,   936,   938,   938,   938,
     939,   939,   939,   939,   939,   939,   939,   939,   939,   940,
     940,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   942,   942,
     942,   942,   942,   942,   943,   943,   943,   943,   943,   943,
     943,   944,   945,   945,   945,   945,   945,   945,   946,   946,
     946,   946,   946,   947,   947,   947,   947,   947,   948,   948,
     948,   948,   948,   948,   948,   948,   948,   949,   949,   949,
     949,   950,   950,   950,   950,   951,   951,   951,   951,   951,
     951,   951,   952,   952,   953,   953,   953,   953,   953,   953,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   958,   958,   959,   960,   960,   961,   961,   962,
     963,   964,   964,   964,   965,   966,   966,   967,   967,   968,
     968,   968,   969,   969,   970,   970,   971,   971,   972,   972,
     972,   972,   972,   973,   973,   973,   973,   973,   973,   973,
     973,   973,   973,   973,   973,   973,   973,   973,   973,   973,
     973,   973,   973,   973,   973,   973,   973,   973,   973,   973,
     973,   973,   973,   973,   973,   973,   973,   973,   973,   973,
     973,   973,   973,   973,   973,   973,   973,   973,   973,   973,
     973,   973,   973,   973,   973,   973,   973,   973,   973
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     3,     3,     5,     5,
       5,     4,     5,     5,     4,     3,     3,     5,     6,     1,
       1,     3,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       2,     5,     2,     2,     3,     3,     1,     3,     1,     1,
       1,     3,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     6,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       3,     4,     3,     2,     4,     1,     1,     1,     1,     1,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     3,     3,     3,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     1,     1,     1,
       1,     1,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     4,     1,     0,     2,     0,     3,     0,
       1,     0,    11,    12,     1,     1,     2,     2,     2,     2,
       0,     1,     0,     1,     3,     1,     1,     1,     3,     2,
       0,     3,     1,     1,     2,     1,     2,     3,     4,     2,
       5,     1,     2,     2,     2,     3,     2,     2,     0,     3,
       1,     4,     5,     6,    11,     3,     0,     3,     1,     1,
       2,     2,     0,     1,     1,     2,     2,     0,     3,     3,
       2,     1,     1,     2,     2,     4,     0,     2,     2,     0,
       3,     4,     4,     0,     2,     0,     4,     0,     0,     8,
       3,     3,     1,     3,     0,     3,     1,     1,     5,     4,
       2,     0,     2,     1,     2,     3,     2,     2,     2,     2,
       3,     3,     1,     0,     5,     9,     1,     0,     1,     2,
       2,     0,     2,     0,     5,     1,     0,     6,     2,     0,
       3,    14,    19,     1,     1,     1,     3,     5,     1,     1,
       1,     3,     0,     1,     0,     1,     1,     1,     3,     0,
       1,     1,     0,     2,     1,     2,     1,     2,     2,     1,
       2,     2,     6,     8,     3,     4,     4,     4,     5,     3,
       3,     1,     3,     3,     1,     1,     1,     1,    12,     1,
       3,     4,     7,     4,     2,     1,     0,     1,     0,     7,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     2,     2,     3,     3,     5,     4,     4,     3,
       4,     3,     3,     2,     4,     2,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     6,     9,     7,     9,     8,     8,     6,     9,
       7,    10,     7,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     7,     7,    10,     2,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       1,     3,     2,     6,     6,     3,     0,     3,     0,    12,
       1,     0,     2,     0,     1,     3,     2,     2,     4,     1,
       2,     0,     9,     7,     2,     0,     3,     2,     1,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     1,     4,     1,     2,     4,     5,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     1,
       2,     0,     5,     1,     2,     1,     0,     5,     7,     1,
       1,     7,     1,     3,     3,     3,     1,     3,    11,    10,
       2,     0,     8,     4,     4,     4,     1,     1,     1,     0,
       9,     6,     6,     7,     6,     6,     9,     6,     6,     6,
       8,     8,     6,     6,     1,     0,     9,     6,     7,     6,
       6,     6,     9,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     2,     2,     2,     2,     2,     3,
       3,     2,     2,     2,     2,     3,     2,     5,     4,     3,
       3,     3,     1,     1,     0,     3,     2,     2,     1,     3,
       2,     1,     0,     7,     9,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     3,
       3,     1,     0,     5,     5,     4,     2,     0,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     5,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     4,     4,     3,     1,
       0,     2,     0,     2,     0,     3,     1,     1,     2,     1,
       2,     5,     6,     5,     1,     2,     1,     4,     3,     4,
       3,     5,     4,     5,     4,     5,     2,     4,     1,     2,
       2,     2,     1,     1,     0,     4,     2,     1,     2,     2,
       4,     1,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       1,     3,     5,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     3,     3,     2,
       3,     5,     4,     6,     3,     5,     4,     6,     4,     6,
       5,     7,     2,     3,     2,     4,     3,     4,     3,     4,
       3,     4,     5,     6,     7,     6,     7,     6,     7,     3,
       4,     4,     6,     2,     1,     3,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     5,
       6,     7,     1,     1,     2,     4,     1,     1,     1,     2,
       2,     2,     1,     3,     4,     5,     5,     4,     1,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     6,     4,     4,     4,     4,     3,     5,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     4,     1,     4,
       1,     2,     1,     2,     1,     3,     3,     0,     3,     1,
       1,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     3,     2,     3,     0,     3,     3,     2,
       2,     1,     0,     2,     2,     3,     2,     1,     1,     3,
       5,     2,     1,     4,     2,     0,     1,     0,     1,     2,
       2,     2,     3,     5,     1,     2,     0,     2,     1,     0,
       3,     1,     3,     1,     1,     3,     7,     1,     2,     4,
       1,     3,     4,     4,     3,     1,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       3,     2,     2,     3,     7,     1,     1,     2,     2,     1,
       0,     1,     3,     1,     2,     0,     2,     0,     2,     0,
       1,     3,     4,     3,     1,     1,     1,     2,     0,     7,
       3,     2,     1,     1,     1,     0,     5,     0,     4,     2,
       1,     2,     0,     1,     3,     3,     3,     3,     0,     4,
       5,     5,     0,     1,     1,     1,     1,     2,     2,     2,
       1,     2,     0,     7,     0,     5,     0,     4,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     2,     1,     3,     2,     2,     3,     0,     5,
       1,     0,     5,     2,     2,     1,     1,     1,     2,     2,
       3,     1,     2,     2,     3,     3,     4,     2,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     0,
       1,     3,     4,     0,     2,     0,     1,     2,     3,     2,
       1,     1,     1,     0,     1,     1,     3,     0,     4,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     4,     1,     0,
       3,     3,     4,     1,     3,     3,     4,     1,     3,     3,
       1,     6,     1,     3,     3,     6,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     4,     4,
       3,     0,     7,     1,     0,     0,     7,     3,     4,     3,
       1,     1,     1,     2,     3,     5,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     0,     1,     2,     1,     2,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     2,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1998,  1999,  2002,  2006,  2007,  1934,
    2008,  2009,  1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,
    1982,  1983,  1984,  1985,  1987,  1986,  1988,  1989,  1990,  1991,
    1992,  1993,  1994,  1995,  1997,  1996,  2011,  2012,  2000,  2001,
    2003,  2004,  1973,  2005,  2013,  2014,  2015,  2010,  1963,  1266,
    1964,    10,  1262,  1263,  2018,  1969,  1970,  1968,  1971,  1972,
    2016,  2017,  1959,  1960,  1962,    11,    12,  1961,     4,  1965,
    1966,  1967,     8,  1348,  1419,     9,  1958,  1419,     0,  1531,
    1532,  1533,     0,  1534,  1535,  1536,  1537,  1538,  1469,  1433,
       0,  1539,     0,  1540,  1541,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,     0,  1549,  1550,  1551,  1552,  1418,  1553,  1554,
    1555,  1556,  1395,  1401,  1557,  1515,     0,  1375,  1376,  1372,
    1374,  1373,  1377,  1362,   714,     0,   768,   767,     0,  1844,
     714,  1845,  1810,  1846,  1811,  1812,   219,     0,   761,  1813,
       0,   714,  1814,   275,   290,  1847,     0,     0,  1815,  1816,
       0,     0,   396,   714,     0,  1817,   784,  1818,     0,  1819,
    1848,  1849,     0,     0,  1820,  1850,  1851,  1821,     0,  1822,
    1823,  1852,  1853,  1854,  1824,  1855,  1856,     0,     0,   846,
       0,  1825,  1857,  1826,  1827,     0,  1858,  1828,  1829,  1830,
    1859,  1860,  1831,  1832,  1833,     0,  1834,     0,     0,     0,
       0,  1861,   714,  1835,     0,   852,     0,  1836,     0,  1862,
    1837,     0,  1838,  1839,  1840,  1841,  1842,   846,  1511,  1396,
       0,     0,   772,  1843,  1863,  1945,  1946,     0,     0,     0,
      42,    48,    24,    23,    25,    58,    63,    39,    18,    55,
      43,    89,    90,    91,    31,    27,    22,    28,    32,    45,
      33,    44,    21,    40,    57,    46,    61,    47,    62,    34,
      53,    51,    41,    56,    60,    85,    66,    30,    67,    80,
      68,    81,    69,    38,    17,    78,    76,    77,    35,    54,
      75,    79,    19,    20,    82,    59,    74,    71,    86,    84,
      92,    72,    49,    14,    15,    64,    37,    16,    36,    29,
      88,    26,   770,    65,    70,    52,    73,    87,    50,    83,
     829,   820,   854,   828,    94,    95,    96,     7,  1332,  1334,
    1333,  1419,  1370,  1371,  1337,  1380,  1390,  1379,  1383,  1391,
    1378,  1397,     0,    98,   100,   101,   102,   105,   106,    99,
      93,    97,   104,   110,   103,   109,   107,   108,   111,   112,
     113,  1600,  1019,  1598,  1599,  1597,  1354,     0,  1419,  1356,
    1355,  1419,  1366,  1390,     0,  1558,  1559,  1560,  1561,  1562,
    1563,  1605,  1606,  1607,  1608,  1609,  1611,  1610,  1620,  1621,
    1622,  1623,  1624,  1625,  1626,  1627,  1628,  1629,  1630,  1631,
    1632,  1633,  1634,  1635,  1636,  1637,  1638,  1639,  1577,  1640,
    1641,  1642,  1643,  1644,  1645,  1646,  1647,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,  1655,  1656,  1657,  1658,  1614,  1659,
    1660,  1661,  1662,  1663,  1664,  1665,  1666,  1667,  1668,  1669,
    1670,  1671,  1672,  1673,  1674,  1676,  1675,  1677,  1678,  1679,
    1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,  1688,  1615,
    1689,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,  1698,
    1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,
    1709,  1710,  1711,  1712,  1713,  1714,  1616,  1715,  1716,  1617,
    1717,  1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,  1726,
    1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,  1736,
    1737,  1740,  1738,  1739,  1741,  1742,  1743,  1744,  1745,  1746,
    1747,  1748,  1749,  1750,  1751,  1752,  1753,  1754,  1755,  1756,
    1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,  1765,  1618,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,  1775,
    1776,  1777,  1778,  1779,  1781,  1780,  1783,  1782,  1784,  1785,
    1786,  1787,     0,  1788,  1789,  1790,  1791,  1792,  1793,  1794,
    1795,  1796,  1797,  1798,  1799,  1800,  1801,  1802,  1803,  1804,
    1805,  1806,  1807,  1808,  1619,  1809,  1944,  1278,  1325,  1324,
    1301,  1320,  1575,  1529,  1530,  1296,  1576,  1573,  1612,  1613,
    1574,  1279,  1940,  1572,  1468,     0,     0,  1431,  1432,  1435,
    1310,  1305,  1434,     0,  1306,  1429,  1430,  1247,  1326,  1572,
    1564,  1565,  1566,  1567,  1569,  1568,  1570,  1864,  1865,  1866,
    1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  1875,  1590,
    1876,  1877,  1878,  1879,  1880,  1881,  1884,  1882,  1883,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,  1894,  1895,
    1896,  1897,  1898,  1899,  1900,  1901,  1902,  1591,  1592,  1903,
    1904,  1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,
    1914,  1915,  1916,  1917,  1918,  1919,  1920,  1921,  1922,  1923,
    1924,  1594,  1925,  1926,  1593,  1927,  1928,  1929,  1930,  1931,
       0,  1385,  1604,  1589,  1386,  1571,  1601,  1588,  1595,  1596,
    1603,  1602,  1448,  1246,  1450,  1393,  1403,  1399,  1407,  1402,
       0,     0,     0,     0,  1419,   713,   712,   698,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,   722,   255,  1298,
    1297,  1242,   760,     0,  1238,  1239,   396,     0,   701,   274,
       0,     0,     0,     0,     0,     0,   455,     0,     0,     0,
       0,     0,     0,     0,   155,     0,   285,   284,     0,   386,
       0,   560,     0,     0,   396,     0,     0,     0,  1302,     0,
    1738,  1446,  1447,  1331,  1775,   812,     0,     0,     0,     0,
     467,     0,   466,     0,     0,   464,     0,   395,     0,     0,
     468,   462,   461,     0,     0,   465,     0,   463,     0,     0,
     702,  1689,  1437,   783,   770,  1621,   493,   497,   488,   494,
     501,   500,   489,   486,   487,  1749,     0,     0,     0,   483,
    1267,  1269,   492,  1268,     0,   529,   535,   534,   533,     0,
     530,   531,   536,     0,   695,  1239,   725,  1251,   845,     0,
       0,   485,   694,  1789,     0,     0,   636,     0,   637,     0,
    1763,   706,   213,  1768,  1839,  1789,   209,   176,     0,     0,
     530,     0,   703,   704,   851,   849,     0,     0,     0,     0,
    1649,  1709,  1718,  1759,  1768,  1839,  1789,   164,     0,   208,
    1768,  1839,  1789,   204,   722,     0,     0,  1394,   697,   696,
       0,     0,   917,   771,   774,   829,     0,   714,     0,     6,
     769,   765,   848,   848,     0,   848,     0,   825,  1335,  1390,
    1369,  1425,  1339,     0,     0,  1415,  1411,  1408,  1416,  1417,
    1410,  1398,  1008,  1009,  1010,  1007,  1011,  1006,     0,  1343,
    1382,  1349,     0,  1359,  1358,  1357,  1364,  1425,  1368,  1947,
    1948,  1470,  1300,  1317,     0,     0,     0,     0,     0,     0,
    1309,  1315,     0,  1307,     0,     0,  1952,  1956,     0,  1954,
    1949,  1384,  1456,  1449,  1451,  1453,  1405,  1404,  1400,     0,
       0,  1520,     0,     0,  1521,  1522,     0,  1517,  1519,     0,
    1425,     0,     0,  1575,  1252,  1576,  1573,  1585,  1572,     0,
     471,   116,     0,     0,   471,     0,     0,     0,     0,     0,
    1642,  1143,  1153,  1151,  1152,  1145,  1146,  1147,  1150,  1148,
    1149,     0,   626,  1144,     0,   116,     0,     0,   371,     0,
       0,     0,     0,   116,     0,     0,     0,   718,   721,   699,
       0,     0,  1214,  1243,     0,     0,     0,   513,   522,   514,
     519,     0,   516,     0,     0,     0,   515,   517,   518,     0,
     520,   521,     0,     0,   710,   277,     0,     0,     0,     0,
     727,   757,   289,   288,   116,   287,   286,     0,     0,   574,
     116,     0,   157,   399,     0,     0,   116,     0,     0,     0,
       0,     0,     0,     0,     0,  1471,  1330,  1428,     0,   796,
       0,   434,     0,   749,     0,   151,  1244,     0,     0,   145,
       0,   400,     0,   146,     0,   252,   469,  1445,  1444,  1436,
    1443,     0,   490,   499,   498,   496,   495,   491,  1270,     0,
     481,   482,  1456,  1459,   479,     0,   528,     0,     0,     0,
       0,   799,  1240,     0,   709,     0,   639,   639,   639,   705,
     212,   210,     0,     0,     0,     0,     0,   711,     0,     0,
       0,  1810,  1811,   967,  1207,     0,  1577,  1812,  1813,  1814,
    1108,  1117,  1109,  1111,  1118,  1815,  1816,  1668,  1817,  1818,
    1259,  1819,  1820,   957,  1822,  1823,  1824,  1113,  1115,  1825,
    1826,     0,  1260,  1828,  1829,  1733,  1831,  1832,  1834,  1835,
    1119,  1837,  1838,  1839,  1840,  1841,  1842,  1258,     0,  1120,
    1843,  1154,  1264,  1265,  1216,     0,     0,  1224,     0,  1098,
       0,   951,   953,   954,   978,   979,   955,   984,   985,   997,
     952,     0,  1223,  1020,  1097,  1102,     0,  1096,  1092,   836,
    1221,  1208,     0,  1093,  1292,  1291,  1293,  1294,  1290,  1254,
    1575,  1581,   956,  1576,  1573,  1261,  1295,  1940,  1572,     0,
       0,     0,     0,  1510,     0,   215,     0,   216,  1768,   165,
     200,   172,   199,   173,   203,   202,     0,  1640,   166,     0,
     170,     0,     0,   207,   205,     0,   700,   475,     0,     0,
     919,     0,   918,   773,   770,   823,   822,     5,   776,   847,
       0,     0,     0,     0,     0,     0,     0,   880,   868,  1425,
    1426,     0,  1420,     0,  1419,  1419,  1413,  1412,  1409,     0,
       0,     0,     0,     0,     0,  1284,  1283,  1340,  1342,  1287,
       0,  1425,     0,     0,  1319,     0,  1323,  1321,  1456,  1465,
    1456,  1466,  1467,  1313,  1308,  1311,     0,  1303,  1315,  1950,
       0,     0,  1953,  1387,     0,  1457,  1288,  1289,  1462,     0,
    1452,  1460,  1463,  1406,  1419,  1528,     0,  1523,  1526,     0,
    1518,     0,  1253,     0,     0,     0,     0,   472,     0,     0,
       0,   115,   747,   745,     0,     0,     0,   751,     0,     0,
       0,   600,     0,     0,   601,   599,   602,   613,   616,     0,
     552,   149,   150,     0,     0,     0,     0,     0,   221,   244,
       0,     0,     0,     0,     0,     0,   141,     0,     0,     0,
     369,   655,   655,     0,     0,     0,   655,     0,   655,     0,
     220,   222,     0,     0,     0,     0,     0,     0,     0,     0,
     144,  1350,     0,   716,   717,     0,   720,     0,  1211,  1210,
    1249,  1215,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   435,     0,   960,   995,
     995,   995,   975,   975,   969,   958,  1002,     0,   995,   972,
     961,     0,   959,  1005,  1005,   990,     0,   933,   943,   945,
     946,   976,   977,   947,   982,   983,   944,  1019,  1580,   956,
    1582,  1579,  1578,     0,     0,   756,     0,     0,   456,   436,
       0,     0,     0,   153,     0,     0,   404,   403,     0,     0,
     437,     0,   371,   364,   326,     0,     0,     0,  1250,     0,
       0,   813,   817,   814,     0,   815,     0,   923,     0,     0,
     252,     0,     0,     0,     0,     0,   252,   250,   251,     0,
     460,  1438,  1441,  1442,     0,   777,   779,   781,   780,   782,
     778,   480,   477,   478,     0,  1458,  1932,  1938,     0,  1472,
    1473,     0,  1658,  1683,  1703,  1764,     0,  1784,     0,   537,
     556,   532,     0,     0,     0,   785,   788,     0,     0,   809,
     484,  1464,   638,   635,   634,   633,   211,   177,     0,     0,
     558,  1763,   708,     0,     0,  1100,  1101,   994,   981,  1206,
       0,     0,   989,   988,     0,     0,     0,     0,     0,   965,
     964,   963,  1099,  1167,     0,   962,     0,     0,     0,     0,
     995,   995,   993,  1039,     0,     0,   966,     0,     0,  1186,
       0,  1192,     0,     0,     0,  1001,     0,   999,     0,     0,
    1073,  1094,  1023,  1024,  1098,  1164,     0,  1255,     0,     0,
     987,     0,  1019,     0,     0,     0,     0,  1219,  1162,     0,
       0,  1052,  1160,     0,  1054,     0,     0,     0,  1154,  1153,
    1151,  1152,  1145,  1146,  1147,  1150,  1148,  1149,  1158,  1036,
       0,  1035,  1456,     0,   884,   835,  1209,     0,     0,  1939,
    1941,  1507,  1506,  1505,  1504,  1508,  1509,  1480,     0,  1476,
    1477,     0,   217,   218,   214,     0,   175,   174,     0,   197,
     198,   169,     0,   193,   194,   179,   190,   192,   191,   189,
     167,   178,   180,   186,   187,   188,   168,   206,  1419,     0,
       0,   884,  1227,  1216,   762,     0,   766,   829,   833,   828,
     832,   855,   856,   861,   831,     0,   882,   882,   870,   864,
     869,   865,   871,   879,   827,   867,   826,     0,  1427,  1338,
    1425,   933,  1419,  1360,  1419,  1414,  1346,  1013,  1014,  1015,
    1016,  1018,  1017,  1347,  1344,  1012,  1345,  1286,  1285,     0,
       0,     0,     0,  1367,  1316,     0,  1299,  1322,     0,  1314,
       0,  1951,  1957,  1955,     0,     0,   933,  1935,  1524,  1935,
     933,   620,     0,   619,     0,     0,   473,     0,     0,     0,
     744,   743,     0,     0,     0,     0,     0,   754,   320,     0,
     249,     0,     0,     0,     0,     0,     0,     0,     0,   605,
     606,   615,   614,   612,   585,   587,   586,   577,     0,   578,
       0,     0,   584,   593,  1586,   956,   591,  1587,  1584,  1583,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   622,   627,   140,     0,     0,   124,   126,
       0,     0,   122,   128,   125,   127,   123,   129,   121,     0,
       0,   120,     0,     0,     0,     0,   139,     0,     0,     0,
       0,   373,   383,     0,     0,     0,   116,   116,   370,   654,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     143,   142,     0,     0,   185,   715,   719,  1212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   258,   257,     0,     0,   441,   444,     0,   933,     0,
       0,     0,   927,  1008,  1007,  1006,     0,   948,   950,     0,
       0,   742,   742,   742,   742,   742,   726,   728,   300,   147,
       0,     0,   114,   157,   290,     0,   156,   158,   160,   161,
     162,   159,   163,   398,     0,   409,   408,   410,     0,   405,
       0,   438,   138,   368,     0,   292,     0,     0,     0,   384,
       0,     0,     0,   672,     0,     0,     0,   816,     0,   894,
     795,   886,   896,   887,   889,   921,  1242,     0,   794,     0,
       0,   617,  1245,     0,     0,   252,   252,   394,   470,  1439,
    1440,   812,   476,     0,     0,  1937,  1271,     0,  1272,     0,
       0,   540,   539,   550,     0,   541,   542,   538,   543,     0,
       0,   558,   787,     0,     0,   792,  1216,     0,   806,     0,
     804,     0,  1241,   808,   797,     0,   530,     0,     0,   252,
     707,  1164,     0,     0,     0,  1170,     0,     0,  1205,  1202,
       0,     0,  1164,     0,     0,     0,     0,  1177,  1178,  1179,
    1176,  1180,  1175,     0,     0,  1181,  1174,     0,     0,     0,
       0,     0,   992,   991,     0,     0,     0,     0,     0,     0,
       0,  1074,     0,     0,  1138,     0,  1164,  1191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1164,  1197,
       0,  1217,  1216,     0,     0,     0,     0,  1256,  1021,  1037,
    1222,     0,  1218,     0,     0,  1044,     0,  1198,  1069,     0,
    1058,     0,  1053,     0,  1056,  1060,  1040,  1219,  1163,     0,
    1161,     0,     0,  1038,     0,  1033,  1031,  1032,  1025,  1026,
    1027,  1028,  1029,  1030,  1034,  1142,  1140,  1141,     0,  1684,
    1709,     0,   846,   846,   834,   844,  1220,     0,   923,     0,
       0,     0,  1103,     0,  1943,  1942,     0,     0,     0,     0,
       0,  1019,     0,   933,   920,     0,  1216,     0,   923,     0,
     764,   763,     0,     0,   859,   860,     0,   878,     0,   809,
     809,     0,     0,     0,  1336,  1421,  1423,  1389,  1361,  1392,
    1341,  1381,     0,  1365,  1318,  1312,     0,  1454,  1461,  1514,
       0,  1936,     0,     0,     0,   663,   641,   474,   664,   642,
       0,   746,     0,     0,     0,     0,     0,   252,   752,   248,
     753,   657,   665,     0,   603,   604,     0,   588,   576,     0,
       0,   583,     0,   582,   950,     0,     0,     0,   644,   148,
     246,   649,   247,   245,   645,     0,  1248,     0,     0,     0,
     134,     0,     0,     0,     0,   117,   135,   133,     0,   132,
       0,   669,   647,   659,   372,   382,     0,   376,   377,   374,
     378,   379,     0,     0,   224,     0,     0,   236,   235,   242,
     243,   241,   252,   252,   239,   240,   238,   648,     0,   660,
     237,   234,     0,   223,   671,   653,     0,   670,   661,   652,
     183,   182,   184,     0,     0,     0,     0,     0,     0,     0,
     524,   508,   523,     0,     0,     0,   502,   260,   261,   279,
     259,   440,     0,     0,     0,     0,   928,     0,     0,   933,
       0,     0,   941,   934,   942,     0,     0,     0,     0,   742,
     741,     0,     0,     0,     0,     0,   729,   750,     0,   326,
     152,     0,     0,   397,     0,     0,     0,   924,     0,     0,
       0,     0,   291,   293,   295,   296,   297,     0,   366,   367,
     362,     0,     0,   358,     0,   328,   329,     0,     0,     0,
     563,     0,     0,     0,   611,   609,   595,     0,   818,   819,
       0,   894,     0,   896,     0,   895,   908,     0,     0,   914,
     912,     0,   914,     0,   914,     0,     0,   888,     0,   890,
     908,  1243,   922,   252,     0,   252,   252,   693,   432,     0,
    1455,  1933,  1481,  1482,     0,  1474,  1475,     0,   552,     0,
     549,   544,   546,     0,   553,  1237,  1236,     0,  1235,     0,
       0,   793,   807,   800,   802,   801,     0,     0,   798,     0,
     252,     0,   554,   850,     0,  1172,  1173,     0,     0,     0,
       0,  1201,     0,     0,  1134,     0,  1132,  1110,  1112,   974,
       0,  1122,     0,   968,  1135,  1136,  1114,  1116,     0,   971,
       0,  1155,     0,     0,  1123,  1076,     0,     0,     0,     0,
    1154,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1088,  1087,  1124,  1137,     0,     0,  1189,  1190,  1125,  1003,
    1004,  1005,  1005,     0,     0,  1196,     0,     0,     0,  1130,
    1095,  1165,   996,   997,     0,     0,     0,     0,     0,     0,
       0,  1059,  1055,     0,  1057,  1061,     0,     0,     0,     0,
    1046,  1070,  1042,     0,     0,  1048,     0,  1071,   846,   846,
     846,   846,   843,     0,     0,   883,   873,     0,     0,  1107,
    1104,  1489,  1490,  1491,  1492,  1493,  1494,  1495,  1496,  1497,
    1498,  1500,  1501,  1502,  1499,  1503,  1485,  1486,     0,  1478,
    1479,   171,     0,   195,   181,  1514,     0,  1228,  1225,   810,
       0,   775,   857,     0,  1156,   858,   881,   877,   876,   862,
     866,   863,     0,  1422,  1351,  1328,  1513,  1516,  1527,  1525,
    1363,     0,     0,     0,   742,     0,   319,     0,     0,     0,
     755,   597,     0,   579,   580,   581,     0,   666,   643,   658,
       0,     0,   624,     0,   625,   623,   130,   118,   137,   136,
     119,   131,   375,   381,   380,   300,     0,     0,     0,   225,
     233,   230,     0,     0,  1213,     0,     0,   504,   510,     0,
       0,     0,     0,   512,   280,   116,     0,   442,  1733,  1146,
     443,   445,   446,   447,     0,     0,     0,     0,   931,     0,
       0,     0,     0,     0,     0,   933,  1019,     0,     0,   737,
    1280,  1281,   736,  1282,   733,   732,   740,   739,   731,   730,
     735,   734,     0,     0,     0,   311,     0,     0,   305,     0,
       0,   357,   299,   302,   303,     0,     0,   290,     0,   412,
     406,   439,     0,   926,   292,   318,   346,     0,   363,     0,
       0,     0,     0,   325,     0,   723,   391,   388,     0,     0,
       0,   607,   589,   608,     0,   592,     0,   596,   573,     0,
     811,  1329,   898,   906,     0,   885,     0,   913,   909,     0,
     910,     0,     0,   911,   900,     0,     0,   906,     0,   618,
     252,   459,   621,   817,     0,     0,   551,   547,     0,     0,
     525,   555,   786,     0,     0,   790,   791,   805,   803,     0,
     526,   557,  1165,  1171,   980,     0,  1204,  1200,     0,     0,
       0,  1166,     0,     0,  1184,  1183,  1075,  1185,     0,     0,
       0,  1086,  1085,  1083,  1084,  1077,  1078,  1079,  1080,  1081,
    1082,  1194,  1193,  1187,  1188,  1000,   998,     0,  1127,  1128,
    1129,  1195,  1139,   986,  1019,  1022,     0,     0,  1045,  1199,
    1062,     0,  1169,     0,  1041,     0,     0,     0,     0,  1050,
    1155,     0,     0,     0,     0,     0,     0,   838,   837,     0,
     875,  1105,  1106,     0,     0,     0,  1512,     0,     0,  1233,
    1232,     0,  1424,     0,  1304,     0,     0,     0,     0,   321,
       0,     0,   357,   598,   594,     0,     0,     0,   298,     0,
       0,     0,     0,   254,   650,   651,     0,     0,     0,     0,
     507,   506,   263,     0,   429,     0,     0,   433,   424,   426,
       0,     0,     0,   929,   935,   936,   937,   938,   939,   940,
     932,   949,   422,   738,     0,     0,   309,   313,   314,   312,
     304,   357,   326,     0,   306,     0,     0,     0,   414,     0,
       0,   925,     0,     0,     0,   315,     0,   349,   294,   365,
     367,   360,   361,   359,   327,     0,   393,   389,     0,   562,
       0,     0,   611,   610,   688,   689,   686,   687,     0,   897,
       0,     0,   899,     0,     0,   902,   904,     0,     0,     0,
       0,     0,  1246,   632,     0,  1483,  1484,     0,   545,  1234,
       0,     0,  1203,  1121,  1131,   973,  1133,   970,  1182,     0,
       0,     0,  1126,  1257,  1067,  1065,     0,  1063,     0,     0,
       0,  1047,  1043,     0,  1049,  1072,   842,   841,   840,   839,
       0,     0,   830,  1487,     0,  1273,  1277,  1274,  1488,  1019,
       0,  1229,     0,  1327,   662,   640,   656,   748,     0,   357,
     322,   668,   646,   667,   226,   227,   228,   229,     0,   231,
     503,     0,   509,   505,   256,   278,   431,   430,   428,   425,
     427,   930,     0,   631,     0,     0,     0,     0,   301,   307,
     332,     0,     0,   724,   292,   413,     0,     0,   407,   349,
     317,   316,     0,     0,     0,   353,   390,     0,   385,     0,
       0,     0,   564,   571,   571,   590,   572,     0,     0,   907,
     916,     0,   903,   901,   891,     0,   893,     0,   548,     0,
     252,  1089,     0,     0,  1064,  1168,  1068,  1066,  1051,   872,
     874,  1276,  1275,   196,  1230,     0,  1157,     0,   323,   253,
     511,   264,   268,   757,   757,     0,   269,   757,   265,   757,
     262,   631,     0,   629,   423,     0,   308,     0,   337,     0,
       0,   415,   416,   411,     0,   353,     0,   347,   348,     0,
     355,   392,   758,     0,   355,     0,     0,   569,   567,   566,
     923,   905,     0,   892,   789,   527,     0,  1090,     0,  1226,
     326,     0,     0,     0,     0,     0,     0,   628,   630,     0,
     330,   331,     0,   310,   333,   334,   356,     0,     0,   355,
     345,     0,     0,   282,   571,   923,   565,   570,     0,   915,
    1091,  1231,   332,   266,   271,     0,   272,   267,   270,     0,
       0,     0,     0,   335,     0,   336,     0,     0,     0,   448,
     449,   419,   283,     0,   350,     0,   354,   568,   559,   692,
     337,   273,     0,   342,     0,   341,     0,   338,   339,     0,
       0,   454,     0,     0,   417,   420,   421,   351,   352,   691,
     690,     0,     0,     0,   340,   343,   344,     0,   458,   450,
     401,     0,   674,   685,   673,   675,   683,   680,   682,   681,
     679,   324,     0,   453,   457,     0,   451,   418,     0,   684,
     678,   829,   820,     0,     0,   676,   685,   419,   458,   677,
       0,   452,   402
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   228,   229,   230,  1382,  1896,   231,
     232,   233,   234,   235,   236,   237,   238,  1404,   239,   240,
    1081,  1513,  1986,   241,   887,   888,  1730,  1731,  1935,  1732,
    1733,  1721,  1271,  1273,   242,   243,   244,  1266,  1714,   245,
     246,  1430,  1431,  1408,  1409,  1387,  1550,  3099,   247,   248,
    1953,  2369,  3104,  3190,   750,  1464,  2715,  2716,   249,  1510,
    2411,  2412,  2413,  2414,  2397,  2762,  2763,  2764,  2415,  2995,
    2416,  1828,  2008,  2424,  2425,  3198,  3243,  3244,  3245,  3297,
    2997,  3135,  3210,  3253,  2984,   250,  2782,  2423,  2006,  2417,
    2418,   251,   252,  1420,  1908,  2316,   253,   774,  2786,  3006,
    3138,   254,   808,   255,  1515,   256,   257,  1518,  1998,  1999,
    2989,  3126,  3203,  3303,  3304,  3115,  2957,  2958,  2959,   258,
     259,   260,   261,  2001,  1466,  1954,  1955,  2720,   262,  3279,
    3280,   775,  3336,   263,   264,   809,  1115,  3217,  1377,   265,
     266,   827,   828,   267,  1063,  2361,   268,   269,   839,  2076,
     841,  1578,  2480,  2481,  2830,  2052,  1005,   270,   271,  2061,
    2079,   272,   776,  2790,  3141,  3142,  3218,   273,   777,  1400,
    1848,  1849,  1850,  2791,  1851,  2794,  1852,  2434,  2435,  2436,
    2798,   274,  1398,  1843,   275,   276,  1812,   277,  1872,  1021,
     278,  3193,   279,   280,   859,  1593,   281,  1911,   282,   283,
     284,  2437,  3324,  3338,  3339,  3340,  3018,  3311,   285,  3326,
     287,   288,   289,   737,  1037,  1038,  1039,   290,   291,   292,
    1976,  1977,  2391,   293,   294,  1821,  2261,   295,   296,   297,
    1506,   298,   299,   300,   301,   302,   911,   904,  1294,  1746,
     303,  1555,   814,  3327,  1585,  2064,  2065,  3328,  1537,   306,
    1589,  2071,  2074,  3329,   308,  1098,  2016,  3330,  1219,   311,
     312,   313,  1694,  2194,   849,  1300,   876,   916,   917,  1751,
    1752,  1307,  1766,  1759,  1761,  2910,  3072,  1308,  1764,  2229,
    2198,  2020,  2021,  2022,  2445,  2456,  2808,  3025,  2023,  2024,
    2028,  2406,  2407,  1853,  1962,  2381,  1487,  1220,  1221,  1222,
    1625,  1636,  1619,  1490,  1223,  1224,  1225,  1493,  1226,  1227,
    1228,  1229,  1608,  1660,  1230,  1231,  1645,   939,  2081,  2120,
    1233,  1234,  1235,  2188,  1688,  1023,  1236,  2645,  1690,  2139,
    2103,  2893,  2084,  1606,  2104,  2118,  2533,  2123,  2128,  2556,
    2557,  2140,  2158,  1237,  2088,  2089,  2512,  1610,  1238,  2141,
    1043,  1651,  2154,  1239,  1240,  1741,  2215,  3175,  1742,  2487,
    2488,  1241,  1579,   902,  3021,  1106,   600,  2295,  1449,   743,
     846,  1242,  1243,  1244,  1245,  1246,  1247,  1248,   831,   832,
    2047,  3078,  2362,  2742,  1357,  1734,  1249,   579,   744,   314,
     602,   603,   960,   961,  1344,  1347,  1334,  1796,   580,   581,
     604,  2924,   315,   316,   317,   318,   319,  1309,   921,  1328,
    1790,   940,    72,    77,    73,   941,   357,   358,  1772,   320,
     714,  1773,  1331,   947,   361,   322,   323,   362,   325,   691,
     363,   923,   327,   924,   328,   329,   330,   331,   931,   332,
    1311,  1312,  2653,  1313,   333,   334,   605,   606,   335,  1120,
    1551,  1119,   783,   336,   337,   973,   974,   975,  1133,  1564,
    1134,  1360,  1361,   338,   339,   596,   340,   341,   342,  1569,
    1570,   343,  1709,  1710,  1711,   344,  2472,  2473,   345,  2626,
    2627,  2628,   346,  1703,   347,   348,   896,  2657,   349,   710,
     350,   987,   582,   583,   584,  1251,   694,   845,  1252,   994,
     695,   352,   697,   586,   587,   588,   589,   590,   997,   701,
    1565,    74,  2250,  1566,  1255,  1256,  1699,  1257,   593,   951,
     966,   967,  2251,   969,    75,   970
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2884
static const int yypact[] =
{
   -2884,   314, 13350, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, 15581, -2884, -2884, 33712,   328, -2884,
   -2884, -2884, 36605, -2884, -2884, -2884, -2884, -2884,   171, 35779,
   14359, -2884, 52688, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, 52688, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, 34541,   676, -2884, -2884,   185, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884,   784,  3177, -2884, -2884, 38257, -2884,
     203, -2884, -2884, -2884, -2884, -2884, -2884, 52688, 46508, -2884,
     360,   343, -2884,   688,  6353, -2884, 38257, 38670, -2884, -2884,
   53100,   609,  4686,   784, 39083, -2884,   941, -2884, 31226, -2884,
   -2884, -2884,   828, 44448, -2884, -2884, -2884, -2884,   629, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, 46508,  1104,   600,
   31639, -2884, -2884, -2884, -2884, 46508, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, 39496, -2884,   514, 53512, 48156,
   44036, -2884,   443, -2884, 52688,   206, 33300, -2884, 48568, -2884,
   -2884,   681, -2884, -2884, -2884, -2884, -2884,   600, -2884, 34541,
   29972, 45272,   989, -2884, -2884, -2884, -2884,   549, 10992,   755,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884,   825, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
      38, -2884,   550,   105, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, 55564,  1237, -2884, -2884, -2884,   812, -2884,   962, -2884,
   -2884, -2884,  1292, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884,    44, -2884, -2884, -2884, -2884,  1274, 34126, -2884,
   -2884, 55564, -2884,  1149, 39909, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, 37018, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884,   106, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, 52688, 52688, -2884, -2884, -2884,
     997, -2884, -2884,   986, -2884, -2884, -2884, -2884, -2884,  1055,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   10422, -2884, -2884, -2884,  1097, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884,  1155, -2884,   194,  1432, -2884, -2884,
   34541,  1377,  1377,  1615, 55564, -2884, -2884, -2884, 43212, 52688,
   52688, 52688, 43212, 52688, 45272, 52688, 28285, 52688, 52688, 45272,
   45272, 52688, 52688, 52688, 52688, -2884,  1624,    52, -2884, -2884,
   -2884,   -94, -2884,  1380, -2884,  1386,  2733,  1104, -2884, -2884,
   46508, 43212, 52688,  1253,  1360, 52688, -2884, 52688,   358, 52688,
     922,   334,  1387, 52688, 52688, 52688, -2884, -2884, 52688, -2884,
   52688, -2884, 52688,   -16,  1452,  1597,  1555,   440, -2884, 39909,
   39909, -2884, -2884, -2884,  1116, -2884, 45272, 43212, 52688,  1363,
   -2884, 52688, -2884, 43212, 52688, -2884,   694, -2884, 52688, 52688,
   -2884, -2884, -2884, 52688, 52688, -2884, 52688, -2884,  1545, 52688,
   -2884,   850, -2884, -2884,   825,  1004, -2884,   131,   160,   295,
   -2884, -2884,   397,   431,   436,  1004,   521, 46920, 52688,  1556,
   -2884, -2884, -2884, -2884, 39909,  1488, -2884, -2884, -2884,  1504,
     -82, -2884, -2884, 46508, -2884, -2884, -2884, -2884, -2884, 46508,
    1201, -2884, -2884,  1104,  1621, 52688, -2884, 52688, -2884, 46508,
   52688, -2884, -2884,  1728,  1411,  1616,  1416, -2884,  1579,  1586,
      19,  1104,  1518, -2884, -2884,  1606, 18539,   581, 32052, 39909,
   48980, 53924,    48, 38257, 49392,  1497,    52, -2884,   638, -2884,
    1800,  1531,  1711,  1416,    52, 46508, 55961, -2884, -2884, -2884,
   25770,  1601,  1516, -2884,  1755,  1510,  1512,   784,  1511, -2884,
   -2884, 46508,  1868,  1868,  1847,  1868,    81,   809, -2884, -2884,
   -2884,  1526, -2884,  1519,  1520, -2884,   196,  1735, -2884, -2884,
   -2884, -2884,  1590,  1591,  1595,  1596, -2884,  1598,   817, -2884,
   -2884, -2884,  1796, -2884, -2884, -2884, -2884,  1526, -2884, -2884,
   -2884, -2884, -2884,  1880,  1865, 38257, 38257,  1581,     4, 32885,
   -2884,  1534,   997, -2884, 13820, 10422, -2884,  5129,   795, -2884,
   -2884, -2884,    99, -2884, -2884, -2884,  1752, -2884, -2884,  1750,
   52688, -2884,  1609, 52688, -2884, -2884, 54336, -2884, -2884,  1377,
    1526,   -94,  1547,  1551, -2884,  1552,  1558, -2884,  1559,    33,
    1554,  1072,   147,  1700,   -45,   736,  1564,   532,   848,  1682,
   52688, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884,  1566, -2884, -2884,  1571,   753,   624,  1668,   -69,  1447,
     642,  1731,    -6,   849,  1580,  1781,   426, -2884,   470, -2884,
   21548, 29146, -2884,   -94, 46508, 43212,  1588, -2884, -2884, -2884,
   -2884, 43212, -2884,  1746,   776, 52688, -2884, -2884, -2884, 52688,
   -2884, -2884,  1794, 52688, -2884,  1627,  1599,  1915, 41975, 52688,
    1632,  1947, -2884, -2884,  1637, -2884, -2884, 52688,  1599,  1000,
    1637,  1945,  1948,  1749,  1265,    70,  1637, 46508, 46508, 46508,
    1812, 52688, 52688, 43212, 52688, -2884, -2884, -2884,   230,  1657,
    1614, -2884, 41975, -2884,  1564,  1613, -2884, 52688,  1628,  1613,
    1765, -2884,  1776,  1613,  1104,    57, -2884, -2884, -2884, -2884,
     107,   648, -2884, -2884, -2884, -2884, -2884, -2884, -2884, 52688,
    1556,  1556,   102, -2884, -2884,    88, -2884, 45684, 52688, 46096,
      53,    31, -2884, 52688, -2884,   850,  1877,  1877,  1877, -2884,
   -2884, -2884,  1830, 52688,  1882, 45684, 52688, -2884, 54748,  1636,
    1071,  1123,  1073, -2884, 21548,  1638,    58,    58,  1640,  1641,
   -2884, -2884,  1644,  1648, -2884,   980,   980,  1771,  1651,  1652,
   -2884,  1050,  1653, -2884,  1232,  1075,  1654,  1655,  1656,  1189,
      58, 21548, -2884,  1658,  1098,  1660,  1661,  1662,  1337,  1664,
   -2884,  1348,  1665,  1008,  1230,  1666,  1667, -2884,  1651, -2884,
      73, -2884, -2884, -2884, -2884, 21548, 21548, -2884, 18968, -2884,
    1104, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,    56,
   -2884,  1108,  8406, -2884, -2884, -2884, 21548, -2884, -2884,   -15,
   -2884,   -94,  1669, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
    1121, -2884, -2884,  1180,  1190, -2884, -2884,   109,  1191,  1159,
    1159, 37431, 37431, -2884,   699, -2884,   170,  1613,   853, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, 37844,  2002, -2884,  1417,
     470, 30384, 30384, -2884, -2884,  1863, -2884,  1663,  1883, 46508,
   -2884, 27021, -2884, -2884,   825, -2884, -2884, -2884,  1677, -2884,
     549,   549, 21548,   549,   -28, 19397, 21548,  1932,   801,  1526,
    1688,   877, -2884, 42800, 55160, 55160,  1897, -2884, -2884,   594,
     450,  1786,  1866,   843,  1178, -2884, -2884, -2884,  1691, -2884,
    1983,  1526,  1107, 38257,  1751, 38257, -2884, -2884,  2098, -2884,
    2098, -2884, -2884, -2884, -2884,  1702,   521, -2884,  1534, -2884,
   17674,  1177, -2884, -2884, 10422, -2884, -2884, -2884, -2884,  2124,
   -2884,  1698, -2884, -2884, 55564,  1707, 52688, -2884,  1708,  1709,
   -2884, 55961,   -94, 29560,  1777,  1788, 34541,  1725,  1809,  1813,
   53924, -2884, -2884, -2884,   823,   641,   534, -2884,  1814,  1881,
    1851, -2884,  1906,   140, -2884, -2884, -2884, -2884,   973, 16857,
     963, -2884, -2884,  1817,  1801,  1819,  1821,  1829,  1754, -2884,
    1826,  1803, 40736, 28715, 53924,  7118, -2884,  1827,  1834,  1867,
    1309,   588,  2076,  1917,  1836,  1825,  1241,  1833,   124,   311,
    1769, -2884,  1842,  1844, 45272,  1845,  1885,  1848, 53924,  7118,
   -2884, -2884,   915, -2884, -2884,    52, -2884,  1723, -2884, -2884,
   -2884, -2884, -2884,  1785, 41975,  1564,   817, 52688,  1787,    83,
    1935, 52688,  1995,  1940,    54, 34541, -2884,  1791, -2884,  1831,
    1831,  1831,  1792,  1792,  1798, -2884, -2884,  1189,  1831,  1802,
   -2884, 42388, -2884,   818,   821, -2884,  2139,    79, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884,   146, -2884,  1554,
   -2884, -2884, -2884,  2160,   495, -2884, 41975,  7118,  2091, -2884,
    1846,  7118, 52688,   141, 52688,  1998, -2884, -2884,   184,  1815,
   -2884,  7118, -2884,   -42,  1818, 38257,  2061,  1966, -2884,  1564,
    2165, -2884,  1088, -2884,  1924, -2884, 24083,  1860, 29560,  2174,
     266, 52688,  1874, 40736, 46508, 46508,   266, -2884, -2884, 52688,
   -2884, -2884,  1556,  1155, 52688, -2884, -2884, -2884, -2884, -2884,
   -2884,  1556, -2884, -2884,  2253,  1835, -2884,   109,   521,  1837,
   -2884,  1849, 52688, 43212, 52688, 52688, 46508, 52688,  1899,  1663,
     685, -2884,  1873,  1838, 26604, -2884, -2884,   231, 46508,  1996,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, 44448,  2085,
      -5, 52688, -2884, 21548, 19826, -2884, -2884, -2884,  1854,  9667,
    1889, 21548, -2884, -2884, 21548, 21548,   521,   521,   521, -2884,
   -2884, -2884, -2884,  1828,   521, -2884, 21548, 21548,   521,   521,
    1831,  1831, -2884,  5396, 21548,   521, -2884, 28715, 21548, 21977,
   16421, 21548,  1912,  1922,   521, -2884,   521, -2884, 21548, 18110,
   -2884,   -94,  2213,  2213,   991,  3912,  1850, -2884,  1952,   521,
   -2884,   521,   964, 41975, 21548, 34541,  1927,   103, 21548,  1862,
     880, -2884, 21548,   619, -2884,  1870, 21548,  1929,   116, 21548,
   21548, 21548, 21548, 21548, 21548, 21548, 21548, 21548, -2884, 22398,
     188,   225, 36192, 18539,  2107, -2884,   993, 15985, 39909, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,   521,  1859,
   -2884,  1884, -2884, -2884, -2884,  2002, -2884, -2884,  1937, -2884,
   -2884, -2884,  1234, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884,  1871, -2884, -2884, -2884, -2884, -2884, -2884, 55564,  1876,
   52688,   117, -2884, -2884, 44860, 52688, -2884, -2884,  2090, -2884,
   -2884,  1879, -2884,  8175,  2090,  2028,  2038,  2038, -2884,   -46,
    9667,  2080,  9667, -2884, -2884, -2884, -2884,  1197, -2884, -2884,
    1526,  1890, 14773, -2884, 15177, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,   817,
    1888,  2290,  1263, -2884, -2884, 38257, -2884, -2884, 32885, -2884,
    1898, -2884, -2884, -2884, 39909,  1279,  1890, 10422, -2884, 10422,
    1890, -2884,  1893, -2884, 52688, 52688, -2884, 34541, 52688, 52688,
   -2884,  2199,  1900, 52688,  2100,  2101,  1901, -2884, -2884, 52688,
   -2884,  2057, 21548,  2060, 52688, 52688,  2062,   780,  2054, -2884,
   -2884, -2884, -2884, -2884,  2049, -2884, -2884, -2884,  1031, -2884,
   35367, 40323, -2884, -2884,   119,  1554, -2884,   134,   157,   257,
    1971,  1974,  2014, 52688, 52688, 52688, 52688, 52688,   789, 52688,
   52688,  1907,  1914,  1909, -2884, -2884, 52688,  2106, -2884, -2884,
    2055,    76, -2884, -2884, -2884, -2884, -2884, -2884, -2884,  1943,
   52688, -2884,   521,  2059, 52688,  1973, -2884, 52688, 52688, 52688,
     817, -2884,  2256,   817,   817,   540,  1637,  1637, -2884, -2884,
   -2884, 52688, 52688, 52688,  2000, 47332, 52688, 52688, 47744, 52688,
   52688, 52688,   113,  1427, 52688, 52688,  2041, 52688, 52688, 52688,
   -2884, -2884,    63,  2064, -2884, -2884, -2884, -2884, 21548, 29560,
    2276,  2140,  2143,  1982, 40736,   339, 52688, 52688,  2150,   339,
   -2884, -2884, -2884,   971,  1036, -2884,  1957, 21548,    97, 41975,
    1949, 24917, -2884,  2010, -2884,  2012,   521, -2884,  1725,   184,
    2145,  1967,  1967,  1967,  1967,  1967,   495, -2884, -2884, -2884,
    2202, 46508, -2884, -2884,  1285, 44448, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884,  1943, -2884, -2884, -2884,  2110,  2113,
   52688, -2884, -2884,  1309, 46508, 43624,   197, 52688,  2307,  2208,
    1104, 46508,  1832, -2884,  2212,  2214,  2230, -2884, 23666, 49804,
    1978,  1311, -2884, 49804, 50216, -2884,   -94, 21548, -2884,  1985,
   41975, -2884, -2884, 52688,  1986,   266,   266, -2884, -2884, -2884,
   -2884, -2884, -2884, 39909,  1055, -2884, -2884,  1055, -2884,  1055,
    2415,  1613,  1984, -2884,  1564,  1613,  1613,  1663,  1613, 50628,
    2346,  2231, -2884, 20261,  1081, -2884, -2884,    43, -2884,    75,
     338,  2180, -2884, -2884, -2884,  2151,  1987, 50628,  2333,   266,
   -2884,  9667,  1143,   897,   928, -2884,   521, 21548,    89, -2884,
    8843,  1215,  8944,  1222,  2004,  2005,  1247, -2884, -2884, -2884,
   -2884, -2884, -2884,  2016,  2257, -2884, -2884,  2017,  1250,  1255,
    2021,  2024, -2884, -2884,  3703,  1268,  2025,  9035,  2029, 21977,
     156, -2884, 21977,  2030, -2884,  1283,  7628,  2008,  2032,  2046,
    2056,  2033,  2036,  9241, 20690, 21548, 20690, 20690,  9933,  2008,
    2039, -2884, -2884, 21548, 52688,  2040,  2043, -2884, -2884,  5396,
   -2884,  2066, -2884, 21977, 21977,  3108, 18968, -2884, -2884,  2289,
   -2884,   882, -2884,  2051, -2884, -2884,  3789,   108, 21548,  1862,
   21548,  2116, 28715,  9876, 21548,  2734,  3008,  3008,   176,   176,
     111,   111,   111,  1154,   225, -2884, -2884, -2884,  2058,  1347,
    1410, 46508,  1823,  3664, -2884, -2884, -2884, 24083,  1860, 21548,
   21548,  2045, -2884,  1290, -2884, -2884,   232,  2415,   521,    52,
     521,   964, 30805,  1890, -2884,  2048, -2884, 52688,  1860,   939,
   -2884, -2884,  1293, 21548, -2884, -2884,  2354, -2884, 52688,  1996,
    1996, 21548, 21548, 19397, -2884, -2884,  2067, -2884, -2884, -2884,
   -2884, -2884,  2071, -2884, -2884, -2884, 52688, -2884, -2884,  2461,
    2063,  2052,  2068,  2073,  1018, -2884, -2884, -2884, -2884, -2884,
    2258, -2884, 21548,   552,  2070,  2077, 52688,   266, -2884,  9667,
   -2884, -2884, -2884,  2277, -2884, -2884,  2221, -2884, -2884, 34954,
   41975, -2884, 41975, -2884,   696, 52688, 52688, 52688, -2884,  1613,
   -2884, -2884, -2884, -2884, -2884,  1033, -2884, 41975,  2206, 41149,
    1613,  1004,  1943, 52688, 52688, -2884,  1613, -2884,  1943,  1613,
    1943, -2884, -2884, -2884, -2884, -2884,   817, -2884, -2884, -2884,
   -2884, -2884,   817,   817, -2884, 41975,    49, -2884, -2884, -2884,
   -2884, -2884,   266,   266, -2884, -2884, -2884, -2884,  2144, -2884,
   -2884, -2884,  2112, -2884, -2884, -2884,  2146, -2884, -2884, -2884,
   -2884, -2884, -2884,  7331,  2082, 41975,   339,   339, 52688,  2083,
   -2884, -2884, -2884,  2292,  2293,   339, -2884, -2884, -2884,   229,
   -2884, -2884, 34541, 27855,  4695,  2093, -2884,  2087,   521,  1890,
   25351,  1473, -2884, -2884, -2884,   717,  2271,  2095,  2243,  1967,
   -2884,   512,   200, 51040, 51452, 51864, -2884,   650,  2152,  1818,
     141,  2215,   811, -2884, 46508,   184,  1295, -2884, 41975,  2097,
   46508,  2102,  2099, -2884, -2884, -2884, -2884,  1307, -2884, 41975,
   -2884,  2259,  2260, -2884,  1308, -2884, -2884,   549, 52688,  2169,
    2154,  1104, 38257, 41562,  1758, -2884, -2884,  2262, -2884, -2884,
   26187, 23248,  1311,  2114, 52688, -2884,  2111, 24083,  2311,  2261,
   -2884, 24083,  2261,  1167,  2261, 24083,  2318, -2884, 27438, -2884,
    2117,   993,  9667,   266,  2115,   266,   266, -2884, -2884,   878,
   -2884, -2884,  2122, -2884,  2131, -2884, -2884, 43212, -2884, 52688,
     729, -2884, -2884,  2266, -2884, -2884,  9667,  1328, -2884,   673,
   52688,   -94, -2884, -2884, -2884, -2884,  2381,  2390, -2884, 45684,
      90, 52688, -2884, -2884, 21548, -2884, -2884,  2133,  2132,  9349,
   21548, -2884,  2395, 41975, -2884, 52688, -2884, -2884, -2884, -2884,
     521, -2884, 21548, -2884, -2884, -2884, -2884, -2884, 21548, -2884,
     521, -2884, 21548,  2378, -2884,  2497, 41975, 21977,   782,  1660,
   22827, 21977, 21977, 21977, 21977, 21977, 21977, 21977, 21977, 21977,
   -2884,   478, -2884, -2884, 21548, 21548,  2385,  2378, -2884, -2884,
   -2884,  1173,  1173, 41975,  2136,  2008,  2137,  2142, 21548, -2884,
     -94,  4861, -2884,  2465,  1104, 21548,   461,  1630, 21548,  1336,
   21548, -2884, -2884,  2147, -2884, -2884, 41975, 21548, 21977, 21977,
    3877, -2884,  4298, 21548,  2148,  5629, 18968, -2884,   600,   600,
     600,   600, -2884, 46508, 46508,  1978,  2376,  1344,  1351, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884,  2138, -2884,  2159, -2884,
   -2884,   470,  2153, -2884, -2884,  2461,  2161,   858, -2884, -2884,
   21119, -2884, -2884,  2155, -2884, -2884,  1613, -2884, -2884, -2884,
   -2884, -2884, 10422, -2884, -2884,  2175, -2884, -2884, -2884, -2884,
   -2884,  2220,  2223,  2264,  1967,  5909, -2884, 52688, 52688,  1355,
   -2884, -2884,  2368, -2884, -2884, -2884,  2211, -2884, -2884, -2884,
    2224,  2227, -2884,  2228, -2884, -2884, -2884, -2884,  1613,  1613,
   -2884, -2884, -2884, -2884, -2884, -2884,   142,   543, 41975, -2884,
   -2884, -2884, 52688, 52688, -2884,  2373,  2166, -2884, -2884,  2375,
    2377,   339,   339, -2884, -2884,  1637,  2445, -2884,  2155,  1178,
   -2884, -2884, -2884, -2884,   829,   521,  1224,  2172, -2884,  1327,
   25351, 25351, 25351, 25351, 25351,  1890,   964, 46508,   521, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884,  2173, 52688, 21977, -2884,   835,   505, -2884,  2382,
   46508,  2216, -2884, -2884, -2884, 41975,  2519,    40, 46508,  2424,
    2323, -2884, 52688, -2884, 43624,   847,  2401, 43624, -2884, 52688,
    2526,  2527,   549, -2884, 52688, -2884,  2226,  1554,  1104, 52688,
    2183, -2884,  2181, -2884,  1930, -2884,  1599, -2884, -2884,   564,
   -2884, -2884, 49804,  2187, 52688,  1311, 24083, -2884, -2884,  2018,
   -2884, 24083,  2393, -2884, -2884, 24083, 52688,  2190, 52688, -2884,
     266, -2884, -2884,  1088,  1055,   232, -2884, -2884,  2430, 50628,
   -2884, -2884, -2884, 20261,  2194, -2884, -2884, -2884, -2884,  2439,
   -2884, -2884,  9667, -2884, -2884, 21548,  9667, -2884,  2195,  2196,
    2197,  9667,  6002,  2200,  9667,  2385, -2884,  1701,  2446,  2358,
    2205,   478,  1701,   926,   926,   199,   199,    78,    78,    78,
    2497,  9667,  9667, -2884, -2884, -2884, -2884,  2207, -2884, -2884,
   -2884,  2008, -2884, -2884,   964,  2213, 21977, 21977,  1576, -2884,
     208, 41975, -2884,  1358,  1576,  1748,  2273, 21548, 21548,  6180,
     198, 21548,  6030, 46508, 46508, 46508, 46508, -2884, -2884,  2535,
    2443, -2884, -2884,   232,  1297,  1104, -2884,  2210, 52688, -2884,
    9667, 28715, -2884, 52688, -2884, 52688, 52688, 52688,   521, -2884,
    1372,  1414,  2216, -2884, -2884, 52688, 52688, 52688,   650,  2370,
    2371,   521, 52688,  2263, -2884, -2884,   339,  2421,   339,   339,
   -2884, -2884, -2884,  1104, -2884,   870,  2496, -2884,  2438,   151,
    2222,  2462,  2464, -2884, -2884,  1136,  1136, -2884, -2884, -2884,
   -2884, -2884,  2467, -2884, 21548,   496,  1701, -2884, -2884, -2884,
   -2884,  2216,  1818,  2448, -2884,  2270,   549,   -13,  2500,  2486,
     184, -2884,  2232,  2511,  2528, -2884,  2244,  1318, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, 52688,  2447,  1725,  2491, -2884,
   24500,  1104,  1758, -2884, -2884, -2884, -2884, -2884,  2312, -2884,
   52688,  1418, -2884, 21548,  2249, -2884, -2884, 24083,  2018,  1419,
   52688,  1429, 41975, -2884,  2501, -2884, -2884,  2397, -2884, -2884,
   20261, 50628,  9667, -2884, -2884, -2884, -2884, -2884, -2884, 21977,
    2255, 21977, -2884, -2884,   590,   590,  1431, -2884, 41975, 21977,
   21977,  1576,  1576, 21548,  1576, -2884, -2884, -2884, -2884, -2884,
   21548, 21548, -2884, -2884,  1178, -2884, -2884, -2884, -2884,   964,
   21548, -2884,  2252, -2884, -2884, -2884, -2884, -2884,  2379,  2216,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, 21548, -2884,
   -2884,   339, -2884, -2884,   932, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, 43212,  2601, 46508,   829,  6571,  2417, -2884, -2884,
    2441,  2334, 52688, -2884, 43624, -2884,     6,  2396, -2884,  1318,
   -2884, -2884, 46508,  2422,  2425,  2426, -2884,  1104, -2884, 52688,
   21548,  1433, -2884, 52276, 17275, -2884, -2884, 46508,  1446, -2884,
    9667, 52688, -2884, -2884, -2884,  1472, -2884,   549, -2884,  1479,
      90,   602, 21977,   308, -2884, -2884,   590,   590,  1576,  2008,
    9667, -2884, -2884, -2884,  3824,  2272, -2884, 46508, -2884,  9667,
   -2884, -2884, -2884,  1947,  1947,   386, -2884,  1947, -2884,  1947,
   -2884,  2601,  2617, -2884, -2884,  2529, -2884,   583,  2428, 52688,
    2626, -2884, -2884, -2884, 52688,  2426,  1483, -2884, -2884,  2595,
    2357, -2884, -2884,  6935,  2357, 24500, 52688, -2884, -2884, -2884,
    1860, -2884,  1484, -2884, -2884, -2884,  1251, -2884, 21548, -2884,
    1818,  1104,  1943,  2452, 52688,  1104,  1943, -2884, -2884,  2555,
   -2884, -2884,    50, -2884,  2437,  2444, -2884,    68,  2296,  2357,
   -2884,   670, 52688, -2884, 52276,  1860, -2884, -2884,  2570, -2884,
   -2884, -2884,  2441, -2884, -2884, 52688,  2294, -2884, -2884,  2408,
     516,   516,  2350, -2884,  2584, -2884,   521,   521, 41975,  2301,
   -2884, 32465, -2884,  2416, -2884,  2419, -2884, -2884, -2884,   558,
    2428,  2294,  2568, -2884,  2670, -2884,   101, -2884, -2884, 43212,
   28715, -2884,    68,  1491, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884,   793,   829,  2449, -2884, -2884, -2884,  1564,   569, -2884,
   -2884, 32465, -2884,    71, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, 43212, -2884, -2884, 40736, -2884, -2884,  1384, -2884,
   -2884,  1396,  1512,  2315,  2316, -2884,    71, 32465,  2440, -2884,
    1495, -2884, -2884
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2884, -2884, -2884, -2884, -2884,  2530, -2884,  -909,  -256, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884,   778, -2884, -2884,  -761,  1084,  1477, -2884, -2884,   551,
   -2884, -2884, -2884, -1215, -2884,   265, -2884, -2884, -2884, -2884,
   -2884, -2884,   841, -2884,   903,   439, -1414, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -1417,  -128,
      -1, -2884,     1,   861,    84, -2884,  -199, -2884, -2884, -2884,
    -517,   520, -2296, -2181,     7,  -470,  -497,  -451,  -449,  -475,
   -2884,  -332,  -406, -2883, -2140, -2884, -2884, -2884, -2884, -2884,
      21, -1415, -2884,  1280, -2884, -2884, -2884, -2884,  -202, -2884,
   -2884, -2884,   186, -2884, -2884, -2884, -1407, -2884,   832, -2294,
   -2884, -2884, -2884,  -543,  -516, -2884, -2870,  -153,  -151, -2884,
   -2884, -2884, -2884, -2884, -1058, -2884,   437, -2884, -2884, -2884,
    -494,  1302,  -535, -2884, -2884, -2884, -2884,  -702, -1440, -2884,
   -2884,  2634,   373, -2884, -2884, -1886, -1405, -2884,  -155,   976,
    1676, -1117, -1984,   -12, -2884, -2884, -1540, -2884, -2884, -2884,
     762, -1398, -2884, -2884, -2884,  -399, -2878, -2884, -2884, -1096,
   -2884,   545,   974, -2884,   977, -2884, -1738,    34,  -872, -2325,
    -183, -2884, -2884, -2884, -2884, -2884, -1408, -2884, -1525, -1401,
   -2884,  -360, -2884, -2884, -2884,   597, -2884,   130, -2884, -2884,
   -2884, -2884, -2884, -2884,  -479,  -512, -2884, -2884, -2884,   562,
   -2884, -2884, -2884,   175, -1013,  -826,  1941, -1395, -2884, -2884,
   -2884,   864, -1788, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -1717, -2884, -2884, -2884,  1093,  2686,  -695, -2884, -2884, -2884,
   -2884, -2884, -2884,    -8, -2884, -2884,   353,    -7, -2884, -2884,
   -2884, -2884,  -345,    -4,  1724,   803,    23,   -71,   -67,  -222,
     293,   310, -2884, -2884,  -204,   904, -2884, -2884, -2884, -2884,
     626,  1539, -2884,   617,  -304, -2884, -2884,  1544, -2884,  1095,
    1112,   657, -1936,   837, -1919,   403,  -609,  -171,  -163, -2884,
   -2101, -2600,    86, -1038, -1670, -2050,  1378, -2884,  1993,  2344,
   -2884, -2884,  -984, -2884, -2884,  3491,  3636, -2884, -2884,  4344,
    6597, -2884, -1024,   288,  6936,   969, -1150, -1455, 10596,   133,
    1331, -1465, -2884, -2884,  -722, -2884, 11168,   489, -2884, -1190,
   -2884,   -27, -2884, -1516, -2884, -2884, -2884, -2884, -2884, -1367,
   -2373,  -656,   697, -2884, -2884,   775, -2884, -2884, -2884,  -718,
    -922, -1621,   698, -2884,  1175, -2884,   -49,  -358,   654,  -168,
      41,  6807,  -843,  -137,  -717,  7944,  -664, -1954, -1247,  1783,
   -2884,  -707, -2884,    -2,   178, -2884, -2884,   224,  -817,  -725,
   -1632, -2884,   -33, -2884,  -860,  -931, -2239,  -613, -2884, -2884,
     -44, -2884,  1911, -2884,  1079,  1530, -2884, -2884,  1085,  -787,
    -133, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
   -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,  1569,   104,
   -2884,   -55, -2884, -2884,  2805, -2884,  2559,   -39, -2884,  2191,
     -38, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
    -813,  1118, -2884,  1896, -2884, -2884, -2884,  -729, -2884, -2884,
   -2884,  1744,  -152, -2884, -2884, -2884,  -995,   981,  1933,  -810,
    -983,  1087, -2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
     844, -2884, -2884,   683,   845, -2884, -2884,    72, -2884, -2884,
     -19,    74, -2884,  1642, -2884, -2884, -2884,   263, -2884, -2884,
   -2884,  -514,  8387,   -40,   -37,   -80,   241,  1683,  7880, -1300,
    -684,   -66,  1587,  5657,  9970,   -61,   -25,    77,   123, -2884,
   -2884,  2546,  1096,   860,  -877,  6671,  1339,  2952,  4354,  -706,
    -815,  1946,  -491, -1307, -2884,  2905
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1788
static const short yytable[] =
{
      69,   742,   812,   309,  1022,   906,  1141,   310,  1540,  1128,
     693,   992,  1874,   895,   782,  1006,   773,   999,  2034,  1002,
    1509,   782,   360,  1042,   696,  1446,   979,  1520,  1656,   699,
    1486,  1032,   693,  2053,   351,   324,   326,   351,  1599,  1078,
     844,  1358,  1967,   854,  1066,   869,   696,  1803,   852,   578,
     351,   699,  1287,   692,  1647,  1071,  1001,  1003,   901,  1968,
    1280,  1717,   782,  2366,  1539,   700,   304,   305,  1085,  1372,
     307,  2025,   351,  1095,  1108,   692,  2206,  1105,  1327,  2465,
    1100,  1109,  2442,   899,   735,  2669,  1104,   700,  2085,  1113,
    1122,  1070,  1124,  2500,  1126,  1362,  1987,  2606,  1988,  1856,
    1127,  2236,   778,  2766,  2457,  2459,  1989,  1116,  1990,  2797,
    1007,  2770,  2281,  2283,  1025,  1991,  1415,  2639,  1992,  1121,
    1269,  1033,  2219,  1278,  1439,  1552,  2031,  1103,  1135,  1816,
    2029,   954,  2037,  1397,  1332,  1698,  2249,  1553,  1568,   693,
    2253,  1355,  1612,  1613,  1355,   847,  1074,  1562,  1563,  1263,
    1080,   353,  1352,   696,   353,  2536,   830,   309,   699,  1086,
     905,   310,  1359,  1267,  1519,  1507,  1632,   353,  1336,  1337,
    1547,  1511,  1960,  1264,  1658,  -821,  -995,  1521,   830,   351,
      70,   359,   692,  2873,  2392,  2393,  2394,  2395,  1663,   353,
    2375,  -990,  1620,  2350,   700,   932,  2078,   354,   988,   968,
     354,  2152, -1143,  1547,  1270,   594,  2152,  2147, -1143,  1582,
    1666,  3270, -1580,   354,  1156,  1692,  3029,  1123,  3031,  2696,
     304,   305,  2492,   976,   307,  1316,    71, -1582,   711,  1384,
     712,   950,   151,  2536,  1340,   354,  2116,  2340,  -821,   758,
    2611,  2231,  -824,  2004,  1587,  3195,  2612,  2613,  2614,  1951,
   -1579,  1909,   933,  1663,  2494, -1247,  1695,  3315,  2615,  2616,
    2617,  2510,  2618,  2619,  2620,  3276,  3219,  1446,  2621,  2622,
    2623,  1304,  2004,  1042,  2185,  1666,  2536,  -917,  1984,  2303,
    2186,   351,   918,   919, -1159,  1663,  1035,  1755,  2376,   760,
   -1159,  2420,   874,  1138,  1435,   168,   353,  1963,  1830,   717,
    1839,   934,  1663,   945,   935,  -824,   577,  1666,  1411,  2954,
    2009,  2067,  2197,   601,     3,  1945,   748,  1385,   351,  1696,
    1756,   351,   946,   919,  1666,  1451,  1087,  1305,   810,  1712,
    2729,  3255,  1458,  1374,  1647,  1813,  1531,  1132,  1453,  3201,
    1436,  1985,   354,  1040,  1455,  1995,   364,  1041,  1723,   185,
   -1578,  1088,   601,   705,   933,  1375,  2744,  1450,   736,  1941,
    3277, -1633,  3202,  1292,  1139,  1757,  3282,  1036,  1306,  2537,
     601,  1840,   875,  1946,  1873,  1508,  3287,   872,  1532,  1547,
    1713,  1125,  3316,   936,  1548,  2536,  1529,  1089,  2538,  1526,
   -1680,  2493,  -281,   595,   205,  2697,  1376,  2005,   353,  1338,
    2232,  2341,   577,   934,  2709,  1542,  1964,  2304,  1996,   766,
    2068,   767,   205,  2082,  2083,  2284,  1940,  1548,  2939,  2359,
     977,  1580,  1317,  2495,  2091,  2093,  3124,  2956,  3278,  1952,
    3155,  1693,  1936,  2012,  2698,   353,  2108,  2109,   353,  1600,
   -1788,  1541,  3331,  3271,   354,  2491,  1612,  1613,  2539,  2351,
    2125,  2127,  1583,  1533,  1632,   937,  1077,  1670,  1671,  1607,
     897,   713,   944,    49,   221,  1139,   576,  2153,  1978, -1143,
    2707,  2708,  2588,  -995,  1351,  1370,  -995,  1588,  -821,  2713,
    -821,   354,  3048,   938,   354,   936,  2930,  2931,  -990,  1620,
    -201,  -990,  1584,  1386,  2087,  1659,  1767,  -995,  1534,  1919,
    1813,   955,   972,  1549,  1674,  1873,   576,  2203,   953,  1465,
     227,  2805,  -990,  2549,    49,  2809,  1961,   576,  1792,  2814,
     576,  2570,    52,  1042,    53, -1682,  1842,   576,  1359,  1799,
    1324,  2354,  1705,  1706,  1961,  1352,  2829,  2624,  2536,   956,
    2538,  2187,  2674,  2635,  2675,  -824,  1687,  -824,  1797,   576,
    1856, -1159,  2886,  2025,    52,  2536, -1580,  1965,  2040, -1580,
   -1580,  1008,   826,  2217,  2069, -1580,  1027,  1029,  1535,  2039,
    2257, -1582,  2540, -1633, -1582, -1582,  2630,  1997,  2042,  2070,
   -1582,   715,  2541,  2542,  2543,  1966,  2544,  2545,  2546,  2547,
    2548,  2549,  1028,  1548, -1579,  2637,  1942, -1579, -1579,  1744,
    2539,  2738, -1680, -1579,  2421,  2422,  2112,  2113,  1684,  1685,
    1686,  1687,   716,  1065,  1401,    49,  2752,  2625,   576,  1820,
    2360,  2467,  2468,  1099,  2714,  2148,  1970, -1705,  1096,  3293,
     693,  2546,  2547,  2548,  2549,  2721,   286,  1093,  1682,  1683,
    1684,  1685,  1686,  1687,   696,  3309,   950,   782,  1921,   699,
     746,   747,  2754,  1875,  1451,  1682,  1683,  1684,  1685,  1686,
    1687, -1719,  3233,  2979,   855,  2502, -1741,  2536,  2739,  1971,
     351,  2496,  1822,   692,   351,   990,   919,  1930,  1118,  2536,
    2965,  2966,  2967,  2968,  2969,   700,  3120,  2797,    69,  2319,
    1832,  1022,  1450,  2538, -1578,  2795,  3128, -1578, -1578,  1832,
    3234,   950,  1402, -1578,  1035,   706,  1140,  1780,  1822,  2728,
    2538,  1707,  1142,   576,  1064,  1909,   707,  1443,    52,  1922,
    1823,   715,  1148,  2167,  2540,  3014,   826,  1072,   912,  1073,
     856,  2497,  2025,  2057,  2541,  2542,  2543, -1682,  2544,  2545,
    2546,  2547,  2548,  2549,  1824,  1776,   950,  1972,  3227,  1708,
    1011,   871,   716,  2539,    49,  1943,  2633,   576,  1142,  1948,
    1012,  1013,  1014,  1290,  1015,  1016,  1017,  1018,  1019,  1020,
    2752,  2594,  3117,  1829,  1298,  1094,   601,  2758,   913,  3240,
    1824,  1956,  2753,  3310,  3294,  1036,  2980,   353,  3015,  1781,
     286,   353,  3090,   708,   749,  1973,  2320,  1830,  2321,  2094,
    2095,  2096,  1777,  1554,   786,  2759,  2754,  2107,  2755,   151,
    1833,  2110,  2111,   830,  2760,   830,  1107,   830,  2115,  2940,
    1144,   715,  2538,   830,   830,  2950,  2951,  2131,  2168,  2132,
    1288,  3283,  2169,   354, -1788,  3009,  1444,   354,  1157, -1705,
    3284,  3119,  2145,  3295,  2146,   914,   834,  2038,  1389,  1272,
    1274,  1778,   716,  2670,  1403,  2051,   351,  2055,  2056,   843,
    2058,  1825,  3296,  1974,  2170,  1975,  2054,  1827,    70,  2756,
    3022,  1834,   168, -1719,  1358,  3026,  2928,  2540, -1741,  3028,
     857,   858,  2539,  3019,  3241,  2761,  3334,  2541,  2542,  2543,
     205,  2544,  2545,  2546,  2547,  2548,  2549,  1825,  1457,  1983,
    2941,  1813,   709,  2942,  1910,  3016,  1873,  1452,  2544,  2545,
    2546,  2547,  2548,  2549,    71,  1022,  1445,  1831,  2700,  2701,
    1390,  2377,   578,   578,  1417,  1777,  2757,    49,  1362,  2240,
     576,  2758,  1062,  1779,  3262,    52,  1325,  2826,   915,   576,
    2274,  1826,  1432,  1822,    52,  2565,  1418,  1391,  2858,  3178,
    1522,  1523,  1524,  1276,   151,  1823,  1259,  3017,  2478,  2759,
    1090,   693,    69,    69,  1433,    69,  2579,   848,  2760,  2171,
    1325,   577,  1715,   353,  1778,   696,  3285,  1826,  1451,  1856,
     699,  2150,  2025,  1987,  1531,  1988,  2025,  2954,   227,   205,
    2025,  2843,  2464,  1989,  2977,  1990,   906,  2322,  2323,  -853,
    1142,   351,  1991,  2536,   692,  1992,  2540,  1260,  3335,  2607,
    2608,  2275,  1118,  1281,   205,  1824,   700,   168,  1142,   354,
    2544,  2545,  2546,  2547,  2548,  2549,  2823,  2993,  2222,  3106,
     126,   127,  2544,  2545,  2546,  2547,  2548,  2549,  3181,  2761,
    2314,   221,  3305,  2317,  2318,  2978,  2159,  1305,  2955,  2819,
    1560,  2821,  2822,  3266,   310,  -853,  1779,  3160,  2859,   894,
    3100,  2994,  3102,  3103,  1392,  2970,  2160,  2860,  2581,  1586,
    3322,   185,  2834,   310,  3182,  2307,  1393,   577,   199,  1153,
    3107,  1546,  3305,  1282,  3291,  1389,  2840,   227,  1306,  1405,
    1394,  3152,  2060,  1605,  3183,   577,  -853,  1395,  2247,  1414,
    1784,  1533,   601,  1785,  2461,  2956,   577,   577,  3305,  3184,
    1011,  1622,   227,  1556,  1557,  1963,  1326,  1558,   353,  3258,
    1012,  1013,  1014,  3185,  1015,  1016,  1017,  1018,  1019,  1020,
    2676,  1541,  1825,  1450,   205,  1407,  2828,  1817,  3186,   840,
    1396,  1650,    70,    70,  2383,    70,  1534,  2289,  1405,  2387,
    1326,  1654,  1739,  1087,  3288,  2259,  2161,  1390,  2538,  2300,
    1381,  2162,   715,  2582,   354,  2163,  2855,  2583,  3200,  -829,
    1406,  1437,   933,  2306,   199,  2829,   870,  2309,  2768,   577,
     577,  -829,  1786,  1931,  1391,   903,   221,  1657,    71,    71,
    2874,    71,  1011,   716,  1407,  1438,  1356,   909,  1662,   758,
    1129,  2255,  1012,  1013,  1014,  2258,  1015,  1016,  1017,  1018,
    1019,  1020,  1826,  3187,  1089,  3180,  1535,  2793,  2539,  -829,
    3188,   934,  2272,  1143,  1964,  1642,  1643,   910,  1642,  1643,
    1932,  1663,  3323,  1747,  1747,   576,  1747,  -829,  1933,  1353,
      52,  1354,    53,  1274,  2363,  2364,  3189,   696,  1324,   760,
    2288,  1979,  2290,  1666,   922,  1982,  1381,  1644,  1934,  2682,
    1646,  2685,  2164,  1860,  2584,  2002,  1383,  1117,   576,  2508,
    2165,  1926,  2585,   351,   351,   351,   692,  1325,  -829,  1325,
    1325,  2971,  3077,   866,  2311,  1861,  -829,  2695,   700,  1794,
    1416,  1075,   893,  1076,   118,  1040,   693,   925,  1440,  1041,
    1841,  1392,   578,   936,  2918,  1810,  1630,  1631,  1042,  1862,
     696,  2344,   122,  1393,  2347,   699,  2349,  2706,  2661,  1769,
       9,   926,  1787,  1770,   351,  1806,   919,  1394,  2536,  2367,
    2368,   351,   927,  2680,  1395,  2505,   351,  2470,   577,   692,
    2662,  2025,  2540,  2504,   830,  2922,  2025,  3007,    69,  1516,
    2025,   700,    69, -1788, -1788,  2681,  2544,  2545,  2546,  2547,
    2548,  2549,   906,  2449,  2663,  2640,  2506,  1517,  1909,   766,
    2773,   767,  1378,  1916,  2507,  1965,  1040,  1396,  2881,  -829,
    1041,  2695,  2839,  2631,   980,   693,    49,  2450,   981,   576,
     353,   353,   353,  2632,  1379,  -975,   820,   199,  -975,   696,
     982,   983,  2811,  -290,   699, -1388,  3033,  2035,  2036,   928,
    2452,  2875,  2876,   959,   821,  1642,  1643,   754,  1380,  1618,
    1900,   984,   576, -1005,   985,   351, -1005,    52,   692,  3053,
    1040,  1295, -1253,   962,  1041,   826,   354,   354,   354,  1142,
     700,   353,  2723,  2075,   577,  1701,  2482,  1644,   353,  1702,
    1022,  2072,  2448,   353,  1325,   577,  2692,  1326,  1901,  1326,
    1326,   929,  2693,  2694,  2482,  -969,  3231,  3232,  -969,  2019,
    3235,  2278,  3236,   576,  1607,  2848,  2371,  2279,  2564,  1381,
    2566,  2567,  2372,  2538,   758,   601,   601,   354,  -995,  1624,
   -1002,  -995,  1274, -1002,   354,  2014,  2015,  2454,  2856,   354,
     577,  -561,  1788,  1356,  2644,  1356,  1356,  2449,  1604,  1421,
     227,  2646,  -995,  -972, -1002,  1422,  -972,   905,   930,    49,
    3082,  2489,   576,    49,  1902,  2877,   576,  2490,    70,  1421,
     225,  2450,    70,   226,   760,  1422, -1580,  1635,  -960, -1580,
     690,  -960,   353,  2539,   986,  3143,  2451,  1661,  2892,  1793,
     972,  1423,  1912,  1770,  2452,  2195,  1917,   601,  1920,   577,
   -1586,  2727,  2025,  2383,  1424,  1903,  2046,  1904,  2732,  2733,
    2734,  1423,  3191,  1719,    71,  2453,  2686,  1905,    71,  2401,
    1642,  1643,  2655,  2503,  1424,   693,  2688,  2689,   354,  2504,
    2105,   948,  1425,  1748,  1750, -1582,  1754,  1426, -1582,   696,
    1427,    52,  2157,    53,   699, -1579, -1578,  2221, -1579, -1578,
    1749,  1749,  1425,  1749,   830,   830,   830,  1426,  1446, -1587,
    1427,  1802,   830,  1354,  3173,   351,   830,   830,   692, -1584,
   -1583,  2961,  2962,   830,  1326,  1906,   989,  1642,  1643,  2234,
     700,  2454,   830,  1770,   830, -1005,  1476,  -958, -1005,    49,
    -958,  2644,   576,  1663,   766,  2514,   767,   830,   978,   830,
    2943,  2504,  2516,  1034,  1907,   768,  1720,  2540,  2504,  1646,
    1044,   950,  2677,  2210,   771,  1666, -1250,  2541,  2542,  2543,
    1667,  2544,  2545,  2546,  2547,  2548,  2549,  2519,  1956,  2211,
    2524,  3260,  1068,  2520,    49,  2525,  2504,   576,   351,  2213,
     919,  2504,    52,  2850,    53,  2243,  2046,  2536,  2529,  1770,
    1324,  1079,    49,  2853,  2530,   576,  2598,  2238,  2599,  2238,
      52,  2887,    53,  2553,  2455,  3133,  3134,  2985,  3074,  2504,
    2610,  1091,   351,  2641,   351,  2771,  2504,   693,  3013,  1541,
    1069,  2772,   353,  1451,  1594,  1595,  3225,  2778,  2783,   577,
    3143,   696,  -961,  2779,  2784,  -961,   699,  2730,  2731,  2732,
    2733,  2734,   578,  -959,   797,   585,  -959,  2964,  2832,  1428,
    2054,  1092,   607,  2342,  2833,   703,  2889,   351,  2536,  2600,
     692,  2601,  2504,  1114,  2911,   703,  1132,  1325,   354,  1669,
    2504,  2912,   700,  1429,  1137,  2932,   906,  2504,  3057,  1136,
    1663,  2784,  1102,  1325,  3058,    69,  2952,    69,  1670,  1671,
    3344,   607,  3088,  2849,  1664,   353,  1145,  1301,  2784,  1303,
     703,   745,  1666,  1151,  3345,  2536,  3346,  1667,  1150,   607,
     703,   225,    49,   703,   226,   576,  1295,   703,  -821,  3059,
      52,   703,    53,  2810,  2399,  2813,   842,   577,  1324,   353,
    1152,   353,  2431,  2892,  3089,  1674,  2402,  1153,  3149,  3154,
    2784,   354,  2538,   703,  1541,  2772,  2827,  2409,  1675,  3156,
    1389,  3164,  1154,  3214,  2430,  2772,  1155,  3058,   703,  3215,
    3169,   861,   867,   842,  2647,  2648,  3221,   873,  2841,   867,
     830,   867,  1541,  1158,   353,   354,  1159,   354,  1325,  3318,
    1283,  1325,  1325,  2730,  2731,  2732,  2733,  2734,  2960,  1279,
     950,  2735,  3223,  2383,  2383,  2383,  2383,  2383,  2772,  3224,
    2370,  2973,  2539,  3250,  3259,  2833,  2431,  2649,  2650,  1588,
    1541,  3320,  1668,  2538,   906,  3352,  1669,  3321,  1339,  1341,
     354,  3321,  1390,  1284,  1389,  1285,   577,  1291,  1292,  1293,
    1295,  2441,  1296,  1297,  1299,  1670,  1671,  1302,  1310,   830,
   -1785,  1318,  1314,  1315,   830,  1319,  1320,  1326,  1672,  1391,
    1321,  1322,  1330,  1323,  1333,  1335,  1338,  2429,  1363,  2097,
    2538,  1346,  1364,  1326,  1366,    70,  1373,    70,  2603,  2604,
   -1586, -1587,  1678,  2539,  2773,  1376,  2432, -1584, -1583,  1673,
    1388, -1785,  1674,  1399,  1410,  1412,  1682,  1683,  1684,  1685,
    1686,  1687,  1413, -1785,  1419,  1675,  1390,  1676, -1785,   577,
    3165,  1434,  1441, -1785,  2431,  1442, -1785,  1454, -1785,  1356,
    1456,    71,  1461,    71,  1463,  1467,  2098,  1497,  1465,  1504,
    2539,  1505,  1389,  1391,  1381,  1512,  2540,   703,  -154,  1514,
    1525, -1785,  1536,  1538,  2602,  1544,  2541,  2542,  2543,  1541,
    2544,  2545,  2546,  2547,  2548,  2549,  1545,  1543,  1592, -1785,
    2432,  1497,  1598,  1677,  1596,  1603,  1621,  1611,  1326,  1614,
    1615,  1326,  1326,  1616,   830,  2099,  1392,  1617,  2100,  1654,
     227,  1623,  1626,  1627,  1628,  1629,  1718,  1634,  1393,  1637,
    1638,  1639,  2157,  1640,  1641,  1648,  1649,  1737,  1697,  1588,
   -1785,  3087,  1394,  2305,  1390,  1738,  1745,  2540, -1785,  1395,
    1768,  2597,  1304,  1775,  3096,  1782,  1783,  2541,  2542,  2543,
    2019,  2544,  2545,  2546,  2547,  2548,  2549,  1789,  1791,  1678,
    1355,  1391,  1804,  1798,  1805,  1795,  1807, -1531,  1809,  1679,
    1680,  1681,  1814,  1682,  1683,  1684,  1685,  1686,  1687,  2448,
    2433,  1937,  1396,  1815,  2540,  2796,  1817,  2101,  2432,   577,
    1938,  1836,  1393,   577,  2541,  2542,  2543,   577,  2544,  2545,
    2546,  2547,  2548,  2549,  1818,  2382,  1394,  1838,  1819,  1835,
     848,  1837,  1863,  1395,  1865,  1864,  1866,  1867,  1870,  1022,
    1868,  1869,  1897,  1909,  1899,  1915,  2046,  1913,   830,  1898,
    1325, -1785,  1914,  1918,  2449,  1923,  2482,  1924,  2403,  1925,
    1927,  3333,  1928,  1929,  1939,  1947,  1944,  1949,  1950, -1785,
    1957,  1618,  1607,  1959,   577,   607,  1396,  1624,  2450,  2102,
    3301,  1635,   225,    49,  1969,   226,   576,   756,  1722,  1981,
    1994,  2010,  2535,  2451,  2000,  2551,  2011,  2007,  1392,  2013,
   -1785,  2452,  2017, -1785, -1785, -1785,  2027,  2769,  2030,  2033,
    1393,  2043,  2062,  2775,  2059,  2050,  2073,  2063,   703,   703,
    2077,  2044,  2453,  2049,  1394,  2129,  2576,  2577,  2801,  3206,
    1663,  1395,   693,  2086,  2087,  2130,  2143,  1873,  2144,   830,
    2151,  2156,  2197,  3148,  2174,  2207,   696,   782,  3023,  2172,
    2208,   699,  3084,  3148,  1325,  2209,  2214,  2212,   913,  2227,
    1325,  1325,  3091,  2228,  3093,  2223,  2233,  1961,  2241,  2242,
    2260,  2246,   351,  2254,  1396,   692,  2264,  2265,  2268,  2262,
    2266,  2270,  1497,  2273,  2276,  2277,  2285,   700,  2454,  2286,
    2536,  2287,  2301,  2297,  2298,  2299,  2785,  2302,    49,  2745,
     310,  2308,  1142,  2346,  3060,  2310,  2315,  2328,  1497,  2800,
    2355,  1325,  2356,   310,   906,  2357,   830,  2358,   830,  2352,
    2019,  1497,  2365,  2373,  2019,  2385,  2378,  2386,  2019,  2740,
    1326,  2389,  2398,  2390,  2903,  2904,  2905,  2906,  2792,  1274,
    2404,  2427,  1000,   607,  1004,  2054,   585,  2405,   703,  1024,
     585,   703,  2428,  3024,   703,   703,  1000,   585,  2835,  2438,
    2440,  2439,   310,  1497,  2447,  2463,  2466,  1707,  2482,  2483,
    2477,  2455,  2078,  1139,  3222,   703,  1356,  3212,   607,  2498,
    1000,  2499,   585,  2501,  2517,  2518,   585,  1082,   703,   353,
    1497,   703,  2522,  1000,  2504,   585,  2521,  2523,  2559,  3299,
    3300,  2526,   703,   703,  2527,  2531,  2907,  2908,  2560,  2534,
    2552,   703,  2558,  2561,   607,  1497,  2562,   703,  2575,  2569,
    2573,   703,   703,  2574,  2580,  2609,   703,   703,  2636,   703,
    2586,  2593,  1000,  2652,  1326,   354,  2656,  2596,  1354,  2671,
    1326,  1326,  2672,  2658,  2664,  2538,  2683,  1497,  2659,  2667,
     703,   703,  1497,  2654,  3257,  2660,  2668,   703,   830,  2702,
    1922,  2703,  2705,  2710,  2711,  2712,  2687,  2726,   830,  1654,
    2725,  1785,  2690,  2737,  2691,  2736,  2774,  2765,   703,  2767,
     703,  2884,  2776,  1149,  2788,  2777,  2806,  2780,  2781,  2789,
    2804,  1326,  2799,  2815,  2802,  2820,  2818,  2825,  2807,  2831,
    2837,   607,   703,   703,   867,  2539,  1275,   867,  2824,  2838,
    1604,  2847,  2844,  2555,  2536,  2554,  2878,  2879,  1022,  2909,
     577,   577,  2880,  1658,  2913,  2914,  2891,  2917,  2900,   577,
    2933,  2923,  3317,  2915,  2921,  2925,  2934,  1356,  2926,  2935,
    2972,  2927,  2936,  2937,  2382,  2946,  2947,  2948,  2953,  2949,
    2963,  2983,  2974,  2986,  2988,  2741,   577,  2990,  2981,  2996,
    3001,  3002,  3010,  2982,  3005,  3343,  3020,  3011,  3027,  3030,
    3037,  2987,  1497,  3040,  3041,  3043,  3044,  3045,   585,   585,
    3047,  3049,  1345,  3050,  3051,  3070,  2643,  3052,  3071,  3080,
      69,  3094,  3095,  3101,  3108,   577,   577,  2955,  3098,  3112,
    3111,  3113,  3114,   703,  3121,  3122,   703,  3127,  3130,   703,
    2857,  3125,  3129,  2861,  2862,  2863,  2864,  2865,  2866,  2867,
    2868,  2869,  2870,  3132,  3137,  3131,  3139,  3147,  3151,  2540,
    3158,  3157,  3176,  1000,  3162,  3192,  3197,  3177,  2980,  2541,
    2542,  2543,  3199,  2544,  2545,  2546,  2547,  2548,  2549,  3204,
    3207,  3003,  3229,  3208,  3238,   310,  3209,  1787,  3242,  3239,
    3247,  2895,  2896,   830,  3251,  3252,  3269,  3272,   830,   830,
     830,   830,   830,  3265,  3274,  3281,   830,  3289,   703,  2019,
    2784,  3292,   703,  3271,  2019,  3270,   703,  3302,  2019,  3313,
    3307,  3314,   703,  3308,  3347,  3008,  3348,  3334,   908,  1736,
    1000,  2400,  3332,  2634,  2343,  2699,  3066,  3067,  3068,  3069,
    1011,  2293,  2324,  2992,  1000,  1528,  3118,   703,  2998,  2938,
    1012,  1013,  1014,  2666,  1015,  1016,  1017,  1018,  1019,  1020,
    1000,  3004,  3290,  3312,  3275,  3273,  3298,  3205,   577,  3249,
    2999,  2388,  2003,  3136,  3350,  3337,  3110,  3109,  3319,  2717,
    1980,  1663,   703,  3351,   850,  1581,  3256,  3038,  1045,  1497,
    1497,   703,   842,  2484,  2673,  2282,   703,  2280,  3012,  3146,
      70,  3237,  3325,  1666,  3349,  1286,  1597,  2220,  1667,   703,
    2396,  1602,   813,  2836,  2469,  1559,  3034,  1765,  1046,  2642,
    2651,  1763,  2230,  2218,  2605,  2443,  2812,  3153,  2991,  1958,
    1047,  2883,  2722,  2511,  3056,  2589,  2591,  1048,  2196,  3081,
    3261,  2638,  3159,  1348,  3039,  1527,    71,  2245,  1800,   321,
    2244,   920,  3079,  1049,  1774,   971,  1371,  2976,  2235,  1591,
    2629,  1342,  2248,  2475,  3073,  2476,  3035,  1788,  2916,  3036,
    1771,  1050,  1704,   942,  2471,  2252,  2045,    76,  1497,     0,
    1350,     0,  2046,  1497,     0,  3123,     0,     0,     0,   310,
    3105,     0,     0,     0,     0,     0,   830,     0,  1497,     0,
    1051,     0,     0,     0,     0,   577,   577,     0,     0,   830,
       0,     0,     0,  1668,   607,   607,     0,  1669,     0,  1052,
       0,     0,     0,     0,  2382,  2382,  2382,  2382,  2382,  1275,
    2019,     0,     0,     0,  1735,  1735,  1670,  1671,     0,     0,
    2121,     0,  1053,     0,  1743,     0,     0,  3194,  3145,  1672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1142,     0,     0,     0,  1497,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3220,     0,   577,  1674,     0,     0,   607,     0,   585,  3054,
    3055,     0,     0,     0,     0,  1054,  1675,     0,     0,     0,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
    3230,   608,     0,     0,     0,   797,     0,     0,     0,   703,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,     0,   867,     0,     0,     0,     0,  1055,     0,
    1056,     0,  3171,     0,     0,  1057,     0,     0,     0,     0,
     608,     0,     0,     0,  1677,  1663,  2800,     0,     0,     0,
     310,     0,  3075,     0,     0,  1488,  1024,   867,   608,   608,
    1058,  3342,     0,     0,  3211,     0,   608,  1666,     0,     0,
     592,     0,  1667,  1059,     0,     0,     0,     0,  1060,     0,
       0,   867,     0,     0,     0,     0,     0,     0,     0,     0,
     592,     0,   592,     0,     0,     0,  1061,     0,  3076,   577,
    1000,     0,     0,     0,  1000,     0,     0,   608,     0,     0,
    1678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,
     577,     0,   577,   577,     0,     0,     0,   577,     0,     0,
       0,     0,  3161,     0,  3163,  1663,     0,     0,     0,     0,
       0,     0,  3166,  3167,     0,   585,     0,   703,  3263,     0,
       0,     0,  3267,     0,     0,     0,     0,  1666,  1275,     0,
       0,     0,  1667,     0,     0,     0,     0,  1668,     0,     0,
       0,  1669,     0,     0,   703,     0,     0,     0,     0,     0,
       0,     0,  1000,     0,     0,   577,     0,   703,     0,     0,
    1670,  1671,     0,     0,   310,     0,     0,     0,  1497,  1497,
       0,  1497,  3172,  1672,     0,   703,  3341,   703,   703,     0,
     703,     0,   718,     0,     0,     0,  1497,  2066,  1497,     0,
       0,     0,     0,     0,   830,   830,     0,     0,     0,   310,
       0,   842,     0,     0,  2080,  2578,     0,  1674,     0,     0,
       0,     0,     0,     0,  1497,  3226,     0,     0,     0,     0,
    1675,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   719,     0,     0,     0,     0,   608, -1788,     0,     0,
    1024,  1669,     0,     0,  1497,   577,     0,   720,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1670,  1671,  1497,     0,     0,   721,     0,     0,     0,     0,
       0,     0,     0, -1788,     0,     0,     0,     0,  1677,     0,
       0,   577,     0,     0,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,   722,     0,     0,  1497,     0,     0,
     723,   703,     0,     0,     0,     0,     0,  1674,  1497,     0,
       0,     0,  1488,   724,     0,     0,     0,     0,     0,     0,
    1675,     0,  1497,     0,     0,  1488,     0,     0,     0,     0,
       0,     0,  1489,     0,     0,   725,     0,     0,     0,     0,
       0,     0,     0,  2216,  1678,     0,     0,     0,   703,     0,
       0,     0,     0,     0,     0, -1788, -1788,     0,  1682,  1683,
    1684,  1685,  1686,  1687,     0,     0,  1489,  1488,     0,     0,
    2121,     0,     0,  2121,     0,   577,  3264,     0, -1788,   577,
    3268,     0,     0,     0,     0,     0,     0,     0,     0,   726,
       0,     0,     0,     0,  1488,     0,     0,     0,   585,     0,
       0,  1345,  1497,     0,  2121,  2121,     0,   703,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   585,   703,  1488,
       0,   585,   607,     0,   608,  1497,   703,     0,   727,     0,
       0,     0,   703,     0,   728,     0,     0,   703,   585,   729,
       0,     0,     0,     0,  1678,     0,     0,     0,     0,     0,
       0,  1488,  1497,     0,     0,     0,  1488,     0,  1682,  1683,
    1684,  1685,  1686,  1687,   730,   731,   585,   703,   585,   703,
     703,     0,   703,  2296,     0,  1497,     0,   732,     0,   703,
       0,   963,   733,     0,     0,     0,     0,     0,     0,     0,
       0,   734,     0,   703,     0,     0,     0,   703,     0,     0,
     585,   703,   703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2325,  2326,   703,     0,   703,   703,
    2333,   703,   703,   703,   703,     0,     0,   585,   703,     0,
     585,   703,   585,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1000,
    1000,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2384,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1497,   842,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2408,     0,     0,     0,     0,  2419,     0,
    2426,     0,     0,     0,     0,     0,     0,     0,     0,   592,
       0,     0,  2446,     0,     0,     0,  2446,  2460,     0,     0,
       0,     0,     0,     0,     0,     0,  2296,  1489,     0,     0,
       0,     0,     0,     0,     0,     0,   703,     0,     0,     0,
       0,   608,   608,     0,  1497,     0,     0,     0,     0,     0,
       0,     0,   585,  1489,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1489,     0,     0,     0,
     585,     0,     0,   608,     0,     0,     0,   592,     0,   592,
       0,   592,     0,     0,     0,     0,     0,   592,   592,     0,
    1663,     0,     0,     0,     0,     0,   608,     0,     0,     0,
       0,     0,     0,     0,  1664,     0,     0,     0,  1489,     0,
       0, -1787,  1666,     0,     0,   592,     0,  1667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,     0,  1489,     0,  2572,     0,     0,
     608,   608,     0,     0,   592,   592,     0,     0,     0,     0,
       0,     0, -1787,  1488,  1488,     0,     0,     0,     0,     0,
    1489,     0,     0,     0, -1787,  1024,     0,     0,     0, -1787,
    1497,     0,     0,     0, -1787,     0,  1663, -1787,  2121, -1787,
       0,  2121,  2121,  2121,  2121,  2121,  2121,  2121,  2121,  2121,
    2121,     0,  1489,     0,     0,     0,     0,  1489,  1666,     0,
     592,     0, -1787,  1667,     0,  1735,     0,     0,     0,     0,
    1743,  1663,     0,     0,     0,     0,     0,   592,   592,     0,
   -1787,   703,  1668,     0,     0,  1664,  1669,     0,     0,  2121,
    2121,     0,     0,  1666,     0,     0,     0,     0,  1667,   607,
       0,     0,  1488,     0,     0,  1670,  1671,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1672,  2426,
       0, -1787,  1488,     0,  1663,     0,     0,     0,     0, -1787,
       0,     0,     0,     0,     0,     0,  2587,     0,   585,   703,
     703,     0,     0,     0,     0,     0,  1666,     0,     0,  1673,
       0,  1667,  1674,     0,     0,     0,   703,   703,     0,  1663,
       0,     0,     0,     0,     0,  1675,     0,  1676, -1788,     0,
       0,  1497,  1669,  1664,     0,     0,     0,  1489,     0,     0,
       0,  1666,     0,     0,     0,     0,  1667,     0,     0,     0,
       0,  1670,  1671,  1488,     0,     0,     0,  1497,     0,     0,
       0,   848,     0,  1668, -1788,     0,     0,  1669,     0,     0,
       0,  2296,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1787,  1677,  2897,     0,  1670,  1671,     0,     0,
       0,     0,     0,  2384,     0,     0,   592,     0,  1674,  1672,
   -1787,     0,     0,     0,     0,     0,   703,   703,   703,     0,
       0,  1675,     0,     0,  1567,  2121, -1788,  1571,     0,     0,
    1669,     0,     0,     0,     0,     0,     0,   608,     0,     0,
    1673, -1787,     0,  1674, -1787, -1787, -1787,     0,     0,  1670,
    1671,   703,     0,     0,     0,  1275,  1675,     0,  1676,  1678,
       0,  1668, -1788,   703,  2446,  1669,     0,  2803,     0,  1679,
    1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687, -1788,
       0,  2817,     0,     0,  1670,  1671,     0,     0,     0,  2528,
       0,     0,     0,     0,     0,     0,  1674,  1672,     0,     0,
       0,     0,   585,     0,     0,     0,     0,     0,     0,  1675,
       0,     0,   592,  2066,  1677,     0,     0,     0,     0,     0,
       0,     0,     0,   592,   585,     0,     0,     0,  1673,     0,
       0,  1674,     0,     0,  1489,  1489,     0,     0,  1000,     0,
       0,     0,     0,     0,  1675,  1678,  1676,     0,     0,  1700,
       0,     0,     0,   608,   608,     0,     0,  2121,  2121,  1682,
    1683,  1684,  1685,  1686,  1687,     0,     0, -1788,   592,     0,
       0,   592,     0,   592,   592,     0,     0,     0,     0,     0,
    1678,     0,     0,     0,     0,     0,     0,  1497,     0,     0,
    1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,
       0,     0,  1677,     0,     0,     0,     0,     0,     0,     0,
    3228,     0,  1488,  1488,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,  1489,     0,   608,     0,   592,  1489,     0,
    1488,     0,  1488,  1678,     0,     0,     0,     0,   592,     0,
       0,     0,     0,  1489,  1497,     0,     0,  1682,  1683,  1684,
    1685,  1686,  1687,     0,     0,     0,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1679,  1680,
    1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,  1488,     0,
    2426,  2426,  2142,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,  1489,  1663,     0,     0,     0,     0,
    2121,     0,  2121,     0,     0,   703,   703,     0,     0,     0,
    2121,  2121,     0,     0,     0,     0,     0,  1666,     0,     0,
       0,  1488,  1667,     0,     0,     0,     0,     0,   592,     0,
       0,     0,  1488,  2384,  2384,  2384,  2384,  2384,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,   355,     0,
       0,   355,     0,     0,     0,     0,   703,     0,     0,     0,
       0,     0,     0,   609,   355,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2408,     0,  2325,     0,     0,
    2325,     0,  3000,     0,     0,     0,   355,  2426,     0,     0,
       0,     0,  2296,     0,     0,  2898,     0,   592,     0,     0,
       0,     0,   609,     0,     0,  2446,     0,   703,     0,     0,
       0,     0,     0,  2121,     0,     0,     0,     0,     0,  2408,
     609,  3032,     0,     0,     0,     0,  1488, -1788,     0,     0,
       0,  1669,   585,     0,     0,     0,     0,     0,     0,  1700,
    2048,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
    1670,  1671,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1788,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,     0,  1491,
       0,     0,     0,     0,     0,     0,     0,     0,   592,   592,
     592,     0,     0,   355,     0,   592,   592,  1674,     0,  1488,
     592,   592,     0,     0,     0,     0,     0,   592,     0,     0,
    1675,     0,     0,  1491,     0,     0,   592,     0,   592,     0,
       0,  2216,     0,     0,  1024,     0,  3083,     0,   585,   703,
     703,   592,     0,   592,     0,     0,     0,     0,   585,   703,
     585,     0,     0,  1489,  1489,  3097,  1489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1489,     0,  1489,  1567,     0,     0,     0, -1788,     0,
    2205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2048,     0,     0,     0,     0,     0,     0,     0,     0,  1489,
       0,     0,     0,     0,   592,   355,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   703,     0,
       0,  1488,     0,  3144,     0,     0,     0,     0,     0,  1489,
       0,     0,     0,   703,  1492,     0,     0,     0,     0,     0,
       0,     0,   355,  3032,  1678,   355,     0,  1489,     0,     0,
       0,     0,     0,     0,   585,     0,     0,     0,  1682,  1683,
    1684,  1685,  1686,  1687,     0,     0,     0,     0,  1492,     0,
       0,   592,     0,     0,     0,     0,     0,   592,     0,     0,
       0,     0,  1489,     0,     0,     0,   608,     0,  1488,     0,
       0,     0,     0,  1489,     0,     0,     0,     0,     0,     0,
       0,   787,  1663,     0,     0,     0,     0,  1489,     0,     0,
       0,     0,   788,     0,     0,     0,  1664,     0,     0,     0,
       0,     0,     0,     0,  1666,     0,     0,     0,     0,  1667,
       0,   789,     0,     0,     0,  2296,     0,  2325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     790,     0,  1000,     0,     0,     0,  1000,  1000,     0,     0,
       0,     0,     0,     0,   703,     0,   791,     0,     0,     0,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,   592,     0,   792,   592,   592,  1489,     0,     0,
       0,     0,     0,     0,  1491,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1489,     0,   703,   793,  1488,     0,     0,   703,     0,   794,
    1491,     0,     0,     0,     0,     0,     0,   592,  3144,  1000,
       0,   592,   795,  1491,  1668,   592,   609,  1489,  1669,     0,
       0,     0,     0,   592,     0,     0,     0,  2426,   592,     0,
       0,     0,     0,     0,     0,     0,     0,  1670,  1671,     0,
    1489,     0,     0,     0,     0,   703,     0,  1000,  1663,     0,
    1672,     0,     0,     0,     0,  1491,     0,     0,  2426,     0,
       0,     0,  1664,     0,     0,     0,     0,     0,     0,     0,
    1666,     0,   592,     0,  3306,  1667,     0,     0,     0,     0,
       0,  1673,  1491,     0,  1674,     0,     0,     0,   796,     0,
       0,     0,     0,  1024,     0,     0,     0,  1675,     0,  1676,
       0,     0,     0,     0,     0,   608,  1567,  1491,   797,  2474,
       0,  1571,     0,     0,  3306,     0,     0,     0,     0,  1492,
       0,     0,     0,     0,     0,     0,     0,   798,     0,     0,
       0,   799,     0,   800,     0,  1488,     0,     0,   801,  1491,
    3306,     0,     0,     0,  1491,  1492,     0,     0,   592,     0,
       0,     0,  1489,     0,     0,  1677,     0,     0,  1492,     0,
       0,  1488,     0,   802,   803,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   355,     0,   804,     0,   355,     0,
    1668,   805,   998,     0,  1669,     0,   998,     0,     0,     0,
     806,     0,     0,     0,     0,     0,     0,     0,     0,   807,
    1492,     0,     0,  1670,  1671,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   998,  1672,     0,     0,  1489,
       0,  1678,     0,     0,     0,     0,     0,  1492,     0,     0,
       0,  1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,
    1687,     0,     0,     0,     4,  2724,     0,  1673,  1097,     0,
    1674,   998,  1492,     0,     0,     0,     0,   998,     0,     5,
       0,     0,     0,  1675,  1491,  1676,     0,     0,     6,     0,
    2048,     0,   592,     0,   592,     0,     0,     0,     0,     7,
       8,     0,     0,     0,  1492,     0,     0,    10,    11,  1492,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,  1677,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,     0,   609,     0,     0,  1489,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
     355,     0,     0,   592,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   592,     0,
       0,  1488,     0,     0,   592,   592,     0,  1678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1679,  1680,  1681,
       0,  1682,  1683,  1684,  1685,  1686,  1687,     0,     0,  1492,
       0,  2882,     0,     0,     0,     0,     0,     0,   592,   592,
       0,     0,     0,     0,     0,     0,     0,   592,    37,     0,
       0,     0,     0,     0,     0,   592,     0,     0,  1488,     0,
     592,     0,   592,     0,     0,     0,     0,    38,     0,     0,
       0,  1491,  1491,   592,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1489,     0,     0,     0,
       0,     0,     0,   592,   592,     0,    40,     0,     0,    41,
       0,     0,   608,     0,  1258,   355,     0,     0,     0,   998,
       0,     0,  1489,     0,     0,   998,     0,     0,     0,     0,
      42,     0,  1494,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1502,     0,     0,     0,     0,     0,     0,     0,
    1491,     0,     0,     0,     0,  1491,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1494,   998,     0,     0,
    1491,     0,     0,     0,     0,     0,  1502,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,   592,  1663,     0,     0,     0,     0,     0,     0,
       0,     0,   592,     0,     0,     0,  1492,  1492,     0,     0,
       0,     0,     0,     0,     0,  1666,     0,     0,     0,     0,
    1667,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,  1258,     0,
       0,  1491,     0,     0,     0,     0,   592,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,  1258,    50,     0,     0,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   964,  1258,
    1258,     0,  1258,     0,     0,  1492,     0,     0,     0,     0,
    1492,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,     0,     0,     0,     0,  1492,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1668,     0,     0,     0,  1669,
       0,     0,     0,     0,     0,   609,   609,     0,     0,     0,
       0,     0,  1489,     0,     0,     0,     0,     0,  1670,  1671,
       0,     0,     0,  1724,     0,     0,     0,     0,     0,     0,
       0,  1672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1258,     0,     0,  1258,
    1258,     0,     0,   592,   592,     0,  1492,   355,   355,   355,
       0,     0,  1673,     0,     0,  1674,     0,   592,     0,  1489,
       0,     0,   592,   592,   592,   592,   592,   609,  1675,     0,
     592,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1663,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1494,   355,     0,
       0,     0,     0,     0,     0,   355,     0,  1502,  1666,     0,
     355,     0,     0,  1667,     0,     0,     0,     0,     0,     0,
     592,     0,     0,  1494,     0,     0,  1677,   698,     0,     0,
       0,     0,     0,  1859,     0,     0,  1494,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1502,     0,     0,   698,
    1491,  1491,     0,  1491,     0,     0,  2474,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1491,     0,
    1491,     0,     0,     0,     0,     0,     0,     0,  1494,     0,
       0,     0,     0,     0,     0,     0,  2901,     0,  1502,     0,
       0,     0,  1678,     0,     0,     0,  1491,     0,     0,   355,
       0,     0,  1679,  1680,  1681,  1494,  1682,  1683,  1684,  1685,
    1686,  1687,     0,     0,     0,  1502,     0,     0, -1788,     0,
       0,     0,  1669,     0,     0,     0,  1491,     0,     0,     0,
    1494,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1502,  1670,  1671,     0,  1491,     0,  2048,   592,     0,     0,
       0,     0,     0,     0, -1788,     0,   698,     0,     0,     0,
     592,     0,  1494,     0,     0,     0,     0,  1494,     0,     0,
     998,     0,  1502,   592,     0,     0,     0,  1502,   592,  1491,
     592,   592,     0,     0,     0,   592,     0,     0,  1674,     0,
    1491,     0,     0,     0,     0,  1492,  1492,     0,  1492,     0,
       0,  1675,     0,     0,  1491,     0,     0,   998,     0,     0,
       0,     0,     0,  1492,     0,  1492,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1258,  1258,     0,
       0,  1492,     0,   592,     0,  1258,     0,     0,  1258,  1258,
       0,     0,     0,     0,     0,     0,     0,  2106,     0, -1788,
    1258,  1258,     0,     0,     0,     0,  1663,     0,  1258,     0,
       0,  1492,  1258,  1258,  1258,  1258,     0,     0,     0,     0,
    1664,     0,  1258,  1258,  1491,     0,     0,  1494,  1666,  1492,
       0,     0,     0,  1667,     0,     0,     0,  1502,  1258,   355,
       0,     0,  1258,     0,     0,     0,  1258,  1491,     0,     0,
    1258,     0,     0,  1258,  1258,  1258,  1258,  1258,  1258,  1258,
    1258,  1258,     0,  1258,  1492,  1678,     0,  1258,     0,     0,
       0,  1258,     0,   592,  1491,  1492,     0,     0,     0,  1682,
    1683,  1684,  1685,  1686,  1687,     0,     0,     0,     0,  1492,
       0,     0,     0,     0,     0,     0,     0,  1491,     0,  1663,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   592,
       0,     0,   355,  1664,     0,     0,     0,     0,     0,     0,
       0,  1666,     0,     0,     0,     0,  1667,  1663,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1668,     0,
       0,  1664,  1669,     0,     0,     0,   355,     0,   355,  1666,
       0,     0,     0,     0,  1667,     0,     0,     0,     0,     0,
       0,  1670,  1671,     0,     0,     0,     0,     0,     0,  1492,
       0,     0,     0,     0,  1672,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   355,  1492,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,     0,  1673,  1258,   592,  1674,  1491,
       0,     0,     0,     0,  1494,  1494,     0,     0,     0,  1492,
       0,  1675,     0,  1676,  1859,  1502,     0,     0,     0,     0,
       0,  1668,     0,     0,     0,  1669,     0,     0,     0,     0,
       0,     0,  1492,     0,     0,     0,     0,     0,   592,   592,
       0,     0,     0,   592,  1670,  1671,     0,     0,     0,  1668,
       0,     0,     0,  1669,     0,     0,     0,  1672,     0,     0,
       0,     0,     0,     0,     0,     0,  1491,  1663,     0,  1677,
       0,     0,  1670,  1671,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,     0,  1672,     0,     0,  1673,  1666,
       0,  1674,     0,  1494,  1667,     0,     0,     0,  1494,     0,
       0,     0,  1258,  1502,  1675,     0,  1676,     0,  1502,   592,
       0,     0,     0,  1494,     0,     0,  1673,     0,     0,  1674,
       0,  1258,     0,  1502,     0,     0,     0,     0,     0,     0,
       0,     0,  1675,     0,  1676,  1678,     0,     0,     0,     0,
       0,     0,     0,     0,  1492,  1679,  1680,  1681,     0,  1682,
    1683,  1684,  1685,  1686,  1687,     0,     0,     0,     0,  2929,
       0,     0,  1677,     0,     0,     0,     0,  3063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   698,     0,     0,
       0,     0,   998,     0,  1494,   995,     0,     0,     0,   995,
    1677,  1258,  1491,     0,  1502,     0,     0,     0,     0, -1788,
       0,     0,     0,  1669,     0,     0,     0,     0,     0,     0,
       0,  1492,     0,     0,     0,     0,     0,     0,   995,     0,
       0,     0,  1670,  1671,     0,     0,     0,  1258,  1678,     0,
       0,     0,     0,     0,     0, -1788,     0,     0,  1679,  1680,
    1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,   751,     0,
       0,  1258,  3046,     0,   995,     0,  1678,     0,     0,   752,
     995,     0,     0,     0,     0,     0,  1679,  1680,  1681,  1674,
    1682,  1683,  1684,  1685,  1686,  1687,     0,     0,   753,     0,
    3065,     0,  1675,  1258,     0,     0,  1258,     0,     0,     0,
       0,     0,     0,     0,     0,   754,     0,  -456,  1258,  1258,
    1258,  1258,     0,     0,     0,     0,     0,  1258,     0,     0,
       0,     0,     0,   755,     0,     0,     0,  1258,  1258,   756,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   757,  1258,  1491,  1258,     0,     0,  1492,  1258,     0,
   -1788,     0,     0,  1253,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1491,
    -575,   998,   758,  1258,  1258,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -561,
       0,     0,     0,     0,     0,     0,     0,  1258,     0,     0,
       0,     0,     0,     0,     0,  1258,  1258,  1258,     0,     0,
       0,  -387,     0,     0,     0,     0,  1678,     0,     0,     0,
       0,     0,   760,     0,     0,     0,     0,     0,     0,     0,
    1682,  1683,  1684,  1685,  1686,  1687,  1258,     0,     0,     0,
       0,     0,     0,  1494,  1494,     0,  1494,     0,     0,     0,
       0,     0,     0,  1859,  1502,     0,  1502,     0,     0,     0,
       0,  1494,     0,  1494,     0,   761,     0,   762,  1663,     0,
       0,  1502,     0,  1502,     0,     0,     0,     0,     0,     0,
       0,     0,  1664,     0,     0,  -387,     0,     0,  1492,  1494,
    1666,     0,     0,     0,     0,  1667,     0,     0,     0,  1502,
       0,     0,     0,     0,   763,     0,     0,     0,  -575,     0,
     764,     0,     0,     0,  1492,     0,     0,  1253,   698,  1494,
       0,     0,   995,     0,     0,     0,     0,     0,   995,  1502,
       0,     0,     0,     0,     0,     0,     0,  1494,     0,     0,
       0,   765,   766,     0,   767,  1500,   355,  1502,     0,     0,
       0,     0,     0,   768,     0,     0,     0,   769,   770,     0,
       0,     0,   771,     0,     0,     0,     0,   772,     0,     0,
     995,     0,  1494,   591,     0,     0,     0,     0,     0,  1500,
       0,     0,  1502,  1494,     0,     0,     0,     0,     0,  1491,
       0,     0,     0,  1502,     0,     0,     0,  1494,     0,     0,
    1668,     0,     0,     0,  1669,     0,     0,  1502,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   998,     0,  1670,  1671,   998,     0,     0,     0,   998,
       0,     0,     0,     0,     0,     0,  1672,     0,     0,     0,
       0,  1253,     0,     0,     0,     0,  1491,     0,     0,   833,
       0,   998,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1673,  1253,   591,
    1674,   833,     0,     0,     0,     0,     0,  1494,  1258,     0,
       0,     0,     0,  1675,  1258,  1676,     0,  1502,     0,     0,
       0,     0,  1253,  1253,     0,  1253,  1258,     0,     0,     0,
    1494,     0,  1258,     0,     0,     0,  1258,     0,     0,     0,
    1502,  1258,     0,  1253,  1258,  1258,  1258,  1258,  1258,  1258,
    1258,  1258,  1258,  1258,     0,     0,     0,  1494,  1258,  1258,
       0,     0,     0,     0,  1492,     0,     0,  1502,     0,     0,
       0,  1677,  1258,     0,     0,     0,     0,     0,     0,  1258,
    1494,     0,  1258,     0,  1258,     0,     0,     0,     0,     0,
    1502,  1258,  1258,  1258,     0,   741,     0,  1258,     0,     0,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,  1253,
       0,     0,  1253,  1253,     0,     0,     0,     0,     0,     0,
       0,  1492,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   741,     0,     0,  1678,     0,     0,
       0,     0,   741,     0,  1258,     0,     0,  1679,  1680,  1681,
       0,  1682,  1683,  1684,  1685,  1686,  1687,     0,     0,     0,
       0,  3196,  1663,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1664,   741,   741,     0,
    1500,     0,     0,   698,  1666,     0,     0,     0,     0,  1667,
       0,     0,  1494,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1502,     0,     0,     0,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1500,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1258,  1494,
       0,  1500,     0,     0,     0,     0,     0,     0,     0,  1502,
       0,     0,   698,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1500,     0,
       0,     0,     0,     0,  1668,     0,     0,     0,  1669,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     998,     0,     0,  1500,     0,   998,     0,  1670,  1671,   998,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1672,     0,     0,     0,     0,     0,     0,  1258,     0,     0,
       0,     0,     0,   995,     0,  1500,     0,     0,     0,  1258,
    1500,  1876,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1673,     0,     0,  1674,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1675,     0,  1676,
     995,     0,     0,     0,     0,  1494,     0,     0,     0,     0,
    1258,  1258,     0,     0,     0,  1502,     0,     0,     0,  1877,
       0,  1258,  1258,     0,     0,  1258,  1878,  1879,     0,     0,
    1253,  1253,     0,     0,     0,     0,     0,     0,  1253,     0,
       0,  1253,  1253,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1253,  1253,  1677,     0,     0,     0,     0,
       0,  1253,     0,  1880,     0,  1253,  1253,  1253,  1253,     0,
       0,     0,     0,     0,     0,  1253,  1253,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1500,  1253,   698,     0,     0,  1253,     0,     0,  1258,  1253,
       0,  1881,     0,  1253,     0,  1882,  1253,  1253,  1253,  1253,
    1253,  1253,  1253,  1253,  1253,     0,  1253,     0,     0,     0,
    1253,  1678,     0,     0,  1253,     0,     0,     0,     0,     0,
       0,  1679,  1680,  1681,   998,  1682,  1683,  1684,  1685,  1686,
    1687,     0,  1883,     0,     0,  3254,  1494,  1258,     0,     0,
       0,   998,     0,     0,     0,     0,  1502,  1884,  1885,     0,
    1886,  1887,     0,  1888,  1258,     0,     0,     0,     0,     0,
       0,     0,  1494,  1258,     0,  1258,     0,     0,  1663,     0,
       0,     0,  1502,  1258,  1258,     0,     0,  1258,   591,     0,
    1889,     0,  1664,     0,  1258,  1258,     0,     0,     0,     0,
    1666,     0,     0,     0,  1258,  1667,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1890,
       0,     0,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   998,     0,     0,     0,
       0,     0,     0,     0,   698,     0,     0,     0,     0,     0,
       0,  1891,     0,  1892,     0,     0,   833,     0,   833,  1253,
     833,     0,     0,     0,  1258,     0,   833,   833,     0,     0,
       0,     0,     0,     0,     0,  1893,     0,  1857,  1500,     0,
       0,     0,  1894,     0,     0,  1895,  1258,     0,     0,     0,
       0,     0,     0,     0,   591,   991,     0,     0,     0,   991,
       0,   741,     0,     0,     0,     0,   741,   741,     0,     0,
    1668,     0,   591,     0,  1669,     0,     0,     0,     0,     0,
       0,     0,     0,   591,   591,     0,     0,   741,   991,     0,
       0,     0,     0,  1670,  1671,     0,     0,     0,     0,   998,
       0,     0,     0,     0,     0,     0,  1672,     0,     0,     0,
       0,     0,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   741,   991,  1253,  1500,     0,     0,     0,
     991,  1500,     0,     0,     0,     0,     0,  1673,     0,  1329,
    1674,     0,     0,     0,  1253,     0,  1500,     0,     0,     0,
       0,     0,  1494,  1675,     0,  1676,   591,   591,     0,     0,
       0,     0,  1502,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1329,     0,     0,     0,     0,     0,     0,
     741,     0,     0,   998,     0,     0,   741,     0,     0,     0,
       0,     0,     0,     0,     0,  1495,   741,     0,     0,     0,
       0,     0,     0,     0,     0,   995,     0,     0,     0,  1494,
       0,  1677,     0,     0,  1253,     0,   998,  1500,     0,  1502,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1495,
       0,     0,   741,     0,     0,  1663,     0,   741,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   741,  1664,
    1253,     0,     0,     0,     0,     0,     0,  1666,     0,     0,
       0,     0,  1667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1253,     0,     0,  1678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1679,  1680,  1681,
       0,  1682,  1683,  1684,  1685,  1686,  1687,     0,     0,  2704,
       0,     0,     0,     0,     0,     0,  1253,     0,     0,  1253,
       0,     0,     0,     0,     0,   591,     0,     0,     0,     0,
       0,  1253,  1253,  1253,  1253,     0,     0,     0,     0,     0,
    1253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1253,  1253,     0,  1253,     0,     0,     0,     0,  2554,     0,
       0,     0,     0,  2555,     0,  1253,     0,  1253,     0,     0,
       0,  1253,     0,     0,     0,     0,     0,  1668,     0,     0,
       0,  1669,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   741,   991,     0,   995,     0,  1253,  1253,   991,     0,
    1670,  1671,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1672,     0,     0,     0,     0,     0,     0,
    1253,     0,     0,     0,     0,     0,     0,     0,  1253,  1253,
    1253,   591,     0,     0,   741,   741,   741,     0,     0,     0,
     991,     0,   591,     0,  1673,     0,     0,  1674,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1253,
    1675,     0,  1676,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1857,  1500,     0,  1500,
       0,     0,     0,     0,   741,     0,     0,   591,     0,     0,
    1329,     0,  1329,  1329,  1500,     0,  1500,     0,     0,     0,
       0,     0,   741,     0,     0,     0,     0,     0,     0,     0,
    1495,     0,     0,     0,     0,     0,     0,     0,  1677,     0,
       0,     0,  1500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1495,     0,     0,     0,
       0,     0,     0,     0,  1496,     0,   591,     0,     0,  1495,
       0,     0,  1500,     0,     0,     0,     0,   833,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   698,
    1500,     0,     0,     0,     0,     0,   702,     0,  1496,     0,
       0,     0,     0,     0,  1678,     0,   704,     0,     0,     0,
       0,  1495,     0,     0,  1679,  1680,  1681,     0,  1682,  1683,
    1684,  1685,  1686,  1687,     0,  1500,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1500,     0,  1495,     0,
       0,   738,     0,     0,     0,     0,     0,     0,     0,     0,
    1500,   781,     0,     0,   785,     0,   741,     0,   781,     0,
       0,     0,   829,  1495,   995,     0,     0,     0,   995,     0,
       0,     0,   995,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   851,     0,     0,  1329,     0,     0,
       0,     0,     0,     0,   995,  1495,     0,     0,     0,   781,
    1495,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1253,     0,     0,     0,     0,     0,  1253,     0,     0,
    1500,     0,     0,     0,     0,     0,     0,     0,     0,  1253,
       0,     0,     0,     0,     0,  1253,     0,     0,     0,  1253,
       0,     0,     0,  1500,  1253,     0,   591,  1253,  1253,  1253,
    1253,  1253,  1253,  1253,  1253,  1253,  1253,     0,     0,     0,
       0,  1253,  1253,     0,     0,     0,     0,     0,     0,     0,
    1500,     0,     0,     0,     0,  1253,     0,     0,     0,     0,
       0,     0,  1253,     0,     0,  1253,     0,  1253,     0,     0,
       0,   741,     0,  1500,  1253,  1253,  1253,     0,     0,     0,
    1253,     0,  1663,  1253,     0,     0,     0,     0,     0,     0,
    1495,     0,     0,     0,     0,     0,  1664,     0,     0,     0,
    2224,     0,     0,     0,  1666,     0,     0,     0,     0,  1667,
       0,     0,     0,     0,     0,     0,     0,   833,   833,   833,
       0,     0,     0,     0,   591,   833,     0,  1253,     0,   833,
     833,     0,     0,     0,     0,     0,   833,     0,   949,  1496,
       0,     0,     0,     0,     0,   833,     0,   833,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     833,     0,   833,     0,     0,  1496,     0,     0,     0,  2225,
       0,     0,     0,  2026,     0,     0,     0,     0,  1496,     0,
       0,   741,   741,     0,     0,  1500,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     991,     0,     0,   741,  1668,     0,     0,     0,  1669,     0,
    1496,     0,     0,   591,     0,   741,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1670,  1671,     0,
       0,  1253,     0,     0,     0,     0,     0,  1496,     0,     0,
    1672,     0,  1500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1496,     0,     0,     0,     0,  1495,  1495,     0,
       0,  1673,     0,     0,  1674,     0,     0,     0,     0,     0,
    1329,     0,     0,   995,     0,     0,   591,  1675,   995,  1676,
       0,     0,   995,     0,  1496,     0,  1329,     0,     0,  1496,
       0,     0,     0,  1663,     0,     0,     0,     0,     0,     0,
    1253,     0,     0,     0,     0,     0,     0,  1664,     0,   741,
    1665,     0,  1253,     0,     0,  1666,     0,     0,     0,     0,
    1667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1677,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1495,     0,     0,   957,
     958,  1495,     0,  1253,  1253,     0,     0,     0,  1500,     0,
       0,   741,     0,     0,  1253,  1253,  1495,     0,  1253,     0,
       0,     0,     0,   833,     0,     0,     0,     0,     0,     0,
    2226,  1329,     0,     0,  1329,  1329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1678,     0,     0,     0,     0,     0,     0,     0,  1496,
       0,  1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,
    1687,     0,     0,     0,     0,  1668,   591,     0,     0,  1669,
     591,     0,     0,     0,   591,     0,     0,  1495,     0,     0,
       0,  1253,   833,     0,     0,     0,     0,   833,  1670,  1671,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   995,     0,  1009,
       0,     0,  1026,     0,     0,  1030,  1031,     0,     0,     0,
    1253,   591,  1673,     0,   995,  1674,     0,     0,     0,  1500,
       0,     0,     0,     0,     0,     0,  1067,  1253,  1675,     0,
    1676,     0,     0,     0,     0,     0,  1253,     0,  1253,  1083,
       0,     0,  1084,     0,     0,  1500,  1253,  1253,     0,     0,
    1253,     0,     0,   949,   781,     0,     0,  1253,  1253,     0,
       0,     0,  1101,     0,     0,     0,     0,  1253,     0,     0,
       0,     0,     0,  1110,     0,     0,     0,  1111,  1112,     0,
       0,     0,     0,     0,     0,  1253,  1677,   833,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   995,
       0,  1130,  1131,     0,     0,     0,     0,     0,   949,     0,
       0,     0,     0,     0,     0,     0,  1496,  1496,   741,     0,
       0,     0,     0,     0,     0,     0,     0,  1253,     0,  1146,
       0,  1147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   741,     0,     0,     0,     0,     0,     0,   741,  1253,
       0,     0,  1678,   949,     0,  2026,     0,     0,     0,     0,
       0,     0,  1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,
    1686,  1687,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   995,     0,     0,  1496,  1495,  1495,     0,  1495,
    1496,   833,     0,  1329,     0,  1253,     0,     0,     0,     0,
       0,     0,     0,     0,  1495,  1496,  1495,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1663,     0,  1495,     0,  1365,     0,     0,  1367,     0,     0,
    1369,     0,     0,     0,  1664,  1500,     0,  2513,     0,     0,
       0,     0,  1666,     0,     0,     0,     0,  1667,  1499,     0,
       0,     0,  1495,     0,     0,     0,   995,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1496,     0,     0,     0,
    1495,     0,   833,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1499,     0,     0,     0,     0,  1329,     0,   995,
       0,     0,  1500,  1329,  1329,     0,     0,     0,   741,  1459,
       0,     0,     0,  1460,  2026,  1495,     0,  1462,     0,     0,
       0,     0,     0,  1503,     0,     0,  1495,     0,     0,     0,
       0,  1663,     0,     0,     0,     0,     0,   591,   591,     0,
    1495,     0,     0,     0,     0,  1664,   591,     0,  1530,     0,
       0,     0,     0,  1666,  1329,     0,     0,     0,  1667,   833,
       0,   833,  1668,     0,     0,     0,  1669,     0,     0,     0,
       0,     0,  2743,   591,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1561,     0,  1670,  1671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1590,  1672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   591,   591,     0,   993,     0,     0,     0,   993,
    1495,     0,  1663,     0,     0,     0,     0,     0,     0,  1673,
       0,     0,  1674,     0,     0,     0,  1664,     0,     0,     0,
       0,     0,     0,  1495,  1666,  1675,     0,  1676,   993,  1667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1668,     0,     0,     0,  1669,     0,     0,
    1495,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   993,     0,  1670,  1671,     0,     0,
     993,     0,     0,  1495,     0,     0,     0,     0,     0,  1672,
       0,   833,     0,  1677,     0,     0,     0,     0,     0,     0,
       0,   833,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   741,     0,     0,     0,  1496,  1496,   741,  1496,     0,
    1673,     0,     0,  1674,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1496,     0,  1496,  1675,     0,  1676,     0,
       0,     0,     0,     0,  1668,   591,     0,     0,  1669,     0,
       0,     0,     0,  1499,  2026,     0,     0,     0,  2026,  1678,
       0,  1496,  2026,  1250,     0,     0,     0,  1670,  1671,  1679,
    1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,  1855,
    1672,     0,     0,     0,   991,     0,     0,     0,     0,     0,
       0,  1496,  1499,     0,  1677,  1495,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   741,     0,     0,  1496,
    1808,  1673,     0,     0,  1674,     0,     0,     0,  1663,     0,
       0,     0,     0,     0,     0,     0,     0,  1675,     0,  1676,
       0,     0,  1664,     0,  1499,  2563,     0,     0,  2532,  2515,
    1666,     0,     0,     0,  1496,  1667,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1496,     0,     0,     0,     0,
    1678,  1499,  1495,     0,     0,     0,     0,     0,     0,  1496,
    1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,
       0,     0,   591,   591,     0,  1677,  1499,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   833,     0,     0,     0,
       0,   833,   833,   833,   833,   833,     0,     0,     0,   833,
     741,   741,     0,     0,     0,     0,     0,     0,  1499,     0,
       0,     0,     0,  1499,     0,     0,  1663,  1250,     0,     0,
       0,     0,   993,     0,     0,     0,     0,     0,   993,     0,
    1664,     0,     0,     0,     0,     0,     0,     0,  1666,  1496,
    1668,  1678,     0,  1667,  1669,  1498,     0,     0,  1993,   591,
       0,  1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,
    1687,     0,  1496,  1670,  1671,     0,     0,     0,     0,     0,
     993,     0,     0,     0,     0,  2032,  1672,     0,  1495,  1498,
       0,     0,     0,     0,     0,     0,     0,     0,  2041,  1496,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1673,     0,     0,
    1674,     0,  1496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1675,     0,  1676,     0,     0,     0,     0,
       0,     0,     0,  1499,   741,     0,     0,     0,     0,     0,
       0,  1250,     0,     0,     0,     0,     0,     0,  1668,     0,
       0,     0,  1669,     0,     0,     0,     0,   741,     0,     0,
       0,     0,     0,     0,     0,   741,     0,     0,  1250,     0,
       0,  1670,  1671,     0,     0,     0,   591,     0,     0,     0,
       0,  1677,     0,     0,  1672,     0,     0,     0,     0,   833,
       0,     0,  1250,  1250,     0,  1250,     0,     0,     0,     0,
       0,     0,   833,  2026,     0,     0,     0,   591,  2026,   591,
     591,     0,  2026,  1250,   591,  1673,     0,     0,  1674,  1495,
       0,     0,     0,     0,  1496,     0,     0,     0,     0,     0,
       0,  1675,  2204,  1676,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1495,     0,  1678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1679,  1680,  1681,
       0,  1682,  1683,  1684,  1685,  1686,  1687,     0,     0,     0,
       0,     0,   591,     0,     0,     0,     0,     0,     0,  1250,
       0,     0,  1250,  1250,     0,     0,     0,     0,     0,  1677,
       0,  1496,     0,     0,     0,     0,     0,     0,     0,     0,
     741,   741,   741,   741,     0,     0,     0,     0,     0,     0,
       0,  2845,     0,     0,     0,     0,     0,     0,     0,     0,
    1855,  1855,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1663,     0,     0,     0,   949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1664,  2256,
    1498,     0,     0,     0,     0,  1678,  1666,  2263,     0,     0,
       0,  1667,   591,  2267,     0,  1679,  1680,  1681,  2271,  1682,
    1683,  1684,  1685,  1686,  1687,     0,  1854,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1498,
       0,     0,     0,     0,     0,     0,     0,     0,   591,     0,
    2291,  2292,     0,  2294,     0,     0,     0,   991,     0,  1499,
       0,     0,     0,     0,  1499,     0,     0,  1496,     0,     0,
       0,     0,     0,     0,  2026,     0,     0,     0,     0,  1499,
       0,  1498,  2312,  2313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2327,     0,  2331,
    2332,     0,  2336,  2337,  2338,  2339,     0,     0,  1498,  2345,
       0,     0,  2348,     0,     0,  1495,  1668,     0,     0,     0,
    1669,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1498,     0,     0,     0,     0,     0,  1670,
    1671,     0,   591,     0,     0,     0,   591,     0,     0,     0,
    1499,     0,  1672,     0,     0,     0,     0,     0,     0,   991,
       0,   741,     0,   993,     0,  1498,     0,     0,     0,     0,
    1498,     0,  1495,     0,     0,     0,     0,     0,     0,   741,
       0,     0,     0,  1673,     0,     0,  1674,   833,   833,     0,
       0,     0,     0,  1663,   741,     0,     0,     0,     0,  1675,
     993,  1676,     0,     0,     0,     0,     0,  1664,  1496,     0,
       0,     0,     0,     0,     0,  1666,     0,     0,     0,     0,
    1667,     0,     0,     0,   741,     0,     0,   949,     0,     0,
    1250,  1250,     0,     0,  1496,     0,     0,     0,  1250,     0,
       0,  1250,  1250,     0,     0,     0,     0,     0,     0,     0,
    1663,     0,     0,  1250,  1250,     0,     0,  1677,     0,     0,
       0,  1250,   991,     0,  1664,  1250,  1250,  1250,  1250,     0,
       0,     0,  1666,     0,     0,  1250,  1250,  1667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1498,  1250,     0,     0,     0,  1250,     0,     0,     0,  1250,
       0,     0,     0,  1250,     0,     0,  1250,  1250,  1250,  1250,
    1250,  1250,  1250,  1250,  1250,     0,  1250,     0,     0,     0,
    1250,     0,     0,  1678,  1250,  1668,     0,     0,     0,  1669,
       0,     0,     0,  1679,  1680,  1681,     0,  1682,  1683,  1684,
    1685,  1686,  1687,     0,     0,     0,   991,     0,  1670,  1671,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1672,     0,     0,     0,     0,     0,     0,  2568,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   991,
       0,     0,  1668,     0,     0,     0,  1669,     0,     0,     0,
       0,     0,  1673,     0,     0,  1674,     0,     0,     0,  1855,
    1855,     0,  1855,     0,     0,  1670,  1671,     0,  1675,     0,
       0,     0,     0,     0,     0,     0,     0,  1499,  1672,  1499,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1499,     0,     0,     0,  1673,
       0,     0,  1674,     0,  1496,     0,     0,     0,     0,  1250,
       0,     0,     0,     0,     0,  1675,  1677,  1676,     0,     0,
    2678,  2679,     0,     0,     0,  1499,     0,  1854,  1498,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1855,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1496,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1677,     0,     0,     0,     0,  1499,     0,
       0,     0,  1678,     0,     0,     0,     0,     0,     0,  1499,
       0,     0,  1679,  1680,  1681,     0,  1682,  1683,  1684,  1685,
    1686,  1687,     0,  1855,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1250,  1498,     0,     0,     0,
       0,  1498,     0,     0,     0,     0,     0,  2747,  2749,  2751,
       0,     0,     0,     0,  1250,     0,  1498,     0,     0,  1678,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1679,
    1680,  1681,     0,  1682,  1683,  1684,  1685,  1686,  1687,     0,
       0,     0,  2787,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   781,     0,     0,     0,     0,     0,
       0,     0,     0,  1499,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   993,     0,     0,     0,     0,
       0,     0,     0,     0,  1250,     0,  1499,  1498,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,  1499,     0,     0,     0,     0,     0,     0,
    1250,     6,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     0,     0,  1499,     0,     0,     0,
      10,    11,     0,     0,  1250,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,  1250,     0,     0,  1250,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1250,  1250,  1250,  1250,     0,     0,     0,     0,     0,
    1250,     0,     0,     0,     0,     0,     0,     0,     0,    36,
    1250,  1250,     0,  1250,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1250,     0,  1250,     0,     0,
       0,  1250,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1499,     0,
       0,     0,     0,     0,   993,     0,  1250,  1250,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1250,    37,     0,     0,     0,     0,     0,     0,  1250,  1250,
    1250,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1499,  2944,  2945,    39,  1250,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1854,  1498,     0,  1498,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,  1498,     0,  1498,     0,   996,     0,
       0,     0,   996,     0,     0,     0,     0,  2975,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,  1498,     0,     0,     0,     0,     0,     0,     0,
       0,   996,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1498,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   996,     0,     0,
    1498,    43,     0,   996,     0,     0,     0,     0,     0,     0,
       0,  1499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1498,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,  1498,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1498,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,   993,     0,    48,    49,   993,    50,
       0,     0,   993,     0,     0,    52,  1254,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   964,     0,     0,   993,   965,     0,     0,     0,     0,
    3085,  3086,     0,     0,     0,     0,     0,     0,     0,     0,
    3092,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1250,     0,     0,     0,     0,     0,  1250,     0,     0,
    1498,     0,     0,     0,     0,     0,     0,     0,     0,  1250,
       0,     0,  1499,     0,     0,  1250,     0,     0,     0,  1250,
       0,     0,     0,  1498,  1250,     0,     0,  1250,  1250,  1250,
    1250,  1250,  1250,  1250,  1250,  1250,  1250,     0,  1499,     0,
       0,  1250,  1250,     0,     0,     0,     0,     0,     0,  2787,
    1498,     0,     0,     0,     0,  1250,     0,     0,     0,     0,
       0,     0,  1250,     0,     0,  1250,     0,  1250,     0,     0,
       0,     0,     0,  1498,  1250,  1250,  1250,     0,     0,     0,
    1250,     0,     0,  1250,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    78,     0,     0,     0,     0,
       0,    82,     0,     0,     0,     0,     0,     0,     0,    88,
    1254,    89,     0,     0,    92,   996,     0,     0,     0,     0,
       0,   996,     0,     0,     0,   102,     0,  1250,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1501,     0,
       0,     0,     0,   115,   116,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   996,     0,     0,     0,     0,     0,     0,
     124,     0,  1501,     0,     0,     0,     0,     0,     0,     0,
     125,   126,   127,     0,     0,  1498,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   136,     0,   137,   138,     0,     0,     0,
     140,   141,     0,     0,     0,     0,     0,     0,   143,   144,
       0,     0,     0,     0,  1254,     0,     0,     0,     0,     0,
       0,  1250,   146,  3246,   147,     0,     0,   150,  3248,     0,
       0,     0,  1498,   151,     0,     0,     0,     0,  1499,     0,
       0,  1254,   152,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,   154,     0,   156,     0,     0,     0,   158,
       0,     0,     0,     0,     0,  1254,  1254,     0,  1254,     0,
     162,     0,   163,   993,     0,     0,  3286,     0,   993,     0,
       0,     0,   993,     0,     0,     0,  1254,     0,     0,     0,
       0,     0,     0,     0,     0,  1499,   168,     0,     0,     0,
    1250,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1250,     0,     0,     0,     0,     0,     0,   177,
     178,     0,     0,     0,     0,   179,     0,     0,     0,     0,
       0,     0,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     185,     0,  1254,  1250,  1250,  1254,  1254,     0,  1498,     0,
       0,     0,     0,     0,  1250,  1250,     0,     0,  1250,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   197,     0,   198,     0,     0,     0,   199,     0,     0,
       0,   200,     0,     0,   202,     0,     0,     0,   204,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   206,     0,
       0,   208,     0,  1501,     0,     0,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1250,     0,     0,     0,     0,     0,     0,     0,  1858,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,     0,  1501,   220,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,   993,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1250,     0,     0,     0,   993,     0,     0,     0,     0,  1498,
       0,     0,     0,     0,  1501,     0,     0,  1250,     0,     0,
       0,   227,     0,     0,     0,     0,  1250,     0,  1250,     0,
       0,     0,     0,     0,     0,  1498,  1250,  1250,     0,     0,
    1250,  1501,     0,     0,     0,     0,     0,  1250,  1250,     0,
       0,     0,     0,     0,     0,     0,     0,  1250,     0,     0,
       0,     0,  1232,     0,     0,     0,  1501,     0,     0,     0,
       0,     0,     0,     0,     0,  1250,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   993,
       0,     0,     0,     0,     0,     0,   996,     0,  1501,     0,
       0,     0,     0,  1501,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1250,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   996,     0,     0,     0,     0,     0,  1250,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1254,  1254,     0,     0,     0,     0,     0,
       0,  1254,     0,     0,  1254,  1254,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1254,  1254,     0,     0,
       0,     0,   993,     0,  1254,     0,     0,     0,  1254,  1254,
    1254,  1254,     0,     0,     0,  1250,     0,     0,  1254,  1254,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1501,  1254,     0,  1447,     0,  1254,     0,
       0,     0,  1254,     0,     0,     0,  1254,     0,     0,  1254,
    1254,  1254,  1254,  1254,  1254,  1254,  1254,  1254,     0,  1254,
       0,     0,     0,  1254,     0,  1498,     0,  1254,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   993,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   993,
       0,     0,  1498,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1609,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1254,     0,     0,     0,     0,     0,     0,     0,
       0,  1652,  1653,     0,  1655,     0,     0,     0,     0,     0,
    1858,  1501,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1691,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1753,     0,
       0,  1760,  1762,     0,     0,     0,     0,     0,  1254,  1501,
       0,     0,     0,     0,  1501,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1254,     0,  1501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   996,     0,
       0,     0,     0,     0,     0,     0,     0,  1254,     0,     0,
    1501,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1254,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1254,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1254,
       0,     0,  1254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1254,  1254,  1254,  1254,     0,     0,
       0,     0,     0,  1254,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1254,  1254,     0,  1254,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1254,     0,
    1254,     0,     0,     0,  1254,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   996,     0,  1254,
    1254,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1254,     0,     0,     0,     0,     0,     0,
       0,  1254,  1254,  1254,     0,     0,     0,  2090,     0,     0,
       0,  2092,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2114,     0,  1254,     0,  2117,     0,     0,  2126,     0,     0,
       0,     0,     0,     0,  2133,  2138,     0,     0,     0,  1858,
    1501,     0,  1501,     0,     0,     0,     0,     0,     0,     0,
    2149,     0,     0,     0,  2155,     0,     0,  1501,  2166,  1501,
       0,     0,  2173,     0,     0,  2175,  2176,  2177,  2178,  2179,
    2180,  2181,  2182,  2183,     0,  2184,     0,     0,     0,  1232,
       0,     0,     0,     0,     0,  1501,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1501,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1501,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1501,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1689,     0,     0,  1501,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   996,     0,     0,
       0,   996,     0,     0,     0,   996,     0,     0,  2269,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   996,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1254,     0,     0,     0,     0,     0,
    1254,     0,     0,  1501,     0,     0,     0,     0,     0,     0,
       0,     0,  1254,     0,     0,     0,     0,     0,  1254,     0,
       0,     0,  1254,     0,     0,     0,  1501,  1254,     0,     0,
    1254,  1254,  1254,  1254,  1254,  1254,  1254,  1254,  1254,  1254,
       0,     0,     0,     0,  1254,  1254,     0,     0,     0,     0,
       0,     0,     0,  1501,  2353,     0,     0,     0,  1254,     0,
       0,     0,     0,     0,     0,  1254,     0,     0,  1254,     0,
    1254,     0,     0,  2374,     0,     0,  1501,  1254,  1254,  1254,
       0,     0,     0,  1254,     0,     0,  1254,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1254,     0,     0,     0,     0,  1689,     0,     0,     0,     0,
       0,     0,     0,  2462,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2486,
       0,     0,     0,     0,     0,     0,     0,     0,  1501,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2509,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1254,     0,     0,     0,     0,     0,
    2138,     0,  2138,  2138,     0,  1501,     0,     0,     0,  2571,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2590,     0,  2592,     0,     0,     0,
    2595,     0,     0,     0,     0,     0,   996,  1689,     0,     0,
       0,   996,     0,     0,     0,   996,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1689,     0,  1254,     0,     0,     0,  2122,     0,     0,
       0,     0,     0,     0,     0,  1254,     0,     0,     0,  1753,
    1689,  1689,     0,  1689,     0,     0,     0,  1762,  1762,  1760,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1254,  1254,  2665,  1689,
       0,  1501,     0,     0,     0,     0,     0,  1254,  1254,     0,
       0,  1254,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1689,     0,     0,     0,     0,     0,     0,  1689,     0,
    1689,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1254,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     996,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1254,     0,     0,     0,   996,     0,     0,
       0,     0,  1501,     0,     0,     0,     0,     0,     0,     0,
    1254,     0,     0,     0,     0,     0,     0,     0,     0,  1254,
       0,  1254,     0,     0,     0,     0,     0,     0,  1501,  1254,
    1254,     0,     0,  1254,     0,     0,     0,     0,     0,     0,
    1254,  1254,     0,     0,     0,     0,     0,     0,     0,     0,
    1254,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   996,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2842,     0,     0,     0,     0,     0,  2846,     0,     0,     0,
    1254,     0,     0,     0,     0,     0,     0,     0,  2851,     0,
       0,     0,     0,     0,  2852,     0,     0,     0,  2854,     0,
       0,     0,  1254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2871,  2872,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2885,     0,     0,  2888,     0,  2890,     0,     0,     0,
       0,     0,     0,  2894,     0,   996,     0,     0,     0,  2899,
       0,     0,  2902,     0,     0,     0,     0,     0,  1254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2920,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1501,  1689,
       0,     0,     0,     0,     0,     0,     0,     0,  1689,     0,
    1689,     0,     0,     0,     0,     0,     0,     0,     0,   996,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1689,     0,     0,  1689,     0,  2122,  2550,     0,
    2122,     0,     0,     0,  1689,     0,     0,     0,     0,     0,
       0,  1689,   996,     0,     0,  1501,  1689,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1689,     0,     0,
       0,  2122,  2122,  1689,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1689,     0,     0,     0,     0,     0,
       0,  1689,     0,  1689,  1689,  1689,  1689,  1689,  1689,  1689,
    1689,  1689,  1689,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       7,     8,     0,     0,     0,     0,     9,     0,    10,    11,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,  2486,
       0,     0,     0,     0,     0,     0,     0,  1689,     0,     0,
       0,  3042,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3061,  3062,     0,     0,  3064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1689,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,  1689,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3116,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,  3150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1689,    42,     0,     0,     0,     0,  2486,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1689,     0,     0,     0,     0,  3168,
       0,     0,     0,     0,     0,     0,     0,  3170,     0,     0,
       0,     0,     0,     0,     0,     0,  3174,  1689,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,  3179,     0,     0,     0,     0,     0,
       0,     0,     0,  2550,     0,  2122,     0,     0,  2122,  2122,
    2122,  2122,  2122,  2122,  2122,  2122,  2122,  2122,     0,  2550,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3213,     0,    45,  1689,
       0,     0,     0,     0,  2550,  2550,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,  2122,  2122,  1689,     0,
    1689,    47,     0,  1689,    48,    49,     0,    50,     0,    51,
       0,     0,     0,    52,     0,    53,    54,     0,     0,     0,
      55,    56,    57,    58,    59,     0,     0,    60,    61,    62,
      63,     0,    64,    65,    66,     0,    67,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3174,     4,     0,     0,     0,     0,
       0,     0,     0,  1689,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       7,     8,     0,     0,     0,     0,     0,     0,    10,    11,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
    1689,     0,     0,     0,  1689,     0,     0,     0,     0,  1689,
    1689,     0,  1689,     0,     0,  2550,     0,     0,    38,  2550,
    2550,  2550,  2550,  2550,  2550,  2550,  2550,  2550,  2550,  1689,
    1689,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,  1689,  2122,  2122,  1689,     0,  1689,     0,
       0,     0,  1689,  2550,  2550,     0,     0,  1689,     0,     0,
    1689,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,  1689,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
    1689,     0,     0,     0,     0,     0,     0,  2122,     0,  2122,
      46,     0,  2550,  2550,     0,     0,     0,  2122,  2122,  1689,
    1689,    47,  1689,     0,    48,    49,     0,    50,     0,     0,
       0,     0,     0,    52,     0,    53,    54,     0,     0,     0,
      55,    56,    57,    58,    59,     0,     0,    60,    61,   964,
    1349,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1689,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1689,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2550,
    2122,  2550,     0,     0,  2550,  2550,  1689,     0,  1689,     0,
       0,     0,  1689,     0,     0,     0,     0,  1689,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   610,    79,    80,    81,   365,     0,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,  1689,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,  2550,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,   617,   386,   387,   618,   619,
     620,   621,   622,   623,   624,   388,   389,   625,   390,   129,
     391,   392,   393,   131,   132,   133,   134,     0,   626,   394,
     395,     0,   396,   627,   628,   397,   629,   135,   399,   630,
     400,   401,   402,   403,   139,   631,   632,   404,   405,   406,
     407,   633,   408,   409,   142,   410,   634,   411,   412,   413,
     145,   414,   635,   636,   637,   638,   639,   415,   416,   417,
     418,   419,   148,   149,   420,   640,   421,   641,   422,     0,
     423,   424,   425,   642,   426,   643,   644,   427,   428,   429,
     430,   645,   431,   432,   433,   646,   434,   647,   435,   436,
     437,   155,   438,     0,   157,   648,   439,   440,   159,   649,
     441,   650,   442,   160,   651,   161,   443,     0,   444,   652,
     445,   164,   653,   446,   654,   447,   448,   449,   165,   450,
     451,   452,   655,   453,   454,   455,   456,   457,   656,   166,
     167,   657,   458,   459,   460,   658,   169,   659,   170,   660,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
     661,   174,   175,   467,   176,   662,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,   182,   183,   663,   482,   483,   484,   485,
     486,   487,   488,   184,   489,   664,   490,   491,   186,   492,
     665,   187,   188,   493,   494,   666,   667,   495,   668,   669,
     670,   496,   497,   671,   672,   189,   190,   191,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,   673,   504,
     505,   506,   507,   508,   509,   196,   510,   674,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
     675,   530,   531,   532,   676,   533,   207,   534,   535,   209,
     536,   210,   677,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,   678,   546,   547,   679,   548,   549,   550,
     551,   680,   213,   214,   681,   553,   682,   554,   215,   555,
     216,   683,   556,   557,   558,   559,   560,   684,   685,   561,
     562,   563,   564,   686,   687,   565,   566,     0,   567,   223,
     568,   224,   569,     0,   688,   689,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,     0,     0,    79,
      80,    81,     0,     0,    83,    84,     0,    85,    86,    87,
       0,     0,     0,    90,    91,     0,    93,    94,    95,    96,
      97,    98,   690,    99,   100,   101,     0,     0,     0,   103,
     104,   105,   106,     0,   107,     0,   108,   109,   110,     0,
     111,   112,   113,   114,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,     0,     0,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,     0,     0,     0,     0,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   142,     0,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,     0,     0,   157,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,   164,     0,     0,     0,     0,
       0,     0,   165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   166,   167,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,   171,   172,     0,   173,     0,
       0,     0,     0,     0,     0,   174,   175,     0,   176,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,   183,     0,
       0,     0,     0,     0,     0,     0,     0,   184,     0,     0,
       0,     0,   186,     0,     0,   187,   188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,   192,     0,     0,     0,     0,   193,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     207,     0,     0,   209,     0,   210,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   213,   214,     0,     0,
       0,     0,   215,     0,   216,     0,     0,     0,     0,     0,
       0,   219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,     0,     0,
       0,     0,     0,    79,    80,    81,     0,   225,    83,    84,
     226,    85,    86,    87,     0,     0,     0,    90,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
       0,     0,     0,   103,   104,   105,   106,  2237,   107,     0,
     108,   109,   110,     0,   111,   112,   113,   114,     0,     0,
       0,     0,     0,   117,   118,     0,     0,     0,     0,   119,
       0,     0,     0,     0,     0,     0,     0,     0,   120,     0,
     121,     0,   122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,     0,     0,
       0,   131,   132,   133,   134,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   135,     0,     0,     0,     0,
       0,     0,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,   157,     0,     0,     0,   159,     0,     0,     0,
       0,   160,     0,   161,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,   165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,   167,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,   171,
     172,     0,   173,     0,     0,     0,     0,     0,     0,   174,
     175,     0,   176,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,   183,     0,     0,     0,     0,     0,     0,     0,
       0,   184,     0,     0,     0,     0,   186,     0,     0,   187,
     188,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   189,   190,   191,   192,     0,     0,     0,
       0,   193,   194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   207,     0,     0,   209,     0,   210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,   214,     0,     0,     0,     0,   215,     0,   216,     0,
       0,     0,     0,     0,     0,   219,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,     0,     0,    78,     0,     0,    79,    80,    81,
      82,   225,    83,    84,   226,    85,    86,    87,    88,     0,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   102,     0,     0,   103,   104,   105,
     106,  2239,   107,     0,   108,   109,   110,     0,   111,   112,
     113,   114,   115,   116,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,   124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   125,
     126,   127,     0,     0,     0,     0,     0,     0,     0,     0,
     128,   129,     0,     0,   130,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,   136,     0,   137,   138,   139,     0,     0,   140,
     141,     0,     0,     0,     0,     0,   142,   143,   144,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,   146,     0,   147,   148,   149,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,   153,     0,     0,
       0,     0,   154,   155,   156,     0,   157,     0,   158,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,   162,
       0,   163,     0,   164,     0,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,   168,     0,     0,   169,     0,
     170,     0,     0,   171,   172,     0,   173,     0,     0,     0,
       0,     0,     0,   174,   175,     0,   176,     0,   177,   178,
       0,     0,     0,     0,   179,     0,     0,     0,     0,     0,
       0,     0,   180,     0,   181,   182,   183,     0,     0,     0,
       0,     0,     0,     0,     0,   184,     0,     0,     0,   185,
     186,     0,     0,   187,   188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   189,   190,   191,
     192,     0,     0,     0,     0,   193,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,   196,     0,     0,
     197,     0,   198,     0,     0,     0,   199,     0,     0,     0,
     200,   201,     0,   202,   203,     0,     0,   204,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   206,   207,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
       0,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   213,   214,     0,     0,     0,     0,
     215,     0,   216,     0,   217,     0,   218,     0,     0,   219,
       0,     0,   220,     0,   221,     0,     0,   222,     0,     0,
       0,   223,     0,   224,     0,     0,     0,     0,     0,     0,
     610,    79,    80,    81,   365,   225,    83,    84,   226,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
     227,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,  2199,   386,   387,     0,     0,     0,     0,  1160,     0,
       0,   388,   389,     0,   390,   129,   391,   392,   393,   131,
    1161,   133,  1162,  1163,     0,   394,   395,     0,   396,  1164,
    1165,   397,  1166,  1167,   399,     0,   400,   401,   402,   403,
    1168,     0,     0,   404,   405,   406,   407,     0,   408,   409,
    1169,   410,     0,   411,   412,   413,   145,   414,  1170,  1171,
    1172,  1173,  1174,   415,   416,   417,   418,   419,  1175,  1176,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,  2200,     0,   427,  1177,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,  1178,   438,     0,
    1179,  1180,   439,   440,  1181,     0,   441,     0,   442,   160,
       0,   161,   443,     0,   444,     0,   445,  1182,     0,   446,
       0,   447,   448,   449,   165,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,   166,   167,     0,   458,   459,
     460,  1183,  1184,     0,  1185,     0,     0,   171,   172,   461,
     173,   462,   463,   464,   465,   466,     0,  1186,   175,   467,
     176,     0,   468,   469,   470,  1187,  1188,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1189,   182,
    1190,   739,   482,   483,   484,   485,   486,   487,   488,   184,
     489,  1191,   490,   491,   186,   492,  1192,  1193,  1194,   493,
     494,     0,     0,   495,   740,     0,     0,  1195,   497,     0,
       0,   189,   190,   191,  1196,   498,   499,   500,     0,  1197,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1198,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   201,   522,   523,  1199,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
    1200,   533,   207,   534,   535,   209,   536,  1201,     0,   537,
     538,   539,   540,   541,   542,   543,   544,  1202,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1203,  1204,
       0,   553,     0,   554,  1205,   555,  1206,  1207,   556,   557,
     558,   559,   560,     0,  1208,   561,   562,   563,   564,  1209,
       0,   565,   566,     0,   567,  1210,   568,   224,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,  1211,   226,   576,     0,     0,  1212,  1213,    52,  1214,
      53,     0,     0,     0,     0,  1215,  1216,  2201,     0,     0,
       0,     0,     0,     0,  1218,  2202,   610,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,  1160,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,  1161,   133,  1162,  1163,
       0,   394,   395,     0,   396,  1164,  1165,   397,  1166,  1167,
     399,     0,   400,   401,   402,   403,  1168,     0,     0,   404,
     405,   406,   407,     0,   408,   409,  1169,   410,     0,   411,
     412,   413,   145,   414,  1170,  1171,  1172,  1173,  1174,   415,
     416,   417,   418,   419,  1175,  1176,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1177,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,  1178,   438,     0,  1179,  1180,   439,   440,
    1181,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,  1182,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,   166,   167,     0,   458,   459,   460,  1183,  1184,     0,
    1185,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,  1186,   175,   467,   176,     0,   468,   469,
     470,  1187,  1188,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1189,   182,  1190,   739,   482,   483,
     484,   485,   486,   487,   488,   184,   489,  1191,   490,   491,
     186,   492,  1192,  1193,  1194,   493,   494,     0,     0,   495,
     740,     0,     0,  1195,   497,     0,     0,   189,   190,   191,
    1196,   498,   499,   500,     0,  1197,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1198,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,  1199,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,  1200,   533,   207,   534,
     535,   209,   536,  1201,     0,   537,   538,   539,   540,   541,
     542,   543,   544,  1202,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1203,  1204,     0,   553,     0,   554,
    1205,   555,  1206,  1207,   556,   557,   558,   559,   560,     0,
    1208,   561,   562,   563,   564,  1209,     0,   565,   566,     0,
     567,  1210,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,  1211,   226,   576,
       0,     0,  1212,  1213,    52,  1214,    53,     0,     0,     0,
       0,  1215,  1216,     0,     0,     0,     0,     0,     0,     0,
    1218,  2124,   610,    79,    80,    81,   365,     0,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,   129,   391,   392,
     393,   131,  1468,   133,  1469,  1163,     0,   394,   395,     0,
     396,     0,     0,   397,  1470,  1471,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,   145,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1472,  1473,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1177,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1474,     0,   441,     0,
     442,   160,     0,   161,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,   165,   450,   451,   452,
    1844,   453,   454,   455,   456,   457,     0,   166,  1845,     0,
     458,   459,   460,  1183,  1475,     0,  1476,     0,     0,   171,
     172,   461,   173,   462,   463,   464,   465,   466,     0,     0,
     175,   467,   176,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1477,   182,  1478,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,   186,   492,     0,     0,
    1479,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,  1846,   190,   191,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1480,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   201,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1481,   534,   535,   209,   536,  1482,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1483,  1484,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1485,   568,   224,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,     0,     0,     0,     0,     0,
       0,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,  1847,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
    3216,   565,   566,     0,   567,   223,   568,     0,   569,     4,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0, -1239,     0,     7,     8, -1239,     0,     0,     0,
       0,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    40,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,   964,  1801,   610,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1160,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1161,   133,  1162,  1163,  2134,
     394,   395,     0,   396,  1164,  1165,   397,  1166,  1167,   399,
       0,   400,   401,   402,   403,  1168,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1169,   410,     0,   411,   412,
     413,   145,   414,  1170,  1171,  1172,  1173,  1174,   415,   416,
     417,   418,   419,  1175,  1176,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1177,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1178,   438,     0,  1179,  1180,   439,   440,  1181,
       0,   441,     0,   442,   160,  2135,   161,   443,     0,   444,
       0,   445,  1182,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1183,  1184,     0,  1185,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,  2136,  1186,   175,   467,   176,     0,   468,   469,   470,
    1187,  1188,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1189,   182,  1190,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1191,   490,   491,   186,
     492,  1192,  1193,  1194,   493,   494,     0,     0,   495,   740,
       0,     0,  1195,   497,     0,     0,   189,   190,   191,  1196,
     498,   499,   500,     0,  1197,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1198,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1199,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1200,   533,   207,   534,   535,
     209,   536,  1201,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1202,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1203,  1204,     0,   553,  2137,   554,  1205,
     555,  1206,  1207,   556,   557,   558,   559,   560,     0,  1208,
     561,   562,   563,   564,  1209,     0,   565,   566,     0,   567,
    1210,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1211,   226,   576,     0,
       0,  1212,  1213,    52,  1214,    53,     0,     0,     0,     0,
    1215,  1216,     0,     0,   610,    79,    80,    81,   365,  1218,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,     0,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,  1160,     0,     0,   388,   389,     0,   390,   129,
     391,   392,   393,   131,  1161,   133,  1162,  1163,     0,   394,
     395,     0,   396,  1164,  1165,   397,  1166,  1167,   399,     0,
     400,   401,   402,   403,  1168,     0,     0,   404,   405,   406,
     407,     0,   408,   409,  1169,   410,     0,   411,   412,   413,
     145,   414,  1170,  1171,  1172,  1173,  1174,   415,   416,   417,
     418,   419,  1175,  1176,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1177,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,  1178,   438,     0,  1179,  1180,   439,   440,  1181,     0,
     441,     0,   442,   160,     0,   161,   443,     0,   444,     0,
     445,  1182,     0,   446,     0,   447,   448,   449,   165,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,   166,
     167,     0,   458,   459,   460,  1183,  1184,     0,  1185,     0,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
       0,  1186,   175,   467,   176,     0,   468,   469,   470,  1187,
    1188,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1189,   182,  1190,   739,   482,   483,   484,   485,
     486,   487,   488,   184,   489,  1191,   490,   491,   186,   492,
    1192,  1193,  1194,   493,   494,     0,     0,   495,   740,     0,
       0,  1195,   497,     0,     0,   189,   190,   191,  1196,   498,
     499,   500,     0,  1197,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1198,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,  1199,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,  1200,   533,   207,   534,   535,   209,
     536,  1201,     0,   537,   538,   539,   540,   541,   542,   543,
     544,  1202,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1203,  1204,     0,   553,     0,   554,  1205,   555,
    1206,  1207,   556,   557,   558,   559,   560,     0,  1208,   561,
     562,   563,   564,  1209,     0,   565,   566,     0,   567,  1210,
     568,   224,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,    49,  1211,   226,   576,     0,     0,
    1212,  1213,    52,  1214,    53,     0,     0,     0,     0,  1215,
    1216,  1217,     0,   610,    79,    80,    81,   365,  1218,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   611,    99,   100,
     101,   368,   612,     0,   103,   104,   105,   106,   613,   614,
       0,   108,   109,   110,     0,   111,   615,   616,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1160,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1161,   133,  1162,  1163,     0,   394,   395,
       0,   396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,
     401,   402,   403,  1168,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1169,   410,     0,   411,   412,   413,   145,
     414,  1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,
     419,  1175,  1176,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1177,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1178,   438,     0,  1179,  1180,   439,   440,  1181,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1182,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1183,  1184,     0,  1185,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1186,   175,   467,   176,     0,   468,   469,   470,  1187,  1188,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1189,   182,  1190,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1191,   490,   491,   186,   492,  1192,
    1193,  1194,   493,   494,     0,     0,   495,   740,     0,     0,
    1195,   497,     0,     0,   189,   190,   191,  1196,   498,   499,
     500,     0,  1197,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1198,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1199,   524,   525,   526,   527,   528,   529,     0,   205,
     530,   531,   532,  1200,   533,   207,   534,   535,   209,   536,
    1201,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1202,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,
    1207,   556,   557,   558,   559,   560,     0,  1208,   561,   562,
     563,   564,  1209,     0,   565,   566,     0,   567,  1210,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1211,   226,   576,     0,     0,  1212,
    1213,    52,  1214,    53,     0,     0,     0,     0,  1215,  1216,
       0,     0,   610,    79,    80,    81,   365,  1218,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,  1758,   386,   387,     0,     0,     0,     0,
    1160,     0,     0,   388,   389,     0,   390,   129,   391,   392,
     393,   131,  1161,   133,  1162,  1163,     0,   394,   395,     0,
     396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,   401,
     402,   403,  1168,     0,     0,   404,   405,   406,   407,     0,
     408,   409,  1169,   410,     0,   411,   412,   413,   145,   414,
    1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,   419,
    1175,  1176,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1177,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,  1178,
     438,     0,  1179,  1180,   439,   440,  1181,     0,   441,     0,
     442,   160,     0,   161,   443,     0,   444,     0,   445,  1182,
       0,   446,     0,   447,   448,   449,   165,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,   166,   167,     0,
     458,   459,   460,  1183,  1184,     0,  1185,     0,     0,   171,
     172,   461,   173,   462,   463,   464,   465,   466,     0,  1186,
     175,   467,   176,     0,   468,   469,   470,  1187,  1188,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1189,   182,  1190,   739,   482,   483,   484,   485,   486,   487,
     488,   184,   489,  1191,   490,   491,   186,   492,  1192,  1193,
    1194,   493,   494,     0,     0,   495,   740,     0,     0,  1195,
     497,     0,     0,   189,   190,   191,  1196,   498,   499,   500,
       0,  1197,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1198,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   201,   522,   523,
    1199,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,  1200,   533,   207,   534,   535,   209,   536,  1201,
       0,   537,   538,   539,   540,   541,   542,   543,   544,  1202,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,  1207,
     556,   557,   558,   559,   560,     0,  1208,   561,   562,   563,
     564,  1209,     0,   565,   566,     0,   567,  1210,   568,   224,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,  1211,   226,   576,     0,     0,  1212,  1213,
      52,  1214,    53,     0,     0,     0,     0,  1215,  1216,     0,
       0,   610,    79,    80,    81,   365,  1218,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,  1160,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1161,   133,  1162,  1163,     0,   394,   395,     0,   396,
    1164,  1165,   397,  1166,  1167,   399,     0,   400,   401,   402,
     403,  1168,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1169,   410,     0,   411,   412,   413,   145,   414,  1170,
    1171,  1172,  1173,  1174,   415,   416,   417,   418,   419,  1175,
    1176,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1177,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,  1178,   438,
       0,  1179,  1180,   439,   440,  1181,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1182,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1183,  1184,     0,  1185,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1186,   175,
     467,   176,     0,   468,   469,   470,  1187,  1188,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1189,
     182,  1190,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,  1191,   490,   491,   186,   492,  1192,  1193,  1194,
     493,   494,     0,     0,   495,   740,     0,     0,  1195,   497,
       0,     0,   189,   190,   191,  1196,   498,   499,   500,     0,
    1197,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1198,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1199,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1200,   533,   207,   534,   535,   209,   536,  1201,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1202,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1203,
    1204,     0,   553,     0,   554,  1205,   555,  1206,  1207,   556,
     557,   558,   559,   560,     0,  1208,   561,   562,   563,   564,
    1209,     0,   565,   566,     0,   567,  1210,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,  1211,   226,   576,     0,     0,  1212,  1213,    52,
    1214,    53,     0,     0,     0,     0,  1215,  1216,     0,     0,
       0,     0,     0,  1604,     0,  1218,   610,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,  1160,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,  1161,   133,  1162,  1163,
       0,   394,   395,     0,   396,  1164,  1165,   397,  1166,  1167,
     399,     0,   400,   401,   402,   403,  1168,     0,     0,   404,
     405,   406,   407,     0,   408,   409,  1169,   410,     0,   411,
     412,   413,   145,   414,  1170,  1171,  1172,  1173,  1174,   415,
     416,   417,   418,   419,  1175,  1176,   420,  2485,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1177,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,  1178,   438,     0,  1179,  1180,   439,   440,
    1181,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,  1182,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,   166,   167,     0,   458,   459,   460,  1183,  1184,     0,
    1185,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,  1186,   175,   467,   176,     0,   468,   469,
     470,  1187,  1188,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1189,   182,  1190,   739,   482,   483,
     484,   485,   486,   487,   488,   184,   489,  1191,   490,   491,
     186,   492,  1192,  1193,  1194,   493,   494,     0,     0,   495,
     740,     0,     0,  1195,   497,     0,     0,   189,   190,   191,
    1196,   498,   499,   500,     0,  1197,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1198,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,  1199,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,  1200,   533,   207,   534,
     535,   209,   536,  1201,     0,   537,   538,   539,   540,   541,
     542,   543,   544,  1202,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1203,  1204,     0,   553,     0,   554,
    1205,   555,  1206,  1207,   556,   557,   558,   559,   560,     0,
    1208,   561,   562,   563,   564,  1209,     0,   565,   566,     0,
     567,  1210,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,  1211,   226,   576,
       0,     0,  1212,  1213,    52,  1214,    53,     0,     0,     0,
       0,  1215,  1216,     0,     0,   610,    79,    80,    81,   365,
    1218,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1160,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1161,   133,  1162,  1163,     0,
     394,   395,     0,   396,  1164,  1165,   397,  1166,  1167,   399,
       0,   400,   401,   402,   403,  1168,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1169,   410,     0,   411,   412,
     413,   145,   414,  1170,  1171,  1172,  1173,  1174,   415,   416,
     417,   418,   419,  1175,  1176,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1177,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1178,   438,     0,  1179,  1180,   439,   440,  1181,
       0,   441,     0,   442,   160,  2135,   161,   443,     0,   444,
       0,   445,  1182,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1183,  1184,     0,  1185,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1186,   175,   467,   176,     0,   468,   469,   470,
    1187,  1188,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1189,   182,  1190,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1191,   490,   491,   186,
     492,  1192,  1193,  1194,   493,   494,     0,     0,   495,   740,
       0,     0,  1195,   497,     0,     0,   189,   190,   191,  1196,
     498,   499,   500,     0,  1197,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1198,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1199,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1200,   533,   207,   534,   535,
     209,   536,  1201,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1202,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1203,  1204,     0,   553,     0,   554,  1205,
     555,  1206,  1207,   556,   557,   558,   559,   560,     0,  1208,
     561,   562,   563,   564,  1209,     0,   565,   566,     0,   567,
    1210,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1211,   226,   576,     0,
       0,  1212,  1213,    52,  1214,    53,     0,     0,     0,     0,
    1215,  1216,     0,     0,   610,    79,    80,    81,   365,  1218,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,     0,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,  1160,     0,     0,   388,   389,     0,   390,   129,
     391,   392,   393,   131,  1161,   133,  1162,  1163,     0,   394,
     395,     0,   396,  1164,  1165,   397,  1166,  1167,   399,     0,
     400,   401,   402,   403,  1168,     0,     0,   404,   405,   406,
     407,     0,   408,   409,  1169,   410,     0,   411,   412,   413,
     145,   414,  1170,  1171,  1172,  1173,  1174,   415,   416,   417,
     418,   419,  1175,  1176,   420,  2919,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1177,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,  1178,   438,     0,  1179,  1180,   439,   440,  1181,     0,
     441,     0,   442,   160,     0,   161,   443,     0,   444,     0,
     445,  1182,     0,   446,     0,   447,   448,   449,   165,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,   166,
     167,     0,   458,   459,   460,  1183,  1184,     0,  1185,     0,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
       0,  1186,   175,   467,   176,     0,   468,   469,   470,  1187,
    1188,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1189,   182,  1190,   739,   482,   483,   484,   485,
     486,   487,   488,   184,   489,  1191,   490,   491,   186,   492,
    1192,  1193,  1194,   493,   494,     0,     0,   495,   740,     0,
       0,  1195,   497,     0,     0,   189,   190,   191,  1196,   498,
     499,   500,     0,  1197,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1198,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,  1199,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,  1200,   533,   207,   534,   535,   209,
     536,  1201,     0,   537,   538,   539,   540,   541,   542,   543,
     544,  1202,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1203,  1204,     0,   553,     0,   554,  1205,   555,
    1206,  1207,   556,   557,   558,   559,   560,     0,  1208,   561,
     562,   563,   564,  1209,     0,   565,   566,     0,   567,  1210,
     568,   224,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,    49,  1211,   226,   576,     0,     0,
    1212,  1213,    52,  1214,    53,     0,     0,     0,     0,  1215,
    1216,     0,     0,   610,    79,    80,    81,   365,  1218,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   611,    99,   100,
     101,   368,   612,     0,   103,   104,   105,   106,   613,   614,
       0,   108,   109,   110,     0,   111,   615,   616,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1160,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1161,   133,  1162,  1163,     0,   394,   395,
       0,   396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,
     401,   402,   403,  1168,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1169,   410,     0,   411,   412,   413,   145,
     414,  1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,
     419,  1175,  1176,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1177,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1178,   438,     0,  1179,  1180,   439,   440,  1181,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1182,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1183,  1184,     0,  1185,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1186,   175,   467,   176,     0,   468,   469,   470,  1187,  1188,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1189,   182,  1190,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1191,   490,   491,   186,   492,  1192,
    1193,  1194,   493,   494,     0,     0,   495,   740,     0,     0,
    1195,   497,     0,     0,   189,   190,   191,  1196,   498,   499,
     500,     0,  1197,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1198,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1199,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1200,   533,   207,   534,   535,   209,   536,
    1201,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1202,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,
    1207,   556,   557,   558,   559,   560,     0,  1208,   561,   562,
     563,   564,  1209,     0,   565,   566,     0,   567,  1210,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1211,   226,   576,     0,     0,  1212,
    1213,    52,  1214,    53,     0,     0,     0,     0,  1215,  1216,
       0,     0,   610,    79,    80,    81,   365,  1218,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
    1160,     0,     0,   388,   389,     0,   390,   129,   391,   392,
     393,   131,  1161,   133,  1162,  1163,     0,   394,   395,     0,
     396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,   401,
     402,   403,  1168,     0,     0,   404,   405,   406,   407,     0,
     408,   409,  1169,   410,     0,   411,   412,   413,   145,   414,
    1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,   419,
    1175,  1176,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1177,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,  1178,
     438,     0,  1179,  1180,   439,   440,  1181,     0,   441,     0,
     442,   160,     0,   161,   443,     0,   444,     0,   445,  1182,
       0,   446,     0,   447,   448,   449,   165,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,   166,   167,     0,
     458,   459,   460,  1183,  1184,     0,  1185,     0,     0,   171,
     172,   461,   173,   462,   463,   464,   465,   466,     0,  1186,
     175,   467,   176,     0,   468,   469,   470,  1187,  1188,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1189,   182,  1190,   739,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,   186,   492,  1192,  1193,
    1194,   493,   494,     0,     0,   495,   740,     0,     0,  1195,
     497,     0,     0,   189,   190,   191,  1196,   498,   499,   500,
       0,  1197,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1198,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   201,   522,   523,
    1199,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,  1200,   533,   207,   534,   535,   209,   536,  1201,
       0,   537,   538,   539,   540,   541,   542,   543,   544,  1202,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,  1207,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,  1209,     0,   565,   566,     0,   567,  1210,   568,   224,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,  1211,   226,   576,     0,     0,  1212,  1213,
      52,  1214,    53,   610,    79,    80,    81,   365,  2119,    83,
      84,     0,    85,    86,    87,   366,  1218,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   611,    99,   100,
     101,   368,   612,     0,   103,   104,   105,   106,   613,   614,
       0,   108,   109,   110,     0,   111,   615,   616,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1160,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,     0,  1161,   133,  1162,  1163,     0,   394,   395,
       0,   396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,
     401,   402,   403,  1168,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1169,   410,     0,   411,   412,   413,   145,
     414,  1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,
     419,  1175,  1176,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1177,   429,   430,
       0,   431,   432,   433,     0,     0,     0,   435,   436,   437,
    1178,   438,     0,  1179,  1180,   439,   440,  1181,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1182,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1183,  1184,     0,  1185,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1186,   175,   467,     0,     0,   468,   469,   470,  1187,  1188,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1189,   182,  1190,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,   186,   492,  1192,
    1193,  1194,   493,   494,     0,     0,   495,   740,     0,     0,
    1195,   497,     0,     0,   189,   190,   191,  1196,   498,   499,
     500,     0,  1197,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1198,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1199,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1200,   533,   207,   534,   535,     0,   536,
    1201,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1202,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,
    1207,   556,   557,   558,   559,   560,     0,  1208,   561,   562,
     563,   564,  1209,     0,   565,   566,     0,   567,  1210,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1211,   226,   576,     0,     0,  1212,
    1213,    52,  1214,    53,     0,     0,     0,     0,  1215,  1216,
       0,     0,   610,    79,    80,    81,   365,  1218,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
    1160,     0,     0,   388,   389,     0,   390,   129,   391,   392,
     393,     0,  1161,   133,  1162,  1163,     0,   394,   395,     0,
     396,  1164,  1165,   397,  1166,  1167,   399,     0,   400,   401,
     402,   403,  1168,     0,     0,   404,   405,   406,   407,     0,
     408,   409,  1169,   410,     0,   411,   412,   413,   145,   414,
    1170,  1171,  1172,  1173,  1174,   415,   416,   417,   418,   419,
    1175,  1176,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1177,   429,   430,     0,
     431,   432,   433,     0,     0,     0,   435,   436,   437,  1178,
     438,     0,  1179,  1180,   439,   440,  1181,     0,   441,     0,
     442,   160,     0,   161,   443,     0,   444,     0,   445,  1182,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,   166,   167,     0,
     458,   459,   460,  1183,  1184,     0,  1185,     0,     0,   171,
     172,   461,   173,   462,   463,   464,   465,   466,     0,  1186,
     175,   467,     0,     0,   468,   469,   470,  1187,  1188,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1189,   182,  1190,   739,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,   186,   492,  1192,  1193,
    1194,   493,   494,     0,     0,   495,   740,     0,     0,     0,
     497,     0,     0,   189,   190,   191,  1196,   498,   499,   500,
       0,  1197,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1198,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   201,   522,   523,
    1199,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,  1200,   533,   207,   534,   535,     0,   536,  1201,
       0,   537,   538,   539,   540,   541,   542,   543,   544,  1202,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1203,  1204,     0,   553,     0,   554,  1205,   555,  1206,  1207,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,  1209,     0,   565,   566,     0,   567,  1210,   568,   224,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,     0,   226,   576,     0,     0,  1212,  1213,
      52,  1214,    53,     0,    79,    80,    81,   365,  2119,    83,
      84,     0,    85,    86,    87,   366,  1218,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,  2444,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,  -829,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,  -829,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,  -829,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,  -829,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,  -829,   495,     0,     0,     0,
     496,   497,     0,  -829,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,  -829,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,     0,     0,     0,     0,
       0,     0,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,  1295,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,   132,   133,   134,     0,     0,   394,   395,     0,   396,
       0,  1165,   397,   398,   135,   399,     0,   400,   401,   402,
     403,  1168,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1169,   410,     0,   411,   412,   413,   145,   414,  1170,
    1171,  1172,  1173,  1174,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,  1179,     0,   439,   440,   159,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1182,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1186,   175,
     467,   176,     0,   468,   469,   470,  1187,  1188,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
     182,   183,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,   186,   492,     0,  1193,   188,
     493,   494,     0,     0,   495,   740,     0,   900,   496,   497,
       0,     0,   189,   190,   191,  1196,   498,   499,   500,     0,
    1197,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   205,   530,   531,
     532,  1200,   533,   207,   534,   535,   209,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1202,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,  1205,   555,  1206,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
    1209,     0,   565,   566,     0,   567,   223,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,     0,     0,     0,     0,     0,    79,
      80,    81,   365,     0,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,  2018,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,   129,   391,   392,   393,   131,   132,   133,
     134,     0,     0,   394,   395,     0,   396,     0,  1165,   397,
     398,   135,   399,     0,   400,   401,   402,   403,  1168,     0,
       0,   404,   405,   406,   407,     0,   408,   409,  1169,   410,
       0,   411,   412,   413,   145,   414,  1170,  1171,  1172,  1173,
    1174,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,  1179,     0,
     439,   440,   159,     0,   441,     0,   442,   160,     0,   161,
     443,     0,   444,     0,   445,  1182,     0,   446,     0,   447,
     448,   449,   165,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,   166,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,     0,  1186,   175,   467,   176,     0,
     468,   469,   470,  1187,  1188,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,   182,   183,   739,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,   186,   492,     0,  1193,   188,   493,   494,     0,
       0,   495,   740,     0,   900,   496,   497,     0,     0,   189,
     190,   191,  1196,   498,   499,   500,     0,  1197,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,  1200,   533,
     207,   534,   535,   209,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,  1202,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,  1205,   555,  1206,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,  1209,     0,   565,
     566,     0,   567,   223,   568,   224,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,     0,     0,     0,     0,     0,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,  2018,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,   132,   133,   134,     0,     0,
     394,   395,     0,   396,     0,  1165,   397,   398,   135,   399,
       0,   400,   401,   402,   403,  1168,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1169,   410,     0,   411,   412,
     413,   145,   414,  1170,  1171,  1172,  1173,  1174,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,  1179,     0,   439,   440,   159,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1182,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1186,   175,   467,   176,     0,   468,   469,   470,
    1187,  1188,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,   182,   183,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,   186,
     492,     0,  1193,   188,   493,   494,     0,     0,   495,   740,
       0,     0,   496,   497,     0,     0,   189,   190,   191,  1196,
     498,   499,   500,     0,  1197,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1200,   533,   207,   534,   535,
     209,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1202,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,  1205,
     555,  1206,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,  1209,     0,   565,   566,     0,   567,
     223,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,     0,     0,
       0,     0,     0,    79,    80,    81,   365,     0,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,  3140,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,     0,   226,   576,     0,     0,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2379,  2380,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,     0,   226,   576,
       0,     0,     0,     0,    52,     0,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
    2380,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,   740,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,     0,     0,
       0,     0,     0,    79,    80,    81,   365,     0,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,  1289,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,   205,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   576,     0,     0,     0,     0,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,   227,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,   205,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,     0,     0,     0,     0,     0,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,   227,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,     0,
       0,     0,     0,     0,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
    1740,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,     0,     0,     0,     0,
     610,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,  2816,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
       0,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1468,     0,  1469,  1163,     0,   394,   395,     0,   396,     0,
       0,   397,  1470,  1471,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1472,  1473,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1177,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1474,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1183,  1475,     0,  1476,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1477,     0,
    1478,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,     0,     0,  1479,   493,
     494,     0,     0,   495,     0,     0,     0,  2718,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1480,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1481,   534,   535,     0,   536,  1482,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1483,  1484,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1485,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,  1011,   226,   576,     0,     0,     0,     0,    52,     0,
      53,  1012,  1013,  1014,     0,  1015,  2719,  1017,  1018,  1019,
    1020,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,  1010,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,  1011,   226,     0,     0,     0,     0,     0,     0,     0,
       0,  1012,  1013,  1014,     0,  1015,  1016,  1017,  1018,  1019,
    1020,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,  1011,   226,     0,     0,     0,     0,     0,     0,     0,
       0,  1012,  1013,  1014,     0,  1015,  1016,  1017,  1018,  1019,
    1020,   610,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,   617,   386,   387,   618,   619,   620,   621,   622,
     623,   624,   388,   389,   625,   390,   129,   391,   392,   393,
     131,   132,   133,   134,     0,   626,   394,   395,     0,   396,
     627,   628,   397,   629,   135,   399,   630,   400,   401,   402,
     403,   139,   631,   632,   404,   405,   406,   407,   633,   408,
     409,   142,   410,   634,   411,   412,   413,   145,   414,   635,
     636,   637,   638,   639,   415,   416,   417,   418,   419,   148,
     149,   420,   640,   421,   641,   422,     0,   423,   424,   425,
     642,   426,   643,   644,   427,   428,   429,   430,   645,   431,
     432,   433,   646,   434,   647,   435,   436,   437,   155,   438,
       0,   157,   648,   439,   440,   159,   649,   441,   650,   442,
     160,   651,   161,   443,     0,   444,   652,   445,   164,   653,
     446,   654,   447,   448,   449,   165,   450,   451,   452,   655,
     453,   454,   455,   456,   457,   656,   166,   167,   657,   458,
     459,   460,   658,   169,   659,   170,   660,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,   661,   174,   175,
     467,   176,   662,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
     182,   183,   663,   482,   483,   484,   485,   486,   487,   488,
     184,   489,   664,   490,   491,   186,   492,   665,   187,   188,
     493,   494,   666,   667,   495,   668,   669,   670,   496,   497,
     671,   672,   189,   190,   191,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,   673,   504,   505,   506,   507,
     508,   509,   196,   510,   674,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   675,   530,   531,
     532,   676,   533,   207,   534,   535,   209,   536,   210,   677,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
     678,   546,   547,   679,   548,   549,   550,   551,   680,   213,
     214,   681,   553,   682,   554,   215,   555,   216,   683,   556,
     557,   558,   559,   560,   684,   685,   561,   562,   563,   564,
     686,   687,   565,   566,     0,   567,   223,   568,   224,   569,
       0,   688,   689,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,     0,   610,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,  1448,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,  1468,     0,  1469,  1163,     0,
     394,   395,     0,   396,     0,     0,   397,  1470,  1471,   399,
       0,   400,   401,   402,   403,     0,     0,     0,   404,   405,
     406,   407,     0,   408,   409,     0,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,  1472,  1473,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1177,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,     0,   438,     0,     0,     0,   439,   440,  1474,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,     0,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,     0,     0,   458,   459,   460,  1183,  1475,     0,  1476,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,     0,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1477,     0,  1478,     0,   482,   483,   484,
     485,   486,   487,   488,     0,   489,     0,   490,   491,     0,
     492,     0,     0,  1479,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,     0,     0,     0,     0,
     498,   499,   500,     0,     0,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1480,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,     0,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,  1481,   534,   535,
       0,   536,  1482,     0,   537,   538,   539,   540,   541,   542,
     543,   544,     0,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1483,  1484,     0,   553,     0,   554,     0,
     555,     0,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
    1485,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,  1811,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,   740,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,   898,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
    1725,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
    1726,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
    1727,     0,   495,     0,  1728,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,  1729,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,     0,     0,     0,     0,    52,     0,    53,
       0,    79,    80,    81,   365,  1324,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,  1726,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,  1727,     0,   495,     0,  1728,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,  1729,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,     0,   226,   576,     0,     0,     0,     0,    52,     0,
      53,     0,    79,    80,    81,   365,  1324,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   815,   380,   381,   382,   383,
     384,   385,   816,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   817,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   818,   159,     0,   441,     0,   819,
       0,   820,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,   821,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   822,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   823,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   824,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   825,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,    79,    80,    81,   365,    52,
      83,    84,     0,    85,    86,    87,   366,   826,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   815,   380,
     381,   382,   383,   384,   385,   816,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     817,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   818,   159,     0,
     441,     0,   819,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   822,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   823,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   824,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   825,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   576,    79,    80,
      81,   365,    52,    83,    84,     0,    85,    86,    87,   366,
     826,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,   599,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,  1261,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,     0,   226,
     576,    79,    80,    81,   365,     0,    83,    84,  1262,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,     0,   226,   576,     0,     0,  1212,  1213,    52,     0,
      53,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,     0,   877,  1343,    79,    80,    81,   365,
     878,    83,    84,     0,    85,    86,    87,   366,   879,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   880,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   881,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   882,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   883,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   884,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   885,   214,     0,   553,     0,   886,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,     0,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110, -1352,   111,
     112,   113,   114,     0,     0,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,   123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,   171,   172,     0,   173,     0,     0,
       0,     0,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,   183,     0,     0,
       0,     0,     0,     0,     0,     0,   184,     0,     0,     0,
       0,   186,     0,     0,   187,   188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   207,
       0,     0,   209,     0,   210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,   215,     0,   216,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,   226,
       0,   356,    79,    80,    81,     0,     0,    83,    84,     0,
      85,    86,    87,     0,     0,     0,    90,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,     0,
       0,     0,   103,   104,   105,   106,     0,   107,     0,   108,
     109,   110, -1353,   111,   112,   113,   114,     0,     0,     0,
       0,     0,   117,   118,     0,     0,     0,     0,   119,     0,
       0,     0,     0,     0,     0,     0,     0,   120,     0,   121,
       0,   122,   123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,     0,     0,   165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   166,   167,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,   171,   172,
       0,   173,     0,     0,     0,     0,     0,     0,   174,   175,
       0,   176,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,   183,     0,     0,     0,     0,     0,     0,     0,     0,
     184,     0,     0,     0,     0,   186,     0,     0,   187,   188,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   207,     0,     0,   209,     0,   210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   213,
     214,     0,     0,     0,     0,   215,     0,   216,     0,     0,
       0,     0,     0,     0,   219,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     225,     0,     0,   226,     0,   943,   610,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,   617,   386,   387,
     618,   619,   620,   621,   622,   623,   624,   388,   389,   625,
     390,   129,   391,   392,   393,   131,   132,   133,   134,     0,
     626,   394,   395,     0,   396,   627,   628,   397,   629,   135,
     399,   630,   400,   401,   402,   403,   139,   631,   632,   404,
     405,   406,   407,   633,   408,   409,   142,   410,   634,   411,
     412,   413,   145,   414,   635,   636,   637,   638,   639,   415,
     416,   417,   418,   419,   148,   149,   420,   640,   421,   641,
     422,     0,   423,   424,   425,   642,   426,   643,   644,   427,
     428,   429,   430,   645,   431,   432,   433,   646,   434,   647,
     435,   436,   437,   155,   438,     0,   157,   648,   439,   440,
     159,   649,   441,   650,   442,   160,   651,   161,   443,     0,
     444,   652,   445,   164,   653,   446,   654,   447,   448,   449,
     165,   450,   451,   452,   655,   453,   454,   455,   456,   457,
     656,   166,   167,   657,   458,   459,   460,   658,   169,   659,
     170,   660,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,   661,   174,   175,   467,   176,   662,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,   182,   183,   663,   482,   483,
     484,   485,   486,   487,   488,   184,   489,   664,   490,   491,
     186,   492,   665,   187,   188,   493,   494,   666,   667,   495,
     668,   669,   670,   496,   497,   671,   672,   189,   190,   191,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
     673,   504,   505,   506,   507,   508,   509,   196,   510,   674,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,   675,   530,   531,   532,   676,   533,   207,   534,
     535,   209,   536,   210,   677,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,   678,   546,   547,   679,   548,
     549,   550,   551,   680,   213,   214,   681,   553,   682,   554,
     215,   555,   216,   683,   556,   557,   558,   559,   560,   684,
     685,   561,   562,   563,   564,   686,   687,   565,   566,     0,
     567,   223,   568,   224,   569,     0,   688,   689,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   610,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   611,    99,   100,   101,   368,   612,     0,
     103,   104,   105,   106,   613,   614,     0,   108,   109,   110,
       0,   111,   615,   616,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1468,
     133,  1469,  1163,     0,   394,   395,     0,   396,     0,     0,
     397,  1470,  1471,   399,     0,   400,   401,   402,   403,     0,
       0,     0,   404,   405,   406,   407,     0,   408,   409,     0,
     410,     0,   411,   412,   413,   145,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,  1472,  1473,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1177,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,     0,   438,     0,     0,
       0,   439,   440,  1474,     0,   441,     0,   442,   160,     0,
     161,   443,     0,   444,     0,   445,     0,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,  1844,   453,   454,
     455,   456,   457,     0,   166,  1845,     0,   458,   459,   460,
    1183,  1475,     0,  1476,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,     0,   175,   467,   176,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1477,   182,  1478,
       0,   482,   483,   484,   485,   486,   487,   488,     0,   489,
       0,   490,   491,   186,   492,     0,     0,  1479,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
    1846,   190,   191,     0,   498,   499,   500,     0,     0,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1480,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,     0,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,  1481,   534,   535,   209,   536,  1482,     0,   537,   538,
     539,   540,   541,   542,   543,   544,     0,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1483,  1484,     0,
     553,     0,   554,     0,   555,     0,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,  1485,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,   610,    79,    80,    81,   365,     0,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,   129,   391,   392,
     393,   131,  1468,   133,  1469,  1163,     0,   394,   395,     0,
     396,     0,     0,   397,  1470,  1471,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,   145,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1472,  1473,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1177,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1474,     0,   441,     0,
     442,   160,     0,   161,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,   165,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,   166,     0,     0,
     458,   459,   460,  1183,  1475,     0,  1476,     0,     0,   171,
     172,   461,   173,   462,   463,   464,   465,   466,     0,     0,
     175,   467,   176,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1477,   182,  1478,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,   186,   492,     0,     0,
    1479,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,     0,   190,   191,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1480,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   201,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1481,   534,   535,   209,   536,  1482,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1483,  1484,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1485,   568,   224,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,     0,
      83,    84,   597,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,   598,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,   599,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,    49,     0,   226,   576,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,  1355,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,  2189,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,  2190,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,   740,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,  2191,
     548,  2192,   550,  2193,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
     576,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
     552,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,     0,   226,   576,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,   952,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,     0,   226,   576,    79,    80,    81,
     365,     0,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,   599,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,     0,   226,   576,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
    1716,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,    79,    80,    81,   365,     0,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,     0,   226,   576,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,   779,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   780,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,   576,    79,
      80,    81,   365,     0,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   811,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   576,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   853,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,    79,    80,    81,   365,     0,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   576,   610,    79,
      80,    81,   365,     0,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   611,    99,   100,   101,   368,   612,     0,   103,
     104,   105,   106,   613,   614,     0,   108,   109,   110,     0,
     111,   615,   616,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,  1468,     0,
    1469,  1163,     0,   394,   395,     0,   396,     0,     0,   397,
    1470,  1471,   399,     0,   400,   401,   402,   403,     0,     0,
       0,   404,   405,   406,   407,     0,   408,   409,     0,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,  1472,  1473,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1177,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,     0,   438,     0,     0,     0,
     439,   440,  1474,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,     0,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,  1844,   453,   454,   455,
     456,   457,     0,     0,  1845,     0,   458,   459,   460,  1183,
    1475,     0,  1476,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,     0,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1477,     0,  1478,     0,
     482,   483,   484,   485,   486,   487,   488,     0,   489,     0,
     490,   491,     0,   492,     0,     0,  1479,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,  1846,
       0,     0,     0,   498,   499,   500,     0,     0,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1480,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,     0,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
    1481,   534,   535,     0,   536,  1482,     0,   537,   538,   539,
     540,   541,   542,   543,   544,     0,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1483,  1484,     0,   553,
       0,   554,     0,   555,     0,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,  1485,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   610,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,  1468,     0,  1469,  1163,     0,   394,   395,     0,   396,
       0,     0,   397,  1470,  1471,   399,     0,   400,   401,   402,
     403,     0,     0,     0,   404,   405,   406,   407,     0,   408,
     409,     0,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,  1472,
    1473,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1177,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,     0,   438,
       0,     0,     0,   439,   440,  1474,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,     0,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,     0,     0,   458,
     459,   460,  1183,  1475,     0,  1476,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,     0,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1477,
       0,  1478,     0,   482,   483,   484,   485,   486,   487,   488,
    1871,   489,     0,   490,   491,     0,   492,     0,     0,  1479,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,     0,     0,     0,     0,   498,   499,   500,     0,
       0,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1480,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,     0,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,  1481,   534,   535,     0,   536,  1482,     0,
     537,   538,   539,   540,   541,   542,   543,   544,     0,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1483,
    1484,     0,   553,     0,   554,     0,   555,     0,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,  1485,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   610,    79,    80,    81,   365,     0,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,     0,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,  1468,     0,  1469,  1163,     0,   394,
     395,     0,   396,     0,     0,   397,  1470,  1471,   399,     0,
     400,   401,   402,   403,     0,     0,     0,   404,   405,   406,
     407,     0,   408,   409,     0,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,  1472,  1473,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1177,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,     0,   438,     0,     0,     0,   439,   440,  1474,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,     0,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
       0,     0,   458,   459,   460,  1183,  1475,     0,  1476,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,     0,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1477,     0,  1478,     0,   482,   483,   484,   485,
     486,   487,   488,  2684,   489,     0,   490,   491,     0,   492,
       0,     0,  1479,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,     0,     0,     0,     0,   498,
     499,   500,     0,     0,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1480,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,     0,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,  1481,   534,   535,     0,
     536,  1482,     0,   537,   538,   539,   540,   541,   542,   543,
     544,     0,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1483,  1484,     0,   553,     0,   554,     0,   555,
       0,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,  1485,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   610,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   611,    99,   100,   101,   368,   612,     0,   103,   104,
     105,   106,   613,   614,     0,   108,   109,   110,     0,   111,
     615,   616,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,  1468,     0,  1469,
    1163,     0,   394,   395,     0,   396,     0,     0,   397,  1470,
    1471,   399,     0,   400,   401,   402,   403,     0,     0,     0,
     404,   405,   406,   407,     0,   408,   409,     0,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,  1472,  1473,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,  1177,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,     0,   438,     0,     0,     0,   439,
     440,  1474,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,     0,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,     0,     0,   458,   459,   460,  1183,  1475,
       0,  1476,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,     0,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,  1477,     0,  1478,     0,   482,
     483,   484,   485,   486,   487,   488,     0,   489,     0,   490,
     491,     0,   492,  1838,     0,  1479,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,     0,     0,
       0,     0,   498,   499,   500,     0,     0,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,  1480,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,     0,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,  1481,
     534,   535,     0,   536,  1482,     0,   537,   538,   539,   540,
     541,   542,   543,   544,     0,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,  1483,  1484,     0,   553,     0,
     554,     0,   555,     0,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,  1485,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
     610,    79,    80,    81,   365,     0,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
       0,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1468,     0,  1469,  1163,     0,   394,   395,     0,   396,     0,
       0,   397,  1470,  1471,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1472,  1473,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1177,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1474,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1183,  1475,     0,  1476,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1477,     0,
    1478,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,     0,     0,  1479,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1480,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1481,   534,   535,     0,   536,  1482,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1483,  1484,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1485,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,   610,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   611,    99,   100,
     101,   368,   612,     0,   103,   104,   105,   106,   613,   614,
       0,   108,   109,   110,     0,   111,   615,   616,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,  1468,     0,  1469,  1163,     0,   394,   395,
       0,   396,     0,     0,   397,  1470,  1471,   399,     0,   400,
     401,   402,   403,     0,     0,     0,   404,   405,   406,   407,
       0,   408,   409,     0,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,  1472,  1473,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1177,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
       0,   438,     0,     0,     0,   439,   440,  1474,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
       0,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,     0,
       0,   458,   459,   460,  1183,  1475,     0,  1476,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
       0,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1477,     0,  1478,     0,   482,   483,   484,   485,   486,
     487,   488,     0,   489,     0,   490,   491,     0,   492,     0,
       0,  1479,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,     0,     0,     0,     0,   498,   499,
     500,     0,     0,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1480,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,     0,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,     0,   534,   535,     0,   536,
    1482,     0,   537,   538,   539,   540,   541,   542,   543,   544,
       0,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1483,  1484,     0,   553,     0,   554,     0,   555,     0,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,  1485,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   378,   379,
     380,   381,   382,   383,   384,   385,   617,   386,   387,   618,
     619,   620,   621,   622,   623,   624,   388,   389,   625,   390,
     129,   391,   392,   393,   131,   132,   133,   134,     0,   626,
     394,   395,     0,   396,   627,   628,   397,     0,   135,   399,
     630,   400,   401,   402,   403,   139,   631,   632,   404,   405,
     406,   407,   633,   408,   409,   142,   410,   634,   411,   412,
     413,   145,   414,   635,   636,   637,   638,   639,   415,   416,
     417,     0,   419,   148,   149,   420,   640,   421,   641,   422,
       0,   423,   424,   425,   642,   426,   643,   644,   427,   428,
     429,   430,   645,   431,   432,   433,   646,   434,   647,   435,
     436,   437,   155,   438,     0,   157,   648,   439,   440,   159,
     649,   441,   650,   442,   160,   651,   161,   443,     0,   444,
     652,   445,   164,   653,   446,   654,   447,   448,     0,   165,
     450,   451,   452,   655,   453,   454,   455,   456,   457,   656,
     166,   167,     0,   458,   459,   460,     0,   169,   659,   170,
     660,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,   661,   174,   175,   467,   176,   662,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,     0,   477,   478,
       0,   480,   481,   181,   182,   183,   663,   482,   483,   484,
     485,   486,   487,   488,   184,   489,   664,   490,   491,   186,
     492,   665,   187,   188,   493,   494,   666,   667,   495,   668,
     669,   670,   496,   497,   671,   672,   189,   190,   191,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,   673,
     504,   505,   506,   507,   508,   509,   196,   510,   674,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,   203,   524,   525,   526,   527,   528,     0,
       0,   675,   530,   531,   532,   676,   533,   207,   534,   535,
     209,   536,   210,   677,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,   678,   546,   547,   679,   548,   549,
     550,   551,   680,   213,   214,     0,   553,   682,   554,   215,
     555,   216,   683,   556,   557,   558,   559,   560,     0,   685,
     561,   562,   563,   564,   686,   687,   565,   566,     0,   567,
     223,   568,   224,   569,     0,   688,   689,   570,   571,   572,
     573,     0,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,   129,   391,   392,   393,   131,   132,   133,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,   145,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,   160,     0,   161,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,   165,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,   166,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,     0,   174,   175,   467,   176,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,   182,   183,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,   186,   492,     0,   187,   188,   493,   494,     0,     0,
     495,   740,     0,     0,   496,   497,     0,     0,   189,   190,
     191,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,   209,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,   224,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,  1822,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,  1823,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,  1824,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,  2410,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,  1825,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,  1826,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,   835,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,   836,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,   868,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,   837,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   838,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,   835,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,   836,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,   837,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,   838,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,   126,
     127,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,   740,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,   740,     0,   900,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,  1572,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,  1573,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,  1574,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
     739,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,   740,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,  1575,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,  1576,  1577,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,   836,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,   837,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   838,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,   740,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,   820,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,   821,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,  2329,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,  2330,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
    2334,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,  2335,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,   862,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     863,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   864,
     214,     0,   553,     0,   865,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,   889,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   890,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   891,   214,     0,   553,     0,   892,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,  1265,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,  1276,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,  1277,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   882,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   883,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,  1268,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   885,   214,     0,   553,     0,
     886,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,  2444,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
    2458,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,  2479,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,  2746,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,  2748,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
    2750,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,  3216,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
       0,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   784,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,     0,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   860,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,     0,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   882,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   883,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,  1268,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   885,   214,     0,
     553,     0,   886,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,  1368,    80,    81,   365,     0,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,     0,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,  1601,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,     0,
       0,    83,    84,     0,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
       0,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,     0,     0,   131,   132,   133,   134,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,   157,     0,     0,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,   165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,   171,   172,     0,   173,     0,     0,     0,     0,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,   183,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,     0,     0,   186,
       0,     0,   187,   188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,   192,
       0,     0,     0,     0,   193,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   207,     0,     0,
     209,     0,   210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   213,   214,     0,     0,     0,     0,   215,
       0,   216,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,     0,     0,     0,     0,     0,
      79,    80,    81,     0,   225,    83,    84,   226,    85,    86,
      87,     0,     0,     0,    90,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,   107,     0,   108,   109,   110,
       0,   111,   112,   113,   114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   129,     0,     0,     0,   131,   132,
     133,   134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   135,     0,     0,     0,     0,     0,     0,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,   171,   172,     0,   173,
       0,     0,     0,     0,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,   183,
       0,     0,     0,     0,     0,     0,     0,     0,   184,     0,
       0,     0,     0,   186,     0,     0,   187,   188,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,   190,   191,   192,     0,     0,     0,     0,   193,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   207,     0,     0,   209,     0,   210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   213,   214,     0,
       0,     0,     0,   215,     0,   216,     0,     0,     0,     0,
       0,     0,   219,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,   224,    79,    80,    81,
       0,     0,    83,    84,     0,    85,    86,    87,   225,     0,
       0,   226,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   142,     0,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   148,   149,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,   164,     0,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,   171,   172,     0,   173,     0,     0,     0,
       0,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,   183,     0,     0,     0,
       0,     0,     0,     0,     0,   184,     0,     0,     0,     0,
     186,     0,     0,   187,   188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   189,   190,   191,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   207,     0,
       0,   209,     0,   210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   213,   214,     0,     0,     0,     0,
     215,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,     0,     0,   226
};

static const short yycheck[] =
{
       2,   138,   154,    74,   726,   227,   849,    74,  1104,   826,
      90,   718,  1413,   217,   147,   722,   144,   719,  1543,   721,
    1078,   154,    77,   741,    90,  1038,   710,  1085,  1218,    90,
    1068,   733,   112,  1573,    74,    74,    74,    77,  1155,   761,
     177,   972,  1497,   195,   751,   200,   112,  1354,   185,    82,
      90,   112,   895,    90,  1204,   757,   720,   721,   221,  1499,
     886,  1276,   195,  1949,  1102,    90,    74,    74,   770,   991,
      74,  1536,   112,   779,   796,   112,  1708,   794,   938,  2033,
     787,   798,  2018,   220,   128,  2266,   793,   112,  1604,   806,
     815,   755,   817,  2077,   819,   972,  1513,  2198,  1513,  1399,
     825,  1771,   146,  2399,  2023,  2024,  1513,   809,  1513,  2434,
     723,  2405,  1850,  1851,   727,  1513,  1025,  2218,  1513,   814,
     881,   734,  1743,   884,  1033,  1120,  1540,   791,   834,  1376,
    1538,    25,  1546,  1005,   947,    26,  1806,  1120,    50,   219,
    1810,    42,  1166,  1167,    42,   178,   759,  1130,  1131,   878,
     763,    74,   967,   219,    77,    77,   158,   228,   219,   772,
     227,   228,   972,   880,    94,  1074,  1190,    90,   955,   956,
     113,  1080,    93,   879,   118,   137,   118,  1086,   180,   219,
       2,    77,   219,  2556,  1972,  1973,  1974,  1975,    77,   112,
      93,   118,  1176,   130,   219,   151,   201,    74,   712,   690,
      77,    98,    86,   113,   156,    34,    98,  1662,    92,   156,
      99,   161,    93,    90,   195,   230,  2816,    86,  2818,   170,
     228,   228,   179,    29,   228,    29,     2,    93,    43,    82,
      45,   364,   161,    77,   230,   112,  1637,   124,   200,   199,
       8,   287,   137,   285,   213,  3115,    14,    15,    16,   195,
      93,   127,   208,    77,   179,   300,  1239,   156,    26,    27,
      28,   172,    30,    31,    32,   197,  3144,  1280,    36,    37,
      38,   190,   285,   991,    86,    99,    77,   346,   137,   203,
      92,   321,   321,   321,    86,    77,   234,   315,  1958,   249,
      92,    94,    86,   375,   300,   224,   219,   151,   156,   124,
     160,   257,    77,   358,   260,   200,    82,    99,  1010,   158,
    1525,    80,   195,    89,     0,   232,   141,   170,   358,  1241,
     348,   361,   361,   361,    99,  1043,   342,   246,   153,   159,
    2380,  3214,  1054,   300,  1484,  1373,   106,   230,  1045,   333,
     346,   200,   219,   437,  1051,   161,    18,   441,  1279,   278,
      93,   367,   128,   112,   208,   322,   156,  1041,   155,  1455,
     292,   230,   356,   432,   446,   393,  3249,   315,   287,   213,
     146,   231,   166,   290,  1412,  1077,  3254,   202,   148,   113,
     210,    86,   281,   339,   327,    77,  1093,   403,   232,  1091,
     230,   348,   163,   222,   341,   346,   441,   439,   321,   395,
     446,   288,   178,   257,  2358,  1107,   260,   331,   224,   369,
     179,   371,   341,  1603,  1604,  1855,  1454,   327,   276,  1944,
     226,  1138,   226,   348,  1614,  1615,   439,   276,   360,   375,
    3030,   446,  1445,  1529,   385,   358,  1626,  1627,   361,  1156,
     232,   446,  3312,   393,   321,  2066,  1470,  1471,   292,   386,
    1640,  1641,   399,   223,  1478,   411,   122,   232,   233,   401,
     219,   276,   358,   415,   393,   446,   418,   364,  1506,   353,
    2356,  2357,   364,   415,   965,   989,   418,   446,   440,  2365,
     442,   358,  2855,   439,   361,   339,  2667,  2668,   415,  1473,
     442,   418,   439,   346,   405,   439,  1309,   439,   268,   375,
    1538,   395,   395,   446,   279,  1543,   418,  1697,   552,   439,
     439,  2447,   439,   435,   415,  2451,   437,   418,  1331,  2455,
     418,  2142,   423,  1241,   425,   230,  1398,   418,  1338,  1346,
     431,  1939,  1261,  1262,   437,  1350,   446,   305,    77,   433,
     232,   353,  2280,  2213,  2282,   440,   435,   442,  1335,   418,
    1850,   353,    91,  2018,   423,    77,   437,   411,  1553,   440,
     441,   724,   431,   446,   333,   446,   729,   730,   338,  1552,
    1817,   437,   416,   442,   440,   441,  2208,   393,  1561,   348,
     446,   378,   426,   427,   428,   439,   430,   431,   432,   433,
     434,   435,   729,   327,   437,  2216,  1456,   440,   441,  1294,
     292,  2389,   442,   446,   407,   408,  1630,  1631,   432,   433,
     434,   435,   409,   750,    82,   415,   120,   385,   418,  1380,
     281,  2035,  2036,   786,   395,  1663,   131,   230,   780,   113,
     710,   432,   433,   434,   435,  2373,    74,   197,   430,   431,
     432,   433,   434,   435,   710,    87,   779,   780,   337,   710,
     290,   308,   156,  1414,  1372,   430,   431,   432,   433,   434,
     435,   230,   276,   158,   150,  2079,   230,    77,   156,   174,
     710,   333,   120,   710,   714,   714,   714,  1438,   811,    77,
    2730,  2731,  2732,  2733,  2734,   710,  2982,  3012,   690,   149,
     156,  1413,  1376,   232,   437,  2433,  2990,   440,   441,   156,
     314,   834,   170,   446,   234,    29,   843,   257,   120,  2379,
     232,    12,   849,   418,   747,   127,    40,   291,   423,   408,
     132,   378,   859,   104,   416,   161,   431,   369,   178,   371,
     216,   393,  2197,  1576,   426,   427,   428,   442,   430,   431,
     432,   433,   434,   435,   192,   151,   879,   252,   440,    50,
     416,   308,   409,   292,   415,  1457,  2211,   418,   895,  1461,
     426,   427,   428,   900,   430,   431,   432,   433,   434,   435,
     120,  2172,   276,   132,   911,   335,   552,   281,   228,   196,
     192,  1465,   132,   225,   268,   315,   281,   710,   224,   339,
     228,   714,  2932,   117,   106,   300,   256,   156,   258,  1616,
    1617,  1618,   208,   155,   195,   309,   156,  1624,   158,   161,
     276,  1628,  1629,   815,   318,   817,   122,   819,  1635,   276,
     853,   378,   232,   825,   826,  2711,  2712,  1644,   209,  1646,
     896,   161,   213,   710,   232,  2789,   410,   714,   871,   442,
     170,  2981,  1659,   327,  1661,   295,    18,  1549,   112,   882,
     883,   257,   409,  2267,   322,  1572,   896,  1574,  1575,   230,
    1577,   309,   346,   368,   245,   370,  1573,  1384,   690,   219,
    2806,   337,   224,   442,  1805,  2811,  2664,   416,   442,  2815,
     366,   367,   292,  2802,   301,   389,   317,   426,   427,   428,
     341,   430,   431,   432,   433,   434,   435,   309,   122,  1512,
     357,  1939,   226,   360,  1421,   341,  1944,  1044,   430,   431,
     432,   433,   434,   435,   690,  1637,   446,   276,  2332,  2333,
     184,  1959,   955,   956,   300,   208,   276,   415,  1805,  1789,
     418,   281,   746,   339,  3230,   423,   938,  2477,   388,   418,
     160,   389,   300,   120,   423,  2135,   322,   211,   166,  3089,
    1087,  1088,  1089,   100,   161,   132,   375,   393,  2054,   309,
     774,  1041,   964,   965,   322,   967,  2156,   367,   318,   350,
     972,   747,   119,   896,   257,  1041,   306,   389,  1696,  2279,
    1041,  1665,  2447,  2400,   106,  2400,  2451,   158,   439,   341,
    2455,  2507,  2030,  2400,   159,  2400,  1218,  1906,  1907,   190,
    1137,  1041,  2400,    77,  1041,  2400,   416,   426,   439,  2199,
    2200,   231,  1145,   375,   341,   192,  1041,   224,  1155,   896,
     430,   431,   432,   433,   434,   435,   148,   180,  1745,   159,
      89,    90,   430,   431,   432,   433,   434,   435,   106,   389,
    1900,   393,  3281,  1903,  1904,   210,   166,   246,   219,  2463,
    1121,  2465,  2466,  3234,  1121,   246,   339,  3041,   276,   378,
    2946,   214,  2948,  2949,   328,  2735,   186,   285,   186,  1140,
     277,   278,   399,  1140,   142,  1892,   340,   853,   325,   441,
     210,  1114,  3321,   445,  3265,   112,  2500,   439,   287,   300,
     354,  3027,   407,  1160,   162,   871,   287,   361,  1804,   346,
     257,   223,   878,   260,  2026,   276,   882,   883,  3347,   177,
     416,  1178,   439,  1121,  1121,   151,   938,  1121,  1041,  3220,
     426,   427,   428,   191,   430,   431,   432,   433,   434,   435,
     434,   446,   309,  1817,   341,   346,   407,   441,   206,   163,
     404,  1208,   964,   965,  1961,   967,   268,  1864,   300,  1966,
     972,  1218,  1289,   342,  3255,  1819,   276,   184,   232,  1876,
     407,   281,   378,   281,  1041,   285,  2533,   285,  3122,   178,
     322,   322,   208,  1890,   325,   446,   200,  1894,   367,   955,
     956,   190,   339,  1439,   211,   196,   393,  1220,   964,   965,
    2557,   967,   416,   409,   346,   346,   972,   442,  1231,   199,
     827,  1814,   426,   427,   428,  1818,   430,   431,   432,   433,
     434,   435,   389,   281,   403,  3101,   338,  2432,   292,   228,
     288,   257,  1835,   850,   260,   407,   408,   402,   407,   408,
     315,    77,   439,  1300,  1301,   418,  1303,   246,   323,   444,
     423,   446,   425,  1276,  1946,  1947,   314,  1313,   431,   249,
    1863,  1507,  1865,    99,   442,  1511,   407,   439,   343,  2297,
     439,  2299,   382,   300,   382,  1521,  1001,   417,   418,  2086,
     390,  1434,   390,  1313,  1314,  1315,  1313,  1279,   287,  1281,
    1282,  2736,  2914,   199,  1897,   322,   295,  2325,  1313,  1333,
    1025,   369,   208,   371,    57,   437,  1376,     5,  1033,   441,
     327,   328,  1335,   339,   446,  1371,   117,   118,  2026,   346,
    1376,  1924,    75,   340,  1927,  1376,  1929,  2355,   300,   442,
      46,    29,  1324,   446,  1364,  1364,  1364,   354,    77,   358,
     359,  1371,    40,   300,   361,   438,  1376,  2043,  1114,  1376,
     322,  2806,   416,   446,  1346,  2652,  2811,  2787,  1350,    84,
    2815,  1376,  1354,   427,   428,   322,   430,   431,   432,   433,
     434,   435,  1584,   196,   346,   426,   438,   102,   127,   369,
    2408,   371,   300,   132,   446,   411,   437,   404,  2568,   388,
     441,  2419,  2499,  2209,     7,  1465,   415,   220,    11,   418,
    1313,  1314,  1315,  2210,   322,   415,   195,   325,   418,  1465,
      23,    24,   235,   403,  1465,   443,  2820,  1544,  1545,   117,
     243,  2561,  2562,   416,   213,   407,   408,   132,   346,   439,
     111,    44,   418,   415,    47,  1465,   418,   423,  1465,  2884,
     437,   440,   439,   447,   441,   431,  1313,  1314,  1315,  1576,
    1465,  1364,  2373,  1598,  1220,   286,  2059,   439,  1371,   290,
    2172,  1588,   141,  1376,  1456,  1231,  2316,  1279,   149,  1281,
    1282,   169,  2322,  2323,  2077,   415,  3183,  3184,   418,  1536,
    3187,   440,  3189,   418,   401,  2513,   440,   446,  2134,   407,
    2136,  2137,   446,   232,   199,  1261,  1262,  1364,   415,   439,
     415,   418,  1525,   418,  1371,   407,   408,   330,  2536,  1376,
    1276,   216,  1324,  1279,  2226,  1281,  1282,   196,   437,    82,
     439,  2228,   439,   415,   439,    88,   418,  1584,   226,   415,
    2921,   440,   418,   415,   215,  2563,   418,   446,  1350,    82,
     414,   220,  1354,   417,   249,    88,   415,   439,   415,   418,
     443,   418,  1465,   292,   167,  3010,   235,   439,  2586,   442,
     395,   124,  1422,   446,   243,  1692,  1426,  1333,  1428,  1335,
     439,  2378,  3027,  2380,   137,   256,  1568,   258,   432,   433,
     434,   124,  3112,   156,  1350,   264,  2301,   268,  1354,   294,
     407,   408,  2246,   440,   137,  1665,  2303,  2304,  1465,   446,
    1623,   442,   165,  1300,  1301,   415,  1303,   170,   418,  1665,
     173,   423,  1669,   425,  1665,   415,   415,  1744,   418,   418,
    1300,  1301,   165,  1303,  1616,  1617,  1618,   170,  2631,   439,
     173,   444,  1624,   446,  3079,  1665,  1628,  1629,  1665,   439,
     439,   407,   408,  1635,  1456,   326,    21,   407,   408,   442,
    1665,   330,  1644,   446,  1646,   415,   229,   415,   418,   415,
     418,  2373,   418,    77,   369,   440,   371,  1659,   226,  1661,
    2698,   446,   440,    39,   355,   380,   249,   416,   446,   439,
     290,  1804,  2285,   439,   389,    99,   290,   426,   427,   428,
     104,   430,   431,   432,   433,   434,   435,   440,  2372,  1722,
     440,   440,   439,   446,   415,   440,   446,   418,  1738,  1738,
    1738,   446,   423,  2520,   425,   442,  1708,    77,   440,   446,
     431,   324,   415,  2530,   446,   418,   369,  1772,   371,  1774,
     423,    91,   425,   440,   413,   407,   408,  2765,   431,   446,
     440,   134,  1772,   440,  1774,   440,   446,  1817,  2796,   446,
     380,   446,  1665,  2461,  1147,  1148,  3160,   440,   440,  1525,
    3215,  1817,   415,   446,   446,   418,  1817,   430,   431,   432,
     433,   434,  1795,   415,   312,    82,   418,   440,   440,   322,
    2477,   216,    89,   346,   446,    92,   440,  1817,    77,   369,
    1817,   371,   446,   238,   440,   102,   230,  1789,  1665,   213,
     446,   440,  1817,   346,   290,   440,  2018,   446,   440,   311,
      77,   446,   439,  1805,   446,  1807,  2715,  1809,   232,   233,
    3335,   128,   440,  2515,    91,  1738,   195,   913,   446,   915,
     137,   138,    99,   412,   440,    77,   442,   104,   100,   146,
     147,   414,   415,   150,   417,   418,   440,   154,   442,    91,
     423,   158,   425,  2452,  1981,  2454,   163,  1623,   431,  1772,
     234,  1774,    94,  2891,   440,   279,  1984,   441,   440,   440,
     446,  1738,   232,   180,   446,   446,  2479,  2004,   292,   440,
     112,   440,   293,   440,  2011,   446,   290,   446,   195,   446,
    3070,   198,   199,   200,  2229,  2230,   440,   204,  2501,   206,
    1892,   208,   446,   375,  1817,  1772,   290,  1774,  1900,  3300,
     100,  1903,  1904,   430,   431,   432,   433,   434,  2725,   412,
    2043,   438,   440,  2730,  2731,  2732,  2733,  2734,   446,   440,
    1953,  2738,   292,   440,   440,   446,    94,  2231,  2232,   446,
     446,   440,   209,   232,  2156,   440,   213,   446,   957,   958,
    1817,   446,   184,   412,   112,   234,  1722,   346,   432,   194,
     440,  2018,   440,   442,    86,   232,   233,   110,   432,  1961,
     137,   226,   443,   443,  1966,   375,   375,  1789,   245,   211,
     375,   375,   176,   375,    94,   110,   395,  2010,   226,   151,
     232,   447,   232,  1805,   375,  1807,   439,  1809,  2192,  2193,
     439,   439,   416,   292,  3032,   441,   238,   439,   439,   276,
     300,   178,   279,   439,   322,   439,   430,   431,   432,   433,
     434,   435,   441,   190,   346,   292,   184,   294,   195,  1795,
    3058,   290,   442,   200,    94,   244,   203,   439,   205,  1805,
     284,  1807,   238,  1809,   407,   120,   208,  1068,   439,   407,
     292,    94,   112,   211,   407,   100,   416,   364,   100,   300,
     238,   228,   395,   439,  2191,   290,   426,   427,   428,   446,
     430,   431,   432,   433,   434,   435,   290,   439,   191,   246,
     238,  1102,   190,   350,   244,   439,   305,   439,  1900,   439,
     439,  1903,  1904,   439,  2086,   257,   328,   439,   260,  2156,
     439,   439,   439,   439,   439,   439,    94,   439,   340,   439,
     439,   439,  2169,   439,   439,   439,   439,   244,   439,   446,
     287,  2928,   354,  1889,   184,   232,   439,   416,   295,   361,
     432,  2188,   190,   226,  2941,   339,   260,   426,   427,   428,
    2197,   430,   431,   432,   433,   434,   435,   446,   155,   416,
      42,   211,    18,   441,   446,   394,   439,   439,   439,   426,
     427,   428,   375,   430,   431,   432,   433,   434,   435,   141,
     328,   438,   404,   375,   416,   407,   441,   339,   238,  1945,
     447,   290,   340,  1949,   426,   427,   428,  1953,   430,   431,
     432,   433,   434,   435,   375,  1961,   354,   281,   375,   375,
     367,   340,   375,   361,   375,   394,   375,   368,   395,  2921,
     446,   375,   375,   127,   337,   380,  2208,   290,  2210,   375,
    2212,   388,   376,   380,   196,   446,  2829,   375,  1994,   375,
     375,  3317,   337,   375,   439,   290,   439,   232,   288,   406,
     439,   439,   401,    94,  2010,   552,   404,   439,   220,   411,
    3278,   439,   414,   415,    84,   417,   418,   156,  1279,   403,
     252,   190,  2119,   235,   439,  2122,   290,   439,   328,    94,
     437,   243,   338,   440,   441,   442,   406,  2404,    94,   395,
     340,    18,   399,  2410,   375,   426,   280,   439,   595,   596,
     195,   446,   264,   446,   354,   373,  2153,  2154,  2440,  3132,
      77,   361,  2372,   439,   405,   373,   446,  3335,   346,  2301,
     373,   439,   195,  3020,   375,   446,  2372,  2440,   290,   439,
     426,  2372,  2925,  3030,  2316,   378,   440,   446,   228,   291,
    2322,  2323,  2935,   285,  2937,   446,   246,   437,   440,    39,
     131,   433,  2372,   440,   404,  2372,   236,   236,   281,   439,
     439,   281,  1373,   281,   290,   296,   375,  2372,   330,   375,
      77,   337,   246,   446,   440,   446,  2427,   302,   415,  2392,
    2427,   302,  2499,   322,    91,   392,   110,   367,  1399,  2440,
      94,  2373,   232,  2440,  2596,   232,  2378,   395,  2380,   315,
    2447,  1412,   232,   426,  2451,   375,   437,   375,  2455,  2391,
    2212,   246,   190,   426,  2598,  2599,  2600,  2601,  2431,  2432,
     290,    94,   719,   720,   721,  3112,   723,   294,   725,   726,
     727,   728,   204,   395,   731,   732,   733,   734,  2489,   207,
     190,   207,  2489,  1454,   446,   440,   440,    12,  3041,    83,
     446,   413,   201,   446,  3151,   752,  2212,  3139,   755,   259,
     757,   290,   759,   110,   440,   440,   763,   764,   765,  2372,
    1481,   768,   195,   770,   446,   772,   440,   440,   412,  3276,
    3277,   440,   779,   780,   440,   440,  2603,  2604,   412,   440,
     440,   788,   440,   440,   791,  1506,   440,   794,   412,   440,
     440,   798,   799,   440,   195,   440,   803,   804,   440,   806,
     439,   375,   809,   426,  2316,  2372,    35,   439,   446,   222,
    2322,  2323,   281,   440,   246,   232,   300,  1538,   440,   439,
     827,   828,  1543,   442,  3216,   442,   439,   834,  2520,   375,
     408,   375,   440,   440,   232,   232,  2302,   440,  2530,  2596,
     437,   260,  2308,   290,  2310,   440,   439,   385,   855,   324,
     857,  2574,   440,   860,   375,   446,   235,   288,   288,   395,
     439,  2373,   290,   235,   440,   440,   439,   426,   297,   293,
     179,   878,   879,   880,   881,   292,   883,   884,   446,   179,
     437,   176,   440,   195,    77,   190,   440,   440,  3300,   203,
    2356,  2357,   440,   118,   446,   426,   439,   426,   440,  2365,
     222,   416,  3299,   440,   439,   375,   385,  2373,   375,   375,
    2737,   337,   375,   375,  2380,   232,   440,   232,   163,   232,
     438,   395,   439,    94,   190,  2391,  2392,   294,   236,   218,
      94,    94,   439,  2760,   398,  3332,   439,   446,   235,   439,
     200,  2768,  1663,   439,   195,   440,   440,   440,   955,   956,
     440,   195,   959,   285,   439,   110,   292,   440,   205,   439,
    2652,   281,   281,   232,   158,  2431,  2432,   219,   395,   197,
     438,   197,   195,   980,   216,   395,   983,   181,   157,   986,
    2537,   171,   440,  2540,  2541,  2542,  2543,  2544,  2545,  2546,
    2547,  2548,  2549,   439,   237,   157,   195,   375,   439,   416,
     293,   190,   440,  1010,   439,    94,   255,   318,   281,   426,
     427,   428,   368,   430,   431,   432,   433,   434,   435,   313,
     288,  2782,   440,   288,    97,  2782,   290,  2719,   290,   190,
      94,  2588,  2589,  2725,   129,   368,   171,   290,  2730,  2731,
    2732,  2733,  2734,   281,   290,   439,  2738,   167,  1055,  2806,
     446,   333,  1059,   393,  2811,   161,  1063,   446,  2815,   181,
     334,    81,  1069,   334,   439,  2788,   440,   317,   228,  1282,
    1077,  1983,   313,  2212,  1923,  2326,  2903,  2904,  2905,  2906,
     416,  1868,  1911,  2774,  1091,  1092,  2975,  1094,  2777,  2695,
     426,   427,   428,  2263,   430,   431,   432,   433,   434,   435,
    1107,  2784,  3262,  3290,  3245,  3244,  3271,  3129,  2574,  3205,
    2779,  1969,  1522,  3005,  3347,  3321,  2959,  2958,  3302,  2372,
    1508,    77,  1129,  3348,   180,  1139,  3215,  2829,    85,  1850,
    1851,  1138,  1139,  2061,  2279,  1851,  1143,  1850,  2794,  3012,
    2652,  3191,  3311,    99,  3346,   894,  1153,  1744,   104,  1156,
    1976,  1158,   156,  2490,  2041,  1121,  2823,  1308,   115,  2223,
    2233,  1307,  1757,  1741,  2197,  2018,  2453,  3028,  2772,  1481,
     127,  2573,  2373,  2088,  2891,  2167,  2169,   134,  1693,  2918,
    3228,  2217,  3040,   962,  2833,  1092,  2652,  1798,  1348,    74,
    1795,   322,  2915,   150,  1315,   694,   990,  2754,  1770,  1145,
    2207,   958,  1805,  2049,  2913,  2050,  2824,  2719,  2635,  2825,
    1313,   168,  1260,   357,  2044,  1809,  1567,     2,  1939,    -1,
     964,    -1,  2914,  1944,    -1,  2986,    -1,    -1,    -1,  2986,
    2953,    -1,    -1,    -1,    -1,    -1,  2928,    -1,  1959,    -1,
     197,    -1,    -1,    -1,    -1,  2711,  2712,    -1,    -1,  2941,
      -1,    -1,    -1,   209,  1261,  1262,    -1,   213,    -1,   216,
      -1,    -1,    -1,    -1,  2730,  2731,  2732,  2733,  2734,  1276,
    3027,    -1,    -1,    -1,  1281,  1282,   232,   233,    -1,    -1,
    1639,    -1,   239,    -1,  1291,    -1,    -1,  3114,  3011,   245,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3132,    -1,    -1,    -1,  2030,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3147,    -1,  2788,   279,    -1,    -1,  1333,    -1,  1335,  2886,
    2887,    -1,    -1,    -1,    -1,   292,   292,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,    -1,
    3177,    89,    -1,    -1,    -1,   312,    -1,    -1,    -1,  1366,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1068,    -1,  1380,    -1,    -1,    -1,    -1,   335,    -1,
     337,    -1,  3074,    -1,    -1,   342,    -1,    -1,    -1,    -1,
     128,    -1,    -1,    -1,   350,    77,  3157,    -1,    -1,    -1,
    3157,    -1,  2914,    -1,    -1,  1102,  1413,  1414,   146,   147,
     367,  3323,    -1,    -1,  3137,    -1,   154,    99,    -1,    -1,
     158,    -1,   104,   380,    -1,    -1,    -1,    -1,   385,    -1,
      -1,  1438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     178,    -1,   180,    -1,    -1,    -1,   403,    -1,  2914,  2915,
    1457,    -1,    -1,    -1,  1461,    -1,    -1,   195,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     426,   427,   428,    -1,   430,   431,   432,   433,   434,   435,
    2946,    -1,  2948,  2949,    -1,    -1,    -1,  2953,    -1,    -1,
      -1,    -1,  3049,    -1,  3051,    77,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,  3060,    -1,  1512,    -1,  1514,  3231,    -1,
      -1,    -1,  3235,    -1,    -1,    -1,    -1,    99,  1525,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,   209,    -1,    -1,
      -1,   213,    -1,    -1,  1541,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1549,    -1,    -1,  3011,    -1,  1554,    -1,    -1,
     232,   233,    -1,    -1,  3311,    -1,    -1,    -1,  2279,  2280,
      -1,  2282,  3074,   245,    -1,  1572,  3323,  1574,  1575,    -1,
    1577,    -1,    85,    -1,    -1,    -1,  2297,  1584,  2299,    -1,
      -1,    -1,    -1,    -1,  3276,  3277,    -1,    -1,    -1,  3346,
      -1,  1598,    -1,    -1,  1601,   177,    -1,   279,    -1,    -1,
      -1,    -1,    -1,    -1,  2325,  3162,    -1,    -1,    -1,    -1,
     292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,   364,   209,    -1,    -1,
    1637,   213,    -1,    -1,  2355,  3101,    -1,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     232,   233,  2373,    -1,    -1,   168,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,   350,    -1,
      -1,  3137,    -1,    -1,    -1,    -1,  1373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   197,    -1,    -1,  2408,    -1,    -1,
     203,  1698,    -1,    -1,    -1,    -1,    -1,   279,  2419,    -1,
      -1,    -1,  1399,   216,    -1,    -1,    -1,    -1,    -1,    -1,
     292,    -1,  2433,    -1,    -1,  1412,    -1,    -1,    -1,    -1,
      -1,    -1,  1068,    -1,    -1,   238,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1740,   416,    -1,    -1,    -1,  1745,    -1,
      -1,    -1,    -1,    -1,    -1,   427,   428,    -1,   430,   431,
     432,   433,   434,   435,    -1,    -1,  1102,  1454,    -1,    -1,
    2119,    -1,    -1,  2122,    -1,  3231,  3232,    -1,   350,  3235,
    3236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   292,
      -1,    -1,    -1,    -1,  1481,    -1,    -1,    -1,  1795,    -1,
      -1,  1798,  2513,    -1,  2153,  2154,    -1,  1804,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1814,  1815,  1506,
      -1,  1818,  1819,    -1,   552,  2536,  1823,    -1,   331,    -1,
      -1,    -1,  1829,    -1,   337,    -1,    -1,  1834,  1835,   342,
      -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,
      -1,  1538,  2563,    -1,    -1,    -1,  1543,    -1,   430,   431,
     432,   433,   434,   435,   367,   368,  1863,  1864,  1865,  1866,
    1867,    -1,  1869,  1870,    -1,  2586,    -1,   380,    -1,  1876,
      -1,   609,   385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   394,    -1,  1890,    -1,    -1,    -1,  1894,    -1,    -1,
    1897,  1898,  1899,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1911,  1912,  1913,    -1,  1915,  1916,
    1917,  1918,  1919,  1920,  1921,    -1,    -1,  1924,  1925,    -1,
    1927,  1928,  1929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1946,
    1947,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1961,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1663,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2698,  1985,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2000,    -1,    -1,    -1,    -1,  2005,    -1,
    2007,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   747,
      -1,    -1,  2019,    -1,    -1,    -1,  2023,  2024,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2033,  1373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2043,    -1,    -1,    -1,
      -1,   779,   780,    -1,  2765,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2059,  1399,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1412,    -1,    -1,    -1,
    2077,    -1,    -1,   811,    -1,    -1,    -1,   815,    -1,   817,
      -1,   819,    -1,    -1,    -1,    -1,    -1,   825,   826,    -1,
      77,    -1,    -1,    -1,    -1,    -1,   834,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,  1454,    -1,
      -1,   137,    99,    -1,    -1,   853,    -1,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   871,    -1,  1481,    -1,  2144,    -1,    -1,
     878,   879,    -1,    -1,   882,   883,    -1,    -1,    -1,    -1,
      -1,    -1,   178,  1850,  1851,    -1,    -1,    -1,    -1,    -1,
    1506,    -1,    -1,    -1,   190,  2172,    -1,    -1,    -1,   195,
    2891,    -1,    -1,    -1,   200,    -1,    77,   203,  2537,   205,
      -1,  2540,  2541,  2542,  2543,  2544,  2545,  2546,  2547,  2548,
    2549,    -1,  1538,    -1,    -1,    -1,    -1,  1543,    99,    -1,
     938,    -1,   228,   104,    -1,  2212,    -1,    -1,    -1,    -1,
    2217,    77,    -1,    -1,    -1,    -1,    -1,   955,   956,    -1,
     246,  2228,   209,    -1,    -1,    91,   213,    -1,    -1,  2588,
    2589,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,  2246,
      -1,    -1,  1939,    -1,    -1,   232,   233,  1944,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   245,  2266,
      -1,   287,  1959,    -1,    77,    -1,    -1,    -1,    -1,   295,
      -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,  2285,  2286,
    2287,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   276,
      -1,   104,   279,    -1,    -1,    -1,  2303,  2304,    -1,    77,
      -1,    -1,    -1,    -1,    -1,   292,    -1,   294,   209,    -1,
      -1,  3032,   213,    91,    -1,    -1,    -1,  1663,    -1,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,
      -1,   232,   233,  2030,    -1,    -1,    -1,  3058,    -1,    -1,
      -1,   367,    -1,   209,   245,    -1,    -1,   213,    -1,    -1,
      -1,  2358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   388,   350,   177,    -1,   232,   233,    -1,    -1,
      -1,    -1,    -1,  2380,    -1,    -1,  1114,    -1,   279,   245,
     406,    -1,    -1,    -1,    -1,    -1,  2393,  2394,  2395,    -1,
      -1,   292,    -1,    -1,  1132,  2754,   209,  1135,    -1,    -1,
     213,    -1,    -1,    -1,    -1,    -1,    -1,  1145,    -1,    -1,
     276,   437,    -1,   279,   440,   441,   442,    -1,    -1,   232,
     233,  2428,    -1,    -1,    -1,  2432,   292,    -1,   294,   416,
      -1,   209,   245,  2440,  2441,   213,    -1,  2444,    -1,   426,
     427,   428,    -1,   430,   431,   432,   433,   434,   435,   350,
      -1,  2458,    -1,    -1,   232,   233,    -1,    -1,    -1,   446,
      -1,    -1,    -1,    -1,    -1,    -1,   279,   245,    -1,    -1,
      -1,    -1,  2479,    -1,    -1,    -1,    -1,    -1,    -1,   292,
      -1,    -1,  1220,  2490,   350,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1231,  2501,    -1,    -1,    -1,   276,    -1,
      -1,   279,    -1,    -1,  1850,  1851,    -1,    -1,  2515,    -1,
      -1,    -1,    -1,    -1,   292,   416,   294,    -1,    -1,  1257,
      -1,    -1,    -1,  1261,  1262,    -1,    -1,  2886,  2887,   430,
     431,   432,   433,   434,   435,    -1,    -1,   350,  1276,    -1,
      -1,  1279,    -1,  1281,  1282,    -1,    -1,    -1,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,  3278,    -1,    -1,
     426,   427,   428,    -1,   430,   431,   432,   433,   434,   435,
      -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     446,    -1,  2279,  2280,    -1,  2282,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1939,    -1,  1333,    -1,  1335,  1944,    -1,
    2297,    -1,  2299,   416,    -1,    -1,    -1,    -1,  1346,    -1,
      -1,    -1,    -1,  1959,  3335,    -1,    -1,   430,   431,   432,
     433,   434,   435,    -1,    -1,    -1,    -1,    -1,  2325,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,   427,
     428,    -1,   430,   431,   432,   433,   434,   435,  2355,    -1,
    2667,  2668,   440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2030,    77,    -1,    -1,    -1,    -1,
    3049,    -1,  3051,    -1,    -1,  2702,  2703,    -1,    -1,    -1,
    3059,  3060,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,  2408,   104,    -1,    -1,    -1,    -1,    -1,  1456,    -1,
      -1,    -1,  2419,  2730,  2731,  2732,  2733,  2734,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2433,    -1,    74,    -1,
      -1,    77,    -1,    -1,    -1,    -1,  2753,    -1,    -1,    -1,
      -1,    -1,    -1,    89,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2772,    -1,  2774,    -1,    -1,
    2777,    -1,  2779,    -1,    -1,    -1,   112,  2784,    -1,    -1,
      -1,    -1,  2789,    -1,    -1,   177,    -1,  1525,    -1,    -1,
      -1,    -1,   128,    -1,    -1,  2802,    -1,  2804,    -1,    -1,
      -1,    -1,    -1,  3162,    -1,    -1,    -1,    -1,    -1,  2816,
     146,  2818,    -1,    -1,    -1,    -1,  2513,   209,    -1,    -1,
      -1,   213,  2829,    -1,    -1,    -1,    -1,    -1,    -1,  1567,
    1568,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2536,
     232,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2563,    -1,    -1,  1068,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1616,  1617,
    1618,    -1,    -1,   219,    -1,  1623,  1624,   279,    -1,  2586,
    1628,  1629,    -1,    -1,    -1,    -1,    -1,  1635,    -1,    -1,
     292,    -1,    -1,  1102,    -1,    -1,  1644,    -1,  1646,    -1,
      -1,  2918,    -1,    -1,  2921,    -1,  2923,    -1,  2925,  2926,
    2927,  1659,    -1,  1661,    -1,    -1,    -1,    -1,  2935,  2936,
    2937,    -1,    -1,  2279,  2280,  2942,  2282,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2297,    -1,  2299,  1692,    -1,    -1,    -1,   350,    -1,
    1698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1708,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2325,
      -1,    -1,    -1,    -1,  1722,   321,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3005,    -1,
      -1,  2698,    -1,  3010,    -1,    -1,    -1,    -1,    -1,  2355,
      -1,    -1,    -1,  3020,  1068,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,  3030,   416,   361,    -1,  2373,    -1,    -1,
      -1,    -1,    -1,    -1,  3041,    -1,    -1,    -1,   430,   431,
     432,   433,   434,   435,    -1,    -1,    -1,    -1,  1102,    -1,
      -1,  1789,    -1,    -1,    -1,    -1,    -1,  1795,    -1,    -1,
      -1,    -1,  2408,    -1,    -1,    -1,  1804,    -1,  2765,    -1,
      -1,    -1,    -1,  2419,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    77,    -1,    -1,    -1,    -1,  2433,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,
      -1,   115,    -1,    -1,    -1,  3122,    -1,  3124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     134,    -1,  3139,    -1,    -1,    -1,  3143,  3144,    -1,    -1,
      -1,    -1,    -1,    -1,  3151,    -1,   150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1892,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1900,    -1,   168,  1903,  1904,  2513,    -1,    -1,
      -1,    -1,    -1,    -1,  1373,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2536,    -1,  3199,   197,  2891,    -1,    -1,  3204,    -1,   203,
    1399,    -1,    -1,    -1,    -1,    -1,    -1,  1945,  3215,  3216,
      -1,  1949,   216,  1412,   209,  1953,   552,  2563,   213,    -1,
      -1,    -1,    -1,  1961,    -1,    -1,    -1,  3234,  1966,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,    -1,
    2586,    -1,    -1,    -1,    -1,  3252,    -1,  3254,    77,    -1,
     245,    -1,    -1,    -1,    -1,  1454,    -1,    -1,  3265,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,  2010,    -1,  3281,   104,    -1,    -1,    -1,    -1,
      -1,   276,  1481,    -1,   279,    -1,    -1,    -1,   292,    -1,
      -1,    -1,    -1,  3300,    -1,    -1,    -1,   292,    -1,   294,
      -1,    -1,    -1,    -1,    -1,  2043,  2044,  1506,   312,  2047,
      -1,  2049,    -1,    -1,  3321,    -1,    -1,    -1,    -1,  1373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   331,    -1,    -1,
      -1,   335,    -1,   337,    -1,  3032,    -1,    -1,   342,  1538,
    3347,    -1,    -1,    -1,  1543,  1399,    -1,    -1,  2086,    -1,
      -1,    -1,  2698,    -1,    -1,   350,    -1,    -1,  1412,    -1,
      -1,  3058,    -1,   367,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   710,    -1,   380,    -1,   714,    -1,
     209,   385,   718,    -1,   213,    -1,   722,    -1,    -1,    -1,
     394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,
    1454,    -1,    -1,   232,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   751,   245,    -1,    -1,  2765,
      -1,   416,    -1,    -1,    -1,    -1,    -1,  1481,    -1,    -1,
      -1,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,    -1,    -1,    -1,     5,   440,    -1,   276,   784,    -1,
     279,   787,  1506,    -1,    -1,    -1,    -1,   793,    -1,    20,
      -1,    -1,    -1,   292,  1663,   294,    -1,    -1,    29,    -1,
    2208,    -1,  2210,    -1,  2212,    -1,    -1,    -1,    -1,    40,
      41,    -1,    -1,    -1,  1538,    -1,    -1,    48,    49,  1543,
      -1,    -1,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    -1,    -1,    -1,
      -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     876,    -1,   878,    -1,    -1,  2891,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
     896,    -1,    -1,  2301,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,    -1,
      -1,  3278,    -1,    -1,  2322,  2323,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,   427,   428,
      -1,   430,   431,   432,   433,   434,   435,    -1,    -1,  1663,
      -1,   440,    -1,    -1,    -1,    -1,    -1,    -1,  2356,  2357,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2365,   189,    -1,
      -1,    -1,    -1,    -1,    -1,  2373,    -1,    -1,  3335,    -1,
    2378,    -1,  2380,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,  1850,  1851,  2391,  2392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   226,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3032,    -1,    -1,    -1,
      -1,    -1,    -1,  2431,  2432,    -1,   257,    -1,    -1,   260,
      -1,    -1,  2440,    -1,  1040,  1041,    -1,    -1,    -1,  1045,
      -1,    -1,  3058,    -1,    -1,  1051,    -1,    -1,    -1,    -1,
     281,    -1,  1068,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1068,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1939,    -1,    -1,    -1,    -1,  1944,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1102,  1093,    -1,    -1,
    1959,    -1,    -1,    -1,    -1,    -1,  1102,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,    -1,
      -1,    -1,  2520,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2530,    -1,    -1,    -1,  1850,  1851,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   388,  1164,    -1,
      -1,  2030,    -1,    -1,    -1,    -1,  2574,    -1,    -1,   400,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     411,    -1,    -1,   414,   415,  1191,   417,    -1,    -1,    -1,
      -1,    -1,   423,    -1,   425,   426,    -1,    -1,    -1,   430,
     431,   432,   433,   434,    -1,    -1,   437,   438,   439,  1215,
    1216,    -1,  1218,    -1,    -1,  1939,    -1,    -1,    -1,    -1,
    1944,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1236,    -1,    -1,    -1,    -1,  1959,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,   213,
      -1,    -1,    -1,    -1,    -1,  1261,  1262,    -1,    -1,    -1,
      -1,    -1,  3278,    -1,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,  1279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1302,    -1,    -1,  1305,
    1306,    -1,    -1,  2711,  2712,    -1,  2030,  1313,  1314,  1315,
      -1,    -1,   276,    -1,    -1,   279,    -1,  2725,    -1,  3335,
      -1,    -1,  2730,  2731,  2732,  2733,  2734,  1333,   292,    -1,
    2738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1373,  1364,    -1,
      -1,    -1,    -1,    -1,    -1,  1371,    -1,  1373,    99,    -1,
    1376,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,
    2788,    -1,    -1,  1399,    -1,    -1,   350,    90,    -1,    -1,
      -1,    -1,    -1,  1399,    -1,    -1,  1412,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1412,    -1,    -1,   112,
    2279,  2280,    -1,  2282,    -1,    -1,  2824,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,    -1,
    2299,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1454,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,  1454,    -1,
      -1,    -1,   416,    -1,    -1,    -1,  2325,    -1,    -1,  1465,
      -1,    -1,   426,   427,   428,  1481,   430,   431,   432,   433,
     434,   435,    -1,    -1,    -1,  1481,    -1,    -1,   209,    -1,
      -1,    -1,   213,    -1,    -1,    -1,  2355,    -1,    -1,    -1,
    1506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1506,   232,   233,    -1,  2373,    -1,  2914,  2915,    -1,    -1,
      -1,    -1,    -1,    -1,   245,    -1,   219,    -1,    -1,    -1,
    2928,    -1,  1538,    -1,    -1,    -1,    -1,  1543,    -1,    -1,
    1536,    -1,  1538,  2941,    -1,    -1,    -1,  1543,  2946,  2408,
    2948,  2949,    -1,    -1,    -1,  2953,    -1,    -1,   279,    -1,
    2419,    -1,    -1,    -1,    -1,  2279,  2280,    -1,  2282,    -1,
      -1,   292,    -1,    -1,  2433,    -1,    -1,  1573,    -1,    -1,
      -1,    -1,    -1,  2297,    -1,  2299,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1603,  1604,    -1,
      -1,  2325,    -1,  3011,    -1,  1611,    -1,    -1,  1614,  1615,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1623,    -1,   350,
    1626,  1627,    -1,    -1,    -1,    -1,    77,    -1,  1634,    -1,
      -1,  2355,  1638,  1639,  1640,  1641,    -1,    -1,    -1,    -1,
      91,    -1,  1648,  1649,  2513,    -1,    -1,  1663,    99,  2373,
      -1,    -1,    -1,   104,    -1,    -1,    -1,  1663,  1664,  1665,
      -1,    -1,  1668,    -1,    -1,    -1,  1672,  2536,    -1,    -1,
    1676,    -1,    -1,  1679,  1680,  1681,  1682,  1683,  1684,  1685,
    1686,  1687,    -1,  1689,  2408,   416,    -1,  1693,    -1,    -1,
      -1,  1697,    -1,  3101,  2563,  2419,    -1,    -1,    -1,   430,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,  2433,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2586,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3137,
      -1,    -1,  1738,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    91,   213,    -1,    -1,    -1,  1772,    -1,  1774,    99,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,    -1,    -1,    -1,  2513,
      -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1817,  2536,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3231,    -1,   276,  1832,  3235,   279,  2698,
      -1,    -1,    -1,    -1,  1850,  1851,    -1,    -1,    -1,  2563,
      -1,   292,    -1,   294,  1850,  1851,    -1,    -1,    -1,    -1,
      -1,   209,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,
      -1,    -1,  2586,    -1,    -1,    -1,    -1,    -1,  3276,  3277,
      -1,    -1,    -1,  3281,   232,   233,    -1,    -1,    -1,   209,
      -1,    -1,    -1,   213,    -1,    -1,    -1,   245,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2765,    77,    -1,   350,
      -1,    -1,   232,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3321,    -1,   245,    -1,    -1,   276,    99,
      -1,   279,    -1,  1939,   104,    -1,    -1,    -1,  1944,    -1,
      -1,    -1,  1938,  1939,   292,    -1,   294,    -1,  1944,  3347,
      -1,    -1,    -1,  1959,    -1,    -1,   276,    -1,    -1,   279,
      -1,  1957,    -1,  1959,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   292,    -1,   294,   416,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2698,   426,   427,   428,    -1,   430,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   350,    -1,    -1,    -1,    -1,   177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   710,    -1,    -1,
      -1,    -1,  2018,    -1,  2030,   718,    -1,    -1,    -1,   722,
     350,  2027,  2891,    -1,  2030,    -1,    -1,    -1,    -1,   209,
      -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2765,    -1,    -1,    -1,    -1,    -1,    -1,   751,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,  2063,   416,    -1,
      -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,   426,   427,
     428,    -1,   430,   431,   432,   433,   434,   435,    85,    -1,
      -1,  2087,   440,    -1,   787,    -1,   416,    -1,    -1,    96,
     793,    -1,    -1,    -1,    -1,    -1,   426,   427,   428,   279,
     430,   431,   432,   433,   434,   435,    -1,    -1,   115,    -1,
     440,    -1,   292,  2119,    -1,    -1,  2122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,  2134,  2135,
    2136,  2137,    -1,    -1,    -1,    -1,    -1,  2143,    -1,    -1,
      -1,    -1,    -1,   150,    -1,    -1,    -1,  2153,  2154,   156,
    2156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   168,  2168,  3032,  2170,    -1,    -1,  2891,  2174,    -1,
     350,    -1,    -1,   876,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3058,
     197,  2197,   199,  2199,  2200,    -1,   203,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2223,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2231,  2232,  2233,    -1,    -1,
      -1,   238,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
      -1,    -1,   249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     430,   431,   432,   433,   434,   435,  2262,    -1,    -1,    -1,
      -1,    -1,    -1,  2279,  2280,    -1,  2282,    -1,    -1,    -1,
      -1,    -1,    -1,  2279,  2280,    -1,  2282,    -1,    -1,    -1,
      -1,  2297,    -1,  2299,    -1,   292,    -1,   294,    77,    -1,
      -1,  2297,    -1,  2299,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,   312,    -1,    -1,  3032,  2325,
      99,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,  2325,
      -1,    -1,    -1,    -1,   331,    -1,    -1,    -1,   335,    -1,
     337,    -1,    -1,    -1,  3058,    -1,    -1,  1040,  1041,  2355,
      -1,    -1,  1045,    -1,    -1,    -1,    -1,    -1,  1051,  2355,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2373,    -1,    -1,
      -1,   368,   369,    -1,   371,  1068,  2372,  2373,    -1,    -1,
      -1,    -1,    -1,   380,    -1,    -1,    -1,   384,   385,    -1,
      -1,    -1,   389,    -1,    -1,    -1,    -1,   394,    -1,    -1,
    1093,    -1,  2408,    82,    -1,    -1,    -1,    -1,    -1,  1102,
      -1,    -1,  2408,  2419,    -1,    -1,    -1,    -1,    -1,  3278,
      -1,    -1,    -1,  2419,    -1,    -1,    -1,  2433,    -1,    -1,
     209,    -1,    -1,    -1,   213,    -1,    -1,  2433,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2447,    -1,   232,   233,  2451,    -1,    -1,    -1,  2455,
      -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,
      -1,  1164,    -1,    -1,    -1,    -1,  3335,    -1,    -1,   158,
      -1,  2477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   276,  1191,   178,
     279,   180,    -1,    -1,    -1,    -1,    -1,  2513,  2504,    -1,
      -1,    -1,    -1,   292,  2510,   294,    -1,  2513,    -1,    -1,
      -1,    -1,  1215,  1216,    -1,  1218,  2522,    -1,    -1,    -1,
    2536,    -1,  2528,    -1,    -1,    -1,  2532,    -1,    -1,    -1,
    2536,  2537,    -1,  1236,  2540,  2541,  2542,  2543,  2544,  2545,
    2546,  2547,  2548,  2549,    -1,    -1,    -1,  2563,  2554,  2555,
      -1,    -1,    -1,    -1,  3278,    -1,    -1,  2563,    -1,    -1,
      -1,   350,  2568,    -1,    -1,    -1,    -1,    -1,    -1,  2575,
    2586,    -1,  2578,    -1,  2580,    -1,    -1,    -1,    -1,    -1,
    2586,  2587,  2588,  2589,    -1,   138,    -1,  2593,    -1,    -1,
    2596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1302,
      -1,    -1,  1305,  1306,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   177,    -1,    -1,   416,    -1,    -1,
      -1,    -1,   185,    -1,  2640,    -1,    -1,   426,   427,   428,
      -1,   430,   431,   432,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,   220,   221,    -1,
    1373,    -1,    -1,  1376,    99,    -1,    -1,    -1,    -1,   104,
      -1,    -1,  2698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2698,    -1,    -1,    -1,  1399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1412,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2754,  2765,
      -1,  1454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2765,
      -1,    -1,  1465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1481,    -1,
      -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,   213,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2806,    -1,    -1,  1506,    -1,  2811,    -1,   232,   233,  2815,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     245,    -1,    -1,    -1,    -1,    -1,    -1,  2833,    -1,    -1,
      -1,    -1,    -1,  1536,    -1,  1538,    -1,    -1,    -1,  2845,
    1543,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   276,    -1,    -1,   279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,   294,
    1573,    -1,    -1,    -1,    -1,  2891,    -1,    -1,    -1,    -1,
    2886,  2887,    -1,    -1,    -1,  2891,    -1,    -1,    -1,   131,
      -1,  2897,  2898,    -1,    -1,  2901,   138,   139,    -1,    -1,
    1603,  1604,    -1,    -1,    -1,    -1,    -1,    -1,  1611,    -1,
      -1,  1614,  1615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1626,  1627,   350,    -1,    -1,    -1,    -1,
      -1,  1634,    -1,   175,    -1,  1638,  1639,  1640,  1641,    -1,
      -1,    -1,    -1,    -1,    -1,  1648,  1649,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1663,  1664,  1665,    -1,    -1,  1668,    -1,    -1,  2974,  1672,
      -1,   213,    -1,  1676,    -1,   217,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,    -1,  1689,    -1,    -1,    -1,
    1693,   416,    -1,    -1,  1697,    -1,    -1,    -1,    -1,    -1,
      -1,   426,   427,   428,  3010,   430,   431,   432,   433,   434,
     435,    -1,   254,    -1,    -1,   440,  3032,  3023,    -1,    -1,
      -1,  3027,    -1,    -1,    -1,    -1,  3032,   269,   270,    -1,
     272,   273,    -1,   275,  3040,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3058,  3049,    -1,  3051,    -1,    -1,    77,    -1,
      -1,    -1,  3058,  3059,  3060,    -1,    -1,  3063,   747,    -1,
     302,    -1,    91,    -1,  3070,  3071,    -1,    -1,    -1,    -1,
      99,    -1,    -1,    -1,  3080,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   331,
      -1,    -1,  3098,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1817,    -1,    -1,    -1,    -1,    -1,
      -1,   363,    -1,   365,    -1,    -1,   815,    -1,   817,  1832,
     819,    -1,    -1,    -1,  3140,    -1,   825,   826,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,  1850,  1851,    -1,
      -1,    -1,   394,    -1,    -1,   397,  3162,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   853,   718,    -1,    -1,    -1,   722,
      -1,   724,    -1,    -1,    -1,    -1,   729,   730,    -1,    -1,
     209,    -1,   871,    -1,   213,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   882,   883,    -1,    -1,   750,   751,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,    -1,  3215,
      -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,
      -1,    -1,  3228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   786,   787,  1938,  1939,    -1,    -1,    -1,
     793,  1944,    -1,    -1,    -1,    -1,    -1,   276,    -1,   938,
     279,    -1,    -1,    -1,  1957,    -1,  1959,    -1,    -1,    -1,
      -1,    -1,  3278,   292,    -1,   294,   955,   956,    -1,    -1,
      -1,    -1,  3278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   972,    -1,    -1,    -1,    -1,    -1,    -1,
     843,    -1,    -1,  3299,    -1,    -1,   849,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1068,   859,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2018,    -1,    -1,    -1,  3335,
      -1,   350,    -1,    -1,  2027,    -1,  3332,  2030,    -1,  3335,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1102,
      -1,    -1,   895,    -1,    -1,    77,    -1,   900,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,    91,
    2063,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2087,    -1,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,   427,   428,
      -1,   430,   431,   432,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,    -1,    -1,    -1,  2119,    -1,    -1,  2122,
      -1,    -1,    -1,    -1,    -1,  1114,    -1,    -1,    -1,    -1,
      -1,  2134,  2135,  2136,  2137,    -1,    -1,    -1,    -1,    -1,
    2143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2153,  2154,    -1,  2156,    -1,    -1,    -1,    -1,   190,    -1,
      -1,    -1,    -1,   195,    -1,  2168,    -1,  2170,    -1,    -1,
      -1,  2174,    -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,
      -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1044,  1045,    -1,  2197,    -1,  2199,  2200,  1051,    -1,
     232,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
    2223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2231,  2232,
    2233,  1220,    -1,    -1,  1087,  1088,  1089,    -1,    -1,    -1,
    1093,    -1,  1231,    -1,   276,    -1,    -1,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2262,
     292,    -1,   294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2279,  2280,    -1,  2282,
      -1,    -1,    -1,    -1,  1137,    -1,    -1,  1276,    -1,    -1,
    1279,    -1,  1281,  1282,  2297,    -1,  2299,    -1,    -1,    -1,
      -1,    -1,  1155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1373,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,
      -1,    -1,  2325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1068,    -1,  1335,    -1,    -1,  1412,
      -1,    -1,  2355,    -1,    -1,    -1,    -1,  1346,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2372,
    2373,    -1,    -1,    -1,    -1,    -1,    92,    -1,  1102,    -1,
      -1,    -1,    -1,    -1,   416,    -1,   102,    -1,    -1,    -1,
      -1,  1454,    -1,    -1,   426,   427,   428,    -1,   430,   431,
     432,   433,   434,   435,    -1,  2408,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2419,    -1,  1481,    -1,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2433,   147,    -1,    -1,   150,    -1,  1289,    -1,   154,    -1,
      -1,    -1,   158,  1506,  2447,    -1,    -1,    -1,  2451,    -1,
      -1,    -1,  2455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   180,    -1,    -1,  1456,    -1,    -1,
      -1,    -1,    -1,    -1,  2477,  1538,    -1,    -1,    -1,   195,
    1543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2504,    -1,    -1,    -1,    -1,    -1,  2510,    -1,    -1,
    2513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2522,
      -1,    -1,    -1,    -1,    -1,  2528,    -1,    -1,    -1,  2532,
      -1,    -1,    -1,  2536,  2537,    -1,  1525,  2540,  2541,  2542,
    2543,  2544,  2545,  2546,  2547,  2548,  2549,    -1,    -1,    -1,
      -1,  2554,  2555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2563,    -1,    -1,    -1,    -1,  2568,    -1,    -1,    -1,    -1,
      -1,    -1,  2575,    -1,    -1,  2578,    -1,  2580,    -1,    -1,
      -1,  1434,    -1,  2586,  2587,  2588,  2589,    -1,    -1,    -1,
    2593,    -1,    77,  2596,    -1,    -1,    -1,    -1,    -1,    -1,
    1663,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1616,  1617,  1618,
      -1,    -1,    -1,    -1,  1623,  1624,    -1,  2640,    -1,  1628,
    1629,    -1,    -1,    -1,    -1,    -1,  1635,    -1,   364,  1373,
      -1,    -1,    -1,    -1,    -1,  1644,    -1,  1646,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1659,    -1,  1661,    -1,    -1,  1399,    -1,    -1,    -1,   164,
      -1,    -1,    -1,  1536,    -1,    -1,    -1,    -1,  1412,    -1,
      -1,  1544,  1545,    -1,    -1,  2698,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1573,    -1,    -1,  1576,   209,    -1,    -1,    -1,   213,    -1,
    1454,    -1,    -1,  1722,    -1,  1588,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,  2754,    -1,    -1,    -1,    -1,    -1,  1481,    -1,    -1,
     245,    -1,  2765,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1506,    -1,    -1,    -1,    -1,  1850,  1851,    -1,
      -1,   276,    -1,    -1,   279,    -1,    -1,    -1,    -1,    -1,
    1789,    -1,    -1,  2806,    -1,    -1,  1795,   292,  2811,   294,
      -1,    -1,  2815,    -1,  1538,    -1,  1805,    -1,    -1,  1543,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
    2833,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,  1692,
      94,    -1,  2845,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1939,    -1,    -1,   595,
     596,  1944,    -1,  2886,  2887,    -1,    -1,    -1,  2891,    -1,
      -1,  1744,    -1,    -1,  2897,  2898,  1959,    -1,  2901,    -1,
      -1,    -1,    -1,  1892,    -1,    -1,    -1,    -1,    -1,    -1,
     395,  1900,    -1,    -1,  1903,  1904,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1663,
      -1,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,    -1,    -1,    -1,    -1,   209,  1945,    -1,    -1,   213,
    1949,    -1,    -1,    -1,  1953,    -1,    -1,  2030,    -1,    -1,
      -1,  2974,  1961,    -1,    -1,    -1,    -1,  1966,   232,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3010,    -1,   725,
      -1,    -1,   728,    -1,    -1,   731,   732,    -1,    -1,    -1,
    3023,  2010,   276,    -1,  3027,   279,    -1,    -1,    -1,  3032,
      -1,    -1,    -1,    -1,    -1,    -1,   752,  3040,   292,    -1,
     294,    -1,    -1,    -1,    -1,    -1,  3049,    -1,  3051,   765,
      -1,    -1,   768,    -1,    -1,  3058,  3059,  3060,    -1,    -1,
    3063,    -1,    -1,   779,   780,    -1,    -1,  3070,  3071,    -1,
      -1,    -1,   788,    -1,    -1,    -1,    -1,  3080,    -1,    -1,
      -1,    -1,    -1,   799,    -1,    -1,    -1,   803,   804,    -1,
      -1,    -1,    -1,    -1,    -1,  3098,   350,  2086,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3112,
      -1,   827,   828,    -1,    -1,    -1,    -1,    -1,   834,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1850,  1851,  1981,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3140,    -1,   855,
      -1,   857,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2004,    -1,    -1,    -1,    -1,    -1,    -1,  2011,  3162,
      -1,    -1,   416,   879,    -1,  2018,    -1,    -1,    -1,    -1,
      -1,    -1,   426,   427,   428,    -1,   430,   431,   432,   433,
     434,   435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3215,    -1,    -1,  1939,  2279,  2280,    -1,  2282,
    1944,  2210,    -1,  2212,    -1,  3228,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2297,  1959,  2299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,  2325,    -1,   980,    -1,    -1,   983,    -1,    -1,
     986,    -1,    -1,    -1,    91,  3278,    -1,    94,    -1,    -1,
      -1,    -1,    99,    -1,    -1,    -1,    -1,   104,  1068,    -1,
      -1,    -1,  2355,    -1,    -1,    -1,  3299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2030,    -1,    -1,    -1,
    2373,    -1,  2301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1102,    -1,    -1,    -1,    -1,  2316,    -1,  3332,
      -1,    -1,  3335,  2322,  2323,    -1,    -1,    -1,  2191,  1055,
      -1,    -1,    -1,  1059,  2197,  2408,    -1,  1063,    -1,    -1,
      -1,    -1,    -1,  1069,    -1,    -1,  2419,    -1,    -1,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,  2356,  2357,    -1,
    2433,    -1,    -1,    -1,    -1,    91,  2365,    -1,  1094,    -1,
      -1,    -1,    -1,    99,  2373,    -1,    -1,    -1,   104,  2378,
      -1,  2380,   209,    -1,    -1,    -1,   213,    -1,    -1,    -1,
      -1,    -1,  2391,  2392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1129,    -1,   232,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1143,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2431,  2432,    -1,   718,    -1,    -1,    -1,   722,
    2513,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,   276,
      -1,    -1,   279,    -1,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,  2536,    99,   292,    -1,   294,   751,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   209,    -1,    -1,    -1,   213,    -1,    -1,
    2563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   787,    -1,   232,   233,    -1,    -1,
     793,    -1,    -1,  2586,    -1,    -1,    -1,    -1,    -1,   245,
      -1,  2520,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2530,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2404,    -1,    -1,    -1,  2279,  2280,  2410,  2282,    -1,
     276,    -1,    -1,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2297,    -1,  2299,   292,    -1,   294,    -1,
      -1,    -1,    -1,    -1,   209,  2574,    -1,    -1,   213,    -1,
      -1,    -1,    -1,  1373,  2447,    -1,    -1,    -1,  2451,   416,
      -1,  2325,  2455,   876,    -1,    -1,    -1,   232,   233,   426,
     427,   428,    -1,   430,   431,   432,   433,   434,   435,  1399,
     245,    -1,    -1,    -1,  2477,    -1,    -1,    -1,    -1,    -1,
      -1,  2355,  1412,    -1,   350,  2698,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2499,    -1,    -1,  2373,
    1366,   276,    -1,    -1,   279,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,   294,
      -1,    -1,    91,    -1,  1454,    94,    -1,    -1,   303,   395,
      99,    -1,    -1,    -1,  2408,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2419,    -1,    -1,    -1,    -1,
     416,  1481,  2765,    -1,    -1,    -1,    -1,    -1,    -1,  2433,
     426,   427,   428,    -1,   430,   431,   432,   433,   434,   435,
      -1,    -1,  2711,  2712,    -1,   350,  1506,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,
      -1,  2730,  2731,  2732,  2733,  2734,    -1,    -1,    -1,  2738,
    2603,  2604,    -1,    -1,    -1,    -1,    -1,    -1,  1538,    -1,
      -1,    -1,    -1,  1543,    -1,    -1,    77,  1040,    -1,    -1,
      -1,    -1,  1045,    -1,    -1,    -1,    -1,    -1,  1051,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,  2513,
     209,   416,    -1,   104,   213,  1068,    -1,    -1,  1514,  2788,
      -1,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,    -1,  2536,   232,   233,    -1,    -1,    -1,    -1,    -1,
    1093,    -1,    -1,    -1,    -1,  1541,   245,    -1,  2891,  1102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1554,  2563,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   276,    -1,    -1,
     279,    -1,  2586,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   292,    -1,   294,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1663,  2737,    -1,    -1,    -1,    -1,    -1,
      -1,  1164,    -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    -1,   213,    -1,    -1,    -1,    -1,  2760,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2768,    -1,    -1,  1191,    -1,
      -1,   232,   233,    -1,    -1,    -1,  2915,    -1,    -1,    -1,
      -1,   350,    -1,    -1,   245,    -1,    -1,    -1,    -1,  2928,
      -1,    -1,  1215,  1216,    -1,  1218,    -1,    -1,    -1,    -1,
      -1,    -1,  2941,  2806,    -1,    -1,    -1,  2946,  2811,  2948,
    2949,    -1,  2815,  1236,  2953,   276,    -1,    -1,   279,  3032,
      -1,    -1,    -1,    -1,  2698,    -1,    -1,    -1,    -1,    -1,
      -1,   292,  1698,   294,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3058,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,   427,   428,
      -1,   430,   431,   432,   433,   434,   435,    -1,    -1,    -1,
      -1,    -1,  3011,    -1,    -1,    -1,    -1,    -1,    -1,  1302,
      -1,    -1,  1305,  1306,    -1,    -1,    -1,    -1,    -1,   350,
      -1,  2765,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2903,  2904,  2905,  2906,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1850,  1851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,  1804,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,  1815,
    1373,    -1,    -1,    -1,    -1,   416,    99,  1823,    -1,    -1,
      -1,   104,  3101,  1829,    -1,   426,   427,   428,  1834,   430,
     431,   432,   433,   434,   435,    -1,  1399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1412,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3137,    -1,
    1866,  1867,    -1,  1869,    -1,    -1,    -1,  3010,    -1,  1939,
      -1,    -1,    -1,    -1,  1944,    -1,    -1,  2891,    -1,    -1,
      -1,    -1,    -1,    -1,  3027,    -1,    -1,    -1,    -1,  1959,
      -1,  1454,  1898,  1899,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1913,    -1,  1915,
    1916,    -1,  1918,  1919,  1920,  1921,    -1,    -1,  1481,  1925,
      -1,    -1,  1928,    -1,    -1,  3278,   209,    -1,    -1,    -1,
     213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1506,    -1,    -1,    -1,    -1,    -1,   232,
     233,    -1,  3231,    -1,    -1,    -1,  3235,    -1,    -1,    -1,
    2030,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,  3112,
      -1,  3114,    -1,  1536,    -1,  1538,    -1,    -1,    -1,    -1,
    1543,    -1,  3335,    -1,    -1,    -1,    -1,    -1,    -1,  3132,
      -1,    -1,    -1,   276,    -1,    -1,   279,  3276,  3277,    -1,
      -1,    -1,    -1,    77,  3147,    -1,    -1,    -1,    -1,   292,
    1573,   294,    -1,    -1,    -1,    -1,    -1,    91,  3032,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,  3177,    -1,    -1,  2043,    -1,    -1,
    1603,  1604,    -1,    -1,  3058,    -1,    -1,    -1,  1611,    -1,
      -1,  1614,  1615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,  1626,  1627,    -1,    -1,   350,    -1,    -1,
      -1,  1634,  3215,    -1,    91,  1638,  1639,  1640,  1641,    -1,
      -1,    -1,    99,    -1,    -1,  1648,  1649,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1663,  1664,    -1,    -1,    -1,  1668,    -1,    -1,    -1,  1672,
      -1,    -1,    -1,  1676,    -1,    -1,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,    -1,  1689,    -1,    -1,    -1,
    1693,    -1,    -1,   416,  1697,   209,    -1,    -1,    -1,   213,
      -1,    -1,    -1,   426,   427,   428,    -1,   430,   431,   432,
     433,   434,   435,    -1,    -1,    -1,  3299,    -1,   232,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3332,
      -1,    -1,   209,    -1,    -1,    -1,   213,    -1,    -1,    -1,
      -1,    -1,   276,    -1,    -1,   279,    -1,    -1,    -1,  2279,
    2280,    -1,  2282,    -1,    -1,   232,   233,    -1,   292,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,   245,  2299,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2325,    -1,    -1,    -1,   276,
      -1,    -1,   279,    -1,  3278,    -1,    -1,    -1,    -1,  1832,
      -1,    -1,    -1,    -1,    -1,   292,   350,   294,    -1,    -1,
    2286,  2287,    -1,    -1,    -1,  2355,    -1,  1850,  1851,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2373,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,  2408,    -1,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,  2419,
      -1,    -1,   426,   427,   428,    -1,   430,   431,   432,   433,
     434,   435,    -1,  2433,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1938,  1939,    -1,    -1,    -1,
      -1,  1944,    -1,    -1,    -1,    -1,    -1,  2393,  2394,  2395,
      -1,    -1,    -1,    -1,  1957,    -1,  1959,    -1,    -1,   416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,
     427,   428,    -1,   430,   431,   432,   433,   434,   435,    -1,
      -1,    -1,  2428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2440,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2513,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2018,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2027,    -1,  2536,  2030,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,  2563,    -1,    -1,    -1,    -1,    -1,    -1,
    2063,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    40,    41,    -1,    -1,  2586,    -1,    -1,    -1,
      48,    49,    -1,    -1,  2087,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2119,    -1,    -1,  2122,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2134,  2135,  2136,  2137,    -1,    -1,    -1,    -1,    -1,
    2143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
    2153,  2154,    -1,  2156,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2168,    -1,  2170,    -1,    -1,
      -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2698,    -1,
      -1,    -1,    -1,    -1,  2197,    -1,  2199,  2200,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2223,   189,    -1,    -1,    -1,    -1,    -1,    -1,  2231,  2232,
    2233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2765,  2702,  2703,   226,  2262,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2279,  2280,    -1,  2282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,   260,    -1,  2297,    -1,  2299,    -1,   718,    -1,
      -1,    -1,   722,    -1,    -1,    -1,    -1,  2753,    -1,    -1,
      -1,    -1,    -1,   281,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   751,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   787,    -1,    -1,
    2373,   339,    -1,   793,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2891,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2408,    -1,   375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2419,    -1,    -1,    -1,
     388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2433,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   411,  2447,    -1,   414,   415,  2451,   417,
      -1,    -1,  2455,    -1,    -1,   423,   876,   425,   426,    -1,
      -1,    -1,   430,   431,   432,   433,   434,    -1,    -1,   437,
     438,   439,    -1,    -1,  2477,   443,    -1,    -1,    -1,    -1,
    2926,  2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2936,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2504,    -1,    -1,    -1,    -1,    -1,  2510,    -1,    -1,
    2513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2522,
      -1,    -1,  3032,    -1,    -1,  2528,    -1,    -1,    -1,  2532,
      -1,    -1,    -1,  2536,  2537,    -1,    -1,  2540,  2541,  2542,
    2543,  2544,  2545,  2546,  2547,  2548,  2549,    -1,  3058,    -1,
      -1,  2554,  2555,    -1,    -1,    -1,    -1,    -1,    -1,  3005,
    2563,    -1,    -1,    -1,    -1,  2568,    -1,    -1,    -1,    -1,
      -1,    -1,  2575,    -1,    -1,  2578,    -1,  2580,    -1,    -1,
      -1,    -1,    -1,  2586,  2587,  2588,  2589,    -1,    -1,    -1,
    2593,    -1,    -1,  2596,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,
    1040,    19,    -1,    -1,    22,  1045,    -1,    -1,    -1,    -1,
      -1,  1051,    -1,    -1,    -1,    33,    -1,  2640,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1068,    -1,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1093,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    -1,  1102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    -1,    -1,  2698,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   121,    -1,   123,   124,    -1,    -1,    -1,
     128,   129,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,    -1,    -1,    -1,  1164,    -1,    -1,    -1,    -1,    -1,
      -1,  2754,   150,  3199,   152,    -1,    -1,   155,  3204,    -1,
      -1,    -1,  2765,   161,    -1,    -1,    -1,    -1,  3278,    -1,
      -1,  1191,   170,    -1,    -1,    -1,    -1,    -1,   176,    -1,
      -1,    -1,    -1,   181,    -1,   183,    -1,    -1,    -1,   187,
      -1,    -1,    -1,    -1,    -1,  1215,  1216,    -1,  1218,    -1,
     198,    -1,   200,  2806,    -1,    -1,  3252,    -1,  2811,    -1,
      -1,    -1,  2815,    -1,    -1,    -1,  1236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3335,   224,    -1,    -1,    -1,
    2833,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2845,    -1,    -1,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,    -1,  1302,  2886,  2887,  1305,  1306,    -1,  2891,    -1,
      -1,    -1,    -1,    -1,  2897,  2898,    -1,    -1,  2901,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,   321,    -1,    -1,    -1,   325,    -1,    -1,
      -1,   329,    -1,    -1,   332,    -1,    -1,    -1,   336,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,   346,    -1,
      -1,   349,    -1,  1373,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2974,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1399,
      -1,    -1,    -1,    -1,    -1,   383,    -1,   385,    -1,    -1,
      -1,    -1,  1412,   391,    -1,   393,    -1,    -1,   396,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3010,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3023,    -1,    -1,    -1,  3027,    -1,    -1,    -1,    -1,  3032,
      -1,    -1,    -1,    -1,  1454,    -1,    -1,  3040,    -1,    -1,
      -1,   439,    -1,    -1,    -1,    -1,  3049,    -1,  3051,    -1,
      -1,    -1,    -1,    -1,    -1,  3058,  3059,  3060,    -1,    -1,
    3063,  1481,    -1,    -1,    -1,    -1,    -1,  3070,  3071,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3080,    -1,    -1,
      -1,    -1,   876,    -1,    -1,    -1,  1506,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3098,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3112,
      -1,    -1,    -1,    -1,    -1,    -1,  1536,    -1,  1538,    -1,
      -1,    -1,    -1,  1543,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3140,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1573,    -1,    -1,    -1,    -1,    -1,  3162,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1603,  1604,    -1,    -1,    -1,    -1,    -1,
      -1,  1611,    -1,    -1,  1614,  1615,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1626,  1627,    -1,    -1,
      -1,    -1,  3215,    -1,  1634,    -1,    -1,    -1,  1638,  1639,
    1640,  1641,    -1,    -1,    -1,  3228,    -1,    -1,  1648,  1649,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1663,  1664,    -1,  1040,    -1,  1668,    -1,
      -1,    -1,  1672,    -1,    -1,    -1,  1676,    -1,    -1,  1679,
    1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,    -1,  1689,
      -1,    -1,    -1,  1693,    -1,  3278,    -1,  1697,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3332,
      -1,    -1,  3335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1191,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1832,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1215,  1216,    -1,  1218,    -1,    -1,    -1,    -1,    -1,
    1850,  1851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1302,    -1,
      -1,  1305,  1306,    -1,    -1,    -1,    -1,    -1,  1938,  1939,
      -1,    -1,    -1,    -1,  1944,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1957,    -1,  1959,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2018,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2027,    -1,    -1,
    2030,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2063,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2087,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2119,
      -1,    -1,  2122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2134,  2135,  2136,  2137,    -1,    -1,
      -1,    -1,    -1,  2143,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2153,  2154,    -1,  2156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2168,    -1,
    2170,    -1,    -1,    -1,  2174,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2197,    -1,  2199,
    2200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2231,  2232,  2233,    -1,    -1,    -1,  1611,    -1,    -1,
      -1,  1615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1634,    -1,  2262,    -1,  1638,    -1,    -1,  1641,    -1,    -1,
      -1,    -1,    -1,    -1,  1648,  1649,    -1,    -1,    -1,  2279,
    2280,    -1,  2282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1664,    -1,    -1,    -1,  1668,    -1,    -1,  2297,  1672,  2299,
      -1,    -1,  1676,    -1,    -1,  1679,  1680,  1681,  1682,  1683,
    1684,  1685,  1686,  1687,    -1,  1689,    -1,    -1,    -1,  1693,
      -1,    -1,    -1,    -1,    -1,  2325,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2373,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2408,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2419,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1232,    -1,    -1,  2433,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2447,    -1,    -1,
      -1,  2451,    -1,    -1,    -1,  2455,    -1,    -1,  1832,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2477,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2504,    -1,    -1,    -1,    -1,    -1,
    2510,    -1,    -1,  2513,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2522,    -1,    -1,    -1,    -1,    -1,  2528,    -1,
      -1,    -1,  2532,    -1,    -1,    -1,  2536,  2537,    -1,    -1,
    2540,  2541,  2542,  2543,  2544,  2545,  2546,  2547,  2548,  2549,
      -1,    -1,    -1,    -1,  2554,  2555,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2563,  1938,    -1,    -1,    -1,  2568,    -1,
      -1,    -1,    -1,    -1,    -1,  2575,    -1,    -1,  2578,    -1,
    2580,    -1,    -1,  1957,    -1,    -1,  2586,  2587,  2588,  2589,
      -1,    -1,    -1,  2593,    -1,    -1,  2596,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2640,    -1,    -1,    -1,    -1,  1447,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2027,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2698,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2087,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2754,    -1,    -1,    -1,    -1,    -1,
    2134,    -1,  2136,  2137,    -1,  2765,    -1,    -1,    -1,  2143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2168,    -1,  2170,    -1,    -1,    -1,
    2174,    -1,    -1,    -1,    -1,    -1,  2806,  1609,    -1,    -1,
      -1,  2811,    -1,    -1,    -1,  2815,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1633,    -1,  2833,    -1,    -1,    -1,  1639,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2845,    -1,    -1,    -1,  2223,
    1652,  1653,    -1,  1655,    -1,    -1,    -1,  2231,  2232,  2233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2886,  2887,  2262,  1691,
      -1,  2891,    -1,    -1,    -1,    -1,    -1,  2897,  2898,    -1,
      -1,  2901,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1753,    -1,    -1,    -1,    -1,    -1,    -1,  1760,    -1,
    1762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2974,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3010,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3023,    -1,    -1,    -1,  3027,    -1,    -1,
      -1,    -1,  3032,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3040,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3049,
      -1,  3051,    -1,    -1,    -1,    -1,    -1,    -1,  3058,  3059,
    3060,    -1,    -1,  3063,    -1,    -1,    -1,    -1,    -1,    -1,
    3070,  3071,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3080,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3098,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2504,    -1,    -1,    -1,    -1,    -1,  2510,    -1,    -1,    -1,
    3140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2522,    -1,
      -1,    -1,    -1,    -1,  2528,    -1,    -1,    -1,  2532,    -1,
      -1,    -1,  3162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2554,  2555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2575,    -1,    -1,  2578,    -1,  2580,    -1,    -1,    -1,
      -1,    -1,    -1,  2587,    -1,  3215,    -1,    -1,    -1,  2593,
      -1,    -1,  2596,    -1,    -1,    -1,    -1,    -1,  3228,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2640,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3278,  2081,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2090,    -1,
    2092,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3299,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2114,    -1,    -1,  2117,    -1,  2119,  2120,    -1,
    2122,    -1,    -1,    -1,  2126,    -1,    -1,    -1,    -1,    -1,
      -1,  2133,  3332,    -1,    -1,  3335,  2138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2149,    -1,    -1,
      -1,  2153,  2154,  2155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2166,    -1,    -1,    -1,    -1,    -1,
      -1,  2173,    -1,  2175,  2176,  2177,  2178,  2179,  2180,  2181,
    2182,  2183,  2184,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    41,    -1,    -1,    -1,    -1,    46,    -1,    48,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    -1,  2833,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,    -1,
      -1,  2845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2897,  2898,    -1,    -1,  2901,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   189,
      -1,    -1,  2374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2974,    -1,    -1,    -1,    -1,    -1,   226,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3023,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2462,   281,    -1,    -1,    -1,    -1,  3040,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2486,    -1,    -1,    -1,    -1,  3063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3071,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3080,  2509,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,
      -1,    -1,    -1,    -1,  3098,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2535,    -1,  2537,    -1,    -1,  2540,  2541,
    2542,  2543,  2544,  2545,  2546,  2547,  2548,  2549,    -1,  2551,
      -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3140,    -1,   388,  2571,
      -1,    -1,    -1,    -1,  2576,  2577,    -1,    -1,    -1,    -1,
     400,    -1,    -1,    -1,    -1,    -1,  2588,  2589,  2590,    -1,
    2592,   411,    -1,  2595,   414,   415,    -1,   417,    -1,   419,
      -1,    -1,    -1,   423,    -1,   425,   426,    -1,    -1,    -1,
     430,   431,   432,   433,   434,    -1,    -1,   437,   438,   439,
     440,    -1,   442,   443,   444,    -1,   446,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3228,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2665,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    41,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2754,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   189,
    2842,    -1,    -1,    -1,  2846,    -1,    -1,    -1,    -1,  2851,
    2852,    -1,  2854,    -1,    -1,  2857,    -1,    -1,   208,  2861,
    2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    2872,    -1,    -1,    -1,    -1,    -1,   226,    -1,    -1,    -1,
      -1,    -1,    -1,  2885,  2886,  2887,  2888,    -1,  2890,    -1,
      -1,    -1,  2894,  2895,  2896,    -1,    -1,  2899,    -1,    -1,
    2902,    -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2976,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   388,    -1,
    3042,    -1,    -1,    -1,    -1,    -1,    -1,  3049,    -1,  3051,
     400,    -1,  3054,  3055,    -1,    -1,    -1,  3059,  3060,  3061,
    3062,   411,  3064,    -1,   414,   415,    -1,   417,    -1,    -1,
      -1,    -1,    -1,   423,    -1,   425,   426,    -1,    -1,    -1,
     430,   431,   432,   433,   434,    -1,    -1,   437,   438,   439,
     440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3161,
    3162,  3163,    -1,    -1,  3166,  3167,  3168,    -1,  3170,    -1,
      -1,    -1,  3174,    -1,    -1,    -1,    -1,  3179,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,  3213,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,  3226,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,    -1,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,    -1,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
      -1,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,    -1,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,    -1,    -1,   417,    -1,    -1,     6,
       7,     8,    -1,    -1,    11,    12,    -1,    14,    15,    16,
      -1,    -1,    -1,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,   443,    30,    31,    32,    -1,    -1,    -1,    36,
      37,    38,    39,    -1,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
     107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,    -1,
      -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,   185,    -1,
      -1,    -1,   189,    -1,    -1,    -1,    -1,   194,    -1,   196,
      -1,    -1,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,
      -1,    -1,   209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   220,   221,    -1,    -1,    -1,    -1,    -1,
     227,    -1,   229,    -1,    -1,   232,   233,    -1,   235,    -1,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,    -1,
      -1,    -1,   279,    -1,    -1,   282,   283,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,    -1,    -1,    -1,    -1,   304,   305,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   330,    -1,    -1,   333,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     347,    -1,    -1,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   373,   374,    -1,    -1,
      -1,    -1,   379,    -1,   381,    -1,    -1,    -1,    -1,    -1,
      -1,   388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   400,    -1,   402,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,    -1,   414,    11,    12,
     417,    14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      -1,    -1,    -1,    36,    37,    38,    39,   444,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,   107,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,
      -1,    -1,   185,    -1,    -1,    -1,   189,    -1,    -1,    -1,
      -1,   194,    -1,   196,    -1,    -1,    -1,    -1,    -1,   202,
      -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,
      -1,    -1,    -1,    -1,   227,    -1,   229,    -1,    -1,   232,
     233,    -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   274,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
     283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,    -1,    -1,    -1,
      -1,   304,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   316,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   330,    -1,    -1,
     333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   347,    -1,    -1,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     373,   374,    -1,    -1,    -1,    -1,   379,    -1,   381,    -1,
      -1,    -1,    -1,    -1,    -1,   388,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,   402,
      -1,    -1,    -1,    -1,     3,    -1,    -1,     6,     7,     8,
       9,   414,    11,    12,   417,    14,    15,    16,    17,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,   444,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,
      89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,   100,    -1,    -1,   103,   104,   105,   106,   107,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,   121,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,    -1,    -1,    -1,    -1,   135,   136,   137,    -1,
      -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   150,    -1,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,
      -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,   194,    -1,   196,    -1,   198,
      -1,   200,    -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,
     209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   220,   221,    -1,    -1,   224,    -1,    -1,   227,    -1,
     229,    -1,    -1,   232,   233,    -1,   235,    -1,    -1,    -1,
      -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,   248,
      -1,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   274,    -1,    -1,    -1,   278,
     279,    -1,    -1,   282,   283,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,    -1,    -1,    -1,    -1,   304,   305,    -1,   307,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,    -1,
     319,    -1,   321,    -1,    -1,    -1,   325,    -1,    -1,    -1,
     329,   330,    -1,   332,   333,    -1,    -1,   336,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,   346,   347,    -1,
     349,   350,    -1,   352,    -1,    -1,   355,    -1,    -1,    -1,
      -1,    -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   373,   374,    -1,    -1,    -1,    -1,
     379,    -1,   381,    -1,   383,    -1,   385,    -1,    -1,   388,
      -1,    -1,   391,    -1,   393,    -1,    -1,   396,    -1,    -1,
      -1,   400,    -1,   402,    -1,    -1,    -1,    -1,    -1,    -1,
       5,     6,     7,     8,     9,   414,    11,    12,   417,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
     439,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    -1,    -1,    -1,    93,    -1,
      -1,    96,    97,    -1,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,    -1,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,   166,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,    -1,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,   209,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,   220,   221,    -1,   223,   224,
     225,   226,   227,    -1,   229,    -1,    -1,   232,   233,   234,
     235,   236,   237,   238,   239,   240,    -1,   242,   243,   244,
     245,    -1,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,    -1,    -1,   288,   289,    -1,    -1,   292,   293,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,   389,   390,   391,   392,   393,   394,
      -1,   396,   397,    -1,   399,   400,   401,   402,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,   417,   418,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,    -1,    -1,   430,   431,   432,    -1,    -1,
      -1,    -1,    -1,    -1,   439,   440,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
      -1,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,    -1,   133,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,   157,    -1,
     159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,
     169,   170,   171,    -1,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,    -1,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,    -1,   201,   202,    -1,   204,    -1,   206,   207,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,   217,   218,
      -1,   220,   221,    -1,   223,   224,   225,   226,   227,    -1,
     229,    -1,    -1,   232,   233,   234,   235,   236,   237,   238,
     239,   240,    -1,   242,   243,   244,   245,    -1,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,    -1,    -1,   288,
     289,    -1,    -1,   292,   293,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,    -1,   368,
     369,   370,   371,    -1,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
     389,   390,   391,   392,   393,   394,    -1,   396,   397,    -1,
     399,   400,   401,   402,   403,    -1,    -1,    -1,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,    -1,
      -1,   430,   431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     439,   440,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,    -1,   110,   111,    -1,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,    -1,   136,    -1,   138,   139,   140,   141,   142,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,   189,    -1,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,   204,    -1,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,    -1,   220,   221,    -1,
     223,   224,   225,   226,   227,    -1,   229,    -1,    -1,   232,
     233,   234,   235,   236,   237,   238,   239,   240,    -1,    -1,
     243,   244,   245,    -1,   247,   248,   249,    -1,    -1,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,    -1,   267,   268,   269,   270,   271,   272,
     273,    -1,   275,    -1,   277,   278,   279,   280,    -1,    -1,
     283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,
     293,    -1,    -1,   296,   297,   298,    -1,   300,   301,   302,
      -1,    -1,    -1,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,    -1,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,    -1,   380,    -1,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,    -1,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,    -1,    -1,   417,    -1,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   440,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
     395,   396,   397,    -1,   399,   400,   401,    -1,   403,     5,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
      -1,    -1,   417,    -1,    20,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   437,    -1,    40,    41,   441,    -1,    -1,    -1,
      -1,    -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     226,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   281,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,   414,   415,
      -1,   417,    -1,    -1,    -1,    -1,    -1,   423,    -1,   425,
     426,    -1,    -1,    -1,   430,   431,   432,   433,   434,    -1,
      -1,   437,   438,   439,   440,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
      -1,   191,    -1,   193,   194,   195,   196,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
     220,   221,    -1,   223,   224,   225,   226,   227,    -1,   229,
      -1,    -1,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    -1,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,    -1,   288,   289,
      -1,    -1,   292,   293,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,   391,   392,   393,   394,    -1,   396,   397,    -1,   399,
     400,   401,   402,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,   415,   416,   417,   418,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,    -1,    -1,
     430,   431,    -1,    -1,     5,     6,     7,     8,     9,   439,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    -1,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,    -1,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,    -1,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,    -1,
     201,   202,    -1,   204,    -1,   206,   207,   208,   209,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,   220,
     221,    -1,   223,   224,   225,   226,   227,    -1,   229,    -1,
      -1,   232,   233,   234,   235,   236,   237,   238,   239,   240,
      -1,   242,   243,   244,   245,    -1,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,    -1,   288,   289,    -1,
      -1,   292,   293,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,   389,   390,
     391,   392,   393,   394,    -1,   396,   397,    -1,   399,   400,
     401,   402,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,   417,   418,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,
     431,   432,    -1,     5,     6,     7,     8,     9,   439,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    96,    97,    -1,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,    -1,   110,   111,
      -1,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,    -1,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,   220,   221,
      -1,   223,   224,   225,   226,   227,    -1,   229,    -1,    -1,
     232,   233,   234,   235,   236,   237,   238,   239,   240,    -1,
     242,   243,   244,   245,    -1,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,
     292,   293,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,   389,   390,   391,
     392,   393,   394,    -1,   396,   397,    -1,   399,   400,   401,
     402,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,   415,   416,   417,   418,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,   431,
      -1,    -1,     5,     6,     7,     8,     9,   439,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    -1,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,    -1,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,    -1,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,   209,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,   220,   221,    -1,
     223,   224,   225,   226,   227,    -1,   229,    -1,    -1,   232,
     233,   234,   235,   236,   237,   238,   239,   240,    -1,   242,
     243,   244,   245,    -1,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,   292,
     293,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,   394,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,   417,   418,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,    -1,    -1,   430,   431,    -1,
      -1,     5,     6,     7,     8,     9,   439,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      -1,    -1,    96,    97,    -1,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,    -1,   110,   111,    -1,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,    -1,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,   220,   221,    -1,   223,
     224,   225,   226,   227,    -1,   229,    -1,    -1,   232,   233,
     234,   235,   236,   237,   238,   239,   240,    -1,   242,   243,
     244,   245,    -1,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,    -1,    -1,   288,   289,    -1,    -1,   292,   293,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,   389,   390,   391,   392,   393,
     394,    -1,   396,   397,    -1,   399,   400,   401,   402,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,   415,   416,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,    -1,    -1,   430,   431,    -1,    -1,
      -1,    -1,    -1,   437,    -1,   439,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
      -1,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,    -1,   133,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,    -1,
     159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,
     169,   170,   171,    -1,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,    -1,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,    -1,   201,   202,    -1,   204,    -1,   206,   207,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,   217,   218,
      -1,   220,   221,    -1,   223,   224,   225,   226,   227,    -1,
     229,    -1,    -1,   232,   233,   234,   235,   236,   237,   238,
     239,   240,    -1,   242,   243,   244,   245,    -1,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,    -1,    -1,   288,
     289,    -1,    -1,   292,   293,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,    -1,   368,
     369,   370,   371,    -1,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
     389,   390,   391,   392,   393,   394,    -1,   396,   397,    -1,
     399,   400,   401,   402,   403,    -1,    -1,    -1,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,    -1,
      -1,   430,   431,    -1,    -1,     5,     6,     7,     8,     9,
     439,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,    -1,
     110,   111,    -1,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
      -1,   191,    -1,   193,   194,   195,   196,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
     220,   221,    -1,   223,   224,   225,   226,   227,    -1,   229,
      -1,    -1,   232,   233,   234,   235,   236,   237,   238,   239,
     240,    -1,   242,   243,   244,   245,    -1,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,    -1,   288,   289,
      -1,    -1,   292,   293,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,   391,   392,   393,   394,    -1,   396,   397,    -1,   399,
     400,   401,   402,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,   415,   416,   417,   418,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,    -1,    -1,
     430,   431,    -1,    -1,     5,     6,     7,     8,     9,   439,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    -1,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,    -1,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,    -1,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,    -1,
     201,   202,    -1,   204,    -1,   206,   207,   208,   209,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,   220,
     221,    -1,   223,   224,   225,   226,   227,    -1,   229,    -1,
      -1,   232,   233,   234,   235,   236,   237,   238,   239,   240,
      -1,   242,   243,   244,   245,    -1,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,    -1,   288,   289,    -1,
      -1,   292,   293,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,   389,   390,
     391,   392,   393,   394,    -1,   396,   397,    -1,   399,   400,
     401,   402,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,   417,   418,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,
     431,    -1,    -1,     5,     6,     7,     8,     9,   439,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    96,    97,    -1,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,    -1,   110,   111,
      -1,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,    -1,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,   220,   221,
      -1,   223,   224,   225,   226,   227,    -1,   229,    -1,    -1,
     232,   233,   234,   235,   236,   237,   238,   239,   240,    -1,
     242,   243,   244,   245,    -1,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,
     292,   293,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,   389,   390,   391,
     392,   393,   394,    -1,   396,   397,    -1,   399,   400,   401,
     402,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,   415,   416,   417,   418,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,   431,
      -1,    -1,     5,     6,     7,     8,     9,   439,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    -1,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,    -1,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,    -1,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,   209,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,   220,   221,    -1,
     223,   224,   225,   226,   227,    -1,   229,    -1,    -1,   232,
     233,   234,   235,   236,   237,   238,   239,   240,    -1,   242,
     243,   244,   245,    -1,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,   292,
     293,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,   417,   418,    -1,    -1,   421,   422,
     423,   424,   425,     5,     6,     7,     8,     9,   431,    11,
      12,    -1,    14,    15,    16,    17,   439,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    96,    97,    -1,    99,   100,   101,
     102,   103,    -1,   105,   106,   107,   108,    -1,   110,   111,
      -1,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,    -1,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,    -1,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,   220,   221,
      -1,   223,   224,   225,   226,   227,    -1,   229,    -1,    -1,
     232,   233,   234,   235,   236,   237,   238,   239,   240,    -1,
     242,   243,   244,    -1,    -1,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,   279,   280,   281,
     282,   283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,
     292,   293,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,   389,   390,   391,
     392,   393,   394,    -1,   396,   397,    -1,   399,   400,   401,
     402,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,   415,   416,   417,   418,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,   431,
      -1,    -1,     5,     6,     7,     8,     9,   439,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    -1,    99,   100,   101,   102,
     103,    -1,   105,   106,   107,   108,    -1,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,    -1,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,    -1,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,    -1,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,   220,   221,    -1,
     223,   224,   225,   226,   227,    -1,   229,    -1,    -1,   232,
     233,   234,   235,   236,   237,   238,   239,   240,    -1,   242,
     243,   244,    -1,    -1,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,    -1,
     293,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,    -1,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,    -1,    -1,   421,   422,
     423,   424,   425,    -1,     6,     7,     8,     9,   431,    11,
      12,    -1,    14,    15,    16,    17,   439,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    94,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,   246,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,    -1,    -1,    -1,
     292,   293,    -1,   295,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,    -1,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   440,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,   220,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,   232,   233,
     234,   235,   236,   237,   238,   239,   240,    -1,   242,   243,
     244,   245,    -1,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,   279,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,   289,    -1,   291,   292,   293,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
     394,    -1,   396,   397,    -1,   399,   400,   401,   402,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   439,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,    -1,   110,   111,    -1,   113,    -1,   115,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,    -1,   133,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
     157,    -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,
      -1,   168,   169,   170,   171,    -1,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
     187,   188,   189,    -1,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,
     207,   208,   209,   210,   211,   212,    -1,   214,   215,   216,
     217,   218,    -1,   220,   221,    -1,   223,   224,   225,    -1,
     227,    -1,   229,    -1,    -1,   232,   233,   234,   235,   236,
     237,   238,   239,   240,    -1,   242,   243,   244,   245,    -1,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,    -1,   282,   283,   284,   285,    -1,
      -1,   288,   289,    -1,   291,   292,   293,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,    -1,   304,   305,   306,
     307,   308,    -1,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
      -1,   368,   369,   370,   371,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,   396,
     397,    -1,   399,   400,   401,   402,   403,    -1,    -1,    -1,
     407,   408,   409,   410,   411,   412,    -1,   414,    -1,    -1,
     417,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   439,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
     220,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,   232,   233,   234,   235,   236,   237,   238,   239,
     240,    -1,   242,   243,   244,   245,    -1,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,   279,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,   289,
      -1,    -1,   292,   293,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,   394,    -1,   396,   397,    -1,   399,
     400,   401,   402,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   439,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,
     103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,    -1,   142,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,    -1,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,    -1,   221,    -1,
     223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,
      -1,   234,    -1,   236,   237,   238,   239,   240,    -1,   242,
      -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,    -1,   265,    -1,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,    -1,   280,    -1,   282,
     283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,
     293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,   348,   349,    -1,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,    -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,    -1,    -1,    -1,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   438,   439,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      99,    -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,
      -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,    -1,   133,   134,   135,   136,    -1,   138,
     139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,   157,    -1,
     159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,
     169,   170,   171,    -1,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,    -1,   187,   188,
     189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,   202,    -1,   204,    -1,   206,   207,   208,
      -1,   210,   211,   212,    -1,   214,   215,   216,   217,   218,
      -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,
     229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,
     239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,
     249,    -1,    -1,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,    -1,   265,    -1,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
      -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,   288,
      -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,   344,    -1,   346,   347,   348,
     349,    -1,   351,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,    -1,   368,
     369,   370,   371,    -1,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,    -1,    -1,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
      -1,    -1,    -1,    -1,   423,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     439,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,   289,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   439,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,
     103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,    -1,   142,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,    -1,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,    -1,   221,    -1,
     223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,
      -1,   234,    -1,   236,   237,   238,   239,   240,    -1,   242,
      -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,    -1,   265,    -1,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,    -1,   280,    -1,   282,
     283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,
     293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,   342,
     343,   344,    -1,   346,   347,   348,   349,    -1,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,    -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,    -1,    -1,   417,   418,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   439,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   439,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      99,    -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,
      -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,    -1,   133,   134,   135,   136,    -1,   138,
     139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,   157,    -1,
     159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,
     169,   170,   171,    -1,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,    -1,   187,   188,
     189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,   202,    -1,   204,    -1,   206,   207,   208,
      -1,   210,   211,   212,    -1,   214,   215,   216,   217,   218,
      -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,
     229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,
     239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,
     249,    -1,    -1,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,    -1,   265,    -1,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
      -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,   288,
      -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,   344,    -1,   346,   347,   348,
     349,    -1,   351,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,    -1,   368,
     369,   370,   371,    -1,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,    -1,    -1,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     439,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,    -1,    -1,    -1,    -1,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   439,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
      -1,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
      -1,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,    -1,    -1,   223,   224,
     225,   226,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,    -1,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,    -1,
     275,    -1,   277,   278,    -1,   280,    -1,    -1,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,    -1,    -1,    -1,    -1,   300,   301,   302,    -1,    -1,
      -1,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,    -1,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,    -1,   380,    -1,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,   417,   418,    -1,    -1,    -1,    -1,   423,    -1,
     425,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
      -1,   416,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
      -1,   416,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   426,   427,   428,    -1,   430,   431,   432,   433,   434,
     435,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,   111,    -1,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,    -1,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,    -1,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,    -1,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
      -1,   405,   406,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,   432,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,    -1,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,    -1,    -1,   223,   224,   225,   226,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,    -1,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,    -1,   267,   268,   269,
     270,   271,   272,   273,    -1,   275,    -1,   277,   278,    -1,
     280,    -1,    -1,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,   292,   293,    -1,    -1,    -1,    -1,    -1,    -1,
     300,   301,   302,    -1,    -1,    -1,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,    -1,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,    -1,
     380,    -1,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,   432,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,   289,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,   432,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
     286,    -1,   288,    -1,   290,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,    -1,    -1,    -1,    -1,   423,    -1,   425,
      -1,     6,     7,     8,     9,   431,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,   286,    -1,   288,    -1,   290,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,    -1,    -1,    -1,    -1,   423,    -1,
     425,    -1,     6,     7,     8,     9,   431,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,   213,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,   418,     6,     7,     8,     9,   423,
      11,    12,    -1,    14,    15,    16,    17,   431,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,
     101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,
     111,    -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,   135,   136,    -1,   138,   139,   140,
      -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,   187,   188,   189,    -1,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,   202,    -1,   204,    -1,   206,   207,   208,    -1,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,    -1,
     221,    -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,
      -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,   240,
      -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,    -1,   265,    -1,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,    -1,   280,
      -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,
      -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,    -1,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,   348,   349,    -1,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,    -1,    -1,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,    -1,    -1,   417,   418,     6,     7,
       8,     9,   423,    11,    12,    -1,    14,    15,    16,    17,
     431,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,    -1,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,    -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,     6,     7,     8,     9,    -1,    11,    12,   426,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,    -1,    -1,   421,   422,   423,    -1,
     425,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
      -1,    -1,   417,    -1,     4,   420,     6,     7,     8,     9,
      10,    11,    12,    -1,    14,    15,    16,    17,    18,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,    -1,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,    -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    39,    -1,    41,    -1,    43,    44,    45,    46,    47,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,   107,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     118,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,    -1,    -1,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   153,   154,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   182,    -1,    -1,   185,    -1,    -1,
      -1,   189,    -1,    -1,    -1,    -1,   194,    -1,   196,    -1,
      -1,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,
      -1,   209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   220,   221,    -1,    -1,    -1,    -1,    -1,   227,
      -1,   229,    -1,    -1,   232,   233,    -1,   235,    -1,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   263,   264,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,    -1,    -1,
      -1,   279,    -1,    -1,   282,   283,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,    -1,    -1,    -1,    -1,   304,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   330,    -1,    -1,   333,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,
      -1,    -1,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   373,   374,    -1,    -1,    -1,
      -1,   379,    -1,   381,    -1,    -1,    -1,    -1,    -1,    -1,
     388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,   402,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   414,    -1,    -1,   417,
      -1,   419,     6,     7,     8,    -1,    -1,    11,    12,    -1,
      14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    -1,
      -1,    -1,    36,    37,    38,    39,    -1,    41,    -1,    43,
      44,    45,    46,    47,    48,    49,    50,    -1,    -1,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,   107,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   135,    -1,    -1,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   153,
     154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,
      -1,   185,    -1,    -1,    -1,   189,    -1,    -1,    -1,    -1,
     194,    -1,   196,    -1,    -1,    -1,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,
      -1,    -1,    -1,   227,    -1,   229,    -1,    -1,   232,   233,
      -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,
     264,   265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     274,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,   283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,    -1,    -1,    -1,    -1,
     304,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   330,    -1,    -1,   333,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   347,    -1,    -1,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,
     374,    -1,    -1,    -1,    -1,   379,    -1,   381,    -1,    -1,
      -1,    -1,    -1,    -1,   388,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,   402,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     414,    -1,    -1,   417,    -1,   419,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,    -1,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,    -1,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,    -1,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,    -1,    -1,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,    -1,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,    -1,
     136,    -1,   138,   139,   140,   141,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,    -1,
      -1,   187,   188,   189,    -1,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,   204,    -1,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,    -1,   220,   221,    -1,   223,   224,   225,
     226,   227,    -1,   229,    -1,    -1,   232,   233,   234,   235,
     236,   237,   238,   239,   240,    -1,    -1,   243,   244,   245,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,    -1,   275,
      -1,   277,   278,   279,   280,    -1,    -1,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,   297,   298,    -1,   300,   301,   302,    -1,    -1,    -1,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,    -1,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,    -1,   380,    -1,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,   402,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,    -1,   110,   111,    -1,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,    -1,   136,    -1,   138,   139,   140,   141,   142,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,   189,    -1,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,   204,    -1,   206,   207,   208,   209,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,   220,    -1,    -1,
     223,   224,   225,   226,   227,    -1,   229,    -1,    -1,   232,
     233,   234,   235,   236,   237,   238,   239,   240,    -1,    -1,
     243,   244,   245,    -1,   247,   248,   249,    -1,    -1,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,    -1,   267,   268,   269,   270,   271,   272,
     273,    -1,   275,    -1,   277,   278,   279,   280,    -1,    -1,
     283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,
     293,    -1,    -1,    -1,   297,   298,    -1,   300,   301,   302,
      -1,    -1,    -1,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,    -1,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,    -1,   380,    -1,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,    -1,    -1,   396,   397,    -1,   399,   400,   401,   402,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,    -1,    -1,   417,     6,     7,     8,     9,    -1,
      11,    12,    13,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,
     101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,
     111,    -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,   135,   136,    -1,   138,   139,   140,
      -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,   187,   188,   189,    -1,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,   202,    -1,   204,    -1,   206,   207,   208,    -1,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,    -1,
     221,    -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,
      -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,   240,
      -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,    -1,   265,    -1,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,    -1,   280,
      -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,
      -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,    -1,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,   348,   349,    -1,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,    -1,    -1,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,    -1,   417,   418,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    42,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,   289,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
     418,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
     135,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,   221,    -1,   223,   224,
     225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,   274,
     275,    -1,   277,   278,    -1,   280,    -1,   282,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,   304,
     305,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      99,    -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,
      -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,    -1,   133,   134,   135,   136,    -1,   138,
     139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,    -1,
     159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,
     169,   170,   171,    -1,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,    -1,   187,   188,
     189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,   202,    -1,   204,    -1,   206,   207,   208,
      -1,   210,   211,   212,    -1,   214,   215,   216,   217,   218,
      -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,
     229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,
     239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,
     249,    -1,    -1,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,    -1,   265,    -1,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
      -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,   288,
      -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,
     299,   300,   301,   302,    -1,   304,   305,   306,   307,   308,
      -1,   310,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,    -1,   342,   343,   344,    -1,   346,   347,   348,
     349,    -1,   351,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,    -1,   368,
     369,   370,   371,    -1,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,    -1,    -1,   396,   397,    -1,
     399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,
     103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,    -1,
     133,   134,   135,   136,    -1,   138,   139,   140,    -1,   142,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,   157,    -1,   159,    -1,   161,   162,
     163,    -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,
      -1,   204,    -1,   206,   207,   208,    -1,   210,   211,   212,
      -1,   214,   215,   216,   217,   218,    -1,    -1,   221,    -1,
     223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,
      -1,   234,    -1,   236,   237,   238,   239,   240,    -1,   242,
      -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,    -1,   265,    -1,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,    -1,   280,    -1,   282,
     283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,
     293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,
      -1,   304,   305,   306,   307,   308,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,    -1,   342,
     343,   344,    -1,   346,   347,   348,   349,    -1,   351,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,    -1,   368,   369,   370,   371,    -1,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,    -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,
     403,    -1,    -1,    -1,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    18,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,    -1,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,   418,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,
     107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,    -1,   133,   134,   135,   136,
      -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,
      -1,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
     157,    -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,
      -1,   168,   169,   170,   171,    -1,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
     187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,
     207,   208,    -1,   210,   211,   212,    -1,   214,   215,   216,
     217,   218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,
     227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,
     237,   238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,
     247,   248,   249,    -1,    -1,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,    -1,   265,    -1,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,    -1,   280,    -1,   282,   283,   284,   285,    -1,
      -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,   296,
      -1,    -1,   299,   300,   301,   302,    -1,   304,   305,   306,
     307,   308,    -1,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,    -1,   331,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,    -1,   342,   343,   344,    -1,   346,
     347,   348,   349,    -1,   351,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
      -1,   368,   369,   370,   371,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,
     397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,
     407,   408,   409,   410,   411,   412,    -1,   414,    -1,    -1,
     417,   418,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,   418,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,
     101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,
     111,    -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,   135,   136,    -1,   138,   139,   140,
      -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,   187,   188,   189,    -1,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,   202,    -1,   204,    -1,   206,   207,   208,    -1,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,    -1,
     221,    -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,
      -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,   240,
      -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,    -1,   265,    -1,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,    -1,   280,
      -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,
      -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,
     301,   302,    -1,   304,   305,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,    -1,
     331,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,   348,   349,    -1,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,    -1,    -1,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,    -1,    -1,   417,   418,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,   129,   130,   131,    -1,   133,   134,    -1,   136,
      -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,
      -1,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
     157,    -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,
      -1,   168,   169,   170,   171,    -1,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,    -1,   204,    -1,   206,
     207,   208,    -1,   210,   211,   212,   213,   214,   215,   216,
     217,   218,    -1,    -1,   221,    -1,   223,   224,   225,   226,
     227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,
     237,   238,   239,   240,    -1,    -1,    -1,   244,    -1,    -1,
     247,   248,   249,    -1,    -1,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,    -1,   265,    -1,
     267,   268,   269,   270,   271,   272,   273,    -1,   275,    -1,
     277,   278,    -1,   280,    -1,    -1,   283,   284,   285,    -1,
      -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,   296,
      -1,    -1,    -1,   300,   301,   302,    -1,    -1,    -1,   306,
     307,   308,    -1,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,    -1,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,    -1,    -1,   342,   343,   344,    -1,   346,
     347,   348,   349,    -1,   351,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,    -1,   363,    -1,   365,   366,
      -1,   368,   369,   370,   371,    -1,   373,   374,    -1,   376,
      -1,   378,    -1,   380,    -1,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,
     397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,
     407,   408,   409,   410,   411,   412,    -1,   414,    -1,    -1,
     417,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,    -1,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,    -1,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,    -1,    -1,   223,
     224,   225,   226,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,    -1,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,    -1,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,    -1,    -1,    -1,    -1,   300,   301,   302,    -1,
      -1,    -1,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,    -1,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,    -1,   380,    -1,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,
     101,   102,   103,    -1,   105,    -1,   107,   108,    -1,   110,
     111,    -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,    -1,   133,   134,    -1,   136,    -1,   138,   139,   140,
      -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,   157,    -1,   159,    -1,
     161,   162,   163,    -1,   165,    -1,    -1,   168,   169,   170,
     171,    -1,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,   189,    -1,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,    -1,   204,    -1,   206,   207,   208,    -1,   210,
     211,   212,    -1,   214,   215,   216,   217,   218,    -1,    -1,
      -1,    -1,   223,   224,   225,   226,   227,    -1,   229,    -1,
      -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,   240,
      -1,    -1,    -1,   244,    -1,    -1,   247,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,    -1,   265,    -1,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,    -1,   280,
      -1,    -1,   283,   284,   285,    -1,    -1,   288,    -1,    -1,
      -1,   292,   293,    -1,    -1,    -1,    -1,    -1,    -1,   300,
     301,   302,    -1,    -1,    -1,   306,   307,   308,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,    -1,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,    -1,
      -1,   342,   343,   344,    -1,   346,   347,   348,   349,    -1,
     351,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,    -1,   363,    -1,   365,   366,    -1,   368,   369,   370,
     371,    -1,   373,   374,    -1,   376,    -1,   378,    -1,   380,
      -1,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,    -1,    -1,   396,   397,    -1,   399,   400,
     401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,
     411,   412,    -1,   414,    -1,    -1,   417,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
     108,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,    -1,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,    -1,    -1,   223,   224,   225,   226,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,    -1,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,    -1,   267,
     268,   269,   270,   271,   272,   273,    -1,   275,    -1,   277,
     278,    -1,   280,   281,    -1,   283,   284,   285,    -1,    -1,
     288,    -1,    -1,    -1,   292,   293,    -1,    -1,    -1,    -1,
      -1,    -1,   300,   301,   302,    -1,    -1,    -1,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,    -1,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,    -1,   380,    -1,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    99,    -1,   101,   102,   103,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
      -1,    -1,    -1,   128,   129,   130,   131,    -1,   133,   134,
      -1,   136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,
     165,    -1,    -1,   168,   169,   170,   171,    -1,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,    -1,   204,
      -1,   206,   207,   208,    -1,   210,   211,   212,    -1,   214,
     215,   216,   217,   218,    -1,    -1,    -1,    -1,   223,   224,
     225,   226,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,
      -1,   236,   237,   238,   239,   240,    -1,    -1,    -1,   244,
      -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,    -1,
     265,    -1,   267,   268,   269,   270,   271,   272,   273,    -1,
     275,    -1,   277,   278,    -1,   280,    -1,    -1,   283,   284,
     285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,
      -1,    -1,    -1,    -1,    -1,   300,   301,   302,    -1,    -1,
      -1,   306,   307,   308,    -1,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    -1,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,    -1,    -1,   342,   343,   344,
      -1,   346,   347,   348,   349,    -1,   351,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,    -1,   363,    -1,
     365,   366,    -1,   368,   369,   370,   371,    -1,   373,   374,
      -1,   376,    -1,   378,    -1,   380,    -1,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,    -1,
      -1,   396,   397,    -1,   399,   400,   401,    -1,   403,    -1,
      -1,    -1,   407,   408,   409,   410,   411,   412,    -1,   414,
      -1,    -1,   417,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,   108,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,    -1,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,    -1,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,    -1,
      -1,   223,   224,   225,   226,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
      -1,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,    -1,   275,    -1,   277,   278,    -1,   280,    -1,
      -1,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,    -1,    -1,    -1,    -1,   300,   301,
     302,    -1,    -1,    -1,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,    -1,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
      -1,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,    -1,   380,    -1,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,   111,    -1,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,   153,   154,   155,   156,   157,   158,   159,
      -1,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,    -1,   199,
     200,   201,   202,   203,   204,   205,   206,   207,    -1,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,   225,    -1,   227,   228,   229,
     230,    -1,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,    -1,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,   391,   392,   393,   394,   395,   396,   397,    -1,   399,
     400,   401,   402,   403,    -1,   405,   406,   407,   408,   409,
     410,    -1,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,   220,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,   232,   233,   234,   235,   236,   237,
     238,   239,   240,    -1,   242,   243,   244,   245,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,   279,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,   289,    -1,    -1,   292,   293,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,   402,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,   192,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,   245,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,   200,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    89,
      90,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,   289,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,   289,    -1,   291,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,   289,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,   289,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,   213,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,    -1,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,    -1,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,    -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,   394,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,   394,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,    -1,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,    -1,   368,   369,   370,   371,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,    -1,    -1,   396,   397,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,    -1,   407,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,   102,   103,    -1,   105,    -1,   107,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,    -1,   133,   134,   135,   136,    -1,   138,   139,
     140,    -1,   142,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,    -1,   159,
      -1,   161,   162,   163,    -1,   165,    -1,    -1,   168,   169,
     170,   171,    -1,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
      -1,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,   202,    -1,   204,    -1,   206,   207,   208,    -1,
     210,   211,   212,    -1,   214,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,   225,    -1,   227,    -1,   229,
      -1,    -1,    -1,    -1,   234,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,   244,    -1,    -1,   247,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,    -1,   265,    -1,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,    -1,
     280,    -1,   282,   283,   284,   285,    -1,    -1,   288,    -1,
      -1,    -1,   292,   293,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,    -1,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,    -1,   342,   343,   344,    -1,   346,   347,   348,   349,
      -1,   351,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,    -1,   368,   369,
     370,   371,    -1,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,   386,   387,    -1,    -1,
     390,   391,   392,   393,    -1,    -1,   396,   397,    -1,   399,
     400,   401,    -1,   403,    -1,    -1,    -1,   407,   408,   409,
     410,   411,   412,    -1,   414,    -1,    -1,   417,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,   100,   101,   102,   103,    -1,   105,    -1,   107,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,    -1,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
      -1,   159,    -1,   161,   162,   163,    -1,   165,    -1,    -1,
     168,   169,   170,   171,    -1,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,   202,    -1,   204,    -1,   206,   207,
     208,    -1,   210,   211,   212,    -1,   214,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,   225,    -1,   227,
      -1,   229,    -1,    -1,    -1,    -1,   234,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,   244,    -1,    -1,   247,
     248,   249,    -1,    -1,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,    -1,   265,    -1,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,    -1,   280,    -1,   282,   283,   284,   285,    -1,    -1,
     288,    -1,    -1,    -1,   292,   293,    -1,    -1,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,    -1,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,    -1,   342,   343,   344,    -1,   346,   347,
     348,   349,    -1,   351,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,    -1,
     368,   369,   370,   371,    -1,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,   386,   387,
      -1,    -1,   390,   391,   392,   393,    -1,    -1,   396,   397,
      -1,   399,   400,   401,    -1,   403,    -1,    -1,    -1,   407,
     408,   409,   410,   411,   412,    -1,   414,    -1,    -1,   417,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    94,    -1,
      96,    97,    -1,    99,    -1,   101,   102,   103,    -1,   105,
      -1,   107,    -1,    -1,   110,   111,    -1,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,    -1,   133,   134,   135,
     136,    -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,   157,    -1,   159,    -1,   161,   162,   163,    -1,   165,
      -1,    -1,   168,   169,   170,   171,    -1,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,    -1,   191,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,   202,    -1,   204,    -1,
     206,   207,   208,    -1,   210,   211,   212,    -1,   214,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,   225,
      -1,   227,    -1,   229,    -1,    -1,    -1,    -1,   234,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,   244,    -1,
      -1,   247,   248,   249,    -1,    -1,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,    -1,   265,
      -1,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,    -1,   280,    -1,   282,   283,   284,   285,
      -1,    -1,   288,    -1,    -1,    -1,   292,   293,    -1,    -1,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,    -1,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,    -1,   342,   343,   344,    -1,
     346,   347,   348,   349,    -1,   351,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,    -1,   368,   369,   370,   371,    -1,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
     386,   387,    -1,    -1,   390,   391,   392,   393,    -1,    -1,
     396,   397,    -1,   399,   400,   401,    -1,   403,    -1,    -1,
      -1,   407,   408,   409,   410,   411,   412,    -1,   414,    -1,
      -1,   417,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      94,    -1,    96,    97,    -1,    99,    -1,   101,   102,   103,
      -1,   105,    -1,   107,    -1,    -1,   110,   111,    -1,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,    -1,   133,
     134,   135,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,    -1,   161,   162,   163,
      -1,   165,    -1,    -1,   168,   169,   170,   171,    -1,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,   197,    -1,   199,    -1,   201,   202,    -1,
     204,    -1,   206,   207,   208,    -1,   210,   211,   212,    -1,
     214,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,   225,    -1,   227,    -1,   229,    -1,    -1,    -1,    -1,
     234,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
     244,    -1,    -1,   247,   248,   249,    -1,    -1,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
      -1,   265,    -1,   267,   268,   269,   270,   271,   272,   273,
     274,   275,    -1,   277,   278,    -1,   280,    -1,   282,   283,
     284,   285,    -1,    -1,   288,    -1,    -1,    -1,   292,   293,
      -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,    -1,   342,   343,
     344,    -1,   346,   347,   348,   349,    -1,   351,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,    -1,   368,   369,   370,   371,    -1,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,   390,   391,   392,   393,
      -1,    -1,   396,   397,    -1,   399,   400,   401,    -1,   403,
      -1,    -1,    -1,   407,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    99,    -1,   101,
     102,   103,    -1,   105,    -1,   107,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
      -1,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,   157,    -1,   159,    -1,   161,
     162,   163,    -1,   165,    -1,    -1,   168,   169,   170,   171,
      -1,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,    -1,   191,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
     202,   203,   204,    -1,   206,   207,   208,    -1,   210,   211,
     212,    -1,   214,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,   225,    -1,   227,    -1,   229,    -1,    -1,
      -1,    -1,   234,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,   244,    -1,    -1,   247,   248,   249,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,    -1,   265,    -1,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,    -1,   280,    -1,
     282,   283,   284,   285,    -1,    -1,   288,    -1,    -1,    -1,
     292,   293,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,    -1,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,    -1,
     342,   343,   344,    -1,   346,   347,   348,   349,    -1,   351,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362, 