/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_DATA = 267,
     SQL_DATETIME_INTERVAL_CODE = 268,
     SQL_DATETIME_INTERVAL_PRECISION = 269,
     SQL_DESCRIBE = 270,
     SQL_DESCRIPTOR = 271,
     SQL_DISCONNECT = 272,
     SQL_FOUND = 273,
     SQL_FREE = 274,
     SQL_GO = 275,
     SQL_GOTO = 276,
     SQL_IDENTIFIED = 277,
     SQL_INDICATOR = 278,
     SQL_KEY_MEMBER = 279,
     SQL_LENGTH = 280,
     SQL_LONG = 281,
     SQL_NULLABLE = 282,
     SQL_OCTET_LENGTH = 283,
     SQL_OPEN = 284,
     SQL_OUTPUT = 285,
     SQL_REFERENCE = 286,
     SQL_RETURNED_LENGTH = 287,
     SQL_RETURNED_OCTET_LENGTH = 288,
     SQL_SCALE = 289,
     SQL_SECTION = 290,
     SQL_SHORT = 291,
     SQL_SIGNED = 292,
     SQL_SQL = 293,
     SQL_SQLERROR = 294,
     SQL_SQLPRINT = 295,
     SQL_SQLWARNING = 296,
     SQL_START = 297,
     SQL_STOP = 298,
     SQL_STRUCT = 299,
     SQL_UNSIGNED = 300,
     SQL_VAR = 301,
     SQL_WHENEVER = 302,
     S_ADD = 303,
     S_AND = 304,
     S_ANYTHING = 305,
     S_AUTO = 306,
     S_CONST = 307,
     S_DEC = 308,
     S_DIV = 309,
     S_DOTPOINT = 310,
     S_EQUAL = 311,
     S_EXTERN = 312,
     S_INC = 313,
     S_LSHIFT = 314,
     S_MEMPOINT = 315,
     S_MEMBER = 316,
     S_MOD = 317,
     S_MUL = 318,
     S_NEQUAL = 319,
     S_OR = 320,
     S_REGISTER = 321,
     S_RSHIFT = 322,
     S_STATIC = 323,
     S_SUB = 324,
     S_VOLATILE = 325,
     S_TYPEDEF = 326,
     TYPECAST = 327,
     ABORT_P = 328,
     ABSOLUTE_P = 329,
     ACCESS = 330,
     ACTION = 331,
     ADD_P = 332,
     ADMIN = 333,
     AFTER = 334,
     AGGREGATE = 335,
     ALL = 336,
     ALSO = 337,
     ALTER = 338,
     ALWAYS = 339,
     ANALYSE = 340,
     ANALYZE = 341,
     AND = 342,
     ANY = 343,
     ARRAY = 344,
     AS = 345,
     ASC = 346,
     ASSERTION = 347,
     ASSIGNMENT = 348,
     ASYMMETRIC = 349,
     AT = 350,
     AUTHORIZATION = 351,
     BACKWARD = 352,
     BEFORE = 353,
     BEGIN_P = 354,
     BETWEEN = 355,
     BIGINT = 356,
     BINARY = 357,
     BIT = 358,
     BOOLEAN_P = 359,
     BOTH = 360,
     BY = 361,
     CACHE = 362,
     CALLED = 363,
     CASCADE = 364,
     CASCADED = 365,
     CASE = 366,
     CAST = 367,
     CHAIN = 368,
     CHAR_P = 369,
     CHARACTER = 370,
     CHARACTERISTICS = 371,
     CHECK = 372,
     CHECKPOINT = 373,
     CLASS = 374,
     CLOSE = 375,
     CLUSTER = 376,
     COALESCE = 377,
     COLLATE = 378,
     COLUMN = 379,
     COMMENT = 380,
     COMMIT = 381,
     COMMITTED = 382,
     CONCURRENTLY = 383,
     CONFIGURATION = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONTENT_P = 388,
     CONVERSION_P = 389,
     COPY = 390,
     COST = 391,
     CREATE = 392,
     CREATEDB = 393,
     CREATEROLE = 394,
     CREATEUSER = 395,
     CROSS = 396,
     CSV = 397,
     CURRENT_P = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DICTIONARY = 421,
     DISABLE_P = 422,
     DISCARD = 423,
     DISTINCT = 424,
     DO = 425,
     DOCUMENT_P = 426,
     DOMAIN_P = 427,
     DOUBLE_P = 428,
     DROP = 429,
     EACH = 430,
     ELSE = 431,
     ENABLE_P = 432,
     ENCODING = 433,
     ENCRYPTED = 434,
     END_P = 435,
     ENUM_P = 436,
     ESCAPE = 437,
     EXCEPT = 438,
     EXCLUSIVE = 439,
     EXCLUDING = 440,
     EXECUTE = 441,
     EXISTS = 442,
     EXPLAIN = 443,
     EXTERNAL = 444,
     EXTRACT = 445,
     FALSE_P = 446,
     FAMILY = 447,
     FETCH = 448,
     FIRST_P = 449,
     FLOAT_P = 450,
     FOR = 451,
     FORCE = 452,
     FOREIGN = 453,
     FORWARD = 454,
     FREEZE = 455,
     FROM = 456,
     FULL = 457,
     FUNCTION = 458,
     GET = 459,
     GLOBAL = 460,
     GRANT = 461,
     GRANTED = 462,
     GREATEST = 463,
     GROUP_P = 464,
     HANDLER = 465,
     HAVING = 466,
     HEADER_P = 467,
     HOLD = 468,
     HOUR_P = 469,
     IF_P = 470,
     ILIKE = 471,
     IMMEDIATE = 472,
     IMMUTABLE = 473,
     IMPLICIT_P = 474,
     IN_P = 475,
     INCLUDING = 476,
     INCREMENT = 477,
     INDEX = 478,
     INDEXES = 479,
     INHERIT = 480,
     INHERITS = 481,
     INITIALLY = 482,
     INNER_P = 483,
     INOUT = 484,
     INPUT_P = 485,
     INSENSITIVE = 486,
     INSERT = 487,
     INSTEAD = 488,
     INT_P = 489,
     INTEGER = 490,
     INTERSECT = 491,
     INTERVAL = 492,
     INTO = 493,
     INVOKER = 494,
     IS = 495,
     ISNULL = 496,
     ISOLATION = 497,
     JOIN = 498,
     KEY = 499,
     LANCOMPILER = 500,
     LANGUAGE = 501,
     LARGE_P = 502,
     LAST_P = 503,
     LEADING = 504,
     LEAST = 505,
     LEFT = 506,
     LEVEL = 507,
     LIKE = 508,
     LIMIT = 509,
     LISTEN = 510,
     LOAD = 511,
     LOCAL = 512,
     LOCALTIME = 513,
     LOCALTIMESTAMP = 514,
     LOCATION = 515,
     LOCK_P = 516,
     LOGIN_P = 517,
     MAPPING = 518,
     MATCH = 519,
     MAXVALUE = 520,
     MINUTE_P = 521,
     MINVALUE = 522,
     MODE = 523,
     MONTH_P = 524,
     MOVE = 525,
     NAME_P = 526,
     NAMES = 527,
     NATIONAL = 528,
     NATURAL = 529,
     NCHAR = 530,
     NEW = 531,
     NEXT = 532,
     NO = 533,
     NOCREATEDB = 534,
     NOCREATEROLE = 535,
     NOCREATEUSER = 536,
     NOINHERIT = 537,
     NOLOGIN_P = 538,
     NONE = 539,
     NOSUPERUSER = 540,
     NOT = 541,
     NOTHING = 542,
     NOTIFY = 543,
     NOTNULL = 544,
     NOWAIT = 545,
     NULL_P = 546,
     NULLIF = 547,
     NULLS_P = 548,
     NUMERIC = 549,
     OBJECT_P = 550,
     OF = 551,
     OFF = 552,
     OFFSET = 553,
     OIDS = 554,
     OLD = 555,
     ON = 556,
     ONLY = 557,
     OPERATOR = 558,
     OPTION = 559,
     OR = 560,
     ORDER = 561,
     OUT_P = 562,
     OUTER_P = 563,
     OVERLAPS = 564,
     OVERLAY = 565,
     OWNED = 566,
     OWNER = 567,
     PARSER = 568,
     PARTIAL = 569,
     PASSWORD = 570,
     PLACING = 571,
     PLANS = 572,
     POSITION = 573,
     PRECISION = 574,
     PRESERVE = 575,
     PREPARE = 576,
     PREPARED = 577,
     PRIMARY = 578,
     PRIOR = 579,
     PRIVILEGES = 580,
     PROCEDURAL = 581,
     PROCEDURE = 582,
     QUOTE = 583,
     READ = 584,
     REAL = 585,
     REASSIGN = 586,
     RECHECK = 587,
     REFERENCES = 588,
     REINDEX = 589,
     RELATIVE_P = 590,
     RELEASE = 591,
     RENAME = 592,
     REPEATABLE = 593,
     REPLACE = 594,
     REPLICA = 595,
     RESET = 596,
     RESTART = 597,
     RESTRICT = 598,
     RETURNING = 599,
     RETURNS = 600,
     REVOKE = 601,
     RIGHT = 602,
     ROLE = 603,
     ROLLBACK = 604,
     ROW = 605,
     ROWS = 606,
     RULE = 607,
     SAVEPOINT = 608,
     SCHEMA = 609,
     SCROLL = 610,
     SEARCH = 611,
     SECOND_P = 612,
     SECURITY = 613,
     SELECT = 614,
     SEQUENCE = 615,
     SERIALIZABLE = 616,
     SESSION = 617,
     SESSION_USER = 618,
     SET = 619,
     SETOF = 620,
     SHARE = 621,
     SHOW = 622,
     SIMILAR = 623,
     SIMPLE = 624,
     SMALLINT = 625,
     SOME = 626,
     STABLE = 627,
     STANDALONE_P = 628,
     START = 629,
     STATEMENT = 630,
     STATISTICS = 631,
     STDIN = 632,
     STDOUT = 633,
     STORAGE = 634,
     STRICT_P = 635,
     STRIP_P = 636,
     SUBSTRING = 637,
     SUPERUSER_P = 638,
     SYMMETRIC = 639,
     SYSID = 640,
     SYSTEM_P = 641,
     TABLE = 642,
     TABLESPACE = 643,
     TEMP = 644,
     TEMPLATE = 645,
     TEMPORARY = 646,
     TEXT_P = 647,
     THEN = 648,
     TIME = 649,
     TIMESTAMP = 650,
     TO = 651,
     TRAILING = 652,
     TRANSACTION = 653,
     TREAT = 654,
     TRIGGER = 655,
     TRIM = 656,
     TRUE_P = 657,
     TRUNCATE = 658,
     TRUSTED = 659,
     TYPE_P = 660,
     UNCOMMITTED = 661,
     UNENCRYPTED = 662,
     UNION = 663,
     UNIQUE = 664,
     UNKNOWN = 665,
     UNLISTEN = 666,
     UNTIL = 667,
     UPDATE = 668,
     USER = 669,
     USING = 670,
     VACUUM = 671,
     VALID = 672,
     VALIDATOR = 673,
     VALUE_P = 674,
     VALUES = 675,
     VARCHAR = 676,
     VARYING = 677,
     VERBOSE = 678,
     VERSION_P = 679,
     VIEW = 680,
     VOLATILE = 681,
     WHEN = 682,
     WHERE = 683,
     WHITESPACE_P = 684,
     WITH = 685,
     WITHOUT = 686,
     WORK = 687,
     WRITE = 688,
     XML_P = 689,
     XMLATTRIBUTES = 690,
     XMLCONCAT = 691,
     XMLELEMENT = 692,
     XMLFOREST = 693,
     XMLPARSE = 694,
     XMLPI = 695,
     XMLROOT = 696,
     XMLSERIALIZE = 697,
     YEAR_P = 698,
     YES_P = 699,
     ZONE = 700,
     NULLS_FIRST = 701,
     NULLS_LAST = 702,
     WITH_CASCADED = 703,
     WITH_LOCAL = 704,
     WITH_CHECK = 705,
     IDENT = 706,
     SCONST = 707,
     Op = 708,
     CSTRING = 709,
     CVARIABLE = 710,
     CPP_LINE = 711,
     IP = 712,
     BCONST = 713,
     XCONST = 714,
     DOLCONST = 715,
     ECONST = 716,
     NCONST = 717,
     ICONST = 718,
     PARAM = 719,
     FCONST = 720,
     POSTFIXOP = 721,
     UMINUS = 722
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_DATA 267
#define SQL_DATETIME_INTERVAL_CODE 268
#define SQL_DATETIME_INTERVAL_PRECISION 269
#define SQL_DESCRIBE 270
#define SQL_DESCRIPTOR 271
#define SQL_DISCONNECT 272
#define SQL_FOUND 273
#define SQL_FREE 274
#define SQL_GO 275
#define SQL_GOTO 276
#define SQL_IDENTIFIED 277
#define SQL_INDICATOR 278
#define SQL_KEY_MEMBER 279
#define SQL_LENGTH 280
#define SQL_LONG 281
#define SQL_NULLABLE 282
#define SQL_OCTET_LENGTH 283
#define SQL_OPEN 284
#define SQL_OUTPUT 285
#define SQL_REFERENCE 286
#define SQL_RETURNED_LENGTH 287
#define SQL_RETURNED_OCTET_LENGTH 288
#define SQL_SCALE 289
#define SQL_SECTION 290
#define SQL_SHORT 291
#define SQL_SIGNED 292
#define SQL_SQL 293
#define SQL_SQLERROR 294
#define SQL_SQLPRINT 295
#define SQL_SQLWARNING 296
#define SQL_START 297
#define SQL_STOP 298
#define SQL_STRUCT 299
#define SQL_UNSIGNED 300
#define SQL_VAR 301
#define SQL_WHENEVER 302
#define S_ADD 303
#define S_AND 304
#define S_ANYTHING 305
#define S_AUTO 306
#define S_CONST 307
#define S_DEC 308
#define S_DIV 309
#define S_DOTPOINT 310
#define S_EQUAL 311
#define S_EXTERN 312
#define S_INC 313
#define S_LSHIFT 314
#define S_MEMPOINT 315
#define S_MEMBER 316
#define S_MOD 317
#define S_MUL 318
#define S_NEQUAL 319
#define S_OR 320
#define S_REGISTER 321
#define S_RSHIFT 322
#define S_STATIC 323
#define S_SUB 324
#define S_VOLATILE 325
#define S_TYPEDEF 326
#define TYPECAST 327
#define ABORT_P 328
#define ABSOLUTE_P 329
#define ACCESS 330
#define ACTION 331
#define ADD_P 332
#define ADMIN 333
#define AFTER 334
#define AGGREGATE 335
#define ALL 336
#define ALSO 337
#define ALTER 338
#define ALWAYS 339
#define ANALYSE 340
#define ANALYZE 341
#define AND 342
#define ANY 343
#define ARRAY 344
#define AS 345
#define ASC 346
#define ASSERTION 347
#define ASSIGNMENT 348
#define ASYMMETRIC 349
#define AT 350
#define AUTHORIZATION 351
#define BACKWARD 352
#define BEFORE 353
#define BEGIN_P 354
#define BETWEEN 355
#define BIGINT 356
#define BINARY 357
#define BIT 358
#define BOOLEAN_P 359
#define BOTH 360
#define BY 361
#define CACHE 362
#define CALLED 363
#define CASCADE 364
#define CASCADED 365
#define CASE 366
#define CAST 367
#define CHAIN 368
#define CHAR_P 369
#define CHARACTER 370
#define CHARACTERISTICS 371
#define CHECK 372
#define CHECKPOINT 373
#define CLASS 374
#define CLOSE 375
#define CLUSTER 376
#define COALESCE 377
#define COLLATE 378
#define COLUMN 379
#define COMMENT 380
#define COMMIT 381
#define COMMITTED 382
#define CONCURRENTLY 383
#define CONFIGURATION 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONTENT_P 388
#define CONVERSION_P 389
#define COPY 390
#define COST 391
#define CREATE 392
#define CREATEDB 393
#define CREATEROLE 394
#define CREATEUSER 395
#define CROSS 396
#define CSV 397
#define CURRENT_P 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DICTIONARY 421
#define DISABLE_P 422
#define DISCARD 423
#define DISTINCT 424
#define DO 425
#define DOCUMENT_P 426
#define DOMAIN_P 427
#define DOUBLE_P 428
#define DROP 429
#define EACH 430
#define ELSE 431
#define ENABLE_P 432
#define ENCODING 433
#define ENCRYPTED 434
#define END_P 435
#define ENUM_P 436
#define ESCAPE 437
#define EXCEPT 438
#define EXCLUSIVE 439
#define EXCLUDING 440
#define EXECUTE 441
#define EXISTS 442
#define EXPLAIN 443
#define EXTERNAL 444
#define EXTRACT 445
#define FALSE_P 446
#define FAMILY 447
#define FETCH 448
#define FIRST_P 449
#define FLOAT_P 450
#define FOR 451
#define FORCE 452
#define FOREIGN 453
#define FORWARD 454
#define FREEZE 455
#define FROM 456
#define FULL 457
#define FUNCTION 458
#define GET 459
#define GLOBAL 460
#define GRANT 461
#define GRANTED 462
#define GREATEST 463
#define GROUP_P 464
#define HANDLER 465
#define HAVING 466
#define HEADER_P 467
#define HOLD 468
#define HOUR_P 469
#define IF_P 470
#define ILIKE 471
#define IMMEDIATE 472
#define IMMUTABLE 473
#define IMPLICIT_P 474
#define IN_P 475
#define INCLUDING 476
#define INCREMENT 477
#define INDEX 478
#define INDEXES 479
#define INHERIT 480
#define INHERITS 481
#define INITIALLY 482
#define INNER_P 483
#define INOUT 484
#define INPUT_P 485
#define INSENSITIVE 486
#define INSERT 487
#define INSTEAD 488
#define INT_P 489
#define INTEGER 490
#define INTERSECT 491
#define INTERVAL 492
#define INTO 493
#define INVOKER 494
#define IS 495
#define ISNULL 496
#define ISOLATION 497
#define JOIN 498
#define KEY 499
#define LANCOMPILER 500
#define LANGUAGE 501
#define LARGE_P 502
#define LAST_P 503
#define LEADING 504
#define LEAST 505
#define LEFT 506
#define LEVEL 507
#define LIKE 508
#define LIMIT 509
#define LISTEN 510
#define LOAD 511
#define LOCAL 512
#define LOCALTIME 513
#define LOCALTIMESTAMP 514
#define LOCATION 515
#define LOCK_P 516
#define LOGIN_P 517
#define MAPPING 518
#define MATCH 519
#define MAXVALUE 520
#define MINUTE_P 521
#define MINVALUE 522
#define MODE 523
#define MONTH_P 524
#define MOVE 525
#define NAME_P 526
#define NAMES 527
#define NATIONAL 528
#define NATURAL 529
#define NCHAR 530
#define NEW 531
#define NEXT 532
#define NO 533
#define NOCREATEDB 534
#define NOCREATEROLE 535
#define NOCREATEUSER 536
#define NOINHERIT 537
#define NOLOGIN_P 538
#define NONE 539
#define NOSUPERUSER 540
#define NOT 541
#define NOTHING 542
#define NOTIFY 543
#define NOTNULL 544
#define NOWAIT 545
#define NULL_P 546
#define NULLIF 547
#define NULLS_P 548
#define NUMERIC 549
#define OBJECT_P 550
#define OF 551
#define OFF 552
#define OFFSET 553
#define OIDS 554
#define OLD 555
#define ON 556
#define ONLY 557
#define OPERATOR 558
#define OPTION 559
#define OR 560
#define ORDER 561
#define OUT_P 562
#define OUTER_P 563
#define OVERLAPS 564
#define OVERLAY 565
#define OWNED 566
#define OWNER 567
#define PARSER 568
#define PARTIAL 569
#define PASSWORD 570
#define PLACING 571
#define PLANS 572
#define POSITION 573
#define PRECISION 574
#define PRESERVE 575
#define PREPARE 576
#define PREPARED 577
#define PRIMARY 578
#define PRIOR 579
#define PRIVILEGES 580
#define PROCEDURAL 581
#define PROCEDURE 582
#define QUOTE 583
#define READ 584
#define REAL 585
#define REASSIGN 586
#define RECHECK 587
#define REFERENCES 588
#define REINDEX 589
#define RELATIVE_P 590
#define RELEASE 591
#define RENAME 592
#define REPEATABLE 593
#define REPLACE 594
#define REPLICA 595
#define RESET 596
#define RESTART 597
#define RESTRICT 598
#define RETURNING 599
#define RETURNS 600
#define REVOKE 601
#define RIGHT 602
#define ROLE 603
#define ROLLBACK 604
#define ROW 605
#define ROWS 606
#define RULE 607
#define SAVEPOINT 608
#define SCHEMA 609
#define SCROLL 610
#define SEARCH 611
#define SECOND_P 612
#define SECURITY 613
#define SELECT 614
#define SEQUENCE 615
#define SERIALIZABLE 616
#define SESSION 617
#define SESSION_USER 618
#define SET 619
#define SETOF 620
#define SHARE 621
#define SHOW 622
#define SIMILAR 623
#define SIMPLE 624
#define SMALLINT 625
#define SOME 626
#define STABLE 627
#define STANDALONE_P 628
#define START 629
#define STATEMENT 630
#define STATISTICS 631
#define STDIN 632
#define STDOUT 633
#define STORAGE 634
#define STRICT_P 635
#define STRIP_P 636
#define SUBSTRING 637
#define SUPERUSER_P 638
#define SYMMETRIC 639
#define SYSID 640
#define SYSTEM_P 641
#define TABLE 642
#define TABLESPACE 643
#define TEMP 644
#define TEMPLATE 645
#define TEMPORARY 646
#define TEXT_P 647
#define THEN 648
#define TIME 649
#define TIMESTAMP 650
#define TO 651
#define TRAILING 652
#define TRANSACTION 653
#define TREAT 654
#define TRIGGER 655
#define TRIM 656
#define TRUE_P 657
#define TRUNCATE 658
#define TRUSTED 659
#define TYPE_P 660
#define UNCOMMITTED 661
#define UNENCRYPTED 662
#define UNION 663
#define UNIQUE 664
#define UNKNOWN 665
#define UNLISTEN 666
#define UNTIL 667
#define UPDATE 668
#define USER 669
#define USING 670
#define VACUUM 671
#define VALID 672
#define VALIDATOR 673
#define VALUE_P 674
#define VALUES 675
#define VARCHAR 676
#define VARYING 677
#define VERBOSE 678
#define VERSION_P 679
#define VIEW 680
#define VOLATILE 681
#define WHEN 682
#define WHERE 683
#define WHITESPACE_P 684
#define WITH 685
#define WITHOUT 686
#define WORK 687
#define WRITE 688
#define XML_P 689
#define XMLATTRIBUTES 690
#define XMLCONCAT 691
#define XMLELEMENT 692
#define XMLFOREST 693
#define XMLPARSE 694
#define XMLPI 695
#define XMLROOT 696
#define XMLSERIALIZE 697
#define YEAR_P 698
#define YES_P 699
#define ZONE 700
#define NULLS_FIRST 701
#define NULLS_LAST 702
#define WITH_CASCADED 703
#define WITH_LOCAL 704
#define WITH_CHECK 705
#define IDENT 706
#define SCONST 707
#define Op 708
#define CSTRING 709
#define CVARIABLE 710
#define CPP_LINE 711
#define IP 712
#define BCONST 713
#define XCONST 714
#define DOLCONST 715
#define ECONST 716
#define NCONST 717
#define ICONST 718
#define PARAM 719
#define FCONST 720
#define POSTFIXOP 721
#define UMINUS 722




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			if (unlink(output_filename) != 0 && *output_filename != '-')
			        fprintf(stderr, "Could not remove output file %s!\n", output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "Initializer not allowed in typedef command");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "Type %s already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "No multidimensional array support for simple data types");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 370 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1396 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1420 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   72890

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  488
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  566
/* YYNRULES -- Number of rules. */
#define YYNRULES  2242
/* YYNRULES -- Number of states. */
#define YYNSTATES  3866

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   723

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   474,     2,     2,
     479,   480,   472,   470,   486,   471,   481,   473,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   487,   482,
     467,   466,   468,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   477,     2,   478,   475,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   483,     2,   484,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   469,   476,   485
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   240,   242,   244,
     246,   248,   250,   252,   254,   260,   262,   263,   266,   269,
     273,   277,   279,   281,   283,   285,   287,   289,   291,   293,
     295,   297,   301,   305,   308,   311,   314,   317,   321,   325,
     331,   337,   342,   348,   353,   357,   363,   367,   373,   379,
     386,   388,   390,   394,   400,   407,   412,   414,   415,   418,
     419,   421,   423,   425,   427,   429,   431,   434,   438,   442,
     446,   450,   454,   458,   462,   466,   469,   475,   478,   481,
     485,   489,   493,   495,   499,   501,   505,   508,   511,   514,
     516,   518,   520,   522,   524,   526,   528,   530,   532,   534,
     538,   545,   547,   549,   551,   553,   554,   556,   558,   562,
     567,   573,   578,   581,   584,   588,   593,   597,   600,   603,
     605,   610,   612,   614,   616,   618,   620,   623,   626,   629,
     632,   637,   642,   644,   648,   652,   657,   664,   671,   678,
     685,   690,   697,   700,   705,   709,   713,   717,   721,   726,
     731,   735,   739,   743,   747,   751,   755,   760,   765,   769,
     772,   776,   778,   780,   784,   788,   792,   795,   798,   802,
     805,   807,   809,   810,   813,   814,   817,   820,   830,   837,
     839,   841,   843,   845,   847,   850,   851,   853,   855,   859,
     863,   865,   867,   871,   875,   879,   884,   886,   887,   890,
     891,   895,   896,   898,   899,   911,   924,   926,   928,   931,
     934,   937,   940,   941,   943,   944,   946,   950,   952,   954,
     956,   960,   963,   964,   968,   970,   972,   975,   977,   981,
     986,   991,   994,  1000,  1002,  1005,  1008,  1011,  1015,  1018,
    1019,  1022,  1025,  1028,  1031,  1034,  1037,  1041,  1043,  1048,
    1055,  1063,  1075,  1079,  1080,  1084,  1086,  1088,  1091,  1094,
    1095,  1097,  1099,  1102,  1105,  1106,  1110,  1114,  1117,  1119,
    1121,  1124,  1127,  1132,  1133,  1136,  1139,  1142,  1143,  1147,
    1152,  1157,  1158,  1161,  1162,  1167,  1168,  1169,  1177,  1183,
    1187,  1188,  1192,  1194,  1196,  1202,  1207,  1210,  1211,  1214,
    1216,  1219,  1223,  1226,  1229,  1232,  1235,  1239,  1243,  1247,
    1249,  1250,  1256,  1266,  1268,  1269,  1271,  1274,  1277,  1278,
    1281,  1282,  1288,  1296,  1298,  1299,  1306,  1309,  1310,  1314,
    1320,  1335,  1355,  1357,  1359,  1361,  1365,  1371,  1373,  1375,
    1377,  1381,  1382,  1384,  1385,  1387,  1389,  1391,  1395,  1396,
    1398,  1400,  1401,  1404,  1406,  1409,  1411,  1414,  1415,  1418,
    1420,  1423,  1426,  1433,  1442,  1451,  1455,  1461,  1466,  1471,
    1476,  1480,  1488,  1497,  1504,  1511,  1518,  1525,  1529,  1531,
    1535,  1539,  1541,  1543,  1545,  1547,  1549,  1553,  1557,  1561,
    1563,  1567,  1571,  1573,  1577,  1591,  1593,  1597,  1602,  1610,
    1615,  1623,  1626,  1628,  1629,  1632,  1633,  1635,  1636,  1643,
    1652,  1661,  1663,  1667,  1673,  1679,  1687,  1697,  1705,  1715,
    1721,  1728,  1735,  1740,  1742,  1744,  1746,  1748,  1750,  1752,
    1754,  1756,  1760,  1764,  1768,  1772,  1774,  1778,  1780,  1783,
    1786,  1790,  1795,  1801,  1806,  1811,  1815,  1820,  1824,  1828,
    1831,  1836,  1839,  1841,  1843,  1845,  1847,  1850,  1853,  1855,
    1857,  1859,  1862,  1865,  1867,  1870,  1873,  1875,  1877,  1879,
    1886,  1894,  1902,  1912,  1921,  1930,  1937,  1947,  1957,  1965,
    1976,  1984,  1993,  2002,  2011,  2020,  2022,  2024,  2026,  2028,
    2030,  2032,  2034,  2036,  2038,  2040,  2042,  2044,  2046,  2048,
    2056,  2064,  2075,  2078,  2080,  2082,  2084,  2088,  2090,  2092,
    2094,  2096,  2098,  2101,  2104,  2107,  2110,  2113,  2116,  2119,
    2121,  2125,  2127,  2130,  2134,  2135,  2137,  2141,  2144,  2151,
    2158,  2162,  2163,  2167,  2168,  2182,  2197,  2199,  2200,  2203,
    2204,  2206,  2210,  2215,  2220,  2227,  2229,  2232,  2233,  2235,
    2237,  2238,  2240,  2242,  2243,  2253,  2261,  2264,  2265,  2269,
    2272,  2274,  2278,  2282,  2286,  2289,  2292,  2294,  2296,  2298,
    2300,  2303,  2305,  2309,  2311,  2313,  2315,  2320,  2326,  2328,
    2331,  2336,  2342,  2344,  2346,  2348,  2350,  2354,  2358,  2361,
    2364,  2367,  2370,  2372,  2375,  2378,  2380,  2383,  2384,  2390,
    2392,  2395,  2397,  2398,  2404,  2412,  2418,  2426,  2434,  2444,
    2446,  2450,  2454,  2458,  2460,  2464,  2476,  2487,  2490,  2491,
    2501,  2504,  2505,  2510,  2515,  2520,  2522,  2524,  2526,  2527,
    2535,  2542,  2549,  2556,  2563,  2571,  2581,  2591,  2598,  2605,
    2612,  2619,  2626,  2635,  2644,  2651,  2658,  2667,  2676,  2685,
    2694,  2696,  2697,  2705,  2712,  2719,  2726,  2733,  2740,  2748,
    2755,  2762,  2769,  2776,  2784,  2794,  2804,  2814,  2821,  2828,
    2835,  2844,  2853,  2854,  2869,  2871,  2873,  2877,  2881,  2883,
    2885,  2887,  2889,  2891,  2893,  2895,  2896,  2898,  2900,  2902,
    2904,  2906,  2908,  2909,  2916,  2925,  2928,  2931,  2934,  2937,
    2940,  2944,  2948,  2951,  2954,  2957,  2960,  2964,  2967,  2973,
    2978,  2982,  2986,  2990,  2992,  2994,  2995,  2999,  3002,  3005,
    3007,  3011,  3014,  3016,  3017,  3026,  3037,  3040,  3044,  3048,
    3049,  3052,  3058,  3062,  3064,  3067,  3071,  3075,  3079,  3083,
    3087,  3091,  3095,  3099,  3104,  3108,  3112,  3114,  3115,  3121,
    3126,  3129,  3130,  3135,  3139,  3145,  3152,  3157,  3164,  3171,
    3177,  3185,  3187,  3188,  3195,  3207,  3219,  3231,  3245,  3255,
    3267,  3278,  3282,  3284,  3289,  3292,  3293,  3298,  3304,  3310,
    3313,  3318,  3320,  3322,  3324,  3325,  3327,  3328,  3330,  3331,
    3335,  3336,  3341,  3343,  3345,  3347,  3349,  3351,  3353,  3355,
    3356,  3362,  3367,  3369,  3371,  3373,  3375,  3379,  3380,  3385,
    3394,  3398,  3399,  3402,  3406,  3409,  3413,  3419,  3421,  3426,
    3429,  3433,  3435,  3438,  3442,  3443,  3450,  3453,  3454,  3460,
    3464,  3465,  3468,  3471,  3474,  3478,  3480,  3484,  3486,  3489,
    3491,  3492,  3500,  3502,  3506,  3508,  3510,  3514,  3520,  3523,
    3525,  3529,  3537,  3538,  3541,  3544,  3547,  3551,  3552,  3555,
    3558,  3560,  3562,  3566,  3570,  3572,  3575,  3580,  3585,  3587,
    3589,  3598,  3600,  3605,  3610,  3615,  3618,  3620,  3621,  3625,
    3629,  3634,  3639,  3644,  3649,  3652,  3654,  3656,  3657,  3659,
    3660,  3662,  3668,  3670,  3671,  3673,  3674,  3678,  3680,  3684,
    3689,  3693,  3698,  3703,  3706,  3709,  3714,  3716,  3717,  3719,
    3721,  3723,  3727,  3728,  3731,  3732,  3734,  3738,  3740,  3741,
    3743,  3746,  3751,  3756,  3759,  3760,  3763,  3767,  3770,  3771,
    3775,  3777,  3779,  3782,  3784,  3787,  3793,  3800,  3806,  3808,
    3811,  3813,  3818,  3822,  3827,  3833,  3838,  3844,  3849,  3855,
    3858,  3863,  3865,  3868,  3871,  3874,  3876,  3878,  3879,  3884,
    3887,  3889,  3892,  3895,  3900,  3902,  3905,  3909,  3911,  3914,
    3915,  3918,  3923,  3928,  3929,  3931,  3935,  3938,  3941,  3945,
    3951,  3958,  3962,  3967,  3968,  3970,  3974,  3978,  3982,  3986,
    3990,  3994,  3996,  3998,  4000,  4002,  4004,  4006,  4008,  4011,
    4017,  4019,  4021,  4023,  4025,  4028,  4032,  4036,  4037,  4039,
    4041,  4043,  4045,  4047,  4050,  4053,  4056,  4059,  4062,  4064,
    4068,  4069,  4071,  4073,  4075,  4077,  4083,  4086,  4088,  4090,
    4092,  4094,  4100,  4103,  4106,  4109,  4111,  4115,  4119,  4122,
    4124,  4125,  4129,  4130,  4136,  4139,  4145,  4148,  4150,  4154,
    4158,  4159,  4161,  4163,  4165,  4167,  4169,  4171,  4175,  4179,
    4183,  4187,  4191,  4195,  4199,  4200,  4202,  4206,  4212,  4215,
    4218,  4222,  4226,  4230,  4234,  4238,  4242,  4246,  4250,  4254,
    4258,  4261,  4264,  4268,  4272,  4275,  4279,  4285,  4290,  4297,
    4301,  4307,  4312,  4319,  4324,  4331,  4337,  4345,  4348,  4352,
    4355,  4360,  4364,  4368,  4373,  4377,  4382,  4386,  4391,  4397,
    4404,  4411,  4419,  4426,  4434,  4441,  4449,  4453,  4458,  4463,
    4470,  4473,  4477,  4482,  4484,  4488,  4491,  4495,  4499,  4503,
    4507,  4511,  4515,  4519,  4523,  4527,  4531,  4534,  4537,  4543,
    4550,  4557,  4565,  4569,  4574,  4576,  4578,  4581,  4586,  4588,
    4590,  4592,  4595,  4598,  4601,  4603,  4607,  4612,  4618,  4624,
    4629,  4631,  4633,  4638,  4640,  4645,  4647,  4652,  4654,  4659,
    4661,  4663,  4665,  4667,  4674,  4679,  4684,  4689,  4694,  4701,
    4707,  4713,  4719,  4724,  4731,  4736,  4741,  4746,  4751,  4757,
    4765,  4773,  4783,  4788,  4795,  4801,  4809,  4817,  4820,  4824,
    4828,  4832,  4837,  4838,  4843,  4845,  4849,  4853,  4855,  4857,
    4859,  4862,  4865,  4866,  4871,  4875,  4881,  4883,  4885,  4887,
    4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,  4905,  4907,
    4909,  4911,  4916,  4918,  4923,  4925,  4930,  4932,  4935,  4937,
    4940,  4942,  4946,  4950,  4951,  4953,  4957,  4959,  4963,  4967,
    4971,  4973,  4975,  4977,  4979,  4981,  4983,  4985,  4987,  4992,
    4996,  4999,  5003,  5004,  5008,  5012,  5015,  5018,  5020,  5021,
    5024,  5027,  5031,  5034,  5036,  5038,  5042,  5048,  5051,  5053,
    5058,  5061,  5062,  5064,  5065,  5067,  5070,  5073,  5076,  5080,
    5086,  5088,  5091,  5092,  5095,  5097,  5098,  5100,  5102,  5104,
    5108,  5112,  5116,  5118,  5122,  5124,  5126,  5128,  5130,  5132,
    5136,  5138,  5141,  5143,  5147,  5149,  5151,  5153,  5155,  5157,
    5159,  5161,  5164,  5166,  5169,  5173,  5180,  5182,  5184,  5186,
    5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,  5204,  5206,
    5208,  5210,  5213,  5215,  5217,  5219,  5221,  5224,  5227,  5229,
    5231,  5233,  5235,  5237,  5239,  5241,  5243,  5246,  5249,  5251,
    5253,  5255,  5257,  5259,  5261,  5263,  5265,  5268,  5274,  5276,
    5278,  5280,  5282,  5288,  5292,  5295,  5298,  5302,  5310,  5312,
    5314,  5316,  5317,  5320,  5323,  5325,  5326,  5328,  5332,  5334,
    5337,  5338,  5341,  5342,  5345,  5346,  5348,  5352,  5357,  5361,
    5363,  5365,  5367,  5370,  5371,  5379,  5383,  5385,  5387,  5389,
    5391,  5394,  5395,  5397,  5401,  5405,  5409,  5413,  5414,  5419,
    5425,  5431,  5432,  5434,  5436,  5438,  5440,  5443,  5446,  5449,
    5451,  5454,  5455,  5463,  5464,  5470,  5471,  5476,  5479,  5482,
    5483,  5486,  5488,  5490,  5492,  5494,  5496,  5498,  5500,  5502,
    5504,  5506,  5508,  5514,  5517,  5519,  5523,  5526,  5529,  5533,
    5534,  5540,  5542,  5543,  5549,  5552,  5555,  5557,  5559,  5561,
    5564,  5567,  5571,  5573,  5576,  5579,  5583,  5587,  5592,  5595,
    5597,  5600,  5602,  5604,  5607,  5610,  5614,  5616,  5618,  5620,
    5622,  5623,  5625,  5629,  5635,  5636,  5639,  5640,  5642,  5645,
    5649,  5652,  5654,  5656,  5658,  5659,  5661,  5663,  5665,  5668,
    5671,  5673,  5675,  5676,  5678,  5680,  5682,  5684,  5687,  5690,
    5694,  5695,  5697,  5700,  5702,  5707,  5712,  5713,  5715,  5718,
    5720,  5722,  5726,  5728,  5730,  5735,  5740,  5745,  5747,  5748,
    5752,  5756,  5761,  5763,  5767,  5771,  5776,  5778,  5782,  5786,
    5788,  5795,  5797,  5801,  5805,  5812,  5814,  5818,  5822,  5824,
    5826,  5828,  5830,  5832,  5834,  5836,  5838,  5840,  5842,  5844,
    5846,  5848,  5850,  5852,  5857,  5862,  5864,  5866,  5871,  5876,
    5880,  5881,  5889,  5891,  5892,  5893,  5901,  5905,  5910,  5914,
    5916,  5918,  5920,  5923,  5927,  5933,  5936,  5942,  5945,  5947,
    5949,  5951,  5953,  5955,  5957,  5959,  5961,  5963,  5965,  5967,
    5969,  5971,  5973,  5975,  5977,  5979,  5981,  5983,  5985,  5987,
    5989,  5991,  5993,  5995,  5997,  5999,  6001,  6003,  6005,  6007,
    6009,  6011,  6013,  6015,  6017,  6019,  6021,  6023,  6025,  6027,
    6029,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,  6047,
    6049,  6051,  6053,  6055,  6057,  6059,  6061,  6063,  6065,  6067,
    6069,  6071,  6073,  6075,  6077,  6079,  6081,  6083,  6085,  6087,
    6089,  6091,  6093,  6095,  6097,  6099,  6101,  6103,  6105,  6107,
    6109,  6111,  6113,  6115,  6117,  6119,  6121,  6123,  6125,  6127,
    6129,  6131,  6133,  6135,  6137,  6139,  6141,  6143,  6145,  6147,
    6149,  6151,  6153,  6155,  6157,  6159,  6161,  6163,  6165,  6167,
    6169,  6171,  6173,  6175,  6177,  6179,  6181,  6183,  6185,  6187,
    6189,  6191,  6193,  6195,  6197,  6199,  6201,  6203,  6205,  6207,
    6209,  6211,  6213,  6215,  6217,  6219,  6221,  6223,  6225,  6227,
    6229,  6231,  6233,  6235,  6237,  6239,  6241,  6243,  6245,  6247,
    6249,  6251,  6253,  6255,  6257,  6259,  6261,  6263,  6265,  6267,
    6269,  6271,  6273,  6275,  6277,  6279,  6281,  6283,  6285,  6287,
    6289,  6291,  6293,  6295,  6297,  6299,  6301,  6303,  6305,  6307,
    6309,  6311,  6313,  6315,  6317,  6319,  6321,  6323,  6325,  6327,
    6329,  6331,  6333,  6335,  6337,  6339,  6341,  6343,  6345,  6347,
    6349,  6351,  6353,  6355,  6357,  6359,  6361,  6363,  6365,  6367,
    6369,  6371,  6373,  6375,  6377,  6379,  6381,  6383,  6385,  6387,
    6389,  6391,  6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,
    6409,  6411,  6413,  6415,  6417,  6419,  6421,  6423,  6425,  6427,
    6429,  6431,  6433,  6435,  6437,  6439,  6441,  6443,  6445,  6447,
    6449,  6451,  6453,  6455,  6457,  6459,  6461,  6463,  6465,  6467,
    6469,  6471,  6473,  6475,  6477,  6479,  6481,  6483,  6485,  6487,
    6489,  6491,  6493,  6495,  6497,  6499,  6501,  6503,  6505,  6507,
    6509,  6511,  6513,  6515,  6517,  6519,  6521,  6523,  6525,  6527,
    6529,  6531,  6533,  6535,  6537,  6539,  6541,  6543,  6545,  6547,
    6549,  6551,  6553,  6555,  6557,  6559,  6561,  6563,  6565,  6567,
    6569,  6571,  6573,  6575,  6577,  6579,  6581,  6583,  6585,  6587,
    6589,  6591,  6593,  6595,  6597,  6599,  6601,  6603,  6605,  6607,
    6609,  6611,  6613,  6615,  6617,  6619,  6621,  6623,  6625,  6627,
    6629,  6631,  6633,  6635,  6637,  6639,  6641,  6643,  6645,  6647,
    6649,  6651,  6653,  6655,  6657,  6659,  6661,  6663,  6665,  6667,
    6669,  6671,  6673,  6675,  6677,  6679,  6681,  6683,  6685,  6687,
    6689,  6691,  6693,  6695,  6697,  6699,  6701,  6703,  6705,  6707,
    6709,  6711,  6713,  6715,  6717,  6719,  6721,  6723,  6725,  6727,
    6729,  6731,  6733,  6735,  6737,  6739,  6741,  6743,  6745,  6747,
    6749,  6751,  6753,  6755,  6757,  6759,  6761,  6763,  6765,  6767,
    6769,  6771,  6773,  6775,  6777,  6779,  6781,  6783,  6785,  6787,
    6789,  6791,  6793,  6795,  6797,  6799,  6801,  6803,  6805,  6807,
    6809,  6811,  6813,  6815,  6817,  6819,  6821,  6823,  6825,  6827,
    6829,  6831,  6833,  6835,  6837,  6839,  6841,  6845,  6847,  6848,
    6850,  6853,  6855,  6858,  6860,  6862,  6865,  6868,  6870,  6872,
    6874,  6876,  6878,  6880,  6883,  6887,  6889,  6892,  6894,  6898,
    6900,  6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,
    6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,  6940,
    6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,  6960,
    6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,  6980,
    6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,  7000,
    7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,  7020,
    7022,  7024,  7026
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     489,     0,    -1,   490,    -1,    -1,   490,   491,    -1,  1039,
     492,   493,   482,    -1,  1039,   493,   482,    -1,  1039,   936,
      -1,   941,    -1,  1052,    -1,   456,    -1,   483,    -1,   484,
      -1,    95,   977,    -1,   730,    -1,   731,    -1,   736,    -1,
     687,    -1,   505,    -1,   704,    -1,   705,    -1,   583,    -1,
     530,    -1,   499,    -1,   498,    -1,   739,    -1,   738,    -1,
     500,    -1,   501,    -1,   744,    -1,   528,    -1,   538,    -1,
     741,    -1,   647,    -1,   525,    -1,   539,    -1,   576,    -1,
     611,    -1,   695,    -1,   740,    -1,   735,    -1,   673,    -1,
     504,    -1,   587,    -1,   623,    -1,   629,    -1,   630,    -1,
     494,    -1,   508,    -1,   582,    -1,   548,    -1,   594,    -1,
     597,    -1,   497,    -1,   726,    -1,   758,    -1,   777,    -1,
     613,    -1,   764,    -1,   529,    -1,   612,    -1,   697,    -1,
     507,    -1,   633,    -1,   634,    -1,   635,    -1,   592,    -1,
     502,    -1,   714,    -1,   637,    -1,   596,    -1,   610,    -1,
     503,    -1,   734,    -1,   750,    -1,   756,    -1,   643,    -1,
     650,    -1,   661,    -1,   665,    -1,   759,    -1,   716,    -1,
     725,    -1,   766,    -1,   715,    -1,   753,    -1,   636,    -1,
     699,    -1,   691,    -1,   692,    -1,   690,    -1,   702,    -1,
     651,    -1,   662,    -1,   706,    -1,   780,    -1,   718,    -1,
     642,    -1,   717,    -1,   770,    -1,   743,    -1,   512,    -1,
     522,    -1,   523,    -1,   723,    -1,   993,    -1,   920,    -1,
     934,    -1,   994,    -1,   974,    -1,   991,    -1,   975,    -1,
     935,    -1,   981,    -1,  1002,    -1,   995,    -1,   982,    -1,
    1009,    -1,  1011,    -1,  1005,    -1,   998,    -1,  1012,    -1,
    1015,    -1,  1017,    -1,   137,   348,   918,   495,   496,    -1,
     430,    -1,    -1,   315,   908,    -1,   315,   291,    -1,   179,
     315,   908,    -1,   407,   315,   908,    -1,   383,    -1,   285,
      -1,   225,    -1,   282,    -1,   138,    -1,   279,    -1,   139,
      -1,   280,    -1,   262,    -1,   283,    -1,   130,   254,   910,
      -1,   417,   412,   908,    -1,   414,   895,    -1,   385,   909,
      -1,    78,   895,    -1,   348,   895,    -1,   220,   348,   895,
      -1,   220,   209,   895,    -1,   137,   414,   918,   495,   496,
      -1,    83,   348,   918,   495,   496,    -1,    83,   348,   918,
     524,    -1,    83,   414,   918,   495,   496,    -1,    83,   414,
     918,   524,    -1,   174,   348,   895,    -1,   174,   348,   215,
     187,   895,    -1,   174,   414,   895,    -1,   174,   414,   215,
     187,   895,    -1,   137,   209,   918,   495,   496,    -1,    83,
     209,   918,   506,   414,   895,    -1,    77,    -1,   174,    -1,
     174,   209,   895,    -1,   174,   209,   215,   187,   895,    -1,
     137,   354,   509,    96,   918,   510,    -1,   137,   354,  1025,
     510,    -1,  1025,    -1,    -1,   510,   511,    -1,    -1,   548,
      -1,   665,    -1,   582,    -1,   597,    -1,   650,    -1,   723,
      -1,   364,   513,    -1,   364,   257,   513,    -1,   364,   362,
     513,    -1,   514,   396,   515,    -1,   514,   485,   515,    -1,
     514,   396,   157,    -1,   514,   485,   157,    -1,   514,   201,
     143,    -1,   394,   445,   519,    -1,   398,   721,    -1,   362,
     116,    90,   398,   721,    -1,   272,   520,    -1,   348,   521,
      -1,   362,    96,   521,    -1,   362,    96,   157,    -1,   434,
     304,   854,    -1,  1024,    -1,   514,   481,  1025,    -1,   517,
      -1,   515,   486,   517,    -1,   329,   406,    -1,   329,   127,
      -1,   338,   329,    -1,   361,    -1,   518,    -1,   916,    -1,
    1025,    -1,   402,    -1,   191,    -1,   301,    -1,   297,    -1,
     916,    -1,  1046,    -1,   842,   913,   844,    -1,   842,   479,
     909,   480,   913,   844,    -1,   157,    -1,   257,    -1,   913,
      -1,   157,    -1,    -1,  1025,    -1,   913,    -1,   367,   514,
     988,    -1,   367,   394,   445,   988,    -1,   367,   398,   242,
     252,   988,    -1,   367,   362,    96,   988,    -1,   367,    81,
      -1,   341,   514,    -1,   341,   394,   445,    -1,   341,   398,
     242,   252,    -1,   341,   362,    96,    -1,   341,    81,    -1,
     364,   513,    -1,   523,    -1,   364,   132,   526,   527,    -1,
      81,    -1,   893,    -1,   160,    -1,   217,    -1,   118,    -1,
     168,    81,    -1,   168,   389,    -1,   168,   391,    -1,   168,
     317,    -1,    83,   387,   814,   531,    -1,    83,   223,   814,
     533,    -1,   532,    -1,   531,   486,   532,    -1,    77,   703,
     553,    -1,    83,   703,  1025,   535,    -1,    83,   703,  1025,
     174,   286,   291,    -1,    83,   703,  1025,   364,   286,   291,
      -1,    83,   703,  1025,   364,   376,   909,    -1,    83,   703,
    1025,   364,   379,  1025,    -1,   174,   703,  1025,   536,    -1,
      83,   703,  1025,   405,   821,   537,    -1,    77,   561,    -1,
     174,   131,   896,   536,    -1,   364,   431,   299,    -1,   121,
     301,   896,    -1,   364,   431,   121,    -1,   177,   400,   896,
      -1,   177,    84,   400,   896,    -1,   177,   340,   400,   896,
      -1,   177,   400,    81,    -1,   177,   400,   414,    -1,   167,
     400,   896,    -1,   167,   400,    81,    -1,   167,   400,   414,
      -1,   177,   352,   896,    -1,   177,    84,   352,   896,    -1,
     177,   340,   352,   896,    -1,   167,   352,   896,    -1,   225,
     894,    -1,   278,   225,   894,    -1,   534,    -1,   534,    -1,
     533,   486,   534,    -1,   312,   396,   918,    -1,   364,   388,
     896,    -1,   364,   614,    -1,   341,   614,    -1,   364,   157,
     845,    -1,   174,   157,    -1,   109,    -1,   343,    -1,    -1,
     415,   845,    -1,    -1,   120,   896,    -1,   120,    81,    -1,
     135,   544,   894,   545,   540,   541,   546,   495,   542,    -1,
     135,   781,   396,   541,   495,   542,    -1,   396,    -1,   201,
      -1,   913,    -1,   377,    -1,   378,    -1,   542,   543,    -1,
      -1,   102,    -1,   299,    -1,   163,   737,   913,    -1,   291,
     737,   913,    -1,   142,    -1,   212,    -1,   328,   737,   908,
      -1,   182,   737,   908,    -1,   197,   328,   564,    -1,   197,
     286,   291,   564,    -1,   102,    -1,    -1,   430,   299,    -1,
      -1,   547,   164,   913,    -1,    -1,   415,    -1,    -1,   137,
     549,   387,   894,   479,   550,   480,   571,   572,   573,   574,
      -1,   137,   549,   387,   894,   296,   894,   479,   550,   480,
     572,   573,   574,    -1,   391,    -1,   389,    -1,   257,   391,
      -1,   257,   389,    -1,   205,   391,    -1,   205,   389,    -1,
      -1,   551,    -1,    -1,   552,    -1,   551,   486,   552,    -1,
     553,    -1,   558,    -1,   561,    -1,  1025,   821,   554,    -1,
     554,   555,    -1,    -1,   131,   896,   556,    -1,   556,    -1,
     557,    -1,   286,   291,    -1,   291,    -1,   409,   686,   575,
      -1,   323,   244,   686,   575,    -1,   117,   479,   845,   480,
      -1,   157,   846,    -1,   333,   894,   563,   566,   567,    -1,
     159,    -1,   286,   159,    -1,   227,   160,    -1,   227,   217,
      -1,   253,   894,   559,    -1,   559,   560,    -1,    -1,   221,
     158,    -1,   185,   158,    -1,   221,   132,    -1,   185,   132,
      -1,   221,   224,    -1,   185,   224,    -1,   131,   896,   562,
      -1,   562,    -1,   117,   479,   845,   480,    -1,   409,   479,
     564,   480,   686,   575,    -1,   323,   244,   479,   564,   480,
     686,   575,    -1,   198,   244,   479,   564,   480,   333,   894,
     563,   566,   567,   607,    -1,   479,   564,   480,    -1,    -1,
     564,   486,   565,    -1,   565,    -1,  1025,    -1,   264,   202,
      -1,   264,   314,    -1,    -1,   568,    -1,   569,    -1,   568,
     569,    -1,   569,   568,    -1,    -1,   301,   162,   570,    -1,
     301,   413,   570,    -1,   278,    76,    -1,   343,    -1,   109,
      -1,   364,   157,    -1,   364,   291,    -1,   226,   479,   893,
     480,    -1,    -1,   430,   614,    -1,   430,   299,    -1,   431,
     299,    -1,    -1,   301,   126,   174,    -1,   301,   126,   162,
     351,    -1,   301,   126,   320,   351,    -1,    -1,   388,   896,
      -1,    -1,   415,   223,   388,   896,    -1,    -1,    -1,   137,
     549,   387,   578,    90,   577,   780,    -1,   894,   579,   572,
     573,   574,    -1,   479,   580,   480,    -1,    -1,   580,   486,
     581,    -1,   581,    -1,  1025,    -1,   137,   549,   360,   894,
     584,    -1,    83,   360,   894,   584,    -1,   584,   585,    -1,
      -1,   107,   915,    -1,   150,    -1,   278,   150,    -1,   222,
     586,   915,    -1,   265,   915,    -1,   267,   915,    -1,   278,
     265,    -1,   278,   267,    -1,   311,   106,   640,    -1,   374,
     495,   915,    -1,   342,   495,   915,    -1,   106,    -1,    -1,
     137,   588,   593,   246,   521,    -1,   137,   588,   593,   246,
     521,   210,   589,   590,   591,    -1,   404,    -1,    -1,   896,
      -1,   896,   641,    -1,   418,   589,    -1,    -1,   245,   913,
      -1,    -1,   174,   593,   246,   913,   536,    -1,   174,   593,
     246,   215,   187,   913,   536,    -1,   326,    -1,    -1,   137,
     388,   896,   595,   260,   908,    -1,   312,   896,    -1,    -1,
     174,   388,   896,    -1,   174,   388,   215,   187,   896,    -1,
     137,   400,   896,   598,   599,   301,   894,   601,   186,   327,
     896,   479,   604,   480,    -1,   137,   131,   400,   896,    79,
     599,   301,   894,   606,   607,   196,   175,   350,   186,   327,
     902,   479,   604,   480,    -1,    98,    -1,    79,    -1,   600,
      -1,   600,   305,   600,    -1,   600,   305,   600,   305,   600,
      -1,   232,    -1,   162,    -1,   413,    -1,   196,   602,   603,
      -1,    -1,   175,    -1,    -1,   350,    -1,   375,    -1,   605,
      -1,   604,   486,   605,    -1,    -1,   917,    -1,  1025,    -1,
      -1,   201,   894,    -1,   608,    -1,   608,   609,    -1,   609,
      -1,   609,   608,    -1,    -1,   286,   159,    -1,   159,    -1,
     227,   217,    -1,   227,   160,    -1,   174,   400,   896,   301,
     894,   536,    -1,   174,   400,   215,   187,   896,   301,   894,
     536,    -1,   137,    92,   896,   117,   479,   845,   480,   607,
      -1,   174,    92,   896,    -1,   137,    80,   902,   618,   614,
      -1,   137,    80,   902,   619,    -1,   137,   303,   858,   614,
      -1,   137,   405,   640,   614,    -1,   137,   405,   640,    -1,
     137,   405,   640,    90,   479,   819,   480,    -1,   137,   405,
     640,    90,   181,   479,   622,   480,    -1,   137,   392,   356,
     313,   640,   614,    -1,   137,   392,   356,   166,   640,   614,
      -1,   137,   392,   356,   390,   640,   614,    -1,   137,   392,
     356,   129,   640,   614,    -1,   479,   615,   480,    -1,   616,
      -1,   615,   486,   616,    -1,  1027,   466,   617,    -1,  1027,
      -1,   682,    -1,  1037,    -1,   861,    -1,   916,    -1,   479,
     865,   480,    -1,   479,   472,   480,    -1,   479,   620,   480,
      -1,   621,    -1,   620,   486,   621,    -1,  1046,   466,   617,
      -1,   913,    -1,   622,   486,   913,    -1,   137,   303,   119,
     640,   626,   196,   405,   821,   415,   898,   627,    90,   624,
      -1,   625,    -1,   624,   486,   625,    -1,   303,   909,   694,
     628,    -1,   303,   909,   694,   479,   693,   480,   628,    -1,
     203,   909,   902,   675,    -1,   203,   909,   479,   865,   480,
     902,   675,    -1,   379,   821,    -1,   157,    -1,    -1,   192,
     640,    -1,    -1,   332,    -1,    -1,   137,   303,   192,   640,
     415,   898,    -1,    83,   303,   192,   640,   415,   898,    77,
     624,    -1,    83,   303,   192,   640,   415,   898,   174,   631,
      -1,   632,    -1,   631,   486,   632,    -1,   303,   909,   479,
     865,   480,    -1,   203,   909,   479,   865,   480,    -1,   174,
     303,   119,   640,   415,   898,   536,    -1,   174,   303,   119,
     215,   187,   640,   415,   898,   536,    -1,   174,   303,   192,
     640,   415,   898,   536,    -1,   174,   303,   192,   215,   187,
     640,   415,   898,   536,    -1,   174,   311,   106,   895,   536,
      -1,   331,   311,   106,   895,   396,   896,    -1,   174,   638,
     215,   187,   639,   536,    -1,   174,   638,   639,   536,    -1,
     387,    -1,   360,    -1,   425,    -1,   223,    -1,   405,    -1,
     172,    -1,   134,    -1,   354,    -1,   392,   356,   313,    -1,
     392,   356,   166,    -1,   392,   356,   390,    -1,   392,   356,
     129,    -1,   640,    -1,   639,   486,   640,    -1,  1025,    -1,
    1025,   641,    -1,   481,   899,    -1,   641,   481,   899,    -1,
     403,   787,   893,   536,    -1,   193,   644,   646,   896,   988,
      -1,   193,   644,   896,   988,    -1,   193,   646,   896,   988,
      -1,   193,   896,   988,    -1,   193,   644,   646,   896,    -1,
     193,   644,   896,    -1,   193,   646,   896,    -1,   193,   896,
      -1,   270,   644,   646,   896,    -1,   270,   896,    -1,   277,
      -1,   324,    -1,   194,    -1,   248,    -1,    74,   645,    -1,
     335,   645,    -1,   645,    -1,    81,    -1,   199,    -1,   199,
     645,    -1,   199,    81,    -1,    97,    -1,    97,   645,    -1,
      97,    81,    -1,   910,    -1,   220,    -1,   201,    -1,   125,
     301,   648,   896,   240,   649,    -1,   125,   301,    80,   902,
     618,   240,   649,    -1,   125,   301,   203,   902,   675,   240,
     649,    -1,   125,   301,   303,   858,   479,   693,   480,   240,
     649,    -1,   125,   301,   400,   896,   301,   640,   240,   649,
      -1,   125,   301,   352,   896,   301,   640,   240,   649,    -1,
     125,   301,   352,   896,   240,   649,    -1,   125,   301,   303,
     119,   640,   415,   898,   240,   649,    -1,   125,   301,   303,
     192,   640,   415,   898,   240,   649,    -1,   125,   301,   247,
     295,   915,   240,   649,    -1,   125,   301,   112,   479,   821,
      90,   821,   480,   240,   649,    -1,   125,   301,   593,   246,
     640,   240,   649,    -1,   125,   301,   392,   356,   313,   640,
     240,   649,    -1,   125,   301,   392,   356,   166,   640,   240,
     649,    -1,   125,   301,   392,   356,   390,   640,   240,   649,
      -1,   125,   301,   392,   356,   129,   640,   240,   649,    -1,
     124,    -1,   151,    -1,   354,    -1,   223,    -1,   360,    -1,
     387,    -1,   172,    -1,   405,    -1,   425,    -1,   134,    -1,
     388,    -1,   348,    -1,   913,    -1,   291,    -1,   206,   652,
     301,   655,   396,   656,   658,    -1,   346,   652,   301,   655,
     201,   656,   536,    -1,   346,   206,   304,   196,   652,   301,
     655,   201,   656,   536,    -1,    81,   325,    -1,    81,    -1,
     653,    -1,   654,    -1,   653,   486,   654,    -1,   359,    -1,
     333,    -1,   137,    -1,  1025,    -1,   893,    -1,   387,   893,
      -1,   360,   893,    -1,   203,   659,    -1,   151,   895,    -1,
     246,   895,    -1,   354,   895,    -1,   388,   895,    -1,   657,
      -1,   656,   486,   657,    -1,   918,    -1,   209,   918,    -1,
     430,   206,   304,    -1,    -1,   660,    -1,   659,   486,   660,
      -1,   902,   675,    -1,   206,   653,   396,   895,   663,   664,
      -1,   346,   653,   201,   895,   664,   536,    -1,   430,    78,
     304,    -1,    -1,   207,   106,   918,    -1,    -1,   137,   666,
     223,   900,   301,   894,   667,   479,   668,   480,   686,   574,
     817,    -1,   137,   666,   223,   128,   900,   301,   894,   667,
     479,   668,   480,   686,   574,   817,    -1,   409,    -1,    -1,
     415,   898,    -1,    -1,   669,    -1,   668,   486,   669,    -1,
    1025,   670,   671,   672,    -1,   848,   670,   671,   672,    -1,
     479,   845,   480,   670,   671,   672,    -1,   640,    -1,   415,
     640,    -1,    -1,    91,    -1,   165,    -1,    -1,   446,    -1,
     447,    -1,    -1,   137,   674,   203,   902,   675,   345,   681,
     683,   686,    -1,   137,   674,   203,   902,   675,   683,   686,
      -1,   305,   339,    -1,    -1,   479,   676,   480,    -1,   479,
     480,    -1,   677,    -1,   676,   486,   677,    -1,   678,   680,
     682,    -1,   680,   678,   682,    -1,   680,   682,    -1,   678,
     682,    -1,   682,    -1,   220,    -1,   307,    -1,   229,    -1,
     220,   307,    -1,   913,    -1,   913,   486,   913,    -1,  1026,
      -1,   682,    -1,   821,    -1,  1026,   641,   474,   405,    -1,
     365,  1026,   641,   474,   405,    -1,   685,    -1,   683,   685,
      -1,   108,   301,   291,   230,    -1,   345,   291,   301,   291,
     230,    -1,   380,    -1,   218,    -1,   372,    -1,   426,    -1,
     189,   358,   161,    -1,   189,   358,   239,    -1,   358,   161,
      -1,   358,   239,    -1,   136,   915,    -1,   351,   915,    -1,
     524,    -1,    90,   679,    -1,   246,   521,    -1,   684,    -1,
     430,   614,    -1,    -1,    83,   203,   660,   688,   689,    -1,
     684,    -1,   688,   684,    -1,   343,    -1,    -1,   174,   203,
     902,   675,   536,    -1,   174,   203,   215,   187,   902,   675,
     536,    -1,   174,    80,   902,   618,   536,    -1,   174,    80,
     215,   187,   902,   618,   536,    -1,   174,   303,   858,   479,
     693,   480,   536,    -1,   174,   303,   215,   187,   694,   479,
     693,   480,   536,    -1,   821,    -1,   821,   486,   821,    -1,
     284,   486,   821,    -1,   821,   486,   284,    -1,   858,    -1,
    1025,   481,   694,    -1,   137,   112,   479,   821,    90,   821,
     480,   430,   203,   660,   696,    -1,   137,   112,   479,   821,
      90,   821,   480,   431,   203,   696,    -1,    90,    93,    -1,
      -1,   174,   112,   698,   479,   821,    90,   821,   480,   536,
      -1,   215,   187,    -1,    -1,   334,   700,   894,   701,    -1,
     334,   386,   896,   701,    -1,   334,   151,   896,   701,    -1,
     223,    -1,   387,    -1,   197,    -1,    -1,    83,    80,   902,
     618,   337,   396,   896,    -1,    83,   134,   640,   337,   396,
     896,    -1,    83,   151,   897,   337,   396,   897,    -1,    83,
     203,   660,   337,   396,   896,    -1,    83,   209,   918,   337,
     396,   918,    -1,    83,   593,   246,   896,   337,   396,   896,
      -1,    83,   303,   119,   640,   415,   898,   337,   396,   896,
      -1,    83,   303,   192,   640,   415,   898,   337,   396,   896,
      -1,    83,   354,   896,   337,   396,   896,    -1,    83,   387,
     814,   337,   396,   896,    -1,    83,   360,   814,   337,   396,
     896,    -1,    83,   425,   814,   337,   396,   896,    -1,    83,
     223,   814,   337,   396,   896,    -1,    83,   387,   814,   337,
     703,   896,   396,   896,    -1,    83,   400,   896,   301,   814,
     337,   396,   896,    -1,    83,   414,   918,   337,   396,   918,
      -1,    83,   388,   896,   337,   396,   896,    -1,    83,   392,
     356,   313,   640,   337,   396,   896,    -1,    83,   392,   356,
     166,   640,   337,   396,   896,    -1,    83,   392,   356,   390,
     640,   337,   396,   896,    -1,    83,   392,   356,   129,   640,
     337,   396,   896,    -1,   124,    -1,    -1,    83,    80,   902,
     618,   364,   354,   896,    -1,    83,   172,   640,   364,   354,
     896,    -1,    83,   203,   660,   364,   354,   896,    -1,    83,
     360,   814,   364,   354,   896,    -1,    83,   387,   814,   364,
     354,   896,    -1,    83,   405,   640,   364,   354,   896,    -1,
      83,    80,   902,   618,   312,   396,   918,    -1,    83,   134,
     640,   312,   396,   918,    -1,    83,   151,   897,   312,   396,
     918,    -1,    83,   172,   897,   312,   396,   918,    -1,    83,
     203,   660,   312,   396,   918,    -1,    83,   593,   246,   896,
     312,   396,   918,    -1,    83,   303,   694,   479,   693,   480,
     312,   396,   918,    -1,    83,   303,   119,   640,   415,   898,
     312,   396,   918,    -1,    83,   303,   192,   640,   415,   898,
     312,   396,   918,    -1,    83,   354,   896,   312,   396,   918,
      -1,    83,   405,   640,   312,   396,   918,    -1,    83,   388,
     896,   312,   396,   918,    -1,    83,   392,   356,   166,   640,
     312,   396,   918,    -1,    83,   392,   356,   129,   640,   312,
     396,   918,    -1,    -1,   137,   674,   352,   896,    90,   707,
     301,   712,   396,   894,   817,   170,   713,   708,    -1,   287,
      -1,   710,    -1,   479,   709,   480,    -1,   709,   482,   711,
      -1,   711,    -1,   780,    -1,   759,    -1,   770,    -1,   764,
      -1,   715,    -1,   710,    -1,    -1,   359,    -1,   413,    -1,
     162,    -1,   232,    -1,   233,    -1,    82,    -1,    -1,   174,
     352,   896,   301,   894,   536,    -1,   174,   352,   215,   187,
     896,   301,   894,   536,    -1,   288,  1025,    -1,   255,  1025,
      -1,   411,  1025,    -1,   411,   472,    -1,    73,   719,    -1,
      99,   719,   722,    -1,   374,   398,   722,    -1,   126,   719,
      -1,   180,   719,    -1,   349,   719,    -1,   353,  1025,    -1,
     336,   353,  1025,    -1,   336,  1025,    -1,   349,   719,   396,
     353,  1025,    -1,   349,   719,   396,  1025,    -1,   321,   398,
     913,    -1,   126,   322,   913,    -1,   349,   322,   913,    -1,
     432,    -1,   398,    -1,    -1,   242,   252,   516,    -1,   329,
     302,    -1,   329,   433,    -1,   720,    -1,   721,   486,   720,
      -1,   721,   720,    -1,   721,    -1,    -1,   137,   549,   425,
     894,   563,    90,   780,   724,    -1,   137,   305,   339,   549,
     425,   894,   563,    90,   780,   724,    -1,   450,   304,    -1,
     448,   117,   304,    -1,   449,   117,   304,    -1,    -1,   256,
     901,    -1,   137,   151,   897,   430,   727,    -1,   137,   151,
     897,    -1,   728,    -1,   727,   728,    -1,   388,   729,   896,
      -1,   388,   729,   157,    -1,   260,   729,   913,    -1,   260,
     729,   157,    -1,   390,   729,   896,    -1,   390,   729,   157,
      -1,   178,   729,   914,    -1,   178,   729,   157,    -1,   130,
     254,   729,   909,    -1,   312,   729,   896,    -1,   312,   729,
     157,    -1,   466,    -1,    -1,    83,   151,   897,   495,   732,
      -1,    83,   151,   897,   524,    -1,   732,   733,    -1,    -1,
     130,   254,   729,   909,    -1,   174,   151,   897,    -1,   174,
     151,   215,   187,   897,    -1,   137,   172,   640,   737,   821,
     554,    -1,    83,   172,   640,   535,    -1,    83,   172,   640,
     174,   286,   291,    -1,    83,   172,   640,   364,   286,   291,
      -1,    83,   172,   640,    77,   561,    -1,    83,   172,   640,
     174,   131,   896,   536,    -1,    90,    -1,    -1,    83,   392,
     356,   166,   640,   614,    -1,    83,   392,   356,   129,   640,
      77,   263,   196,   895,   430,   639,    -1,    83,   392,   356,
     129,   640,    83,   263,   196,   895,   430,   639,    -1,    83,
     392,   356,   129,   640,    83,   263,   339,   640,   430,   640,
      -1,    83,   392,   356,   129,   640,    83,   263,   196,   895,
     339,   640,   430,   640,    -1,    83,   392,   356,   129,   640,
     174,   263,   196,   895,    -1,    83,   392,   356,   129,   640,
     174,   263,   215,   187,   196,   895,    -1,   137,   626,   134,
     640,   196,   913,   396,   913,   201,   640,    -1,   121,   894,
     742,    -1,   121,    -1,   121,   894,   301,   894,    -1,   415,
     900,    -1,    -1,   416,   747,   748,   746,    -1,   416,   747,
     748,   746,   894,    -1,   416,   747,   748,   746,   744,    -1,
     745,   746,    -1,   745,   746,   894,   749,    -1,    86,    -1,
      85,    -1,   423,    -1,    -1,   202,    -1,    -1,   200,    -1,
      -1,   479,   895,   480,    -1,    -1,   188,   752,   746,   751,
      -1,   780,    -1,   759,    -1,   770,    -1,   764,    -1,   777,
      -1,   756,    -1,   745,    -1,    -1,   321,   980,   755,    90,
     754,    -1,   321,   980,   201,   979,    -1,   780,    -1,   759,
      -1,   770,    -1,   764,    -1,   479,   865,   480,    -1,    -1,
     186,   980,   757,   978,    -1,   137,   549,   387,   578,    90,
     186,   980,   757,    -1,   479,   863,   480,    -1,    -1,   153,
     980,    -1,   153,   321,   980,    -1,   153,    81,    -1,   153,
     321,    81,    -1,   232,   238,   894,   760,   763,    -1,   780,
      -1,   479,   761,   480,   780,    -1,   157,   420,    -1,   761,
     486,   762,    -1,   762,    -1,  1025,   885,    -1,   344,   890,
     988,    -1,    -1,   162,   201,   815,   765,   818,   763,    -1,
     415,   807,    -1,    -1,   261,   787,   893,   767,   769,    -1,
     220,   768,   268,    -1,    -1,    75,   366,    -1,   350,   366,
      -1,   350,   184,    -1,   366,   413,   184,    -1,   366,    -1,
     366,   350,   184,    -1,   184,    -1,    75,   184,    -1,   290,
      -1,    -1,   413,   815,   364,   771,   806,   818,   763,    -1,
     772,    -1,   771,   486,   772,    -1,   773,    -1,   774,    -1,
     775,   466,   887,    -1,   479,   776,   480,   466,   889,    -1,
    1025,   885,    -1,   775,    -1,   776,   486,   775,    -1,   156,
     896,   778,   149,   779,   196,   780,    -1,    -1,   778,   102,
      -1,   778,   231,    -1,   778,   355,    -1,   778,   278,   355,
      -1,    -1,   430,   213,    -1,   431,   213,    -1,   782,    -1,
     781,    -1,   479,   782,   480,    -1,   479,   781,   480,    -1,
     784,    -1,   783,   791,    -1,   783,   790,   800,   795,    -1,
     783,   790,   794,   801,    -1,   784,    -1,   781,    -1,   359,
     789,   890,   785,   806,   817,   798,   799,    -1,   805,    -1,
     783,   408,   788,   783,    -1,   783,   236,   788,   783,    -1,
     783,   183,   788,   783,    -1,   238,   786,    -1,   988,    -1,
      -1,   391,   787,   894,    -1,   389,   787,   894,    -1,   257,
     391,   787,   894,    -1,   257,   389,   787,   894,    -1,   205,
     391,   787,   894,    -1,   205,   389,   787,   894,    -1,   387,
     894,    -1,   894,    -1,   387,    -1,    -1,    81,    -1,    -1,
     169,    -1,   169,   301,   479,   863,   480,    -1,    81,    -1,
      -1,   791,    -1,    -1,   306,   106,   792,    -1,   793,    -1,
     792,   486,   793,    -1,   845,   415,   861,   672,    -1,   845,
     671,   672,    -1,   254,   796,   298,   797,    -1,   298,   797,
     254,   796,    -1,   254,   796,    -1,   298,   797,    -1,   254,
     796,   486,   797,    -1,   794,    -1,    -1,   845,    -1,    81,
      -1,   845,    -1,   209,   106,   863,    -1,    -1,   211,   845,
      -1,    -1,   802,    -1,   196,   329,   302,    -1,   800,    -1,
      -1,   803,    -1,   802,   803,    -1,   196,   413,   804,   769,
      -1,   196,   366,   804,   769,    -1,   296,   895,    -1,    -1,
     420,   889,    -1,   805,   486,   889,    -1,   201,   807,    -1,
      -1,   807,   486,   808,    -1,   808,    -1,   814,    -1,   814,
     810,    -1,   816,    -1,   816,   810,    -1,   816,    90,   479,
     819,   480,    -1,   816,    90,  1025,   479,   819,   480,    -1,
     816,  1025,   479,   819,   480,    -1,   781,    -1,   781,   810,
      -1,   809,    -1,   479,   809,   480,   810,    -1,   479,   809,
     480,    -1,   808,   141,   243,   808,    -1,   808,   811,   243,
     808,   813,    -1,   808,   243,   808,   813,    -1,   808,   274,
     811,   243,   808,    -1,   808,   274,   243,   808,    -1,    90,
    1025,   479,   895,   480,    -1,    90,  1025,    -1,  1025,   479,
     895,   480,    -1,  1025,    -1,   202,   812,    -1,   251,   812,
      -1,   347,   812,    -1,   228,    -1,   308,    -1,    -1,   415,
     479,   895,   480,    -1,   301,   845,    -1,   894,    -1,   894,
     472,    -1,   302,   894,    -1,   302,   479,   894,   480,    -1,
     814,    -1,   814,  1025,    -1,   814,    90,  1025,    -1,   848,
      -1,   428,   845,    -1,    -1,   428,   845,    -1,   428,   143,
     296,   896,    -1,   428,   143,   296,   464,    -1,    -1,   820,
      -1,   819,   486,   820,    -1,  1025,   821,    -1,   824,   822,
      -1,   365,   824,   822,    -1,   824,    89,   477,   909,   478,
      -1,   365,   824,    89,   477,   909,   478,    -1,   477,   478,
     822,    -1,   477,   823,   478,   822,    -1,    -1,   909,    -1,
     479,   823,   480,    -1,   823,   470,   823,    -1,   823,   471,
     823,    -1,   823,   472,   823,    -1,   823,   473,   823,    -1,
     823,   474,   823,    -1,   908,    -1,  1025,    -1,   826,    -1,
     841,    -1,   828,    -1,   830,    -1,   834,    -1,   842,   844,
      -1,   842,   479,   909,   480,   844,    -1,   828,    -1,   831,
      -1,   835,    -1,   841,    -1,  1026,   827,    -1,  1026,   641,
     827,    -1,   479,   863,   480,    -1,    -1,   234,    -1,   235,
      -1,   370,    -1,   101,    -1,   330,    -1,   195,   829,    -1,
     173,   319,    -1,   155,   827,    -1,   154,   827,    -1,   294,
     827,    -1,   104,    -1,   479,   909,   480,    -1,    -1,   832,
      -1,   833,    -1,   832,    -1,   833,    -1,   103,   839,   479,
     863,   480,    -1,   103,   839,    -1,   836,    -1,   837,    -1,
     836,    -1,   837,    -1,   838,   479,   909,   480,   840,    -1,
     838,   840,    -1,   115,   839,    -1,   114,   839,    -1,   421,
      -1,   273,   115,   839,    -1,   273,   114,   839,    -1,   275,
     839,    -1,   422,    -1,    -1,   115,   364,  1025,    -1,    -1,
     395,   479,   909,   480,   843,    -1,   395,   843,    -1,   394,
     479,   909,   480,   843,    -1,   394,   843,    -1,   237,    -1,
     430,   394,   445,    -1,   431,   394,   445,    -1,    -1,   443,
      -1,   269,    -1,   152,    -1,   214,    -1,   266,    -1,   357,
      -1,   443,   396,   269,    -1,   152,   396,   214,    -1,   152,
     396,   266,    -1,   152,   396,   357,    -1,   214,   396,   266,
      -1,   266,   396,   357,    -1,   214,   396,   357,    -1,    -1,
     847,    -1,   845,    72,   821,    -1,   845,    95,   394,   445,
     845,    -1,   470,   845,    -1,   471,   845,    -1,   845,   470,
     845,    -1,   845,   471,   845,    -1,   845,   472,   845,    -1,
     845,   473,   845,    -1,   845,   474,   845,    -1,   845,   475,
     845,    -1,   845,   467,   845,    -1,   845,   468,   845,    -1,
     845,   466,   845,    -1,   845,   860,   845,    -1,   860,   845,
      -1,   845,   860,    -1,   845,    87,   845,    -1,   845,   305,
     845,    -1,   286,   845,    -1,   845,   253,   845,    -1,   845,
     253,   845,   182,   845,    -1,   845,   286,   253,   845,    -1,
     845,   286,   253,   845,   182,   845,    -1,   845,   216,   845,
      -1,   845,   216,   845,   182,   845,    -1,   845,   286,   216,
     845,    -1,   845,   286,   216,   845,   182,   845,    -1,   845,
     368,   396,   845,    -1,   845,   368,   396,   845,   182,   845,
      -1,   845,   286,   368,   396,   845,    -1,   845,   286,   368,
     396,   845,   182,   845,    -1,   845,   241,    -1,   845,   240,
     291,    -1,   845,   289,    -1,   845,   240,   286,   291,    -1,
     856,   309,   856,    -1,   845,   240,   402,    -1,   845,   240,
     286,   402,    -1,   845,   240,   191,    -1,   845,   240,   286,
     191,    -1,   845,   240,   410,    -1,   845,   240,   286,   410,
      -1,   845,   240,   169,   201,   845,    -1,   845,   240,   286,
     169,   201,   845,    -1,   845,   240,   296,   479,   865,   480,
      -1,   845,   240,   286,   296,   479,   865,   480,    -1,   845,
     100,   886,   846,    87,   846,    -1,   845,   286,   100,   886,
     846,    87,   846,    -1,   845,   100,   384,   846,    87,   846,
      -1,   845,   286,   100,   384,   846,    87,   846,    -1,   845,
     220,   876,    -1,   845,   286,   220,   876,    -1,   845,   862,
     857,   781,    -1,   845,   862,   857,   479,   845,   480,    -1,
     409,   781,    -1,   845,   240,   171,    -1,   845,   240,   286,
     171,    -1,   847,    -1,   846,    72,   821,    -1,   471,   846,
      -1,   846,   470,   846,    -1,   846,   471,   846,    -1,   846,
     472,   846,    -1,   846,   473,   846,    -1,   846,   474,   846,
      -1,   846,   475,   846,    -1,   846,   467,   846,    -1,   846,
     468,   846,    -1,   846,   466,   846,    -1,   846,   453,   846,
      -1,   860,   846,    -1,   846,   860,    -1,   846,   240,   169,
     201,   846,    -1,   846,   240,   286,   169,   201,   846,    -1,
     846,   240,   296,   479,   846,   480,    -1,   846,   240,   286,
     296,   479,   846,   480,    -1,   846,   240,   171,    -1,   846,
     240,   286,   171,    -1,   882,    -1,   903,    -1,   464,   885,
      -1,   479,   845,   480,   885,    -1,   877,    -1,   848,    -1,
     781,    -1,   187,   781,    -1,    89,   781,    -1,    89,   867,
      -1,   856,    -1,   902,   479,   480,    -1,   902,   479,   863,
     480,    -1,   902,   479,    81,   863,   480,    -1,   902,   479,
     169,   863,   480,    -1,   902,   479,   472,   480,    -1,   144,
      -1,   146,    -1,   146,   479,   909,   480,    -1,   147,    -1,
     147,   479,   909,   480,    -1,   258,    -1,   258,   479,   909,
     480,    -1,   259,    -1,   259,   479,   909,   480,    -1,   145,
      -1,   148,    -1,   363,    -1,   414,    -1,   112,   479,   845,
      90,   821,   480,    -1,   190,   479,   864,   480,    -1,   310,
     479,   869,   480,    -1,   318,   479,   871,   480,    -1,   382,
     479,   872,   480,    -1,   399,   479,   845,    90,   821,   480,
      -1,   401,   479,   105,   875,   480,    -1,   401,   479,   249,
     875,   480,    -1,   401,   479,   397,   875,   480,    -1,   401,
     479,   875,   480,    -1,   292,   479,   845,   486,   845,   480,
      -1,   122,   479,   863,   480,    -1,   208,   479,   863,   480,
      -1,   250,   479,   863,   480,    -1,   436,   479,   863,   480,
      -1,   437,   479,   271,  1027,   480,    -1,   437,   479,   271,
    1027,   486,   851,   480,    -1,   437,   479,   271,  1027,   486,
     863,   480,    -1,   437,   479,   271,  1027,   486,   851,   486,
     863,   480,    -1,   438,   479,   852,   480,    -1,   439,   479,
     854,   845,   855,   480,    -1,   440,   479,   271,  1027,   480,
      -1,   440,   479,   271,  1027,   486,   845,   480,    -1,   441,
     479,   845,   486,   849,   850,   480,    -1,   424,   845,    -1,
     424,   278,   419,    -1,   486,   373,   444,    -1,   486,   373,
     278,    -1,   486,   373,   278,   419,    -1,    -1,   435,   479,
     852,   480,    -1,   853,    -1,   852,   486,   853,    -1,   845,
      90,  1027,    -1,   845,    -1,   171,    -1,   133,    -1,   320,
     429,    -1,   381,   429,    -1,    -1,   350,   479,   863,   480,
      -1,   350,   479,   480,    -1,   479,   863,   486,   845,   480,
      -1,    88,    -1,   371,    -1,    81,    -1,   453,    -1,   859,
      -1,   470,    -1,   471,    -1,   472,    -1,   474,    -1,   475,
      -1,   473,    -1,   467,    -1,   468,    -1,   466,    -1,   453,
      -1,   303,   479,   694,   480,    -1,   858,    -1,   303,   479,
     694,   480,    -1,   858,    -1,   303,   479,   694,   480,    -1,
     253,    -1,   286,   253,    -1,   216,    -1,   286,   216,    -1,
     845,    -1,   863,   486,   845,    -1,   868,   201,   845,    -1,
      -1,   821,    -1,   865,   486,   821,    -1,   867,    -1,   866,
     486,   867,    -1,   477,   863,   478,    -1,   477,   866,   478,
      -1,  1046,    -1,   443,    -1,   269,    -1,   152,    -1,   214,
      -1,   266,    -1,   357,    -1,   913,    -1,   845,   870,   873,
     874,    -1,   845,   870,   873,    -1,   316,   845,    -1,   846,
     220,   846,    -1,    -1,   845,   873,   874,    -1,   845,   874,
     873,    -1,   845,   873,    -1,   845,   874,    -1,   863,    -1,
      -1,   201,   845,    -1,   196,   845,    -1,   845,   201,   863,
      -1,   201,   863,    -1,   863,    -1,   781,    -1,   479,   863,
     480,    -1,   111,   881,   878,   880,   180,    -1,   878,   879,
      -1,   879,    -1,   427,   845,   393,   845,    -1,   176,   845,
      -1,    -1,   845,    -1,    -1,   892,    -1,   892,   884,    -1,
     481,   899,    -1,   481,   472,    -1,   477,   845,   478,    -1,
     477,   845,   487,   845,   478,    -1,   883,    -1,   884,   883,
      -1,    -1,   885,   883,    -1,    94,    -1,    -1,   845,    -1,
     157,    -1,   887,    -1,   888,   486,   887,    -1,   479,   888,
     480,    -1,   890,   486,   891,    -1,   891,    -1,   845,    90,
    1027,    -1,   845,    -1,   472,    -1,   919,    -1,  1025,    -1,
     894,    -1,   893,   486,   894,    -1,   892,    -1,   892,   884,
      -1,   896,    -1,   895,   486,   896,    -1,  1025,    -1,  1025,
      -1,  1025,    -1,  1027,    -1,  1025,    -1,   913,    -1,  1026,
      -1,   892,   884,    -1,   917,    -1,   825,   913,    -1,   842,
     913,   844,    -1,   842,   479,   909,   480,   913,   844,    -1,
     402,    -1,   191,    -1,   291,    -1,  1042,    -1,   463,    -1,
     465,    -1,   458,    -1,   459,    -1,   452,    -1,   461,    -1,
     462,    -1,   460,    -1,   904,    -1,  1043,    -1,   909,    -1,
     471,   909,    -1,   904,    -1,  1045,    -1,   905,    -1,   911,
      -1,   471,   905,    -1,   471,   904,    -1,   908,    -1,   908,
      -1,  1043,    -1,   904,    -1,   908,    -1,  1043,    -1,   905,
      -1,   904,    -1,   471,   905,    -1,   471,   904,    -1,  1043,
      -1,   908,    -1,   915,    -1,   908,    -1,   905,    -1,   904,
      -1,   906,    -1,   907,    -1,   902,   908,    -1,   902,   479,
     863,   480,   908,    -1,  1043,    -1,  1025,    -1,   300,    -1,
     276,    -1,     9,   396,   921,   928,   929,    -1,     9,   396,
     157,    -1,     9,   930,    -1,   151,   921,    -1,   922,   925,
     927,    -1,   923,   487,   924,   927,   473,   922,   933,    -1,
     932,    -1,   908,    -1,   897,    -1,    -1,  1046,  1045,    -1,
     453,   926,    -1,   924,    -1,    -1,  1025,    -1,  1025,   481,
     926,    -1,   457,    -1,   487,   909,    -1,    -1,    90,   977,
      -1,    -1,   414,   930,    -1,    -1,   931,    -1,   931,   473,
     931,    -1,   931,    22,   106,   931,    -1,   931,   415,   931,
      -1,   918,    -1,   913,    -1,  1045,    -1,   453,  1025,    -1,
      -1,   156,   896,   778,   149,   779,   196,   980,    -1,   186,
     217,   979,    -1,   937,    -1,   948,    -1,   950,    -1,   915,
      -1,   486,   915,    -1,    -1,   844,    -1,   443,   396,   266,
      -1,   443,   396,   357,    -1,   152,   396,   152,    -1,   269,
     396,   269,    -1,    -1,   943,   942,   945,   944,    -1,  1039,
      99,   156,    35,   482,    -1,  1039,   180,   156,    35,   482,
      -1,    -1,   946,    -1,   456,    -1,   950,    -1,   948,    -1,
     946,   950,    -1,   946,   948,    -1,   946,   456,    -1,   950,
      -1,   947,   950,    -1,    -1,    71,   949,   957,   973,  1028,
     822,   482,    -1,    -1,   954,   957,   951,   970,   482,    -1,
      -1,   957,   952,   970,   482,    -1,   960,   482,    -1,   487,
     904,    -1,    -1,   955,   956,    -1,   955,    -1,   956,    -1,
      57,    -1,    68,    -1,    66,    -1,    51,    -1,    52,    -1,
      70,    -1,   966,    -1,   962,    -1,   958,    -1,  1028,   479,
     938,   939,   480,    -1,  1028,   940,    -1,   964,    -1,   181,
    1023,   959,    -1,   181,   959,    -1,   181,  1023,    -1,   483,
    1050,   484,    -1,    -1,   964,   961,   483,   947,   484,    -1,
     960,    -1,    -1,   965,   963,   483,   947,   484,    -1,    44,
    1023,    -1,   408,  1023,    -1,    44,    -1,   408,    -1,   967,
      -1,   969,   968,    -1,    45,    36,    -1,    45,    36,   234,
      -1,    45,    -1,    45,   234,    -1,    45,    26,    -1,    45,
      26,   234,    -1,    45,    26,    26,    -1,    45,    26,    26,
     234,    -1,    45,   114,    -1,    36,    -1,    36,   234,    -1,
     234,    -1,    26,    -1,    26,   234,    -1,    26,    26,    -1,
      26,    26,   234,    -1,     5,    -1,   114,    -1,   173,    -1,
      37,    -1,    -1,   971,    -1,   970,   486,   971,    -1,   973,
    1029,   822,   953,   972,    -1,    -1,   466,  1051,    -1,    -1,
     472,    -1,   472,   472,    -1,   156,   375,  1046,    -1,    17,
     976,    -1,   977,    -1,   143,    -1,    81,    -1,    -1,   897,
      -1,   157,    -1,   932,    -1,   984,   988,    -1,   988,   984,
      -1,   984,    -1,   988,    -1,    -1,   932,    -1,   454,    -1,
     896,    -1,   932,    -1,    19,   896,    -1,    19,    81,    -1,
      29,   896,   983,    -1,    -1,   984,    -1,   415,   989,    -1,
     985,    -1,   415,   987,    16,  1047,    -1,   238,   987,    16,
    1047,    -1,    -1,    38,    -1,   238,  1038,    -1,   986,    -1,
     990,    -1,   990,   486,   989,    -1,   916,    -1,  1042,    -1,
      15,   230,   896,   985,    -1,    15,   992,   896,   985,    -1,
      15,   992,   896,   986,    -1,    30,    -1,    -1,     3,    16,
    1047,    -1,   153,    16,  1047,    -1,   204,    16,  1047,   996,
      -1,   997,    -1,   996,   486,   997,    -1,  1045,   466,  1001,
      -1,   364,    16,  1047,   999,    -1,  1000,    -1,   999,   486,
    1000,    -1,  1001,   466,   911,    -1,    11,    -1,   204,    16,
    1047,   419,   911,  1003,    -1,  1004,    -1,  1003,   486,  1004,
      -1,  1045,   466,  1008,    -1,   364,    16,  1047,   419,   911,
    1006,    -1,  1007,    -1,  1006,   486,  1007,    -1,  1008,   466,
     912,    -1,     8,    -1,    12,    -1,    13,    -1,    14,    -1,
      23,    -1,    24,    -1,    25,    -1,   271,    -1,    27,    -1,
      28,    -1,   319,    -1,    32,    -1,    33,    -1,    34,    -1,
     405,    -1,   364,     4,   466,  1010,    -1,   364,     4,   396,
    1010,    -1,   301,    -1,   297,    -1,   364,   130,   396,   977,
      -1,   364,   130,   466,   977,    -1,   364,   130,   977,    -1,
      -1,   405,  1013,  1028,   240,   957,   822,  1014,    -1,    31,
      -1,    -1,    -1,    46,  1016,  1027,   240,   957,   822,  1014,
      -1,    47,    39,  1018,    -1,    47,   286,    18,  1018,    -1,
      47,    41,  1018,    -1,    10,    -1,    40,    -1,    43,    -1,
      21,   896,    -1,    20,   396,   896,    -1,   170,   896,   479,
    1040,   480,    -1,   170,     6,    -1,     7,   896,   479,  1040,
     480,    -1,     7,   896,    -1,  1020,    -1,  1021,    -1,     6,
      -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,
      -1,    13,    -1,    14,    -1,    18,    -1,    20,    -1,    21,
      -1,    22,    -1,    23,    -1,    24,    -1,    25,    -1,    27,
      -1,    28,    -1,    32,    -1,    33,    -1,    34,    -1,    35,
      -1,    38,    -1,    39,    -1,    40,    -1,    41,    -1,    43,
      -1,     9,    -1,    15,    -1,    17,    -1,    29,    -1,    46,
      -1,    47,    -1,     5,    -1,    26,    -1,    30,    -1,    36,
      -1,    44,    -1,    37,    -1,    45,    -1,  1027,    -1,  1046,
      -1,  1032,    -1,  1034,    -1,  1035,    -1,  1019,    -1,  1030,
      -1,   114,    -1,   420,    -1,  1046,    -1,  1031,    -1,  1035,
      -1,  1019,    -1,  1030,    -1,   114,    -1,   420,    -1,  1046,
      -1,  1031,    -1,  1036,    -1,  1019,    -1,  1022,    -1,  1030,
      -1,  1029,    -1,  1022,    -1,   114,    -1,   230,    -1,   234,
      -1,   408,    -1,   396,    -1,  1030,    -1,  1032,    -1,  1046,
      -1,  1035,    -1,  1036,    -1,  1020,    -1,  1028,    -1,  1037,
      -1,  1033,    -1,  1021,    -1,    51,    -1,    52,    -1,    57,
      -1,    66,    -1,    68,    -1,    71,    -1,    70,    -1,  1032,
      -1,  1033,    -1,   152,    -1,   214,    -1,   266,    -1,   269,
      -1,   357,    -1,   443,    -1,  1034,    -1,   130,    -1,    73,
      -1,    74,    -1,    75,    -1,    76,    -1,    77,    -1,    78,
      -1,    79,    -1,    80,    -1,    82,    -1,    83,    -1,    84,
      -1,    92,    -1,    93,    -1,    95,    -1,    97,    -1,    98,
      -1,    99,    -1,   106,    -1,   107,    -1,   109,    -1,   110,
      -1,   113,    -1,   116,    -1,   118,    -1,   119,    -1,   120,
      -1,   121,    -1,   125,    -1,   126,    -1,   127,    -1,   128,
      -1,   129,    -1,   132,    -1,   133,    -1,   134,    -1,   135,
      -1,   136,    -1,   138,    -1,   139,    -1,   140,    -1,   142,
      -1,   149,    -1,   150,    -1,   151,    -1,   153,    -1,   156,
      -1,   158,    -1,   160,    -1,   162,    -1,   163,    -1,   164,
      -1,   166,    -1,   167,    -1,   168,    -1,   171,    -1,   172,
      -1,   173,    -1,   174,    -1,   175,    -1,   177,    -1,   178,
      -1,   179,    -1,   182,    -1,   185,    -1,   184,    -1,   186,
      -1,   188,    -1,   189,    -1,   192,    -1,   193,    -1,   194,
      -1,   197,    -1,   199,    -1,   203,    -1,   205,    -1,   207,
      -1,   210,    -1,   212,    -1,   213,    -1,   215,    -1,   217,
      -1,   218,    -1,   219,    -1,   221,    -1,   222,    -1,   223,
      -1,   224,    -1,   225,    -1,   226,    -1,   231,    -1,   232,
      -1,   233,    -1,   242,    -1,   244,    -1,   245,    -1,   246,
      -1,   247,    -1,   248,    -1,   252,    -1,   255,    -1,   256,
      -1,   257,    -1,   260,    -1,   261,    -1,   262,    -1,   263,
      -1,   264,    -1,   265,    -1,   267,    -1,   268,    -1,   270,
      -1,   271,    -1,   272,    -1,   277,    -1,   278,    -1,   279,
      -1,   280,    -1,   281,    -1,   282,    -1,   283,    -1,   285,
      -1,   287,    -1,   288,    -1,   290,    -1,   293,    -1,   295,
      -1,   296,    -1,   299,    -1,   303,    -1,   304,    -1,   311,
      -1,   312,    -1,   313,    -1,   314,    -1,   315,    -1,   317,
      -1,   321,    -1,   322,    -1,   320,    -1,   324,    -1,   325,
      -1,   326,    -1,   327,    -1,   328,    -1,   329,    -1,   331,
      -1,   332,    -1,   334,    -1,   335,    -1,   336,    -1,   337,
      -1,   338,    -1,   339,    -1,   340,    -1,   341,    -1,   342,
      -1,   343,    -1,   345,    -1,   346,    -1,   348,    -1,   349,
      -1,   351,    -1,   352,    -1,   353,    -1,   354,    -1,   355,
      -1,   356,    -1,   360,    -1,   361,    -1,   362,    -1,   364,
      -1,   366,    -1,   367,    -1,   369,    -1,   372,    -1,   373,
      -1,   374,    -1,   375,    -1,   376,    -1,   377,    -1,   378,
      -1,   379,    -1,   380,    -1,   381,    -1,   383,    -1,   386,
      -1,   385,    -1,   388,    -1,   389,    -1,   390,    -1,   391,
      -1,   392,    -1,   398,    -1,   400,    -1,   403,    -1,   404,
      -1,   405,    -1,   406,    -1,   407,    -1,   410,    -1,   411,
      -1,   412,    -1,   413,    -1,   416,    -1,   417,    -1,   418,
      -1,   419,    -1,   422,    -1,   424,    -1,   425,    -1,   426,
      -1,   429,    -1,   430,    -1,   431,    -1,   432,    -1,   433,
      -1,   434,    -1,   444,    -1,   445,    -1,   101,    -1,   103,
      -1,   115,    -1,   122,    -1,   154,    -1,   155,    -1,   187,
      -1,   190,    -1,   195,    -1,   208,    -1,   229,    -1,   235,
      -1,   237,    -1,   250,    -1,   273,    -1,   275,    -1,   284,
      -1,   292,    -1,   294,    -1,   307,    -1,   310,    -1,   318,
      -1,   319,    -1,   330,    -1,   350,    -1,   365,    -1,   370,
      -1,   382,    -1,   394,    -1,   395,    -1,   399,    -1,   401,
      -1,   421,    -1,   435,    -1,   436,    -1,   437,    -1,   438,
      -1,   439,    -1,   440,    -1,   441,    -1,   442,    -1,    96,
      -1,   100,    -1,   102,    -1,   141,    -1,   200,    -1,   202,
      -1,   216,    -1,   228,    -1,   240,    -1,   241,    -1,   243,
      -1,   251,    -1,   253,    -1,   274,    -1,   289,    -1,   308,
      -1,   309,    -1,   347,    -1,   368,    -1,   423,    -1,    81,
      -1,    85,    -1,    86,    -1,    87,    -1,    88,    -1,    89,
      -1,    90,    -1,    91,    -1,    94,    -1,   105,    -1,   111,
      -1,   112,    -1,   117,    -1,   123,    -1,   124,    -1,   131,
      -1,   137,    -1,   143,    -1,   144,    -1,   146,    -1,   147,
      -1,   145,    -1,   148,    -1,   157,    -1,   159,    -1,   165,
      -1,   169,    -1,   170,    -1,   176,    -1,   180,    -1,   183,
      -1,   191,    -1,   196,    -1,   198,    -1,   201,    -1,   206,
      -1,   209,    -1,   211,    -1,   220,    -1,   227,    -1,   236,
      -1,   238,    -1,   249,    -1,   254,    -1,   276,    -1,   286,
      -1,   291,    -1,   297,    -1,   298,    -1,   300,    -1,   301,
      -1,   302,    -1,   305,    -1,   306,    -1,   323,    -1,   333,
      -1,   344,    -1,   359,    -1,   363,    -1,   371,    -1,   384,
      -1,   387,    -1,   393,    -1,   397,    -1,   402,    -1,   409,
      -1,   414,    -1,   415,    -1,   427,    -1,   428,    -1,  1041,
      -1,  1038,   486,  1041,    -1,    42,    -1,    -1,  1050,    -1,
    1045,  1044,    -1,  1045,    -1,  1045,  1044,    -1,  1045,    -1,
    1045,    -1,    23,  1045,    -1,    23,   896,    -1,   455,    -1,
     451,    -1,   454,    -1,   896,    -1,   932,    -1,  1053,    -1,
     479,   480,    -1,   479,  1049,   480,    -1,  1048,    -1,  1049,
    1048,    -1,  1051,    -1,  1050,   486,  1051,    -1,  1049,    -1,
     483,  1050,   484,    -1,  1053,    -1,   479,    -1,   480,    -1,
     486,    -1,   482,    -1,   451,    -1,   454,    -1,   904,    -1,
     905,    -1,   908,    -1,   472,    -1,   470,    -1,   471,    -1,
     473,    -1,   474,    -1,   291,    -1,    48,    -1,    49,    -1,
      50,    -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,
      55,    -1,    56,    -1,    57,    -1,    58,    -1,    59,    -1,
      61,    -1,    60,    -1,    62,    -1,    63,    -1,    64,    -1,
      65,    -1,    66,    -1,    67,    -1,    68,    -1,    69,    -1,
      71,    -1,    70,    -1,     5,    -1,   181,    -1,   214,    -1,
     234,    -1,    26,    -1,   266,    -1,   269,    -1,   357,    -1,
      36,    -1,    37,    -1,    44,    -1,    45,    -1,   443,    -1,
     114,    -1,   195,    -1,   396,    -1,   408,    -1,   421,    -1,
     477,    -1,   478,    -1,   466,    -1,   487,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   684,   684,   686,   687,   690,   691,   692,   698,   699,
     700,   701,   702,   705,   718,   719,   720,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   730,   731,   732,   733,
     734,   735,   759,   760,   761,   762,   763,   764,   765,   766,
     767,   768,   769,   770,   771,   772,   773,   774,   775,   776,
     777,   778,   779,   780,   781,   782,   789,   790,   791,   792,
     793,   794,   795,   796,   797,   798,   799,   800,   801,   802,
     803,   804,   805,   806,   807,   808,   809,   810,   811,   812,
     813,   814,   815,   816,   817,   818,   827,   828,   829,   830,
     831,   832,   833,   834,   835,   836,   837,   843,   844,   845,
     846,   847,   848,   849,   850,   851,   857,   867,   871,   879,
     883,   894,   904,   905,   916,   923,   929,   940,   946,   955,
     962,   968,   977,   984,  1005,  1009,  1010,  1019,  1020,  1021,
    1022,  1023,  1024,  1025,  1026,  1027,  1028,  1029,  1030,  1031,
    1032,  1033,  1034,  1035,  1036,  1037,  1038,  1039,  1040,  1050,
    1061,  1065,  1075,  1078,  1088,  1090,  1100,  1102,  1113,  1123,
    1127,  1128,  1137,  1139,  1150,  1152,  1156,  1157,  1160,  1161,
    1168,  1169,  1170,  1171,  1172,  1173,  1186,  1188,  1190,  1195,
    1197,  1199,  1201,  1203,  1206,  1208,  1210,  1212,  1214,  1216,
    1218,  1220,  1224,  1225,  1229,  1231,  1235,  1236,  1237,  1238,
    1241,  1242,  1252,  1255,  1256,  1257,  1258,  1268,  1269,  1270,
    1272,  1274,  1276,  1280,  1281,  1282,  1285,  1286,  1289,  1291,
    1293,  1295,  1297,  1304,  1306,  1308,  1310,  1312,  1318,  1319,
    1322,  1326,  1328,  1332,  1333,  1339,  1343,  1344,  1345,  1346,
    1356,  1358,  1364,  1365,  1369,  1373,  1376,  1379,  1382,  1385,
    1388,  1391,  1394,  1397,  1400,  1403,  1406,  1409,  1412,  1415,
    1418,  1421,  1424,  1427,  1430,  1433,  1436,  1439,  1442,  1445,
    1448,  1450,  1454,  1455,  1461,  1464,  1466,  1468,  1473,  1474,
    1477,  1478,  1479,  1482,  1483,  1493,  1495,  1499,  1511,  1520,
    1521,  1524,  1525,  1526,  1529,  1530,  1533,  1534,  1535,  1537,
    1539,  1540,  1541,  1543,  1545,  1547,  1552,  1553,  1556,  1557,
    1564,  1567,  1570,  1571,  1581,  1584,  1594,  1595,  1596,  1597,
    1598,  1599,  1600,  1604,  1607,  1609,  1611,  1615,  1616,  1617,
    1620,  1624,  1625,  1628,  1630,  1631,  1645,  1647,  1649,  1651,
    1653,  1655,  1657,  1672,  1673,  1674,  1675,  1678,  1682,  1684,
    1688,  1689,  1690,  1691,  1692,  1693,  1700,  1702,  1706,  1708,
    1710,  1712,  1717,  1718,  1721,  1723,  1727,  1730,  1732,  1738,
    1741,  1742,  1743,  1744,  1745,  1748,  1752,  1756,  1757,  1758,
    1759,  1760,  1763,  1766,  1769,  1770,  1771,  1772,  1775,  1776,
    1777,  1778,  1781,  1782,  1785,  1786,  1795,  1794,  1805,  1811,
    1814,  1817,  1819,  1823,  1834,  1838,  1842,  1843,  1846,  1848,
    1850,  1852,  1854,  1856,  1858,  1860,  1862,  1864,  1866,  1870,
    1871,  1882,  1884,  1889,  1890,  1897,  1898,  1901,  1904,  1906,
    1909,  1912,  1914,  1918,  1919,  1929,  1933,  1934,  1948,  1950,
    1963,  1967,  1974,  1975,  1978,  1980,  1982,  1986,  1987,  1988,
    1991,  1994,  1997,  1998,  2001,  2002,  2005,  2007,  2010,  2013,
    2014,  2017,  2018,  2021,  2022,  2029,  2030,  2038,  2043,  2045,
    2049,  2051,  2055,  2057,  2068,  2076,  2091,  2093,  2095,  2097,
    2099,  2101,  2103,  2105,  2107,  2109,  2111,  2115,  2119,  2120,
    2123,  2124,  2128,  2129,  2130,  2131,  2134,  2135,  2138,  2141,
    2142,  2145,  2148,  2149,  2152,  2159,  2160,  2163,  2165,  2167,
    2169,  2171,  2175,  2176,  2179,  2180,  2183,  2184,  2187,  2191,
    2193,  2197,  2198,  2202,  2204,  2208,  2210,  2214,  2216,  2229,
    2234,  2246,  2248,  2252,  2253,  2254,  2255,  2256,  2257,  2258,
    2259,  2260,  2261,  2262,  2263,  2266,  2268,  2272,  2273,  2276,
    2277,  2286,  2301,  2306,  2311,  2316,  2321,  2326,  2331,  2336,
    2341,  2343,  2347,  2348,  2349,  2350,  2351,  2352,  2353,  2354,
    2355,  2356,  2357,  2358,  2359,  2360,  2363,  2374,  2375,  2378,
    2380,  2382,  2384,  2386,  2388,  2390,  2392,  2394,  2396,  2398,
    2400,  2402,  2404,  2406,  2408,  2412,  2413,  2414,  2415,  2416,
    2417,  2418,  2419,  2420,  2421,  2422,  2423,  2426,  2427,  2437,
    2441,  2443,  2447,  2448,  2449,  2452,  2454,  2458,  2459,  2460,
    2461,  2464,  2466,  2468,  2470,  2472,  2474,  2476,  2478,  2482,
    2484,  2488,  2489,  2492,  2497,  2500,  2502,  2506,  2515,  2520,
    2524,  2525,  2528,  2529,  2545,  2548,  2553,  2554,  2557,  2560,
    2563,  2564,  2567,  2569,  2571,  2575,  2576,  2577,  2580,  2581,
    2582,  2585,  2586,  2587,  2590,  2593,  2598,  2599,  2602,  2604,
    2608,  2610,  2614,  2615,  2616,  2617,  2618,  2621,  2622,  2623,
    2624,  2627,  2629,  2633,  2635,  2645,  2647,  2649,  2654,  2656,
    2661,  2663,  2665,  2667,  2669,  2671,  2673,  2675,  2677,  2679,
    2681,  2683,  2685,  2689,  2691,  2693,  2697,  2698,  2702,  2706,
    2707,  2710,  2711,  2724,  2726,  2730,  2732,  2736,  2738,  2742,
    2747,  2749,  2751,  2756,  2758,  2762,  2765,  2770,  2771,  2775,
    2779,  2780,  2790,  2792,  2794,  2798,  2799,  2802,  2803,  2814,
    2816,  2818,  2820,  2822,  2824,  2826,  2828,  2830,  2832,  2834,
    2836,  2838,  2840,  2842,  2844,  2846,  2848,  2850,  2852,  2854,
    2858,  2859,  2869,  2871,  2873,  2875,  2877,  2879,  2889,  2891,
    2893,  2895,  2897,  2899,  2901,  2903,  2905,  2907,  2909,  2911,
    2913,  2915,  2927,  2926,  2936,  2937,  2938,  2942,  2944,  2948,
    2949,  2950,  2951,  2952,  2955,  2956,  2960,  2961,  2962,  2963,
    2966,  2967,  2968,  2971,  2973,  2985,  2989,  2993,  2995,  3008,
    3009,  3010,  3011,  3012,  3013,  3014,  3015,  3016,  3017,  3018,
    3019,  3020,  3021,  3024,  3025,  3026,  3030,  3032,  3033,  3037,
    3038,  3039,  3043,  3044,  3055,  3057,  3066,  3071,  3076,  3082,
    3092,  3104,  3106,  3110,  3112,  3116,  3118,  3120,  3122,  3124,
    3126,  3128,  3130,  3132,  3134,  3136,  3140,  3141,  3152,  3156,
    3161,  3162,  3166,  3176,  3178,  3189,  3196,  3198,  3200,  3202,
    3204,  3208,  3209,  3213,  3218,  3220,  3222,  3224,  3226,  3228,
    3233,  3247,  3249,  3251,  3256,  3257,  3268,  3270,  3272,  3276,
    3278,  3282,  3283,  3286,  3287,  3290,  3291,  3294,  3295,  3298,
    3301,  3312,  3317,  3318,  3319,  3320,  3321,  3322,  3325,  3326,
    3329,  3335,  3344,  3345,  3346,  3347,  3350,  3351,  3354,  3359,
    3364,  3365,  3368,  3369,  3370,  3371,  3381,  3386,  3388,  3390,
    3394,  3396,  3400,  3404,  3405,  3415,  3419,  3420,  3423,  3427,
    3430,  3433,  3434,  3435,  3436,  3437,  3438,  3439,  3440,  3443,
    3444,  3454,  3463,  3464,  3468,  3469,  3473,  3476,  3479,  3482,
    3483,  3492,  3523,  3524,  3525,  3526,  3527,  3531,  3537,  3538,
    3548,  3550,  3554,  3556,  3560,  3562,  3564,  3566,  3570,  3571,
    3574,  3578,  3580,  3582,  3584,  3588,  3593,  3594,  3604,  3606,
    3608,  3610,  3612,  3614,  3616,  3618,  3622,  3623,  3626,  3627,
    3630,  3632,  3634,  3637,  3640,  3641,  3644,  3648,  3649,  3652,
    3654,  3658,  3660,  3662,  3664,  3666,  3673,  3674,  3677,  3678,
    3681,  3691,  3694,  3697,  3700,  3704,  3705,  3709,  3710,  3714,
    3715,  3719,  3721,  3726,  3727,  3730,  3732,  3744,  3745,  3748,
    3749,  3759,  3761,  3763,  3765,  3767,  3769,  3771,  3773,  3778,
    3780,  3782,  3803,  3805,  3807,  3809,  3811,  3813,  3817,  3819,
    3821,  3823,  3827,  3828,  3829,  3830,  3834,  3835,  3845,  3847,
    3851,  3853,  3855,  3857,  3861,  3863,  3865,  3869,  3872,  3873,
    3876,  3877,  3878,  3879,  3882,  3884,  3888,  3901,  3903,  3905,
    3907,  3912,  3918,  3925,  3932,  3933,  3934,  3935,  3936,  3937,
    3938,  3939,  3940,  3943,  3944,  3945,  3946,  3947,  3948,  3950,
    3954,  3955,  3956,  3957,  3960,  3961,  3964,  3965,  3973,  3975,
    3977,  3979,  3981,  3983,  3985,  3987,  3989,  3991,  3993,  3997,
    4000,  4008,  4009,  4012,  4013,  4016,  4020,  4029,  4030,  4033,
    4034,  4037,  4041,  4045,  4047,  4049,  4051,  4053,  4055,  4059,
    4062,  4065,  4068,  4071,  4073,  4075,  4077,  4081,  4085,  4087,
    4090,  4093,  4094,  4095,  4096,  4097,  4098,  4099,  4100,  4101,
    4102,  4103,  4104,  4105,  4106,  4132,  4134,  4136,  4147,  4149,
    4151,  4153,  4155,  4157,  4159,  4161,  4163,  4165,  4167,  4169,
    4171,  4173,  4175,  4177,  4179,  4181,  4183,  4185,  4187,  4189,
    4191,  4193,  4195,  4197,  4199,  4201,  4203,  4205,  4207,  4209,
    4211,  4213,  4224,  4226,  4228,  4230,  4232,  4234,  4236,  4238,
    4240,  4242,  4244,  4246,  4248,  4250,  4252,  4254,  4256,  4258,
    4260,  4262,  4264,  4276,  4278,  4280,  4282,  4284,  4286,  4288,
    4290,  4292,  4294,  4296,  4298,  4300,  4302,  4304,  4306,  4308,
    4310,  4312,  4314,  4316,  4328,  4330,  4332,  4334,  4336,  4338,
    4340,  4342,  4344,  4346,  4348,  4360,  4362,  4364,  4366,  4368,
    4370,  4372,  4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,
    4390,  4392,  4394,  4396,  4398,  4400,  4402,  4404,  4406,  4409,
    4411,  4413,  4415,  4417,  4419,  4421,  4423,  4425,  4427,  4429,
    4431,  4433,  4435,  4437,  4439,  4441,  4443,  4451,  4453,  4457,
    4459,  4461,  4464,  4467,  4471,  4473,  4477,  4479,  4483,  4484,
    4487,  4488,  4489,  4492,  4494,  4496,  4500,  4501,  4502,  4505,
    4506,  4509,  4510,  4511,  4512,  4513,  4514,  4515,  4516,  4517,
    4520,  4521,  4524,  4525,  4528,  4529,  4530,  4531,  4532,  4533,
    4536,  4538,  4542,  4545,  4548,  4550,  4554,  4555,  4559,  4560,
    4566,  4567,  4568,  4569,  4570,  4571,  4572,  4573,  4577,  4579,
    4584,  4588,  4591,  4594,  4596,  4598,  4600,  4602,  4605,  4608,
    4612,  4616,  4618,  4620,  4624,  4626,  4633,  4637,  4639,  4643,
    4647,  4650,  4653,  4654,  4657,  4658,  4662,  4663,  4664,  4665,
    4668,  4669,  4673,  4674,  4677,  4678,  4682,  4683,  4687,  4688,
    4691,  4699,  4701,  4706,  4708,  4710,  4786,  4787,  4790,  4792,
    4796,  4798,  4802,  4804,  4809,  4810,  4811,  4812,  4813,  4815,
    4817,  4819,  4827,  4829,  4831,  4833,  4835,  4837,  4839,  4841,
    4845,  4846,  4847,  4848,  4849,  4859,  4870,  4881,  4887,  4888,
    4891,  4892,  4895,  4903,  4906,  4914,  4915,  4924,  4933,  4945,
    4946,  4949,  4950,  4951,  4954,  4955,  4956,  4957,  4958,  4961,
    4962,  4965,  4966,  4967,  4968,  4969,  4970,  4971,  4973,  4976,
    4978,  4985,  5001,  5003,  5006,  5008,  5012,  5024,  5040,  5044,
    5055,  5056,  5059,  5071,  5080,  5081,  5084,  5085,  5086,  5089,
    5090,  5093,  5094,  5097,  5098,  5101,  5103,  5105,  5107,  5111,
    5118,  5141,  5174,  5184,  5191,  5228,  5237,  5239,  5240,  5243,
    5245,  5246,  5249,  5250,  5251,  5252,  5253,  5260,  5259,  5269,
    5271,  5273,  5274,  5275,  5278,  5279,  5280,  5281,  5282,  5285,
    5286,  5290,  5289,  5306,  5304,  5319,  5318,  5331,  5337,  5338,
    5341,  5343,  5344,  5347,  5348,  5349,  5350,  5353,  5354,  5357,
    5365,  5382,  5390,  5413,  5511,  5545,  5547,  5549,  5553,  5557,
    5556,  5607,  5609,  5608,  5623,  5629,  5636,  5641,  5644,  5645,
    5648,  5649,  5650,  5651,  5652,  5653,  5654,  5662,  5670,  5673,
    5674,  5675,  5676,  5677,  5678,  5686,  5694,  5695,  5696,  5699,
    5700,  5703,  5705,  5709,  5795,  5796,  5803,  5804,  5805,  5811,
    5820,  5823,  5824,  5825,  5826,  5829,  5830,  5831,  5834,  5835,
    5836,  5837,  5838,  5841,  5843,  5847,  5860,  5867,  5868,  5874,
    5876,  5877,  5880,  5881,  5884,  5891,  5898,  5898,  5900,  5901,
    5904,  5904,  5906,  5916,  5923,  5930,  5937,  5946,  5947,  5959,
    5970,  5981,  5985,  5986,  5989,  5994,  5998,  5999,  6002,  6009,
    6016,  6020,  6021,  6024,  6027,  6031,  6032,  6035,  6042,  6043,
    6044,  6045,  6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,
    6054,  6055,  6056,  6063,  6064,  6067,  6068,  6075,  6076,  6077,
    6084,  6083,  6100,  6101,  6108,  6107,  6176,  6182,  6188,  6196,
    6202,  6208,  6214,  6220,  6226,  6232,  6238,  6244,  6255,  6256,
    6259,  6260,  6261,  6262,  6263,  6264,  6265,  6266,  6267,  6268,
    6269,  6270,  6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,
    6279,  6280,  6281,  6282,  6283,  6284,  6287,  6288,  6289,  6290,
    6291,  6292,  6296,  6297,  6298,  6299,  6300,  6301,  6302,  6305,
    6319,  6320,  6321,  6322,  6323,  6324,  6325,  6326,  6330,  6331,
    6332,  6333,  6334,  6335,  6336,  6340,  6341,  6342,  6343,  6344,
    6345,  6351,  6352,  6353,  6354,  6355,  6356,  6357,  6358,  6359,
    6362,  6363,  6364,  6365,  6368,  6369,  6370,  6371,  6374,  6375,
    6376,  6377,  6378,  6379,  6380,  6398,  6398,  6400,  6401,  6402,
    6403,  6404,  6405,  6411,  6412,  6415,  6416,  6417,  6418,  6419,
    6420,  6421,  6422,  6423,  6424,  6425,  6426,  6427,  6428,  6429,
    6430,  6431,  6432,  6433,  6434,  6435,  6436,  6437,  6438,  6439,
    6440,  6441,  6442,  6443,  6444,  6445,  6446,  6448,  6449,  6450,
    6451,  6452,  6453,  6454,  6455,  6456,  6457,  6458,  6459,  6461,
    6462,  6463,  6464,  6465,  6466,  6467,  6468,  6469,  6470,  6471,
    6472,  6473,  6474,  6475,  6476,  6477,  6478,  6480,  6481,  6482,
    6483,  6484,  6485,  6486,  6487,  6488,  6489,  6490,  6491,  6492,
    6493,  6494,  6495,  6496,  6498,  6499,  6500,  6501,  6502,  6503,
    6504,  6505,  6506,  6507,  6508,  6509,  6510,  6511,  6512,  6513,
    6514,  6515,  6516,  6517,  6518,  6519,  6520,  6521,  6522,  6523,
    6524,  6525,  6526,  6528,  6529,  6531,  6532,  6533,  6534,  6535,
    6536,  6537,  6538,  6539,  6540,  6541,  6542,  6543,  6544,  6545,
    6546,  6547,  6548,  6549,  6550,  6551,  6552,  6553,  6554,  6555,
    6556,  6557,  6558,  6559,  6560,  6561,  6562,  6563,  6564,  6565,
    6566,  6567,  6568,  6569,  6570,  6571,  6572,  6573,  6574,  6575,
    6576,  6577,  6578,  6579,  6580,  6581,  6582,  6583,  6584,  6585,
    6586,  6587,  6589,  6590,  6591,  6592,  6593,  6594,  6595,  6596,
    6597,  6598,  6599,  6600,  6601,  6602,  6603,  6604,  6605,  6606,
    6607,  6608,  6609,  6610,  6611,  6612,  6613,  6614,  6615,  6616,
    6617,  6618,  6619,  6620,  6621,  6622,  6623,  6624,  6625,  6626,
    6627,  6628,  6629,  6630,  6631,  6632,  6633,  6634,  6635,  6636,
    6637,  6638,  6639,  6641,  6655,  6656,  6660,  6661,  6662,  6663,
    6664,  6665,  6666,  6667,  6668,  6672,  6673,  6674,  6675,  6676,
    6677,  6678,  6679,  6680,  6681,  6682,  6683,  6684,  6685,  6686,
    6687,  6688,  6689,  6690,  6691,  6692,  6695,  6696,  6697,  6698,
    6699,  6700,  6701,  6702,  6703,  6717,  6718,  6719,  6720,  6721,
    6722,  6723,  6724,  6725,  6726,  6727,  6728,  6729,  6730,  6731,
    6732,  6733,  6734,  6735,  6736,  6746,  6747,  6748,  6749,  6750,
    6751,  6752,  6753,  6754,  6755,  6756,  6757,  6758,  6759,  6760,
    6761,  6762,  6763,  6764,  6765,  6766,  6767,  6768,  6769,  6770,
    6771,  6772,  6773,  6774,  6775,  6776,  6777,  6778,  6779,  6780,
    6781,  6782,  6783,  6784,  6785,  6786,  6787,  6788,  6789,  6790,
    6791,  6792,  6793,  6794,  6795,  6796,  6797,  6798,  6799,  6800,
    6801,  6802,  6803,  6804,  6805,  6806,  6807,  6808,  6812,  6813,
    6817,  6818,  6819,  6820,  6821,  6825,  6825,  6828,  6834,  6835,
    6838,  6840,  6845,  6855,  6862,  6863,  6864,  6867,  6899,  6900,
    6903,  6905,  6913,  6914,  6915,  6919,  6920,  6924,  6925,  6928,
    6929,  6932,  6933,  6934,  6935,  6936,  6939,  6940,  6941,  6942,
    6943,  6944,  6945,  6946,  6947,  6948,  6949,  6950,  6951,  6952,
    6953,  6954,  6955,  6956,  6957,  6958,  6959,  6960,  6961,  6962,
    6963,  6964,  6965,  6966,  6967,  6968,  6969,  6970,  6971,  6972,
    6973,  6974,  6975,  6976,  6977,  6978,  6979,  6980,  6981,  6982,
    6983,  6984,  6985,  6986,  6987,  6988,  6989,  6990,  6991,  6992,
    6993,  6994,  6995
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", 
  "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", 
  "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", 
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", 
  "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", 
  "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", 
  "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONTENT_P", "CONVERSION_P", "COPY", "COST", "CREATE", 
  "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", 
  "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", 
  "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", 
  "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", 
  "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WITH", "WITHOUT", "WORK", "WRITE", "XML_P", 
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", 
  "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", 
  "NULLS_FIRST", "NULLS_LAST", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ECONST", "NCONST", 
  "ICONST", "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", 
  "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", 
  "'.'", "';'", "'{'", "'}'", "\"=\"", "','", "':'", "$accept", "prog", 
  "statements", "statement", "at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", 
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_name", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "SetResetClause", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "TableLikeOptionList", 
  "TableLikeOption", "TableConstraint", "ConstraintElem", 
  "opt_column_list", "columnList", "columnElem", "key_match", 
  "key_actions", "key_delete", "key_update", "key_action", "OptInherit", 
  "OptWith", "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "CreateAsStmt", "@1", "create_as_target", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_trusted", 
  "handler_name", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "FetchStmt", "fetch_direction", "fetch_count", "from_in", "CommentStmt", 
  "comment_type", "comment_text", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", "IndexStmt", 
  "index_opt_unique", "access_method_clause", "index_params", 
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "PreparableStmt", 
  "prep_type_clause", "ExecuteStmt", "execute_param_clause", 
  "DeallocateStmt", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "returning_clause", "DeleteStmt", "using_clause", 
  "LockStmt", "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "set_clause_list", "set_clause", "single_set_clause", 
  "multiple_set_clause", "set_target", "set_target_list", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "where_or_current_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "opt_type_modifiers", 
  "Numeric", "opt_float", "Bit", "ConstBit", "BitWithLength", 
  "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "row", "sub_type", 
  "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", 
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration", 
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@3", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@4", "var_declaration", "@5", "@6", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execute_rest", 
  "execstring", "prepared_name", "ECPGFree", "ECPGOpen", "opt_ecpg_using", 
  "ecpg_using", "using_descriptor", "into_descriptor", "opt_sql", 
  "ecpg_into", "using_list", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", "@9", 
  "opt_reference", "ECPGVar", "@10", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "col_name_keyword", "type_func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,    61,    60,    62,   721,
      43,    45,    42,    47,    37,    94,   722,    91,    93,    40,
      41,    46,    59,   123,   125,   723,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   488,   489,   490,   490,   491,   491,   491,   491,   491,
     491,   491,   491,   492,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   494,   495,   495,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   497,
     498,   499,   500,   501,   502,   502,   503,   503,   504,   505,
     506,   506,   507,   507,   508,   508,   509,   509,   510,   510,
     511,   511,   511,   511,   511,   511,   512,   512,   512,   513,
     513,   513,   513,   513,   513,   513,   513,   513,   513,   513,
     513,   513,   514,   514,   515,   515,   516,   516,   516,   516,
     517,   517,   517,   518,   518,   518,   518,   519,   519,   519,
     519,   519,   519,   520,   520,   520,   521,   521,   522,   522,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   524,
     525,   526,   526,   527,   527,   528,   529,   529,   529,   529,
     530,   530,   531,   531,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   533,   533,   534,   534,   534,   534,   535,   535,
     536,   536,   536,   537,   537,   538,   538,   539,   539,   540,
     540,   541,   541,   541,   542,   542,   543,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   548,   549,   549,   549,   549,
     549,   549,   549,   550,   550,   551,   551,   552,   552,   552,
     553,   554,   554,   555,   555,   555,   556,   556,   556,   556,
     556,   556,   556,   557,   557,   557,   557,   558,   559,   559,
     560,   560,   560,   560,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   566,   566,   566,
     567,   567,   567,   567,   567,   568,   569,   570,   570,   570,
     570,   570,   571,   571,   572,   572,   572,   572,   573,   573,
     573,   573,   574,   574,   575,   575,   577,   576,   578,   579,
     579,   580,   580,   581,   582,   583,   584,   584,   585,   585,
     585,   585,   585,   585,   585,   585,   585,   585,   585,   586,
     586,   587,   587,   588,   588,   589,   589,   590,   590,   591,
     591,   592,   592,   593,   593,   594,   595,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   600,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   604,   605,
     605,   606,   606,   607,   607,   607,   607,   607,   608,   608,
     609,   609,   610,   610,   611,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   614,   615,   615,
     616,   616,   617,   617,   617,   617,   618,   618,   619,   620,
     620,   621,   622,   622,   623,   624,   624,   625,   625,   625,
     625,   625,   626,   626,   627,   627,   628,   628,   629,   630,
     630,   631,   631,   632,   632,   633,   633,   634,   634,   635,
     636,   637,   637,   638,   638,   638,   638,   638,   638,   638,
     638,   638,   638,   638,   638,   639,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   645,   646,   646,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   648,   648,   648,   648,   648,
     648,   648,   648,   648,   648,   648,   648,   649,   649,   650,
     651,   651,   652,   652,   652,   653,   653,   654,   654,   654,
     654,   655,   655,   655,   655,   655,   655,   655,   655,   656,
     656,   657,   657,   658,   658,   659,   659,   660,   661,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     668,   668,   669,   669,   669,   670,   670,   670,   671,   671,
     671,   672,   672,   672,   673,   673,   674,   674,   675,   675,
     676,   676,   677,   677,   677,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   682,   682,   682,   683,   683,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   685,   685,   685,   686,   686,   687,   688,
     688,   689,   689,   690,   690,   691,   691,   692,   692,   693,
     693,   693,   693,   694,   694,   695,   695,   696,   696,   697,
     698,   698,   699,   699,   699,   700,   700,   701,   701,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     703,   703,   704,   704,   704,   704,   704,   704,   705,   705,
     705,   705,   705,   705,   705,   705,   705,   705,   705,   705,
     705,   705,   707,   706,   708,   708,   708,   709,   709,   710,
     710,   710,   710,   710,   711,   711,   712,   712,   712,   712,
     713,   713,   713,   714,   714,   715,   716,   717,   717,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   719,   719,   719,   720,   720,   720,   721,
     721,   721,   722,   722,   723,   723,   724,   724,   724,   724,
     725,   726,   726,   727,   727,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   729,   729,   730,   731,
     732,   732,   733,   734,   734,   735,   736,   736,   736,   736,
     736,   737,   737,   738,   739,   739,   739,   739,   739,   739,
     740,   741,   741,   741,   742,   742,   743,   743,   743,   744,
     744,   745,   745,   746,   746,   747,   747,   748,   748,   749,
     749,   750,   751,   751,   751,   751,   751,   751,   752,   752,
     753,   753,   754,   754,   754,   754,   755,   755,   756,   756,
     757,   757,   758,   758,   758,   758,   759,   760,   760,   760,
     761,   761,   762,   763,   763,   764,   765,   765,   766,   767,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   769,
     769,   770,   771,   771,   772,   772,   773,   774,   775,   776,
     776,   777,   778,   778,   778,   778,   778,   779,   779,   779,
     780,   780,   781,   781,   782,   782,   782,   782,   783,   783,
     784,   784,   784,   784,   784,   785,   785,   785,   786,   786,
     786,   786,   786,   786,   786,   786,   787,   787,   788,   788,
     789,   789,   789,   789,   790,   790,   791,   792,   792,   793,
     793,   794,   794,   794,   794,   794,   795,   795,   796,   796,
     797,   798,   798,   799,   799,   800,   800,   801,   801,   802,
     802,   803,   803,   804,   804,   805,   805,   806,   806,   807,
     807,   808,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   809,   809,   809,   809,   809,   809,   810,   810,
     810,   810,   811,   811,   811,   811,   812,   812,   813,   813,
     814,   814,   814,   814,   815,   815,   815,   816,   817,   817,
     818,   818,   818,   818,   819,   819,   820,   821,   821,   821,
     821,   822,   822,   822,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   824,   824,   824,   824,   824,   824,   824,
     825,   825,   825,   825,   826,   826,   827,   827,   828,   828,
     828,   828,   828,   828,   828,   828,   828,   828,   828,   829,
     829,   830,   830,   831,   831,   832,   833,   834,   834,   835,
     835,   836,   837,   838,   838,   838,   838,   838,   838,   839,
     839,   840,   840,   841,   841,   841,   841,   842,   843,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   849,   849,   850,
     850,   850,   850,   851,   852,   852,   853,   853,   854,   854,
     855,   855,   855,   856,   856,   856,   857,   857,   857,   858,
     858,   859,   859,   859,   859,   859,   859,   859,   859,   859,
     860,   860,   861,   861,   862,   862,   862,   862,   862,   862,
     863,   863,   864,   864,   865,   865,   866,   866,   867,   867,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   869,
     870,   871,   871,   872,   872,   872,   872,   872,   872,   873,
     874,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     880,   880,   881,   881,   882,   882,   883,   883,   883,   883,
     884,   884,   885,   885,   886,   886,   887,   887,   888,   888,
     889,   890,   890,   891,   891,   891,   892,   892,   893,   893,
     894,   894,   895,   895,   896,   897,   898,   899,   900,   901,
     902,   902,   903,   903,   903,   903,   903,   903,   903,   903,
     904,   905,   906,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   911,   911,   912,   912,   912,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   915,   915,   915,   916,
     916,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     919,   919,   920,   920,   920,   920,   921,   921,   921,   921,
     922,   922,   923,   924,   925,   925,   926,   926,   926,   927,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   932,   933,   933,   934,   935,   936,   937,   937,   938,
     939,   939,   940,   940,   940,   940,   940,   942,   941,   943,
     944,   945,   945,   945,   946,   946,   946,   946,   946,   947,
     947,   949,   948,   951,   950,   952,   950,   950,   953,   953,
     954,   954,   954,   955,   955,   955,   955,   956,   956,   957,
     957,   957,   957,   957,   957,   958,   958,   958,   959,   961,
     960,   962,   963,   962,   964,   964,   965,   965,   966,   966,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   969,
     969,   970,   970,   971,   972,   972,   973,   973,   973,   974,
     975,   976,   976,   976,   976,   977,   977,   977,   978,   978,
     978,   978,   978,   979,   979,   980,   980,   981,   981,   982,
     983,   983,   984,   984,   985,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   992,   992,   993,
     994,   995,   996,   996,   997,   998,   999,   999,  1000,  1001,
    1002,  1003,  1003,  1004,  1005,  1006,  1006,  1007,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1009,  1009,  1010,  1010,  1011,  1011,  1011,
    1013,  1012,  1014,  1014,  1016,  1015,  1017,  1017,  1017,  1018,
    1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1019,  1019,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,  1021,
    1021,  1021,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,
    1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1025,  1025,
    1025,  1025,  1025,  1025,  1025,  1026,  1026,  1026,  1026,  1026,
    1026,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,
    1028,  1028,  1028,  1028,  1029,  1029,  1029,  1029,  1030,  1030,
    1030,  1030,  1030,  1030,  1030,  1031,  1031,  1032,  1032,  1032,
    1032,  1032,  1032,  1033,  1033,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1038,  1038,  1039,  1040,  1040,
    1041,  1041,  1042,  1043,  1044,  1044,  1044,  1045,  1046,  1046,
    1047,  1047,  1048,  1048,  1048,  1049,  1049,  1050,  1050,  1051,
    1051,  1052,  1052,  1052,  1052,  1052,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     3,     3,     5,
       5,     4,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       6,     1,     1,     1,     1,     0,     1,     1,     3,     4,
       5,     4,     2,     2,     3,     4,     3,     2,     2,     1,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     2,     9,     6,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,    11,    12,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     1,     3,     1,     1,     1,
       3,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     2,     0,
       2,     2,     2,     2,     2,     2,     3,     1,     4,     6,
       7,    11,     3,     0,     3,     1,     1,     2,     2,     0,
       1,     1,     2,     2,     0,     3,     3,     2,     1,     1,
       2,     2,     4,     0,     2,     2,     2,     0,     3,     4,
       4,     0,     2,     0,     4,     0,     0,     7,     5,     3,
       0,     3,     1,     1,     5,     4,     2,     0,     2,     1,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     1,
       0,     5,     9,     1,     0,     1,     2,     2,     0,     2,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
      14,    19,     1,     1,     1,     3,     5,     1,     1,     1,
       3,     0,     1,     0,     1,     1,     1,     3,     0,     1,
       1,     0,     2,     1,     2,     1,     2,     0,     2,     1,
       2,     2,     6,     8,     8,     3,     5,     4,     4,     4,
       3,     7,     8,     6,     6,     6,     6,     3,     1,     3,
       3,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     3,    13,     1,     3,     4,     7,     4,
       7,     2,     1,     0,     2,     0,     1,     0,     6,     8,
       8,     1,     3,     5,     5,     7,     9,     7,     9,     5,
       6,     6,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     4,     5,     4,     4,     3,     4,     3,     3,     2,
       4,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     6,
       7,     7,     9,     8,     8,     6,     9,     9,     7,    10,
       7,     8,     8,     8,     8,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     7,
       7,    10,     2,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     2,     2,     1,
       3,     1,     2,     3,     0,     1,     3,     2,     6,     6,
       3,     0,     3,     0,    13,    14,     1,     0,     2,     0,
       1,     3,     4,     4,     6,     1,     2,     0,     1,     1,
       0,     1,     1,     0,     9,     7,     2,     0,     3,     2,
       1,     3,     3,     3,     2,     2,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     4,     5,     1,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     2,     2,
       2,     2,     1,     2,     2,     1,     2,     0,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     7,     9,     1,
       3,     3,     3,     1,     3,    11,    10,     2,     0,     9,
       2,     0,     4,     4,     4,     1,     1,     1,     0,     7,
       6,     6,     6,     6,     7,     9,     9,     6,     6,     6,
       6,     6,     8,     8,     6,     6,     8,     8,     8,     8,
       1,     0,     7,     6,     6,     6,     6,     6,     7,     6,
       6,     6,     6,     7,     9,     9,     9,     6,     6,     6,
       8,     8,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     8,     2,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       3,     2,     1,     0,     8,    10,     2,     3,     3,     0,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     4,     3,     3,     1,     0,     5,     4,
       2,     0,     4,     3,     5,     6,     4,     6,     6,     5,
       7,     1,     0,     6,    11,    11,    11,    13,     9,    11,
      10,     3,     1,     4,     2,     0,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       5,     4,     1,     1,     1,     1,     3,     0,     4,     8,
       3,     0,     2,     3,     2,     3,     5,     1,     4,     2,
       3,     1,     2,     3,     0,     6,     2,     0,     5,     3,
       0,     2,     2,     2,     3,     1,     3,     1,     2,     1,
       0,     7,     1,     3,     1,     1,     3,     5,     2,     1,
       3,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     1,     4,     4,     4,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     2,     1,     1,     0,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     1,     0,     1,     1,
       1,     3,     0,     2,     0,     1,     3,     1,     0,     1,
       2,     4,     4,     2,     0,     2,     3,     2,     0,     3,
       1,     1,     2,     1,     2,     5,     6,     5,     1,     2,
       1,     4,     3,     4,     5,     4,     5,     4,     5,     2,
       4,     1,     2,     2,     2,     1,     1,     0,     4,     2,
       1,     2,     2,     4,     1,     2,     3,     1,     2,     0,
       2,     4,     4,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       1,     1,     1,     1,     2,     3,     3,     0,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     2,     3,     2,
       4,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     3,     4,     1,     3,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       6,     7,     3,     4,     1,     1,     2,     4,     1,     1,
       1,     2,     2,     2,     1,     3,     4,     5,     5,     4,
       1,     1,     4,     1,     4,     1,     4,     1,     4,     1,
       1,     1,     1,     6,     4,     4,     4,     4,     6,     5,
       5,     5,     4,     6,     4,     4,     4,     4,     5,     7,
       7,     9,     4,     6,     5,     7,     7,     2,     3,     3,
       3,     4,     0,     4,     1,     3,     3,     1,     1,     1,
       2,     2,     0,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     1,     3,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     1,     0,     1,     1,     1,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     5,     3,     2,     2,     3,     7,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     3,     1,     2,
       0,     2,     0,     2,     0,     1,     3,     4,     3,     1,
       1,     1,     2,     0,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     2,     1,     3,     2,     2,     3,     0,
       5,     1,     0,     5,     2,     2,     1,     1,     1,     2,
       2,     3,     1,     2,     2,     3,     3,     4,     2,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       0,     1,     3,     5,     0,     2,     0,     1,     2,     3,
       2,     1,     1,     1,     0,     1,     1,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     2,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2221,  2225,  2229,  2230,  2157,  2231,
    2232,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2206,  2207,  2208,  2210,  2209,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2220,  2219,  2234,  2222,  2235,  2223,  2224,
    2226,  2227,  2196,  2228,  2236,  2237,  2238,  2233,  2186,  1444,
    2187,    10,  1447,  1445,  1446,  1440,  1441,  2241,  2192,  2193,
    2191,  2194,  2195,  2239,  2240,  2182,  2183,  2185,    11,    12,
    2184,  2242,     4,  2188,  2189,  2190,     8,  1527,  1600,     9,
    2181,  1600,     0,  1710,  1711,  1712,     0,  1713,  1714,  1715,
    1716,  1717,  1648,  1614,  1718,     0,  1719,  1720,  1721,  1722,
    1723,  1724,  1725,  1726,     0,  1727,  1728,  1729,  1730,  1599,
    1731,  1732,  1733,  1734,  1735,  1576,  1582,  1694,     0,  1556,
    1557,  1553,  1555,  1554,  1558,  1541,   825,   434,   892,   891,
       0,  2065,   825,  2066,  2024,  2067,  2025,  2026,   235,     0,
     882,  2027,     0,   825,   307,   322,  2068,  1491,     0,  2028,
    2029,     0,     0,     0,   434,   825,     0,     0,  2030,   909,
    2031,     0,  2032,  2069,  2070,     0,     0,  2033,  2071,  2072,
    2034,     0,  2035,  2036,  2073,  2074,  2075,  2037,  2076,  2077,
       0,     0,   997,     0,  2038,  2078,  2039,  2040,     0,  2079,
    2041,  2042,  2043,  2080,  2081,  2044,  2045,  2046,     0,  2047,
       0,     0,     0,     0,     0,  2082,   825,  2048,     0,  1003,
       0,  2049,     0,  2083,  2050,     0,  2051,  2052,  2053,  2054,
    2055,   997,  1690,  1577,     0,     0,   896,     0,  2056,  2084,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2168,  2169,
       0,     0,     0,    47,    53,    24,    23,    27,    28,    67,
      72,    42,    18,    62,    48,   101,   102,   103,    34,    30,
      59,    22,    31,    35,    50,    36,    49,    21,    43,    66,
      51,    70,    52,    71,    37,    60,    57,    44,    45,    46,
      63,    64,    65,    86,    69,    97,    76,    33,    77,    92,
      78,    93,    79,    41,    17,    90,    88,    89,    38,    61,
      87,    91,    19,    20,    94,    68,    84,    81,    98,    96,
     104,    82,    54,    14,    15,    73,    40,    16,    26,    25,
      39,    32,   100,    29,   894,    74,    85,    75,    55,    80,
      58,    83,    99,    56,    95,   971,   970,  1005,   974,   981,
     106,   107,   112,     7,  1516,  1517,  1518,  1600,  1551,  1552,
    1545,  1561,  1571,  1560,  1564,  1572,  1559,  1578,     0,   109,
     111,   113,   116,   110,   105,   108,   115,   120,   114,   119,
     117,   118,   121,   122,   123,  1783,  1174,  1781,  1782,  1780,
    1533,     0,  1600,  1535,  1534,     0,  1736,  1737,  1738,  1739,
    1740,  1741,  1788,  1789,  1790,  1791,  1792,  1794,  1793,  1805,
    1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,
    1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,
    1826,  1763,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,
    1835,  1836,  1804,  1837,  1838,  1839,  1840,  1841,  1842,  1843,
    1844,  1845,  1846,  1847,  1848,  1797,  1849,  1850,  1851,  1852,
    1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,  1861,  1862,
    1863,  1864,  1865,  1866,  1867,  1869,  1868,  1870,  1871,  1872,
    1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,
    1883,  1798,  1884,  1885,  1886,  1887,  1888,  1889,  1890,  1891,
    1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,
    1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,  1911,
    1912,  1799,  1913,  1914,  1800,  1915,  1916,  1917,  1918,  1919,
    1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,
    1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,  1939,
    1940,  1943,  1941,  1942,  1944,  1945,  1946,  1947,  1948,  1949,
    1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,  1959,
    1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,  1969,
    1970,  1971,  1801,  1972,  1973,  1974,  1975,  1976,  1977,  1978,
    1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,
    1989,  1991,  1990,  1992,  1993,  1994,  1995,  1996,  1491,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,  2007,
    2008,  2009,  2010,  2011,  1764,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  2021,  1802,  2022,  2023,  2167,  1459,
    1510,  1509,  1484,  1505,  1761,  1708,  1709,  1479,  1762,  1759,
    1795,  1796,  1803,  1760,  1460,  2163,  1758,  1647,     0,     0,
    1613,  1612,  1616,  1615,  1617,  1610,  1611,  1425,  1511,  1628,
    1627,  1424,  1630,  1742,  1743,  1744,  1745,  1747,  1746,  1748,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  1773,  2097,  2098,  2099,  2100,  2101,  2102,  2103,
    2106,  2104,  2105,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
    2124,  1774,  1775,  2125,  2126,  2127,  2128,  2129,  2130,  2131,
    2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2142,  2143,  2144,  2145,  2146,  2147,  1777,  2148,  2149,  1776,
    2150,  2151,  2152,  2153,  2154,  1787,  1772,  1574,  1749,  1784,
    1771,  1778,  1779,  1786,  1785,  1584,  1580,  1588,  1583,     0,
       0,     0,     0,  1600,   824,   823,   809,     0,     0,     0,
       0,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,   833,
     286,   285,  1481,  1480,  1420,   885,  1416,  1417,   434,     0,
     812,   306,     0,     0,     0,     0,     0,     0,     0,   512,
       0,     0,     0,     0,     0,     0,     0,   167,     0,   317,
     316,     0,     0,   423,     0,   646,     0,     0,   434,     0,
       0,     0,  1490,  1489,  1485,  1495,     0,  1488,  1758,     0,
     924,  1941,  1625,  1626,   922,  1982,   962,     0,   236,   239,
     237,   238,     0,     0,   731,   539,     0,   538,     0,     0,
     536,     0,     0,     0,     0,   540,   534,   533,     0,     0,
       0,   537,     0,   535,     0,     0,   813,     0,  1566,  1567,
    1885,   921,   908,   894,  1806,   569,   573,   564,   570,   578,
     577,   565,   562,   563,  1953,     0,     0,   568,     0,   559,
    1448,  1450,   576,  1449,     0,   613,   619,   618,   617,     0,
     614,   615,   620,     0,   806,   840,  1429,   996,     0,     0,
     561,   805,  1997,   917,     0,     0,   735,     0,   736,     0,
    1968,   817,   227,  1756,  1974,  2052,  1997,  1757,   223,  1754,
     192,  1755,  1751,  1752,  1753,  1750,     0,     0,   614,     0,
     814,   815,  1002,  1000,     0,     0,     0,     0,  1837,  1906,
     215,  1964,  1974,  2052,  1997,  2021,   176,     0,   222,  1974,
    2052,  1997,     0,   833,     0,     0,  1575,   808,   807,     0,
    1074,     0,  1070,   895,   898,     0,  1035,   979,     0,   825,
       0,     6,   893,   889,   999,   999,     0,   999,     0,   975,
       0,  1543,  1571,  1550,  1606,  1547,     0,     0,  1596,  1592,
    1589,  1597,  1598,  1591,  1579,  1163,  1164,  1165,  1162,  1166,
    1161,     0,  1522,  1563,  1528,     0,  1538,  1537,  1536,  2170,
    2171,  1649,  1483,  1502,     0,     0,     0,     0,     0,  1636,
    1629,  1631,  1633,  1586,  1585,  1581,     0,     0,  1699,     0,
       0,  1700,  1701,     0,  1696,  1698,     0,  1606,     0,     0,
    1761,  1769,  1430,  1762,  1759,  1767,  1758,     0,   547,   126,
       0,     0,   547,     0,     0,     0,     0,  1829,  1873,  1329,
    1339,  1337,  1338,  1331,  1332,  1333,  1336,  1334,  1335,     0,
     723,  1330,     0,   126,     0,     0,   407,     0,     0,     0,
       0,     0,   126,     0,     0,     0,     0,     0,   829,   832,
     810,     0,     0,  1400,  1421,     0,     0,   881,     0,     0,
     595,   604,   596,   601,     0,   598,     0,     0,   606,     0,
     597,   599,   600,   605,     0,     0,   602,   603,     0,     0,
     821,   309,     0,     0,     0,     0,     0,   842,   872,   321,
     320,   126,   319,   318,     0,     0,     0,   666,   126,     0,
     169,   437,     0,     0,   480,   126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1494,  1500,     0,  1492,  1650,
     925,   923,  1609,     0,   937,  1884,     0,   475,     0,     0,
    1884,   863,  1884,     0,  1884,   162,  1422,     0,     0,     0,
       0,     0,  1884,   154,  1884,     0,  1884,   438,     0,  1884,
       0,  1884,   156,     0,  1884,   282,   545,     0,     0,  2175,
    2179,     0,  2177,  2172,  1565,  1624,  1623,  1515,     0,  1622,
       0,   566,   575,   574,   572,   571,   567,  1451,     0,   557,
     558,  1636,  1639,   555,     0,   612,     0,     0,     0,     0,
     940,  1418,     0,   820,     0,     0,     0,     0,   738,   738,
     738,   816,   226,   224,     0,     0,     0,     0,     0,   822,
       0,     0,     0,  2024,  2025,  1128,  1393,     0,  1763,  2026,
    2027,  1270,  1279,  1271,  1273,  1280,  2028,  2029,  1861,  2030,
    2031,  1437,  2032,  2033,  1118,  2035,  2036,  2037,  1275,  1277,
    2038,  2039,     0,  1438,  2041,  2042,  1933,  2044,  2045,  2047,
    2048,  1281,  2050,  2051,  2052,  2053,  2054,  2055,  1436,     0,
    1282,  2056,  2058,  2059,  2060,  2061,  2062,  2063,  1340,  1442,
    1443,  1402,     0,     0,  1415,     0,  1260,     0,  1110,  1111,
    1133,  1134,  1112,  1139,  1140,  1152,  1113,     0,  1414,  1175,
    1259,  1264,     0,  1258,  1254,   987,  1412,  1394,     0,  1255,
    1473,  1472,  1474,  1475,  1471,  1432,  1439,  1478,  2163,     0,
       0,     0,     0,     0,  1689,   231,     0,   232,  1974,   177,
     214,   187,   213,   188,   217,   216,     0,  1827,   178,     0,
     185,     0,     0,     0,     0,     0,     0,     0,   218,   811,
     282,     0,     0,  1072,     0,  1075,     0,  1071,   897,   894,
    1407,  1406,  1408,     0,   973,   972,     5,   900,   998,     0,
       0,     0,     0,     0,     0,     0,  1028,  1017,  1025,  1029,
    1036,  1606,  1607,     0,  1601,     0,  1600,  1600,  1594,  1593,
    1590,     0,     0,     0,     0,     0,     0,  1465,  1464,  1519,
    1521,  1468,     0,     0,  1504,     0,  1508,  1506,  1636,  1644,
    1636,  1645,  1646,  1637,  1469,  1470,  1642,     0,  1632,  1640,
    1643,  1587,  1600,  1707,     0,  1702,  1705,     0,  1697,     0,
    1431,     0,     0,     0,     0,     0,   548,     0,     0,     0,
     125,   861,   229,   859,     0,     0,     0,   866,     0,     0,
       0,     0,   693,     0,     0,     0,     0,     0,     0,   694,
     692,   695,   702,   709,   712,     0,   637,   160,   161,     0,
       0,     0,     0,     0,     0,   241,   272,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,   405,   761,   761,
       0,     0,   761,     0,     0,     0,   761,     0,   240,   242,
     271,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,     0,  1529,     0,   827,   828,     0,
     831,     0,  1397,  1396,  1427,  1401,   883,   884,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,   293,   126,   291,     0,     0,   477,
       0,  1121,  1150,  1150,  1150,  1117,  1117,  1130,  1119,  1157,
       0,  1150,  1117,  1122,     0,  1120,  1160,  1160,  1145,     0,
    1093,  1103,  1105,  1106,  1131,  1132,  1107,  1137,  1138,  1104,
    1174,  1768,  1117,  1770,  1766,  1765,     0,     0,   871,     0,
       0,   513,     0,     0,   478,     0,     0,     0,   165,     0,
       0,     0,     0,     0,     0,   443,   442,     0,     0,   479,
       0,   407,     0,   400,   363,     0,     0,  1835,     0,     0,
       0,  1498,  1493,  1496,     0,  1486,  1500,   963,   967,   964,
       0,   965,     0,  1083,     0,   282,   730,     0,     0,     0,
     282,     0,     0,  1884,     0,  1884,     0,     0,     0,   282,
       0,     0,     0,     0,   544,   542,   541,   543,     0,     0,
       0,     0,   282,     0,   280,   281,     0,   532,  2173,     0,
       0,  2176,  1568,     0,  1350,     0,   918,  1620,  1621,   322,
       0,     0,   901,   907,   903,   905,   904,   906,   902,   556,
     553,   554,     0,  1638,  2155,  2161,     0,  1651,  1652,     0,
    1848,  1878,  1900,  1969,  1972,     0,  1992,     0,   621,   641,
     616,     0,     0,   934,   927,     0,     0,   950,   560,   911,
    1354,     0,     0,     0,   737,   734,   733,   732,   225,   193,
       0,     0,   643,  1968,   819,     0,     0,  1262,  1263,  1149,
    1136,  1392,     0,     0,  1144,  1143,     0,     0,     0,     0,
    1126,  1125,  1124,  1261,  1353,     0,  1123,     0,     0,     0,
       0,  1150,  1150,  1148,  1194,     0,  1127,     0,     0,  1372,
       0,  1378,     0,     0,     0,  1156,     0,  1154,     0,     0,
    1230,     0,     0,     0,     0,     0,     0,  1256,  1178,  1179,
    1764,  1260,  1350,     0,  1433,     0,     0,  1142,     0,  1174,
       0,     0,     0,     0,  1405,  1348,     0,     0,  1207,  1346,
       0,  1209,     0,     0,     0,  1340,  1339,  1337,  1338,  1331,
    1332,  1333,  1336,  1334,  1335,  1344,  1191,     0,     0,  1190,
    1636,     0,  1038,   986,  1395,     0,  1476,     0,  2162,  2164,
    1686,  1685,  1684,  1683,  1659,     0,  1655,  1656,     0,  1687,
    1688,   233,   234,   230,     0,   190,   189,     0,   211,   212,
     184,     0,   207,   208,  1319,  1318,   191,   183,   181,   204,
     206,   205,   203,   179,   194,   200,   201,   202,   182,   180,
     221,   219,     0,   551,  1600,     0,  1076,     0,  1038,   952,
     954,   955,     0,  1402,   886,  1410,     0,     0,   890,   979,
     984,   978,   983,  1006,  1007,   660,   982,     0,  1034,  1034,
    1019,  1013,  1018,  1014,  1020,  1027,   977,  1016,   976,     0,
    1030,     0,  1608,  1546,  1606,  1093,  1600,  1539,  1600,  1595,
    1525,  1168,  1169,  1170,  1171,  1173,  1172,  1526,  1523,  1167,
    1524,  1467,  1466,     0,     0,     0,  1501,     0,  1482,  1507,
       0,     0,  1093,  2158,  1703,  2158,  1093,     0,     0,     0,
       0,     0,     0,     0,   549,     0,     0,     0,   228,   858,
       0,     0,     0,     0,     0,   869,   357,     0,   279,     0,
       0,     0,     0,     0,     0,   700,     0,     0,     0,     0,
     701,   698,   699,  1969,   711,   710,   708,   677,   679,   678,
       0,   669,     0,   670,     0,     0,   676,   685,   683,     0,
       0,     0,     0,   277,     0,   276,     0,     0,     0,     0,
       0,   719,   724,     0,     0,   135,   137,     0,     0,   133,
     139,   136,   138,   134,   140,   132,     0,     0,   131,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,   409,
     420,     0,     0,     0,     0,   126,   126,   406,   760,   252,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   269,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,   199,   826,   830,  1398,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   308,   290,   289,     0,   295,
       0,   499,  1765,   476,     0,  1093,     0,     0,     0,  1087,
    1163,  1162,  1161,     0,  1108,  1117,  1114,     0,     0,   857,
     857,   857,   857,   857,   841,   843,   332,   158,     0,     0,
       0,   488,   491,     0,   124,   169,   322,     0,   168,   170,
     172,   173,   174,   171,   175,   436,     0,     0,     0,     0,
       0,   448,   447,   449,     0,   444,     0,     0,   149,   404,
     396,     0,   324,   387,     0,     0,   421,     0,     0,     0,
       0,   782,     0,  1499,     0,     0,     0,     0,   966,     0,
    1048,   936,  1040,  1050,  1041,  1043,  1077,  1420,     0,     0,
     934,     0,   715,     0,   864,     0,   713,   163,  1423,     0,
       0,     0,     0,     0,     0,   529,   155,     0,   282,   439,
       0,   282,   157,     0,   431,   282,   546,  2174,  2180,  2178,
     920,     0,  1618,  1619,     0,   962,   552,     0,     0,  2160,
    1452,     0,  1453,     0,     0,   625,   624,   635,   626,   627,
     623,   622,   628,     0,     0,   643,   929,     0,   931,  1402,
       0,   926,     0,   947,     0,   945,     0,  1419,   949,   938,
     916,     0,   910,   913,   915,   914,   912,     0,     0,   614,
       0,     0,   282,   818,     0,     0,     0,  1356,     0,     0,
    1391,  1388,     0,     0,     0,     0,     0,  1363,  1364,  1365,
    1362,  1366,  1361,     0,     0,  1367,  1360,     0,     0,     0,
       0,     0,  1147,  1146,     0,     0,     0,     0,     0,     0,
    1233,  1264,     0,     0,  1324,     0,  1350,  1377,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1350,  1383,
       0,     0,     0,  1317,     0,  1314,     0,     0,     0,  1403,
    1402,     0,     0,     0,     0,  1434,  1176,  1192,  1413,     0,
    1404,     0,     0,  1199,     0,  1384,  1226,     0,  1231,  1214,
       0,  1208,     0,  1212,  1216,  1195,  1405,  1349,     0,  1347,
       0,     0,  1193,     0,  1188,  1186,  1187,  1180,  1181,  1182,
    1183,  1184,  1185,  1189,  1328,  1326,  1327,     0,     0,     0,
    1211,  1731,  1879,  1906,     0,   997,   997,   985,   995,  1411,
       0,  1079,     0,     0,     0,  1265,     0,  2166,  2165,     0,
       0,     0,     0,     0,  1174,     0,   220,  1093,  1073,   959,
       0,     0,  1083,     0,   958,   888,   887,  1409,     0,     0,
     658,   659,     0,   663,  1026,     0,   950,   950,     0,     0,
       0,  1544,  1602,  1549,  1570,  1540,  1573,  1520,  1562,     0,
    1503,  1634,  1641,  1693,     0,  2159,     0,     0,   497,   496,
       0,     0,     0,   769,   740,   550,   770,   741,     0,   860,
       0,     0,     0,     0,     0,   282,   867,   278,   868,   763,
     771,     0,   696,   697,   772,   742,     0,   764,   680,  1117,
     668,     0,     0,   675,     0,   674,  1117,  1117,   743,   159,
     274,   751,   275,   273,     0,  1426,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   128,   127,   146,   144,     0,
     143,     0,   777,   747,   749,   765,   408,   419,     0,   412,
     413,   410,   414,   415,     0,     0,     0,   244,     0,     0,
     255,   268,   263,   264,   262,   282,   282,     0,     0,     0,
       0,   265,   260,   261,   257,   270,   748,     0,   766,   256,
     254,     0,   243,   779,   755,     0,     0,     0,     0,     0,
       0,     0,   873,     0,     0,     0,   778,   767,   754,   750,
       0,     0,   197,   196,   198,     0,     0,     0,     0,     0,
       0,     0,     0,   608,   585,   607,     0,     0,     0,     0,
       0,     0,     0,   579,   311,   288,   498,     0,     0,     0,
       0,  1088,     0,     0,  1093,     0,     0,  1101,  1094,  1102,
       0,     0,     0,  1115,     0,   857,   856,     0,     0,     0,
       0,     0,   844,   865,     0,   518,   487,     0,     0,   363,
     164,     0,     0,   435,   486,   484,   483,   485,     0,     0,
       0,     0,  1084,     0,     0,     0,     0,     0,     0,   323,
     325,   327,   328,   329,     0,   402,   403,     0,     0,   391,
       0,   365,   366,     0,     0,     0,     0,   649,     0,     0,
       0,   707,   705,   688,     0,  1497,  1491,   968,   969,     0,
     979,     0,  1050,     0,  1049,  1061,     0,     0,  1067,  1065,
       0,  1067,     0,  1067,     0,  1042,     0,  1044,  1061,  1421,
       0,     0,  1080,   935,   282,     0,   282,     0,   282,     0,
     282,     0,   282,     0,   803,     0,   472,   282,   531,  1351,
       0,     0,  1635,  2156,  1660,  1661,     0,  1653,  1654,     0,
       0,   634,   629,   631,     0,   638,     0,     0,   932,     0,
     948,   941,   943,   942,     0,     0,   939,  1355,   530,     0,
     282,     0,   639,  1001,  1358,  1359,     0,     0,     0,     0,
    1387,     0,     0,  1294,  1272,  1274,  1116,  1284,     0,  1129,
    1295,  1296,  1276,  1278,     0,  1341,     0,     0,  1285,  1235,
       0,     0,     0,     0,  1340,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1247,  1246,  1286,  1323,     0,     0,
    1375,  1376,  1287,  1158,  1159,  1160,  1160,     0,     0,  1382,
       0,     0,     0,  1292,  1297,     0,     0,  1302,     0,  1322,
       0,     0,  1257,  1351,  1151,  1152,     0,     0,     0,     0,
       0,     0,     0,     0,  1232,  1215,  1210,     0,  1213,  1217,
       0,     0,     0,     0,  1201,  1227,  1197,     0,     0,  1203,
       0,  1228,   997,   997,   997,   997,   994,     0,     0,  1037,
       0,  1022,     0,     0,  1269,  1266,  1668,  1669,  1670,  1671,
    1672,  1673,  1674,  1676,  1677,  1679,  1680,  1681,  1675,  1678,
    1682,  1664,  1665,     0,  1657,  1658,   186,     0,   209,   195,
    1693,     0,     0,   953,   934,   956,   899,  1008,     0,  1342,
     663,   661,   662,  1010,  1033,  1032,  1031,  1011,  1015,  1012,
       0,  1604,  1530,  1692,  1695,  1706,  1704,  1542,   768,   739,
     762,   857,     0,   356,     0,     0,     0,   870,   690,     0,
    1117,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,   721,     0,   722,   720,   141,   129,   148,   147,   130,
     142,   411,   416,   418,   417,   332,     0,     0,     0,   245,
     253,   250,   266,   258,   267,   259,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   773,   744,  1399,
     580,     0,   581,   588,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   590,   312,   126,     0,   296,   300,   872,
     872,     0,   301,   872,   297,   872,   294,   500,     0,  1933,
    1332,   501,   492,   494,   495,   493,   467,     0,     0,     0,
    1091,     0,     0,     0,     0,     0,     0,  1093,  1174,     0,
       0,   852,  1461,  1462,   851,  1463,   848,   847,   855,   854,
     846,   845,   850,   849,     0,     0,     0,   343,     0,     0,
     337,     0,     0,   707,   331,   334,   335,     0,   489,   490,
       0,   322,     0,   451,   445,     0,   502,   481,     0,  1086,
     921,   397,   324,   349,   383,     0,   399,     0,   385,   384,
     386,     0,   393,   362,     0,   839,   428,   425,     0,   649,
       0,     0,   703,   681,   704,     0,   684,     0,   689,   665,
       0,  1513,   961,  1514,  1052,  1059,     0,  1039,     0,  1066,
    1062,     0,  1063,     0,     0,  1064,     0,     0,  1059,     0,
       0,     0,   716,     0,   714,     0,   525,     0,   527,     0,
     717,   282,   282,   432,     0,   400,   967,     0,     0,   636,
     632,     0,     0,   609,   640,   928,   930,   933,   946,   944,
       0,   610,   642,  1357,  1135,     0,  1390,  1386,     0,  1352,
       0,  1370,  1369,  1234,  1371,     0,  1252,     0,     0,  1245,
    1244,  1242,  1243,  1236,  1237,  1238,  1239,  1240,  1241,  1380,
    1379,  1373,  1374,  1155,  1153,     0,  1289,  1290,  1291,  1381,
    1298,     0,  1316,  1315,     0,     0,     0,  1304,     0,     0,
    1312,  1325,  1141,  1174,  1177,     0,     0,  1200,  1385,  1218,
       0,     0,     0,  1196,     0,     0,     0,     0,  1205,  1341,
       0,     0,     0,     0,     0,     0,   989,   988,  1078,     0,
    1024,  1267,  1268,  1477,     0,     0,     0,  1691,     0,   960,
     951,     0,  1009,  1548,     0,  1603,     0,   358,     0,     0,
     707,   691,     0,   686,     0,     0,     0,     0,     0,   519,
     505,     0,     0,   520,   521,     0,     0,     0,   330,     0,
       0,     0,     0,   284,   752,     0,     0,     0,     0,     0,
     781,   759,   780,   757,   756,   758,   753,     0,     0,     0,
       0,   584,   594,   592,   591,   593,   583,   295,     0,     0,
       0,     0,     0,     0,     0,   469,     0,     0,   474,   463,
     465,     0,     0,     0,  1089,  1095,  1096,  1097,  1098,  1099,
    1100,  1092,  1109,   461,   853,     0,     0,   341,   345,   346,
     344,   336,   707,   363,   395,     0,     0,     0,   453,     0,
       0,   482,     0,  1085,   919,     0,   347,     0,   387,   326,
     401,   403,     0,     0,   398,   364,     0,     0,     0,   834,
       0,   430,   426,     0,     0,   648,     0,     0,   707,   706,
     798,   799,   796,   797,     0,     0,  1487,  1051,     0,     0,
    1053,     0,     0,  1055,  1057,     0,     0,     0,     0,     0,
    1424,  1266,  1082,  1081,   282,   282,   282,   282,   804,   473,
       0,     0,     0,  1662,  1663,     0,   630,     0,  1389,  1283,
    1293,  1368,     0,     0,  1253,     0,     0,  1288,  2057,     0,
       0,  1320,  1321,  1303,     0,  1919,  1307,     0,     0,  1435,
    1224,  1222,  1219,     0,  1220,     0,     0,  1202,  1198,     0,
    1204,  1229,   993,   992,   991,   990,     0,     0,   980,  1666,
       0,  1454,  1458,  1455,  1667,  1174,   957,     0,  1605,   862,
       0,   707,   395,   687,   775,   745,     0,     0,   511,     0,
       0,     0,     0,   776,   746,   774,   246,   247,   248,   249,
       0,   251,     0,     0,     0,   878,     0,     0,   586,   587,
     582,   287,   310,   298,   303,     0,   304,   299,   302,   471,
     470,   468,   464,   466,  1090,     0,   728,     0,   467,     0,
       0,   333,   395,   369,     0,   338,     0,   839,   324,   452,
       0,     0,   446,   503,   387,     0,     0,   348,     0,   391,
       0,   388,     0,   392,     0,     0,   836,   427,     0,   422,
       0,     0,     0,     0,   650,   657,   657,   682,   664,     0,
    1512,     0,  1060,  1069,     0,  1056,  1054,  1045,     0,  1047,
     729,   526,   528,   718,     0,   633,   282,  1248,     0,     0,
       0,     0,  1299,     0,  1300,  1305,  1308,     0,  1306,  1221,
    1225,  1223,  1206,  1021,  1023,  1457,  1456,   210,  1343,     0,
     395,   359,     0,     0,   517,   506,     0,     0,   522,   283,
       0,     0,     0,     0,     0,   589,   305,   728,     0,   726,
     462,     0,   340,   339,     0,   374,     0,   515,   835,   454,
     455,   450,     0,   391,   353,   351,   355,   352,   350,   354,
       0,   393,   389,   390,   837,   838,   429,   880,     0,     0,
     707,     0,     0,   655,   660,   660,  1079,  1058,     0,  1046,
     611,  1249,     0,  1250,     0,     0,  1310,  1309,   363,   360,
       0,   509,   516,     0,   507,     0,     0,   874,     0,   875,
     876,   879,   725,   727,     0,   367,   368,     0,   342,   370,
     371,     0,     0,     0,     0,   393,   382,   314,   707,   657,
     393,   651,   656,   663,   663,     0,  1068,  1251,  1313,  1301,
    1311,   369,     0,     0,   524,   523,     0,     0,     0,     0,
       0,   372,     0,   373,   394,   514,     0,   458,   315,   393,
     660,  1079,   653,   652,   802,   374,     0,   517,   877,     0,
     379,     0,   378,     0,   375,   376,   504,     0,   456,     0,
     459,   460,  1079,   663,   644,   801,   800,     0,   467,   510,
     508,     0,   377,   380,   381,   440,     0,     0,   645,   654,
     784,   795,   783,   785,   793,   790,   792,   791,   789,   361,
       0,   457,     0,     0,   794,   788,   979,   970,     0,     0,
     786,   795,   458,   787,     0,   441
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    72,   241,   242,   243,  1491,  2093,   244,
     245,   246,   247,   248,   249,   250,   251,   252,  1520,   253,
     254,  1159,  1648,  2208,   255,  2018,   967,  1923,  2145,  1924,
    1925,  1910,  1381,  1383,   256,  1492,  1512,   258,  1376,  1903,
     259,   260,   261,  1548,  1549,  1525,  1550,  1497,  1717,  3561,
     262,   263,  2168,  1595,  2675,  3086,   802,  1592,  3075,  3076,
     264,  1645,  2728,  2729,  2730,  2731,  2703,  3134,  3135,  3136,
    2732,  3426,  3607,  2733,  2026,  2235,  2740,  2741,  3695,  3758,
    3759,  3760,  3814,  3428,  2739,  3162,  3434,  3595,   265,  2725,
    1662,  2233,  2734,  2735,   266,   267,  1537,  2107,  2598,   268,
     828,  3166,  3441,  3619,   269,   786,   270,  1650,   271,   272,
    1657,  2224,  2225,  3419,  3600,  3701,  3817,  3818,  3588,  3388,
    3389,  3390,   273,   274,   275,   276,  2065,  2200,  2201,  3091,
    1482,  1599,  2170,  2171,  3145,   277,  3339,  3340,   829,  3763,
    3744,   278,   279,  3343,  3344,   280,   281,   282,   283,   284,
     875,  1215,  1216,  1486,   285,   286,   896,   897,   898,   287,
    1139,  2664,   288,   289,   909,  2339,   911,  1757,  2811,  2812,
    3223,  2306,  1073,   290,   291,  2315,  2342,   292,   830,  3171,
    3623,  3624,  3724,  2503,  2983,   293,   831,  1516,  2052,  2053,
    2054,  3172,  2055,  3175,  2056,  2751,  2752,  2753,  3179,   294,
    1514,  2046,   295,   296,   297,  2070,  1089,   298,  3689,   299,
    1189,   300,   929,  1775,   301,  2110,   302,   303,   304,  2754,
    3842,  3853,  3854,  3855,  3454,  3827,   305,  3844,   307,   308,
     309,   789,  1108,  1109,  1110,   310,  3439,   311,   312,  2194,
    2195,  2697,   313,   314,  2019,  2539,   315,   316,   317,  1639,
     318,   319,   320,   321,  1117,   322,   323,   324,   993,   984,
    1409,  1948,   325,  1732,   883,   326,  2332,  1256,   327,  1229,
     328,  3845,  1763,  2317,  2318,  2321,  3846,  1683,   331,  1767,
    2326,  2329,  3847,  1938,  1939,  1940,  1941,  1942,  2490,   333,
    1183,  2247,  3848,  1336,   336,   337,   338,  1882,  2467,   918,
    1419,   954,   998,   999,  1953,  1954,  1426,  1968,  1961,  1963,
    3310,  3528,  1427,  1966,  1428,  1429,  2506,   339,  2471,  2251,
    2252,  2253,  2764,  2774,  3190,  3463,  2254,   981,  2255,  2941,
    2260,  2721,  2722,  2057,  2179,  2686,  1620,  1337,  1621,  2186,
    1338,  1806,  1623,  1339,  1340,  1341,  1626,  1342,  1343,  1344,
    1345,  1790,  1847,  1346,  1347,  1825,  1022,  1724,  2379,  1349,
    1350,  3280,  3508,  3499,  2404,  2405,  1916,  3276,  1351,  2457,
    1875,  1091,  1352,  3093,  1877,  2399,  2363,  2008,  2346,  1788,
    2364,  2377,  2857,  2383,  2388,  2880,  2881,  2400,  2426,  1353,
    2350,  2351,  2841,  1792,  1354,  1113,  1114,  1837,  2422,  1412,
    1413,   986,  1355,  1356,  1357,  1758,   982,  3459,  1196,   653,
    2574,  1573,  1577,   915,  1358,  1359,  1360,  1361,  1362,  1363,
    1364,   901,   902,  2301,  3534,  2665,  3114,  1465,  1926,  1365,
     631,   796,   340,   834,   835,   836,  1175,  1176,  1672,  1675,
    1454,  1998,   632,   633,   843,  3456,   341,   342,   343,   344,
    1450,  1994,  1023,    76,    81,    77,  1024,   381,   382,  1976,
     345,   763,  1977,  1431,  1004,  2991,   347,   348,   349,   350,
     351,   878,   352,  1006,   353,  1007,   354,   355,   356,   357,
    1014,   358,  1433,  1434,  3325,  1435,   359,   360,   655,   656,
    1726,  1227,   881,   361,   362,  1040,  1041,  1042,  1242,  1742,
    1243,  1468,  1469,   363,   649,   364,   365,   366,  1747,  1748,
     367,  1896,  1897,  1898,   368,  2804,  2805,   369,  2961,  2962,
    2963,   370,  1892,   371,   372,   975,  2994,   373,   759,   374,
    1054,   634,   635,   636,  1061,   747,   940,   797,  1062,   748,
     749,   750,   638,   639,   640,   641,   642,   643,  1065,   754,
    1743,    78,  2524,  1744,  1366,  1367,  1888,  1368,   646,  1031,
    1219,  1220,  2525,  1222,    79,  1223
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3400
static const int yypact[] =
{
   -3400,   318,  6961, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, 18355, -3400,
   -3400, 42330,   570, -3400, -3400, -3400, 39601, -3400, -3400, -3400,
   -3400, -3400,   179, 46832, -3400, 57619, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, 61660, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, 43233,   999, -3400,   301, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,  -141,  5368, -3400, -3400,
   49532, -3400,   158, -3400, -3400, -3400, -3400, -3400, -3400, 58068,
   55823, -3400,   334,   662,    95, 11141, -3400, 40972, 48632, -3400,
   -3400, 62109,   485,   101,  4041,  -141, 16997, 50432, -3400,  1703,
   -3400, 37299, -3400, -3400, -3400,   735, 53129, -3400, -3400, -3400,
   -3400,   595, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   61660,  1922,   513, 37765, -3400, -3400, -3400, -3400, 61660, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, 50882, -3400,
     562,   207, 62558, 63007, 52680, -3400,   918, -3400, 61660,   217,
   41881, -3400, 63456, -3400, -3400,   515, -3400, -3400, -3400, -3400,
   -3400,   513, -3400, 43233, 35448, 54027,   770,   506, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
     510, 18715,   532, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400,   607, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400,  2153, -3400,    29,  2244,   598,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, 71987,  1238, -3400,
   -3400, -3400,   690, -3400,   612, -3400, -3400, -3400,  1245, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,   522, -3400, -3400, -3400,
   -3400,  1163, 42781, -3400, -3400, 51332, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, 40058, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400,   112, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, 61660, 61660,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400,   795, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400,   216,  1161, -3400, -3400, 43233,
    1793,  1793,  1388, 71987, -3400, -3400, -3400, 43683, 61660, 61660,
   61660, 43683, 61660, 54027, 33601, -3400, 61660, 61660, 54027, 54027,
   61660,  1151, 61660, 61660, 61660, 54027,  1266, -3400,  1503,    22,
   -3400, -3400, -3400, -3400,   997,   374, -3400, -3400,  5997,  1922,
   -3400, -3400, 55823,  1199, 43683, 61660,  1069,  1184, 61660, -3400,
   61660,   281, 61660,  1071,   461,  1277, 61660, 61660, 61660, -3400,
   -3400,  1244, 61660, -3400, 61660, -3400, 61660,   866,  1235,  1495,
    1417,   433, -3400, -3400, -3400,  1212,  1171, -3400,  1221, 51332,
   -3400, 49982, -3400, -3400, -3400,  1187, -3400, 54027, -3400, -3400,
   -3400, -3400, 44133, 61660,  1494, -3400, 63905, -3400, 44583, 64354,
   -3400,  1589,  1598, 64803, 65252, -3400, -3400, -3400, 65701,  1363,
   66150, -3400, 66599, -3400,  1477, 67048, -3400, 15378, -3400,  1263,
    1338,  1278, -3400,   607,  1070, -3400,   359,    41,   389, -3400,
   -3400,   109,   122,   161,  1070,   969, 56272, -3400, 61660,  1529,
   -3400, -3400, -3400, -3400, 51332,  1480, -3400, -3400, -3400,  1515,
     351, -3400, -3400, 55823, -3400, -3400, -3400, -3400, 55823,  1065,
   -3400, -3400,  1922,     6,  1722, 61660, -3400, 61660, -3400, 55823,
   61660, -3400, -3400, -3400,  1778,  1433,  1648, -3400,  1414, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,  1544,  1605,   -34,  1922,
    1514, -3400, -3400,  1630, 21484,  -127, 51332, 38692, 54476, 70640,
     509, 40972, 67497,  1496,    22,  1657, -3400,   -30, -3400,  1850,
    1545,  1755,   137,    22, 55823, 72436, -3400, -3400, -3400, 30871,
   67946,  1636,  1535, -3400,  1828, 21959, -3400,  1532,  1560,  -141,
    1566, -3400, -3400, 55823,  1986,  1986,  1963,  1986,    66,    67,
     506, -3400, -3400, -3400,  1603, -3400,  1612,  1624, -3400,   344,
    1849, -3400, -3400, -3400, -3400,  1712,  1728,  1740,  1748, -3400,
    1756,  1320, -3400, -3400, -3400,  1983, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400,  2074,  2071, 40972, 40972,  1753,     0,    99,
   -3400, -3400, -3400,  1952, -3400, -3400,  1958, 61660, -3400,  1804,
   61660, -3400, -3400, 68395, -3400, -3400,  1793,  1603,   997,  1723,
    1696, -3400, -3400,  1744,  1797, -3400,  1869,   -12,  1726,  1005,
     115,  1908,   272,  1222,  1742,   183,  1205, 61660, 61660, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  1758,
   -3400, -3400,  1763,   622,   967,   685,   707,  2938,  1026,   141,
    1933,   988,  1072,  1914, 61660,  1772,  2009,    11, -3400,    60,
   -3400, 24809, 34542, -3400,   997, 55823, 61660, -3400, 43683,  1809,
   -3400, -3400, -3400, -3400, 43683, -3400,  1977,  2343, -3400, 61660,
   -3400, -3400, -3400, -3400,  1956, 61660, -3400, -3400,  2067, 61660,
   -3400,  1878,  1570,  1841,  2199, 47283, 61660,  1903,  2252, -3400,
   -3400,  1915, -3400, -3400, 61660, 61660,  1867,  1261,  1915,  2254,
    2258,  2049,   511,  1309,    54,  1915, 55823, 55823, 55823,  2116,
   61660, 68844, 43683, 61660, 41429, -3400,  1876,  1212, -3400, -3400,
   -3400, -3400, -3400,  1055,  1950,  2179,  1723, -3400,  2185,  1917,
    2191, -3400,  2219,  1742,  2222,  1881, -3400, 69293, 69742,  2223,
    1937, 61660,  2235,  1881,  2237,  2124,  2242, -3400,   655,  2250,
    2140,  2255,  1881,   737,  2259,    52, -3400, 15688, 15378, -3400,
   16514,   989, -3400, -3400, -3400, -3400, -3400, -3400, 24809,    17,
     924, -3400, -3400, -3400, -3400, -3400, -3400, -3400, 61660,  1529,
    1529,   102, -3400, -3400,   714, -3400, 54925, 61660, 55374,    26,
      16, -3400, 61660, -3400,  1338, 47283,  2355, 61660,  2256,  2256,
    2256, -3400, -3400, -3400,  2195, 61660,  2264, 54925, 61660, -3400,
   70191,  1973,  1130,  1971,  2026, -3400, 24809,  1975,    36,    36,
    1987, -3400, -3400,  1988,  1992, -3400,  1303,  1303,  2146,  2000,
    2003, -3400,  1680,  2010, -3400,  2131,  1732,  2012,  2015,  2016,
    1682,    36, 24809, -3400,  2017,  1303,  2018,  2024,  2025,  2212,
    2027, -3400,  2269,  2029,  2062,  2180,  2032,  2034, -3400,  2000,
   -3400,    51,  2036,  2037,  2040,  2064,  2065,  2068, -3400, -3400,
   -3400, -3400, 24809, 24809, -3400, 22434, -3400,  1922, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400,    42, -3400,  1818,  8374, -3400,
   -3400,  2245, 24809, -3400, -3400,    33, -3400,   997,  2066, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,   116,  1265,
    1265,   131, 49532, 49532, -3400, -3400,   856,  2060,  1196, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, 40515,  2461, -3400,  1718,
      60,   160,  2413, 35901, 36367,  1529,  1529,  2308, -3400, -3400,
      77,  2322, 55823, -3400, 61660, -3400, 32222, -3400, -3400,   607,
   -3400, 10280, -3400,   939, -3400, -3400, -3400,  2086, -3400,   510,
     510, 24809,   510,   677, 22909, 24809,  2370,    45,  2371, -3400,
   -3400,  1603,  2097,  1105, -3400, 51782, 71538, 71538,  2337, -3400,
   -3400,   902,   585,  2215,  2305,   402,  1234, -3400, -3400, -3400,
    2090, -3400,  2421, 49532,  2167, 40972, -3400, -3400,  2541, -3400,
    2541, -3400, -3400, -3400, -3400, -3400, -3400,  2566, -3400,  2099,
   -3400, -3400, 71987,  2109, 61660, -3400,  2118,  2119, -3400, 72436,
     997, 34995,   957,  2204,  2205, 43233,  2121,  2209,  2211, 70640,
   -3400, -3400, -3400, -3400,   614,   726,   469, -3400,  2213,  2307,
    1320,  2257, -3400,  2217,  2218,  2325,  1320,   117, 71089, -3400,
   -3400, -3400, -3400, -3400,  1152, 20083, -3400, -3400, -3400,  2224,
    2214,  2227,  2234,  1867,   369,  2145, -3400,  2221,  2228, 45483,
   34071,  4076, -3400,  2241,  2243,  2249,  2279,   613,   164,  2522,
    2346,   773,  1420,    86, 55823,  2424,    97,   805,  2172, -3400,
   -3400,  2265,  2266, 61660, 61660, 61660, 61660, 54027,  2267,  2297,
    2270,  4076, -3400,  2281,  1027, -3400,  1024, -3400, -3400,    22,
   -3400,  1426, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  1723,
   47283,  1742,  1320, 61660, 61660,  2186,    18,   811,  2374, 61660,
    2438,  2380,    38, -3400, -3400,  1915, -3400, 34995,  1867, -3400,
    2201, -3400,  2262,  2262,  2262,  2202,  2202,  2206, -3400, -3400,
    1682,  2262,  2202, -3400, 49083, -3400,  -147,   992, -3400,  2598,
      57, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
     559, -3400,  1211, -3400, -3400, -3400,  2611,   961, -3400, 47283,
    4076,  2536,  2285, 43233, -3400,  2276,  4076, 61660,   804, 61660,
    2443, 61660, 61660, 61660, 61660, -3400, -3400,   105,   -16, -3400,
    4076, -3400,  2615,   -83,  2229, 40972,  2511, 61660,  2411,  1742,
    2623, -3400, -3400,  2238,   969, -3400,  1876, -3400,  1409, -3400,
    2365, -3400, 28119,  2298, 43683,   245, -3400, 47283, 61660, 43683,
     245, 61660, 61660,  2538,  2313,  2549,  2324, 34071, 45483,    93,
   61660, 61660, 55823, 61660, -3400, -3400, -3400, -3400, 61660, 55823,
   61660,  2550,   245, 61660, -3400, -3400, 61660, -3400, -3400, 16240,
    1230, -3400, -3400, 15378, 10280,  1084, -3400,  1529,   795,   694,
   61660, 51332, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  1529,
   -3400, -3400,  2724,  2272, -3400,   116,   969,  2273, -3400,  2282,
   61660, 43683, 61660, 61660, 55823, 55823, 61660,  2356,  2060,   396,
   -3400,  2333, 31773,  2398, -3400,   133, 55823,  2465, -3400, -3400,
   -3400,  1095,   656,   550, -3400, -3400, -3400, -3400, -3400, -3400,
   53129,  2555,     3, 61660, -3400, 24809, 23384, -3400, -3400, -3400,
    2283, 10280,  2336, 24809, -3400, -3400, 24809,   969,   969, 24809,
   -3400, -3400, -3400, -3400,  2078,   969, -3400, 24809, 24809,   969,
     969,  2262,  2262, -3400,  3408, 24809, -3400, 34071, 24809, 26234,
   19607, 24809,  2366,  2373,   969, -3400,   969, -3400, 24809, 21009,
   -3400, 24809,  2493, 24809,   160,  2497, 24809,   997,  2697,  2697,
     506,  1737,  3118,  2284, -3400,  2409,   969, -3400,   969,   839,
   47283, 24809, 43233,  2383,    90, 24809,  2299,  1405, -3400, 24809,
     517, -3400,  2300, 24809,  2384,   107, 24809, 24809, 24809, 24809,
   24809, 24809, 24809, 24809, 24809, -3400, 26709,   123,  -101,   187,
   47732, 21484,  2580, -3400,  1158, 19131, -3400, 51332, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400,   969,  2304, -3400,  2319, -3400,
   -3400, -3400, -3400, -3400,  2461, -3400, -3400,  2388, -3400, -3400,
   -3400,  1959, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400,  2311, -3400, -3400, -3400, -3400, -3400,  2311,
   -3400, -3400,  1529, -3400, 71987,  2314, -3400, 61660,   -27, -3400,
   -3400, -3400,  2332, -3400, 53578, -3400, 21959, 61660, -3400, -3400,
    2563, -3400, -3400,  2315, -3400,  7659,  2563,  2500,  2495,  2495,
   -3400,   -80, 10280,  2551, 10280, -3400, -3400, -3400, -3400,   453,
   -3400,  1195, -3400, -3400,  1603,  2326, 17449, -3400, 17902, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400,  1320,  2328,  2777, -3400, 40972, -3400, -3400,
   51332,  2419,  2326, 15378, -3400, 15378,  2326,  2341,  1145,  2428,
    2430,  2474, 61660, 61660, -3400, 43233, 61660, 61660, -3400,  2699,
    2352, 61660,  2588,  2591,  2361, -3400, -3400, 61660, -3400,  2552,
   24809,  2553, 61660, 61660,  2557, -3400,   728, 61660, 61660,  2540,
   -3400, -3400, -3400, 61660, -3400, -3400, -3400,  2535, -3400, -3400,
   49083, -3400,  1165, -3400, 48183, 45033, -3400, -3400,   319, 61660,
   61660, 61660, 61660, -3400, 61660, -3400,  1056, 61660, 61660,  2360,
    2385,  2368, -3400, 61660,  2599, -3400, -3400,  2558,    32, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,   987, 61660, -3400,   969,
    2560, 61660,  2454, -3400, 61660, 61660, 61660, 61660,  1320, -3400,
    2761,  1320,  1320,   591,  2766,  1915,  1915, -3400, -3400, -3400,
   61660, 61660, 61660, 61660, 56721, 61660, 61660,   861,   925, 61660,
   57170, -3400, 55823, 61660, 61660, 61660,   491,  2817, 61660, 61660,
     666,   430,  2539,  2548,  2554, 61660, 61660, 61660, -3400, 61660,
    2481,  2490,   104,  2559, -3400, -3400, -3400, -3400, 24809,  2652,
    2803,  2655,  2656,  2482,  2484, 45483,  1292, 61660, 61660, 61660,
   61660, 61660, 61660,  2666,  1292, -3400, -3400, -3400,  1570, -3400,
    1169, -3400,  2441, -3400, 24809,    75, 47283,  2431, 29937, -3400,
    2514, -3400,  2520,   969, -3400,  1281, -3400,   105,  2663,  2456,
    2456,  2456,  2456,  2456,   961, -3400, -3400, -3400,  2727, 61660,
    1188, -3400,  2458, 55823, -3400, -3400,  1551, 53129, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,  1274,  1867,  1867,  1867,
    1867, -3400, -3400, -3400,  2624,  2621,  2448, 61660, -3400,   613,
    2753, 55823, 52231,  1523, 61660,  2850,  2732,  1922,  2644, 55823,
    3866, -3400, 41429, -3400,  2473,  2735,  2740,  2762, -3400, 27659,
   58517,  2471,  1046, -3400, 58517, 58966, -3400,   997,  2480, 23859,
    2398,  1723, -3400,  2871, -3400,  1742, -3400,  1881, -3400, 61660,
   61660, 61660, 61660,  2483,  2485, -3400,  1881,  2662,   245, -3400,
    2671,   245,  1881,  1922, -3400,    52, -3400, -3400, -3400, -3400,
   -3400, 24809, -3400, -3400,  2577, -3400, -3400, 51332,  1221, -3400,
   -3400,  1221, -3400,  1221,  2956,  1881,  2494, -3400,  1881,  1881,
    2060,  2060,  1881, 59415,  2901,  2774, -3400,  1208, -3400, -3400,
   21484, -3400,    48, -3400,    50,   -77,  2715, -3400, -3400, -3400,
   -3400, 47283, -3400, -3400, -3400, -3400, -3400, 61660,  2684,  2502,
   59415,  2880,   245, -3400,  1227,   983,  1023, -3400, 24809, 24809,
      14, -3400,  8841,  1346,  2509,  2510,  1358, -3400, -3400, -3400,
   -3400, -3400, -3400,  2513,  2794, -3400, -3400,  2517,  1367,  1369,
    2518,  2523, -3400, -3400,  1885,  2530,  8894,  2531, 26234,   255,
   -3400, -3400, 26234,  2532, -3400,  1401,  7520,  2527,  2537,  2571,
    2573,  2542,  2543,  9232, 24334, 24809, 24334, 24334,  9369,  2527,
    2544,  1403, 43233,  9657,  1446, -3400, 24809, 43233,  3690, -3400,
   -3400, 24809, 61660,  2545,  2547, -3400, -3400,  3408, -3400,  2575,
   -3400, 26234, 26234,  2958, 22434, -3400, -3400,  2830, -3400, -3400,
    1717, -3400,  2556, -3400, -3400,  4195,   132, 24809,  2299, 24809,
    2636, 34071,  2534, 24809,  4937,  2002,  2002,   134,   134,    80,
      80,    80,   213,   187, -3400, -3400, -3400,  2561,  2027, 24809,
   -3400,  3017,  1389,  1530, 55823,  6646,  8128, -3400, -3400, -3400,
   28119,  2608, 24809, 24809,  2568, -3400,  1448, -3400, -3400,  2367,
    2956,   969,    22,   969,   839, 36833, -3400,  2326, -3400, -3400,
    1463, 32222,  2298, 21959,   997, -3400, -3400, -3400,  1470, 24809,
   -3400, -3400,  2882,  1568, -3400, 61660,  2465,  2465, 24809, 24809,
   22909, -3400, -3400,  2562, -3400, -3400, -3400, -3400, -3400,  2564,
   -3400, -3400, -3400,  3007,  2570,  2565,  2572,  2578, -3400, -3400,
   61660, 61660, 61660, -3400, -3400, -3400, -3400, -3400,  2785, -3400,
   24809,    68,  2576,  2582, 61660,   245, -3400, 10280, -3400, -3400,
   -3400,  2811, -3400, -3400, -3400, -3400,  2752, -3400, -3400,  1211,
   -3400, 45033, 48183, -3400, 48183, -3400,  1211,  1048, -3400,  1881,
   -3400, -3400, -3400, -3400,  1053, -3400,   769, 47283,  2742, 45933,
    1881,  1070,  1274, 61660, 61660, -3400, -3400,  1881, -3400,  1274,
    1881,  1274, -3400, -3400, -3400, -3400, -3400, -3400,  1320, -3400,
   -3400, -3400, -3400, -3400, 61660,  1320,  1320, -3400, 47283,   249,
   -3400, -3400, -3400, -3400, -3400,   245,   245, 61660, 61660, 61660,
   61660, -3400, -3400, -3400, -3400, -3400, -3400,  2661, -3400, -3400,
   -3400,   477, -3400, -3400, -3400,  2799,  2801,  2808,  2678,  2680,
    2681,  2682, -3400,  2683,  2686,  2687, -3400, -3400, -3400, -3400,
   61660, 61660, -3400, -3400, -3400,  7383,  1292, 47283,  1292,  1292,
   61660, 61660,  2595, -3400, -3400, -3400,  2845,  2847,  2848,  2849,
    2851,  2852,  1292, -3400,    34,  1782, -3400,  1187, 33131,  4029,
    2616, -3400,  2617,   969,  2326, 30411,  1444, -3400, -3400, -3400,
     865,  2827,  2618, -3400,  2805,  2456, -3400,   603,   782, 59864,
   60313, 60762, -3400,  1827,  2702, -3400, -3400, 43233, 33131,  2229,
     804,  2769,   953, -3400, -3400, -3400, -3400, -3400, 55823,   105,
    1922,  1502, -3400, 47283, 51332,   510,  2630, 55823,  2631,  2628,
   -3400, -3400, -3400, -3400,  1512, -3400, 47283,   -69,  2819,  2809,
    1525, -3400, -3400,   510, 61660,  2723, 55823,  2705,  1922, 40972,
   46383,  1888, -3400, -3400,  2822, -3400, 61660, -3400, -3400, 31320,
   29488,  1046,  2645, 61660, -3400,  2647, 28119,  2881,  2825, -3400,
   28119,  2825,  1029,  2825,  2884, -3400, 32671, -3400,  2659,  1251,
   19131,  2838, 10280, -3400,   245, 47283,   245,  2728,   245,  2733,
     245, 45483,   245, 55823, -3400, 55823, -3400,   245, -3400, 10280,
   55823,  1076, -3400, -3400,  2653, -3400,  2689, -3400, -3400, 43683,
   61660,   637, -3400, -3400,  2855, -3400,   510, 61660,   997,    39,
   -3400, -3400, -3400, -3400,  2972,  2976, -3400, -3400, -3400, 54925,
      96, 61660, -3400, -3400, -3400, -3400,  2685,  1543,  9700, 24809,
   -3400,  2981, 47283, -3400, -3400, -3400, -3400, -3400, 24809, -3400,
   -3400, -3400, -3400, -3400, 24809, -3400, 24809,  2963, -3400,  3093,
   47283, 26234,   943,  2018, 27184, 26234, 26234, 26234, 26234, 26234,
   26234, 26234, 26234, 26234, -3400,   208, -3400, -3400, 24809, 24809,
    2973,  2963, -3400, -3400, -3400,  1620,  1620, 47283,  2688,  2527,
    2691,  2693, 24809, -3400, -3400,  1553, 43233, -3400, 24809,  8261,
    1558,  2756,   997,  4440, -3400,  3061,  1922, 24809,  2462,  2503,
   24809,  1567, 24809,  2982, -3400, -3400, -3400,  2698, -3400, -3400,
   47283, 24809, 26234, 26234,  4635, -3400,  5708, 24809,  2706,  5760,
   22434, -3400,   513,   513,   513,   513, -3400, 55823, 55823,  2471,
   24809,  2979,  1585,  1586, -3400,  1274, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400,  2696, -3400,  2725, -3400, -3400,    60,  2709, -3400, -3400,
    3007,  2726, 61660, -3400,  2398, -3400, -3400, -3400,  2714, -3400,
    1568, -3400, -3400, -3400,  1881, -3400, -3400, -3400, -3400, -3400,
    2731,  2729, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400,  2456,  5055, -3400, 61660, 61660,  1599, -3400, -3400,  2966,
    1125, -3400, -3400, -3400,  2792,  2804,  2806,   536,    58,  2807,
    2810, -3400,  2812, -3400, -3400, -3400, -3400,  1881,  1881, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400,   552,   581, 47283, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, 61660,  3008,   467,  1193,
   61660, 61660, 61660, 61660, 61660, 61660, 61660, -3400, -3400, -3400,
   -3400,  2730, -3400, -3400,  2967,  2969,  2974,  1292,  1292,  1292,
    1292,  1292,  1292, -3400, -3400,  1915,  3048, -3400, -3400,  2252,
    2252,   584, -3400,  2252, -3400,  2252, -3400, -3400,  2441,  2714,
    1234, -3400, -3400, -3400, -3400, -3400,   486,   969,  1660,  2737,
   -3400,  1546, 30411, 30411, 30411, 30411, 30411,  2326,   839, 55823,
     969, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400,  2738, 61660, 26234, -3400,  1021,   480,
   -3400,  2975, 55823,  2790, -3400, -3400, -3400, 47283, -3400, -3400,
    3131,   694, 55823,  3027,  2919,  1600, -3400, -3400, 61660, -3400,
    1278, -3400, 52231, -3400,  2999, 52231, -3400, 61660, -3400, -3400,
   -3400,  3101,  2840, -3400, 61660,  1421,  2814,  1726,  1922,  2705,
   61660,  2750, -3400,  2744, -3400,  4509, -3400,  1867, -3400, -3400,
     665,  2780, -3400, -3400, 58517,  2759, 61660,  1046, 28119, -3400,
   -3400,   674, -3400, 28119,  2992, -3400, 28119, 61660,  2763, 61660,
    1602, 39142, -3400,  2760, -3400, 61660, -3400, 61660, -3400,  2764,
   -3400,   245,   245, -3400,  3151,  2767,  1409,  1221,  2367, -3400,
   -3400,  3037, 59415, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
    3044, -3400, -3400, -3400, -3400, 24809, 10280, -3400,  2768, 10280,
    5356, 10280,  2973, -3400,  1015,  3050, -3400,   951,  2770,   208,
    1015,    69,    69,   176,   176,    78,    78,    78,  3093, 10280,
   10280, -3400, -3400, -3400, -3400,  2773, -3400, -3400, -3400,  2527,
   -3400, 25284, -3400, -3400,  2826,  2828,  2776, -3400, 24809, 25759,
    2772, -3400, -3400,   839,  2697, 26234, 26234,   128, -3400,   305,
   24809, 47283,  1623,   128,  2679,  2833, 24809, 24809,  6041,   136,
   24809,  5446, 55823, 55823, 55823, 55823, -3400, -3400, 10280,  3148,
    3049, -3400, -3400, -3400,  2367,  2489,  1922, -3400,   506, -3400,
   -3400, 34071, -3400, -3400, 15378, -3400,   969, -3400,  1631,  1642,
    2790, -3400,  2854, -3400, 61660, 61660,   969,   969, 47283,  2778,
   -3400,   969,   969,  2779, -3400, 61660, 61660, 61660,  1827,  2977,
    2980,   969, 61660,  2857, -3400, 61660, 61660, 61660, 61660,  3076,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400,  3026,  1292,  1292,
    1292, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  1922,  1922,
    1274,  2983, 61660,  1922,  1274, -3400,  1098,  3108, -3400,  3046,
      85,  2802,  3081,  3082, -3400, -3400,  1812,  1812, -3400, -3400,
   -3400, -3400, -3400,  3088, -3400, 24809,    59,  1015, -3400, -3400,
   -3400, -3400,  2790,  2229,  2875,  2878,   510,   -74,  3120,  3110,
     105, -3400,  1922, -3400, -3400,  2829,   949,  2818,  1523, -3400,
   -3400, -3400,   642, 61660, -3400, -3400,  3193,  3194,  3011, -3400,
   61660,  3067,  2121,  3115,  2841, -3400, 28579,  1922,  1888, -3400,
   -3400, -3400, -3400, -3400,  2921, 61660, -3400, -3400, 61660,  1643,
   -3400, 24809,  2842, -3400, -3400, 28119,   674,  1651, 61660,  1663,
   47283, -3400, -3400, -3400,   245,   245,   245,   245, -3400, -3400,
    2753, 61660,  3123, -3400, -3400,  3019, -3400, 59415, 10280, -3400,
   -3400, -3400, 26234,  3124, -3400,  2853, 26234, -3400,  2860,  1667,
    1675, -3400, -3400, -3400,  5775,  2905, 10280,  2954,  2856, -3400,
     244,   244,   305,  1711, -3400, 26234, 26234,   128,   128, 24809,
     128, -3400, -3400, -3400, -3400, -3400, 24809, 24809, -3400, -3400,
    1234, -3400, -3400, -3400, -3400,   839, -3400,  2862, -3400, -3400,
    2995,  2790,  2875, -3400, -3400, -3400, 29039, 34071, -3400,   536,
    2864,  2867,    58, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   24809, -3400,   669,   463,  2900,  1881,  3135,  1292, -3400, -3400,
   -3400,  1782, -3400, -3400, -3400, 61660,  2861, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, 43683,  3270, 55823,   486,  6618,
    3070, -3400,  2875,  3098,  3141, -3400, 61660,  1421, 52231, -3400,
    1054,  3038, -3400, -3400,  1523,  1143,  1178, -3400, 55823,  2809,
    3018, -3400,  3021, -3400,  3066,  3071, -3400, -3400,  1922, -3400,
   61660, 28579, 24809,  1715, -3400, 61211, 20532, -3400, -3400, 55823,
   -3400,  1730, -3400, 10280, 61660, -3400, -3400, -3400,  1745, -3400,
   -3400, -3400, -3400, -3400,   510, -3400,    96,   220, 26234, 26234,
     232, 24809, -3400, 24809, -3400, -3400, -3400,   350, -3400, -3400,
     244,   244,   128,  2527, 10280, -3400, -3400, -3400, -3400, 55823,
    2875, -3400, 47283,  1742,   -82, -3400, 47283, 47283, -3400, 10280,
   61660, 61660, 61660, 61660, 61660, -3400,  2861,  3270,  3281, -3400,
   -3400,  3183, -3400, -3400,   554,  3084,  3000,  3191, -3400, -3400,
   -3400, -3400, 61660,  2809, -3400, -3400, -3400, -3400, -3400, -3400,
    1752,  2840, -3400, -3400, -3400, -3400, -3400, -3400,  1761,  6860,
    2790, 28579, 61660, -3400,   163,   163,  2608, -3400,  1776, -3400,
   -3400,   220,   984, -3400,  1807,  1816,  2968, -3400,  2229, -3400,
    1820, -3400, -3400, 45483, -3400,  1821,  1829,  2903,  2960,  2903,
   -3400,  1881, -3400, -3400,  3216, -3400, -3400,   113, -3400,  3091,
    3092, 61660, 61660,  3304,  2920,  2840, -3400, -3400,  2790, 61211,
    2840, -3400, -3400,  1568,  1568,  3228, -3400, -3400, -3400, -3400,
   -3400,  3098, 43683,  2922, -3400, -3400, 61660,  3051,   810,   810,
    2987, -3400,  3241, -3400, -3400, -3400,   536, 38232, -3400,  2840,
     163,  2608, -3400, -3400,   143,  3084,  1742,  3073, -3400,  3220,
   -3400,  3332, -3400,   154, -3400, -3400,  2778,  1837, -3400,  2165,
   -3400,  1183,  2608,  1568, -3400, -3400, -3400,  1366,   486, -3400,
   -3400,  3083, -3400, -3400, -3400, -3400, 38232, 24809, -3400, -3400,
   -3400,   741, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   43683, -3400,  1855,  1456, -3400, -3400,  1486,  1560,  2934,  1274,
   -3400,   741, 38232, -3400,  1857, -3400
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3400, -3400, -3400, -3400, -3400,  3173, -3400, -1066,  -285, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400,  1214, -3400, -3400,  -130,  1231,  2022, -3400,   932,
   -3400, -3400, -3400, -1335, -3400,   157,   450, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400,  1297, -3400,  -994,   818,  1137, -3400,
   -3400, -3400, -3400,  1268,    61, -3400, -3400, -3400, -3400, -3400,
   -1589,  -136,   282, -3400,   284,  1330,   406, -3400,    37, -3400,
   -3400, -3400, -3400, -1204,   901, -2620, -2456,   283,  -335,  -357,
    -311,  -309,  -338, -3400, -3201, -3357, -2332, -3296, -3400, -3400,
     653, -3400, -3400,   297, -1584, -3400,  1794, -3400, -3400, -3400,
   -3400,    19, -3400, -3400, -3400,   -46, -3400, -3400, -3400, -1573,
   -3400,  1270, -2617, -3400, -3400, -3400,  -404,  -376, -3400, -3399,
      73,    76, -3400, -3400, -3400, -3400, -1090, -3400,   755,   756,
   -1070, -3400, -3400,   789, -3400, -3400,  -329,   -81,  1830, -3400,
    -337, -3400, -3400, -3400,   -79, -3400, -3400, -3400, -3400, -3400,
   -3400, -1706,  -389, -1585, -3400, -3400,  3286,   937,   438, -3400,
   -3400, -1924, -1569, -3400,  -166,   847,  2226, -1228, -2285,   250,
   -3400, -3400, -1717, -3400, -3400, -3400,  1160, -1561, -3400,   307,
    -144,  -240, -3379, -2429, -2879, -3400, -3400, -1188, -3400,   921,
    1430, -3400,  1434, -3400, -1895,   314,  -938, -2647, -3024, -3400,
   -3400, -3400, -3400, -3400, -3400, -1694, -1520, -3400,  -197, -3400,
   -3400, -3400, -3400,   592, -3400,   -31, -3400, -3400, -3400, -3400,
   -3400, -3400,  -336,  -369, -3400, -3400, -3400,   505, -3400, -3400,
   -3400,  1489, -1089,  -924,  2521, -1558,  -102, -3400, -3400, -3400,
    1302, -2063, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -1457,
   -3400, -3400, -3400, -3400, -3400, -3400,  1554,  3338,  -776, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  2271,   349,
   -3400,   -54, -3400, -3400,   683, -2182,   -50, -3400, -3400, -3400,
   -3400,  -470,   -48, -3400,  1011, -3400, -3400, -1861, -3400,  2274,
    1210,   293,   -72,   -21,  -239,    72,   855, -3400, -3400,  -200,
    1007, -3400, -3400, -3400, -3400,  1012,  2087, -3400,  1003,  -410,
   -3400, -3400,  2089, -3400, -3400,  2088,  1561, -3400,  1581,  1052,
   -2146,  1275, -2158,   751,  -784,    62,  -163,  2692, -3400, -2566,
    1033, -2954,   379,  2407, -1853, -2537, -1478, -3400, -3400, -1193,
    2928, -3400, -3400, -3400,  4120,  5049, -3400, -3400,  6775,  7573,
   -3400, -1147,   625,  8289,  1997, -1273, -1612, 11942,  1925,  1899,
   -1628, -3400, -3400, -3400,  -119,   635,  1700, -3400,  1606, -3400,
    -743, -3400, 13154,  1034, -3400,  -803, -3400, -1233, -3400, -1719,
   -3400, -3400, -3400, -3400, -3400, -1649, -2718,  -847,  1097, -3400,
   -3400,  1190, -3400, -3400, -3400, -1073, -1008, -1818,  1102, -1841,
   -3400,  -984,  1223,  1661,  6362,  -893,  1290,  -846,  8541,  -132,
   -2019, -1371, -1038, -3400,  -499, -3400, 10216,   111, -3400, -3400,
      -2,  -778,   960, -1850, -3400,   -38, -3400,  -895, -1006, -2944,
    1592, -3400, -3400,  2946,   790, -3400,  2372, -3400,  1305,  1872,
   -3400, -3400,  1548,  -880,   -70, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  2113,
      87, -3400,   -49, -3400, -3400, -3400, -3400, -3400,  3205,  -310,
   -3400,  2675,  -301, -3400, -3400, -3400, -3400, -3400, -3400, -3400,
   -3400, -3400,  2125,  1583, -3400,  2498, -3400, -3400, -3400,   -67,
   -3400,  2306,  -140, -3400, -3400, -3400, -1114,  1083,  2524,  -881,
    -953,  1557, -3400, -3400, -3400, -3400, -3400, -3400, -3400,  1256,
   -3400, -3400,  1081,  1259, -3400, -3400,   347, -3400, -3400,   252,
     352, -3400,  2197, -3400, -3400, -3400,   599, -3400, -3400, -3400,
    -589,  8908,   118,  -113,  -104,   651, -3400,  2933, 11799,  -745,
       5,  2133,  6363, 11835,  -112,  -103,  -142,   100,   248, -2384,
   -3400,  3192,  1569,  1280,  -944, 10056,  1834,  5070,    -9,  -783,
   -1096,  2358,  -714, -1688, -3400,  3581
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1996
static const short yytable[] =
{
      75,   988,   745,   752,  2274,  1690,   334,  2285,   844,   827,
    2072,   746,   753,  1195,  1046,   832,  1430,  1203,  2184,  1398,
    1570,   974,  1771,   654,   329,  1250,  1212,  1531,   330,   346,
     332,  1090,   384,  1466,  2307,  2289,  1561,  1001,   947,  1781,
    1390,  1575,  1827,   745,   752,  2479,  1002,  2185,   630,  2576,
    1480,  1906,   746,   753,  2256,  2830,  1179,   335,   923,  2209,
     654,   943,   980,   787,  2210,  1377,  1644,  2347,   943,   379,
     943,  1156,   379,  1598,  1659,  2211,  2489,   837,  2783,  2212,
     966,  1400,  1526,   376,   629,  1640,   376,  2213,  3006,  3140,
    2214,   942,  1646,  1800,  1801,  1470,  2775,  2777,   942,  1660,
     942,  3322,  3144,  2761,  3178,  2497,   379,  1230,   874,  3414,
     745,   752,  1816,    74,  2014,  1727,  1685,  1237,  1200,   746,
     753,  1244,  2513,   803,  1721,  2494,  1449,  2698,  2699,  2700,
    2701,  1794,  1795,  1668,  1034,  1513,  2175,  1463,   838,  1887,
    1463,  2860,  1894,   916,  1658,   833,  2177,   379,  3101,  2523,
    2860, -1150,  1850,  2527,  1813,  1456,  1457,  1845,  1467,  2563,
    2565,  1714,  3261,  1221,  2680,  2226, -1145,  1268,   383,   334,
    2117,  1392,  1055,  1371,  2470,  1853,  3124,  2273,   377,   629,
    2705,   377,   848,  1761,  2420,  2020,  1714,   329, -1329,  3691,
    2839,   330,  1494,   332,   945, -1329,   375,   801,  -313,   375,
    1850,   945,  1714,   945,  2454,  1714,  1850,  1254,  2322,   647,
    2341,  2455,   994,  2231,   379,   377,  3126, -1345,  2508,   987,
     335,  2108,  2231,  1853, -1345,  3825,  2420,  3609,  1854,  1853,
    3158,  2652,  2820,   375,  2822,   257,  1765,  2415,  1460,  2166,
    2673,  2583,  1043,  3467,  3385,  3469,  3671,  3725,  2860,  2458,
    3742,  2788,  3711,  2790,  2500,  1241,   377,   764,  2156,  1850,
    1517,  3341,  1423, -1004,  1106,   995,  2022,  2221,  1059,  1369,
    1553,  1880,  1074,  2824,   375,  3788,  1728,  1241,  2041, -1875,
    2860,  2020,  1853,  1822,  1823,  1850,  1740,  1741,  2108,  1495,
    2025,   765,  2860,  1914,  3095,  2021,  3693,  2375,   952,  1424,
    1483,  1570,  1106,   944,  2860,  1143,  3542,  1554,  1853,  2862,
     944,  3833,   944,  1567,   788,  1030,  2860,  2323,     3,  2157,
    1424, -1004,  2681,   377,  3095,  1484,   378,  2860,  2501,   378,
    2236,  1915,  1824,  1028,  2109,   996,  2825,  2222,   379,  1370,
     760,   375,   761,  1425,  1827,  3590,  3765, -1902,  1856,  1884,
    3130,  1107,   376,  1186,  1714,  1699,  2042,  1518,   925,  1193,
   -1918,  3342,  2022,   378,  1425, -1004,  1393,  1574,  1857,  1858,
    1438,  3387,  2863,   379,  3739,  1241,  3826,  1850,  2459,  1067,
    2584,  1070,  3131,  1912,  1585,   209,   953,   376,  3592,  1107,
    3800,  2023,  3132,  2151,  1101,  1715,  2232,  3743,   257, -1944,
    1853,  1759,  1883,  3703,   378,  3598,  2509,  1575, -1117,   648,
    1643,  1773,  1800,  1801,  2821,  1458,  2823,  1861,   849,  1816,
    1715,  1148,  1782,  3036,  3628,  1725,  2118,  1857,  1858,  3849,
     926,  1862,  1039,  2063,  2167,  1164,  1715,   997,  2119,  1715,
    1232,  2349,  1930,  1931,  1568,  3834,   227,   377,  2862,  3074,
    1044,  1265,  1248,  1057,  1555,  1394,  1794,  1795,  1789,  2491,
   -1996,  2662,  1002,  2227,  1813,   375,   832,  1478,  3133,  1027,
    1234,   378,  2862,  2567,  2421,  2861,  1861,  2024, -1329,  1496,
    2146,  2240,   377,  2324,  2862,  1255,  2120,  2023, -1150,  1692,
     850, -1150,   851,  2123,  2456,  2862, -1150, -1150, -1150,  2325,
     375,  2818,  1766, -1145,  1720,  1762, -1145, -1345,  2173,  2149,
    2653, -1145, -1145, -1145,  3638, -1150,  2922,  3670,  2223,  1881,
    1519,  1846,  2864, -1875,  3491,  1881,  3789,  1035,   837,  2169,
   -1145,  1556,  1843,  1643,  2178,  2863, -1996, -1996,  1716,  2868,
    2869,  2870,  2871,  2872,  2873, -1996,  1569,  2863,  3328,  3329,
    1895,    49,  2178,  2873,   628,  1874,   764,   628,  2863,    52,
      53,    54,    55,  1766,    56,  3396,  3397,  3398,  3399,  3400,
    1446,   628,  2175,  2024,   240,  1999,  2045,  1467,  1439,  1692,
    1154,  1865,  3222,   306, -1425,  1036,   385,   762,  1715,   838,
     765, -1902,  2902,   927,   928,   378,   833, -1819,  1869,  1870,
    1871,  1872,  1873,  1874, -1918,  2035,  1871,  1872,  1873,  1874,
    1076,  2040,  2629,  3037,  2293,  1095,  1097,  2436,  1265,  1579,
    3187,  2256,  1103,  1721,  3191,  1581,  2030, -1877,  3736,  2238,
     378,  2965,  3110,  1944,  2970,   798,  1172,  1069,  1071,  3410,
    1651,  3064,  3065, -1944,  2535,  3385,   745,   752,  2870,  2871,
    2872,  2873,  2975,  1155,  3038,   746,   753,  1869,  1870,  1871,
    1872,  1873,  1874,  3356,  2372,  2373,  1380,  3012,  1988,  3013,
    1149,  1989,  1150,  1669,  1015,  1115,  1147,  1652,  2868,  2869,
    2870,  2871,  2872,  2873,   980,  2864,   847,  2152,  1527,  1528,
    2868,  2869,  2870,  2871,  2872,  2873,  3770,  2864,  2865,  2866,
    2867,  1181,  2868,  2869,  2870,  2871,  2872,  2873,  2864,  2028,
   -1917,  2180,  3733,  3386,  2868,  2869,  2870,  2871,  2872,  2873,
    2098,  2865,  2866,  2867,  1191,  2868,  2869,  2870,  2871,  2872,
    2873,  2020,  3060,  2437,  3062,  3063,  1016,  2438,  2030,  3336,
    1574,  2601,  2640,  2635,  3799,  2021,   306,  1247,  3073,  2636,
     379,   904,  1138,  1485,   379,  2031,  3755,  2064,  1066,  1990,
    3111,  1140,  1066,  2099,  2409,  1641,  1642,  2641,   376,  1030,
    2439,  3411,  3387,  1016,  2292,  1869,  1870,  1871,  1872,  1873,
    1874,  1666,  1169,  3092,  1704,  1173,  2296,  1090,  1017,  1116,
    2630,  1018,  3320,  3593,  3737,  1066, -1117,   629,  1799, -1117,
    1485,  3178,  3681,  3602,  3610, -1117,  3357,   879,  1694,  1696,
    1226,  1575,  2022,  3092,   628,  2767,  3611,   943,   152,  1958,
     943,  1705,    55,  2032,  1653,  1017,  2314,  3450,  2181,  1379,
     895,  3100,  1388,   913,  1030,  2100,  1182,  1248,  3349,  3337,
    2637, -1819,  2256,  1066,   628,  2267,  3017,   942,  1643,  1066,
     942,  1984,    55,  3820,  2276,  3176,  2602,  2027,  2603,   377,
     895,  2310,  2311,   377,  2282,  2064,  1959,  3350,  3756,   209,
    3381, -1877,  2968,   924,   976,    75,  2768,   375,  2101,  1019,
    2102,   375,  1692,  2028,  1253,  2440,  1030,   654,   171,  2552,
    1374,  2103,  3820,  3682,  3802,  3803,  2243,  3451,  2202,   811,
     917,  1654,  2769,   152,  2305, -1917,  2308,  2309,  2126,  1643,
    2312,  1269,  3382,   973,  1079,  3338,  1019,  2770,  3820,  3810,
     629,  2928,  1382,  1384,  2104,  2771,  3576,  1080,  1081,  1082,
     227,  1083,  1084,  1085,  1086,  1087,  1088,  2023,  3326,  3116,
    2158,  2206,  1985,  3018,  3839,  1066,  2337,   629,  2772,  1692,
     945,   813,  1711,   945,  1090,  2105,  1643,  3351,   629,   629,
    3352,    49,  3612,   203,   628,  1020,   379,  2553,  1706,    52,
      53,    54,   983,   171,  3010,  3461,  1066,  2159,  2638,  2486,
    1401,  2567,  2344,  2345,   799,   985,  1489,  2106,    74,   240,
   -1917,  2180,  2693,  2353, -1917,  1466,  2356,   630,   630,   745,
     752,  1021,  2182,  2639,  2368,  2369,  1957,   378,   746,   753,
    2207,   378,  2029,   910,   991,   209,  1901,  2385,  2387,  2354,
    2355,  2773,  1535,  2024,  3452,   755,  3457,  2367,  2401,   188,
     992,  2370,  2371,   629,   629,   756,  1692,  1464,  2183,  2605,
    2606,  2642,  3460,  1958, -1070,  1707,  2391,  3464,  2392,  1536,
    3466,   948,  1490,  1016,  1980,    49,  2860,  1470,   628,   944,
     764,  1729,   944,    52,    53,    54,    55,  3221,  2413,   225,
    2414, -1070,  2573,  1902,  1090,   377,   227,  2786,  3453,  1981,
    1730,  3019,  2476,   819,  1000,   820,   152,  2860,  3811,  3462,
    1959,  2188,  3219,   375,   765, -1569,   988,  3209,  2517,  3680,
     209,  2498,  1066,   379,  1596,  1017,  3020,  2418,  2181,  1066,
    1731,  3319,  3245,   757,  3246,  1066,  1981,  3233,  3781,  3686,
    3493,  2209,  3494,  3222,  2160,  2113,  2210,  2714,  2715,  2716,
    2717,  1982,  1448,  1746,  3605,   240,  1635,  2211,  2256,  2189,
     629,  2212,  2256,  3371,  3372,  3373,  3374,  3375,  3376,  2213,
    1448,  3445,  2214,  3812,   225,  1692,   171,  1677,  1738,  2125,
    3775,   227,  2002,  1066,  2130,  2131,  2132,  2133,  1982,   628,
    3606,  1002,  1005,  2114,  3813,  1712,  1734,  1764,  1677,  1407,
    1735,  3408,  1736,  2258,  1226,  2261,  3475,  2767,  3476,    49,
    2265,  2784,   628,  2064,  2153,  2154,  1019,    52,    53,    54,
    2163,  2161,  3646,  2596,  1678,     8,  2599,  2600,  3242,   335,
    1039,   629,   377,  2617,  2569,    75,    75,  2521,    75,  1066,
     240,  2190,  1983,   378,  2862,  3216,  1166,  2580,   335,  3247,
     375,  2768,  3262,   758,    49,  3824,  2126,   628,  3409,  3248,
     949,  2587,    52,    53,    54,  2590,  1635,  3495,  2768,  2779,
    1008,  1787,  1074,  1167,  3401,  2862,  3838,  2769,  3579,  1983,
    1499,  2618,  2217,  2218,  2219,  2220,   889,  1066,  1803,  2009,
    1574,  1009,  3193,  2191,  2769,  3704,  2138,  2619,  2585,  1533,
    2771,  1010,  2182,   209,  1643,   890,  1679,  2863,  1500,  2770,
     120,  1168,  1386,  1066,  2010,  3773,  3774,  2771,  1830,  1844,
    1558,  3705,   654,   654,  1534,  1899,  1900,  1679,   124,  1849,
    3707,  2588,  1904,  1166,  1841,  3580,   764,  1487,  2863,  3635,
    2772,  2011,   745,  1066,  1066,  2620,  1066,  2286,    74,    74,
    1499,    74,   753,  1680,  1238,   629,  3708,   225,  1551,  2140,
    3142,  1501,  1488,  1066,   227,   629,   203,   943,  1384,  2192,
     765,  2193,  1559,  2142,  1680,  2197,  1886,  1252,  1500,  1011,
     378,  2204,  2143,  1552,  2141,  3015,   943,  3706,  1521,  1489,
    1502,  3823,   745,   752,  2693,  2228,  2773,   942,  1168,  3767,
    1913,   746,   753,   654,   629,  2144,  1996,  1464,  1655,  3358,
    3016,  1464,  1464,  2773,  2134,  1045,   942,  1523,  1949,  1949,
    2688,  1949,  3709,   240,  3699,  2692,  1056,  1656,  3359,  1560,
    1681,  1501,  1066,   203,  3174,  1066,  1066,   630,  1012,  1945,
    1524,  2409,  1822,  1823,   628,  1946,   379,   379,   379,  3700,
     795,  1681,    55,  3798,   938,  1490,  1489,  2864,  3801,    49,
    1502,   376,   376,   972,  3568,  3569,  3570,    52,    53,    54,
    2865,  2866,  2867,   629,  2868,  2869,  2870,  2871,  2872,  2873,
    1152,  2834,  1153,   379,  3777,  3533,   811,  3822,  2864,  2291,
     379,  1826,  1635,  1722,  1111,  1723,   379,   376,  1112,  1013,
     945,  2865,  2866,  2867,  2006,  2868,  2869,  2870,  2871,  2872,
    2873,  1950,  1952,   203,  1956,  2044,  3402,  1505,  1850,   945,
    1448,  2835,  1490,  1506,  1448,  1448,  1635,  1099,  2111,  2836,
    1507,  2116,  1104,  1851,  2802,  2124,  1489,  1521,   813,  1493,
    1635,  1853,  3014,   988,  1509,   628,  1854,  1799,   152,  2015,
     745,   752,  1510,    55,  1503,   377,   377,   377,  1105,   746,
     753,   895,  1522,  1532,  2108,  2837,  1523,  2888,  1145,  2890,
    2891,  2115,  1562,   375,   375,   375,  2264,  1992,  2966,  1504,
    2256,   775,  1890,   203,  2290,  2256,  1891,  1505,  2256,  1524,
    2291,  1635,   377,  1506,  2427,  2330,  2428,  3697,  1511,   377,
    1507,  2331,  3442,  2663,  1146,   377,  1508,  1973,  2172,   944,
     375,  1974,  2889,  2294,  1509,  1142,  2429,   375,   171,  3332,
    1162,  3230,  1510,   375,  1799,  1635,  2015,  1786,   944,   240,
   -1431,  1448,  3263,  3264,  2338,   766,  1157,  1448, -1431, -1431,
   -1431,  2911,  3379,  3380,  2487,  2529,  3383,  1384,  3384,  1170,
    1635,  2331,   800,  1002,   379,  1111,  3538, -1431,   238,  1112,
    1171,   239,  1855,  3685,   876,  2560,  1856,  3159,  1511,  2676,
     819,  2561,   820,  3840,   188,  2677,  1843,  2895,  1177,  2984,
   -1417,  2250,  2900,   629, -1417,  1174,  1857,  1858,  2706,  2942,
    2943,  3509,  3094,  1066,  2707,  1066,   628,  2511,  1635,  1859,
    1066,  1974,   807,   378,   378,   378,  -322,  3292,  2816,  1635,
    1799,  2430,  1485,  1448,  2817,   950,  2431,    55,  1090,    56,
    2336,  2432,  3094,  3031,  1201,  2967,  1575,  2833,  1197,  1188,
    3033,  3034,  1860,  2291,  2288,  1861,  1723,    75,  2333,  1208,
     378,    75,  2334,  1213,  2335,   209,    49,   378,  1111,  1862,
   -1431,  1863,  1112,   378,    52,    53,    54,  3027,  3028,   745,
     752,   987,  1066,   377,    49,  2409,   877,   628,   746,   753,
    2258,   335,    52,    53,    54, -1117,   811,  1228, -1117,  2979,
    1799,   375,  2015, -1117, -1117, -1117,  2365,  1241,  2666,  2667,
    2668,  2669,  2670,  2671,  -647,   628,  1066,  1066,  2932,   225,
    2933,  1198,  1799,    55,  1066,    56,   227,  1066,   128,   129,
    1066,  1446,  1225,   628,  1864,  2366,  1811,  1812,  1066,  1066,
    1047,  3537,   629,  1048,  1199,  1245,  1066,  2433,   813,  1066,
    1066,  1066,  1066,  1049,  1050,  2434,  1246,  2693,  3625,  1066,
    1066,  1231,  1066,  1233,  1066,  1235,  2843,  1066,  1257,  2409,
      74,  1236,  2291,  1051,    74,  2425,  1052,  2256,  2846,  2245,
    2246,  1635,  1066,   379,  2291,  3841,  1066,  2850,  1266,  2851,
    1066,  1776,  1777,  2291,  1066,  2291,  2711,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  3227,  1066,  3687,  3436,
    3437,  3438,  1066,  2484,  1262,  1908,  1066,  1570,  1263,  1865,
    2787,  2877,  2789,  2894,  3077,  2537,  2913,  2291,  2914,  2291,
    1264,   378,  1866,  1867,  1868,  1265,  1869,  1870,  1871,  1872,
    1873,  1874,   745,   752,  2147,  3099,  1267,  2688,  2915,   629,
    1270,   746,   753,  2148,  3102,  3103,  3104,  3105,  3106,  2934,
    -979,  2935,  3107,  3667,  3078,   379,  2897,  2515,  2945,  2515,
    1030,  1271,  2898,  -979,  2291,  2979,  3860,  1066,  3861,   376,
     819,  1389,   820,  2971,  3124,  3079,  1395,  1593,  1594,  2972,
    2976,   822,   377,  2737,  2738,  1609,  1692,  1850,  3125,   630,
     825,  1391,  2202,  1053,  3080,  2979,  1414,   379,  -971,   379,
     375,  2258,  1851,  -979,  3747,  1909,  3749,  3200,  2748,  3081,
    1853,   376,  3147,   376,  3126,  1854,  3127,  3192,  3148,  3195,
    1396,  -979,  3156,  3625,  3082,   629,  1499,  1397,  3157,  1464,
    1406,    75,  1420,    75,  1422,  3163,   379,  1407,  2916,  3377,
     988,  3164,  1414,  2917,  2981,  2982,  3102,  3103,  3104,  3105,
    3106,  1066,    49,  3234,  1500,   628,  3395,  3674,  1408,  2291,
      52,    53,    54,  3270,   377,  -979,  2985,  2986,  3277,  3271,
    1415,  1635,  1079,  -979,  3278,  1635,  1635,  3288,  1416,  3783,
    1822,  1823,   375,  2291,  3128,  1080,  1081,  1082,  3513,  1083,
    1084,  1085,  1086,  1087,  1088,  3311,  3312,  1418,  1096,  1421,
    2712,  2291,  2291,  3083,  1850,  1432,   377,  1501,   377,  3330,
    3421,  3084,  3471,  1440,  2586,  3164,  3422,  3449,  2291,  3269,
    3392,  3393,  1141,  3625,   375,  1436,   375,  1853,  2987,  2988,
     378,  1855,  1854,  3514,  1448,  1856,  1502,  1437,  1441,  2331,
    3085,  3540,  1448,  3129,    74,   377,    74,  3164,  3130,  2918,
    1459,  1461,  3541,  3632,  1442,  1857,  1858,  2919,  3164,  1692,
    1596,  3637, -1130,   375,  2749, -1130,  1443,  3148,  1859,  1066,
   -1130, -1130, -1130,  3639,  1444,  -979,  1635,  3652, -1768,  3148,
    3131,  3272,  1445,  3653,   629,  3654, -1768, -1768, -1768,  1805,
    3132,  2291,   629,  1452,  1453,  1066,   629,  1635,  1458,   238,
      49,  1860,   239,   628,  1861, -1768,  2687,  1455,    52,    53,
      54,    55,   378,    56, -1157,   988,  1471, -1157,  1862,  1446,
    1863,  3659, -1157, -1157, -1157,  3720, -1770,  2331,  1472,  2745,
    1474,  3721,  1481,  1249, -1770, -1770, -1770,  1485,  1251,  1448,
    3727, -1157,  1448,  1448,  2713,  3032,  1692,  1414,  1855,  1260,
    1498,  1515,  1856, -1770,   378,  3729,   378,  1030,  2760,   203,
    2357,  3148,  3766,  1505,  1557,   629,  3133,  1529,  1766,  1506,
    1066,  3768,  1857,  1858,  1530,  2797,  1507,  3721,  1251, -1766,
    1066,  1563,  1489,  1864,  1565,  1859,  3776, -1766, -1766, -1766,
    1509,  1566,  1692,   378,  1251,  2937,  2938,  2258,  1510,  1403,
      49,  2258,  1582,   628,  1951,  1951, -1766,  1951,    52,    53,
      54,   629,  1066,  1417,  3104,  3105,  3106,  3778,  1580,   745,
     752,  1861,  2358,  2898,   745,   752,  3779,  1848,   746,   753,
    3782,  3784,  2291,   746,   753,  1862,  2331,  2331,  1591,  3785,
    1074,  1066,  1587,  1589,  1511,  2331,  1600,  3835,  3177,  3391,
    1597, -1765,  1635,  3836,  2688,  2688,  2688,  2688,  2688, -1765,
   -1765, -1765,  3404,  1637,  3536,  3859,  -979,  3865,  1865,  1066,
    1066,  2291,  1638,  3836,  2359,  1490,  1643,  2360, -1765,  -979,
    1647,  1866,  1867,  1868,  -166,  1869,  1870,  1871,  1872,  1873,
    1874,  1649,  1665,  1674,  1075,  1682,  1684,  1692,  1093,  1066,
    1864,  2854,  1686,  1066,    49,  2946,  1102,   628,  1688,  2947,
    2948,  2949,    52,    53,    54,  1066,  1066,  1066,  1066,  -979,
    2950,  2951,  2952,   379,  2953,  2954,  1687,  1066,   379,  2955,
    2956,  2957,  1066,  1841,  1151,  1576,  1689,  -979,  1158,  1691,
    1697,    49,  1066,  1066,   628,  1066,  1698,  2425,  1165,    52,
      53,    54,  1700, -1121,  1701,  1702, -1121,  -978,  1066,  1703,
    1066, -1121, -1121, -1121,  1066,  2361,  2931,  1708,  2483,  3740,
    -978,  1709,  1710,  3745,  3746,  1772,  1713,  1778,  1789,  2250,
    1066,  -979,  1785,  1774,  1793,  1865,  1661,  1663,  1664,  -979,
    1780,  1066,  1583,  1066,  1066,  1802,  1796,  1797,  3500, -1996,
   -1996,  1798,  1869,  1870,  1871,  1872,  1873,  1874, -1150,   240,
    -978, -1150,  1804,  1464,  1066,  3741, -1150, -1150, -1150,  1807,
    1066,  1808,  1822,  1823,  1809,  1810,  1815,  1817,  -978,  1066,
    1066,  1066,   377,  1818,  1819, -1150,  1820,   377,  1821,  3562,
    3563,  1828,  3565,  1829, -1160,  1831,  1832, -1160,    49,  1833,
     375,  2362, -1160, -1160, -1160,   375,    52,    53,    54,   238,
      49,  1066,   239,   628,  2860,  1584,  1251,  1933,    52,    53,
      54,  1824,  -978,  1834,  1835,  1885,  1766,  1836,  3539,  3285,
    -978,  1907,  1635,  1635,  1878,  1635,  1917,  1251,  3546,  3547,
    1932,  -979,  1934,  3550,  3551,  1947,  1423,  1969,  1635,  1972,
    1635,  1979,  1986,  3558,  1987,  2860,  1993,  1995,  1090,  1463,
    3026,  1997,  2000, -1119,  3150,  2001, -1119,  3029,  2003,  3030,
    3286, -1119, -1119, -1119,   745,   752,  1448, -1710,  2005,  1635,
    2012,  2013,  2015,   746,   753,  2016,  1850,  2017,  2034,  2033,
    1822,  1823,  3631,  2037,  2038,  2036,  2039,    49,  3829,  3183,
    2059,  1851,  3631,  2061,   832,    52,    53,    54,  2060,  1853,
    2062,  2066, -1160,  2097,  1854, -1160,  2067,  2094,  2958,  2095,
   -1160, -1160, -1160,  2068,  3837,  2096,  2108,  2112,  1635,  2122,
     378,  2136,  -978,  3151,   629,   378,   629,   629,  2127,  1826,
    3117,  2128,  2129,  2135, -1122,  2155,  2137, -1122,  3088,  1635,
     629,  3165, -1122, -1122, -1122,  2162,  1464,  2139,  2164,  2165,
    2174,  1799,  3146,  2687,  1789,  1805,  2959,  3182,  2176,  2258,
    2187,   988,  1935,   809,  2258,  3113,   629,  2258,   379,  1635,
    2199,  2203,  2862,  2216,   335,  2230,  1464,  2237,  2234,  1448,
    3173,  1384,  2239,  2241,  1635,  3710,  1448,  1448,   629,  2242,
    2248, -1120,   335,  3663, -1120,  2269,  2259,  1635,  2270, -1120,
   -1120, -1120,  3302,  3303,  3304,  3305,  2271,  2283,   335,  2272,
    2297,  1635,  2320,  2862,  3225,  2250,   629,   629,  2304,  2250,
    1855,  2860,  2313,  2316,  1856,  2328,  2340,  1066,  2298,  2303,
    2389,  1066,  2348,  2349,  2402,  2863,  3515,  2390,  2407,  1850,
    2411,  1066,  2960,  2412,  1857,  1858,  1635,  2419,  2424,  2441,
    2443,  2470,  1635,   745,   752,  2481,  2482,  1859,  3728,  1448,
    2480,  2505,   746,   753,  2488,   335,  1079,  2485,  2493,   995,
    1066,  2499,  2504,  2178,  1090,  2510,  2863,   377,  2518,  1080,
    1081,  1082,  2519,  1083,  1084,  1085,  1086,  1087,  1088,  1448,
    1860,  2528,  2262,  1861,  2530,   375,  2531,  2266,  2532,  2538,
    1066,  2540,  2542,  1635,  2121,  2543,  2275,  1862,  3751,  1066,
    2544,  2556,  2558,  2546,  2548,  1066,  2577,  1066,  2551,  2284,
    3735,  1635,  1066,  2581,  2579,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  2578,  2591,  2597,  3283,  1066,
    1066,    49,  2604,  2582,   628,  2589,  2643,  2650,  1635,    52,
      53,    54,    55,  1066,    56,  2644,  2651,   379,  2654,  1066,
    1446,  2645,  2656,  2657,  1538,  2658,  2659,  2660,  1066,  2661,
    1539,  1066,  1864,  1066,   629,  2860,  2672,  2678,  2683,  1841,
    2690,  1635,  1066,  1066,  1066,  2864,  2691,  2695,  1066,  2862,
    3516,  1066,  2696,  2704,  2708,  2718,  2719,  2720,  2865,  2866,
    2867,  1066,  2868,  2869,  2870,  2871,  2872,  2873,  1540,  2724,
    2743,    49,  2744,  3313,   628,  2746,  2756,  2258,  2757,    52,
      53,    54,    55,  2758,    56,   378,  2864,  2766,  2759,  2780,
    3530,  2785,  2791,  2793,  2800,  2792,  2258,  1894,  3564,  2865,
    2866,  2867,  2795,  2868,  2869,  2870,  2871,  2872,  2873,  2814,
    2809,  2341,  2863,  2826,  1541,  2829,  2831,  1865,  1248,  2844,
    2845,  1542,  2278,  2847,  1543,  2848,   377,  2849,  2852,  2281,
    1866,  1867,  1868,  2853,  1869,  1870,  1871,  1872,  1873,  1874,
    2855,  2858,  2876,  2291,   375,  1538,  2883,  2882,  2884,   637,
    2907,  1539,  2885,  2886,  2893,  2905,   657,  2906,   661,  1635,
    1850,  2912,  2927, -1637,  3852,  2920,  2940,   661,  2993,  3001,
    2930,  3008,  1544,  3009,  1251,  1251,  2992,  3673,  2944,  2990,
    2995,  1723,  2996,  1853,  3022,  3004,  2327,  3046,  1854,  1540,
    2997,  3005,  3047,   657,  3048,   629,   629,   629,   629,   629,
     629,  3049,   661,  2862,  3050,  3066,  3051,  3052,  3053,  3054,
     657,   661,  3055,  3056,   661,  3067,  1074,  3068,  3069,  3070,
     661,  3071,  3072,  3097,   661,  1545,  1989,  3098,  3108,   912,
    2687,  2687,  2687,  2687,  2687,  1541,  3109,  3137,  3141,  3152,
    3161,  3154,  1542,   914,  3155,  1543,   661,  1066,  3160,  3168,
    3170,   921,  2258,  3180,  3188,  3184,  3186,  3196,  1635,  1521,
    3443,   661,  2864,  3189,  3201,   931,  2863,   912,  3199,  3217,
    2910,   951,  1630,  3205,   378,  2865,  2866,  2867,  3207,  2868,
    2869,  2870,  2871,  2872,  2873,  3218,  3228,   978,  1523,  3224,
    3229,  3237,  1786,  1544,  2879,  2860,   629,  2250,  3266,  2878,
    2468,  3267,  2250,  3268, -1996,  2250,  1845,  3291,  1856,  1066,
    3279,  2631,  3314,  3290,  1066,  2978,  3299,  1066,  3309,  3316,
    1850,  3315,  3318,  3321,    55,  3324,  3331,  3333,  1857,  1858,
    3334,  1992,  3335,  3345,  3355,  1851,  3346,  3368,  3347,  3369,
    3367, -1996,  3378,  1853,  3370,  3394,  1545,  3405,  1854,  3412,
    3177,  3416,  2258,  3418,  3420,  3427,  1066,  3432,  3433,  3446,
    3447,  3717,  3440,  3455,  2496,  3465,  3723,  3723,  3458,  2205,
    3474,  3480,  3468,  3485,  3477,  3487,  3481,  1861,  3489,  3496,
    1521,  3492,  1630,  3497,  3526,  3501,  3503,  3502,  3507,  3543,
    3527,  1862,  1066,  3566,  3549,  3552,  3567,  3581,  3556,  1066,
    1066,  3557,  3560,  3386,  3575,  1546,  1066,  1066,  3535,  1523,
    3584,  1066,  1635,  3806,  3585,  3586,  2864,  1066,  1066,  3587,
    3594,  1066,  3748,  3596,  3750,  3599,  3601,  3608,  3819,  2865,
    2866,  2867,  1547,  2868,  2869,  2870,  2871,  2872,  2873,  3604,
    3614,  3615,  3618,  3532,   629,  3616,  3620,  3629,   661,  3644,
    3621,  3634,    75,  3645,  3656,  3648, -1996,  3657,  3669,  1635,
    3683,  3684,  3649,  3772,  1855,  1079,  3658,  3819,  1856,  3651,
    3572,  3573,  3668,  3676,  3597,  3577,  3677,  3164,  1080,  1081,
    1082,  3858,  1083,  1084,  1085,  1086,  1087,  1088,  1857,  1858,
    3688,  3411,  3694,  3819,  3696,  3702,   629,   629,   629,  3712,
    3714,  1859,  3713,  3795,  3753,  3715,   629,   629,  3574,  3754,
    3723,   629,  3578,  3762,  3603,  3757,  1911,  3780,  3761,  1716,
    3786,  3787,  3790,  3792,  3796,   335,  1066,  3808,  3804,  3797,
    3789,  3809,  3807,  3788,  1860,  3742,  3831,  1861,  3832,  3627,
    3850,  1865,  2625,  3862,   990,  2794,  1929,  2969,  2796,  2710,
     629,  1862,  2798,  1863,  2632,  2381,  3531,  3039,  1869,  1870,
    1871,  1872,  1873,  1874,  3425,    74,  2674,  1066,  3571,  3429,
    2607,  3348,  3003,  3591,  2250,   629,  3805,  3435,  3828,  3793,
    3791,  3815,  1066,  3214,  3430,  2229,  1066,  2694,  3864,  3617,
    3851,  1635,  3138,  3583,  3139,  3582,  3087,  3816,  3675,   919,
    3830,  2198,  3486,  3678,  1760,  2815,  3444,  3718,  1630,  2832,
    1850,  3771,  3011,  1066,  2460,  2564,  1864,  1066,  2562,  3448,
    3752,  3843,  3863,  2709,  1399,  3698,  2702,   882,  2495,  3424,
    3226,  1733,  2973,  1853,  1737,  2801,  1066,  1066,  1854,  3482,
    1066,  2977,  1630,  2989,  1967,  1965,  1970,  1066,  1066,  2492,
    2507,  2726,  2939,  3194,  2762,  2974,  1630,  3423,  3636,  2747,
    3282,   657,  3734,  3273,  2406,  2925,  2980,  1066,  2923,  1184,
    2840,  3025,  2469,  2819,  1033,  2520,  3181,  2755,  2244,  1676,
    1978,  1066,  1619,  1003,  1224,  1479,  1971,  2512,  2522,  2807,
    1769,  2964,  1462,  2808,  3483,   629,  3529,  1893,  1975,  3317,
    3484,  1865,  3182,  1025,  2526,  1719,  1066,  1630,  2803,  2299,
    3716,   661,   661,    80,  1866,  1867,  1868,     0,  1869,  1870,
    1871,  1872,  1873,  1874,  1630,     0,     0,     0,  2410,     0,
       0,     0,  3857,     0,  2533,     0,     0,     0,  2536,     0,
       0,  1630,  1066,  1066,     0,     0,   629,     0,     0,     0,
       0,     0,     0,   335,  1855,  2550,     0,     0,  1856,  2554,
       0,     0,     0,     0,     0,     0,  1630,     0,     0,  1066,
    1066,  3666,  1066,     0,  1066,     0,     0,     0,  1857,  1858,
       0,  2568,     0,  2570,     0,     0,     0,     0,     0,     0,
       0,  1859,  1770,  1635,     0,     0,     0,  1635,  1635,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3007,     0,  1630,     0,  2592,     0,     0,     0,
       0,     0,     0,     0,  1860,  1630,     0,  1861,     0,     0,
       0,  1068,   657,  1072,     0,   637,     0,  1092,     0,   637,
     661,  1862,  1066,   661,     0,   661,  1068,   637,  2380,     0,
    2633,     0,     0,     0,     0,     0,     0,  2646,     0,  2648,
       0,     0,     0,     0,  1635,     0,     0,     0,   661,     0,
       0,   657,     0,  1068,     0,   637,     0,     0,     0,   637,
    1160,   661,  3040,  3041,  2936,   661,     0,  1068,     0,   637,
       0,     0,  1850,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   661,  1066,   661,     0,  1864,  1851,     0,     0,
       0,     0,     0,     0,     0,  1853,   661,     0,  1066,   657,
    1854,     0,   661,     0,     0,     0,   661,   661,     0,     0,
       0,   661,     0,   661,     0,   661,   335,     0,  1068,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
    3856,     0,     0,     0,     0,     0,     0,  1066,  1066,   661,
       0,   661,     0,     0,     0,     0,     0,   661,     0,     0,
     335,  1066,     0,     0,     0,     0,     0,  1630,     0,     0,
       0,     0,     0,  1066,     0,     0,     0,  3313,   661,     0,
     661,  1865,     0,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1866,  1867,  1868,     0,  1869,  1870,
    1871,  1872,  1873,  1874,     0,     0,     0,     0,  1770,   661,
     657,     0,     0,     0,  1385,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2813,  1855,     0,     0,     0,
    1856,     0,     0,  1405,     0,     0,     0,     0,     0,     0,
       0,  3202,     0,  3204,     0,  3206,     0,  3208,     0,  3210,
    1857,  1858,  2813,     0,  3213,     0,  2071,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2748,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3231,   637,   637,
       0,     0,     0,     0,  1499,     0,  1860,     0,     0,  1861,
     661,     0,     0,   661,  2381,     0,   661,  2150,  2381,     0,
       0,     0,     0,  1862,     0,  1863,     0,     0,     0,     0,
       0,     0,  1500,     0,  1770,     0,     0,     0,  3143,     0,
    1068,  1068,     0,     0,     0,     0,     0,  3153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2381,  2381,     0,
       0,     0,     0,     0,     0,     0,  3169,   661,     0,     0,
       0,     0,     0,     0,     0,     0,  2196,  1630,     0,  1578,
       0,  1630,  1630,     0,     0,  1501,     0,     0,  1864,     0,
       0,     0,   661,     0,     0,     0,     0,     0,   661,     0,
       0,     0,   661,  1622,     0,     0,     0,     0,     0,   661,
       0,     0,     0,  3211,  1502,  3212,     0,  1068,  1068,     0,
    3215,     0,     0,     0,  2263,     0,     0,     0,     0,     0,
       0,  1850,     0,  1068,  1578,  2071,   661,  1673,     0,     0,
       0,     0,  2749,     0,     0,     0,  1851,     0,     0,  1251,
       0,   852,  2998,     0,  1853,     0,     0,     0,     0,  1854,
    1068,  1068,     0,   853,   661,     0,     0,     0,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,  1630,   854,  2073,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,   661,     0,  1630,     0,   855,  2901,     0,     0,     0,
     661,   912,     0,  1622,     0,   661,     0,     0,     0,     0,
     661,     0,   856,     0,     0,     0,     0,     0,  1779,     0,
       0,   661,     0,  1784,     0,     0,  2074,   203,     0,     0,
       0,  2750,     0,   857,  2075,  2076,     0,  1506,     0,     0,
       0,     0,     0,     0,  1507,     0,     0,  3306,  3307,     0,
    1489,     0,     0,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,  3057,     0,   858,  1855,  1510,     0,     0,  1856,
     859,     0,     0,     0,     0,  2077,     0,  2416,     0,     0,
       0,     0,     0,     0,   860,     0,     0,  1850,     0,  1857,
    1858,     0,     0,     0,     0,     0,     0,  2380,     0,     0,
       0,  2380,  1859,     0,     0,     0,     0,     0,     0,     0,
    1853,     0,  1511,     0,     0,  1854,  2078,     0,     0,     0,
       0,  2079,     0,  2859,     0,   657,   657,  2875,     0,     0,
       0,     0,     0,     0,     0,  1860,     0,     0,  1861,  1385,
    2380,  2380,     0,     0,     0,     0,  1927,  1927,  1630,     0,
       0,     0,  1862,     0,  1863,     0,     0,  1936,  2080,  1943,
       0,     0,     0,     0,   861,     0,  2908,  2909,  3478,  3479,
       0,     0,   862,     0,     0,  2081,  2082,     0,  2083,  2084,
       0,  2085,     0,     0,     0,     0,     0,   775,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2921,     0,     0,
       0,     0,     0,     0,     0,     0,   657,     0,   637,   863,
       0,  2086,     0,   864,     0,   865,     0,  1864,     0,  3403,
       0,   866,  3220,     0,     0,     0,     0,   661,     0,  1622,
       0, -1996,     0,     0,     0,  1856,     0,     0,     0,     0,
       0,     0,  3413,  3232,  2087,     0,     0,     0,   867,   868,
       0,     0,  3417,   869,     0,  1857,  1858,     0,     0,     0,
       0,   870,     0,  1622,     0,     0,   871,     0, -1996,     0,
       0,     0,     0,     0,     0,   872,     0,  1622,     0,  2088,
       0,  2089,     0,  1092,     0,     0,   873,  2381,     0,     0,
    2381,  2381,  2381,  2381,  2381,  2381,  2381,  2381,  2381,  2381,
       0,     0,  1865,  2090,  1861,     0,  1068,  1068,  1068,  1068,
    2091,     0,     0,  2092,     0,  1866,  1867,  1868,  1862,  1869,
    1870,  1871,  1872,  1873,  1874,     0,     0,     0,  1622,  3096,
       0,     0,  1850,     0,     0,     0,  1068,  1068,     0,     0,
       0,     0,  1068,     0,     0,  1622,     0,  1851,  2381,  2381,
       0,     0,     0,     0,     0,  1853,     0,     0,     0,     0,
    1854,     0,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1630,  1630,
       0,  1630,  2071, -1996,     0,     0,     0,  1622,     0,     0,
       0,     0,     0,     0,  1630,     0,  1630,     0,     0,     0,
     637,     0,   661,  2682,  1068,  1068,  1068,  1068,     0,     0,
       0,     0,  3522,  3523,  3524,  3525,     0,     0,  1385,  2748,
    1578,     0,     0,     0,     0,  1630,     0,     0,     0,     0,
       0,  3640,  3641,  3642,  3643,  1622,     0,  1499,     0,     0,
       0,   657,     0,     0,   661,   661,  1622,     0,     0,     0,
    1092,     0,     0,   661,   661,     0,   661,     0,     0,     0,
       0,   661,  3360,   661,  3362,  1500,  1068,     0,  1865,  1068,
       0,     0,     0,     0,  1630,     0,  1855,     0,     0,     0,
    1856,     0,     0,   661,   661,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,     0,     0,  1630,     0,     0,     0,     0,
    1857,  1858,     0,   661,     0,   661,   661,     0,     0,   661,
       0,     0,     0,  1859,     0,  2319,     0,     0,  1501,     0,
       0,     0,     0,     0,     0,  1630,     0,  1850,     0,     0,
       0,     0,     0,   912,     0,     0,  2343,     0,     0,     0,
    1630,     0,     0,     0,     0,     0,  1860,  1502,     0,  1861,
    1853,     0,  2381,  1630,     0,  1854,     0,     0,  2827,     0,
       0,     0,     0,  1862,     0,  1863,     0,  1630,     0,     0,
    1092,     0,     0,     0,     0,  2749,     0,     0,     0,     0,
    2380,     0,     0,  2380,  2380,  2380,  2380,  2380,  2380,  2380,
    2380,  2380,  2380,     0,     0,     0,     0,     0,  1622,     0,
       0,     0,  1630,  3730,     0,     0,  3244,     0,  1630,  3249,
    3250,  3251,  3252,  3253,  3254,  3255,  3256,  3257,  3258,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,  2813,     0,     0,  3296,     0,     0,
     661,  2380,  2380,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1630,
       0,     0,     0,     0,     0,     0,     0,  3294,  3295,     0,
     203, -1996,     0,     0,  1505,  1856,     0,  1630,     0,     0,
    1506,     0,     0,     0,     0,     0,     0,  1507,     0,     0,
    1943,     0,     0,  1489,     0,  1857,  1858,  3690,     0,     0,
     661,  1509,     0,     0,  1630,     0,     0,     0, -1996,  1510,
       0,  2381,  2381,  1865,     0,     0,     0,     0,  1251,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,  1630,     0,  3726,
    3281,     0,     0,     0,  1861,     0,  3544,     0,     0,     0,
     637,     0,     0,   661,     0,  1511,     0,  3553,  1862,  3555,
       0,     0,     0,     0,     0,   637,   661,     0,     0,   637,
     657,     0,     0,     0,   661,     0,     0,     0,     0,  3738,
     661,     0,     0,     0,     0,   661,   637,     0,     0,     0,
     637,   661,     0,     0,     0,     0,   661,     0,  1622,     0,
       0,     0,  1622,  1622,  3021,     0,  3024,     0,     0,     0,
       0,     0,   637,   661,   637,   661,     0,   661,     0,     0,
    2575,  2575,     0, -1996,     0,     0,   661,     0,     0,  1850,
       0,     0,     0,     0,     0,  3035,     0,     0,     0,     0,
     661,     0,     0,     0,   661,  2380,     0,   637,   661,   661,
     661,     0,  1853,     0,     0,  1630,     0,  1854,     0,     0,
       0,     0,     0,  2608,  2609,   661,   661,   661,   661,  2616,
       0,  3407,   661,   661,     0,     0,   661,   661,   661,     0,
       0,   637,   661,     0,  3061,     0,     0,     0,   637,   661,
     637,     0,   661,     0,     0,     0,     0,     0,     0,  2813,
       0,     0,     0,  1622,     0,     0,     0,     0,  1865,     0,
    1068,  1068,  1068,  1068,  1068,  1068,     0,     0,  2381,     0,
       0,     0,  2381,     0,  1622,  1869,  1870,  1871,  1872,  1873,
    1874,  2689,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2381,  2381,     0,     0,     0,     0,  1850,     0,     0,
    3149,     0,  2575,     0,  1630,     0,     0,     0,     0,     0,
     912,     0,  1851,  3035,     0,     0,     0,     0,     0,     0,
    1853,     0,     0,  1855,     0,  1854,   645,  1856,     0,     0,
    2723,     0,     0,   658,     0,  2736,     0,  2742,     0,     0,
       0,     0,     0,     0,     0,  1673,     0,  1857,  1858,     0,
       0,     0,     0,  2765,  2380,  2380,     0,  2765,  2778,     0,
    1859,     0,  3203,     0,     0,     0,     0,     0,  2071,     0,
     658,     0,  1068,  2575,  1068,  2575,     0,     0,     0,     0,
    3510,  3511,     0,     0,     0,     0,     0,   658,   658,     0,
       0,     0,     0,     0,     0,     0,  1861,   658,     0,     0,
     661,   645,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,   637,     0,     0,  3238,
       0,   645,     0,   645,  2381,  2381,     0,     0,     0,  1622,
       0,     0,     0,     0,     0,  1624,     0,  3243,   658,     0,
     661,  1855,     0,   637,     0,  1856,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1630,     0,
       0,     0,     0,     0,  3265,  1857,  1858,     0,     0,     0,
       0,     0,     0,     0,     0,  1864,     0,     0,  1859,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1770,     0,     0,
       0,     0,     0,     0,     0,  1630,     0,     0,     0,     0,
       0,  1860,     0,     0,  1861,  2904,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1862,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1092,  1624,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1865,  2380,     0,     0,     0,  2380,     0,     0,     0,     0,
       0,     0,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,
    1872,  1873,  1874,     0,  2380,  2380,     0,  3647,  1927,     0,
       0,  3650,     0,  1864,  1943,     0,     0,     0,  1850,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
    3660,  3661,     0,  1851,     0,  3353,     0,     0,   767,     0,
       0,  1853,     0,     0,     0,   658,  1854,     0,     0,     0,
       0,     0,     0,   637,   661,   661,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
    1622,     0,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   768,     0,     0,  1622,     0,  1622,  1865,     0,
       0,     0,     0,     0,     0,     0,   661,   661,  1850,   769,
       0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,  1851,     0,  3327,  1622,  1068,     0,     0,
     770,  1853,     0,     0,  3415,     0,  1854,  2380,  2380,     0,
     661,   661,   661,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   771,  1855,  3731,  3732,     0,  1856,   772,     0,     0,
       0,     0,     0,   637,   661,  1622,     0,     0,     0,     0,
       0,   773,     0,  2575,  2575,     0,  1857,  1858,     0,     0,
       0,  1624,     0,     0,     0,     0,  1622,     0,     0,  1859,
       0,     0,     0,     0,     0,     0,     0,     0,  2689,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   661,   661,   661,  1624,  1622,     0,     0,     0,
       0,     0,  1860,     0,     0,  1861,     0,     0,     0,  1624,
       0,  1622,     0,     0,     0,     0,     0,   661,     0,  1862,
       0,  1863,  1855,     0,  1622,     0,  1856,     0,   658,  1630,
       0,   774,     0,  1630,  1630,     0,     0,   661,  1622,     0,
       0,     0,  1385,     0,     0,     0,  1857,  1858,     0,   657,
       0,     0,   661,  2765,   775,     0,  3185,     0,  1770,  1859,
    1624,     0,     0,     0,     0,     0,     0,     0,     0,  3198,
       0,     0,     0,  1622,     0,     0,   776,  1624,     0,  1622,
       0,     0,   777,     0,  1864,     0,     0,     0,   778,     0,
       0,     0,  1860,     0,  1624,  1861,     0,     0,     0,     0,
    1630,     0,     0,   637,     0,  3548,     0,     0,     0,  1862,
    2319,  1863,     0,     0,     0,   779,   780,     0,     0,  1624,
     781,     0,     0,     0,   637,     0,     0,     0,   782,     0,
    1622,     0,     0,   783,     0,     0,     0,     0,     0,     0,
    1850,     0,   784,     0,     0,     0,     0,     0,  1622,     0,
       0,     0,     0,   785,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1853,     0,     0,     0,  1624,  1854,  1865,
       0,     0,     0,     0,  1864,  1622,     0,     0,  1624,     0,
       0,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,  1850,     0,     0,     0,  3490,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1850,  1622,     0,
       0,     0,     0,     0,     0,  1853,     0,     0,     0,     0,
    1854,     0,  1851,     0,     0,     0,     0,     0,     0,   645,
    1853,     0,     0,     0,     0,  1854,     0,  3149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3297,     0,     0,     0,     0,     0,     0,     0,     0,  1865,
       0,     0,     0,     0,     0,  1943,     0,     0,  1178,   658,
       0,   658,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0, -1996,     0,  3521,     0,  1856,     0,
       0,     0,     0,     0,     0,     0,     0,  2742,  2742,     0,
       0,     0,  3300,     0,     0,     0,     0,     0,  1857,  1858,
     658,     0,     0,     0,   645,     0,   645,     0,   645,     0,
       0, -1996,     0,     0,   645,   645,  1622,     0,     0,     0,
    1624,     0,     0,     0,   658,     0, -1996,     0,     0,   661,
    1856,     0,     0,   637,   661,   637,   661,   661,   661,   661,
       0,  1855,   645,     0,     0,  1856,     0,  1861,     0,     0,
    1857,  1858,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0, -1996,     0,  1857,  1858,     0,     0,   645,
       0,     0,     0,     0,     0,     0,   658,   658,  1859,     0,
     645,   645,     0,     0,     0,  2689,  2689,  2689,  2689,  2689,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1861,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
       0,  1860,     0,  1862,  1861,  1622,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1996,  1118,  1862,  1770,
    1863,  2723,     0,  1770,  1770,  2608,     0,     0,  2608,     0,
    3431,   645,     0,     0,     0,     0,     0,  2742,     0,     0,
       0,     0,     0,  2575,     0,   645,   645,     0,     0,  1119,
       0,     0,     0,  1850,     0,     0,     0,  2765,     0,   661,
       0,  1120,     0,     0,     0,     0,     0,     0, -1996,     0,
    2723,  1121,  3470,     0,   661,     0,  1853,     0,  2575,     0,
    2575,  1854,     0,  1864,     0,     0,     0,     0,  1122,     0,
    2071,     0,     0,     0,     0,   637,     0,     0,     0,     0,
       0,  1865,     0,     0,     0,     0,     0,     0,     0,  1123,
    1624,     0,     0,     0,  1624,  1624,     0,     0,  1869,  1870,
    1871,  1872,  1873,  1874,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
    1124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   645,  1865,     0,     0,     0,     0,     0,  1622,
    1125,     0,     0,  3519,     0,     0,     0,     0,  1865,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,  1866,  1867,  1868,  1126,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,     0,  1092,  3655,     0, -1996,     0,     0,
       0,  1856,     0,     0,     0,     0,  1622,   637,   661,     0,
       0,     0,     0,     0,     0,  1624,     0,     0,   637,   661,
     637,  1857,  1858,   645,     0,  3559,     0,     0,   661,   661,
    1068,   661,     0,     0, -1996,     0,  1624,     0,     0,     0,
    1127,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
       0,  1745,     0,     0,  1749,  2742,     0,     0,     0,     0,
       0,     0,     0,   775,   658,     0,     0,     0,     0,     0,
    1861,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1862,  1128,     0,     0,     0,  1129,
       0,  1130,     0,     0,     0,     0,     0,  1131,     0,     0,
       0,     0,     0,     0,     0,     0,   661,     0,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,     0,  3626,
       0,     0,     0,     0,  1132,  1133,     0,     0,  3630,  1134,
       0,   661,     0,     0,     0,     0,     0,  1135,  1622,     0,
       0,  3470,  1136,     0,     0,     0,     0,   645,     0, -1996,
       0,     0,     0,     0,  3431,     0,     0,   645,     0,     0,
     637,     0,  1137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1889,     0,
       0,     0,   658,   658,     0,     0,     0,     0,     0,     0,
       0,  1624,     0,     0,     0,     0,   645,     0,     0,   645,
       0,     0,     0,   645,   645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   751,     0,
    1092,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1865,     0,     0,     0,     0,     0,
       0,     0,   794,     0,     0,     0,     0,     0,  2742,     0,
       0,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,   751,
       0,     0,     0,   658,     0,   645,     0,     0,     0,  2575,
    1625,  2608,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1068,  3626,     0,     0,     0,  1068,  1068,
       0,     0,     0,     0,  1625,     0,   941,   661,     0,     0,
     645,     0,     0,   941,     0,   941,   645,     0,  1625,     0,
       0,     0,     0,     0,     0,     0,   751,   794,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1622,     0,     0,     0,  1622,  1622,     0,     0,     0,     0,
       0,     0,     0,  1068,  1068,  1068,  1068,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1625,
       0,     0,     0,     0,     0,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,   645,     0,  3626,  1068,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,  1622,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1624,  1624,     0,  1624,     0,     0,     0,  1625,     0,
    1850,     0,     0,     0,   661,  1068,     0,  1624,     0,  1624,
       0,     0,  1068,     0,     0,  1851,     0,     0,     0,     0,
       0,     0,     0,  1853,     0,     0,     0,     0,  1854,  1068,
       0,     0,     0,     0,     0,     0,     0,     0,  1624,     0,
    3821,     0,     0,     0,     0,   645,  1625,     0,     0,     0,
       0,     0,     0,     0,   645,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3821,
       0,     0,     0,     0,     0,     0,     0,  1624,     0,     0,
       0,     0,     0, -1993,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3821,     0,     0,  1624,     0,
       0,   658,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1889,  2302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1624, -1993,
       0,     0,     0,     0,  1855,     0,     0,     0,  1856,     0,
       0,     0, -1993,  1624,     0,     0,     0, -1993,     0,     0,
       0,     0, -1993,     0,     0, -1993,  1624, -1993,  1857,  1858,
       0,     0,     0,     0,     0,     0,     0,   645,   645,     0,
    1624,  1859,     0,     0,   645,   645,     0,     0,     0,   645,
     645,     0, -1993,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   645,     0,   645,     0,     0,  1625,
   -1993,     0,     0,     0,  1860,  1624,     0,  1861,     0,     0,
       0,  1624,     0,     0,     0,     0,   645,     0,   645,     0,
       0,  1862,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,  1850,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1993,     0,     0,  1851,     0,     0,
    1745,     0, -1993,     0,     0,  1853,     0,  2478,     0,     0,
    1854,     0,  1624,     0,     0,  2302,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1624,   645,     0,     0,     0,     0,  1864,     5,     0,     0,
   -1993,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     8,     0,     9,    10,  1624,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,   917,     0,     0,     0,     0,     0,     0,
    1624,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1993,     0,     0,     0,     0,     0,
       0,     0,     0,   645,     0,     0,     0,   645,     0,     0,
     658,  1865,     0,     0, -1993,    35,  1855,     0,     0,     0,
    1856,     0,     0,     0,  1866,  1867,  1868,     0,  1869,  1870,
    1871,  1872,  1873,  1874, -1993, -1993, -1993,     0,  3692,  1625,
    1857,  1858,     0,  1625,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,   751, -1993,     0,     0, -1993, -1993, -1993,  1058,
    1063,     0,     0,  1058,  1063,   794,     0,     0,     0,     0,
     794,   794,    36,     0,     0,     0,  1860,   794,     0,  1861,
       0,     0,     0,     0,     0,     0,    37,     0,  1624,   645,
       0,     0,     0,  1862,   794,  1863,  1058,  1063,   645,     0,
       0,   645,   645,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,   794,
       0,     0,     0,     0,  1058,  1063,     0,     0,     0,     0,
    1058,  1063,     0,     0,     0,  1625,   645,    40,  1864,     0,
      41,     0,     0,     0,   645,     0,     0,     0,   645,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,     0,
       0,     0,    42,   645,     0,     0,     0,  1624,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   794,     0,     0,     0,     0,
     794,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   794,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   645,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,  1063,    43,     0,
     794,     0,   941,     0,     0,   941,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,   794,     0,     0,     0,
    3769,   794,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,   645,     0,   794,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   658,  1745,    45,
       0,  2806,     0,  1749,     0,     0,     0,     0,     0,     0,
    1625,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,     0,
       0,  1624,    48,    49,     0,    50,     0,    51,     0,     0,
       0,    52,    53,    54,    55,     0,    56,    57,     0,     0,
       0,    58,    59,    60,    61,    62,     0,     0,    63,    64,
      65,    66,     0,    67,    68,    69,     0,    70,    71,     0,
       0,     0,     0,     0,     0,  1850,     0,     0,  1624,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1851,     0,     0,     0,  1063,   751,     0,   794,  1853,     0,
    1058,  1063,     0,  1854,     0,     0,  1058,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   794,   794,
     794,     0,     0,     0,  1058,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2302,     0,   645,     0,   645,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1624,  1063,  1850,     0,     0,     0,     0,     0,     0,  1855,
       0,     0,     0,  1856,     0,     0,     0,  1851,   794,     0,
    1625,  1625,     0,  1625,     0,  1853,     0,     0,  1633,     0,
    1854,     0,     0,  1857,  1858,     0,  1625,     0,  1625,   794,
       0,     0,     0,     0,     0,     0,  1859,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   645,     0,     0,     0,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,   645,  1860,
       0,     0,  1861,     0,     0,   645,   645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1862,     0,  1863,     0,
       0,     0,     0,     0,     0,  1063,  1063,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,  2878,     0,     0,     0,
       0,  2879,     0,     0,     0,     0,   645,  1625,   645,   645,
       0,  1850,     0,     0,     0,     0,  1855,     0,     0,     0,
    1856,     0,   645,     0,     0,     0,  1851,     0,   645,     0,
    2500,  1864,     0,   645,  1853,   645,     0,  1625,     0,  1854,
    1857,  1858,     0,     0,   794,     0,     0,   645,   645,     0,
       0,     0,  1625,  1859,     0,     0,     0,     0,   645,     0,
       0,     0,     0,     0,  1063,  1625,     0,  1063,  1063,     0,
     645,     0,  1624,     0,   658,     0,  1624,  1624,     0,  1625,
       0,     0,     0,     0,     0,     0,  1860,     0,     0,  1861,
       0,     0,     0,     0,     0,     0,     0,     0,   645,   645,
       0,     0,     0,  1862,  2501,  1863,     0,     0,     0,   658,
       0,     0,     0,     0,  1625,     0,  1865,     0,     0,     0,
    1625,     0,     0,     0,  1633,     0,     0,     0,   751,  1866,
    1867,  1868,   941,  1869,  1870,  1871,  1872,  1873,  1874,     0,
       0,  3059,     0,  1624,     0,     0,     0,     0,     0,     0,
       0,   941,     0,     0,     0,  1855,     0,     0,  1633,  1856,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,  1625,  1633,     0,     0,     0,     0,     0,     0,  1857,
    1858,     0,     0,     0,     0,     0,   794,     0,     0,  1625,
       0,     0,  1859,     0,     0,     0,     0,     0,     0,   794,
    1627,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,     0,  1633,     0,  1860,     0,     0,  1861,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,  1862,     0,  1863,     0,     0,     0,     0,  1625,
       0,     0,     0,  1865,     0,     0,   645,  1633,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,     0,  1633,     0,     0,     0,   751,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1864,     0,     0,
    1627,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2257,  1063,  1058,  1063,     0,     0,
    1633,  1058,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,  1633,     0,     0,   794,     0,     0,     0,     0,     0,
       0,   794,     0,     0,  2502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1865,  1058,  1063,     0,   794,   794,     0,     0,
       0,     0,     0,     0,     0,  1866,  1867,  1868,   794,  1869,
    1870,  1871,  1872,  1873,  1874,     0,     0,   645,   645,   645,
     645,   645,   645,     0,     0,     0,     0,     0,  1063,  1063,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,  1063,
       0,     0,  1063,     0,     0,     0,     0,   645,     0,     0,
    1063,  1063,   645,   645,   645,   645,   645,     0,  1063,     0,
     645,  1063,  1063,  1063,  1063,     0,  1625,     0,     0,     0,
       0,  1063,  1063,     0,  1063,     0,  1063,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1633,  1063,   751,     0,     0,  1063,     0,
       0,     0,  1063,     0,     0,     0,  1063,     0,     0,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,   645,  1063,
       0,     0,   794,     0,  1063,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,  1627,     0,     0,     0,
       0,     0,     0,     0,     0, -1995,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2806,     0,     0,
    1627,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1627,     0,   794,     0,     0,  1063,
       0, -1995,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1995,     0,     0,     0,     0, -1995,
       0,     0,     0,  1850, -1995,     0,     0, -1995,     0, -1995,
    1625,     0,     0,     0,     0,     0,     0,     0,  1851,     0,
       0,     0,     0,     0,     0,  1627,  1853,     0,     0,     0,
       0,  1854,     0,     0, -1995,     0,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,     0,     0,     0,   751,     0,
       0,     0, -1995,     0,     0,  2302,   645,  1625,     0,  1627,
       0,     0,     0,  1063,     0,     0,   645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   645,   645,     0,     0,
       0,   645,   645,  1633,  1627,     0,     0,  1633,  1633,     0,
       0,   645,     0,     0,     0,     0, -1995,     0,     0,     0,
       0,     0,     0,     0, -1995,     0,     0,     0,   645,   645,
     645,     0,     0,     0,     0,     0,  1850,     0,   645,   645,
       0,     0,     0,   645,     0,     0,     0,     0,     0,     0,
       0,  1851,  1627,     0,  1852,     0,     0,     0,     0,  1853,
       0,     0, -1995,  1627,  1854,     0,     0,  1855,     0,     0,
       0,  1856,     0,     0,   794,     0,     0,     0,     0,     0,
       0,     0,   645,     0,     0,     0,     0,     0,     0,     0,
       0,  1857,  1858,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,  1859,   917,     0,   645,  1633,  1625,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1995,  1063,     0,  1633,
       0,     0,     0,     0,     0,     0,     0,  1860,     0,     0,
    1861,     0,     0,     0,     0,     0, -1995,     0,     0,     0,
       0,     0,     0,     0,  1862,   794,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1995, -1995, -1995,     0,
       0,  3274,     0,     0,     0,     0,     0,     0,     0,     0,
    1855,     0,     0,   794,  1856,     0,     0,     0,     0,     0,
       0,   794,     0,     0,     0, -1995,     0,     0, -1995, -1995,
   -1995,  2257,  1063,     0,  1857,  1858,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,  1627,     0,  1859,     0,  1864,
       0,     0,     0,     0,     0,     0,   660,   645,     0,     0,
       0,     0,  3275,     0,     0,   662,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,     0,     0,     0,     0,     0,
    1860,     0,     0,  1861,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1862,     0,  1863,
     791,     0,     0,  1063,     0,     0,     0,     0,   645,   842,
       0,     0,   846,     0,  1633,     0,     0,     0,   842,     0,
       0,     0,   899,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,  1063,     0,  1865,     0,     0,     0,  1628,     0,
       0,  1625,     0,     0,   920,  1625,  1625,  1866,  1867,  1868,
       0,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,   842,
       0,  1063,  1864,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,  1063,  1063,
    1063,     0,     0,     0,     0,   751,     0,     0,     0,  1063,
     751,     0,     0,     0,  1063,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,  1063,     0,  1063,     0,     0,
       0,     0,  1625,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,  1063,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,  1627,   794,  1865,  1628,  1627,
    1627,     0,  2257,  1063,     0,  1063,  1063,     0,     0,     0,
    1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,   645,     0,     0,
       0,  1063,  1063,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,   645,     0,     0,     0,
       0,     0,     0,  1850,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1633,  1633,  1029,  1633,  1851,     0,
    1627,  2842,   645,     0,     0,     0,  1853,     0,     0,     0,
    1633,  1854,  1633,     0,     0,     0,     0,     0,     0,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1850,     0,     0,     0,
       0,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1851,     0,     0,     0,     0,     0,     0,     0,  1853,
       0,     0,     0,     0,  1854,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1628,     0,     0,  1855,     0,     0,
       0,  1856,     0,     0,     0,     0,     0,     0,     0,     0,
     751,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
     794,  1857,  1858,     0,     0,     0,  1633,     0,  1628,   794,
       0,     0,     0,     0,  1859,     0,     0,     0,     0,  1633,
       0,     0,  1628,     0,     0,     0,  1627,     0,   794,     0,
    1855,   939,     0,  1633,  1856,     0,     0,     0,   939,     0,
     939,     0,     0,     0,     0,     0,     0,  1860,  2257,  1063,
    1861,     0,  2257,  1063,  1857,  1858,     0,     0,     0,     0,
       0,     0,     0,  1063,  1862,     0,  1863,  1859,  1633,     0,
       0,     0,     0,  1628,  1633,   794,     0,   794,     0,     0,
       0,     0,   794,     0,     0,     0,     0,     0,     0,     0,
    1628,  1058,  1063,     0,     0,     0,     0,     0,     0,     0,
    1860,     0,     0,  1861,     0,     0,     0,  1628,     0,  1037,
    1038,   794,     0,     0,     0,     0,     0,  1862,     0,  1863,
       0,     0,  1063,     0,     0,  1633,     0,     0,     0,  1864,
    2856,  1063,  1628,     0,     0,     0,     0,  1063,     0,  1063,
       0,     0,     0,  1633,  1063,     0,     0,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,     0,     0,     0,
       0,  1063,  1063,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,     0,  1063,     0,     0,     0,   751,
    1628,  1063,  1864,     0,     0,     0,     0,     0,     0,     0,
    1063,  1628,     0,  1063,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,  1633,  1063,  1063,  1063,     0,     0,     0,
    1063,     0,     0,  1063,  1865,     0,     0,     0,     0,   794,
     794,     0,     0,  1063,  1850,     0,     0,  1866,  1867,  1868,
       0,  1869,  1870,  1871,  1872,  1873,  1874,     0,  1094,  1851,
       0,  1098,  2887,  1100,     0,     0,     0,  1853,     0,     0,
       0,     0,  1854,     0,     0,     0,  1627,  1627,     0,  1627,
       0,     0,     0,     0,     0,     0,  1144,  1865,     0,     0,
       0,     0,  1627,     0,  1627,     0,     0,     0,     0,  1161,
    1866,  1867,  1868,  1163,  1869,  1870,  1871,  1872,  1873,  1874,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1029,     0,   842,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1187,     0,     0,     0,     0,     0,
       0,  1633,     0,     0,     0,  1205,     0,     0,     0,  1207,
       0,  1210,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
       0,     0,  1627,     0,  1629,     0,     0,  1239,     0,  1240,
       0,  1850,     0,     0,     0,  1029,     0,     0,  1855,     0,
       0,     0,  1856,  1627,     0,     0,  1851,     0,     0,     0,
       0,     0,     0,     0,  1853,     0,  1258,     0,  1259,  1854,
       0,   794,  1857,  1858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1627,     0,  1859,     0,     0,     0,  1063,
       0,     0,     0,     0,   794,     0,     0,  1029,  1627,     0,
    1633,     0,     0,     0,   794,     0,     0,     0,     0,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,  1860,     0,
       0,  1861,     0,     0,     0,  1627,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,  1863,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
    2257,  1063,     0,     0,     0,  2257,  1063,     0,  2257,  1063,
    1627,     0,     0,     0,     0,     0,  1627,     0,     0,     0,
    2892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1855,     0,     0,  1473,  1856,
       0,  1475,     0,     0,  1477,     0,     0,     0,  1063,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,  1857,
    1858,     0,     0,     0,     0,     0,     0,  1627,     0,     0,
       0,     0,  1859,  1628,     0,     0,     0,  1628,  1628,     0,
       0,     0,     0,     0,  1063,  1627,     0,     0,     0,     0,
       0,  1063,  1063,     0,     0,  1564,     0,     0,  1063,  1063,
       0,     0,     0,  1063,  1633,  1860,     0,     0,  1861,  1063,
    1063,     0,  1627,  1063,   794,   794,   794,   794,     0,     0,
    1586,     0,  1862,     0,  1863,  1060,  1588,     0,     0,  1060,
    1590,     0,     0,     0,     0,  1865,     0,  1636,     0,     0,
       0,     0,     0,     0,     0,  1627,     0,     0,  1866,  1867,
    1868,  1633,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,
       0,     0,  1060,     0,  1670,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1628,  1850,
       0,     0,     0,     0,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,  1851,     0,     0,  2896,     0,  1628,
       0,     0,  1853,     0,     0,     0,     0,  1854,     0,     0,
    1060,     0,     0,     0,     0,     0,  1060,     0,  1063,     0,
    1629,     0,  1850,     0,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,  1851,     0,     0,
       0,     0,     0,  1768,     0,  1853,     0,     0,     0,     0,
    1854,     0,     0,     0,  1629,     0,     0,     0,  1058,  1063,
       0,     0,     0,  1627,     0,     0,     0,     0,  1629,     0,
       0,     0,  1865,     0,  1063,     0,     0,  2257,  1063,     0,
       0,     0,     0,  1633,     0,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,  1063,
       0,     0,  1060,     0,     0,     0,     0,   939,     0,  1629,
     939,     0,     0,  1855,     0,     0,     0,  1856,  1063,  1063,
       0,     0,  1063,     0,     0,     0,  1629,     0,     0,  1063,
    1063,     0,     0,  1060,     0,     0,     0,  1857,  1858,     0,
       0,     0,     0,  1629,  1628,     0,     0,     0,  1058,  1063,
    1859,     0,  1627,     0,     0,     0,  1855,     0,     0,     0,
    1856,     0,     0,  1063,     0,     0,     0,     0,  1629,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1857,  1858,     0,  1860,     0,     0,  1861,  1058,  1063,   794,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
    1862,     0,  1863,     0,     0,     0,     0,     0,     0,     0,
     794,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,  1058,  1063,  1063,  1860,  1629,     0,  1861,
       0,   794,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,  1863,     0,     0,     0,     0,
       0,  1063,  1063,     0,  1063,  2004,  1063,     0,     0,  1060,
       0,     0,     0,     0,     0,  1864,  1060,     0,     0,     0,
       0,   794,  1060,     0,     0,  1633,     0,     0,     0,  1633,
    1633,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1627,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1060,     0,     0,  1058,  1063,     0,     0,     0,     0,     0,
       0,     0,     0,  3235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
    1865,     0,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,
    1872,  1873,  1874,     0,  1628,  1628,  1060,  1628,     0,  1629,
       0,     0,   644,     0,  1058,  1063,     0,     0,     0,     0,
    1628,     0,  1628,  1865,     0,     0,     0,     0,     0,  1058,
    1063,     0,     0,  1631,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,  1628,     0,     0,  1060,     0,     0,     0,     0,     0,
    2215,     0,     0,     0,     0,     0,     0,     0,  1058,  1063,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1060,     0,  1058,  1063,     0,     0,     0,   903,    73,     0,
       0,     0,     0,     0,  1058,  1063,     0,     0,     0,     0,
    1628,     0,     0,  2268,     0,     0,     0,   644,     0,   903,
    1060,  1060,  2277,  1060,  2279,  1627,     0,     0,     0,  2280,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2295,   842,     0,     0,     0,     0,     0,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,  1060,
       0,     0,  1060,  1060,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,  1629,  1629,     0,     0,     0,     0,     0,
       0,     0,  1850,     0,     0,     0,     0,     0,  1628,     0,
       0,     0,     0,     0,  1628,     0,     0,  1851,     0,     0,
       0,     0,     0,     0,     0,  1853,     0,   900,     0,     0,
    1854,     0,     0,     0,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,   939,     0,   900,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,   939,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,  2477,     0,
       0,     0,     0,  1628,     0,     0,     0,  1631,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,  1627,     0,     0,
       0,  1627,  1627,     0,     0,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,     0,  1628,     0,     0,  1855,     0,     0,     0,
    1856,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1627,     0,
    1857,  1858,  1631,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,  1029,     0,     0,     0,     0,     0,  1631,     0,     0,
       0,     0,     0,     0,  2534,     0,     0,     0,     0,     0,
       0,     0,  2541,     0,     0,     0,  1860,     0,  2545,  1861,
       0,     0,     0,  2549,     0,     0,     0,     0,     0,  2555,
       0,     0,     0,  1862,  2557,  1863,     0,     0,     0,     0,
    1060,     0,  1060,     0,     0,  1631,     0,  1060,     0,     0,
       0,     0,     0,  2571,     0,  2572,  1631,     0,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2593,  2594,  2595,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,  2610,  2611,  2614,  2615,     0,     0,  1060,
    2621,  2624,     0,     0,  2626,  2627,  2628,     0,     0,     0,
    2634,     0,     0,     0,     0,     0,     0,  2647,     0,     0,
    2649,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,  1060,     0,     0,     0,     0,     0,
       0,  1060,     0,     0,  1060,     0,     0,  1060,     0,     0,
    1628,     0,     0,     0,     0,  1060,  1060,     0,     0,     0,
       0,     0,     0,  1060,     0,     0,  1060,  1060,  1060,  1060,
       0,     0,     0,  1865,     0,     0,  1060,  1060,     0,  1060,
       0,  1060,     0,     0,  1060,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,  1631,  1060,
       0,     0,     0,  1060,     0,     0,     0,  1060,     0,     0,
       0,  1060,     0,     0,  1060,  1060,  1060,  1060,  1060,  1060,
    1060,  1060,  1060,     0,  1060,     0,     0,     0,     0,  1060,
       0,     0,     0,  1060,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1029,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,  1629,     0,  1629,  1060,   644,     0,     0,     0,     0,
       0,     0,     0,     0,  1628,     0,  1629,     0,  1629,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2828,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
     903,     0,   903,     0,   903,     0,  1629,     0,     0,     0,
     903,   903,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,  1631,  1631,     0,     0,     0,  1629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,     0,     0,
       0,     0,  1629,     0,     0,     0,   644,   644,     0,     0,
       0,     0,     0,     0,     0,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,  2999,  3000,  1629,     0,     0,  1451,     0,     0,
    1629,     0,  1060,     0,  1631,     0,     0,     0,     0,     0,
       0,   644,   644,    73,     0,  1451,     0,     0,     0,     0,
     900,     0,   900,     0,   900,     0,     0,     0,     0,     0,
     900,   900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,     0,  1060,  3042,  3043,
    3044,  3045,     0,     0,     0,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3058,     0,     0,     0,     0,     0,   644,  1060,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   804,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,     0,     0,   805,     0,     0,     0,  1447,     0,  1631,
    3119,  3121,  3123,     0,     0,  1628,     0,     0,     0,  1628,
    1628,     0,     0,   806,     0,  1447,  1060,  1060,     0,     0,
       0,     0,     0,     0,     0,   842,     0,     0,     0,   644,
       0,     0,   807,     0,     0,  -513,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3167,  1060,     0,     0,     0,
    1060,     0,   808,     0,     0,     0,     0,     0,   809,     0,
     842,     0,  1060,  1060,  1060,  1060,     0,     0,     0,     0,
       0,     0,     0,   810,  1060,     0,  1628,     0,     0,  1060,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,  1060,
    1060,     0,  1060,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -667,  1060,   811,  1060,     0,     0,
     812,  1060,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -647,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
    1060,  1060,     0,     0,     0,     0,     0,  -424,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,   813,     0,
       0,  1060,     0,   644,     0,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,  1060,  1060,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,    73,    73,     0,    73,     0,     0,     0,
       0,     0,   644,     0,   814,  1451,   815,     0,  1060,  1451,
    1451,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -424,     0,  1631,
    1631,     0,  1631,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,  1631,     0,   816,
       0,     0,     0,  -667,     0,   817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   644,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   818,
     819,     0,   820,   821,     0,     0,     0,     0,     0,     0,
       0,   822,     0,     0,     0,   823,   824,     0,     0,     0,
     825,     0,     0,     0,     0,   826,  1451,     0,     0,     0,
       0,     0,  1451,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,  1631,  3354,     0,     0,
       0,     0,  3361,     0,  3363,  3364,  3365,  3366,     0,     0,
       0,     0,     0,     0,     0,  1447,     0,     0,     0,  1447,
    1447,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,     0,
       0,  1631,     0,     0,     0,     0,     0,     0,  1451,     0,
       0,     0,     0,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,     0,
       0,     0,  1991,     0,     0,     0,  3406,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,  1060,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1447,  1060,     0,     0,
       0,   644,  1447,     0,     0,     0,     0,     0,     0,     0,
     903,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3473,     0,     0,     0,     0,  1060,     0,     0,
    1631,     0,     0,     0,     0,     0,  1060,     0,     0,  1629,
       0,     0,  1060,     0,  1060,     0,     0,     0,  1631,  1060,
       0,     0,  1060,  1060,  1060,  1060,  1060,  1060,  1060,  1060,
    1060,  1060,     0,     0,     0,     0,  1060,  1060,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,     0,  1447,     0,
    1060,     0,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,  1060,     0,
    1060,     0,     0,     0,     0,     0,     0,     0,  1631,  1060,
    1060,  1060,     0,     0,     0,  1060,     0,     0,  1060,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,     0,     0,   903,   903,     0,     0,     0,     0,     0,
     644,   903,     0,     0,     0,   903,   903,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3545,     0,     0,     0,
     903,     0,   903,     0,     0,     0,     0,  3554,     0,     0,
     900,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   903,     0,   903,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,     0,     0,    73,
       0,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1629,  2300,     0,     0,  1629,  1629,   644,     0,     0,
       0,     0,     0,     0,  3613,     0,     0,     0,     0,     0,
       0,  3167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   900,   900,     0,     0,     0,     0,     0,
       0,   900,     0,     0,     0,   900,   900,     0,     0,     0,
       0,     0,  1629,     0,  1060,     0,     0,     0,     0,     0,
     900,     0,   900,     0,     0,  1631,     0,     0,     0,  1451,
       0,     0,     0,   644,     0,     0,     0,  1451,     0,     0,
       0,     0,   900,     0,   900,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,  1060,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,  2300,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,     0,   903,     0,     0,     0,     0,
       0,     0,     0,     0,  1451,     0,     0,  1451,  1451,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
       0,     0,     0,     0,     0,     0,  1060,  1060,     0,     0,
       0,     0,     0,  1060,  1060,     0,     0,     0,  1060,  1631,
       0,     0,     0,     0,  1060,  1060,     0,     0,  1060,  1447,
       0,     0,   644,     0,     0,     0,     0,  1447,     0,    73,
     644,    73,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   903,     0,     0,     0,     0,   903,
       0,     0,     0,  3764,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,  3794,     0,     0,   900,     0,     0,     0,     0,
       0,     0,     0,  1060,  1447,     0,     0,  1447,  1447,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
       0,     0,     0,  1060,     0,     0,     0,     0,  1631,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   900,     0,     0,     0,     0,   900,
    1060,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,  1060,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,  1060,  1060,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,   903,
       0,  1451,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,  1060,     0,  1060,
       0,  1060,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,  1631,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
       0,     0,     0,     0,     0,     0,     0,   903,     0,  1064,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,     0,  1451,     0,     0,     0,     0,     0,
       0,  1451,  1451,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
    1060,     0,     0,  1064,     0,     0,     0,  2300,     0,   900,
       0,  1447,     0,     0,     0,  1060,     0,     0,     0,     0,
       0,     0,   644,     0,   644,   644,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,     0,     0,  1451,     0,     0,     0,     0,   903,
       0,   903,     0,     0,  1060,  1060,     0,     0,     0,     0,
       0,     0,     0,  3115,   644,     0,     0,     0,  1060,     0,
       0,     0,     0,     0,  1451,     0,     0,     0,     0,     0,
    1060,     0,     0,     0,     0,     0,   644,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
       0,     0,     0,     0,     0,     0,     0,   900,     0,     0,
       0,     0,     0,     0,   644,   644,     0,     0,     0,     0,
       0,     0,     0,     0,  1447,     0,     0,     0,     0,     0,
    1064,  1447,  1447,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1447,     0,  1348,     0,     0,   900,
       0,   900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3112,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1447,     0,     0,  1411,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1632,     0,  1064,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,  1064,
       0,     0,   644,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1571,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   644,   644,   644,   644,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   903,     0,     0,     0,     0,   903,   903,
     903,   903,   903,     0,     0,     0,   903,  1064,  1064,     0,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1791,     0,
       0,     0,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,  1064,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1838,  1839,     0,  1842,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1879,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1991,     0,     0,     0,
       0,     0,     0,   900,  2058,     0,  1634,     0,   900,   900,
     900,   900,   900,     0,     0,     0,   900,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1955,  1634,     0,  1962,  1964,     0,     0,
       0,     0,   644,     0,     0,     0,     0,     0,     0,  1632,
       0,     0,   903,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   903,   903,     0,     0,  1632,   903,   903,     0,
       0,     0,     0,     0,     0,     0,     0,   903,     0,     0,
       0,     0,     0,  1632,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,   644,   644,   644,     0,     0,     0,
       0,     0,  1634,     0,   644,   644,     0,     0,  1632,   644,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1634,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1634,     0,     0,     0,   644,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,  1064,
       0,     0,  1634,     0,  1064,     0,     0,     0,     0,     0,
       0,  2300,     0,  1634,     0,     0,     0,     0,     0,     0,
      73,     0,   900,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   900,   900,     0,     0,     0,   900,   900,     0,
       0,     0,     0,     0,     0,     0,     0,   900,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1064,  1064,     0,   644,     0,     0,     0,     0,  1064,     0,
       0,  1064,     0,     0,  1064,     0,     0,     0,     0,     0,
       0,     0,  1064,  1064,     0,     0,     0,     0,     0,  1632,
    1064,     0,     0,  1064,  1064,  1064,  1064,     0,     0,     0,
       0,     0,     0,  1064,  1064,     0,  1064,     0,  1064,     0,
       0,  1064,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1634,  1064,     0,     0,     0,
    1064,     0,     0,     0,  1064,     0,     0,     0,  1064,     0,
       0,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
       0,  1064,     0,     0,     0,     0,  1064,     0,     0,     0,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2352,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3665,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2374,     0,     0,
    2376,     0,     0,  2386,     0,     0,     0,     0,     0,     0,
    2393,  2398,     0,     0,     0,  2403,     0,     0,  2408,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2417,     0,     0,     0,  2423,     0,     0,
       0,  2435,     0,     0,     0,  2442,     0,     0,  2444,  2445,
    2446,  2447,  2448,  2449,  2450,  2451,  2452,     0,  2453,     0,
       0,     0,     0,  1348,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2559,
       0,     0,     0,  2058,  2566,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,     0,  1411,  1634,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2547,     0,     0,  1632,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1064,     0,     0,     0,     0,     0,
    2655,     0,     0,     0,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2679,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2782,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
    1064,  1064,  1064,  2799,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,  1064,     0,  1064,
       0,     0,  1348,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,  1064,     0,     0,     0,  1064,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2838,     0,     0,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,  1064,  1064,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
       0,     0,     0,     0,  1064,     0,  2398,     0,  2398,  2398,
       0,     0,     0,  1064,  1064,  1064,     0,     0,  2899,     0,
       0,     0,     0,  2903,     0,     0,     0,     0,     0,     0,
    2058,  2566,     0,  2566,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,  1632,     0,  1632,  2924,
       0,  2926,     0,     0,     0,  2929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,  1634,     0,  1634,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,  1634,     0,  1634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1411,     0,     0,     0,     0,
       0,  1955,     0,  1634,     0,     0,     0,     0,     0,     0,
    1964,  1964,  1962,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2566,     0,     0,
       0,     0,  3002,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1634,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     0,  2566,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1632,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,  2566,
       0,     0,     0,     0,     0,     0,     0,     0,  1634,     0,
       0,     0,     0,     0,     0,  1876,     0,     0,     0,     0,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1632,  1634,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1064,     0,     0,  1634,     0,     0,
       0,     0,     0,  1064,     0,     0,  1632,     0,     0,  1064,
       0,  1064,     0,     0,     0,  1634,  1064,     0,     0,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,     0,
       0,     0,     0,  1064,  1064,     0,     0,     0,     0,  1632,
       0,     0,  1634,     0,     0,  1876,     0,  1064,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,  1064,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,  1634,  1064,  1064,  1064,     0,
       0,     0,  1064,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,  3236,     0,     0,     0,     0,     0,     0,     0,     0,
    3239,     0,     0,     0,     0,     0,  3240,     0,  3241,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3259,  3260,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
    2403,     0,     0,     0,     0,     0,     0,     0,     0,  3284,
       0,     0,  3287,     0,  3289,     0,     0,     0,     0,     0,
       0,     0,     0,  3293,     0,     0,     0,     0,     0,  3298,
       0,     0,  3301,  1634,     0,     0,     0,     0,  1876,     0,
       0,     0,  3308,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,  1876,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,  1876,     0,
       0,     0,  1634,  2382,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1876,  1876,     0,     0,  1876,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,  1064,     0,
       0,  1064,     0,  1876,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,  1876,
       0,     0,     0,  1064,  1064,     0,  1876,     0,  1876,     0,
    1064,  1064,     0,     0,     0,  1064,  1634,     0,     0,     0,
       0,  1064,  1064,     0,     0,  1064,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,  3488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3504,  3506,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3512,     0,     0,     0,     0,     0,  3517,  3518,
    1064,     0,  3520,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
    1064,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3589,     0,     0,
    1064,  1064,     0,     0,  1064,     0,     0,     0,     0,     0,
       0,  1064,  1064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,  3633,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
    1064,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,  1064,  1064,     0,     0,
       0,  3662,     0,     0,     0,     0,     0,     0,     0,  3664,
       0,  1632,     0,     0,     0,  1632,  1632,     0,     0,     0,
       0,     0,     0,  1064,  1064,     0,  1064,     0,  1064,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3679,     0,     0,     0,  1876,  1634,     0,     0,
       0,  1634,  1634,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,     0,
    1876,     0,  2382,  2874,     0,     0,  2382,     0,     0,     0,
    1876,     0,  1632,     0,     0,     0,     0,  1876,     0,     0,
       0,     0,  1876,     0,     0,     0,  1064,  1876,     0,    36,
       0,     0,  1876,     0,  3719,     0,     0,     0,     0,     0,
       0,  1876,     0,    37,     0,  2382,  2382,  1876,  1634,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1876,
       0,     0,    38,  2403,     0,     0,  1876,     0,  1876,  1876,
    1876,  1876,  1876,  1876,  1876,  1876,  1876,  1876,     0,     0,
       0,     0,    39,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,  1064,  1064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,  1064,     0,     0,
       0,  1876,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     9,    10,     0,    43,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,    35,     0,     0,     0,     0,     0,     0,  1876,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,  1876,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1217,     0,     0,
       0,  1218,     0,     0,     0,    71,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1876,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1876,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2874,     0,  2382,     0,     0,  2382,  2382,
    2382,  2382,  2382,  2382,  2382,  2382,  2382,  2382,     0,  2874,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,  1876,     0,     0,     0,  1876,     0,     0,
       0,     0,  2874,  2874,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2382,  2382,  1876,     0,
    1876,     0,     0,  1876,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,  1876,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1217,  1718,     0,
       0,     0,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
    2382,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1876,     0,     0,  1876,  1876,  1876,     0,     0,  2874,     0,
       0,     0,     0,  2874,  2874,  2874,  2874,  2874,  2874,  2874,
    2874,  2874,  2874,  1876,  1876,     0,     0,     0,     0,     0,
       0,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,  1876,  2382,
    2382,  1876,     0,  1876,     0,     0,     0,  1876,  2874,  2874,
       0,     0,  1876,     0,    38,  1876,     0,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,  2874,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,  2382,     0,    45,     0,
    2382,     0,     0,     0,     0,     0,     0,     0,  1876,     0,
    1876,    46,     0,     0,  2874,  2874,  1876,     0,     0,  2382,
    2382,  1876,  1876,     0,  1876,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,    50,    36,     0,     0,     0,     0,
      52,    53,    54,    55,     0,    56,    57,     0,     0,    37,
      58,    59,    60,    61,    62,     0,     0,    63,    64,  1217,
    2287,     0,     0,     0,     0,     0,     0,    71,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1876,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,     0,     0,     0,  1876,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2874,  2382,  2382,  2874,    42,     0,     0,     0,     0,
       0,     0,     0,     0,  2874,  2874,  1876,     0,  1876,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1876,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,  1876,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2874,  2874,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,    50,     0,
       0,     0,     0,     0,    52,    53,    54,    55,     0,    56,
      57,     0,     0,     0,    58,    59,    60,    61,    62,     0,
       0,    63,    64,  1217,     0,     0,     0,     0,     0,     0,
       0,    71,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,   110,   111,   112,   113,     0,
     114,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   670,   407,
     408,   409,   671,   672,   673,   674,   675,   676,   677,   410,
     411,   678,   412,   131,   413,   414,   415,   133,   134,   135,
     136,     0,   679,   416,   417,     0,   418,   419,   680,   681,
     420,   682,   137,   422,   683,   423,   424,   425,   426,   141,
     684,   685,   427,   428,   429,   430,   431,   432,   686,   433,
     434,   435,   436,   437,   687,   438,   439,   440,   146,   441,
     688,   689,   690,   691,   692,   693,   442,   443,   444,   445,
     446,   149,   150,   447,   694,   448,   695,   449,     0,   450,
     451,   452,   696,   453,   454,   455,   697,   698,   456,   457,
     458,   459,   460,   699,   461,   462,   463,   700,     0,   464,
     701,   465,   466,   467,   158,   468,   469,   160,   702,   470,
     471,   472,   162,   703,   473,   704,   474,   163,   705,   164,
     475,     0,   476,   706,   477,   167,   707,   478,   708,   479,
     480,   481,   482,   168,   483,   484,   485,   709,   486,   487,
     488,   489,   490,   491,   710,   169,   170,   711,   492,   493,
     494,   712,   172,   713,   173,   714,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,   715,   177,   178,   501,
     179,   716,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,   185,   186,   717,   518,   519,   520,   521,   522,   523,
     524,   187,   525,   718,   526,   527,   189,   528,   719,   190,
     529,   191,   530,   531,   720,   721,   532,   722,   723,   724,
     533,   534,   725,   726,   192,   193,   194,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
     727,   544,   545,   546,   547,   548,   549,   199,   550,   551,
     728,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,   729,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,   730,   573,   574,   575,
     731,   576,   211,   577,   578,   213,   579,   214,   732,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,   733,   591,   592,   734,   593,   594,   595,   596,   597,
     735,   217,   218,   736,   737,   599,   219,   600,   220,   738,
     601,   602,   603,   604,   605,   739,   740,   606,   607,   608,
     609,   741,   742,   610,   611,   612,   613,     0,   228,   615,
     229,   616,   617,   618,   743,   744,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,     0,     0,    83,    84,    85,     0,    87,
      88,    89,    90,    91,     0,     0,     0,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,     0,     0,
     877,   105,   106,   107,   108,     0,   109,   110,   111,   112,
     113,     0,   114,   115,   116,     0,     0,     0,     0,     0,
     119,   120,     0,     0,     0,     0,   121,     0,     0,     0,
       0,     0,     0,     0,     0,   122,     0,   123,     0,   124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   131,     0,     0,     0,   133,
     134,   135,   136,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   137,     0,     0,     0,     0,     0,
       0,   141,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   149,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     156,     0,     0,     0,     0,     0,   158,     0,     0,   160,
       0,     0,     0,     0,   162,     0,     0,     0,     0,   163,
       0,   164,     0,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   169,   170,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,   174,
     175,     0,   176,     0,     0,     0,     0,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   184,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,     0,     0,   189,     0,
       0,   190,     0,   191,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   192,   193,   194,   195,
       0,     0,     0,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   207,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,   214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,   218,     0,     0,     0,   219,     0,
     220,     0,     0,     0,     0,     0,     0,   223,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     228,     0,   229,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   230,   231,   232,   233,   234,   235,
     236,   237,     0,     0,     0,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,  2514,   105,   106,   107,   108,     0,   109,
     110,   111,   112,   113,     0,   114,   115,   116,     0,     0,
       0,     0,     0,   119,   120,     0,     0,     0,     0,   121,
       0,     0,     0,     0,     0,     0,     0,     0,   122,     0,
     123,     0,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   131,     0,
       0,     0,   133,   134,   135,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   137,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,     0,     0,     0,     0,     0,   158,
       0,     0,   160,     0,     0,     0,     0,   162,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,   189,     0,     0,   190,     0,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
     193,   194,   195,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,   218,     0,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   230,   231,   232,
     233,   234,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,    82,     0,
       0,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,     0,    93,    94,    95,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   104,     0,  2516,   105,   106,   107,
     108,     0,   109,   110,   111,   112,   113,     0,   114,   115,
     116,   117,   118,     0,     0,     0,   119,   120,     0,     0,
       0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,     0,   124,   125,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   127,     0,
     128,   129,     0,     0,     0,     0,     0,     0,     0,     0,
     130,   131,     0,     0,   132,   133,   134,   135,   136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,     0,     0,   138,     0,   139,   140,   141,     0,     0,
     142,   143,     0,     0,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   147,     0,   148,   149,
     150,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,   157,   158,   159,     0,   160,     0,     0,   161,     0,
     162,     0,     0,     0,     0,   163,     0,   164,     0,   165,
       0,   166,     0,   167,     0,     0,     0,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   169,   170,     0,     0,   171,     0,     0,
     172,     0,   173,     0,     0,   174,   175,     0,   176,     0,
       0,     0,     0,     0,     0,   177,   178,     0,   179,     0,
     180,   181,     0,     0,     0,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,   183,     0,     0,   184,   185,
     186,     0,     0,     0,     0,     0,     0,     0,     0,   187,
       0,     0,     0,   188,   189,     0,     0,   190,     0,   191,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   192,   193,   194,   195,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,   203,     0,     0,     0,
       0,   204,   205,     0,   206,   207,     0,     0,   208,     0,
       0,     0,     0,     0,   209,     0,     0,     0,    82,   210,
     211,     0,   212,   213,    86,   214,     0,     0,     0,   215,
      92,     0,    93,     0,    95,     0,     0,   216,     0,     0,
       0,     0,     0,     0,   104,     0,     0,     0,     0,   217,
     218,     0,     0,     0,   219,     0,   220,     0,   221,     0,
     222,   117,   118,   223,     0,     0,   224,     0,   225,     0,
       0,   226,     0,     0,     0,   227,   228,     0,   229,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   126,     0,
     230,   231,   232,   233,   234,   235,   236,   237,   127,     0,
     128,   129,     0,     0,     0,     0,   238,     0,     0,   239,
       0,     0,     0,     0,   989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   138,   240,   139,   140,     0,     0,     0,
     142,   143,     0,     0,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   147,     0,   148,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
       0,     0,     0,     0,     0,   155,     0,     0,     0,     0,
       0,   157,     0,   159,     0,     0,     0,     0,   161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
       0,   166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,     0,     0,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,   203,     0,     0,     0,
       0,   204,     0,     0,   206,     0,     0,     0,   208,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   221,     0,
     222,     0,     0,     0,     0,     0,   224,     0,   225,     0,
       0,   226,     0,     0,     0,   227,   663,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,   664,   102,   103,
     389,   665,     0,   105,   106,   107,   108,   666,   667,   110,
     111,   112,   113,     0,   114,   668,   669,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,   240,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,  2472,   407,   408,   409,     0,     0,     0,     0,
    1272,     0,     0,   410,   411,     0,   412,   131,   413,   414,
     415,   133,  1273,   135,  1274,  1275,     0,   416,   417,     0,
     418,   419,  1276,  1277,   420,  1278,  1279,   422,     0,   423,
     424,   425,   426,  1280,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,  1285,
     442,   443,   444,   445,   446,  1286,  1287,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
    2473,     0,   456,   457,  1288,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,  1289,   468,
     469,  1290,  1291,   470,   471,   472,  1292,     0,   473,     0,
     474,   163,     0,   164,   475,     0,   476,     0,   477,  1293,
       0,   478,     0,   479,   480,   481,   482,   168,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,   169,
     170,     0,   492,   493,   494,  1294,  1295,     0,  1296,     0,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
       0,  1297,   178,   501,   179,     0,   502,   503,   504,  1298,
    1299,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1300,   185,  1301,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,  1302,   526,   527,
     189,   528,  1303,  1304,   529,  1305,   530,   531,     0,     0,
     532,   793,     0,     0,  1306,   534,     0,     0,   192,   193,
     194,  1307,   535,   536,   537,   538,   539,     0,   540,  1308,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,  1309,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,   205,   564,
     565,  1310,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,  1311,   576,   211,   577,   578,   213,
     579,  1312,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,  1313,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,  1314,  1315,     0,     0,   599,
    1316,   600,  1317,  1318,   601,   602,   603,   604,   605,     0,
    1319,   606,   607,   608,   609,  1320,     0,   610,   611,   612,
     613,   614,  1321,   615,   229,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,  1322,  1323,  1324,
    1325,  1326,  1327,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1328,   239,   628,     0,     0,  1329,
    1330,    52,    53,    54,    55,  1331,    56,     0,     0,     0,
       0,  1332,  1333,  2474,     0,     0,     0,     0,     0,     0,
    1335,  2475,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,   110,   111,   112,   113,     0,
     114,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,  1272,     0,     0,   410,
     411,     0,   412,   131,   413,   414,   415,   133,  1273,   135,
    1274,  1275,     0,   416,   417,     0,   418,   419,  1276,  1277,
     420,  1278,  1279,   422,     0,   423,   424,   425,   426,  1280,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,   146,   441,
       0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,   445,
     446,  1286,  1287,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
    1288,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,  1289,   468,   469,  1290,  1291,   470,
     471,   472,  1292,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,  1293,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,  1294,  1295,     0,  1296,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,  1297,   178,   501,
     179,     0,   502,   503,   504,  1298,  1299,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
    1300,   185,  1301,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,  1302,   526,   527,   189,   528,  1303,  1304,
     529,  1305,   530,   531,     0,     0,   532,   793,     0,     0,
    1306,   534,     0,     0,   192,   193,   194,  1307,   535,   536,
     537,   538,   539,     0,   540,  1308,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,  1309,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,  1310,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
    1311,   576,   211,   577,   578,   213,   579,  1312,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,  1313,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,  1314,  1315,     0,     0,   599,  1316,   600,  1317,  1318,
     601,   602,   603,   604,   605,     0,  1319,   606,   607,   608,
     609,  1320,     0,   610,   611,   612,   613,   614,  1321,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,  1322,  1323,  1324,  1325,  1326,  1327,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
    1328,   239,   628,     0,     0,  1329,  1330,    52,    53,    54,
      55,  1331,    56,     0,     0,     0,     0,  1332,  1333,     0,
       0,     0,     0,     0,     0,     0,  1335,  2384,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,  2047,   486,   487,   488,   489,   490,   491,
       0,   169,  2048,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
    2049,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  2050,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,  2051,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,  3722,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1417,
       0,     0,     0, -1417,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,  2394,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
    2395,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,  2396,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,  2397,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,  1334,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,  1410,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,   209,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,  1840,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
    1960,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,  1786,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,  2781,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,  2395,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,  3498,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,  3505,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,     0,  2378,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,     0,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,     0,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,     0,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,     0,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,     0,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,     0,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,     0,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,     0,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,     0,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,     0,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,     0,  2378,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
     134,   135,   136,     0,     0,   416,   417,     0,   418,   419,
       0,  1277,   420,   421,   137,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,  1290,
       0,   470,   471,   472,   162,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
       0,  1304,   529,   191,   530,   531,     0,     0,   532,   793,
       0,   979,   533,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,   209,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,  1316,   600,
    1317,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,  1840,
     228,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,  2249,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
     134,   135,   136,     0,     0,   416,   417,     0,   418,   419,
       0,  1277,   420,   421,   137,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,  1290,
       0,   470,   471,   472,   162,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
       0,  1304,   529,   191,   530,   531,     0,     0,   532,   793,
       0,   979,   533,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,  1316,   600,
    1317,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
     228,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,  2249,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
     134,   135,   136,     0,     0,   416,   417,     0,   418,   419,
       0,  1277,   420,   421,   137,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,  1290,
       0,   470,   471,   472,   162,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
       0,  1304,   529,   191,   530,   531,     0,     0,   532,   793,
       0,     0,   533,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,  1316,   600,
    1317,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
     228,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,  3622,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
     134,   135,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,   177,
     178,   501,   179,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,   793,
       0,     0,   533,   534,     0,     0,   192,   193,   194,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,   213,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,  3672,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,  2763,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440, -1048,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
   -1048,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0, -1048,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495, -1048,   496,   497,   498,   499,   500,     0,   177, -1048,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184, -1048,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563, -1048,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,  1414,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
       0,   239,   628,     0,     0,     0,     0,    52,    53,    54,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2684,  2685,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    55,     0,     0,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
    2685,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,   793,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
    1402,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,   209,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
    1840,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,   628,     0,     0,     0,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   240,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,   209,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,  1840,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,   240,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,  1937,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
    3197,    96,    97,    98,    99,   100,   101,   664,   102,   103,
     389,   665,     0,   105,   106,   107,   108,   666,   667,   110,
     111,   112,   113,     0,   114,   668,   669,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,   670,   407,   408,   409,   671,   672,   673,   674,
     675,   676,   677,   410,   411,   678,   412,   131,   413,   414,
     415,   133,  1601,   135,  1602,  1275,   679,   416,   417,     0,
     418,   419,   680,   681,   420,  1603,  1604,   422,   683,   423,
     424,   425,   426,     0,   684,   685,   427,   428,   429,   430,
     431,   432,   686,   433,   434,   435,   436,   437,   687,   438,
     439,   440,   146,   441,   688,   689,   690,   691,   692,   693,
     442,   443,   444,   445,   446,  1605,  1606,   447,   694,   448,
     695,   449,     0,   450,   451,   452,   696,   453,   454,   455,
     697,   698,   456,   457,  1288,   459,   460,   699,   461,   462,
     463,   700,     0,   464,   701,   465,   466,   467,     0,   468,
     469,     0,   702,   470,   471,   472,  1607,   703,   473,   704,
     474,   163,   705,   164,   475,     0,   476,   706,   477,     0,
     707,   478,   708,   479,   480,   481,   482,   168,   483,   484,
     485,   709,   486,   487,   488,   489,   490,   491,   710,   169,
       0,     0,   492,   493,   494,  1294,  1608,   713,  1609,   714,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
     715,     0,   178,   501,   179,   716,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1610,   185,  1611,   717,   518,   519,
     520,   521,   522,   523,   524,     0,   525,   718,   526,   527,
     189,   528,   719,     0,   529,  1612,   530,   531,   720,   721,
     532,   722,   723,   724,  3089,   534,   725,   726,     0,   193,
     194,     0,   535,   536,   537,   538,   539,     0,   540,     0,
       0,   541,   542,   543,   727,   544,   545,   546,   547,   548,
     549,  1613,   550,   551,   728,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,   729,   562,   563,   205,   564,
     565,     0,   566,   567,   568,   569,   570,   571,   572,     0,
     730,   573,   574,   575,   731,   576,  2050,   577,   578,   213,
     579,  1615,   732,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,     0,   590,   733,   591,   592,   734,   593,
     594,   595,   596,   597,   735,  1616,  1617,     0,   737,   599,
       0,   600,     0,   738,   601,   602,   603,   604,   605,     0,
     740,   606,   607,   608,   609,   741,   742,   610,   611,   612,
     613,     0,  1618,   615,   229,   616,   617,   618,   743,   744,
     619,   620,   621,   622,   623,   624,     0,     0,     0,     0,
       0,     0,     0,     0,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1079,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    55,     0,    56,  1080,  1081,  1082,
       0,  1083,  3090,  1085,  1086,  1087,  1088,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
    1077,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,  1078,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,  1079,   239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1080,  1081,  1082,
       0,  1083,  1084,  1085,  1086,  1087,  1088,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,  1079,   239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1080,  1081,  1082,
       0,  1083,  1084,  1085,  1086,  1087,  1088,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
     110,   111,   112,   113,     0,   114,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   670,   407,   408,   409,   671,   672,   673,
     674,   675,   676,   677,   410,   411,   678,   412,   131,   413,
     414,   415,   133,   134,   135,   136,     0,   679,   416,   417,
       0,   418,   419,   680,   681,   420,   682,   137,   422,   683,
     423,   424,   425,   426,   141,   684,   685,   427,   428,   429,
     430,   431,   432,   686,   433,   434,   435,   436,   437,   687,
     438,   439,   440,   146,   441,   688,   689,   690,   691,   692,
     693,   442,   443,   444,   445,   446,   149,   150,   447,   694,
     448,   695,   449,     0,   450,   451,   452,   696,   453,   454,
     455,   697,   698,   456,   457,   458,   459,   460,   699,   461,
     462,   463,   700,     0,   464,   701,   465,   466,   467,   158,
     468,   469,   160,   702,   470,   471,   472,   162,   703,   473,
     704,   474,   163,   705,   164,   475,     0,   476,   706,   477,
     167,   707,   478,   708,   479,   480,   481,   482,   168,   483,
     484,   485,   709,   486,   487,   488,   489,   490,   491,   710,
     169,   170,   711,   492,   493,   494,   712,   172,   713,   173,
     714,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,   715,   177,   178,   501,   179,   716,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,   185,   186,   717,   518,
     519,   520,   521,   522,   523,   524,   187,   525,   718,   526,
     527,   189,   528,   719,   190,   529,   191,   530,   531,   720,
     721,   532,   722,   723,   724,   533,   534,   725,   726,   192,
     193,   194,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,   727,   544,   545,   546,   547,
     548,   549,   199,   550,   551,   728,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,   729,   562,   563,   205,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,   730,   573,   574,   575,   731,   576,   211,   577,   578,
     213,   579,   214,   732,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,   733,   591,   592,   734,
     593,   594,   595,   596,   597,   735,   217,   218,   736,   737,
     599,   219,   600,   220,   738,   601,   602,   603,   604,   605,
     739,   740,   606,   607,   608,   609,   741,   742,   610,   611,
     612,   613,     0,   228,   615,   229,   616,   617,   618,   743,
     744,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,     0,     0,
     663,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,  1572,    96,    97,    98,    99,   100,
     101,   664,   102,   103,   389,   665,     0,   105,   106,   107,
     108,   666,   667,   110,   111,   112,   113,     0,   114,   668,
     669,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,   131,   413,   414,   415,   133,  1601,   135,  1602,  1275,
       0,   416,   417,     0,   418,   419,     0,     0,   420,  1603,
    1604,   422,     0,   423,   424,   425,   426,     0,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,   146,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,  1605,
    1606,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,  1288,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,     0,   468,   469,     0,     0,   470,   471,   472,
    1607,     0,   473,     0,   474,   163,     0,   164,   475,     0,
     476,     0,   477,     0,     0,   478,     0,   479,   480,   481,
     482,   168,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,   169,     0,     0,   492,   493,   494,  1294,
    1608,     0,  1609,     0,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,     0,     0,   178,   501,   179,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,  1610,   185,
    1611,     0,   518,   519,   520,   521,   522,   523,   524,     0,
     525,     0,   526,   527,   189,   528,     0,     0,   529,  1612,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,     0,   193,   194,     0,   535,   536,   537,   538,
     539,     0,   540,     0,     0,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,  1613,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,   205,   564,   565,     0,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
    1614,   577,   578,   213,   579,  1615,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,     0,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,  1616,
    1617,     0,     0,   599,     0,   600,     0,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,     0,  1618,   615,   229,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
       0,     0,     0,     0,     0,     0,     0,     0,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
       0,     0,     0,     0,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,  2007,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,     0,     0,     0,     0,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
     977,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,  1918,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,  1919,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,  1920,     0,
     532,     0,  1921,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,  1922,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,     0,
       0,     0,  1446,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,  1928,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,  1919,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,  1920,     0,   532,     0,  1921,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,  1922,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
       0,   239,   628,     0,     0,     0,     0,    52,    53,    54,
      55,     0,    56,     0,     0,     0,     0,     0,  1446,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,  1919,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
    1920,     0,   532,     0,  1921,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,  1922,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,     0,   239,   628,     0,
       0,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,     0,     0,     0,  1446,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   884,   401,   402,   403,   404,   405,   406,
     885,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   886,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   887,   162,     0,   473,     0,   888,     0,
     889,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,   890,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   891,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   892,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   893,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   894,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,   628,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
     895,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   884,
     401,   402,   403,   404,   405,   406,   885,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   886,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   887,
     162,     0,   473,     0,   888,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   891,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   892,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   893,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     894,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
     628,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,   895,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
     110,   111,   112,   113,     0,   114,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,   131,   413,
     414,   415,   133,   134,   135,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,   146,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,   163,     0,   164,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,   168,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
     169,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,     0,   177,   178,   501,   179,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,   185,   186,   792,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,   189,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,   793,     0,     0,   533,   534,     0,     0,   192,
     193,   194,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,   205,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
     213,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,   229,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,    49,     0,   239,   628,     0,     0,
    1329,  1330,    52,    53,    54,    55,     0,    56,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,   652,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,  1372,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,  1373,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3472,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,   598,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,  1032,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
      49,     0,   239,   628,     0,     0,     0,     0,    52,    53,
      54,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,  1905,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,     0,   239,
     628,     0,     0,     0,     0,    52,    53,    54,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,    49,     0,   239,   628,     0,     0,
       0,     0,    52,    53,    54,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,   955,  1671,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,   956,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   933,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   957,     0,   958,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   959,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   960,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   961,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   962,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   963,   218,     0,     0,   964,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   937,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   965,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,     0,
      87,    88,    89,    90,    91,     0,     0,     0,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,     0,
       0,     0,   105,   106,   107,   108,     0,   109,   110,   111,
     112,   113, -1531,   114,   115,   116,     0,     0,     0,     0,
       0,   119,   120,     0,     0,     0,     0,   121,     0,     0,
       0,     0,     0,     0,     0,     0,   122,     0,   123,     0,
     124,   125,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
     133,   134,   135,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,     0,     0,     0,     0,
       0,     0,   141,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   156,     0,     0,     0,     0,     0,   158,     0,     0,
     160,     0,     0,     0,     0,   162,     0,     0,     0,     0,
     163,     0,   164,     0,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
     174,   175,     0,   176,     0,     0,     0,     0,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   184,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,     0,   189,
       0,     0,   190,     0,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,   218,     0,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   228,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   230,   231,   232,   233,   234,
     235,   236,   237,     0,     0,     0,     0,     0,     0,     0,
       0,   238,     0,     0,   239,     0,   380,    83,    84,    85,
       0,    87,    88,    89,    90,    91,     0,     0,     0,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,   109,   110,
     111,   112,   113, -1532,   114,   115,   116,     0,     0,     0,
       0,     0,   119,   120,     0,     0,     0,     0,   121,     0,
       0,     0,     0,     0,     0,     0,     0,   122,     0,   123,
       0,   124,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,     0,     0,
       0,   133,   134,   135,   136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   137,     0,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   156,     0,     0,     0,     0,     0,   158,     0,
       0,   160,     0,     0,     0,     0,   162,     0,     0,     0,
       0,   163,     0,   164,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   169,
     170,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,   174,   175,     0,   176,     0,     0,     0,     0,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   187,     0,     0,     0,     0,
     189,     0,     0,   190,     0,   191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   192,   193,
     194,   195,     0,     0,     0,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,   207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,   214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,   218,     0,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   228,     0,   229,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   230,   231,   232,   233,
     234,   235,   236,   237,     0,     0,     0,     0,     0,     0,
       0,     0,   238,     0,     0,   239,     0,  1026,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   670,   407,   408,   409,   671,   672,
     673,   674,   675,   676,   677,   410,   411,   678,   412,   131,
     413,   414,   415,   133,   134,   135,   136,     0,   679,   416,
     417,     0,   418,   419,   680,   681,   420,   682,   137,   422,
     683,   423,   424,   425,   426,   141,   684,   685,   427,   428,
     429,   430,   431,   432,   686,   433,   434,   435,   436,   437,
     687,   438,   439,   440,   146,   441,   688,   689,   690,   691,
     692,   693,   442,   443,   444,   445,   446,   149,   150,   447,
     694,   448,   695,   449,     0,   450,   451,   452,   696,   453,
     454,   455,   697,   698,   456,   457,   458,   459,   460,   699,
     461,   462,   463,   700,     0,   464,   701,   465,   466,   467,
     158,   468,   469,   160,   702,   470,   471,   472,   162,   703,
     473,   704,   474,   163,   705,   164,   475,     0,   476,   706,
     477,   167,   707,   478,   708,   479,   480,   481,   482,   168,
     483,   484,   485,   709,   486,   487,   488,   489,   490,   491,
     710,   169,   170,   711,   492,   493,   494,   712,   172,   713,
     173,   714,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,   715,   177,   178,   501,   179,   716,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,   185,   186,   717,
     518,   519,   520,   521,   522,   523,   524,   187,   525,   718,
     526,   527,   189,   528,   719,   190,   529,   191,   530,   531,
     720,   721,   532,   722,   723,   724,   533,   534,   725,   726,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,   727,   544,   545,   546,
     547,   548,   549,   199,   550,   551,   728,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   729,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,   730,   573,   574,   575,   731,   576,   211,   577,
     578,   213,   579,   214,   732,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,   733,   591,   592,
     734,   593,   594,   595,   596,   597,   735,   217,   218,   736,
     737,   599,   219,   600,   220,   738,   601,   602,   603,   604,
     605,   739,   740,   606,   607,   608,   609,   741,   742,   610,
     611,   612,   613,     0,   228,   615,   229,   616,   617,   618,
     743,   744,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,   134,   135,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,   177,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,   185,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,   189,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,   213,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,   134,   135,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1185,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,   177,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,   185,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,   189,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,   213,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,   134,   135,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1192,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,   177,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,   185,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,   189,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,   213,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,  2047,   486,   487,   488,   489,   490,   491,
       0,   169,  2048,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
    2049,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  2050,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,  2069,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  1614,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,  3023,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  1614,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,  2039,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  2050,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   650,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,   651,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,   652,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  1614,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
    2461,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,  2462,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,  2463,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,   792,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,   793,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,  2464,
     593,  2465,   595,  2466,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  2050,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,   839,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   840,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   841,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,   110,   111,   112,   113,     0,   114,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   131,
     413,   414,   415,   133,  1601,   135,  1602,  1275,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,     0,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,     0,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,   652,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,  1180,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   880,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     922,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   670,   407,   408,   409,   671,   672,   673,
     674,   675,   676,   677,   410,   411,   678,   412,   131,   413,
     414,   415,   133,   134,   135,   136,     0,   679,   416,   417,
       0,   418,   419,   680,   681,   420,     0,   137,   422,   683,
     423,   424,   425,   426,   141,   684,   685,   427,   428,   429,
     430,   431,   432,   686,   433,   434,   435,   436,   437,   687,
     438,   439,   440,   146,   441,   688,   689,   690,   691,   692,
     693,   442,   443,   444,     0,   446,   149,   150,   447,   694,
     448,   695,   449,     0,   450,   451,   452,   696,   453,   454,
     455,   697,   698,   456,   457,   458,   459,   460,   699,   461,
     462,   463,   700,     0,   464,   701,   465,   466,   467,   158,
     468,   469,   160,   702,   470,   471,   472,   162,   703,   473,
     704,   474,   163,   705,   164,   475,     0,   476,   706,   477,
     167,   707,   478,   708,   479,   480,     0,   482,   168,   483,
     484,   485,   709,   486,   487,   488,   489,   490,   491,   710,
     169,   170,     0,   492,   493,   494,     0,   172,   713,   173,
     714,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,   715,   177,   178,   501,   179,   716,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,     0,   512,
     513,     0,   515,   516,   517,   184,   185,   186,   717,   518,
     519,   520,   521,   522,   523,   524,   187,   525,   718,   526,
     527,   189,   528,   719,   190,   529,   191,   530,   531,   720,
     721,   532,   722,   723,   724,   533,   534,   725,   726,   192,
     193,   194,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,   727,   544,   545,   546,   547,
     548,   549,   199,   550,   551,   728,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,   729,   562,   563,   205,
     564,   565,   207,   566,   567,   568,   569,   570,   571,     0,
       0,   730,   573,   574,   575,   731,   576,   211,   577,   578,
     213,   579,   214,   732,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,   733,   591,   592,   734,
     593,   594,   595,   596,   597,   735,   217,   218,     0,   737,
     599,   219,   600,   220,   738,   601,   602,   603,   604,   605,
       0,   740,   606,   607,   608,   609,   741,   742,   610,   611,
     612,   613,     0,   228,   615,   229,   616,   617,   618,   743,
     744,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,     0,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,  2020,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,  2021,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,  2022,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,  2727,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,  2023,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
    2024,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,   905,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,   906,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,   946,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,   907,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,   908,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     905,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,   906,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,   907,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,   908,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,   128,   129,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,   793,     0,   979,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,  1375,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,   792,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,   793,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,  1750,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,  1751,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,  1752,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,   792,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,   793,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,  1753,
     570,   571,   572,     0,     0,  1754,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,  1755,  1756,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,   906,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,   907,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,   908,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,   889,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,   890,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,  2612,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,  2613,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,  2622,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,  2623,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     659,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   790,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,  2763,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,  2776,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,  2810,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,  3118,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    3120,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,  3122,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,  3722,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   845,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   930,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   932,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   933,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,     0,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   934,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   935,   218,     0,     0,   936,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   937,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   968,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     933,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,     0,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   969,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     970,   218,     0,     0,   971,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   937,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
    1190,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,  1194,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1202,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,  1204,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,  1206,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,  1209,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,  1211,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1214,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,  1386,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   933,   137,  1387,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,     0,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   960,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   961,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,  1378,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   963,   218,     0,     0,   964,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   937,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   965,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,  1404,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
       0,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,  1476,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,  1667,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1693,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,  1695,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,  1783,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   933,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
       0,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   960,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   961,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,  1378,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   963,   218,     0,     0,   964,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     937,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   965,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   933,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,     0,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   960,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   961,   565,   207,
     566,   567,   568,  2043,   570,   571,   572,     0,     0,   573,
     574,  1378,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   963,   218,     0,     0,   964,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   937,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   965,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,     0,    87,    88,
      89,    90,    91,     0,     0,     0,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,     0,     0,     0,
     105,   106,   107,   108,     0,   109,   110,   111,   112,   113,
       0,   114,   115,   116,     0,     0,     0,     0,     0,   119,
     120,     0,     0,     0,     0,   121,     0,     0,     0,     0,
       0,     0,     0,     0,   122,     0,   123,     0,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   131,     0,     0,     0,   133,   134,
     135,   136,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   137,     0,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,   150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   156,
       0,     0,     0,     0,     0,   158,     0,     0,   160,     0,
       0,     0,     0,   162,     0,     0,     0,     0,   163,     0,
     164,     0,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   169,   170,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,   174,   175,
       0,   176,     0,     0,     0,     0,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   184,   185,   186,     0,     0,     0,     0,     0,     0,
       0,     0,   187,     0,     0,     0,     0,   189,     0,     0,
     190,     0,   191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   192,   193,   194,   195,     0,
       0,     0,     0,     0,     0,     0,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     0,     0,   207,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,   218,     0,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   230,   231,   232,   233,   234,   235,   236,
     237,     0,     0,     0,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,     0,    87,    88,    89,
      90,    91,     0,     0,     0,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,     0,     0,     0,   105,
     106,   107,   108,     0,   109,   110,   111,   112,   113,     0,
     114,   115,   116,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   131,     0,     0,     0,   133,   134,   135,
     136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   137,     0,     0,     0,     0,     0,     0,   141,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   156,     0,
       0,     0,     0,     0,   158,     0,     0,   160,     0,     0,
       0,     0,   162,     0,     0,     0,     0,   163,     0,   164,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   169,   170,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,   174,   175,     0,
     176,     0,     0,     0,     0,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     184,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,     0,     0,     0,   189,     0,     0,   190,
       0,   191,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   192,   193,   194,   195,     0,     0,
       0,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,   218,     0,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,   223,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   228,     0,
     229,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   230,   231,   232,   233,   234,   235,   236,   237,
       0,     0,     0,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,     0,    87,    88,    89,    90,
      91,     0,     0,     0,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,     0,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   131,     0,     0,     0,   133,   134,   135,   136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   137,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   158,     0,     0,   160,     0,     0,     0,
       0,   162,     0,     0,     0,     0,   163,     0,   164,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   184,
     185,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,     0,     0,   189,     0,     0,   190,     0,
     191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,   193,   194,   195,     0,     0,     0,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,   218,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   228,     0,   229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,   231,   232,   233,   234,   235,   236,   237,     0,
       0,     0,     0,     0,     0,     0,     0,   238,     0,     0,
     239
};

static const short yycheck[] =
{
       2,   240,   115,   115,  1698,  1193,    78,  1713,   148,   145,
    1530,   115,   115,   859,   759,   147,  1000,   863,  1630,   972,
    1109,   221,  1255,    93,    78,   918,   872,  1093,    78,    78,
      78,   774,    81,  1039,  1751,  1723,  1102,   347,   204,  1267,
     964,  1114,  1315,   156,   156,  1895,   347,  1632,    86,  2068,
    1058,  1386,   156,   156,  1682,  2340,   839,    78,   198,  1648,
     130,   203,   225,   130,  1648,   958,  1156,  1786,   210,    78,
     212,   814,    81,  1143,  1164,  1648,  1937,   147,  2260,  1648,
     210,   974,  1076,    78,    86,  1151,    81,  1648,  2544,  2709,
    1648,   203,  1158,  1286,  1287,  1039,  2254,  2255,   210,  1165,
     212,  2980,  2719,  2249,  2751,  1946,   115,   883,   154,  3133,
     223,   223,  1305,     2,  1485,  1229,  1186,   895,   861,   223,
     223,   904,  1975,   144,  1220,  1943,  1021,  2190,  2191,  2192,
    2193,  1278,  1279,  1171,    22,  1073,  1614,    38,   147,    23,
      38,    72,    11,   181,    90,   147,    89,   156,  2685,  2002,
      72,   115,    72,  2006,  1301,  1035,  1036,   115,  1039,  2054,
    2055,   109,  2880,   877,    89,   181,   115,   201,    81,   241,
      84,   201,   761,   956,   201,    95,   117,  1697,    78,   181,
    2199,    81,    81,   157,    94,   117,   109,   241,    81,  3588,
     176,   241,    77,   241,   203,    88,    78,   102,   164,    81,
      72,   210,   109,   212,    81,   109,    72,   201,    75,    30,
     207,    88,   183,   296,   223,   115,   157,    81,   298,   240,
     241,   124,   296,    95,    88,    82,    94,  3428,   100,    95,
     299,   127,   184,   115,   184,    78,   220,  1849,   238,   201,
    2164,   209,    26,  3197,   159,  3199,  3542,  3626,    72,   350,
     332,  2270,  3609,  2272,    91,   238,   156,   398,   240,    72,
      77,   203,   196,   196,   242,   236,   198,   162,   767,   396,
     129,   238,   771,   350,   156,   162,  1229,   238,   161,   238,
      72,   117,    95,   430,   431,    72,  1239,  1240,   124,   174,
    1494,   432,    72,   133,  2678,   131,  3592,  1817,    81,   254,
     312,  1390,   242,   203,    72,   804,  3330,   166,    95,   240,
     210,   157,   212,   302,   156,   385,    72,   184,     0,   301,
     254,   254,  2175,   223,  2708,   337,    78,    72,   165,    81,
    1665,   171,   479,   382,  1538,   306,   413,   232,   347,   466,
      39,   223,    41,   298,  1617,   286,  3703,   238,   220,  1357,
     291,   329,   347,   852,   109,  1201,   239,   174,   151,   858,
     238,   303,   198,   115,   298,   298,   396,  1112,   240,   241,
      26,   286,   303,   382,  3670,   238,   233,    72,   479,   768,
     348,   770,   323,  1389,  1127,   359,   169,   382,  3412,   329,
    3769,   323,   333,  1581,   783,   343,   479,   479,   241,   238,
      95,  1247,  1355,  3604,   156,   479,   486,  1480,    89,   230,
     479,  1257,  1605,  1606,   366,   415,   366,   289,   317,  1612,
     343,   810,  1268,   174,  3448,  1228,   340,   240,   241,  3828,
     223,   303,   415,  1523,   396,   824,   343,   408,   352,   343,
      81,   427,  1395,  1396,   433,   291,   420,   347,   240,   415,
     234,   481,   486,   763,   313,   485,  1603,  1604,   422,   486,
     240,  2155,   763,   479,  1611,   347,   598,  1056,   409,   382,
      81,   223,   240,  2058,   384,   220,   289,   409,   371,   364,
    1569,  1669,   382,   350,   240,   479,   400,   323,   452,   486,
     389,   455,   391,   396,   371,   240,   460,   461,   462,   366,
     382,  2319,   486,   452,  1218,   479,   455,   371,  1598,  1579,
     406,   460,   461,   462,  3468,   479,   384,  3541,   413,   486,
     337,   479,   453,   482,  3242,   486,   413,   415,   598,  1595,
     479,   390,  1335,   479,   477,   303,   467,   468,   486,   470,
     471,   472,   473,   474,   475,   240,   486,   303,  3004,  3005,
     419,   452,   477,   475,   455,   475,   398,   455,   303,   460,
     461,   462,   463,   486,   465,  3102,  3103,  3104,  3105,  3106,
     471,   455,  2050,   409,   479,  1455,  1514,  1458,   234,   486,
     119,   453,   486,    78,   312,   473,    16,   286,   343,   598,
     432,   482,  2410,   386,   387,   347,   598,   238,   470,   471,
     472,   473,   474,   475,   482,  1500,   472,   473,   474,   475,
     773,  1506,   121,   364,  1728,   778,   779,   100,   481,  1118,
    2766,  2249,   785,  1719,  2770,  1124,   157,   238,   278,  1667,
     382,  2481,  2695,  1409,  2487,   301,   203,   769,   770,   159,
     129,  2660,  2661,   482,  2015,   159,   759,   759,   472,   473,
     474,   475,  2493,   192,   405,   759,   759,   470,   471,   472,
     473,   474,   475,   196,  1811,  1812,   157,  2562,   266,  2564,
     389,   269,   391,  1172,   152,   301,   808,   166,   470,   471,
     472,   473,   474,   475,   847,   453,   201,  1582,  1077,  1078,
     470,   471,   472,   473,   474,   475,  3720,   453,   466,   467,
     468,   841,   470,   471,   472,   473,   474,   475,   453,   157,
     201,   152,   480,   227,   470,   471,   472,   473,   474,   475,
     107,   466,   467,   468,   856,   470,   471,   472,   473,   474,
     475,   117,  2656,   216,  2658,  2659,   214,   220,   157,   203,
    1485,   150,   312,    77,  3768,   131,   241,   396,  2672,    83,
     759,    16,   798,   481,   763,   286,   202,   388,   767,   357,
     157,   799,   771,   150,  1837,  1154,  1155,   337,   763,   839,
     253,   291,   286,   214,  1727,   470,   471,   472,   473,   474,
     475,  1170,   828,  2678,   129,   352,  1739,  1530,   266,   415,
     299,   269,  2974,  3413,   444,   804,   477,   799,   479,   480,
     481,  3448,   339,  3420,   162,   486,   339,   156,  1197,  1198,
     880,  1884,   198,  2708,   455,   141,   174,   959,   162,   366,
     962,   166,   463,   354,   313,   266,   430,   162,   269,   959,
     471,  2684,   962,   238,   904,   222,   845,   486,   286,   303,
     174,   482,  2470,   852,   455,  1691,    77,   959,   479,   858,
     962,   266,   463,  3797,  1700,  2750,   265,   131,   267,   759,
     471,  1754,  1755,   763,  1710,   388,   413,   286,   314,   359,
     286,   482,  2484,   311,   223,   877,   202,   759,   265,   357,
     267,   763,   486,   157,   922,   368,   956,   957,   232,   161,
     957,   278,  3836,   430,  3773,  3774,  1674,   232,  1643,   205,
     387,   390,   228,   162,  1750,   396,  1752,  1753,   431,   479,
    1756,   949,   328,   398,   453,   379,   357,   243,  3862,   109,
     922,  2441,   960,   961,   311,   251,  3382,   466,   467,   468,
     420,   470,   471,   472,   473,   474,   475,   323,  3001,   157,
     129,   137,   357,   174,  3823,   954,   396,   949,   274,   486,
     959,   257,   215,   962,  1697,   342,   479,   376,   960,   961,
     379,   452,   320,   341,   455,   443,   975,   239,   313,   460,
     461,   462,   202,   232,  2559,   301,   985,   166,   312,  1932,
     975,  2566,  1785,  1786,   322,   479,   364,   374,   877,   479,
     481,   152,  2185,  1796,   485,  2001,  1799,  1035,  1036,  1112,
    1112,   479,   443,   337,  1807,  1808,   329,   759,  1112,  1112,
     206,   763,   286,   166,   482,   359,   160,  1820,  1821,  1797,
    1798,   347,   337,   409,   359,    26,  3184,  1805,  1831,   288,
     423,  1809,  1810,  1035,  1036,    36,   486,  1039,   479,  2105,
    2106,  2131,  3188,   366,   337,   390,  1824,  3193,  1826,   364,
    3196,   204,   430,   214,   152,   452,    72,  2001,   455,   959,
     398,   137,   962,   460,   461,   462,   463,   430,  1846,   413,
    1848,   364,  2066,   217,  1817,   975,   420,  2265,   413,   214,
     156,   312,  1885,   389,   486,   391,   162,    72,   278,   415,
     413,   130,  2809,   975,   432,   483,  1335,  2791,  1993,   430,
     359,  1947,  1111,  1112,  1142,   266,   337,  1852,   269,  1118,
     186,  2972,   169,   114,   171,  1124,   214,  2836,  3738,  3575,
     169,  2710,   171,   486,   313,   352,  2710,  2217,  2218,  2219,
    2220,   266,  1021,   419,   185,   479,  1145,  2710,  2766,   178,
    1142,  2710,  2770,  3067,  3068,  3069,  3070,  3071,  3072,  2710,
    1039,  3170,  2710,   343,   413,   486,   232,   102,  1230,   354,
    3726,   420,  1472,  1172,  1553,  1554,  1555,  1556,   266,   455,
     221,  1472,   482,   400,   364,  1213,  1230,  1249,   102,   472,
    1230,   160,  1230,  1682,  1254,  1684,  3205,   141,  3207,   452,
    1689,  2261,   455,   388,  1583,  1584,   357,   460,   461,   462,
    1589,   390,  3487,  2098,   149,    42,  2101,  2102,  2857,  1230,
     415,  1213,  1112,   352,  2060,  1217,  1218,  2000,  1220,  1228,
     479,   260,   357,   975,   240,   149,   360,  2073,  1249,   286,
    1112,   202,  2881,   234,   452,  3801,   431,   455,   217,   296,
     322,  2087,   460,   461,   462,  2091,  1255,   296,   202,  2257,
       5,  1272,  1751,   387,  3107,   240,  3822,   228,   160,   357,
     108,   400,  1651,  1652,  1653,  1654,   201,  1276,  1289,   312,
    2015,    26,   243,   312,   228,   132,  1561,   352,   291,   312,
     251,    36,   443,   359,   479,   220,   231,   303,   136,   243,
      52,   425,    96,  1302,   337,  3724,  3725,   251,  1319,  1337,
     312,   158,  1372,  1373,   337,  1372,  1373,   231,    70,  1347,
     132,  2089,   116,   360,  1335,   217,   398,   312,   303,  3465,
     274,   364,  1435,  1332,  1333,   400,  1335,  1716,  1217,  1218,
     108,  1220,  1435,   278,   896,  1337,   158,   413,   312,   312,
     387,   189,   337,  1352,   420,  1347,   341,  1489,  1386,   388,
     432,   390,   364,   329,   278,  1640,  1358,   919,   136,   114,
    1112,  1646,   338,   337,   337,   312,  1508,   224,   312,   364,
     218,  3800,  1485,  1485,  2567,  1660,   347,  1489,   425,  3711,
    1389,  1485,  1485,  1453,  1386,   361,  1453,  1389,    79,   196,
     337,  1393,  1394,   347,  1557,   234,  1508,   341,  1419,  1420,
    2178,  1422,   224,   479,   350,  2183,    18,    98,   215,   337,
     355,   189,  1421,   341,  2749,  1424,  1425,  1455,   173,   480,
     364,  2494,   430,   431,   455,   486,  1435,  1436,  1437,   375,
     140,   355,   463,  3765,   203,   430,   364,   453,  3770,   452,
     218,  1436,  1437,   212,  3368,  3369,  3370,   460,   461,   462,
     466,   467,   468,  1455,   470,   471,   472,   473,   474,   475,
     389,   478,   391,  1472,   480,  3315,   205,  3799,   453,   486,
    1479,   479,  1481,   484,   477,   486,  1485,  1472,   481,   234,
    1489,   466,   467,   468,  1479,   470,   471,   472,   473,   474,
     475,  1419,  1420,   341,  1422,   343,  3108,   345,    72,  1508,
    1389,   478,   430,   351,  1393,  1394,  1515,   356,  1539,   486,
     358,  1542,   246,    87,  2297,  1546,   364,   312,   257,  1069,
    1529,    95,   474,  1762,   372,   455,   100,   479,   162,   481,
    1643,  1643,   380,   463,   312,  1435,  1436,  1437,    35,  1643,
    1643,   471,   337,  1093,   124,  2348,   341,  2394,   479,  2396,
    2397,   131,  1102,  1435,  1436,  1437,  1688,  1446,  2482,   337,
    3188,   326,   297,   341,   480,  3193,   301,   345,  3196,   364,
     486,  1580,  1472,   351,   169,   480,   171,  3596,   426,  1479,
     358,   486,  3167,   291,   400,  1485,   364,   482,  1597,  1489,
    1472,   486,  2395,  1729,   372,   396,   191,  1479,   232,   474,
     356,  2829,   380,  1485,   479,  1614,   481,   477,  1508,   479,
     452,  1500,  2885,  2886,  1780,   126,   339,  1506,   460,   461,
     462,  2424,  3079,  3080,  1934,   480,  3083,  1665,  3085,   134,
    1639,   486,   143,  1934,  1643,   477,  3324,   479,   451,   481,
     223,   454,   216,  3567,   155,   480,   220,  2737,   426,   480,
     389,   486,   391,   287,   288,   486,  2459,  2402,   487,  2505,
     477,  1682,  2407,  1665,   481,   453,   240,   241,   480,  2472,
    2473,  3283,  2678,  1682,   486,  1684,   455,   482,  1687,   253,
    1689,   486,   131,  1435,  1436,  1437,   425,  2920,   480,  1698,
     479,   286,   481,  1582,   486,   206,   291,   463,  2441,   465,
    1772,   296,  2708,  2598,   106,  2483,  2779,   480,   119,   215,
    2605,  2606,   286,   486,   484,   289,   486,  1719,  1772,   356,
    1472,  1723,  1772,   246,  1772,   359,   452,  1479,   477,   303,
     479,   305,   481,  1485,   460,   461,   462,  2583,  2584,  1852,
    1852,  1762,  1751,  1643,   452,  2818,   483,   455,  1852,  1852,
    2249,  1772,   460,   461,   462,   452,   205,   479,   455,  2502,
     479,  1643,   481,   460,   461,   462,  1804,   238,  2157,  2158,
    2159,  2160,  2161,  2162,   223,   455,  1785,  1786,   389,   413,
     391,   192,   479,   463,  1793,   465,   420,  1796,    85,    86,
    1799,   471,   454,   455,   368,  1804,   114,   115,  1807,  1808,
       7,  3321,  1804,    10,   215,   325,  1815,   402,   257,  1818,
    1819,  1820,  1821,    20,    21,   410,   301,  3010,  3446,  1828,
    1829,   884,  1831,   886,  1833,   888,   480,  1836,   106,  2902,
    1719,   894,   486,    40,  1723,  1856,    43,  3465,   480,   430,
     431,  1850,  1851,  1852,   486,   479,  1855,   480,   304,   480,
    1859,  1259,  1260,   486,  1863,   486,   305,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,  2819,  1876,  3585,   448,
     449,   450,  1881,  1911,    96,   157,  1885,  2966,   445,   453,
    2269,   480,  2271,   480,   102,  2017,   169,   486,   171,   486,
     242,  1643,   466,   467,   468,   481,   470,   471,   472,   473,
     474,   475,  2015,  2015,   478,  2683,   301,  2685,   191,  1911,
     396,  2015,  2015,   487,   470,   471,   472,   473,   474,   389,
     183,   391,   478,  3535,   142,  1934,   480,  1976,   480,  1978,
    2000,   301,   486,   196,   486,  2678,   480,  1946,   482,  1934,
     389,   445,   391,   480,   117,   163,    96,   377,   378,   486,
     480,   400,  1852,   430,   431,   237,   486,    72,   131,  1997,
     409,   304,  2707,   170,   182,  2708,   480,  1976,   482,  1978,
    1852,  2470,    87,   236,  3680,   257,  3682,  2780,    90,   197,
      95,  1976,   480,  1978,   157,   100,   159,  2771,   486,  2773,
     445,   254,   480,  3621,   212,  1997,   108,   242,   486,  2001,
     364,  2003,   995,  2005,   997,   480,  2015,   472,   291,  3075,
    2249,   486,   480,   296,   446,   447,   470,   471,   472,   473,
     474,  2030,   452,   480,   136,   455,   480,  3547,   200,   486,
     460,   461,   462,   480,  1934,   298,  2506,  2507,   480,   486,
     480,  2050,   453,   306,   486,  2054,  2055,   480,   482,  3743,
     430,   431,  1934,   486,   227,   466,   467,   468,  3291,   470,
     471,   472,   473,   474,   475,   480,   480,    81,   778,   106,
    2206,   486,   486,   291,    72,   472,  1976,   189,  1978,   480,
     480,   299,   480,   234,  2086,   486,   486,  3177,   486,  2892,
     430,   431,   802,  3721,  1976,   483,  1978,    95,  2508,  2509,
    1852,   216,   100,   480,  1993,   220,   218,   483,   396,   486,
     328,   480,  2001,   286,  2003,  2015,  2005,   486,   291,   402,
    1037,  1038,   480,   480,   396,   240,   241,   410,   486,   486,
    2168,   480,   452,  2015,   246,   455,   396,   486,   253,  2148,
     460,   461,   462,   480,   396,   408,  2155,   480,   452,   486,
     323,  2896,   396,   486,  2156,   480,   460,   461,   462,   479,
     333,   486,  2164,   180,    90,  2174,  2168,  2176,   415,   451,
     452,   286,   454,   455,   289,   479,  2178,   106,   460,   461,
     462,   463,  1934,   465,   452,  2424,   234,   455,   303,   471,
     305,   480,   460,   461,   462,   480,   452,   486,   240,  2237,
     396,   486,   479,   913,   460,   461,   462,   481,   918,  2098,
     480,   479,  2101,  2102,  2216,  2604,   486,   480,   216,   929,
     312,   479,   220,   479,  1976,   480,  1978,  2297,  2249,   341,
     152,   486,   480,   345,   301,  2237,   409,   479,   486,   351,
    2249,   480,   240,   241,   481,  2283,   358,   486,   958,   452,
    2259,   337,   364,   368,   482,   253,   480,   460,   461,   462,
     372,   252,   486,  2015,   974,  2465,  2466,  2766,   380,   979,
     452,  2770,   295,   455,  1419,  1420,   479,  1422,   460,   461,
     462,  2283,  2291,   993,   472,   473,   474,   480,   479,  2402,
    2402,   289,   214,   486,  2407,  2407,   480,   479,  2402,  2402,
     480,   480,   486,  2407,  2407,   303,   486,   486,   430,   480,
    2809,  2320,   356,   246,   426,   486,   117,   480,   430,  3097,
     479,   452,  2331,   486,  3102,  3103,  3104,  3105,  3106,   460,
     461,   462,  3110,   430,  3318,   480,   183,   480,   453,  2348,
    2349,   486,    90,   486,   266,   430,   479,   269,   479,   196,
      96,   466,   467,   468,    96,   470,   471,   472,   473,   474,
     475,   312,   246,   487,   772,   415,   187,   486,   776,  2378,
     368,   486,   187,  2382,   452,     8,   784,   455,   187,    12,
      13,    14,   460,   461,   462,  2394,  2395,  2396,  2397,   236,
      23,    24,    25,  2402,    27,    28,   479,  2406,  2407,    32,
      33,    34,  2411,  2424,   812,  1115,   187,   254,   816,   187,
     187,   452,  2421,  2422,   455,  2424,   479,  2438,   826,   460,
     461,   462,   187,   452,   187,   301,   455,   183,  2437,   187,
    2439,   460,   461,   462,  2443,   357,  2457,   187,   479,  3672,
     196,   301,   187,  3676,  3677,    90,   187,   252,   422,  2470,
    2459,   298,   479,   197,   479,   453,  1166,  1167,  1168,   306,
     196,  2470,   119,  2472,  2473,   319,   479,   479,  3271,   467,
     468,   479,   470,   471,   472,   473,   474,   475,   452,   479,
     236,   455,   479,  2485,  2493,  3673,   460,   461,   462,   479,
    2499,   479,   430,   431,   479,   479,   479,   479,   254,  2508,
    2509,  2510,  2402,   479,   479,   479,   479,  2407,   479,  3355,
    3356,   479,  3358,   479,   452,   479,   479,   455,   452,   479,
    2402,   443,   460,   461,   462,  2407,   460,   461,   462,   451,
     452,  2540,   454,   455,    72,   192,  1246,  1400,   460,   461,
     462,   479,   298,   479,   479,   479,   486,   479,  3326,    87,
     306,    90,  2561,  2562,   309,  2564,   143,  1267,  3336,  3337,
     252,   408,   240,  3341,  3342,   479,   196,   196,  2577,   472,
    2579,   234,   357,  3351,   269,    72,   486,   156,  3321,    38,
    2582,   414,    16,   452,  2724,   486,   455,  2589,   479,  2591,
      87,   460,   461,   462,  2707,  2707,  2485,   479,   479,  2608,
     396,   396,   481,  2707,  2707,   396,    72,   396,   301,   396,
     430,   431,  3458,   396,   396,   358,   291,   452,  3806,  2759,
     396,    87,  3468,   396,  2756,   460,   461,   462,   414,    95,
     396,   486,   452,   354,   100,   455,   415,   396,   271,   396,
     460,   461,   462,   415,   479,   396,   124,   301,  2657,   225,
    2402,   354,   408,  2725,  2656,  2407,  2658,  2659,   486,   479,
    2698,   396,   396,   396,   452,   479,   396,   455,  2677,  2678,
    2672,  2743,   460,   461,   462,   301,  2678,   396,   240,   299,
     479,   479,  2720,  2685,   422,   479,   319,  2759,    90,  3188,
      79,  2930,  1402,   157,  3193,  2697,  2698,  3196,  2707,  2708,
     415,   425,   240,   260,  2725,    90,  2708,   196,   479,  2598,
    2748,  2749,   301,    90,  2723,  3608,  2605,  2606,  2720,   481,
     355,   452,  2743,  3526,   455,   187,   428,  2736,   415,   460,
     461,   462,  2932,  2933,  2934,  2935,   187,   187,  2759,   415,
      16,  2750,   344,   240,  2816,  2766,  2748,  2749,   466,  2770,
     216,    72,   396,   420,   220,   290,   201,  2766,   486,   486,
     394,  2770,   479,   427,   271,   303,    87,   394,   271,    72,
     486,  2780,   405,   364,   240,   241,  2785,   394,   479,   479,
     396,   201,  2791,  2896,  2896,   466,   398,   253,  3634,  2678,
     486,   296,  2896,  2896,   480,  2816,   453,   486,   466,   236,
    2809,   486,   302,   477,  3547,   254,   303,  2707,   480,   466,
     467,   468,    35,   470,   471,   472,   473,   474,   475,  2708,
     286,   480,  1685,   289,   396,  2707,   396,  1690,   354,   130,
    2839,   479,   244,  2842,  1544,   244,  1699,   303,  3684,  2848,
     479,   301,   307,   291,   291,  2854,   486,  2856,   291,  1712,
    3653,  2860,  2861,   254,   486,  2864,  2865,  2866,  2867,  2868,
    2869,  2870,  2871,  2872,  2873,   480,   412,   106,  2906,  2878,
    2879,   452,   106,   315,   455,   315,   337,   396,  2887,   460,
     461,   462,   463,  2892,   465,   337,   396,  2896,   329,  2898,
     471,   337,   240,    90,    77,   240,   240,   415,  2907,   415,
      83,  2910,   368,  2912,  2906,    72,   240,   466,   477,  2930,
     396,  2920,  2921,  2922,  2923,   453,   396,   254,  2927,   240,
      87,  2930,   466,   196,   466,   301,   305,   479,   466,   467,
     468,  2940,   470,   471,   472,   473,   474,   475,   121,   186,
      90,   452,   210,  2945,   455,   301,   473,  3446,   213,   460,
     461,   462,   463,   213,   465,  2707,   453,   486,   196,   479,
     471,    90,   479,   301,   387,   480,  3465,    11,  3357,   466,
     467,   468,   301,   470,   471,   472,   473,   474,   475,    78,
     486,   207,   303,   268,   167,   301,   106,   453,   486,   480,
     480,   174,  1702,   480,   177,   201,  2896,   480,   480,  1709,
     466,   467,   468,   480,   470,   471,   472,   473,   474,   475,
     480,   480,   480,   486,  2896,    77,   445,   480,   445,    86,
     445,    83,   480,   480,   480,   480,    93,   480,    95,  3038,
      72,   201,   396,    16,  3837,   479,   428,   104,    31,   254,
     479,   230,   225,   291,  1754,  1755,   482,  3546,   480,   487,
     480,   486,   480,    95,   312,   479,  1766,   396,   100,   121,
     482,   479,   263,   130,   263,  3067,  3068,  3069,  3070,  3071,
    3072,   263,   139,   240,   396,   480,   396,   396,   396,   396,
     147,   148,   396,   396,   151,   240,  3585,   240,   240,   240,
     157,   240,   240,   477,   161,   278,   269,   480,   480,   166,
    3102,  3103,  3104,  3105,  3106,   167,   301,   405,   339,   479,
     301,   480,   174,   180,   486,   177,   183,  3126,   299,   396,
     415,   188,  3621,   301,   243,   480,   479,   243,  3137,   312,
    3168,   198,   453,   308,   296,   202,   303,   204,   479,   486,
     182,   208,  1145,   415,  2896,   466,   467,   468,   415,   470,
     471,   472,   473,   474,   475,   466,   184,   224,   341,   304,
     184,   180,   477,   225,   201,    72,  3168,  3188,   480,   196,
    1880,   480,  3193,   480,   216,  3196,   115,   479,   220,  3188,
     424,   364,   486,   201,  3193,   303,   480,  3196,   209,   480,
      72,   466,   466,   479,   463,   466,   230,   405,   240,   241,
     396,  3090,   396,   396,   196,    87,   396,   240,   396,   240,
     480,   253,   164,    95,   240,   478,   278,   479,   100,   244,
     430,    90,  3721,   196,   305,   226,  3235,   126,   388,   479,
     486,  3620,   418,   453,  1944,   243,  3625,  3626,   479,  1647,
     480,    90,   479,   206,   480,   201,   479,   289,   480,   479,
     312,   201,  1255,   480,   106,   429,   480,   429,   486,   405,
     211,   303,  3271,   187,   486,   486,   240,   159,   291,  3278,
    3279,   291,   415,   227,   291,   337,  3285,  3286,  3316,   341,
     478,  3290,  3291,  3782,   203,   203,   453,  3296,  3297,   201,
     415,  3300,  3681,   415,  3683,   175,   186,   479,  3797,   466,
     467,   468,   364,   470,   471,   472,   473,   474,   475,   480,
     117,   117,   245,  3315,  3316,   304,   201,   396,   385,   196,
     479,   479,  3324,   304,   419,   201,   368,   373,   333,  3338,
     430,   196,   479,  3722,   216,   453,   480,  3836,   220,   479,
    3378,  3379,   480,   479,  3416,  3383,   479,   486,   466,   467,
     468,  3850,   470,   471,   472,   473,   474,   475,   240,   241,
      90,   291,   264,  3862,   223,   327,  3368,  3369,  3370,   351,
     304,   253,   351,  3762,    93,   304,  3378,  3379,  3380,   196,
    3769,  3383,  3384,   192,  3422,   301,  1389,   419,   388,   486,
     430,   175,   301,   301,    90,  3416,  3405,  3786,   170,   479,
     413,   350,   480,   162,   286,   332,   186,   289,    76,  3447,
     327,   453,  2122,   479,   241,  2278,  1394,  2485,  2281,  2205,
    3422,   303,  2285,   305,  2127,  1819,  3315,  2609,   470,   471,
     472,   473,   474,   475,  3152,  3324,  2168,  3446,  3377,  3155,
    2110,  3035,  2541,  3406,  3465,  3447,  3781,  3164,  3805,  3760,
    3759,  3789,  3461,  2800,  3157,  1661,  3465,  2187,  3862,  3440,
    3836,  3470,  2707,  3390,  2708,  3389,  2677,  3796,  3549,   183,
    3807,  1641,  3222,  3552,  1248,  2315,  3169,  3621,  1481,  2342,
      72,  3721,  2561,  3492,  1878,  2055,   368,  3496,  2054,  3175,
    3687,  3827,  3861,  2203,   973,  3597,  2194,   159,  1944,  3150,
    2817,  1230,  2491,    95,  1230,  2295,  3515,  3516,   100,  3216,
    3519,  2499,  1515,  2510,  1427,  1426,  1428,  3526,  3527,  1938,
    1959,  2231,  2470,  2772,  2249,  2492,  1529,  3148,  3466,  2239,
    2905,   598,  3651,  2898,  1834,  2438,  2502,  3546,  2436,   847,
    2350,  2581,  1881,  2320,   598,  1997,  2756,  2242,  1676,  1177,
    1437,  3560,  1145,   348,   879,  1057,  1431,  1974,  2001,  2303,
    1254,  2480,  1038,  2304,  3217,  3567,  3314,  1370,  1435,  2970,
    3218,   453,  3644,   381,  2005,  1217,  3585,  1580,  2298,  1745,
    3618,   648,   649,     2,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,  1597,    -1,    -1,    -1,   480,    -1,
      -1,    -1,  3841,    -1,  2012,    -1,    -1,    -1,  2016,    -1,
      -1,  1614,  3621,  3622,    -1,    -1,  3618,    -1,    -1,    -1,
      -1,    -1,    -1,  3644,   216,  2033,    -1,    -1,   220,  2037,
      -1,    -1,    -1,    -1,    -1,    -1,  1639,    -1,    -1,  3648,
    3649,  3530,  3651,    -1,  3653,    -1,    -1,    -1,   240,   241,
      -1,  2059,    -1,  2061,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   253,  1255,  3672,    -1,    -1,    -1,  3676,  3677,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2545,    -1,  1687,    -1,  2094,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   286,  1698,    -1,   289,    -1,    -1,
      -1,   768,   769,   770,    -1,   772,    -1,   774,    -1,   776,
     777,   303,  3721,   780,    -1,   782,   783,   784,  1819,    -1,
    2128,    -1,    -1,    -1,    -1,    -1,    -1,  2135,    -1,  2137,
      -1,    -1,    -1,    -1,  3743,    -1,    -1,    -1,   805,    -1,
      -1,   808,    -1,   810,    -1,   812,    -1,    -1,    -1,   816,
     817,   818,  2615,  2616,  2464,   822,    -1,   824,    -1,   826,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   839,  3782,   841,    -1,   368,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,   853,    -1,  3797,   856,
     100,    -1,   859,    -1,    -1,    -1,   863,   864,    -1,    -1,
      -1,   868,    -1,   870,    -1,   872,  3827,    -1,   875,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3819,    -1,    -1,
    3841,    -1,    -1,    -1,    -1,    -1,    -1,  3836,  3837,   896,
      -1,   898,    -1,    -1,    -1,    -1,    -1,   904,    -1,    -1,
    3861,  3850,    -1,    -1,    -1,    -1,    -1,  1850,    -1,    -1,
      -1,    -1,    -1,  3862,    -1,    -1,    -1,  3859,   925,    -1,
     927,   453,    -1,   930,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,    -1,    -1,    -1,    -1,  1481,   956,
     957,    -1,    -1,    -1,   961,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2313,   216,    -1,    -1,    -1,
     220,    -1,    -1,   980,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2784,    -1,  2786,    -1,  2788,    -1,  2790,    -1,  2792,
     240,   241,  2340,    -1,  2797,    -1,  1529,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2830,  1035,  1036,
      -1,    -1,    -1,    -1,   108,    -1,   286,    -1,    -1,   289,
    1047,    -1,    -1,  1050,  2378,    -1,  1053,  1580,  2382,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,   136,    -1,  1597,    -1,    -1,    -1,  2718,    -1,
    1077,  1078,    -1,    -1,    -1,    -1,    -1,  2727,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2421,  2422,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2746,  1104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1639,  2050,    -1,  1116,
      -1,  2054,  2055,    -1,    -1,   189,    -1,    -1,   368,    -1,
      -1,    -1,  1129,    -1,    -1,    -1,    -1,    -1,  1135,    -1,
      -1,    -1,  1139,  1145,    -1,    -1,    -1,    -1,    -1,  1146,
      -1,    -1,    -1,  2793,   218,  2795,    -1,  1154,  1155,    -1,
    2800,    -1,    -1,    -1,  1687,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,  1170,  1171,  1698,  1173,  1174,    -1,    -1,
      -1,    -1,   246,    -1,    -1,    -1,    87,    -1,    -1,  2829,
      -1,    80,  2530,    -1,    95,    -1,    -1,    -1,    -1,   100,
    1197,  1198,    -1,    92,  1201,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2155,   112,    78,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,  1238,    -1,  2176,    -1,   134,   486,    -1,    -1,    -1,
    1247,  1248,    -1,  1255,    -1,  1252,    -1,    -1,    -1,    -1,
    1257,    -1,   151,    -1,    -1,    -1,    -1,    -1,  1265,    -1,
      -1,  1268,    -1,  1270,    -1,    -1,   130,   341,    -1,    -1,
      -1,   345,    -1,   172,   138,   139,    -1,   351,    -1,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,  2937,  2938,    -1,
     364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,    -1,
      -1,    -1,  2650,    -1,   203,   216,   380,    -1,    -1,   220,
     209,    -1,    -1,    -1,    -1,   179,    -1,  1850,    -1,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,    72,    -1,   240,
     241,    -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,    -1,
      -1,  2382,   253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,   426,    -1,    -1,   100,   220,    -1,    -1,    -1,
      -1,   225,    -1,  2378,    -1,  1372,  1373,  2382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,   289,  1386,
    2421,  2422,    -1,    -1,    -1,    -1,  1393,  1394,  2331,    -1,
      -1,    -1,   303,    -1,   305,    -1,    -1,  1404,   262,  1406,
      -1,    -1,    -1,    -1,   303,    -1,  2421,  2422,  3211,  3212,
      -1,    -1,   311,    -1,    -1,   279,   280,    -1,   282,   283,
      -1,   285,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1453,    -1,  1455,   348,
      -1,   315,    -1,   352,    -1,   354,    -1,   368,    -1,  3109,
      -1,   360,  2810,    -1,    -1,    -1,    -1,  1474,    -1,  1481,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,
      -1,    -1,  3132,  2831,   348,    -1,    -1,    -1,   387,   388,
      -1,    -1,  3142,   392,    -1,   240,   241,    -1,    -1,    -1,
      -1,   400,    -1,  1515,    -1,    -1,   405,    -1,   253,    -1,
      -1,    -1,    -1,    -1,    -1,   414,    -1,  1529,    -1,   383,
      -1,   385,    -1,  1530,    -1,    -1,   425,  2861,    -1,    -1,
    2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,
      -1,    -1,   453,   407,   289,    -1,  1553,  1554,  1555,  1556,
     414,    -1,    -1,   417,    -1,   466,   467,   468,   303,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,  1580,   480,
      -1,    -1,    72,    -1,    -1,    -1,  1583,  1584,    -1,    -1,
      -1,    -1,  1589,    -1,    -1,  1597,    -1,    87,  2922,  2923,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,  1614,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,  2562,
      -1,  2564,  2155,   368,    -1,    -1,    -1,  1639,    -1,    -1,
      -1,    -1,    -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,
    1647,    -1,  1649,  2176,  1651,  1652,  1653,  1654,    -1,    -1,
      -1,    -1,  3302,  3303,  3304,  3305,    -1,    -1,  1665,    90,
    1667,    -1,    -1,    -1,    -1,  2608,    -1,    -1,    -1,    -1,
      -1,  3474,  3475,  3476,  3477,  1687,    -1,   108,    -1,    -1,
      -1,  1688,    -1,    -1,  1691,  1692,  1698,    -1,    -1,    -1,
    1697,    -1,    -1,  1700,  1701,    -1,  1703,    -1,    -1,    -1,
      -1,  1708,  3050,  1710,  3052,   136,  1713,    -1,   453,  1716,
      -1,    -1,    -1,    -1,  2657,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,  1730,  1731,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,
     240,   241,    -1,  1750,    -1,  1752,  1753,    -1,    -1,  1756,
      -1,    -1,    -1,   253,    -1,  1762,    -1,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,  2708,    -1,    72,    -1,    -1,
      -1,    -1,    -1,  1780,    -1,    -1,  1783,    -1,    -1,    -1,
    2723,    -1,    -1,    -1,    -1,    -1,   286,   218,    -1,   289,
      95,    -1,  3126,  2736,    -1,   100,    -1,    -1,  2331,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,  2750,    -1,    -1,
    1817,    -1,    -1,    -1,    -1,   246,    -1,    -1,    -1,    -1,
    2861,    -1,    -1,  2864,  2865,  2866,  2867,  2868,  2869,  2870,
    2871,  2872,  2873,    -1,    -1,    -1,    -1,    -1,  1850,    -1,
      -1,    -1,  2785,  3646,    -1,    -1,  2861,    -1,  2791,  2864,
    2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,  3222,    -1,    -1,   182,    -1,    -1,
    1887,  2922,  2923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2842,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,  2923,    -1,
     341,   216,    -1,    -1,   345,   220,    -1,  2860,    -1,    -1,
     351,    -1,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,
    1937,    -1,    -1,   364,    -1,   240,   241,  3587,    -1,    -1,
    1947,   372,    -1,    -1,  2887,    -1,    -1,    -1,   253,   380,
      -1,  3285,  3286,   453,    -1,    -1,    -1,    -1,  3608,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,  2920,    -1,  3629,
     480,    -1,    -1,    -1,   289,    -1,  3334,    -1,    -1,    -1,
    1997,    -1,    -1,  2000,    -1,   426,    -1,  3345,   303,  3347,
      -1,    -1,    -1,    -1,    -1,  2012,  2013,    -1,    -1,  2016,
    2017,    -1,    -1,    -1,  2021,    -1,    -1,    -1,    -1,  3669,
    2027,    -1,    -1,    -1,    -1,  2032,  2033,    -1,    -1,    -1,
    2037,  2038,    -1,    -1,    -1,    -1,  2043,    -1,  2050,    -1,
      -1,    -1,  2054,  2055,  2577,    -1,  2579,    -1,    -1,    -1,
      -1,    -1,  2059,  2060,  2061,  2062,    -1,  2064,    -1,    -1,
    2067,  2068,    -1,   368,    -1,    -1,  2073,    -1,    -1,    72,
      -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,    -1,    -1,
    2087,    -1,    -1,    -1,  2091,  3126,    -1,  2094,  2095,  2096,
    2097,    -1,    95,    -1,    -1,  3038,    -1,   100,    -1,    -1,
      -1,    -1,    -1,  2110,  2111,  2112,  2113,  2114,  2115,  2116,
      -1,  3126,  2119,  2120,    -1,    -1,  2123,  2124,  2125,    -1,
      -1,  2128,  2129,    -1,  2657,    -1,    -1,    -1,  2135,  2136,
    2137,    -1,  2139,    -1,    -1,    -1,    -1,    -1,    -1,  3487,
      -1,    -1,    -1,  2155,    -1,    -1,    -1,    -1,   453,    -1,
    2157,  2158,  2159,  2160,  2161,  2162,    -1,    -1,  3492,    -1,
      -1,    -1,  3496,    -1,  2176,   470,   471,   472,   473,   474,
     475,  2178,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3515,  3516,    -1,    -1,    -1,    -1,    72,    -1,    -1,
    2723,    -1,  2199,    -1,  3137,    -1,    -1,    -1,    -1,    -1,
    2207,    -1,    87,  2736,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,   216,    -1,   100,    86,   220,    -1,    -1,
    2227,    -1,    -1,    93,    -1,  2232,    -1,  2234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2242,    -1,   240,   241,    -1,
      -1,    -1,    -1,  2250,  3285,  3286,    -1,  2254,  2255,    -1,
     253,    -1,  2785,    -1,    -1,    -1,    -1,    -1,  2791,    -1,
     130,    -1,  2269,  2270,  2271,  2272,    -1,    -1,    -1,    -1,
    3285,  3286,    -1,    -1,    -1,    -1,    -1,   147,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   289,   157,    -1,    -1,
    2297,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,    -1,    -1,  2313,    -1,    -1,  2842,
      -1,   181,    -1,   183,  3648,  3649,    -1,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,  1145,    -1,  2860,   198,    -1,
    2337,   216,    -1,  2340,    -1,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3291,    -1,
      -1,    -1,    -1,    -1,  2887,   240,   241,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,   253,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3338,    -1,    -1,    -1,    -1,
      -1,   286,    -1,    -1,   289,  2412,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2441,  1255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     453,  3492,    -1,    -1,    -1,  3496,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,   472,
     473,   474,   475,    -1,  3515,  3516,    -1,  3492,  2485,    -1,
      -1,  3496,    -1,   368,  2491,    -1,    -1,    -1,    72,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2505,    -1,
    3515,  3516,    -1,    87,    -1,  3038,    -1,    -1,    80,    -1,
      -1,    95,    -1,    -1,    -1,   385,   100,    -1,    -1,    -1,
      -1,    -1,    -1,  2530,  2531,  2532,    -1,  3470,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2544,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,
    2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,    -1,  2577,    -1,  2579,   453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2583,  2584,    72,   151,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    87,    -1,   480,  2608,  2604,    -1,    -1,
     172,    95,    -1,    -1,  3137,    -1,   100,  3648,  3649,    -1,
    2617,  2618,  2619,  2620,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   203,   216,  3648,  3649,    -1,   220,   209,    -1,    -1,
      -1,    -1,    -1,  2650,  2651,  2657,    -1,    -1,    -1,    -1,
      -1,   223,    -1,  2660,  2661,    -1,   240,   241,    -1,    -1,
      -1,  1481,    -1,    -1,    -1,    -1,  2678,    -1,    -1,   253,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2685,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2699,  2700,  2701,  1515,  2708,    -1,    -1,    -1,
      -1,    -1,   286,    -1,    -1,   289,    -1,    -1,    -1,  1529,
      -1,  2723,    -1,    -1,    -1,    -1,    -1,  2724,    -1,   303,
      -1,   305,   216,    -1,  2736,    -1,   220,    -1,   598,  3672,
      -1,   303,    -1,  3676,  3677,    -1,    -1,  2744,  2750,    -1,
      -1,    -1,  2749,    -1,    -1,    -1,   240,   241,    -1,  2756,
      -1,    -1,  2759,  2760,   326,    -1,  2763,    -1,  3291,   253,
    1580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2776,
      -1,    -1,    -1,  2785,    -1,    -1,   348,  1597,    -1,  2791,
      -1,    -1,   354,    -1,   368,    -1,    -1,    -1,   360,    -1,
      -1,    -1,   286,    -1,  1614,   289,    -1,    -1,    -1,    -1,
    3743,    -1,    -1,  2810,    -1,  3338,    -1,    -1,    -1,   303,
    2817,   305,    -1,    -1,    -1,   387,   388,    -1,    -1,  1639,
     392,    -1,    -1,    -1,  2831,    -1,    -1,    -1,   400,    -1,
    2842,    -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,   414,    -1,    -1,    -1,    -1,    -1,  2860,    -1,
      -1,    -1,    -1,   425,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,  1687,   100,   453,
      -1,    -1,    -1,    -1,   368,  2887,    -1,    -1,  1698,    -1,
      -1,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    72,    -1,    -1,    -1,   480,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,  2920,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,   799,
      95,    -1,    -1,    -1,    -1,   100,    -1,  3470,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   453,
      -1,    -1,    -1,    -1,    -1,  2972,    -1,    -1,   838,   839,
      -1,   841,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,   216,    -1,   480,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3004,  3005,    -1,
      -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,   240,   241,
     880,    -1,    -1,    -1,   884,    -1,   886,    -1,   888,    -1,
      -1,   253,    -1,    -1,   894,   895,  3038,    -1,    -1,    -1,
    1850,    -1,    -1,    -1,   904,    -1,   216,    -1,    -1,  3046,
     220,    -1,    -1,  3050,  3051,  3052,  3053,  3054,  3055,  3056,
      -1,   216,   922,    -1,    -1,   220,    -1,   289,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   303,    -1,   253,    -1,   240,   241,    -1,    -1,   949,
      -1,    -1,    -1,    -1,    -1,    -1,   956,   957,   253,    -1,
     960,   961,    -1,    -1,    -1,  3102,  3103,  3104,  3105,  3106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   289,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3125,    -1,
      -1,   286,    -1,   303,   289,  3137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   368,    80,   303,  3672,
     305,  3148,    -1,  3676,  3677,  3152,    -1,    -1,  3155,    -1,
    3157,  1021,    -1,    -1,    -1,    -1,    -1,  3164,    -1,    -1,
      -1,    -1,    -1,  3170,    -1,  1035,  1036,    -1,    -1,   112,
      -1,    -1,    -1,    72,    -1,    -1,    -1,  3184,    -1,  3186,
      -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
    3197,   134,  3199,    -1,  3201,    -1,    95,    -1,  3205,    -1,
    3207,   100,    -1,   368,    -1,    -1,    -1,    -1,   151,    -1,
    3743,    -1,    -1,    -1,    -1,  3222,    -1,    -1,    -1,    -1,
      -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   172,
    2050,    -1,    -1,    -1,  2054,  2055,    -1,    -1,   470,   471,
     472,   473,   474,   475,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1145,    -1,    -1,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1142,   453,    -1,    -1,    -1,    -1,    -1,  3291,
     223,    -1,    -1,   182,    -1,    -1,    -1,    -1,   453,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,   466,   467,   468,   247,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,  3321,   480,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    -1,  3338,  3334,  3335,    -1,
      -1,    -1,    -1,    -1,    -1,  2155,    -1,    -1,  3345,  3346,
    3347,   240,   241,  1213,    -1,  3352,    -1,    -1,  3355,  3356,
    3357,  3358,    -1,    -1,   253,    -1,  2176,    -1,    -1,    -1,
     303,    -1,    -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,
      -1,  1241,    -1,    -1,  1244,  3382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   326,  1254,    -1,    -1,    -1,    -1,    -1,
     289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   303,   348,    -1,    -1,    -1,   352,
      -1,   354,    -1,    -1,    -1,    -1,    -1,   360,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3433,    -1,    -1,    -1,
      -1,    -1,    -1,  3440,    -1,    -1,    -1,    -1,    -1,  3446,
      -1,    -1,    -1,    -1,   387,   388,    -1,    -1,  3455,   392,
      -1,  3458,    -1,    -1,    -1,    -1,    -1,   400,  3470,    -1,
      -1,  3468,   405,    -1,    -1,    -1,    -1,  1337,    -1,   368,
      -1,    -1,    -1,    -1,  3481,    -1,    -1,  1347,    -1,    -1,
    3487,    -1,   425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1368,    -1,
      -1,    -1,  1372,  1373,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2331,    -1,    -1,    -1,    -1,  1386,    -1,    -1,  1389,
      -1,    -1,    -1,  1393,  1394,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
    3547,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,  3575,    -1,
      -1,   470,   471,   472,   473,   474,   475,    -1,    -1,   156,
      -1,    -1,    -1,  1453,    -1,  1455,    -1,    -1,    -1,  3596,
    1481,  3598,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3620,  3621,    -1,    -1,    -1,  3625,  3626,
      -1,    -1,    -1,    -1,  1515,    -1,   203,  3634,    -1,    -1,
    1500,    -1,    -1,   210,    -1,   212,  1506,    -1,  1529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   223,   225,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3672,    -1,    -1,    -1,  3676,  3677,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3680,  3681,  3682,  3683,  3684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1580,
      -1,    -1,    -1,    -1,    -1,  3702,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1597,    -1,    -1,    -1,
      -1,    -1,  1582,    -1,  3721,  3722,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1614,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3743,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2561,  2562,    -1,  2564,    -1,    -1,    -1,  1639,    -1,
      72,    -1,    -1,    -1,  3761,  3762,    -1,  2577,    -1,  2579,
      -1,    -1,  3769,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,  3786,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,
    3797,    -1,    -1,    -1,    -1,  1665,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1674,    -1,    -1,  1698,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3836,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3862,    -1,    -1,  2678,    -1,
      -1,  1731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1745,  1746,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2708,   183,
      -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   196,  2723,    -1,    -1,    -1,   201,    -1,    -1,
      -1,    -1,   206,    -1,    -1,   209,  2736,   211,   240,   241,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1797,  1798,    -1,
    2750,   253,    -1,    -1,  1804,  1805,    -1,    -1,    -1,  1809,
    1810,    -1,   236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1824,    -1,  1826,    -1,    -1,  1850,
     254,    -1,    -1,    -1,   286,  2785,    -1,   289,    -1,    -1,
      -1,  2791,    -1,    -1,    -1,    -1,  1846,    -1,  1848,    -1,
      -1,   303,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   298,    -1,    -1,    87,    -1,    -1,
    1880,    -1,   306,    -1,    -1,    95,    -1,  1887,    -1,    -1,
     100,    -1,  2842,    -1,    -1,  1895,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2860,  1911,    -1,    -1,    -1,    -1,   368,    26,    -1,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    36,    37,    -1,
      -1,    -1,    -1,    42,    -1,    44,    45,  2887,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,   387,    -1,    -1,    -1,    -1,    -1,    -1,
    2920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1993,    -1,    -1,    -1,  1997,    -1,    -1,
    2000,   453,    -1,    -1,   428,   114,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,   448,   449,   450,    -1,   480,  2050,
     240,   241,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   759,   477,    -1,    -1,   480,   481,   482,   767,
     767,    -1,    -1,   771,   771,   773,    -1,    -1,    -1,    -1,
     778,   779,   181,    -1,    -1,    -1,   286,   785,    -1,   289,
      -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,  3038,  2089,
      -1,    -1,    -1,   303,   802,   305,   804,   804,  2098,    -1,
      -1,  2101,  2102,    -1,    -1,   214,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2155,    -1,    -1,    -1,    -1,   847,
      -1,    -1,    -1,    -1,   852,   852,    -1,    -1,    -1,    -1,
     858,   858,    -1,    -1,    -1,  2176,  2156,   266,   368,    -1,
     269,    -1,    -1,    -1,  2164,    -1,    -1,    -1,  2168,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2178,    -1,
      -1,    -1,   291,  2183,    -1,    -1,    -1,  3137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
     918,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2237,    -1,    -1,
      -1,    -1,    -1,   453,    -1,    -1,    -1,   954,   357,    -1,
     958,    -1,   959,    -1,    -1,   962,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,   974,    -1,    -1,    -1,
     480,   979,    -1,    -1,    -1,    -1,    -1,    -1,   985,    -1,
      -1,    -1,    -1,  2283,    -1,   993,    -1,   396,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,  2298,   408,
      -1,  2301,    -1,  2303,    -1,    -1,    -1,    -1,    -1,    -1,
    2331,    -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,
      -1,  3291,   451,   452,    -1,   454,    -1,   456,    -1,    -1,
      -1,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,   474,    -1,    -1,   477,   478,
     479,   480,    -1,   482,   483,   484,    -1,   486,   487,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,  3338,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    -1,    -1,    -1,  1111,  1112,    -1,  1115,    95,    -1,
    1118,  1118,    -1,   100,    -1,    -1,  1124,  1124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1145,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1166,  1167,
    1168,    -1,    -1,    -1,  1172,  1172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2481,    -1,  2483,    -1,  2485,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3470,  1228,    72,    -1,    -1,    -1,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,    87,  1246,    -1,
    2561,  2562,    -1,  2564,    -1,    95,    -1,    -1,  1255,    -1,
     100,    -1,    -1,   240,   241,    -1,  2577,    -1,  2579,  1267,
      -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,    -1,  1276,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2581,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1302,    -1,    -1,  2598,   286,
      -1,    -1,   289,    -1,    -1,  2605,  2606,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,   305,    -1,
      -1,    -1,    -1,    -1,    -1,  1332,  1333,    -1,  1335,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1352,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,    -1,  2656,  2678,  2658,  2659,
      -1,    72,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,  2672,    -1,    -1,    -1,    87,    -1,  2678,    -1,
      91,   368,    -1,  2683,    95,  2685,    -1,  2708,    -1,   100,
     240,   241,    -1,    -1,  1402,    -1,    -1,  2697,  2698,    -1,
      -1,    -1,  2723,   253,    -1,    -1,    -1,    -1,  2708,    -1,
      -1,    -1,    -1,    -1,  1421,  2736,    -1,  1424,  1425,    -1,
    2720,    -1,  3672,    -1,  2724,    -1,  3676,  3677,    -1,  2750,
      -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,   289,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2748,  2749,
      -1,    -1,    -1,   303,   165,   305,    -1,    -1,    -1,  2759,
      -1,    -1,    -1,    -1,  2785,    -1,   453,    -1,    -1,    -1,
    2791,    -1,    -1,    -1,  1481,    -1,    -1,    -1,  1485,   466,
     467,   468,  1489,   470,   471,   472,   473,   474,   475,    -1,
      -1,   478,    -1,  3743,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1508,    -1,    -1,    -1,   216,    -1,    -1,  1515,   220,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,  2842,  1529,    -1,    -1,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,    -1,    -1,  1544,    -1,    -1,  2860,
      -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,  1557,
    1145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2887,    -1,    -1,    -1,
      -1,    -1,    -1,  1580,    -1,   286,    -1,    -1,   289,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1597,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,  2920,
      -1,    -1,    -1,   453,    -1,    -1,  2906,  1614,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,    -1,  1639,    -1,    -1,    -1,  1643,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
    1255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1682,  1682,  1684,  1684,    -1,    -1,
    1687,  1689,  1689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1698,    -1,    -1,  1702,    -1,    -1,    -1,    -1,    -1,
      -1,  1709,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,  1751,  1751,    -1,  1754,  1755,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,   468,  1766,   470,
     471,   472,   473,   474,   475,    -1,    -1,  3067,  3068,  3069,
    3070,  3071,  3072,    -1,    -1,    -1,    -1,    -1,  1785,  1786,
      -1,    -1,    -1,    -1,    -1,    -1,  1793,    -1,    -1,  1796,
      -1,    -1,  1799,    -1,    -1,    -1,    -1,  3097,    -1,    -1,
    1807,  1808,  3102,  3103,  3104,  3105,  3106,    -1,  1815,    -1,
    3110,  1818,  1819,  1820,  1821,    -1,  3137,    -1,    -1,    -1,
      -1,  1828,  1829,    -1,  1831,    -1,  1833,    -1,    -1,  1836,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1850,  1851,  1852,    -1,    -1,  1855,    -1,
      -1,    -1,  1859,    -1,    -1,    -1,  1863,    -1,    -1,  1866,
    1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  3168,  1876,
      -1,    -1,  1880,    -1,  1881,    -1,    -1,    -1,  1885,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1481,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3217,    -1,    -1,
    1515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1529,    -1,  1944,    -1,    -1,  1946,
      -1,   183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,    72,   206,    -1,    -1,   209,    -1,   211,
    3291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,  1580,    95,    -1,    -1,    -1,
      -1,   100,    -1,    -1,   236,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,    -1,    -1,    -1,  2015,    -1,
      -1,    -1,   254,    -1,    -1,  3315,  3316,  3338,    -1,  1614,
      -1,    -1,    -1,  2030,    -1,    -1,  3326,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3336,  3337,    -1,    -1,
      -1,  3341,  3342,  2050,  1639,    -1,    -1,  2054,  2055,    -1,
      -1,  3351,    -1,    -1,    -1,    -1,   298,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   306,    -1,    -1,    -1,  3368,  3369,
    3370,    -1,    -1,    -1,    -1,    -1,    72,    -1,  3378,  3379,
      -1,    -1,    -1,  3383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    87,  1687,    -1,    90,    -1,    -1,    -1,    -1,    95,
      -1,    -1,   344,  1698,   100,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,  2122,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3422,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2148,    -1,    -1,   253,   387,    -1,  3447,  2155,  3470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,  2174,    -1,  2176,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,
     289,    -1,    -1,    -1,    -1,    -1,   428,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   303,  2203,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   448,   449,   450,    -1,
      -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,    -1,    -1,  2231,   220,    -1,    -1,    -1,    -1,    -1,
      -1,  2239,    -1,    -1,    -1,   477,    -1,    -1,   480,   481,
     482,  2249,  2249,    -1,   240,   241,    -1,    -1,    -1,    -1,
      -1,    -1,  2259,    -1,    -1,  1850,    -1,   253,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    95,  3567,    -1,    -1,
      -1,    -1,   381,    -1,    -1,   104,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2291,    -1,    -1,    -1,    -1,    -1,
     286,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,   305,
     139,    -1,    -1,  2320,    -1,    -1,    -1,    -1,  3618,   148,
      -1,    -1,   151,    -1,  2331,    -1,    -1,    -1,   157,    -1,
      -1,    -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2348,  2349,    -1,   453,    -1,    -1,    -1,  1145,    -1,
      -1,  3672,    -1,    -1,   183,  3676,  3677,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,    -1,    -1,   198,
      -1,  2378,   368,    -1,    -1,  2382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,  2395,  2396,
    2397,    -1,    -1,    -1,    -1,  2402,    -1,    -1,    -1,  2406,
    2407,    -1,    -1,    -1,  2411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2421,  2422,    -1,  2424,    -1,    -1,
      -1,    -1,  3743,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2437,    -1,  2439,    -1,    -1,    -1,  2443,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2459,    -1,    -1,  2050,  2464,   453,  1255,  2054,
    2055,    -1,  2470,  2470,    -1,  2472,  2473,    -1,    -1,    -1,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,    -1,    -1,    -1,    -1,  2493,    -1,    -1,    -1,
      -1,    -1,  2499,    -1,    -1,    -1,    -1,  3797,    -1,    -1,
      -1,  2508,  2509,  2510,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2540,    -1,    -1,  3836,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2561,  2562,   385,  2564,    87,    -1,
    2155,    90,  3862,    -1,    -1,    -1,    95,    -1,    -1,    -1,
    2577,   100,  2579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,
      -1,  2608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1481,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2707,  2708,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2718,   240,   241,    -1,    -1,    -1,  2723,    -1,  1515,  2727,
      -1,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,  2736,
      -1,    -1,  1529,    -1,    -1,    -1,  2331,    -1,  2746,    -1,
     216,   203,    -1,  2750,   220,    -1,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,    -1,    -1,    -1,   286,  2766,  2766,
     289,    -1,  2770,  2770,   240,   241,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2780,   303,    -1,   305,   253,  2785,    -1,
      -1,    -1,    -1,  1580,  2791,  2793,    -1,  2795,    -1,    -1,
      -1,    -1,  2800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1597,  2809,  2809,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     286,    -1,    -1,   289,    -1,    -1,    -1,  1614,    -1,   648,
     649,  2829,    -1,    -1,    -1,    -1,    -1,   303,    -1,   305,
      -1,    -1,  2839,    -1,    -1,  2842,    -1,    -1,    -1,   368,
     316,  2848,  1639,    -1,    -1,    -1,    -1,  2854,    -1,  2856,
      -1,    -1,    -1,  2860,  2861,    -1,    -1,  2864,  2865,  2866,
    2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,    -1,    -1,
      -1,  2878,  2879,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2887,    -1,    -1,    -1,    -1,  2892,    -1,    -1,    -1,  2896,
    1687,  2898,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2907,  1698,    -1,  2910,    -1,  2912,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2920,  2921,  2922,  2923,    -1,    -1,    -1,
    2927,    -1,    -1,  2930,   453,    -1,    -1,    -1,    -1,  2937,
    2938,    -1,    -1,  2940,    72,    -1,    -1,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,    -1,   777,    87,
      -1,   780,    90,   782,    -1,    -1,    -1,    95,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,  2561,  2562,    -1,  2564,
      -1,    -1,    -1,    -1,    -1,    -1,   805,   453,    -1,    -1,
      -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,    -1,   818,
     466,   467,   468,   822,   470,   471,   472,   473,   474,   475,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     839,    -1,   841,  2608,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,
      -1,  3038,    -1,    -1,    -1,   864,    -1,    -1,    -1,   868,
      -1,   870,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1850,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2657,    -1,  1145,    -1,    -1,   896,    -1,   898,
      -1,    72,    -1,    -1,    -1,   904,    -1,    -1,   216,    -1,
      -1,    -1,   220,  2678,    -1,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,   925,    -1,   927,   100,
      -1,  3109,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2708,    -1,   253,    -1,    -1,    -1,  3126,
      -1,    -1,    -1,    -1,  3132,    -1,    -1,   956,  2723,    -1,
    3137,    -1,    -1,    -1,  3142,    -1,    -1,    -1,    -1,    -1,
      -1,  2736,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,   289,    -1,    -1,    -1,  2750,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   303,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,
    3188,  3188,    -1,    -1,    -1,  3193,  3193,    -1,  3196,  3196,
    2785,    -1,    -1,    -1,    -1,    -1,  2791,    -1,    -1,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,  1047,   220,
      -1,  1050,    -1,    -1,  1053,    -1,    -1,    -1,  3235,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,    -1,    -1,    -1,  2842,    -1,    -1,
      -1,    -1,   253,  2050,    -1,    -1,    -1,  2054,  2055,    -1,
      -1,    -1,    -1,    -1,  3271,  2860,    -1,    -1,    -1,    -1,
      -1,  3278,  3279,    -1,    -1,  1104,    -1,    -1,  3285,  3286,
      -1,    -1,    -1,  3290,  3291,   286,    -1,    -1,   289,  3296,
    3297,    -1,  2887,  3300,  3302,  3303,  3304,  3305,    -1,    -1,
    1129,    -1,   303,    -1,   305,   767,  1135,    -1,    -1,   771,
    1139,    -1,    -1,    -1,    -1,   453,    -1,  1146,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2920,    -1,    -1,   466,   467,
     468,  3338,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,   804,    -1,  1173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2155,    72,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    87,    -1,    -1,    90,    -1,  2176,
      -1,    -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,
     852,    -1,    -1,    -1,    -1,    -1,   858,    -1,  3405,    -1,
    1481,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,  1238,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,  1252,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,  1515,    -1,    -1,    -1,  3446,  3446,
      -1,    -1,    -1,  3038,    -1,    -1,    -1,    -1,  1529,    -1,
      -1,    -1,   453,    -1,  3461,    -1,    -1,  3465,  3465,    -1,
      -1,    -1,    -1,  3470,    -1,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3492,    -1,    -1,    -1,  3496,
      -1,    -1,   954,    -1,    -1,    -1,    -1,   959,    -1,  1580,
     962,    -1,    -1,   216,    -1,    -1,    -1,   220,  3515,  3516,
      -1,    -1,  3519,    -1,    -1,    -1,  1597,    -1,    -1,  3526,
    3527,    -1,    -1,   985,    -1,    -1,    -1,   240,   241,    -1,
      -1,    -1,    -1,  1614,  2331,    -1,    -1,    -1,  3546,  3546,
     253,    -1,  3137,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,  3560,    -1,    -1,    -1,    -1,  1639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     240,   241,    -1,   286,    -1,    -1,   289,  3585,  3585,  3587,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
     303,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3608,    -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,  3621,  3621,  3622,   286,  1698,    -1,   289,
      -1,  3629,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,
      -1,  3648,  3649,    -1,  3651,  1474,  3653,    -1,    -1,  1111,
      -1,    -1,    -1,    -1,    -1,   368,  1118,    -1,    -1,    -1,
      -1,  3669,  1124,    -1,    -1,  3672,    -1,    -1,    -1,  3676,
    3677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1145,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3291,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1172,    -1,    -1,  3721,  3721,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3743,    -1,    -1,    -1,
     453,    -1,    -1,  3338,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,   472,
     473,   474,   475,    -1,  2561,  2562,  1228,  2564,    -1,  1850,
      -1,    -1,    86,    -1,  3782,  3782,    -1,    -1,    -1,    -1,
    2577,    -1,  2579,   453,    -1,    -1,    -1,    -1,    -1,  3797,
    3797,    -1,    -1,  1255,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,  2608,    -1,    -1,  1276,    -1,    -1,    -1,    -1,    -1,
    1649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3836,  3836,
    3837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1302,    -1,  3850,  3850,    -1,    -1,    -1,   161,     2,    -1,
      -1,    -1,    -1,    -1,  3862,  3862,    -1,    -1,    -1,    -1,
    2657,    -1,    -1,  1692,    -1,    -1,    -1,   181,    -1,   183,
    1332,  1333,  1701,  1335,  1703,  3470,    -1,    -1,    -1,  1708,
      -1,  2678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1730,  1731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2708,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2723,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2736,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2750,    -1,    -1,    -1,    -1,    -1,  1421,
      -1,    -1,  1424,  1425,    -1,    -1,    -1,    -1,    -1,  2050,
      -1,    -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,  2785,    -1,
      -1,    -1,    -1,    -1,  2791,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,   161,    -1,    -1,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1481,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1489,    -1,   183,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2842,  1508,    -1,    -1,    -1,
      -1,    -1,    -1,  1515,    -1,    -1,    -1,    -1,  1887,    -1,
      -1,    -1,    -1,  2860,    -1,    -1,    -1,  1529,    -1,    -1,
      -1,    -1,    -1,    -1,  2155,    -1,    -1,  3672,    -1,    -1,
      -1,  3676,  3677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2887,    -1,    -1,    -1,    -1,  2176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1580,    -1,
      -1,    -1,    -1,  2920,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,    -1,  1597,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3743,    -1,
     240,   241,  1614,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2000,    -1,    -1,    -1,    -1,    -1,  1639,    -1,    -1,
      -1,    -1,    -1,    -1,  2013,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2021,    -1,    -1,    -1,   286,    -1,  2027,   289,
      -1,    -1,    -1,  2032,    -1,    -1,    -1,    -1,    -1,  2038,
      -1,    -1,    -1,   303,  2043,   305,    -1,    -1,    -1,    -1,
    1682,    -1,  1684,    -1,    -1,  1687,    -1,  1689,    -1,    -1,
      -1,    -1,    -1,  2062,    -1,  2064,  1698,    -1,    -1,    -1,
      -1,  3038,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2095,  2096,  2097,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,  2112,  2113,  2114,  2115,    -1,    -1,  1751,
    2119,  2120,    -1,    -1,  2123,  2124,  2125,    -1,    -1,    -1,
    2129,    -1,    -1,    -1,    -1,    -1,    -1,  2136,    -1,    -1,
    2139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1785,  1786,    -1,    -1,    -1,    -1,    -1,
      -1,  1793,    -1,    -1,  1796,    -1,    -1,  1799,    -1,    -1,
    3137,    -1,    -1,    -1,    -1,  1807,  1808,    -1,    -1,    -1,
      -1,    -1,    -1,  1815,    -1,    -1,  1818,  1819,  1820,  1821,
      -1,    -1,    -1,   453,    -1,    -1,  1828,  1829,    -1,  1831,
      -1,  1833,    -1,    -1,  1836,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,  1850,  1851,
      -1,    -1,    -1,  1855,    -1,    -1,    -1,  1859,    -1,    -1,
      -1,  1863,    -1,    -1,  1866,  1867,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,    -1,  1876,    -1,    -1,    -1,    -1,  1881,
      -1,    -1,    -1,  1885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,  2564,  1946,   799,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3291,    -1,  2577,    -1,  2579,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2337,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2030,    -1,
     884,    -1,   886,    -1,   888,    -1,  2657,    -1,    -1,    -1,
     894,   895,    -1,    -1,    -1,    -1,    -1,    -1,  2050,    -1,
      -1,    -1,  2054,  2055,    -1,    -1,    -1,  2678,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   922,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2708,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,
      -1,    -1,  2723,    -1,    -1,    -1,   960,   961,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2750,
      -1,    -1,    -1,  3470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2148,    -1,    -1,    -1,
      -1,    -1,    -1,  2155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2531,  2532,  2785,    -1,    -1,  1021,    -1,    -1,
    2791,    -1,  2174,    -1,  2176,    -1,    -1,    -1,    -1,    -1,
      -1,  1035,  1036,   877,    -1,  1039,    -1,    -1,    -1,    -1,
     884,    -1,   886,    -1,   888,    -1,    -1,    -1,    -1,    -1,
     894,   895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2249,  2617,  2618,
    2619,  2620,    -1,    -1,    -1,    -1,    -1,  2259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2887,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2651,    -1,    -1,    -1,    -1,    -1,  1142,  2291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    -1,    -1,    -1,  2320,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    -1,  1021,    -1,  2331,
    2699,  2700,  2701,    -1,    -1,  3672,    -1,    -1,    -1,  3676,
    3677,    -1,    -1,   112,    -1,  1039,  2348,  2349,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2724,    -1,    -1,    -1,  1213,
      -1,    -1,   131,    -1,    -1,   134,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2744,  2378,    -1,    -1,    -1,
    2382,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,    -1,
    2759,    -1,  2394,  2395,  2396,  2397,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   172,  2406,    -1,  3743,    -1,    -1,  2411,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,  2421,
    2422,    -1,  2424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   203,  2437,   205,  2439,    -1,    -1,
     209,  2443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,  2459,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2470,    -1,
    2472,  2473,    -1,    -1,    -1,    -1,    -1,   246,    -1,    -1,
      -1,    -1,    -1,  1337,    -1,    -1,    -1,    -1,   257,    -1,
      -1,  2493,    -1,  1347,    -1,    -1,    -1,  2499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2508,  2509,  2510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3137,    -1,    -1,    -1,
      -1,    -1,    -1,  1217,  1218,    -1,  1220,    -1,    -1,    -1,
      -1,    -1,  1386,    -1,   303,  1389,   305,    -1,  2540,  1393,
    1394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,  2561,
    2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2577,    -1,  2579,    -1,   348,
      -1,    -1,    -1,   352,    -1,   354,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1455,    -1,    -1,    -1,    -1,  2608,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   388,
     389,    -1,   391,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   400,    -1,    -1,    -1,   404,   405,    -1,    -1,    -1,
     409,    -1,    -1,    -1,    -1,   414,  1500,    -1,    -1,    -1,
      -1,    -1,  1506,    -1,    -1,  2657,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3291,    -1,    -1,    -1,    -1,    -1,  2678,  3046,    -1,    -1,
      -1,    -1,  3051,    -1,  3053,  3054,  3055,  3056,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1389,    -1,    -1,    -1,  1393,
    1394,    -1,    -1,    -1,    -1,    -1,  2708,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3338,    -1,    -1,
      -1,  2723,    -1,    -1,    -1,    -1,    -1,    -1,  1582,    -1,
      -1,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2750,    -1,
      -1,    -1,  1446,    -1,    -1,    -1,  3125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2766,    -1,    -1,    -1,  2770,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2780,    -1,
      -1,    -1,    -1,  2785,    -1,    -1,    -1,    -1,    -1,  2791,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1500,  2809,    -1,    -1,
      -1,  1665,  1506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1674,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3201,    -1,    -1,    -1,    -1,  2839,    -1,    -1,
    2842,    -1,    -1,    -1,    -1,    -1,  2848,    -1,    -1,  3470,
      -1,    -1,  2854,    -1,  2856,    -1,    -1,    -1,  2860,  2861,
      -1,    -1,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    2872,  2873,    -1,    -1,    -1,    -1,  2878,  2879,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2887,    -1,    -1,  1582,    -1,
    2892,    -1,    -1,    -1,    -1,    -1,  2898,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2907,    -1,    -1,  2910,    -1,
    2912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,  2921,
    2922,  2923,    -1,    -1,    -1,  2927,    -1,    -1,  2930,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2940,    -1,
      -1,    -1,    -1,  1797,  1798,    -1,    -1,    -1,    -1,    -1,
    1804,  1805,    -1,    -1,    -1,  1809,  1810,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3335,    -1,    -1,    -1,
    1824,    -1,  1826,    -1,    -1,    -1,    -1,  3346,    -1,    -1,
    1674,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1846,    -1,  1848,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1719,    -1,    -1,    -1,  1723,
      -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3672,  1746,    -1,    -1,  3676,  3677,  1911,    -1,    -1,
      -1,    -1,    -1,    -1,  3433,    -1,    -1,    -1,    -1,    -1,
      -1,  3440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1797,  1798,    -1,    -1,    -1,    -1,    -1,
      -1,  1805,    -1,    -1,    -1,  1809,  1810,    -1,    -1,    -1,
      -1,    -1,  3743,    -1,  3126,    -1,    -1,    -1,    -1,    -1,
    1824,    -1,  1826,    -1,    -1,  3137,    -1,    -1,    -1,  1993,
      -1,    -1,    -1,  1997,    -1,    -1,    -1,  2001,    -1,    -1,
      -1,    -1,  1846,    -1,  1848,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3188,    -1,    -1,    -1,
      -1,  3193,    -1,    -1,  3196,    -1,    -1,    -1,    -1,    -1,
      -1,  1895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3235,    -1,  2089,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2098,    -1,    -1,  2101,  2102,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3271,
      -1,    -1,    -1,    -1,    -1,    -1,  3278,  3279,    -1,    -1,
      -1,    -1,    -1,  3285,  3286,    -1,    -1,    -1,  3290,  3291,
      -1,    -1,    -1,    -1,  3296,  3297,    -1,    -1,  3300,  1993,
      -1,    -1,  2156,    -1,    -1,    -1,    -1,  2001,    -1,  2003,
    2164,  2005,    -1,    -1,  2168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2178,    -1,    -1,    -1,    -1,  2183,
      -1,    -1,    -1,  3702,    -1,    -1,  3338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2237,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3761,    -1,    -1,  2089,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3405,  2098,    -1,    -1,  2101,  2102,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3446,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3461,
      -1,    -1,    -1,  3465,    -1,    -1,    -1,    -1,  3470,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2178,    -1,    -1,    -1,    -1,  2183,
    3492,    -1,    -1,    -1,  3496,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3515,  3516,    -1,    -1,  3519,    -1,    -1,
      -1,    -1,    -1,    -1,  3526,  3527,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3546,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3560,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3585,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3621,
    3622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2483,
      -1,  2485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3648,  3649,    -1,  3651,
      -1,  3653,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3672,    -1,    -1,    -1,  3676,  3677,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   767,    -1,    -1,    -1,   771,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3721,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2581,    -1,   804,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3743,    -1,    -1,  2598,    -1,    -1,    -1,    -1,    -1,
      -1,  2605,  2606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   852,    -1,    -1,
    3782,    -1,    -1,   858,    -1,    -1,    -1,  2481,    -1,  2483,
      -1,  2485,    -1,    -1,    -1,  3797,    -1,    -1,    -1,    -1,
      -1,    -1,  2656,    -1,  2658,  2659,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2672,    -1,
      -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,  2683,
      -1,  2685,    -1,    -1,  3836,  3837,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2697,  2698,    -1,    -1,    -1,  3850,    -1,
      -1,    -1,    -1,    -1,  2708,    -1,    -1,    -1,    -1,    -1,
    3862,    -1,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   954,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2581,    -1,    -1,
      -1,    -1,    -1,    -1,  2748,  2749,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2598,    -1,    -1,    -1,    -1,    -1,
     985,  2605,  2606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2678,    -1,   954,    -1,    -1,  2683,
      -1,  2685,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2697,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2708,    -1,    -1,   985,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1145,    -1,  1111,    -1,    -1,    -1,
      -1,    -1,    -1,  1118,    -1,    -1,    -1,    -1,    -1,  1124,
      -1,    -1,  2906,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1172,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1111,  1255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1228,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3067,  3068,  3069,  3070,  3071,  3072,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1302,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3097,    -1,    -1,    -1,    -1,  3102,  3103,
    3104,  3105,  3106,    -1,    -1,    -1,  3110,  1332,  1333,    -1,
    1335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2990,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1276,    -1,
      -1,    -1,    -1,    -1,  3168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1302,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1421,    -1,    -1,  1424,
    1425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1332,  1333,    -1,  1335,    -1,    -1,
    1481,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3090,    -1,    -1,    -1,
      -1,    -1,    -1,  3097,  1515,    -1,  1481,    -1,  3102,  3103,
    3104,  3105,  3106,    -1,    -1,    -1,  3110,    -1,  1529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1421,  1529,    -1,  1424,  1425,    -1,    -1,
      -1,    -1,  3316,    -1,    -1,    -1,    -1,    -1,    -1,  1580,
      -1,    -1,  3326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3336,  3337,    -1,    -1,  1597,  3341,  3342,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3351,    -1,    -1,
      -1,    -1,    -1,  1614,    -1,  1580,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3368,  3369,  3370,    -1,    -1,    -1,
      -1,    -1,  1597,    -1,  3378,  3379,    -1,    -1,  1639,  3383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1614,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1639,    -1,    -1,    -1,  3422,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1698,    -1,    -1,
      -1,    -1,    -1,  3447,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1682,    -1,  1684,
      -1,    -1,  1687,    -1,  1689,    -1,    -1,    -1,    -1,    -1,
      -1,  3315,    -1,  1698,    -1,    -1,    -1,    -1,    -1,    -1,
    3324,    -1,  3326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3336,  3337,    -1,    -1,    -1,  3341,  3342,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1751,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1785,  1786,    -1,  3567,    -1,    -1,    -1,    -1,  1793,    -1,
      -1,  1796,    -1,    -1,  1799,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1807,  1808,    -1,    -1,    -1,    -1,    -1,  1850,
    1815,    -1,    -1,  1818,  1819,  1820,  1821,    -1,    -1,    -1,
      -1,    -1,    -1,  1828,  1829,    -1,  1831,    -1,  1833,    -1,
      -1,  1836,    -1,    -1,  3618,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1850,  1851,    -1,    -1,    -1,
    1855,    -1,    -1,    -1,  1859,    -1,    -1,    -1,  1863,    -1,
      -1,  1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,
      -1,  1876,    -1,    -1,    -1,    -1,  1881,    -1,    -1,    -1,
    1885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1793,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1815,    -1,    -1,
    1818,    -1,    -1,  1821,    -1,    -1,    -1,    -1,    -1,    -1,
    1828,  1829,    -1,    -1,    -1,  1833,    -1,    -1,  1836,    -1,
      -1,  1946,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1851,    -1,    -1,    -1,  1855,    -1,    -1,
      -1,  1859,    -1,    -1,    -1,  1863,    -1,    -1,  1866,  1867,
    1868,  1869,  1870,  1871,  1872,  1873,  1874,    -1,  1876,    -1,
      -1,    -1,    -1,  1881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2050,
      -1,    -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2030,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2050,    -1,    -1,  1946,  2054,
    2055,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2030,    -1,    -1,  2176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2148,    -1,    -1,    -1,    -1,    -1,    -1,
    2155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,
      -1,  2176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2249,    -1,    -1,    -1,    -1,    -1,
    2148,    -1,    -1,    -1,  2259,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2291,    -1,    -1,    -1,
    2331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2320,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2348,  2349,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2378,    -1,    -1,    -1,  2382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,
    2395,  2396,  2397,  2291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2406,    -1,    -1,    -1,    -1,  2411,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2421,  2422,    -1,  2424,
      -1,    -1,  2320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2437,    -1,  2439,    -1,    -1,    -1,  2443,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2349,    -1,    -1,  2459,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2470,    -1,  2472,  2473,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2493,    -1,
      -1,    -1,    -1,    -1,  2499,    -1,  2394,    -1,  2396,  2397,
      -1,    -1,    -1,  2508,  2509,  2510,    -1,    -1,  2406,    -1,
      -1,    -1,    -1,  2411,    -1,    -1,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2540,  2577,    -1,  2579,  2437,
      -1,  2439,    -1,    -1,    -1,  2443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2561,  2562,    -1,  2564,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2493,    -1,    -1,    -1,    -1,
      -1,  2499,    -1,  2608,    -1,    -1,    -1,    -1,    -1,    -1,
    2508,  2509,  2510,    -1,    -1,    -1,  2657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,
      -1,    -1,  2540,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1348,    -1,    -1,    -1,    -1,  2708,    -1,    -1,
      -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2708,    -1,    -1,    -1,    -1,    -1,  2750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2723,    -1,
      -1,    -1,    -1,    -1,    -1,  1411,    -1,    -1,    -1,    -1,
      -1,  2736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2785,  2750,    -1,    -1,    -1,    -1,
    2791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2766,    -1,    -1,    -1,  2770,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2780,    -1,    -1,    -1,    -1,
    2785,    -1,    -1,    -1,    -1,    -1,  2791,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2842,    -1,    -1,  2809,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2839,    -1,    -1,  2842,    -1,    -1,
      -1,    -1,    -1,  2848,    -1,    -1,  2887,    -1,    -1,  2854,
      -1,  2856,    -1,    -1,    -1,  2860,  2861,    -1,    -1,  2864,
    2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,
      -1,    -1,    -1,  2878,  2879,    -1,    -1,    -1,    -1,  2920,
      -1,    -1,  2887,    -1,    -1,  1571,    -1,  2892,    -1,    -1,
      -1,    -1,    -1,  2898,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2907,    -1,    -1,  2910,    -1,  2912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2920,  2921,  2922,  2923,    -1,
      -1,    -1,  2927,    -1,    -1,  2930,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2940,    -1,    -1,    -1,    -1,
      -1,  2839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2848,    -1,    -1,    -1,    -1,    -1,  2854,    -1,  2856,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2878,  2879,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,    -1,
    2898,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2907,
      -1,    -1,  2910,    -1,  2912,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2921,    -1,    -1,    -1,    -1,    -1,  2927,
      -1,    -1,  2930,  3038,    -1,    -1,    -1,    -1,  1724,    -1,
      -1,    -1,  2940,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1791,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3126,    -1,    -1,    -1,    -1,    -1,    -1,  1814,    -1,
      -1,    -1,  3137,  1819,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1838,  1839,    -1,    -1,  1842,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3188,    -1,    -1,    -1,    -1,  3193,    -1,
      -1,  3196,    -1,  1879,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3271,    -1,    -1,  1955,
      -1,    -1,    -1,  3278,  3279,    -1,  1962,    -1,  1964,    -1,
    3285,  3286,    -1,    -1,    -1,  3290,  3291,    -1,    -1,    -1,
      -1,  3296,  3297,    -1,    -1,  3300,    -1,  3338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3338,    -1,    -1,    -1,  3235,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3278,  3279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3290,    -1,    -1,    -1,    -1,    -1,  3296,  3297,
    3405,    -1,  3300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3461,    -1,    -1,    -1,
    3465,    -1,    -1,    -1,    -1,  3470,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3492,    -1,    -1,
      -1,  3496,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3405,    -1,    -1,
    3515,  3516,    -1,    -1,  3519,    -1,    -1,    -1,    -1,    -1,
      -1,  3526,  3527,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3546,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3560,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3461,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
    3585,    -1,    44,    45,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,  3621,  3622,    -1,    -1,
      -1,  3519,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3527,
      -1,  3672,    -1,    -1,    -1,  3676,  3677,    -1,    -1,    -1,
      -1,    -1,    -1,  3648,  3649,    -1,  3651,    -1,  3653,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3560,    -1,    -1,    -1,  2352,  3672,    -1,    -1,
      -1,  3676,  3677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2374,    -1,
    2376,    -1,  2378,  2379,    -1,    -1,  2382,    -1,    -1,    -1,
    2386,    -1,  3743,    -1,    -1,    -1,    -1,  2393,    -1,    -1,
      -1,    -1,  2398,    -1,    -1,    -1,  3721,  2403,    -1,   181,
      -1,    -1,  2408,    -1,  3622,    -1,    -1,    -1,    -1,    -1,
      -1,  2417,    -1,   195,    -1,  2421,  2422,  2423,  3743,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2435,
      -1,    -1,   214,  3651,    -1,    -1,  2442,    -1,  2444,  2445,
    2446,  2447,  2448,  2449,  2450,  2451,  2452,  2453,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,  3782,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,
      -1,  3836,  3837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3850,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,  3862,    -1,    -1,
      -1,  2547,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    -1,   357,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,  2655,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,  2679,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,    -1,    -1,
      -1,   483,    -1,    -1,    -1,   487,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2782,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2799,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2838,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2859,    -1,  2861,    -1,    -1,  2864,  2865,
    2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,  2875,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2899,    -1,    -1,    -1,  2903,    -1,    -1,
      -1,    -1,  2908,  2909,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2922,  2923,  2924,    -1,
    2926,    -1,    -1,  2929,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,  3002,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,   480,    -1,
      -1,    -1,    -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    36,    37,    -1,    -1,
    3126,    -1,    -1,    -1,    44,    45,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3236,    -1,    -1,  3239,  3240,  3241,    -1,    -1,  3244,    -1,
      -1,    -1,    -1,  3249,  3250,  3251,  3252,  3253,  3254,  3255,
    3256,  3257,  3258,  3259,  3260,    -1,    -1,    -1,    -1,    -1,
      -1,   181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,  3284,  3285,
    3286,  3287,    -1,  3289,    -1,    -1,    -1,  3293,  3294,  3295,
      -1,    -1,  3298,    -1,   214,  3301,    -1,    -1,    -1,    -1,
      -1,    -1,  3308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   266,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      36,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,    45,
      -1,  3407,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,
      -1,    -1,  3488,    -1,    -1,    -1,  3492,    -1,   408,    -1,
    3496,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3504,    -1,
    3506,   421,    -1,    -1,  3510,  3511,  3512,    -1,    -1,  3515,
    3516,  3517,  3518,    -1,  3520,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   451,   452,    -1,   454,   181,    -1,    -1,    -1,    -1,
     460,   461,   462,   463,    -1,   465,   466,    -1,    -1,   195,
     470,   471,   472,   473,   474,    -1,    -1,   477,   478,   479,
     480,    -1,    -1,    -1,    -1,    -1,    -1,   487,   214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3589,    -1,    -1,    -1,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     266,    -1,    -1,   269,    -1,    -1,    -1,  3633,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3647,  3648,  3649,  3650,   291,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3660,  3661,  3662,    -1,  3664,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3679,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   357,    -1,  3719,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3731,  3732,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     396,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   451,   452,    -1,   454,    -1,
      -1,    -1,    -1,    -1,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,   474,    -1,
      -1,   477,   478,   479,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   487,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,   105,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,    -1,    -1,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,    -1,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,    -1,    -1,     6,     7,     8,    -1,    10,
      11,    12,    13,    14,    -1,    -1,    -1,    18,    -1,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    -1,    -1,
     483,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    -1,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,
     101,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,    -1,    -1,    -1,   187,    -1,    -1,   190,
      -1,    -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,   200,
      -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,   229,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,    -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,   250,
     251,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,   289,    -1,
      -1,   292,    -1,   294,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   307,   308,   309,   310,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   318,   319,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   330,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   347,    -1,    -1,   350,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   365,    -1,    -1,   368,    -1,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   394,   395,    -1,    -1,    -1,   399,    -1,
     401,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     421,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,   436,   437,   438,   439,   440,
     441,   442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,    -1,    -1,    -1,    -1,     6,     7,
       8,    -1,    10,    11,    12,    13,    14,    -1,    -1,    -1,
      18,    -1,    20,    21,    22,    23,    24,    25,    -1,    27,
      28,    -1,    -1,   484,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    -1,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,
      -1,    -1,   100,   101,   102,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,
      -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   154,   155,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,   187,
      -1,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,    -1,
      -1,    -1,   200,    -1,   202,    -1,    -1,    -1,    -1,    -1,
     208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     228,   229,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,   240,   241,    -1,   243,    -1,    -1,    -1,    -1,
      -1,    -1,   250,   251,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,
      -1,   289,    -1,    -1,   292,    -1,   294,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,
     308,   309,   310,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     318,   319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,
      -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,    -1,    -1,
     368,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   394,   395,    -1,    -1,
      -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,   437,
     438,   439,   440,   441,   442,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   451,    -1,    -1,   454,    -1,     3,    -1,
      -1,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    -1,    27,    28,    29,    -1,   484,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    -1,    99,   100,   101,   102,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,   120,   121,   122,    -1,    -1,
     125,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,   154,
     155,   156,    -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,   174,
      -1,    -1,    -1,    -1,    -1,   180,   181,    -1,    -1,    -1,
      -1,   186,   187,   188,    -1,   190,    -1,    -1,   193,    -1,
     195,    -1,    -1,    -1,    -1,   200,    -1,   202,    -1,   204,
      -1,   206,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,    -1,   237,    -1,    -1,   240,   241,    -1,   243,    -1,
      -1,    -1,    -1,    -1,    -1,   250,   251,    -1,   253,    -1,
     255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   270,    -1,    -1,   273,   274,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,
      -1,    -1,    -1,   288,   289,    -1,    -1,   292,    -1,   294,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   307,   308,   309,   310,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   318,   319,    -1,   321,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   330,   331,    -1,    -1,   334,
      -1,   336,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,   346,   347,    -1,   349,   350,    -1,    -1,   353,    -1,
      -1,    -1,    -1,    -1,   359,    -1,    -1,    -1,     3,   364,
     365,    -1,   367,   368,     9,   370,    -1,    -1,    -1,   374,
      15,    -1,    17,    -1,    19,    -1,    -1,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,   394,
     395,    -1,    -1,    -1,   399,    -1,   401,    -1,   403,    -1,
     405,    46,    47,   408,    -1,    -1,   411,    -1,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,   421,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,    -1,
     435,   436,   437,   438,   439,   440,   441,   442,    83,    -1,
      85,    86,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,
      -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   118,   479,   120,   121,    -1,    -1,    -1,
     125,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,   174,
      -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,    -1,
      -1,   186,    -1,   188,    -1,    -1,    -1,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   204,
      -1,   206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   270,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   321,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   331,    -1,    -1,   334,
      -1,   336,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,   346,    -1,    -1,   349,    -1,    -1,    -1,   353,    -1,
      -1,    -1,    -1,    -1,   359,    -1,    -1,    -1,    -1,   364,
      -1,    -1,   367,    -1,    -1,    -1,    -1,    -1,    -1,   374,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,    -1,
     405,    -1,    -1,    -1,    -1,    -1,   411,    -1,   413,    -1,
      -1,   416,    -1,    -1,    -1,   420,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    17,    18,
      -1,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    46,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    -1,   479,    -1,    -1,    66,    -1,    68,
      -1,    70,    71,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    92,    93,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,    -1,   106,   107,    -1,
     109,   110,   111,   112,   113,   114,   115,   116,    -1,   118,
     119,   120,   121,   122,    -1,    -1,   125,   126,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,   136,    -1,   138,
     139,   140,   141,   142,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,   167,   168,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,    -1,    -1,   182,    -1,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,    -1,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
      -1,   210,    -1,   212,   213,   214,   215,   216,   217,   218,
     219,    -1,   221,   222,   223,   224,   225,   226,    -1,   228,
     229,    -1,   231,   232,   233,   234,   235,    -1,   237,    -1,
      -1,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,
     309,   310,   311,   312,   313,   314,   315,    -1,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,    -1,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,    -1,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,   394,   395,    -1,    -1,   398,
     399,   400,   401,   402,   403,   404,   405,   406,   407,    -1,
     409,   410,   411,   412,   413,   414,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,    -1,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,   444,   445,    -1,    -1,    -1,
      -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,   458,
     459,   460,   461,   462,   463,   464,   465,    -1,    -1,    -1,
      -1,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,    -1,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,   228,   229,    -1,   231,   232,
     233,   234,   235,    -1,   237,    -1,    -1,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,   304,    -1,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,    -1,   409,   410,   411,   412,
     413,   414,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
     453,   454,   455,    -1,    -1,   458,   459,   460,   461,   462,
     463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    -1,
      17,    18,    -1,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    46,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      -1,    68,    -1,    70,    71,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,    -1,   106,
     107,    -1,   109,   110,    -1,    -1,   113,   114,   115,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,   126,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,    -1,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
     167,   168,    -1,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,    -1,    -1,   182,    -1,   184,   185,   186,
      -1,   188,   189,    -1,    -1,   192,   193,   194,   195,    -1,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
     207,    -1,    -1,   210,    -1,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,   226,
      -1,   228,   229,    -1,   231,   232,   233,   234,   235,    -1,
     237,    -1,    -1,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,    -1,   251,   252,   253,    -1,   255,   256,
     257,    -1,    -1,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,    -1,
     287,   288,   289,   290,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,    -1,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,    -1,   345,   346,
     347,   348,   349,    -1,   351,   352,   353,   354,   355,   356,
     357,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,   368,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,   394,   395,    -1,
      -1,   398,    -1,   400,    -1,    -1,   403,   404,   405,   406,
     407,    -1,    -1,   410,   411,   412,   413,    -1,    -1,   416,
     417,   418,   419,    -1,   421,   422,   423,   424,   425,   426,
      -1,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   443,   444,   445,    -1,
      -1,    -1,    -1,    -1,   451,    -1,    -1,   454,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    -1,    27,
      28,    29,    -1,   480,    32,    33,    34,    35,    -1,    -1,
      38,    39,    40,    41,    -1,    43,    -1,    -1,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    95,    -1,    97,
      98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,   107,
      -1,   109,   110,    -1,    -1,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,    -1,   197,
      -1,   199,    -1,    -1,    -1,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,   233,    -1,   235,    -1,   237,
      -1,    -1,    -1,    -1,   242,    -1,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,    -1,    -1,   255,   256,   257,
      -1,    -1,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,    -1,   275,    -1,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,    -1,   290,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,    -1,   403,   404,   405,   406,   407,
      -1,    -1,   410,   411,   412,   413,    -1,   415,   416,   417,
     418,   419,   420,   421,   422,    -1,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,    -1,    -1,   454,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
     201,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,   477,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,   201,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,    -1,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,    -1,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,    -1,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,    -1,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
      -1,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,    -1,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,    -1,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,   302,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,   479,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,   302,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,   479,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,   479,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,    -1,    -1,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    -1,    27,    28,    29,   479,    -1,
      32,    33,    34,    35,    -1,    -1,    38,    39,    40,    41,
      -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      92,    93,    -1,    95,    -1,    97,    98,    99,    -1,   101,
      -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,
      -1,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,   167,   168,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,    -1,    -1,
     182,    -1,   184,   185,   186,   187,   188,   189,   190,    -1,
     192,   193,   194,   195,    -1,   197,    -1,   199,    -1,    -1,
     202,   203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,
     212,   213,   214,   215,    -1,   217,   218,   219,    -1,   221,
     222,   223,   224,   225,   226,    -1,   228,   229,    -1,   231,
     232,   233,    -1,   235,    -1,   237,    -1,    -1,    -1,    -1,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,    -1,    -1,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,   279,   280,   281,
     282,   283,   284,   285,    -1,   287,   288,    -1,   290,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,    -1,    -1,
      -1,   303,   304,    -1,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,    -1,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,    -1,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,    -1,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,   394,   395,    -1,    -1,   398,   399,   400,   401,
      -1,   403,   404,   405,   406,   407,    -1,    -1,   410,   411,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,    -1,   424,   425,   426,    -1,    -1,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,
      -1,    -1,   454,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    -1,    27,    28,    29,    -1,   480,    32,
      33,    34,    35,    -1,    -1,    38,    39,    40,    41,    -1,
      43,    -1,    -1,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    -1,    97,    98,    99,    -1,   101,    -1,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,    -1,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,    -1,   142,
      -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,    -1,    -1,    -1,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,    -1,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,    -1,    -1,   242,
      -1,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
      -1,    -1,   255,   256,   257,    -1,    -1,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,    -1,   275,    -1,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,    -1,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,    -1,    -1,    -1,
     303,   304,    -1,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
      -1,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,
      -1,   454,   455,    -1,    -1,    -1,    -1,   460,   461,   462,
     463,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   478,   479,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    17,    18,
      -1,    20,    21,    22,    23,    24,    25,    -1,    27,    28,
      29,    -1,    -1,    32,    33,    34,    35,    -1,    -1,    38,
      39,    40,    41,    -1,    43,    -1,    -1,    46,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,
      -1,    70,    71,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    93,    -1,    95,    -1,    97,    98,
      99,    -1,   101,    -1,   103,    -1,    -1,   106,   107,    -1,
     109,   110,    -1,    -1,   113,   114,   115,   116,    -1,   118,
     119,   120,   121,   122,    -1,    -1,   125,   126,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,   136,    -1,   138,
     139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,   167,   168,
      -1,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,    -1,    -1,   182,    -1,   184,   185,   186,   187,   188,
     189,   