.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER OPERATOR" "" "2011-09-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER OPERATOR \- change the definition of an operator

.SH SYNOPSIS
.sp
.nf
ALTER OPERATOR \fIname\fR ( { \fIlefttype\fR | NONE } , { \fIrighttype\fR | NONE } ) OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER OPERATOR\fR changes the definition of
an operator. The only currently available functionality is to change the
owner of the operator.
.PP
You must own the operator to use \fBALTER OPERATOR\fR.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the operator's schema. (These restrictions enforce that altering the owner
doesn't do anything you couldn't do by dropping and recreating the operator.
However, a superuser can alter ownership of any operator anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator.
.TP
\fB\fIlefttype\fB\fR
The data type of the operator's left operand; write
NONE if the operator has no left operand.
.TP
\fB\fIrighttype\fB\fR
The data type of the operator's right operand; write
NONE if the operator has no right operand.
.TP
\fB\fInewowner\fB\fR
The new owner of the operator.
.SH "EXAMPLES"
.PP
Change the owner of a custom operator a @@ b for type \fBtext\fR:
.sp
.nf
ALTER OPERATOR @@ (text, text) OWNER TO joe;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER OPERATOR\fR statement in
the SQL standard.
.SH "SEE ALSO"
CREATE OPERATOR [\fBcreate_operator\fR(l)], DROP OPERATOR [\fBdrop_operator\fR(l)]
