.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER TEXT SEARCH DICTIONARY" "" "2012-08-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TEXT SEARCH DICTIONARY \- change the definition of a text search dictionary

.SH SYNOPSIS
.sp
.nf
ALTER TEXT SEARCH DICTIONARY \fIname\fR (
    \fIoption\fR [ = \fIvalue\fR ] [, ... ]
)
ALTER TEXT SEARCH DICTIONARY \fIname\fR RENAME TO \fInewname\fR
ALTER TEXT SEARCH DICTIONARY \fIname\fR OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER TEXT SEARCH DICTIONARY\fR changes the definition of
a text search dictionary. You can change the dictionary's
template-specific options, or change the dictionary's name or owner.
.PP
You must be the owner of the dictionary to use
\fBALTER TEXT SEARCH DICTIONARY\fR.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing text search
dictionary.
.TP
\fB\fIoption\fB\fR
The name of a template-specific option to be set for this dictionary.
.TP
\fB\fIvalue\fB\fR
The new value to use for a template-specific option.
If the equal sign and value are omitted, then any previous
setting for the option is removed from the dictionary,
allowing the default to be used.
.TP
\fB\fInewname\fB\fR
The new name of the text search dictionary.
.TP
\fB\fInewowner\fB\fR
The new owner of the text search dictionary.
.PP
Template-specific options can appear in any order.
.PP
.SH "EXAMPLES"
.PP
The following example command changes the stopword list
for a Snowball-based dictionary. Other parameters remain unchanged.
.sp
.nf
ALTER TEXT SEARCH DICTIONARY my_dict ( StopWords = newrussian );
.sp
.fi
.PP
The following example command changes the language option to dutch,
and removes the stopword option entirely.
.sp
.nf
ALTER TEXT SEARCH DICTIONARY my_dict ( language = dutch, StopWords );
.sp
.fi
.PP
The following example command ``updates'' the dictionary's
definition without actually changing anything.
.sp
.nf
ALTER TEXT SEARCH DICTIONARY my_dict ( dummy );
.sp
.fi
(The reason this works is that the option removal code doesn't complain
if there is no such option.) This trick is useful when changing
configuration files for the dictionary: the \fBALTER\fR will
force existing database sessions to re-read the configuration files,
which otherwise they would never do if they had read them earlier.
.SH "COMPATIBILITY"
.PP
There is no \fBALTER TEXT SEARCH DICTIONARY\fR statement in
the SQL standard.
.SH "SEE ALSO"
CREATE TEXT SEARCH DICTIONARY [\fBcreate_text_search_dictionary\fR(l)], DROP TEXT SEARCH DICTIONARY [\fBdrop_text_search_dictionary\fR(l)]
