.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER TYPE" "" "2012-08-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TYPE \- change the definition of a type

.SH SYNOPSIS
.sp
.nf
ALTER TYPE \fIname\fR OWNER TO \fInew_owner\fR 
ALTER TYPE \fIname\fR SET SCHEMA \fInew_schema\fR
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER TYPE\fR changes the definition of an existing type.
The only currently available capabilities are changing the owner and schema
of a type.
.PP
You must own the type to use \fBALTER TYPE\fR.
To change the schema of a type, you must also have
CREATE privilege on the new schema.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the type's schema. (These restrictions enforce that altering the owner
doesn't do anything you couldn't do by dropping and recreating the type.
However, a superuser can alter ownership of any type anyway.)
.SH "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing type to
alter.
.TP
\fB\fInew_owner\fB\fR
The user name of the new owner of the type.
.TP
\fB\fInew_schema\fB\fR
The new schema for the type.
.PP
.SH "EXAMPLES"
.PP
To change the owner of the user-defined type email
to joe:
.sp
.nf
ALTER TYPE email OWNER TO joe;
   
.sp
.fi
.PP
To change the schema of the user-defined type email
to customers:
.sp
.nf
ALTER TYPE email SET SCHEMA customers;
   
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER TYPE\fR statement in the SQL
standard.
