.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "EXECUTE" "" "2008-10-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
EXECUTE \- execute a prepared statement

.SH SYNOPSIS
.sp
.nf
EXECUTE \fIname\fR [ ( \fIparameter\fR [, ...] ) ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBEXECUTE\fR is used to execute a previously prepared
statement. Since prepared statements only exist for the duration of a
session, the prepared statement must have been created by a
\fBPREPARE\fR statement executed earlier in the
current session.
.PP
If the \fBPREPARE\fR statement that created the statement
specified some parameters, a compatible set of parameters must be
passed to the \fBEXECUTE\fR statement, or else an
error is raised. Note that (unlike functions) prepared statements are
not overloaded based on the type or number of their parameters; the
name of a prepared statement must be unique within a database session.
.PP
For more information on the creation and usage of prepared statements,
see PREPARE [\fBprepare\fR(l)].
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the prepared statement to execute.
.TP
\fB\fIparameter\fB\fR
The actual value of a parameter to the prepared statement. This
must be an expression yielding a value that is compatible with
the data type of this parameter, as was determined when the
prepared statement was created.
.SH "OUTPUTS"
.PP
The command tag returned by \fBEXECUTE\fR
is that of the prepared statement, and not EXECUTE.
.SH "EXAMPLES"
.PP
Examples are given in the Examples [\fBprepare\fR(l)] section of the PREPARE [\fBprepare\fR(l)] documentation.
.SH "COMPATIBILITY"
.PP
The SQL standard includes an \fBEXECUTE\fR statement,
but it is only for use in embedded SQL. This version of the
\fBEXECUTE\fR statement also uses a somewhat different
syntax.
.SH "SEE ALSO"
DEALLOCATE [\fBdeallocate\fR(l)], PREPARE [\fBprepare\fR(l)]
