.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP TEXT SEARCH TEMPLATE" "" "2009-02-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TEXT SEARCH TEMPLATE \- remove a text search template

.SH SYNOPSIS
.sp
.nf
DROP TEXT SEARCH TEMPLATE [ IF EXISTS ] \fIname\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP TEXT SEARCH TEMPLATE\fR drops an existing text search
template. You must be a superuser to use this command.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the text search template does not exist.
A notice is issued in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing text search
template.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the text search template.
.TP
\fBRESTRICT\fR
Refuse to drop the text search template if any objects depend on it.
This is the default.
.SH "EXAMPLES"
.PP
Remove the text search template thesaurus:
.sp
.nf
DROP TEXT SEARCH TEMPLATE thesaurus;
.sp
.fi
This command will not succeed if there are any existing text search
dictionaries that use the template. Add CASCADE to
drop such dictionaries along with the template.
.SH "COMPATIBILITY"
.PP
There is no \fBDROP TEXT SEARCH TEMPLATE\fR statement in the
SQL standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH TEMPLATE [\fBalter_text_search_template\fR(l)], CREATE TEXT SEARCH TEMPLATE [\fBcreate_text_search_template\fR(l)]
