.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP INDEX" "" "2009-12-09" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP INDEX \- remove an index

.SH SYNOPSIS
.sp
.nf
DROP INDEX [ IF EXISTS ] \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP INDEX\fR drops an existing index from the database
system. To execute this command you must be the owner of
the index.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the index does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an index to remove.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the index.
.TP
\fBRESTRICT\fR
Refuse to drop the index if any objects depend on it. This is
the default.
.SH "EXAMPLES"
.PP
This command will remove the index title_idx:
.sp
.nf
DROP INDEX title_idx;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBDROP INDEX\fR is a
PostgreSQL language extension. There
are no provisions for indexes in the SQL standard.
.SH "SEE ALSO"
CREATE INDEX [\fBcreate_index\fR(l)]
