.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE ROLE" "" "2007-10-05" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE ROLE \- define a new database role

.SH SYNOPSIS
.sp
.nf
CREATE ROLE \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:
    
      SUPERUSER | NOSUPERUSER
    | CREATEDB | NOCREATEDB
    | CREATEROLE | NOCREATEROLE
    | CREATEUSER | NOCREATEUSER
    | INHERIT | NOINHERIT
    | LOGIN | NOLOGIN
    | CONNECTION LIMIT \fIconnlimit\fR
    | [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR'
    | VALID UNTIL '\fItimestamp\fR' 
    | IN ROLE \fIrolename\fR [, ...]
    | IN GROUP \fIrolename\fR [, ...]
    | ROLE \fIrolename\fR [, ...]
    | ADMIN \fIrolename\fR [, ...]
    | USER \fIrolename\fR [, ...]
    | SYSID \fIuid\fR 
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE ROLE\fR adds a new role to a
PostgreSQL database cluster. A role is
an entity that can own database objects and have database privileges;
a role can be considered a ``user'', a ``group'', or both
depending on how it is used. Refer to
in the documentation and in the documentation for information about managing
users and authentication. You must have CREATEROLE
privilege or be a database superuser to use this command.
.PP
Note that roles are defined at the database cluster
level, and so are valid in all databases in the cluster.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the new role.
.TP
\fBSUPERUSER\fR
.TP
\fBNOSUPERUSER\fR
These clauses determine whether the new role is a ``superuser'',
who can override all access restrictions within the database.
Superuser status is dangerous and should be used only when really
needed. You must yourself be a superuser to create a new superuser.
If not specified,
NOSUPERUSER is the default.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a role's ability to create databases. If
CREATEDB is specified, the role being
defined will be allowed to create new databases. Specifying
NOCREATEDB will deny a role the ability to
create databases. If not specified,
NOCREATEDB is the default.
.TP
\fBCREATEROLE\fR
.TP
\fBNOCREATEROLE\fR
These clauses determine whether a role will be permitted to
create new roles (that is, execute \fBCREATE ROLE\fR).
A role with CREATEROLE privilege can also alter
and drop other roles.
If not specified,
NOCREATEROLE is the default.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses are an obsolete, but still accepted, spelling of
SUPERUSER and NOSUPERUSER.
Note that they are \fBnot\fR equivalent to
CREATEROLE as one might naively expect!
.TP
\fBINHERIT\fR
.TP
\fBNOINHERIT\fR
These clauses determine whether a role ``inherits'' the
privileges of roles it is a member of.
A role with the INHERIT attribute can automatically
use whatever database privileges have been granted to all roles
it is directly or indirectly a member of.
Without INHERIT, membership in another role
only grants the ability to \fBSET ROLE\fR to that other role;
the privileges of the other role are only available after having
done so.
If not specified,
INHERIT is the default.
.TP
\fBLOGIN\fR
.TP
\fBNOLOGIN\fR
These clauses determine whether a role is allowed to log in;
that is, whether the role can be given as the initial session
authorization name during client connection. A role having
the LOGIN attribute can be thought of as a user.
Roles without this attribute are useful for managing database
privileges, but are not users in the usual sense of the word.
If not specified,
NOLOGIN is the default, except when
\fBCREATE ROLE\fR is invoked through its alternate spelling
\fBCREATE USER\fR.
.TP
\fBCONNECTION LIMIT \fIconnlimit\fB\fR
If role can log in, this specifies how many concurrent connections
the role can make. -1 (the default) means no limit.
.TP
\fBPASSWORD \fIpassword\fB\fR
Sets the role's password. (A password is only of use for
roles having the LOGIN attribute, but you
can nonetheless define one for roles without it.) If you do
not plan to use password authentication you can omit this
option. If no password is specified, the password will be set
to null and password authentication will always fail for that
user. A null password can optionally be written explicitly as
PASSWORD NULL.
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
These key words control whether the password is stored
encrypted in the system catalogs. (If neither is specified,
the default behavior is determined by the configuration
parameter password_encryption.) If the
presented password string is already in MD5-encrypted format,
then it is stored encrypted as-is, regardless of whether
ENCRYPTED or UNENCRYPTED is specified
(since the system cannot decrypt the specified encrypted
password string). This allows reloading of encrypted
passwords during dump/restore.

Note that older clients might lack support for the MD5
authentication mechanism that is needed to work with passwords
that are stored encrypted.
.TP
\fBVALID UNTIL '\fItimestamp\fB'\fR
The VALID UNTIL clause sets a date and
time after which the role's password is no longer valid. If
this clause is omitted the password will be valid for all time.
.TP
\fBIN ROLE \fIrolename\fB\fR
The IN ROLE clause lists one or more existing
roles to which the new role will be immediately added as a new
member. (Note that there is no option to add the new role as an
administrator; use a separate \fBGRANT\fR command to do that.)
.TP
\fBIN GROUP \fIrolename\fB\fR
IN GROUP is an obsolete spelling of
IN ROLE.
.TP
\fBROLE \fIrolename\fB\fR
The ROLE clause lists one or more existing
roles which are automatically added as members of the new role.
(This in effect makes the new role a ``group''.)
.TP
\fBADMIN \fIrolename\fB\fR
The ADMIN clause is like ROLE,
but the named roles are added to the new role WITH ADMIN
OPTION, giving them the right to grant membership in this role
to others.
.TP
\fBUSER \fIrolename\fB\fR
The USER clause is an obsolete spelling of
the ROLE clause.
.TP
\fBSYSID \fIuid\fB\fR
The SYSID clause is ignored, but is accepted
for backwards compatibility.
.SH "NOTES"
.PP
Use ALTER ROLE [\fBalter_role\fR(l)] to
change the attributes of a role, and DROP ROLE [\fBdrop_role\fR(l)] to remove a role. All the attributes
specified by \fBCREATE ROLE\fR can be modified by later
\fBALTER ROLE\fR commands.
.PP
The preferred way to add and remove members of roles that are being
used as groups is to use
GRANT [\fBgrant\fR(l)] and
REVOKE [\fBrevoke\fR(l)].
.PP
The VALID UNTIL clause defines an expiration time for a
password only, not for the role \fIper se\fR. In
particular, the expiration time is not enforced when logging in using
a non-password-based authentication method.
.PP
The INHERIT attribute governs inheritance of grantable
privileges (that is, access privileges for database objects and role
memberships). It does not apply to the special role attributes set by
\fBCREATE ROLE\fR and \fBALTER ROLE\fR. For example, being
a member of a role with CREATEDB privilege does not immediately
grant the ability to create databases, even if INHERIT is set;
it would be necessary to become that role via
SET ROLE [\fBset_role\fR(l)] before
creating a database.
.PP
The INHERIT attribute is the default for reasons of backwards
compatibility: in prior releases of PostgreSQL,
users always had access to all privileges of groups they were members of.
However, NOINHERIT provides a closer match to the semantics
specified in the SQL standard.
.PP
Be careful with the CREATEROLE privilege. There is no concept of
inheritance for the privileges of a CREATEROLE-role. That
means that even if a role does not have a certain privilege but is allowed
to create other roles, it can easily create another role with different
privileges than its own (except for creating roles with superuser
privileges). For example, if the role ``user'' has the
CREATEROLE privilege but not the CREATEDB privilege,
nonetheless it can create a new role with the CREATEDB
privilege. Therefore, regard roles that have the CREATEROLE
privilege as almost-superuser-roles.
.PP
PostgreSQL includes a program createuser [\fBcreateuser\fR(1)] that has
the same functionality as \fBCREATE ROLE\fR (in fact,
it calls this command) but can be run from the command shell.
.PP
The CONNECTION LIMIT option is only enforced approximately;
if two new sessions start at about the same time when just one
connection ``slot'' remains for the role, it is possible that
both will fail. Also, the limit is never enforced for superusers.
.PP
Caution must be exercised when specifying an unencrypted password
with this command. The password will be transmitted to the server
in cleartext, and it might also be logged in the client's command
history or the server log. The command createuser [\fBcreateuser\fR(1)], however, transmits
the password encrypted. Also, psql [\fBpsql\fR(1)] contains a command
\fB\\password\fR that can be used to safely change the
password later.
.SH "EXAMPLES"
.PP
Create a role that can log in, but don't give it a password:
.sp
.nf
CREATE ROLE jonathan LOGIN;
.sp
.fi
.PP
Create a role with a password:
.sp
.nf
CREATE USER davide WITH PASSWORD 'jw8s0F4';
.sp
.fi
(\fBCREATE USER\fR is the same as \fBCREATE ROLE\fR except
that it implies LOGIN.)
.PP
Create a role with a password that is valid until the end of 2004.
After one second has ticked in 2005, the password is no longer
valid.
.sp
.nf
CREATE ROLE miriam WITH LOGIN PASSWORD 'jw8s0F4' VALID UNTIL '2005-01-01';
.sp
.fi
.PP
Create a role that can create databases and manage roles:
.sp
.nf
CREATE ROLE admin WITH CREATEDB CREATEROLE;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBCREATE ROLE\fR statement is in the SQL standard,
but the standard only requires the syntax
.sp
.nf
CREATE ROLE \fIname\fR [ WITH ADMIN \fIrolename\fR ]
.sp
.fi
Multiple initial administrators, and all the other options of
\fBCREATE ROLE\fR, are
PostgreSQL extensions.
.PP
The SQL standard defines the concepts of users and roles, but it
regards them as distinct concepts and leaves all commands defining
users to be specified by each database implementation. In
PostgreSQL we have chosen to unify
users and roles into a single kind of entity. Roles therefore
have many more optional attributes than they do in the standard.
.PP
The behavior specified by the SQL standard is most closely approximated
by giving users the NOINHERIT attribute, while roles are
given the INHERIT attribute.
.SH "SEE ALSO"
SET ROLE [\fBset_role\fR(l)], ALTER ROLE [\fBalter_role\fR(l)], DROP ROLE [\fBdrop_role\fR(l)], GRANT [\fBgrant\fR(l)], REVOKE [\fBrevoke\fR(l)], \fBcreateuser\fR(1)
