.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP FUNCTION" "" "2007-10-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP FUNCTION \- remove a function

.SH SYNOPSIS
.sp
.nf
DROP FUNCTION [ IF EXISTS ] \fIname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] )
    [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP FUNCTION\fR removes the definition of an existing
function. To execute this command the user must be the
owner of the function. The argument types to the
function must be specified, since several different functions
can exist with the same name and different argument lists.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the function does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing function.
.TP
\fB\fIargmode\fB\fR
The mode of an argument: either IN, OUT,
or INOUT. If omitted, the default is IN.
Note that \fBDROP FUNCTION\fR does not actually pay
any attention to OUT arguments, since only the input
arguments are needed to determine the function's identity.
So it is sufficient to list the IN and INOUT
arguments.
.TP
\fB\fIargname\fB\fR
The name of an argument.
Note that \fBDROP FUNCTION\fR does not actually pay
any attention to argument names, since only the argument data
types are needed to determine the function's identity.
.TP
\fB\fIargtype\fB\fR
The data type(s) of the function's arguments (optionally 
schema-qualified), if any.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the function (such as
operators or triggers).
.TP
\fBRESTRICT\fR
Refuse to drop the function if any objects depend on it. This
is the default.
.SH "EXAMPLES"
.PP
This command removes the square root function:
.sp
.nf
DROP FUNCTION sqrt(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBDROP FUNCTION\fR statement is defined in the SQL
standard, but it is not compatible with this command.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], ALTER FUNCTION [\fBalter_function\fR(l)]
