/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define TYPECAST 326
#define CSTRING 327
#define CVARIABLE 328
#define CPP_LINE 329
#define IP 330
#define DOLCONST 331
#define ECONST 332
#define NCONST 333
#define UCONST 334
#define UIDENT 335
#define ABORT_P 336
#define ABSOLUTE_P 337
#define ACCESS 338
#define ACTION 339
#define ADD_P 340
#define ADMIN 341
#define AFTER 342
#define AGGREGATE 343
#define ALL 344
#define ALSO 345
#define ALTER 346
#define ALWAYS 347
#define ANALYSE 348
#define ANALYZE 349
#define AND 350
#define ANY 351
#define ARRAY 352
#define AS 353
#define ASC 354
#define ASSERTION 355
#define ASSIGNMENT 356
#define ASYMMETRIC 357
#define AT 358
#define AUTHORIZATION 359
#define BACKWARD 360
#define BEFORE 361
#define BEGIN_P 362
#define BETWEEN 363
#define BIGINT 364
#define BINARY 365
#define BIT 366
#define BOOLEAN_P 367
#define BOTH 368
#define BY 369
#define CACHE 370
#define CALLED 371
#define CASCADE 372
#define CASCADED 373
#define CASE 374
#define CAST 375
#define CATALOG_P 376
#define CHAIN 377
#define CHAR_P 378
#define CHARACTER 379
#define CHARACTERISTICS 380
#define CHECK 381
#define CHECKPOINT 382
#define CLASS 383
#define CLOSE 384
#define CLUSTER 385
#define COALESCE 386
#define COLLATE 387
#define COLUMN 388
#define COMMENT 389
#define COMMIT 390
#define COMMITTED 391
#define CONCURRENTLY 392
#define CONFIGURATION 393
#define CONNECTION 394
#define CONSTRAINT 395
#define CONSTRAINTS 396
#define CONTENT_P 397
#define CONTINUE_P 398
#define CONVERSION_P 399
#define COPY 400
#define COST 401
#define CREATE 402
#define CREATEDB 403
#define CREATEROLE 404
#define CREATEUSER 405
#define CROSS 406
#define CSV 407
#define CURRENT_P 408
#define CURRENT_CATALOG 409
#define CURRENT_DATE 410
#define CURRENT_ROLE 411
#define CURRENT_SCHEMA 412
#define CURRENT_TIME 413
#define CURRENT_TIMESTAMP 414
#define CURRENT_USER 415
#define CURSOR 416
#define CYCLE 417
#define DATA_P 418
#define DATABASE 419
#define DAY_P 420
#define DEALLOCATE 421
#define DEC 422
#define DECIMAL_P 423
#define DECLARE 424
#define DEFAULT 425
#define DEFAULTS 426
#define DEFERRABLE 427
#define DEFERRED 428
#define DEFINER 429
#define DELETE_P 430
#define DELIMITER 431
#define DELIMITERS 432
#define DESC 433
#define DICTIONARY 434
#define DISABLE_P 435
#define DISCARD 436
#define DISTINCT 437
#define DO 438
#define DOCUMENT_P 439
#define DOMAIN_P 440
#define DOUBLE_P 441
#define DROP 442
#define EACH 443
#define ELSE 444
#define ENABLE_P 445
#define ENCODING 446
#define ENCRYPTED 447
#define END_P 448
#define ENUM_P 449
#define ESCAPE 450
#define EXCEPT 451
#define EXCLUDING 452
#define EXCLUSIVE 453
#define EXECUTE 454
#define EXISTS 455
#define EXPLAIN 456
#define EXTERNAL 457
#define EXTRACT 458
#define FALSE_P 459
#define FAMILY 460
#define FETCH 461
#define FIRST_P 462
#define FLOAT_P 463
#define FOLLOWING 464
#define FOR 465
#define FORCE 466
#define FOREIGN 467
#define FORWARD 468
#define FREEZE 469
#define FROM 470
#define FULL 471
#define FUNCTION 472
#define GLOBAL 473
#define GRANT 474
#define GRANTED 475
#define GREATEST 476
#define GROUP_P 477
#define HANDLER 478
#define HAVING 479
#define HEADER_P 480
#define HOLD 481
#define HOUR_P 482
#define IDENTITY_P 483
#define IF_P 484
#define ILIKE 485
#define IMMEDIATE 486
#define IMMUTABLE 487
#define IMPLICIT_P 488
#define IN_P 489
#define INCLUDING 490
#define INCREMENT 491
#define INDEX 492
#define INDEXES 493
#define INHERIT 494
#define INHERITS 495
#define INITIALLY 496
#define INNER_P 497
#define INOUT 498
#define INPUT_P 499
#define INSENSITIVE 500
#define INSERT 501
#define INSTEAD 502
#define INT_P 503
#define INTEGER 504
#define INTERSECT 505
#define INTERVAL 506
#define INTO 507
#define INVOKER 508
#define IS 509
#define ISNULL 510
#define ISOLATION 511
#define JOIN 512
#define KEY 513
#define LANCOMPILER 514
#define LANGUAGE 515
#define LARGE_P 516
#define LAST_P 517
#define LC_COLLATE_P 518
#define LC_CTYPE_P 519
#define LEADING 520
#define LEAST 521
#define LEFT 522
#define LEVEL 523
#define LIKE 524
#define LIMIT 525
#define LISTEN 526
#define LOAD 527
#define LOCAL 528
#define LOCALTIME 529
#define LOCALTIMESTAMP 530
#define LOCATION 531
#define LOCK_P 532
#define LOGIN_P 533
#define MAPPING 534
#define MATCH 535
#define MAXVALUE 536
#define MINUTE_P 537
#define MINVALUE 538
#define MODE 539
#define MONTH_P 540
#define MOVE 541
#define NAME_P 542
#define NAMES 543
#define NATIONAL 544
#define NATURAL 545
#define NCHAR 546
#define NEW 547
#define NEXT 548
#define NO 549
#define NOCREATEDB 550
#define NOCREATEROLE 551
#define NOCREATEUSER 552
#define NOINHERIT 553
#define NOLOGIN_P 554
#define NONE 555
#define NOSUPERUSER 556
#define NOT 557
#define NOTHING 558
#define NOTIFY 559
#define NOTNULL 560
#define NOWAIT 561
#define NULL_P 562
#define NULLIF 563
#define NULLS_P 564
#define NUMERIC 565
#define OBJECT_P 566
#define OF 567
#define OFF 568
#define OFFSET 569
#define OIDS 570
#define OLD 571
#define ON 572
#define ONLY 573
#define OPERATOR 574
#define OPTION 575
#define OPTIONS 576
#define OR 577
#define ORDER 578
#define OUT_P 579
#define OUTER_P 580
#define OVER 581
#define OVERLAPS 582
#define OVERLAY 583
#define OWNED 584
#define OWNER 585
#define PARSER 586
#define PARTIAL 587
#define PARTITION 588
#define PASSWORD 589
#define PLACING 590
#define PLANS 591
#define POSITION 592
#define PRECEDING 593
#define PRECISION 594
#define PRESERVE 595
#define PREPARE 596
#define PREPARED 597
#define PRIMARY 598
#define PRIOR 599
#define PRIVILEGES 600
#define PROCEDURAL 601
#define PROCEDURE 602
#define QUOTE 603
#define RANGE 604
#define READ 605
#define REAL 606
#define REASSIGN 607
#define RECHECK 608
#define RECURSIVE 609
#define REFERENCES 610
#define REINDEX 611
#define RELATIVE_P 612
#define RELEASE 613
#define RENAME 614
#define REPEATABLE 615
#define REPLACE 616
#define REPLICA 617
#define RESET 618
#define RESTART 619
#define RESTRICT 620
#define RETURNING 621
#define RETURNS 622
#define REVOKE 623
#define RIGHT 624
#define ROLE 625
#define ROLLBACK 626
#define ROW 627
#define ROWS 628
#define RULE 629
#define SAVEPOINT 630
#define SCHEMA 631
#define SCROLL 632
#define SEARCH 633
#define SECOND_P 634
#define SECURITY 635
#define SELECT 636
#define SEQUENCE 637
#define SERIALIZABLE 638
#define SERVER 639
#define SESSION 640
#define SESSION_USER 641
#define SET 642
#define SETOF 643
#define SHARE 644
#define SHOW 645
#define SIMILAR 646
#define SIMPLE 647
#define SMALLINT 648
#define SOME 649
#define STABLE 650
#define STANDALONE_P 651
#define START 652
#define STATEMENT 653
#define STATISTICS 654
#define STDIN 655
#define STDOUT 656
#define STORAGE 657
#define STRICT_P 658
#define STRIP_P 659
#define SUBSTRING 660
#define SUPERUSER_P 661
#define SYMMETRIC 662
#define SYSID 663
#define SYSTEM_P 664
#define TABLE 665
#define TABLESPACE 666
#define TEMP 667
#define TEMPLATE 668
#define TEMPORARY 669
#define TEXT_P 670
#define THEN 671
#define TIME 672
#define TIMESTAMP 673
#define TO 674
#define TRAILING 675
#define TRANSACTION 676
#define TREAT 677
#define TRIGGER 678
#define TRIM 679
#define TRUE_P 680
#define TRUNCATE 681
#define TRUSTED 682
#define TYPE_P 683
#define UNBOUNDED 684
#define UNCOMMITTED 685
#define UNENCRYPTED 686
#define UNION 687
#define UNIQUE 688
#define UNKNOWN 689
#define UNLISTEN 690
#define UNTIL 691
#define UPDATE 692
#define USER 693
#define USING 694
#define VACUUM 695
#define VALID 696
#define VALIDATOR 697
#define VALUE_P 698
#define VALUES 699
#define VARCHAR 700
#define VARIADIC 701
#define VARYING 702
#define VERBOSE 703
#define VERSION_P 704
#define VIEW 705
#define VOLATILE 706
#define WHEN 707
#define WHERE 708
#define WHITESPACE_P 709
#define WINDOW 710
#define WITH 711
#define WITHOUT 712
#define WORK 713
#define WRAPPER 714
#define WRITE 715
#define XML_P 716
#define XMLATTRIBUTES 717
#define XMLCONCAT 718
#define XMLELEMENT 719
#define XMLFOREST 720
#define XMLPARSE 721
#define XMLPI 722
#define XMLROOT 723
#define XMLSERIALIZE 724
#define YEAR_P 725
#define YES_P 726
#define ZONE 727
#define NULLS_FIRST 728
#define NULLS_LAST 729
#define WITH_TIME 730
#define IDENT 731
#define FCONST 732
#define SCONST 733
#define BCONST 734
#define XCONST 735
#define Op 736
#define ICONST 737
#define PARAM 738
#define POSTFIXOP 739
#define UMINUS 740




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 387 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1447 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1471 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   85353

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  617
/* YYNRULES -- Number of rules. */
#define YYNRULES  2435
/* YYNRULES -- Number of states. */
#define YYNSTATES  4234

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1612,  1614,  1616,  1618,  1622,  1623,  1625,  1626,  1628,
    1630,  1632,  1636,  1637,  1639,  1641,  1643,  1645,  1647,  1649,
    1652,  1653,  1655,  1658,  1660,  1663,  1664,  1667,  1669,  1672,
    1675,  1682,  1691,  1700,  1705,  1711,  1716,  1721,  1726,  1730,
    1738,  1747,  1754,  1761,  1768,  1775,  1779,  1781,  1785,  1789,
    1791,  1793,  1795,  1797,  1799,  1801,  1805,  1809,  1813,  1815,
    1819,  1823,  1825,  1829,  1843,  1845,  1849,  1854,  1860,  1865,
    1873,  1876,  1878,  1879,  1882,  1883,  1885,  1886,  1893,  1902,
    1911,  1913,  1917,  1923,  1929,  1937,  1947,  1955,  1965,  1971,
    1978,  1985,  1990,  1992,  1994,  1996,  1998,  2000,  2002,  2004,
    2006,  2010,  2014,  2018,  2022,  2024,  2028,  2030,  2033,  2036,
    2040,  2046,  2049,  2052,  2053,  2060,  2068,  2076,  2084,  2093,
    2102,  2109,  2118,  2128,  2138,  2146,  2157,  2165,  2174,  2183,
    2192,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2223,  2225,  2227,  2229,  2234,  2237,  2242,  2245,
    2251,  2256,  2261,  2265,  2269,  2273,  2275,  2277,  2279,  2281,
    2284,  2287,  2289,  2291,  2293,  2296,  2299,  2301,  2304,  2307,
    2309,  2311,  2319,  2327,  2338,  2340,  2342,  2345,  2350,  2356,
    2358,  2362,  2365,  2368,  2371,  2374,  2376,  2379,  2382,  2387,
    2391,  2394,  2397,  2400,  2403,  2406,  2408,  2412,  2414,  2417,
    2421,  2422,  2424,  2428,  2431,  2438,  2445,  2455,  2459,  2460,
    2464,  2465,  2479,  2494,  2496,  2497,  2500,  2501,  2503,  2507,
    2512,  2517,  2524,  2526,  2529,  2530,  2532,  2534,  2535,  2537,
    2539,  2540,  2550,  2563,  2571,  2574,  2575,  2579,  2582,  2584,
    2588,  2592,  2595,  2597,  2601,  2605,  2609,  2612,  2615,  2617,
    2619,  2621,  2623,  2626,  2628,  2630,  2632,  2634,  2639,  2645,
    2647,  2651,  2655,  2657,  2660,  2665,  2671,  2673,  2675,  2677,
    2679,  2683,  2687,  2690,  2693,  2696,  2699,  2701,  2704,  2707,
    2709,  2711,  2713,  2717,  2720,  2721,  2724,  2726,  2730,  2736,
    2738,  2741,  2743,  2744,  2750,  2758,  2764,  2772,  2778,  2786,
    2790,  2796,  2802,  2808,  2810,  2814,  2826,  2837,  2848,  2851,
    2854,  2855,  2865,  2868,  2869,  2874,  2879,  2884,  2886,  2888,
    2890,  2891,  2899,  2906,  2913,  2920,  2927,  2935,  2945,  2955,
    2962,  2969,  2976,  2983,  2990,  2999,  3008,  3015,  3022,  3029,
    3038,  3047,  3056,  3065,  3072,  3074,  3075,  3078,  3079,  3087,
    3094,  3101,  3108,  3115,  3122,  3129,  3137,  3144,  3151,  3158,
    3165,  3173,  3181,  3191,  3201,  3208,  3215,  3222,  3231,  3240,
    3249,  3256,  3258,  3260,  3264,  3268,  3270,  3272,  3274,  3276,
    3278,  3280,  3282,  3283,  3285,  3287,  3289,  3291,  3293,  3295,
    3296,  3303,  3312,  3315,  3318,  3321,  3324,  3327,  3331,  3335,
    3338,  3341,  3344,  3347,  3351,  3354,  3360,  3365,  3369,  3373,
    3377,  3379,  3381,  3382,  3386,  3389,  3392,  3394,  3398,  3401,
    3403,  3404,  3413,  3424,  3428,  3433,  3438,  3439,  3442,  3448,
    3451,  3452,  3456,  3460,  3464,  3468,  3472,  3476,  3480,  3484,
    3488,  3492,  3496,  3500,  3504,  3509,  3513,  3517,  3519,  3520,
    3526,  3533,  3538,  3541,  3542,  3547,  3551,  3557,  3564,  3569,
    3576,  3583,  3589,  3597,  3599,  3600,  3607,  3619,  3631,  3643,
    3657,  3667,  3679,  3690,  3695,  3698,  3704,  3707,  3708,  3713,
    3719,  3725,  3728,  3733,  3735,  3737,  3739,  3740,  3742,  3743,
    3745,  3746,  3750,  3751,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3773,  3779,  3784,  3788,  3789,  3791,  3793,
    3795,  3797,  3802,  3811,  3815,  3816,  3822,  3824,  3829,  3832,
    3834,  3838,  3841,  3844,  3845,  3852,  3855,  3856,  3862,  3866,
    3867,  3870,  3873,  3876,  3880,  3882,  3886,  3888,  3891,  3893,
    3894,  3902,  3904,  3908,  3910,  3912,  3916,  3922,  3925,  3927,
    3931,  3939,  3940,  3944,  3947,  3950,  3953,  3954,  3957,  3960,
    3962,  3964,  3968,  3972,  3974,  3977,  3982,  3987,  3990,  3994,
    4000,  4006,  4008,  4010,  4020,  4022,  4025,  4030,  4035,  4040,
    4043,  4047,  4049,  4053,  4058,  4061,  4063,  4064,  4068,  4072,
    4077,  4082,  4087,  4092,  4095,  4097,  4099,  4100,  4102,  4104,
    4105,  4107,  4113,  4115,  4116,  4118,  4119,  4123,  4125,  4129,
    4134,  4138,  4143,  4148,  4151,  4154,  4159,  4163,  4169,  4178,
    4180,  4181,  4183,  4185,  4187,  4191,  4192,  4194,  4196,  4198,
    4200,  4202,  4204,  4208,  4209,  4212,  4213,  4215,  4219,  4221,
    4222,  4224,  4227,  4232,  4237,  4240,  4241,  4244,  4248,  4251,
    4252,  4254,  4258,  4260,  4263,  4265,  4268,  4274,  4281,  4287,
    4289,  4292,  4294,  4299,  4303,  4308,  4314,  4319,  4325,  4330,
    4336,  4339,  4344,  4346,  4349,  4352,  4355,  4357,  4359,  4360,
    4365,  4368,  4370,  4373,  4376,  4381,  4383,  4387,  4389,  4392,
    4396,  4398,  4401,  4402,  4405,  4410,  4415,  4416,  4418,  4422,
    4425,  4428,  4432,  4438,  4445,  4448,  4452,  4456,  4461,  4462,
    4464,  4466,  4468,  4470,  4472,  4475,  4481,  4483,  4485,  4487,
    4489,  4492,  4496,  4500,  4501,  4503,  4505,  4507,  4509,  4511,
    4514,  4517,  4520,  4523,  4526,  4528,  4532,  4533,  4535,  4537,
    4539,  4541,  4547,  4550,  4552,  4554,  4556,  4558,  4564,  4567,
    4570,  4573,  4575,  4579,  4583,  4586,  4588,  4589,  4593,  4594,
    4600,  4603,  4609,  4612,  4614,  4617,  4621,  4622,  4624,  4626,
    4628,  4630,  4632,  4634,  4638,  4642,  4646,  4650,  4654,  4658,
    4662,  4663,  4665,  4670,  4672,  4676,  4682,  4685,  4688,  4692,
    4696,  4700,  4704,  4708,  4712,  4716,  4720,  4724,  4728,  4731,
    4734,  4738,  4742,  4745,  4749,  4755,  4760,  4767,  4771,  4777,
    4782,  4789,  4794,  4801,  4807,  4815,  4819,  4822,  4827,  4830,
    4834,  4838,  4843,  4847,  4852,  4856,  4861,  4867,  4874,  4881,
    4889,  4896,  4904,  4911,  4919,  4923,  4928,  4933,  4940,  4943,
    4947,  4952,  4954,  4958,  4961,  4964,  4968,  4972,  4976,  4980,
    4984,  4988,  4992,  4996,  5000,  5004,  5007,  5010,  5016,  5023,
    5030,  5038,  5042,  5047,  5049,  5051,  5054,  5059,  5061,  5063,
    5065,  5068,  5071,  5074,  5076,  5081,  5087,  5094,  5103,  5110,
    5117,  5123,  5125,  5127,  5132,  5134,  5139,  5141,  5146,  5148,
    5153,  5155,  5157,  5159,  5161,  5163,  5165,  5172,  5177,  5182,
    5187,  5192,  5199,  5205,  5211,  5217,  5222,  5229,  5234,  5239,
    5244,  5249,  5255,  5263,  5271,  5281,  5286,  5293,  5299,  5307,
    5315,  5323,  5326,  5330,  5334,  5338,  5343,  5344,  5349,  5351,
    5355,  5359,  5361,  5363,  5365,  5368,  5371,  5372,  5375,  5376,
    5378,  5382,  5386,  5389,  5392,  5393,  5400,  5402,  5403,  5407,
    5408,  5411,  5414,  5415,  5417,  5422,  5425,  5428,  5431,  5436,
    5440,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5464,  5466,  5468,  5470,  5472,  5474,  5476,  5481,  5483,  5488,
    5490,  5495,  5497,  5500,  5502,  5505,  5507,  5511,  5513,  5517,
    5521,  5525,  5528,  5530,  5534,  5538,  5539,  5541,  5543,  5545,
    5547,  5549,  5551,  5553,  5555,  5560,  5564,  5567,  5571,  5572,
    5576,  5580,  5583,  5586,  5588,  5589,  5592,  5595,  5599,  5602,
    5604,  5606,  5610,  5616,  5618,  5621,  5626,  5629,  5630,  5632,
    5633,  5635,  5638,  5641,  5644,  5648,  5654,  5656,  5659,  5660,
    5663,  5665,  5666,  5668,  5670,  5672,  5676,  5680,  5682,  5686,
    5690,  5693,  5695,  5697,  5699,  5701,  5703,  5707,  5709,  5712,
    5714,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,  5735,
    5737,  5739,  5741,  5743,  5745,  5748,  5754,  5757,  5761,  5768,
    5770,  5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5789,
    5792,  5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,
    5812,  5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5852,  5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,
    5872,  5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,
    5892,  5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,  5910,
    5912,  5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,  5930,
    5932,  5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,  5950,
    5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,  5970,
    5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,  5990,
    5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,  6010,
    6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,
    6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,  6050,
    6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,  6070,
    6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,  6090,
    6092,  6094,  6096,  6098,  6100,  6102,  6104,  6105,  6108,  6113,
    6117,  6120,  6122,  6124,  6126,  6128,  6130,  6131,  6140,  6141,
    6156,  6159,  6165,  6169,  6172,  6175,  6179,  6187,  6189,  6191,
    6193,  6194,  6197,  6200,  6202,  6203,  6205,  6209,  6211,  6214,
    6215,  6218,  6219,  6222,  6223,  6225,  6229,  6234,  6238,  6240,
    6242,  6244,  6246,  6249,  6250,  6253,  6258,  6259,  6262,  6265,
    6268,  6270,  6272,  6280,  6284,  6286,  6288,  6290,  6292,  6295,
    6296,  6298,  6302,  6306,  6310,  6314,  6315,  6320,  6326,  6332,
    6333,  6335,  6337,  6339,  6341,  6344,  6347,  6350,  6352,  6355,
    6356,  6364,  6365,  6371,  6372,  6377,  6380,  6383,  6384,  6387,
    6389,  6391,  6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,
    6409,  6415,  6418,  6420,  6424,  6427,  6430,  6434,  6435,  6441,
    6443,  6444,  6450,  6453,  6456,  6458,  6460,  6462,  6465,  6468,
    6472,  6474,  6477,  6480,  6484,  6488,  6493,  6496,  6498,  6501,
    6503,  6505,  6508,  6511,  6515,  6517,  6519,  6521,  6523,  6524,
    6526,  6530,  6536,  6537,  6540,  6541,  6543,  6546,  6550,  6553,
    6555,  6557,  6559,  6560,  6562,  6564,  6566,  6568,  6570,  6573,
    6576,  6580,  6581,  6583,  6586,  6588,  6593,  6598,  6599,  6601,
    6603,  6607,  6609,  6611,  6613,  6615,  6618,  6621,  6623,  6626,
    6629,  6631,  6633,  6635,  6640,  6645,  6650,  6652,  6653,  6657,
    6661,  6666,  6668,  6672,  6676,  6681,  6683,  6687,  6691,  6693,
    6695,  6697,  6704,  6706,  6710,  6714,  6721,  6723,  6727,  6731,
    6733,  6735,  6738,  6741,  6743,  6745,  6747,  6749,  6751,  6753,
    6755,  6757,  6759,  6761,  6763,  6765,  6767,  6769,  6771,  6773,
    6778,  6783,  6785,  6787,  6792,  6797,  6801,  6802,  6810,  6812,
    6813,  6814,  6822,  6826,  6831,  6835,  6837,  6839,  6841,  6844,
    6848,  6854,  6857,  6863,  6866,  6868,  6870,  6872,  6874,  6876,
    6878,  6880,  6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,
    6898,  6900,  6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,
    6918,  6920,  6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,
    6938,  6940,  6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,
    6958,  6960,  6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,
    6978,  6980,  6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,
    6998,  7000,  7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,
    7018,  7020,  7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,
    7038,  7040,  7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,
    7058,  7060,  7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,
    7078,  7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,
    7098,  7100,  7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,
    7118,  7120,  7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,
    7138,  7140,  7142,  7144,  7146,  7148,  7150,  7152,  7154,  7156,
    7158,  7160,  7162,  7164,  7166,  7168,  7170,  7172,  7174,  7176,
    7178,  7180,  7182,  7184,  7186,  7188,  7190,  7192,  7194,  7196,
    7198,  7200,  7202,  7204,  7206,  7208,  7210,  7212,  7214,  7216,
    7218,  7220,  7222,  7224,  7226,  7228,  7230,  7232,  7234,  7236,
    7238,  7240,  7242,  7244,  7246,  7248,  7250,  7252,  7254,  7256,
    7258,  7260,  7262,  7264,  7266,  7268,  7270,  7272,  7274,  7276,
    7278,  7280,  7282,  7284,  7286,  7288,  7290,  7292,  7294,  7296,
    7298,  7300,  7302,  7304,  7306,  7308,  7310,  7312,  7314,  7316,
    7318,  7320,  7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,
    7338,  7340,  7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,
    7358,  7360,  7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,
    7378,  7380,  7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,
    7398,  7400,  7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,
    7418,  7420,  7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,
    7438,  7440,  7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,
    7458,  7460,  7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,
    7478,  7482,  7484,  7485,  7487,  7490,  7492,  7495,  7497,  7499,
    7502,  7505,  7507,  7509,  7511,  7513,  7515,  7517,  7519,  7521,
    7523,  7525,  7527,  7529,  7531,  7533,  7535,  7537,  7540,  7544,
    7546,  7549,  7551,  7555,  7557,  7561,  7563,  7565,  7567,  7569,
    7571,  7573,  7575,  7577,  7579,  7581,  7583,  7585,  7587,  7589,
    7591,  7593,  7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,
    7611,  7613,  7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,
    7631,  7633,  7635,  7637,  7639,  7641,  7643,  7645,  7647,  7649,
    7651,  7653,  7655,  7657,  7659,  7661,  7663,  7665,  7667,  7669,
    7671,  7673,  7675,  7677,  7679,  7681,  7683,  7686,  7690,  7693,
    7697,  7699,  7703,  7707,  7711,  7715,  7719,  7723,  7725,  7727,
    7728,  7731,  7734,  7736,  7738,  7741
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     506,     0,    -1,   974,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   976,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1118,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   978,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1055,    -1,   981,    -1,   998,
      -1,  1056,    -1,  1038,    -1,  1053,    -1,  1039,    -1,   999,
      -1,  1043,    -1,  1065,    -1,  1057,    -1,  1044,    -1,  1073,
      -1,  1075,    -1,  1068,    -1,  1060,    -1,  1076,    -1,  1079,
      -1,  1081,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1108,    -1,
     334,   307,    -1,   192,   334,  1108,    -1,   431,   334,  1108,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1108,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,   968,   525,    -1,
     968,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1108,    -1,   376,  1108,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1088,    -1,   529,
     499,   968,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1108,    -1,  1110,    -1,   892,  1108,
     894,    -1,   892,   497,   965,   498,  1108,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1108,    -1,   170,    -1,    -1,
     968,    -1,  1108,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1121,    -1,   390,   417,   472,  1121,    -1,   390,   421,   256,
     268,  1121,    -1,   390,   385,   104,  1121,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
     968,   548,    -1,    91,   748,   968,   187,   302,   307,    -1,
      91,   748,   968,   387,   302,   307,    -1,    91,   748,   968,
     387,   399,   967,    -1,    91,   748,   968,   387,   402,   968,
      -1,   187,   748,   968,   549,    -1,    91,   748,   968,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1089,   484,   657,    -1,  1089,    -1,  1089,   499,  1089,
     484,   657,    -1,  1089,   499,  1089,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1108,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1108,    -1,   307,   781,  1108,    -1,   152,    -1,   225,
      -1,   348,   781,  1108,    -1,   195,   781,  1108,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1108,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
     968,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
     968,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,   968,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1107,    -1,   489,  1107,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1108,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1108,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1089,    -1,  1108,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1108,    -1,    -1,   449,  1108,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   639,   322,   640,    -1,
     246,    -1,   175,    -1,   437,    -1,   426,    -1,   210,   642,
     643,    -1,    -1,   188,    -1,    -1,   372,    -1,   398,    -1,
     645,    -1,   644,   500,   645,    -1,    -1,   965,    -1,  1107,
      -1,  1108,    -1,  1106,    -1,   480,    -1,   968,    -1,   215,
     955,    -1,    -1,   648,    -1,   648,   649,    -1,   649,    -1,
     649,   648,    -1,    -1,   302,   172,    -1,   172,    -1,   241,
     231,    -1,   241,   173,    -1,   187,   423,   957,   317,   955,
     549,    -1,   187,   423,   229,   200,   957,   317,   955,   549,
      -1,   147,   100,   957,   126,   497,   896,   498,   647,    -1,
     187,   100,   957,   549,    -1,   147,    88,   963,   658,   654,
      -1,   147,    88,   963,   659,    -1,   147,   319,   739,   654,
      -1,   147,   428,   680,   654,    -1,   147,   428,   680,    -1,
     147,   428,   680,    98,   497,   870,   498,    -1,   147,   428,
     680,    98,   194,   497,   662,   498,    -1,   147,   415,   378,
     331,   680,   654,    -1,   147,   415,   378,   179,   680,   654,
      -1,   147,   415,   378,   413,   680,   654,    -1,   147,   415,
     378,   138,   680,   654,    -1,   497,   655,   498,    -1,   656,
      -1,   655,   500,   656,    -1,  1089,   484,   657,    -1,  1089,
      -1,   723,    -1,   972,    -1,   922,    -1,   604,    -1,  1108,
      -1,   497,   925,   498,    -1,   497,   490,   498,    -1,   497,
     660,   498,    -1,   661,    -1,   660,   500,   661,    -1,  1110,
     484,   657,    -1,  1108,    -1,   662,   500,  1108,    -1,   147,
     319,   128,   680,   666,   210,   428,   872,   439,   959,   667,
      98,   664,    -1,   665,    -1,   664,   500,   665,    -1,   319,
     965,   739,   668,    -1,   319,   965,   739,   738,   668,    -1,
     217,   965,   963,   715,    -1,   217,   965,   497,   925,   498,
     963,   715,    -1,   402,   872,    -1,   170,    -1,    -1,   205,
     680,    -1,    -1,   353,    -1,    -1,   147,   319,   205,   680,
     439,   959,    -1,    91,   319,   205,   680,   439,   959,    85,
     664,    -1,    91,   319,   205,   680,   439,   959,   187,   671,
      -1,   672,    -1,   671,   500,   672,    -1,   319,   965,   497,
     925,   498,    -1,   217,   965,   497,   925,   498,    -1,   187,
     319,   128,   680,   439,   959,   549,    -1,   187,   319,   128,
     229,   200,   680,   439,   959,   549,    -1,   187,   319,   205,
     680,   439,   959,   549,    -1,   187,   319,   205,   229,   200,
     680,   439,   959,   549,    -1,   187,   329,   114,   956,   549,
      -1,   352,   329,   114,   956,   419,   957,    -1,   187,   678,
     229,   200,   679,   549,    -1,   187,   678,   679,   549,    -1,
     410,    -1,   382,    -1,   450,    -1,   237,    -1,   428,    -1,
     185,    -1,   144,    -1,   376,    -1,   415,   378,   331,    -1,
     415,   378,   179,    -1,   415,   378,   413,    -1,   415,   378,
     138,    -1,   680,    -1,   679,   500,   680,    -1,   968,    -1,
     968,   681,    -1,   499,   960,    -1,   681,   499,   960,    -1,
     426,   833,   865,   683,   549,    -1,   143,   228,    -1,   364,
     228,    -1,    -1,   134,   317,   685,   680,   254,   686,    -1,
     134,   317,    88,   963,   658,   254,   686,    -1,   134,   317,
     217,   963,   715,   254,   686,    -1,   134,   317,   319,   739,
     738,   254,   686,    -1,   134,   317,   140,   957,   317,   680,
     254,   686,    -1,   134,   317,   374,   957,   317,   680,   254,
     686,    -1,   134,   317,   374,   957,   254,   686,    -1,   134,
     317,   423,   957,   317,   680,   254,   686,    -1,   134,   317,
     319,   128,   680,   439,   959,   254,   686,    -1,   134,   317,
     319,   205,   680,   439,   959,   254,   686,    -1,   134,   317,
     261,   311,   604,   254,   686,    -1,   134,   317,   120,   497,
     872,    98,   872,   498,   254,   686,    -1,   134,   317,   612,
     260,   680,   254,   686,    -1,   134,   317,   415,   378,   331,
     680,   254,   686,    -1,   134,   317,   415,   378,   179,   680,
     254,   686,    -1,   134,   317,   415,   378,   413,   680,   254,
     686,    -1,   134,   317,   415,   378,   138,   680,   254,   686,
      -1,   133,    -1,   164,    -1,   376,    -1,   237,    -1,   382,
      -1,   410,    -1,   185,    -1,   428,    -1,   450,    -1,   144,
      -1,   411,    -1,   370,    -1,  1108,    -1,   307,    -1,   206,
     688,   689,   957,    -1,   206,   957,    -1,   286,   688,   689,
     957,    -1,   286,   957,    -1,   206,   688,   689,   957,  1121,
      -1,   206,   688,   957,  1121,    -1,   206,   689,   957,  1121,
      -1,   206,   957,  1121,    -1,   206,   688,   957,    -1,   206,
     689,   957,    -1,   293,    -1,   344,    -1,   207,    -1,   262,
      -1,    82,   967,    -1,   357,   967,    -1,   967,    -1,    89,
      -1,   213,    -1,   213,   967,    -1,   213,    89,    -1,   105,
      -1,   105,   967,    -1,   105,    89,    -1,   215,    -1,   234,
      -1,   219,   692,   317,   695,   419,   696,   698,    -1,   368,
     692,   317,   695,   215,   696,   549,    -1,   368,   219,   320,
     210,   692,   317,   695,   215,   696,   549,    -1,   693,    -1,
      89,    -1,    89,   345,    -1,    89,   497,   581,   498,    -1,
      89,   345,   497,   581,   498,    -1,   694,    -1,   693,   500,
     694,    -1,   381,   580,    -1,   355,   580,    -1,   147,   580,
      -1,   968,   580,    -1,   954,    -1,   410,   954,    -1,   382,
     954,    -1,   212,   163,   459,   956,    -1,   212,   384,   956,
      -1,   217,   699,    -1,   164,   956,    -1,   260,   956,    -1,
     376,   956,    -1,   411,   956,    -1,   697,    -1,   696,   500,
     697,    -1,   966,    -1,   222,   966,    -1,   456,   219,   320,
      -1,    -1,   700,    -1,   699,   500,   700,    -1,   963,   715,
      -1,   219,   693,   419,   956,   703,   704,    -1,   368,   693,
     215,   956,   704,   549,    -1,   368,    86,   320,   210,   693,
     215,   956,   704,   549,    -1,   456,    86,   320,    -1,    -1,
     220,   114,   966,    -1,    -1,   147,   706,   237,   961,   317,
     955,   707,   497,   708,   498,   552,   591,   868,    -1,   147,
     706,   237,   137,   961,   317,   955,   707,   497,   708,   498,
     552,   591,   868,    -1,   433,    -1,    -1,   439,   959,    -1,
      -1,   709,    -1,   708,   500,   709,    -1,   968,   710,   711,
     712,    -1,   899,   710,   711,   712,    -1,   497,   896,   498,
     710,   711,   712,    -1,   680,    -1,   439,   680,    -1,    -1,
      99,    -1,   178,    -1,    -1,   473,    -1,   474,    -1,    -1,
     147,   714,   217,   963,   717,   367,   722,   725,   729,    -1,
     147,   714,   217,   963,   717,   367,   410,   497,   731,   498,
     725,   729,    -1,   147,   714,   217,   963,   717,   725,   729,
      -1,   322,   361,    -1,    -1,   497,   716,   498,    -1,   497,
     498,    -1,   719,    -1,   716,   500,   719,    -1,   497,   718,
     498,    -1,   497,   498,    -1,   724,    -1,   718,   500,   724,
      -1,   720,   721,   723,    -1,   721,   720,   723,    -1,   721,
     723,    -1,   720,   723,    -1,   723,    -1,   234,    -1,   324,
      -1,   243,    -1,   234,   324,    -1,   446,    -1,   969,    -1,
     723,    -1,   872,    -1,   969,   681,   492,   428,    -1,   388,
     969,   681,   492,   428,    -1,   719,    -1,   719,   170,   896,
      -1,   719,   484,   896,    -1,   727,    -1,   725,   727,    -1,
     116,   317,   307,   244,    -1,   367,   307,   317,   307,   244,
      -1,   403,    -1,   232,    -1,   395,    -1,   451,    -1,   202,
     380,   174,    -1,   202,   380,   253,    -1,   380,   174,    -1,
     380,   253,    -1,   146,   604,    -1,   373,   604,    -1,   538,
      -1,    98,   728,    -1,   260,   536,    -1,   455,    -1,   726,
      -1,  1108,    -1,  1108,   500,  1108,    -1,   456,   654,    -1,
      -1,   721,   723,    -1,   730,    -1,   731,   500,   730,    -1,
      91,   217,   700,   733,   734,    -1,   726,    -1,   733,   726,
      -1,   365,    -1,    -1,   187,   217,   963,   715,   549,    -1,
     187,   217,   229,   200,   963,   715,   549,    -1,   187,    88,
     963,   658,   549,    -1,   187,    88,   229,   200,   963,   658,
     549,    -1,   187,   319,   739,   738,   549,    -1,   187,   319,
     229,   200,   739,   738,   549,    -1,   497,   872,   498,    -1,
     497,   872,   500,   872,   498,    -1,   497,   300,   500,   872,
     498,    -1,   497,   872,   500,   300,   498,    -1,   919,    -1,
     968,   499,   739,    -1,   147,   120,   497,   872,    98,   872,
     498,   456,   217,   700,   741,    -1,   147,   120,   497,   872,
      98,   872,   498,   457,   217,   741,    -1,   147,   120,   497,
     872,    98,   872,   498,   456,   243,   741,    -1,    98,   233,
      -1,    98,   101,    -1,    -1,   187,   120,   743,   497,   872,
      98,   872,   498,   549,    -1,   229,   200,    -1,    -1,   356,
     745,   955,   746,    -1,   356,   409,   957,   746,    -1,   356,
     164,   957,   746,    -1,   237,    -1,   410,    -1,   211,    -1,
      -1,    91,    88,   963,   658,   359,   419,   957,    -1,    91,
     144,   680,   359,   419,   957,    -1,    91,   164,   958,   359,
     419,   958,    -1,    91,   217,   700,   359,   419,   957,    -1,
      91,   222,   966,   359,   419,   966,    -1,    91,   612,   260,
     957,   359,   419,   957,    -1,    91,   319,   128,   680,   439,
     959,   359,   419,   957,    -1,    91,   319,   205,   680,   439,
     959,   359,   419,   957,    -1,    91,   376,   957,   359,   419,
     957,    -1,    91,   410,   864,   359,   419,   957,    -1,    91,
     382,   955,   359,   419,   957,    -1,    91,   450,   955,   359,
     419,   957,    -1,    91,   237,   955,   359,   419,   957,    -1,
      91,   410,   864,   359,   748,   957,   419,   957,    -1,    91,
     423,   957,   317,   955,   359,   419,   957,    -1,    91,   370,
     966,   359,   419,   966,    -1,    91,   438,   966,   359,   419,
     966,    -1,    91,   411,   957,   359,   419,   957,    -1,    91,
     415,   378,   331,   680,   359,   419,   957,    -1,    91,   415,
     378,   179,   680,   359,   419,   957,    -1,    91,   415,   378,
     413,   680,   359,   419,   957,    -1,    91,   415,   378,   138,
     680,   359,   419,   957,    -1,    91,   428,   680,   359,   419,
     957,    -1,   133,    -1,    -1,   387,   163,    -1,    -1,    91,
      88,   963,   658,   387,   376,   957,    -1,    91,   185,   680,
     387,   376,   957,    -1,    91,   217,   700,   387,   376,   957,
      -1,    91,   410,   864,   387,   376,   957,    -1,    91,   382,
     955,   387,   376,   957,    -1,    91,   450,   955,   387,   376,
     957,    -1,    91,   428,   680,   387,   376,   957,    -1,    91,
      88,   963,   658,   330,   419,   966,    -1,    91,   144,   680,
     330,   419,   966,    -1,    91,   164,   958,   330,   419,   966,
      -1,    91,   185,   680,   330,   419,   966,    -1,    91,   217,
     700,   330,   419,   966,    -1,    91,   612,   260,   957,   330,
     419,   966,    -1,    91,   319,   739,   738,   330,   419,   966,
      -1,    91,   319,   128,   680,   439,   959,   330,   419,   966,
      -1,    91,   319,   205,   680,   439,   959,   330,   419,   966,
      -1,    91,   376,   957,   330,   419,   966,    -1,    91,   428,
     680,   330,   419,   966,    -1,    91,   411,   957,   330,   419,
     966,    -1,    91,   415,   378,   179,   680,   330,   419,   966,
      -1,    91,   415,   378,   138,   680,   330,   419,   966,    -1,
      91,   212,   163,   459,   957,   330,   419,   966,    -1,    91,
     384,   957,   330,   419,   966,    -1,   303,    -1,   754,    -1,
     497,   753,   498,    -1,   753,   501,   755,    -1,   755,    -1,
     823,    -1,   802,    -1,   813,    -1,   807,    -1,   759,    -1,
     754,    -1,    -1,   381,    -1,   437,    -1,   175,    -1,   246,
      -1,   247,    -1,    90,    -1,    -1,   187,   374,   957,   317,
     955,   549,    -1,   187,   374,   229,   200,   957,   317,   955,
     549,    -1,   304,   968,    -1,   271,   968,    -1,   435,   968,
      -1,   435,   490,    -1,    81,   763,    -1,   107,   763,   766,
      -1,   397,   421,   766,    -1,   135,   763,    -1,   193,   763,
      -1,   371,   763,    -1,   375,   968,    -1,   358,   375,   968,
      -1,   358,   968,    -1,   371,   763,   419,   375,   968,    -1,
     371,   763,   419,   968,    -1,   341,   421,  1108,    -1,   135,
     342,  1108,    -1,   371,   342,  1108,    -1,   458,    -1,   421,
      -1,    -1,   256,   268,   532,    -1,   350,   318,    -1,   350,
     460,    -1,   764,    -1,   765,   500,   764,    -1,   765,   764,
      -1,   765,    -1,    -1,   147,   566,   450,   955,   580,    98,
     823,   768,    -1,   147,   322,   361,   566,   450,   955,   580,
      98,   823,   768,    -1,   456,   126,   320,    -1,   456,   118,
     126,   320,    -1,   456,   273,   126,   320,    -1,    -1,   272,
     962,    -1,   147,   164,   958,   509,   771,    -1,   771,   772,
      -1,    -1,   411,   773,   957,    -1,   411,   773,   170,    -1,
     276,   773,  1108,    -1,   276,   773,   170,    -1,   413,   773,
     957,    -1,   413,   773,   170,    -1,   191,   773,  1108,    -1,
     191,   773,   965,    -1,   191,   773,   170,    -1,   263,   773,
    1108,    -1,   263,   773,   170,    -1,   264,   773,  1108,    -1,
     264,   773,   170,    -1,   139,   270,   773,   967,    -1,   330,
     773,   957,    -1,   330,   773,   170,    -1,   484,    -1,    -1,
      91,   164,   958,   509,   776,    -1,    91,   164,   958,   387,
     411,   957,    -1,    91,   164,   958,   538,    -1,   776,   777,
      -1,    -1,   139,   270,   773,   967,    -1,   187,   164,   958,
      -1,   187,   164,   229,   200,   958,    -1,   147,   185,   680,
     781,   872,   571,    -1,    91,   185,   680,   548,    -1,    91,
     185,   680,   187,   302,   307,    -1,    91,   185,   680,   387,
     302,   307,    -1,    91,   185,   680,    85,   578,    -1,    91,
     185,   680,   187,   140,   957,   549,    -1,    98,    -1,    -1,
      91,   415,   378,   179,   680,   654,    -1,    91,   415,   378,
     138,   680,    85,   279,   210,   956,   456,   679,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   456,   679,
      -1,    91,   415,   378,   138,   680,    91,   279,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,    91,   279,
     210,   956,   361,   680,   456,   680,    -1,    91,   415,   378,
     138,   680,   187,   279,   210,   956,    -1,    91,   415,   378,
     138,   680,   187,   279,   229,   200,   210,   956,    -1,   147,
     666,   144,   680,   210,  1108,   419,  1108,   215,   680,    -1,
     130,   790,   955,   786,    -1,   130,   790,    -1,   130,   790,
     961,   317,   955,    -1,   439,   961,    -1,    -1,   440,   791,
     792,   790,    -1,   440,   791,   792,   790,   955,    -1,   440,
     791,   792,   790,   788,    -1,   789,   790,    -1,   789,   790,
     955,   793,    -1,    94,    -1,    93,    -1,   448,    -1,    -1,
     216,    -1,    -1,   214,    -1,    -1,   497,   956,   498,    -1,
      -1,   201,   796,   790,   795,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   820,    -1,   976,    -1,   800,    -1,
     789,    -1,    -1,   341,   997,   798,    98,   799,    -1,   341,
     997,   215,  1042,    -1,   497,   925,   498,    -1,    -1,   823,
      -1,   802,    -1,   813,    -1,   807,    -1,   199,   997,   801,
    1120,    -1,   147,   566,   410,   593,    98,   199,   997,   801,
      -1,   497,   924,   498,    -1,    -1,   246,   252,   955,   803,
     806,    -1,   823,    -1,   497,   804,   498,   823,    -1,   170,
     444,    -1,   805,    -1,   804,   500,   805,    -1,   968,   946,
      -1,   366,   951,    -1,    -1,   175,   215,   866,   808,   869,
     806,    -1,   439,   857,    -1,    -1,   277,   833,   865,   810,
     812,    -1,   234,   811,   284,    -1,    -1,    83,   389,    -1,
     372,   389,    -1,   372,   198,    -1,   389,   437,   198,    -1,
     389,    -1,   389,   372,   198,    -1,   198,    -1,    83,   198,
      -1,   306,    -1,    -1,   437,   866,   387,   814,   856,   869,
     806,    -1,   815,    -1,   814,   500,   815,    -1,   816,    -1,
     817,    -1,   818,   484,   948,    -1,   497,   819,   498,   484,
     950,    -1,   968,   946,    -1,   818,    -1,   819,   500,   818,
      -1,   169,   957,   821,   161,   822,   210,   823,    -1,    -1,
     821,   294,   377,    -1,   821,   377,    -1,   821,   110,    -1,
     821,   245,    -1,    -1,   456,   226,    -1,   457,   226,    -1,
     825,    -1,   824,    -1,   497,   825,   498,    -1,   497,   824,
     498,    -1,   827,    -1,   826,   837,    -1,   826,   836,   850,
     841,    -1,   826,   836,   840,   851,    -1,   828,   826,    -1,
     828,   826,   837,    -1,   828,   826,   836,   850,   841,    -1,
     828,   826,   836,   840,   851,    -1,   827,    -1,   824,    -1,
     381,   835,   951,   831,   856,   868,   848,   849,   907,    -1,
     855,    -1,   410,   864,    -1,   826,   432,   834,   826,    -1,
     826,   250,   834,   826,    -1,   826,   196,   834,   826,    -1,
     456,   829,    -1,   456,   354,   829,    -1,   830,    -1,   829,
     500,   830,    -1,   957,   793,    98,   824,    -1,   252,   832,
      -1,  1121,    -1,    -1,   414,   833,   955,    -1,   412,   833,
     955,    -1,   273,   414,   833,   955,    -1,   273,   412,   833,
     955,    -1,   218,   414,   833,   955,    -1,   218,   412,   833,
     955,    -1,   410,   955,    -1,   955,    -1,   410,    -1,    -1,
      89,    -1,   182,    -1,    -1,   182,    -1,   182,   317,   497,
     924,   498,    -1,    89,    -1,    -1,   837,    -1,    -1,   323,
     114,   838,    -1,   839,    -1,   838,   500,   839,    -1,   896,
     439,   922,   712,    -1,   896,   711,   712,    -1,   270,   842,
     314,   844,    -1,   314,   844,   270,   842,    -1,   270,   842,
      -1,   314,   844,    -1,   270,   842,   500,   844,    -1,   314,
     845,   846,    -1,   206,   847,   843,   846,   318,    -1,   314,
     845,   846,   206,   847,   843,   846,   318,    -1,   840,    -1,
      -1,   896,    -1,    89,    -1,   967,    -1,   497,   896,   498,
      -1,    -1,   896,    -1,   898,    -1,   372,    -1,   373,    -1,
     207,    -1,   293,    -1,   222,   114,   924,    -1,    -1,   224,
     896,    -1,    -1,   852,    -1,   210,   350,   318,    -1,   850,
      -1,    -1,   853,    -1,   852,   853,    -1,   210,   437,   854,
     812,    -1,   210,   389,   854,   812,    -1,   312,   954,    -1,
      -1,   444,   950,    -1,   855,   500,   950,    -1,   215,   857,
      -1,    -1,   858,    -1,   857,   500,   858,    -1,   864,    -1,
     864,   860,    -1,   867,    -1,   867,   860,    -1,   867,    98,
     497,   870,   498,    -1,   867,    98,   968,   497,   870,   498,
      -1,   867,   968,   497,   870,   498,    -1,   824,    -1,   824,
     860,    -1,   859,    -1,   497,   859,   498,   860,    -1,   497,
     859,   498,    -1,   858,   151,   257,   858,    -1,   858,   861,
     257,   858,   863,    -1,   858,   257,   858,   863,    -1,   858,
     290,   861,   257,   858,    -1,   858,   290,   257,   858,    -1,
      98,   968,   497,   956,   498,    -1,    98,   968,    -1,   968,
     497,   956,   498,    -1,   968,    -1,   216,   862,    -1,   267,
     862,    -1,   369,   862,    -1,   242,    -1,   325,    -1,    -1,
     439,   497,   956,   498,    -1,   317,   896,    -1,   955,    -1,
     955,   490,    -1,   318,   955,    -1,   318,   497,   955,   498,
      -1,   864,    -1,   865,   500,   864,    -1,   864,    -1,   864,
     968,    -1,   864,    98,   968,    -1,   899,    -1,   453,   896,
      -1,    -1,   453,   896,    -1,   453,   153,   312,   957,    -1,
     453,   153,   312,  1105,    -1,    -1,   871,    -1,   870,   500,
     871,    -1,   968,   872,    -1,   874,   873,    -1,   388,   874,
     873,    -1,   874,    97,   495,   965,   496,    -1,   388,   874,
      97,   495,   965,   496,    -1,   874,    97,    -1,   388,   874,
      97,    -1,   873,   495,   496,    -1,   873,   495,  1119,   496,
      -1,    -1,   876,    -1,   878,    -1,   880,    -1,   884,    -1,
     891,    -1,   892,   894,    -1,   892,   497,   965,   498,   894,
      -1,   878,    -1,   881,    -1,   885,    -1,   891,    -1,   969,
     877,    -1,   969,   681,   877,    -1,   497,   924,   498,    -1,
      -1,   248,    -1,   249,    -1,   393,    -1,   109,    -1,   351,
      -1,   208,   879,    -1,   186,   339,    -1,   168,   877,    -1,
     167,   877,    -1,   310,   877,    -1,   112,    -1,   497,   965,
     498,    -1,    -1,   882,    -1,   883,    -1,   882,    -1,   883,
      -1,   111,   889,   497,   924,   498,    -1,   111,   889,    -1,
     886,    -1,   887,    -1,   886,    -1,   887,    -1,   888,   497,
     965,   498,   890,    -1,   888,   890,    -1,   124,   889,    -1,
     123,   889,    -1,   445,    -1,   289,   124,   889,    -1,   289,
     123,   889,    -1,   291,   889,    -1,   447,    -1,    -1,   124,
     387,   968,    -1,    -1,   418,   497,   965,   498,   893,    -1,
     418,   893,    -1,   417,   497,   965,   498,   893,    -1,   417,
     893,    -1,   251,    -1,   475,   472,    -1,   457,   417,   472,
      -1,    -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,
     282,    -1,   895,    -1,   470,   419,   285,    -1,   165,   419,
     227,    -1,   165,   419,   282,    -1,   165,   419,   895,    -1,
     227,   419,   282,    -1,   227,   419,   895,    -1,   282,   419,
     895,    -1,    -1,   379,    -1,   379,   497,   965,   498,    -1,
     898,    -1,   896,    71,   872,    -1,   896,   103,   417,   472,
     896,    -1,   488,   896,    -1,   489,   896,    -1,   896,   488,
     896,    -1,   896,   489,   896,    -1,   896,   490,   896,    -1,
     896,   491,   896,    -1,   896,   492,   896,    -1,   896,   493,
     896,    -1,   896,   485,   896,    -1,   896,   486,   896,    -1,
     896,   484,   896,    -1,   896,   921,   896,    -1,   921,   896,
      -1,   896,   921,    -1,   896,    95,   896,    -1,   896,   322,
     896,    -1,   302,   896,    -1,   896,   269,   896,    -1,   896,
     269,   896,   195,   896,    -1,   896,   302,   269,   896,    -1,
     896,   302,   269,   896,   195,   896,    -1,   896,   230,   896,
      -1,   896,   230,   896,   195,   896,    -1,   896,   302,   230,
     896,    -1,   896,   302,   230,   896,   195,   896,    -1,   896,
     391,   419,   896,    -1,   896,   391,   419,   896,   195,   896,
      -1,   896,   302,   391,   419,   896,    -1,   896,   302,   391,
     419,   896,   195,   896,    -1,   896,   254,   307,    -1,   896,
     255,    -1,   896,   254,   302,   307,    -1,   896,   305,    -1,
     917,   327,   917,    -1,   896,   254,   425,    -1,   896,   254,
     302,   425,    -1,   896,   254,   204,    -1,   896,   254,   302,
     204,    -1,   896,   254,   434,    -1,   896,   254,   302,   434,
      -1,   896,   254,   182,   215,   896,    -1,   896,   254,   302,
     182,   215,   896,    -1,   896,   254,   312,   497,   925,   498,
      -1,   896,   254,   302,   312,   497,   925,   498,    -1,   896,
     108,   947,   897,    95,   897,    -1,   896,   302,   108,   947,
     897,    95,   897,    -1,   896,   108,   407,   897,    95,   897,
      -1,   896,   302,   108,   407,   897,    95,   897,    -1,   896,
     234,   937,    -1,   896,   302,   234,   937,    -1,   896,   923,
     918,   824,    -1,   896,   923,   918,   497,   896,   498,    -1,
     433,   824,    -1,   896,   254,   184,    -1,   896,   254,   302,
     184,    -1,   898,    -1,   897,    71,   872,    -1,   488,   897,
      -1,   489,   897,    -1,   897,   488,   897,    -1,   897,   489,
     897,    -1,   897,   490,   897,    -1,   897,   491,   897,    -1,
     897,   492,   897,    -1,   897,   493,   897,    -1,   897,   485,
     897,    -1,   897,   486,   897,    -1,   897,   484,   897,    -1,
     897,   921,   897,    -1,   921,   897,    -1,   897,   921,    -1,
     897,   254,   182,   215,   897,    -1,   897,   254,   302,   182,
     215,   897,    -1,   897,   254,   312,   497,   925,   498,    -1,
     897,   254,   302,   312,   497,   925,   498,    -1,   897,   254,
     184,    -1,   897,   254,   302,   184,    -1,   943,    -1,   964,
      -1,  1105,   946,    -1,   497,   896,   498,   946,    -1,   938,
      -1,   899,    -1,   824,    -1,   200,   824,    -1,    97,   824,
      -1,    97,   926,    -1,   917,    -1,   963,   497,   498,   910,
      -1,   963,   497,   924,   498,   910,    -1,   963,   497,   446,
     896,   498,   910,    -1,   963,   497,   924,   500,   446,   896,
     498,   910,    -1,   963,   497,    89,   924,   498,   910,    -1,
     963,   497,   182,   924,   498,   910,    -1,   963,   497,   490,
     498,   910,    -1,   155,    -1,   158,    -1,   158,   497,   965,
     498,    -1,   159,    -1,   159,   497,   965,   498,    -1,   274,
      -1,   274,   497,   965,   498,    -1,   275,    -1,   275,   497,
     965,   498,    -1,   156,    -1,   160,    -1,   386,    -1,   438,
      -1,   154,    -1,   157,    -1,   120,   497,   896,    98,   872,
     498,    -1,   203,   497,   928,   498,    -1,   328,   497,   930,
     498,    -1,   337,   497,   932,   498,    -1,   405,   497,   933,
     498,    -1,   422,   497,   896,    98,   872,   498,    -1,   424,
     497,   113,   936,   498,    -1,   424,   497,   265,   936,   498,
      -1,   424,   497,   420,   936,   498,    -1,   424,   497,   936,
     498,    -1,   308,   497,   896,   500,   896,   498,    -1,   131,
     497,   924,   498,    -1,   221,   497,   924,   498,    -1,   266,
     497,   924,   498,    -1,   463,   497,   924,   498,    -1,   464,
     497,   287,  1089,   498,    -1,   464,   497,   287,  1089,   500,
     902,   498,    -1,   464,   497,   287,  1089,   500,   924,   498,
      -1,   464,   497,   287,  1089,   500,   902,   500,   924,   498,
      -1,   465,   497,   903,   498,    -1,   466,   497,   905,   896,
     906,   498,    -1,   467,   497,   287,  1089,   498,    -1,   467,
     497,   287,  1089,   500,   896,   498,    -1,   468,   497,   896,
     500,   900,   901,   498,    -1,   469,   497,   905,   896,    98,
     874,   498,    -1,   449,   896,    -1,   449,   294,   443,    -1,
     500,   396,   471,    -1,   500,   396,   294,    -1,   500,   396,
     294,   443,    -1,    -1,   462,   497,   903,   498,    -1,   904,
      -1,   903,   500,   904,    -1,   896,    98,  1089,    -1,   896,
      -1,   184,    -1,   142,    -1,   340,   454,    -1,   404,   454,
      -1,    -1,   455,   908,    -1,    -1,   909,    -1,   908,   500,
     909,    -1,   968,    98,   911,    -1,   326,   911,    -1,   326,
     968,    -1,    -1,   497,   912,   913,   836,   914,   498,    -1,
     968,    -1,    -1,   333,   114,   924,    -1,    -1,   349,   915,
      -1,   373,   915,    -1,    -1,   916,    -1,   108,   916,    95,
     916,    -1,   429,   338,    -1,   429,   209,    -1,   153,   372,
      -1,   372,   497,   924,   498,    -1,   372,   497,   498,    -1,
     497,   924,   500,   896,   498,    -1,    96,    -1,   394,    -1,
      89,    -1,   481,    -1,   920,    -1,   488,    -1,   489,    -1,
     490,    -1,   491,    -1,   492,    -1,   493,    -1,   485,    -1,
     486,    -1,   484,    -1,   481,    -1,   319,   497,   739,   498,
      -1,   919,    -1,   319,   497,   739,   498,    -1,   919,    -1,
     319,   497,   739,   498,    -1,   269,    -1,   302,   269,    -1,
     230,    -1,   302,   230,    -1,   896,    -1,   924,   500,   896,
      -1,   872,    -1,   925,   500,   872,    -1,   495,   924,   496,
      -1,   495,   927,   496,    -1,   495,   496,    -1,   926,    -1,
     927,   500,   926,    -1,   929,   215,   896,    -1,    -1,  1110,
      -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,   282,
      -1,   379,    -1,  1108,    -1,   896,   931,   934,   935,    -1,
     896,   931,   934,    -1,   335,   896,    -1,   897,   234,   897,
      -1,    -1,   896,   934,   935,    -1,   896,   935,   934,    -1,
     896,   934,    -1,   896,   935,    -1,   924,    -1,    -1,   215,
     896,    -1,   210,   896,    -1,   896,   215,   924,    -1,   215,
     924,    -1,   924,    -1,   824,    -1,   497,   924,   498,    -1,
     119,   942,   939,   941,   193,    -1,   940,    -1,   939,   940,
      -1,   452,   896,   416,   896,    -1,   189,   896,    -1,    -1,
     896,    -1,    -1,   953,    -1,   953,   945,    -1,   499,   960,
      -1,   499,   490,    -1,   495,   896,   496,    -1,   495,   896,
     502,   896,   496,    -1,   944,    -1,   945,   944,    -1,    -1,
     946,   944,    -1,   102,    -1,    -1,   896,    -1,   170,    -1,
     948,    -1,   949,   500,   948,    -1,   497,   949,   498,    -1,
     952,    -1,   951,   500,   952,    -1,   896,    98,  1089,    -1,
     896,  1110,    -1,   896,    -1,   490,    -1,   973,    -1,   968,
      -1,   955,    -1,   954,   500,   955,    -1,   953,    -1,   953,
     945,    -1,   957,    -1,   956,   500,   957,    -1,   968,    -1,
     968,    -1,   968,    -1,  1089,    -1,   968,    -1,  1108,    -1,
     969,    -1,   953,   945,    -1,   965,    -1,  1107,    -1,  1108,
      -1,  1106,    -1,   480,    -1,   963,  1108,    -1,   963,   497,
     924,   498,  1108,    -1,   875,  1108,    -1,   892,  1108,   894,
      -1,   892,   497,   965,   498,  1108,   894,    -1,   425,    -1,
     204,    -1,   307,    -1,  1102,    -1,  1101,    -1,   482,    -1,
     968,    -1,   965,    -1,  1102,    -1,   488,   965,    -1,   489,
     965,    -1,  1110,    -1,  1093,    -1,   970,    -1,  1083,    -1,
    1092,    -1,   123,    -1,   444,    -1,  1110,    -1,  1093,    -1,
     971,    -1,  1083,    -1,  1086,    -1,  1092,    -1,   109,    -1,
     111,    -1,   112,    -1,   124,    -1,   131,    -1,   167,    -1,
     168,    -1,   200,    -1,   203,    -1,   208,    -1,   221,    -1,
     243,    -1,   249,    -1,   251,    -1,   266,    -1,   289,    -1,
     291,    -1,   300,    -1,   308,    -1,   310,    -1,   324,    -1,
     328,    -1,   337,    -1,   339,    -1,   351,    -1,   372,    -1,
     388,    -1,   393,    -1,   405,    -1,   417,    -1,   418,    -1,
     422,    -1,   424,    -1,   445,    -1,   462,    -1,   463,    -1,
     464,    -1,   465,    -1,   466,    -1,   467,    -1,   468,    -1,
     469,    -1,   104,    -1,   108,    -1,   110,    -1,   151,    -1,
     157,    -1,   214,    -1,   216,    -1,   230,    -1,   242,    -1,
     254,    -1,   255,    -1,   257,    -1,   267,    -1,   269,    -1,
     290,    -1,   305,    -1,   325,    -1,   326,    -1,   327,    -1,
     369,    -1,   391,    -1,   448,    -1,    89,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
      99,    -1,   102,    -1,   113,    -1,   119,    -1,   120,    -1,
     126,    -1,   132,    -1,   133,    -1,   140,    -1,   147,    -1,
     154,    -1,   155,    -1,   156,    -1,   158,    -1,   159,    -1,
     160,    -1,   170,    -1,   172,    -1,   178,    -1,   182,    -1,
     183,    -1,   189,    -1,   193,    -1,   196,    -1,   204,    -1,
     206,    -1,   210,    -1,   212,    -1,   215,    -1,   219,    -1,
     222,    -1,   224,    -1,   234,    -1,   241,    -1,   250,    -1,
     252,    -1,   265,    -1,   270,    -1,   274,    -1,   275,    -1,
     292,    -1,   302,    -1,   307,    -1,   313,    -1,   314,    -1,
     316,    -1,   317,    -1,   318,    -1,   322,    -1,   323,    -1,
     335,    -1,   343,    -1,   355,    -1,   366,    -1,   381,    -1,
     386,    -1,   394,    -1,   407,    -1,   410,    -1,   416,    -1,
     420,    -1,   425,    -1,   433,    -1,   438,    -1,   439,    -1,
     446,    -1,   452,    -1,   453,    -1,   455,    -1,   456,    -1,
     316,    -1,   292,    -1,    -1,   974,   975,    -1,  1098,   980,
     507,   501,    -1,  1098,   507,   501,    -1,  1098,  1000,    -1,
    1005,    -1,  1116,    -1,    74,    -1,   503,    -1,   504,    -1,
      -1,   147,   566,   410,   593,    98,   977,   823,   597,    -1,
      -1,   147,   714,   374,   957,    98,   979,   317,   756,   419,
     955,   868,   183,   757,   752,    -1,   103,  1041,    -1,     9,
     419,   982,   989,   990,    -1,     9,   419,   170,    -1,     9,
     991,    -1,   164,   982,    -1,   983,   986,   988,    -1,   984,
     502,   985,   988,   491,   983,   994,    -1,   993,    -1,  1108,
      -1,   958,    -1,    -1,  1110,  1104,    -1,   481,   987,    -1,
     985,    -1,    -1,   968,    -1,   968,   499,   987,    -1,    75,
      -1,   502,   965,    -1,    -1,    98,  1041,    -1,    -1,   438,
     991,    -1,    -1,   992,    -1,   992,   491,   992,    -1,   992,
      21,   114,   992,    -1,   992,   439,   992,    -1,   966,    -1,
    1108,    -1,  1102,    -1,  1104,    -1,   481,   995,    -1,    -1,
     968,   996,    -1,   968,   996,   481,   995,    -1,    -1,   484,
     965,    -1,   484,  1110,    -1,   484,  1102,    -1,   957,    -1,
     993,    -1,   169,   957,   821,   161,   822,   210,   997,    -1,
     199,   231,  1042,    -1,  1001,    -1,  1012,    -1,  1014,    -1,
     604,    -1,   500,   604,    -1,    -1,   894,    -1,   470,   419,
     282,    -1,   470,   419,   379,    -1,   165,   419,   165,    -1,
     285,   419,   285,    -1,    -1,  1007,  1006,  1009,  1008,    -1,
    1098,   107,   169,    34,   501,    -1,  1098,   193,   169,    34,
     501,    -1,    -1,  1010,    -1,    74,    -1,  1014,    -1,  1012,
      -1,  1010,  1014,    -1,  1010,  1012,    -1,  1010,    74,    -1,
    1014,    -1,  1011,  1014,    -1,    -1,    70,  1013,  1021,  1037,
    1090,   873,   501,    -1,    -1,  1018,  1021,  1015,  1034,   501,
      -1,    -1,  1021,  1016,  1034,   501,    -1,  1024,   501,    -1,
     502,   965,    -1,    -1,  1019,  1020,    -1,  1019,    -1,  1020,
      -1,    56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,
      -1,    69,    -1,  1030,    -1,  1026,    -1,  1022,    -1,  1090,
     497,  1002,  1003,   498,    -1,  1090,  1004,    -1,  1028,    -1,
     194,  1087,  1023,    -1,   194,  1023,    -1,   194,  1087,    -1,
     503,  1114,   504,    -1,    -1,  1028,  1025,   503,  1011,   504,
      -1,  1024,    -1,    -1,  1029,  1027,   503,  1011,   504,    -1,
      43,  1087,    -1,   432,  1087,    -1,    43,    -1,   432,    -1,
    1031,    -1,  1033,  1032,    -1,    44,    35,    -1,    44,    35,
     248,    -1,    44,    -1,    44,   248,    -1,    44,    25,    -1,
      44,    25,   248,    -1,    44,    25,    25,    -1,    44,    25,
      25,   248,    -1,    44,   123,    -1,    35,    -1,    35,   248,
      -1,   248,    -1,    25,    -1,    25,   248,    -1,    25,    25,
      -1,    25,    25,   248,    -1,     5,    -1,   123,    -1,   186,
      -1,    36,    -1,    -1,  1035,    -1,  1034,   500,  1035,    -1,
    1037,  1091,   873,  1017,  1036,    -1,    -1,   484,  1115,    -1,
      -1,   490,    -1,   490,   490,    -1,   169,   398,  1110,    -1,
      15,  1040,    -1,  1041,    -1,   153,    -1,    89,    -1,    -1,
     958,    -1,   170,    -1,   993,    -1,   993,    -1,    72,    -1,
      17,   957,    -1,    17,    89,    -1,    28,   957,  1045,    -1,
      -1,  1046,    -1,   439,  1050,    -1,  1047,    -1,   439,  1049,
      14,  1111,    -1,   252,  1049,    14,  1111,    -1,    -1,    37,
      -1,  1051,    -1,  1051,   500,  1050,    -1,  1052,    -1,  1102,
      -1,  1101,    -1,   965,    -1,   488,   965,    -1,   489,   965,
      -1,  1107,    -1,   488,  1107,    -1,   489,  1107,    -1,  1108,
      -1,  1106,    -1,  1109,    -1,    13,   244,   957,  1047,    -1,
      13,  1054,   957,  1047,    -1,    13,  1054,   957,  1048,    -1,
      29,    -1,    -1,     3,    14,  1111,    -1,   166,    14,  1111,
      -1,    18,    14,  1111,  1058,    -1,  1059,    -1,  1058,   500,
    1059,    -1,  1104,   484,  1064,    -1,   387,    14,  1111,  1061,
      -1,  1062,    -1,  1061,   500,  1062,    -1,  1064,   484,  1063,
      -1,   965,    -1,  1104,    -1,    10,    -1,    18,    14,  1111,
     443,  1063,  1066,    -1,  1067,    -1,  1066,   500,  1067,    -1,
    1104,   484,  1072,    -1,   387,    14,  1111,   443,  1063,  1069,
      -1,  1070,    -1,  1069,   500,  1070,    -1,  1072,   484,  1071,
      -1,  1107,    -1,  1063,    -1,   489,  1107,    -1,   489,   965,
      -1,  1108,    -1,     8,    -1,   163,    -1,    11,    -1,    12,
      -1,    22,    -1,    23,    -1,    24,    -1,   287,    -1,    26,
      -1,    27,    -1,   339,    -1,    31,    -1,    32,    -1,    33,
      -1,   428,    -1,   387,     4,   484,  1074,    -1,   387,     4,
     419,  1074,    -1,   317,    -1,   313,    -1,   387,   139,   419,
    1041,    -1,   387,   139,   484,  1041,    -1,   387,   139,  1041,
      -1,    -1,   428,  1077,  1090,   254,  1021,   873,  1078,    -1,
      30,    -1,    -1,    -1,    45,  1080,  1089,   254,  1021,   873,
    1078,    -1,    46,    38,  1082,    -1,    46,   302,    16,  1082,
      -1,    46,    40,  1082,    -1,   143,    -1,    39,    -1,    42,
      -1,    20,   957,    -1,    19,   419,   957,    -1,   183,   957,
     497,  1099,   498,    -1,   183,     6,    -1,     7,   957,   497,
    1099,   498,    -1,     7,   957,    -1,  1084,    -1,  1085,    -1,
       6,    -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,
      12,    -1,    16,    -1,    19,    -1,    20,    -1,    21,    -1,
      22,    -1,    23,    -1,    24,    -1,    26,    -1,    27,    -1,
      31,    -1,    32,    -1,    33,    -1,    34,    -1,    37,    -1,
      38,    -1,    39,    -1,    40,    -1,    42,    -1,     9,    -1,
      13,    -1,    15,    -1,    28,    -1,    45,    -1,    46,    -1,
       5,    -1,    25,    -1,    29,    -1,    35,    -1,    43,    -1,
      36,    -1,    44,    -1,  1089,    -1,  1110,    -1,  1094,    -1,
    1096,    -1,   970,    -1,  1083,    -1,  1092,    -1,   123,    -1,
     444,    -1,  1091,    -1,  1086,    -1,   123,    -1,   244,    -1,
     248,    -1,   432,    -1,   419,    -1,  1092,    -1,  1094,    -1,
    1110,    -1,   970,    -1,   971,    -1,  1084,    -1,  1090,    -1,
     972,    -1,  1095,    -1,  1085,    -1,    50,    -1,    51,    -1,
      56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,
    1094,    -1,  1095,    -1,   165,    -1,   227,    -1,   282,    -1,
     285,    -1,   379,    -1,   470,    -1,  1096,    -1,   139,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    85,    -1,
      86,    -1,    87,    -1,    88,    -1,    90,    -1,    91,    -1,
      92,    -1,   100,    -1,   101,    -1,   103,    -1,   105,    -1,
     106,    -1,   107,    -1,   114,    -1,   115,    -1,   117,    -1,
     118,    -1,   122,    -1,   125,    -1,   127,    -1,   128,    -1,
     129,    -1,   130,    -1,   134,    -1,   135,    -1,   136,    -1,
     137,    -1,   138,    -1,   141,    -1,   142,    -1,   143,    -1,
     144,    -1,   145,    -1,   146,    -1,   148,    -1,   149,    -1,
     150,    -1,   152,    -1,   161,    -1,   162,    -1,   163,    -1,
     164,    -1,   166,    -1,   169,    -1,   171,    -1,   173,    -1,
     175,    -1,   176,    -1,   177,    -1,   179,    -1,   180,    -1,
     181,    -1,   184,    -1,   185,    -1,   186,    -1,   187,    -1,
     188,    -1,   190,    -1,   191,    -1,   192,    -1,   195,    -1,
     197,    -1,   198,    -1,   199,    -1,   201,    -1,   202,    -1,
     205,    -1,   207,    -1,   211,    -1,   213,    -1,   217,    -1,
     218,    -1,   220,    -1,   223,    -1,   225,    -1,   226,    -1,
     228,    -1,   229,    -1,   231,    -1,   232,    -1,   233,    -1,
     235,    -1,   236,    -1,   237,    -1,   238,    -1,   239,    -1,
     240,    -1,   245,    -1,   246,    -1,   247,    -1,   256,    -1,
     258,    -1,   259,    -1,   260,    -1,   261,    -1,   262,    -1,
     263,    -1,   264,    -1,   268,    -1,   271,    -1,   272,    -1,
     273,    -1,   276,    -1,   277,    -1,   278,    -1,   279,    -1,
     280,    -1,   281,    -1,   283,    -1,   284,    -1,   286,    -1,
     287,    -1,   288,    -1,   293,    -1,   294,    -1,   295,    -1,
     296,    -1,   297,    -1,   298,    -1,   299,    -1,   301,    -1,
     303,    -1,   304,    -1,   306,    -1,   309,    -1,   311,    -1,
     312,    -1,   315,    -1,   319,    -1,   320,    -1,   329,    -1,
     330,    -1,   331,    -1,   332,    -1,   334,    -1,   336,    -1,
     341,    -1,   342,    -1,   340,    -1,   344,    -1,   345,    -1,
     346,    -1,   347,    -1,   348,    -1,   350,    -1,   352,    -1,
     353,    -1,   354,    -1,   356,    -1,   357,    -1,   358,    -1,
     359,    -1,   360,    -1,   361,    -1,   362,    -1,   363,    -1,
     364,    -1,   365,    -1,   367,    -1,   368,    -1,   370,    -1,
     371,    -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,
     377,    -1,   378,    -1,   382,    -1,   383,    -1,   385,    -1,
     387,    -1,   389,    -1,   390,    -1,   392,    -1,   395,    -1,
     396,    -1,   397,    -1,   398,    -1,   399,    -1,   400,    -1,
     401,    -1,   402,    -1,   403,    -1,   404,    -1,   406,    -1,
     409,    -1,   408,    -1,   411,    -1,   412,    -1,   413,    -1,
     414,    -1,   415,    -1,   421,    -1,   423,    -1,   426,    -1,
     427,    -1,   428,    -1,   430,    -1,   431,    -1,   434,    -1,
     435,    -1,   436,    -1,   437,    -1,   440,    -1,   441,    -1,
     442,    -1,   443,    -1,   447,    -1,   449,    -1,   450,    -1,
     451,    -1,   454,    -1,   457,    -1,   458,    -1,   460,    -1,
     461,    -1,   471,    -1,   472,    -1,  1100,    -1,  1097,   500,
    1100,    -1,    41,    -1,    -1,  1114,    -1,  1104,  1103,    -1,
    1104,    -1,  1104,  1103,    -1,  1104,    -1,  1104,    -1,    22,
    1104,    -1,    22,   957,    -1,    73,    -1,   483,    -1,   479,
      -1,   477,    -1,   478,    -1,    77,    -1,    78,    -1,    79,
      -1,    76,    -1,   480,    -1,   476,    -1,    72,    -1,    80,
      -1,   957,    -1,   993,    -1,  1117,    -1,   497,   498,    -1,
     497,  1113,   498,    -1,  1112,    -1,  1113,  1112,    -1,  1115,
      -1,  1114,   500,  1115,    -1,  1113,    -1,   503,  1114,   504,
      -1,  1117,    -1,   497,    -1,   498,    -1,   500,    -1,   501,
      -1,  1110,    -1,   965,    -1,  1107,    -1,  1108,    -1,   490,
      -1,   488,    -1,   489,    -1,   491,    -1,   492,    -1,   307,
      -1,    47,    -1,    48,    -1,    49,    -1,    50,    -1,    51,
      -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    60,    -1,    59,    -1,    61,
      -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,    66,
      -1,    67,    -1,    68,    -1,    70,    -1,    69,    -1,     5,
      -1,   194,    -1,   227,    -1,   248,    -1,    25,    -1,   282,
      -1,   285,    -1,   379,    -1,    35,    -1,    36,    -1,    43,
      -1,    44,    -1,   470,    -1,   123,    -1,   208,    -1,   419,
      -1,   432,    -1,   445,    -1,   495,    -1,   496,    -1,   484,
      -1,   502,    -1,   166,   997,    -1,   166,   341,   997,    -1,
     166,    89,    -1,   166,   341,    89,    -1,   965,    -1,   497,
    1119,   498,    -1,  1119,   488,  1119,    -1,  1119,   489,  1119,
      -1,  1119,   490,  1119,    -1,  1119,   491,  1119,    -1,  1119,
     492,  1119,    -1,  1108,    -1,   968,    -1,    -1,  1046,  1121,
      -1,  1121,  1046,    -1,  1046,    -1,  1121,    -1,   252,  1097,
      -1,  1048,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1193,  1193,  1196,  1198,  1200,  1202,  1204,  1206,  1208,
    1210,  1212,  1214,  1216,  1218,  1220,  1222,  1224,  1226,  1228,
    1230,  1232,  1234,  1236,  1254,  1256,  1258,  1260,  1262,  1264,
    1266,  1268,  1270,  1272,  1274,  1276,  1278,  1280,  1282,  1284,
    1286,  1288,  1290,  1292,  1294,  1296,  1298,  1300,  1302,  1304,
    1306,  1313,  1315,  1317,  1319,  1321,  1323,  1325,  1327,  1329,
    1331,  1333,  1335,  1337,  1339,  1341,  1343,  1345,  1347,  1349,
    1351,  1353,  1355,  1357,  1359,  1361,  1363,  1365,  1367,  1369,
    1371,  1373,  1375,  1377,  1384,  1386,  1388,  1390,  1392,  1394,
    1396,  1398,  1400,  1402,  1404,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1432,  1442,  1446,  1454,  1458,  1468,
    1478,  1479,  1490,  1497,  1503,  1514,  1520,  1529,  1536,  1542,
    1551,  1558,  1566,  1571,  1579,  1584,  1590,  1595,  1601,  1605,
    1609,  1613,  1617,  1621,  1625,  1629,  1633,  1637,  1641,  1645,
    1649,  1653,  1657,  1661,  1665,  1669,  1673,  1677,  1681,  1685,
    1689,  1693,  1701,  1709,  1717,  1725,  1733,  1741,  1745,  1753,
    1757,  1765,  1773,  1781,  1785,  1793,  1797,  1805,  1809,  1817,
    1822,  1828,  1833,  1839,  1843,  1847,  1851,  1855,  1859,  1867,
    1871,  1875,  1883,  1887,  1891,  1895,  1899,  1903,  1907,  1911,
    1915,  1920,  1924,  1928,  1932,  1936,  1940,  1948,  1952,  1960,
    1964,  1972,  1976,  1980,  1994,  1998,  2002,  2006,  2014,  2018,
    2022,  2026,  2034,  2038,  2042,  2046,  2050,  2054,  2058,  2066,
    2070,  2075,  2081,  2085,  2093,  2097,  2101,  2105,  2109,  2117,
    2121,  2129,  2133,  2137,  2141,  2145,  2154,  2162,  2166,  2174,
    2178,  2186,  2194,  2198,  2202,  2206,  2214,  2218,  2222,  2226,
    2234,  2238,  2246,  2250,  2254,  2258,  2262,  2266,  2270,  2274,
    2278,  2282,  2286,  2290,  2294,  2298,  2302,  2306,  2310,  2314,
    2318,  2322,  2326,  2330,  2334,  2338,  2342,  2346,  2350,  2354,
    2358,  2362,  2366,  2370,  2378,  2382,  2390,  2394,  2399,  2405,
    2410,  2416,  2424,  2429,  2435,  2439,  2447,  2451,  2455,  2459,
    2467,  2471,  2479,  2490,  2501,  2505,  2513,  2517,  2521,  2529,
    2534,  2540,  2544,  2548,  2552,  2556,  2560,  2564,  2568,  2572,
    2576,  2584,  2589,  2595,  2600,  2606,  2611,  2617,  2622,  2628,
    2632,  2640,  2644,  2648,  2652,  2656,  2660,  2665,  2671,  2676,
    2682,  2686,  2694,  2698,  2702,  2710,  2718,  2723,  2729,  2733,
    2737,  2745,  2749,  2753,  2757,  2761,  2765,  2769,  2777,  2781,
    2785,  2789,  2797,  2805,  2810,  2816,  2820,  2824,  2828,  2832,
    2836,  2844,  2848,  2856,  2860,  2864,  2868,  2876,  2881,  2887,
    2891,  2899,  2907,  2911,  2916,  2921,  2927,  2931,  2935,  2939,
    2944,  2950,  2958,  2966,  2970,  2974,  2978,  2982,  2990,  2995,
    3001,  3005,  3009,  3014,  3020,  3024,  3028,  3033,  3039,  3044,
    3050,  3055,  3061,  3069,  3074,  3080,  3084,  3092,  3100,  3104,
    3109,  3115,  3123,  3131,  3136,  3142,  3146,  3154,  3158,  3162,
    3166,  3170,  3174,  3178,  3182,  3186,  3190,  3194,  3198,  3206,
    3211,  3217,  3221,  3225,  3236,  3240,  3248,  3253,  3259,  3263,
    3271,  3275,  3283,  3288,  3294,  3299,  3305,  3309,  3317,  3322,
    3328,  3336,  3341,  3347,  3351,  3359,  3367,  3371,  3379,  3383,
    3387,  3395,  3400,  3406,  3410,  3418,  3426,  3430,  3438,  3442,
    3446,  3450,  3458,  3466,  3474,  3482,  3490,  3495,  3501,  3505,
    3513,  3518,  3524,  3528,  3536,  3540,  3544,  3552,  3560,  3564,
    3568,  3576,  3580,  3588,  3596,  3600,  3608,  3612,  3620,  3624,
    3632,  3636,  3640,  3644,  3652,  3657,  3663,  3668,  3674,  3678,
    3686,  3690,  3695,  3701,  3705,  3709,  3713,  3717,  3721,  3729,
    3734,  3740,  3744,  3751,  3755,  3763,  3769,  3773,  3781,  3785,
    3793,  3797,  3805,  3814,  3823,  3827,  3831,  3835,  3839,  3843,
    3847,  3851,  3855,  3859,  3863,  3871,  3879,  3883,  3891,  3895,
    3903,  3907,  3911,  3915,  3919,  3927,  3931,  3939,  3947,  3951,
    3959,  3967,  3971,  3979,  3987,  3991,  3999,  4003,  4007,  4011,
    4015,  4023,  4028,  4034,  4039,  4045,  4051,  4057,  4065,  4069,
    4077,  4081,  4089,  4093,  4101,  4105,  4113,  4117,  4125,  4133,
    4141,  4145,  4153,  4157,  4161,  4165,  4169,  4173,  4177,  4181,
    4185,  4189,  4193,  4197,  4205,  4209,  4217,  4221,  4229,  4233,
    4241,  4249,  4253,  4258,  4264,  4268,  4272,  4276,  4280,  4284,
    4288,  4292,  4296,  4300,  4304,  4308,  4312,  4316,  4320,  4324,
    4328,  4336,  4340,  4344,  4348,  4352,  4356,  4360,  4364,  4368,
    4372,  4376,  4380,  4388,  4392,  4400,  4405,  4410,  4414,  4418,
    4423,  4428,  4433,  4438,  4443,  4452,  4456,  4460,  4464,  4468,
    4478,  4488,  4498,  4502,  4506,  4516,  4520,  4524,  4534,  4542,
    4546,  4554,  4562,  4566,  4574,  4578,  4582,  4586,  4590,  4598,
    4602,  4610,  4614,  4618,  4622,  4630,  4634,  4638,  4642,  4646,
    4650,  4654,  4658,  4662,  4666,  4674,  4678,  4686,  4690,  4698,
    4703,  4709,  4713,  4721,  4729,  4737,  4741,  4749,  4754,  4760,
    4765,  4771,  4775,  4783,  4788,  4794,  4799,  4805,  4809,  4817,
    4821,  4825,  4833,  4837,  4842,  4848,  4852,  4857,  4863,  4867,
    4872,  4878,  4882,  4886,  4894,  4899,  4905,  4909,  4917,  4921,
    4929,  4933,  4941,  4945,  4953,  4957,  4961,  4965,  4969,  4977,
    4981,  4985,  4989,  4993,  5001,  5009,  5017,  5021,  5025,  5033,
    5037,  5041,  5049,  5053,  5061,  5065,  5069,  5073,  5077,  5081,
    5085,  5089,  5093,  5097,  5101,  5105,  5109,  5117,  5121,  5125,
    5129,  5137,  5141,  5149,  5154,  5160,  5168,  5172,  5180,  5188,
    5192,  5200,  5205,  5211,  5215,  5223,  5227,  5235,  5239,  5247,
    5251,  5255,  5259,  5267,  5271,  5279,  5283,  5287,  5295,  5299,
    5304,  5310,  5318,  5323,  5329,  5333,  5337,  5345,  5349,  5357,
    5362,  5368,  5372,  5376,  5380,  5384,  5388,  5392,  5396,  5400,
    5404,  5408,  5412,  5416,  5420,  5424,  5428,  5432,  5436,  5440,
    5444,  5448,  5452,  5456,  5464,  5469,  5475,  5480,  5486,  5490,
    5494,  5498,  5502,  5506,  5510,  5518,  5522,  5526,  5530,  5534,
    5538,  5542,  5546,  5550,  5554,  5558,  5562,  5566,  5570,  5574,
    5578,  5586,  5590,  5594,  5602,  5606,  5614,  5618,  5622,  5626,
    5630,  5638,  5643,  5649,  5653,  5657,  5661,  5669,  5673,  5678,
    5684,  5688,  5696,  5704,  5712,  5716,  5724,  5728,  5732,  5736,
    5740,  5744,  5748,  5752,  5756,  5760,  5764,  5768,  5772,  5776,
    5784,  5788,  5793,  5799,  5803,  5807,  5815,  5819,  5823,  5831,
    5836,  5842,  5846,  5854,  5859,  5864,  5870,  5876,  5884,  5892,
    5897,  5903,  5907,  5911,  5915,  5919,  5923,  5927,  5931,  5935,
    5939,  5943,  5947,  5951,  5955,  5959,  5963,  5971,  5976,  5982,
    5986,  5994,  6002,  6007,  6013,  6021,  6025,  6033,  6041,  6045,
    6049,  6053,  6057,  6065,  6070,  6076,  6084,  6088,  6092,  6096,
    6100,  6104,  6112,  6120,  6124,  6128,  6136,  6141,  6147,  6151,
    6155,  6163,  6167,  6175,  6179,  6187,  6192,  6198,  6203,  6209,
    6214,  6220,  6225,  6231,  6239,  6243,  6247,  6251,  6255,  6259,
    6263,  6271,  6276,  6282,  6288,  6298,  6303,  6309,  6313,  6317,
    6321,  6329,  6331,  6339,  6344,  6350,  6358,  6362,  6366,  6374,
    6378,  6386,  6394,  6399,  6405,  6413,  6418,  6424,  6432,  6437,
    6443,  6447,  6451,  6455,  6459,  6463,  6467,  6471,  6479,  6484,
    6490,  6498,  6502,  6510,  6514,  6522,  6530,  6538,  6546,  6550,
    6558,  6590,  6592,  6596,  6600,  6604,  6613,  6619,  6623,  6631,
    6635,  6643,  6647,  6655,  6659,  6663,  6667,  6671,  6675,  6679,
    6683,  6691,  6695,  6703,  6707,  6711,  6715,  6719,  6723,  6731,
    6735,  6743,  6747,  6755,  6763,  6768,  6770,  6776,  6780,  6784,
    6788,  6792,  6796,  6800,  6804,  6812,  6817,  6823,  6827,  6832,
    6838,  6842,  6846,  6851,  6857,  6862,  6868,  6876,  6880,  6888,
    6892,  6900,  6904,  6908,  6912,  6916,  6921,  6925,  6929,  6937,
    6942,  6948,  6952,  6960,  6964,  6969,  6975,  6983,  6991,  6995,
    7003,  7007,  7015,  7020,  7026,  7031,  7037,  7041,  7049,  7054,
    7060,  7064,  7072,  7076,  7084,  7089,  7095,  7099,  7107,  7112,
    7118,  7122,  7130,  7134,  7138,  7142,  7146,  7150,  7154,  7158,
    7164,  7168,  7172,  7180,  7184,  7188,  7192,  7196,  7200,  7208,
    7212,  7216,  7220,  7228,  7232,  7236,  7240,  7248,  7253,  7259,
    7263,  7271,  7275,  7279,  7283,  7291,  7295,  7303,  7307,  7311,
    7319,  7327,  7332,  7338,  7342,  7346,  7351,  7357,  7361,  7369,
    7377,  7379,  7381,  7385,  7389,  7393,  7401,  7411,  7422,  7431,
    7435,  7439,  7443,  7447,  7451,  7455,  7463,  7467,  7471,  7475,
    7483,  7487,  7495,  7500,  7506,  7510,  7514,  7518,  7522,  7526,
    7530,  7534,  7538,  7542,  7546,  7554,  7559,  7565,  7569,  7577,
    7581,  7589,  7597,  7605,  7609,  7617,  7621,  7629,  7637,  7645,
    7649,  7653,  7657,  7661,  7665,  7673,  7678,  7684,  7689,  7695,
    7699,  7703,  7707,  7715,  7723,  7727,  7732,  7738,  7742,  7746,
    7750,  7754,  7758,  7762,  7766,  7770,  7774,  7778,  7782,  7786,
    7791,  7797,  7801,  7809,  7813,  7817,  7821,  7825,  7829,  7833,
    7837,  7841,  7845,  7849,  7853,  7857,  7861,  7865,  7869,  7873,
    7877,  7881,  7885,  7889,  7893,  7897,  7901,  7905,  7909,  7913,
    7917,  7921,  7925,  7929,  7933,  7937,  7941,  7945,  7949,  7953,
    7957,  7961,  7965,  7969,  7973,  7977,  7981,  7985,  7989,  7993,
    7997,  8001,  8005,  8009,  8013,  8017,  8021,  8025,  8029,  8034,
    8038,  8046,  8050,  8054,  8058,  8062,  8066,  8070,  8074,  8078,
    8082,  8086,  8090,  8094,  8098,  8102,  8106,  8110,  8114,  8118,
    8122,  8126,  8130,  8138,  8142,  8146,  8150,  8154,  8158,  8162,
    8166,  8170,  8174,  8178,  8186,  8190,  8194,  8198,  8202,  8206,
    8210,  8214,  8218,  8222,  8226,  8230,  8234,  8238,  8242,  8246,
    8250,  8254,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,
    8290,  8294,  8298,  8302,  8306,  8310,  8314,  8318,  8322,  8326,
    8330,  8334,  8338,  8342,  8346,  8350,  8354,  8358,  8362,  8366,
    8370,  8378,  8382,  8390,  8394,  8398,  8403,  8409,  8417,  8421,
    8429,  8433,  8441,  8445,  8453,  8457,  8462,  8468,  8473,  8479,
    8483,  8491,  8499,  8503,  8508,  8514,  8522,  8526,  8533,  8538,
    8544,  8548,  8553,  8559,  8564,  8573,  8577,  8581,  8589,  8593,
    8597,  8605,  8609,  8613,  8621,  8625,  8633,  8637,  8641,  8645,
    8649,  8653,  8657,  8661,  8665,  8673,  8677,  8685,  8689,  8697,
    8701,  8705,  8709,  8713,  8717,  8725,  8729,  8737,  8741,  8749,
    8753,  8757,  8765,  8769,  8777,  8782,  8788,  8792,  8796,  8800,
    8804,  8808,  8812,  8816,  8824,  8828,  8836,  8844,  8849,  8855,
    8859,  8863,  8867,  8871,  8876,  8882,  8890,  8898,  8902,  8906,
    8914,  8918,  8926,  8934,  8938,  8946,  8954,  8959,  8965,  8970,
    8976,  8980,  8988,  8992,  8996,  9000,  9008,  9012,  9021,  9023,
    9031,  9036,  9042,  9046,  9054,  9058,  9066,  9074,  9078,  9086,
    9090,  9094,  9098,  9106,  9110,  9118,  9122,  9130,  9134,  9142,
    9146,  9154,  9162,  9170,  9178,  9186,  9194,  9202,  9206,  9214,
    9218,  9222,  9226,  9230,  9234,  9238,  9242,  9246,  9250,  9254,
    9258,  9262,  9266,  9267,  9272,  9278,  9286,  9290,  9291,  9295,
    9303,  9307,  9311,  9315,  9316,  9317,  9318,  9323,  9327,  9331,
    9335,  9336,  9337,  9342,  9346,  9350,  9354,  9358,  9362,  9366,
    9370,  9374,  9378,  9382,  9386,  9390,  9394,  9398,  9402,  9406,
    9410,  9414,  9418,  9422,  9426,  9430,  9434,  9438,  9442,  9446,
    9450,  9454,  9458,  9462,  9466,  9470,  9474,  9478,  9482,  9486,
    9490,  9494,  9498,  9502,  9506,  9514,  9518,  9522,  9526,  9530,
    9534,  9538,  9542,  9546,  9550,  9554,  9558,  9562,  9566,  9570,
    9574,  9578,  9582,  9586,  9590,  9594,  9598,  9606,  9610,  9614,
    9618,  9622,  9626,  9630,  9634,  9638,  9642,  9646,  9650,  9654,
    9658,  9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,
    9698,  9702,  9706,  9710,  9714,  9718,  9722,  9726,  9730,  9734,
    9738,  9742,  9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,
    9778,  9782,  9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,
    9818,  9822,  9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,
    9858,  9862,  9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,
    9898,  9902,  9906,  9910,  9918,  9925,  9938,  9939,  9942,  9943,
    9944,  9950,  9951,  9952,  9953,  9954,  9957,  9957,  9967,  9966,
    9976,  9992,  9994,  9997,  9999, 10003, 10015, 10031, 10035, 10046,
   10047, 10050, 10062, 10071, 10072, 10075, 10076, 10077, 10080, 10081,
   10084, 10085, 10088, 10089, 10092, 10094, 10096, 10098, 10102, 10109,
   10116, 10132, 10165, 10175, 10178, 10180, 10193, 10194, 10196, 10198,
   10202, 10215, 10222, 10259, 10268, 10270, 10271, 10274, 10276, 10277,
   10280, 10281, 10282, 10283, 10284, 10291, 10290, 10300, 10302, 10304,
   10305, 10306, 10309, 10310, 10311, 10312, 10313, 10316, 10317, 10321,
   10320, 10337, 10335, 10350, 10349, 10362, 10368, 10369, 10372, 10374,
   10375, 10378, 10379, 10380, 10381, 10384, 10385, 10388, 10396, 10413,
   10421, 10444, 10542, 10576, 10578, 10580, 10584, 10588, 10587, 10638,
   10640, 10639, 10654, 10660, 10667, 10672, 10675, 10676, 10679, 10680,
   10681, 10682, 10683, 10684, 10685, 10693, 10701, 10704, 10705, 10706,
   10707, 10708, 10709, 10717, 10725, 10726, 10727, 10730, 10731, 10734,
   10736, 10740, 10826, 10827, 10834, 10835, 10836, 10842, 10851, 10854,
   10855, 10856, 10857, 10860, 10861, 10862, 10865, 10867, 10875, 10876,
   10882, 10884, 10885, 10888, 10889, 10892, 10899, 10906, 10906, 10908,
   10908, 10910, 10917, 10918, 10921, 10922, 10923, 10924, 10925, 10926,
   10927, 10928, 10929, 10935, 10942, 10949, 10958, 10959, 10971, 10982,
   10993, 10997, 10998, 11001, 11006, 11010, 11011, 11014, 11020, 11028,
   11031, 11038, 11042, 11043, 11046, 11049, 11053, 11054, 11057, 11063,
   11071, 11072, 11081, 11090, 11102, 11103, 11104, 11105, 11106, 11107,
   11108, 11109, 11110, 11111, 11112, 11113, 11114, 11115, 11116, 11123,
   11124, 11127, 11128, 11135, 11136, 11137, 11144, 11143, 11160, 11161,
   11168, 11167, 11236, 11242, 11248, 11256, 11262, 11268, 11274, 11280,
   11286, 11292, 11298, 11304, 11315, 11316, 11319, 11320, 11321, 11322,
   11323, 11324, 11325, 11326, 11327, 11328, 11329, 11330, 11331, 11332,
   11333, 11334, 11335, 11336, 11337, 11338, 11339, 11340, 11341, 11342,
   11345, 11346, 11347, 11348, 11349, 11350, 11354, 11355, 11356, 11357,
   11358, 11359, 11360, 11363, 11366, 11367, 11368, 11369, 11370, 11371,
   11372, 11373, 11378, 11379, 11380, 11381, 11382, 11383, 11384, 11385,
   11386, 11389, 11390, 11391, 11392, 11395, 11396, 11397, 11398, 11401,
   11402, 11403, 11404, 11405, 11406, 11407, 11425, 11425, 11427, 11428,
   11429, 11430, 11431, 11432, 11438, 11439, 11442, 11443, 11444, 11445,
   11446, 11447, 11448, 11449, 11450, 11451, 11452, 11453, 11454, 11455,
   11456, 11457, 11458, 11459, 11460, 11461, 11462, 11463, 11464, 11465,
   11466, 11467, 11468, 11469, 11470, 11471, 11472, 11473, 11475, 11476,
   11477, 11478, 11479, 11480, 11481, 11482, 11483, 11484, 11485, 11486,
   11487, 11488, 11490, 11491, 11492, 11493, 11494, 11495, 11496, 11497,
   11498, 11499, 11500, 11501, 11502, 11503, 11504, 11505, 11506, 11507,
   11509, 11510, 11511, 11512, 11513, 11514, 11515, 11517, 11518, 11519,
   11520, 11521, 11522, 11523, 11524, 11525, 11527, 11528, 11529, 11530,
   11531, 11532, 11533, 11534, 11535, 11536, 11537, 11538, 11539, 11540,
   11541, 11542, 11543, 11544, 11545, 11546, 11547, 11548, 11549, 11550,
   11551, 11552, 11553, 11554, 11555, 11556, 11557, 11558, 11560, 11561,
   11563, 11564, 11565, 11566, 11567, 11568, 11569, 11570, 11571, 11572,
   11573, 11574, 11575, 11576, 11577, 11578, 11579, 11580, 11581, 11582,
   11583, 11584, 11585, 11586, 11587, 11588, 11589, 11590, 11591, 11592,
   11593, 11594, 11595, 11596, 11597, 11598, 11599, 11600, 11601, 11602,
   11603, 11604, 11605, 11606, 11607, 11608, 11609, 11610, 11611, 11612,
   11613, 11614, 11615, 11616, 11617, 11618, 11619, 11620, 11622, 11623,
   11624, 11625, 11626, 11627, 11628, 11629, 11630, 11631, 11632, 11633,
   11634, 11635, 11636, 11637, 11638, 11639, 11640, 11641, 11642, 11643,
   11644, 11645, 11646, 11647, 11648, 11649, 11650, 11651, 11652, 11653,
   11654, 11655, 11656, 11657, 11658, 11659, 11660, 11661, 11662, 11663,
   11664, 11665, 11666, 11667, 11668, 11669, 11670, 11671, 11673, 11676,
   11676, 11679, 11685, 11686, 11689, 11691, 11696, 11706, 11713, 11714,
   11715, 11718, 11751, 11753, 11755, 11758, 11768, 11778, 11788, 11789,
   11792, 11794, 11795, 11796, 11799, 11801, 11809, 11810, 11811, 11815,
   11816, 11820, 11821, 11824, 11825, 11828, 11829, 11830, 11831, 11832,
   11835, 11836, 11837, 11838, 11839, 11840, 11841, 11842, 11843, 11844,
   11845, 11846, 11847, 11848, 11849, 11850, 11851, 11852, 11853, 11854,
   11855, 11856, 11857, 11858, 11859, 11860, 11861, 11862, 11863, 11864,
   11865, 11866, 11867, 11868, 11869, 11870, 11871, 11872, 11873, 11874,
   11875, 11876, 11877, 11878, 11879, 11880, 11881, 11882, 11883, 11884,
   11885, 11886, 11887, 11888, 11889, 11890, 11893, 11894, 11895, 11896,
   11899, 11900, 11901, 11902, 11903, 11904, 11905, 11906, 11907, 11910,
   11911, 11912, 11913, 11914, 11917, 11918
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", 
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONCURRENTLY", 
  "CONFIGURATION", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", 
  "CONTINUE_P", "CONVERSION_P", "COPY", "COST", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", 
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", 
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", 
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", 
  "PARTITION", "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", 
  "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", 
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P", 
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", 
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", 
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", 
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", 
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", 
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op", 
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "','", "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", 
  "CreateRoleStmt", "opt_with", "OptRoleList", "OptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableResetStmt", "SetResetClause", "VariableShowStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "create_as_target", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "opt_with_data", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", 
  "NumericOnly", "CreatePLangStmt", "opt_trusted", "handler_name", 
  "validator_clause", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt", 
  "privileges", "privilege_list", "privilege", "privilege_target", 
  "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "opt_set_data", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList", 
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event", 
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "with_clause", "cte_list", "common_table_expr", 
  "into_clause", "OptTempTableName", "opt_table", "opt_all", 
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list", 
  "sortby", "select_limit", "opt_select_limit", "select_limit_value", 
  "opt_select_fetch_first_value", "select_offset_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "type_list", "array_expr", 
  "array_expr_list", "extract_list", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "RoleId", "SignedIconst", "ColId", "type_function_name", 
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword", 
  "SpecialRuleRelation", "statements", "statement", "CreateAsStmt", "@1", 
  "RuleStmt", "@2", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@3", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@4", "var_declaration", 
  "@5", "@6", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@9", "opt_reference", "ECPGVar", 
  "@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColLabel", 
  "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ecpg_param", "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", 
  "ecpg_xconst", "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 
  "DeallocateStmt", "Iresult", "execute_rest", "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     640,   640,   640,   640,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   645,   645,   645,   645,   645,   645,   646,
     646,   647,   647,   647,   647,   647,   648,   648,   649,   649,
     650,   650,   651,   652,   653,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   655,   655,   656,   656,
     657,   657,   657,   657,   657,   658,   658,   659,   660,   660,
     661,   662,   662,   663,   664,   664,   665,   665,   665,   665,
     665,   666,   666,   667,   667,   668,   668,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   676,
     677,   677,   678,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   679,   679,   680,   680,   681,   681,
     682,   683,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   687,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   688,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   689,
     689,   690,   691,   691,   692,   692,   692,   692,   692,   693,
     693,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   699,   700,   701,   702,   702,   703,   703,   704,
     704,   705,   705,   706,   706,   707,   707,   708,   708,   709,
     709,   709,   710,   710,   710,   711,   711,   711,   712,   712,
     712,   713,   713,   713,   714,   714,   715,   715,   716,   716,
     717,   717,   718,   718,   719,   719,   719,   719,   719,   720,
     720,   720,   720,   720,   721,   722,   723,   723,   723,   724,
     724,   724,   725,   725,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   727,   727,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   736,   737,   737,   738,
     738,   738,   738,   739,   739,   740,   740,   740,   741,   741,
     741,   742,   743,   743,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   748,   748,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   752,   752,   752,   753,   753,   754,   754,   754,   754,
     754,   755,   755,   756,   756,   756,   756,   757,   757,   757,
     758,   758,   759,   760,   761,   761,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     763,   763,   763,   764,   764,   764,   765,   765,   765,   766,
     766,   767,   767,   768,   768,   768,   768,   769,   770,   771,
     771,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   773,   773,   774,
     774,   775,   776,   776,   777,   778,   778,   779,   780,   780,
     780,   780,   780,   781,   781,   782,   783,   783,   783,   783,
     783,   783,   784,   785,   785,   785,   786,   786,   787,   787,
     787,   788,   788,   789,   789,   790,   790,   791,   791,   792,
     792,   793,   793,   794,   795,   795,   795,   795,   795,   795,
     795,   796,   796,   797,   797,   798,   798,   799,   799,   799,
     799,   800,   800,   801,   801,   802,   803,   803,   803,   804,
     804,   805,   806,   806,   807,   808,   808,   809,   810,   810,
     811,   811,   811,   811,   811,   811,   811,   811,   812,   812,
     813,   814,   814,   815,   815,   816,   817,   818,   819,   819,
     820,   821,   821,   821,   821,   821,   822,   822,   822,   823,
     823,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   826,   827,   827,   827,   827,   827,   827,   828,
     828,   829,   829,   830,   831,   831,   831,   832,   832,   832,
     832,   832,   832,   832,   832,   833,   833,   834,   834,   834,
     835,   835,   835,   835,   836,   836,   837,   838,   838,   839,
     839,   840,   840,   840,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   843,   844,   845,   846,   846,
     847,   847,   848,   848,   849,   849,   850,   850,   851,   851,
     852,   852,   853,   853,   854,   854,   855,   855,   856,   856,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   859,   859,   859,   859,   860,
     860,   860,   860,   861,   861,   861,   861,   862,   862,   863,
     863,   864,   864,   864,   864,   865,   865,   866,   866,   866,
     867,   868,   868,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   875,   875,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   883,   884,   884,   885,   885,   886,   887,   888,
     888,   888,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   891,   891,   892,   893,   893,   893,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   895,   895,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   900,   900,   901,   901,   901,   901,   902,   903,   903,
     904,   904,   905,   905,   906,   906,   906,   907,   907,   908,
     908,   909,   910,   910,   910,   911,   912,   912,   913,   913,
     914,   914,   914,   915,   915,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   919,   919,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   921,   921,   922,   922,   923,
     923,   923,   923,   923,   923,   924,   924,   925,   925,   926,
     926,   926,   927,   927,   928,   928,   929,   929,   929,   929,
     929,   929,   929,   929,   930,   930,   931,   932,   932,   933,
     933,   933,   933,   933,   933,   934,   935,   936,   936,   936,
     937,   937,   938,   939,   939,   940,   941,   941,   942,   942,
     943,   943,   944,   944,   944,   944,   945,   945,   946,   946,
     947,   947,   948,   948,   949,   949,   950,   951,   951,   952,
     952,   952,   952,   953,   953,   954,   954,   955,   955,   956,
     956,   957,   958,   959,   960,   961,   962,   963,   963,   964,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   965,   966,   967,   967,   967,   967,
     968,   968,   968,   968,   968,   968,   968,   969,   969,   969,
     969,   969,   969,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   973,   973,   974,   974,   975,   975,
     975,   975,   975,   975,   975,   975,   977,   976,   979,   978,
     980,   981,   981,   981,   981,   982,   982,   982,   982,   983,
     983,   984,   985,   986,   986,   987,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   991,   992,   992,
     992,   993,   994,   994,   995,   995,   996,   996,   996,   996,
     997,   997,   998,   999,  1000,  1001,  1001,  1002,  1003,  1003,
    1004,  1004,  1004,  1004,  1004,  1006,  1005,  1007,  1008,  1009,
    1009,  1009,  1010,  1010,  1010,  1010,  1010,  1011,  1011,  1013,
    1012,  1015,  1014,  1016,  1014,  1014,  1017,  1017,  1018,  1018,
    1018,  1019,  1019,  1019,  1019,  1020,  1020,  1021,  1021,  1021,
    1021,  1021,  1021,  1022,  1022,  1022,  1023,  1025,  1024,  1026,
    1027,  1026,  1028,  1028,  1029,  1029,  1030,  1030,  1031,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1032,  1032,  1032,
    1032,  1032,  1032,  1032,  1032,  1032,  1032,  1033,  1033,  1034,
    1034,  1035,  1036,  1036,  1037,  1037,  1037,  1038,  1039,  1040,
    1040,  1040,  1040,  1041,  1041,  1041,  1042,  1042,  1043,  1043,
    1044,  1045,  1045,  1046,  1046,  1047,  1048,  1049,  1049,  1050,
    1050,  1051,  1051,  1051,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1053,  1053,  1053,  1054,  1054,  1055,  1056,
    1057,  1058,  1058,  1059,  1060,  1061,  1061,  1062,  1063,  1063,
    1064,  1065,  1066,  1066,  1067,  1068,  1069,  1069,  1070,  1071,
    1071,  1071,  1071,  1071,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1073,
    1073,  1074,  1074,  1075,  1075,  1075,  1077,  1076,  1078,  1078,
    1080,  1079,  1081,  1081,  1081,  1082,  1082,  1082,  1082,  1082,
    1082,  1082,  1082,  1082,  1083,  1083,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1085,  1085,  1085,  1085,  1085,  1085,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1087,  1088,  1088,  1088,  1088,  1088,  1088,
    1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1089,  1089,
    1089,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1091,  1092,
    1092,  1092,  1092,  1092,  1092,  1092,  1093,  1093,  1094,  1094,
    1094,  1094,  1094,  1094,  1095,  1095,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1097,
    1097,  1098,  1099,  1099,  1100,  1100,  1101,  1102,  1103,  1103,
    1103,  1104,  1105,  1106,  1107,  1108,  1108,  1108,  1108,  1108,
    1109,  1110,  1110,  1110,  1111,  1111,  1112,  1112,  1112,  1113,
    1113,  1114,  1114,  1115,  1115,  1116,  1116,  1116,  1116,  1116,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1118,  1118,  1118,  1118,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1120,
    1120,  1120,  1120,  1120,  1121,  1121
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       1,     1,     1,     1,     3,     0,     1,     0,     1,     1,
       1,     3,     0,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     4,     5,     4,     4,     4,     3,     7,
       8,     6,     6,     6,     6,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     2,     4,     2,     5,
       4,     4,     3,     3,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,    13,    14,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,    11,    10,    10,     2,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     6,     6,     8,     8,     6,     6,     6,     8,
       8,     8,     8,     6,     1,     0,     2,     0,     7,     6,
       6,     6,     6,     6,     6,     7,     6,     6,     6,     6,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       6,     8,     2,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     2,     4,     1,     1,     1,     0,     1,     0,     1,
       0,     3,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     3,     5,     8,     1,
       0,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     4,     4,     2,     0,     2,     3,     2,     0,
       1,     3,     1,     2,     1,     2,     5,     6,     5,     1,
       2,     1,     4,     3,     4,     5,     4,     5,     4,     5,
       2,     4,     1,     2,     2,     2,     1,     1,     0,     4,
       2,     1,     2,     2,     4,     1,     3,     1,     2,     3,
       1,     2,     0,     2,     4,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     4,     5,     6,     8,     6,     6,
       5,     1,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     1,     1,     1,     1,     1,     6,     4,     4,     4,
       4,     6,     5,     5,     5,     4,     6,     4,     4,     4,
       4,     5,     7,     7,     9,     4,     6,     5,     7,     7,
       7,     2,     3,     3,     3,     4,     0,     4,     1,     3,
       3,     1,     1,     1,     2,     2,     0,     2,     0,     1,
       3,     3,     2,     2,     0,     6,     1,     0,     3,     0,
       2,     2,     0,     1,     4,     2,     2,     2,     4,     3,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     1,
       4,     1,     2,     1,     2,     1,     3,     1,     3,     3,
       3,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     2,     3,     0,     3,
       3,     2,     2,     1,     0,     2,     2,     3,     2,     1,
       1,     3,     5,     1,     2,     4,     2,     0,     1,     0,
       1,     2,     2,     2,     3,     5,     1,     2,     0,     2,
       1,     0,     1,     1,     1,     3,     3,     1,     3,     3,
       2,     1,     1,     1,     1,     1,     3,     1,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     5,     2,     3,     6,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     4,     3,
       2,     1,     1,     1,     1,     1,     0,     8,     0,    14,
       2,     5,     3,     2,     2,     3,     7,     1,     1,     1,
       0,     2,     2,     1,     0,     1,     3,     1,     2,     0,
       2,     0,     2,     0,     1,     3,     4,     3,     1,     1,
       1,     1,     2,     0,     2,     4,     0,     2,     2,     2,
       1,     1,     7,     3,     1,     1,     1,     1,     2,     0,
       1,     3,     3,     3,     3,     0,     4,     5,     5,     0,
       1,     1,     1,     1,     2,     2,     2,     1,     2,     0,
       7,     0,     5,     0,     4,     2,     2,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     5,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     2,
       3,     0,     1,     2,     1,     4,     4,     0,     1,     1,
       3,     1,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     1,     4,     4,     4,     1,     0,     3,     3,
       4,     1,     3,     3,     4,     1,     3,     3,     1,     1,
       1,     6,     1,     3,     3,     6,     1,     3,     3,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       4,     1,     1,     4,     4,     3,     0,     7,     1,     0,
       0,     7,     3,     4,     3,     1,     1,     1,     2,     3,
       5,     2,     5,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     0,     1,     2,     1,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     3,     2,     3,
       1,     3,     3,     3,     3,     3,     3,     1,     1,     0,
       2,     2,     1,     1,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    1756,     0,     2,     1,  2394,  2398,  2402,  2403,  2321,  2404,
    2405,  2370,  2371,  2372,  2373,  2374,  2375,  2376,  2377,  2378,
    2379,  2380,  2381,  2383,  2382,  2384,  2385,  2386,  2387,  2388,
    2389,  2390,  2391,  2393,  2392,  2342,  1763,  2339,  2336,  2337,
    2338,  2343,  2407,  2395,  2408,  2396,  2397,  2399,  2400,  2369,
    2401,  2409,  2410,  2411,  2406,  2341,  2334,  2335,  1594,  2414,
    2365,  2366,  2364,  2367,  2368,  2412,  2413,  2356,  2357,  2358,
    2359,  2415,  1764,  1765,  2361,  1757,  1761,  1825,  1898,  2362,
    2363,  2360,  1762,  2355,  1898,     0,  2016,  2017,  2018,     0,
    2019,  2020,  2021,  1947,  1912,  2022,     0,     0,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,     0,  2031,  2032,  2033,
    2034,  1897,  2035,  2036,  2037,  2038,  2039,  1874,  1880,  2000,
       0,  1854,  1855,  1851,  1853,  1852,  1856,  1839,   922,   459,
     994,   993,     0,  1655,   922,  1656,  1613,  1657,  1614,  1615,
    1616,   241,     0,   996,  1617,     0,   922,   322,   337,  1658,
    1659,  1780,     0,  1618,  1619,     0,     0,     0,   459,   922,
       0,     0,  1620,  1012,  1621,     0,  1622,  1660,  1661,     0,
    1623,  1662,  1663,  1624,     0,  1625,  1626,  1664,  1665,  1666,
    1627,  1667,  1668,     0,     0,  1106,     0,  1628,  1669,  1629,
    1630,     0,  1670,  1631,  1632,  1633,  1671,  1672,  1673,  1634,
    1635,  1636,     0,  1637,     0,     0,     0,     0,     0,  1674,
     922,  1638,     0,  1113,     0,  1639,     0,  1675,  1640,     0,
    1641,     0,  1642,  1643,  1644,  1645,  1106,  1996,  1875,     0,
       0,   998,     0,  1646,  1676,     0,  1647,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   996,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1082,  1069,  1115,  1081,     0,  1084,
    2072,  2073,    28,    92,   122,   104,   105,   110,  1760,  1814,
    1815,  1816,  1898,  1849,  1850,  1843,  1859,  1869,  1858,  1862,
    1870,  1857,  1876,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2074,  1290,  2071,    50,  1831,     0,  1898,  1833,  1832,     0,
    2040,  2041,  2042,  2043,  2044,  2045,  2079,  2080,  2081,  2082,
    2083,  2085,  2084,  2331,  2096,  2097,  2098,  2099,  2100,  2101,
    2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,
    2112,  2113,  2114,  2115,  2116,  2117,  1605,  2118,  2119,  2120,
    2121,  2122,  2123,  2124,  2125,  2126,  2127,  2095,  2128,  2129,
    2130,  2131,  2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,
    2140,  2141,  2088,  2142,  2143,  2144,  2145,  2146,  2147,  2148,
    2149,  2150,  2151,  2152,  2153,  2154,  2155,  2156,  2157,  2158,
    2159,  2160,  2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,
    2169,  2170,  2171,  2172,  2173,  2174,  2175,  2089,  2176,  2177,
    2178,  2179,  2180,  2181,  2182,  2183,  2184,  2185,  2186,  2187,
    2188,  2189,  2190,  2191,  2192,  2193,  2194,  2195,  2196,  2197,
    2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,  2206,  2207,
    2090,  2208,  2209,  2091,  2210,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,
    2226,  2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,
    2238,  2236,  2237,  2239,  2240,  2241,  2242,  2243,  2244,  2245,
    2246,  2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,  2255,
    2256,  2257,  2258,  2259,  2260,  2261,  2262,  2263,  2264,  2265,
    2266,  2267,  2092,  2268,  2269,  2270,  2271,  2272,  2273,  2274,
    2275,  2276,  2277,  2278,  2279,  2280,  2281,  2282,  2283,  2284,
    2285,  2287,  2286,  2288,  2289,  2290,  2291,  2292,  1780,  2293,
    2294,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,  2303,
    2304,  2305,  2306,  2307,  1606,  2308,  2309,  2310,  2311,  2312,
    2313,  2314,  2315,  2316,  2093,  2317,  2318,  1798,  1595,  1602,
    1773,  1794,  1603,  2014,  2015,  1604,  1601,  2086,  2087,  2094,
    1800,  2327,  1799,  1600,  1946,     0,     0,  1911,  1910,  1914,
    1913,  1572,  1915,  1908,  1909,  1801,  1919,  1918,  1571,     0,
    1921,  2046,  2047,  2048,  2049,  2051,  2050,  2052,  1677,  1678,
    1679,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,  1688,
    2064,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,
    1698,  1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,
    1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,
    2065,  2066,  1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,
    1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,
    1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  2068,  1744,
    1745,  2067,  1746,  1747,  1748,  1749,  1750,  1751,  1752,  1753,
    2076,  2078,  2063,  1872,  2053,  2075,  2062,  2069,  2070,  2077,
    1882,  1878,  1886,  1881,     0,     0,     0,     0,  1898,   921,
     920,   906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   458,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1770,     0,   930,   301,   300,   995,
     984,   459,     0,   909,   321,     0,     0,     0,     0,     0,
       0,     0,   581,     0,     0,     0,     0,     0,     0,     0,
       0,   170,     0,     0,   332,   331,     0,     0,   446,     0,
     723,     0,     0,   459,     0,     0,     0,  1779,  1774,  1784,
       0,  1777,  1778,  1600,     0,  2418,  2236,  1810,  1811,  2416,
    2278,  1061,     0,   242,   245,   243,   244,     0,     0,   823,
     608,     0,   607,     0,     0,     0,   605,     0,     0,     0,
       0,   609,   603,     0,   602,     0,     0,     0,   606,     0,
     604,     0,     0,   910,     0,  1864,  1865,  2178,  1024,  1011,
     996,  2097,   672,   676,   667,   673,   679,   680,   668,   665,
     666,  2249,     0,     0,     0,     0,   656,  1596,   671,  1597,
     685,   378,   378,   378,     0,   684,   689,   378,     0,   903,
     937,  1576,  1105,     0,     0,   658,   902,  2293,  1016,     0,
       0,   827,     0,   828,     0,  2264,   914,   228,  2060,  2270,
    1642,  2293,  2061,   224,  2057,  2058,   197,  2059,  2055,  2056,
    2054,  2101,     0,     0,   684,     0,   911,   912,  1112,  1110,
       0,     0,     0,     0,     0,  2128,  2201,   221,  2260,  2265,
    2270,  1642,  2293,  2316,   179,     0,   235,  2270,  1642,  2293,
       0,   930,  1755,  1754,     0,  1085,  1567,  1191,  1564,  1563,
       0,     0,  1873,   905,   904,  1197,     0,   997,  1000,     0,
    1156,  2247,  1089,  1091,  1002,  1082,     0,  1759,   991,  1109,
    1109,     0,  1109,     0,  1074,  1082,  1077,  1081,     0,   922,
       0,  1841,  1869,  1848,  1904,  1845,     0,     0,  1894,  1890,
    1887,  1895,  1896,  1889,  1877,  1279,  1280,  1281,  1278,  1291,
    1277,     0,  1820,  1282,  1861,  1826,     0,  1836,  1835,  1834,
    2344,  2345,  1948,  1772,  1791,     0,     0,     0,     0,     0,
       0,  1927,  1920,  1922,  1924,  1884,  1883,  1879,     0,     0,
       0,     0,  2006,  2007,  2005,     0,  2002,  2004,     0,  1904,
       0,     0,  1577,  1609,  1603,  1611,  1604,  1601,  1600,     0,
     616,   125,     0,     0,     0,     0,     0,     0,  2120,  2166,
    1474,  1484,  1482,  1483,  1476,  1477,  1478,  1479,  1480,  1481,
       0,   813,  1475,     0,   125,     0,     0,     0,     0,     0,
       0,     0,     0,  2205,   125,     0,     0,     0,     0,     0,
     926,   929,   907,   987,     0,  1564,     0,     0,   641,     0,
     650,   642,   647,     0,   644,     0,     0,   652,     0,   643,
     645,   646,   651,     0,     0,   648,   649,     0,     0,   918,
     378,     0,     0,     0,     0,     0,   125,   974,     0,   336,
     335,   125,   334,   333,  2120,  2166,     0,   744,   125,     0,
     172,   487,   462,     0,     0,   548,  2205,   125,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1783,  1789,     0,
    1781,  1949,  2419,  2417,  1907,     0,  1036,  2177,     0,   288,
       0,     0,  2177,   965,     0,  2177,     0,  2177,   165,  1569,
    2120,  2166,  2177,     0,     0,  2177,   157,  2177,     0,  2177,
     288,  2177,   463,     0,  2177,     0,  2177,  2205,   159,     0,
    2177,   288,   614,     0,     0,  2349,  2353,     0,  2351,  2346,
    1863,  1917,  1916,  1813,     0,  2429,     0,   669,   678,   677,
     675,   674,   670,  1598,  1599,     0,   663,   664,  1927,  2435,
     662,   686,     0,     0,   693,   692,   691,     0,     0,     0,
     694,     0,  1195,  1039,     0,   917,     0,     0,     0,     0,
     830,   830,   830,   913,   227,   225,     0,     0,     0,     0,
       0,     0,   919,     0,     0,     0,  1613,  1614,  1615,  1539,
       0,  1605,  1616,  1617,  1404,  1391,  1400,  1405,  1392,  1394,
    1401,  1618,  1619,  2154,  1620,  1621,  1590,  1622,  1623,  1234,
    1625,  1626,  1627,  1396,  1398,  1628,  1629,     0,  1591,  1631,
    1632,  2228,  1634,  1635,  1637,  1638,  1402,  1640,  1641,  1642,
    1643,  1644,  1645,  1589,     0,  1403,  1646,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,  2333,  1583,  1485,  2332,     0,     0,
    1562,     0,  1379,     0,  1226,  1227,  1249,  1250,  1228,  1255,
    1256,  1268,  1229,     0,  1561,  1293,  1378,  1383,     0,  1377,
    1373,  1096,  1557,  1540,     0,  1374,  1579,  1593,  1592,  2327,
    1548,  1582,  1580,  1581,     0,     0,     0,   190,     0,     0,
    1995,   237,     0,   238,  1565,  2270,   180,   220,   192,   219,
     193,   222,   223,   191,     0,  2118,   181,     0,   188,     0,
       0,     0,     0,     0,     0,     0,   231,   908,     0,  1193,
       0,     0,  1546,  1568,  1192,   623,     0,     0,  1198,     0,
     999,   996,  1553,  1552,  1554,     0,  1090,     0,     0,     0,
    1072,  1071,  1002,  1107,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,  1149,  1130,  1146,  1150,     0,  1078,  1157,
    1758,  1904,  1905,     0,  1899,     0,  1898,  1898,  1892,  1891,
    1888,     0,     0,     0,     0,     0,     0,     0,  1817,   443,
    1819,   441,     0,     0,  1793,     0,  1797,  1795,  1927,  1943,
    1927,  1944,  1945,     0,  1950,  1951,     0,  1928,  2340,     0,
       0,  1934,     0,  1923,  1929,  1931,  1933,  1932,  1941,  1937,
    1940,  1942,  1885,  1898,  2013,     0,  2008,  2011,     0,  2003,
       0,  1578,     0,     0,     0,     0,     0,   617,     0,     0,
       0,   124,   963,   230,   961,     0,     0,     0,     0,   968,
       0,     0,     0,     0,   777,     0,     0,     0,     0,     0,
       0,   778,   776,   779,   786,   799,   802,     0,   713,   163,
     164,     0,     0,   855,   855,     0,     0,   855,     0,     0,
       0,     0,     0,     0,     0,   247,   250,     0,     0,     0,
       0,     0,     0,     0,   127,   154,     0,     0,     0,   428,
     440,     0,     0,     0,     0,     0,   437,     0,   125,   248,
     422,   425,     0,     0,     0,   496,   495,   855,     0,   246,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   127,   156,     0,     0,   249,     0,  1827,     0,
     924,   925,     0,   928,     0,   983,     0,     0,     0,     0,
       0,     0,  2120,  2166,     0,     0,     0,     0,     0,     0,
     324,   307,   308,   125,   306,     0,     0,   545,     0,  1237,
    1266,  1244,  1266,  1266,  1233,  1233,  1246,  1235,  1273,     0,
    1266,  1233,  1238,     0,  1236,  1276,  1276,  1261,     0,  1218,
    1219,  1220,  1221,  1247,  1248,  1222,  1253,  1254,  1223,  1290,
    1233,  1610,  1612,  1608,  1607,     0,   940,   973,     0,     0,
     127,   582,     0,     0,   546,     0,   127,     0,   168,     0,
     491,     0,     0,     0,     0,     0,     0,   507,   506,     0,
       0,   547,     0,   127,   424,     0,   414,   378,     0,     0,
    2126,     0,  1575,     0,     0,  1787,  1785,  1782,     0,  1775,
    1789,  1064,  1066,  1065,     0,  1063,     0,  1206,     0,   288,
     286,   287,   543,   822,     0,     0,     0,     0,   288,     0,
       0,  2177,     0,  2177,     0,     0,   288,   288,     0,     0,
       0,     0,   492,     0,   613,   611,   610,   612,     0,     0,
       0,     0,     0,  2177,   288,     0,     0,   601,  2347,     0,
       0,  2350,     0,  1866,  1495,     0,  2432,  1021,  2433,   337,
       0,     0,  1003,  1010,  1005,  1007,  1006,  1008,  1004,  1009,
     655,   660,   661,     0,  2434,  2319,  2325,     0,     0,   379,
     381,     0,  2141,     0,  2170,  2193,  2265,  2268,     0,  2288,
       0,   695,   718,   690,     0,     0,  1033,  1026,     0,     0,
    1049,   657,  1014,  1497,     0,     0,     0,   829,   826,   825,
     824,   226,   198,     0,     0,     0,   720,  2264,   916,     0,
       0,  1381,  1382,  1265,  1252,  1538,     0,     0,  1260,  1259,
       0,     0,     0,     0,  1242,  1241,  1240,  1380,  1505,     0,
    1239,     0,     0,     0,     0,  1266,  1266,  1264,  1312,     0,
    1243,     0,     0,  1518,     0,  1524,     0,     0,     0,  1272,
       0,  1270,     0,     0,  1348,     0,     0,     0,     0,     0,
       0,     0,  1296,  1297,  1606,  1379,  1495,     0,  1586,     0,
       0,  1258,     0,  1290,     0,     0,     0,     0,  1551,  1493,
       0,     0,  1326,  1491,     0,  1328,     0,     0,     0,  1485,
    1484,  1482,  1483,  1476,  1477,  1478,  1479,  1480,  1481,  1489,
    1309,     0,  1560,     0,  1308,  1927,     0,  1159,  1095,  1541,
       0,  1584,     0,  2326,  2328,  1375,  1992,  1991,  1990,  1989,
    1960,     0,  1954,  1955,     0,  1993,  1994,   239,   240,   236,
       0,     0,   195,   194,     0,   217,   218,   187,   216,     0,
     212,   213,  1443,  1442,   196,   186,   184,   209,   211,   210,
     208,   182,   199,   201,   202,   203,   185,   183,   234,   232,
       0,     0,     0,  1543,  1542,  1574,  1547,     0,     0,   288,
    1898,  1199,     0,  1159,  1051,  1053,  1054,     0,  1548,   988,
    1556,     0,  1092,     0,     0,   992,  1088,  1087,  1116,  1117,
     737,  1086,  1140,  1141,  1135,     0,  1155,  1155,  1132,  1123,
    1131,  1124,     0,  1136,  1293,  1148,  1076,  1129,  1075,     0,
    1151,  1149,  1130,     0,  1906,  1904,  1844,  1218,  1898,  1837,
    1898,  1893,  1823,  1284,  1285,  1286,  1287,  1288,  1289,  1824,
       0,  1821,  1283,  1822,   442,     0,     0,     0,  1790,     0,
    1771,  1796,  1958,     0,  1959,     0,     0,  1935,  1938,  1936,
    1939,     0,     0,  1218,  2322,  2009,  2322,  1218,     0,     0,
       0,     0,     0,     0,     0,   618,     0,     0,     0,  2288,
     229,   959,     0,     0,     0,     0,     0,   971,   372,     0,
     285,     0,     0,     0,     0,     0,     0,     0,   784,     0,
       0,     0,     0,   785,   782,   783,  2265,   801,   800,   798,
     759,   761,   760,     0,   763,   747,     0,   748,     0,     0,
     758,   766,   764,     0,     0,   854,   260,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   278,     0,
       0,     0,     0,   283,     0,     0,     0,   282,     0,     0,
       0,     0,     0,     0,   814,     0,   153,     0,     0,   427,
     439,     0,   431,   432,   429,   433,   434,     0,     0,     0,
       0,     0,     0,   426,     0,     0,   489,   488,   494,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   498,   499,     0,   500,     0,   155,     0,     0,
       0,     0,     0,     0,   207,   923,   927,   986,   985,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   310,     0,
     568,  1607,   544,     0,  1218,     0,  1214,  1210,  1279,  1278,
    1277,     0,  1224,  1233,  1230,     0,   938,   347,   453,   161,
       0,     0,     0,   556,   559,     0,   123,   172,   337,     0,
     171,   173,   175,   176,   177,   174,   178,   486,   490,     0,
     461,     0,     0,     0,     0,     0,   511,   510,   513,   512,
       0,   508,     0,     0,     0,   152,   421,   423,  1766,     0,
     339,   403,     0,   444,     0,     0,     0,     0,     0,  1768,
       0,  1788,     0,     0,     0,     0,  1062,     0,  1169,  1035,
    1160,  1171,  1162,  1164,  1200,  1567,     0,     0,  1033,     0,
     805,     0,   966,  2177,   288,     0,   803,   166,  1570,     0,
       0,     0,     0,     0,   807,   598,   158,     0,   288,   288,
     464,     0,   288,   160,     0,     0,     0,   456,   288,   615,
    2348,  2354,  2352,  1023,     0,  2430,  2431,     0,  1061,   659,
       0,     0,  2324,     0,   687,     0,   377,   701,     0,     0,
     700,   711,   702,   703,   697,   696,   704,     0,     0,   720,
    1028,     0,  1029,  1548,     0,  1025,     0,  1046,     0,  1044,
       0,  1196,  1048,  1037,  1015,     0,  1013,  1018,  1020,  1019,
    1017,     0,     0,     0,   684,     0,     0,   288,   915,     0,
    1501,     0,  1502,     0,     0,     0,  1537,  1533,     0,     0,
       0,     0,     0,  1509,  1510,  1511,  1508,  1512,  1507,     0,
       0,  1513,  1506,     0,     0,     0,     0,     0,  1263,  1262,
       0,     0,     0,     0,     0,     0,     0,  1351,  1383,     0,
       0,  1469,     0,  1495,  1523,     0,     0,  1274,     0,     0,
       0,     0,     0,     0,     0,  1495,  1529,     0,     0,     0,
    1441,     0,  1438,     0,     0,     0,     0,  1548,     0,     0,
       0,     0,  1587,  1294,  1310,  1559,     0,  1550,     0,     0,
    1317,     0,  1530,  1344,     0,  1349,  1332,     0,  1325,     0,
    1330,  1334,  1313,  1551,  1494,     0,  1492,     0,     0,  1311,
       0,  1306,  1304,  1305,  1298,  1299,  1300,  1301,  1302,  1303,
    1307,  1473,  1471,  1472,     0,     0,     0,  1329,  2035,  2171,
    2201,     0,  1106,  1106,  1094,  1104,  1558,     0,  1202,     0,
       0,     0,     0,  1454,     0,  2330,  2329,  1549,     0,     0,
       0,  1566,     0,     0,  1290,     0,   233,  1194,  1544,     0,
     621,   622,   620,  1218,  1058,     0,     0,  1206,     0,  1057,
     990,   989,  1555,  1001,  1093,     0,   735,   736,     0,   740,
       0,     0,  1133,  1147,     0,  1049,  1049,     0,     0,     0,
    1138,  1139,  1126,  1080,  1079,  1842,  1900,  1847,  1868,  1838,
    1871,  1292,  1818,  1860,     0,  1792,  1961,  1962,     0,  1952,
    1953,  1925,  1930,  1999,     0,  2323,     0,     0,   566,   565,
       0,     0,     0,   866,   832,   619,   867,   833,   960,     0,
     962,     0,     0,     0,     0,     0,   288,   969,   868,   284,
     970,   859,     0,     0,     0,   469,   470,     0,   780,   781,
     869,   834,     0,   860,   762,  1233,   746,     0,     0,   757,
       0,   756,  1233,  1233,   835,   162,   252,     0,   857,   264,
     277,   272,   273,   271,   288,   288,     0,     0,     0,     0,
     274,   269,   270,   266,   279,   280,   843,     0,   294,   297,
     281,   262,   265,   263,   251,     0,  1573,     0,     0,   809,
       0,     0,   846,     0,     0,   136,   138,   140,     0,     0,
     134,   142,   137,   139,   141,   135,   143,   133,     0,     0,
     132,     0,     0,     0,     0,   126,   874,   839,   430,   435,
     841,   438,   862,   436,  2100,  2155,  2271,     0,   476,   478,
       0,   483,   880,   840,     0,   861,   876,   848,     0,     0,
       0,     0,     0,     0,     0,   975,     0,     0,     0,   875,
     853,   864,     0,   847,   842,   863,     0,     0,   205,   204,
     206,     0,     0,     0,     0,     0,     0,     0,     0,   654,
     630,   653,     0,     0,     0,     0,     0,     0,     0,   624,
     323,   304,   305,     0,   303,   567,     0,     0,     0,  1215,
    1211,     0,     0,     0,     0,     0,     0,  1231,     0,     0,
     958,   958,   958,   958,   958,   958,   958,   939,   967,   452,
     472,     0,   587,   555,     0,     0,   378,   167,     0,     0,
       0,   460,   554,   552,   551,   553,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,     0,     0,   338,   340,
     342,   343,   344,     0,   415,   417,     0,     0,   407,     0,
       0,     0,     0,   726,   751,     0,   769,   752,     0,     0,
       0,   789,   794,   790,   772,     0,  1786,  1780,  1067,  1068,
       0,  1082,     0,  1171,     0,  1170,  1182,     0,     0,  1188,
    1186,     0,  1188,     0,  1188,     0,  1163,     0,  1165,  1182,
    1568,     0,     0,  1203,  1034,   288,     0,     0,   466,   288,
       0,   288,     0,   288,   288,     0,   900,   493,     0,   540,
       0,     0,   288,   600,  1496,     0,     0,  1926,  2320,   688,
     380,     0,   699,     0,     0,   710,   705,   707,     0,   714,
       0,     0,  1031,  1032,  1047,  1040,  1042,  1041,     0,     0,
    1038,  1498,   599,     0,     0,   288,     0,   715,  1111,  1499,
    1500,     0,     0,     0,     0,  1534,     0,     0,  1417,  1393,
    1395,  1232,  1407,     0,  1245,  1418,  1419,  1397,  1399,     0,
    1486,     0,     0,  1408,  1353,  1354,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1366,
    1365,  1409,  1468,     0,     0,  1521,  1522,  1410,  1275,  1276,
    1276,     0,     0,  1528,     0,     0,     0,  1415,  1420,     0,
       0,  1425,     0,  1446,     0,     0,     0,  1376,  1496,  1267,
    1268,     0,     0,     0,     0,     0,     0,     0,     0,  1350,
    1333,  1327,     0,  1331,  1335,     0,     0,     0,     0,  1319,
    1345,  1315,     0,     0,  1321,     0,  1346,  1106,  1106,  1106,
    1106,  1103,     0,     0,  1158,     0,  1143,     0,     0,     0,
    1454,     0,  1384,  1454,     0,  1974,  1976,  1977,  1978,  1979,
    1980,  1982,  1983,  1985,  1986,  1987,  1975,  1981,  1984,  1988,
    1965,  1966,     0,  1956,  1957,   189,     0,   214,   200,     0,
    1999,     0,     0,  1052,  1033,  1055,  1118,     0,  1487,   740,
     738,   739,  1120,     0,     0,  1154,  1153,  1152,  1121,  1125,
    1122,     0,     0,  1902,  1828,     0,     0,  1998,  2001,  2012,
    2010,  1840,   865,   831,   858,   958,     0,   371,     0,     0,
       0,   972,   451,     0,   450,   448,   468,   774,     0,  1233,
     749,   754,   755,     0,   347,     0,     0,   253,     0,   261,
     258,   275,   267,   276,   268,   291,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   871,   148,
       0,     0,     0,     0,   129,   128,   149,   147,     0,   146,
       0,   480,   481,   479,   475,     0,   482,   484,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     870,   836,   625,     0,     0,   626,   634,     0,     0,   627,
       0,     0,     0,     0,     0,     0,   636,   326,   311,   315,
     974,   974,     0,   316,   974,   312,   974,   309,   569,     0,
    2228,  1476,  1477,   563,   570,   560,   562,   561,   564,   535,
       0,     0,     0,  1216,     0,  2420,  2428,  2427,     0,  1290,
       0,   958,   957,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   358,     0,     0,   352,     0,     0,   794,
     346,   349,   350,     0,   465,     0,   557,   558,     0,   337,
       0,     0,   515,   509,     0,   571,   549,     0,  1209,   472,
    1024,   420,   339,   364,   399,     0,   413,     0,   401,   400,
     402,     0,   409,   936,   453,     0,   726,     0,     0,   750,
       0,     0,     0,   787,   791,   788,     0,     0,   765,     0,
     773,   743,     0,  1803,  1060,  1812,  1173,  1180,     0,  1161,
       0,  1187,  1183,     0,  1184,     0,     0,  1185,     0,     0,
    1180,     0,     0,     0,   806,     0,   288,   804,     0,   594,
       0,   596,   808,   288,   288,   501,     0,   457,   414,  1066,
     698,   712,   708,     0,     0,   681,   717,  1027,  1030,  1045,
    1043,   720,     0,   682,   719,  1503,  1251,     0,  1536,  1532,
       0,  1504,     0,  1516,  1515,  1352,  1517,     0,  1371,     0,
       0,  1363,  1361,  1362,  1355,  1356,  1357,  1358,  1359,  1360,
    1364,  1526,  1525,  1519,  1520,  1271,  1269,     0,  1412,  1413,
    1414,  1527,  1421,     0,  1440,  1439,     0,     0,     0,  1427,
       0,     0,  1436,     0,  1470,  1257,  1290,  1295,     0,     0,
    1318,  1531,  1336,     0,     0,     0,  1314,     0,     0,     0,
       0,  1323,  1486,     0,     0,     0,     0,     0,     0,  1098,
    1097,  1201,     0,  1145,  1454,  1454,  1454,  1390,  1457,  1452,
    1453,  1385,  1585,     0,     0,     0,     0,  1545,  1997,     0,
    1059,  1050,     0,  1119,  1134,  1127,  1135,  1846,     0,  1901,
    1963,  1964,     0,   373,     0,     0,   794,   879,   449,   775,
       0,   767,   345,     0,   856,     0,     0,     0,     0,   295,
     296,   299,     0,     0,     0,     0,     0,   588,   574,     0,
       0,   589,   590,     0,     0,   811,   812,   810,   144,   130,
     151,   150,   131,   145,   477,   844,     0,     0,     0,     0,
       0,   878,   852,   877,   850,   849,   851,   845,   503,     0,
     628,     0,     0,   629,   640,   638,   637,   639,   631,   327,
     125,     0,     0,     0,     0,     0,     0,     0,   537,     0,
       0,   542,   531,   533,     0,     0,     0,  1212,     0,     0,
       0,     0,     0,     0,  1217,  1225,   530,     0,   949,   948,
     947,   951,   950,   953,   952,   944,   943,   956,   955,   942,
     941,   946,   945,     0,     0,   356,   360,   361,   359,   351,
     794,   378,   411,     0,     0,     0,     0,     0,   517,     0,
     550,     0,  1208,   497,  1022,     0,  1767,     0,   362,     0,
     403,   341,   416,   417,     0,     0,   412,     0,   931,   455,
       0,     0,   725,     0,   753,   770,   771,     0,     0,   794,
     793,   895,   896,   893,   894,     0,     0,  1776,  1172,     0,
       0,  1174,     0,     0,  1176,  1178,     0,     0,     0,     0,
       0,  1571,  1454,  1204,  1205,   288,   467,   288,   288,   901,
     541,     0,     0,     0,     0,   706,   288,     0,  1535,  1406,
    1416,  1514,     0,     0,  1372,     0,     0,  1411,  1647,     0,
       0,  1444,  1445,  1426,     0,  2214,  1431,     0,     0,     0,
    1588,  1342,  1340,  1337,     0,  1338,     0,     0,  1320,  1316,
       0,  1322,  1347,  1102,  1101,  1100,  1099,     0,     0,  1448,
    1388,  1389,  1386,  1459,  1456,     0,  1967,     0,  1970,  1968,
    1969,  1973,  1290,  1056,     0,     0,  1903,   964,     0,   794,
     411,   768,   254,   255,   256,   257,   290,     0,   872,   837,
       0,     0,   580,     0,     0,     0,     0,   873,   838,     0,
       0,     0,   980,     0,     0,   632,   633,   310,     0,   313,
     318,     0,   319,   314,   317,   539,   538,   536,   532,   534,
    1213,     0,   820,   820,  2421,  2422,  2423,  2424,  2425,  2426,
       0,   535,   954,     0,     0,   348,   411,   385,     0,   353,
       0,   473,     0,   936,   339,   472,   516,     0,     0,   572,
     418,     0,   403,     0,     0,   363,     0,   407,     0,   404,
       0,   408,     0,     0,     0,     0,   445,     0,     0,     0,
       0,   727,   734,   734,   792,     0,   796,     0,   764,   741,
       0,  1806,  1802,     0,  1181,  1190,     0,  1177,  1175,  1166,
       0,  1168,   821,   595,   597,   502,     0,   709,   716,   288,
    1367,     0,     0,     0,     0,  1422,     0,  1423,  1428,  1432,
       0,  1429,  1430,  1339,  1343,  1341,  1324,  1142,  1144,     0,
    1083,     0,  1115,  1454,  1972,  1971,   215,  1488,     0,     0,
     411,   374,     0,   259,   298,     0,     0,   586,   575,     0,
       0,   591,     0,     0,     0,     0,     0,   635,   302,   325,
     320,   820,     0,   817,   816,   529,     0,   355,   354,     0,
     390,     0,   471,     0,   584,   932,   485,   518,   519,   514,
       0,   419,   407,   368,   366,   370,   367,   365,   369,     0,
     409,   405,   406,     0,   933,     0,   454,   982,     0,     0,
     293,     0,     0,   732,   737,   737,   795,     0,     0,  1202,
       0,  1804,  1179,     0,  1167,   683,  1368,     0,  1369,     0,
       0,  1434,  1433,  1447,  1449,     0,     0,  1462,  1114,  1387,
    1128,   378,   375,   289,     0,   578,   585,   576,   586,     0,
       0,   976,     0,   977,   978,   981,   815,   819,   818,     0,
     382,   383,   384,     0,   357,   386,   387,     0,   474,     0,
       0,     0,   409,   398,   329,   934,   935,   293,   734,     0,
     409,   728,   733,   740,   740,   794,   797,     0,  1807,  1809,
    1808,     0,  1189,  1370,  1437,  1424,  1435,     0,     0,  1458,
       0,     0,     0,   385,     0,   577,   593,   592,     0,     0,
       0,     0,     0,   388,     0,   389,   410,   583,     0,   522,
     330,   409,   737,   292,  1202,   730,   729,   742,   899,  1805,
    1450,  1451,     0,     0,     0,  1460,  1463,  1461,  1455,   390,
       0,   979,     0,   395,     0,   394,     0,   392,   391,   573,
     527,     0,   520,   523,   528,   526,   524,   525,  1202,   740,
     721,   898,   897,     0,     0,  1467,  1466,  1465,   535,   579,
       0,   393,   397,   396,   504,     0,   722,   731,   881,   892,
    1769,   882,   890,   887,   889,   888,   886,     0,   376,     0,
     521,     0,   891,   885,  1082,  1069,  1464,     0,   883,   892,
     522,   884,     0,   505
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   245,   246,  1572,  2236,  2805,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1602,   256,   257,  1199,
    1748,  2340,   258,  2160,   995,  2041,  2042,  2285,  2043,  2027,
    1438,  2044,  1573,  1594,   260,   261,  1432,  2019,   262,   263,
     264,  1615,  1616,  1579,  1792,  3983,  2227,  4110,  2767,  2768,
     265,   266,  2873,  1693,  2874,  3317,   825,  2307,  3640,  3641,
     267,  1745,  2927,  2928,  2929,  2930,  2898,  3360,  3361,  3362,
    2931,  3708,  3905,  2932,  2168,  1294,  1858,  1859,  4010,  4094,
    4095,  4096,  4177,  3710,  2938,  3392,  3716,  3889,  1765,  2371,
    2933,  2934,  3706,   268,   269,  2366,  1640,  1641,  2241,  3323,
     270,   853,  3224,  2899,  2900,  3916,   271,   813,   272,  1752,
     273,   274,   275,   276,  3364,  3890,  1645,  2817,  2818,  2819,
    2820,  3276,   277,  1750,  1646,  2349,   278,   279,   280,  2274,
     281,   282,   283,  1759,  2360,  2361,  3699,  3897,  4019,  4181,
    4182,  3881,  3651,  3652,  3653,   284,   285,   286,   287,  1744,
    2332,  2333,  3324,  1563,  1697,  2309,  2310,  3374,   288,  3597,
    3598,   854,  4100,  4077,   289,   290,  3601,  3602,   291,   292,
     293,   294,   295,   902,  1261,  1262,  2743,   296,  2059,   297,
    1178,  2860,   298,   924,   925,   299,   300,   934,  2484,   936,
    1870,  3015,  3016,  3455,  2450,  1114,   301,   302,  2459,  2487,
     303,   855,  3398,  3920,  3921,  4044,  2659,  3192,   304,   856,
    1598,  2196,  2378,  2945,  2946,  2198,  2199,  3407,  2200,  2947,
    2952,  2953,  2954,  3403,  3411,  3926,  3927,   305,  1596,  2189,
     306,   307,   308,  1620,  1130,   309,  4003,   310,  1231,   311,
     954,  1888,   312,  2207,  3238,   313,   314,  4210,  4221,  4222,
    4223,  3735,  4193,   315,  4212,   317,   318,   319,   816,  1150,
    1151,  1152,   320,  3718,   321,   322,  2326,  2897,  3343,   323,
     324,  2161,  2710,   325,   326,   327,  1738,   328,   329,   330,
     331,  1675,   332,   333,   334,   820,  1018,  1471,  1479,   335,
    1842,   910,   336,  1308,  2476,   337,  1275,  4213,  1876,  2461,
    2462,  2465,  4214,  1787,   340,  1880,  2470,  2473,  4215,  2063,
    2064,  2065,  2066,  2067,  2645,   342,  1225,  2385,  4216,  1392,
     345,   346,   347,   348,  1022,  1023,  1997,  2614,   943,  1485,
     980,  1033,  1034,  2078,  2079,  2097,  2098,  2089,  2661,  2091,
    2092,  2672,  2084,  3543,  3809,  2095,  2096,  1495,  1496,  2665,
     349,  2618,  2389,  2390,  2391,  2965,  2975,  3422,  3744,  2392,
    1303,  1016,  2393,  3146,  2398,  2919,  2920,  2201,  2317,  1719,
    1393,  1720,  2324,  1394,  1920,  1722,  1395,  1396,  1397,  1725,
    1398,  1399,  1400,  1401,  1904,  1961,  1402,  1403,  1939,  1062,
    1063,  1834,  2526,  1405,  1406,  3512,  3788,  3779,  2551,  2552,
    2034,  3508,  3970,  4063,  4064,  3551,  3549,  3813,  3972,  4132,
    4165,  4166,  1407,  2604,  1989,  1132,  1408,  3326,  1991,  2546,
    2149,  1902,  2493,  2509,  2510,  2523,  3062,  2530,  2535,  3085,
    3086,  2547,  2573,  1409,  2496,  2497,  3046,  1906,  1410,  1462,
    1463,  2005,  2569,  1474,  1475,  1020,  1411,  1412,  1413,  1871,
    1007,  3740,  1239,   670,  2775,  2054,  1154,   940,  1414,  1415,
    1416,   647,  1519,  1008,  1102,   649,  1103,   770,  1009,     2,
      75,   352,  2924,   353,  2955,   354,   355,   858,   859,   860,
    1217,  1218,  1777,  1779,  1524,  2130,   650,   651,   868,  3737,
    3932,  4051,   908,   356,   357,   358,   359,  1520,  2126,  1064,
      76,    84,    77,  1065,   395,   396,  2108,   360,   788,  2109,
    1501,  1044,  3203,   362,   363,   364,   365,   366,   905,   367,
    1046,   368,  1047,   369,   370,   371,   372,  1054,   373,  1503,
    1504,  3569,  1505,   374,   375,   673,   674,  1273,   376,   377,
    1082,  1083,  1084,  1289,  1853,  1543,  1544,  1545,   378,   666,
     379,   380,   381,  1534,  1535,   382,  2012,  2013,  2133,  2014,
     383,  2686,  2687,   384,  3170,  3171,  3819,  3172,   385,  2008,
     386,   387,  1011,  3208,   388,   784,   389,  1096,   652,   653,
     654,  1105,   773,   966,  2821,   775,   776,   655,   656,   657,
     658,   659,  1854,    78,  2694,  1855,  1417,  1418,  2003,  1419,
    1420,  1421,  1422,  1423,  1551,   663,  1072,  1265,  1266,  2695,
    1268,    82,  1269,   393,  3338,  1837,  1290
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3831
static const int yypact[] =
{
   -3831,   330, 12541, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, 18652, -3831,
   -3831, -3831, -3831, -3831, 83009,   332, -3831, -3831, -3831, 44837,
   -3831, -3831, -3831,   215, 55695, -3831, 63231,   750, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, 69825, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, 48147,  1208, -3831,
     224, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  1095,  3603,
   -3831, -3831, 59934, -3831,   413, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, 63702,   369, -3831,   793,  1047,    63, 11291, -3831,
   -3831, 45783, 58050, -3831, -3831, 70296,  1052,   144,  7931,  1095,
   18178, 64173, -3831,  1251, -3831, 42435, -3831, -3831, -3831, 56166,
   -3831, -3831, -3831, -3831,  1025, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, 69825,   372,   875, 42919, -3831, -3831, -3831,
   -3831, 69825, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, 64644, -3831,   964,   592, 70767, 71238, 55224, -3831,
    1147, -3831, 69825,   200, 47675, -3831, 71709, -3831, -3831,   889,
   -3831, 58521, -3831, -3831, -3831, -3831,   875, -3831, 48147, 40511,
   58521,  1112,   860, -3831, -3831, 72180, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831,  1388,  1075, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831,   369, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831,  1440, -3831,  1111,  1441,  1007,   895,
   -3831, -3831, -3831, -3831,  9393, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, 84410,   855, -3831, -3831, -3831,  1115, -3831,  1129,
   -3831, -3831, -3831,  1439, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,  1907, -3831, -3831, -3831,  1605, 83476, -3831, -3831, 65115,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, 45310, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,   126, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, 69825, 69825, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, 65115,
    1229, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
     718,  1467, -3831, -3831, 48147,  1502,  1502,  1706, 84410, -3831,
   -3831, -3831, 49091, 69825, 69825, 69825,  1516, 49091, 69825, 60405,
   37126, -3831, 69825, 69825, 60405, 69825, 58521, 69825,  1371, 69825,
   69825, 72651, 60405,  1494, -3831,  1736,    24, -3831, -3831, -3831,
   60405,  2191,   372, -3831, -3831, 60405,  1383, 49091, 69825,  1299,
    1403, 69825, -3831, 69825,  1695,  1194, 69825,  1325, 37614,  1511,
   69825, 69825, 69825, 69825, -3831, -3831,  1533, 69825, -3831, 69825,
   -3831, 73122,  1153,  1572,  1784,  1694,   597, -3831, -3831,  1453,
    1480, -3831, -3831,  1929, 65115, -3831, 60876, -3831, -3831, -3831,
     147, -3831, 58521, -3831, -3831, -3831, -3831, 49563, 69825,  1769,
   -3831, 73593, -3831,  1777, 50035, 74064, -3831, 38102,  1900, 74535,
   75006, -3831, -3831, 75477, -3831, 75948,  1629, 76419, -3831, 76890,
   -3831,  1750, 77361, -3831, 16931, -3831,  1531,  1618,  1544, -3831,
     369,   209, -3831,    95,   -20,   187, -3831, -3831,   151,   152,
     176,   209,  1556,  1556, 61347, 69825,  1793, -3831, -3831, -3831,
    -100,  1557,  1557,  1557,  1740,  -149, -3831,  1557, 60405, -3831,
   -3831, -3831, -3831, 58521,  1233, -3831, -3831,   372,    64,  1967,
   69825, -3831, 69825, -3831, 60405, 69825, -3831, -3831, -3831,  1972,
    1622,  1813, -3831,  1601, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,  1791,  1806,  1814,    28,   372,  1720, -3831, -3831,  1826,
   24543,   334, 65115,   372, 43403, 58992, 77832,   302, 46729,   372,
   65586,  1700,    24,  1846, -3831,   481, -3831,  2077,  1713,  1932,
     139,    24, -3831, -3831, 34743, -3831,  1012,  1703, -3831, -3831,
   58521, 84877, -3831, -3831, -3831, 78303,  1821, -3831,  2010, 25036,
   -3831, 69825,  1712, -3831,  1735,  1730,  1737, -3831, 60405,   694,
     694,  2124,   694,  1565,  1798, -3831,  2877, -3831,   860,  1095,
    1748, -3831, -3831, -3831,  1764, -3831,  1756,  1759, -3831,   722,
    2021, -3831, -3831, -3831, -3831,  1869,  1872,  1879,  1895,  1824,
    1899,   113, -3831, -3831, -3831, -3831,  2154, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831,  2271,  2256, 45783, 45783,  1936,     4,
     112,   353, -3831, -3831, -3831,  2142, -3831, -3831,  2128, 69825,
    1979, 69825, -3831, -3831, -3831, 78774, -3831, -3831,  1502,  1764,
    1012,  1904, -3831, -3831,   196, -3831,   232,   368,   397,  1045,
    1903,  1438,   127,  1953,  2799,  1922,   255,  3127, 69825, 69825,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    1923, -3831, -3831,  1924,   983,  1425,  4915,  1107,  3578,  1478,
     698,  2109,   -33,  2217,  1323,  3770, 69825,  1930,  2167,   436,
   -3831,   511, -3831,  2025,  2137,  2153, 49091,  1978, -3831, 69825,
   -3831, -3831, -3831, 49091, -3831,  2171, 38590, -3831, 69825, -3831,
   -3831, -3831, -3831,  2105, 69825, -3831, -3831,  2244, 69825, -3831,
    1557,   466,  2022,  2382, 52395, 69825,  2056,  2424,  2069, -3831,
   -3831,  2056, -3831, -3831, 69825, 69825,  2038,  1300,  2056,  2445,
    2446,  2125,  2248,   753,  1428,    67,  2371,  2056, 60405, 60405,
   60405,  2327, 69825, 79245, 49091, 69825, 66057, -3831,  2089,  1453,
   -3831, -3831, -3831, -3831, -3831,   554,  2159,  2410,  1904,   168,
    2411,  2118,  2416, -3831,  2161,  2421,  1922,  2429,  2136, -3831,
   79716, 80187,  2437,  1923, 69825,  2449,  2136,  2451,  2335,  2453,
     168,  2461, -3831,   906,  2463,  2348,  2468,  1364,  2136, 47202,
    2473,    46, -3831, 17406, 16931, -3831, 20144,  1334, -3831, -3831,
   -3831, -3831, -3831, -3831, 27501,   398,  1754, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, 69825,  1793,  1793,   265, -3831,
   -3831,  2177, 69825, 69825, -3831, -3831, -3831, 56637, 69825, 59463,
   -3831,   636, -3831,    57, 69825, -3831,  1618, 52395,  2578, 69825,
    2469,  2469,  2469, -3831, -3831, -3831,  2415, 69825,  2474,  2475,
   56637, 69825, -3831, 80658,  2182,  1448,   443,   346,  1353, 27501,
    2189,   239,   239,  2196, -3831, -3831, -3831,   429,  2200,  2202,
   -3831,   471,   471,  2349,  2204,  2206, -3831,   838,  2207, -3831,
    1405,  1042,  2211,  2212,  2214,  1687,   239, 27501, -3831,  2215,
     471,  2216,  2218,  2220,  1452,  2223, -3831,  1472,  2225,   406,
    1097,  2226,  2234, -3831,  2204, -3831,   341,  2235,  2236,  2239,
    2240,  2242,  2255,  2258, -3831, -3831, -3831, -3831, 27501, 27501,
   -3831, 23557, -3831,   372, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,    54, -3831,  1136,  8332, -3831, -3831,  2387, 27501, -3831,
   -3831,   158, -3831,  1012,  1151, -3831, -3831, -3831, -3831,   740,
   -3831, -3831, -3831, -3831,  1482,  1482,   143, -3831, 59934, 59934,
   -3831, -3831,   119,  2257, -3831,  1434, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, 46256,  2658, -3831,  3398,   511,   669,
    2606, 40983, 41467,  1793,  1793,  2492, -3831, -3831, 60405, -3831,
   27501, 39567, -3831,  1012, -3831,    29,  2508, 69825, -3831, 35215,
   -3831,   369, -3831, 10868, -3831,  1483,  1712, 69825, 69825,  2675,
   -3831, -3831,  1735, -3831, -3831,  1007,  1007, 27501,  1007,    71,
     976, 25529, 27501,  2570,  1078,  2572, -3831,  1565,  1798, -3831,
   -3831,  1764,  2294,  1349, -3831, 54282, 83943, 83943,  2537, -3831,
   -3831,  1287,    13,  2407,  2503,  1556,   911,  1114, -3831, -3831,
    2290, -3831,  2622, 59934,  2354, 45783, -3831, -3831,  2756, -3831,
    2756, -3831, -3831,    89,  2297, -3831,  2310, -3831, -3831,  1114,
    1114, -3831,  2786, -3831,  2302, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, 84410,  2306, 69825, -3831,  2309,  2311, -3831,
   84877,  1012, 40039,  1399,  2388,  2390, 48147,  2312,  2393,  2394,
   81129, -3831, -3831, -3831, -3831,   173,   611,  2396,   558, -3831,
   69825,  2502,   113,  2442, -3831,  2408,  2413,  2526,   113,   109,
   81600, -3831, -3831, -3831, -3831, -3831,  2637, 21630, -3831, -3831,
   -3831,  2418,  2397,   676,  2701,  2521,   -86,  1086,   115, 60405,
    2603,  2431,  2432,  2346,  1521,  2357, -3831,  2409,  2419, 51451,
    2530, 39078,  2440, 77832, -3831, -3831,  2443,  2444,   113, -3831,
    2747,   113,   113,  1298,  2750,  2448,   179,  1549,  2056,  2357,
    2739, -3831,  2375,  2454,   662, -3831,  2553,    59,  1717,  2357,
    2457,  2459, 69825, 69825, 69825, 69825, 60405,  2460,  2470,  2504,
   61818,  2471, -3831, -3831,  2476,  1726,  2357,  1488, -3831,  1150,
   -3831, -3831,    24, -3831, 69825, -3831, 60405,  1904, 52395,  2565,
    1922,   113, 69825, 69825,  1923,   812,   986,  2571, 69825,  2633,
    2436, -3831, -3831,  2056, -3831, 40039,  2038, -3831,  2399, -3831,
    2450, -3831,  2450,  2450,  2401,  2401,  2402, -3831, -3831,  1687,
    2450,  2401, -3831, 53339, -3831,   936,  1259, -3831,  2795,  2803,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  2051,
    1491, -3831, -3831, -3831, -3831,  2819, -3831, -3831, 52395, 69825,
   -3831,  2740,  2472, 48147, -3831,  2464, -3831, 69825,   146,   372,
    2479, 69825,  2641, 69825, 69825, 69825, 69825, -3831, -3831,   208,
       6, -3831, 61818, -3831,  2739,  2811,  -109,  1557, 46729,  2703,
   69825,  2605, -3831,  2426,  2836, -3831,  2438, -3831,  1556, -3831,
    2089, -3831,  1431, -3831,  2563, -3831, 30938,  2488, 49091,   168,
   -3831, -3831, -3831, -3831, 52395, 69825, 82071, 49091,   168, 69825,
   69825,  2749,  2512,  2752,  2514, 39078,   168,    76, 69825, 69825,
   60405, 69825, -3831, 69825, -3831, -3831, -3831, -3831, 69825, 60405,
   69825, 61818,  2754,  2758,   168, 69825, 69825, -3831, -3831, 20063,
    1361, -3831, 16931, -3831, 10868,  1501,  1793, -3831,  1229,    21,
   69825, 65115, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    1793, -3831, -3831,  2945,  2467, -3831,   740, 69825,  1537, -3831,
   -3831,  1560, 69825,   242, 49091, 69825, 69825, 60405, 60405, 69825,
    2541,  2257,  -156, -3831,  2517, 34271,  2597, -3831,   260, 58521,
    2662, -3831, -3831, -3831,  1577,  2254,   344, -3831, -3831, -3831,
   -3831, -3831, -3831, 59463, 56166,  2755,     0, 69825, -3831, 27501,
   24050, -3831, -3831, -3831,  2477, 10868,  2519, 27501, -3831, -3831,
   27501,  1556,  1556, 27501, -3831, -3831, -3831, -3831,  1275,  1556,
   -3831, 27501, 27501,  1556,  1556,  2450,  2450, -3831,  1988, 27501,
   -3831, 39078, 27501, 28980, 21136, 27501,  2552,  2506,  1556, -3831,
    1556, -3831, 27501, 23064, -3831, 27501,  2692, 27501,   669,  2693,
   27501,   669,  2913,  2913,   860,  2333,  4839,  2485, -3831,  2599,
    1556, -3831,  1556,   460, 52395, 27501, 48147,  2574,   108, 27501,
    2490,  2370, -3831, 27501,   649, -3831,  2491, 27501,  2573,    98,
   27501, 27501, 27501, 27501, 27501, 27501, 27501, 27501, 27501, -3831,
   29473,   142, -3831,  -111,   299, 57108, 24543,  2774, -3831,   228,
   20642, -3831, 65115, -3831, -3831,  1012, -3831, -3831, -3831, -3831,
   -3831,    89,  2493, -3831,  2510, -3831, -3831, -3831, -3831, -3831,
   60405,  2658, -3831, -3831,  2577, -3831, -3831, -3831, -3831,  1226,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,  2495, -3831, -3831, -3831, -3831, -3831,  2495, -3831, -3831,
    1793,  2501,  4149, -3831, -3831, -3831, -3831,  2775,  2777,   168,
   84410, -3831, 69825,    39, -3831, -3831, -3831,  2522, -3831, 57579,
   -3831, 25036, -3831,  1586,  2204, -3831,  2757, -3831,  2511, -3831,
    8659,  2757, -3831, -3831,    81,  2690,  2700,  2700, -3831,   184,
   10868,  2743,  1527, 10868,  1732, -3831, -3831, -3831, -3831,   342,
   -3831,  2570,  1078,  1614, -3831,  1764, -3831, -3831, 19124, -3831,
   19598, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    2518, -3831, -3831, -3831, -3831,   113,  2520,  2981, -3831, 45783,
   -3831, -3831, -3831,  1929, -3831,  1929,  3009, -3831, -3831, -3831,
   -3831, 65115,  1542, -3831, 16931, -3831, 16931, -3831,  2531,  1589,
    2611,  2615,  2659, 69825, 69825, -3831, 48147, 69825, 69825, 69825,
   -3831,  2897,  2540, 69825,  2781,  2783,  2546, -3831, -3831, 69825,
   -3831,  2737, 69825, 27501,  2742, 69825,  1167,  2759, -3831,   823,
   69825, 69825,  2729, -3831, -3831, -3831, 46729, -3831, -3831, -3831,
    2723, -3831, -3831, 53339, -3831, -3831,  1592, -3831, 52867, 50507,
   -3831, -3831,   825, 69825, 69825, -3831, -3831, 69825, 69825, 69825,
   69825, 62289, 69825, 69825,   762,   765, 69825, 62760, -3831, 60405,
   69825, 69825, 48147, -3831, 69825,  2735,   530, -3831,  3195, 69825,
   69825,  2554,  1597,  2642, -3831, 69825,  5722, 69825, 69825, -3831,
   -3831,   113, -3831, -3831, -3831, -3831, -3831, 69825, 69825,   113,
   69825,   113,  1465, -3831, 48619, 69825, -3831, -3831, -3831, 69825,
   69825, 69825, 69825, 69825,   251,   742,  2704,  2705,  2706, 69825,
   69825, 69825, -3831, -3831,  2678, -3831, 69825,  5722, 69825, 69825,
    2650,  2651,    60,  2730, -3831, -3831, -3831, -3831, -3831,  2827,
    2984, 69825,  2830,  2831,  2647,  2652,  2835,  1020, 69825, 69825,
   69825, 69825, 69825, 69825,  2838,  1020,  2778,    -7, -3831,  1603,
   -3831,  2614, -3831, 27501,  2998, 52395,  2604,  2607,  2681, -3831,
    2682,  1556, -3831,  1492, -3831,   208,  1541, -3831,   361,  5722,
    2894, 69825,  1610, -3831,  2621, 60405,  5722, -3831,  2185, 56166,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  2895,
   -3831,   372,  2038,  2038,  2038,  2038, -3831, -3831, -3831, -3831,
    1352, -3831,  2609, 69825,  2724,  5722, -3831,  2739,  2914, 60405,
   54753,  1691,  3012,  2889,   372,  2798, 60405, 22110,  3768, -3831,
   66057, -3831,  2626,  2892,  2898,  2910, -3831, 30459, 66528,  2623,
    1719, -3831, 66528, 66999, -3831,  1012,  2628, 26022,  2597,  1904,
   -3831,  3028, -3831,  2930,   168,  1922, -3831,  2136, -3831, 69825,
   69825, 69825, 69825,  1923, -3831, -3831,  2136,  2816,   168,   168,
   -3831,  2818,   168,  2136,  2753,  2928, 46729, -3831,    46, -3831,
   -3831, -3831, -3831, -3831, 27501, -3831, -3831,  2731, -3831, -3831,
   65115,  1929, -3831,  1638, -3831, 69825, -3831,  2136,  2680, 69825,
    2646, -3831,  2136,  2136,  2257,  2257,  2136, 67470,  3056,  2929,
   -3831,  1654, -3831, -3831, 24543, -3831,   521, -3831,   548,   715,
    2868, -3831, -3831, -3831, -3831, 52395, -3831, -3831, -3831, -3831,
   -3831, 69825,    66,  2837,  2655, 67470,  3043,   168, -3831,  1658,
   -3831,  1377, -3831,  1468, 27501, 27501,   160, -3831,  9418,  1662,
    2661,  2663,  1663, -3831, -3831, -3831, -3831, -3831, -3831,  2665,
    2950, -3831, -3831,  2669,  1704,  1707,  2672,  2673, -3831, -3831,
    4305,  2676,  9736,  2677, 28980, 28980,   571, -3831, -3831, 28980,
    2683, -3831,  1711,  8510,  2684,  2685,  2708, -3831,  2687,  2694,
    9765, 26515, 27501, 26515, 26515, 10096,  2684,  2695,  1731, 48147,
   10296,  1752, -3831, 27501, 48147,  4389, 27501, -3831, 27501, 69825,
    2697,  2698, -3831, -3831,  1988, -3831,  2710, -3831, 28980, 28980,
    2237, 23557, -3831, -3831,  2961, -3831, -3831,  2380, -3831,  2691,
   -3831, -3831,  2586,   133, 27501,  2490, 27501,  2779, 39078,  5276,
   27501,  1925,   917,   917,   138,   138,    96,    96,    96,  1316,
     299, -3831, -3831, -3831,  2709,  2223, 27501, -3831,  3164,  1853,
    1868, 60405,  5606,  8808, -3831, -3831, -3831, 30938,  2744, 27501,
   27501, 27501,  2711,  2881,  1783, -3831, -3831, -3831,  1881,  3009,
      89, -3831,    24,  1556,   460, 41951, -3831, -3831, -3831, 27501,
   -3831, -3831, -3831, -3831, -3831,  1789, 35215,  2488, 25036,  1012,
   -3831, -3831, -3831, -3831, -3831, 27501, -3831, -3831,  2286,  1702,
   27501,  1527, -3831, -3831, 60405,  2662,  2662, 27501, 27501, 25529,
   -3831, -3831,  2997, -3831, -3831, -3831, -3831,  1351, -3831, -3831,
   -3831, -3831, -3831, -3831,  2707, -3831,  2713, -3831,  2732, -3831,
   -3831, -3831, -3831,   116,  2716,  2715,  2722,   940, -3831, -3831,
   69825, 69825, 69825, -3831, -3831, -3831, -3831, -3831, -3831,  2951,
   -3831, 27501,   250,  2725,  2726, 69825,   168, -3831, -3831, 10868,
   -3831, -3831,  2784,  2810, 69825,  2553, -3831,  2986, -3831, -3831,
   -3831, -3831,  2924, -3831, -3831,  1491, -3831, 50507, 52867, -3831,
   52867, -3831,  1491,  1423, -3831,  2136, -3831, 52395,    11, -3831,
   -3831, -3831, -3831, -3831,   168,   168, 69825, 69825, 69825, 69825,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831,  1796, -3831,   550,
   -3831, -3831, -3831, -3831, -3831,  1515, -3831,   894, 52395, -3831,
   51923, 69825, -3831, 69825,  2962, -3831, -3831, -3831,  2899,   539,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  1220, 69825,
   -3831,  1556,  2901, 69825,  2800, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, 48147, 48147, 48147,  1801, -3831, -3831,
     372, -3831, -3831, -3831,  2820, -3831, -3831, -3831,  2958,  2959,
    2964,  2825,  2829,  2832,  2833, -3831,  2834,  2839,  2842, -3831,
   -3831, -3831, 69825, -3831, -3831, -3831, 69825, 69825, -3831, -3831,
   -3831,  1020, 52395,  2992,  1020,  1020, 69825, 69825,  1020, -3831,
   -3831, -3831,  3001,  3010,  3011,  3015,  3017,  3019,  1020, -3831,
   -3831, -3831, -3831,   466,  2529, -3831,   147, 36638,  4913,  2768,
    2607,  2776,  1556, 32841,   821,  2990,  2780, -3831,  1421,  3013,
    2797,  2797,  2797,  2797,  2797,  2797,  2797, -3831,  1329, -3831,
    2963,  2854, -3831, -3831, 48147, 36638,  1557,   146,  2926,  1342,
    3125, -3831, -3831, -3831, -3831, -3831, 60405,   208,   372,  1815,
   -3831, 52395, 69825, 65115,  1388,  2793, 60405,  2796,  2804, -3831,
   -3831, -3831, -3831,  1819, -3831, 52395,   411,  2980,  2979,  1388,
   69825,  2878, 60405,  2866, -3831,  1834,    18, -3831,   372, 46729,
   50979, -3831,  1897, -3831, -3831,  2993, -3831, 69825, -3831, -3831,
   33799, 32368,  1719,  2813, 69825, -3831,  2821, 30938,  3058,  2988,
   -3831, 30938,  2988,  1660,  2988,  3059, -3831, 35687, -3831,  2822,
    1566, 20642,  3008, 10868, -3831,   168, 52395, 69825, -3831,   168,
    2883,   168,  2884,   168,   168, 60405, -3831, -3831, 60405, -3831,
   69825, 61818,   168, -3831, 10868, 60405,   690, -3831, -3831, -3831,
   -3831, 69825,  2136, 49091, 69825,   921, -3831, -3831,  3004, -3831,
    1388, 69825,  1012,  2826, -3831, -3831, -3831, -3831,  3129,  3130,
   -3831, -3831, -3831, 69825, 56637,    88, 69825, -3831, -3831, -3831,
   -3831,  2841,  1843, 10570, 27501, -3831,  3137, 52395, -3831, -3831,
   -3831, -3831, -3831, 27501, -3831, -3831, -3831, -3831, -3831, 27501,
   -3831, 27501,  3116, -3831,  3262,  3262, 52395, 28980,  1243,  2216,
   28980, 28980, 28980, 28980, 28980, 28980, 28980, 28980, 28980, 29966,
     464, -3831, -3831, 27501, 27501,  3124,  3116, -3831, -3831,   678,
     678, 52395,  2840,  2684,  2847,  2852, 27501, -3831, -3831,  1844,
   48147, -3831, 27501,  9390,  1856,  2888, 10615,  1012,  5357, -3831,
    3215,   372, 27501,   713,   848, 27501,  1860, 27501,  3139, -3831,
   -3831, -3831,  2843, -3831, -3831, 52395, 27501, 28980, 28980,  3264,
   -3831,  4272, 27501,  2858,  6365, 23557, -3831,   875,   875,   875,
     875, -3831, 60405, 60405,  2623, 27501,  3135,  1866,  1867,  5501,
    2881, 36159, -3831,  1235, 27008, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    2860, -3831,  2880, -3831, -3831,   511,  2863, -3831, -3831,  8192,
     116,  2885, 69825, -3831,  2597, -3831, -3831,  2873, -3831,  1702,
   -3831, -3831, -3831,  6458,  3053,  2257, -3831, -3831, -3831, -3831,
   -3831,    71,  1556,  2890, -3831,  1929,  1881, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831,  2797,  6518, -3831, 69825, 69825,
    1880, -3831, -3831, 69825, -3831,  1903, -3831, -3831,  3132,  1427,
   -3831, -3831, -3831,  2949, -3831,   625,   998, -3831,  2953, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, 48147, 36638, 48147,  2954,
    2960,   711,    52,  2967,  2969,  2896,  2900,  2902, -3831,  2136,
     209,   372, 69825, 69825, -3831, -3831,  2136, -3831,   372,  2136,
     372, -3831, -3831, -3831, -3831, 48619, -3831, -3831, 69825,  3168,
      53,  1471, 69825, 69825, 69825, 69825, 69825, 69825, 69825,  2553,
   -3831, -3831, -3831,  2903,  1020, -3831, -3831,  3136,  3141, -3831,
    1020,  1020,  1020,  1020,  1020,  1020, -3831,    48, -3831, -3831,
    2424,  2424,   907, -3831,  2424, -3831,  2424, -3831, -3831,  2614,
    2873,  1556,  1114, -3831, -3831, -3831, -3831, -3831, -3831,   905,
    1556,  1849,  2906, -3831, 33320, -3831, -3831, -3831,  2135,   460,
   60405,  2797, -3831,   392,   945,  1295,  1506, 67941, 68412, 68883,
    2907, 69825, 28980, -3831,   804,   114, -3831,  3138, 60405,  2941,
   -3831, -3831, -3831,  2908, -3831, 52395, -3831, -3831,  3301,    21,
   60405,  2947,  3197, -3831,  1883, -3831, -3831, 69825, -3831,  2963,
    1544,  2952, 54753, -3831,  3170, 54753, -3831, 69825, -3831, -3831,
   -3831,  3276,  3003,  2956,   361,   372,  2866, 69825,  2920, -3831,
   50507, 27501, 27501, -3831,  2918, -3831,  2925,  4468, -3831,  2038,
   -3831, -3831,   632,  2943, -3831, -3831, 66528,  2931, 69825,  1719,
   30938, -3831, -3831,  2350, -3831, 30938,  3169, -3831, 30938, 69825,
    2932, 69825,  1887, 43882, -3831,  2933,   168, -3831, 69825, -3831,
   69825, -3831, -3831,   168,   168, -3831,  3048, -3831,  2938,  1431,
    2136, -3831, -3831,  3208, 67470, -3831, -3831, -3831, -3831, -3831,
   -3831,     0,  3221, -3831, -3831, -3831, -3831, 27501, 10868, -3831,
    2939, 10868,  6799, 10868,  3124, -3831,  1952,  3223, -3831,  1110,
    2942,  1952,  1481,  1481,   180,   180,    87,    87,    87,  3262,
     464, 10868, 10868, -3831, -3831, -3831, -3831,  2946, -3831, -3831,
   -3831,  2684, -3831, 27994, -3831, -3831,  2987,  2991,  2948, -3831,
   27501, 28487,  2955, 53339, -3831, -3831,   460,  2913, 28980, 28980,
    1559, -3831,   470, 27501, 52395,  1888,  1559,  1632,  2567, 27501,
   27501,  7346,   288, 27501,  6976, 60405, 60405, 60405, 60405, -3831,
   -3831, 10868,  3333,  3224,  2881,  2881,  2881, -3831, 82542, -3831,
   -3831, -3831, -3831, 27501,  1881,  1305,   372, -3831, -3831,   860,
   -3831, -3831, 39078, -3831, -3831, -3831,    81, -3831, 16931, -3831,
   -3831, -3831,   209, -3831,  1893,  1896,  2941, -3831,  2312, -3831,
    3022, -3831,  1329,  3144, -3831,  3145,   209, 69825, 52395, -3831,
   -3831,  2970, 69825, 69825,  1556,  1556, 52395,  2965, -3831,  1556,
    1556,  2966, -3831, 69825, 69825, -3831, -3831, -3831, -3831, -3831,
    2136,  2136, -3831, -3831, -3831, -3831, 69825, 69825, 69825, 69825,
    3253, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  3202,
   -3831,  1020,  1020, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    2056,  3285,   372,   372,  3156, 69825,   372,   372, -3831,   842,
    3292, -3831,  3231,   714,  2977,   118,  3263, -3831,  1996, 33320,
   33320, 33320, 33320, 33320, -3831, -3831,  3266,   209, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, 27501,  1526,  1952, -3831, -3831, -3831, -3831,
    2941,  1557,  3044, 48147,  3045,  1388,   395, 69825,  3294,  3286,
   -3831,   372, -3831, -3831, -3831,   749, -3831,  2994,  1124,  2996,
    1691, -3831, -3831, -3831,   545, 69825, -3831,   919, -3831,  3229,
    3282,  3002, -3831, 31417, -3831, 10868, 10868,   372, 53811,  1897,
   -3831, -3831, -3831, -3831, -3831,  3072, 69825, -3831, -3831, 69825,
    1949, -3831, 27501,  3005, -3831, -3831, 30938,  2350,  1955, 69825,
    1959, 52395,  2881, -3831, -3831,   168, -3831,   168,   168, -3831,
   -3831, 69825, 69825,  3290,  3181, -3831,   168, 67470, 10868, -3831,
   -3831, -3831, 28980,  3293, -3831,  3014, 52395, -3831,  3018,  1962,
    1965, -3831, -3831, -3831,  7305,  3062, 10868,  3113,  3023,  3025,
   -3831,   366,   366,   470,  1998, -3831, 28980, 28980,  1559,  1559,
   27501,  1559, -3831, -3831, -3831, -3831, -3831, 27501, 27501,  3057,
   -3831, -3831, -3831,  3183, -3831,  7375, -3831,  1114, -3831, -3831,
   -3831, -3831,   460, -3831,  3026,  1527, -3831, -3831,  3162,  2941,
    3044, -3831, -3831, -3831, -3831, -3831,  3081, 36638, -3831, -3831,
   31896, 39078, -3831,   711,  3029,  3030,    52, -3831, -3831,   924,
     689,  3073,  2136,  3320,  1020, -3831, -3831, -3831,   372, -3831,
   -3831, 69825,  3031, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, 49091,  3434,  3434, -3831,  1466,  1466, -3831, -3831, -3831,
   60405,   905, -3831,  7754,  3227, -3831,  3044,  3256,  3300, -3831,
    1999, -3831, 69825,  2956, 54753,  2963, -3831,   425,  3191, -3831,
   -3831,  3376,  1691,   887,  1219, -3831, 60405,  2979,  3167, -3831,
    3171, -3831,  3417,  3225,  3421,   372, -3831, 69825, 31417, 27501,
    2005, -3831, 69354, 22583, -3831, 52867, -3831,  2011, -3831, -3831,
   60405,  3064, -3831,  2015, -3831, 10868, 69825, -3831, -3831, -3831,
    2020, -3831, -3831, -3831, -3831, -3831,  1388, -3831, -3831,    88,
     501, 28980, 52395,  2027, 27501, -3831, 27501, -3831, -3831, -3831,
     -37, -3831, -3831, -3831,   366,   366,  1559,  2684, 10868, 69825,
   -3831,  3435,  3228,  2881, -3831, -3831, -3831, -3831,  3232, 60405,
    3044, -3831, 27501, -3831, -3831, 52395,  1922,   -98, -3831, 52395,
   52395, -3831, 69825, 69825, 69825, 69825, 69825, -3831,  2529, -3831,
    3031,  3434,   771, -3831, -3831, -3831,  3342, -3831, -3831,   798,
    3238,  3146, -3831, 48147,  3354, -3831, -3831, -3831, -3831, -3831,
   49091, -3831,  2979, -3831, -3831, -3831, -3831, -3831, -3831,  2033,
    3003, -3831, -3831,  3243, -3831,  3245, -3831, -3831,  2046,  7837,
    3111, 31417, 69825, -3831,   188,   188, -3831,  4468, 53811,  2744,
     157,  3089, -3831,  2047, -3831, -3831,   501,  2059, -3831,  2060,
    2071,  3128, -3831,  3074, -3831,  3474, 27501,   859, -3831, -3831,
   -3831,  1557, -3831, 10868,  2072, -3831, -3831, -3831,  3220,  2096,
    2134,  3077,  3122,  3077, -3831,  2136, -3831, -3831, -3831,  3391,
   -3831, -3831, -3831,   185, -3831,  3267,  3268, 69825, -3831, 69825,
    3483,  3090,  3003, -3831, -3831, -3831, -3831,  3111, 69354,  2346,
    3003, -3831, -3831,  1702,  1702,  1897, -3831,  3405, -3831, -3831,
   -3831, 69825, -3831, -3831, -3831, -3831, -3831, 69825,  3092,  2684,
      68,    68,  3094,  3256, 49091, -3831, -3831, -3831, 69825,  3218,
     417,   417,  3419, -3831,  3158, -3831, -3831, -3831,   711, 44360,
   -3831,  3003,   188, -3831,  2744, -3831, -3831, -3831,   792, -3831,
   -3831, -3831,    83,  3226,    37, -3831, -3831, -3831, -3831,  3238,
    1922, -3831,  3397, -3831,  3515, -3831,   692, -3831, -3831,  2965,
   -3831,  2145, -3831, -3831, -3831, -3831, -3831, -3831,  2744,  1702,
   -3831, -3831, -3831,  2058,  3505, -3831, -3831, -3831,   905, -3831,
    3254, -3831, -3831, -3831, -3831, 44360, -3831, -3831, -3831,  2080,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831,    83, -3831, 49091,
   -3831,  1397, -3831, -3831,  1408,  1737, -3831,  3105, -3831,  2080,
   44360, -3831,  2146, -3831
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3831, -3831,  3249, -3831, -1106,   -85, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
    1267, -3831, -3831,   -91,  1385,  2155,   970, -3831, -3831, -3831,
   -3831,  -956,   245,   456, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831,   730,  1378,   861,   806, -3831, -1593,  -499, -3831,   364,
   -3831, -3831, -3831,   739,  -244, -3831, -3831, -3831, -3831, -3831,
   -1648,  -119,   233, -3831,   229,  1409,   383, -3831,   -66, -3831,
   -3831, -3831, -3831,    23,   909,  -927, -1272,  1178,  -505,  -537,
    -459,  -453,  -498, -3831, -3506, -2853, -2664, -3564, -3831, -3831,
   -3831,   261, -3831, -1642, -3831, -3831,  1886, -1518, -3831,  -991,
   -3831, -3831,   712,  1475,   259, -3831, -3831,   -25, -3831, -3831,
   -3831, -3831, -3831, -3831, -3236, -3831, -1584, -3831,   379, -2718,
     841, -3831, -3831, -3831,  1912, -3831, -3831, -3831, -3831, -1683,
   -3831, -3831, -1641, -3831,  1339,   748, -3831, -3831, -3831,  -564,
    -538, -3831, -3702,    15,    20, -3831, -3831, -3831, -3831, -1172,
   -3831,   766, -2784, -1098, -3831, -3831,   799, -3831, -3831,  -474,
    -167,  1937, -3831,  -401, -3831, -3831, -3831,  -166, -3831, -3831,
   -3831, -3831, -3831, -3831, -1795,  2301, -1084, -3831, -3831, -3831,
   -3831, -2146, -3831,  3495,   287, -1635, -3831,  -154,  -133,  2383,
   -1267, -2411,   235, -3831, -3831, -1829, -3831, -3831, -3831, -2349,
   -1633, -3831,   294,  -235,  -348, -3188, -2974, -3072, -3831, -3831,
   -1228, -3831, -3831, -3831, -1485,  1495, -2157, -3831, -2140,   295,
   -3279,  -969, -2861, -3831, -3235,  -352, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -1218,  -827, -3831, -3114, -3831, -3831, -3831,
   -3831,  1017, -3831,   205, -3831, -3831, -3831, -3831, -3831,  -496,
    -531, -3831, -3831, -3831,   253, -3831, -3831, -3831,  1631, -1120,
    -923,  2702, -1632,  -191, -3831, -3831, -3831, -3831, -2678, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831, -1299, -3831, -3831, -3831,
   -3831, -3831, -3831,  1635,  3542,  -230, -3831, -3831,  2224, -3831,
   -3831, -3831, -3831, -3831, -3831,  2433,   331,   -34, -3831, -3831,
     691, -2280,   -30, -3831, -3831, -3831, -3831,  -420,   -29, -3831,
    1067, -3831, -3831, -1957, -3831,  2441,  1276,   267,   -56,     5,
    -241,  -237,  -206, -3831,  2699,  2241, -3831, -3831,  -213,  1375,
   -3831, -1029, -1024, -3831,  1064,  -882,  1619,  1053,   161,  -330,
   -3831, -2585,   525, -3831, -3831,  -878,  1633, -3831,  2243,  1643,
   -3831,  1669,  1118, -2320,  1362, -2273,   767,  -324,    -8,  -158,
    2738,  2887, -3831, -2967,  1103, -3254,   385,  2489, -1941, -1670,
   -3831, -3831, -1296,  3991, -3831, -3831, -3831, 10494, 12486, -3831,
   -3831, 13128, 13315, -3831, -1192,   654, 13573,  4185, -1309, -1692,
   -1418, 12593, -2301,  -329, -1684, -3831, -3831, -3831,  -188,   667,
    -825, -3831, -3831, -3831,  -357, -2537,  -356, -3831, -3831, -3831,
    -358, -3830,  1254, -3831,  -799, -3831, 14180,  1116, -3831, -1256,
   -1283, -1797, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -1668,
   -2915,  -842,  1192, -3831, -3831,  1285, -3831, -3831, -3831, -1381,
   -1019, -1936,  1199, -1935, -3831, -1021,  1320,  1794,   206,  -970,
    2911,  1641, 11345,  -132, -2162, -1440, -1069, -3831,  -750, -3831,
      25,  2935,  -163,  5509,  5677,   105,   117, -2748, -3831, -3831,
   -3831,  2509, -3831, -3831, -3831, -3831, -3831,  3174,   830, -3831,
    2575, -3831,  1413,  2009, -3831, -3831,  1672,  -916,   -43, -3831,
    -319, -3831,  -136, -3831, -3831, -3831, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831, -3831, -3831,  2296,    97, -3831,   -44,
   -3831, -3831, -3831, -3831, -3831,  3441,  -297, -3831,  2905,  -284,
   -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831, -3831,  2304,
    1701, -3831,  2714, -3831, -3831, -3831,   -61,  2515, -3831, -3831,
   -3831, -1138,  1272,  2728,  -925,  1667, -3831, -3831, -3831, -3831,
   -3831, -3831, -3831, -3831,  1677, -3831, -3831,  1185, -1938,  1680,
   -3831, -3831,   613, -3831, -3831,   272, -3831,   621, -3831,  2403,
   -3831, -3831, -3831,   650, -3831, -3831, -3831,  -589,  9339,   212,
      14,   167,   934, -3831,  -103,   -28,  2324,  7392, 12415,   141,
      31,  -117, -3831,  3436,  1690,  1396,  -972,    61,  1982, 10871,
     410, -1077,     7,    -2, -3831,  2372,  -624, -1125,  2576,  -733,
   -1780, -3831,  3844, -3831, -1840, -3831,  -886
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2292
static const short yytable[] =
{
      80,  1131,   928,  1026,  1548,  1295,  1296,  1497,  1798,    79,
    1300,  1196,  1498,  1010,   774,  1433,   869,  1499,  1835,   857,
    2223,  1861,   343,   928,  1884,  1806,  1567,    74,  1624,   852,
    2428,  1673,  1440,  1761,   361,  2451,   935,  2322,  1662,  1131,
     398,  2738,  1101,  2314,   338,  1914,  1915,  1115,   339,   341,
     391,   672,  2432,  1895,   973,  1080,   391,   774,  2739,  2741,
    1243,  1941,  2258,  1005,  1930,  1041,   948,  2962,  2777,  1448,
    1518,   814,  1015,  2628,  3035,   974,  3194,  1182,  1042,  2364,
    1736,  1561,  2056,   344,  1696,  1740,  3152,   662,  1131,   672,
     969,  3410,  1746,  2115,  2117,  2118,  3271,   969,  3273,   969,
    2341,  1763,  2394,  2492,  1028,  2644,  2342,  2343,   861,  1546,
    3019,  1036,  2197,  2344,  1456,  2345,  2346,  3563,  2984,  2976,
    2978,  3367,  2253,   994,  3692,   774,  2155,  1228,  3729,  3327,
    1789,   771,  2649,   901,  1236,  1957,  2652,  1836,  2424,  1908,
    1909,  1831,  1037,  3703,  1771,  1595,  3207,  1075,   779,   862,
     660,  1493,   826,  2010,   413,  1494,  1542,  3327,  3066,  2869,
    1526,  1527,   413,  1790,  1927,  1760,  2677,  1964,   413,  2902,
    3493,  1267,  2057,   824,   771,  3748,  4162,  3750,  1959,  4006,
    2056,   397,   941,   350,  1278,   413,   413, -1474,  3401,   350,
     927,   779,  2205,  1790, -1474,   351,  2848,  1097,  3235,  1967,
    2362,   351,  2693,  2369,  3907,  1790,  2697,  2214,  2871,  1964,
    2567,   927,  1575,  3344,  3345,  3346,  3347,  3348,  3349,    35,
    2486,  4163,   350,  3064,  3065,  -328,   929,    41,  3080,    35,
     413,  2601, -2167,   873,   351,  2567,  4163,    41,  2602,   835,
    1221,  1967,   771,  1321,   664,  1291,  4196,   929,  2991,  1025,
    2993,  3066,  -125,  1690,  2617,  4076,  1530,  4061,   778,   779,
     413,  2605,   785,  3617,   786,   350,  3981,  3113,  3114,  3599,
    1298,  2562, -1610, -1610, -1610, -1610,  1280,   351,  2082,  1306,
    1148,  3033,   413,  2184,   772,  1790,  3688,  2656,  2210,   978,
     390,  1878,  2017,  2338,   837,  2116,   390,  1657,   343,  2162,
    2458,   778,  1537,  1824, -1578, -1578, -1578, -1578, -1612, -1612,
   -1612, -1612,   964,  2163,  1576, -1266, -1266, -1266, -1266,   964,
     338,   964,  4008,   259,   339,   341,  1658,   772,  1673,   390,
       3,   316,  4194,   350,   391,  3871,  2828,  2211,   413,  1684,
    1599,  3830,  2829,  2466,  1800,   351,   399, -2110,   968,  3044,
    2018,  1299,  1069,  1035,  1659,   968,  1071,   968,  1426,   344,
    4140,  3872,  2185, -1266,  2083,  2339,  2657,  1131,   391,   778,
    1964,  3600,   390,  2880,  1149,  4197,  2162, -1490,    37,    38,
      39,    40,   979,  2356, -1490,  2164,  2606,  4226,  2370,  1838,
    1537,  1288,  1059,  2058,  1999,   772,  4022,  1292,  3236,  1619,
    1851,  1852,  1967, -2195, -2213,  2448,  1677,  1941,  1914,  1915,
    1995,  1791,  2872,  1680,  3618,  1930,  4072, -1261, -1261, -1261,
   -1261,  3689, -1266, -1266, -1266, -1266,   413,  1006, -2239,    37,
      38,    39,    40,   844,  4062,   845,  1006,  3066,  2830, -2169,
     390,  1791,  1600,  1528, -1608, -1608, -1608, -1608,    37,    38,
      39,    40,  2292,  1791,  2357,  3886,  2028,  1577,  2467,   665,
    2045,  2045,  2164,  3590,  1773, -1261,  2296,   350,    37,    38,
      39,    40,  1437, -1607, -1607, -1607, -1607,  2215,  2259,   351,
     874, -2167, -1276, -1276, -1276, -1276,   857,  3639,  2023,  2216,
    2849,  1099, -1474,  1068,  3929,  3940,  4218,  4164,  2667,  3327,
    1800,   350,  3402,  2363,  1042, -1659, -1659, -1659, -1659,  1559,
    1908,  1909,  4164,   351,  1578,  2568,  2165, -2212,  1927, -1237,
   -1237, -1237, -1237,  2314,  2312,  1998,   787,  3022,  1299,  1879,
    2249,  1830,  2251,  1791,  4173,  3066,  2603,  3572,  2217,  2646,
    3127,  1964,    37,    38,    39,    40,  1826, -1233, -1233, -1233,
   -1233,  1960,  2286,  1971,  1972,  1533,   875,  1879,   876,  3771,
     244,  1307,  3668,    58,  1743,  1076,  1299,  2048,  2049,   922,
     923,    58,  3066,  1967,   390,   861,  1800,    58,  2660,  2289,
    3078,  2831,   815,   922,   923,  2443,  2011,  2308,  3454,  1988,
      56,  2178,  2726,  2165,  3980,    58, -2110,  2183,  3231,   259,
    3232,   922,  1517,  1542,  1975,  2287,  2166,   316,   390,  2131,
    2832,  2883,  2495,  3547,  1601,  2101,   862,  1077,  2056,  2102,
    3068,  3107,  4141,    55,  2627,  2318,  2449,  2188,  1985,  1986,
    1987,  1988,  2468,    55,  2358,  1571,  1071,  2239,  1317,    58,
    2242,  2243,  3066,  2489,  2491,  2359,  2323,  3419,  1138,  2469,
    1288,  3423, -2195, -2213,  2499,  2722,  -125,  2502,  1996,  4016,
    2772,  -125,  1111,  3667,  1781,  2514,  2515,  -125,  -125,    58,
    3075,  3076,  3077,  3078, -1610,   922,   923, -2239,  2532,  2534,
    1276,  1088, -1490,  2166,  2668,  3069,  1903,  1056, -2169,  2548,
    2293,    58,  3174, -1610,  3297,  3298,  1450,   922,   923,  1186,
    2436,  2375,  3180,  2394,  1831,  3292, -1578,  2369,  3295,  3296,
   -1612,  4174,  3299,  3185,  1015,  1782,  2705, -1266,  3068,  3024,
    3908, -2212,  3306,  1460, -2292, -1578,  3388,  1461,  2173, -1612,
    1223,  2086,  3909,  2518,  2519,  4045, -1266,  3325,    37,    38,
      39,    40,  1057,  1085,  2624,  2319,  3026,  1508,  1277,  1233,
    1279,  2169,  1281,  1424,  1670, -2292,   950,  2583,  1282,  4004,
     391,  3262,  2002,  2481,   679,  3325,  3476,  1148,  4115,  3481,
    3482,  3483,  3484,  3485,  3486,  3487,  3488,  3489,  3490,  2087,
      57,  2170,  4175,  1483,  3066,  1302, -2212,  1983,  1984,  1985,
    1986,  1987,  1988,  1903,  2234,  2170,  1177,  4017,   771,  1783,
    1781, -2212,  2162,  2724,  4176,  3067,  1874,  3731,  3518,  2205,
    3408,  2032,  2373,   413,  1214,   779,  2163,   819,  1425, -1261,
    1179,  1071,  1131,  4018, -1266,  3068,  3527,  3528,  1211,   951,
      56,    57,  1384,  1538,   789,    58,  1652,  1081, -1261,  1059,
    2372,  1539,  1540, -1266,  1800,  2773, -1608,  1386,  1784,  2253,
      57,  3449,  1302,  2033,  3073,  3074,  3075,  3076,  3077,  3078,
    2174,  1149,  4202,  1936,  1272, -1608,  1691,  1692,  3410,   969,
      57,   790,  4087,   969,    58, -1607,  1484,  1653,  3732,  2584,
    4157,  1937,  4191,  2585, -1276,  3910,  3648,  4086,  2164,   350,
    3069,  1753,  3894,   350, -1607,  1436,  1671,  2454,  2455,  1446,
    1451,   351,    80,  1938,  3561,   351,   122, -1659,  2222,  3263,
    3025,    79,  3900,  2171, -1246, -1246, -1246, -1246,  2586,  3066,
    4152, -1237, -1233,  1430,   126,   778, -1659,  3583,  3594,    74,
    2320,  1785,  1754,  2394,  2175,  1783,   927,  3027,   927,  1071,
     927,   672,  3177,  3519,    57,  1305,   927,  1283,  1284, -1233,
    2435,   772,  3073,  3074,  3075,  3076,  3077,  3078,  1983,  1984,
    1985,  1986,  1987,  1988,  2439,  1452,  1086,  3068,  1913,  2256,
    1509,  1215,   929,  1322,   929,  3891,   929,  3686,  2413,  3251,
    1317,  1427,   929,  1466,  1784,  1439,  1442,  1443,  1964,  3073,
    3074,  3075,  3076,  3077,  3078, -1233,   390,  2728,  1100,  4203,
     390,   952,   953,  1100,  4088,  1006,  1131,  3810,  3811,  3812,
    1006,  1672,  1006,  3733,  4090,  3865,  3650,   213,  1006,  2165,
    1967,    37,    38,    39,    40,  1968,  1006,  2887,  4023,  1654,
    3595,  1006,  3069,  1100,  3247,  3687,  2396,  3912,  2399,  4192,
    2587,  4155,  4156,  3901,  1814,  3913,   221,  2405,  2113,  3248,
    3993,  3685,  1386,  3984,  4030,  3070,  3071,  3072,  4024,  3073,
    3074,  3075,  3076,  3077,  3078,  1548,  2297,  1785,  1521,  3734,
    4113,  4114,  2833,  3866,   662,   662,  2729,  3648,  1006,  1550,
     232,  3252,  4117,  1100,  1755,  1815,   927,  3028,  1549,  3327,
    1100,   964,   235,  2835,   906,   964,    37,    38,    39,    40,
    3741,  2834,  3068,  2114,  2521,  3745,  1541,  3325,  3747,  2166,
     821,  1655,  3766,  3596,  1115,  3671,   350,  4207, -1273, -1273,
   -1273, -1273,   929,  2553,  2299,  4025,  2556,   968,   351,  2298,
    4091,   968,  1131,  1875,  2682,  1936,  2756,   660,   660,  2758,
      57,  3226,  1547,  3738,  1006,  3994,  3649,  1969,  3630,  1006,
    1026,  1970,  3029,  1937,  3633,  3634,  3635,  3636,  3637,  3638,
    1006,  3584,  1012,  2094,  2636,  2300,  1756,  3069,  2173,  4102,
    1546,  1971,  1972, -1276, -1276, -1276, -1276,  2989,  4189,  1694,
    2912,  2913,  2914,  2915,  3451,  2757,  1973,  4190,  2759,  1800,
    4092,  1006,  3914,  2121,  1386,  2994,  2122,  3070,  3071,  3072,
    1059,  3073,  3074,  3075,  3076,  3077,  3078,  3650,  4130,  3644,
    1006,  1285,    37,    38,    39,    40,  1006,  3791,  3792,  2205,
    1848,  4206,  1975,   390,  3253,  3560,  2212,    37,    38,    39,
      40,  1304,  4131,   780,  1006,  3722,  1976,  1816,  3042,  1743,
    3978,  2069,  1844,   781,  3465,  1877,  1845,  1846,  2076,  2077,
    2808,  2081,  3230,  3254,  3410,  3645,  2143,  1442,  2811,  2341,
    2813,    80,    80,  1272,    80,  2342,  2343,   872,  2627,  1042,
      79,    79,  2344,    79,  2345,  2346,  3757,   938,  3758,  1037,
    1037,   344,  1037,  2394,  1489,   942,  3093,  2394,    74,    74,
    2123,    74,  3773,   949,  3774,  4098,    37,    38,    39,    40,
    3585,  2985,    37,    38,    39,    40,   344,  1029,  1978, -1233,
    1001,    37,    38,    39,    40,  3116, -1246,  2301,  3446,  1817,
   -1233,  3903,  1913, -1233,  1566, -1233,  2085,  2859,  1017,  1386,
    1901,   782,  3070,  3071,  3072,  1919,  3073,  3074,  3075,  3076,
    3077,  3078,  1622,  3389,   130,   131,   207,    35,  1491,  1917,
    1957,    37,    38,    39,    40,    41,  3949,  1019,  2055,  3904,
    4026,  1030,  1100,  3147,  3148,  2086,  4104,  2015,  2016,  1100,
    1623,    37,    38,    39,    40,  1564,  2980,  3453,   413,  1944,
    3992,    37,    38,    39,    40,   672,   672,  1964,   213,   822,
    4027,  1958,  1492,  1936,  3474,  1038,  1955,  3586,  1979,  2302,
    3587,  1963, -2292, -2292,  1565,  1983,  1984,  1985,  1986,  1987,
    1988,  1937,  2001,  2087,  1006,  1006,  1006,   221,  3494,  1967,
    1100,  3454,  3775,    57,  1800,  3477,  3937,  3478,  1642, -1244,
   -1244, -1244, -1244,  1938,  1031,  2883,  4069,  1643,  4150,  1571,
    2503,  3211,  1442,  3220,  1048,  2030,  4154,  2887,   916,  1442,
    1442,   232,  2112,   969,  1521,  3350,   783,  4028,  1521,  1521,
    2244,  2722,  2128,  2055,  1049,  3673,  2115,   917,   789,  3351,
    3002,  3950,   927,   969,  1050,   771,   927,   927,   391,   391,
     672, -1235, -1235, -1235, -1235,  3855,  3856,  4188,  1642,   975,
    1035,  1035,   779,  1035,  3658,  3964,  3965,  2723,    57,  3352,
    2282,  3353,  2504,  1006,   244,   790,   969,  1460,   929,  1089,
    2283,  1461,   929,   929,  2113,  1757,   789,  2691,   835,   771,
   -1273,  1090,  1091,   662,  2124,   391,  1006,  3264, -1238, -1238,
   -1238, -1238,  2147,  2284,  1758,  1208,   779,  2219,  1444, -1273,
    2120,  1092,  1284,  1032,  1093,  3479,  2138,  2140, -1236, -1236,
   -1236, -1236,  3066,   790,  1936,  3480,  1644,  2505,  2132,  2021,
    2506,  3151,  1051,  1209,  2137,  2139,   350,  1574,   789,  2114,
    3354,  3925,  1937,   837,  1821, -1276,  1027,  2277,   351,  2245,
     771,  2246,    37,    38,    39,    40,   660, -1070, -1073,  1521,
    1625,    56,   963,  1822,  1940,  1521,    58,   779,  2167,  2056,
    1663,  1000,   778,  1210,  2527,   790,  1189,   927,  1190,  2724,
     350,   350,   350,   927,    57,   413,  1045,  3818,    37,    38,
      39,    40,   351,   351,   351,  1052,  2206,  2244,   772,    57,
    1964,  3355, -1867,  1962,  1026,  1521,  3356,  2396,  1521,  1521,
    2334,  2627,  2257,   929,  2045,  1094,     8,  3665,  2000,   929,
    4056,  3229,  3350,   927,  2507,  2329,   927,   927,   350, -1070,
   -1073,  2336,  1967,  2402,  1006,   350,  1059,  1968,  1081,  2916,
     351,   350,  3357,   390,  2917,   964,  3675,   351,  2365,  1113,
    2889,  3619,  1661,   351,  3358,  1095,   207,  1053,  1521,   929,
    1271,   413,   929,   929,  3195,   964,  3352,  3325,    57,  3092,
    3620,  3094,  3095,  3066,    57,  3628,   927,   778,  3997,  3175,
    1623,   968,   844,    57,   845,  1087,  1936,   390,   390,   390,
    2437,  2471,  1098,  2633,  1208,  3432,  2627,  3796,   964,  2150,
    4014,   968,  2890,   772,  1937,  3068,  2394,  1192,  3340,  1193,
    2483,  2394,   929,  2917,  2394,  2508,  2245,  2347,  2246,  1140,
    -337,    55,  3370,    57,  1146,  1626,  1940,   771,  2151,   791,
    2482,  3133,  3359,  2643,   968,   390,  1442,  3462,  1568,   213,
    1147,  1489,   390,    57,   779,  1490,  1042,   823,   390,  1571,
    3495,  3496,    56,    57,  1627,  4046,  2152,    58,  3826,  1131,
     903,  2388,  1210,  1970,  3817,  2006,  1184,  1569,   221,  2007,
    3069,   207,  1181,  2381,  2891,  2892, -1070, -1073,  1650,  2208,
    1925,  1926,  2213,  1971,  1972,  1006,  3007,  2893,  2280,  3875,
    3876,  3877,  3878,  3879,  3790,  1570,  1185,    80,  3884,  2480,
      80, -1244,   232,  3356,  1832,  1491,    79,  1651,  1833,    79,
    3501,   976,  3525,  3789,   235,  3249,  2883,  2281,   350,  2105,
    2106,  2477,  2260,  3202,    74,  2478,  2479,    74,  1188,  3188,
     351,  1832,  1006,  2565,  1975,  2431,  1639,  2396,  1649,  3357,
    2968,  2894,  1197,  3039,  3250,  1666,  2969,  2434,  1976,  1492,
    1025,  3358,  1006, -1235,   778,   244,  3068,  2383,  2384,  3155,
     344,  3925,  3156,  3157,  1571,  4228, -1070, -1073,  4229,  2670,
    2671,  1839,  2970,  3158,  3159,  3160,  1480,  3161,  3162, -1070,
     772,  1203,  3163,  3164,  3165,  3233,  2511,  3425,   801,  3580,
    1913,  2662,  2156,  1840,  1913,  2250,  2156,  2972,  1212,   156,
   -1238,  1213,  2224,  2887,  1216,  2969,  2500,  2501, -1070, -1073,
    1234, -1070, -1073,  1900,  2513,   244,  3574,  3575,  2516,  2517,
   -1236,  3069,  2895,  1841,  2896,   390,  3661,  3662,  3663,  3359,
    2224,  2970,  1386,  2538,  3040,  2539, -2292, -2292,  3041,  3073,
    3074,  3075,  3076,  3077,  3078,  2572,  2971,  2225,  2226,  3368,
     771,  2070,  1219,  2071,    57,  2560,  2972,  2561,  1913,  1913,
    1566,  2156,  2395,  3405,  1100,  2948,  1964,   779,  1230,  2433,
     174,  2434,   413,  1100, -1114,  2225,  2226,  1253, -1114,  2973,
    1259,  3642,  3643,  1581,  1244,  3646,  1006,  3647,  2222,    56,
      57,  1384,  1538,  3066,    58,  1006,  2707,  2634,  1967,  2974,
    1539,  1540,   391,  1968,   904,  2444,  2132,  2445,    58,  3922,
    1979,  1274,  4001,  1582,  3166,  1288,  2222,  1983,  1984,  1985,
    1986,  1987,  1988,  2055,  1293,  1673,  1812,  1297,  2446,  1964,
    2445,  1460,  2394, -1578,  2679,  1461,  2679,  1827, -1114,  1316,
    1100,   350,  1055,  1006,  1006,  2474,  1314,  2475,  3188,  2654,
     391,  1309,   391,   351,  2653,  1006,  1800,  2699,  2974,  2475,
    2736,  1967,  2737,  2261,  1315,  2779,  1968,  2780,  1071,  1583,
    1317,  2875,  2279,  2876, -1137, -1137,  3188,   778,  2903,   927,
    2904,  1318, -1114,  1386,  2105,  2675,  3070,  3071,  3072,  2769,
    3073,  3074,  3075,  3076,  3077,  3078,  1319,   662,  2224,  1584,
    3976,  1320,  1521,   772,  1056,   213,  3009,  2224,  2445,  1323,
    1550,  3578,    80,  1324,    80,   929,  1026,  2936,  2937,  1549,
     927,    79,  3020,    79,  3021,  1969,  3038,  2949,  2434,  1970,
    3048,  3051,  2434,  2434,   221,   350,  1449,  1541,  3167,    74,
     771,    74,  1447,  2225,  2226,  3190,  3191,   351,   390,  1971,
    1972,  1453,  2225,  2226,  1443,  1454,   929,   779,  1455,  1057,
     660,   230,  1058,  1464,  1973,  2527,  2527,  4081,   232,  4083,
    2527,  1006,  3055,  1547,  2434,  3056,  3068,  2434,  1469,  3082,
     235,  2434,  1477,   350,  2222,   350,  2318,  2396,  1969,  2909,
    3168,  2396,  1970,  2222,  1470,   351,  1006,   351,  1480,  3098,
    1975,  2434,  1478,   156,  3922,  1481,   771,  3730,  1487,  2527,
    2527,  3794,  1971,  1972,  1976,  3196,  3197,  3780,  1521,  1500,
    3101,   244,  3102,   779,  1502,   156,  1521,  1973,  1521,  1506,
     207,   350,  1507,  1115,  1587,  3137,   927,  3138,   771,  1510,
    1588,  3069,   390,   351,   927,  1006,   927,  1589,  1056,  1156,
    3139,  3153,  3140,  3154,  1623,   779,  1059,  3181,  1511,  3182,
    1974,  1512,  1591,  1975,  3245,  2861,  3246,   778,  1513,  3274,
    1592,  3275,   929,  2861,   174,  3655,  3656,  1976,  1964,  3169,
     929,  1157,   929,  3376,  1514,  3377,  1978,  3386,  1516,  3387,
     390,  1515,   390,   772,  1158,   830,   174,   350,  1889,  1890,
    1026,  1159,  3399,  1057,  3400,  1160,  2319,  3198,  3199,   351,
    1967,  3466,  3502,  2434,  3503,  1968,  2886,  1522,  1593,  2911,
    1529,  1531,  2951,  3409,  3509,  1161,  3510,  3922,  3521,   350,
    2434,  4208,   191,   778,  3544,  3545,  2434,  2434,   390,  1523,
    1525,   351,  2941,  3862,    81,  1528,  1162,  1060,  3576,  1978,
    2445,  3700,  1553,  3701,   191,  3752,  3795,  3154,  2475,   772,
    1552,  3828,  2961,  2445,  3829,   778,  2445,  1071,  1555,  3142,
    3143,  1562,  1566,   835,  1061,  1486,  1979,  1488,  1163,  1980,
    1981,  1982,  1580,  1983,  1984,  1985,  1986,  1987,  1988,  1597,
    1619,   772,  -724,  1621,  1442,  1006,  1656,  1660,  1164,   156,
    1059,  1668,  3115,  1386,   390,  1669,  3070,  3071,  3072,   213,
    3073,  3074,  3075,  3076,  3077,  3078,  3099,  3934,  3188,  1800,
     392,  3104,  1165,  3939,  1676,  3377,   392,  3941,   837,  3377,
    3955,   213,  3956,  3957,  1674,  2434,   390, -2292,   221,  1979,
   -1575,  1970,  1980,  1981,  1982,  1678,  1983,  1984,  1985,  1986,
    1987,  1988,  1681,  1686,  3659,  3660,  3661,  3662,  3663,   392,
     221,  1971,  1972,  3953,  3874,   230,  3963,  4012,  2475,  4013,
     174,  2968,   232,  4040,  1688,  4041, -2292,  2908,  1698,  4047,
    1166,  4048,  1571,  4052,   235,  1800,  4153,   230,  4054,  1695,
    3377,  2320,  1737,   863,   232,  4058,  1238,  2475,  1739, -1082,
    1246,  4103,   392,  2020,  3857,  1743,   235,   801,  3823, -1082,
    1258,  1006,  1975, -1082,  4107,  4122,  4041,  1800,  2321,  1747,
    -169,  3967,  2574,  1749,  2575,  4209,  1976,  4123,  4124,  2475,
    3102,  1167,  3118,   771,  3119,  1168,  2969,  1169,   771,  4125,
    4134,  2434,  2475,  1170,  2576,  1006,  1955,   244,  1751,   970,
     779,  1762,  1006, -1082,  3120,   779,   970,  1768,   970,  4000,
    2572,  1778,  2970,  2395,  4136,  2400,  2475,   844,  1786,   845,
     392,  1171,  1172, -1082,  2406,  3187,  1173,  2971,   847,  3136,
    1788,  1793,  2414,  2415,  1174,  1794,  1795,  2972,   850,  1175,
    1796,  1797,  2388,  3659,  3660,  3661,  3662,  3663, -2292,  1799,
    2427,  3664,  4137,  1442,  2475,   213,  1800,  1805,  3066,  3308,
    2973,  1176,  1521,  4204,  4233,  4205,  4205, -1082,  3424,  1808,
    3427,  1809,  1810,  1811,   350,  2132, -1082,  1964,  3176,   350,
     927,  1813,  3797,  1818,   221,  1819,   351,  3742,  1820,  4057,
    2396,   351,  2577,  1825,  1857,  2396,  1885,  2578,  2396,  1899,
    1887,  3309,  2579,  1891,  1893,  1894,  1907,  3121,  1916,  1967,
     778,   230,  3122,  1910,  1968,   778,   929,  1911,   232,  1912,
    4060,   244,  4074,  1918,  1921,  3310,  4079,  4080,  1922,  1923,
     235,  1924,  1929,  1931,  1993,  1932,   772,  1933,  1979,  2974,
    1934,   772,  1935,  1942,  3311,  1983,  1984,  1985,  1986,  1987,
    1988,  1943,  1945,  1946,   392,  3824,  1947,  1948,  2527,  1949,
    3312,  2527,  2527,  2527,  2527,  2527,  2527,  2527,  2527,  2527,
    2527,   244,  1950,  1581,  3313,  1951,  2024,  2020,  4075,  2035,
    2050,   390,  2060,  1131,  3887, -1082,   390,  1120,   392,  4078,
    1121,  1122,  1123,  2074,  1124,  1125,  1126,  1127,  1128,  1129,
    1490,  3126,  2099,  1582,  2104,  2111,  1059,  3380,  2119,  3743,
    2125,  2127,  2129,  1537,  2136,  2580,  3265,  2135,  2527,  2527,
    2141,  2334,  2142,  2144,  2581,  3123, -2016,  2153,  2146,  2154,
    4129,  2156,  2157,  2158,  3124,  2172, -2292,  1006,  3277,  2177,
    1970,  3068,  2179,  2395,  3415,   857,  3267,  2180,   771,   771,
     771,  1480,  2181,  2182,  2205,  2204,  3314,  2203,  2209,  1583,
    1971,  1972,  2219,  2222,  3315,   779,   779,   779,  2229,  2861,
    2220,  2221,  2861,  2861,  1628, -2292,  2861,  2228,  2230,  2235,
    2233,  2240,  2237,  2238,  2247,  2642,  2861,  2248,  3381,  1584,
    1006,  1694,  2254,  2255,  1642,  3328,  2262,  3316,  2263,  2269,
    2271,  3337,  2291,  3393,  1521,  1807,  3069,  2305,  2303,  2270,
    2276,  1975,  2306,  2315,  1026,  2278,  2313,  1903,  1913,  1919,
    2316,  1629,   927,  3328,  3414,  1976,  2325,  3332,  3335,  2368,
     832,  2331,  1521,  2374,  2335,  1581,  3375,  2351,   771,   350,
     350,   350,  2376,  2377,  3535,  3536,  3537,  3538,  1644,   344,
     927,   351,   351,   351,  2379,   779,  4029,  2380,   929,  1872,
    2386,  2397,  4199,  4067,   344,  1582,  3404,  1442,  4068,  2409,
    1886,  2410,  2411,  2412,  2425,   778,   778,   778,  2426,  2440,
    2457,  2460,  1896,  2464,  3457,   344,   929,  2441,  2472,  2536,
    2485,  2495,  2388,  2396,  2494,  1630,  2388, -2292,  2537,  2549,
    2554,   772,   772,   772,  1964,  2558,  2559,  2571,  2588,  2617,
     863,  2566,  2590,  2629,  2630,  2635,  2396,  3504,  2632,  2637,
     207,  1583,  2187,  2640,  1587,  2641,  2648,  1030,  2663,   350,
    1588,  2655,  2664,  2669,  3987,  2684,  2681,  1589,  2683,  2010,
    1631,   351,  1632,  2527,  1623,   344,   390,   390,   390,  2698,
    2700,  1584,  1591,  2252,  2701,  2702,  2709,  2711,  3188,  2713,
    1592,  2714,  1131,  2715,  2717,   778,  2732,  2734,  1386,  2720,
    2771,  3070,  3071,  3072,  2778,  3073,  3074,  3075,  3076,  3077,
    3078,  2781,  2842,  2836,  2837,  2838,  2727,  1979,  1634,  2846,
    2847,   772,  4185,  1029,  1983,  1984,  1985,  1986,  1987,  1988,
    2850,  2851,  2852, -1115,  2854,  2855,  2856, -1115,  1593,  2858,
    3986,  2857,  2868,  2870,  1109,  2879,  1112,  3608,  2877,  2882,
    2884,  2885,  2883,  1636,  2901,  2905,  2918,  2910,  2922,  3516,
    2939,  1142,  2940,  2923,   771,  2942,   390,  2957,  2958,  2073,
    2960,  1115,  1006,  2967,  2959,  2981,  2986,  1030,  4185,  1585,
    2987,   779,  1006,  2995,  1187,  2998,  1638,  3000,  3001,  3011,
    1955,  3005,  3018,  2769,  4133,  3591,  3013, -1115,  1006,  2486,
    1205,  3552,  3030,  4185,  3034,  1299,   392,  3036,  1586,  3049,
     392,  3050,   207,  3052,  1108,  3053,  1587,  3054,  2396,  1108,
    3057,  3058,  1588,  2395,  3060,  3063,  3117,  2395, -1928,  1589,
    3088,  3081,  3112,  3087,  2434,  3089,  1590,  2528,  3125,  2527,
    2527, -1115,  3090,  3097,  1591,  3110,  3111,  3145,  3132,  1108,
    1031,  1006,  1592,  3201,  1006,   350,  3135,  3151,  3204,  3150,
    2988,  1006,  1603,  3205,  3209,  1832,  3206,   351,  1604,  1100,
    3210,  3215,  3218,  3219,  2996,  2997,  3222,  3567,  2999,  3223,
    3227,  3228,  3260,  3261,  3003,  3268,  3270,  3279,  3280,  3278,
    1006,   778,  1224,  3281,  3282,  3328,  3294,  2607,  3283,  1108,
    1593,  3284,  3285,  3286,  1521,  3300,  1108,  1605,  3287,  3609,
     771,  3288,   771,  3330,  3301,  3302,  3612,   772,  3613,  3303,
    4101,  3304,   927,  3305,  3331,  2122,    81,   779,  3339,   779,
    1603,  3342,  3365,  3341,  3363,   927,  1604,  3369,  3371,   771,
    3382,  2396,  2861,  3037,  3384,  3390,  3391,  3395,  2861,  2861,
    2861,  2861,  2861,  2861,  3385,  3397,   779,  1606,   929,  1032,
    3412,  3416,   390,  3421,  1607,  3420,  3428,  1608,  3418,  3431,
    3433,   929,  3438,  3440,  3456,  1605,  1996,  3459,  3460,  2124,
    3469,  3084,  3337,  3066,  3083,  1964,  1900,  3511,  3498,  1959,
    3524,  3670,  3672,  3674,  3676,  3499,  1283,  1284,  1006,  1006,
    3500,   350,  1108,   350,  3523,  3654,  3532,  3542,   970,  3335,
    3554,  3556,   970,   351,  3555,   351,  1609,  1967,  3669,  3559,
    3562,  3565,  1968,  3592,  3568,  1606,  3579,  3581,  3616,  3593,
     350,  3588,  1607,   392,  4170,  1608,  3603,   778,  3604,   778,
    3631,  1108,   351,  3720,  3605,  3632,  3690,  3409,  3606,  3695,
    3607,  3629,  3657,  2662,  3683,  3693,  3697,  3698,  3705,  3827,
    3709,  3714,  3717,   772,  3715,   772,   778,  3723,  3727,  1617,
    1618,  1610,  3728,  3834,  3736,  2388,  3746,  3764,  3739,  3749,
    2388,  3755,  3761,  2388,  1609,  3762,  3767,  3769,  3772,  3776,
    2407,  3781,   772,  2527,  3777,  3782,  3783,  3807,  3808,  2416,
    3831,  3832,  3833,  3853,  3837,  3787,  3854,  1611,   390,  3529,
     390,  2423,  3858,  3861,  3867,  3843,  3846,  2527,  2527,  4227,
      35,   413,  3649,  3870,    37,    38,    39,    40,    41,  1689,
    3873,  3880,  3896,  3888,  3892,  3898,  1612,   390,  3915,  1610,
    1613,  3930,  3902,  3906, -2292,  1741,  1742,  3917,  1970,  3918,
    3946,  3947,  3936,  2447,  3882,  3959,  2452,  2453,  3951,  3960,
    2456,  3952,  3969,  1769,  1614,  3954,  3971,  3979,  1971,  1972,
    3982,  3961,  3221,  3962,  3977,  1611,  3989,  3990,  1108,  3995,
    3996,  2445,  4002, -2292,  3689,  1108,  4009,  4011,  4020,  4021,
    4031,  1802,  1804,  4033,  4032,  4034,  1006,  4035,  4050,  4066,
    4070,  1031,  4089,  3821,  3822,  4093,  1734,  4097,  1613,  4099,
    3239,  3240,  3820,  4105,  1006,  4106,    80,  4109,  2025,  1975,
    4121,  4126,  4128,  4076,  4127,    79,  1006,  1826,  4138,  4139,
    2132,  4148,  1614,  1976,  4142,  4144,  1108,  4149,  4158,  3548,
    4172,   927,  4168,    74,  4140,  4141,  4200,   927,  4195,  4201,
    4217,  4219,  4230,  1040,  2907,  3178,  2774,  2047,  4151,  3237,
    3589,   927,  3307,  3998,  3711,  3707,  2746,  3582,  3885,  3840,
    3841,  3217,  2527,  3010,  3844,  3845,  2395,   929,  4169,  2861,
    2861,  2395,  4198,   929,  2395,    81,    81,  4145,    81,  3893,
    3859,  3860,  4143,  4178,  3863,  3864,  1108,   929,  3712,  1708,
    2367,  2725,  3394,  3719,  3614, -2292,  3272,  3337,  3337,  3337,
    3337,  3337,  2348,  1603,  2888,  3373,  4232,  4220,  3869,  1604,
    3366,  2026,  3868,  1718,  4179,  3318,  3988,  4135,  2330,  1734,
    3991,   944,  1873,  4038,  3335,  3335,  3335,  3335,  3335,  3765,
    3721,   792,   927,  4111,  2740,  3724,  4116,  4211,  4231,  3899,
     344,  1108,  4015,  1457,  2650,   909,  2075,   771,  1605,  1843,
    1117,  3704,  3458,  3183,  3006,  1136,  3763,  1847,  2072,  3186,
    1476,  2674,  3200,  1145,   779,  3924,  3566,  3825,   929,  1108,
    2666,  1153,  2647,  1116,  2673,  3144,  1180,  1134,  2100,  3938,
    3426,  1006,  1006,  1006,  1006,  1979,  1144,   793,  1465,  2963,
    3184,  2388,  1983,  1984,  1985,  1986,  1987,  1988,  1606,  1226,
    1108,  1108,  3702,  1108,  3515,  1607,  4059,   794,  1608,  3505,
    4160,  1191,  4161,  4167,  3189,  1198,  1992,  3130,  2528,  2528,
    1108,  3045,  3128,  2528,  3023,  1849,  1207,  3413,   795,  2382,
    2616,  3434,  1074,  2956,  1780,  3437,  1883,  3439,   350,  3441,
    3442,  2685,  4159,  2110,  1043,  2103,  2676,  1532,  3447,  2692,
     351,  1270,  2689,  1560,  3173,   796,  2690,  1609,  3570,  2031,
     797,  1882,  2528,  2528,  3975,   798,  3816,  3571,  2009,  2107,
    3558,  1066,  1108,   392,   778,  3328,  2696,  3008,  2442,  1829,
     799,  3463,  3974,  3754,  1521,  2745,    83,     0,     0,  1301,
       0,     0,  2861,     0,     0,  1603,  3999,     0,     0,  1108,
     772,  1604,   927,  1108,  1108,  1312,  2948,     0,     0,     0,
       0,     0,  1610,     0,    55,    56,    57,   392,   392,   392,
      58,     0,     0,     0,  1581,     0,   922,  1517,     0,     0,
    3414,     0,     0,     0,     0,     0,  1434,     0,   929,     0,
    1605,     0,     0,     0,     0,   390,     0,     0,  1611,     0,
       0,     0,     0,  4036,  1582,  1459,     0,     0,     0,     0,
       0,     0,   800,     0,     0,   392,     0,     0,     0,  1100,
       0,     0,   392,     0,  1734,     0,     0,  1647,   392,  1482,
       0,  1613,   970,     0,     0,     0,     0,     0,     0,   801,
    1606,   344,  2395,  2264,  2265,  2266,  2267,  1607,     0,     0,
    1608,     0,   970,     0,     0,  1648,     0,     0,  4225,  1734,
    1583,     0,     0,   802,     0,     0,     0,     0,     0,   803,
       0,     0,     0,  2294,  2295,   804,     0,   805,     0,  2304,
       0,  1734,     0,     0,     0,   970,     0,     0,     0,     0,
    1584,     0,     0,     0,     0,     0,     0,     0,     0,  1609,
       0,     0,     0,   806,   807,     0,     0,     0,   808,     0,
       0,     0,     0,     0,     0,     0,   809,   771,  2949,     0,
       0,   810,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   811,     0,     0,   779,     0,  1100,     0,     0,     0,
    1734,  1883,     0,   812,  2352,  2353,  2354,  2355,     0,     0,
       0,     0,     0,     0,  1610,     0,     0,  2311,     0,     0,
       0,     0,     0,     0,     0,  4118,     0,  1100,     0,     0,
       0,     0,     0,     0,     0,  1734,  1006,     0,     0,     0,
    3012,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1611,     0,     0,     0,     0,     0,     0,     0,  2232,     0,
    1734,  4119,  1006,     0,     0,   392,     0,     0,   350,  1764,
    1766,  1767,     0,     0,  1100,     0,     0,  2429,     0,  1664,
     351,   207,     0,  1613,     0,  2950,  1006,     0,     0,     0,
       0,  1588,     0,     0,     0,     0,     0,  4187,  1589,     0,
       0,     0,     0,     0,   778,  1623,  4186,  1665,  1108,     0,
    1108,     0,     0,  1591,     0,     0,  1734,  2290,     0,  1108,
       0,  1592,     0,     0,  4183,     0,     0,     0,     0,     0,
     772,     0,     0,     0,  1883,  1006,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   344,     0,
       0,    81,     0,  4187,    81,     0,     0,     0,  1434,     0,
       0,     0,  4186,     0,  4224,     0,     0,     0,     0,  1593,
    1964,     0,     0,  2951,     0,   390,  1100,  2327,  4187,     0,
    4183,  1434,     0,     0,   344,     0,  1108,  4186,     0,     0,
       0,     0,  3756,     0,  1965,     0,     0,  1100,     0,  3759,
    3760,     0,  1967,     0,     0,  4183,     0,  1968,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1108,  1108,     0,     0,     0,     0,     0,     0,  1108,
       0,     0,  1108,  2401,     0,  1108,     0,     0,     0,     0,
    2512,     0,     0,  1108,  1108,     0,     0,     0,     0,     0,
       0,  1108,     0,     0,  1108,  1108,  1108,  1108,     0,     0,
       0,     0,     0,     0,  1108,  1108,     0,  1108,     0,  1108,
       0,  2528,  1108,     0,  2528,  2528,  2528,  2528,  2528,  2528,
    2528,  2528,  2528,  2528,     0,     0,  1734,  1108,   392,     0,
    1100,  1108,     0,  1964,     0,  1108,     0,     0,     0,  1108,
       0,     0,  1108,  1108,  1108,  1108,  1108,  1108,  1108,  1108,
    1108,     0,  1108,     0,     0,     0,     0,     0,  1108,  2051,
       0,     0,  1108,     0,     0,  1967,  1964,     0,     0,  1969,
    1968,  2528,  2528,  1970,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1965,     0,     0,  1971,  1972,     0,     0,     0,  1967,     0,
       0,     0,     0,  1968,     0,     0,     0,     0,  1973,     0,
       0,     0,     0,     0,  3259,  1100,     0,     0,     0,     0,
       0,     0,   392,     0,     0,     0,     0,     0,     0,     0,
    3266,     0,     0,  1108,  3269,     0,     0,     0,     0,     0,
       0,  1974,     0,  2563,  1975,     0,     0,     0,     0,     0,
    1964,     0,     0,     0,     0,     0,     0,  3530,  1976,     0,
       0,  1977,     0,     0,     0,     0,     0,     0,     0,     0,
     392,     0,   392,     0,  1965,     0,     0,     0,     0,     0,
       0,     0,  1967,     0,     0,     0,     0,  1968,     0,     0,
       0,     0, -2292,     0,     0,     0,  1970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,     0,    81,     0,
    2218,     0,     0,     0,     0,     0,  1971,  1972,   392,     0,
       0,     0,     0,     0,     0,  1969,     0,     0,     0,  1970,
    1978, -2292,     0,     0,     0,  1108,     0,     0,  2809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1971,
    1972,  3942,     0,  3943,  3944,  1734,  2948,  2268,     0,     0,
    1734,  1734,  3948,     0,  1973,     0,     0,  1975,     0,     0,
       0,     0,     0,     0,  1581,     0,     0,  2288,     0,     0,
       0,  1976,  2853,     0,   392,  2275,     0,     0,     0,  2862,
    2863,  2864,  2865,  2866,  2867,     0,  2528,  1974,     0,     0,
    1975,     0,     0,     0,  1582,     0,     0,     0,     0,  1969,
       0,     0,     0,  1970,  1976,     0,   392,  1977,     0,     0,
    1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,  1971,  1972,  2638,     0,     0,     0,     0,
       0,  2639,  3450,     0,     0,     0,     0,     0,  1973,     0,
       0,     0,     0, -2292,     0,     0,     0,     0,     0,     0,
    1583,     0,     0,     0,  3461,     0,     0,     0,     0,     0,
       0,     0,  2337,     0,     0,  1108,     0,  1734,     0,     0,
       0,  1974,     0,     0,  1975,     0,  1978,  2275,     0,     0,
    1584,     0,     0,     0,     0,     0,     0,     0,  1976,     0,
    2990,  1977,  2992,     0,     0,     0,     0,     0,     0,     0,
       0,  2418,     0,     0,     0,     0,     0,     0,  2949,     0,
    2422,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1734,
       0,     0,     0,  1979,     0,  4055,  2275,     0,     0,  1108,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,  1108,
       0,     0,  2528,  2528,     0,     0,     0,     0,  1434,  1434,
    1978,     0,     0,     0,     0,     0,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,     0,  2881,  3059,  1108,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   207,     0,     0,     0,  1587,  1108,     0,     0,     0,
       0,  1588,     0,     0,     0,     0,     0,  1734,  1589,     0,
       0,     0,     0,     0,     0,  1623,     0,     0,     0,     0,
       0,     0,     0,  1591,     0,     0,  1108,  1108,     0,     0,
    1979,  1592,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,     0,     0,  3105,
       0,     0,     0,     0,     0,     0,  1108,  1108,     0,     0,
       0,  1108,     0,  3610,  3611,     0,  2615,     0,     0,     0,
    1964,     0,     0,  1108,  1108,  1108,  1108,     0,     0,  1593,
       0,   392,     0,  2951,     0,  1108,   392,     0,  1108,     0,
    1108,  2631,     0,     0,  1965,     0,     0,     0,     0,     0,
    1108,  1108,  1967,  1108,     0,     0,     0,  1968,     0,     0,
       0,     0,     0,     0,     0,     0,  1108,     0,  1108,     0,
       0,     0,  1108,     0,  3031,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1108,     0,
    2651,     0,     0,     0,  1964,     0,     0,     0,     0,  1108,
       0,  1108,  1108,  1108,     0,     0,     0,     0,     0,     0,
    1603,     0,     0,     0,     0,     0,  1604,     0,  1965,     0,
       0,  1108,     0,     0,     0,     0,  1967,     0,     0,     0,
    1108,  1968,     0,     0,     0,     0,  2528,  1108,     0,     0,
    1628,     0,  1108,     0,     0,     0,     0,     0,     0,  1108,
    1108,  1108,     0,     0,     0,  1605,     0,     0,     0,     0,
    2528,  2528,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1969,
       0,     0,     0,  1970,     0,     0,     0,  1629,     0,     0,
       0,     0,     0,  1108,     0,     0,     0,     0,  2703,     0,
       0,     0,  2706,  1971,  1972,  1606,     0,     0,     0,     0,
       0,     0,  1607,     0,     0,  1608,     0,  2718,  1973,  1734,
    1734,     0,  1734,     0,     0,  2730,     0,     0,     0,  1734,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2764,     0,     0,     0,     0,     0,     0,     0,  2744,     0,
       0,  1974,     0,  1969,  1975,     0,     0,  1970,     0,     0,
    1734,  1630,  1734,     0,  1609,  2765,     0,     0,  1976,     0,
       0,  1977,     0,     0,     0,     0,     0,  1971,  1972,     0,
    2782,     0,  2806,     0,     0,  1721,     0,     0,     0,     0,
       0,     0,  1973,     0,     0,     0,   392,   392,   392,     0,
    2822,     0,     0,     0,     0,     0,  1631,  2826,  1632,     0,
       0,     0,     0,     0,  2839,  2528,     0,     0,     0,  1633,
       0,  2843,     0,     0,     0,  1974,     0,     0,  1975,     0,
       0,     0,     0,     0,  1734,     0,     0,     0,     0,     0,
    1978,     0,  1976,     0,     0,  1977,  3234,     0,     0,     0,
       0,     0,     0,     0,  1634,  1611,  2906,     0,  3319,  1734,
       0,     0,     0,     0,     0,     0,     0,  3849,  3850,     0,
    3852,     0,     0,     0,     0,     0,     0,  3255,     0,  3257,
       0,     0,     0,     0,  1635,     0,   392,  1734,  1613,  1636,
    2925,     0,     0,     0,     0,     0,     0,  2943,     0,     0,
       0,     0,     0,  1734,     0,     0,     0,     0,  1721,     0,
       0,     0,  1637,     0,  1978,     0,     0,  1734,     0,     0,
       0,     0,  1638,     0,     0,     0,     0,     0,     0,     0,
    1979,     0,  1734,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,  2557,     0,  1108,
       0,  3293,     0,  1108,     0,     0,     0,  1964,     0,     0,
       0,     0,     0,  1108,     0,     0,     0,     0,  1734,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1729,
       0,  1965,     0,     0,     0,     0,     0,     0,     0,  1967,
    3933,     0,     0,     0,  1968,  1108,     0,     0,     0,     0,
    3933,     0,  3017,     0,  1979,     0,     0,  1980,  1981,  1982,
       0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,
    3378,  3329,     0,     0,     0,     0,  1108,     0,     0,  1734,
    3017,     0,     0,     0,  3234,  1108,     0,     0,  1964,     0,
       0,  1108,     0,  1108,     0,     0,     0,     0,  1734,  1108,
       0,     0,  1108,  1108,  1108,  1108,  1108,  1108,  1108,  1108,
    1108,  1108,  1965,     0,     0,  1108,  1108,     0,     0,     0,
    1967,     0,     0,  1734,     0,  1968,     0,     0,  1108,     0,
       0,     0,   392,     0,  1108,  3435,     0,     0,     0,     0,
       0,     0,     0,     0,  1108,     0,     0,  1108,     0,  1108,
       0,     0,  1729,     0,     0,     0,     0,  1734,  1108,  1108,
    1108,     0,     0,     0,  1108,     0,  1969,  1108,     0,     0,
    1970,     0,     0,     0,     0,     0,     0,  1108,     0,     0,
       0,     0,  3141,     0,     0,     0,  1108,     0,     0,     0,
    1971,  1972,     0,     0,     0,     0,  3470,     0,     0,     0,
       0,     0,     0,     0,     0,  1973,     0,     0,     0,     0,
       0,     0,     0,  1721,     0,  3475,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1964,     0,     0,  1434,     0,  4053,  1974,     0,
    3497,  1975,     0,     0,     0,     0,     0,  1969,  1721,     0,
       0,  1970,     0,     0,     0,  1976,  1965,     0,   648,     0,
       0,     0,     0,   671,  1967,   678,     0,     0,     0,  1968,
    1721,  1971,  1972,     0,  1883,   678,     0,     0,   392,  1734,
     392,     0,     0,     0,     0,     0,  1973,     0,     0,     0,
       0,     0,  2029,     0,     0,  3212,     0,  4085,     0,     0,
       0,   671,     0,     0,     0,     0,     0,   392,     0,     0,
       0,   678,     0,     0,     0,     0,     0,     0,     0,  1974,
     671,   678,  1975,     0,   678,     0,     0,  1978,     0,  1721,
     678,     0,     0,     0,   678,     0,  1976,     0,   937,  1977,
       0,     0,     0,     0,     0,     0,  1721,     0,     0,     0,
       0,     0,   939,     0,     0,   678,     0,     0,     0,     0,
     946,     0,     0,     0,  1721,     0,     0,     0,     0,     0,
       0,   678,     0,     0,     0,   956,  3258,   937,     0,     0,
       0,   977,     0,     0,  1108,     0,     0,     0,     0,  1721,
       0,  1969,     0,     0,     0,  1970,     0,  1734,  1014,     0,
       0,     0,     0,     0,   678,     0,     0,  1729,  1978,     0,
       0,     0,     0, -2289,     0,  1971,  1972,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
    1973,     0,  1734,  1108,  1108,     0,     0,     0,     0,     0,
       0,  3290,  1729,     0,     0,  1721,     0,     0,     0,     0,
       0,     0,  1108,     0,     0,     0,     0,  1108,     0,     0,
    1108,     0, -2289,  1974,  1729,     0,  1975,     0,  2783,     0,
       0,     0, -2289,     0,     0,     0, -2289,     0,     0,     0,
    1976, -2289,     0,  1977,     0, -2289,     0,  3372, -2289,     0,
   -2289,     0,     0,     0,     0,     0,     0,  3383,  1979,  1108,
       0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,     0,     0,  3396,  3694,  3514, -2289,     0,     0,     0,
       0,  2784,     0,  1729,     0,     0,     0,     0,     0,     0,
    2785,  2786,  2787,     0,     0,  1108, -2289,     0,     0,     0,
    1729,     0,  1108,  1108,     0,  1734,     0,     0,     0,     0,
    1108,  1108,  1978,     0,     0,  1108,  1734,     0,  1729,     0,
       0,  1108,  1108,     0,     0,  1108,  3443,     0,   678,  3444,
       0,     0,     0,     0,  2788,     0,  3448,     0,     0,  3851,
   -2289,     0,     0,  1729,     0,  1108,     0,     0,     0, -2289,
       0,     0,     0,     0,     0,     0,  2275,     0,     0,     0,
      81,     0,     0,     0,     0,  1434,     0,     0,     0,  3452,
       0,     0,     0,     0,     0,  1721,  2789,     0,     0,     0,
    1734,  2790,     0,     0,     0,     0,     0,     0,  1734,     0,
       0,  3464, -2289,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,  3546,
    2791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1883,     0,     0,   942,  2792,  2793,  2794,
    2795,  2796,     0,  2797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2289,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3539,  3540,  1108,  2798,     0,     0, -2289,
       0, -2289, -2289,     0,     0,   392,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3836,     0,     0,
       0,     0,     0,     0,     0,  3842,     0,     0,     0,     0,
       0,     0,  2799,     0,     0,  1108,     0,     0,     0,     0,
    1734, -2289,     0,     0, -2289, -2289,     0, -2289,     0,     0,
       0,     0,     0,     0,  1108,     0,     0,     0,  1108,     0,
       0,     0,     0,  1734,     0,     0,     0,   671,  2800,     0,
    2801,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1108,     0,     0,     0,  1734,  1729,
       0,     0,     0,  2802,     0,     0,     0,     0,  3577,     0,
    2803,     0,     0,  2804,     0,     0,     0,     0,  1108,  1108,
       0,     0,  1108,     0,   678,   678,     0,     0,     0,  1108,
    1108,     0,     0,     0,  1721,     0,     0,     0,   678,  1721,
    1721,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1734,
       0,     0,  1108,     0,     0,     0,     0,  3621,  4037,  3623,
       0,     0,     0,  4043,  4043,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3378,     0,     0,  1108,     0,     0,     0,     0,     0,     0,
       0,  3666,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,     0,     0,     0,  3691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3696,     0,     0,     0,     0,     0,     0,     0,     0,
    1108,  1108,     0,     0,  4082,     0,  4084,  1734,     0,     0,
       0,     0,  1110,   671,  1110,     0,  1721,   648,     0,  1133,
       0,   648,   678,     0,   678,     0,   678,     0,   678,  1110,
     648,     0,     0,  1108,  1734,     0,  1108,     0,  1108,  1155,
       0,     0,     0,     0,     0,     0,     0,   678,     0,     0,
     671,     0,  1110,  4112,     0,   648,     0,  1133,     0,   648,
    1200,   678,   678,     0,  1108,     0,   678,  1734,  1110,     0,
     648,  1734,  1734,     0,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,   678,     0,   678,     0,     0,  1729,     0,
       0,     0,     0,  1729,  1729,   392,     0,   678,     0,  3017,
     671,     0,  1108,     0,   678,     0,  1133,     0,   678,   678,
    4147,     0,   678,     0,   678,     0,   678,     0,   678,  4043,
       0,  1110,     0,  1108,     0,     0,     0,     0,     0,     0,
    1734,     0,  4120,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   678,   678,     0,  1964,     0,  1108,  4171,
       0,  1883,     0,     0,     0,     0,  3803,  3804,  3805,  3806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   678,     0,     0,  1313,     0,  1721,     0,  1967,     0,
       0,     0,     0,  1968,  1883,     0,     0,     0,  1883,  1883,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   671,     0,     0,     0,  1441,     0,     0,
    1729,     0,     0,     0,     0,     0,  1108,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1468,     0,     0,  3838,     0,  1964,
     678,     0,     0,     0,     0,     0,     0,     0,  3847,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1965,     0,     0,     0,     0,     0,     0,
    3533,  1967,  1729,     0,     0,     0,  1968,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   648,   648,     0,     0,  1964,
       0,  1108,     0,     0,     0, -2292,     0,     0,   678,  1970,
     678,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,     0,  1965,     0,     0,     0,     0,     0,  1971,
    1972,  1967,     0,     0,     0,     0,  1968,  1110,  1110,     0,
       0,     0,     0,     0, -2292,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,     0,     0,   678,     0,
    1975,     0,     0,     0,     0,  1133,     0,   678,     0,     0,
       0,     0,     0,   678,  1976,     0,     0,  1110,  1969,     0,
       0,     0,  1970,     0,   678,     0,     0,     0,     0,     0,
       0,     0,  3017,  1110,  1110,     0,     0,     0,     0,     0,
       0,     0,  1971,  1972,     0,     0,     0,     0,     0,     0,
       0,  1110,  1772,     0,   678,  1776,     0,  1973,  1721,  1721,
       0,  1721,     0,     0,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1969,  1110,
    1110,     0,  1970,   678,     0,     0, -2292,     0,     0,     0,
    1974,     0,     0,  1975,     0,     0,     0,     0,  1441,  1721,
       0,  1721,  1971,  1972,     0,     0,     0,  1976,     0,     0,
    1977,     0,     0,     0,     0,     0,     0,  1973,     0,     0,
       0,  4005,     0,     0,   678,     0,     0,     0,     0,     0,
       0,  1860,  1860,     0,     0,     0,     0,   678,   937,     0,
       0,     0,     0,   678,     0,     0,     0,  1434,   678,     0,
    1974,     0,     0,  1975,     0,     0,  1892,     0,     0,     0,
     678,     0,  1898,     0,     0,     0,     0,  1976,     0,     0,
    1977,  4049,     0,  1721,     0,     0,  1979,     0,     0,  1978,
       0,     0,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,  1730,     0,     0,     0,     0,     0,     0,  1721,     0,
    1964,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4071,     0,     0,     0,  1965,     0,  1721,     0,     0,     0,
       0,     0,  1967,     0,     0,     0,     0,  1968,     0,  1978,
       0,     0,  1721,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1729,  1729,     0,  1729,  1721,     0,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,   671,   671,  1979,
       0,  1721,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,
    1987,  1988,     0,  1441,     0,     0,  3564,     0,     0,     0,
    1441,  1441,     0,  1729,     0,  1729,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2061,  1721,  2068,     0,
       0,     0,     0,     0,  1730,     0,   678,   678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1979,
       0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,
    1987,  1988,     0,     0,     0,     0,  3573,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1969,
       0,     0,   671,  1970,   648,     0,     0,  1729,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,  1964,     0,     0,
       0,     0,     0,  1971,  1972,     0,     0,  1721,     0,     0,
       0,     0,  1729,     0,   678,     0,     0,     0,  1973,     0,
       0,  1965,     0,     0,     0,     0,     0,     0,     0,  1967,
       0,     0,  1721,     0,  1968,     0,     0,     0,     0,   678,
    1729,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1974,     0,     0,  1975,     0,  1729,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1721,     0,  1976,     0,
    1729,  1977,     0,     0,     0,     0,     0,     0,     0,     0,
    1133,     0,     0,     0,     0,  1729,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1110,  1110,  1110,  1110,     0,     0,     0,     0,   648,
       0,  1729,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1772,     0,     0,     0,     0,     0,     0,
    1978,  1110,  1110,     0,     0,     0,     0,  1110,     0,     0,
       0,     0,     0,     0,     0,     0,  1969,     0,     0,     0,
    1970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1971,  1972,  1729,     0,     0,     0,     0,     0,  1721,  1730,
       0,     0,     0,     0,     0,  1973,     0,     0,   678,     0,
       0,  1729,     0,     0,     0,     0,   648,     0,     0,     0,
     678,     0,  1110,  1110,  1110,  1110,     0,     0,     0,     0,
       0,   648,     0,     0,  2202,     0,  1729,  1441,  1974,  1772,
    1979,  1975,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,  1976,  1730,  3770,  1977,     0,
       0,     0,     0,     0,   671,   678,     0,     0,   678,   678,
    1729,     0,     0,     0,  1133,     0,     0,   678,   678,     0,
     678,     0,   678,     0,     0,     0,     0,   678,     0,   678,
     648,     0,     0,     0,  1110,  1110,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   678,
     678,     0,     0,     0,     0,  1730,  1721,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1860,  1978,     0,     0,
       0,   678,  1730,     0,   678,   678,  1964,     0,   678,     0,
       0,     0,     0,     0,  2463,     0,     0,     0,     0,     0,
    1730,  1721,     0,     0,     0,     0,     0,     0,     0,     0,
    1965,     0,   937,   937,     0,     0,  2488,     0,  1967,     0,
       0,     0,     0,  1968,     0,  1730,     0,  1964,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,     0,     0,     0,
    1133,     0,     0,     0,     0,     0,  1964,     0,     0,  1967,
       0,     0,     0,     0,  1968,     0,     0,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
    1965,  1730,     0,     0,  3802,     0,     0,     0,  1967,     0,
       0,     0,     0,  1968,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1721,     0,     0,     0,     0,   777,
       0,   678,     0,     0,     0,  1721,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1969,     0,     0,     0,  1970,
       0,  3800,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,     0,   777,     0,     0,     0,     0,     0,     0,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2068,     0,     0,  1973,     0, -2292,     0,     0,  1721,
    1970,     0,     0,     0,     0,  1729,     0,  1721,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   967,
    1971,  1972,     0,     0,     0,  1969,   967,  1974,   967,  1970,
    1975,     0,     0,     0,     0, -2292,     0,     0,     0,     0,
     777,     0,     0,     0,  1976,     0,     0,  1977,     0,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,   648,     0,
       0,  1730,     0,     0,  1973,     0,     0,     0,     0,     0,
     678,  1975,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   648,   678,     0,  1976,   648,   671,   678,     0,
       0,     0,   678,     0,     0,     0,     0,  1974,   678,     0,
    1975,   648,     0,     0,   678,     0,     0,     0,     0,   648,
     678,     0,     0,     0,  1976,   678,  1978,  1977,  1729,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,   648,   678,     0,     0,  2747,  2748,   678,   678,
     678,   678,  2755,     0,     0,   678,   678,     0,     0,   648,
     678,     0,     0,   678,     0,     0,     0, -2292,  2776,  2776,
       0,     0,  1721,     0,   648,     0,   648,   678,     0,     0,
       0,     0,     0,     0,     0,     0,  1110,   678,     0,   678,
       0,     0,     0,     0,   648,     0,  1978,  1721,   678,   678,
     678,   648,   678,  1729,     0,     0,     0,     0,   648,   678,
     678,  1729,     0,     0,     0,   648,  1979,   678,   678,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
    1110,     0,     0,  3958,     0,     0,     0,  1110,  1110,  1110,
    1110,  1110,  1110,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1964,     0,  1979,  1721,     0,
       0,     0,     0,     0,  1983,  1984,  1985,  1986,  1987,  1988,
    2776,     0,     0,     0,     0,     0,     0,     0,   937,  1965,
       0,     0,     0,     0,     0,     0,  1979,  1967,     0,  1980,
    1981,  1982,  1968,  1983,  1984,  1985,  1986,  1987,  1988,     0,
    2735,     0,  2921,  3973,     0,  2202,  2742,     0,     0,  2935,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1776,
       0,     0,     0,     0,     0,     0,     0,  2966,     0,     0,
       0,  2966,  2979,     0,     0,     0,     0,     0,  1964,     0,
       0,     0,     0,     0,     0,     0,  1721,     0,  1110,  2776,
    1110,  2776,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1965,     0,     0,  1441,  1729,     0,     0,     0,
    1967,     0,     0,  1721,     0,  1968,     0,     0,     0,   678,
       0,     0,     0,     0,  1860,     0,     0,     0,   678,     0,
       0,  1729,     0,     0,     0,     0,   648,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1721,     0,     0,     0,
    1721,  1721,     0,     0,  1969,     0,     0,     0,  1970,     0,
     678,     0,  1730,     0,   648,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1971,  1972,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   877,
       0,     0,  1729,  1973,     0,     0,     0,     0,     0,     0,
       0,   878,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   879,     0,     0,  2202,     0,  1974,     0,     0,  1975,
       0,     0,     0,     0,     0,     0,     0,  1969,  3109,     0,
       0,  1970,     0,  1976,     0,   880,  1977,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1971,  1972,     0,     0,   881,     0,  1133,     0,     0,
       0,     0,     0,     0,     0,     0,  1973,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,   882,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1729,     0,  1974,
       0,     0,  1975,   883,  1441,  1978,     0,     0,   884,     0,
       0,     0,  1730,   885,     0,  2068,  1976,     0,     0,  1977,
       0,     0,     0,     0,     0,     0,     0,     0,   886,     0,
    1729,     0,     0,     0,  1729,  1729,   777,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   648,
     678,   678,     0,     0,     0,     0,     0,     0,     0,  1106,
       0,     0,     0,     0,  1860,     0,     0,     0,  1978,     0,
       0,     0,     0,   678,     0,  1979,     0,     0,  1980,  1981,
    1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,
     887,     0,  4007,     0,     0,     0,     0,     0,     0,     0,
     888,     0,     0,  1964,     0,   678,   678,   678,   678,  1106,
       0,     0,     0,     0,     0,     0,  1106,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1965,     0,     0,
     648,     0,   678,     0,     0,  1967,     0,     0,     0,     0,
    1968,   889,     0,     0,     0,   890,     0,   891,   678,     0,
       0,     0,   678,   892,     0,   893,     0,     0,  1979,     0,
       0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,     0,     0,     0,     0,  4108,     0,     0,     0,     0,
       0,   894,   895,     0,     0,     0,   896,     0,     0,     0,
       0,   678,     0,     0,   897,   648,   678,     0,     0,   898,
       0,     0,     0,     0,     0,  2776,  2776,     0,     0,   899,
       0,     0,  1106,     0,     0,     0,     0,     0,   967,     0,
       0,   900,   967,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3336,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1964,    35,     0,     0,     0,     0,     0,
       0,  1106,    41,     0,  2202,  2742,     0,  2742,     0,     0,
       0,     0,  1969,     0,  1730,     0,  1970,  1965,     0,     0,
    1966,   678,   678,     0,     0,  1967,     0,     0,     0,     0,
    1968,     0,     0,     0,     0,     0,  1971,  1972,     0,   678,
       0,     0,     0,     0,     0,  1730,     0,  1730,  1441,     0,
       0,  1973,     0,     0,     0,     0,   671,     0,     0,   678,
    2966,     0,     0,  3417,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3430,     0,     0,     0,
       0,     0,     0,     0,  1974,     0,   678,  1975,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   678,
     648,  1976,     0,     0,  1977,     0,     0,     0,     0,     0,
     678,     0,     0,   648,     0,     0,     0,     0,     0,  1730,
    2463,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,   648,     0,     0,  1106,     0,
       0,     0,     0,     0,  2742,  1106,     0,     0,     0,     0,
       0,     0,  1969,     0,     0,     0,  1970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,  1964,  2742,  1978,     0,     0,  1971,  1972,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1730,     0,
       0,  1973,     0,     0,     0,  1965,  1106,     0,     0,     0,
       0,     0,  1730,  1967,     0,     0,     0,     0,  1968,     0,
       0,     0,     0,     0,     0,     0,     0,  2742,     0,     0,
       0,     0,     0,     0,  1974,     0,     0,  1975,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1976,     0,     0,  1977,     0,     0,     0,     0,     0,
    3550,     0,     0,  1730,     0,     0,  1106,     0,     0,     0,
       0,     0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,  3557,     0,
       0,  2068,     0,     0,     0,     0,     0,     0,     0,  1732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3083,  1106,     0,  1978,  1730,  3084,     0,  1860,  1860,     0,
    1964,     0,   648,     0,     0,     0,     0,     0,     0,     0,
    1969,     0,     0,  1730,  1970,     0,     0,     0,     0,  1106,
       0,     0,     0,     0,  1965,     0,     0,     0,  2656,     0,
       0,     0,  1967,     0,  1971,  1972,     0,  1968,  1730,     0,
       0,   678,   678,     0,     0,     0,     0,     0,     0,  1973,
    1106,  1106,     0,  1106,     0,     0,     0,   678,     0,     0,
       0,   648,   678,   648,   678,   678,   678,   678,     0,     0,
    1106,     0,  1730,     0,     0,     0,     0,     0,    55,     0,
       0,     0,  1974,  1979,     0,  1975,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,  1976,
       0,     0,  1977,     0,     0,     0,     0,  2657,     0,     0,
       0,     0,     0,  3336,     0,     0,     0,     0,     0,     0,
       0,     0,  1106,   777,     0,     0,   678,   678,   678,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1106,
       0,     0,     0,  1106,  1106,     0,  2921,     0,     0,  1969,
       0,  2747,     0,  1970,  2747,     0,  3713,     0,     0,     0,
       0,  1978,     0,     0,     0,     0,  2776,     0,     0,     0,
       0,     0,     0,  1971,  1972,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2742,  2966,     0,   678,  1973,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2921,     0,
    3751,     0,   678,     0,     0,     0,     0,  2776,     0,  2776,
       0,     0,     0,     0,  1732, -2291,     0,     0,   777,     0,
       0,  1974,   967,   648,  1975,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1976,     0,
       0,  1977,   967,     0,     0,     0,     0,     0,     0,  1732,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988, -2291,     0,     0,     0,     0,     0,
       0,  1732,     0,     0, -2291,   967,     0,     0, -2291,     0,
       0,     0,     0, -2291,     0,     0,     0, -2291,     0,     0,
   -2291,     0, -2291,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1730,     0,     0,     0,     0,     0,     0,     0,
    1978,     0,     0,     0,     0,     0,     0,  3814, -2291,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1732,  1133,     0,     0,     0,     0,     0,  2202, -2291,     0,
       0,     0,     0,     0,     0,     0,     0,  1732,     0,     0,
       0,     0,     0,     0,     0,     0,  3835,     0,  2658,     0,
       0,   648,   678,     0,     0,  1732,     0,     0,     0,     0,
       0,     0,   648,   678,     0,     0,     0,     0,     0,     0,
       0,     0, -2291,     0,     0,   678,   678,  1110,   678,     0,
    1732, -2291,     0,     0,     0,   777,     0,     0,     0,     0,
    1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,  1860,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3336,  3336,
    3336,  3336,  3336,     0, -2291,     0,     0,     0,  1106,     0,
    1106,     0,     0,     0,     0,     0,  1732,     0,     0,  1106,
    1730,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1730,     0,     0,     0,     0,   678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   942,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,  3923,     0,     0,     0,     0,     0,     0,     0,
   -2291,     0,     0,     0,     0,  3931,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,  3751,     0,
       0, -2291,     0, -2291, -2291,  1730,     0,     0,     0,     0,
     678,  3713,     0,  1730,     0,     0,   648,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1106,  1106,     0,     0,     0,     0,     0,     0,  1106,
       0,     0,  1106, -2291,     0,  1106, -2291, -2291,     0, -2291,
       0,     0,     0,  1106,  1106,     0,     0,     0,     0,     0,
       0,  1106,     0,     0,  1106,  1106,  1106,  1106,     0,     0,
       0,     0,     0,     0,  1106,  1106,     0,  1106,     0,  1106,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
    1133,     0,     0,     0,     0,     0,  1732,  1106,   777,     0,
       0,  1106,     0,     0,     0,  1106,     0,     0,     0,  1106,
    1860,     0,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,
    1106,     0,  1106,     0,     0,     0,     0,     0,  1106,     0,
       0,     0,  1106,     0,     0,     0,    85,     0,     0,     0,
       0,  2776,    89,  2747,     0,  3928,    93,     0,    94,     0,
      96,    97,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   106,     0,     0,     0,     0,  1110,  3923,  1730,     0,
       0,  1110,  1110,     0,     0,     0,     0,     0,   119,   120,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
       0,     0,     0,  1730,     0,     0,     0,     0,     0,     0,
       0,  1964,     0,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,     0,  4065,     0,
       0,     0,     0,     0,   129,  1965,   130,   131,     0,  1964,
       0,     0,     0,  1967,     0,     0,     0,     0,  1968,     0,
    1039,  1110,  1110,  1110,  1110,   678,     0,     0,     0,     0,
       0,     0,     0,  1965,  2742,     0,  3047,     0,     0,     0,
     141,  1967,   142,   143,     0,     0,  1968,   145,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   147,     0,
     148,     0,     0,     0,     0,     0,   965,     0,   777,     0,
    3923,  1110,     0,   965,     0,   965,     0,   151,     0,   152,
       0,     0,   155,     0,     0,  1106,     0,     0,   156,     0,
       0,     0,     0,     0,   157,     0,     0,     0,     0,     0,
     158,     0,     0,     0,     0,  1732,   159,     0,     0,     0,
    1732,  1732,   161,     0,   163,     0,     0,     0,     0,   165,
       0,     0,  2742,     0,     0,     0,   678,     0,  1110,     0,
       0,     0,   169,     0,   777,     0,     0,  1110,     0,     0,
    1969,     0,     0,     0,  1970,     0,     0,     0,     0,  1730,
    3931,     0,     0,     0,     0,     0,  4065,     0,     0,   174,
       0,     0,     0,     0,  1971,  1972,   777,  1110,  1969,     0,
       0,     0,  1970,     0,     0,     0,     0,     0,  4184,  1973,
       0,     0,  1730,     0,   183,   184,  1730,  1730,     0,     0,
     185,     0,  1971,  1972,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,  1973,     0,     0,
       0,     0,  1974,     0,     0,  1975,     0,   191,     0,     0,
       0,     0,     0,     0,     0,  1106,     0,  1732,     0,  1976,
       0,     0,  1977,     0,  4184,     0,     0,     0,     0,     0,
    1974,     0,     0,  1975,     0,  3928,     0,     0,     0,     0,
    3506,     0,     0,     0,   202,     0,     0,  1976,     0,  4184,
    1977,     0,     0,     0,     0,   204,     0,     0,     0,   205,
       0,   206,     0,     0,     0,     0,   207,     0,     0,     0,
       0,   208,     0,     0,   210,     0,     0,     0,   212,  1732,
       0,     0,     0,     0,   213,     0,     0,     0,     0,  1106,
     214,  1978,     0,   216,     0,     0,     0,     0,     0,  1106,
     219,     0,     0,     0,  3507,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,     0,     0,  1964,     0,  1978,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,  1106,     0,   229,     0,
     230,  1965,     0,   231,     0,     0,  1964,   232,     0,  1967,
       0,     0,     0,     0,  1968,     0,     0,     0,     0,   235,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,     0,
    1965,     0,     0,  3091,     0,     0,     0,  1732,  1967,     0,
       0,  1979,     0,  1968,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,     0,     0,  1106,  1106,     0,     0,
     244,     0,     0,     0,     0,     0,     0,     0,     0,  1979,
       0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,
    1987,  1988,     0,     0,     0,     0,  1106,  1106,     0,     0,
       0,  1106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,  1106,  1106,  1106,     0,     0,     0,
       0,   777,     0,     0,     0,  1106,   777,     0,  1106,     0,
    1106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1106,  1106,     0,  1106,     0,     0,  1969,     0,     0,     0,
    1970,     0,     0,     0,     0,     0,  1106,     0,  1106,     0,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
    1971,  1972,     0,     0,     0,  1969,     0,     0,  1106,  1970,
       0,     0,     0,     0,     0,  1973,     0,     0,     0,  1106,
       0,  1106,  1106,  1106,     0,     0,     0,     0,     0,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1106,     0,     0,  1973,     0,     0,     0,  1974,     0,
    1106,  1975,     0,     0,     0,     0,     0,  1106,     0,     0,
       0,     0,  1106,     0,     0,  1976,     0,     0,  1977,  1106,
    1106,  1106,     0,     0,     0,     0,     0,  1974,     0,     0,
    1975,  3061,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1976,     0,     0,  1977,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1978,     0,  1732,
    1732,  1104,  1732,     0,     0,     0,  1104,     0,     0,  1732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1978,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1104,  1964,     0,     0,
    1732,     0,  1732,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1965,     0,     0,     0,     0,     0,     0,     0,  1967,
       0,     0,     0,     0,  1968,     0,   777,   777,   777,     0,
       0,     0,     0,     0,     0,     0,  1104,  1979,     0,     0,
    1980,  1981,  1982,  1104,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1732,     0,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   777,  1732,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3096,     0,  1732,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,     0,   965,  1969,  1732,     0,   965,
    1970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1732,     0,     0,     0,     0,     0,     0,     0,
    1971,  1972,     0,     0,     0,     0,     0,     0,  1104,  1106,
       0,     0,     0,  1106,     0,  1973,     0,  1964,     0,     0,
       0,     0,     0,  1106,     0,     0,     0,     0,  1732,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1965,     0,     0,  3100,     0,     0,     0,  1974,  1967,
       0,  1975,     0,     0,  1968,  1106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1976,     0,     0,  1977,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,  1732,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,     0,
       0,  1106,     0,  1106,     0,     0,     0,     0,  1732,  1106,
       0,     0,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,
    1106,  1106,     0,     0,     0,  1106,  1106,     0,     0,     0,
       0,     0,     0,  1732,     0,     0,     0,  1978,  1106,     0,
       0,     0,   777,     0,  1106,  1104,     0,     0,     0,     0,
       0,     0,  1104,     0,  1106,     0,     0,  1106,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,  1732,  1106,  1106,
    1106,     0,     0,  1731,  1106,     0,  1969,  1106,     0,     0,
    1970,     0,     0,     0,     0,     0,     0,  1106,     0,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,     0,
    1971,  1972,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1973,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,     0,     0,     0,     0,     0,     0,  1974,     0,
       0,  1975,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,  1976,     0,     0,  1977,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   777,  1732,
     777,  1964,     0,     0,     0,     0,  1731,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1965,     0,   777,  1104,     0,
       0,     0,     0,  1967,     0,     0,     0,     0,  1968,     0,
       0,     0,     0,     0,     0,     0,  1964,  1978,     0,     0,
       0,     0,     0,     0,     0,     0,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1965,     0,     0,  3513,     0,     0,     0,     0,  1967,     0,
       0,     0,     0,  1968,     0,     0,     0,  1104,  1104,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1732,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,  1732,  1106,  1106,     0,     0,     0,     0,  1104,
    1969,     0,     0,     0,  1970,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,     0,     0,  1106,     0,     0,
    1106,     0,     0,     0,  1971,  1972,  1104,     0,     0,     0,
    1104,  1104,     0,     0,     0,     0,     0,     0,     0,  1973,
       0,     0,     0,     0,     0,  1969,     0,     0,     0,  1970,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1971,
    1972,     0,  1974,     0,     0,  1975,     0,     0,     0,     0,
       0,     0,     0,     0,  1973,     0,     0,     0,     0,  1976,
       0,     0,  1977,     0,     0,  1106,     0,     0,     0,     0,
       0,  1731,  1106,  1106,     0,  1732,     0,     0,     0,   965,
    1106,  1106,     0,     0,     0,  1106,  1732,  1974,     0,     0,
    1975,  1106,  1106,     0,     0,  1106,     0,     0,     0,   965,
       0,     0,     0,     0,  1976,     0,  1731,  1977,     0,  1964,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1731,     0,
     661,  1978,   965,  1965,     0,   675,     0,     0,     0,     0,
       0,  1967,     0,     0,     0,     0,  1968,     0,     0,     0,
    1732,     0,     0,     0,     0,     0,  3467,     0,  1732,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   675,     0,     0,  1978,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1731,     0,     0,
       0,     0,   675,   675,     0,     0,     0,     0,     0,     0,
       0,     0,   675,     0,  1731,     0,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1979,  1731,     0,  1980,  1981,  1982,   661,  1983,  1984,
    1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   675,     0,  1106,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,   777,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1979,     0,  1969,  1980,
    1981,  1982,  1970,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,     0,
    1732,     0,  1971,  1972,     0,  1104,     0,  1104,     0,     0,
       0,     0,     0,  1731,  1106,     0,  1104,  1973,  1106,     0,
       0,     0,     0,  1732,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,     0,  1732,     0,
    1974,     0,     0,  1975,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1976,  1106,  1106,
    1977,     0,  1106,     0,     0,     0,     0,     0,     0,  1106,
    1106,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1732,
       0,     0,  1106,     0,     0,     0,     0,     0,  1104,  1104,
       0,     0,     0,     0,     0,     0,  1104,     0,     0,  1104,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,  1978,
    1104,  1104,     0,  1106,     0,     0,     0,     0,  1104,     0,
     675,  1104,  1104,  1104,  1104,     0,     0,     0,     0,     0,
       0,  1104,  1104,     0,  1104,     0,  1104,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1731,  1104,     0,     0,     0,  1104,     0,
    1106,  1106,  1104,     0,     0,     0,  1104,  1732,     0,  1104,
    1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,     0,  1104,
       0,     0,     0,     0,     0,  1104,     0,     0,     0,  1104,
       0,     0,     0,  1106,  1732,     0,  1106,     0,  1106,  1979,
       0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,
    1987,  1988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,  1732,     0,   827,
       0,  1732,  1732,     0,     0,     0,     0,     0,     0,     0,
       0,   828,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,     0,     0,     0,     0,
    1104,   829,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   830,     0,  1106,     0,  -582,     0,     0,     0,     0,
    1732,   677,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   680,     0,     0,     0,   831,     0,     0,  1106,     0,
       0,   832,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   833,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   818,     0,   675,
       0,     0,     0,     0,     0,     0,     0,   867,     0,     0,
     871,     0,     0,   834,     0,     0,   867,     0,  -745,   835,
     926,     0,  1104,   836,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,  -724,     0,
       0,   945,  1731,     0,     0,     0,     0,  1731,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,   867,     0,     0,
     675,  -447,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   837,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1024,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     838,  1106,     0,   839,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -447,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,  1731,     0,     0,     0,     0,     0,
       0,   840,     0,     0,     0,  -745,     0,   841,     0,     0,
       0,     0,     0,     0,     0,   842,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   843,   844,     0,   845,   846,     0,     0,     0,
       0,     0,     0,     0,   847,     0,  1731,     0,   848,   849,
       0,     0,     0,     0,   850,     0,  1104,     0,     0,   851,
       0,     0,     0,     0,  1220,   675,  1104,   675,     0,     0,
       0,     0,     0,     0,  1070,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,   675,     0,
       0,     0,   661,     0,   661,     0,   661,     0,     0,     0,
       0,     0,   661,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   675,     0,   675,     0,     0,     0,     0,
       0,     0,     0,  1104,  1104,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,  1104,  1104,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,  1104,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,  1104,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,  1104,     0,     0,     0,  1104,
       0,     0,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,   661,   661,     0,
       0,  1536,     0,     0,     0,     0,  1104,     0,  1104,  1104,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,  1104,  1104,  1104,     0,
    1078,  1079,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1070,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,  1723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1731,  1731,     0,  1731,
       0,     0,     0,     0,     0,     0,  1731,     0,     0,     0,
       0,  1723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1723,     0,     0,     0,  1731,     0,  1731,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1135,     0,
    1137,     0,  1139,     0,  1141,     0,     0,     0,     0,  1856,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1723,  1183,     0,     0,     0,   675,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1201,  1202,  1723,
       0,  1731,  1204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,  1070,
       0,   867,     0,     0,     0,     0,  1731,     0,     0,     0,
       0,     0,     0,  1229,     0,     0,     0,     0,     0,     0,
       0,     0,  1723,     0,     0,  1248,     0,     0,  1250,     0,
    1252,     0,  1255,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1731,     0,     0,     0,     0,     0,     0,     0,     0,  1286,
    1287,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,  1731,
    2004,     0,     0,     0,     0,  1310,     0,  1311,     0,   675,
     675,     0,     0,     0,     0,     0,  1104,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,   661,     0,
    1104,     0,   661,   661,     0,  1731,     0,  1070,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1024,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,  1731,     0,     0,     0,
       0,     0,  1104,     0,   675,     0,   661,     0,  1104,     0,
    1104,     0,     0,     0,  2134,  1731,  1104,     0,     0,  1104,
    1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,     0,
       0,     0,  1104,  1104,     0,     0,     0,     0,     0,     0,
    1731,     0,     0,     0,  1554,  1104,  1556,     0,     0,     0,
    1558,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,   661,  1104,     0,  1104,     0,  1723,   661,
       0,     0,     0,     0,  1731,  1104,  1104,  1104,     0,     0,
       0,  1104,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,  1667,     0,  1104,     0,     0,     0,     0,     0,   661,
       0,     0,   661,   661,  1679,     0,     0,     0,     0,     0,
       0,     0,     0,  1685,     0,     0,     0,     0,     0,  1687,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1735,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,   661,     0,     0,     0,     0,     0,     0,     0,
    1774,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     8,     0,     9,    10,  1731,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,    35,     0,    36,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     0,     0,     0,
    1850,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1881,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,  1104,  1723,  1723,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,   675,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2004,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,  1731,
    1104,  1104,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,  1104,     0,     0,  1104,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1104,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1024,    47,     0,     0,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,    49,  1104,
    1104,     0,  1731,     0,     0,     0,     0,  1104,  1104,     0,
       0,     0,  1104,  1731,     0,     0,  1856,     0,  1104,  1104,
       0,  1723,  1104,  2626,     0,     0,     0,     0,     0,     0,
       0,     0,  2134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
    2145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,  2176,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,  1731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   661,     0,     0,     0,     0,
      51,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   661,     0,     0,     0,
     661,     0,     0,     0,  2688,     0,  1536,     0,     0,     0,
       0,    54,   675,     0,     0,     0,     0,    55,    56,    57,
       0,     0,  1104,    58,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,    67,    68,
       0,    69,    70,    71,    72,    73,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,     0,  2328,  1104,     0,     0,     0,     0,
    1731,     0,     0,     0,     0,     0,  2350,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,   661,     0,     0,  1731,     0,     0,     0,     0,
     661,     0,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,  1104,     0,     0,  1104,
       0,  2404,     0,     0,     0,  2408,  1104,  1104,     0,     0,
       0,     0,     0,     0,  2417,     0,  2419,     0,  2420,     0,
       0,     0,     0,  2421,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1731,     0,     0,  1104,
       0,     0,     0,     0,     0,  2438,   867,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
    1104,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,  1723,     0,  1723,     0,     0,     0,     0,     0,
       0,  1723,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,  1104,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,  1723,     0,  1723,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,  1731,  1107,  1104,     0,  1104,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   675,  1856,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,     0,  1731,     0,     0,     0,  1731,  1731,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1723,  2625,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,  1104,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1723,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
    1723,     0,     0,     0,     0,     0,  1070,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2704,
       0,  2134,     0,     0,  2708,     0,   661,     0,  2712,     0,
       0,     0,     0,     0,  2716,     0,     0,     0,     0,     0,
    2721,     0,     0,     0,     0,     0,  2731,     0,     0,     0,
       0,  2733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2749,  2750,  2753,  2754,  1104,     0,
    1723,  2760,  2763,     0,     0,     0,  2766,     0,     0,  2770,
       0,  1107,     0,  1404,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,  2807,     0,  1723,     0,     0,     0,     0,
       0,     0,     0,  2810,     0,  2812,     0,     0,     0,  1733,
       0,     0,     0,     0,  2823,  2824,  2825,     0,  2827,     0,
       0,     0,  1473,     0,     0,  2840,  2841,     0,     0,  1723,
       0,     0,     0,  2844,  2845,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,     0,     0,  1107,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,   661,     0,     0,     0,
       0,     0,     0,     0,     0,  1070,     0,     0,     0,     0,
       0,     0,     0,  1724,   675,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,  1107,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,     0,     0,  3032,     0,     0,     0,
       0,   675,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,  1107,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1905,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,     0,     0,
       0,  1952,  1953,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1994,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3213,  3214,  1724,     0,
       0,     0,     0,  2052,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3225,
       0,     0,     0,     0,     0,     0,  2688,     0,     0,     0,
    2080,     0,  1723,  1724,  2090,  2093,     0,     0,     0,     0,
    1723,     0,     0,  1733,     0,     0,     0,     0,     0,     0,
       0,  3241,  3242,  3243,  3244,  1724,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1733,     0,
       0,   661,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1733,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1724,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,  3289,     0,     0,
       0,     0,  3291,     0,     0,     0,     0,     0,     0,  1724,
       0,  1107,     0,  1107,     0,     0,     0,     0,     0,  1733,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1724,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1723,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3379,   867,     0,
    1723,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
    1724,     0,     0,     0,     0,  3225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   867,     0,     0,     0,     0,
       0,     0,  1726,     0,  1107,  1107,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,  1107,     0,     0,  1107,     0,
       0,  1723,  3436,     0,     0,     0,  1107,  1107,     0,     0,
       0,     0,     0,     0,  1107,  3445,     0,  1107,  1107,  1107,
    1107,     0,     0,     0,     0,     0,     0,  1107,  1107,     0,
    1107,     0,  1107,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
    1107,     0,     0,     0,  1107,     0,     0,     0,  1107,     0,
       0,     0,  1107,     0,     0,  1107,  1107,  1107,  1107,  1107,
    1107,  1107,  1107,  1107,     0,  1107,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  1107,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,  2134,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,     0,   661,     0,     0,
       0,     0,     0,   661,     0,     0,  1723,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,  1723,  1723,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1727,
    2498,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2520,     0,     0,  2522,     0,     0,  2533,     0,
       0,     0,     0,     0,     0,  2540,  2545,     0,   661,     0,
    2550,     0,     0,  2555,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2564,     0,
       0,     0,  2570,     0,     0,     0,  2582,     0,     0,     0,
    2589,     0,     0,  2591,  2592,  2593,  2594,  2595,  2596,  2597,
    2598,  2599,     0,  2600,     0,     0,     0,     0,  1107,  1404,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1733,     0,
       0,     0,     0,  1733,  1733,     0,     0,     0,     0,     0,
       0,     0,  1727,  3615,     0,     0,     0,     0,  3622,     0,
    3624,  3625,  3626,  3627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1473,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1724,
       0,     0,     0,     0,  1724,  1724,     0,     0,     0,     0,
    1726,     0,  3678,  3680,  3682,     0,  3684,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,     0,     0,  1107,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1726,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,  2719,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3753,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
       0,  1724,  1107,     0,     0,     0,  1726,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1724,     0,     0,  1726,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1727,     0,  1107,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2878,     0,     0,  1107,
    1107,     0,  1727,     0,     0,     0,     0,     0,     0,     0,
       0,   661,  1726,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1727,     0,     0,     0,  3839,  1107,
    1107,     0,     0,     0,  1107,     0,     0,     0,     0,  3848,
       0,     0,     0,     0,     0,     0,  1107,  1107,  1107,  1107,
       0,  1724,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,  1107,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,  1107,     0,  1107,     0,     0,     0,
    2983,     0,     0,  1727,     0,     0,     0,     0,     0,  1107,
       0,  1107,     0,     0,     0,  1107,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,     0,     0,  3004,  1727,     0,
       0,     0,  1107,     0,  1107,  1107,  1107,     0,     0,     0,
       0,     0,  3895,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1727,  1107,     0,     0,  1404,     0,     0,
    3911,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
    1107,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,  1107,  1107,  1107,     0,     0,     0,  3043,     0,
       0,     0,  1726,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3945,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,  2545,  1728,  2545,  2545,     0,     0,
       0,     0,     0,     0,     0,     0,  3103,     0,     0,  3106,
       0,  3108,  1733,  1733,     0,  1733,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,  3129,     0,  3131,
       0,     0,     0,  3134,     0,     0,     0,     0,     0,     0,
       0,     0,  1728,  1733,     0,  1733,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3149,     0,     0,     0,     0,     0,
       0,     0,     0,  1724,  1724,     0,  1724,     0,     0,     0,
       0,     0,  3179,  1724,     0,     0,     0,     0,     0,     0,
       0,  1473,     0,     0,     0,     0,     0,     0,  2080,     0,
       0,  1728,     0,  3193,     0,     0,     0,     0,     0,     0,
    2093,  2093,  2090,     0,  1724,     0,  1724,  1733,  1728,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,  1728,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3216,     0,     0,     0,     0,     0,
       0,  1728,     0,     0,     0,     0,     0,     0,     0,     0,
    1733,  1726,     0,     0,     0,     0,  1726,  1726,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,  1724,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1724,     0,  1733,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,  1107,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,  1733,     0,     0,     0,     0,     0,  1724,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,  1724,     0,     0,     0,
       0,     0,  4146,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,  1733,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,  1724,     0,  1107,     0,  1107,     0,     0,     0,
       0,  1733,  1107,     0,     0,  1107,  1107,  1107,  1107,  1107,
    1107,  1107,  1107,  1107,  1107,     0,     0,     0,  1107,  1107,
       0,     0,     0,     0,     0,  1726,  1733,     0,  1727,     0,
       0,  1107,     0,  1727,  1727,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
    1107,     0,  1107,  1724,     0,     0,     0,  1728,     0,     0,
    1733,  1107,  1107,  1107,     0,     0,     0,  1107,     0,     0,
    1107,     0,  1724,     0,     0,     0,     0,     0,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,  1724,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,     0,     0,  3468,     0,     0,
       0,     0,     0,     0,     0,     0,  3471,     0,     0,     0,
       0,     0,  3472,  1990,  3473,     0,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3491,  3492,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1727,     0,     0,  2550,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3517,     0,     0,  3520,     0,
    3522,     0,     0,     0,     0,     0,     0,     0,     0,  3526,
       0,     0,     0,     0,     0,  3531,     0,     0,  3534,     0,
       0,     0,     0,  1724,     0,     0,     0,     0,  3541,     0,
       0,     0,     0,     0,     0,     0,     0,  3004,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1728,  1107,     0,     0,
       0,  1728,  1728,     0,     0,     0,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1733,  1107,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
    1107,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,  1726,     0,  1726,     0,
       0,     0,     0,     0,     0,  1726,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,  1724,     0,  1728,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1726,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,  1107,  1107,     0,  1733,     0,
       0,     0,     0,  1107,  1107,     0,     0,     0,  1107,  1733,
       0,     0,     0,     0,  1107,  1107,     0,     0,  1107,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3725,  3726,     0,     0,     0,  1724,
       0,     0,     0,  1733,     0,  1726,     0,     0,     0,     0,
    1724,  1733,     0,     0,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,  1726,
       0,     0,  1727,  1727,     0,  1727,     0,     0,     0,     0,
    3768,     0,  1727,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1724,     0,     0,     0,  1726,     0,
       0,     0,  1724,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,  1727,     0,  1727,     0,     0,  1107,     0,
       0,     0,     0,  3784,  3786,     0,     0,     0,  1990,     0,
       0,     0,     0,  2529,  1726,     0,  3793,     0,     0,     0,
       0,     0,  3798,  3799,     0,     0,  3801,     0,     0,     0,
       0,     0,  1990,  1990,     0,     0,  1990,     0,  1107,     0,
       0,     0,     0,  1733,     0,     0,  3815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,  1107,     0,     0,     0,     0,  1733,  1727,     0,     0,
       0,     0,     0,     0,  1990,  1726,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,  1733,  1727,     0,  1726,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,  1107,     0,     0,  1107,     0,     0,     0,  1726,
    1727,     0,  1107,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,     0,  1727,  1724,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1727,     0,  1733,  1726,     0,  1107,     0,     0,     0,     0,
    1990,     0,  1724,     0,     0,  1727,     0,     0,     0,     0,
    1990,     0,     0,  1990,     0,     0,  3883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1727,     0,     0,     0,     0,     0,     0,     0,     0,
    1728,  1728,     0,  1728,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,  1724,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,  1107,  3935,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,  1727,     0,     0,     0,  1107,  1733,     0,  1107,
       0,  1107,     0,     0,     0,  1726,     0,     0,     0,     0,
       0,  1727,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3966,     0,     0,     0,  1107,     0,     0,
    1733,  3968,     0,     0,  1733,  1733,  1727,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,  1724,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,  1733,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,  1724,  1724,     0,  1728,     0,
       0,  1107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,  1728,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,  4039,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2550,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,  1727,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,  1728,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1726,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
    1990,     0,  1990,     0,  2529,  2529,  3079,     0,     0,  2529,
       0,     0,     0,  1990,     0,  1727,  1726,     0,     0,     0,
    1990,     0,     0,     0,  1726,  1990,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,  2529,  2529,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,     0,     0,     0,     0,  1990,
       0,  1990,  1990,  1990,  1990,  1990,  1990,  1990,  1990,  1990,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1726,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,     0,  1727,  1726,     0,     0,     0,     0,     0,
       0,  1727,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,  1728,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,     6,     7,     0,     0,
       0,     0,     0,  1728,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,    42,     0,     0,     0,  1990,     0,
       0,     0,     0,     0,     0,     0,  1727,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,  1728,     0,     0,     0,
       0,  1727,     0,     0,     0,     0,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,  1726,  1726,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1727,     0,     0,     0,     0,     0,    45,     0,
       0,  1728,     0,  1990,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
    1727,     0,     0,     0,  3079,  3079,     0,  2529,     0,     0,
    2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,
    3079,     0,     0,     0,     0,     0,     0,  1727,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,  1990,     0,  1990,     0,
       0,     0,     0,  3079,  3079,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,  1727,  1727,     0,  2529,  2529,  1990,
      50,  1990,     0,     0,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,     0,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
      51,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1990,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,    55,    56,    57,
    1728,     4,     0,    58,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1263,     0,
       0,     5,     0,    71,  1264,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,     0,    35,     0,
       0,     0,    37,    38,    39,    40,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,     0,     0,     0,    42,
       0,     0,  2529,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,  1728,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,  1990,  1990,  1990,    46,     0,  3079,     0,     0,     0,
       0,  3079,  3079,  3079,  3079,  3079,  3079,  3079,  3079,  3079,
    3079,  1990,  1990,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,     0,     0,     0,     0,     0,  1990,  2529,  2529,
    1990,     0,  1990,     0,     0,     0,  1990,  3079,  3079,     0,
       0,  1990,     0,    49,  1990,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    51,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3079,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,    55,    56,    57,     0,     0,     0,    58,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1263,  1828,  1990,  1990,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,     0,  2529,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,  1990,     0,     0,     0,
       0,  3079,  3079,  1990,     0,     0,  2529,  2529,  1990,  1990,
       0,  1990,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3079,  2529,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3079,  3079,  1990,     0,  1990,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,  1990,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,  3079,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,  1990,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   688,   422,   423,
     424,   689,   690,   691,   692,   693,   694,   695,   425,   426,
     696,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   697,   431,   432,     0,   433,   434,   698,   699,     0,
     435,   700,   140,   437,   701,   438,   439,   440,   441,   144,
     702,   703,   442,   443,   444,   445,   446,   447,   704,   448,
     449,   450,   451,   452,   453,   705,   454,   455,   456,   149,
     457,     0,   706,   707,   708,   150,   709,   710,   711,   458,
     459,   460,   461,   462,   463,   153,   154,   464,   712,   465,
     713,   466,     0,   467,   468,   469,   714,   470,   471,   472,
     715,   716,   473,   474,   475,   476,   477,   717,   478,   479,
     480,   718,     0,   481,   719,   482,   483,   484,   162,   485,
     486,   164,   720,   487,   721,   488,   166,     0,   722,   489,
     723,   490,   167,   724,   168,   491,   492,   725,   493,   170,
     726,   494,   727,   495,   496,   497,   498,   499,   171,   500,
     501,   502,   728,   503,   504,   505,   506,   507,   508,   729,
     172,   173,   730,   509,   510,   511,   731,   175,   732,   176,
     733,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,   734,   180,   181,   520,   182,   735,   521,
     522,   523,   736,   737,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,   188,   189,
     738,   537,   538,   539,   540,   541,   542,   543,   190,   544,
     739,   545,   546,   192,   547,   740,   193,   548,   194,   549,
     550,   741,   742,   551,   743,   744,   745,   552,   553,     0,
     746,   747,   195,   196,   197,   198,   199,   554,   555,   556,
     557,     0,   558,   748,   559,   200,     0,   201,   560,   561,
     562,   749,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,   750,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   751,   582,   583,   209,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,   752,
     593,   594,     0,   595,   753,   596,   215,   597,   598,   217,
     599,   218,   754,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,   755,   611,   612,   756,   613,
     614,   615,   616,   617,   757,   222,   223,   758,   759,   619,
     224,   620,   225,   760,   621,   622,   623,     0,   624,   625,
     761,   762,   626,   627,   628,   629,   763,   764,   630,   631,
     632,   633,     0,   233,   765,   635,   234,   636,   637,   638,
     766,   767,   639,   768,   769,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    85,     0,     0,    86,    87,
      88,    89,    90,    91,    92,    93,     0,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     106,   904,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,   119,   120,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,   127,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   128,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,   130,   131,     0,     0,     0,
       0,     0,     0,     0,     0,   132,   133,     0,     0,   134,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,   141,
       0,   142,   143,   144,     0,     0,   145,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   147,     0,   148,
       0,     0,     0,   149,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,     0,   151,     0,   152,   153,
     154,   155,     0,     0,     0,     0,     0,   156,     0,     0,
       0,     0,     0,   157,     0,     0,     0,     0,     0,   158,
       0,     0,     0,     0,     0,   159,   160,     0,     0,     0,
       0,   161,   162,   163,     0,   164,     0,     0,   165,     0,
     166,     0,     0,     0,     0,     0,   167,     0,   168,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,     0,
       0,     0,   171,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   172,   173,     0,     0,   174,     0,
       0,   175,     0,   176,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,   180,   181,
       0,   182,     0,   183,   184,     0,     0,     0,     0,   185,
       0,     0,     0,     0,     0,     0,     0,     0,   186,     0,
       0,   187,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,   190,     0,     0,     0,   191,   192,     0,     0,
     193,     0,   194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   195,   196,   197,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,   205,     0,
     206,     0,     0,     0,     0,   207,     0,     0,     0,     0,
     208,   209,     0,   210,   211,     0,     0,   212,     0,     0,
       0,     0,     0,   213,     0,     0,     0,     0,     0,   214,
     215,     0,   216,   217,     0,   218,     0,     0,     0,   219,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,     0,   221,     0,     0,     0,     0,     0,     0,   222,
     223,     0,     0,     0,   224,     0,   225,     0,   226,     0,
     227,     0,     0,     0,   228,     0,     0,   229,     0,   230,
       0,     0,   231,     0,     0,     0,   232,   233,     0,     0,
     234,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,     0,     0,     0,   236,   237,   238,   239,   240,   241,
     242,   243,     0,     0,     0,     0,     0,     0,    55,     0,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   244,
     104,   105,     0,  -122,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,   154,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   162,     0,     0,   164,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   172,   173,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,   196,
     197,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,   217,     0,   218,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,   223,     0,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
       0,     0,   234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,  2678,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     4,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,  2680,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,    35,     0,     0,     0,    37,
      38,    39,    40,    41,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,    42,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,    35,     0,     0,     0,
      37,    38,    39,    40,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    51,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,     0,    55,
      56,    57,     0,     0,     0,    58,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1263,  2430,     0,    51,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1263,     0,     0,     0,     0,    71,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,  2619,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,  2620,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,  1376,  2621,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,  2622,     0,     0,     0,     0,     0,     0,  1391,
    2623,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,   182,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,  1357,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,   217,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,  1374,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  1388,  1389,     0,     0,     0,     0,
       0,     0,     0,  1391,  2531,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1699,
     137,  1700,  1701,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,  1702,  1703,   437,     0,   438,   439,   440,
     441,     0,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,  1704,  1705,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
       0,   485,   486,     0,     0,   487,     0,   488,  1706,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,     0,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,  2190,   503,   504,   505,   506,   507,
     508,     0,   172,  2191,     0,   509,   510,   511,  1349,  1707,
       0,  1708,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,     0,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1709,
     188,  1710,     0,   537,   538,   539,   540,   541,   542,   543,
       0,   544,     0,   545,   546,   192,   547,     0,     0,   548,
    1711,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,  2192,   196,   197,   198,     0,   554,
     555,   556,   557,     0,   558,     0,   559,     0,     0,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1712,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,  2193,   597,
     598,   217,   599,  1714,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1715,  1716,     0,
       0,   619,     0,   620,     0,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,     0,  1717,  2194,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   645,   646,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  2195,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1699,
     137,  1700,  1701,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,  1702,  1703,   437,     0,   438,   439,   440,
     441,     0,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,  1704,  1705,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
       0,   485,   486,     0,     0,   487,     0,   488,  1706,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,     0,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,  2190,   503,   504,   505,   506,   507,
     508,     0,   172,  2191,     0,   509,   510,   511,  1349,  1707,
       0,  1708,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,     0,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1709,
     188,  1710,     0,   537,   538,   539,   540,   541,   542,   543,
       0,   544,     0,   545,   546,   192,   547,     0,     0,   548,
    1711,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,  2192,   196,   197,   198,     0,   554,
     555,   556,   557,     0,   558,     0,   559,     0,     0,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1712,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,  2193,   597,
     598,   217,   599,  1714,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1715,  1716,     0,
       0,   619,     0,   620,     0,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,     0,  1717,  2194,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   645,   646,     0,     0,     0,    55,     0,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,  2944,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,  4042,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   681,
      86,    87,    88,   400,    90,    91,    92,   401, -1564,   402,
      95,     0, -1564,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1325,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1326,   137,  1327,  1328,  2541,   431,   432,
       0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,  1341,  1342,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,  1344,   485,   486,  1345,  1346,   487,
       0,   488,  1347,     0,     0,   489,     0,   490,   167,  2542,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,  1349,  1350,     0,  1351,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,  2543,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1355,   188,  1356,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,  1357,   545,   546,   192,
     547,  1358,  1359,   548,  1360,   549,   550,     0,     0,   551,
    1003,     0,     0,  1361,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1364,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,  1365,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,  1367,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1369,  1370,     0,  2544,   619,  1371,   620,  1372,  1373,
     621,   622,   623,     0,   624,   625,     0,  1374,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,   634,  1376,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,
       0,     0,  1388,  1389,     0,     0,     0,     0,     0,     0,
       0,  1391,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,   213,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,   221,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,  1954,  1376,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,   235,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,     0,     0,     0,
       0,     0,     0,     0,  1391,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1325,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1326,
     137,  1327,  1328,     0,   431,   432,     0,   433,   434,  1329,
    1330,     0,   435,  1331,  1332,   437,     0,   438,   439,   440,
     441,  1333,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,
    1340,   458,   459,   460,   461,   462,   463,  1341,  1342,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
    1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,  1348,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,  1349,  1350,
       0,  1351,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,  1352,   181,   520,   182,
       0,   521,   522,   523,  1353,  1354,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1355,
     188,  1356,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,  1357,   545,   546,   192,   547,  1358,  1359,   548,
    1360,   549,   550,     0,     0,   551,  1003,     0,     0,  1361,
     553,     0,     0,     0,   195,   196,   197,   198,  1362,   554,
     555,   556,   557,     0,   558,     0,   559,  1363,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1364,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,  1365,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,  1366,   596,   215,   597,
     598,   217,   599,  1367,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,  1368,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1369,  1370,     0,
       0,   619,  1371,   620,  1372,  1373,   621,   622,   623,     0,
     624,   625,     0,  1374,   626,   627,   628,   629,  1375,     0,
     630,   631,   632,   633,   634,  1376,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,
       0,     0,     0,     0,     0,  1900,  2490,  1391,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1325,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1326,   137,  1327,  1328,     0,   431,   432,     0,
     433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
    1341,  1342,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,  1344,   485,   486,  1345,  1346,   487,     0,
     488,  1347,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,  1349,  1350,     0,  1351,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,   182,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1355,   188,  1356,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,  1357,   545,   546,   192,   547,
    1358,  1359,   548,  1360,   549,   550,     0,     0,   551,  1003,
       0,     0,  1361,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1364,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,  1365,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,   217,   599,  1367,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,
     622,   623,     0,   624,   625,     0,  1374,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,  1376,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
      56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,
       0,  1388,  1389,  1390,     0,     0,     0,     0,     0,     0,
    1391,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,  1472,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,   182,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,  1357,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,   217,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,  1374,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  1388,  1389,     0,     0,     0,     0,
       0,     0,     0,  1391,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  2088,   422,
     423,   424,     0,     0,     0,     0,  1325,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1326,   137,
    1327,  1328,     0,   431,   432,     0,   433,   434,  1329,  1330,
       0,   435,  1331,  1332,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,  1341,  1342,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,  1344,
     485,   486,  1345,  1346,   487,     0,   488,  1347,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,  1349,  1350,     0,
    1351,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1355,   188,
    1356,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,  1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,
     549,   550,     0,     0,   551,  1003,     0,     0,  1361,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1364,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,  1365,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,  1367,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1369,  1370,     0,     0,
     619,  1371,   620,  1372,  1373,   621,   622,   623,     0,   624,
     625,     0,  1374,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,   634,  1376,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,    56,    57,  1384,  1385,
    1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,     0,
       0,     0,     0,     0,     0,     0,  1391,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,  2982,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,  1376,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,     0,     0,     0,     0,     0,     0,     0,  1391,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1325,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1326,   137,  1327,  1328,     0,   431,
     432,     0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,
     437,     0,   438,   439,   440,   441,  1333,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,  1334,
    1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,
     462,   463,  1341,  1342,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,  1344,   485,   486,  1345,  1346,
     487,     0,   488,  1347,     0,     0,   489,     0,   490,   167,
    2542,   168,   491,   492,     0,   493,  1348,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,  1349,  1350,     0,  1351,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,  1352,   181,   520,   182,     0,   521,   522,   523,  1353,
    1354,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1355,   188,  1356,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,  1357,   545,   546,
     192,   547,  1358,  1359,   548,  1360,   549,   550,     0,     0,
     551,  1003,     0,     0,  1361,   553,     0,     0,     0,   195,
     196,   197,   198,  1362,   554,   555,   556,   557,     0,   558,
       0,   559,  1363,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1364,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,  1365,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,  1366,   596,   215,   597,   598,   217,   599,  1367,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
    1368,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,
    1373,   621,   622,   623,     0,   624,   625,     0,  1374,   626,
     627,   628,   629,  1375,     0,   630,   631,   632,   633,   634,
    1376,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,  1377,  1378,
    1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,
       0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,
       0,     0,     0,  1388,  1389,     0,     0,     0,     0,     0,
       0,     0,  1391,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1325,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1326,   137,  1327,
    1328,     0,   431,   432,     0,   433,   434,  1329,  1330,     0,
     435,  1331,  1332,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,  1341,  1342,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,  1343,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,  1344,   485,
     486,  1345,  1346,   487,     0,   488,  1347,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,  1349,  1350,     0,  1351,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,   182,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1355,   188,  1356,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
    1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,   549,
     550,     0,     0,   551,  1003,     0,     0,  1361,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,  1364,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
    1365,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,   217,
     599,  1367,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,  1369,  1370,     0,     0,   619,
    1371,   620,  1372,  1373,   621,   622,   623,     0,   624,   625,
       0,  1374,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,  1376,  3553,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,    56,    57,  1384,  1385,  1386,
      58,  1387,     0,     0,     0,     0,  1388,  1389,     0,     0,
       0,     0,     0,     0,     0,  1391,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1325,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1326,   137,  1327,  1328,     0,   431,   432,     0,   433,   434,
    1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,   439,
     440,   441,  1333,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,
    1339,  1340,   458,   459,   460,   461,   462,   463,  1341,  1342,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,  1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,  1348,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,  1349,
    1350,     0,  1351,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,  1352,   181,   520,
     182,     0,   521,   522,   523,  1353,  1354,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1355,   188,  1356,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,  1357,   545,   546,   192,   547,  1358,  1359,
     548,  1360,   549,   550,     0,     0,   551,  1003,     0,     0,
    1361,   553,     0,     0,     0,   195,   196,   197,   198,  1362,
     554,   555,   556,   557,     0,   558,     0,   559,  1363,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1364,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,  1365,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,  1366,   596,   215,
     597,   598,   217,   599,  1367,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,  1368,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1369,  1370,
       0,     0,   619,  1371,   620,  1372,  1373,   621,   622,   623,
       0,   624,   625,     0,  1374,   626,   627,   628,   629,  1375,
       0,   630,   631,   632,   633,   634,  1376,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,
    1383,   644,   645,   646,     0,     0,     0,    55,    56,    57,
    1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,
    1389,     0,     0,     0,     0,     0,     0,     0,  1391,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1325,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1326,   137,  1327,  1328,     0,   431,   432,
       0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,  1341,  1342,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,  1344,   485,   486,  1345,  1346,   487,
       0,   488,  1347,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,  1349,  1350,     0,  1351,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1355,   188,  1356,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,  1357,   545,   546,   192,
     547,  1358,  1359,   548,  1360,   549,   550,     0,     0,   551,
    1003,     0,     0,  1361,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1364,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,  1365,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,  1367,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,
     621,   622,   623,     0,   624,   625,     0,  1374,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,   634,  1376,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,  3778,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,
       0,     0,  1388,  1389,     0,     0,     0,     0,     0,     0,
       0,  1391,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,  3785,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,  1376,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,     0,     0,     0,
       0,     0,     0,     0,  1391,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1325,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1326,
     137,  1327,  1328,     0,   431,   432,     0,   433,   434,  1329,
    1330,     0,   435,  1331,  1332,   437,     0,   438,   439,   440,
     441,  1333,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,
    1340,   458,   459,   460,   461,   462,   463,  1341,  1342,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
    1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,  1348,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,  1349,  1350,
       0,  1351,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,  1352,   181,   520,   182,
       0,   521,   522,   523,  1353,  1354,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1355,
     188,  1356,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,   192,   547,  1358,  1359,   548,
    1360,   549,   550,     0,     0,   551,  1003,     0,     0,  1361,
     553,     0,     0,     0,   195,   196,   197,   198,  1362,   554,
     555,   556,   557,     0,   558,     0,   559,  1363,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1364,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,  1365,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,  1366,   596,   215,   597,
     598,   217,   599,  1367,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,  1368,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1369,  1370,     0,
       0,   619,  1371,   620,  1372,  1373,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,  1375,     0,
     630,   631,   632,   633,   634,  1376,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    1385,  1386,    58,  1387,     0,     0,     0,     0,  2524,  2525,
       0,     0,     0,     0,     0,     0,     0,  1391,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1325,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,     0,  1326,   137,  1327,  1328,     0,   431,   432,     0,
     433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
    1341,  1342,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,     0,     0,
     482,   483,   484,  1344,   485,   486,  1345,  1346,   487,     0,
     488,  1347,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,  1349,  1350,     0,  1351,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,     0,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1355,   188,  1356,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,   192,   547,
    1358,  1359,   548,  1360,   549,   550,     0,     0,   551,  1003,
       0,     0,  1361,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1364,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,  1365,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,     0,   599,  1367,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,
     622,   623,     0,   624,   625,     0,  1374,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,  1376,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
      56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,
       0,  1388,  1389,     0,     0,     0,     0,     0,     0,     0,
    1391,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,     0,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,     0,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,     0,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,     0,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  2524,  2525,     0,     0,     0,     0,
       0,     0,     0,  1391,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,     0,   433,   434,     0,  1330,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,  1345,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,   188,
     189,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,   192,   547,     0,  1359,   548,   194,
     549,   550,     0,     0,   551,  1003,     0,  1004,   552,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     213,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,   221,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,  1371,   620,  1372,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,  1954,   233,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,   235,   640,   641,     0,   642,
     643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  2387,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,     0,   433,   434,     0,  1330,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,  1345,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,   182,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,   188,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,   192,   547,     0,  1359,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,  1004,   552,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,   217,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
    1371,   620,  1372,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,   233,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  2387,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,     0,   433,   434,     0,  1330,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
    1345,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,   192,   547,     0,  1359,   548,   194,   549,   550,
       0,     0,   551,  1003,     0,     0,   552,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,  1371,
     620,  1372,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,   233,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,  3919,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
       0,     0,     0,   150,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,   180,   181,   520,   182,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,   188,   189,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,   192,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,  1003,     0,     0,   552,   553,     0,     0,     0,
     195,   196,   197,   198,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,   217,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,  3985,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2964,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456, -1169,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0, -1169,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
   -1169,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512, -1169,   513,   514,   515,   516,
     517,   518,   519,     0,   180, -1169,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187, -1169,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583, -1169,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,  1480,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    57,
       0,     0,     0,    58,     0,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,  3333,  3334,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,    57,     0,
       0,     0,    58,     0,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  3334,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     213,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,   221,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,  1954,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,   235,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   244,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,   213,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,   221,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,  1954,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,   235,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   244,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
    1458,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,  2062,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,  3429,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  3548,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   688,   422,   423,
     424,   689,   690,   691,   692,   693,   694,   695,   425,   426,
     696,   427,   133,   428,   429,   430,   135,  1699,   137,  1700,
    1701,   697,   431,   432,     0,   433,   434,   698,   699,     0,
     435,  1702,  1703,   437,   701,   438,   439,   440,   441,     0,
     702,   703,   442,   443,   444,   445,   446,   447,   704,   448,
     449,   450,   451,   452,   453,   705,   454,   455,   456,   149,
     457,     0,   706,   707,   708,   150,   709,   710,   711,   458,
     459,   460,   461,   462,   463,  1704,  1705,   464,   712,   465,
     713,   466,     0,   467,   468,   469,   714,   470,   471,   472,
     715,   716,   473,   474,  1343,   476,   477,   717,   478,   479,
     480,   718,     0,   481,   719,   482,   483,   484,     0,   485,
     486,     0,   720,   487,   721,   488,  1706,     0,   722,   489,
     723,   490,   167,   724,   168,   491,   492,   725,   493,     0,
     726,   494,   727,   495,   496,   497,   498,   499,   171,   500,
     501,   502,   728,   503,   504,   505,   506,   507,   508,   729,
     172,     0,     0,   509,   510,   511,  1349,  1707,   732,  1708,
     733,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,   734,     0,   181,   520,   182,   735,   521,
     522,   523,   736,   737,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1709,   188,  1710,
     738,   537,   538,   539,   540,   541,   542,   543,     0,   544,
     739,   545,   546,   192,   547,   740,     0,   548,  1711,   549,
     550,   741,   742,   551,   743,   744,   745,  3320,   553,     0,
     746,   747,     0,   196,   197,   198,     0,   554,   555,   556,
     557,     0,   558,   748,   559,     0,     0,     0,   560,   561,
     562,   749,   563,   564,   565,   566,   567,     0,   568,  1712,
     569,   570,   571,   750,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   751,   582,   583,   209,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,     0,   752,
     593,   594,     0,   595,   753,   596,  2193,   597,   598,   217,
     599,  1714,   754,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,   755,   611,   612,   756,   613,
     614,   615,   616,   617,   757,  1715,  1716,     0,   759,   619,
       0,   620,     0,   760,   621,   622,   623,     0,   624,   625,
       0,   762,   626,   627,   628,   629,   763,   764,   630,   631,
     632,   633,     0,  1717,   765,   635,   234,   636,   637,   638,
     766,   767,   639,   768,   769,   640,   641,     0,   642,   643,
       0,     0,     0,     0,     0,     0,     0,     0,   644,   645,
     646,     0,     0,     0,    55,    56,    57,     0,     0,  1120,
      58,     0,  1121,  1122,  1123,     0,  3321,  3322,  1126,  1127,
    1128,  1129,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,  1118,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,  1119,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,     0,     0,     0,  1120,     0,     0,
    1121,  1122,  1123,     0,  1124,  1125,  1126,  1127,  1128,  1129,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,  1194,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,  1195,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,     0,     0,     0,  1120,     0,     0,  1121,  1122,
    1123,     0,  1124,  1125,  1126,  1127,  1128,  1129,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
    1240,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,  1241,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1242,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
       0,     0,     0,  1120,     0,     0,  1121,  1122,  1123,     0,
    1124,  1125,  1126,  1127,  1128,  1129,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,  1682,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,  1683,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,     0,     0,
       0,  1120,     0,     0,  1121,  1122,  1123,     0,  1124,  1125,
    1126,  1127,  1128,  1129,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,  1120,
       0,     0,  1121,  1122,  1123,     0,  1124,  1125,  1126,  1127,
    1128,  1129,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   688,   422,   423,   424,
     689,   690,   691,   692,   693,   694,   695,   425,   426,   696,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     697,   431,   432,     0,   433,   434,   698,   699,     0,   435,
     700,   140,   437,   701,   438,   439,   440,   441,   144,   702,
     703,   442,   443,   444,   445,   446,   447,   704,   448,   449,
     450,   451,   452,   453,   705,   454,   455,   456,   149,   457,
       0,   706,   707,   708,   150,   709,   710,   711,   458,   459,
     460,   461,   462,   463,   153,   154,   464,   712,   465,   713,
     466,     0,   467,   468,   469,   714,   470,   471,   472,   715,
     716,   473,   474,   475,   476,   477,   717,   478,   479,   480,
     718,     0,   481,   719,   482,   483,   484,   162,   485,   486,
     164,   720,   487,   721,   488,   166,     0,   722,   489,   723,
     490,   167,   724,   168,   491,   492,   725,   493,   170,   726,
     494,   727,   495,   496,   497,   498,   499,   171,   500,   501,
     502,   728,   503,   504,   505,   506,   507,   508,   729,   172,
     173,   730,   509,   510,   511,   731,   175,   732,   176,   733,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,   734,   180,   181,   520,   182,   735,   521,   522,
     523,   736,   737,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,   738,
     537,   538,   539,   540,   541,   542,   543,   190,   544,   739,
     545,   546,   192,   547,   740,   193,   548,   194,   549,   550,
     741,   742,   551,   743,   744,   745,   552,   553,     0,   746,
     747,   195,   196,   197,   198,   199,   554,   555,   556,   557,
       0,   558,   748,   559,   200,     0,   201,   560,   561,   562,
     749,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,   750,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,   751,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,   752,   593,
     594,     0,   595,   753,   596,   215,   597,   598,   217,   599,
     218,   754,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,   755,   611,   612,   756,   613,   614,
     615,   616,   617,   757,   222,   223,   758,   759,   619,   224,
     620,   225,   760,   621,   622,   623,     0,   624,   625,   761,
     762,   626,   627,   628,   629,   763,   764,   630,   631,   632,
     633,     0,   233,   765,   635,   234,   636,   637,   638,   766,
     767,   639,   768,   769,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  2053,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,     0,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,  1713,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  2148,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,  1013,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,  2036,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,  2037,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,  2038,     0,   551,     0,
    2039,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,  2040,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      56,    57,     0,     0,     0,    58,     0,     0,     0,     0,
       0,   922,  1517,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,  2046,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,  2037,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
    2038,     0,   551,     0,  2039,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,  2040,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    56,    57,     0,     0,     0,    58,
       0,     0,     0,     0,     0,   922,  1517,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,  2037,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,  2038,     0,   551,     0,  2039,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,  2040,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,     0,     0,     0,     0,   922,
    1517,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   911,   416,   417,
     418,   419,   420,   421,   912,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     913,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   914,   166,     0,     0,   489,     0,   915,     0,
     916,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,   917,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   918,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   919,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   920,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   921,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,     0,     0,     0,     0,    58,     0,     0,
       0,     0,     0,   922,   923,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   911,   416,   417,   418,   419,   420,   421,   912,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   913,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   914,   166,     0,     0,
     489,     0,   915,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   918,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   919,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   920,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   921,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,   922,   923,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,   669,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,  1428,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,  1429,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,  1387,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    4180,     0,    58,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,   618,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,    57,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
    1073,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,    57,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,    57,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,  2022,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    57,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,    57,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1823,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,   981,
      57,    86,    87,    88,   400,    90,    91,    92,   401,   982,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,   983,   435,   958,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   984,     0,   985,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   986,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   987,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   988,   585,   211,   586,   587,
     588,   989,   590,   591,   592,     0,     0,   593,   594,     0,
     990,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   991,   223,     0,     0,   992,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   962,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   993,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   688,   422,   423,   424,
     689,   690,   691,   692,   693,   694,   695,   425,   426,   696,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     697,   431,   432,     0,   433,   434,   698,   699,     0,   435,
     700,   140,   437,   701,   438,   439,   440,   441,   144,   702,
     703,   442,   443,   444,   445,   446,   447,   704,   448,   449,
     450,   451,   452,   453,   705,   454,   455,   456,   149,   457,
       0,   706,   707,   708,   150,   709,   710,   711,   458,   459,
     460,   461,   462,   463,   153,   154,   464,   712,   465,   713,
     466,     0,   467,   468,   469,   714,   470,   471,   472,   715,
     716,   473,   474,   475,   476,   477,   717,   478,   479,   480,
     718,     0,   481,   719,   482,   483,   484,   162,   485,   486,
     164,   720,   487,   721,   488,   166,     0,   722,   489,   723,
     490,   167,   724,   168,   491,   492,   725,   493,   170,   726,
     494,   727,   495,   496,   497,   498,   499,   171,   500,   501,
     502,   728,   503,   504,   505,   506,   507,   508,   729,   172,
     173,   730,   509,   510,   511,   731,   175,   732,   176,   733,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,   734,   180,   181,   520,   182,   735,   521,   522,
     523,   736,   737,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,   738,
     537,   538,   539,   540,   541,   542,   543,   190,   544,   739,
     545,   546,   192,   547,   740,   193,   548,   194,   549,   550,
     741,   742,   551,   743,   744,   745,   552,   553,     0,   746,
     747,   195,   196,   197,   198,   199,   554,   555,   556,   557,
       0,   558,   748,   559,   200,     0,   201,   560,   561,   562,
     749,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,   750,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,   751,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,   752,   593,
     594,     0,   595,   753,   596,   215,   597,   598,   217,   599,
     218,   754,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,   755,   611,   612,   756,   613,   614,
     615,   616,   617,   757,   222,   223,   758,   759,   619,   224,
     620,   225,   760,   621,   622,   623,     0,   624,   625,   761,
     762,   626,   627,   628,   629,   763,   764,   630,   631,   632,
     633,     0,   233,   765,   635,   234,   636,   637,   638,   766,
     767,   639,   768,   769,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,  2814,   419,   420,   421,   688,   422,
     423,   424,   689,   690,   691,   692,   693,   694,   695,   425,
     426,   696,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,   697,   431,   432,     0,   433,   434,   698,   699,
       0,   435,   700,   140,   437,   701,   438,   439,   440,   441,
     144,   702,   703,   442,   443,   444,   445,   446,   447,   704,
     448,   449,   450,   451,   452,   453,   705,   454,   455,   456,
     149,   457,     0,   706,   707,   708,   150,   709,   710,   711,
     458,   459,   460,   461,   462,   463,   153,   154,   464,   712,
     465,   713,   466,     0,   467,   468,   469,   714,   470,   471,
     472,   715,   716,   473,   474,   475,  2815,   477,   717,   478,
     479,   480,   718,     0,   481,   719,   482,   483,   484,   162,
     485,   486,   164,   720,   487,   721,   488,   166,     0,   722,
     489,   723,   490,   167,   724,   168,   491,   492,   725,   493,
     170,   726,   494,   727,   495,   496,   497,   498,   499,   171,
     500,   501,   502,   728,   503,   504,   505,   506,   507,   508,
     729,   172,   173,   730,   509,   510,   511,   731,   175,   732,
     176,   733,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,   734,   180,   181,   520,   182,   735,
     521,   522,   523,   736,   737,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,   188,
     189,   738,   537,   538,   539,   540,   541,   542,   543,   190,
     544,   739,   545,   546,   192,   547,   740,   193,   548,   194,
     549,   550,   741,   742,   551,   743,   744,   745,   552,   553,
       0,   746,   747,   195,   196,   197,   198,   199,   554,   555,
     556,   557,     0,   558,   748,   559,   200,     0,   201,   560,
     561,   562,   749,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,   750,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,   751,   582,   583,   209,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     752,   593,   594,     0,   595,   753,  2816,   215,   597,   598,
     217,   599,   218,   754,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,   755,   611,   612,   756,
     613,   614,   615,   616,   617,   757,   222,   223,   758,   759,
     619,   224,   620,   225,   760,   621,   622,   623,     0,   624,
     625,   761,   762,   626,   627,   628,   629,   763,   764,   630,
     631,   632,   633,     0,   233,   765,   635,   234,   636,   637,
     638,   766,   767,   639,   768,   769,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,   180,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,   188,   189,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,   192,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,  1003,     0,     0,
     552,   553,     0,     0,     0,   195,   196,   197,   198,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,   217,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,     0,     0,     0,
     150,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,  1227,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,   180,
     181,   520,   182,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,   188,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,   192,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,     0,   552,   553,     0,     0,     0,   195,   196,   197,
     198,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,   217,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,  1235,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,   180,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,   188,   189,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
     192,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,  1003,     0,     0,   552,   553,     0,     0,     0,   195,
     196,   197,   198,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,   217,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1699,   137,  1700,  1701,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
    1702,  1703,   437,     0,   438,   439,   440,   441,     0,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,     0,     0,     0,   150,     0,     0,     0,   458,   459,
     460,   461,   462,   463,  1704,  1705,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,     0,   485,   486,
       0,     0,   487,     0,   488,  1706,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,     0,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,  2190,   503,   504,   505,   506,   507,   508,     0,   172,
    2191,     0,   509,   510,   511,  1349,  1707,     0,  1708,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,     0,   181,   520,   182,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1709,   188,  1710,     0,
     537,   538,   539,   540,   541,   542,   543,     0,   544,     0,
     545,   546,   192,   547,     0,     0,   548,  1711,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,  2192,   196,   197,   198,     0,   554,   555,   556,   557,
       0,   558,     0,   559,     0,     0,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1712,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,  2193,   597,   598,   217,   599,
    1714,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1715,  1716,     0,     0,   619,     0,
     620,     0,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,     0,  1717,  2194,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,     0,
       0,     0,     0,     0,     0,     0,     0,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,  2182,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,  2193,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,  3406,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1699,   137,  1700,  1701,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,  1702,  1703,   437,     0,   438,   439,
     440,   441,     0,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,  1704,  1705,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,     0,   485,   486,     0,     0,   487,     0,   488,  1706,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,     0,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,     0,     0,   509,   510,   511,  1349,
    1707,     0,  1708,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,     0,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1709,   188,  1710,     0,   537,   538,   539,   540,   541,   542,
     543,  2231,   544,     0,   545,   546,   192,   547,     0,     0,
     548,  1711,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,     0,   196,   197,   198,     0,
     554,   555,   556,   557,     0,   558,     0,   559,     0,     0,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1712,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,  1713,
     597,   598,   217,   599,  1714,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1715,  1716,
       0,     0,   619,     0,   620,     0,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,     0,  1717,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,     0,     0,     0,     0,     0,     0,     0,
       0,   644,   645,   646,     0,     0,     0,    55,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1699,   137,  1700,  1701,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,  1702,  1703,   437,     0,
     438,   439,   440,   441,     0,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,     0,     0,     0,
     150,     0,     0,     0,   458,   459,   460,   461,   462,   463,
    1704,  1705,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,     0,   485,   486,     0,     0,   487,     0,
     488,  1706,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,     0,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,     0,     0,   509,   510,
     511,  1349,  1707,     0,  1708,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,     0,
     181,   520,   182,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1709,   188,  1710,     0,   537,   538,   539,   540,
     541,   542,   543,  3256,   544,     0,   545,   546,   192,   547,
       0,     0,   548,  1711,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,     0,   196,   197,
     198,     0,   554,   555,   556,   557,     0,   558,     0,   559,
       0,     0,     0,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1712,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,  1713,   597,   598,   217,   599,  1714,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1715,  1716,     0,     0,   619,     0,   620,     0,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,     0,  1717,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,     0,     0,     0,     0,     0,
       0,     0,     0,   644,   645,   646,     0,     0,     0,    55,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1699,   137,  1700,  1701,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,  1702,  1703,
     437,     0,   438,   439,   440,   441,     0,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,  1704,  1705,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,     0,   485,   486,     0,     0,
     487,     0,   488,  1706,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,     0,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,     0,     0,
     509,   510,   511,  1349,  1707,     0,  1708,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,     0,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1709,   188,  1710,     0,   537,   538,
     539,   540,   541,   542,   543,     0,   544,     0,   545,   546,
     192,   547,     0,     0,   548,  1711,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,     0,
     196,   197,   198,     0,   554,   555,   556,   557,     0,   558,
       0,   559,     0,     0,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1712,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,  1713,   597,   598,   217,   599,  1714,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1715,  1716,     0,     0,   619,     0,   620,     0,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,     0,
    1717,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,     0,     0,     0,
       0,     0,     0,     0,     0,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1699,   137,  1700,  1701,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
    1702,  1703,   437,     0,   438,   439,   440,   441,     0,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,     0,     0,     0,   150,     0,     0,     0,   458,   459,
     460,   461,   462,   463,  1704,  1705,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,     0,   485,   486,
       0,     0,   487,     0,   488,  1706,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,     0,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
       0,     0,   509,   510,   511,  1349,  1707,     0,  1708,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,     0,   181,   520,   182,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1709,   188,  1710,     0,
     537,   538,   539,   540,   541,   542,   543,     0,   544,     0,
     545,   546,   192,   547,     0,     0,   548,  1711,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,     0,   196,   197,   198,     0,   554,   555,   556,   557,
       0,   558,     0,   559,     0,     0,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1712,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,  2193,   597,   598,   217,   599,
    1714,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1715,  1716,     0,     0,   619,     0,
     620,     0,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,     0,  1717,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,     0,
       0,     0,     0,     0,     0,     0,     0,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,     0,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,     0,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
       0,   137,     0,     0,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,     0,     0,   437,     0,   438,   439,
     440,   441,     0,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,     0,     0,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,     0,   485,   486,     0,     0,   487,     0,   488,     0,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,     0,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,     0,     0,   509,   510,   511,     0,
       0,     0,     0,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,     0,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
       0,   188,     0,     0,   537,   538,   539,   540,   541,   542,
     543,     0,   544,     0,   545,   546,   192,   547,     0,     0,
     548,     0,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,     0,   196,   197,   198,     0,
     554,   555,   556,   557,     0,   558,     0,   559,     0,     0,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,     0,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,     0,
     597,   598,   217,   599,     0,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,     0,     0,
       0,     0,   619,     0,   620,     0,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,     0,     0,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,     0,     0,     0,     0,     0,     0,     0,
       0,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   688,   422,   423,   424,   689,   690,   691,   692,   693,
     694,   695,   425,   426,   696,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   697,   431,   432,     0,   433,
     434,   698,   699,     0,   435,     0,   140,   437,   701,   438,
     439,   440,   441,   144,   702,   703,   442,   443,   444,   445,
     446,   447,   704,   448,   449,   450,   451,   452,   453,   705,
     454,   455,   456,   149,   457,     0,   706,   707,   708,   150,
     709,   710,   711,   458,   459,   460,   461,     0,   463,   153,
     154,   464,   712,   465,   713,   466,     0,   467,   468,   469,
     714,   470,   471,   472,   715,   716,   473,   474,   475,   476,
     477,   717,   478,   479,   480,   718,     0,   481,   719,   482,
     483,   484,   162,   485,   486,   164,   720,   487,   721,   488,
     166,     0,   722,   489,   723,   490,   167,   724,   168,   491,
     492,   725,   493,   170,   726,   494,   727,   495,   496,     0,
     498,   499,   171,   500,   501,   502,   728,   503,   504,   505,
     506,   507,   508,   729,   172,   173,     0,   509,   510,   511,
       0,   175,   732,   176,   733,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,   734,   180,   181,
     520,   182,   735,   521,   522,   523,   736,   737,   524,   525,
     526,   527,   528,   529,     0,   531,   532,     0,   534,   535,
     536,   187,   188,   189,   738,   537,   538,   539,   540,   541,
     542,   543,   190,   544,   739,   545,   546,   192,   547,   740,
     193,   548,   194,   549,   550,   741,   742,   551,   743,   744,
     745,   552,   553,     0,   746,   747,   195,   196,   197,   198,
     199,   554,   555,   556,   557,     0,   558,   748,   559,   200,
       0,   201,   560,   561,   562,   749,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,   750,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   751,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,     0,     0,   752,   593,   594,     0,   595,   753,   596,
     215,   597,   598,   217,   599,   218,   754,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,   755,
     611,   612,   756,   613,   614,   615,   616,   617,   757,   222,
     223,     0,   759,   619,   224,   620,   225,   760,   621,   622,
     623,     0,   624,   625,     0,   762,   626,   627,   628,   629,
     763,   764,   630,   631,   632,   633,     0,   233,   765,   635,
     234,   636,   637,   638,   766,   767,   639,   768,   769,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,     0,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,  2162,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,  2163,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,  2164,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,  2926,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,  2165,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,  2166,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     971,   420,   421,   930,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,   931,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,   972,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,   932,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,   933,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   667,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,   668,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,   669,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   930,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,   931,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,   932,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,   933,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,  1862,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,  1863,
     490,     0,     0,     0,  1864,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,  1865,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,  1003,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,  1866,   590,   591,   592,     0,     0,  1867,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,  1868,  1869,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,  2608,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,  2609,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,  2610,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,  2611,   613,
    2612,   615,  2613,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,   130,   131,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,  1003,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,   864,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,   865,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   866,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,  1003,     0,  1004,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,  1431,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,  1003,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
     931,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,   932,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,   933,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,   669,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,  1003,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,  1222,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,   916,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,   917,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,  2272,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,  2273,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  2751,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,  2752,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2761,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,  2762,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
     676,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   817,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   907,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   947,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
    1444,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,   983,   435,   958,
     140,  1445,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   987,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   988,   585,   211,   586,
     587,   588,   989,   590,   591,   592,     0,     0,   593,   594,
       0,  1435,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   991,   223,     0,     0,   992,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     962,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   993,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,  1775,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2964,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2977,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,  3014,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,  3677,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,  3679,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,  3681,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,  4042,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   870,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   955,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   957,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   958,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   959,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   960,   223,     0,     0,   961,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   962,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   996,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   958,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   997,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   998,   223,     0,     0,
     999,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   962,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,  1021,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
    1143,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,  1206,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,  1232,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,  1237,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,  1245,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  1247,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1249,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,  1251,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,  1254,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,  1256,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,  1257,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    1260,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,   983,   435,   958,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     987,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   988,   585,   211,   586,   587,   588,   989,   590,
     591,   592,     0,     0,   593,   594,     0,  1435,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   991,
     223,     0,     0,   992,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   962,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   993,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  1467,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
       0,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
    1557,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,  1770,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  1801,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1803,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,  1897,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
     983,   435,   958,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   987,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   988,
     585,   211,   586,   587,   588,   989,   590,   591,   592,     0,
       0,   593,   594,     0,  1435,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
    2159,   614,   615,   616,   617,     0,   991,   223,     0,     0,
     992,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   962,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     993,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,   983,   435,   958,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   987,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     988,   585,   211,   586,   587,   588,  2186,   590,   591,   592,
       0,     0,   593,   594,     0,  1435,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   991,   223,     0,
       0,   992,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   962,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   993,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    2403,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,     0,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,    86,    87,    88,    55,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
   -1829,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
       0,    35,     0,   394,     0,     0,     0,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,   154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   160,     0,     0,     0,     0,     0,   162,
       0,     0,   164,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,   168,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   172,   173,     0,     0,     0,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,   190,
       0,     0,     0,     0,   192,     0,     0,   193,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   195,   196,   197,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   209,     0,
       0,   211,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
     217,     0,   218,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   223,     0,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,     0,     0,   234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   236,   237,   238,   239,   240,   241,   242,   243,     0,
       0,     0,    86,    87,    88,    55,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115, -1830,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,     0,    35,     0,
    1067,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   153,   154,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     160,     0,     0,     0,     0,     0,   162,     0,     0,   164,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     167,     0,   168,     0,     0,     0,     0,   170,     0,     0,
       0,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   172,   173,
       0,     0,     0,     0,     0,   175,     0,   176,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,   180,   181,     0,   182,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,   190,     0,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,   196,   197,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   209,     0,     0,   211,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,     0,     0,   217,     0,   218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,   223,     0,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,     0,     0,   234,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   236,   237,
     238,   239,   240,   241,   242,   243,     0,     0,     0,    86,
      87,    88,    55,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,   154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   162,     0,     0,   164,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,   167,     0,   168,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   172,   173,     0,     0,     0,
       0,     0,   175,     0,   176,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,     0,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   195,   196,   197,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   209,     0,     0,   211,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,   217,     0,   218,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,   223,     0,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,     0,     0,     0,    86,    87,    88,    55,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,   154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     162,     0,     0,   164,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,   167,     0,   168,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   172,   173,     0,     0,     0,     0,     0,   175,
       0,   176,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,   180,   181,     0,   182,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
     190,     0,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   209,
       0,     0,   211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,   217,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,    86,    87,    88,    55,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
       0,     0,     0,    55
};

static const short yycheck[] =
{
       2,   800,   165,   244,  1081,   932,   933,  1036,  1236,     2,
     937,   838,  1036,   226,   117,   985,   152,  1038,  1274,   151,
    1613,  1293,    78,   186,  1307,  1243,  1110,     2,  1134,   148,
    1825,  1151,   988,  1205,    78,  1864,   169,  1729,  1144,   838,
      84,  2198,   792,  1713,    78,  1341,  1342,   797,    78,    78,
      78,    94,  1832,  1320,   208,   679,    84,   160,  2198,  2199,
     887,  1370,  1646,   221,  1360,   362,   202,  2387,  2230,   992,
    1061,   132,   230,  2011,  2485,   208,  2661,   827,   362,  1762,
    1186,  1100,  1463,    78,  1182,  1191,  2623,    89,   887,   132,
     207,  2952,  1198,  1511,  1512,  1513,  2814,   214,  2816,   216,
    1748,  1207,  1786,  1900,   334,  2062,  1748,  1748,   151,  1081,
    2459,   348,  1597,  1748,  1000,  1748,  1748,  3189,  2398,  2392,
    2393,  2905,  1640,   214,  3359,   228,  1566,   877,  3407,  2877,
    1228,   117,  2068,   158,   884,  1391,  2071,  1275,  1821,  1331,
    1332,  1266,   348,  3379,  1213,  1114,    30,    21,   117,   151,
      89,  1033,   147,    10,    73,  1033,  1081,  2905,    71,  2305,
    1076,  1077,    73,   117,  1356,    98,  2107,    71,    73,  2331,
    3085,   904,   143,   110,   160,  3429,   108,  3431,   124,  3881,
    1561,    84,   184,    78,    89,    73,    73,    89,   170,    84,
     165,   160,   133,   117,    96,    78,   136,   786,   187,   103,
     194,    84,  2143,   312,  3710,   117,  2147,    92,   215,    71,
     102,   186,    85,  2891,  2892,  2893,  2894,  2895,  2896,    72,
     220,   153,   117,  2524,  2525,   177,   165,    80,  2529,    72,
      73,    89,   252,    89,   117,   102,   153,    80,    96,   218,
     864,   103,   228,   215,    29,   345,   209,   186,  2410,   244,
    2412,    71,    73,  1180,   215,   353,   252,   294,   117,   228,
      73,   372,    38,   210,    40,   160,  3830,  2568,  2569,   217,
     419,  1963,    76,    77,    78,    79,    89,   160,   207,   215,
     256,   215,    73,   174,   117,   117,   172,    99,   374,    89,
      78,   234,   173,   147,   273,   282,    84,   330,   354,   126,
     456,   160,    37,  1259,    76,    77,    78,    79,    76,    77,
      78,    79,   207,   140,   187,    76,    77,    78,    79,   214,
     354,   216,  3886,    78,   354,   354,   359,   160,  1448,   117,
       0,    78,  4162,   228,   362,   217,    85,   423,    73,  1166,
      85,  3576,    91,    83,   500,   228,    14,   252,   207,   189,
     231,   500,   396,   348,   387,   214,   399,   216,   982,   354,
     175,   243,   253,   124,   293,   219,   178,  1166,   396,   228,
      71,   319,   160,  2314,   350,   338,   126,    89,    76,    77,
      78,    79,   182,   175,    96,   212,   497,  4217,   497,  1275,
      37,   252,   379,   364,  1413,   228,  3902,   497,   387,   497,
    1286,  1287,   103,   252,   252,   163,  1156,  1716,  1704,  1705,
     252,   365,   419,  1163,   361,  1711,  3980,    76,    77,    78,
      79,   307,    76,    77,    78,    79,    73,   221,   252,    76,
      77,    78,    79,   412,   471,   414,   230,    71,   187,   252,
     228,   365,   187,   439,    76,    77,    78,    79,    76,    77,
      78,    79,  1680,   365,   246,  3690,  1447,   330,   198,   244,
    1451,  1452,   212,  3247,  1214,   124,  1684,   362,    76,    77,
      78,    79,   170,    76,    77,    78,    79,   362,   419,   362,
     336,   501,    76,    77,    78,    79,   618,   439,  1444,   374,
     430,   788,   394,   396,  3729,  3749,  4198,   429,   314,  3247,
     500,   396,   484,   497,   788,    76,    77,    78,    79,  1098,
    1702,  1703,   429,   396,   387,   407,   343,   215,  1710,    76,
      77,    78,    79,  2193,  1696,  1411,   302,  2463,   500,   500,
    1636,  1264,  1638,   365,   117,    71,   394,  3215,   423,   500,
     407,    71,    76,    77,    78,    79,   500,    76,    77,    78,
      79,   497,  1672,   254,   255,   443,   412,   500,   414,  3474,
     497,   497,   170,   482,   497,   439,   500,  1453,  1454,   488,
     489,   482,    71,   103,   362,   618,   500,   482,   497,  1677,
     493,   330,   169,   488,   489,  1857,   443,  1693,   500,   493,
     477,  1582,  2176,   343,  3829,   482,   501,  1588,  2738,   354,
    2740,   488,   489,  1528,   305,  1674,   433,   354,   396,  1525,
     359,   495,   452,  3150,   359,  1497,   618,   491,  1999,  1497,
     254,  2557,   437,   476,  2005,   165,   384,  1596,   490,   491,
     492,   493,   372,   476,   426,   456,   679,  1628,   499,   482,
    1631,  1632,    71,  1899,  1900,   437,  1730,  2967,   806,   389,
     252,  2971,   501,   501,  1910,   294,   477,  1913,   500,  3895,
     130,   482,   794,  3341,   110,  1921,  1922,   488,   489,   482,
     490,   491,   492,   493,   478,   488,   489,   501,  1934,  1935,
     910,   784,   394,   433,   500,   319,   447,   227,   501,  1945,
    1681,   482,  2630,   497,  2856,  2857,   215,   488,   489,   831,
    1838,  1770,  2643,  2387,  1829,  2851,   478,   312,  2854,  2855,
     478,   294,  2858,  2648,   872,   161,  2156,   478,   254,   198,
     175,   419,  2868,   495,   254,   497,   315,   499,   170,   497,
     866,   389,   187,  1925,  1926,  3923,   497,  2877,    76,    77,
      78,    79,   282,    25,  2000,   285,   198,    25,   911,   881,
     913,   140,   915,   419,   318,   254,   164,   108,   921,  3873,
     788,   222,    22,   419,    14,  2905,  3067,   256,  4047,  3070,
    3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,   437,
     478,   170,   365,    89,    71,   943,   484,   488,   489,   490,
     491,   492,   493,   447,  1621,   170,   821,   372,   784,   245,
     110,   499,   126,   442,   387,   234,   170,   175,    95,   133,
    2950,   142,  1768,    73,   217,   784,   140,   448,   484,   478,
     822,   864,  1621,   398,   478,   254,  3127,  3128,   853,   237,
     477,   478,   479,   480,   421,   482,   138,   439,   497,   379,
    1767,   488,   489,   497,   500,   315,   478,   481,   294,  2367,
     478,   161,  1010,   184,   488,   489,   490,   491,   492,   493,
     302,   350,   170,   457,   907,   497,   400,   401,  3729,   986,
     478,   458,   101,   990,   482,   478,   182,   179,   246,   230,
    4115,   475,    90,   234,   478,   340,   172,  4001,   212,   784,
     319,   138,   497,   788,   497,   986,   460,  1867,  1868,   990,
     419,   784,   904,   497,  3184,   788,    51,   478,   497,   370,
     389,   904,   163,   302,    76,    77,    78,    79,   269,    71,
    4108,   478,    97,   984,    69,   784,   497,   302,   217,   904,
     470,   377,   179,  2617,   376,   245,   911,   389,   913,   982,
     915,   984,  2634,    95,   478,   947,   921,   922,   923,   478,
    1836,   784,   488,   489,   490,   491,   492,   493,   488,   489,
     490,   491,   492,   493,  1850,   484,   248,   254,   497,   307,
     248,   374,   911,   975,   913,  3693,   915,   173,  1805,    85,
     499,   983,   921,  1011,   294,   987,   988,   989,    71,   488,
     489,   490,   491,   492,   493,   170,   784,   174,   792,   307,
     788,   409,   410,   797,   233,   799,  1805,  3544,  3545,  3546,
     804,   500,   806,   381,   216,   173,   302,   381,   812,   343,
     103,    76,    77,    78,    79,   108,   820,  2323,   141,   331,
     319,   825,   319,   827,   484,   231,  1786,   118,  1788,   247,
     391,  4113,  4114,   294,   138,   126,   410,  1797,   227,   499,
     361,  3352,   481,  3837,  3907,   484,   485,   486,   171,   488,
     489,   490,   491,   492,   493,  2142,   254,   377,  1061,   437,
    4044,  4045,   330,   231,  1076,  1077,   253,   172,   872,  1081,
     444,   187,  4049,   877,   331,   179,  1061,   372,  1081,  3837,
     884,   986,   456,  2265,   160,   990,    76,    77,    78,    79,
    3420,   359,   254,   282,  1931,  3425,  1081,  3247,  3428,   433,
     317,   413,  3461,   402,  1864,   170,  1011,  4189,    76,    77,
      78,    79,  1061,  1948,   138,   238,  1951,   986,  1011,   317,
     332,   990,  1931,   497,  2125,   457,   374,  1076,  1077,   374,
     478,  2725,  1081,  3416,   938,   456,   241,   230,  3294,   943,
    1391,   234,   437,   475,  3300,  3301,  3302,  3303,  3304,  3305,
     954,   163,   228,  1492,  2050,   179,   413,   319,   170,  4022,
    2142,   254,   255,    76,    77,    78,    79,  2405,  4152,  1181,
    2352,  2353,  2354,  2355,  3013,   423,   269,  4154,   423,   500,
     392,   985,   273,   282,   481,  2413,   285,   484,   485,   486,
     379,   488,   489,   490,   491,   492,   493,   302,   349,   302,
    1004,   924,    76,    77,    78,    79,  1010,  3518,  3519,   133,
    1276,  4188,   305,  1011,   330,  3182,   140,    76,    77,    78,
      79,   944,   373,    25,  1028,  3397,   319,   331,  2494,   497,
    3825,  1471,  1276,    35,  3041,  1301,  1276,  1276,  1485,  1486,
    2241,  1488,  2737,   359,  4115,   348,  1553,  1259,  2249,  2907,
    2251,  1263,  1264,  1306,  1266,  2907,  2907,   215,  2649,  1553,
    1263,  1264,  2907,  1266,  2907,  2907,  3438,   252,  3440,  1485,
    1486,  1276,  1488,  2967,   206,   410,  2542,  2971,  1263,  1264,
     379,  1266,   182,   329,   184,  4013,    76,    77,    78,    79,
     302,  2399,    76,    77,    78,    79,  1301,   196,   391,   484,
     421,    76,    77,    78,    79,  2571,   478,   331,  3001,   413,
     495,   197,   497,   498,   499,   500,   350,   307,   216,   481,
    1325,   123,   484,   485,   486,   497,   488,   489,   490,   491,
     492,   493,   359,  2936,    93,    94,   363,    72,   270,  1344,
    2606,    76,    77,    78,    79,    80,  3767,   497,  1461,   235,
     141,   250,  1156,  2619,  2620,   389,  4030,  1428,  1429,  1163,
     387,    76,    77,    78,    79,   330,  2395,   456,    73,  1374,
     456,    76,    77,    78,    79,  1428,  1429,    71,   381,   342,
     171,  1393,   314,   457,  3062,   500,  1391,   399,   481,   413,
     402,  1403,   485,   486,   359,   488,   489,   490,   491,   492,
     493,   475,  1414,   437,  1208,  1209,  1210,   410,  3086,   103,
    1214,   500,   312,   478,   500,   182,  3746,   184,   321,    76,
      77,    78,    79,   497,   323,   495,  3973,   330,  4102,   456,
     165,   501,  1444,  2715,     5,  1447,  4110,  2743,   215,  1451,
    1452,   444,   165,  1570,  1447,   126,   248,   238,  1451,  1452,
     162,   294,  1523,  1566,    25,   170,  2884,   234,   421,   140,
    2426,  3772,  1447,  1590,    35,  1461,  1451,  1452,  1506,  1507,
    1523,    76,    77,    78,    79,  3631,  3632,  4151,   321,   342,
    1485,  1486,  1461,  1488,  3334,  3796,  3797,   330,   478,   170,
     350,   172,   227,  1297,   497,   458,  1623,   495,  1447,     7,
     360,   499,  1451,  1452,   227,    87,   421,  2141,   218,  1505,
     478,    19,    20,  1525,  1517,  1553,  1320,   307,    76,    77,
      78,    79,  1560,   383,   106,   382,  1505,   239,   104,   497,
    1515,    39,  1517,   432,    42,   302,  1539,  1540,    76,    77,
      78,    79,    71,   458,   457,   312,   449,   282,  1533,   125,
     285,   326,   123,   410,  1539,  1540,  1461,  1111,   421,   282,
     241,  3728,   475,   273,   210,   478,   501,  1662,  1461,   281,
    1566,   283,    76,    77,    78,    79,  1525,   147,   147,  1582,
    1134,   477,   207,   229,   497,  1588,   482,  1566,  1575,  2980,
    1144,   216,  1461,   450,  1933,   458,   412,  1582,   414,   442,
    1505,  1506,  1507,  1588,   478,    73,   501,  3555,    76,    77,
      78,    79,  1505,  1506,  1507,   186,  1603,   162,  1461,   478,
      71,   302,   503,   497,  1875,  1628,   307,  2387,  1631,  1632,
    1743,  3022,  1644,  1582,  2635,   143,    41,  3339,   497,  1588,
    3951,  2735,   126,  1628,   379,  1740,  1631,  1632,  1553,   219,
     219,  1746,   103,  1795,  1458,  1560,   379,   108,   439,   317,
    1553,  1566,   343,  1461,   322,  1570,   170,  1560,  1763,   163,
     139,   210,   359,  1566,   355,   183,   363,   248,  1681,  1628,
      72,    73,  1631,  1632,  2664,  1590,   170,  3837,   478,  2541,
     229,  2543,  2544,    71,   478,  3289,  1681,  1566,  3854,  2632,
     387,  1570,   412,   478,   414,   248,   457,  1505,  1506,  1507,
    1839,  1879,    16,   497,   382,  2981,  3107,    95,  1623,   330,
    3892,  1590,   191,  1566,   475,   254,  3420,   412,   317,   414,
    1894,  3425,  1681,   322,  3428,   470,   281,  1749,   283,   378,
     450,   476,   410,   478,   260,   330,   497,  1743,   359,   128,
    1893,  2588,   433,  2060,  1623,  1553,  1768,  3034,   330,   381,
      34,   206,  1560,   478,  1743,   210,  2060,   146,  1566,   456,
    3089,  3090,   477,   478,   359,  3925,   387,   482,  3568,  2588,
     159,  1786,   450,   234,   489,   313,   497,   359,   410,   317,
     319,   363,   419,  1778,   263,   264,   366,   366,   330,  1604,
     123,   124,  1607,   254,   255,  1609,  2440,   276,   330,  3659,
    3660,  3661,  3662,  3663,  3516,   387,   423,  1829,   302,  1885,
    1832,   478,   444,   307,   500,   270,  1829,   359,   504,  1832,
    3096,   210,  3125,  3513,   456,   330,   495,   359,  1743,   500,
     501,  1885,  1647,   502,  1829,  1885,  1885,  1832,   163,  2658,
    1743,   500,  1656,  1966,   305,   504,  1136,  2617,  1138,   343,
     151,   330,   361,   496,   359,  1145,   216,   500,   319,   314,
    1875,   355,  1676,   478,  1743,   497,   254,   456,   457,     8,
    1885,  4048,    11,    12,   456,   498,   456,   456,   501,   372,
     373,   147,   242,    22,    23,    24,   498,    26,    27,   501,
    1743,   378,    31,    32,    33,   492,  1918,   257,   346,   492,
     497,  2084,   499,   169,   497,   376,   499,   267,   144,   175,
     478,   237,   411,  3229,   481,   216,  1911,  1912,   498,   498,
     163,   501,   501,   495,  1919,   497,  3218,  3219,  1923,  1924,
     478,   319,   411,   199,   413,  1743,   490,   491,   492,   433,
     411,   242,   481,  1938,   496,  1940,   485,   486,   500,   488,
     489,   490,   491,   492,   493,  1970,   257,   456,   457,  2906,
    1966,   498,   502,   500,   478,  1960,   267,  1962,   497,   497,
     499,   499,  1786,  2949,  1788,    98,    71,  1966,   229,   498,
     246,   500,    73,  1797,   206,   456,   457,   378,   210,   290,
     260,  3310,  3311,   116,   114,  3314,  1810,  3316,   497,   477,
     478,   479,   480,    71,   482,  1819,  2158,  2029,   103,   369,
     488,   489,  2060,   108,   503,   498,  2011,   500,   482,  3723,
     481,   497,  3871,   146,   163,   252,   497,   488,   489,   490,
     491,   492,   493,  2156,   497,  3175,  1250,   317,   498,    71,
     500,   495,  3746,   497,  2108,   499,  2110,  1261,   270,   256,
    1864,  1966,   165,  1867,  1868,   498,   104,   500,  2877,  2074,
    2108,   114,  2110,  1966,   498,  1879,   500,   498,   369,   500,
     498,   103,   500,   376,   472,   498,   108,   500,  2141,   202,
     499,   498,   376,   500,   372,   373,  2905,  1966,   498,  2084,
     500,   320,   314,   481,   500,   501,   484,   485,   486,  2222,
     488,   489,   490,   491,   492,   493,   320,  2129,   411,   232,
    3822,   317,  2125,  1966,   227,   381,   498,   411,   500,   419,
    2142,  3225,  2144,   317,  2146,  2084,  2387,   456,   457,  2142,
    2125,  2144,   498,  2146,   500,   230,   498,   260,   500,   234,
     498,   498,   500,   500,   410,  2060,   320,  2142,   287,  2144,
    2156,  2146,   472,   456,   457,   473,   474,  2060,  1966,   254,
     255,   104,   456,   457,  2186,   472,  2125,  2156,   256,   282,
    2129,   437,   285,   490,   269,  2524,  2525,  3992,   444,  3994,
    2529,  1995,   498,  2142,   500,   498,   254,   500,   387,   498,
     456,   500,   500,  2108,   497,  2110,   165,  2967,   230,  2338,
     339,  2971,   234,   497,   214,  2108,  2020,  2110,   498,   498,
     305,   500,   497,   175,  3918,   498,  2222,  3409,   114,  2568,
    2569,  3524,   254,   255,   319,  2665,  2666,  3503,  2241,   501,
     498,   497,   500,  2222,   490,   175,  2249,   269,  2251,   503,
     363,  2156,   503,  3013,   367,   412,  2241,   414,  2254,   248,
     373,   319,  2060,  2156,  2249,  2069,  2251,   380,   227,    88,
     412,   498,   414,   500,   387,  2254,   379,   498,   419,   500,
     302,   419,   395,   305,   498,  2297,   500,  2156,   419,   498,
     403,   500,  2241,  2305,   246,   456,   457,   319,    71,   428,
    2249,   120,  2251,   498,   419,   500,   391,   498,   419,   500,
    2108,   497,  2110,  2156,   133,   140,   246,  2222,  1311,  1312,
    2571,   140,   498,   282,   500,   144,   285,  2667,  2668,  2222,
     103,   498,   498,   500,   500,   108,  2321,   193,   451,  2351,
    1078,  1079,   455,   456,   498,   164,   500,  4041,   498,  2254,
     500,   303,   304,  2222,   498,   498,   500,   500,  2156,    98,
     114,  2254,  2374,  3645,     2,   439,   185,   470,   498,   391,
     500,   498,   254,   500,   304,   498,   498,   500,   500,  2222,
     248,   498,  2387,   500,   498,  2254,   500,  2440,   419,  2612,
    2613,   497,   499,   218,   497,  1030,   481,  1032,   217,   484,
     485,   486,   459,   488,   489,   490,   491,   492,   493,   497,
     497,  2254,   237,   499,  2426,  2219,   317,   210,   237,   175,
     379,   501,   195,   481,  2222,   268,   484,   485,   486,   381,
     488,   489,   490,   491,   492,   493,  2549,   498,  3247,   500,
      78,  2554,   261,   498,   317,   500,    84,   498,   273,   500,
     498,   381,   500,   498,   439,   500,  2254,   230,   410,   481,
     317,   234,   484,   485,   486,   497,   488,   489,   490,   491,
     492,   493,   311,   378,   488,   489,   490,   491,   492,   117,
     410,   254,   255,  3776,   498,   437,   498,   498,   500,   500,
     246,   151,   444,   498,   260,   500,   269,   322,   126,   498,
     319,   500,   456,   498,   456,   500,  4109,   437,   498,   497,
     500,   470,    98,   151,   444,   498,   885,   500,   459,   196,
     889,   498,   160,   500,  3640,   497,   456,   346,  3559,   206,
     899,  2335,   305,   210,   498,   498,   500,   500,   497,   104,
     104,  3807,   182,   428,   184,   497,   319,   498,   498,   500,
     500,   370,   182,  2549,   184,   374,   216,   376,  2554,   498,
     498,   500,   500,   382,   204,  2369,  2571,   497,   330,   207,
    2549,   210,  2376,   250,   204,  2554,   214,   260,   216,  3861,
    2585,   502,   242,  2387,   498,  1789,   500,   412,   439,   414,
     228,   410,   411,   270,  1798,   319,   415,   257,   423,  2604,
     200,   200,  1806,  1807,   423,   497,   200,   267,   433,   428,
     459,   200,  2617,   488,   489,   490,   491,   492,   391,   200,
    1824,   496,   498,  2635,   500,   381,   500,   200,    71,   110,
     290,   450,  2635,   498,   498,   500,   500,   314,  2972,   200,
    2974,   200,   317,   200,  2549,  2630,   323,    71,  2633,  2554,
    2635,   200,    95,   200,   410,   317,  2549,   317,   200,  3952,
    3420,  2554,   302,   200,   497,  3425,    98,   307,  3428,   497,
     211,   152,   312,   268,   210,   210,   497,   307,   339,   103,
    2549,   437,   312,   497,   108,  2554,  2635,   497,   444,   497,
    3956,   497,  3985,   497,   497,   176,  3989,  3990,   497,   497,
     456,   497,   497,   497,   327,   497,  2549,   497,   481,   369,
     497,  2554,   497,   497,   195,   488,   489,   490,   491,   492,
     493,   497,   497,   497,   362,  3562,   497,   497,  3067,   497,
     211,  3070,  3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,
    3079,   497,   497,   116,   225,   497,    98,   500,  3986,   153,
     268,  2549,   254,  3562,  3691,   432,  2554,   481,   396,  3987,
     484,   485,   486,    98,   488,   489,   490,   491,   492,   493,
     210,   195,   210,   146,   490,   248,   379,  2923,   285,   439,
     500,   169,   438,    37,   484,   425,  2798,   500,  3127,  3128,
      14,  2904,   500,   497,   434,   425,   497,   419,   497,   419,
    4066,   499,   419,   419,   434,   419,   230,  2611,  2820,   317,
     234,   254,   380,  2617,  2960,  2957,  2801,   419,  2814,  2815,
    2816,   498,   419,   307,   133,   438,   307,   419,   317,   202,
     254,   255,   239,   497,   315,  2814,  2815,  2816,   439,  2851,
     419,   419,  2854,  2855,   115,   269,  2858,   500,   439,   419,
     330,   114,   419,   419,   114,  2059,  2868,   419,  2924,   232,
    2664,  2873,   497,   419,   321,  2877,   419,   348,   419,   419,
     376,  2883,   317,  2939,  2877,  1244,   319,   254,   317,   419,
     419,   305,   456,    98,  3135,   419,   497,   447,   497,   497,
      97,   162,  2877,  2905,  2960,   319,    87,  2882,  2883,    98,
     170,   439,  2905,   210,   450,   116,  2918,   276,  2904,  2814,
    2815,  2816,   317,   497,  3137,  3138,  3139,  3140,   449,  2924,
    2905,  2814,  2815,  2816,    98,  2904,  3906,   499,  2877,  1298,
     377,   453,  4170,  3972,  2939,   146,  2948,  2949,  3972,   200,
    1309,   439,   200,   439,   200,  2814,  2815,  2816,   200,    14,
     419,   444,  1321,   366,  3020,  2960,  2905,   500,   306,   417,
     215,   452,  2967,  3723,   497,   236,  2971,   391,   472,   287,
     287,  2814,  2815,  2816,    71,   500,   387,   497,   497,   215,
     618,   417,   419,   500,   484,   500,  3746,  3100,   421,   498,
     363,   202,   365,   228,   367,   228,   484,   250,   318,  2904,
     373,   500,   312,   270,  3841,    34,   498,   380,   498,    10,
     281,  2904,   283,  3352,   387,  3020,  2814,  2815,  2816,   498,
     419,   232,   395,   294,   419,   376,   139,   497,  3837,   258,
     403,   258,  3841,   497,   307,  2904,   317,   324,   481,   307,
     315,   484,   485,   486,   500,   488,   489,   490,   491,   492,
     493,   419,   384,   359,   359,   359,   307,   481,   329,   419,
     419,  2904,  4149,   196,   488,   489,   490,   491,   492,   493,
     350,   254,    98,   206,   254,   254,   439,   210,   451,   254,
    3840,   439,   254,   315,   793,    97,   795,  3260,   484,   495,
     419,   419,   495,   364,   210,   484,   497,   212,   384,  3111,
      98,   810,   223,   199,  3100,   317,  2904,   491,   226,  1478,
     210,  3871,  2916,   500,   226,   497,    98,   250,  4205,   330,
     200,  3100,  2926,   317,   833,   317,   397,   384,   210,   459,
    3135,   410,    86,  3246,  4071,  3248,   500,   270,  2942,   220,
     849,  3153,   284,  4230,   317,   500,   784,   114,   359,   498,
     788,   498,   363,   498,   792,   215,   367,   498,  3918,   797,
     498,   498,   373,  2967,   498,   498,   215,  2971,    14,   380,
     472,   498,   472,   498,   500,   498,   387,  1933,   497,  3518,
    3519,   314,   498,   498,   395,   498,   498,   453,   419,   827,
     323,  2995,   403,   206,  2998,  3100,   497,   326,   501,   498,
    2404,  3005,    85,   500,   498,   500,   484,  3100,    91,  3013,
     498,   270,   497,   497,  2418,  2419,   442,  3202,  2422,   419,
     244,   307,   270,   334,  2428,   334,   436,   279,   279,   419,
    3034,  3100,   870,   279,   419,  3247,   254,  1993,   419,   877,
     451,   419,   419,   419,  3247,   254,   884,   130,   419,  3261,
    3246,   419,  3248,   495,   254,   254,  3268,  3100,  3270,   254,
    4020,   254,  3247,   254,   498,   285,   904,  3246,   498,  3248,
      85,   484,   428,   270,   321,  3260,    91,   361,   163,  3275,
     497,  4041,  3294,  2487,   498,   315,   317,   419,  3300,  3301,
    3302,  3303,  3304,  3305,   500,   439,  3275,   180,  3247,   432,
     317,   498,  3100,   325,   187,   257,   257,   190,   497,   497,
     312,  3260,   439,   439,   320,   130,   500,   198,   198,  3322,
     193,   215,  3334,    71,   210,    71,   495,   449,   498,   124,
     497,  3343,  3344,  3345,  3346,   498,  3321,  3322,  3142,  3143,
     498,  3246,   980,  3248,   215,  3330,   498,   222,   986,  3334,
     500,   498,   990,  3246,   484,  3248,   239,   103,  3343,   484,
     497,   318,   108,   419,   484,   180,   244,   428,   210,   419,
    3275,   428,   187,  1011,  4134,   190,   419,  3246,   419,  3248,
     254,  1019,  3275,  3395,   498,   254,   258,   456,   498,    98,
     498,   498,   496,  3566,   497,   497,   459,   210,   456,  3572,
     240,   135,   456,  3246,   411,  3248,  3275,   497,   500,  1118,
    1119,   294,   497,  3586,   481,  3420,   257,   219,   497,   497,
    3425,   498,   384,  3428,   239,   497,   215,   498,   215,   497,
    1799,   454,  3275,  3772,   498,   454,   498,   114,   224,  1808,
     428,   307,   307,   200,   484,   500,   254,   330,  3246,   195,
    3248,  1820,   177,   307,   172,   500,   500,  3796,  3797,  4219,
      72,    73,   241,   496,    76,    77,    78,    79,    80,  1178,
     217,   215,   188,   439,   439,   199,   359,  3275,   259,   294,
     363,   419,   498,   497,   230,  1194,  1195,   215,   234,   497,
     210,   320,   497,  1862,  3667,   443,  1865,  1866,   215,   396,
    1869,   497,   455,  1212,   387,   497,   333,   355,   254,   255,
     439,   498,  2716,   498,   498,   330,   497,   497,  1156,   456,
     210,   500,    98,   269,   307,  1163,   280,   237,   347,   163,
     373,  1240,  1241,   126,   373,   320,  3340,   126,   484,   114,
     318,   323,   210,  3555,  3556,   317,  1184,   411,   363,   205,
    2754,  2755,  3555,   320,  3358,   320,  3568,   456,   170,   305,
     481,   443,    98,   353,   500,  3568,  3370,   500,   456,   188,
    3555,    98,   387,   319,   317,   317,  1214,   497,   183,   497,
     372,  3566,   498,  3568,   175,   437,   199,  3572,   372,    84,
      95,   347,   497,   354,  2337,  2635,  2228,  1452,  4107,  2748,
    3246,  3586,  2873,  3857,  3385,  3382,  2207,  3234,  3684,  3594,
    3595,  2712,  3951,  2445,  3599,  3600,  3420,  3566,  4133,  3631,
    3632,  3425,  4169,  3572,  3428,  1263,  1264,  4096,  1266,  3695,
    3642,  3643,  4095,  4141,  3646,  3647,  1274,  3586,  3387,   251,
    1764,  2176,  2940,  3394,  3275,   391,  2815,  3659,  3660,  3661,
    3662,  3663,  1750,    85,  2325,  2917,  4230,  4205,  3653,    91,
    2904,   273,  3652,  1184,  4148,  2876,  3843,  4078,  1741,  1307,
    3846,   186,  1299,  3918,  3659,  3660,  3661,  3662,  3663,  3454,
    3396,    88,  3667,  4041,  2199,  3400,  4048,  4193,  4229,  3701,
    3695,  1329,  3893,  1001,  2069,   163,  1482,  3693,   130,  1276,
     799,  3380,  3021,  2646,  2438,   804,  3449,  1276,  1477,  2655,
    1021,  2102,  2669,   812,  3693,  3727,  3201,  3566,  3667,  1357,
    2087,   820,  2063,   798,  2101,  2617,   825,   802,  1495,  3747,
    2973,  3535,  3536,  3537,  3538,   481,   811,   144,  1010,  2387,
    2647,  3746,   488,   489,   490,   491,   492,   493,   180,   872,
    1388,  1389,  3377,  1391,  3110,   187,  3954,   164,   190,  3102,
    4127,   836,  4128,  4131,  2658,   840,  1404,  2585,  2524,  2525,
    1408,  2496,  2583,  2529,  2464,  1276,   851,  2957,   185,  1780,
    1996,  2985,   618,  2380,  1219,  2989,  1307,  2991,  3693,  2993,
    2994,  2129,  4121,  1507,   363,  1501,  2105,  1079,  3002,  2142,
    3693,   906,  2135,  1099,  2629,   212,  2136,   239,  3205,  1447,
     217,  1306,  2568,  2569,  3817,   222,  3554,  3206,  1425,  1505,
    3180,   395,  1460,  1461,  3693,  3837,  2146,  2441,  1856,  1263,
     237,  3035,  3817,  3433,  3837,  2204,     2,    -1,    -1,   938,
      -1,    -1,  3854,    -1,    -1,    85,  3858,    -1,    -1,  1487,
    3693,    91,  3837,  1491,  1492,   954,    98,    -1,    -1,    -1,
      -1,    -1,   294,    -1,   476,   477,   478,  1505,  1506,  1507,
     482,    -1,    -1,    -1,   116,    -1,   488,   489,    -1,    -1,
    3946,    -1,    -1,    -1,    -1,    -1,   985,    -1,  3837,    -1,
     130,    -1,    -1,    -1,    -1,  3693,    -1,    -1,   330,    -1,
      -1,    -1,    -1,  3915,   146,  1004,    -1,    -1,    -1,    -1,
      -1,    -1,   319,    -1,    -1,  1553,    -1,    -1,    -1,  3723,
      -1,    -1,  1560,    -1,  1562,    -1,    -1,   359,  1566,  1028,
      -1,   363,  1570,    -1,    -1,    -1,    -1,    -1,    -1,   346,
     180,  3946,  3746,  1652,  1653,  1654,  1655,   187,    -1,    -1,
     190,    -1,  1590,    -1,    -1,   387,    -1,    -1,  4209,  1597,
     202,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,   376,
      -1,    -1,    -1,  1682,  1683,   382,    -1,   384,    -1,  1688,
      -1,  1619,    -1,    -1,    -1,  1623,    -1,    -1,    -1,    -1,
     232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   239,
      -1,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   423,  4013,   260,    -1,
      -1,   428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   438,    -1,    -1,  4013,    -1,  3840,    -1,    -1,    -1,
    1678,  1562,    -1,   450,  1753,  1754,  1755,  1756,    -1,    -1,
      -1,    -1,    -1,    -1,   294,    -1,    -1,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4050,    -1,  3871,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1713,  3880,    -1,    -1,    -1,
    2449,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
    1738,  4050,  3906,    -1,    -1,  1743,    -1,    -1,  4013,  1208,
    1209,  1210,    -1,    -1,  3918,    -1,    -1,  1826,    -1,   359,
    4013,   363,    -1,   363,    -1,   367,  3930,    -1,    -1,    -1,
      -1,   373,    -1,    -1,    -1,    -1,    -1,  4149,   380,    -1,
      -1,    -1,    -1,    -1,  4013,   387,  4149,   387,  1786,    -1,
    1788,    -1,    -1,   395,    -1,    -1,  1794,  1678,    -1,  1797,
      -1,   403,    -1,    -1,  4149,    -1,    -1,    -1,    -1,    -1,
    4013,    -1,    -1,    -1,  1695,  3979,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4193,    -1,
      -1,  1829,    -1,  4205,  1832,    -1,    -1,    -1,  1297,    -1,
      -1,    -1,  4205,    -1,  4209,    -1,    -1,    -1,    -1,   451,
      71,    -1,    -1,   455,    -1,  4013,  4020,  1738,  4230,    -1,
    4205,  1320,    -1,    -1,  4229,    -1,  1864,  4230,    -1,    -1,
      -1,    -1,  3436,    -1,    95,    -1,    -1,  4041,    -1,  3443,
    3444,    -1,   103,    -1,    -1,  4230,    -1,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1899,  1900,    -1,    -1,    -1,    -1,    -1,    -1,  1907,
      -1,    -1,  1910,  1794,    -1,  1913,    -1,    -1,    -1,    -1,
    1918,    -1,    -1,  1921,  1922,    -1,    -1,    -1,    -1,    -1,
      -1,  1929,    -1,    -1,  1932,  1933,  1934,  1935,    -1,    -1,
      -1,    -1,    -1,    -1,  1942,  1943,    -1,  1945,    -1,  1947,
      -1,  3067,  1950,    -1,  3070,  3071,  3072,  3073,  3074,  3075,
    3076,  3077,  3078,  3079,    -1,    -1,  1964,  1965,  1966,    -1,
    4134,  1969,    -1,    71,    -1,  1973,    -1,    -1,    -1,  1977,
      -1,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1988,    -1,  1990,    -1,    -1,    -1,    -1,    -1,  1996,  1458,
      -1,    -1,  2000,    -1,    -1,   103,    71,    -1,    -1,   230,
     108,  3127,  3128,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,   254,   255,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,  2783,  4219,    -1,    -1,    -1,    -1,
      -1,    -1,  2060,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2799,    -1,    -1,  2071,  2803,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,  1964,   305,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,   195,   319,    -1,
      -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2108,    -1,  2110,    -1,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2144,    -1,  2146,    -1,
    1609,    -1,    -1,    -1,    -1,    -1,   254,   255,  2156,    -1,
      -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
     391,   269,    -1,    -1,    -1,  2173,    -1,    -1,  2247,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   254,
     255,  3755,    -1,  3757,  3758,  2193,    98,  1656,    -1,    -1,
    2198,  2199,  3766,    -1,   269,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,  1676,    -1,    -1,
      -1,   319,  2291,    -1,  2222,  1660,    -1,    -1,    -1,  2298,
    2299,  2300,  2301,  2302,  2303,    -1,  3352,   302,    -1,    -1,
     305,    -1,    -1,    -1,   146,    -1,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,   319,    -1,  2254,   322,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,   254,   255,   496,    -1,    -1,    -1,    -1,
      -1,   502,  3011,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,
     202,    -1,    -1,    -1,  3033,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1747,    -1,    -1,  2313,    -1,  2315,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,   391,  1762,    -1,    -1,
     232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
    2409,   322,  2411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,
    1819,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2377,
      -1,    -1,    -1,   481,    -1,  3949,  1821,    -1,    -1,  2387,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,  2397,
      -1,    -1,  3518,  3519,    -1,    -1,    -1,    -1,  1867,  1868,
     391,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,  2315,   500,  2434,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,    -1,    -1,    -1,   367,  2464,    -1,    -1,    -1,
      -1,   373,    -1,    -1,    -1,    -1,    -1,  2475,   380,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   395,    -1,    -1,  2494,  2495,    -1,    -1,
     481,   403,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,
      -1,    -1,    -1,    -1,    -1,    -1,  2524,  2525,    -1,    -1,
      -1,  2529,    -1,  3262,  3263,    -1,  1995,    -1,    -1,    -1,
      71,    -1,    -1,  2541,  2542,  2543,  2544,    -1,    -1,   451,
      -1,  2549,    -1,   455,    -1,  2553,  2554,    -1,  2556,    -1,
    2558,  2020,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,
    2568,  2569,   103,  2571,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2584,    -1,  2586,    -1,
      -1,    -1,  2590,    -1,  2475,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2606,    -1,
    2069,    -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,  2617,
      -1,  2619,  2620,  2621,    -1,    -1,    -1,    -1,    -1,    -1,
      85,    -1,    -1,    -1,    -1,    -1,    91,    -1,    95,    -1,
      -1,  2639,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
    2648,   108,    -1,    -1,    -1,    -1,  3772,  2655,    -1,    -1,
     115,    -1,  2660,    -1,    -1,    -1,    -1,    -1,    -1,  2667,
    2668,  2669,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,
    3796,  3797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,  2711,    -1,    -1,    -1,    -1,  2153,    -1,
      -1,    -1,  2157,   254,   255,   180,    -1,    -1,    -1,    -1,
      -1,    -1,   187,    -1,    -1,   190,    -1,  2172,   269,  2737,
    2738,    -1,  2740,    -1,    -1,  2180,    -1,    -1,    -1,  2747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2219,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2203,    -1,
      -1,   302,    -1,   230,   305,    -1,    -1,   234,    -1,    -1,
    2778,   236,  2780,    -1,   239,  2220,    -1,    -1,   319,    -1,
      -1,   322,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,
    2235,    -1,  2237,    -1,    -1,  1184,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,  2814,  2815,  2816,    -1,
    2255,    -1,    -1,    -1,    -1,    -1,   281,  2262,   283,    -1,
      -1,    -1,    -1,    -1,  2269,  3951,    -1,    -1,    -1,   294,
      -1,  2276,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
      -1,    -1,    -1,    -1,  2852,    -1,    -1,    -1,    -1,    -1,
     391,    -1,   319,    -1,    -1,   322,  2747,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,   330,  2335,    -1,  2876,  2877,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3616,  3617,    -1,
    3619,    -1,    -1,    -1,    -1,    -1,    -1,  2778,    -1,  2780,
      -1,    -1,    -1,    -1,   359,    -1,  2904,  2905,   363,   364,
    2369,    -1,    -1,    -1,    -1,    -1,    -1,  2376,    -1,    -1,
      -1,    -1,    -1,  2921,    -1,    -1,    -1,    -1,  1307,    -1,
      -1,    -1,   387,    -1,   391,    -1,    -1,  2935,    -1,    -1,
      -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,  2950,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,   498,    -1,  2967,
      -1,  2852,    -1,  2971,    -1,    -1,    -1,    71,    -1,    -1,
      -1,    -1,    -1,  2981,    -1,    -1,    -1,    -1,  2986,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1184,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
    3739,    -1,    -1,    -1,   108,  3013,    -1,    -1,    -1,    -1,
    3749,    -1,  2457,    -1,   481,    -1,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
    2921,   498,    -1,    -1,    -1,    -1,  3044,    -1,    -1,  3047,
    2485,    -1,    -1,    -1,  2935,  3053,    -1,    -1,    71,    -1,
      -1,  3059,    -1,  3061,    -1,    -1,    -1,    -1,  3066,  3067,
      -1,    -1,  3070,  3071,  3072,  3073,  3074,  3075,  3076,  3077,
    3078,  3079,    95,    -1,    -1,  3083,  3084,    -1,    -1,    -1,
     103,    -1,    -1,  3091,    -1,   108,    -1,    -1,  3096,    -1,
      -1,    -1,  3100,    -1,  3102,  2986,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3112,    -1,    -1,  3115,    -1,  3117,
      -1,    -1,  1307,    -1,    -1,    -1,    -1,  3125,  3126,  3127,
    3128,    -1,    -1,    -1,  3132,    -1,   230,  3135,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,    -1,  3145,    -1,    -1,
      -1,    -1,  2611,    -1,    -1,    -1,  3154,    -1,    -1,    -1,
     254,   255,    -1,    -1,    -1,    -1,  3047,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1562,    -1,  3066,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,  2664,    -1,  3936,   302,    -1,
    3091,   305,    -1,    -1,    -1,    -1,    -1,   230,  1597,    -1,
      -1,   234,    -1,    -1,    -1,   319,    95,    -1,    89,    -1,
      -1,    -1,    -1,    94,   103,    96,    -1,    -1,    -1,   108,
    1619,   254,   255,    -1,  3125,   106,    -1,    -1,  3246,  3247,
    3248,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,    -1,  1447,    -1,    -1,  2700,    -1,  3996,    -1,    -1,
      -1,   132,    -1,    -1,    -1,    -1,    -1,  3275,    -1,    -1,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,
     151,   152,   305,    -1,   155,    -1,    -1,   391,    -1,  1678,
     161,    -1,    -1,    -1,   165,    -1,   319,    -1,   169,   322,
      -1,    -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,    -1,
      -1,    -1,   183,    -1,    -1,   186,    -1,    -1,    -1,    -1,
     191,    -1,    -1,    -1,  1713,    -1,    -1,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,   206,  2781,   208,    -1,    -1,
      -1,   212,    -1,    -1,  3352,    -1,    -1,    -1,    -1,  1738,
      -1,   230,    -1,    -1,    -1,   234,    -1,  3365,   229,    -1,
      -1,    -1,    -1,    -1,   235,    -1,    -1,  1562,   391,    -1,
      -1,    -1,    -1,   147,    -1,   254,   255,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
     269,    -1,  3400,  3401,  3402,    -1,    -1,    -1,    -1,    -1,
      -1,  2846,  1597,    -1,    -1,  1794,    -1,    -1,    -1,    -1,
      -1,    -1,  3420,    -1,    -1,    -1,    -1,  3425,    -1,    -1,
    3428,    -1,   196,   302,  1619,    -1,   305,    -1,    86,    -1,
      -1,    -1,   206,    -1,    -1,    -1,   210,    -1,    -1,    -1,
     319,   215,    -1,   322,    -1,   219,    -1,  2916,   222,    -1,
     224,    -1,    -1,    -1,    -1,    -1,    -1,  2926,   481,  3467,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,  2942,  3365,   498,   250,    -1,    -1,    -1,
      -1,   139,    -1,  1678,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,    -1,    -1,  3503,   270,    -1,    -1,    -1,
    1695,    -1,  3510,  3511,    -1,  3513,    -1,    -1,    -1,    -1,
    3518,  3519,   391,    -1,    -1,  3523,  3524,    -1,  1713,    -1,
      -1,  3529,  3530,    -1,    -1,  3533,  2995,    -1,   399,  2998,
      -1,    -1,    -1,    -1,   192,    -1,  3005,    -1,    -1,  3618,
     314,    -1,    -1,  1738,    -1,  3553,    -1,    -1,    -1,   323,
      -1,    -1,    -1,    -1,    -1,    -1,  3001,    -1,    -1,    -1,
    3568,    -1,    -1,    -1,    -1,  3034,    -1,    -1,    -1,  3014,
      -1,    -1,    -1,    -1,    -1,  1964,   234,    -1,    -1,    -1,
    3588,   239,    -1,    -1,    -1,    -1,    -1,    -1,  3596,    -1,
      -1,  3036,   366,    -1,    -1,    -1,    -1,    -1,    -1,  1794,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,
     278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3524,    -1,    -1,   410,   295,   296,   297,
     298,   299,    -1,   301,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   432,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3142,  3143,  3683,   334,    -1,    -1,   453,
      -1,   455,   456,    -1,    -1,  3693,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3588,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3596,    -1,    -1,    -1,    -1,
      -1,    -1,   370,    -1,    -1,  3723,    -1,    -1,    -1,    -1,
    3728,   495,    -1,    -1,   498,   499,    -1,   501,    -1,    -1,
      -1,    -1,    -1,    -1,  3742,    -1,    -1,    -1,  3746,    -1,
      -1,    -1,    -1,  3751,    -1,    -1,    -1,   618,   406,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3772,    -1,    -1,    -1,  3776,  1964,
      -1,    -1,    -1,   431,    -1,    -1,    -1,    -1,  3223,    -1,
     438,    -1,    -1,   441,    -1,    -1,    -1,    -1,  3796,  3797,
      -1,    -1,  3800,    -1,   665,   666,    -1,    -1,    -1,  3807,
    3808,    -1,    -1,    -1,  2193,    -1,    -1,    -1,   679,  2198,
    2199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3837,
      -1,    -1,  3840,    -1,    -1,    -1,    -1,  3282,  3917,  3284,
      -1,    -1,    -1,  3922,  3923,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3751,    -1,    -1,  3871,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3776,    -1,    -1,    -1,  3358,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3918,  3919,    -1,    -1,  3993,    -1,  3995,  3925,    -1,    -1,
      -1,    -1,   793,   794,   795,    -1,  2315,   798,    -1,   800,
      -1,   802,   803,    -1,   805,    -1,   807,    -1,   809,   810,
     811,    -1,    -1,  3951,  3952,    -1,  3954,    -1,  3956,   820,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   828,    -1,    -1,
     831,    -1,   833,  4042,    -1,   836,    -1,   838,    -1,   840,
     841,   842,   843,    -1,  3982,    -1,   847,  3985,   849,    -1,
     851,  3989,  3990,    -1,    -1,    -1,    -1,    -1,  2377,    -1,
      -1,    -1,    -1,   864,    -1,   866,    -1,    -1,  2193,    -1,
      -1,    -1,    -1,  2198,  2199,  4013,    -1,   878,    -1,  3454,
     881,    -1,  4020,    -1,   885,    -1,   887,    -1,   889,   890,
    4099,    -1,   893,    -1,   895,    -1,   897,    -1,   899,  4108,
      -1,   902,    -1,  4041,    -1,    -1,    -1,    -1,    -1,    -1,
    4048,    -1,  4050,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   924,   925,    -1,    71,    -1,  4066,  4138,
      -1,  3952,    -1,    -1,    -1,    -1,  3535,  3536,  3537,  3538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   950,
      -1,   952,    -1,    -1,   955,    -1,  2475,    -1,   103,    -1,
      -1,    -1,    -1,   108,  3985,    -1,    -1,    -1,  3989,  3990,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   982,    -1,   984,    -1,    -1,    -1,   988,    -1,    -1,
    2315,    -1,    -1,    -1,    -1,    -1,  4134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1015,    -1,    -1,  3592,    -1,    71,
    1021,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3603,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,
     195,   103,  2377,    -1,    -1,    -1,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1076,  1077,    -1,    -1,    71,
      -1,  4219,    -1,    -1,    -1,   230,    -1,    -1,  1089,   234,
    1091,    -1,    -1,    -1,  1095,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,   254,
     255,   103,    -1,    -1,    -1,    -1,   108,  1118,  1119,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1146,    -1,    -1,    -1,    -1,
    2475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1159,    -1,
     305,    -1,    -1,    -1,    -1,  1166,    -1,  1168,    -1,    -1,
      -1,    -1,    -1,  1174,   319,    -1,    -1,  1178,   230,    -1,
      -1,    -1,   234,    -1,  1185,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3767,  1194,  1195,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1212,  1213,    -1,  1215,  1216,    -1,   269,  2737,  2738,
      -1,  2740,    -1,    -1,    -1,    -1,    -1,    -1,  2747,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,  1240,
    1241,    -1,   234,  1244,    -1,    -1,   391,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,  1259,  2778,
      -1,  2780,   254,   255,    -1,    -1,    -1,   319,    -1,    -1,
     322,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,  3880,    -1,    -1,  1285,    -1,    -1,    -1,    -1,    -1,
      -1,  1292,  1293,    -1,    -1,    -1,    -1,  1298,  1299,    -1,
      -1,    -1,    -1,  1304,    -1,    -1,    -1,  3906,  1309,    -1,
     302,    -1,    -1,   305,    -1,    -1,  1317,    -1,    -1,    -1,
    1321,    -1,  1323,    -1,    -1,    -1,    -1,   319,    -1,    -1,
     322,  3930,    -1,  2852,    -1,    -1,   481,    -1,    -1,   391,
      -1,    -1,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,  1184,    -1,    -1,    -1,    -1,    -1,    -1,  2877,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3979,    -1,    -1,    -1,    95,    -1,  2905,    -1,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,   391,
      -1,    -1,  2921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2737,  2738,    -1,  2740,  2935,    -1,    -1,    -1,
      -1,    -1,  2747,    -1,    -1,    -1,    -1,  1428,  1429,   481,
      -1,  2950,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,  1444,    -1,    -1,   498,    -1,    -1,    -1,
    1451,  1452,    -1,  2778,    -1,  2780,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1467,  2986,  1469,    -1,
      -1,    -1,    -1,    -1,  1307,    -1,  1477,  1478,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,  1523,   234,  1525,    -1,    -1,  2852,  3047,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,  3066,    -1,    -1,
      -1,    -1,  2877,    -1,  1555,    -1,    -1,    -1,   269,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
      -1,    -1,  3091,    -1,   108,    -1,    -1,    -1,    -1,  1580,
    2905,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,  2921,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3125,    -1,   319,    -1,
    2935,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1621,    -1,    -1,    -1,    -1,  2950,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1652,  1653,  1654,  1655,    -1,    -1,    -1,    -1,  1660,
      -1,  2986,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1674,    -1,    -1,    -1,    -1,    -1,    -1,
     391,  1682,  1683,    -1,    -1,    -1,    -1,  1688,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     254,   255,  3047,    -1,    -1,    -1,    -1,    -1,  3247,  1562,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,  1739,    -1,
      -1,  3066,    -1,    -1,    -1,    -1,  1747,    -1,    -1,    -1,
    1751,    -1,  1753,  1754,  1755,  1756,    -1,    -1,    -1,    -1,
      -1,  1762,    -1,    -1,  1597,    -1,  3091,  1768,   302,  1770,
     481,   305,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,   319,  1619,   498,   322,    -1,
      -1,    -1,    -1,    -1,  1795,  1796,    -1,    -1,  1799,  1800,
    3125,    -1,    -1,    -1,  1805,    -1,    -1,  1808,  1809,    -1,
    1811,    -1,  1813,    -1,    -1,    -1,    -1,  1818,    -1,  1820,
    1821,    -1,    -1,    -1,  1825,  1826,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1840,
    1841,    -1,    -1,    -1,    -1,  1678,  3365,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1857,   391,    -1,    -1,
      -1,  1862,  1695,    -1,  1865,  1866,    71,    -1,  1869,    -1,
      -1,    -1,    -1,    -1,  1875,    -1,    -1,    -1,    -1,    -1,
    1713,  3400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,  1893,  1894,    -1,    -1,  1897,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,  1738,    -1,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1931,    -1,    -1,    -1,    -1,    -1,    71,    -1,    -1,   103,
      -1,    -1,    -1,    -1,   108,    -1,    -1,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      95,  1794,    -1,    -1,   498,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3513,    -1,    -1,    -1,    -1,   117,
      -1,  2002,    -1,    -1,    -1,  3524,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3365,    -1,   160,    -1,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2062,    -1,    -1,   269,    -1,   230,    -1,    -1,  3588,
     234,    -1,    -1,    -1,    -1,  3400,    -1,  3596,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   207,
     254,   255,    -1,    -1,    -1,   230,   214,   302,   216,   234,
     305,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,
     228,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2129,    -1,
      -1,  1964,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,
    2141,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2153,  2154,    -1,   319,  2157,  2158,  2159,    -1,
      -1,    -1,  2163,    -1,    -1,    -1,    -1,   302,  2169,    -1,
     305,  2172,    -1,    -1,  2175,    -1,    -1,    -1,    -1,  2180,
    2181,    -1,    -1,    -1,   319,  2186,   391,   322,  3513,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3524,
      -1,    -1,  2203,  2204,    -1,    -1,  2207,  2208,  2209,  2210,
    2211,  2212,  2213,    -1,    -1,  2216,  2217,    -1,    -1,  2220,
    2221,    -1,    -1,  2224,    -1,    -1,    -1,   391,  2229,  2230,
      -1,    -1,  3751,    -1,  2235,    -1,  2237,  2238,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2247,  2248,    -1,  2250,
      -1,    -1,    -1,    -1,  2255,    -1,   391,  3776,  2259,  2260,
    2261,  2262,  2263,  3588,    -1,    -1,    -1,    -1,  2269,  2270,
    2271,  3596,    -1,    -1,    -1,  2276,   481,  2278,  2279,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
    2291,    -1,    -1,   498,    -1,    -1,    -1,  2298,  2299,  2300,
    2301,  2302,  2303,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,   481,  3837,    -1,
      -1,    -1,    -1,    -1,   488,   489,   490,   491,   492,   493,
    2331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2339,    95,
      -1,    -1,    -1,    -1,    -1,    -1,   481,   103,    -1,   484,
     485,   486,   108,   488,   489,   490,   491,   492,   493,    -1,
    2193,    -1,  2363,   498,    -1,  2198,  2199,    -1,    -1,  2370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,    -1,
      -1,  2392,  2393,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3925,    -1,  2409,  2410,
    2411,  2412,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    -1,    -1,  2426,  3751,    -1,    -1,    -1,
     103,    -1,    -1,  3952,    -1,   108,    -1,    -1,    -1,  2440,
      -1,    -1,    -1,    -1,  2445,    -1,    -1,    -1,  2449,    -1,
      -1,  3776,    -1,    -1,    -1,    -1,  2457,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3985,    -1,    -1,    -1,
    3989,  3990,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,
    2481,    -1,  2315,    -1,  2485,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   254,   255,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,
      -1,    -1,  3837,   269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,  2377,    -1,   302,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,  2559,    -1,
      -1,   234,    -1,   319,    -1,   144,   322,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   254,   255,    -1,    -1,   164,    -1,  2588,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
    3925,    -1,    -1,    -1,    -1,    -1,   185,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3952,    -1,   302,
      -1,    -1,   305,   212,  2635,   391,    -1,    -1,   217,    -1,
      -1,    -1,  2475,   222,    -1,  2646,   319,    -1,    -1,   322,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
    3985,    -1,    -1,    -1,  3989,  3990,   784,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   792,    -1,    -1,    -1,    -1,   797,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2700,
    2701,  2702,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,
      -1,    -1,    -1,    -1,  2715,    -1,    -1,    -1,   391,    -1,
      -1,    -1,    -1,  2724,    -1,   481,    -1,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
     319,    -1,   498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,    71,    -1,  2756,  2757,  2758,  2759,   877,
      -1,    -1,    -1,    -1,    -1,    -1,   884,   346,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
    2781,    -1,  2783,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,   370,    -1,    -1,    -1,   374,    -1,   376,  2799,    -1,
      -1,    -1,  2803,   382,    -1,   384,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,  2842,    -1,    -1,   423,  2846,  2847,    -1,    -1,   428,
      -1,    -1,    -1,    -1,    -1,  2856,  2857,    -1,    -1,   438,
      -1,    -1,   980,    -1,    -1,    -1,    -1,    -1,   986,    -1,
      -1,   450,   990,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    72,    -1,    -1,    -1,    -1,    -1,
      -1,  1019,    80,    -1,  2737,  2738,    -1,  2740,    -1,    -1,
      -1,    -1,   230,    -1,  2747,    -1,   234,    95,    -1,    -1,
      98,  2922,  2923,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,  2940,
      -1,    -1,    -1,    -1,    -1,  2778,    -1,  2780,  2949,    -1,
      -1,   269,    -1,    -1,    -1,    -1,  2957,    -1,    -1,  2960,
    2961,    -1,    -1,  2964,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2977,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,  2987,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3000,
    3001,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
    3011,    -1,    -1,  3014,    -1,    -1,    -1,    -1,    -1,  2852,
    3021,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3033,    -1,    -1,  3036,    -1,    -1,  1156,    -1,
      -1,    -1,    -1,    -1,  2877,  1163,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,    -1,
      -1,    71,  2905,   391,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2921,    -1,
      -1,   269,    -1,    -1,    -1,    95,  1214,    -1,    -1,    -1,
      -1,    -1,  2935,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2950,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
    3151,    -1,    -1,  2986,    -1,    -1,  1274,    -1,    -1,    -1,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,   496,    -1,
      -1,  3182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1307,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     210,  1329,    -1,   391,  3047,   215,    -1,  3218,  3219,    -1,
      71,    -1,  3223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     230,    -1,    -1,  3066,   234,    -1,    -1,    -1,    -1,  1357,
      -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,    -1,   254,   255,    -1,   108,  3091,    -1,
      -1,  3262,  3263,    -1,    -1,    -1,    -1,    -1,    -1,   269,
    1388,  1389,    -1,  1391,    -1,    -1,    -1,  3278,    -1,    -1,
      -1,  3282,  3283,  3284,  3285,  3286,  3287,  3288,    -1,    -1,
    1408,    -1,  3125,    -1,    -1,    -1,    -1,    -1,   476,    -1,
      -1,    -1,   302,   481,    -1,   305,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,    -1,   178,    -1,    -1,
      -1,    -1,    -1,  3334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1460,  1461,    -1,    -1,  3347,  3348,  3349,    -1,
    3351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1487,
      -1,    -1,    -1,  1491,  1492,    -1,  3377,    -1,    -1,   230,
      -1,  3382,    -1,   234,  3385,    -1,  3387,    -1,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,  3397,    -1,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3247,  3416,    -1,  3418,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3429,    -1,
    3431,    -1,  3433,    -1,    -1,    -1,    -1,  3438,    -1,  3440,
      -1,    -1,    -1,    -1,  1562,   147,    -1,    -1,  1566,    -1,
      -1,   302,  1570,  3454,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,   322,  1590,    -1,    -1,    -1,    -1,    -1,    -1,  1597,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,   196,    -1,    -1,    -1,    -1,    -1,
      -1,  1619,    -1,    -1,   206,  1623,    -1,    -1,   210,    -1,
      -1,    -1,    -1,   215,    -1,    -1,    -1,   219,    -1,    -1,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3365,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,  3548,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1678,  3562,    -1,    -1,    -1,    -1,    -1,  3400,   270,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3587,    -1,   439,    -1,
      -1,  3592,  3593,    -1,    -1,  1713,    -1,    -1,    -1,    -1,
      -1,    -1,  3603,  3604,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   314,    -1,    -1,  3616,  3617,  3618,  3619,    -1,
    1738,   323,    -1,    -1,    -1,  1743,    -1,    -1,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,  3645,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3659,  3660,
    3661,  3662,  3663,    -1,   366,    -1,    -1,    -1,  1786,    -1,
    1788,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,  1797,
    3513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3524,    -1,    -1,    -1,    -1,  3697,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,
      -1,    -1,    -1,    -1,  3715,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     432,    -1,    -1,    -1,    -1,  3736,    -1,    -1,  3739,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1864,    -1,  3749,    -1,
      -1,   453,    -1,   455,   456,  3588,    -1,    -1,    -1,    -1,
    3761,  3762,    -1,  3596,    -1,    -1,  3767,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1899,  1900,    -1,    -1,    -1,    -1,    -1,    -1,  1907,
      -1,    -1,  1910,   495,    -1,  1913,   498,   499,    -1,   501,
      -1,    -1,    -1,  1921,  1922,    -1,    -1,    -1,    -1,    -1,
      -1,  1929,    -1,    -1,  1932,  1933,  1934,  1935,    -1,    -1,
      -1,    -1,    -1,    -1,  1942,  1943,    -1,  1945,    -1,  1947,
      -1,    -1,  1950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3841,    -1,    -1,    -1,    -1,    -1,  1964,  1965,  1966,    -1,
      -1,  1969,    -1,    -1,    -1,  1973,    -1,    -1,    -1,  1977,
    3861,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1988,    -1,  1990,    -1,    -1,    -1,    -1,    -1,  1996,    -1,
      -1,    -1,  2000,    -1,    -1,    -1,     3,    -1,    -1,    -1,
      -1,  3892,     9,  3894,    -1,  3728,    13,    -1,    15,    -1,
      17,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    -1,    -1,    -1,    -1,  3917,  3918,  3751,    -1,
      -1,  3922,  3923,    -1,    -1,    -1,    -1,    -1,    45,    46,
      -1,    -1,    -1,    -1,    -1,  3936,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3776,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,  2071,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,  3969,    -1,
      -1,    -1,    -1,    -1,    91,    95,    93,    94,    -1,    71,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
     107,  3992,  3993,  3994,  3995,  3996,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,  3837,    -1,    98,    -1,    -1,    -1,
     127,   103,   129,   130,    -1,    -1,   108,   134,   135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,
     147,    -1,    -1,    -1,    -1,    -1,   207,    -1,  2156,    -1,
    4041,  4042,    -1,   214,    -1,   216,    -1,   164,    -1,   166,
      -1,    -1,   169,    -1,    -1,  2173,    -1,    -1,   175,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
     187,    -1,    -1,    -1,    -1,  2193,   193,    -1,    -1,    -1,
    2198,  2199,   199,    -1,   201,    -1,    -1,    -1,    -1,   206,
      -1,    -1,  3925,    -1,    -1,    -1,  4097,    -1,  4099,    -1,
      -1,    -1,   219,    -1,  2222,    -1,    -1,  4108,    -1,    -1,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,  3952,
    4121,    -1,    -1,    -1,    -1,    -1,  4127,    -1,    -1,   246,
      -1,    -1,    -1,    -1,   254,   255,  2254,  4138,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,  4149,   269,
      -1,    -1,  3985,    -1,   271,   272,  3989,  3990,    -1,    -1,
     277,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,    -1,   302,    -1,    -1,   305,    -1,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2313,    -1,  2315,    -1,   319,
      -1,    -1,   322,    -1,  4205,    -1,    -1,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,  4048,    -1,    -1,    -1,    -1,
     340,    -1,    -1,    -1,   341,    -1,    -1,   319,    -1,  4230,
     322,    -1,    -1,    -1,    -1,   352,    -1,    -1,    -1,   356,
      -1,   358,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,
      -1,   368,    -1,    -1,   371,    -1,    -1,    -1,   375,  2377,
      -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,  2387,
     387,   391,    -1,   390,    -1,    -1,    -1,    -1,    -1,  2397,
     397,    -1,    -1,    -1,   404,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,    -1,    -1,    -1,    71,    -1,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,
      -1,   428,    -1,    -1,    -1,    -1,  2434,    -1,   435,    -1,
     437,    95,    -1,   440,    -1,    -1,    71,   444,    -1,   103,
      -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,   456,
      -1,    -1,    -1,    -1,    -1,    -1,  2464,    -1,    -1,    -1,
      95,    -1,    -1,    98,    -1,    -1,    -1,  2475,   103,    -1,
      -1,   481,    -1,   108,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,  2494,  2495,    -1,    -1,
     497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,  2524,  2525,    -1,    -1,
      -1,  2529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2541,  2542,  2543,  2544,    -1,    -1,    -1,
      -1,  2549,    -1,    -1,    -1,  2553,  2554,    -1,  2556,    -1,
    2558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2568,  2569,    -1,  2571,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,  2584,    -1,  2586,    -1,
      -1,    -1,  2590,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     254,   255,    -1,    -1,    -1,   230,    -1,    -1,  2606,   234,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,  2617,
      -1,  2619,  2620,  2621,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2639,    -1,    -1,   269,    -1,    -1,    -1,   302,    -1,
    2648,   305,    -1,    -1,    -1,    -1,    -1,  2655,    -1,    -1,
      -1,    -1,  2660,    -1,    -1,   319,    -1,    -1,   322,  2667,
    2668,  2669,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,   335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2711,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,  2737,
    2738,   792,  2740,    -1,    -1,    -1,   797,    -1,    -1,  2747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   827,    71,    -1,    -1,
    2778,    -1,  2780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
      -1,    -1,    -1,    -1,   108,    -1,  2814,  2815,  2816,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   877,   481,    -1,    -1,
     484,   485,   486,   884,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2852,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2877,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2904,  2905,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   215,    -1,  2921,    -1,    -1,    -1,    -1,    -1,   980,
      -1,    -1,    -1,    -1,    -1,   986,   230,  2935,    -1,   990,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     254,   255,    -1,    -1,    -1,    -1,    -1,    -1,  1019,  2967,
      -1,    -1,    -1,  2971,    -1,   269,    -1,    71,    -1,    -1,
      -1,    -1,    -1,  2981,    -1,    -1,    -1,    -1,  2986,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    98,    -1,    -1,    -1,   302,   103,
      -1,   305,    -1,    -1,   108,  3013,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3044,    -1,    -1,  3047,
      -1,    -1,    -1,    -1,    -1,  3053,    -1,    -1,    -1,    -1,
      -1,  3059,    -1,  3061,    -1,    -1,    -1,    -1,  3066,  3067,
      -1,    -1,  3070,  3071,  3072,  3073,  3074,  3075,  3076,  3077,
    3078,  3079,    -1,    -1,    -1,  3083,  3084,    -1,    -1,    -1,
      -1,    -1,    -1,  3091,    -1,    -1,    -1,   391,  3096,    -1,
      -1,    -1,  3100,    -1,  3102,  1156,    -1,    -1,    -1,    -1,
      -1,    -1,  1163,    -1,  3112,    -1,    -1,  3115,    -1,  3117,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3125,  3126,  3127,
    3128,    -1,    -1,  1184,  3132,    -1,   230,  3135,    -1,    -1,
     234,    -1,    -1,    -1,    -1,    -1,    -1,  3145,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3154,    -1,    -1,    -1,
     254,   255,    -1,  1214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,
      -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1274,    -1,   319,    -1,    -1,   322,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3246,  3247,
    3248,    71,    -1,    -1,    -1,    -1,  1307,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,  3275,  1329,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,   391,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,  1388,  1389,    -1,
    1391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3352,    -1,    -1,  1408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,  3400,  3401,  3402,    -1,    -1,    -1,    -1,  1460,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3420,    -1,    -1,    -1,    -1,  3425,    -1,    -1,
    3428,    -1,    -1,    -1,   254,   255,  1487,    -1,    -1,    -1,
    1491,  1492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3467,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,  3503,    -1,    -1,    -1,    -1,
      -1,  1562,  3510,  3511,    -1,  3513,    -1,    -1,    -1,  1570,
    3518,  3519,    -1,    -1,    -1,  3523,  3524,   302,    -1,    -1,
     305,  3529,  3530,    -1,    -1,  3533,    -1,    -1,    -1,  1590,
      -1,    -1,    -1,    -1,   319,    -1,  1597,   322,    -1,    71,
      -1,    -1,    -1,    -1,    -1,  3553,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
      89,   391,  1623,    95,    -1,    94,    -1,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,
    3588,    -1,    -1,    -1,    -1,    -1,   416,    -1,  3596,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,    -1,
      -1,    -1,   151,   152,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   161,    -1,  1695,    -1,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   481,  1713,    -1,   484,   485,   486,   186,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   202,    -1,  3683,    -1,  1738,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3693,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,   230,   484,
     485,   486,   234,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,  3723,    -1,    -1,    -1,    -1,
    3728,    -1,   254,   255,    -1,  1786,    -1,  1788,    -1,    -1,
      -1,    -1,    -1,  1794,  3742,    -1,  1797,   269,  3746,    -1,
      -1,    -1,    -1,  3751,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3772,    -1,    -1,    -1,  3776,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,  3796,  3797,
     322,    -1,  3800,    -1,    -1,    -1,    -1,    -1,    -1,  3807,
    3808,    -1,    -1,  1864,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3837,
      -1,    -1,  3840,    -1,    -1,    -1,    -1,    -1,  1899,  1900,
      -1,    -1,    -1,    -1,    -1,    -1,  1907,    -1,    -1,  1910,
      -1,    -1,  1913,    -1,    -1,    -1,    -1,    -1,    -1,   391,
    1921,  1922,    -1,  3871,    -1,    -1,    -1,    -1,  1929,    -1,
     399,  1932,  1933,  1934,  1935,    -1,    -1,    -1,    -1,    -1,
      -1,  1942,  1943,    -1,  1945,    -1,  1947,    -1,    -1,  1950,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1964,  1965,    -1,    -1,    -1,  1969,    -1,
    3918,  3919,  1973,    -1,    -1,    -1,  1977,  3925,    -1,  1980,
    1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,    -1,  1990,
      -1,    -1,    -1,    -1,    -1,  1996,    -1,    -1,    -1,  2000,
      -1,    -1,    -1,  3951,  3952,    -1,  3954,    -1,  3956,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3982,    -1,    -1,  3985,    -1,    88,
      -1,  3989,  3990,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4013,    -1,    -1,    -1,    -1,
    2071,   120,  4020,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   140,    -1,  4041,    -1,   144,    -1,    -1,    -1,    -1,
    4048,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   106,    -1,    -1,    -1,   164,    -1,    -1,  4066,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,   618,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,    -1,    -1,
     155,    -1,    -1,   212,    -1,    -1,   161,    -1,   217,   218,
     165,    -1,  2173,   222,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4134,    -1,   237,    -1,
      -1,   186,  2193,    -1,    -1,    -1,    -1,  2198,  2199,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   202,    -1,    -1,
     679,   260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,  4219,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2313,    -1,  2315,    -1,    -1,    -1,    -1,    -1,
      -1,   370,    -1,    -1,    -1,   374,    -1,   376,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   384,    -1,    -1,  1184,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   411,   412,    -1,   414,   415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   423,    -1,  2377,    -1,   427,   428,
      -1,    -1,    -1,    -1,   433,    -1,  2387,    -1,    -1,   438,
      -1,    -1,    -1,    -1,   863,   864,  2397,   866,    -1,    -1,
      -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2434,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,   911,    -1,   913,    -1,   915,    -1,    -1,    -1,
      -1,    -1,   921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1307,    -1,  2464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2475,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2494,  2495,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   982,    -1,   984,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2524,  2525,    -1,    -1,    -1,  2529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2541,  2542,  2543,  2544,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2553,    -1,    -1,  2556,    -1,  2558,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2568,  2569,    -1,
    2571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2584,    -1,  2586,    -1,    -1,    -1,  2590,
      -1,    -1,  1061,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2606,    -1,  1076,  1077,    -1,
      -1,  1080,    -1,    -1,    -1,    -1,  2617,    -1,  2619,  2620,
    2621,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2648,    -1,    -1,
      -1,    -1,    -1,    -1,  2655,    -1,    -1,    -1,    -1,  2660,
      -1,    -1,    -1,    -1,    -1,    -1,  2667,  2668,  2669,    -1,
     665,   666,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   679,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2711,    -1,    -1,    -1,    -1,    -1,  1562,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2737,  2738,    -1,  2740,
      -1,    -1,    -1,    -1,    -1,    -1,  2747,    -1,    -1,    -1,
      -1,  1597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1619,    -1,    -1,    -1,  2778,    -1,  2780,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   803,    -1,
     805,    -1,   807,    -1,   809,    -1,    -1,    -1,    -1,  1288,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1678,   828,    -1,    -1,    -1,  1306,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   842,   843,  1695,
      -1,  2852,   847,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1713,    -1,   864,
      -1,   866,    -1,    -1,    -1,    -1,  2877,    -1,    -1,    -1,
      -1,    -1,    -1,   878,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1738,    -1,    -1,   890,    -1,    -1,   893,    -1,
     895,    -1,   897,    -1,  2905,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   924,
     925,    -1,    -1,    -1,  2935,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1794,  2950,
    1419,    -1,    -1,    -1,    -1,   950,    -1,   952,    -1,  1428,
    1429,    -1,    -1,    -1,    -1,    -1,  2967,    -1,    -1,    -1,
    2971,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1447,    -1,
    2981,    -1,  1451,  1452,    -1,  2986,    -1,   982,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3013,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1021,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3044,    -1,    -1,  3047,    -1,    -1,    -1,
      -1,    -1,  3053,    -1,  1523,    -1,  1525,    -1,  3059,    -1,
    3061,    -1,    -1,    -1,  1533,  3066,  3067,    -1,    -1,  3070,
    3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,    -1,
      -1,    -1,  3083,  3084,    -1,    -1,    -1,    -1,    -1,    -1,
    3091,    -1,    -1,    -1,  1089,  3096,  1091,    -1,    -1,    -1,
    1095,  3102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3112,    -1,  1582,  3115,    -1,  3117,    -1,  1964,  1588,
      -1,    -1,    -1,    -1,  3125,  3126,  3127,  3128,    -1,    -1,
      -1,  3132,    -1,    -1,  3135,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3145,    -1,    -1,    -1,    -1,    -1,
      -1,  1146,    -1,  3154,    -1,    -1,    -1,    -1,    -1,  1628,
      -1,    -1,  1631,  1632,  1159,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1168,    -1,    -1,    -1,    -1,    -1,  1174,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1185,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,  1681,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1215,    -1,    -1,    -1,    -1,    -1,    25,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    36,    -1,    -1,
      -1,    -1,    41,    -1,    43,    44,  3247,    -1,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    -1,    74,    -1,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1304,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2193,    -1,    -1,
      -1,  3352,  2198,  2199,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3365,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1856,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   194,    -1,    -1,    -1,  3400,
    3401,  3402,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3420,
      -1,    -1,    -1,    -1,  3425,    -1,    -1,  3428,   227,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3467,    -1,    -1,  2315,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1477,   282,    -1,    -1,   285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3503,    -1,    -1,    -1,    -1,    -1,   307,  3510,
    3511,    -1,  3513,    -1,    -1,    -1,    -1,  3518,  3519,    -1,
      -1,    -1,  3523,  3524,    -1,    -1,  1995,    -1,  3529,  3530,
      -1,  2377,  3533,  2002,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2011,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3553,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,    -1,    -1,    -1,    -1,  1580,    -1,  3588,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3596,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2084,    -1,    -1,    -1,    -1,
     419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2475,
      -1,    -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2125,    -1,    -1,    -1,
    2129,    -1,    -1,    -1,  2133,    -1,  2135,    -1,    -1,    -1,
      -1,   470,  2141,    -1,    -1,    -1,    -1,   476,   477,   478,
      -1,    -1,  3683,   482,    -1,   484,    -1,    -1,    -1,   488,
     489,   490,   491,   492,    -1,    -1,   495,   496,   497,   498,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3723,    -1,    -1,    -1,    -1,  3728,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3742,    -1,    -1,  1739,  3746,    -1,    -1,    -1,    -1,
    3751,    -1,    -1,    -1,    -1,    -1,  1751,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3772,  2241,    -1,    -1,  3776,    -1,    -1,    -1,    -1,
    2249,    -1,  2251,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3796,  3797,    -1,    -1,  3800,
      -1,  1796,    -1,    -1,    -1,  1800,  3807,  3808,    -1,    -1,
      -1,    -1,    -1,    -1,  1809,    -1,  1811,    -1,  1813,    -1,
      -1,    -1,    -1,  1818,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3837,    -1,    -1,  3840,
      -1,    -1,    -1,    -1,    -1,  1840,  1841,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   792,    -1,    -1,
    3871,    -1,   797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2737,  2738,    -1,  2740,    -1,    -1,    -1,    -1,    -1,
      -1,  2747,   827,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3918,  3919,    -1,
      -1,    -1,    -1,    -1,  3925,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2778,    -1,  2780,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3951,  3952,   877,  3954,    -1,  3956,    -1,    -1,    -1,   884,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2440,  2441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3982,    -1,    -1,  3985,    -1,    -1,    -1,  3989,  3990,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2852,  2002,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4020,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2877,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4041,    -1,    -1,    -1,    -1,    -1,    -1,  4048,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   980,    -1,    -1,    -1,  2905,
      -1,    -1,    -1,    -1,    -1,  4066,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2921,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2935,
      -1,    -1,    -1,    -1,  1019,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2950,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4134,    -1,    -1,    -1,    -1,    -1,    -1,
    2986,    -1,    -1,    -1,    -1,    -1,  2141,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2154,
      -1,  2630,    -1,    -1,  2159,    -1,  2635,    -1,  2163,    -1,
      -1,    -1,    -1,    -1,  2169,    -1,    -1,    -1,    -1,    -1,
    2175,    -1,    -1,    -1,    -1,    -1,  2181,    -1,    -1,    -1,
      -1,  2186,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3047,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2209,  2210,  2211,  2212,  4219,    -1,
    3066,  2216,  2217,    -1,    -1,    -1,  2221,    -1,    -1,  2224,
      -1,  1156,    -1,   980,    -1,    -1,    -1,    -1,  1163,    -1,
      -1,    -1,    -1,  2238,    -1,  3091,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2248,    -1,  2250,    -1,    -1,    -1,  1184,
      -1,    -1,    -1,    -1,  2259,  2260,  2261,    -1,  2263,    -1,
      -1,    -1,  1019,    -1,    -1,  2270,  2271,    -1,    -1,  3125,
      -1,    -1,    -1,  2278,  2279,    -1,    -1,    -1,    -1,  1214,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1184,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3247,    -1,    -1,  1329,    -1,    -1,    -1,  2877,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1357,    -1,    -1,    -1,  2905,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2440,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1307,  2923,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1388,  1389,    -1,  1391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1408,    -1,    -1,  2481,    -1,    -1,    -1,
      -1,  2960,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3365,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1460,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1487,    -1,    -1,    -1,  1491,  1492,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1562,    -1,    -1,
      -1,  1388,  1389,    -1,  1391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1408,    -1,    -1,    -1,    -1,    -1,  3513,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,    -1,    -1,    -1,  3524,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1619,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2701,  2702,  1562,    -1,
      -1,    -1,    -1,  1460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2724,
      -1,    -1,    -1,    -1,    -1,    -1,  3205,    -1,    -1,    -1,
    1487,    -1,  3588,  1597,  1491,  1492,    -1,    -1,    -1,    -1,
    3596,    -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2756,  2757,  2758,  2759,  1619,    -1,    -1,    -1,    -1,
    1695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3247,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1713,    -1,
      -1,  3260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1738,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1695,    -1,    -1,    -1,    -1,    -1,  2842,    -1,    -1,
      -1,    -1,  2847,    -1,    -1,    -1,    -1,    -1,    -1,  1713,
      -1,  1786,    -1,  1788,    -1,    -1,    -1,    -1,    -1,  1794,
      -1,    -1,  1797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1738,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3751,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,  2923,    -1,
    3776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1864,
    1794,    -1,    -1,    -1,    -1,  2940,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2960,    -1,    -1,    -1,    -1,
      -1,    -1,  1184,    -1,  1899,  1900,    -1,    -1,    -1,    -1,
      -1,    -1,  1907,    -1,    -1,  1910,    -1,    -1,  1913,    -1,
      -1,  3837,  2987,    -1,    -1,    -1,  1921,  1922,    -1,    -1,
      -1,    -1,    -1,    -1,  1929,  3000,    -1,  1932,  1933,  1934,
    1935,    -1,    -1,    -1,    -1,    -1,    -1,  1942,  1943,    -1,
    1945,    -1,  1947,    -1,    -1,  1950,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1964,
    1965,    -1,    -1,    -1,  1969,    -1,    -1,    -1,  1973,    -1,
      -1,    -1,  1977,    -1,    -1,  1980,  1981,  1982,  1983,  1984,
    1985,  1986,  1987,  1988,    -1,  1990,    -1,    -1,    -1,    -1,
      -1,  1996,    -1,    -1,    -1,  2000,    -1,    -1,    -1,  3925,
      -1,    -1,    -1,    -1,    -1,    -1,  3555,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1307,    -1,  3566,    -1,    -1,
      -1,    -1,    -1,  3572,    -1,    -1,  3952,    -1,    -1,    -1,
    1964,    -1,    -1,    -1,    -1,    -1,    -1,  3586,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3985,
      -1,    -1,    -1,  3989,  3990,    -1,  2071,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1184,
    1907,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1929,    -1,    -1,  1932,    -1,    -1,  1935,    -1,
      -1,    -1,    -1,    -1,    -1,  1942,  1943,    -1,  3667,    -1,
    1947,    -1,    -1,  1950,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,    -1,
      -1,    -1,  1969,    -1,    -1,    -1,  1973,    -1,    -1,    -1,
    1977,    -1,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,    -1,  1990,    -1,    -1,    -1,    -1,  2173,  1996,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2193,    -1,
      -1,    -1,    -1,  2198,  2199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1307,  3278,    -1,    -1,    -1,    -1,  3283,    -1,
    3285,  3286,  3287,  3288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2071,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2193,
      -1,    -1,    -1,    -1,  2198,  2199,    -1,    -1,    -1,    -1,
    1562,    -1,  3347,  3348,  3349,    -1,  3351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3837,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1597,    -1,    -1,  2313,    -1,
    2315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3433,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2315,  2387,    -1,    -1,    -1,  1678,    -1,    -1,    -1,
      -1,    -1,  2397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1695,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1713,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2434,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2377,    -1,    -1,  1738,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1562,    -1,  2464,
    1307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2313,    -1,    -1,  2494,
    2495,    -1,  1597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4050,  1794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1619,    -1,    -1,    -1,  3593,  2524,
    2525,    -1,    -1,    -1,  2529,    -1,    -1,    -1,    -1,  3604,
      -1,    -1,    -1,    -1,    -1,    -1,  2541,  2542,  2543,  2544,
      -1,  2475,    -1,    -1,    -1,    -1,    -1,    -1,  2553,    -1,
      -1,  2556,    -1,  2558,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2568,  2569,    -1,  2571,    -1,    -1,    -1,
    2397,    -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,  2584,
      -1,  2586,    -1,    -1,    -1,  2590,    -1,    -1,    -1,    -1,
    1695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2606,    -1,    -1,    -1,    -1,    -1,  2434,  1713,    -1,
      -1,    -1,  2617,    -1,  2619,  2620,  2621,    -1,    -1,    -1,
      -1,    -1,  3697,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1738,  2639,    -1,    -1,  2464,    -1,    -1,
    3715,    -1,    -1,  2648,    -1,    -1,    -1,    -1,    -1,    -1,
    2655,    -1,    -1,    -1,    -1,  2660,    -1,    -1,    -1,    -1,
      -1,    -1,  2667,  2668,  2669,    -1,    -1,    -1,  2495,    -1,
      -1,    -1,  1964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3761,    -1,    -1,  1794,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2541,  1562,  2543,  2544,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2553,    -1,    -1,  2556,
      -1,  2558,  2737,  2738,    -1,  2740,    -1,    -1,    -1,    -1,
      -1,    -1,  2747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1597,    -1,    -1,    -1,    -1,    -1,    -1,  2584,    -1,  2586,
      -1,    -1,    -1,  2590,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1619,  2778,    -1,  2780,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2621,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2737,  2738,    -1,  2740,    -1,    -1,    -1,
      -1,    -1,  2639,  2747,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2648,    -1,    -1,    -1,    -1,    -1,    -1,  2655,    -1,
      -1,  1678,    -1,  2660,    -1,    -1,    -1,    -1,    -1,    -1,
    2667,  2668,  2669,    -1,  2778,    -1,  2780,  2852,  1695,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1964,
      -1,    -1,    -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,
      -1,    -1,  2877,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2711,    -1,    -1,    -1,    -1,    -1,
      -1,  1738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2905,  2193,    -1,    -1,    -1,    -1,  2198,  2199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2921,    -1,  2852,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2877,    -1,  2950,    -1,  1794,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2967,    -1,    -1,    -1,  2971,    -1,    -1,    -1,
      -1,  2905,    -1,    -1,    -1,    -1,  2981,    -1,    -1,    -1,
      -1,  2986,    -1,    -1,    -1,    -1,    -1,  2921,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2935,    -1,    -1,    -1,    -1,    -1,    -1,  3013,    -1,
 