/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     AUTHORIZATION = 369,
     BACKWARD = 370,
     BEFORE = 371,
     BEGIN_P = 372,
     BETWEEN = 373,
     BIGINT = 374,
     BINARY = 375,
     BIT = 376,
     BOOLEAN_P = 377,
     BOTH = 378,
     BY = 379,
     CACHE = 380,
     CALLED = 381,
     CASCADE = 382,
     CASCADED = 383,
     CASE = 384,
     CAST = 385,
     CATALOG_P = 386,
     CHAIN = 387,
     CHAR_P = 388,
     CHARACTER = 389,
     CHARACTERISTICS = 390,
     CHECK = 391,
     CHECKPOINT = 392,
     CLASS = 393,
     CLOSE = 394,
     CLUSTER = 395,
     COALESCE = 396,
     COLLATE = 397,
     COLUMN = 398,
     COMMENT = 399,
     COMMENTS = 400,
     COMMIT = 401,
     COMMITTED = 402,
     CONCURRENTLY = 403,
     CONFIGURATION = 404,
     CONNECTION = 405,
     CONSTRAINT = 406,
     CONSTRAINTS = 407,
     CONTENT_P = 408,
     CONTINUE_P = 409,
     CONVERSION_P = 410,
     COPY = 411,
     COST = 412,
     CREATE = 413,
     CREATEDB = 414,
     CREATEROLE = 415,
     CREATEUSER = 416,
     CROSS = 417,
     CSV = 418,
     CURRENT_P = 419,
     CURRENT_CATALOG = 420,
     CURRENT_DATE = 421,
     CURRENT_ROLE = 422,
     CURRENT_SCHEMA = 423,
     CURRENT_TIME = 424,
     CURRENT_TIMESTAMP = 425,
     CURRENT_USER = 426,
     CURSOR = 427,
     CYCLE = 428,
     DATA_P = 429,
     DATABASE = 430,
     DAY_P = 431,
     DEALLOCATE = 432,
     DEC = 433,
     DECIMAL_P = 434,
     DECLARE = 435,
     DEFAULT = 436,
     DEFAULTS = 437,
     DEFERRABLE = 438,
     DEFERRED = 439,
     DEFINER = 440,
     DELETE_P = 441,
     DELIMITER = 442,
     DELIMITERS = 443,
     DESC = 444,
     DICTIONARY = 445,
     DISABLE_P = 446,
     DISCARD = 447,
     DISTINCT = 448,
     DO = 449,
     DOCUMENT_P = 450,
     DOMAIN_P = 451,
     DOUBLE_P = 452,
     DROP = 453,
     EACH = 454,
     ELSE = 455,
     ENABLE_P = 456,
     ENCODING = 457,
     ENCRYPTED = 458,
     END_P = 459,
     ENUM_P = 460,
     ESCAPE = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LANGUAGE = 528,
     LARGE_P = 529,
     LAST_P = 530,
     LC_COLLATE_P = 531,
     LC_CTYPE_P = 532,
     LEADING = 533,
     LEAST = 534,
     LEFT = 535,
     LEVEL = 536,
     LIKE = 537,
     LIMIT = 538,
     LISTEN = 539,
     LOAD = 540,
     LOCAL = 541,
     LOCALTIME = 542,
     LOCALTIMESTAMP = 543,
     LOCATION = 544,
     LOCK_P = 545,
     LOGIN_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NOCREATEDB = 562,
     NOCREATEROLE = 563,
     NOCREATEUSER = 564,
     NOINHERIT = 565,
     NOLOGIN_P = 566,
     NONE = 567,
     NOSUPERUSER = 568,
     NOT = 569,
     NOTHING = 570,
     NOTIFY = 571,
     NOTNULL = 572,
     NOWAIT = 573,
     NULL_P = 574,
     NULLIF = 575,
     NULLS_P = 576,
     NUMERIC = 577,
     OBJECT_P = 578,
     OF = 579,
     OFF = 580,
     OFFSET = 581,
     OIDS = 582,
     ON = 583,
     ONLY = 584,
     OPERATOR = 585,
     OPTION = 586,
     OPTIONS = 587,
     OR = 588,
     ORDER = 589,
     OUT_P = 590,
     OUTER_P = 591,
     OVER = 592,
     OVERLAPS = 593,
     OVERLAY = 594,
     OWNED = 595,
     OWNER = 596,
     PARSER = 597,
     PARTIAL = 598,
     PARTITION = 599,
     PASSWORD = 600,
     PLACING = 601,
     PLANS = 602,
     POSITION = 603,
     PRECEDING = 604,
     PRECISION = 605,
     PRESERVE = 606,
     PREPARE = 607,
     PREPARED = 608,
     PRIMARY = 609,
     PRIOR = 610,
     PRIVILEGES = 611,
     PROCEDURAL = 612,
     PROCEDURE = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REFERENCES = 621,
     REINDEX = 622,
     RELATIVE_P = 623,
     RELEASE = 624,
     RENAME = 625,
     REPEATABLE = 626,
     REPLACE = 627,
     REPLICA = 628,
     RESET = 629,
     RESTART = 630,
     RESTRICT = 631,
     RETURNING = 632,
     RETURNS = 633,
     REVOKE = 634,
     RIGHT = 635,
     ROLE = 636,
     ROLLBACK = 637,
     ROW = 638,
     ROWS = 639,
     RULE = 640,
     SAVEPOINT = 641,
     SCHEMA = 642,
     SCROLL = 643,
     SEARCH = 644,
     SECOND_P = 645,
     SECURITY = 646,
     SELECT = 647,
     SEQUENCE = 648,
     SEQUENCES = 649,
     SERIALIZABLE = 650,
     SERVER = 651,
     SESSION = 652,
     SESSION_USER = 653,
     SET = 654,
     SETOF = 655,
     SHARE = 656,
     SHOW = 657,
     SIMILAR = 658,
     SIMPLE = 659,
     SMALLINT = 660,
     SOME = 661,
     STABLE = 662,
     STANDALONE_P = 663,
     START = 664,
     STATEMENT = 665,
     STATISTICS = 666,
     STDIN = 667,
     STDOUT = 668,
     STORAGE = 669,
     STRICT_P = 670,
     STRIP_P = 671,
     SUBSTRING = 672,
     SUPERUSER_P = 673,
     SYMMETRIC = 674,
     SYSID = 675,
     SYSTEM_P = 676,
     TABLE = 677,
     TABLES = 678,
     TABLESPACE = 679,
     TEMP = 680,
     TEMPLATE = 681,
     TEMPORARY = 682,
     TEXT_P = 683,
     THEN = 684,
     TIME = 685,
     TIMESTAMP = 686,
     TO = 687,
     TRAILING = 688,
     TRANSACTION = 689,
     TREAT = 690,
     TRIGGER = 691,
     TRIM = 692,
     TRUE_P = 693,
     TRUNCATE = 694,
     TRUSTED = 695,
     TYPE_P = 696,
     UNBOUNDED = 697,
     UNCOMMITTED = 698,
     UNENCRYPTED = 699,
     UNION = 700,
     UNIQUE = 701,
     UNKNOWN = 702,
     UNLISTEN = 703,
     UNTIL = 704,
     UPDATE = 705,
     USER = 706,
     USING = 707,
     VACUUM = 708,
     VALID = 709,
     VALIDATOR = 710,
     VALUE_P = 711,
     VALUES = 712,
     VARCHAR = 713,
     VARIADIC = 714,
     VARYING = 715,
     VERBOSE = 716,
     VERSION_P = 717,
     VIEW = 718,
     VOLATILE = 719,
     WHEN = 720,
     WHERE = 721,
     WHITESPACE_P = 722,
     WINDOW = 723,
     WITH = 724,
     WITHOUT = 725,
     WORK = 726,
     WRAPPER = 727,
     WRITE = 728,
     XML_P = 729,
     XMLATTRIBUTES = 730,
     XMLCONCAT = 731,
     XMLELEMENT = 732,
     XMLFOREST = 733,
     XMLPARSE = 734,
     XMLPI = 735,
     XMLROOT = 736,
     XMLSERIALIZE = 737,
     YEAR_P = 738,
     YES_P = 739,
     ZONE = 740,
     NULLS_FIRST = 741,
     NULLS_LAST = 742,
     WITH_TIME = 743,
     POSTFIXOP = 744,
     UMINUS = 745
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define AUTHORIZATION 369
#define BACKWARD 370
#define BEFORE 371
#define BEGIN_P 372
#define BETWEEN 373
#define BIGINT 374
#define BINARY 375
#define BIT 376
#define BOOLEAN_P 377
#define BOTH 378
#define BY 379
#define CACHE 380
#define CALLED 381
#define CASCADE 382
#define CASCADED 383
#define CASE 384
#define CAST 385
#define CATALOG_P 386
#define CHAIN 387
#define CHAR_P 388
#define CHARACTER 389
#define CHARACTERISTICS 390
#define CHECK 391
#define CHECKPOINT 392
#define CLASS 393
#define CLOSE 394
#define CLUSTER 395
#define COALESCE 396
#define COLLATE 397
#define COLUMN 398
#define COMMENT 399
#define COMMENTS 400
#define COMMIT 401
#define COMMITTED 402
#define CONCURRENTLY 403
#define CONFIGURATION 404
#define CONNECTION 405
#define CONSTRAINT 406
#define CONSTRAINTS 407
#define CONTENT_P 408
#define CONTINUE_P 409
#define CONVERSION_P 410
#define COPY 411
#define COST 412
#define CREATE 413
#define CREATEDB 414
#define CREATEROLE 415
#define CREATEUSER 416
#define CROSS 417
#define CSV 418
#define CURRENT_P 419
#define CURRENT_CATALOG 420
#define CURRENT_DATE 421
#define CURRENT_ROLE 422
#define CURRENT_SCHEMA 423
#define CURRENT_TIME 424
#define CURRENT_TIMESTAMP 425
#define CURRENT_USER 426
#define CURSOR 427
#define CYCLE 428
#define DATA_P 429
#define DATABASE 430
#define DAY_P 431
#define DEALLOCATE 432
#define DEC 433
#define DECIMAL_P 434
#define DECLARE 435
#define DEFAULT 436
#define DEFAULTS 437
#define DEFERRABLE 438
#define DEFERRED 439
#define DEFINER 440
#define DELETE_P 441
#define DELIMITER 442
#define DELIMITERS 443
#define DESC 444
#define DICTIONARY 445
#define DISABLE_P 446
#define DISCARD 447
#define DISTINCT 448
#define DO 449
#define DOCUMENT_P 450
#define DOMAIN_P 451
#define DOUBLE_P 452
#define DROP 453
#define EACH 454
#define ELSE 455
#define ENABLE_P 456
#define ENCODING 457
#define ENCRYPTED 458
#define END_P 459
#define ENUM_P 460
#define ESCAPE 461
#define EXCEPT 462
#define EXCLUDE 463
#define EXCLUDING 464
#define EXCLUSIVE 465
#define EXECUTE 466
#define EXISTS 467
#define EXPLAIN 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LANGUAGE 528
#define LARGE_P 529
#define LAST_P 530
#define LC_COLLATE_P 531
#define LC_CTYPE_P 532
#define LEADING 533
#define LEAST 534
#define LEFT 535
#define LEVEL 536
#define LIKE 537
#define LIMIT 538
#define LISTEN 539
#define LOAD 540
#define LOCAL 541
#define LOCALTIME 542
#define LOCALTIMESTAMP 543
#define LOCATION 544
#define LOCK_P 545
#define LOGIN_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NOCREATEDB 562
#define NOCREATEROLE 563
#define NOCREATEUSER 564
#define NOINHERIT 565
#define NOLOGIN_P 566
#define NONE 567
#define NOSUPERUSER 568
#define NOT 569
#define NOTHING 570
#define NOTIFY 571
#define NOTNULL 572
#define NOWAIT 573
#define NULL_P 574
#define NULLIF 575
#define NULLS_P 576
#define NUMERIC 577
#define OBJECT_P 578
#define OF 579
#define OFF 580
#define OFFSET 581
#define OIDS 582
#define ON 583
#define ONLY 584
#define OPERATOR 585
#define OPTION 586
#define OPTIONS 587
#define OR 588
#define ORDER 589
#define OUT_P 590
#define OUTER_P 591
#define OVER 592
#define OVERLAPS 593
#define OVERLAY 594
#define OWNED 595
#define OWNER 596
#define PARSER 597
#define PARTIAL 598
#define PARTITION 599
#define PASSWORD 600
#define PLACING 601
#define PLANS 602
#define POSITION 603
#define PRECEDING 604
#define PRECISION 605
#define PRESERVE 606
#define PREPARE 607
#define PREPARED 608
#define PRIMARY 609
#define PRIOR 610
#define PRIVILEGES 611
#define PROCEDURAL 612
#define PROCEDURE 613
#define QUOTE 614
#define RANGE 615
#define READ 616
#define REAL 617
#define REASSIGN 618
#define RECHECK 619
#define RECURSIVE 620
#define REFERENCES 621
#define REINDEX 622
#define RELATIVE_P 623
#define RELEASE 624
#define RENAME 625
#define REPEATABLE 626
#define REPLACE 627
#define REPLICA 628
#define RESET 629
#define RESTART 630
#define RESTRICT 631
#define RETURNING 632
#define RETURNS 633
#define REVOKE 634
#define RIGHT 635
#define ROLE 636
#define ROLLBACK 637
#define ROW 638
#define ROWS 639
#define RULE 640
#define SAVEPOINT 641
#define SCHEMA 642
#define SCROLL 643
#define SEARCH 644
#define SECOND_P 645
#define SECURITY 646
#define SELECT 647
#define SEQUENCE 648
#define SEQUENCES 649
#define SERIALIZABLE 650
#define SERVER 651
#define SESSION 652
#define SESSION_USER 653
#define SET 654
#define SETOF 655
#define SHARE 656
#define SHOW 657
#define SIMILAR 658
#define SIMPLE 659
#define SMALLINT 660
#define SOME 661
#define STABLE 662
#define STANDALONE_P 663
#define START 664
#define STATEMENT 665
#define STATISTICS 666
#define STDIN 667
#define STDOUT 668
#define STORAGE 669
#define STRICT_P 670
#define STRIP_P 671
#define SUBSTRING 672
#define SUPERUSER_P 673
#define SYMMETRIC 674
#define SYSID 675
#define SYSTEM_P 676
#define TABLE 677
#define TABLES 678
#define TABLESPACE 679
#define TEMP 680
#define TEMPLATE 681
#define TEMPORARY 682
#define TEXT_P 683
#define THEN 684
#define TIME 685
#define TIMESTAMP 686
#define TO 687
#define TRAILING 688
#define TRANSACTION 689
#define TREAT 690
#define TRIGGER 691
#define TRIM 692
#define TRUE_P 693
#define TRUNCATE 694
#define TRUSTED 695
#define TYPE_P 696
#define UNBOUNDED 697
#define UNCOMMITTED 698
#define UNENCRYPTED 699
#define UNION 700
#define UNIQUE 701
#define UNKNOWN 702
#define UNLISTEN 703
#define UNTIL 704
#define UPDATE 705
#define USER 706
#define USING 707
#define VACUUM 708
#define VALID 709
#define VALIDATOR 710
#define VALUE_P 711
#define VALUES 712
#define VARCHAR 713
#define VARIADIC 714
#define VARYING 715
#define VERBOSE 716
#define VERSION_P 717
#define VIEW 718
#define VOLATILE 719
#define WHEN 720
#define WHERE 721
#define WHITESPACE_P 722
#define WINDOW 723
#define WITH 724
#define WITHOUT 725
#define WORK 726
#define WRAPPER 727
#define WRITE 728
#define XML_P 729
#define XMLATTRIBUTES 730
#define XMLCONCAT 731
#define XMLELEMENT 732
#define XMLFOREST 733
#define XMLPARSE 734
#define XMLPI 735
#define XMLROOT 736
#define XMLSERIALIZE 737
#define YEAR_P 738
#define YES_P 739
#define ZONE 740
#define NULLS_FIRST 741
#define NULLS_LAST 742
#define WITH_TIME 743
#define POSTFIXOP 744
#define UMINUS 745




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = make_str("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 471 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1541 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1565 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   94422

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  510
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  657
/* YYNRULES -- Number of rules. */
#define YYNRULES  2565
/* YYNRULES -- Number of states. */
#define YYNSTATES  4492

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   745

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   497,     2,     2,
     502,   503,   495,   493,   505,   494,   504,   496,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   507,   506,
     490,   489,   491,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   500,     2,   501,   498,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   508,     2,   509,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   492,   499
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   248,   254,   256,   257,   260,
     261,   264,   265,   268,   271,   275,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   297,   299,   301,   303,   307,
     311,   314,   316,   319,   322,   325,   329,   333,   339,   345,
     346,   350,   356,   362,   367,   371,   377,   381,   387,   393,
     400,   402,   404,   408,   414,   421,   426,   428,   429,   432,
     433,   435,   437,   439,   441,   443,   445,   448,   452,   456,
     460,   464,   468,   472,   476,   480,   483,   489,   492,   495,
     498,   501,   505,   509,   513,   515,   519,   521,   525,   527,
     529,   531,   534,   537,   540,   542,   544,   546,   548,   550,
     552,   554,   558,   565,   567,   569,   571,   573,   575,   576,
     578,   580,   583,   587,   592,   596,   599,   602,   604,   608,
     613,   619,   624,   627,   632,   634,   636,   638,   640,   642,
     645,   648,   651,   654,   659,   664,   669,   674,   676,   680,
     683,   687,   692,   699,   706,   713,   719,   725,   732,   739,
     744,   752,   755,   762,   767,   771,   775,   779,   783,   787,
     792,   797,   801,   805,   809,   813,   817,   821,   826,   831,
     835,   838,   842,   846,   850,   853,   856,   860,   863,   865,
     867,   868,   871,   872,   876,   879,   880,   882,   886,   890,
     892,   898,   902,   905,   908,   919,   926,   928,   930,   932,
     934,   936,   938,   942,   945,   946,   948,   950,   954,   958,
     960,   962,   966,   970,   974,   978,   983,   985,   986,   989,
     990,   994,   995,   997,   998,  1000,  1004,  1007,  1009,  1011,
    1013,  1015,  1019,  1020,  1022,  1026,  1028,  1030,  1042,  1053,
    1055,  1057,  1060,  1063,  1066,  1069,  1070,  1072,  1073,  1077,
    1078,  1080,  1084,  1086,  1090,  1092,  1094,  1096,  1098,  1100,
    1104,  1109,  1112,  1113,  1117,  1119,  1121,  1124,  1126,  1130,
    1135,  1140,  1143,  1149,  1151,  1154,  1157,  1160,  1164,  1168,
    1172,  1173,  1175,  1177,  1179,  1181,  1183,  1185,  1189,  1191,
    1197,  1205,  1214,  1224,  1236,  1240,  1241,  1243,  1247,  1249,
    1252,  1255,  1258,  1259,  1261,  1265,  1269,  1276,  1281,  1282,
    1284,  1286,  1289,  1292,  1293,  1297,  1301,  1304,  1306,  1308,
    1311,  1314,  1319,  1320,  1323,  1326,  1329,  1330,  1334,  1339,
    1344,  1345,  1348,  1349,  1354,  1355,  1361,  1365,  1366,  1368,
    1372,  1374,  1377,  1381,  1382,  1388,  1393,  1395,  1396,  1398,
    1401,  1404,  1406,  1409,  1413,  1416,  1419,  1422,  1425,  1429,
    1433,  1435,  1439,  1441,  1442,  1444,  1447,  1449,  1456,  1467,
    1469,  1470,  1472,  1475,  1478,  1479,  1482,  1485,  1487,  1488,
    1494,  1502,  1504,  1505,  1512,  1515,  1516,  1520,  1526,  1534,
    1541,  1550,  1558,  1565,  1572,  1577,  1578,  1580,  1584,  1589,
    1591,  1595,  1597,  1600,  1603,  1606,  1609,  1611,  1613,  1624,
    1627,  1628,  1631,  1634,  1636,  1637,  1642,  1649,  1655,  1660,
    1665,  1674,  1676,  1678,  1680,  1688,  1698,  1707,  1723,  1744,
    1746,  1748,  1750,  1754,  1756,  1758,  1760,  1764,  1766,  1770,
    1771,  1773,  1774,  1776,  1778,  1783,  1784,  1786,  1790,  1791,
    1793,  1795,  1797,  1799,  1801,  1803,  1806,  1807,  1809,  1812,
    1814,  1817,  1818,  1821,  1823,  1826,  1829,  1836,  1845,  1854,
    1859,  1865,  1870,  1875,  1880,  1884,  1892,  1901,  1908,  1915,
    1922,  1929,  1933,  1935,  1939,  1943,  1945,  1947,  1949,  1951,
    1953,  1955,  1959,  1963,  1967,  1969,  1973,  1977,  1979,  1980,
    1982,  1986,  2000,  2002,  2006,  2011,  2017,  2022,  2030,  2033,
    2035,  2036,  2039,  2040,  2042,  2043,  2050,  2059,  2068,  2070,
    2074,  2080,  2086,  2094,  2104,  2112,  2122,  2128,  2135,  2142,
    2147,  2149,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2167,
    2171,  2175,  2179,  2181,  2185,  2187,  2190,  2193,  2197,  2203,
    2206,  2209,  2210,  2217,  2225,  2233,  2241,  2250,  2259,  2266,
    2275,  2285,  2295,  2303,  2314,  2322,  2331,  2340,  2349,  2358,
    2360,  2362,  2364,  2366,  2368,  2370,  2372,  2374,  2376,  2378,
    2380,  2382,  2384,  2386,  2389,  2392,  2396,  2401,  2407,  2412,
    2418,  2422,  2427,  2431,  2436,  2438,  2441,  2445,  2449,  2453,
    2457,  2462,  2467,  2471,  2475,  2480,  2485,  2490,  2495,  2497,
    2499,  2501,  2502,  2510,  2518,  2529,  2531,  2533,  2536,  2541,
    2547,  2549,  2553,  2556,  2559,  2562,  2565,  2567,  2570,  2573,
    2578,  2582,  2585,  2588,  2591,  2595,  2598,  2601,  2607,  2613,
    2619,  2621,  2625,  2627,  2630,  2634,  2635,  2637,  2641,  2644,
    2651,  2658,  2668,  2672,  2673,  2677,  2678,  2684,  2687,  2688,
    2692,  2696,  2700,  2708,  2716,  2727,  2729,  2731,  2733,  2748,
    2750,  2751,  2753,  2754,  2756,  2757,  2760,  2761,  2763,  2767,
    2772,  2777,  2784,  2786,  2789,  2790,  2792,  2794,  2795,  2797,
    2799,  2800,  2810,  2823,  2831,  2834,  2835,  2839,  2842,  2844,
    2848,  2852,  2855,  2857,  2861,  2865,  2869,  2872,  2875,  2877,
    2879,  2881,  2883,  2886,  2888,  2890,  2892,  2894,  2899,  2905,
    2907,  2911,  2915,  2917,  2920,  2925,  2931,  2933,  2935,  2937,
    2939,  2943,  2947,  2950,  2953,  2956,  2959,  2961,  2964,  2967,
    2969,  2971,  2973,  2977,  2980,  2981,  2984,  2986,  2990,  2996,
    2998,  3001,  3003,  3004,  3010,  3018,  3024,  3032,  3038,  3046,
    3050,  3056,  3062,  3068,  3070,  3074,  3077,  3079,  3082,  3084,
    3087,  3099,  3110,  3121,  3124,  3127,  3128,  3138,  3141,  3142,
    3147,  3152,  3157,  3159,  3161,  3163,  3164,  3172,  3179,  3186,
    3193,  3200,  3208,  3218,  3228,  3235,  3242,  3249,  3256,  3263,
    3272,  3281,  3288,  3295,  3302,  3308,  3314,  3323,  3332,  3341,
    3350,  3357,  3359,  3360,  3363,  3364,  3372,  3379,  3386,  3393,
    3400,  3407,  3414,  3422,  3429,  3436,  3443,  3450,  3458,  3466,
    3474,  3484,  3494,  3501,  3508,  3515,  3524,  3533,  3542,  3549,
    3563,  3565,  3567,  3571,  3575,  3577,  3579,  3581,  3583,  3585,
    3587,  3589,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3603,
    3610,  3619,  3623,  3626,  3627,  3630,  3633,  3636,  3639,  3643,
    3647,  3650,  3653,  3656,  3659,  3663,  3666,  3672,  3677,  3681,
    3685,  3689,  3691,  3693,  3694,  3698,  3701,  3704,  3706,  3710,
    3713,  3715,  3716,  3725,  3736,  3740,  3745,  3750,  3751,  3754,
    3760,  3763,  3764,  3768,  3772,  3776,  3780,  3784,  3788,  3792,
    3796,  3800,  3804,  3808,  3812,  3816,  3821,  3825,  3829,  3831,
    3832,  3838,  3845,  3850,  3853,  3854,  3859,  3863,  3869,  3876,
    3881,  3888,  3895,  3901,  3909,  3911,  3912,  3919,  3931,  3943,
    3955,  3969,  3979,  3991,  4002,  4007,  4010,  4016,  4019,  4020,
    4025,  4031,  4037,  4042,  4049,  4051,  4055,  4057,  4059,  4061,
    4063,  4066,  4071,  4073,  4075,  4077,  4078,  4080,  4081,  4083,
    4084,  4088,  4089,  4092,  4097,  4101,  4107,  4109,  4111,  4113,
    4115,  4117,  4119,  4121,  4123,  4127,  4130,  4132,  4134,  4136,
    4138,  4140,  4142,  4143,  4149,  4154,  4158,  4159,  4161,  4163,
    4165,  4167,  4172,  4181,  4185,  4186,  4192,  4194,  4199,  4202,
    4204,  4208,  4211,  4214,  4215,  4222,  4225,  4226,  4232,  4236,
    4237,  4240,  4243,  4246,  4250,  4252,  4256,  4258,  4261,  4263,
    4264,  4272,  4274,  4278,  4280,  4282,  4286,  4292,  4295,  4297,
    4301,  4309,  4311,  4313,  4314,  4318,  4321,  4324,  4327,  4328,
    4331,  4334,  4336,  4338,  4342,  4346,  4348,  4351,  4356,  4361,
    4364,  4368,  4374,  4380,  4382,  4384,  4394,  4396,  4399,  4404,
    4409,  4414,  4417,  4421,  4423,  4427,  4432,  4435,  4437,  4438,
    4442,  4446,  4451,  4456,  4461,  4466,  4469,  4471,  4473,  4474,
    4476,  4478,  4479,  4481,  4487,  4489,  4490,  4492,  4493,  4497,
    4499,  4503,  4508,  4512,  4515,  4518,  4520,  4522,  4524,  4525,
    4528,  4533,  4539,  4542,  4546,  4548,  4550,  4552,  4554,  4558,
    4559,  4561,  4563,  4565,  4567,  4569,  4573,  4574,  4577,  4578,
    4580,  4584,  4586,  4587,  4589,  4592,  4597,  4602,  4605,  4606,
    4609,  4613,  4616,  4617,  4619,  4623,  4625,  4628,  4630,  4633,
    4639,  4646,  4652,  4654,  4657,  4659,  4664,  4668,  4673,  4679,
    4684,  4690,  4695,  4701,  4704,  4709,  4711,  4714,  4717,  4720,
    4722,  4724,  4725,  4730,  4733,  4735,  4738,  4741,  4746,  4748,
    4752,  4754,  4757,  4761,  4763,  4766,  4767,  4770,  4775,  4776,
    4778,  4782,  4785,  4788,  4792,  4798,  4805,  4808,  4812,  4816,
    4821,  4822,  4824,  4826,  4828,  4830,  4832,  4835,  4841,  4843,
    4845,  4847,  4849,  4852,  4856,  4860,  4861,  4863,  4865,  4867,
    4869,  4871,  4874,  4877,  4880,  4883,  4886,  4888,  4892,  4893,
    4895,  4897,  4899,  4901,  4907,  4910,  4912,  4914,  4916,  4918,
    4924,  4927,  4930,  4933,  4935,  4939,  4943,  4946,  4948,  4949,
    4953,  4954,  4960,  4963,  4969,  4972,  4974,  4977,  4981,  4982,
    4984,  4986,  4988,  4990,  4992,  4994,  4998,  5002,  5006,  5010,
    5014,  5018,  5022,  5023,  5025,  5030,  5032,  5036,  5042,  5045,
    5048,  5052,  5056,  5060,  5064,  5068,  5072,  5076,  5080,  5084,
    5088,  5091,  5094,  5098,  5102,  5105,  5109,  5115,  5120,  5127,
    5131,  5137,  5142,  5149,  5154,  5161,  5167,  5175,  5179,  5182,
    5187,  5190,  5194,  5198,  5203,  5207,  5212,  5216,  5221,  5227,
    5234,  5241,  5249,  5256,  5264,  5271,  5279,  5283,  5288,  5293,
    5300,  5303,  5307,  5312,  5314,  5318,  5321,  5324,  5328,  5332,
    5336,  5340,  5344,  5348,  5352,  5356,  5360,  5364,  5367,  5370,
    5376,  5383,  5390,  5398,  5402,  5407,  5409,  5411,  5414,  5419,
    5421,  5423,  5425,  5428,  5431,  5434,  5436,  5441,  5447,  5454,
    5463,  5470,  5478,  5486,  5492,  5494,  5496,  5501,  5503,  5508,
    5510,  5515,  5517,  5522,  5524,  5526,  5528,  5530,  5532,  5534,
    5541,  5546,  5551,  5556,  5561,  5568,  5574,  5580,  5586,  5591,
    5598,  5603,  5608,  5613,  5618,  5624,  5632,  5640,  5650,  5655,
    5662,  5668,  5676,  5684,  5692,  5695,  5699,  5703,  5707,  5712,
    5713,  5718,  5720,  5724,  5728,  5730,  5732,  5734,  5737,  5740,
    5741,  5744,  5745,  5747,  5751,  5755,  5758,  5761,  5762,  5769,
    5771,  5772,  5776,  5777,  5780,  5783,  5784,  5786,  5791,  5794,
    5797,  5800,  5803,  5806,  5811,  5815,  5821,  5823,  5825,  5827,
    5829,  5831,  5833,  5835,  5837,  5839,  5841,  5843,  5845,  5847,
    5849,  5851,  5856,  5858,  5863,  5865,  5870,  5872,  5875,  5877,
    5880,  5882,  5886,  5888,  5892,  5894,  5898,  5900,  5904,  5908,
    5912,  5915,  5917,  5921,  5925,  5926,  5928,  5930,  5932,  5934,
    5936,  5938,  5940,  5942,  5947,  5951,  5954,  5958,  5959,  5963,
    5967,  5970,  5973,  5975,  5976,  5979,  5982,  5986,  5989,  5991,
    5993,  5997,  6003,  6005,  6008,  6013,  6016,  6017,  6019,  6020,
    6022,  6025,  6028,  6031,  6035,  6041,  6043,  6046,  6047,  6050,
    6052,  6053,  6055,  6057,  6059,  6063,  6067,  6069,  6073,  6077,
    6080,  6082,  6084,  6086,  6090,  6092,  6095,  6097,  6101,  6103,
    6105,  6107,  6109,  6111,  6113,  6115,  6118,  6120,  6122,  6124,
    6126,  6128,  6131,  6137,  6140,  6144,  6151,  6153,  6155,  6157,
    6159,  6161,  6163,  6165,  6167,  6169,  6172,  6175,  6177,  6181,
    6183,  6185,  6187,  6189,  6191,  6193,  6195,  6197,  6199,  6201,
    6203,  6205,  6207,  6209,  6211,  6213,  6215,  6217,  6219,  6221,
    6223,  6225,  6227,  6229,  6231,  6233,  6235,  6237,  6239,  6241,
    6243,  6245,  6247,  6249,  6251,  6253,  6255,  6257,  6259,  6261,
    6263,  6265,  6267,  6269,  6271,  6273,  6275,  6277,  6279,  6281,
    6283,  6285,  6287,  6289,  6291,  6293,  6295,  6297,  6299,  6301,
    6303,  6305,  6307,  6309,  6311,  6313,  6315,  6317,  6319,  6321,
    6323,  6325,  6327,  6329,  6331,  6333,  6335,  6337,  6339,  6341,
    6343,  6345,  6347,  6349,  6351,  6353,  6355,  6357,  6359,  6361,
    6363,  6365,  6367,  6369,  6371,  6373,  6375,  6377,  6379,  6381,
    6383,  6385,  6387,  6389,  6391,  6393,  6395,  6397,  6399,  6401,
    6403,  6405,  6407,  6409,  6411,  6413,  6415,  6417,  6419,  6421,
    6423,  6425,  6427,  6429,  6431,  6433,  6435,  6437,  6439,  6441,
    6443,  6445,  6447,  6449,  6451,  6453,  6455,  6457,  6459,  6461,
    6463,  6465,  6467,  6469,  6471,  6473,  6475,  6477,  6479,  6481,
    6483,  6485,  6487,  6489,  6491,  6493,  6495,  6497,  6499,  6501,
    6503,  6505,  6507,  6509,  6511,  6513,  6515,  6517,  6519,  6521,
    6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,  6539,  6541,
    6543,  6545,  6547,  6549,  6551,  6553,  6555,  6557,  6559,  6561,
    6563,  6565,  6567,  6569,  6571,  6573,  6575,  6577,  6579,  6581,
    6583,  6585,  6587,  6589,  6591,  6593,  6595,  6597,  6599,  6601,
    6603,  6605,  6607,  6609,  6611,  6613,  6615,  6617,  6619,  6621,
    6623,  6625,  6627,  6629,  6631,  6633,  6635,  6637,  6639,  6641,
    6643,  6645,  6647,  6649,  6651,  6653,  6655,  6657,  6659,  6661,
    6663,  6665,  6667,  6669,  6671,  6673,  6675,  6677,  6679,  6681,
    6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,  6699,  6701,
    6703,  6705,  6707,  6709,  6711,  6713,  6715,  6717,  6719,  6721,
    6723,  6725,  6727,  6729,  6731,  6733,  6735,  6737,  6739,  6741,
    6743,  6745,  6747,  6749,  6751,  6753,  6755,  6757,  6759,  6761,
    6763,  6765,  6767,  6769,  6771,  6773,  6775,  6777,  6779,  6781,
    6783,  6785,  6787,  6789,  6791,  6793,  6795,  6797,  6799,  6801,
    6803,  6805,  6807,  6809,  6811,  6813,  6815,  6817,  6819,  6821,
    6823,  6825,  6827,  6829,  6831,  6833,  6835,  6837,  6839,  6841,
    6843,  6845,  6847,  6849,  6851,  6853,  6855,  6857,  6859,  6861,
    6863,  6865,  6867,  6869,  6871,  6873,  6875,  6877,  6879,  6881,
    6883,  6885,  6887,  6889,  6891,  6893,  6895,  6897,  6899,  6901,
    6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,  6921,
    6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,  6941,
    6943,  6944,  6947,  6952,  6956,  6959,  6961,  6963,  6965,  6967,
    6969,  6970,  6979,  6982,  6988,  6992,  6995,  6998,  7002,  7010,
    7012,  7014,  7016,  7017,  7020,  7023,  7025,  7026,  7028,  7032,
    7034,  7037,  7038,  7041,  7042,  7045,  7046,  7048,  7052,  7057,
    7061,  7063,  7065,  7067,  7069,  7072,  7073,  7076,  7081,  7082,
    7085,  7088,  7091,  7093,  7095,  7103,  7107,  7109,  7111,  7113,
    7115,  7118,  7119,  7121,  7125,  7129,  7133,  7137,  7138,  7143,
    7149,  7155,  7156,  7158,  7160,  7162,  7165,  7168,  7170,  7173,
    7174,  7182,  7183,  7189,  7190,  7195,  7198,  7201,  7202,  7205,
    7207,  7209,  7211,  7213,  7215,  7217,  7219,  7221,  7223,  7225,
    7227,  7233,  7236,  7238,  7242,  7245,  7248,  7252,  7253,  7259,
    7261,  7262,  7268,  7271,  7274,  7276,  7278,  7280,  7283,  7286,
    7290,  7292,  7295,  7298,  7302,  7306,  7311,  7314,  7316,  7319,
    7321,  7323,  7326,  7329,  7333,  7335,  7337,  7339,  7341,  7342,
    7344,  7348,  7354,  7355,  7358,  7359,  7361,  7364,  7368,  7371,
    7373,  7375,  7377,  7378,  7380,  7382,  7384,  7386,  7388,  7391,
    7394,  7398,  7399,  7401,  7404,  7406,  7411,  7415,  7420,  7424,
    7427,  7429,  7433,  7435,  7437,  7439,  7441,  7444,  7447,  7449,
    7452,  7455,  7457,  7459,  7461,  7466,  7471,  7476,  7481,  7486,
    7488,  7489,  7493,  7497,  7502,  7504,  7508,  7512,  7517,  7519,
    7523,  7527,  7529,  7531,  7533,  7540,  7542,  7546,  7550,  7557,
    7559,  7563,  7567,  7569,  7571,  7574,  7577,  7579,  7581,  7583,
    7585,  7587,  7589,  7591,  7593,  7595,  7597,  7599,  7601,  7603,
    7605,  7607,  7609,  7614,  7619,  7621,  7623,  7628,  7633,  7637,
    7638,  7646,  7648,  7649,  7650,  7658,  7662,  7667,  7671,  7673,
    7675,  7677,  7680,  7684,  7690,  7693,  7699,  7702,  7704,  7706,
    7708,  7710,  7712,  7714,  7716,  7718,  7720,  7722,  7724,  7726,
    7728,  7730,  7732,  7734,  7736,  7738,  7740,  7742,  7744,  7746,
    7748,  7750,  7752,  7754,  7756,  7758,  7760,  7762,  7764,  7766,
    7768,  7770,  7772,  7774,  7776,  7778,  7780,  7782,  7784,  7786,
    7788,  7790,  7792,  7794,  7796,  7798,  7800,  7802,  7804,  7806,
    7808,  7810,  7812,  7814,  7816,  7818,  7820,  7822,  7824,  7826,
    7828,  7830,  7832,  7834,  7836,  7838,  7840,  7842,  7844,  7846,
    7848,  7850,  7852,  7854,  7856,  7858,  7860,  7862,  7864,  7866,
    7868,  7870,  7872,  7874,  7876,  7878,  7880,  7882,  7884,  7886,
    7888,  7890,  7892,  7894,  7896,  7898,  7902,  7904,  7905,  7907,
    7910,  7912,  7915,  7917,  7919,  7921,  7924,  7927,  7929,  7931,
    7933,  7935,  7937,  7939,  7941,  7943,  7945,  7947,  7949,  7951,
    7953,  7955,  7957,  7959,  7962,  7966,  7968,  7971,  7973,  7977,
    7979,  7983,  7985,  7987,  7989,  7991,  7993,  7995,  7997,  7999,
    8001,  8003,  8005,  8007,  8009,  8011,  8013,  8015,  8017,  8019,
    8021,  8023,  8025,  8027,  8029,  8031,  8033,  8035,  8037,  8039,
    8041,  8043,  8045,  8047,  8049,  8051,  8053,  8055,  8057,  8059,
    8061,  8063,  8065,  8067,  8069,  8071,  8073,  8075,  8077,  8079,
    8081,  8083,  8085,  8087,  8089,  8091,  8093,  8095,  8097,  8099,
    8101,  8103,  8105,  8108,  8112,  8115,  8119,  8121,  8125,  8129,
    8133,  8137,  8141,  8145,  8147,  8149,  8150,  8153,  8156,  8158,
    8160,  8163,  8165,  8167,  8169,  8170
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     511,     0,    -1,  1018,    -1,   810,    -1,   811,    -1,   729,
      -1,   816,    -1,   639,    -1,   653,    -1,   763,    -1,   528,
      -1,   784,    -1,   785,    -1,   620,    -1,   553,    -1,   522,
      -1,   520,    -1,   819,    -1,   818,    -1,   657,    -1,   524,
      -1,   523,    -1,   826,    -1,   551,    -1,   563,    -1,   821,
      -1,   707,    -1,   548,    -1,   564,    -1,  1020,    -1,   673,
      -1,   774,    -1,   820,    -1,   815,    -1,   637,    -1,   648,
      -1,   744,    -1,   527,    -1,   686,    -1,   692,    -1,   693,
      -1,   626,    -1,   531,    -1,   619,    -1,   579,    -1,   634,
      -1,   658,    -1,   513,    -1,   519,    -1,   654,    -1,   806,
      -1,  1161,    -1,   861,    -1,   675,    -1,   848,    -1,   552,
      -1,   771,    -1,   674,    -1,   776,    -1,   638,    -1,   652,
      -1,   530,    -1,   696,    -1,   697,    -1,   698,    -1,   632,
      -1,   793,    -1,   700,    -1,   636,    -1,   672,    -1,   525,
      -1,   526,    -1,   656,    -1,   814,    -1,   841,    -1,   832,
      -1,   710,    -1,   714,    -1,   725,    -1,   734,    -1,   843,
      -1,   796,    -1,   805,    -1,   850,    -1,   794,    -1,   838,
      -1,   699,    -1,   778,    -1,   767,    -1,   766,    -1,   768,
      -1,   781,    -1,   715,    -1,   726,    -1,   786,    -1,   865,
      -1,   798,    -1,   705,    -1,   797,    -1,   854,    -1,   823,
      -1,   545,    -1,   535,    -1,   547,    -1,   803,    -1,  1097,
      -1,  1023,    -1,  1040,    -1,  1098,    -1,  1080,    -1,  1095,
      -1,  1081,    -1,  1041,    -1,  1085,    -1,  1107,    -1,  1099,
      -1,  1086,    -1,  1115,    -1,  1117,    -1,  1110,    -1,  1102,
      -1,  1118,    -1,  1121,    -1,  1123,    -1,    -1,   158,   381,
    1011,   514,   515,    -1,   469,    -1,    -1,   515,   518,    -1,
      -1,   516,   517,    -1,    -1,   345,  1151,    -1,   345,   319,
      -1,   203,   345,  1151,    -1,   444,   345,  1151,    -1,   418,
      -1,   313,    -1,   252,    -1,   310,    -1,   159,    -1,   307,
      -1,   160,    -1,   308,    -1,   161,    -1,   309,    -1,   291,
      -1,   311,    -1,   150,   283,  1012,    -1,   454,   449,  1151,
      -1,   451,  1001,    -1,   517,    -1,   420,  1010,    -1,    96,
    1001,    -1,   381,  1001,    -1,   247,   381,  1001,    -1,   247,
     235,  1001,    -1,   158,   451,  1011,   514,   515,    -1,   101,
     381,  1011,   514,   516,    -1,    -1,   247,   175,  1003,    -1,
     101,   381,  1011,   521,   546,    -1,   101,   451,  1011,   514,
     516,    -1,   101,   451,  1011,   546,    -1,   198,   381,  1001,
      -1,   198,   381,   242,   212,  1001,    -1,   198,   451,  1001,
      -1,   198,   451,   242,   212,  1001,    -1,   158,   235,  1011,
     514,   515,    -1,   101,   235,  1011,   529,   451,  1001,    -1,
      95,    -1,   198,    -1,   198,   235,  1001,    -1,   198,   235,
     242,   212,  1001,    -1,   158,   387,   532,   114,  1011,   533,
      -1,   158,   387,  1131,   533,    -1,  1131,    -1,    -1,   533,
     534,    -1,    -1,   579,    -1,   734,    -1,   619,    -1,   658,
      -1,   714,    -1,   803,    -1,   399,   536,    -1,   399,   286,
     536,    -1,   399,   397,   536,    -1,   537,   432,   538,    -1,
     537,   489,   538,    -1,   537,   432,   181,    -1,   537,   489,
     181,    -1,   537,   227,   164,    -1,   430,   485,   542,    -1,
     434,   801,    -1,   397,   135,   108,   434,   801,    -1,   131,
    1151,    -1,   387,  1151,    -1,   301,   543,    -1,   381,   544,
      -1,   397,   114,   544,    -1,   397,   114,   181,    -1,   474,
     331,   949,    -1,  1130,    -1,   537,   504,  1131,    -1,   539,
      -1,   538,   505,   539,    -1,   541,    -1,   544,    -1,   625,
      -1,   361,   443,    -1,   361,   147,    -1,   371,   361,    -1,
     395,    -1,   438,    -1,   216,    -1,   328,    -1,   325,    -1,
    1151,    -1,  1153,    -1,   936,  1151,   938,    -1,   936,   502,
    1010,   503,  1151,   938,    -1,   625,    -1,   181,    -1,   286,
      -1,  1151,    -1,   181,    -1,    -1,  1131,    -1,  1151,    -1,
     374,   537,    -1,   374,   430,   485,    -1,   374,   434,   270,
     281,    -1,   374,   397,   114,    -1,   374,    99,    -1,   399,
     536,    -1,   545,    -1,   402,   537,  1164,    -1,   402,   430,
     485,  1164,    -1,   402,   434,   270,   281,  1164,    -1,   402,
     397,   114,  1164,    -1,   402,    99,    -1,   399,   152,   549,
     550,    -1,    99,    -1,   999,    -1,   184,    -1,   244,    -1,
     137,    -1,   192,    99,    -1,   192,   425,    -1,   192,   427,
      -1,   192,   347,    -1,   101,   422,   908,   554,    -1,   101,
     250,  1000,   554,    -1,   101,   393,  1000,   554,    -1,   101,
     463,  1000,   554,    -1,   555,    -1,   554,   505,   555,    -1,
      95,   587,    -1,    95,   143,   587,    -1,   101,   782,  1131,
     556,    -1,   101,   782,  1131,   198,   314,   319,    -1,   101,
     782,  1131,   399,   314,   319,    -1,   101,   782,  1131,   399,
     411,  1012,    -1,   101,   782,  1131,   399,   559,    -1,   101,
     782,  1131,   374,   559,    -1,   101,   782,  1131,   399,   414,
    1131,    -1,   198,   782,   242,   212,  1131,   557,    -1,   198,
     782,  1131,   557,    -1,   101,   782,  1131,   783,   441,   916,
     558,    -1,    95,   596,    -1,   198,   151,   242,   212,  1002,
     557,    -1,   198,   151,  1002,   557,    -1,   399,   469,   327,
      -1,   399,   470,   327,    -1,   140,   328,  1002,    -1,   399,
     470,   140,    -1,   201,   436,  1002,    -1,   201,   102,   436,
    1002,    -1,   201,   373,   436,  1002,    -1,   201,   436,    99,
      -1,   201,   436,   451,    -1,   191,   436,  1002,    -1,   191,
     436,    99,    -1,   191,   436,   451,    -1,   201,   385,  1002,
      -1,   201,   102,   385,  1002,    -1,   201,   373,   385,  1002,
      -1,   191,   385,  1002,    -1,   252,  1000,    -1,   306,   252,
    1000,    -1,   341,   432,  1011,    -1,   399,   424,  1002,    -1,
     399,   559,    -1,   374,   559,    -1,   399,   181,   940,    -1,
     198,   181,    -1,   127,    -1,   376,    -1,    -1,   452,   940,
      -1,    -1,   502,   561,   503,    -1,   469,   559,    -1,    -1,
     562,    -1,   561,   505,   562,    -1,  1133,   489,   679,    -1,
    1133,    -1,  1133,   504,  1133,   489,   679,    -1,  1133,   504,
    1133,    -1,   139,   862,    -1,   139,    99,    -1,   156,   570,
    1000,   598,   571,   565,   566,   572,   514,   567,    -1,   156,
     866,   432,   566,   514,   567,    -1,   227,    -1,   432,    -1,
    1151,    -1,   412,    -1,   413,    -1,   568,    -1,   502,   574,
     503,    -1,   568,   569,    -1,    -1,   120,    -1,   327,    -1,
     187,   817,  1151,    -1,   319,   817,  1151,    -1,   163,    -1,
     238,    -1,   359,   817,  1151,    -1,   206,   817,  1151,    -1,
     223,   359,   599,    -1,   223,   359,   495,    -1,   223,   314,
     319,   599,    -1,   120,    -1,    -1,   469,   327,    -1,    -1,
     573,   188,  1151,    -1,    -1,   452,    -1,    -1,   575,    -1,
     574,   505,   575,    -1,  1133,   576,    -1,   541,    -1,   544,
      -1,   625,    -1,   495,    -1,   502,   577,   503,    -1,    -1,
     578,    -1,   577,   505,   578,    -1,   541,    -1,   544,    -1,
     158,   580,   422,  1000,   502,   581,   503,   609,   610,   611,
     612,    -1,   158,   580,   422,  1000,   324,   703,   582,   610,
     611,   612,    -1,   427,    -1,   425,    -1,   286,   427,    -1,
     286,   425,    -1,   231,   427,    -1,   231,   425,    -1,    -1,
     583,    -1,    -1,   502,   584,   503,    -1,    -1,   585,    -1,
     583,   505,   585,    -1,   586,    -1,   584,   505,   586,    -1,
     587,    -1,   593,    -1,   596,    -1,   588,    -1,   596,    -1,
    1131,   916,   589,    -1,  1131,   469,   332,   589,    -1,   589,
     590,    -1,    -1,   151,  1002,   591,    -1,   591,    -1,   592,
      -1,   314,   319,    -1,   319,    -1,   446,   760,   613,    -1,
     354,   272,   760,   613,    -1,   136,   502,   940,   503,    -1,
     181,   941,    -1,   366,  1000,   598,   601,   605,    -1,   183,
      -1,   314,   183,    -1,   254,   184,    -1,   254,   244,    -1,
     282,  1000,   594,    -1,   594,   248,   595,    -1,   594,   209,
     595,    -1,    -1,   182,    -1,   152,    -1,   251,    -1,   414,
      -1,   145,    -1,    99,    -1,   151,  1002,   597,    -1,   597,
      -1,   136,   502,   940,   503,   669,    -1,   446,   502,   599,
     503,   760,   613,   669,    -1,   354,   272,   502,   599,   503,
     760,   613,   669,    -1,   208,   738,   502,   602,   503,   760,
     613,   604,   669,    -1,   224,   272,   502,   599,   503,   366,
    1000,   598,   601,   605,   669,    -1,   502,   599,   503,    -1,
      -1,   600,    -1,   599,   505,   600,    -1,  1131,    -1,   293,
     228,    -1,   293,   343,    -1,   293,   404,    -1,    -1,   603,
      -1,   602,   505,   603,    -1,   740,   469,   770,    -1,   740,
     469,   330,   502,   770,   503,    -1,   466,   502,   940,   503,
      -1,    -1,   606,    -1,   607,    -1,   606,   607,    -1,   607,
     606,    -1,    -1,   328,   450,   608,    -1,   328,   186,   608,
      -1,   306,    94,    -1,   376,    -1,   127,    -1,   399,   319,
      -1,   399,   181,    -1,   253,   502,   999,   503,    -1,    -1,
     469,   559,    -1,   469,   327,    -1,   470,   327,    -1,    -1,
     328,   146,   198,    -1,   328,   146,   186,   384,    -1,   328,
     146,   351,   384,    -1,    -1,   424,  1002,    -1,    -1,   452,
     250,   424,  1002,    -1,    -1,  1000,   615,   610,   611,   612,
      -1,   502,   616,   503,    -1,    -1,   617,    -1,   616,   505,
     617,    -1,  1131,    -1,   469,   174,    -1,   469,   306,   174,
      -1,    -1,   158,   580,   393,  1000,   621,    -1,   101,   393,
    1000,   622,    -1,   622,    -1,    -1,   623,    -1,   622,   623,
      -1,   125,   625,    -1,   173,    -1,   306,   173,    -1,   249,
     624,   625,    -1,   294,   625,    -1,   296,   625,    -1,   306,
     294,    -1,   306,   296,    -1,   340,   124,   703,    -1,   409,
     514,   625,    -1,   375,    -1,   375,   514,   625,    -1,   124,
      -1,    -1,  1150,    -1,   494,  1150,    -1,  1012,    -1,   158,
     745,   627,   633,   273,   544,    -1,   158,   745,   627,   633,
     273,   544,   236,   628,   629,   631,    -1,   440,    -1,    -1,
    1002,    -1,  1002,   704,    -1,   255,   628,    -1,    -1,   455,
     628,    -1,   306,   455,    -1,   630,    -1,    -1,   198,   633,
     273,   544,   557,    -1,   198,   633,   273,   242,   212,   544,
     557,    -1,   357,    -1,    -1,   158,   424,  1002,   635,   289,
    1151,    -1,   341,  1002,    -1,    -1,   198,   424,  1002,    -1,
     198,   424,   242,   212,  1002,    -1,   158,   224,   174,   472,
    1002,   631,   640,    -1,   198,   224,   174,   472,  1002,   557,
      -1,   198,   224,   174,   472,   242,   212,  1002,   557,    -1,
     101,   224,   174,   472,  1002,   630,   642,    -1,   101,   224,
     174,   472,  1002,   630,    -1,   101,   224,   174,   472,  1002,
     642,    -1,   332,   502,   641,   503,    -1,    -1,   645,    -1,
     641,   505,   645,    -1,   332,   502,   643,   503,    -1,   644,
      -1,   643,   505,   644,    -1,   645,    -1,   399,   645,    -1,
      95,   645,    -1,   198,   646,    -1,   646,   647,    -1,  1133,
      -1,  1151,    -1,   158,   396,  1002,   649,   651,   224,   174,
     472,  1002,   640,    -1,   441,  1151,    -1,    -1,   462,  1151,
      -1,   462,   319,    -1,   650,    -1,    -1,   198,   396,  1002,
     557,    -1,   198,   396,   242,   212,  1002,   557,    -1,   101,
     396,  1002,   650,   642,    -1,   101,   396,  1002,   650,    -1,
     101,   396,  1002,   642,    -1,   158,   451,   292,   222,   655,
     396,  1002,   640,    -1,   171,    -1,   451,    -1,  1011,    -1,
     198,   451,   292,   222,   655,   396,  1002,    -1,   198,   451,
     292,   242,   212,   222,   655,   396,  1002,    -1,   101,   451,
     292,   222,   655,   396,  1002,   642,    -1,   158,   436,  1002,
     659,   660,   328,  1000,   662,   665,   211,   358,  1008,   502,
     666,   503,    -1,   158,   151,   436,  1002,    97,   660,   328,
    1000,   668,   669,   222,   199,   383,   665,   211,   358,  1008,
     502,   666,   503,    -1,   116,    -1,    97,    -1,   661,    -1,
     660,   333,   661,    -1,   260,    -1,   186,    -1,   450,    -1,
     450,   324,   599,    -1,   439,    -1,   222,   663,   664,    -1,
      -1,   199,    -1,    -1,   383,    -1,   410,    -1,   465,   502,
     940,   503,    -1,    -1,   667,    -1,   666,   505,   667,    -1,
      -1,  1010,    -1,  1150,    -1,  1151,    -1,  1149,    -1,    84,
      -1,  1131,    -1,   227,  1000,    -1,    -1,   670,    -1,   670,
     671,    -1,   671,    -1,   671,   670,    -1,    -1,   314,   183,
      -1,   183,    -1,   254,   244,    -1,   254,   184,    -1,   198,
     436,  1002,   328,  1000,   557,    -1,   198,   436,   242,   212,
    1002,   328,  1000,   557,    -1,   158,   110,  1002,   136,   502,
     940,   503,   669,    -1,   198,   110,  1002,   557,    -1,   158,
      98,  1008,   680,   676,    -1,   158,    98,  1008,   681,    -1,
     158,   330,   770,   676,    -1,   158,   441,   703,   676,    -1,
     158,   441,   703,    -1,   158,   441,   703,   108,   502,   914,
     503,    -1,   158,   441,   703,   108,   205,   502,   684,   503,
      -1,   158,   428,   389,   342,   703,   676,    -1,   158,   428,
     389,   190,   703,   676,    -1,   158,   428,   389,   426,   703,
     676,    -1,   158,   428,   389,   149,   703,   676,    -1,   502,
     677,   503,    -1,   678,    -1,   677,   505,   678,    -1,  1133,
     489,   679,    -1,  1133,    -1,   754,    -1,  1017,    -1,   966,
      -1,   625,    -1,  1151,    -1,   502,   971,   503,    -1,   502,
     495,   503,    -1,   502,   682,   503,    -1,   683,    -1,   682,
     505,   683,    -1,  1153,   489,   679,    -1,   685,    -1,    -1,
    1151,    -1,   685,   505,  1151,    -1,   158,   330,   138,   703,
     689,   222,   441,   916,   452,  1004,   690,   108,   687,    -1,
     688,    -1,   687,   505,   688,    -1,   330,  1010,   770,   691,
      -1,   330,  1010,   770,   769,   691,    -1,   229,  1010,  1008,
     746,    -1,   229,  1010,   502,   971,   503,  1008,   746,    -1,
     414,   916,    -1,   181,    -1,    -1,   217,   703,    -1,    -1,
     364,    -1,    -1,   158,   330,   217,   703,   452,  1004,    -1,
     101,   330,   217,   703,   452,  1004,    95,   687,    -1,   101,
     330,   217,   703,   452,  1004,   198,   694,    -1,   695,    -1,
     694,   505,   695,    -1,   330,  1010,   502,   971,   503,    -1,
     229,  1010,   502,   971,   503,    -1,   198,   330,   138,   703,
     452,  1004,   557,    -1,   198,   330,   138,   242,   212,   703,
     452,  1004,   557,    -1,   198,   330,   217,   703,   452,  1004,
     557,    -1,   198,   330,   217,   242,   212,   703,   452,  1004,
     557,    -1,   198,   340,   124,  1001,   557,    -1,   363,   340,
     124,  1001,   432,  1002,    -1,   198,   701,   242,   212,   702,
     557,    -1,   198,   701,   702,   557,    -1,   422,    -1,   393,
      -1,   463,    -1,   250,    -1,   441,    -1,   196,    -1,   155,
      -1,   387,    -1,   428,   389,   342,    -1,   428,   389,   190,
      -1,   428,   389,   426,    -1,   428,   389,   149,    -1,   703,
      -1,   702,   505,   703,    -1,  1131,    -1,  1131,   704,    -1,
     504,  1005,    -1,   704,   504,  1005,    -1,   439,   875,   909,
     706,   557,    -1,   154,   241,    -1,   375,   241,    -1,    -1,
     144,   328,   708,   703,   268,   709,    -1,   144,   328,    98,
    1008,   680,   268,   709,    -1,   144,   328,   229,  1008,   746,
     268,   709,    -1,   144,   328,   330,   770,   769,   268,   709,
      -1,   144,   328,   151,  1002,   328,   703,   268,   709,    -1,
     144,   328,   385,  1002,   328,   703,   268,   709,    -1,   144,
     328,   385,  1002,   268,   709,    -1,   144,   328,   436,  1002,
     328,   703,   268,   709,    -1,   144,   328,   330,   138,   703,
     452,  1004,   268,   709,    -1,   144,   328,   330,   217,   703,
     452,  1004,   268,   709,    -1,   144,   328,   274,   323,   625,
     268,   709,    -1,   144,   328,   130,   502,   916,   108,   916,
     503,   268,   709,    -1,   144,   328,   633,   273,   703,   268,
     709,    -1,   144,   328,   428,   389,   342,   703,   268,   709,
      -1,   144,   328,   428,   389,   190,   703,   268,   709,    -1,
     144,   328,   428,   389,   426,   703,   268,   709,    -1,   144,
     328,   428,   389,   149,   703,   268,   709,    -1,   143,    -1,
     175,    -1,   387,    -1,   250,    -1,   393,    -1,   422,    -1,
     196,    -1,   441,    -1,   463,    -1,   155,    -1,   424,    -1,
     381,    -1,  1151,    -1,   319,    -1,   218,   711,    -1,   299,
     711,    -1,   218,   711,  1165,    -1,   218,   225,   862,  1166,
      -1,   218,   225,   712,   862,  1166,    -1,   218,   115,   862,
    1166,    -1,   218,   115,   712,   862,  1166,    -1,   299,   225,
     862,    -1,   299,   225,   712,   862,    -1,   299,   115,   862,
      -1,   299,   115,   712,   862,    -1,   862,    -1,   712,   862,
      -1,   305,   713,   862,    -1,   355,   713,   862,    -1,   219,
     713,   862,    -1,   275,   713,   862,    -1,    92,  1012,   713,
     862,    -1,   368,  1012,   713,   862,    -1,  1012,   713,   862,
      -1,    99,   713,   862,    -1,   225,  1012,   713,   862,    -1,
     225,    99,   713,   862,    -1,   115,  1012,   713,   862,    -1,
     115,    99,   713,   862,    -1,   227,    -1,   247,    -1,   712,
      -1,    -1,   232,   716,   328,   719,   432,   720,   722,    -1,
     379,   716,   328,   719,   227,   720,   557,    -1,   379,   232,
     331,   222,   716,   328,   719,   227,   720,   557,    -1,   717,
      -1,    99,    -1,    99,   356,    -1,    99,   502,   599,   503,
      -1,    99,   356,   502,   599,   503,    -1,   718,    -1,   717,
     505,   718,    -1,   392,   598,    -1,   366,   598,    -1,   158,
     598,    -1,  1131,   598,    -1,   999,    -1,   422,   999,    -1,
     393,   999,    -1,   224,   174,   472,  1001,    -1,   224,   396,
    1001,    -1,   229,   723,    -1,   175,  1001,    -1,   273,  1001,
      -1,   274,   323,  1013,    -1,   387,  1001,    -1,   424,  1001,
      -1,    99,   423,   247,   387,  1001,    -1,    99,   394,   247,
     387,  1001,    -1,    99,   230,   247,   387,  1001,    -1,   721,
      -1,   720,   505,   721,    -1,  1011,    -1,   235,  1011,    -1,
     469,   232,   331,    -1,    -1,   724,    -1,   723,   505,   724,
      -1,  1008,   746,    -1,   232,   717,   432,  1001,   727,   728,
      -1,   379,   717,   227,  1001,   728,   557,    -1,   379,    96,
     331,   222,   717,   227,  1001,   728,   557,    -1,   469,    96,
     331,    -1,    -1,   233,   124,  1011,    -1,    -1,   101,   181,
     356,   730,   732,    -1,   730,   731,    -1,    -1,   247,   387,
    1001,    -1,   222,   381,  1001,    -1,   222,   451,  1001,    -1,
     232,   716,   328,   733,   432,   720,   722,    -1,   379,   716,
     328,   733,   227,   720,   557,    -1,   379,   232,   331,   222,
     716,   328,   733,   227,   720,   557,    -1,   423,    -1,   230,
      -1,   394,    -1,   158,   735,   250,   736,   737,   328,  1000,
     738,   502,   739,   503,   560,   612,   912,    -1,   446,    -1,
      -1,   148,    -1,    -1,  1006,    -1,    -1,   452,  1004,    -1,
      -1,   740,    -1,   739,   505,   740,    -1,  1131,   741,   742,
     743,    -1,   943,   741,   742,   743,    -1,   502,   940,   503,
     741,   742,   743,    -1,   703,    -1,   452,   703,    -1,    -1,
     109,    -1,   189,    -1,    -1,   486,    -1,   487,    -1,    -1,
     158,   745,   229,  1008,   748,   378,   753,   756,   760,    -1,
     158,   745,   229,  1008,   748,   378,   422,   502,   762,   503,
     756,   760,    -1,   158,   745,   229,  1008,   748,   756,   760,
      -1,   333,   372,    -1,    -1,   502,   747,   503,    -1,   502,
     503,    -1,   750,    -1,   747,   505,   750,    -1,   502,   749,
     503,    -1,   502,   503,    -1,   755,    -1,   749,   505,   755,
      -1,   751,   752,   754,    -1,   752,   751,   754,    -1,   752,
     754,    -1,   751,   754,    -1,   754,    -1,   247,    -1,   335,
      -1,   257,    -1,   247,   335,    -1,   459,    -1,  1132,    -1,
     754,    -1,   916,    -1,  1132,   704,   497,   441,    -1,   400,
    1132,   704,   497,   441,    -1,   750,    -1,   750,   181,   940,
      -1,   750,   489,   940,    -1,   758,    -1,   756,   758,    -1,
     126,   328,   319,   258,    -1,   378,   319,   328,   319,   258,
      -1,   415,    -1,   245,    -1,   407,    -1,   464,    -1,   214,
     391,   185,    -1,   214,   391,   267,    -1,   391,   185,    -1,
     391,   267,    -1,   157,   625,    -1,   384,   625,    -1,   546,
      -1,   108,   759,    -1,   273,   544,    -1,   468,    -1,   757,
      -1,  1151,    -1,  1151,   505,  1151,    -1,   469,   676,    -1,
      -1,   752,   754,    -1,   761,    -1,   762,   505,   761,    -1,
     101,   229,   724,   764,   765,    -1,   757,    -1,   764,   757,
      -1,   376,    -1,    -1,   198,   229,  1008,   746,   557,    -1,
     198,   229,   242,   212,  1008,   746,   557,    -1,   198,    98,
    1008,   680,   557,    -1,   198,    98,   242,   212,  1008,   680,
     557,    -1,   198,   330,   770,   769,   557,    -1,   198,   330,
     242,   212,   770,   769,   557,    -1,   502,   916,   503,    -1,
     502,   916,   505,   916,   503,    -1,   502,   312,   505,   916,
     503,    -1,   502,   916,   505,   312,   503,    -1,   963,    -1,
    1131,   504,   770,    -1,   194,   772,    -1,   773,    -1,   772,
     773,    -1,  1151,    -1,   273,   544,    -1,   158,   130,   502,
     916,   108,   916,   503,   469,   229,   724,   775,    -1,   158,
     130,   502,   916,   108,   916,   503,   470,   229,   775,    -1,
     158,   130,   502,   916,   108,   916,   503,   469,   257,   775,
      -1,   108,   246,    -1,   108,   111,    -1,    -1,   198,   130,
     777,   502,   916,   108,   916,   503,   557,    -1,   242,   212,
      -1,    -1,   367,   779,  1000,   780,    -1,   367,   421,  1002,
     780,    -1,   367,   175,  1002,   780,    -1,   250,    -1,   422,
      -1,   223,    -1,    -1,   101,    98,  1008,   680,   370,   432,
    1002,    -1,   101,   155,   703,   370,   432,  1002,    -1,   101,
     175,  1003,   370,   432,  1003,    -1,   101,   229,   724,   370,
     432,  1002,    -1,   101,   235,  1011,   370,   432,  1011,    -1,
     101,   633,   273,  1002,   370,   432,  1002,    -1,   101,   330,
     138,   703,   452,  1004,   370,   432,  1002,    -1,   101,   330,
     217,   703,   452,  1004,   370,   432,  1002,    -1,   101,   387,
    1002,   370,   432,  1002,    -1,   101,   422,   908,   370,   432,
    1002,    -1,   101,   393,  1000,   370,   432,  1002,    -1,   101,
     463,  1000,   370,   432,  1002,    -1,   101,   250,  1000,   370,
     432,  1002,    -1,   101,   422,   908,   370,   782,  1002,   432,
    1002,    -1,   101,   436,  1002,   328,  1000,   370,   432,  1002,
      -1,   101,   381,  1011,   370,   432,  1011,    -1,   101,   451,
    1011,   370,   432,  1011,    -1,   101,   424,  1002,   370,   432,
    1002,    -1,   101,   424,  1002,   399,   559,    -1,   101,   424,
    1002,   374,   559,    -1,   101,   428,   389,   342,   703,   370,
     432,  1002,    -1,   101,   428,   389,   190,   703,   370,   432,
    1002,    -1,   101,   428,   389,   426,   703,   370,   432,  1002,
      -1,   101,   428,   389,   149,   703,   370,   432,  1002,    -1,
     101,   441,   703,   370,   432,  1002,    -1,   143,    -1,    -1,
     399,   174,    -1,    -1,   101,    98,  1008,   680,   399,   387,
    1002,    -1,   101,   196,   703,   399,   387,  1002,    -1,   101,
     229,   724,   399,   387,  1002,    -1,   101,   422,   908,   399,
     387,  1002,    -1,   101,   393,  1000,   399,   387,  1002,    -1,
     101,   463,  1000,   399,   387,  1002,    -1,   101,   441,   703,
     399,   387,  1002,    -1,   101,    98,  1008,   680,   341,   432,
    1011,    -1,   101,   155,   703,   341,   432,  1011,    -1,   101,
     175,  1003,   341,   432,  1011,    -1,   101,   196,   703,   341,
     432,  1011,    -1,   101,   229,   724,   341,   432,  1011,    -1,
     101,   633,   273,  1002,   341,   432,  1011,    -1,   101,   274,
     323,  1010,   341,   432,  1011,    -1,   101,   330,   770,   769,
     341,   432,  1011,    -1,   101,   330,   138,   703,   452,  1004,
     341,   432,  1011,    -1,   101,   330,   217,   703,   452,  1004,
     341,   432,  1011,    -1,   101,   387,  1002,   341,   432,  1011,
      -1,   101,   441,   703,   341,   432,  1011,    -1,   101,   424,
    1002,   341,   432,  1011,    -1,   101,   428,   389,   190,   703,
     341,   432,  1011,    -1,   101,   428,   389,   149,   703,   341,
     432,  1011,    -1,   101,   224,   174,   472,  1002,   341,   432,
    1011,    -1,   101,   396,  1002,   341,   432,  1011,    -1,   158,
     745,   385,  1002,   108,   328,   791,   432,  1000,   912,   194,
     792,   787,    -1,   315,    -1,   789,    -1,   502,   788,   503,
      -1,   788,   506,   790,    -1,   790,    -1,   865,    -1,   843,
      -1,   854,    -1,   848,    -1,   794,    -1,   789,    -1,    -1,
     392,    -1,   450,    -1,   186,    -1,   260,    -1,   261,    -1,
     100,    -1,    -1,   198,   385,  1002,   328,  1000,   557,    -1,
     198,   385,   242,   212,  1002,   328,  1000,   557,    -1,   316,
    1131,   795,    -1,   505,  1151,    -1,    -1,   284,  1131,    -1,
     448,  1131,    -1,   448,   495,    -1,    91,   799,    -1,   117,
     799,   802,    -1,   409,   434,   802,    -1,   146,   799,    -1,
     204,   799,    -1,   382,   799,    -1,   386,  1131,    -1,   369,
     386,  1131,    -1,   369,  1131,    -1,   382,   799,   432,   386,
    1131,    -1,   382,   799,   432,  1131,    -1,   352,   434,  1151,
      -1,   146,   353,  1151,    -1,   382,   353,  1151,    -1,   471,
      -1,   434,    -1,    -1,   270,   281,   540,    -1,   361,   329,
      -1,   361,   473,    -1,   800,    -1,   801,   505,   800,    -1,
     801,   800,    -1,   801,    -1,    -1,   158,   580,   463,  1000,
     598,   108,   865,   804,    -1,   158,   333,   372,   580,   463,
    1000,   598,   108,   865,   804,    -1,   469,   136,   331,    -1,
     469,   128,   136,   331,    -1,   469,   286,   136,   331,    -1,
      -1,   285,  1007,    -1,   158,   175,  1003,   514,   807,    -1,
     807,   808,    -1,    -1,   424,   809,  1002,    -1,   424,   809,
     181,    -1,   289,   809,  1151,    -1,   289,   809,   181,    -1,
     426,   809,  1002,    -1,   426,   809,   181,    -1,   202,   809,
    1151,    -1,   202,   809,  1010,    -1,   202,   809,   181,    -1,
     276,   809,  1151,    -1,   276,   809,   181,    -1,   277,   809,
    1151,    -1,   277,   809,   181,    -1,   150,   283,   809,  1012,
      -1,   341,   809,  1002,    -1,   341,   809,   181,    -1,   489,
      -1,    -1,   101,   175,  1003,   514,   812,    -1,   101,   175,
    1003,   399,   424,  1002,    -1,   101,   175,  1003,   546,    -1,
     812,   813,    -1,    -1,   150,   283,   809,  1012,    -1,   198,
     175,  1003,    -1,   198,   175,   242,   212,  1003,    -1,   158,
     196,   703,   817,   916,   589,    -1,   101,   196,   703,   556,
      -1,   101,   196,   703,   198,   314,   319,    -1,   101,   196,
     703,   399,   314,   319,    -1,   101,   196,   703,    95,   596,
      -1,   101,   196,   703,   198,   151,  1002,   557,    -1,   108,
      -1,    -1,   101,   428,   389,   190,   703,   676,    -1,   101,
     428,   389,   149,   703,    95,   292,   222,  1001,   469,   702,
      -1,   101,   428,   389,   149,   703,   101,   292,   222,  1001,
     469,   702,    -1,   101,   428,   389,   149,   703,   101,   292,
     372,   703,   469,   703,    -1,   101,   428,   389,   149,   703,
     101,   292,   222,  1001,   372,   703,   469,   703,    -1,   101,
     428,   389,   149,   703,   198,   292,   222,  1001,    -1,   101,
     428,   389,   149,   703,   198,   292,   242,   212,   222,  1001,
      -1,   158,   689,   155,   703,   222,  1151,   432,  1151,   227,
     703,    -1,   140,   828,  1000,   822,    -1,   140,   828,    -1,
     140,   828,  1006,   328,  1000,    -1,   452,  1006,    -1,    -1,
     453,   829,   830,   828,    -1,   453,   829,   830,   828,  1000,
      -1,   453,   829,   830,   828,   826,    -1,   453,   502,   824,
     503,    -1,   453,   502,   824,   503,  1000,   831,    -1,   825,
      -1,   824,   505,   825,    -1,   827,    -1,   461,    -1,   226,
      -1,   228,    -1,   827,   828,    -1,   827,   828,  1000,   831,
      -1,   104,    -1,   103,    -1,   461,    -1,    -1,   228,    -1,
      -1,   226,    -1,    -1,   502,  1001,   503,    -1,    -1,   213,
     833,    -1,   213,   827,   828,   833,    -1,   213,   461,   833,
      -1,   213,   502,   834,   503,   833,    -1,   865,    -1,   843,
      -1,   854,    -1,   848,    -1,   861,    -1,  1020,    -1,   841,
      -1,   835,    -1,   834,   505,   835,    -1,   836,   837,    -1,
    1131,    -1,   827,    -1,   461,    -1,   541,    -1,   544,    -1,
     625,    -1,    -1,   352,  1039,   839,   108,   840,    -1,   352,
    1039,   227,  1084,    -1,   502,   971,   503,    -1,    -1,   865,
      -1,   843,    -1,   854,    -1,   848,    -1,   211,  1039,   842,
    1163,    -1,   158,   580,   422,   614,   108,   211,  1039,   842,
      -1,   502,   968,   503,    -1,    -1,   260,   266,  1000,   844,
     847,    -1,   865,    -1,   502,   845,   503,   865,    -1,   181,
     457,    -1,   846,    -1,   845,   505,   846,    -1,  1131,   992,
      -1,   377,   997,    -1,    -1,   186,   227,   910,   849,   913,
     847,    -1,   452,   901,    -1,    -1,   290,   875,   909,   851,
     853,    -1,   247,   852,   297,    -1,    -1,    93,   401,    -1,
     383,   401,    -1,   383,   210,    -1,   401,   450,   210,    -1,
     401,    -1,   401,   383,   210,    -1,   210,    -1,    93,   210,
      -1,   318,    -1,    -1,   450,   910,   399,   855,   900,   913,
     847,    -1,   856,    -1,   855,   505,   856,    -1,   857,    -1,
     858,    -1,   859,   489,   994,    -1,   502,   860,   503,   489,
     996,    -1,  1131,   992,    -1,   859,    -1,   860,   505,   859,
      -1,   180,   862,   863,   172,   864,   222,   865,    -1,  1002,
      -1,  1144,    -1,    -1,   863,   306,   388,    -1,   863,   388,
      -1,   863,   120,    -1,   863,   259,    -1,    -1,   469,   239,
      -1,   470,   239,    -1,   867,    -1,   866,    -1,   502,   867,
     503,    -1,   502,   866,   503,    -1,   869,    -1,   868,   879,
      -1,   868,   878,   894,   883,    -1,   868,   878,   882,   895,
      -1,   870,   868,    -1,   870,   868,   879,    -1,   870,   868,
     878,   894,   883,    -1,   870,   868,   878,   882,   895,    -1,
     869,    -1,   866,    -1,   392,   877,   997,   873,   900,   912,
     892,   893,   951,    -1,   899,    -1,   422,   908,    -1,   868,
     445,   876,   868,    -1,   868,   264,   876,   868,    -1,   868,
     207,   876,   868,    -1,   469,   871,    -1,   469,   365,   871,
      -1,   872,    -1,   871,   505,   872,    -1,  1002,   831,   108,
     866,    -1,   266,   874,    -1,  1164,    -1,    -1,   427,   875,
    1000,    -1,   425,   875,  1000,    -1,   286,   427,   875,  1000,
      -1,   286,   425,   875,  1000,    -1,   231,   427,   875,  1000,
      -1,   231,   425,   875,  1000,    -1,   422,  1000,    -1,  1000,
      -1,   422,    -1,    -1,    99,    -1,   193,    -1,    -1,   193,
      -1,   193,   328,   502,   968,   503,    -1,    99,    -1,    -1,
     879,    -1,    -1,   334,   124,   880,    -1,   881,    -1,   880,
     505,   881,    -1,   940,   452,   966,   743,    -1,   940,   742,
     743,    -1,   884,   885,    -1,   885,   884,    -1,   884,    -1,
     885,    -1,   882,    -1,    -1,   283,   886,    -1,   283,   886,
     505,   887,    -1,   218,   891,   888,   890,   329,    -1,   326,
     887,    -1,   326,   889,   890,    -1,   940,    -1,    99,    -1,
     940,    -1,  1012,    -1,   502,   940,   503,    -1,    -1,   942,
      -1,   383,    -1,   384,    -1,   219,    -1,   305,    -1,   235,
     124,   968,    -1,    -1,   237,   940,    -1,    -1,   896,    -1,
     222,   361,   329,    -1,   894,    -1,    -1,   897,    -1,   896,
     897,    -1,   222,   450,   898,   853,    -1,   222,   401,   898,
     853,    -1,   324,   999,    -1,    -1,   457,   996,    -1,   899,
     505,   996,    -1,   227,   901,    -1,    -1,   902,    -1,   901,
     505,   902,    -1,   908,    -1,   908,   904,    -1,   911,    -1,
     911,   904,    -1,   911,   108,   502,   914,   503,    -1,   911,
     108,  1131,   502,   914,   503,    -1,   911,  1131,   502,   914,
     503,    -1,   866,    -1,   866,   904,    -1,   903,    -1,   502,
     903,   503,   904,    -1,   502,   903,   503,    -1,   902,   162,
     271,   902,    -1,   902,   905,   271,   902,   907,    -1,   902,
     271,   902,   907,    -1,   902,   303,   905,   271,   902,    -1,
     902,   303,   271,   902,    -1,   108,  1131,   502,  1001,   503,
      -1,   108,  1131,    -1,  1131,   502,  1001,   503,    -1,  1131,
      -1,   228,   906,    -1,   280,   906,    -1,   380,   906,    -1,
     256,    -1,   336,    -1,    -1,   452,   502,  1001,   503,    -1,
     328,   940,    -1,  1000,    -1,  1000,   495,    -1,   329,  1000,
      -1,   329,   502,  1000,   503,    -1,   908,    -1,   909,   505,
     908,    -1,   908,    -1,   908,  1131,    -1,   908,   108,  1131,
      -1,   943,    -1,   466,   940,    -1,    -1,   466,   940,    -1,
     466,   164,   324,  1002,    -1,    -1,   915,    -1,   914,   505,
     915,    -1,  1131,   916,    -1,   918,   917,    -1,   400,   918,
     917,    -1,   918,   107,   500,  1010,   501,    -1,   400,   918,
     107,   500,  1010,   501,    -1,   918,   107,    -1,   400,   918,
     107,    -1,   917,   500,   501,    -1,   917,   500,  1162,   501,
      -1,    -1,   920,    -1,   922,    -1,   924,    -1,   928,    -1,
     935,    -1,   936,   938,    -1,   936,   502,  1010,   503,   938,
      -1,   922,    -1,   925,    -1,   929,    -1,   935,    -1,  1132,
     921,    -1,  1132,   704,   921,    -1,   502,   968,   503,    -1,
      -1,   262,    -1,   263,    -1,   405,    -1,   119,    -1,   362,
      -1,   220,   923,    -1,   197,   350,    -1,   179,   921,    -1,
     178,   921,    -1,   322,   921,    -1,   122,    -1,   502,  1010,
     503,    -1,    -1,   926,    -1,   927,    -1,   926,    -1,   927,
      -1,   121,   933,   502,   968,   503,    -1,   121,   933,    -1,
     930,    -1,   931,    -1,   930,    -1,   931,    -1,   932,   502,
    1010,   503,   934,    -1,   932,   934,    -1,   134,   933,    -1,
     133,   933,    -1,   458,    -1,   302,   134,   933,    -1,   302,
     133,   933,    -1,   304,   933,    -1,   460,    -1,    -1,   134,
     399,  1131,    -1,    -1,   431,   502,  1010,   503,   937,    -1,
     431,   937,    -1,   430,   502,  1010,   503,   937,    -1,   430,
     937,    -1,   265,    -1,   488,   485,    -1,   470,   430,   485,
      -1,    -1,   483,    -1,   298,    -1,   176,    -1,   240,    -1,
     295,    -1,   939,    -1,   483,   432,   298,    -1,   176,   432,
     240,    -1,   176,   432,   295,    -1,   176,   432,   939,    -1,
     240,   432,   295,    -1,   240,   432,   939,    -1,   295,   432,
     939,    -1,    -1,   390,    -1,   390,   502,  1010,   503,    -1,
     942,    -1,   940,    88,   916,    -1,   940,   113,   430,   485,
     940,    -1,   493,   940,    -1,   494,   940,    -1,   940,   493,
     940,    -1,   940,   494,   940,    -1,   940,   495,   940,    -1,
     940,   496,   940,    -1,   940,   497,   940,    -1,   940,   498,
     940,    -1,   940,   490,   940,    -1,   940,   491,   940,    -1,
     940,   489,   940,    -1,   940,   965,   940,    -1,   965,   940,
      -1,   940,   965,    -1,   940,   105,   940,    -1,   940,   333,
     940,    -1,   314,   940,    -1,   940,   282,   940,    -1,   940,
     282,   940,   206,   940,    -1,   940,   314,   282,   940,    -1,
     940,   314,   282,   940,   206,   940,    -1,   940,   243,   940,
      -1,   940,   243,   940,   206,   940,    -1,   940,   314,   243,
     940,    -1,   940,   314,   243,   940,   206,   940,    -1,   940,
     403,   432,   940,    -1,   940,   403,   432,   940,   206,   940,
      -1,   940,   314,   403,   432,   940,    -1,   940,   314,   403,
     432,   940,   206,   940,    -1,   940,   268,   319,    -1,   940,
     269,    -1,   940,   268,   314,   319,    -1,   940,   317,    -1,
     961,   338,   961,    -1,   940,   268,   438,    -1,   940,   268,
     314,   438,    -1,   940,   268,   216,    -1,   940,   268,   314,
     216,    -1,   940,   268,   447,    -1,   940,   268,   314,   447,
      -1,   940,   268,   193,   227,   940,    -1,   940,   268,   314,
     193,   227,   940,    -1,   940,   268,   324,   502,   971,   503,
      -1,   940,   268,   314,   324,   502,   971,   503,    -1,   940,
     118,   993,   941,   105,   941,    -1,   940,   314,   118,   993,
     941,   105,   941,    -1,   940,   118,   419,   941,   105,   941,
      -1,   940,   314,   118,   419,   941,   105,   941,    -1,   940,
     247,   983,    -1,   940,   314,   247,   983,    -1,   940,   967,
     962,   866,    -1,   940,   967,   962,   502,   940,   503,    -1,
     446,   866,    -1,   940,   268,   195,    -1,   940,   268,   314,
     195,    -1,   942,    -1,   941,    88,   916,    -1,   493,   941,
      -1,   494,   941,    -1,   941,   493,   941,    -1,   941,   494,
     941,    -1,   941,   495,   941,    -1,   941,   496,   941,    -1,
     941,   497,   941,    -1,   941,   498,   941,    -1,   941,   490,
     941,    -1,   941,   491,   941,    -1,   941,   489,   941,    -1,
     941,   965,   941,    -1,   965,   941,    -1,   941,   965,    -1,
     941,   268,   193,   227,   941,    -1,   941,   268,   314,   193,
     227,   941,    -1,   941,   268,   324,   502,   971,   503,    -1,
     941,   268,   314,   324,   502,   971,   503,    -1,   941,   268,
     195,    -1,   941,   268,   314,   195,    -1,   989,    -1,  1009,
      -1,  1148,   992,    -1,   502,   940,   503,   992,    -1,   984,
      -1,   943,    -1,   866,    -1,   212,   866,    -1,   107,   866,
      -1,   107,   972,    -1,   961,    -1,  1008,   502,   503,   954,
      -1,  1008,   502,   969,   503,   954,    -1,  1008,   502,   459,
     970,   503,   954,    -1,  1008,   502,   969,   505,   459,   970,
     503,   954,    -1,  1008,   502,   969,   879,   503,   954,    -1,
    1008,   502,    99,   969,   878,   503,   954,    -1,  1008,   502,
     193,   969,   878,   503,   954,    -1,  1008,   502,   495,   503,
     954,    -1,   166,    -1,   169,    -1,   169,   502,  1010,   503,
      -1,   170,    -1,   170,   502,  1010,   503,    -1,   287,    -1,
     287,   502,  1010,   503,    -1,   288,    -1,   288,   502,  1010,
     503,    -1,   167,    -1,   171,    -1,   398,    -1,   451,    -1,
     165,    -1,   168,    -1,   130,   502,   940,   108,   916,   503,
      -1,   215,   502,   974,   503,    -1,   339,   502,   976,   503,
      -1,   348,   502,   978,   503,    -1,   417,   502,   979,   503,
      -1,   435,   502,   940,   108,   916,   503,    -1,   437,   502,
     123,   982,   503,    -1,   437,   502,   278,   982,   503,    -1,
     437,   502,   433,   982,   503,    -1,   437,   502,   982,   503,
      -1,   320,   502,   940,   505,   940,   503,    -1,   141,   502,
     968,   503,    -1,   234,   502,   968,   503,    -1,   279,   502,
     968,   503,    -1,   476,   502,   968,   503,    -1,   477,   502,
     300,  1133,   503,    -1,   477,   502,   300,  1133,   505,   946,
     503,    -1,   477,   502,   300,  1133,   505,   968,   503,    -1,
     477,   502,   300,  1133,   505,   946,   505,   968,   503,    -1,
     478,   502,   947,   503,    -1,   479,   502,   949,   940,   950,
     503,    -1,   480,   502,   300,  1133,   503,    -1,   480,   502,
     300,  1133,   505,   940,   503,    -1,   481,   502,   940,   505,
     944,   945,   503,    -1,   482,   502,   949,   940,   108,   918,
     503,    -1,   462,   940,    -1,   462,   306,   456,    -1,   505,
     408,   484,    -1,   505,   408,   306,    -1,   505,   408,   306,
     456,    -1,    -1,   475,   502,   947,   503,    -1,   948,    -1,
     947,   505,   948,    -1,   940,   108,  1133,    -1,   940,    -1,
     195,    -1,   153,    -1,   351,   467,    -1,   416,   467,    -1,
      -1,   468,   952,    -1,    -1,   953,    -1,   952,   505,   953,
      -1,  1131,   108,   955,    -1,   337,   955,    -1,   337,  1131,
      -1,    -1,   502,   956,   957,   878,   958,   503,    -1,  1131,
      -1,    -1,   344,   124,   968,    -1,    -1,   360,   959,    -1,
     384,   959,    -1,    -1,   960,    -1,   118,   960,   105,   960,
      -1,   442,   349,    -1,   442,   221,    -1,   164,   383,    -1,
     940,   349,    -1,   940,   221,    -1,   383,   502,   968,   503,
      -1,   383,   502,   503,    -1,   502,   968,   505,   940,   503,
      -1,   106,    -1,   406,    -1,    99,    -1,    85,    -1,   964,
      -1,   493,    -1,   494,    -1,   495,    -1,   496,    -1,   497,
      -1,   498,    -1,   490,    -1,   491,    -1,   489,    -1,    85,
      -1,   330,   502,   770,   503,    -1,   963,    -1,   330,   502,
     770,   503,    -1,   963,    -1,   330,   502,   770,   503,    -1,
     282,    -1,   314,   282,    -1,   243,    -1,   314,   243,    -1,
     940,    -1,   968,   505,   940,    -1,   970,    -1,   969,   505,
     970,    -1,   940,    -1,   752,    90,   940,    -1,   916,    -1,
     971,   505,   916,    -1,   500,   968,   501,    -1,   500,   973,
     501,    -1,   500,   501,    -1,   972,    -1,   973,   505,   972,
      -1,   975,   227,   940,    -1,    -1,  1153,    -1,   483,    -1,
     298,    -1,   176,    -1,   240,    -1,   295,    -1,   390,    -1,
    1151,    -1,   940,   977,   980,   981,    -1,   940,   977,   980,
      -1,   346,   940,    -1,   941,   247,   941,    -1,    -1,   940,
     980,   981,    -1,   940,   981,   980,    -1,   940,   980,    -1,
     940,   981,    -1,   968,    -1,    -1,   227,   940,    -1,   222,
     940,    -1,   940,   227,   968,    -1,   227,   968,    -1,   968,
      -1,   866,    -1,   502,   968,   503,    -1,   129,   988,   985,
     987,   204,    -1,   986,    -1,   985,   986,    -1,   465,   940,
     429,   940,    -1,   200,   940,    -1,    -1,   940,    -1,    -1,
    1131,    -1,  1131,   991,    -1,   504,  1005,    -1,   504,   495,
      -1,   500,   940,   501,    -1,   500,   940,   507,   940,   501,
      -1,   990,    -1,   991,   990,    -1,    -1,   992,   990,    -1,
     112,    -1,    -1,   940,    -1,   181,    -1,   994,    -1,   995,
     505,   994,    -1,   502,   995,   503,    -1,   998,    -1,   997,
     505,   998,    -1,   940,   108,  1133,    -1,   940,  1153,    -1,
     940,    -1,   495,    -1,  1000,    -1,   999,   505,  1000,    -1,
    1131,    -1,  1131,   991,    -1,  1002,    -1,  1001,   505,  1002,
      -1,  1131,    -1,  1131,    -1,  1131,    -1,  1133,    -1,  1131,
      -1,  1151,    -1,  1132,    -1,  1131,   991,    -1,  1010,    -1,
    1150,    -1,  1151,    -1,  1149,    -1,    84,    -1,  1008,  1151,
      -1,  1008,   502,   969,   503,  1151,    -1,   919,  1151,    -1,
     936,  1151,   938,    -1,   936,   502,  1010,   503,  1151,   938,
      -1,   438,    -1,   216,    -1,   319,    -1,  1145,    -1,  1143,
      -1,    86,    -1,  1131,    -1,  1010,    -1,  1145,    -1,   493,
    1010,    -1,   494,  1010,    -1,  1010,    -1,  1013,   505,  1010,
      -1,    91,    -1,    92,    -1,    93,    -1,    94,    -1,    95,
      -1,    96,    -1,    97,    -1,    98,    -1,   100,    -1,   101,
      -1,   102,    -1,   110,    -1,   111,    -1,   113,    -1,   115,
      -1,   116,    -1,   117,    -1,   124,    -1,   125,    -1,   126,
      -1,   127,    -1,   128,    -1,   131,    -1,   132,    -1,   135,
      -1,   137,    -1,   138,    -1,   139,    -1,   140,    -1,   144,
      -1,   145,    -1,   146,    -1,   147,    -1,   149,    -1,   152,
      -1,   153,    -1,   154,    -1,   155,    -1,   156,    -1,   157,
      -1,   159,    -1,   160,    -1,   161,    -1,   163,    -1,   172,
      -1,   173,    -1,   174,    -1,   175,    -1,   177,    -1,   180,
      -1,   182,    -1,   184,    -1,   185,    -1,   186,    -1,   187,
      -1,   188,    -1,   190,    -1,   191,    -1,   192,    -1,   195,
      -1,   196,    -1,   197,    -1,   198,    -1,   199,    -1,   201,
      -1,   202,    -1,   203,    -1,   205,    -1,   206,    -1,   208,
      -1,   209,    -1,   210,    -1,   211,    -1,   213,    -1,   214,
      -1,   217,    -1,   219,    -1,   221,    -1,   223,    -1,   225,
      -1,   229,    -1,   230,    -1,   231,    -1,   233,    -1,   236,
      -1,   238,    -1,   239,    -1,   241,    -1,   242,    -1,   244,
      -1,   245,    -1,   246,    -1,   248,    -1,   249,    -1,   250,
      -1,   251,    -1,   252,    -1,   253,    -1,   255,    -1,   259,
      -1,   260,    -1,   261,    -1,   267,    -1,   270,    -1,   272,
      -1,   273,    -1,   274,    -1,   275,    -1,   276,    -1,   277,
      -1,   281,    -1,   284,    -1,   285,    -1,   286,    -1,   289,
      -1,   290,    -1,   291,    -1,   292,    -1,   293,    -1,   294,
      -1,   296,    -1,   297,    -1,   299,    -1,   300,    -1,   301,
      -1,   305,    -1,   306,    -1,   307,    -1,   308,    -1,   309,
      -1,   310,    -1,   311,    -1,   313,    -1,   315,    -1,   316,
      -1,   318,    -1,   321,    -1,   323,    -1,   324,    -1,   327,
      -1,   330,    -1,   331,    -1,   332,    -1,   340,    -1,   341,
      -1,   342,    -1,   343,    -1,   344,    -1,   345,    -1,   347,
      -1,   349,    -1,   352,    -1,   353,    -1,   351,    -1,   355,
      -1,   356,    -1,   357,    -1,   358,    -1,   359,    -1,   360,
      -1,   361,    -1,   363,    -1,   364,    -1,   365,    -1,   367,
      -1,   368,    -1,   369,    -1,   370,    -1,   371,    -1,   372,
      -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,   378,
      -1,   379,    -1,   381,    -1,   382,    -1,   384,    -1,   385,
      -1,   386,    -1,   387,    -1,   388,    -1,   389,    -1,   391,
      -1,   393,    -1,   394,    -1,   395,    -1,   396,    -1,   397,
      -1,   399,    -1,   401,    -1,   402,    -1,   404,    -1,   407,
      -1,   408,    -1,   409,    -1,   410,    -1,   411,    -1,   412,
      -1,   413,    -1,   414,    -1,   415,    -1,   416,    -1,   418,
      -1,   420,    -1,   421,    -1,   423,    -1,   424,    -1,   425,
      -1,   426,    -1,   427,    -1,   428,    -1,   434,    -1,   436,
      -1,   439,    -1,   440,    -1,   441,    -1,   442,    -1,   443,
      -1,   444,    -1,   447,    -1,   448,    -1,   449,    -1,   450,
      -1,   453,    -1,   454,    -1,   455,    -1,   456,    -1,   460,
      -1,   462,    -1,   463,    -1,   464,    -1,   467,    -1,   470,
      -1,   471,    -1,   472,    -1,   473,    -1,   474,    -1,   484,
      -1,   485,    -1,   118,    -1,   119,    -1,   121,    -1,   122,
      -1,   134,    -1,   141,    -1,   178,    -1,   179,    -1,   212,
      -1,   215,    -1,   220,    -1,   234,    -1,   257,    -1,   263,
      -1,   265,    -1,   279,    -1,   302,    -1,   304,    -1,   312,
      -1,   320,    -1,   322,    -1,   335,    -1,   339,    -1,   348,
      -1,   350,    -1,   362,    -1,   383,    -1,   400,    -1,   405,
      -1,   417,    -1,   430,    -1,   431,    -1,   435,    -1,   437,
      -1,   458,    -1,   475,    -1,   476,    -1,   477,    -1,   478,
      -1,   479,    -1,   480,    -1,   481,    -1,   482,    -1,   114,
      -1,   120,    -1,   148,    -1,   162,    -1,   168,    -1,   226,
      -1,   228,    -1,   243,    -1,   256,    -1,   268,    -1,   269,
      -1,   271,    -1,   280,    -1,   282,    -1,   303,    -1,   317,
      -1,   336,    -1,   337,    -1,   338,    -1,   380,    -1,   403,
      -1,   461,    -1,    99,    -1,   103,    -1,   104,    -1,   105,
      -1,   106,    -1,   107,    -1,   108,    -1,   109,    -1,   112,
      -1,   123,    -1,   129,    -1,   130,    -1,   136,    -1,   142,
      -1,   143,    -1,   151,    -1,   158,    -1,   165,    -1,   166,
      -1,   167,    -1,   169,    -1,   170,    -1,   171,    -1,   181,
      -1,   183,    -1,   189,    -1,   193,    -1,   194,    -1,   200,
      -1,   204,    -1,   207,    -1,   216,    -1,   218,    -1,   222,
      -1,   224,    -1,   227,    -1,   232,    -1,   235,    -1,   237,
      -1,   247,    -1,   254,    -1,   264,    -1,   266,    -1,   278,
      -1,   283,    -1,   287,    -1,   288,    -1,   314,    -1,   319,
      -1,   325,    -1,   326,    -1,   328,    -1,   329,    -1,   333,
      -1,   334,    -1,   346,    -1,   354,    -1,   366,    -1,   377,
      -1,   392,    -1,   398,    -1,   406,    -1,   419,    -1,   422,
      -1,   429,    -1,   433,    -1,   438,    -1,   446,    -1,   451,
      -1,   452,    -1,   459,    -1,   465,    -1,   466,    -1,   468,
      -1,   469,    -1,    -1,  1018,  1019,    -1,  1140,  1022,   512,
     506,    -1,  1140,   512,   506,    -1,  1140,  1042,    -1,  1047,
      -1,  1159,    -1,    73,    -1,   508,    -1,   509,    -1,    -1,
     158,   580,   422,   614,   108,  1021,   865,   618,    -1,   113,
    1083,    -1,     9,   432,  1024,  1031,  1032,    -1,     9,   432,
     181,    -1,     9,  1033,    -1,   175,  1024,    -1,  1025,  1028,
    1030,    -1,  1026,   507,  1027,  1030,   496,  1025,  1036,    -1,
    1035,    -1,  1151,    -1,  1003,    -1,    -1,  1153,  1147,    -1,
      85,  1029,    -1,  1027,    -1,    -1,  1131,    -1,  1131,   504,
    1029,    -1,    74,    -1,   507,  1010,    -1,    -1,   108,  1083,
      -1,    -1,   451,  1033,    -1,    -1,  1034,    -1,  1034,   496,
    1034,    -1,  1034,    21,   124,  1034,    -1,  1034,   452,  1034,
      -1,  1011,    -1,  1151,    -1,  1145,    -1,  1147,    -1,    85,
    1037,    -1,    -1,  1131,  1038,    -1,  1131,  1038,    85,  1037,
      -1,    -1,   489,  1010,    -1,   489,  1153,    -1,   489,  1145,
      -1,  1002,    -1,  1035,    -1,   180,   862,   863,   172,   864,
     222,  1039,    -1,   211,   244,  1084,    -1,  1043,    -1,  1054,
      -1,  1056,    -1,   625,    -1,   505,   625,    -1,    -1,   938,
      -1,   483,   432,   295,    -1,   483,   432,   390,    -1,   176,
     432,   176,    -1,   298,   432,   298,    -1,    -1,  1049,  1048,
    1051,  1050,    -1,  1140,   117,   180,    34,   506,    -1,  1140,
     204,   180,    34,   506,    -1,    -1,  1052,    -1,  1043,    -1,
      73,    -1,  1052,  1043,    -1,  1052,    73,    -1,  1056,    -1,
    1053,  1056,    -1,    -1,    70,  1055,  1063,  1079,  1135,   917,
     506,    -1,    -1,  1060,  1063,  1057,  1076,   506,    -1,    -1,
    1063,  1058,  1076,   506,    -1,  1066,   506,    -1,   507,  1010,
      -1,    -1,  1061,  1062,    -1,  1061,    -1,  1062,    -1,    56,
      -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,    69,
      -1,  1072,    -1,  1068,    -1,  1064,    -1,  1135,   502,  1044,
    1045,   503,    -1,  1135,  1046,    -1,  1070,    -1,   205,  1129,
    1065,    -1,   205,  1065,    -1,   205,  1129,    -1,   508,  1157,
     509,    -1,    -1,  1070,  1067,   508,  1053,   509,    -1,  1066,
      -1,    -1,  1071,  1069,   508,  1053,   509,    -1,    43,  1129,
      -1,   445,  1129,    -1,    43,    -1,   445,    -1,  1073,    -1,
    1075,  1074,    -1,    44,    35,    -1,    44,    35,   262,    -1,
      44,    -1,    44,   262,    -1,    44,    25,    -1,    44,    25,
     262,    -1,    44,    25,    25,    -1,    44,    25,    25,   262,
      -1,    44,   133,    -1,    35,    -1,    35,   262,    -1,   262,
      -1,    25,    -1,    25,   262,    -1,    25,    25,    -1,    25,
      25,   262,    -1,     5,    -1,   133,    -1,   197,    -1,    36,
      -1,    -1,  1077,    -1,  1076,   505,  1077,    -1,  1079,  1134,
     917,  1059,  1078,    -1,    -1,   489,  1158,    -1,    -1,   495,
      -1,   495,   495,    -1,   180,   410,  1153,    -1,    15,  1082,
      -1,  1083,    -1,   164,    -1,    99,    -1,    -1,  1003,    -1,
     181,    -1,  1035,    -1,  1035,    -1,    71,    -1,    17,   862,
      -1,    17,    99,    -1,    28,   862,  1087,    -1,    -1,  1088,
      -1,   452,  1092,    -1,  1089,    -1,   452,    37,    14,  1154,
      -1,   452,    14,  1002,    -1,   266,    37,    14,  1154,    -1,
     266,    14,  1002,    -1,   266,  1002,    -1,  1093,    -1,  1093,
     505,  1092,    -1,  1094,    -1,  1145,    -1,  1143,    -1,  1010,
      -1,   493,  1010,    -1,   494,  1010,    -1,  1150,    -1,   493,
    1150,    -1,   494,  1150,    -1,  1151,    -1,  1149,    -1,  1152,
      -1,    13,   258,  1039,  1089,    -1,    13,  1096,  1039,  1089,
      -1,    13,  1096,  1039,  1090,    -1,    13,   258,  1039,  1091,
      -1,    13,  1096,  1039,  1091,    -1,    29,    -1,    -1,     3,
      14,  1154,    -1,   177,    14,  1154,    -1,    18,    14,  1154,
    1100,    -1,  1101,    -1,  1100,   505,  1101,    -1,  1147,   489,
    1106,    -1,   399,    14,  1154,  1103,    -1,  1104,    -1,  1103,
     505,  1104,    -1,  1106,   489,  1105,    -1,  1010,    -1,  1147,
      -1,    10,    -1,    18,    14,  1154,   456,  1105,  1108,    -1,
    1109,    -1,  1108,   505,  1109,    -1,  1147,   489,  1114,    -1,
     399,    14,  1154,   456,  1105,  1111,    -1,  1112,    -1,  1111,
     505,  1112,    -1,  1114,   489,  1113,    -1,  1150,    -1,  1105,
      -1,   494,  1150,    -1,   494,  1010,    -1,  1151,    -1,     8,
      -1,   174,    -1,    11,    -1,    12,    -1,    22,    -1,    23,
      -1,    24,    -1,   300,    -1,    26,    -1,    27,    -1,   350,
      -1,    31,    -1,    32,    -1,    33,    -1,   441,    -1,   399,
       4,   489,  1116,    -1,   399,     4,   432,  1116,    -1,   328,
      -1,   325,    -1,   399,   150,   432,  1083,    -1,   399,   150,
     489,  1083,    -1,   399,   150,  1083,    -1,    -1,   441,  1119,
    1135,   268,  1063,   917,  1120,    -1,    30,    -1,    -1,    -1,
      45,  1122,  1133,   268,  1063,   917,  1120,    -1,    46,    38,
    1124,    -1,    46,   314,    16,  1124,    -1,    46,    40,  1124,
      -1,   154,    -1,    39,    -1,    42,    -1,    20,  1002,    -1,
      19,   432,  1002,    -1,   194,  1002,   502,  1141,   503,    -1,
     194,     6,    -1,     7,  1002,   502,  1141,   503,    -1,     7,
    1002,    -1,  1126,    -1,  1127,    -1,     6,    -1,     7,    -1,
       8,    -1,    10,    -1,    11,    -1,    12,    -1,    16,    -1,
      19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,
      24,    -1,    26,    -1,    27,    -1,    31,    -1,    32,    -1,
      33,    -1,    34,    -1,    37,    -1,    38,    -1,    39,    -1,
      40,    -1,    42,    -1,     9,    -1,    13,    -1,    15,    -1,
      28,    -1,    45,    -1,    46,    -1,     5,    -1,    25,    -1,
      29,    -1,    35,    -1,    43,    -1,    36,    -1,    44,    -1,
    1133,    -1,  1153,    -1,  1014,    -1,  1015,    -1,  1138,    -1,
    1125,    -1,  1136,    -1,   133,    -1,   457,    -1,  1153,    -1,
    1137,    -1,  1015,    -1,  1125,    -1,  1136,    -1,   133,    -1,
     457,    -1,  1153,    -1,  1137,    -1,  1016,    -1,  1125,    -1,
    1136,    -1,  1128,    -1,  1134,    -1,  1128,    -1,   133,    -1,
     164,    -1,   258,    -1,   262,    -1,   432,    -1,   445,    -1,
     457,    -1,  1136,    -1,  1138,    -1,  1135,    -1,  1014,    -1,
    1017,    -1,  1127,    -1,   150,    -1,  1153,    -1,  1015,    -1,
    1016,    -1,  1126,    -1,    50,    -1,    51,    -1,    56,    -1,
      65,    -1,    67,    -1,    70,    -1,    69,    -1,  1014,    -1,
    1138,    -1,   150,    -1,   176,    -1,   240,    -1,   295,    -1,
     298,    -1,   390,    -1,   483,    -1,  1142,    -1,  1139,   505,
    1142,    -1,    41,    -1,    -1,  1157,    -1,  1147,  1146,    -1,
    1147,    -1,  1147,  1146,    -1,  1035,    -1,  1147,    -1,  1147,
      -1,    22,  1147,    -1,    22,  1002,    -1,    72,    -1,    87,
      -1,    83,    -1,    81,    -1,    82,    -1,    76,    -1,    77,
      -1,    78,    -1,    75,    -1,    84,    -1,    80,    -1,    71,
      -1,    79,    -1,  1002,    -1,  1035,    -1,  1160,    -1,   502,
     503,    -1,   502,  1156,   503,    -1,  1155,    -1,  1156,  1155,
      -1,  1158,    -1,  1157,   505,  1158,    -1,  1156,    -1,   508,
    1157,   509,    -1,  1160,    -1,   502,    -1,   503,    -1,   505,
      -1,   506,    -1,  1153,    -1,  1010,    -1,  1150,    -1,  1151,
      -1,   495,    -1,   493,    -1,   494,    -1,   496,    -1,   497,
      -1,   319,    -1,    47,    -1,    48,    -1,    49,    -1,    50,
      -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,    59,
      -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,
      -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,    69,
      -1,     5,    -1,   205,    -1,   240,    -1,   262,    -1,    25,
      -1,   295,    -1,   298,    -1,   390,    -1,    35,    -1,    36,
      -1,    43,    -1,    44,    -1,   483,    -1,   133,    -1,   220,
      -1,   432,    -1,   445,    -1,   458,    -1,   500,    -1,   501,
      -1,   489,    -1,   507,    -1,   177,  1039,    -1,   177,   352,
    1039,    -1,   177,    99,    -1,   177,   352,    99,    -1,  1010,
      -1,   502,  1162,   503,    -1,  1162,   493,  1162,    -1,  1162,
     494,  1162,    -1,  1162,   495,  1162,    -1,  1162,   496,  1162,
      -1,  1162,   497,  1162,    -1,  1151,    -1,  1131,    -1,    -1,
    1088,  1164,    -1,  1164,  1088,    -1,  1088,    -1,  1164,    -1,
     266,  1139,    -1,  1090,    -1,  1164,    -1,  1089,    -1,    -1,
    1165,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1340,  1340,  1343,  1345,  1347,  1349,  1351,  1353,  1355,
    1357,  1359,  1361,  1363,  1365,  1367,  1369,  1371,  1373,  1375,
    1377,  1379,  1381,  1383,  1385,  1403,  1405,  1407,  1409,  1411,
    1413,  1415,  1417,  1419,  1421,  1423,  1425,  1427,  1429,  1431,
    1433,  1435,  1437,  1439,  1441,  1443,  1445,  1447,  1449,  1451,
    1453,  1455,  1462,  1464,  1466,  1468,  1470,  1472,  1474,  1476,
    1478,  1480,  1482,  1484,  1486,  1488,  1490,  1492,  1494,  1496,
    1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,
    1518,  1520,  1522,  1524,  1526,  1528,  1535,  1537,  1539,  1541,
    1543,  1545,  1547,  1549,  1551,  1553,  1555,  1561,  1563,  1565,
    1567,  1569,  1571,  1573,  1575,  1577,  1583,  1593,  1597,  1605,
    1609,  1619,  1629,  1630,  1644,  1651,  1657,  1668,  1674,  1683,
    1690,  1696,  1705,  1712,  1720,  1725,  1733,  1738,  1744,  1749,
    1755,  1760,  1766,  1770,  1774,  1778,  1782,  1786,  1790,  1794,
    1798,  1802,  1806,  1810,  1814,  1818,  1822,  1826,  1830,  1834,
    1838,  1846,  1850,  1854,  1858,  1862,  1866,  1874,  1882,  1891,
    1893,  1901,  1909,  1917,  1925,  1929,  1937,  1941,  1949,  1957,
    1965,  1969,  1977,  1981,  1989,  1993,  2001,  2006,  2012,  2017,
    2023,  2027,  2031,  2035,  2039,  2043,  2051,  2055,  2059,  2067,
    2071,  2075,  2079,  2083,  2087,  2091,  2095,  2099,  2104,  2108,
    2112,  2116,  2120,  2124,  2132,  2136,  2144,  2148,  2156,  2160,
    2164,  2178,  2182,  2186,  2190,  2198,  2202,  2206,  2210,  2218,
    2222,  2226,  2230,  2234,  2238,  2242,  2250,  2254,  2259,  2265,
    2269,  2277,  2281,  2285,  2289,  2293,  2301,  2305,  2313,  2317,
    2321,  2325,  2329,  2338,  2346,  2350,  2358,  2362,  2370,  2378,
    2382,  2386,  2390,  2398,  2402,  2406,  2410,  2418,  2422,  2430,
    2434,  2438,  2442,  2446,  2450,  2454,  2458,  2462,  2466,  2470,
    2474,  2478,  2482,  2486,  2490,  2494,  2498,  2502,  2506,  2510,
    2514,  2518,  2522,  2526,  2530,  2534,  2538,  2542,  2546,  2550,
    2554,  2558,  2562,  2566,  2570,  2574,  2582,  2586,  2594,  2598,
    2603,  2609,  2614,  2620,  2628,  2633,  2639,  2643,  2651,  2655,
    2659,  2663,  2671,  2676,  2684,  2695,  2706,  2710,  2718,  2722,
    2726,  2734,  2738,  2746,  2751,  2757,  2761,  2765,  2769,  2773,
    2777,  2781,  2785,  2789,  2793,  2797,  2805,  2810,  2816,  2821,
    2827,  2832,  2838,  2843,  2849,  2853,  2861,  2869,  2873,  2877,
    2881,  2885,  2890,  2896,  2900,  2908,  2912,  2920,  2924,  2932,
    2936,  2940,  2944,  2948,  2952,  2957,  2963,  2968,  2974,  2979,
    2985,  2989,  2997,  3001,  3009,  3013,  3017,  3025,  3029,  3037,
    3045,  3053,  3058,  3064,  3068,  3072,  3080,  3084,  3088,  3092,
    3096,  3100,  3104,  3112,  3116,  3120,  3124,  3132,  3140,  3144,
    3149,  3155,  3159,  3163,  3167,  3171,  3175,  3183,  3187,  3195,
    3200,  3204,  3208,  3212,  3220,  3225,  3231,  3235,  3243,  3251,
    3255,  3260,  3265,  3271,  3275,  3283,  3287,  3295,  3300,  3306,
    3310,  3314,  3318,  3323,  3329,  3337,  3345,  3349,  3353,  3357,
    3361,  3369,  3374,  3380,  3384,  3388,  3393,  3399,  3403,  3407,
    3412,  3418,  3423,  3429,  3434,  3440,  3448,  3453,  3459,  3463,
    3471,  3479,  3483,  3488,  3494,  3502,  3510,  3515,  3521,  3525,
    3533,  3537,  3541,  3545,  3549,  3553,  3557,  3561,  3565,  3569,
    3573,  3577,  3585,  3590,  3596,  3600,  3604,  3612,  3616,  3624,
    3629,  3635,  3639,  3647,  3652,  3658,  3662,  3670,  3675,  3681,
    3685,  3693,  3698,  3704,  3712,  3717,  3723,  3727,  3735,  3743,
    3747,  3755,  3759,  3763,  3771,  3776,  3782,  3786,  3794,  3802,
    3806,  3814,  3818,  3822,  3826,  3834,  3842,  3850,  3858,  3866,
    3871,  3877,  3881,  3889,  3894,  3900,  3904,  3912,  3916,  3920,
    3928,  3936,  3940,  3944,  3952,  3956,  3964,  3972,  3976,  3984,
    3988,  3996,  4000,  4008,  4012,  4016,  4020,  4024,  4032,  4037,
    4043,  4048,  4054,  4058,  4066,  4071,  4077,  4081,  4086,  4092,
    4096,  4100,  4104,  4108,  4112,  4120,  4125,  4131,  4135,  4142,
    4146,  4154,  4160,  4164,  4172,  4176,  4184,  4188,  4196,  4205,
    4214,  4218,  4222,  4226,  4230,  4234,  4238,  4242,  4246,  4250,
    4254,  4262,  4270,  4274,  4282,  4286,  4294,  4298,  4302,  4306,
    4310,  4318,  4322,  4330,  4338,  4342,  4350,  4358,  4363,  4369,
    4373,  4381,  4389,  4393,  4401,  4405,  4409,  4413,  4417,  4425,
    4430,  4436,  4441,  4447,  4453,  4459,  4467,  4471,  4479,  4483,
    4491,  4495,  4503,  4507,  4515,  4519,  4527,  4535,  4543,  4547,
    4555,  4559,  4563,  4567,  4571,  4575,  4579,  4583,  4587,  4591,
    4595,  4599,  4607,  4611,  4619,  4623,  4631,  4635,  4643,  4651,
    4655,  4660,  4666,  4670,  4674,  4678,  4682,  4686,  4690,  4694,
    4698,  4702,  4706,  4710,  4714,  4718,  4722,  4726,  4730,  4738,
    4742,  4746,  4750,  4754,  4758,  4762,  4766,  4770,  4774,  4778,
    4782,  4790,  4794,  4802,  4806,  4810,  4814,  4820,  4826,  4832,
    4838,  4844,  4850,  4856,  4866,  4877,  4888,  4899,  4910,  4921,
    4932,  4948,  4964,  4980,  4991,  5007,  5018,  5034,  5049,  5053,
    5061,  5066,  5072,  5080,  5084,  5092,  5096,  5100,  5104,  5108,
    5116,  5120,  5128,  5132,  5136,  5140,  5148,  5152,  5156,  5160,
    5164,  5168,  5172,  5176,  5180,  5184,  5188,  5192,  5196,  5200,
    5208,  5212,  5220,  5224,  5232,  5237,  5243,  5247,  5255,  5263,
    5271,  5275,  5283,  5288,  5294,  5299,  5305,  5313,  5318,  5324,
    5328,  5332,  5340,  5344,  5348,  5356,  5360,  5364,  5372,  5380,
    5385,  5391,  5396,  5402,  5407,  5413,  5418,  5424,  5428,  5436,
    5440,  5444,  5452,  5456,  5461,  5467,  5471,  5476,  5482,  5486,
    5491,  5497,  5501,  5505,  5513,  5518,  5524,  5528,  5536,  5540,
    5548,  5552,  5560,  5564,  5572,  5576,  5580,  5584,  5588,  5596,
    5600,  5604,  5608,  5612,  5620,  5628,  5636,  5640,  5644,  5652,
    5656,  5660,  5668,  5672,  5680,  5684,  5688,  5692,  5696,  5700,
    5704,  5708,  5712,  5716,  5720,  5724,  5728,  5736,  5740,  5744,
    5748,  5756,  5760,  5768,  5773,  5779,  5787,  5791,  5799,  5807,
    5811,  5819,  5824,  5830,  5834,  5842,  5846,  5854,  5858,  5866,
    5870,  5874,  5878,  5886,  5890,  5898,  5906,  5910,  5918,  5922,
    5930,  5934,  5938,  5946,  5950,  5955,  5961,  5969,  5974,  5980,
    5984,  5988,  5996,  6000,  6008,  6013,  6019,  6023,  6027,  6031,
    6035,  6039,  6043,  6047,  6051,  6055,  6059,  6063,  6067,  6071,
    6075,  6079,  6083,  6087,  6091,  6095,  6099,  6103,  6107,  6111,
    6115,  6123,  6128,  6134,  6139,  6145,  6149,  6153,  6157,  6161,
    6165,  6169,  6177,  6181,  6185,  6189,  6193,  6197,  6201,  6205,
    6209,  6213,  6217,  6221,  6225,  6229,  6233,  6237,  6241,  6249,
    6257,  6261,  6265,  6273,  6277,  6285,  6289,  6293,  6297,  6301,
    6309,  6314,  6320,  6324,  6328,  6332,  6340,  6344,  6349,  6355,
    6359,  6367,  6375,  6380,  6386,  6394,  6398,  6406,  6410,  6414,
    6418,  6422,  6426,  6430,  6434,  6438,  6442,  6446,  6450,  6454,
    6458,  6466,  6470,  6475,  6481,  6485,  6489,  6497,  6501,  6505,
    6513,  6518,  6524,  6528,  6536,  6541,  6546,  6552,  6558,  6566,
    6574,  6579,  6585,  6589,  6593,  6597,  6601,  6605,  6609,  6613,
    6617,  6621,  6625,  6629,  6633,  6637,  6641,  6645,  6653,  6658,
    6664,  6668,  6676,  6684,  6689,  6695,  6703,  6707,  6715,  6723,
    6727,  6731,  6735,  6739,  6747,  6752,  6758,  6766,  6770,  6774,
    6778,  6782,  6786,  6794,  6802,  6806,  6810,  6818,  6823,  6829,
    6833,  6837,  6841,  6845,  6853,  6857,  6865,  6869,  6873,  6877,
    6885,  6889,  6897,  6901,  6909,  6914,  6920,  6925,  6931,  6936,
    6942,  6947,  6953,  6957,  6961,  6965,  6973,  6977,  6981,  6985,
    6989,  6993,  6997,  7005,  7009,  7017,  7025,  7029,  7033,  7041,
    7045,  7049,  7054,  7060,  7066,  7076,  7081,  7087,  7091,  7095,
    7099,  7107,  7109,  7117,  7122,  7128,  7136,  7140,  7144,  7152,
    7156,  7164,  7172,  7177,  7183,  7191,  7196,  7202,  7210,  7215,
    7221,  7225,  7229,  7233,  7237,  7241,  7245,  7249,  7257,  7262,
    7268,  7276,  7280,  7288,  7292,  7300,  7308,  7316,  7324,  7328,
    7336,  7388,  7392,  7405,  7407,  7411,  7415,  7419,  7428,  7434,
    7438,  7446,  7450,  7458,  7462,  7470,  7474,  7478,  7482,  7486,
    7490,  7494,  7498,  7506,  7510,  7518,  7522,  7526,  7530,  7534,
    7538,  7546,  7550,  7558,  7562,  7570,  7578,  7583,  7585,  7591,
    7595,  7599,  7603,  7607,  7611,  7615,  7619,  7627,  7632,  7638,
    7642,  7647,  7653,  7657,  7661,  7666,  7672,  7677,  7683,  7691,
    7695,  7703,  7707,  7715,  7719,  7723,  7727,  7735,  7740,  7746,
    7750,  7755,  7763,  7767,  7775,  7779,  7787,  7795,  7799,  7804,
    7810,  7818,  7822,  7830,  7834,  7842,  7847,  7853,  7858,  7864,
    7868,  7876,  7881,  7887,  7891,  7899,  7903,  7911,  7916,  7922,
    7926,  7934,  7939,  7945,  7949,  7957,  7961,  7965,  7969,  7973,
    7977,  7981,  7985,  7991,  7995,  7999,  8007,  8011,  8015,  8019,
    8023,  8027,  8035,  8039,  8043,  8047,  8055,  8059,  8063,  8067,
    8075,  8080,  8086,  8090,  8098,  8102,  8106,  8110,  8118,  8122,
    8130,  8134,  8138,  8146,  8154,  8159,  8165,  8169,  8174,  8180,
    8184,  8192,  8200,  8202,  8204,  8208,  8212,  8216,  8224,  8234,
    8245,  8254,  8258,  8262,  8266,  8270,  8274,  8278,  8286,  8290,
    8294,  8298,  8306,  8310,  8318,  8323,  8329,  8333,  8337,  8341,
    8345,  8349,  8353,  8357,  8361,  8365,  8369,  8377,  8382,  8388,
    8392,  8400,  8404,  8412,  8420,  8428,  8432,  8440,  8444,  8452,
    8460,  8468,  8472,  8476,  8480,  8484,  8488,  8496,  8501,  8507,
    8512,  8518,  8522,  8526,  8530,  8538,  8546,  8550,  8555,  8561,
    8565,  8569,  8573,  8577,  8581,  8585,  8589,  8593,  8597,  8601,
    8605,  8609,  8614,  8620,  8624,  8632,  8636,  8640,  8644,  8648,
    8652,  8656,  8660,  8664,  8668,  8672,  8676,  8680,  8684,  8688,
    8692,  8696,  8700,  8704,  8708,  8712,  8716,  8720,  8724,  8728,
    8732,  8736,  8740,  8744,  8748,  8752,  8756,  8760,  8764,  8768,
    8772,  8776,  8780,  8784,  8788,  8792,  8796,  8800,  8804,  8808,
    8812,  8816,  8820,  8824,  8828,  8832,  8836,  8840,  8844,  8848,
    8852,  8857,  8861,  8869,  8873,  8877,  8881,  8885,  8889,  8893,
    8897,  8901,  8905,  8909,  8913,  8917,  8921,  8925,  8929,  8933,
    8937,  8941,  8945,  8949,  8953,  8961,  8965,  8969,  8973,  8977,
    8981,  8985,  8989,  8993,  8997,  9001,  9009,  9013,  9017,  9021,
    9025,  9029,  9033,  9037,  9041,  9045,  9049,  9053,  9057,  9061,
    9065,  9069,  9073,  9077,  9081,  9085,  9089,  9093,  9097,  9101,
    9105,  9109,  9113,  9117,  9121,  9125,  9129,  9133,  9137,  9141,
    9145,  9149,  9153,  9157,  9161,  9165,  9169,  9173,  9177,  9181,
    9185,  9189,  9193,  9197,  9205,  9209,  9217,  9221,  9225,  9230,
    9236,  9244,  9248,  9256,  9260,  9268,  9272,  9280,  9284,  9289,
    9295,  9300,  9306,  9310,  9318,  9326,  9330,  9335,  9341,  9349,
    9353,  9360,  9365,  9371,  9376,  9381,  9387,  9391,  9399,  9403,
    9407,  9411,  9415,  9423,  9427,  9431,  9439,  9443,  9447,  9455,
    9459,  9467,  9471,  9475,  9479,  9483,  9487,  9491,  9495,  9499,
    9507,  9511,  9519,  9523,  9531,  9535,  9539,  9543,  9547,  9551,
    9559,  9563,  9571,  9575,  9583,  9587,  9595,  9599,  9607,  9611,
    9615,  9623,  9627,  9635,  9640,  9646,  9650,  9654,  9658,  9662,
    9666,  9670,  9674,  9682,  9686,  9694,  9702,  9707,  9713,  9717,
    9721,  9725,  9729,  9734,  9740,  9748,  9756,  9760,  9764,  9772,
    9776,  9784,  9792,  9796,  9804,  9812,  9817,  9823,  9828,  9834,
    9838,  9846,  9850,  9854,  9858,  9866,  9870,  9879,  9881,  9889,
    9894,  9900,  9904,  9912,  9916,  9924,  9932,  9936,  9944,  9948,
    9952,  9956,  9964,  9968,  9976,  9980,  9988,  9992, 10000, 10008,
   10016, 10024, 10032, 10040, 10048, 10052, 10060, 10064, 10068, 10072,
   10076, 10080, 10084, 10088, 10092, 10096, 10100, 10104, 10108, 10112,
   10113, 10118, 10124, 10132, 10136, 10137, 10141, 10149, 10153, 10161,
   10165, 10169, 10173, 10177, 10181, 10185, 10189, 10193, 10197, 10201,
   10205, 10209, 10213, 10217, 10221, 10225, 10229, 10233, 10237, 10241,
   10245, 10249, 10253, 10257, 10261, 10265, 10269, 10273, 10277, 10281,
   10285, 10289, 10293, 10297, 10301, 10305, 10309, 10313, 10317, 10321,
   10325, 10329, 10333, 10337, 10341, 10345, 10349, 10353, 10357, 10361,
   10365, 10369, 10373, 10377, 10381, 10385, 10389, 10393, 10397, 10401,
   10405, 10409, 10413, 10417, 10421, 10425, 10429, 10433, 10437, 10441,
   10445, 10449, 10453, 10457, 10461, 10465, 10469, 10473, 10477, 10481,
   10485, 10489, 10493, 10497, 10501, 10505, 10509, 10513, 10517, 10521,
   10525, 10529, 10533, 10537, 10541, 10545, 10549, 10553, 10557, 10561,
   10565, 10569, 10573, 10577, 10581, 10585, 10589, 10593, 10597, 10601,
   10605, 10609, 10613, 10617, 10621, 10625, 10629, 10633, 10637, 10641,
   10645, 10649, 10653, 10657, 10661, 10665, 10669, 10673, 10677, 10681,
   10685, 10689, 10693, 10697, 10701, 10705, 10709, 10713, 10717, 10721,
   10725, 10729, 10733, 10737, 10741, 10745, 10749, 10753, 10757, 10761,
   10765, 10769, 10773, 10777, 10781, 10785, 10789, 10793, 10797, 10801,
   10805, 10809, 10813, 10817, 10821, 10825, 10829, 10833, 10837, 10841,
   10845, 10849, 10853, 10857, 10861, 10865, 10869, 10873, 10877, 10881,
   10885, 10889, 10893, 10897, 10901, 10905, 10909, 10913, 10917, 10921,
   10925, 10929, 10933, 10937, 10941, 10945, 10949, 10953, 10957, 10961,
   10965, 10969, 10973, 10977, 10981, 10985, 10989, 10993, 10997, 11001,
   11005, 11009, 11013, 11017, 11021, 11025, 11029, 11033, 11037, 11041,
   11045, 11049, 11053, 11057, 11061, 11065, 11069, 11073, 11077, 11081,
   11085, 11089, 11093, 11097, 11101, 11105, 11109, 11113, 11117, 11121,
   11129, 11133, 11137, 11141, 11145, 11149, 11153, 11157, 11161, 11165,
   11169, 11173, 11177, 11181, 11185, 11189, 11193, 11197, 11201, 11205,
   11209, 11213, 11217, 11221, 11225, 11229, 11233, 11237, 11241, 11245,
   11249, 11253, 11257, 11261, 11265, 11269, 11273, 11277, 11281, 11285,
   11289, 11293, 11297, 11305, 11309, 11313, 11317, 11321, 11325, 11329,
   11333, 11337, 11341, 11345, 11349, 11353, 11357, 11361, 11365, 11369,
   11373, 11377, 11381, 11385, 11389, 11397, 11401, 11405, 11409, 11413,
   11417, 11421, 11425, 11429, 11433, 11437, 11441, 11445, 11449, 11453,
   11457, 11461, 11465, 11469, 11473, 11477, 11481, 11485, 11489, 11493,
   11497, 11501, 11505, 11509, 11513, 11517, 11521, 11525, 11529, 11533,
   11537, 11541, 11545, 11549, 11553, 11557, 11561, 11565, 11569, 11573,
   11577, 11581, 11585, 11589, 11593, 11597, 11601, 11605, 11609, 11613,
   11617, 11621, 11625, 11629, 11633, 11637, 11641, 11645, 11649, 11653,
   11657, 11661, 11665, 11669, 11673, 11677, 11681, 11685, 11689, 11693,
   11703, 11704, 11707, 11708, 11709, 11715, 11716, 11717, 11718, 11719,
   11732, 11732, 11741, 11757, 11759, 11762, 11764, 11768, 11780, 11796,
   11800, 11811, 11812, 11815, 11827, 11836, 11837, 11840, 11841, 11842,
   11845, 11846, 11849, 11850, 11853, 11854, 11857, 11859, 11861, 11863,
   11867, 11874, 11881, 11897, 11931, 11941, 11944, 11946, 11959, 11960,
   11962, 11964, 11968, 11981, 11988, 12048, 12057, 12059, 12060, 12063,
   12065, 12066, 12069, 12070, 12071, 12072, 12073, 12080, 12079, 12089,
   12091, 12093, 12094, 12097, 12098, 12099, 12100, 12103, 12104, 12108,
   12107, 12124, 12122, 12138, 12137, 12151, 12157, 12158, 12161, 12163,
   12164, 12167, 12168, 12169, 12170, 12173, 12174, 12177, 12185, 12202,
   12210, 12233, 12339, 12373, 12375, 12377, 12381, 12385, 12384, 12435,
   12437, 12436, 12451, 12457, 12464, 12469, 12472, 12473, 12476, 12477,
   12478, 12479, 12480, 12481, 12482, 12490, 12498, 12501, 12502, 12503,
   12504, 12505, 12506, 12514, 12522, 12523, 12524, 12527, 12528, 12531,
   12533, 12537, 12625, 12626, 12633, 12634, 12635, 12641, 12650, 12653,
   12654, 12655, 12656, 12659, 12660, 12661, 12664, 12666, 12674, 12675,
   12681, 12689, 12690, 12693, 12694, 12697, 12702, 12709, 12714, 12721,
   12728, 12728, 12730, 12737, 12738, 12741, 12742, 12743, 12744, 12745,
   12746, 12747, 12748, 12749, 12755, 12762, 12774, 12780, 12787, 12795,
   12796, 12808, 12819, 12830, 12834, 12835, 12838, 12843, 12847, 12848,
   12851, 12857, 12865, 12868, 12875, 12879, 12880, 12883, 12886, 12890,
   12891, 12894, 12900, 12908, 12909, 12918, 12927, 12939, 12940, 12941,
   12942, 12943, 12944, 12945, 12946, 12947, 12948, 12949, 12950, 12951,
   12952, 12953, 12960, 12961, 12964, 12965, 12972, 12973, 12974, 12981,
   12980, 12997, 12998, 13005, 13004, 13074, 13080, 13086, 13094, 13100,
   13106, 13112, 13118, 13124, 13130, 13136, 13142, 13153, 13154, 13157,
   13158, 13159, 13160, 13161, 13162, 13163, 13164, 13165, 13166, 13167,
   13168, 13169, 13170, 13171, 13172, 13173, 13174, 13175, 13176, 13177,
   13178, 13179, 13180, 13183, 13184, 13185, 13186, 13187, 13188, 13192,
   13193, 13194, 13195, 13196, 13197, 13198, 13201, 13204, 13205, 13206,
   13207, 13208, 13209, 13210, 13211, 13224, 13225, 13226, 13227, 13228,
   13229, 13230, 13235, 13236, 13237, 13238, 13239, 13240, 13246, 13247,
   13248, 13249, 13250, 13251, 13252, 13253, 13254, 13255, 13256, 13259,
   13260, 13261, 13262, 13263, 13266, 13267, 13268, 13269, 13272, 13273,
   13274, 13275, 13276, 13277, 13278, 13295, 13296, 13297, 13300, 13301,
   13302, 13303, 13304, 13305, 13309, 13309, 13312, 13318, 13319, 13322,
   13324, 13329, 13339, 13350, 13357, 13358, 13359, 13362, 13395, 13397,
   13399, 13402, 13412, 13422, 13432, 13433, 13436, 13438, 13439, 13440,
   13443, 13445, 13453, 13454, 13455, 13459, 13460, 13464, 13465, 13468,
   13469, 13472, 13473, 13474, 13475, 13476, 13479, 13480, 13481, 13482,
   13483, 13484, 13485, 13486, 13487, 13488, 13489, 13490, 13491, 13492,
   13493, 13494, 13495, 13496, 13497, 13498, 13499, 13500, 13501, 13502,
   13503, 13504, 13505, 13506, 13507, 13508, 13509, 13510, 13511, 13512,
   13513, 13514, 13515, 13516, 13517, 13518, 13519, 13520, 13521, 13522,
   13523, 13524, 13525, 13526, 13527, 13528, 13529, 13530, 13531, 13532,
   13533, 13534, 13537, 13538, 13539, 13540, 13543, 13544, 13545, 13546,
   13547, 13548, 13549, 13550, 13551, 13554, 13555, 13556, 13557, 13558,
   13561, 13562, 13565, 13566, 13577, 13578
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", 
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMENTS", "COMMIT", 
  "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION", 
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P", 
  "COPY", "COST", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", 
  "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", 
  "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", 
  "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", 
  "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", 
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH", 
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", 
  "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", 
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", 
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", 
  "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", 
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", 
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", "MAPPING", "MATCH", 
  "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOCREATEDB", 
  "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", 
  "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", 
  "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", 
  "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", 
  "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT", 
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", 
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "STANDALONE_P", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "STRIP_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", 
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", 
  "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", 
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", 
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", "'>'", 
  "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", 
  "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", "opt_boolean", 
  "zone_value", "opt_encoding", "ColId_or_Sconst", "VariableResetStmt", 
  "SetResetClause", "VariableShowStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "reloptions", "opt_reloptions", "reloption_list", "reloption_elem", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_options", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "copy_generic_opt_list", 
  "copy_generic_opt_elem", "copy_generic_opt_arg", 
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item", 
  "CreateStmt", "OptTemp", "OptTableElementList", 
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList", 
  "TableElement", "TypedTableElement", "columnDef", "columnOptions", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "ExclusionConstraintList", 
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions", 
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith", 
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "CreatePLangStmt", 
  "opt_trusted", "handler_name", "opt_inline_handler", "validator_clause", 
  "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "opt_enum_val_list", "enum_val_list", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_opfamily", "opt_recheck", "CreateOpFamilyStmt", 
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop", 
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt", 
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list", 
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt", 
  "comment_type", "comment_text", "FetchStmt", "fetch_args", "from_in", 
  "opt_from_in", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", 
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption", 
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique", 
  "opt_concurrently", "opt_index_name", "access_method_clause", 
  "index_params", "index_elem", "opt_class", "opt_asc_desc", 
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args", 
  "func_args_list", "func_args_with_defaults", 
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name", 
  "func_return", "func_type", "func_arg_with_default", 
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item", 
  "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "limit_clause", "offset_clause", "select_limit_value", 
  "select_offset_value", "opt_select_fetch_first_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "Iconst_list", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,    61,
      60,    62,   744,    43,    45,    42,    47,    37,    94,   745,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   510,   511,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   513,   514,   514,   515,   515,
     516,   516,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   517,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   518,   518,   518,   518,   518,   518,   519,   520,   521,
     521,   522,   523,   524,   525,   525,   526,   526,   527,   528,
     529,   529,   530,   530,   531,   531,   532,   532,   533,   533,
     534,   534,   534,   534,   534,   534,   535,   535,   535,   536,
     536,   536,   536,   536,   536,   536,   536,   536,   536,   536,
     536,   536,   536,   536,   537,   537,   538,   538,   539,   539,
     539,   540,   540,   540,   540,   541,   541,   541,   541,   542,
     542,   542,   542,   542,   542,   542,   543,   543,   543,   544,
     544,   545,   545,   545,   545,   545,   546,   546,   547,   547,
     547,   547,   547,   548,   549,   549,   550,   550,   551,   552,
     552,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   556,   556,   557,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   565,   566,   566,
     566,   567,   567,   568,   568,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   570,   570,   571,   571,
     572,   572,   573,   573,   574,   574,   575,   576,   576,   576,
     576,   576,   576,   577,   577,   578,   578,   579,   579,   580,
     580,   580,   580,   580,   580,   580,   581,   581,   582,   582,
     583,   583,   584,   584,   585,   585,   585,   586,   586,   587,
     588,   589,   589,   590,   590,   590,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   592,   592,   593,   594,   594,
     594,   595,   595,   595,   595,   595,   595,   596,   596,   597,
     597,   597,   597,   597,   598,   598,   599,   599,   600,   601,
     601,   601,   601,   602,   602,   603,   603,   604,   604,   605,
     605,   605,   605,   605,   606,   607,   608,   608,   608,   608,
     608,   609,   609,   610,   610,   610,   610,   611,   611,   611,
     611,   612,   612,   613,   613,   614,   615,   615,   616,   616,
     617,   618,   618,   618,   619,   620,   621,   621,   622,   622,
     623,   623,   623,   623,   623,   623,   623,   623,   623,   623,
     623,   623,   624,   624,   625,   625,   625,   626,   626,   627,
     627,   628,   628,   629,   629,   630,   630,   631,   631,   632,
     632,   633,   633,   634,   635,   635,   636,   636,   637,   638,
     638,   639,   639,   639,   640,   640,   641,   641,   642,   643,
     643,   644,   644,   644,   644,   645,   646,   647,   648,   649,
     649,   650,   650,   651,   651,   652,   652,   653,   653,   653,
     654,   655,   655,   655,   656,   656,   657,   658,   658,   659,
     659,   660,   660,   661,   661,   661,   661,   661,   662,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   666,   667,
     667,   667,   667,   667,   667,   668,   668,   669,   669,   669,
     669,   669,   670,   670,   671,   671,   672,   672,   673,   674,
     675,   675,   675,   675,   675,   675,   675,   675,   675,   675,
     675,   676,   677,   677,   678,   678,   679,   679,   679,   679,
     679,   680,   680,   681,   682,   682,   683,   684,   684,   685,
     685,   686,   687,   687,   688,   688,   688,   688,   688,   689,
     689,   690,   690,   691,   691,   692,   693,   693,   694,   694,
     695,   695,   696,   696,   697,   697,   698,   699,   700,   700,
     701,   701,   701,   701,   701,   701,   701,   701,   701,   701,
     701,   701,   702,   702,   703,   703,   704,   704,   705,   706,
     706,   706,   707,   707,   707,   707,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   709,   709,   710,   710,   710,   710,   710,   710,   710,
     710,   710,   710,   710,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   711,   711,   711,   712,   712,
     713,   713,   714,   715,   715,   716,   716,   716,   716,   716,
     717,   717,   718,   718,   718,   718,   719,   719,   719,   719,
     719,   719,   719,   719,   719,   719,   719,   719,   719,   719,
     720,   720,   721,   721,   722,   722,   723,   723,   724,   725,
     726,   726,   727,   727,   728,   728,   729,   730,   730,   731,
     731,   731,   732,   732,   732,   733,   733,   733,   734,   735,
     735,   736,   736,   737,   737,   738,   738,   739,   739,   740,
     740,   740,   741,   741,   741,   742,   742,   742,   743,   743,
     743,   744,   744,   744,   745,   745,   746,   746,   747,   747,
     748,   748,   749,   749,   750,   750,   750,   750,   750,   751,
     751,   751,   751,   751,   752,   753,   754,   754,   754,   755,
     755,   755,   756,   756,   757,   757,   757,   757,   757,   757,
     757,   757,   757,   757,   757,   757,   757,   758,   758,   758,
     758,   759,   759,   760,   760,   761,   762,   762,   763,   764,
     764,   765,   765,   766,   766,   767,   767,   768,   768,   769,
     769,   769,   769,   770,   770,   771,   772,   772,   773,   773,
     774,   774,   774,   775,   775,   775,   776,   777,   777,   778,
     778,   778,   779,   779,   780,   780,   781,   781,   781,   781,
     781,   781,   781,   781,   781,   781,   781,   781,   781,   781,
     781,   781,   781,   781,   781,   781,   781,   781,   781,   781,
     781,   782,   782,   783,   783,   784,   784,   784,   784,   784,
     784,   784,   785,   785,   785,   785,   785,   785,   785,   785,
     785,   785,   785,   785,   785,   785,   785,   785,   785,   786,
     787,   787,   787,   788,   788,   789,   789,   789,   789,   789,
     790,   790,   791,   791,   791,   791,   792,   792,   792,   793,
     793,   794,   795,   795,   796,   797,   797,   798,   798,   798,
     798,   798,   798,   798,   798,   798,   798,   798,   798,   798,
     798,   799,   799,   799,   800,   800,   800,   801,   801,   801,
     802,   802,   803,   803,   804,   804,   804,   804,   805,   806,
     807,   807,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   808,   808,   808,   808,   808,   808,   809,   809,
     810,   810,   811,   812,   812,   813,   814,   814,   815,   816,
     816,   816,   816,   816,   817,   817,   818,   819,   819,   819,
     819,   819,   819,   820,   821,   821,   821,   822,   822,   823,
     823,   823,   823,   823,   824,   824,   825,   825,   825,   825,
     826,   826,   827,   827,   828,   828,   829,   829,   830,   830,
     831,   831,   832,   832,   832,   832,   833,   833,   833,   833,
     833,   833,   833,   834,   834,   835,   836,   836,   836,   837,
     837,   837,   837,   838,   838,   839,   839,   840,   840,   840,
     840,   841,   841,   842,   842,   843,   844,   844,   844,   845,
     845,   846,   847,   847,   848,   849,   849,   850,   851,   851,
     852,   852,   852,   852,   852,   852,   852,   852,   853,   853,
     854,   855,   855,   856,   856,   857,   858,   859,   860,   860,
     861,   862,   862,   863,   863,   863,   863,   863,   864,   864,
     864,   865,   865,   866,   866,   867,   867,   867,   867,   867,
     867,   867,   867,   868,   868,   869,   869,   869,   869,   869,
     869,   870,   870,   871,   871,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   874,   875,   875,   876,
     876,   876,   877,   877,   877,   877,   878,   878,   879,   880,
     880,   881,   881,   882,   882,   882,   882,   883,   883,   884,
     884,   884,   885,   885,   886,   886,   887,   888,   888,   888,
     889,   890,   890,   891,   891,   892,   892,   893,   893,   894,
     894,   895,   895,   896,   896,   897,   897,   898,   898,   899,
     899,   900,   900,   901,   901,   902,   902,   902,   902,   902,
     902,   902,   902,   902,   902,   902,   903,   903,   903,   903,
     903,   903,   904,   904,   904,   904,   905,   905,   905,   905,
     906,   906,   907,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   910,   911,   912,   912,   913,   913,   913,   914,
     914,   915,   916,   916,   916,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   918,   918,   918,   918,   919,   919,
     919,   919,   920,   920,   921,   921,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   923,   923,   924,
     924,   925,   925,   926,   927,   928,   928,   929,   929,   930,
     931,   932,   932,   932,   932,   932,   932,   933,   933,   934,
     934,   935,   935,   935,   935,   936,   937,   937,   937,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   939,   939,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   942,   942,   942,   942,   942,
     942,   942,   942,   942,   942,   942,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   944,   944,   945,   945,   945,   945,
     946,   947,   947,   948,   948,   949,   949,   950,   950,   950,
     951,   951,   952,   952,   953,   954,   954,   954,   955,   956,
     956,   957,   957,   958,   958,   958,   959,   959,   960,   960,
     960,   960,   960,   961,   961,   961,   962,   962,   962,   963,
     963,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     965,   965,   966,   966,   967,   967,   967,   967,   967,   967,
     968,   968,   969,   969,   970,   970,   971,   971,   972,   972,
     972,   973,   973,   974,   974,   975,   975,   975,   975,   975,
     975,   975,   975,   976,   976,   977,   978,   978,   979,   979,
     979,   979,   979,   979,   980,   981,   982,   982,   982,   983,
     983,   984,   985,   985,   986,   987,   987,   988,   988,   989,
     989,   990,   990,   990,   990,   991,   991,   992,   992,   993,
     993,   994,   994,   995,   995,   996,   997,   997,   998,   998,
     998,   998,   999,   999,  1000,  1000,  1001,  1001,  1002,  1003,
    1004,  1005,  1006,  1007,  1008,  1008,  1009,  1009,  1009,  1009,
    1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,
    1009,  1010,  1011,  1012,  1012,  1012,  1012,  1013,  1013,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1018,  1018,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1021,  1020,  1022,  1023,  1023,  1023,  1023,  1024,  1024,  1024,
    1024,  1025,  1025,  1026,  1027,  1028,  1028,  1029,  1029,  1029,
    1030,  1030,  1031,  1031,  1032,  1032,  1033,  1033,  1033,  1033,
    1034,  1034,  1034,  1035,  1036,  1036,  1037,  1037,  1038,  1038,
    1038,  1038,  1039,  1039,  1040,  1041,  1042,  1043,  1043,  1044,
    1045,  1045,  1046,  1046,  1046,  1046,  1046,  1048,  1047,  1049,
    1050,  1051,  1051,  1052,  1052,  1052,  1052,  1053,  1053,  1055,
    1054,  1057,  1056,  1058,  1056,  1056,  1059,  1059,  1060,  1060,
    1060,  1061,  1061,  1061,  1061,  1062,  1062,  1063,  1063,  1063,
    1063,  1063,  1063,  1064,  1064,  1064,  1065,  1067,  1066,  1068,
    1069,  1068,  1070,  1070,  1071,  1071,  1072,  1072,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1075,  1075,  1076,
    1076,  1077,  1078,  1078,  1079,  1079,  1079,  1080,  1081,  1082,
    1082,  1082,  1082,  1083,  1083,  1083,  1084,  1084,  1085,  1085,
    1086,  1087,  1087,  1088,  1088,  1089,  1089,  1090,  1090,  1091,
    1092,  1092,  1093,  1093,  1093,  1094,  1094,  1094,  1094,  1094,
    1094,  1094,  1094,  1094,  1095,  1095,  1095,  1095,  1095,  1096,
    1096,  1097,  1098,  1099,  1100,  1100,  1101,  1102,  1103,  1103,
    1104,  1105,  1105,  1106,  1107,  1108,  1108,  1109,  1110,  1111,
    1111,  1112,  1113,  1113,  1113,  1113,  1113,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1115,  1115,  1116,  1116,  1117,  1117,  1117,  1119,
    1118,  1120,  1120,  1122,  1121,  1123,  1123,  1123,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1125,  1125,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,  1127,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1129,  1130,  1130,  1130,
    1130,  1130,  1130,  1130,  1130,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1134,
    1134,  1134,  1134,  1134,  1135,  1135,  1135,  1135,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1137,  1137,  1137,  1138,  1138,
    1138,  1138,  1138,  1138,  1139,  1139,  1140,  1141,  1141,  1142,
    1142,  1143,  1144,  1145,  1146,  1146,  1146,  1147,  1148,  1149,
    1150,  1151,  1151,  1151,  1151,  1151,  1152,  1153,  1153,  1153,
    1154,  1154,  1155,  1155,  1155,  1156,  1156,  1157,  1157,  1158,
    1158,  1159,  1159,  1159,  1159,  1159,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1163,  1163,  1163,  1163,  1163,
    1164,  1164,  1165,  1165,  1166,  1166
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     0,     2,     0,
       2,     0,     2,     2,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     1,     2,     2,     2,     3,     3,     5,     5,     0,
       3,     5,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     2,
       2,     3,     3,     3,     1,     3,     1,     3,     1,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     1,     0,     1,
       1,     2,     3,     4,     3,     2,     2,     1,     3,     4,
       5,     4,     2,     4,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     4,     4,     4,     4,     1,     3,     2,
       3,     4,     6,     6,     6,     5,     5,     6,     6,     4,
       7,     2,     6,     4,     3,     3,     3,     3,     3,     4,
       4,     3,     3,     3,     3,     3,     3,     4,     4,     3,
       2,     3,     3,     3,     2,     2,     3,     2,     1,     1,
       0,     2,     0,     3,     2,     0,     1,     3,     3,     1,
       5,     3,     2,     2,    10,     6,     1,     1,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,     1,     3,     2,     1,     1,     1,
       1,     3,     0,     1,     3,     1,     1,    11,    10,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     3,     0,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       4,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     1,     5,
       7,     8,     9,    11,     3,     0,     1,     3,     1,     2,
       2,     2,     0,     1,     3,     3,     6,     4,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     5,     3,     0,     1,     3,
       1,     2,     3,     0,     5,     4,     1,     0,     1,     2,
       2,     1,     2,     3,     2,     2,     2,     2,     3,     3,
       1,     3,     1,     0,     1,     2,     1,     6,    10,     1,
       0,     1,     2,     2,     0,     2,     2,     1,     0,     5,
       7,     1,     0,     6,     2,     0,     3,     5,     7,     6,
       8,     7,     6,     6,     4,     0,     1,     3,     4,     1,
       3,     1,     2,     2,     2,     2,     1,     1,    10,     2,
       0,     2,     2,     1,     0,     4,     6,     5,     4,     4,
       8,     1,     1,     1,     7,     9,     8,    15,    20,     1,
       1,     1,     3,     1,     1,     1,     3,     1,     3,     0,
       1,     0,     1,     1,     4,     0,     1,     3,     0,     1,
       1,     1,     1,     1,     1,     2,     0,     1,     2,     1,
       2,     0,     2,     1,     2,     2,     6,     8,     8,     4,
       5,     4,     4,     4,     3,     7,     8,     6,     6,     6,
       6,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     1,     3,     3,     1,     0,     1,
       3,    13,     1,     3,     4,     5,     4,     7,     2,     1,
       0,     2,     0,     1,     0,     6,     8,     8,     1,     3,
       5,     5,     7,     9,     7,     9,     5,     6,     6,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     1,     3,     1,     2,     2,     3,     5,     2,
       2,     0,     6,     7,     7,     7,     8,     8,     6,     8,
       9,     9,     7,    10,     7,     8,     8,     8,     8,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     3,     4,     5,     4,     5,
       3,     4,     3,     4,     1,     2,     3,     3,     3,     3,
       4,     4,     3,     3,     4,     4,     4,     4,     1,     1,
       1,     0,     7,     7,    10,     1,     1,     2,     4,     5,
       1,     3,     2,     2,     2,     2,     1,     2,     2,     4,
       3,     2,     2,     2,     3,     2,     2,     5,     5,     5,
       1,     3,     1,     2,     3,     0,     1,     3,     2,     6,
       6,     9,     3,     0,     3,     0,     5,     2,     0,     3,
       3,     3,     7,     7,    10,     1,     1,     1,    14,     1,
       0,     1,     0,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,     2,     1,     2,     1,     2,
      11,    10,    10,     2,     2,     0,     9,     2,     0,     4,
       4,     4,     1,     1,     1,     0,     7,     6,     6,     6,
       6,     7,     9,     9,     6,     6,     6,     6,     6,     8,
       8,     6,     6,     6,     5,     5,     8,     8,     8,     8,
       6,     1,     0,     2,     0,     7,     6,     6,     6,     6,
       6,     6,     7,     6,     6,     6,     6,     7,     7,     7,
       9,     9,     6,     6,     6,     8,     8,     8,     6,    13,
       1,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     0,     6,
       8,     3,     2,     0,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     3,     3,
       3,     1,     1,     0,     3,     2,     2,     1,     3,     2,
       1,     0,     8,    10,     3,     4,     4,     0,     2,     5,
       2,     0,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     1,     0,
       5,     6,     4,     2,     0,     4,     3,     5,     6,     4,
       6,     6,     5,     7,     1,     0,     6,    11,    11,    11,
      13,     9,    11,    10,     4,     2,     5,     2,     0,     4,
       5,     5,     4,     6,     1,     3,     1,     1,     1,     1,
       2,     4,     1,     1,     1,     0,     1,     0,     1,     0,
       3,     0,     2,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     1,     1,     0,     3,     2,     2,     2,     0,     2,
       2,     1,     1,     3,     3,     1,     2,     4,     4,     2,
       3,     5,     5,     1,     1,     9,     1,     2,     4,     4,
       4,     2,     3,     1,     3,     4,     2,     1,     0,     3,
       3,     4,     4,     4,     4,     2,     1,     1,     0,     1,
       1,     0,     1,     5,     1,     0,     1,     0,     3,     1,
       3,     4,     3,     2,     2,     1,     1,     1,     0,     2,
       4,     5,     2,     3,     1,     1,     1,     1,     3,     0,
       1,     1,     1,     1,     1,     3,     0,     2,     0,     1,
       3,     1,     0,     1,     2,     4,     4,     2,     0,     2,
       3,     2,     0,     1,     3,     1,     2,     1,     2,     5,
       6,     5,     1,     2,     1,     4,     3,     4,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     3,
       1,     2,     3,     1,     2,     0,     2,     4,     0,     1,
       3,     2,     2,     3,     5,     6,     2,     3,     3,     4,
       0,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     2,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     4,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     3,     2,     4,
       2,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     3,     4,     1,     3,     2,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     5,
       6,     6,     7,     3,     4,     1,     1,     2,     4,     1,
       1,     1,     2,     2,     2,     1,     4,     5,     6,     8,
       6,     7,     7,     5,     1,     1,     4,     1,     4,     1,
       4,     1,     4,     1,     1,     1,     1,     1,     1,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     4,     4,     4,     5,     7,     7,     9,     4,     6,
       5,     7,     7,     7,     2,     3,     3,     3,     4,     0,
       4,     1,     3,     3,     1,     1,     1,     2,     2,     0,
       2,     0,     1,     3,     3,     2,     2,     0,     6,     1,
       0,     3,     0,     2,     2,     0,     1,     4,     2,     2,
       2,     2,     2,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     1,     3,     1,     3,     1,     3,     3,     3,
       2,     1,     3,     3,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     2,     3,     0,     3,     3,
       2,     2,     1,     0,     2,     2,     3,     2,     1,     1,
       3,     5,     1,     2,     4,     2,     0,     1,     0,     1,
       2,     2,     2,     3,     5,     1,     2,     0,     2,     1,
       0,     1,     1,     1,     3,     3,     1,     3,     3,     2,
       1,     1,     1,     3,     1,     2,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     5,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     2,     1,     1,     1,     1,     1,
       0,     8,     2,     5,     3,     2,     2,     3,     7,     1,
       1,     1,     0,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     1,     2,     0,     2,     4,     0,     2,
       2,     2,     1,     1,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     2,     2,     1,     2,     0,
       7,     0,     5,     0,     4,     2,     2,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     5,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     2,
       3,     0,     1,     2,     1,     4,     3,     4,     3,     2,
       1,     3,     1,     1,     1,     1,     2,     2,     1,     2,
       2,     1,     1,     1,     4,     4,     4,     4,     4,     1,
       0,     3,     3,     4,     1,     3,     3,     4,     1,     3,
       3,     1,     1,     1,     6,     1,     3,     3,     6,     1,
       3,     3,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     4,     1,     1,     4,     4,     3,     0,
       7,     1,     0,     0,     7,     3,     4,     3,     1,     1,
       1,     2,     3,     5,     2,     5,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     3,     1,     3,     3,     3,
       3,     3,     3,     1,     1,     0,     2,     2,     1,     1,
       2,     1,     1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2090,     0,     2,     1,  2520,  2524,  2528,  2529,  2446,  2530,
    2531,  2496,  2497,  2498,  2499,  2500,  2501,  2502,  2503,  2504,
    2505,  2506,  2507,  2509,  2508,  2510,  2511,  2512,  2513,  2514,
    2515,  2516,  2517,  2519,  2518,  2468,  2097,  2465,  2462,  2463,
    2464,  2469,  2467,  2460,  2461,  1701,  2533,  2521,  2534,  2522,
    2523,  2525,  2526,  2495,  2527,  2535,  2536,  2537,  2532,  2540,
    2491,  2492,  2490,  2493,  2494,  2538,  2539,  2482,  2483,  2484,
    2485,  2541,  2098,  2099,  2487,  2091,  2095,  2157,  2228,  2488,
    2489,  2486,  2096,  2481,  2228,     0,  2349,  2350,  2351,     0,
    2352,  2353,  2354,  2280,  2242,  2355,     0,     0,  2356,  2357,
    2358,  2359,  2360,  2361,  2362,  2363,     0,  2364,  2365,  2366,
    2367,  2227,  2368,  2369,  2370,  2371,  2372,  2204,  2210,  2333,
       0,  2184,  2185,  2181,  2183,  2182,  2186,  2169,  1003,   502,
    1083,  1082,     0,  1993,  1003,  1950,  1951,  1994,  1952,  1953,
    1954,   248,     0,  1085,  1955,     0,  1003,  1995,   337,   815,
    1996,  1997,  2112,     0,  1956,  1957,     0,     0,     0,     0,
     502,  1003,     0,     0,  1958,     0,  1959,     0,  1960,  1998,
    1999,     0,  1961,  2000,  2001,  1962,     0,  1963,  1964,  2002,
    2003,  2004,  1965,  2005,  2006,     0,     0,  1208,     0,  1966,
    2007,  1967,  1968,     0,  2008,  1969,  1970,  1971,  2009,  2010,
    2011,  1972,  1973,  1974,     0,  1975,     0,     0,     0,     0,
       0,  2012,  1003,  1976,     0,  1215,     0,  1977,     0,  2013,
    1978,     0,  1979,     0,  1980,  1981,  1982,  1983,  1208,  2329,
    2205,     0,     0,  1087,     0,  1984,  2014,     0,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,     0,     0,    47,    48,
      16,    15,    21,    20,    70,    71,    37,    10,    61,    42,
     102,   101,   103,    27,    23,    55,    14,    24,    28,    44,
      43,    13,    41,    65,    45,    68,    34,    59,     7,    35,
      60,     8,    49,    72,    19,    46,    69,    30,    57,    53,
      38,    39,    40,    62,    63,    64,    86,    67,    97,    26,
      76,    77,    92,    78,    93,     5,    79,    36,     9,    89,
      88,    90,    56,    31,    58,    87,    91,    11,    12,    94,
      66,    84,    81,    98,    96,   104,    82,    50,     3,     4,
      73,    33,     6,    18,    17,    32,    25,   100,    22,  1085,
      75,    85,    74,    80,    54,    83,    99,    52,    95,  1184,
    1171,  1217,  1183,     0,  1186,  2425,  2426,    29,   124,   106,
     107,   112,  2094,  2146,  2147,  2148,  2228,  2179,  2180,  2173,
    2189,  2199,  2188,  2192,  2200,  2187,  2206,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  2427,  1392,  2424,    51,  2164,  2163,
       0,  2228,     0,  2373,  2374,  2375,  2376,  2377,  2378,  2428,
    2429,  2430,  2431,  2432,  2434,  2433,  2457,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  2400,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,
    1741,  1742,  2437,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  2438,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,
    1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,  1788,
    1789,  1790,  1791,  1792,  1793,  1794,  1795,  2439,  1796,  1797,
    1798,  1799,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,
    1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,  1826,  1827,
    1828,  2440,  1829,  1830,  2441,  1831,  1832,  1833,  1834,  1835,
    1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,
    1846,  1847,  1848,  1849,  1850,  1851,  1852,  1853,  1854,  1855,
    1856,  1857,  1858,  1859,  1862,  1860,  1861,  1863,  1864,  1865,
    1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  1875,
    1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,  1884,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  2442,  1893,  1894,
    1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1919,  1920,  1921,  2112,  1922,  1923,
    1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,
    1934,  1935,  1936,  1937,  2401,  1938,  1939,  1940,  1941,  1942,
    1943,  1944,  1945,  1946,  1947,  2443,  1948,  1949,  2130,  2435,
    2397,  2105,  2126,  2398,  2347,  2348,  1702,  2399,  2396,  2436,
    2132,  2453,  2131,  2395,  2279,     0,     0,  2241,  2240,  2244,
    2243,  2245,  2238,  2239,  1679,  2133,  2249,  2248,  1161,  2452,
    1678,  1162,     0,  2251,  2379,  2380,  2381,  2382,  2384,  2383,
    2385,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2410,  2027,  2028,  2029,  2423,  2030,  2031,
    2411,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2053,  2054,  2055,  2412,  2413,  2056,  2057,  2058,
    2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,
    2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,  2077,  2078,
    2079,  2414,  2080,  2081,  2415,  2082,  2083,  2084,  2416,  2085,
    2086,  2087,  2088,  2089,  2420,  2421,  2422,  2409,  2202,  2386,
    2408,  2419,  2417,  2418,  2212,  2208,  2216,  2211,     0,     0,
       0,     0,  2228,  1002,  1001,   987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   501,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2102,     0,  1011,   313,   312,  1084,  1065,   502,     0,   990,
     336,     0,     0,     0,     0,     0,     0,     0,   629,     0,
       0,     0,     0,     0,     0,     0,     0,   177,     0,     0,
     360,   359,     0,     0,     0,   789,     0,     0,     0,     0,
     490,  2111,  2106,  2116,     0,  2109,  2110,  2395,     0,  2544,
    1860,  2142,  2143,  2542,  1906,  1163,     0,   249,   252,   250,
     251,     0,   885,   886,   888,     0,     0,   898,   656,     0,
     655,     0,     0,     0,   653,     0,     0,     0,     0,   657,
     651,     0,   650,     0,     0,     0,   654,     0,   652,     0,
       0,   991,     0,  2194,  2195,  1798,  1124,   365,     0,     0,
       0,     0,  1085,  1092,  1102,  1097,  1099,  1098,  1100,  1096,
    1101,  1710,   731,  1723,   731,  1788,   728,   729,   731,   731,
     731,  1874,     0,     0,   703,     0,   714,  1703,   731,  1704,
    2453,   736,   415,   415,   415,     0,   735,   740,   415,     0,
     984,  1018,  1683,  1207,     0,  1723,  1788,   704,   983,  1922,
    1116,     0,     0,   902,     0,   903,     0,  1889,   995,   235,
    2393,  1898,  1980,  1922,  2394,   231,  2388,  2389,  2391,   204,
    2392,  2390,  2387,  1714,     0,     0,   735,     0,   992,   993,
    1214,  1212,     0,     0,     0,  1731,     0,  1743,  1822,   228,
    1885,  1890,  1898,  1980,  1922,  1947,   186,     0,   242,  1898,
    1980,  1922,     0,  1011,     0,  1187,  1294,  1674,     0,     0,
    2203,   986,   985,  1300,     0,  1086,     0,  1089,     0,  1259,
    1872,  1191,  1193,  1091,  1184,     0,  2093,  1080,  1211,  1211,
       0,  1211,     0,  1176,  1184,  1179,  1183,     0,  1003,     0,
    2171,  2199,  2178,  2234,  2175,     0,     0,  2224,  2220,  2217,
    2225,  2226,  2219,  2207,  1381,  1382,  1383,  1380,  1393,  1379,
       0,  2152,  1384,  2191,  2158,     0,  2166,  2165,  2470,  2471,
    2281,  2104,  2123,     0,     0,     0,     0,     0,     0,     0,
    2250,  2252,  2254,  2214,  2213,  2209,     0,     0,     0,     0,
    2339,  2340,  2338,     0,  2335,  2337,     0,  2234,     0,  2404,
    2398,  2407,     0,  1684,  2399,  2396,  2395,     0,   664,   127,
     778,     0,     0,     0,     0,     0,     0,     0,  1579,  1735,
    1784,  1589,  1587,  1588,  1581,  1582,  1583,  1584,  1585,  1586,
       0,   883,  1580,     0,   127,     0,     0,     0,     0,     0,
       0,     0,     0,  1826,   127,     0,     0,     0,     0,     0,
    1007,  1010,   988,  1068,     0,  1674,     0,     0,   689,     0,
     698,   690,   695,     0,   692,     0,     0,   700,     0,   691,
     693,   694,   699,     0,     0,   696,   697,     0,     0,   999,
     415,     0,     0,     0,     0,     0,   127,  1055,     0,   364,
     363,   127,   362,   361,  1735,  1784,     0,   814,   127,     0,
     179,   530,   505,     0,     0,   594,  1826,   127,     0,     0,
       0,     0,   792,     0,     0,   489,   502,     0,  2115,  2121,
       0,  2113,  2282,  2545,  2543,  2237,     0,  1136,   889,   229,
     230,   887,  1797,     0,   300,     0,     0,  1797,  1046,     0,
    1797,     0,  1797,   172,  1676,  1735,  1784,  1797,     0,     0,
    1797,   164,  1797,     0,  1797,   300,  1797,   506,     0,  1797,
       0,  1797,  1826,   166,     0,  1797,   300,   662,     0,     0,
    2475,  2479,     0,  2477,  2472,  2193,  2247,  2246,  2145,     0,
    2555,     0,  1163,  1094,  2401,  1108,  1107,     0,  1103,  1112,
    1106,     0,   731,   730,     0,   731,     0,  2564,   731,     0,
     731,     0,  2564,   731,     0,     0,     0,   731,  1705,  1706,
       0,     0,  2563,  2561,  2562,   705,   715,     0,   737,     0,
       0,   744,   743,   742,     0,     0,     0,   745,     0,  1298,
    1139,     0,   712,     0,   710,     0,   981,   998,     0,     0,
       0,     0,   905,   905,   905,   994,   234,   232,     0,     0,
       0,     0,     0,     0,  1000,     0,     0,  2459,  1690,  1590,
    2458,     0,  1951,  1952,  1953,  1648,     0,  2400,  1954,  1955,
    1507,  1494,  1503,  1508,  1495,  1497,  1504,  1956,  1957,  1770,
    1958,  1959,  1697,  1960,  1961,  1336,  1963,  1964,  1965,  1499,
    1501,  1966,  1967,     0,  1698,  1969,  1970,  1849,  1972,  1973,
    1975,  1976,  1505,  1978,  1979,  1980,  1981,  1982,  1983,  1696,
       0,  1506,  1984,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
       0,     0,  1671,     0,  1481,     0,  1328,  1329,  1351,  1352,
    1330,  1357,  1358,  1370,  1331,     0,  1670,  1395,  1480,  1485,
       0,  1479,  1475,  1198,  1666,     0,  1476,  1686,  1649,  1700,
    1699,  2453,  1657,  1689,  1687,  1688,     0,     0,     0,   197,
       0,     0,  2328,   244,     0,   245,  1672,  1898,   187,   227,
     199,   226,   200,   198,     0,  1733,   188,     0,   195,     0,
       0,     0,     0,     0,     0,     0,   238,   989,     0,  1296,
    1295,     0,     0,  1655,  1675,   671,     0,     0,  1301,     0,
    1078,  1079,  1077,     0,  1074,  1076,  1088,  1085,  1662,  1661,
    1663,     0,  1192,     0,     0,     0,  1174,  1173,  1091,  1209,
    1210,     0,     0,     0,     0,     0,     0,     0,     0,  1252,
    1225,  1226,  1228,  1249,  1253,     0,  1180,  1260,  2092,  2234,
    2235,     0,  2229,     0,  2228,  2228,  2222,  2221,  2218,     0,
       0,     0,     0,     0,     0,     0,  2149,   486,  2151,   484,
       0,     0,  2125,     0,  2129,  2127,     0,  2274,  2277,     0,
    2275,  2276,  2278,     0,  2283,  2284,     0,     0,     0,  2466,
       0,     0,  2265,  2253,  2260,  2262,  2264,  2263,  2272,  2268,
    2271,  2273,  2215,  2228,  2346,     0,  2341,  2344,     0,  2336,
       0,     0,     0,  1685,     0,     0,     0,   665,     0,     0,
       0,   126,  1044,   237,  1042,     0,     0,     0,     0,     0,
    1049,     0,     0,     0,     0,   847,     0,     0,     0,     0,
       0,     0,   848,   846,   849,   856,   869,   872,     0,   768,
     170,   171,     0,     0,     0,   932,     0,     0,   932,     0,
       0,     0,     0,     0,     0,     0,   254,   257,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
       0,   471,   483,     0,     0,     0,     0,     0,   480,     0,
     127,   255,   465,   468,     0,     0,     0,   539,   538,   932,
       0,   253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   163,     0,
       0,   256,     0,  2159,     0,  1005,  1006,     0,  1009,     0,
    1064,     0,     0,     0,     0,     0,     0,  1735,  1784,     0,
       0,     0,     0,     0,     0,   339,   319,   320,   127,   318,
       0,     0,   591,     0,  1339,  1368,  1346,  1368,  1368,  1335,
    1335,  1348,  1337,  1375,     0,  1368,  1335,  1340,     0,  1338,
    1378,  1378,  1363,     0,  1320,  1321,  1322,  1323,  1349,  1350,
    1324,  1355,  1356,  1325,  1392,  2405,  1335,  2406,  2403,  2402,
       0,  1021,  1054,     0,     0,   129,   630,     0,     0,   592,
       0,   129,     0,   175,     0,   534,     0,     0,     0,     0,
       0,     0,   550,   549,     0,     0,   593,     0,   129,   467,
       0,   457,   415,     0,   791,   794,     0,     0,     0,  2119,
    2114,  2117,     0,  2107,  2121,  1166,  1168,  1167,     0,  1165,
       0,  1308,     0,   300,   298,   299,   589,   897,     0,     0,
       0,     0,   300,     0,     0,  1797,     0,  1797,     0,     0,
     300,   300,     0,     0,     0,     0,   535,     0,   661,   659,
     658,   660,     0,     0,     0,     0,     0,  1797,   300,     0,
       0,   649,  2473,     0,     0,  2476,     0,  2196,  1600,     0,
    2558,  1121,  2559,     0,     0,     0,     0,   216,   218,   217,
     215,  1109,  1110,  1111,  1105,  1093,     0,   723,     0,  2564,
    2565,   708,     0,   718,     0,  2564,   706,     0,   719,   716,
     717,     0,     0,     0,  2560,  2444,  2450,   722,     0,     0,
     416,   418,     0,     0,  1756,     0,  1789,  1814,  1815,  1890,
    1894,     0,  1917,     0,   746,   773,   741,     0,     0,  1133,
    1126,     0,     0,  1149,   713,   711,   982,  1114,  1606,     0,
       0,     0,   904,   901,   900,   899,   233,   205,     0,     0,
       0,   775,  1889,   997,     0,     0,  1483,  1484,  1367,  1354,
    1647,     0,     0,  1362,  1361,     0,     0,     0,     0,  1344,
    1343,  1342,  1482,  1614,     0,  1341,     0,     0,     0,     0,
    1368,  1368,  1366,  1414,     0,  1345,     0,     0,  1627,     0,
    1633,     0,     0,     0,  1374,     0,  1372,     0,     0,  1450,
       0,     0,     0,     0,     0,     0,     0,  1398,  1399,  1481,
    1600,     0,  1693,     0,     0,  1360,     0,  1392,  1590,     0,
       0,     0,     0,  1660,  1598,     0,     0,  1428,  1596,     0,
    1430,     0,     0,     0,  1589,  1587,  1588,  1581,  1582,  1583,
    1584,  1585,  1586,  1594,  1411,     0,  1669,     0,  1410,     0,
       0,  1262,  1197,     0,  1691,  1650,     0,  2451,  2454,  1477,
    2325,  2324,  2323,  2322,  2293,     0,  2287,  2288,     0,  2326,
    2327,   246,   247,   243,     0,     0,   202,   201,     0,   224,
     225,   194,   223,     0,   219,   220,  1546,  1545,   203,   193,
     191,   189,   206,   208,   209,   210,   192,   190,   241,   239,
       0,     0,     0,  1652,  1651,  1681,  1656,     0,     0,   300,
    2228,  1302,     0,  1262,  1151,  1153,  1154,     0,  1657,  1072,
       0,  1069,  1665,     0,  1194,     0,     0,  1081,  1190,  1189,
    1218,  1219,   807,  1188,  1243,  1244,  1239,     0,  1258,  1258,
    1235,  1229,  1234,  1232,     0,  1236,  1395,  1251,  1178,  1223,
    1224,  1227,  1177,     0,  1254,  1252,  1228,     0,  2236,  2234,
    2174,  1320,  2228,  2167,  2228,  2223,  2155,  1386,  1387,  1388,
    1389,  1390,  1391,  2156,     0,  2153,  1385,  2154,   485,     0,
       0,     0,  2122,     0,  2103,  2128,  2259,  2368,  2291,     0,
    2292,     0,     0,  2256,     0,  2266,  2269,  2267,  2270,     0,
    1320,  2447,  2342,  2447,  1320,     0,     0,     0,     0,     0,
       0,     0,   666,     0,     0,     0,  1917,   236,  1040,     0,
       0,     0,     0,   777,   776,     0,     0,   796,     0,     0,
       0,  1052,   408,     0,   297,     0,     0,     0,     0,     0,
       0,     0,   854,     0,     0,     0,     0,   855,   852,   853,
    1890,   871,   870,   868,   829,   831,   830,     0,   833,   817,
       0,   818,     0,     0,   828,   836,   834,     0,     0,     0,
    1778,   259,   271,     0,   931,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   290,     0,     0,     0,     0,
     295,     0,     0,     0,   294,     0,     0,     0,     0,     0,
       0,     0,   884,     0,     0,   158,   161,     0,     0,   470,
     482,     0,   474,   475,   472,   476,   477,     0,     0,     0,
       0,     0,     0,   469,     0,     0,   532,   531,   537,     0,
       0,     0,     0,     0,   925,   924,     0,     0,     0,     0,
       0,     0,     0,     0,   541,   542,     0,   543,     0,   162,
       0,     0,     0,     0,     0,     0,   214,  1004,  1008,  1067,
    1682,  1066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,     0,   614,  2402,   590,     0,  1320,     0,  1316,
    1312,  1381,  1380,  1379,     0,  1326,  1335,  1332,     0,  1019,
     382,   498,   168,     0,     0,     0,   602,   605,     0,   125,
     179,   365,     0,   178,   180,   182,   183,   184,   181,   185,
     529,   533,     0,   504,     0,     0,     0,     0,     0,   554,
     553,   557,   555,     0,   551,     0,     0,     0,   157,   464,
     466,  2100,     0,   367,   446,     0,     0,     0,   793,     0,
       0,     0,     0,     0,  2120,     0,     0,     0,     0,  1164,
       0,  1272,  1135,  1263,  1274,  1265,  1267,  1303,     0,  1674,
       0,  1133,     0,   875,     0,  1047,  1797,   300,     0,   873,
     173,  1677,     0,     0,     0,     0,     0,   877,   646,   165,
       0,   300,   300,   507,     0,   300,   167,     0,     0,     0,
     499,   300,   663,  2474,  2480,  2478,  1123,     0,  2556,  2557,
     457,  1168,  1095,  1104,   720,   727,   709,   726,   725,   707,
     724,   721,  2258,     0,     0,  2449,     0,   738,     0,   414,
       0,     0,     0,   752,     0,     0,   751,   766,   753,     0,
     755,   748,   747,   756,     0,     0,   775,  1128,     0,  1129,
    1657,     0,  1125,     0,  1146,     0,  1144,     0,  1299,  1148,
    1137,  1115,     0,  1113,  1118,  1120,  1119,  1117,     0,     0,
       0,   735,     0,     0,   300,   996,     0,  1610,     0,  1611,
       0,     0,     0,  1646,  1642,     0,     0,     0,     0,     0,
    1618,  1619,  1620,  1617,  1621,  1616,     0,     0,  1622,  1615,
       0,     0,     0,     0,     0,  1365,  1364,     0,     0,     0,
       0,     0,     0,     0,  1453,  1485,     0,     0,  1574,     0,
    1600,  1632,     0,     0,  1376,     0,     0,     0,     0,     0,
       0,     0,  1600,  1638,     0,     0,     0,  1544,     0,  1541,
       0,     0,     0,     0,  1657,     0,     0,     0,     0,  1694,
    1396,  1412,  1668,     0,  1659,     0,     0,  1419,     0,  1639,
    1446,     0,  1451,  1434,     0,  1427,     0,  1432,  1436,  1415,
    1660,  1599,     0,  1597,     0,     0,  1413,     0,  1408,  1406,
    1407,  1400,  1401,  1402,  1403,  1404,  1405,  1409,  1578,  1576,
    1577,     0,     0,     0,  1431,  1791,  1822,     0,  1208,  1208,
    1196,  1206,  1667,     0,  1305,     0,     0,     0,     0,  1557,
       0,  1604,     0,  1602,  1684,  2456,  2455,  1658,     0,     0,
       0,  1673,     0,     0,  1392,     0,   240,  1297,  1653,     0,
     669,   670,   668,  1320,  1158,     0,     0,  1308,     0,  1157,
    1091,  1075,  1071,  1070,  1664,  1090,  1195,     0,   805,   806,
       0,   810,     0,     0,  1237,  1250,     0,  1149,  1149,     0,
    1241,  1242,  1233,  1182,  1181,  2172,  2230,  2177,  2198,  2168,
    2201,  1394,  2150,  2190,     0,  2124,  2294,  2295,     0,  2285,
    2286,  2255,  2261,  2332,     0,  2448,     0,     0,   612,   611,
       0,     0,     0,   943,   907,   667,   944,   908,  1041,     0,
    1043,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   300,  1050,   945,   296,  1051,   936,
       0,     0,     0,   512,   513,     0,   850,   851,   946,   909,
       0,   937,   832,  1335,   816,     0,     0,   827,     0,   826,
    1335,  1335,   910,   169,   260,   382,   934,   276,   289,   284,
     285,   283,  1797,   300,  1797,   300,     0,     0,     0,     0,
     286,   281,   282,   278,   291,   292,   918,     0,   306,   309,
     293,   274,   277,   275,   258,     0,     0,  1680,     0,     0,
     879,     0,     0,   160,   921,     0,   140,   142,   144,     0,
     138,   146,   141,   143,   145,   139,   147,   137,     0,   136,
       0,     0,     0,   130,   952,   914,   473,   478,   916,   481,
     939,   479,  1713,  1771,  1899,     0,   519,   521,     0,   526,
     958,   915,     0,   938,   954,   923,     0,     0,     0,     0,
       0,     0,     0,  1056,     0,     0,     0,   953,   930,   941,
       0,   922,   917,   940,     0,     0,   212,   211,   213,     0,
       0,     0,     0,     0,     0,     0,     0,   702,   678,   701,
       0,     0,     0,     0,     0,     0,     0,   672,   338,   316,
     317,     0,     0,   315,   321,   613,     0,     0,     0,  1317,
    1313,     0,     0,     0,     0,     0,     0,  1333,     0,     0,
    1039,  1039,  1039,  1039,  1039,  1039,  1039,  1020,  1048,   497,
     515,     0,     0,     0,     0,   151,   128,     0,   635,   601,
       0,     0,   415,   174,     0,     0,     0,   503,   600,   598,
     597,   599,     0,     0,     0,   618,     0,  1309,     0,     0,
       0,     0,   369,     0,     0,   366,   370,   374,   375,   376,
       0,   458,   460,     0,     0,   450,     0,     0,     0,   821,
       0,   839,   822,     0,     0,     0,   859,   864,   860,   842,
       0,   487,  2118,  2112,  1169,  1170,     0,  1184,     0,  1274,
       0,  1273,  1285,     0,     0,  1291,  1289,     0,  1291,     0,
    1291,     0,  1266,     0,  1268,  1285,     0,  1675,     0,  1306,
    1134,   300,     0,     0,   509,   300,     0,   300,     0,   300,
     300,     0,   979,   536,     0,   586,     0,     0,   300,   648,
    1601,     0,     0,  2257,  2445,   739,   417,     0,     0,     0,
       0,   750,     0,  1707,   754,     0,   765,   760,   762,     0,
     769,     0,     0,  1131,  1132,  1147,  1140,  1142,  1141,     0,
       0,  1138,  1607,   647,     0,     0,   300,     0,   770,  1213,
    1608,  1609,     0,     0,     0,     0,  1643,     0,     0,  1520,
    1496,  1498,  1334,  1510,     0,  1347,  1521,  1522,  1500,  1502,
       0,  1591,     0,     0,  1511,  1455,  1456,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1468,  1467,  1512,  1573,     0,     0,  1630,  1631,  1513,  1377,
    1378,  1378,     0,     0,  1637,     0,     0,     0,  1518,  1523,
       0,     0,  1528,     0,  1549,     0,     0,     0,  1478,  1601,
    1369,  1370,     0,     0,     0,     0,     0,     0,     0,     0,
    1452,  1435,  1429,     0,  1433,  1437,     0,     0,     0,     0,
    1421,  1447,  1417,     0,     0,  1423,     0,  1448,  1208,  1208,
    1208,  1208,  1205,     0,     0,  1261,     0,  1246,  1217,  1217,
       0,  1557,     0,  1486,     0,  1557,     0,     0,  2307,  2309,
    2310,  2311,  2312,  2313,  2315,  2316,  2318,  2319,  2320,  2308,
    2314,  2317,  2321,  2298,  2299,     0,  2289,  2290,   196,     0,
     221,   207,     0,  2332,     0,     0,  1152,  1133,  1155,  1073,
    1220,     0,  1592,   810,   808,   809,  1222,     0,     0,  1257,
    1256,  1255,  1230,     0,  2232,  2160,     0,     0,  2331,  2334,
    2345,  2343,  2170,   942,   906,   935,  1039,   780,   781,     0,
     779,     0,     0,     0,   407,   795,     0,     0,     0,     0,
    1053,   496,     0,   495,   491,   511,   844,     0,  1335,   819,
     824,   825,     0,   379,     0,     0,     0,   261,     0,     0,
     273,     0,   269,   287,   279,   288,   280,   303,     0,     0,
       0,   948,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   949,     0,     0,   133,   132,     0,   150,     0,   523,
     524,   522,   518,     0,   525,   527,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   947,   911,
     673,     0,     0,   674,   682,     0,     0,   675,     0,     0,
       0,     0,     0,     0,   684,   341,     0,   344,   352,   325,
     329,  1055,  1055,     0,   330,  1055,   326,  1055,   323,   615,
       0,  1849,  1581,  1582,   609,   616,   606,   608,   607,   610,
     581,     0,     0,     0,  1318,     0,  2546,  2554,  2553,     0,
    1392,     0,  1039,  1038,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   393,     0,     0,   387,     0,     0,
     864,   381,   384,   385,     0,   508,   153,     0,     0,   154,
     152,     0,   603,   604,     0,   365,     0,     0,   556,   559,
     552,     0,   617,   619,   595,     0,  1311,   515,  1124,   463,
       0,   446,   400,   442,     0,   456,     0,   444,   443,   445,
       0,   452,  1017,     0,   796,   820,     0,     0,     0,   857,
     861,   858,     0,     0,   835,     0,   843,   813,   974,   975,
     972,   973,     0,     0,  2135,  1160,  2144,  1276,  1283,     0,
    1264,     0,  1290,  1286,     0,  1287,     0,     0,  1288,     0,
       0,  1283,     0,     0,     0,   876,     0,   300,   874,     0,
     642,     0,   644,   878,   300,   300,   544,     0,   500,   460,
       0,     0,     0,     0,   749,   767,     0,   763,     0,     0,
     732,   772,  1127,  1130,  1145,  1143,   775,     0,   733,   774,
    1612,  1353,     0,  1645,  1641,     0,  1613,     0,  1625,  1624,
    1454,  1626,     0,  1473,     0,     0,  1465,  1463,  1464,  1457,
    1458,  1459,  1460,  1461,  1462,  1466,  1635,  1634,  1628,  1629,
    1373,  1371,     0,  1515,  1516,  1517,  1636,  1524,     0,  1543,
    1542,     0,     0,     0,  1530,     0,     0,  1539,     0,  1575,
    1359,  1392,  1397,     0,     0,  1420,  1640,  1438,     0,     0,
       0,  1416,     0,     0,     0,     0,  1425,  1591,     0,     0,
       0,     0,     0,     0,  1200,  1199,  1304,     0,  1248,     0,
       0,  1216,     0,  1557,  1493,  1560,  1555,  1556,  1605,  1487,
    1692,     0,  1603,  1557,     0,     0,     0,  1654,  2330,     0,
    1159,  1150,     0,  1221,  1238,  1231,  2176,     0,  2231,  2296,
    2297,     0,   786,   787,   785,     0,     0,     0,   581,     0,
       0,   423,     0,   804,   804,     0,     0,   864,   957,   492,
     845,     0,   837,     0,   266,   933,     0,     0,     0,   265,
       0,   300,   300,   307,   308,   311,     0,     0,     0,     0,
       0,   636,   622,     0,     0,   637,   638,     0,     0,   881,
     882,   880,   148,   134,   135,   149,   520,   919,     0,     0,
       0,     0,     0,   956,   929,   955,   927,   926,   928,   920,
     546,     0,   676,     0,     0,   677,   688,   686,   685,   687,
     679,   342,   127,     0,   322,     0,   350,     0,   347,   348,
     346,   349,     0,     0,     0,     0,     0,     0,   583,     0,
       0,   588,   577,   579,     0,     0,     0,  1314,     0,     0,
       0,     0,     0,     0,  1319,  1327,   576,     0,  1030,  1029,
    1028,  1032,  1031,  1034,  1033,  1025,  1024,  1037,  1036,  1023,
    1022,  1027,  1026,     0,     0,   391,   395,   396,   394,   386,
     864,   415,   454,     0,   156,   155,     0,     0,     0,     0,
     561,   565,   596,     0,  1310,   540,  1122,     0,  2101,     0,
     372,   377,   378,     0,   450,   397,     0,   446,   371,   459,
       0,     0,   455,     0,  1012,     0,     0,   823,   840,   841,
       0,     0,   864,   863,     0,   494,     0,  2108,  1275,     0,
       0,  1277,     0,     0,  1279,  1281,     0,     0,     0,     0,
       0,  1678,  1557,  1307,   300,   510,   300,   300,   980,   587,
       0,   759,   758,   757,  1708,     0,   761,   300,     0,  1644,
    1509,  1519,  1623,     0,     0,  1474,     0,     0,  1514,  1985,
       0,     0,  1547,  1548,  1529,     0,  1835,  1534,     0,     0,
       0,  1695,  1444,  1442,  1439,     0,  1440,     0,     0,  1422,
    1418,     0,  1424,  1449,  1204,  1203,  1202,  1201,     0,     0,
    1551,  1557,  1557,  1488,  1562,  1559,     0,  1490,  2300,     0,
    2303,  2301,  2302,  2306,  1392,  1156,     0,  2233,  1045,     0,
       0,     0,   409,     0,   864,     0,     0,     0,   802,   807,
     807,     0,   864,   454,   838,   262,   263,   264,   267,   302,
     272,   268,     0,   950,   912,     0,     0,   628,     0,     0,
       0,     0,   951,   913,     0,     0,     0,  1061,     0,     0,
     680,   681,   324,     0,   345,   355,   356,     0,   353,   327,
     332,     0,   334,   333,   328,   331,   585,   584,   582,   578,
     580,  1315,     0,   895,   895,  2547,  2548,  2549,  2550,  2551,
    2552,     0,   581,  1035,     0,     0,   383,   454,   422,     0,
     388,     0,   516,     0,  1017,   367,   515,   560,     0,     0,
       0,   620,   461,     0,   368,     0,     0,   452,     0,     0,
       0,   450,     0,   447,     0,   451,     0,     0,     0,     0,
       0,   862,     0,   866,     0,   834,   811,  1305,     0,   498,
    2134,  2138,     0,  1284,  1293,     0,  1280,  1278,  1269,     0,
    1271,   896,   643,   645,   545,   764,   771,   300,  1469,     0,
       0,     0,     0,  1525,     0,  1526,  1531,  1535,     0,  1532,
    1533,  1441,  1445,  1443,  1426,  1245,  1247,     0,  1185,  1491,
    1492,     0,  1217,  1557,  2305,  2304,   222,  1593,   765,     0,
     300,   804,   454,   424,  1849,   425,   803,   810,   810,     0,
     454,   581,     0,   270,   310,     0,     0,   634,   623,     0,
       0,   639,     0,     0,     0,     0,     0,   683,   314,   340,
     351,     0,   335,   895,     0,   892,   891,   575,     0,   390,
     389,     0,   433,     0,   514,     0,   632,  1013,   528,   562,
     563,   558,     0,     0,   462,   373,   382,   358,   406,   405,
     402,   401,   403,   404,   399,   398,     0,   452,   448,   449,
       0,  1014,     0,  1063,     0,   797,   865,     0,     0,     0,
     493,   488,     0,  2136,  1282,     0,  1270,   734,  1470,     0,
    1471,     0,     0,  1537,  1536,  1550,  1552,     0,     0,  1565,
    1489,   782,     0,   783,   807,   428,     0,   800,   799,   415,
     581,   410,   301,     0,   626,   633,   624,   634,     0,     0,
    1057,     0,  1058,  1059,  1062,   354,   890,   894,   893,     0,
     419,   420,   421,     0,   392,   429,   430,     0,   517,     0,
       0,     0,     0,   380,   441,   357,  1015,  1016,   305,     0,
     864,   867,   978,  2139,  2141,  2140,     0,  1292,  1472,  1540,
    1527,  1538,     0,     0,  1561,     0,     0,     0,     0,   810,
       0,   581,     0,   422,   411,     0,   625,   641,   640,     0,
       0,     0,     0,     0,   431,     0,   432,   453,   631,     0,
     564,     0,     0,   452,   798,   812,   977,   976,     0,  2137,
    1553,  1554,  1950,     0,  1927,     0,  1563,  1566,  1564,  1558,
     300,   801,     0,   412,   426,   433,     0,  1060,   565,   438,
       0,   437,     0,   435,   434,   621,   568,   304,  1305,   960,
     971,   959,   961,   969,   966,   968,   967,   965,     0,  1570,
    1569,  1568,  1572,  1571,   784,     0,   581,   627,     0,   436,
     440,   439,   573,     0,   566,   569,   574,   572,   570,   571,
     788,     0,   970,   964,  1184,  1171,     0,   427,   413,     0,
     547,     0,   962,   971,  1567,     0,   567,   963,     0,   568,
       0,   548
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   247,   248,  1652,  2452,  2355,  3055,  3056,   249,
     250,  1707,   251,   252,   253,   254,   255,   256,   257,  1683,
     258,   259,  1239,  1833,  2463,   260,  2267,  1037,  2141,  2142,
    2407,  2143,  2131,  1510,  2144,  1653,  1675,   262,   263,  1504,
    2123,   264,   265,   266,  1696,  1697,  1660,  1876,  4223,  2344,
    4403,  2917,  2918,   267,   268,  3021,  1778,  3023,  3024,  3488,
     851,  2430,  3842,  3843,  3476,  3477,  3850,  4087,  4088,   269,
    1830,  3084,  3561,  3085,  3919,  3086,  3920,  3087,  3921,  3048,
    3531,  3532,  3533,  3088,  3925,  4274,  3089,  2282,  1361,  1959,
    1960,  4252,  3770,  3771,  4381,  4344,  4345,  4346,  4433,  3927,
    3095,  3571,  3932,  4120,  1850,  2494,  3090,  3091,  3918,   270,
     271,  2489,  1722,  1723,  2361,  3494,   272,  1256,  3393,  4159,
    3049,  3050,   273,   839,   274,  1837,   275,   276,   277,   278,
    3535,  4121,  1727,  2965,  2966,  2967,  2968,  3444,   279,  1835,
    1728,  2472,   280,   281,   282,  2396,   283,   284,   285,  1844,
    2483,  2484,  3911,  4128,  4261,  4130,  4463,  4464,  4112,  3861,
    3862,  3863,   286,   287,   288,   289,  1829,  2455,  2456,  3495,
    1642,  1782,  2432,  2433,  3551,  3552,   290,  3801,  3802,   878,
    4350,  4326,   291,   292,  3805,  3806,   293,   294,   295,   296,
     297,   930,  1306,  1307,  2891,   298,  2159,   299,  1218,  3008,
     300,   964,  1333,  1334,   301,   302,   975,  2621,   977,  1973,
    3176,  3177,  3640,  2586,  1153,   303,   304,  2596,  2624,   305,
    1655,  2273,  2274,  3765,   306,   879,  1855,  2497,  2860,  4284,
    3772,  4049,  2801,  3356,   307,   880,  1679,  2310,  2500,  3100,
    3101,  2312,  2760,  3583,  2314,  3102,  3107,  3108,  3109,  3579,
    3587,  4153,  4154,   308,  1677,  2303,   309,   310,   311,  1702,
    1170,   312,   902,   903,   313,  4245,   314,  1276,   315,   996,
    1993,   316,  2325,  3408,   317,   318,   319,  4441,  4471,  4472,
    4473,  3592,  4408,   320,  4443,  1376,   322,   323,   324,   842,
    1190,  1191,  1192,   325,  3934,   326,   327,  2449,  3047,  3514,
     328,   329,  2268,  2850,   330,   331,   332,  1823,   333,   334,
     335,   336,  1760,   337,  1543,  1544,   338,   339,   846,  1057,
    1547,  1555,   340,   943,  1327,  1328,  1329,  1934,   341,  1380,
    2613,   944,  1320,   945,  1979,  2598,  2599,  2602,   946,  1871,
     345,  1983,  2607,  2610,   947,  2163,  2164,  2165,  2166,  2167,
    2785,   948,   966,  1266,  2508,   949,  1464,   350,   351,   352,
     353,  1061,  1062,  2101,  2750,   984,  1561,  1022,  1072,  3731,
    2180,  2181,  2201,  2202,  1570,  1571,  2191,  2193,  2803,  2194,
    2812,  2186,  3728,  4020,  2197,  2198,  1573,  1574,  2807,   354,
    2754,  2512,  2513,  2514,  3121,  3131,  3603,  3954,  2515,  1370,
    1054,  2516,  3307,  2521,  3076,  3077,  2315,  2440,  1804,  1465,
    1805,  2447,  1466,  2025,  1807,  1467,  1468,  1469,  1810,  1470,
    1471,  1472,  1473,  2009,  2065,  1474,  1475,  2044,  1101,  1102,
    1918,  2663,  1477,  1478,  3697,  3999,  3990,  2688,  2689,  2138,
    3693,  4198,  4305,  4306,  3739,  3736,  4024,  4202,  4377,  4416,
    4417,  1479,  2741,  2093,  1172,  1480,  3497,  2095,  2683,  2762,
    2763,  2256,  2007,  2630,  2646,  2647,  2660,  3223,  2667,  2672,
    3246,  3247,  2684,  2710,  1481,  2633,  2634,  3207,  2011,  1482,
    1533,  1534,  2109,  2706,  1550,  1551,  1059,  1483,  1484,  1974,
    1046,  3950,  1284,   690,  2926,  2154,  1194,   981,  1485,  1486,
    1487,  3178,  1597,  3174,   669,   670,  1139,   795,     2,    75,
     950,  3081,   358,   359,   882,   883,   884,  1258,  1259,  1860,
    1863,  1602,  2234,   671,   672,   699,  3947,  4160,  4293,   936,
     360,   361,   362,   363,  1598,  2230,  1103,    76,    84,    77,
    1104,   400,   401,  2212,   364,   812,   365,  1579,  1083,  3364,
     366,   367,   368,   369,   370,   933,   371,  1085,   372,  1086,
     373,   374,   375,   376,  1093,   377,  1581,  1582,  3758,  1583,
     378,   379,   692,   693,  1318,   380,   381,  1120,  1121,  1352,
    1353,  1608,  1623,  1624,  1625,   382,   686,   383,   384,   385,
    1614,  1615,   386,  2116,  2117,  2239,  2118,   387,  2826,  2827,
     388,  3333,  3334,  4031,  3335,   389,  2112,   390,   391,  1049,
    3369,   392,   808,   393,  1134,   673,   674,   675,  1141,   798,
    1009,   700,  1143,  2969,   800,   801,   677,   678,   679,  1954,
      78,  2834,  1955,  1489,   701,  1490,  2107,  1491,  1492,  1493,
    1494,  1495,  1631,   683,  1110,  1310,  1311,  2835,  1313,    82,
    1314,   397,  3509,  1921,  1354,  1940,  1941
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3892
static const int yypact[] =
{
   -3892,   765, 18258, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, 20280, -3892,
   -3892, -3892, -3892, -3892, 92032,   380, -3892, -3892, -3892, 58432,
   -3892, -3892, -3892,   393, 63712, -3892, 67072,   785, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, 70912, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, 50740,   836, -3892,
     348, -3892, -3892, -3892, -3892, -3892, -3892, -3892,   833,  5352,
   -3892, -3892, 67552, -3892,    64, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, 68032,   351, -3892,   658,   895, -3892,    65, 12787,
   -3892, -3892, 59392, 64672, -3892, -3892, 71392,   618,   327,  1472,
    7557,   833, 19797, 71872, -3892,  2054, -3892, 47819, -3892, -3892,
   -3892, 64192, -3892, -3892, -3892, -3892,   839, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, 78112,  2579,   721, 48308, -3892,
   -3892, -3892, -3892, 78112, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, 72352, -3892,   855,   865, 78592, 79072,
   61312, -3892,  1235, -3892, 78112,   254, 50259, -3892, 79552, -3892,
   -3892,   871, -3892, 72832, -3892, -3892, -3892, -3892,   721, -3892,
   50740, 45390, 72832,    66,   771, -3892, -3892, 80032, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892,  1317,   972, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,   351,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,   621,
   -3892,   157,   876,  1606,  1072, -3892, -3892, -3892, 10010, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, 93463,  1719, -3892, -3892,
   -3892,  1019, -3892,  1095, -3892, -3892, -3892,  1217, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892,   679, -3892, -3892, -3892, -3892,
    1583, 92509, 70912, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, 58912, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892,   153, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, 70912, 70912, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, 70912,  1225, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892,   428,  1384, -3892, -3892, 50740,  1926,
    1926,  1715, 93463, -3892, -3892, -3892, 51702, 78112, 78112,  1419,
   78112,  1610, 51702, 78112, 78112,  1566, 41469, -3892, 78112, 78112,
   78112, 78112, 72832, 78112,  1485, 78112, 78112, 80512, 78112,  1653,
   -3892,  1920,   606, -3892, -3892, -3892, 78112,  2377,  2579, -3892,
   -3892, 78112,  1532, 51702, 78112,  1410,  1534, 78112, -3892, 78112,
    1829,  1262, 78112,  1507, 41962,  1621, 78112, 78112, 78112, 78112,
   -3892, -3892,  1629, 78112, 78112, -3892, 80992,  1289,  1887,  1804,
      48, -3892, -3892,  1974,  1575, -3892, -3892,  2017, 70912, -3892,
   68512, -3892, -3892, -3892,   310, -3892, 72832, -3892, -3892, -3892,
   -3892, 61792,  1472, -3892, -3892, 52183, 78112,  1855, -3892, 81472,
   -3892,  1937, 52664, 81952, -3892, 42455,  2039, 82432, 82912, -3892,
   -3892, 83392, -3892, 83872,  1727, 84352, -3892, 84832, -3892,  1868,
   85312, -3892, 19156, -3892,  1644,  1810,  1667,  1231, 70912, 70912,
    1355, 37104,   351, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892,   139,  1551, 48797,   234, 49286, -3892, -3892,   594,   669,
     715,   139,  2089,  2089,   559, 70912, -3892, -3892,  1551, -3892,
     416,   514,  1677,  1677,  1677,  1857,   794, -3892,  1677, 78112,
   -3892, -3892, -3892, -3892, 72832, 48797, 49286, -3892,  1686,  2579,
      22,  2079, 78112, -3892, 78112, -3892, 78112, 78112, -3892, -3892,
   -3892,  2097,  1729,  1952, -3892,  1721, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892,  1917,  1942,  1936,    -4,  2579,  1853, -3892,
   -3892,  1965, 26232,   928, 70912,  2579, 49775, 73312, 90112,   175,
   61792,  2579, 85792,  1812,   606,  2015, -3892,   707, -3892,  2227,
    1866,  2110,    58,   606, 39040, -3892,  1906,  1420, 72832, 93940,
   -3892, -3892, -3892, 86272,  2018, -3892,   569,  2196, 26730, -3892,
   78112,  1924, -3892,  1930,  1932,  1954, -3892, 78112,   255,   255,
    2321,   255,  1392,  1537, -3892,  2132, -3892,   771,   833,  1955,
   -3892, -3892, -3892,  1970, -3892,  1962,  1969, -3892,   445,  2231,
   -3892, -3892, -3892, -3892,  2042,  2070,  2073,  2074,  2024,  2098,
     280, -3892, -3892, -3892, -3892,  2317, -3892, -3892, -3892, -3892,
   -3892, -3892,  2419,  2410, 59392, 59392,   597,   644,   127,   245,
   -3892, -3892, -3892,  2284, -3892, -3892,  2281, 78112,  2118, 78112,
   -3892, -3892, -3892, 86752, -3892, -3892,  1926,  1970,  2077, -3892,
     186, -3892,  1420, -3892,   261,   389,   437,  1120,  2058,  1226,
   -3892,   176,  2086,  2925,  2078,   296,  2629,  2089, -3892, 78112,
   78112, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
    2092, -3892, -3892,  2087,  1054,  1219,  4551,  1166,  2770,  1597,
     662,  2267,    35,  2382,  1279,  3085, 78112,  2099,  2330,   -19,
   -3892,   444, -3892,  2167,  2295,   394, 51702,  2123, -3892, 78112,
   -3892, -3892, -3892, 51702, -3892,  2305, 42948, -3892, 78112, -3892,
   -3892, -3892, -3892,  2255, 78112, -3892, -3892,  2362, 78112, -3892,
    1677,   802,  2163,  2513, 55069, 78112,  2190,  2561,  2202, -3892,
   -3892,  2190, -3892, -3892, 78112, 78112,  2185,  1194,  2190,  2586,
    2587,  2264,  2373,   798,  1787,    88,  2500,  2190, 78112, 78112,
   78112, 78112,  2583, 51702, 78112, -3892,  2381, 73792, -3892,  2249,
    1974, -3892, -3892, -3892, -3892, -3892,   852,  2308, -3892, -3892,
   -3892, -3892,  2549,  2077,   188,  2554,  2269,  2560, -3892,  2306,
    2567,  2078,  2588,  2290, -3892, 87232, 87712,  2591,  2092, 78112,
    2604,  2290,  2605,  2494,  2612,   188,  2613, -3892,   948,  2614,
    2503,  2616,  1589,  2290, 62272,  2621,    76, -3892, 21220, 19156,
   -3892, 21781,  1426, -3892, -3892, -3892, -3892, -3892, -3892, 30216,
     712,  2413, -3892, -3892,   771, -3892, -3892,  1600, -3892, 47330,
   -3892,  1355,  1551, -3892, 70912,  1551, 70912,   559,  1551, 70912,
    1551, 70912,   559,  1551, 70912, 70912, 70912,  1551, -3892, -3892,
    1613,  1690, -3892, -3892, -3892, -3892, -3892, 70912,  2334, 78112,
   78112, -3892, -3892, -3892, 65152, 78112, 65632, -3892,   578, -3892,
      98, 70912, -3892, 70912, -3892,  2579, -3892, -3892,  1810, 55069,
    2729, 78112,  2618,  2618,  2618, -3892, -3892, -3892,  2558, 78112,
    2620,  2622, 65152, 78112, -3892, 88192,  2341, -3892, -3892, -3892,
   -3892,  1607,  2643,   407,  2699, 30216,  2343,   363,   363,  2347,
   -3892, -3892, -3892,   454,  2348,  2349, -3892,   215,   215,  2502,
    2351,  2352, -3892,   494,  2353, -3892,  2707,   517,  2354,  2356,
    2357,  1843,   363, 30216, -3892,  2359,   215,  2361,  2364,  2365,
    2715,  2368, -3892,  2733,  2370,   223,   334,  2372,  2374, -3892,
    2351, -3892,   463,  2376,  2378,  2380,  2383,  2385,  2388,  2389,
   30216, 30216, -3892, 25236, -3892,  2579, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892,    80, -3892,   537,  3794, -3892, -3892,  2537,
   30216, -3892, -3892,   191, -3892,   623, -3892, -3892,  1420, -3892,
   -3892,   335, -3892, -3892, -3892, -3892,  1511,  1511,   185, -3892,
   67552, 67552, -3892, -3892,   184,  2379, -3892,   258, -3892, -3892,
   -3892, -3892, -3892, -3892, 59872,  2769, -3892,  1111,   444,   908,
    2728, 46352, 46841,  2628,  2628,  2598, -3892, -3892, 78112, -3892,
   -3892, 30216, 44428, -3892,  1420,    81,  2627, 78112, -3892, 39524,
   -3892, -3892, -3892,  1632, -3892, -3892, -3892,   351, -3892, 12557,
   -3892,  1639,  1924, 78112, 78112,  2790, -3892, -3892,  1930, -3892,
   -3892,  1606,  1606, 30216,  1606,   918,  1197, 27228, 30216,  2677,
    2574,   566,  1092,  2679, -3892,  1392,  1537, -3892, -3892,  1970,
    2408,  1650, -3892, 56992, 92986, 92986,  2642, -3892, -3892,   678,
     483,  2517,  2610,  2089,  1370,  1441, -3892, -3892,  2407, -3892,
    2734, 67552,  2462, 59392, -3892, -3892, 78112, -3892, -3892, 74272,
   -3892, -3892, -3892,  1763,  2412, -3892,  2429, 78112,  2906, -3892,
    1441,  1441, -3892, -3892,  2416, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, 93463,  2420, 78112, -3892,  2421,  2423, -3892,
   93940, 44909,  1423,  1420,  2499,  2501, 50740,  2422,  2504,  2506,
   90592, -3892, -3892, -3892, -3892,  1218,   756,  1066,  2507,    86,
   -3892, 78112,  2606,   280,  2541, -3892,  2508,  2509,  2623,   280,
     595, 91072, -3892, -3892, -3892, -3892, -3892,  1908, 23282, -3892,
   -3892, -3892,  2511,  2496, 60352,  2802,  2624,   872,  1533,   120,
   78112,  2697,  2518,  2521,  2454,   -66,  2453, -3892,  2619,  2512,
    2515, 54107,  2631, 43441,  2788,  2542, -3892,  1191,  2543,  2544,
     280, -3892,  2849,   280,   280,  1104,  2853,  2546,   159,  1598,
    2190,  2453,  2860, -3892,  2477,  2550,  1638, -3892,  2649,    93,
    1730,  2453,  2551,  2556,  2454,  2454, 78112, 78112, 78112, 78112,
   78112,  2559,  2562,  2599, 68992,  2563, 90112, -3892, -3892,  2566,
    2127,  2453,  1281, -3892,  1337, -3892, -3892,   606, -3892, 78112,
   -3892, 78112,  2077, 55069,  2662,  2078,   280, 78112, 78112,  2092,
    1117,  1020,  2664, 78112,  2725,  2533, -3892, -3892,  2190, -3892,
   44909,  2185, -3892,  2505, -3892,  2545, -3892,  2545,  2545,  2510,
    2510,  2514, -3892, -3892,  1843,  2545,  2510, -3892, 56031, -3892,
    1368,  1371, -3892,  2898,  2902, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892,   906, -3892,  1647, -3892, -3892, -3892,
    2913, -3892, -3892, 55069, 78112, -3892,  2830,  2565, 50740, -3892,
    2552, -3892, 78112,  1091,  2579,  2564, 78112,  2731, 78112, 78112,
   78112, 78112, -3892, -3892,   654,     1, -3892, 68992, -3892,  2860,
    2910,     6,  1677,  2807, -3892, 78112,  2522,  2922,  2759, -3892,
   -3892,  2530,  2089, -3892,  2249, -3892,  1766, -3892,  2647, -3892,
   34186,  2570, 51702,   188, -3892, -3892, -3892, -3892, 55069, 78112,
   88672, 51702,   188, 78112, 78112,  2826,  2590,  2832,  2593, 43441,
     188,   111, 78112, 78112, 78112, 78112, -3892, 78112, -3892, -3892,
   -3892, -3892, 78112, 78112, 78112, 68992,  2834,  2835,   188, 78112,
   78112, -3892, -3892, 21308,  1514, -3892, 19156, -3892, 12557,  1656,
    2628, -3892,  1225, 78112,   912,  1355, 66112, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, 70912, -3892, 70912,   559,
   -3892, -3892, 70912, -3892, 70912,   559, -3892, 70912, -3892, -3892,
   -3892, 70912, 78112,  3038,  2557, -3892,   335, -3892, 78112,  1665,
   -3892, -3892,  1675,   478, 78112,   487, 51702, 78112,  2737, 78112,
   78112, 78112, 78112,  2625,  2379,   -85, -3892,  2608, 38556,  2686,
   -3892,   172, 72832,  2738, -3892, -3892, -3892, -3892, -3892,  1681,
    1990,   812, -3892, -3892, -3892, -3892, -3892, -3892, 65632, 64192,
    2839,    15, 78112, -3892, 30216, 25734, -3892, -3892, -3892,  2568,
   12557,  2602, 30216, -3892, -3892, 30216,  2089,  2089, 30216, -3892,
   -3892, -3892, -3892,  1074,  2089, -3892, 30216, 30216,  2089,  2089,
    2545,  2545, -3892,  3492, 30216, -3892, 43441, 30216, 31710, 22783,
   30216,  2639,  2589,  2089, -3892,  2089, -3892, 30216, 24738, -3892,
   30216,  2771, 30216,   908,  2777, 30216,   908,  2993,  2993,  1311,
    6144,  2578, -3892,  2689,  2089, -3892,  2089,  1236,   190, 55069,
   30216, 50740,  2659,   160, 30216,  2592,  1369, -3892, 30216,   600,
   -3892,  2594, 30216,  2658, 30216, 30216, 30216, 30216, 30216, 30216,
   30216, 30216, 30216, -3892, 32706,   241, -3892,   570,   938, 66592,
   26232,  2866, -3892, 22284, -3892,   142, 70912, -3892, -3892,  1420,
   -3892, -3892, -3892, -3892, -3892,  1763,  2595, -3892,  2609, -3892,
   -3892, -3892, -3892, -3892, 78112,  2769, -3892, -3892,  2661, -3892,
   -3892, -3892, -3892,   671, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892,  2607, -3892, -3892, -3892, -3892, -3892,  2607, -3892, -3892,
    2628,  2626,  4413, -3892, -3892, -3892, -3892,  2856,  2869,   188,
   93463, -3892, 78112,    28, -3892, -3892, -3892,  2630, -3892, 78112,
     569, 69472, -3892, 26730, -3892,  1689,  2351, -3892,  2851, -3892,
    2611, -3892, 10563,  2851, -3892, -3892,   143,  2792,  2793,  2793,
   -3892,  2617, 12557, -3892,  1872, 12557,  1894, -3892, -3892, -3892,
   -3892, -3892, -3892,   -36, -3892,  2677,  1092,  1822, -3892,  1970,
   -3892, -3892, 19237, -3892, 20757, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892,  2633, -3892, -3892, -3892, -3892,   280,
    2638,  3089, -3892, 59392, -3892, -3892, -3892,  3038, -3892,  2017,
   -3892,  2017,  3114, -3892, 70912, -3892, -3892, -3892, -3892,   981,
   -3892, 19156, -3892, 19156, -3892,  2640,  1703,  2693,  2694,  2740,
   78112, 78112, -3892, 50740, 78112, 78112, 78112, -3892,  2980,  1070,
   64192,  2744, 62752, -3892, -3892,  2644, 78112,  2680,  2870,  2876,
    2648, -3892, -3892, 78112, -3892,  2833, 78112, 30216,  2836, 78112,
    1165,  2843, -3892,   869, 78112, 78112,  2821, -3892, -3892, -3892,
   61792, -3892, -3892, -3892,  2816, -3892, -3892, 56031, -3892, -3892,
    1738, -3892, 55550, 53145, -3892, -3892,   731, 78112, 78112, 78112,
     789, -3892, -3892, 55069, -3892, 78112, 78112, 78112, 69952, 89152,
   89632,  1001,  1016, 78112, 70432, -3892, 78112, 78112, 78112, 50740,
   -3892, 78112,  2831,   133, -3892,  3687,  2721, 78112, 78112,  2663,
    1741,  2732, -3892, 78112, 78112,  2442, -3892, 78112, 78112, -3892,
   -3892,   280, -3892, -3892, -3892, -3892, -3892, 78112, 78112,   280,
   78112,   280,  1220, -3892, 51221, 78112, -3892, -3892, -3892, 78112,
   78112, 78112, 78112, 78112, -3892, -3892,   666,   701,  2797,  2803,
    2804, 78112, 78112, 78112, -3892, -3892,  2767, -3892, 78112,  2442,
   78112, 78112,  2745,  2746,    94,  2818, -3892, -3892, -3892, -3892,
   -3892, -3892,  2914,  3073, 78112,  2915,  2916,  2739,  2742,  2917,
    1751, 78112, 78112, 78112, 78112, 78112, 78112,  2931,  1751,  2863,
      27,  2700,  1756, -3892,  2716, -3892, 30216,  3097, 55069,  2706,
    2708,  2775, -3892,  2778,  2089, -3892,  1798, -3892,   654,  1802,
   -3892,   435,  8422,  2989, 78112,  1806, -3892,  2724, 78112,  8422,
   -3892,  1590, 64192, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892,  2990, -3892,  2579,  2185,  2185,  2185,  2185, -3892,
   -3892, -3892,  2891,  1625, -3892,  2714, 78112,  2822,  8422, -3892,
    2860,  3006, 78112, 60832,  1901,  3112,  2579,  2893, -3892, 23767,
    4226,  2894, 61792, 73792, -3892,  2727,  2985,  2987,  3005, -3892,
   33702, 74752,  2735,  1830, -3892, 74752, 75232, -3892,  2736,  1420,
   27726,  2686,  2077, -3892,  3122, -3892,  3020,   188,  2078, -3892,
    2290, -3892, 78112, 78112, 78112, 78112,  2092, -3892, -3892,  2290,
    2905,   188,   188, -3892,  2908,   188,  2290,  2838,  3017, 61792,
   -3892,    76, -3892, -3892, -3892, -3892, -3892, 30216, -3892, -3892,
    2741,  1766, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, 70912,  2017, -3892,  1819, -3892, 78112, -3892,
    2995,  2997,  2998,  2290,  2774, 78112,  2748, -3892,  2290,  2089,
    2290,  2379,  2379,  2290, 75712,  3153,  3021, -3892,  1839, -3892,
   -3892, 26232, -3892,   106, -3892,   502,   735,  2953, -3892, -3892,
   -3892, -3892, 55069, -3892, -3892, -3892, -3892, -3892, 78112,    47,
    2928,  2753, 75712,  3135,   188, -3892,  1844, -3892,  1519, -3892,
    1580, 30216, 30216,   229, -3892, 11439,  1878,  2757,  2758,  1883,
   -3892, -3892, -3892, -3892, -3892, -3892,  2762,  3035, -3892, -3892,
    2764,  1886,  1892,  2768,  2776, -3892, -3892,  5461,  2779, 11553,
    2781, 31710, 31710,   998, -3892, -3892, 31710,  2785, -3892,  1905,
    7044,  2772,  2786,  2787, -3892,  2789,  2791, 11584, 28224, 30216,
   28224, 28224, 11903,  2772,  2794,  1922, 50740, 12318,  1933, -3892,
   30216, 50740,  5504, 30216, -3892, 30216, 78112,  2795,  2798, -3892,
   -3892,  3492, -3892,  2796, -3892, 31710, 31710,  3456, 25236, -3892,
   -3892,  3064, -3892, -3892,  1439, -3892,  2805, -3892, -3892,  4756,
     206, 30216,  2592, 30216,  2864, 43441,  8286, 30216,  4061,  4700,
    4700,   311,   311,   119,   119,   119,  1608,   938, -3892, -3892,
   -3892,  2806,  2368, 30216, -3892,  1949,  2016, 78112,  7358,  8686,
   -3892, -3892, -3892, 34186,  2840, 30216, 30216, 30216,  2809,  2963,
    3215, 12557,   751, -3892,  3224, -3892, -3892, -3892,  1560,  3114,
    1763, -3892,   606,  2089,  1236, 47330, -3892, -3892, -3892, 30216,
   -3892, -3892, -3892, -3892, -3892,  1939, 39524,  2570, 26730,  1420,
    1930, -3892, -3892, -3892, -3892, -3892, -3892, 30216, -3892, -3892,
     292,  1869, 30216,  1872, -3892, -3892, 78112,  2738,  2738, 30216,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892,  -115, -3892, -3892,
   -3892, -3892, -3892, -3892,  2811, -3892,  2810, -3892,  2829, -3892,
   -3892, -3892, -3892,   156,  2817,  2814,  2819,   966, -3892, -3892,
   78112, 78112, 78112, -3892, -3892, -3892, -3892, -3892, -3892,  3040,
   -3892, 78112, 78112,  3000, 78112,  2994,  3001, 30216,   548, 78112,
    2828,  2841,  2842, 78112,   188, -3892, -3892, 12557, -3892, -3892,
    2879,  2899, 78112,  2649, -3892,  3077, -3892, -3892, -3892, -3892,
    3023, -3892, -3892,  1647, -3892, 53145, 55550, -3892, 55550, -3892,
    1647,  1349, -3892,  2290, -3892, -3892,   632, -3892, -3892, -3892,
   -3892, -3892,  3124,   188,  3136,   188, 78112, 78112, 78112, 78112,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892,  1951, -3892,   775,
   -3892, -3892, -3892, -3892, -3892, 78112,  1330, -3892,   620, 55069,
   -3892, 54588, 78112, -3892, -3892,  3066, -3892, -3892, -3892,  3002,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,  1831, -3892,
    3007, 78112,  2901, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, 50740, 50740, 50740,  1966, -3892, -3892,  2579, -3892,
   -3892, -3892,  2919, -3892, -3892, -3892,  3061,  3062,  3067,  2930,
    2932,  2933,  2936, -3892,  2937,  2938,  2939, -3892, -3892, -3892,
   78112, -3892, -3892, -3892, 78112, 78112, -3892, -3892, -3892,  1751,
   55069,  3092,  1751,  1751, 78112, 78112,  1751, -3892, -3892, -3892,
    3095,  3104,  3105,  3107,  3110,  3113,  1751, -3892, -3892, -3892,
   -3892,   802, 50740, -3892,  1846, -3892,   310, 40976,  6223,  2880,
    2708,  2881,  2089, 36620,    72,  3084,  2885, -3892,  1645,  3100,
    2904,  2904,  2904,  2904,  2904,  2904,  2904, -3892,  2194, -3892,
    3058, 78112,   754, 78112,  2089, -3892, -3892,  2954, -3892, -3892,
   50740, 40976,  1677,  1091,  3022,  1422,  3223, -3892, -3892, -3892,
   -3892, -3892, 78112, 78112,   654,  2579,  1986, -3892, 55069, 78112,
   70912,  1317,  2897, 78112,  2900,  2895, -3892, -3892, -3892, -3892,
    1992, -3892, 55069,   439,  3074,  3076,  1317,  2970, 78112, -3892,
    2014,    61, -3892,  2579, 61792, 53626, -3892,  3975, -3892, -3892,
     979,  3169, -3892, 78112, -3892, -3892, 38072, 35638,  1830,  2903,
   78112, -3892,  2907, 34186,  3137,  3071, -3892, 34186,  3071,  1159,
    3071,  3139, -3892, 40008, -3892,  2909, 22284,  1506,  3088, 12557,
   -3892,   188, 55069, 78112, -3892,   188,  2961,   188,  2962,   188,
     188, 78112, -3892, -3892, 78112, -3892, 78112, 68992,   188, -3892,
   12557, 78112,  3193, -3892, -3892, -3892, -3892,  3029,  3031,  3032,
   78112,  2290, 51702, -3892,  2918, 78112,  1073, -3892, -3892,  3090,
   -3892,  1317, 78112,  1420,  2920, -3892, -3892, -3892, -3892,  3210,
    3214, -3892, -3892, -3892, 78112, 65152,   152, 78112, -3892, -3892,
   -3892, -3892,  2927,  2019, 12352, 30216, -3892,  3225, 55069, -3892,
   -3892, -3892, -3892, -3892, 30216, -3892, -3892, -3892, -3892, -3892,
   30216, -3892, 30216,  3201, -3892,  3342,  3342, 55069, 31710,  1316,
    2361, 31710, 31710, 31710, 31710, 31710, 31710, 31710, 31710, 31710,
   33204,   787, -3892, -3892, 30216, 30216,  3211,  3201, -3892, -3892,
    1452,  1452, 55069,  2934,  2772,  2940,  2941, 30216, -3892, -3892,
    2028, 50740, -3892, 30216, 10962,  2034,  2977, 12455,  1420,  6261,
   -3892,  3306,  2579, 30216,  1909,  1989, 30216,  2035, 30216,  3218,
   -3892, -3892, -3892,  2945, -3892, -3892, 55069, 30216, 31710, 31710,
    4995, -3892,  5804, 30216,  2946,  6533, 25236, -3892,   721,   721,
     721,   721, -3892, 78112, 78112,  2735, 30216,  3206,   -30,   -30,
    2947,  2963, 40492, -3892, 30216,  1344, 28722,  2950, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892,  2951, -3892,  2968, -3892, -3892,   444,  2958,
   -3892, -3892, 10226,   156,  2974, 78112, -3892,  2686, -3892, -3892,
   -3892,  2971, -3892,  1869, -3892, -3892, -3892,  6461,  3143,  2379,
   -3892, -3892, -3892,  2089,  2975, -3892,  2017,  1560, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892,  2904,  2290,  2290,   753,
    2290,  3252,   753,  6680, -3892, -3892, 34670, 78112, 78112,  2038,
   -3892, -3892, 78112, -3892,  2058, -3892, -3892,  3217,  1503, -3892,
   -3892, -3892,  3036,  2194,   818,  2454,   132, -3892,  3039, 78112,
   -3892, 78112, -3892, -3892, -3892, -3892, -3892, -3892, 50740, 40976,
   50740, -3892,  3049,  3050,   652,   608,  3051,  3053,  2984,  2996,
    2999, -3892,   139,  2579, -3892, -3892,  2579,  2290,  2579, -3892,
   -3892, -3892, -3892, 51221, -3892, -3892, 78112,  3266,   521,  1633,
   78112, 78112, 78112, 78112, 78112, 78112, 78112,  2649, -3892, -3892,
   -3892,  3003,  1751, -3892, -3892,  3228,  3230, -3892,  1751,  1751,
    1751,  1751,  1751,  1751, -3892,   114,  2056, -3892, 36123, -3892,
   -3892,  2561,  2561,  1085, -3892,  2561, -3892,  2561, -3892, -3892,
    2716,  2971,  2089,  1441, -3892, -3892, -3892, -3892, -3892, -3892,
    1325,  2089,  1944,  2991, -3892, 37588, -3892, -3892, -3892,  2215,
    1236, 78112,  2904, -3892,  2052,  2037,  2120,  2555, 76192, 76672,
   77152,  3008, 78112, 31710, -3892,  1367,   567, -3892,  3221, 78112,
    3042, -3892, -3892, -3892,  3015, -3892,  2290, 78112, 78112,  2290,
   -3892, 55069, -3892, -3892,  3392,  1231, 78112,  3033,  3004,  3282,
   -3892,  3016,  3018, -3892, -3892, 78112, -3892,  3058,  1667,  3052,
   63232,  1901, -3892,  3254, 60832, -3892, 78112, -3892, -3892, -3892,
    3378,  3101,  3057,  2579,  2680, -3892, 53145, 30216, 30216, -3892,
    3025, -3892,  3026,  4271, -3892,  2185, -3892, -3892, -3892, -3892,
   -3892, -3892,  3099, 78112,  3442, -3892, -3892, 74752,  3030, 78112,
    1830, 34186, -3892, -3892,  2010, -3892, 34186,  3262, -3892, 34186,
   78112,  3037, 78112,   838, 78112, -3892,  3043,   188, -3892, 78112,
   -3892, 78112, -3892, -3892,   188,   188, -3892,  3142, -3892, -3892,
    1317, 78112, 78112, 78112,  2290, -3892,  2089, -3892,  3303, 75712,
   -3892, -3892, -3892, -3892, -3892, -3892,    15,  3313, -3892, -3892,
   -3892, -3892, 30216, 12557, -3892,  3044, 12557,  6813, 12557,  3211,
   -3892,  2195,  3315, -3892,  1343,  3041,  2195,  1550,  1550,   337,
     337,   112,   112,   112,  3342,   787, 12557, 12557, -3892, -3892,
   -3892, -3892,  3046, -3892, -3892, -3892,  2772, -3892, 30714, -3892,
   -3892,  3078,  3083,  3059, -3892, 30216, 31212,  3048, 56031, -3892,
   -3892,  1236,  2993, 31710, 31710,  1871, -3892,  1007, 30216, 55069,
    2060,  1871,  2119,  2182, 30216, 30216,  6988,   242, 30216,  7249,
   78112, 78112, 78112, 78112, -3892, -3892, 12557,  3430,  3318, 30216,
    3063, -3892,  3065,  2963, -3892, 91552, -3892, -3892, 12557, -3892,
   -3892, 30216, -3892,  2963,  1560,   738,  2579, -3892, -3892,   771,
   -3892, -3892, 43441, -3892, -3892, -3892, -3892, 19156, -3892, -3892,
   -3892,   139, -3892, -3892, -3892,  3129, 64192,  3329,  1325, 30216,
    2063, -3892,  3096, 77632, 24252,  2064,  2071,  3042, -3892,  2422,
   -3892,  3126, -3892,  3251, -3892, -3892,  3253,   139, 78112, -3892,
   55069,   188,   188, -3892, -3892,  3086, 78112, 78112,  2089,  2089,
   55069,  3079, -3892,  2089,  2089,  3080, -3892, 78112, 78112, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, 78112, 78112,
   78112, 78112,  3366, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892,  3311, -3892,  1751,  1751, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892,  2190,  3393, -3892, 50740, -3892, 57472, -3892, -3892,
   -3892, -3892,  2579,  2579,  3263, 45871,  2579,  2579, -3892,  1389,
    3400, -3892,  3332,   860,  3087,  1434,  3358, -3892,  1840, 37588,
   37588, 37588, 37588, 37588, -3892, -3892,  3363,   139, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, 30216,  1388,  2195, -3892, -3892, -3892, -3892,
    3042,  1677,  3141, 50740,  2290,  2290,  3144,  1317,   395, 78112,
    3395,  3130, -3892,  2579, -3892, -3892, -3892,   670, -3892,  2095,
   -3892, -3892, -3892,  3132,  3076,  1201,  3106,  1901, -3892, -3892,
     921, 78112, -3892,   722, -3892,  3371,  3109, -3892, 12557, 12557,
    2579, 56512,  3975, -3892, 78112,  3344, 78112, -3892, -3892, 78112,
    2115, -3892, 30216,  3111, -3892, -3892, 34186,  2010,  2131, 78112,
    2138, 55069,  2963, -3892,   188, -3892,   188,   188, -3892, -3892,
   78112,  2290,  2290,  2290, -3892,  3278, -3892,   188, 75712, 12557,
   -3892, -3892, -3892, 31710,  3380, -3892,  3116, 55069, -3892,  3118,
    2147,  2157, -3892, -3892, -3892,  7760,  3156, 12557,  3208,  3119,
    3121, -3892,  1306,  1306,  1007,  2165, -3892, 31710, 31710,  1871,
    1871, 30216,  1871, -3892, -3892, -3892, -3892, -3892, 30216, 30216,
    3157,  2963,  2963, -3892,  3283, -3892,  3123, -3892, -3892,  1441,
   -3892, -3892, -3892, -3892,  1236, -3892,  3127, -3892, -3892, 75712,
    3301, 75712, -3892,  7842,  3042, 34670, 43934, 78112, -3892,   246,
     246,  3265,  3042,  3141, -3892, -3892, -3892, -3892, -3892,  3180,
   -3892, -3892, 40976, -3892, -3892, 35154, 43441, -3892,   652,  3131,
    3133,   608, -3892, -3892,  1126,   -37,  3165,  2290,  3414,  1751,
   -3892, -3892,  2700,  2579, -3892, -3892, -3892,  2178, -3892, -3892,
   -3892, 78112, -3892,  3004, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, 51702,  3529,  3529, -3892,  1576,  1576, -3892, -3892,
   -3892, 78112,  1325, -3892,  7899,  3319, -3892,  3141,  3346,  3391,
   -3892,  2192, -3892, 78112,  3057, 60832,  3058, -3892,   747,  3140,
    3433, -3892, -3892,  3472, -3892, 63232,  3317,  3101,   949,   949,
   78112,  3076,  3268, -3892,  3270, -3892,  3511,  3325,  3514, 78112,
   34670, -3892, 55550, -3892,  2193, -3892, -3892,  2840, 78112,   435,
   -3892,  3168,  2201, -3892, 12557, 78112, -3892, -3892, -3892,  2212,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892,   152,   962, 31710,
   55069,  2223, 30216, -3892, 30216, -3892, -3892, -3892,   464, -3892,
   -3892, -3892,  1306,  1306,  1871,  2772, 12557, 78112, -3892, -3892,
   -3892,  3534,  3331,  2963, -3892, -3892, -3892, -3892,  1073,   753,
     152, 77632,  3141, -3892,  3161, -3892, -3892,  1869,  1869, 78112,
    3141,  1325, 30216, -3892, -3892, 55069,  2078,   -84, -3892, 55069,
   55069, -3892, 78112, 78112, 78112, 78112, 78112, -3892, -3892, -3892,
   -3892, 57472,  3004,  3529,  1017, -3892, -3892, -3892,  3445, -3892,
   -3892,   894,  3345,  3248, -3892, 50740,  3460, -3892, -3892, -3892,
   -3892, -3892, 30216,  3320, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892,  2224,  3101, -3892, -3892,
    3348, -3892,  3349, -3892,  2234, -3892, -3892,  4271, 56512,  3489,
   -3892, -3892,  2246,  3599, -3892,  2240, -3892, -3892,   962,  2243,
   -3892,  2254,  2262,  3229, -3892,  3181, -3892,  3579, 30216,  1365,
   -3892, -3892,  3461, -3892,   246,  3226, 43441, -3892, -3892,  1677,
    1325, -3892, 12557,  2283, -3892, -3892, -3892,  3326,  2291,  2301,
    3184,  3222,  3184, -3892,  2290, -3892, -3892, -3892, -3892,  3494,
   -3892, -3892, -3892,   189, -3892,  3369,  3372, 78112, -3892, 78112,
    3586,  8553, 51702,  2194, -3892, -3892, -3892, -3892,  3232, 34670,
    3975, -3892,   219, -3892, -3892, -3892, 78112, -3892, -3892, -3892,
   -3892, -3892, 78112,  3200,  2772, 29220, 29220,  3202, 75712,  1869,
    3205,  1325,  3209,  3346, -3892, 51702, -3892, -3892, -3892, 78112,
    3321,   982,   982,  3522, -3892,  3259, -3892, -3892, -3892,   652,
   -3892,  3212,  2454,  3101, -3892, -3892, -3892, -3892,  1714, -3892,
   -3892, -3892, 32208,  3330,   849, 11090, -3892, -3892, -3892, -3892,
     152, -3892, 30216, -3892, -3892,  3345,  2078, -3892,  3130, -3892,
    3621, -3892,   706, -3892, -3892,  3079, 57952, -3892,  2840, -3892,
    1480, -3892, -3892, -3892, -3892, -3892, -3892, -3892,  3611, -3892,
   -3892, -3892, -3892, -3892, -3892,  9474,  1325, -3892,  3506, -3892,
   -3892, -3892, -3892,  2309, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892,  1339, -3892, -3892,  1484,  1954, 29718, -3892, -3892,  3361,
   -3892, 57952, -3892,  1480, -3892, 51702, -3892, -3892,  3220, 57952,
    2318, -3892
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3892, -3892,  3362, -3892, -1140,  -363,  1976, -1557, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892,  1270, -3892, -3892,   -57,  1535,  2209,   957,
   -3892, -1312, -3892, -3892,  -885,   168,  -974, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892,   914,  1391,   837,  2730, -3892, -1655,
   -3892, -3892,   316, -3892, -3892, -3892,   716,  -342, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892,  -104, -3892, -3892,  -499, -1745,
    -108, -3892, -3892, -3892, -3892,   181,  -389, -1542, -3892, -2819,
   -3892,  -146, -3892, -3892, -3892,  -390, -1619,   892,  -964, -1337,
    1173,  -631, -3892,  -292, -3892,  -669,  -589,  -587,  -633, -3892,
   -3340, -3190, -3446, -2859, -3892, -3892, -3892,   196, -3892, -1744,
   -3892, -3892,  1914, -1584, -3892, -1045, -3892, -3892, -3431, -3892,
    1474,  -394, -3892,   -44, -3892, -3892, -3892, -3892, -3892, -3892,
   -3390, -3892, -1660, -3892,   323, -2865,   804, -3892, -3892, -3892,
    1934, -3892, -3892, -3892, -3892, -1762, -3892, -3892, -1733, -3892,
    1322,   697, -3892, -3892, -3892,  -656,  -714,  -703, -3892, -3617,
     -86,   -83, -3892, -3892, -3892, -3892, -1207, -3892,   725, -2933,
   -1139, -3892, -3892,   764, -3892, -3892, -3892,  -608,  -276,  1968,
   -3892,  -532, -3892, -3892, -3892,  -275, -3892, -3892, -3892, -3892,
   -3892, -3892, -1874,  3276, -1100, -3892, -3892, -3892, -3892, -2066,
   -3892,  3609,    -1,   648, -1725, -3892,  -208,  -120,  2432, -1345,
   -2555,   161,  -409, -3892, -1921, -3892, -3892, -3892, -2476, -3892,
   -3892, -3892, -3892, -3249, -1724, -3892, -3892, -3892,   227, -3892,
   -3415, -3591, -3780, -3200, -3892, -3892, -1269, -3892, -3892, -3892,
   -1573,  1489, -1625, -3892, -2210,   231, -3439,  -982, -3025, -3892,
   -3394,  -485, -3892, -3892, -3892, -3892, -3892, -3892, -3892, -1258,
    -837, -3892, -3892,  2911, -3892, -3793, -3892, -3892, -3892, -3892,
    1069, -3892,  -596, -3892, -3892, -3892, -3892, -3892, -3892,  -603,
    -675, -3892, -3892, -3892,   230, -3892, -3892, -3892, -3892,  1400,
   -1148,  -980,  2780, -1723,  -314, -3892, -3892, -3892, -3892, -2853,
   -3892, -3892, -3892, -3892, -3892, -3892, -3892, -1450, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892,  1641,  1646,  -113,  -214, -3892,
   -3892, -1477, -3892,  -809, -3892,  1889, -3892, -3892, -3892, -3892,
   -3892,   282,   260,   -75, -3892, -3892,   637, -2384,   -72, -3892,
   -3892, -3892, -3892,  -309,   -71, -3892,  1038, -3892, -3892, -2051,
   -3892,   285,  2325,  2516,  1264,   -73,    -9,  -235,  -213,  -207,
   -3892,  2766,  2275, -3892, -3892,  -195,  1486, -3892, -1055,  -338,
   -3892,  1032,  -900,  1624,  2265,  2263, -3892,  1026, -3892, -3892,
    1036, -3892, -3892, -3892,  -892,  1635, -3892,  2268,  1654, -3892,
    1679,  1094, -2446,  1342, -2392,   719,  -506,  -101,  -128,  2801,
    2957, -3892, -3891,  1077, -3382,   305,  1685, -2041, -1748, -3892,
   -3892, -1359,  8186, -3892, -3892, -3892,  8948, 11000, -3892, -3892,
   13781, 13817, -3892, -1230,   590, 14287,  6136, -1384, -1772, -1497,
   14411,  -650, -1341, -1830, -3892, -3892, -3892,  -316,   609,    68,
   -3892, -3892, -3892,  -497, -2644,  -496, -3892, -3892, -3892,  -500,
   -3335,  1338, -3892,  -798, -3892, 15431,  1080, -3892, -1295, -2551,
   -2627, -1361, -1899, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -1462, -3048,  -585,  1161, -3892, -3892,  1248, -3892, -3892, -3892,
   -1478, -1110, -1992,  1164, -2026, -3892, -1046,  1285,  1790, -1012,
    4486,  -891, 12451,  -133, -2275, -1494, -1386, -3892,  -704, -3892,
      59,  2375,  -159, -3892,   116,   197,    77, -2901, -3892, -3892,
     302, -3892, -3892, -3892,  3250,   778, -3892,  2632, -3892,  1390,
    2030, -3892, -3892,  1663,  -933,   -31, -3892,  -469, -3892,  -132,
   -3892, -3892, -3892,   150, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892, -3892, -3892,  2315, -3892, -3892, -1421, -3892, -3892, -3892,
   -3892, -3892,  3536,  -296, -3892,  2967,  -291, -3892, -3892, -3892,
   -3892, -3892, -3892, -3892, -3892, -3892,  2326,  1695, -3892,  2773,
   -3892, -3892, -3892,   -58,  2531, -3892, -3892, -3892, -1162,  -607,
    2799,  2800,  1659, -3892, -3892, -3892, -3892, -3892, -3892, -3892,
   -3892,  1672, -3892, -3892,  1145, -2044,  1673, -3892, -3892,   552,
   -3892, -3892,   177, -3892,   553, -3892,  2427, -3892, -3892, -3892,
     576, -3892, -3892, -3892,  -594, 10464,   225,  -116,   171,  1046,
   -3892,  5374, 12246,   -33,  2342,    57,  7904, 13055,   233, -3892,
    3526,  1674,  1359, -1006, -3892,   -40,  1978,  8540, -3892, -1115,
      23,    -2, -3892,  2143,  -645, -1142,  2634,  -720, -1856, -3892,
    3933, -3892, -2944, -3892,  -923,  2973, -1188
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2407
static const short yytable[] =
{
      80,   796,  1015,   343,  1628,   348,   344,   346,   968,  1362,
    1363,  1065,  1882,  1073,  1367,  1505,  1268,  1931,  1989,   881,
    1575,   893,  1283,  1962,  1919,    79,  1291,  1236,  1171,   968,
    1890,  1577,  1643,  1048,  1706,  2551,  1303,  2281,  1846,  2340,
    2517,   877,  2445,  1758,  1747,  2587,   796,  2000,  1647,   680,
    2437,   976,   942,  2313,  1518,  1596,  2156,  1118,  2019,  2020,
    2555,    74,  2046,   691,  3118,  2322,  1171,  3196,  2378,   349,
    1080,  2768,   990,  2928,   840,  1081,  3403,  2035,  1288,  2384,
    2385,  2177,  3586,  1781,   799,  2487,  1821,   682,  2464,  2465,
    1016,  1825,  2219,  2221,  2222,  1045,  1122,  3439,  1831,  3441,
    2466,   691,  2887,  2889,  1053,  2311,  2629,  1848,  2467,  2468,
    2469,  2784,  1138,  1626,   796,  3313,   929,  1171,  1154,  1526,
    3180,   885,   892,  3132,  3134,  1067,  3498,   969,  3543,   799,
    3310,  1323,   892,  3767,  1873,   395,  3902,  3140,  2373,   852,
    1075,   395,  2321,  2547,  3942,  1512,  1076,  2794,   969,  1222,
     886,  4042,  2262,  3753,  1946,   356,   349,   904,  1920,  1036,
    3498,   356,  3945,  2213,  2213,  2156,   965,  3915,  2061,  1915,
    2817,  1676,  1569,   892,  1113,  1654,  2789,  2013,  2014,  3058,
    1572,  1604,  1605,  4050,   982,   850,  3368,   965,  3515,  3516,
    3517,  3518,  3519,  3520,   356,  2114,  1845,   799,  3678,   416,
    3227,  1273,  2032,  1874,  3308,  3309,  2485,  2069,  1281,  2833,
    1748,   416,  1312,  2837,  2063,   416,  1135, -1685, -1685, -1685,
   -1685,  3924,  2331,  1393, -1685,    45,   967,  2196,  3958,    45,
    3960,  -127,  2072,   794,   399,  2157,  2324,  1064,  1874,   356,
    -127,  2996,  3577,  1262,   841,  -127,   261,   967,  2623,  1378,
      37,    38,    39,    40,  3019,  2753,  1775,    44,  3147,  1617,
    3149, -2405, -2405, -2405, -2405,  2603,  4289,  2287, -2405,  4217,
    4218,  1656,  2704,  2922,  3194,   355, -2405,  1253,   794,  1874,
    4325,   355,  1618,   343,  1933,   348,   344,   346,   797, -1579,
   -1335, -1335, -1335, -1335,  1055,  2699, -1579, -1335, -1378, -1378,
   -1378, -1378,  -343,   394,  1070, -1378,  3785,   356,   321,   394,
    1755,  4246,  2217,  2287,   355,  1874,  3185,   416,  2704,  4406,
      37,    38,    39,    40,  1350,  1006,    43,    44,  1397,  1619,
    2492,    45,  1006,   797,  1006,  4233, -2406, -2406, -2406, -2406,
    2738, -1595,   394, -2406,  1074,  1981,   794,  2739, -1595,   349,
     803, -2406,   416,  1020,  1559,  2798,  1509,  2106,  2341,   355,
     342,    43,  3017,   347,  1068,  2188,    45,  2218,  2121,  1769,
    1758,  1109,  1514,  2409,  1657,  4391,  1741,  1158,  2105,  1498,
     357,    35,  2604,  4053,  2595,  3033,   809,   394,   810,    41,
      42,  1680,  3363,  2125,   402,   803,  3030,  1922,  1891,  2069,
    2288,   797, -1833,  2342,  2343,  1742,  1007,   416,  1171, -1378,
   -1378, -1378, -1378,  1007,  2189,  1007, -1378,  2046,  1701,  1908,
    1884,  1069,   684,   395,  2072,  3227,   897,   355,  2122,  3205,
    2019,  2020,  4234,  1254,  1743,  2799,  2339,  2035, -1368, -1368,
   -1368, -1368,  1011,   356,  1932, -1368,  3786,  1021,  1560,  1011,
    4336,  1011,  1875,  1123,  1756,   394,  2158,  2099,   395,  3020,
    2923,   956,  1098,   803, -2403, -2403, -2403, -2403,  1884,  2498,
    1586, -2403,  2132,  2289,  1975,  3729,  2145,  2145,   356, -2403,
    4407,   957, -1368, -1368, -1368, -1368,  3794,  1875,  1255, -1368,
    1991,  1070,  1762,  2332,  1681,  4248,  2415, -1368,   813,  1765,
   -1785,  1366,  2001,  2486,   881,  2333,  4117,  3186,  2493,  1607,
    1610,  2419, -2402, -2402, -2402, -2402,  1137,  1658,  3498, -2402,
    1884,  1081,  1935,  3761,  1379,  2379,   261, -2402,  1875, -1997,
   -1997, -1997, -1997,  2786,  4379,   814, -1997,  2997, -1363, -1363,
   -1363, -1363,  1639,  3787, -1997, -1363,  3788,  4470,  4156,  1856,
    3578,  1107,  1366,  1116,  1117,  2605,  2334,  2013,  2014,  2437,
    2102,  3868,  1389,   355,  1875,  2032,  3841,   246,  1056, -1348,
   -1348, -1348, -1348,  2606,  2435,  1659, -1348,  4169,  2369,  2705,
    2371,  1910,  2064,  1613,  3385,  3613,  1982,  4141,   321,  1914,
    1828,   394, -1375, -1375, -1375, -1375, -1579, -1363,   355, -1375,
    2148,  2149,  1071,  1982,  4321,  1114,   885, -1833,  3183,  2408,
    3239,  3982,    37,    38,    39,    40,  1884,  2092,  2292,    44,
    4314,  2576,  3351,  2412,  2297,  3288,   394,  2156,  1651,  2127,
    2874,  2767,   962,   963,  2339,   886,   962,   963,  2431,  4392,
     342,  2115,  1531,   347, -1685,  2802,  1532,  2740, -1595,  1115,
    4212,   685,  -127,  -127,   892,   892,  3033,  3639,  4220,  3877,
     357,  2584,   811,  2175, -1833,  2359,  1682,  3734,  2362,  2363,
    2235,  1109,   130,   131,   898,  2205,  3400,  3600,  3401, -1833,
    2517,  3604, -2133,  2206,  2275,  1149, -1785,  2886, -2405,  3742,
    1124,  4267,   796,  2041,  2632,  2302,  2100,  2664,    37,    38,
      39,    40,  3268,  4384,  1178,    44,  1065,  1587,  2580,  2626,
    2628,  2042,  3187,  1122,  1188,  3424,  2446,  2018,  2720,  2492,
    2636,  2416, -1682,  2639,  1226,  2043,  3337,  4290,  1331,  3465,
    3466,  2651,  2652,  2356,  4137,  4285,  4258,  1576,  1620,  1621,
   -1785,  2870,  3343,  3819,  2669,  2671,    37,    38,    39,    40,
    3898,  2566,   899,    44,   900,  2685,  2277,  2569,  1264,  1977,
    2559,  2976,  3348, -2406,  4423,     3,  3567,  2977,  1053,  2845,
    4303,  1915,  2278,   962,  1595,  1126,  1278,  2894,  2220, -1172,
    2298,  1161,  1162,  1163,  1565,  1164,  1165,  1166,  1167,  1168,
    1169,  2819,  1332,  2819,  1338,  1540,  1343,  1541,  2953,   702,
    2655,  2656,  1347,  1217,  2041,  1189,  2089,  2090,  2091,  2092,
     416,  1736,   845,    37,    38,    39,    40,  3496,  3425,    43,
      44,   956,  2042,  2008,    45,  1350,  1338,  1343,  1326,  1321,
    3404,  4355,  3236,  3237,  3238,  3239,  2045,  3803, -1335,  4478,
    2479,   957,  2953,  2721,  4132,   896,  1219,  2722,  4360,  1567,
    4146,  3496,  1737, -1172,  2216,  1094,  1369,  1109,  4147,   892,
   -1816,   804,  2299,  1606,  2978, -1368,  2352,  2008, -2133,   395,
    1358,   805,  2581,  1098,  2313,  3227,  1188,    37,    38,    39,
      40,  3798,  2723,  2585,    44,   356,  3899,  4460,  2495,   356,
    2872, -2403,  2275,  3820,  1531,  3584,   956,  4125,  1532,  1270,
     904,  2582,  2279,  3188,  1317,  1171,  2373,  2276,   892, -1368,
    1609,   969, -1335,   969,  2480,   969,   957,  3586,  2217,  1095,
    1369,   969, -2133,  2517,   794,  4106,  4107,  4108,  4109,  4110,
      80,   349,  1064,  3460,  1520, -1834,  3463,  3464,  3804, -2402,
    3467,  2339,   956,  1545,  4404,   969,   969,  1838,  4304,  1757,
    3474,  4277,  1336,  2742,  1341,    79, -1997,  4438,  2591,  2592,
    4312,  3426,   957,  3751,  2277, -1363,  4405,  1189,  1502,   806,
     215,  1508,  1865,  2218,  1096,  1516,  4133,  1097,  1350,   797,
    2278, -1863,  3799,  3762,  1371,  1373,   847,  1377,  1839,  3537,
    3427,    74,  2530,  1109,  2280,   691,  2024,  2558, -1172,  2284,
     223,  2539,  3340,  2724,  1738,   355,  3405,  2979,  4148,   355,
     967,  1351,   967,  2546,   967,  1394,  1359,  4317,  4318, -1375,
     967,  1348,  1349,  1499,  1866,  4461,  2069,  1511,  1270,  1513,
    1542,  3406,  1865,   394, -1175,   234,  2980,   394,  4122,  2066,
     992,   803,  2981,  3858,   967,   967, -1816,   237,  4268,  1351,
    3227,  2072,  2536,   416,  2876,  3229,    37,    38,    39,    40,
     969,  2136,    43,    44,  1397,  1619,  3800,    45,  1098,  1098,
    4450,  2982,  2743,  2583,   680,   680,  2588,  4448,  2590,  1627,
    1978,  2593,  2441,  1399,  2561,  1070,  3227,  3037,  1739,  4023,
   -1172,  1171,  2330,  2481,  4269,  2069,  1351,  1898,   807,  4027,
   -1816,  4270,  3742,  2137,  2482,   979,  1536,  4142, -1175,  4429,
    2279,  1867,   682,   682,  4026,   993,  2562,  1630,  3189,  4143,
    2072, -1834,  4340,  1599, -1172,  2103,   356, -1172,  4337,  4224,
    4259,  4271,  3783,  2380,  1628,  3538,  2877,  2184,  1899,  1521,
    1840,  4484,  1629,   983,  1006,    35,  1095,  3763,  1006,    37,
      38,    39,    40,    41,    42,  3951,    44,  4260,  1868,   967,
    3955,  3498,  1099,  3957,  1119,  3588,  2518, -1863,  2522,  2422,
    3977,  1867,  1070,  2773,  3860, -1834,  3764,  2528,  1622,  4421,
    2983,  1100,    35,   416,  2822,  3190,    37,    38,    39,    40,
      41,    42,    43,    44,  4221,   991,  1522,    45,  4451,  2658,
    4272,  1096,  2280,  1828,  2442,  3948,  2076,  2077,   934,  3496,
    2423,  1389,  1858,  3395,  1776,  1777,  1698,  2283,  1868,  1779,
   -1335, -1863,  1087,  2185,  1841,  1007,  1365,  2776,  1065,  1007,
   -2407, -1335,  4029,  2018, -1335,  1646, -1335,  4341,  1171,  3589,
    1869,  2859,  1088,  1626,  2618,  3228,   355,  2284,   848,  2461,
    2640,  3635,  1089, -1175,  3315,  2080,  3316,  2327,  4250,  3145,
    2313,  1011,  1154,  4338,  3419,  1011,  3229,   813,  3068,  3069,
    3070,  3071,  4144,  1058,   394, -2407,  1050,  2364,  3150,  3420,
    3234,  3235,  3236,  3237,  3238,  3239,   994,   995,  4430,   969,
    1900,  -796,  2129,  2517,  3750,  1980,  1098,  2517,  4342,  1366,
    1869,  1704,  1270,  3650,   814,  1043,    80,    80,  2328,    80,
    1565,  2767,  3399,  3349,  2641,  1122,  2956,  1884,  2464,  2465,
    2664,  2664,   349,  2462,  2959,  2664,  2961,  1270,  3230,   813,
    2466,    79,    79,  2171,    79,  3586,  3203,  2250,  2467,  2468,
    2469,  3962,  1081,  3316,  3966, -1175,  3967,  1317,  2178,  2179,
    1090,  2183,  1599,  4315,  1076,  1076,  2336,  1076,  4431,   349,
    1496,  4320,  2424,  4273,  2664,  2664,   814,    74,    74,  2642,
      74,  3590,  2643,  1986,  1901,  1567,  1793,  4199,  4200, -1175,
    2285,  4432, -1175,  3141,  3254,  2420,  2906,  3125,   967,  2443,
    4348,  1399,  2006,  2364,  3227,  3627,  3832,  2130,  2365,  3854,
    2366,  2908,  3835,  3836,  3837,  3838,  3839,  3840,  2444,  3137,
    4138,  2022,  2441,  3277,  1091,  3126,   796,  1497,  1568,    37,
      38,    39,    40,  4177,  1705,   861,    44,  2893,  -159,  3591,
    3606,  2087,  2088,  2089,  2090,  2091,  2092,  2907,  3568,  3128,
    2269,  2049,  2119,  2120,  3855,  2421,  2425,  4353,  2061,  4139,
    2270,  2851,  2909,  -159,  2059,  3234,  3235,  3236,  3237,  3238,
    3239,  1644,   861,  2062,  2644,  2271,  3033,   796,  2459,   691,
     691,  2870,  3372,  2067,  1620,  1621,  1095,   969,  1066,  1092,
     863,   969,   969,  2104,  4208,  2488,  4210,  3231,  3232,  3233,
    1645,  3234,  3235,  3236,  3237,  3238,  3239,  1724,  1724,  2155,
    2087,  2088,  2089,  2090,  2091,  2092,  2871,  1725,  3858,  3662,
    4166,  3663,  1270,   937,  2365,  2134,  2366,   863, -1184,  1270,
    1270,  2852,    43,  1651,  3521,  1084,  3389,    45,   815, -1184,
     796,  1096,  3037, -1184,  2442,   938,  3984,  2219,  3985,  3130,
    1599,   157,  3638,  2232,  1599,  1599,   849,    37,    38,    39,
      40,  3896,  1074,  1074,    44,  1074,  3773,  2645,  2187,  4310,
    1708,   931,  2711,   680,  2712,   209,   939,  1648,  3318,  3523,
     691,  3319,  3320,  4096,  3229, -1184,   967,  1077,  3639,  3859,
     967,   967,  3321,  3322,  3323,  2713,  3324,  3325,  1017,  1709,
    1746,  3326,  3327,  3328, -1184,  4232,  1649,  2272,  2188,  2831,
     209,   682,  1339, -2197,   962,  1595,  1344,  1345,  1346,   356,
    1565,  3897,  1018,  2155,  1566,   176,  1357,  3111,  2228,   870,
    2872,   871,  2402,   969,     8,  1650,  1098,  1952,  1726,   969,
    3664,  1884,  3279,  4097,  3280,  1399,  3230, -1184,  3227,  3860,
    3665,   395,   395,  2246,  2248, -1184,  1125,  2189,   794,  1745,
    1953,  2403,  2224,   209,  1349,  3281,   870,  -365,   871,  2156,
     356,   356,   356,  4102,  3158,  2225,   157,  3986,  2226,   813,
     969,  3422,  2238,   969,   969,  1567,  2324,  1119,  1746,  2245,
    2247,  3312,  1248,  2714,  2329,   416,  1599,  1229,  2715,  1230,
     395,  4103,  1599,  2716,  3171,  1651,  2069,  2254,  2404,   794,
    3423,  4030,  4115,   797,  1617,  2767,   814,  3527,  2405,   215,
     356,  1249,   796,    37,    38,    39,    40,   356,  1568,  2443,
      44,  2072,   967,   356,  2377,  4375,   969,  1618,   967,   355,
    2145,  1136,  2406,  1599,  3329,  3548,  1599,  1599,  3875,   223,
     176,   856,  3528,  1065,  1005,   901,  2525,   215,  1651,  4376,
    3784,  3789,  1250,  1042,  3529, -1216, -1184,   394,  3282, -1216,
    2227,  3659,   794,  3283,  2257,   803,  1006,  4080,  4081,   967,
     122,  2517,   967,   967,   234,  1150,  2517,   223,   956,  2517,
     355,   355,   355,  3398,  1152,  3679,   237,  1006,   126,  1599,
    2767,  2620,  3338,  2258,  3359,  2457,   193,  3830,   957,  3234,
    3235,  3236,  3237,  3238,  3239,   232,  2518,  2717,   394,   394,
     394,  1905,   234,  1326,  1556,  1248,  2718,   797,  3229,   246,
   -1216,   861,  2259,  4420,   237,   967,    37,    38,    39,    40,
     355,  1906,  2470,    44,  3530,   416,  2110,   355,  2041,  2111,
    -790,  2041,  4482,   355,  3546,  4483,  3402,  1007,  4256,    45,
    3647,  2018,  3496,  2263,  2608,  3821,  2042,   246,   394,  2042,
    3330,  2511,  1006, -1216,  2783,   394,  3680,  3681,  1007,  1081,
    2043,   394,   215,  2045,  1180,  3822,   863,  3284,  2619,   803,
    3230,  1316,   416,  1011,  1842,  1250,  3285,  2664,  3294,  1157,
    2664,  2664,  2664,  2664,  2664,  2664,  2664,  2664,  2664,  2664,
     157,  4037,   223,  1843,  1011,   356,    37,    38,    39,    40,
    3331,    80,  1224,    44,    80,  2614,   349,  2617,  2615,  2616,
    1531,  2504,  2041,  3064,  1532,  3710,  1186,  1171,  3163,  4001,
     232,  1916,  1232,  1127,  1233,  1917,    79,   234,  1732,    79,
    2042,  3922,  4286,  1007,   794,  1128,  1129,  2664,  2664,   237,
    4000,  2313,  3039,  3073,  1187,   796,  2068,  2376,  3074,  2069,
    3377,  3378,  3686,  3380,  1221,  1130,  3479,  1733,  1131,  1064,
    1225,  1734,    74,  3511,   176,    74,  2030,  2031,  3074,  1011,
    1936,   349,   246,  1938,  2072,  2370,  1942,  1556,  1944,  2073,
   -1172,  1947,  3124,  1237,  1399,  1951,  1735,  3227,   215,   797,
    3781,  3332,  3352,  1228,  3040,  2018,  1531,  2263, -1685,  3480,
    1532,  3225,  3226,  4237,  3703,   870,  3241,   871,  1243,  1916,
    3200,  2648,  2341,  2554,  2557,   355,   873,  2804,   223,  4439,
     193,  3852,  3853,  3481,  1662,  3856,   875,  3857,  2702,  3037,
   -2407, -2407,  1251,  3234,  3235,  3236,  3237,  3238,  3239,  2518,
    3775,  3776,  3482,   394,  1252,  3274,  3275,  1545,  3125,  1257,
    3437,   803,  2853,   234,  2856,  1663,  2709,  2342,  2343,  3483,
    3007,  3871,  3872,  3873,  1399,  2637,  2638,  3227,  3041,  3042,
    1132,  3201,  1260,  2650,  3484,  3202,  3126,  2653,  2654,   416,
    1721,  3043,  1731,  3253,  3704,  3255,  3256,  1275,  3544,  1751,
    2339,  3127,  2675,  1925,  2676,  1926,   215,  2005,   246,   246,
    3128,  1279,    37,    38,    39,    40,  1298,  2381,  2075,    44,
    1133,  2690,  1664,  2697,  2693,  2698,  2517,    37,    38,    39,
      40,  2774,  2847,  3129,    44,  2169,   223,  2170,    45,  2076,
    2077,  1304,  2172,  3044,  2173,    81,   969,   796,   356,  2018,
    3434,  1646,   932,  1665,  2341,  2209,  2210,   130,   131,  2556,
    3536,  2557,  3539,  1289,   232,  3485,  3848,  2796,  2577,  1319,
    2578,   234,  3124,  3486,  2238,    45,   157,  3229,  2579,  1360,
    2578,  4243,  2664,   237,  2611,  1364,  2612,   794,  2080,   969,
    1758,  1375,  2795,   680,  1884,    37,    38,    39,    40,  2342,
    2343,  2081,    44,  1381,  1399,  3487,  2839,  3227,  2612,  1627,
    3130,  1386,   937,  1109,  1387,  3773,  4440,   395,  3881,  3581,
    2933,   396,  1388,   796,  4007,  1389,  3045,   396,  3046,  3352,
    2155,   682,  2339,  3878,   938,  2506,  2507,   356,  3125,  3230,
     157,  2884,   797,  2885,  2930,   967,  2931,  1630,  1390,    80,
     176,    80,  1599,  3730,  3732,  2810,  2811,  3229,   796,  3025,
     396,  3026,  4206,  3352,  1392,   939,  3126,  1399,   355,   395,
    3227,   395,  1629,  1391,    79,  1065,    79, -1240, -1240,  3634,
    1399,  3127,   209,  3227,  2301,  1395,  1668,  4008,   967,   356,
    3128,   356,  1669,  1396,  3779,   887,   394,  1517,  1513,  1670,
    2018,  3883,  2263,  3646,   803,   396,  2919,  1746,  1622,  3059,
      74,  3060,    74,  3129,   176,  1672,  4152,    35,   416,  3230,
    3773,   969,  3165,  1673,  2578,    41,    42,  2209,  2815,   969,
    3521,   969,    45,  3869,  3870,  3871,  3872,  3873,  3952,  1068,
     356,  1523,  3181,  4105,  3182,  3522,  1519,  3199,  4005,  2557,
   -1217,  1524,  1012,  3065, -1217,  3354,  3355,   355,  4330,  1012,
    4332,  1012,  2664,  2664,  2087,  2088,  2089,  2090,  2091,  2092,
    3093,  3094,  1674,   396,  3298,  3523,  3299,  3524,  3943,   794,
    1525,  3209,   215,  2557,  1599,   394,  3212,  3229,  2557,  3216,
    3130,  2557,  1599,  3991,  1599,  3217,  1069,  2557,  3231,  3232,
    3233,  1530,  3234,  3235,  3236,  3237,  3238,  3239,  3243,   355,
    2557,   355,   223,  3865,  3866, -1217,   356,  1539,  3009,  2518,
     967,   697,  1546,  2518,  3317,  3259,  3009,  2557,   967,  1553,
     967,   703,  1554,  3851,   797,  1556,  3262,   394,  3263,   394,
     232,  3300,  3344,  3301,  3345,  1563,   215,   234,  3525,  3230,
    3229,   356,  1994,  1995,  3417,   794,  3418,  1557, -1217,   237,
     355,  1578,  3953,  3229,   668,  1580,  1070,   844,  1154,  3442,
    1584,  3443,  3067,  1065,  1589,  1196,   223,  1585,  3231,  3232,
    3233,   895,  3234,  3235,  3236,  3237,  3238,  3239,   394,  3554,
     794,  3555,   246,  1588,  3097,  3565,   803,  3566,  3360,  3361,
    1270,  3117,  1590,  3036,   232,  1591,  1592,  1197,  3526,   396,
     797,   234,  3230,  3527,  2401,   940,  3922,  3575,  4093,  3576,
    1198,  1600,  3651,   237,  2557,  3230,  1593,  1601,  1199,  3773,
    1594,  3687,  1200,  3688,  1603,  4085,   355,  3694,  3706,  3695,
    2557,  3777,  1109,  2578,   396,   797,  1632,  1270,  3528,  1633,
    1635,  2341,  1201,  3303,  3304,  1562,   941,  1564,  1661,  3844,
    3529,  3845,  1646,  4006,   394,  2612,  4044,  4051,  4045,  2578,
     796,   355,   803,  1202,  4052,   796,  2578,  1071,  3661,  1641,
    1678,  3666,  3667,  3668,  3669,  3670,  3671,  3672,  3673,  3674,
    3675,  1703,  2935,  3849,  1701,  1740,  2342,  2343,  4134,   394,
    4135,  2936,  2937,  2938,  1744,  1753,  1203,   803,  3231,  3232,
    3233,  1754,  3234,  3235,  3236,  3237,  3238,  3239,  4163,  1759,
    1884,  3352,  3605,  1761,  3608,  1763,  4181,  1204,  1766,  2339,
      37,    38,    39,    40,  4168,  1773,  3555,    44,  3712,  3713,
    3530,  4170,  2664,  3555,  1771,  2939,  3904,  3905,  3173,  1783,
    4183,  1205,  4184,  3260,    37,    38,    39,    40,  3265,  1651,
    4185,    44,  2557,  4152,  1643,  1780,  2664,  2664,  4191,  1822,
    2612,  3231,  3232,  3233,  1824,  3234,  3235,  3236,  3237,  3238,
    3239,  4240,  2518,  4241,  3231,  3232,  3233,  1828,  3234,  3235,
    3236,  3237,  3238,  3239,  2940,  4254,  4287,  4255,  4288,  2059,
    1832,  -176,  4082,  4035,  4294,  1834,  1884,  1206,  3869,  3870,
    3871,  3872,  3873,  2709,  1836,  4296,  3874,  3555, -1339, -1339,
   -1339, -1339,  1847,  4195,  1684, -1339,  4300,  4354,  2612,  2124,
    1685,  1854,  3297,  2941,   827,   969,  3885,  4358,   827,  4359,
    3971,  3972,  3973,  4367,  2511,  1884,  4368,  4437,  2612,  2942,
    2943,  2944,  2945,  2946,  4242,  2947,  1862,  4369,  1207,  3263,
    1870,  1872,  1208,   356,  1209,  4370,  1877,  2557,   356,  1686,
    1210,  1878,  1879,  1270, -1346, -1346, -1346, -1346,  1880,  1881,
     887, -1346, -1337, -1337, -1337, -1337,  4385,  2948,  2612, -1337,
   -1340, -1340, -1340, -1340,  4387,  1884,  2612, -1340,  1599,  1211,
    1883,  1212,   794,  1889,  4388,  1213,  2612,   794, -1338, -1338,
   -1338, -1338,  4480,  1214,  4481, -1338,  1892,  1893,  1215,  4299,
    1687,  4491,  1894,  4481,  1895,  1897,  1902,  1688,  1904,  2238,
    1689,  1903,  3339,  1909,   967,  1923,  1958,  1990,  2664,  1996,
    1216,  1992,  1998,  2004,  1999,  2012,   796,   796,   796,  2015,
    2016,  2017,  2021,   246,  2023,  2026,  2027,   797,  2028,  2029,
    2949,  2034,   797,  2036,  4323,  1684,  2037,  2038,  4328,  4329,
    2039,  1685,  2040,  3895,  2047,  2097,  2048,  2128,  2050,  2150,
    2051,  1690,  2052,   355,  2124,  2053,  2950,  2054,   355,  4302,
    2055,  2056,  2139,  2951,  1350,  2160,  2952,  2518,  2176,  1566,
    1568,  2203,  2518,  2208,  2215,  2518,   796,  1098,  2223,  1803,
    1686,   394,  2229,  2233,  2231,  4036,   394,  2241,  2242,   803,
    2244,  2249,  2251, -2349,   803,  2253,  2263,  4074,  4075,  4085,
    4077,  2260,  2293,  2261,  2291,  1691,  2264,  4118,  2265,  2286,
    2294,  2295,  2296,  2317,   796,  2324,  3435,  2318,  3558,  2336,
    2337,   396,  2326,  2338,  1171,   396,  2339,  4324,  2345,  1146,
    2346,  1687,  4086,  2353,  2347,  1146,  3445,  2348,  1688,  4327,
    1692,  1689,  2351,  2360,  2354,  2357,  2358,  2367,  2368,  2374,
     881,  1724,  2375,  2382,  3596,  1710,  2393,   969,  2383,  3478,
    2414,  2391,  2426,  2428,  2392,  2398,  1146,  3009,  2400,  1693,
    3009,  3009,  2429,  1694,  3009,  2008,  2438,  2436,  3559,  2439,
    2448,   858,  2018,  4374,  3009,  2458,  2024,  2454,  2491,  1779,
    2474,   969,  1690,  3572,  2499,  3499,  1726,  2457,  1695,  2496,
    2501,  3508,  2502,  1711,  2503,  2509,  2520,  1265,  2532,   356,
     356,   356,  2533,  3595,  2534,  2535,  2548,  2549,  1146,   892,
    1599,  1662,  2573,  4002,  4003,  1146,  2609,  2594,  4162,  3499,
    2589,  1065,  2574,  2601,  1988,  2597,  2622,  2632,  4162,  2673,
    2631,  2686,   349,  3553,  2674,    81,  1691,  2691,   794,   794,
     794,  2069,  1663,  2695,  1599,   892,   967,   349,  2696,  2703,
    2727,  3503,  3506,  2753,  2708,  2772,  2725,  2780,  2770,   356,
    2769,  3580,  1270,  3720,  3721,  3722,  3723,   349,  3642,  1712,
    2781,  1692,  2775,  3540,  2511,  1069,  2797,  2806,  2511,  2788,
     967,  2805,  2809,  2824,  2114,  2840,  2841,  2842,  4276,  2777,
    2849,  2854,  2859,   797,   797,   797,  2821,   356,   794,  1664,
    1729,  2823,  2861,  2838,  1694,   796,  2857,  4309,  2862,  2880,
    2863,  2882,  2865,  2925,  1713,  2868,  1714,  4457,  2921,   355,
     355,   355,  2875,  2990,  2932,  1146,  2372,  2984,  2929,  1730,
    1665,  1012,   349,  2985,  2986,  1012,   794,  2994,  2995,  2998,
    1684,  3000,  2999,  3002,  3003,  3006,  1685,   394,   394,   394,
    3018,  3004,   396,   797,  3005,   803,   803,   803,  1155,  3016,
    1716,  1146,  3022,  1174,  3029,  3027,  3032,  3034,  3033,  4215,
    3035,  3057,  1184,  3061,  3066,  3072,  3075,  3080,  3079,   355,
    3096,  3098,  3110,  3113,  3114,  1686,  3115,  3116,  3689,  4227,
    3142,   797,  3143,  3151,  3156,  1718,  3154,  1231,  3136,  3157,
    3123,  1238,  3167,  3161,  3168,  3169,  3170,   394,  1171,  3179,
    3191,  1247,  2518,  3172,  2623,   803,  3195,   355,  1366,  3197,
    3210,  3211,  3214,  1322,  3352,  3213,  1666,  3215,  1171,  1720,
    3701,  3218,  3249,  3812,  4295,  3317,  1687,  2557,  1337,  3219,
    1342,  3273,  3221,  1688,  3224,   394,  1689,  2059,  3242,  3248,
    1356,  3278,  3250,   803,  3251,  1667,  3293,  3258,  3271,   209,
    3312,  3272,   796,  1668,   796,  3314,  3306,  3286,  3296,  1669,
    1372,  1374,  3311,  3740,  -834,  3366,  1670,  3365,  3367,  1916,
    3370,  4467,  3371,  3376,  1671,  3381,  1988,   796,  3379,  3382,
    3386,  3392,  1672,  4178,  3391,  3396,  3409,  1690,   356,  1146,
    1673,  2518,  3397,  3387,  3388,  4334,  1146,  3433,  3411,  3432,
    3438,  3446,  3436,  3447,  3448,  4383,  4086,  4192,  4193,  3449,
    3462,  4226,  3450,  3468,  3451,  3452,  4467,  1819,  3453,  3454,
    3455,  3456,  3469,  3470,  4467,  3471,  2665,   794,  3472,   969,
    3501,  3473,  2226,  3512,  3502,  2919,  2350,  3795,  3510,  1674,
    3534,  1691,   969,  3513,  3545,  3541,  1146,  3547,  1154,  3560,
    3564,  3569,  3573,  3563,  3570,  3593,  3597,  3602,  3601,  3599,
    3609,  3612,  3614,  3619,  3621,  3630,  3631,  3499,  3632,  3633,
    3644,  3641,  3756,  3636,  3645,  2100,  1692,  2005,  3245,  3654,
    3227,  3813,   797,  3244,  3814,  2744,  3815,  3683,   969,  3696,
    2063,  3727,  1599,  3684,  3685,  3708,  2518,  3709,  2413,  3717,
    3733,    81,    81,  3743,    81,  1749,  3744,  3745,   355,  1694,
    3009,  3746,  1146,  3749,  3757,  1988,  3009,  3009,  3009,  3009,
    3009,  3009,  3755,  3752,  3766,  3780,  1270,  3782,   967,  4382,
    3790,  3796,  3797,  3807,  1750,  3808,   394,  3809,  3818,   668,
     668,   967,  3867,  3900,   803,   356,  3833,   356,  3834,  3810,
    3907,  1599,  3811,  3508,  3910,  3909,  3831,  3926,  2450,  2578,
    3893,  3585,  3880,  3882,  3884,  3886,  2228,  3903,  1171,  3912,
     356,  3917,  1819,  3913,  3930,  3931,  3933,  3946,  3941,  4298,
    3940,  3944,  3949,  3956,   794,  3975,   794,   967,  3970,  3959,
    3978,  2068,  3983,  3987,  2069,  3992,  3964,  3980,  1146,  3988,
    3993,  1348,  1349,  3998,  4018,  4019,  4041,  3595,  4040,   794,
    3864,  4039,  3994,  2524,  3506,  4046,  4021,  4054,  4022,  2072,
    4055,  3935,  4056,  3879,  2073,  4062,  1146,  2068,  4078,  4079,
    2069,  4083,  4091,  4098,  4068,  4071,  3859,  4104,  4101,   797,
    4111,   797,  2511,  4119,  4127,  4129,  4123,  2511,  4149,  4158,
    2511,  4136,  4038,  1146,  1146,  2072,  1146,  4179,  4140,  4175,
    2073,  4150,  4187,  4165,   797,   355,  4188,   355,  4180,  2096,
    4182,   349,  4189,  1146,  4190,  4197,  4203,  4201,  4057,  4209,
    4207,  4219,  4222,  4229,  4235,  4230,  4236,  4244,  3899,  4251,
     355,  4253,  4262,   394,  4263,   394,  4264,  4280,  4401,  4266,
    4282,   803,  4278,   803,  4279,  2518,  4281,  4292,  4308,  1937,
    2135,  1939,  3276,  4316,  1943,  1070,  1945,  4339,   394,  1948,
    1949,  1950,  4347,  4343,  1146,   396,   803,  4349,  4352,  4356,
    4357,  4426,  1957,  4362,  4366,  4371,  4372,  4373,  4378,  1910,
    4325,  4389,  4380,  4390,  4399,  3974,  1984,  4393,  1985, -2407,
    4395,  4402,  3735,  2075,  4428,  4419,  1146,  4422,  4391,  4392,
    1146,  1146,  4424,  4449,  4436,  4459,  4476,  4479,  4113,  4485,
    1079,   969,  4489,  2399,  2076,  2077,   396,   396,   396,   796,
    3063,  2147,  3341,  3407,  3793,  2074,  2924,  3475, -2407,  2075,
    4238,  4084,  4335,  4033,  4034,  3928,  4265,   969,  4116,  4275,
    3384,  3166,  4425,  4213,  2700,    80,  4456,  4396,  4394,  4434,
    2076,  2077,  3929,  2490,  2873,  4291,  3816,  3440,  4032,  2471,
    3038,  3550,  4458,  2080,  2078,  4490,   396,  4100,  4486,  4099,
      79,  4488,  1684,   396,  1819,  3542,  2081,   796,  1685,   396,
    3489,  4435,  4228,  1012,  2453,  4386,  4231,   987,  1976,  4311,
    3976,  3936,  2888,  4361,  2238,  4442,  2079,  3937,  4487,  2080,
    4257,  2791,  3478,  1271,  1012,  2563,    74,  2792,  3916,  3643,
     967,  1819,  2081,  1527,  3346,  3162,  1552,  1686,  2174,  3350,
    2814,  3009,  3009,  2199,  4124,  3362,  2200,   969,  1924,  3358,
    2813,  2204,  2787,  2808,  1819,  1270,   967,  3305,  3607,  1535,
    4089,  4090,  3119,  1267,  4094,  4095,  4167,  4065,  4066, -2407,
    3914,  3700,  4069,  4070,  3347,    35,  4301,  3508,  3508,  3508,
    3508,  3508,  3690,    41,    42,  4410,  4418,  4411,  1687,  2068,
    3353,  3206,  2069,  3291,  3289,  1688,  3184,  1112,  1689,  1012,
    2752,  3594,  1864,  3112,  2505,  2083,  2825,  4409,   349,  2070,
    2214,  1315,  2071,  1082,  2816,  2207,  1819,  2072,  2832,  1987,
    1640,  4131,  2073,  2829,  3336,  2830,  1611,  1612,  3759,  3748,
    3760,  4028,   356,  2434,  2113,  2211,  1105,  2836,  3506,  3506,
    3506,  3506,  3506,  3164,  2575,    83,   967,  1355,  4151,  1690,
       0,  1819,  1913,     0,     0,     0,     0,  2511,     0,  2087,
    2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,     0,
       0,   794,     0,     0,     0,     0,  1819,     0,     0,     0,
       0,   396,     0,     0,     0,     0,     0,     0,   668,     0,
     356,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,  1691,     0,     0,     0,     0,     0,  2665,
    2665,     0,     0,     0,  2665,     0,     0,     0,  2895,     0,
       0,     0,     0,  1146,     0,  1146,   797,     0,     0,   794,
       0,  1819,   969,     0,  1146,  1896,     0,     0,  1692,     0,
       0,     0,     0,     0,     0,     0,  1911,  2074,     0,     0,
       0,  2075,   355,  2665,  2665,     0,     0,     0,     0,     0,
       0,     0,  4205,     0,     0,     0,    81,     0,     0,    81,
    3499,  1694,  2076,  2077,     0,     0,     0,     0,     0,     0,
     394,     0,     0,     0,   797,     0,  2078,  3009,   803,     0,
       0,  4239,     0,  3103,     0,  1599,  1695,     0,  4204,     0,
       0,     0,     0,  1147,     0,     0,  1151,     0,     0,     0,
     355,  1662,     0,     0,     0,     0,     0,     0,  2079,  1146,
       0,  2080,  1182,     0,     0,     0,     0,     0,     0,  2397,
       0,   967,     0,  3031,  2081,     0,     0,  2082,   394,     0,
       0,     0,  1663,     0,     0,  1227,   803,     0,     0,   796,
       0,     0,     0,     0,     0,     0,  2068,  1146,  1146,  2069,
    1245,     0,     0,     0,     0,  1146,     0,     0,  1146,     0,
       0,  1146,     0,     0,     0,     0,  2649,     0,     0,  1146,
    1146,     0,     0,     0,  2072,     0,     0,  1146,     0,  2073,
    1146,  1146,  1146,  1146,     0,     0,     0,     0,     0,  1664,
    1146,  1146,     0,  1146,     0,  1146,     0,  2083,  1146,     0,
       0,     0,     0,     0,     0,  4475,     0,  2460,     0,     0,
       0,     0,  1819,  1146,   396,     0,     0,  1146,     0,     0,
    1665,  1146,  2397,     0,     0,  1146,     0,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,     0,  1146,     0,  1270,
       0,     0,     0,  1146,     0,     0,  1146,     0,  3104,     0,
       0,     0,  4364,     0,     0,     0,     0,     0,     0,     0,
       0,  2564,     0,  2565,     0,     0,     0,  2567,     0,  2568,
       0,     0,  2570,     0,     0,     0,  2571,     0,     0,     0,
    2397,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,     0,     0,  3192,     0,     0,
       0,     0,     0,   396,  2074,     0,     0,     0,  2075,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2076,
    2077,     0,   356,  4444,  3103,  4447,  4445,  4446,     0,     0,
       0,     0,     0,  2078,     0,     0,     0,     0,     0,   209,
       0,  4363,  1662,  1668,     0,   396,     0,   396,     0,  1669,
       0,     0,     0,     0,     0,  4444,  1670,  4447,  4445,  4446,
       0,   794,     0,     0,  1746,     0,     0,     0,  2080,  3103,
       0,     0,  1672,  1663,     0,     0,     0,     0,     0,     0,
    1673,  2081,     0,     0,    81,     0,    81,  1662,     0,   349,
       0,     0,     0,     0,     0,     0,   396,     0,  4444,     0,
    4447,  4445,  4446,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   797,     0,  1663,     0,
    1146,  4474,     0,     0,  4469,  1699,  1700,     0,     0,  1674,
    1664,     0,     0,  3106,  3585,     0,     0,     0,     0,     0,
    1819,     0,   355,     0,     0,  1819,  1819,     0,     0,  4468,
       0,     0,     0,     0,  2083,     0,  1819,     0,     0,     0,
       0,  1665,     0,     0,   349,     0,     0,     0,     0,  4469,
     394,     0,   396,     0,     0,  1664,     0,  4469,   803,     0,
       0,     0,     0,     0,  1774,  4465,     0,     0,  2068,  3104,
       0,  2069,     0,     0,  4468,     0,     0,     0,     0,     0,
    1826,  1827,  4468,     0,     0,     0,  1665,   396,  2070,     0,
       0,     0,     0,     0,     0,     0,  2072,  1853,     0,     0,
       0,  2073,     0,     0,     0,     0,     0,     0,     0,     0,
    4465,     0,     0,     0,  3104,     0,     0,     0,  4465,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,  1886,  1888,     0,     0,     0,  2665,     0,     0,  2665,
    2665,  2665,  2665,  2665,  2665,  2665,  2665,  2665,  2665,  1146,
       0,  1819,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     209,     0,     0,  2523,  3105,     0,     0,     0,   668,     0,
    1669,     0,  2529,     0,  3428,     0,  3430,  1670,     0,     0,
    2537,  2538,     0,     0,     0,  1746,  2665,  2665,     0,     0,
       0,     0,     0,  1672,     0,  2843,     0,     0,  2550,  2846,
       0,  1673,  1819,     0,     0,   209,  1684,     0,     0,  1668,
       0,     0,  1685,  1146,     0,  1669,  2074,     0,     0,     0,
    2075,  2866,  1670,  1146,     0,     0,     0,     0,     0,  2878,
    1746,     0,     0,     0,     0,     0,  1710,     0,  1672,     0,
       0,  2076,  2077,     0,     0,  3461,  1673,     0,     0,     0,
    1674,  1686,  2892,     0,  3106,  2078,     0,     0,     0,     0,
    1146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2915,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1711,     0,     0,  2079,     0,  2934,
    2080,     0,  2954,     0,     0,  1674,     0,     0,     0,  3106,
       0,     0,  1687,  2081,  1146,     0,  2082,     0,     0,  1688,
    2970,     0,  1689,     0,     0,  1819,     0,  2974,     0,     0,
       0,     0,     0,  3556,     0,     0,  2987,     0,     0,     0,
       0,     0,     0,  2991,  1146,  1146,     0,  2895,     0,     0,
       0,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1712,     0,     0,  1690,  1146,  1146,     0,     0,     0,  1146,
       0,     0,     0,  2072,     0,     0,  2083,     0,  2073,     0,
       0,  1146,  1146,  1146,  1146,     0,     0,  3616,     0,   396,
       0,     0,     0,  1146,   396,     0,  1146,     0,  1146,     0,
       0,  2068,     0,     0,  2069,  1713,     0,  1714,  1146,  1146,
       0,  1146,     0,     0,     0,     0,     0,  1715,     0,     0,
       0,  2665,     0,     0,  1146,     0,  1146,     0,     0,  2072,
    1146,     0,     0,     0,  2073,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,  2782,
       0,  1716,  1692,  3655,     0,     0,  1146,     0,  1146,  1146,
    1146,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,  3660,     0,  2778,     0,     0,     0,     0,     0,
    2779,  1717,  1146,     0,     0,  1694,  1718,     0,     0,     0,
       0,  1146,     0,     0,     0,     0,     0,  3682,     0,     0,
    1146,     0,     0,  2074,     0,  1146,     0,  2075,     0,     0,
    1719,     0,  1146,     0,     0,     0,     0,     0,     0,     0,
    1720,     0,  3287,     0,     0,     0,     0,     0,  2076,  2077,
       0,  1988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2078,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2407,
    1146,     0,     0,  2075,     0,     0,     0,     0,     0,     0,
       0,     0,  2386,  2387,  2388,  2389,     0,  2080,     0,     0,
       0,     0,     0,     0,  2076,  2077,     0,     0,  1819,  1819,
    2081,  1819,     0,     0,     0,     0,     0,     0, -2407,     0,
       0,  2665,  2665,  2417,  2418,     0,     0,     0,     0,  2427,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1819,  2080,  1819,     0,     0,     0,     0,     0,
    2068,     0,     0,  2069,     0,     0,  2081,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2083,     0,   396,   396,   396,  2072,     0,
       0,     0,     0,  2073,  2475,  2476,  2477,  2478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2407,
       0,     0,     0,     0,     0,   396,     0,     0,     0,  3490,
    1819,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2552,     0,     0,     0,
   -2407, -2407,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,  3714,     0,   396,  1819,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3373,     0,     0,     0,     0,
       0,  1819,     0,     0,     0,     0,  3906,     0,     0,     0,
       0,     0,     0,     0,     0,  1819,     0,     0, -2407,     0,
       0,     0,  2075,     0,     0,     0,     0,     0,  1819,  2087,
    2088,  2089,  2090,  2091,  2092,     0,     0,  3144,     0,     0,
       0,     0,     0,  2076,  2077,     0,  1146,     0,     0,     0,
    1146,  3152,  3153,     0,     0,  3155,     0, -2407,     0,  1146,
       0,  3159,     0,     0,     0,  1819,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3421,     0,     0,     0,     0,     0,     0,  3431,     0,     0,
    1156,     0,  2080,     0,     0,  1146,  1176,     0,     0,     0,
       0,  2665,     0,     0,  1185,  2081,     0,     0,     0,     0,
       0,     0,  1193,     0,     0,     0,     0,  1220,     0,     0,
       0,     0,     0,     0,     0,  2665,  2665,     0,  1146,     0,
       0,  1819,     0,     0,  3198,     0,     0,  1146,     0,     0,
       0,     0,     0,  1146,     0,  1146,     0,     0,     0,  3458,
    1819,  1146,     0,     0,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,     0,     0,     0,  1146,  1146,     0,
       0,     0,     0,     0,  1988,  1819,     0,     0, -2407,     0,
    1146,     0,     0,     0,   396,     0,  1146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,  1146,
       0,  1146,     0,     0,     0,     0,     0,     0,     0,  1819,
    1146,  1146,  1146,     0,     0,     0,  1146,     0,     0,  1146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1146,
     816,     0,     0,     0,     0,     0,     0,  1146,     0,  1146,
       0,     0,     0,   676,     0,  1368,     0,     0,   694,     0,
       0,     0,     0,     0,     0,  4059,     0,     0,     0,     0,
       0,     0,  1384,     0,     0,  4067,     0,     0,  2087,  2088,
    2089,  2090,  2091,  2092,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,   817,     0,     0,
       0,     0,     0,  1506,     0,     0,     0,  2665,     0,     0,
       0,     0,     0,     0,     0,     0,   694,   818,     0,  1146,
    1529,     0,  2397,   819,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   978,  2068,     0,   820,  2069,
    3637,     0,     0,  1558,     0,     0,     0,     0,     0,   980,
       0,   396,  1819,   396,     0,     0,  2070,   988,     0,     0,
       0,     0,  3649,     0,  2072,     0,   821,     0,     0,  2073,
       0,   822,   998,     0,   978,     0,   396,   823,  1019,  2068,
       0,     0,  2069,     0,  3390,     0,     0,  1047,     0,     0,
       0,     0,   824,     0,     0,  1052,  1047,     0,     0,  2070,
       0,     0,     0,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,   825,     0,     0,     0,
       0,     0,     0,  3410,     0,  3412,     0,     0,     0,     0,
       0,     0,     0,  2957,     0,     0,  3556,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   826,     0,  1819,     0,     0,     0,     0,     0,
    3001,     0,     0,     0,     0,     0,     0,  3010,  3011,  3012,
    3013,  3014,  3015,     0,  2074,     0,     0,     0,  2075,   827,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1819,
    1146,  1146,     0,     0,     0,     0,     0,     0,     0,  2076,
    2077,     0,     0,   828,  1849,  1851,  1852,     0,     0,   829,
       0,     0,     0,  2078,  1146,   830,     0,  2074,   831,  1146,
       0,  2075,  1146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3778,  3082,     0,
       0,     0,  2076,  2077,   832,  2079,   833,     0,  2080,     0,
     834,     0,     0,     0,     0,     0,  2078,     0,   835,     0,
       0,  2081,     0,   836,  2082,  1146,     0,     0,     0,     0,
       0,     0,     0,   837,     0,     0,     0,     0,  3146,     0,
    3148,     0,     0,     0,     0,   838,     0,     0,  2079,     0,
       0,  2080,     0,     0,     0,  3823,     0,  3825,     0,     0,
       0,  1146,     0,     0,  2081,     0,     0,  2082,  1146,  1146,
       0,  1819,     0,     0,     0,     0,  1146,  1146,     0,     0,
    1506,  1146,  1819,     0,     0,     0,     0,  1146,  1146,     0,
       0,  1146,     0,     0,  2083,  1988,     0,     0,     0,     0,
       0,  3615,  1146,     0,     0,  3618,     0,  3620,  1506,  3622,
    3623,     0,     0,     0,  1146,     0,     0,     0,  3628,  2068,
       0,     0,  2069,     0,     0,     0,     0,     0,     0,     0,
      81,     0,     0,     0,     0,     0,     0,  2083,     0,     0,
    1988,     0,  1146,     0,  1988,  1988,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,  3648,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,     0,     0,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,     0,     0,     0,     0,     0,  3220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   396,     0,
       0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,     0,     0,     0,     0,  3266,
    3715,   694,     0,     0,  2151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   396, -2407,     0,     0,
       0,  2075,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2076,  2077,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1819,     0, -2407,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,     0,     0,     0,  1146,
       0,     0,     0,     0,  1819,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2080,     0,     0,     0,     0,  1146,     0,     0,     0,
    1819,     0,     0,     0,  2081,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1146,  1146,     0,     0,  1146,     0,     0,     0,     0,     0,
       0,  1146,  1146,     0,     0,     0,     0,     0,     0,     0,
       0,  4063,     0,     0,     0,     0,  2335,     0,     0,     0,
       0,     0,  4072,     0,     0,     0,     0,     0,  1146,     0,
    1142,  1148,   694,     0,  1148,     0,  1142,   676,  1047,     0,
    1173,     0,   676,     0,  1047,  1819,  1047, -2407,  1146,     0,
    1148,   676,  1047,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,  1047,  2390,  1142,     0,  2068,
       0,   694,  2069,  1148,     0,     0,   676,     0,  1173,     0,
     676,  1240,     0,     0,     0,  1146,     0,  2411,  1148,  2070,
     676,     0,     0,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,     0,     0,  1269,     0,     0,     0,  1142,
       0,     0,     0,   694,     0,     0,  1142,     0,     0,  1173,
       0,     0,     0,  1146,     0,  1819,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,  1148,     0,     0,     0,  2068,     0,
       0,  2069,     0,     0,     0,  1330,     0,     0,     0,     0,
       0,     0,  1146,  1819,     0,  1146,     0,  1146,  2070,     0,
       0,     0,     0,     0,     0,     0,  2072,     0,     0,     0,
       0,  2073,     0,     0,     0,     0,  2068,  3965,     0,  2069,
       0,     0,     0,  1047,  3968,  3969,     0,     0,  1047,     0,
       0,     0,     0,     0,     0,  1146,  2070,     0,  1819,     0,
    1047,  1385,  1819,  1819,  2072,     0,     0,     0,     0,  2073,
    2541,     0,     0,     0,     0,     0,     0,  2074,     0,  2545,
       0,  2075,     0,     0,     0,     0,  1488,     0,   396,     0,
     694,  1047,     0,     0,  1269,  1146,     0,     0,     0,  2560,
       0,     0,  2076,  2077,     0,     0,     0,     0,  1047,     0,
       0,     0,  1047,     0,     0,     0,  2078,  1538,     0,     0,
       0,  1819,  1488,     0,     0,  4365,     0,     0,     0,     0,
       0,  1047,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,     0,     0,     0,     0,  1506,  1506,  2079,     0,
       0,  2080,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,     0,  2081,     0,     0,  2082,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   676,   676,
       0,  2076,  2077,     0,     0,  1146,     0,     0,     0,     0,
       0,     0,  1146,     0,  2074,  2078,     0,     0,  2075,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,  1146,
       0,  4060,  4061,     0,     0,     0,     0,     0,  1146,  2076,
    2077,     0,     0,  1148,  1148,     0,     0,  2079,     0,     0,
    2080,     0,     0,  2078,     0,     0,  2068,  2083,     0,  2069,
       0,     0,     0,  2081,     0,  1146,  2082,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,  2070,     0,     0,     0,
    1142,     0,     0,     0,  2072,  2079,     0,  1142,  2080,  2073,
    1173,     0,     0,     0,     0,  2751,     0,     0,     0,     0,
       0,  2081,  1148,     0,  2082,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1148,  1148,
    2771,     0,     0,     0,     0,     0,     0,     0,  2068,  1146,
       0,  2069,  1047,  1047,  1047,  1148,  2083,  1142,  1146,     0,
       0,  1861,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,     0,  2072,  2694,     0,     0,
       0,  2073,     0,     0,     0,  2790,     0,  2793,     0,  1148,
    1148,     0,     0,     0,  2083,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1488,  4171,     0,  4172,  4173,     0,     0,
       0,     0,     0,  1269,  2074,     0,     0,  4176,  2075,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  3500,     0,     0,  2076,
    2077,     0,     0,  1961,  1961,     0,     0,     0,  1047,  3718,
     978,     0,     0,  2078,     0,     0,     0,     0,     0,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,     0,     0,  1997,  3699,  2068,  1047,     0,  2069,  2003,
       0,     0,     0,     0,     0,  2079, -2407,     0,  2080,  1488,
    2075,     0,     0,     0,     0,  2070,     0,     0,     0,     0,
       0,  2081,     0,  2072,  2082,     0,     0,     0,  2073,     0,
       0,  2076,  2077,     0,     0,     0,     0,  1488,     0,     0,
       0,     0,     0,     0,     0, -2407,     0,     0,     0,     0,
       0,     0,  2914,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,  1488,     0,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2080,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,  2081,  2083,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   694,   694,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,     0,     0,     0,  1269,  1269,     0,  2068,     0,
       0,  2069,  1047,     0,     0,  1488,     0,  4297,     0,     0,
       0,  2161,     0,  2168,     0,     0,     0,     0,  2070,     0,
       0,     0,     0,  2074,     0,     0,  2072,  2075,     0,     0,
       0,  2073,     0,     0,     0,     0, -2407,  1488,     0,     0,
    4313,  1488,  1488,     0,  3062,     0,     0,     0,  2076,  2077,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,     0,  2078,     0,  3754,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   694,     0,   676,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4048,
    4048,     0,     0,     0,     0,     0,  2074,     0,  2323,     0,
    2075,     0,     0,     0,  1047,     0,     0,     0,     0,     0,
       0,     0,     0,  2068,     0,     0,  2069,  1173,     0,     0,
       0,  2076,  2077,  2083,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,  4076,     0,     0,     0,
       0,  2072,     0,     0,     0,     0,  2073,     0,     0,     0,
    1148,  1148,  1148,  1148,  1047,     0,     0,     0,   676,     0,
       0,     0,     0,     0,     0,     0,     0,  2079,     0,  2068,
    2080,     0,  2069,  2410,     0,  1047,     0,     0,     0,     0,
       0,  1148,  1148,  2081,     0,     0,  2082,  1148,     0,  2070,
    4454,     0,     0,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  3768,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4011,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   676,     0,     0,     0,
       0,     0,  1148,  1148,  1148,  1148,  2083,     0,     0,     0,
       0,   676,     0,     0,     0,     0,     0,     0,     0,  2410,
       0, -2407,     0,  3302,     0,  2075,     0,     0,     0,     0,
       0,     0,     0,     0,  2519,     0,  1142,     0,     0,     0,
       0,     0,     0,   694,     0,  1142,  2076,  2077,     0,     0,
       0,     0,     0,  1173,     0,     0,  3244,     0,  1047,     0,
   -2407,  3245,     0,     0,     0,     0,     0,  1047,     0,   676,
       0,     0,     0,  1148,  1148,     0,     0,  2074,     0,     0,
       0,  2075,  1506,     0,     0,     0,     0,  1047,     0,     0,
    1330,     0,  2084,  2085,  2086,  2080,  2087,  2088,  2089,  2090,
    2091,  2092,  2076,  2077,     0,     0,  3981,     0,  2081,     0,
       0,     0,     0,  4216,     0,     0,  2078,     0,     0,     0,
       0,     0,  1961,     0,  2068,     0,     0,  2069,     0,     0,
    1142,     0,     0,     0,  1047,  1047,     0,     0,     0,     0,
       0,     0,  2600,     0,  2070,     0,  1047,     0,  2079,     0,
    1814,  2080,  2072,     0,     0,     0,     0,  2073,     0,     0,
       0,     0,   978,   978,  2081,     0,  2625,  2082,  1488,  1488,
       0,     0,     0,     0,     0,     0,  1488,     0,     0,  1488,
       0, -2407,  1488,     0,     0,     0,     0,     0,     0,     0,
    1488,  1488,     0,     0,     0,     0,     0,     0,  1488,     0,
    1173,  1488,  1488,  1488,  1488,     0,     0,     0,     0,     0,
       0,  1488,  1488,     0,  1488,  4283,  1488,     0,     0,  1488,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,     0,     0,  2083,  1488,     0,
       0,     0,  1488,     0,     0,     0,  1488,     0,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,  1488,  1488,     0,  1488,     0,
       0,     0,     0,  1047,  1488,     0,     0,  1488,     0,     0,
       0,  2087,  2088,  2089,  2090,  2091,  2092,  4048,     0,     0,
       0,     0,  2074,     0,     0,     0,  2075,     0,  1047,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4331,
       0,  4333,     0,     0,     0,  1814, -1918,  2076,  2077,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2078,     0,  2084,  2085,  2086,  2168,  2087,  2088,  2089,
    2090,  2091,  2092,  1047,     0,  1047,     0,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3549,
       0,     0,     0,  2079,     0, -1918,  2080,     0,     0,  3562,
       0,     0,     0,     0,     0,     0, -1918,     0,     0,  2081,
   -1918,     0,  2082,     0,  3574, -1918,     0,     0,     0,     0,
   -1918,     0,     0, -1918,     0, -1918,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   676,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1918,     0,     0,  4398,     0,     0,     0,     0,
       0,     0,     0,     0,   676,     0,     0,  3624,   676,   694,
    3625, -1918,     0,     0,   978,     0,   978,     0,     0,     0,
       0,     0,  2083,  2133,     0,   905,     0,     0,     0,     0,
     676,  1488,     0,     0,     0,  4427,     0,   906,   676,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,     0, -1918,     0,     0,   907,     0,     0,
       0,   676, -1918,  2323,     0,     0,     0,     0,     0,  2896,
       0,     0,     0,     0,  2905,     0,     0,     0,     0,     0,
    1047,   676,   908,     0,     0,     0,     0,     0,     0,     0,
       0,  2927,  2927,     0,     0,     0,     0,   694,   676,     0,
       0,   676,   909,     0,     0, -1918,     0,     0,  2084,  2085,
    2086,  1148,  2087,  2088,  2089,  2090,  2091,  2092,     0,   676,
       0,     0,  4013,   910,     0,     0,   676,     0,     0,     0,
       0,     0,     0,     0,     0,   676,     0,     0,     0,     0,
       0,     0,   676,     0,     0,     0,     0,  1814,     0,     0,
     983,   911,     0,     0,     0,     0,   912,     0,  1148,  3724,
    3725,     0,   913,     0,     0,  1148,  1148,  1148,  1148,  1148,
    1148,     0,     0, -1918,     0,     0,     0,   914,     0,     0,
    1488,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1918,     0, -1918, -1918,  2927,     0,
       0,     0,  1047,     0,     0,     0,   978,  1814,     0,     0,
       0,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1918,     0,
    3078, -1918, -1918,     0, -1918,  2070,  1148,  3092,     0,     0,
       0,     0,     0,  2072,     0,     0,  1269,  1861,  2073,     0,
       0,     0,     0,     0,  2519,  3122,     0,   915,     0,  3122,
    3135,     0,     0,     0,  1488,     0,     0,   916,     0,  1814,
       0,     0,     0,     0,     0,     0,  1148,  2927,  1148,  2927,
       0,     0,     0,     0,   827,     0,  1814,     0,     0,     0,
       0,     0,     0,  1269,     0,     0,     0,  2068,     0,     0,
    2069,  1488,     0,     0,  1814,     0,     0,     0,   917,     0,
       0,     0,   918,     0,   919,     0,     0,  2070,     0,     0,
     920,     0,  1961,   921,     0,  2072,     0,     0,     0,  1814,
    2073,     0,     0,     0,     0,     0,     0,     0,   676,     0,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,   922,
       0,   923,     0,     0,  2068,   924,     0,  2069,     0,     0,
       0,     0,     0,   925,     0,     0,   676,  3876,   926,     0,
       0,     0,     0,  2074,  2070,  1488,  1488,  2075,   927,     0,
       0,     0,  2072,     0,  1814,  3901,     0,  2073,     0,     0,
     928,   802,     0,     0,     0,     0,     0,     0,  2076,  2077,
       0,     0,  3908,     0,     0,  1488,  1488,     0,     0,     0,
    1488,     0,  2078,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1488,  1488,  1488,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,     0,   802,  1488,     0,  1488,
    3270,     0,     0,     0,  2079,     0,     0,  2080,     0,  1488,
    1488,     0,  1488,     0,     0,  2074,     0,     0,     0,  2075,
    2081,     0,     0,  2082,     0,  1488,     0,  1488,     0,  1173,
       0,  1488,     0,     0,     0,     0,     0,     0,     0,     0,
    2076,  2077,     0,  1010,     0,     0,     0,  1488,     0,     0,
    1010,  1047,  1010,     0,  2078,     0,     0,  2519,     0,  1488,
    1488,  1488,     0,     0,   802,     0,     0,     0,     0,     0,
       0,     0,  2074,     0,     0,     0,  2075,     0,     0,  1269,
       0,     0,     0,  1488,     0,     0,  2079,     0,     0,  2080,
    2168,     0,  1488,  2083,     0,     0,     0,  2076,  2077,     0,
       0,  1488,  2081,     0,     0,  2082,  1488,     0,     0,     0,
    1047,  2078,     0,  1488,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,  4014,  4015,  4016,  4017,
       0,     0,     0,  2079,   676,     0,  2080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2081,
       0,  1488,  2082,  2927,     0,     0,     0,  1961,     0,     0,
       0,     0,     0,     0,     0,  2083,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  4186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   676,
       0,     0,  2083,     0,     0,     0,   676,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,     0,     0,  4211,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   676,     0,
       0,  2068,     0,     0,  2069,     0,     0,     0,  2927,  2927,
       0,     0,     0,     0,     0,     0,     0,     0,  2084,  2085,
    2086,  2070,  2087,  2088,  2089,  2090,  2091,  2092,     0,  2072,
       0,     0,  4249,     0,  2073,     0,     0,  3507,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4157,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1814,     0,     0,  1961,  1047,  1814,  1814,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,  1814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1047,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,     0,     0,     0,     0,     0,   694,     0,     0,
       0,  3122,     0,     0,  3598,     0,     0,  2519,     0,     0,
       0,  2519,     0,     0,     0,     0,     0,  3611,     0,     0,
    1488,     0,     0,     0,     0,     0,     0,     0,  3051,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,  1047,  2074,
       0,   676,     0,  2075,     0,  3629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1142,     0,     0,   676,
       0,     0,     0,     0,  2076,  2077,  2600,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2078,  1047,
       0,   676,  2935,     0,  1814,     0,     0,     0,     0,  1488,
       0,  2936,  2937,  2938,     0,     0,     0,     0,  1488,     0,
       0,     0,     0,     0,  1488,     0,  1488,  4247,     0,     0,
    2079,     0,  1488,  2080,     0,  1488,  1488,  1488,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,     0,  2081,     0,  1488,  1488,
       0,     0,     0,     0,     0,  2939,  1506,     0,     0,   681,
       0,  1488,     0,     0,   695,  1814,   695,  1488,  2068,     0,
       0,  2069,     0,     0,     0,     0,   695,  1488,     0,     0,
    1488,     0,  1488,     0,     0,     0,     0,     0,  2070,     0,
       0,  1488,  1488,  1488,     0,     0,  2072,  1488,     0,  3052,
    1488,  2073,   695,     0,  2940,     0,     0,  1047,  1047,     0,
    1488,     0,   695,     0,     0,     0,  3737,     0,  1488,  2083,
    1488,     0,   695,   695,     0,     0,   695,     0,     0,     0,
       0,     0,     0,   695,     0,  4319,     0,   970,     0,     0,
       0,     0,   802,  2941,     0,     0,     0,     0,     0,  2168,
    1144,     0,     0,     0,     0,     0,  1144,     0,   970,  2942,
    2943,  2944,  2945,  2946,     0,  2947,     0,     0,     0,     0,
       0,     0,     0,     0,   695,     0,     0,     0,  1814,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
    3774,  1961,  1961,     0,     0,     0,   676,  2948,     0,     0,
       0,     0,     0,     0,     0,  2084,  2085,  2086,     0,  2087,
    2088,  2089,  2090,  2091,  2092,  3792,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,  3053,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,  2076,  2077,     0,   676,     0,   676,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,     0,     0,     0,     0,
    2949,     0,  3054,     0, -1920,     0,     0,     0,     0,     0,
       0,     0,  1269,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2950,  2079,     0,     0,
    2080,     0,     0,  2951,     0,     0,  2952,     0,     0,  3507,
       0,     0,     0,  2081,     0,  1047,  2082,     0,     0,     0,
       0,     0,     0, -1920,     0,     0,     0,  1488,     0,     0,
       0,     0,     0,  1047, -1920,     0,     0,     0, -1920,     0,
       0,     0,     0, -1920,     0,     0,     0,     0, -1920,     0,
    1047, -1920,     0, -1920,     0,     0,  1144,     0,     0,  3078,
       0,     0,  1010,     0,  3923,     0,  1010,     0,  2323,     0,
    3629,     0,   695,     0,     0,     0,     0,     0,     0,     0,
   -1920,  1488,  1488,     0,     0,     0,  2083,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0, -1920,
       0,  3122,     0,     0,     0,  2519,     0,     0,     0,     0,
    2519,     0,     0,  2519,  3078,     0,  3961,     0,     0,     0,
       0,     0,     0,  2927,     0,  2927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1920,   676,     0,     0,     0,     0,     0,     0,
   -1920,  1814,  1814,     0,  1814,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  4400,     0,     0,     0,
       0,     0,  1488, -1920,     0,  1814,     0,  1814,     0,  1488,
    1488,     0,     0,     0,     0,     0,     0,  1488,  1488,     0,
       0,     0,  1488,     0,     0,     0,     0,     0,  1488,  1488,
       0,     0,  1488,     0,  1047,  1047,  1047,  1047,     0,     0,
    1144,     0,     0,  1488,     0,     0,     0,  1144,   983,  4025,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1173,     0,  1817,     0,
       0, -1920,     0,     0,     0,     0,  1814,     0,     0,     0,
     978,     0,     0,  1488,     0,     0,     0,  1148,  1148,     0,
       0,     0, -1920,     0, -1920, -1920,     0,  1144,     0,     0,
       0,     0,  4058,  1814,     0,     0,     0,     0,     0,     0,
     676,     0,     0,     0,     0,     0,     0,   695,     0,     0,
       0,   676,     0,     0,     0,     0, -1920,     0,     0, -1920,
   -1920,     0, -1920,     0,  1148,     0,     0,  1814,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,  1269,     0,  1144,     0,   695,   695,     0,  1814,  1961,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1814,   695,  3507,  3507,  3507,  3507,  3507,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1814,     0,
       0,     0,     0,  1817,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,  1047,     0,
    4161,     0,     0,     0,     0,     0,  1488,     0,     0,     0,
    2519,     0,     0,  3961,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,   676,     0,     0,     0,     0,  1488,     0,     0,
       0,     0,     0,  1814,  1144,  1144,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,  1488,     0,  1144,  1488,     0,     0,  1814,     0,
       0,     0,  1488,  1488,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1806,     0,     0,   676,     0,   676,     0,     0,     0,  3774,
    1173,  1148,  1814,     0,     0,     0,     0,  1261,   695,     0,
     695,     0,     0,     0,     0,  1144,   802,     0,     0,  1142,
    1173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1961,     0,  1144,     0,     0,
       0,  1144,  1144,     0,     0,   695,  1142,     0,   695,   695,
       0,     0,     0,     0,     0,  1047,     0,     0,     0,     0,
       0,   681,     0,   970,     0,   970,     0,  2927,     0,  2323,
       0,   681,     0,     0,     0,   695,     0,     0,     0,  3923,
       0,     0,     0,     0,  1047,     0,     0,     0,     0,     0,
       0,     0,     0,  1148,  3774,   970,   970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1817,     0,     0,     0,     0,
     802,     0,     0,  1488,  1010,  1814,  1488,     0,  1488,  2068,
       0,     0,  2069,     0,   695,  1806,   695,     0,     0,     0,
       0,  4307,     0,     0,     0,  1010,     0,     0,     0,  2070,
       0,     0,  1817,     0,     0,  1148,     0,  2072,     0,     0,
       0,     0,  2073,  1047,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,  1817,  1148,  1148,  1148,  1148,
       0,     0,     0,     0,     0,  1269,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,     0,     0,
     681,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1010,     0,     0,     0,   681,   681,     0,     0,  1616,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
       0,     0,  1488,     0,  1817,     0,     0,     0,     0,     0,
    1173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1817,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1814,     0,     0,     0,     0,  2074,     0,     0,
       0,  2075,     0,  1148,     0,     0,  1142,  1817,     0,     0,
       0,     0,   802,  3774,     0,     0,     0,     0,     0,     0,
    4161,     0,  2076,  2077,     0,     0,  4307,     0,     0,  1488,
    1488,     0,   676,     0,     0,     0,  2078,     0,     0,  1142,
       0,     0,     0,  1148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,     0,  1144,     0,     0,     0,
       0,     0,  1817,     0,     0,  1144,  1488,     0,  2079,     0,
       0,  2080,     0,     0,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,  2081,     0,     0,  2082,     0,     0,
    4466,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1806,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
    1488,     0,     0,     0,     0,  4466,     0,     0,     0,  1142,
       0,     0,     0,  4466,  1806,     0,     0,     0,     0,   681,
    1144,     0,     0,     0,   695,     0,   695,  2083,     0,   695,
       0,   695,     0,     0,   695,   695,   695,  1806,     0,     0,
    1956,     0,     0,     0,     0,     0,     0,   695,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,  1144,
       0,   695,     0,   695,     0,     0,  1144,     0,   695,  1144,
       0,     0,  1144,     0,     0,     0,  1814,     0,     0,     0,
    1144,  1144,     0,     0,     0,     0,  1814,     0,  1144,     0,
       0,  1144,  1144,  1144,  1144,     0,     0,     0,     0,  1806,
       0,  1144,  1144,     0,  1144,     0,  1144,     0,     0,  1144,
       0,     0,     0,  2084,  2085,  2086,  1806,  2087,  2088,  2089,
    2090,  2091,  2092,  1817,  1144,   802,     0,  4477,  1144,     0,
       0,     0,  1144,     0,  1806,     0,  1144,     0,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,  1144,  1144,     0,  1144,     0,
       0,     0,     0,     0,  1144,     0,     0,  1144,     0,  1806,
       0,     0,     0,    85,     0,     0,     0,     0,     0,    89,
       0,     0,     0,    93,     0,    94,     0,    96,    97,     0,
       0,  2108,     0,     0,     0,     0,     0,     0,   106,     0,
     695,   695,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   119,   120,   681,     0,     0,
       0,   681,   681,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
       0,   128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,  1814,     0,     0,     0,  1078,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   695,     0,   681,     0,     0,     0,   141,     0,   142,
     143,     0,     0,  2240,   145,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   802,   149,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   152,     0,   153,     0,     0,
     156,  1144,     0,     0,     0,     0,   157,     0,  1814,     0,
       0,     0,   158,   681,   159,     0,     0,     0,   160,   681,
       0,  1817,     0,     0,   161,     0,  1817,  1817,     0,     0,
       0,   163,     0,   165,     0,     0,     0,  1817,   167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   171,   802,     0,     0,     0,     0,     0,     0,
     681,     0,     0,   681,   681,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     176,     0,     0,     0,     0,     0,     0,     0,   802,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1814,     0,
       0,     0,     0,     0,   185,   186,     0,     0,     0,     0,
     187,     0,     0,     0,     0,     0,   681,     0,     0,   188,
       0,  2068,     0,     0,  2069,     0,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   193,  1808,     0,     0,
       0,  2070,     0,     0,     0,     0,     0,     0,     0,  2072,
    1144,     0,  1817,     0,  2073,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1814,   204,     0,     0,  1814,  1814,     0,     0,     0,
       0,     0,     0,   206,     0,     0,     0,   207,     0,   208,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,   214,     0,     0,     0,
       0,     0,   215,  1817,     0,     0,     0,     0,     0,   216,
       0,     0,   218,     0,  1144,     0,     0,     0,     0,   221,
       0,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,     0,     0,     0,     0,   231,     0,
     232,  1144,     0,   233,     0,     0,     0,   234,     0,  2074,
       0,     0,     0,  2075,     0,     0,   695,     0,   695,   237,
       0,     0,   695,     0,   695,     0,     0,   695,     0,     0,
       0,   695,     0,  1806,  2076,  2077,  2108,     0,  1806,  1806,
       0,     0,     0,     0,     0,  1144,     0,     0,  2078,  1806,
       0,     0,   246,     0,     0,     0,  1817,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,  1144,     0,     0,     0,
    2079,     0,     0,  2080,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2081,     0,     0,  2082,
       0,     0,     0,     0,     0,  1144,  1144,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1144,  1144,  1144,  1144,     0,     0,     0,  1808,
     802,     0,     0,     0,  1144,   802,     0,  1144,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
    1144,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,  1144,  1808,  1144,     0,  2083,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,     0,     0,     0,  2766,  1144,  2068,  1808,
       0,  2069,     0,     0,     0,  2240,     0,  1144,     0,  1144,
    1144,  1144,     0,     0,     0,     0,     0,     0,  2070,     0,
       0,     0,  2798,  1008,     0,     0,  2072,     0,     0,     0,
    1008,  2073,  1008,  1144,     0,  1806,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,  1808,     0,  1144,     0,  2084,  2085,  2086,     0,  2087,
    2088,  2089,  2090,  2091,  2092,     0,   681,  3747,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,  2799,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,   681,
       0,  1808,     0,   681,     0,     0,     0,     0,     0,  2828,
       0,  1616,     0,     0,   695,     0,     0,     0,     0,  1817,
    1817,     0,  1817,     0,     0,     0,     0,     0,  1806,     0,
       0,     0,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,  2076,  2077,  1817,     0,  1817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   802,   802,   802,     0,
       0,     0,     0,     0,     0,     0,     0,  2079,     0,     0,
    2080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2081,     0,     0,  2082,     0,     0,     0,
       0,   681,     0,     0,  1817,     0,     0,     0,     0,   681,
       0,   681,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   802,     0,     0,     0,
       0,  1817,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   802,  1817,  2083,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1817,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1817,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1817,
       0,     0,     0,     0,     0,  2800,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,  1817,  2068,     0,     0,
    2069,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,     0,  2070,     0,     0,
       0,  1806,  1806,     0,  1806,  2072,  1144,     0,     0,     0,
    2073,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,  1817,   695,  1956,  1806,     0,  1806,  1144,     0,
       0,     0,     0,     0,  1144,     0,  1144,     0,     0,     0,
       0,  1817,  1144,     0,     0,  1144,  1144,  1144,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,     0,     0,     0,  1144,  1144,
       0,     0,     0,     0,     0,     0,  1817,     0,     0,     0,
       0,  1144,     0,     0,     0,   802,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,  2068,     0,  1144,  2069,     0,
    1144,     0,  1144,     0,     0,     0,  1806,     0,     0,     0,
    1817,  1144,  1144,  1144,     0,  2070,     0,  1144,     0,     0,
    1144,     0,     0,  2072,     0,  2074,     0,     0,  2073,  2075,
    1144,     0,     0,  1806,     0,     0,     0,     0,  1144,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2076,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2078,     0,     0,  1806,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,     0,     0,     0,
    1808,  1808,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,  2079,     0,  1806,  2080,
    1140,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
    1144,  1806,  2081,     0,     0,  2082,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2240,  4452,     0,  3691,     0,   681,     0,  1140,     0,     0,
       0,     0,   802,  1817,   802,     0,     0,     0,  1806,     0,
       0,     0,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2076,  2077,
       0,     0,     0,     0,     0,  2083,     0,     0,     0,  1140,
       0,     0,  2078,     0,     0,     0,  1140,     0,  3692,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,     0,     0,
       0,     0,     0,  1806,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1806,  4453,
       0,     0,     0,     0,     0,  1817,     0,  1808,     0,     0,
       0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1806,     0,     0,     0,     0,     0,     0,     0,
    1817,  1144,  1144,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,  1008,  2083,     0,     0,  1008,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,     0,
    1144,     0,     0,  1144,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,  2068,     0,     0,  2069,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2070,     0,     0,  3208,     0,     0,
       0,     0,  2072,     0,     0,     0,  1144,  2073,     0,     0,
    1808,     0,     0,     0,     0,     0,     0,   681,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,  1144,
    1144,   681,  1817,     0,     0,  1806,     0,  1144,  1144,     0,
       0,     0,  1144,  1817,     0,     0,     0,     0,  1144,  1144,
     695,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,     0,     0,     0,  2068,     0,
       0,  2069,     0,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   695,     0,  2070,     0,
    1140,     0,     0,     0,     0,     0,  2072,  1140,     0,  2068,
       0,  2073,  2069,  1144,     0,     0,     0,     0,     0,     0,
       0,     0,  2074,     0,     0,     0,  2075,     0,  1815,  2070,
       0,     0,  3252,     0,  1817,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,  1817,     0,     0,  2076,  2077,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,  2078,     0,     0,     0,     0,     0,  1806,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   802,
       0,     0,     0,  2079,     0,     0,  2080,     0,     0,     0,
       0,     0,  1806,     0,     0,     0,     0,     0,     0,  2081,
       0,     0,  2082,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2074,  1144,     0,     0,
    2075,     0,     0,     0,     0,     0,     0,   802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2076,  2077,     0,     0,     0,     0,  2074,     0,     0,
       0,  2075,     0,  1808,  1808,  2078,  1808,     0,     0,     0,
       0,     0,  2083,  1815,     0,  1817,     0,     0,     0,     0,
       0,     0,  2076,  2077,     0,     0,  1144,     0,     0,     0,
    1144,     0,     0,     0,     0,  1817,  2078,  2079,     0,  1140,
    2080,     0,     0,     0,     0,     0,     0,  1808,     0,  1808,
       0,     0,     0,  2081,  1806,     0,  2082,  1144,     0,     0,
       0,  1817,     0,     0,     0,  1806,     0,  1140,  2079,  3222,
       0,  2080,     0,     0,     0,     0,  2828,     0,     0,     0,
       0,  1144,  1144,     0,  2081,  1144,     0,  2082,     0,     0,
       0,     0,  1144,  1144,  1140,  1140,     0,  1140,  2084,  2085,
    2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,  1808,  1144,
       0,     0,     0,     0,     0,     0,  2083,     0,     0,   681,
       0,     0,     0,     0,     0,     0,  1817,     0,     0,  1144,
       0,     0,   681,     0,     0,  1808,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1806,  2083,  2068,     0,
       0,  2069,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,  2070,  1808,
       0,     0,     0,     0,     0,     0,  2072,     0,   681,     0,
       0,  2073,     0,     0,     0,     0,  1808,  1140,     0,     0,
       0,  1140,  1140,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  1808,  1144,     0,  1817,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,  1144,  1817,     0,  1144,     0,  1144,     0,
    1808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,  1008,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,  1817,
    3257,     0,     0,  1817,  1817,  1008,     0,     0,     0,     0,
       0,     0,  1815,     0,     0,     0,  2074,  1806,     0,     0,
    2075,     0,     0,     0,     0,     0,  1808,     0,     0,   802,
       0,     0,     0,     0,     0,  1815,  1144,     0,     0,     0,
       0,  2076,  2077,  1806,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,     0,     0,     0,     0,
       0,     0,  1817,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1008,     0,  1144,     0,     0,     0,     0,  2079,     0,     0,
    2080,     0,     0,     0,  1809,     0,     0,  1815,     0,     0,
       0,     0,     0,  2081,  1808,     0,  2082,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,  1806,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,  1815,  1144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
    1144,     0,     0,     0,     0,  2240,     0,  1815,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   681,     0,     0,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,   681,     0,     0,
       0,     0,     0,     0,  1140,     0,  1140,     0,  1806,     0,
       0,     0,  1815,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1806,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  2068,     0,     0,  2069,     0,     0,     0,
       0,  1806,     0,     0,     0,  1806,  1806,   681,     0,     0,
       0,     0,     0,  2070,     0,     0,  3261,     0,     0,     0,
    1140,  2072,     0,     0,     0,     0,  2073,  2068,     0,     0,
    2069,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2070,     0,     0,
       0,     0,     0,     0,     0,  2072,     0,     0,  1140,  1140,
    2073,     0,     0,     0,     0,     0,  1140,     0,     0,  1140,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,  1808,
    1140,  1140,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,  1140,  1140,  1140,  1140,     0,     0,     0,     0,     0,
       0,  1140,  1140,     0,  1140,     0,  1140,     0,     0,  1140,
       0,     0,     0,     0,  1808,     0,     0,     0,     0,     0,
       0,     0,     0,  1815,  1140,     0,     0,     0,  1140,     0,
    2068,     0,  1140,  2069,     0,     0,  1140,   698,  1140,  1140,
    1140,  1140,  1140,  1140,  1140,  1140,  1140,   698,  1140,     0,
    2070,  2074,     0,  3698,  1140,  2075,     0,  1140,  2072,     0,
       0,     0,     0,  2073,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2076,  2077,     0,     0,
       0,     0,     0,   698,     0,  2074,     0,     0,     0,  2075,
    2078,     0,   681,     0,   891,     0,     0,   698,     0,     0,
       0,     0,     0,     0,   891,     0,     0,     0,   698,     0,
    2076,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2079,     0,  2078,  2080,     0,  1140,     0,   698,
       0,  1809,  2068,     0,     0,  2069,  1808,     0,  2081,     0,
       0,  2082,     0,     0,     0,   891,     0,  1808,     0,     0,
       0,     0,  2070,     0,     0,     0,  2079,     0,     0,  2080,
    2072,     0,     0,     0,     0,  2073,     0,     0,  1809,     0,
       0,     0,  2081,     0,     0,  2082,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2074,     0,
       0,  1809,  2075,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2083,     0,  2076,  2077,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2078,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,  1140,     0,     0,     0,  2083,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,     0,  2079,
       0,  1815,  2080,     0,     0,     0,  1815,  1815,     0,     0,
    1809,  3652,     0,     0,     0,  2081,     0,  1815,  2082,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1809,     0,
    2074,     0,     0,     0,  2075,     0,     0,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,
       0,     0,     0,  1809,     0,  2076,  2077,     0,     0,     0,
       0,     0,   681,     0,     0,     0,     0,     0,     0,  2078,
       0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,  1108,     0,     0,     0,     0,  2083,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2079,     0,     0,  2080,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,   853,     0,  2081,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,   854,     0,     0,
    1140,     0,  1815,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,     0,     0,   855,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,     0,   856,     0,
       0,     0,  -630,     0,  2084,  2085,  2086,     0,  2087,  2088,
    2089,  2090,  2091,  2092,     0,     0,     0,     0,     0,     0,
    2083,     0,   857,  1815,     0,     0,     0,     0,   858,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,   859,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,   860,     0,     0,     0,     0,     0,     0,   861,     0,
       0,  1140,   862,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -790,     0,     0,
       0,     0,     0,     0,     0,     0,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,     0,  1809,
       0,     0,     0,   863,     0,     0,  1815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,  1140,     0,     0,     0,
    1808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   864,     0,     0,
     865,     0,     0,     0,     0,  1140,  1140,     0,  1808,     0,
    1140,     0,     0,     0,     0,     0,   891,   891,     0,     0,
       0,     0,  1140,  1140,  1140,  1140,     0,     0,     0,     0,
       0,     0,     0,  1108,  1140,     0,     0,  1140,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,   866,  1140,
    1140,     0,  1140,  1808,   867,     0,     0,  1808,  1808,     0,
    -365,     0,     0,   868,     0,  1140,     0,  1140,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,  -365,
       0,   869,   870,     0,   871,   872,     0,  1140,     0,  1140,
    1140,  1140,     0,   873,     0,     0,     0,     0,   874,     0,
       0,     0,     0,   875,     0,     0,     0,     0,   876,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
    -365,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
    1175,     0,  1177,     0,  1179,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1223,     0,  1809,     0,     0,
       0,     0,  1809,  1809,     0,     0,     0,     0,     0,  1241,
    1242,  1140,     0,  1809,  1244,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1108,
       0,   891,     0,     0,     0,     0,     0,     0,     0,  1815,
    1815,     0,  1815,     0,     0,     0,     0,  1274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1293,
       0,     0,  1295,     0,  1297,     0,  1300,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   698,
     891,     0,     0,  1815,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,   698,     0,   698,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   698,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   698,   698,  1809,     0,
       0,     0,     0,  1382,     0,  1383,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
    1816,     0,     0,     0,     0,  1108,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,  1634,     0,
    1636,     0,     0,     0,  1638,     0,     0,  1140,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,  1752,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1764,     0,     0,     0,     0,     0,     0,     0,     0,  1770,
       0,     0,     0,     0,     0,  1772,     0,     0,     0,  1140,
       0,     0,  1815,     0,     0,     0,  1820,     0,  1140,     0,
       0,     0,     0,     0,  1140,     0,  1140,     0,     0,     0,
       0,  1815,  1140,     0,     0,  1140,  1140,  1140,  1140,  1140,
    1140,  1140,  1140,  1140,  1140,  1857,     0,     0,  1140,  1140,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
    1140,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
    1815,  1140,  1140,  1140,     0,     0,     0,  1140,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
    1140,     0,     0,     0,     0,   698,     0,   698,     0,     0,
     698,     0,   698,     0,     0,   698,   698,   698,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   698,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   698,     0,   698,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,  1815,     0,  1809,  1809,  1816,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2316,     0,     0,     0,     0,  1809,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,  1063,  1815,     0,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1816,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,  1140,  1140,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2236,     0,     0,
    2236,  1809,     0,     0,     0,  1140,     0,     0,  2243,  1816,
    1140,     0,     0,  1140,     0,     0,     0,  1145,  1809,     0,
       0,     0,     0,     0,     0,     0,  2252,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,  2290,  1145,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,  1140,
    1140,     0,  1815,     0,     0,     0,     0,  1140,  1140,     0,
       0,     0,  1140,  1815,     0,     0,     0,     0,  1140,  1140,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,  1809,     0,  1815,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2451,     0,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,  1809,  2473,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,  1816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2527,     0,     0,     0,  2531,     0,     0,     0,     0,
       0,     0,     0,     0,  2540,     0,  2542,     0,  2543,  2764,
       0,     0,     0,  2544,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   698,     0,   698,
       0,     0,     0,   698,     0,   698,     0,     0,   698,     0,
       0,     0,   698,  2572,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,  1809,
    1140,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,  1140,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,  1140,  1140,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,  1145,  1145,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,  1140,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2883,     0,     0,     0,  2765,  2316,  2890,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,  1815,     0,  1145,     0,
       0,     0,  1145,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,  1815,     0,  1140,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,  1140,     0,     0,  1815,
       0,     0,     0,  1815,  1815,  1108,  1818,     0,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,  2844,     0,     0,     0,     0,  2848,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,  2858,     0,     0,
       0,     0,     0,  1818,  2864,     0,     0,     0,     0,     0,
    2869,     0,     0,     0,     0,  2316,  2879,     0,     0,     0,
       0,  2881,  1815,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,     0,     0,     0,  2897,  2898,  2901,
    2903,     0,     0,     0,  2910,  2913,     0,     0,     0,  2916,
    1809,     0,  2920,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,  2955,
       0,     0,     0,     0,     0,     0,  1140,     0,  1818,  2958,
       0,  2960,     0,  1140,     0,     0,     0,     0,     0,     0,
    2971,  2972,  2973,     0,  2975,  1818,     0,     0,     0,  1140,
    1140,     0,     0,  2988,  2989,     0,     0,     0,     0,  1140,
       0,  2992,  2993,  1818,     0,     0,     0,     0,  1816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,  1145,     0,     0,
       0,     0,     0,  1818,     0,     0,  1145,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2764,  2764,  2764,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
    1145,     0,  1809,     0,     0,     0,     0,  1145,     0,  3193,
    1145,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  1145,  1145,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,  1145,  1145,  1145,  1145,     0,     0,     0,     0,
       0,     0,  1145,  1145,     0,  1145,     0,  1145,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,  1145,     0,     0,     0,  1145,
       0,  2316,  2890,  1145,  2890,     0,     0,  1145,     0,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,     0,  1145,
       0,     0,  1809,     0,     0,  1145,     0,     0,  1145,     0,
    1811,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,     0,  1816,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,  1145,  1809,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1816,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2890,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3374,  3375,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3394,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1816,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  2890,     0,     0,     0,     0,     0,  3413,  3414,  3415,
    3416,     0,  1818,     0,     0,     0,     0,  1818,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,  2764,     0,     0,     0,     0,     0,  1816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1476,     0,     0,     0,     0,     0,     0,
       0,  3457,     0,     0,     0,     0,  3459,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,     0,     0,  1812,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1549,
       0,     0,     0,  1816,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,  1818,     0,  1812,     0,     0,  1816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3557,   891,  1816,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,  1811,  2764,     0,     0,  1145,     0,   891,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,  1811,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3617,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,  3626,     0,     0,
       0,     0,  1145,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,  1811,
       0,     0,     0,     0,     0,  2890,  1813,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,  1145,  1145,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,  1145,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,  1145,     0,
       0,     0,  1145,     0,     0,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
    1145,  1145,  1145,     0,     0,     0,  2010,     0,     0,     0,
       0,     0,  2316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,  2033,     0,     0,     0,     0,     0,
    1811,     0,  1145,     0,     0,     0,     0,  1145,     0,     0,
    3791,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,  2057,  2058,     0,  2060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,  2098,     0,     0,     0,     0,     0,  3817,     0,     0,
       0,     0,  3824,     0,  3826,  3827,  3828,  3829,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,  1818,  2152,  1818,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,     0,  3888,
    3890,  3892,     0,  3894,  2182,  2764,     0,     0,  2192,  2195,
       0,     0,     0,     0,  1818,     0,  1818,  2764,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1816,     0,     0,     0,
       0,     0,     0,     0,  3394,     0,  1816,     0,     0,     0,
    1813,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3963,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1818,     0,     0,  1813,     0,     0,  1811,     0,
       0,     0,     0,  1811,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,     0,  1812,
    1812,     0,     0,  1818,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,  1145,     0,     0,     0,     0,  4155,     0,     0,
       0,  1145,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,  1816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4064,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,  4073,
    1145,     0,     0,  1818,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,  1145,     0,  1145,     0,     0,
    1811,     0,  1818,  1145,     0,     0,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,     0,     0,     0,  1145,
    1145,     0,     0,     0,     0,     0,     0,  1818,  2890,     0,
       0,     0,  1145,     0,     0,     0,  1812,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  1818,  1145,  1145,  1145,     0,     0,     0,  1145,     0,
       0,  1145,     0,     0,     0,     0,  1813,     0,     0,     0,
    4126,  1145,     0,     0,     0,     0,     0,     0,     0,  1145,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,  2890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4174,     0,  2635,     0,     0,  1816,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,  2657,     0,     0,  2659,     0,
       0,  2670,     0,     0,     0,     0,     0,     0,  2677,  2682,
       0,     0,     0,  2687,     0,     0,  2692,     0,     0,     0,
       0,  1816,     0,     0,  1818,  1816,  1816,     0,     0,     0,
       0,  2701,     0,     0,     0,  2707,     0,     0,     0,  2719,
       0,     0,     0,  2726,     0,  2728,  2729,  2730,  2731,  2732,
    2733,  2734,  2735,  2736,     0,  2737,     0,     0,     0,     0,
       0,  1476,     0,     0,  2761,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4155,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,  1549,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,  1818,     0,     0,  1813,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,  3394,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1818,  1145,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,  1145,     0,     0,  1145,     0,  1811,  1811,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2867,     0,
       0,     0,  1812,  1812,     0,  1812,     0,  1145,     0,     0,
    1811,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,  1812,     0,  1812,     0,
    1145,  1145,     0,  1818,     0,     0,     0,     0,  1145,  1145,
       0,     0,     0,  1145,  1818,     0,     0,     0,     0,  1145,
    1145,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,     0,  1145,     0,  1813,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,  4397,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,  1812,  1818,     0,  3028,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,  1811,     0,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,  2094,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,  1811,     0,     0,     0,     0,     0,     0,
       0,  3139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,  3160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,  1811,     0,
       0,  1145,  1476,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,  1145,     0,
       0,     0,  1818,  3204,  1812,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1145,  1145,     0,     0,  1145,  1811,     0,  1812,
       0,     0,     0,  1145,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2682,
       0,  2682,  2682,     0,     0,     0,     0,     0,     0,     0,
    1145,  3264,     0,  1812,  3267,     0,  3269,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3290,     0,  3292,     0,     0,     0,  3295,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,  2761,  2761,  2761,     0,
       0,     0,  1813,  1813,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3342,     0,     0,     0,     0,     0,     0,     0,     0,  1549,
    1811,     0,     0,     0,     0,  1145,     0,  1818,  2182,     0,
       0,     0,     0,  3357,     0,     0,  1813,     0,  1813,     0,
    2195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,  1818,  1812,  1145,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3383,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
    1818,     0,     0,     0,  1818,  1818,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,  1145,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1818,     0,     0,     0,     0,  1813,  2094,
       0,     0,     0,     0,     0,     0,     0,  1811,  1812,     0,
       0,     0,     0,  1145,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,  1812,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
    1145,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,  2094,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,     0,  1145,     0,  2666,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,  2094,
    1811,  2094,     0,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,  2094,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,  1813,
    1145,     0,     0,     0,     0,     0,     0,  2761,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,  2094,     0,     0,  3653,  1812,     0,     0,
       0,     0,     0,  2094,     0,  3656,  2094,     0,     0,     0,
       0,  3657,     0,  3658,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3676,  3677,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2687,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3702,     0,     0,  3705,     0,  3707,
       0,     0,     0,     0,     0,     0,     0,     0,  3711,     0,
       0,     0,     0,     0,  3716,     0,  1813,  3719,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3726,     0,     0,
       0,     0,     0,     0,     0,  3738,     0,  2761,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,     0,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,  3938,  3939,
       0,     0,     0,     0,     0,     0,  1813,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,  1811,     0,     0,     0,
    1811,  1811,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,  1812,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3979,     0,     0,  2094,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,  2094,     0,
    2094,     0,  2666,  2666,  3240,     0,     0,  2666,     0,     0,
       0,  2094,     0,     0,     0,     0,  3995,  3997,  2094,     0,
       0,     0,     0,  2094,     0,     0,     0,     0,  2094,  4004,
       0,     0,     0,  2094,     0,  4009,  4010,     0,     0,  4012,
       0,     0,  2094,     0,     0,     0,  2666,  2666,  2094,     0,
    2761,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,  2761,     0,     0,     0,     0,  2094,     0,  2094,
    2094,  2094,  2094,  2094,  2094,  2094,  2094,  2094,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4043,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,  2094,     8,
       0,     9,    10,     0,  4114,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,    36,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4164,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4194,     0,     0,     0,     0,     0,     0,     0,
    4196,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,    47,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,  1813,  1813,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2094,     0,  2687,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4322,     0,  2094,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,     0,     0,     0,  3240,  3240,     0,  2666,
       0,     0,  2666,  2666,  2666,  2666,  2666,  2666,  2666,  2666,
    2666,  2666,  3240,  4351,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,  2094,     0,     0,  2094,     0,
    2094,     0,     0,    56,     0,  3240,  3240,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,  2666,
    2666,  2094,     0,  2094,     0,     0,  2094,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
      67,    68,     0,    69,    70,    71,    72,    73,     0,     0,
       0,     0,     0,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4415,  4415,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,  4415,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4455,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4415,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,     0,  2094,  2094,  2094,
       0,     0,  3240,     0,     0,     0,     0,  3240,  3240,  3240,
    3240,  3240,  3240,  3240,  3240,  3240,  3240,  2094,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2094,  2666,  2666,  2094,     0,  2094,     0,
       0,     0,  2094,  3240,  3240,     0,     0,  2094,     0,     0,
    2094,     0,     0,     0,     0,     0,     0,  2094,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,    46,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,  3240,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,    47,     0,     0,     0,     0,     0,     0,     0,  2094,
    2094,   140,     0,     0,     0,     0,    48,     0,   144,     0,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
    2094,     0,     0,     0,  2666,   154,   155,     0,    50,     0,
       0,     0,     0,     0,     0,     0,  2094,     0,  2094,     0,
       0,     0,     0,  3240,  3240,  2094,     0,     0,  2666,  2666,
    2094,  2094,   162,  2094,     0,     0,     0,     0,     0,   164,
       0,    51,   166,     0,    52,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,  2094,    53,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     177,     0,   178,     0,     0,   179,   180,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,   183,     0,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,     0,  2094,    54,     0,     0,   192,
       0,     0,     0,     0,   194,     0,     0,   195,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   197,   198,   199,   200,   201,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,   203,    55,     0,
       0,     0,     0,     0,     0,  2094,     0,     0,     0,   205,
       0,    56,     0,     0,     0,     0,     0,     0,     0,  3240,
    2666,     0,     0,     0,    57,     0,     0,   211,     0,     0,
     213,     0,     0,  3240,  3240,  2094,     0,  2094,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,    58,
     219,     0,   220,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,   222,     0,    65,    66,  1308,     0,
       0,     0,     0,    71,  1309,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3240,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2818,     0,     0,     0,
       0,     0,     0,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   704,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,  2094,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,  2094,     0,   417,   418,
     419,   420,   421,   422,   423,   424,   711,   425,   426,   427,
     712,   713,   714,   715,   716,   717,   718,   428,   429,   719,
     430,   133,   431,   432,   433,   135,   136,   137,   138,   139,
     720,   434,   435,   436,   437,   438,   721,   722,   439,   440,
     723,   140,   442,   724,   443,   444,   445,   446,   144,   725,
     726,   447,   448,   449,   450,   147,   451,   727,   728,   453,
     454,   455,   456,   457,   458,   729,   459,   460,   461,   150,
     462,   730,   731,   732,   733,   151,   734,   735,   736,   463,
     464,   465,   466,   467,   468,   154,   155,   469,   737,   470,
     738,   471,   472,   473,   474,   475,   739,   476,   477,   478,
     740,   741,   479,   480,   481,   482,   483,   742,   484,   485,
     486,   743,   487,   488,   744,   489,   490,   491,   492,   164,
     493,   494,   166,   745,   495,   746,   496,   168,   497,   747,
     498,   748,   499,   169,   749,   170,   500,   501,   502,   750,
     503,   172,   751,   504,   752,   505,   506,   507,   508,   509,
     173,   510,   511,   512,   753,   513,   514,   515,   516,   517,
     518,   754,   519,   174,   175,   755,   520,   521,   522,   756,
     177,   757,   178,   758,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,   759,   182,   183,   531,   184,
     760,   532,   533,   534,   761,   762,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
     190,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,   763,   556,   557,   194,   558,   764,   195,   559,   196,
     560,   561,   765,   766,   562,   767,   768,   563,   564,   565,
     769,   770,   197,   198,   199,   200,   201,   566,   567,   568,
     569,   570,   571,   771,   572,   202,   573,   203,   574,   575,
     576,   772,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,   773,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   774,   597,   598,   211,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,   775,
     609,   610,   611,   612,   613,   776,   614,   217,   615,   616,
     219,   617,   220,   777,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,   778,   629,   630,   779,
     631,   632,   633,   634,   635,   636,   780,   224,   225,   781,
     782,   638,   226,   639,   227,   783,   640,   641,   642,   643,
     644,   645,   784,   785,   646,   647,   648,   649,   786,   787,
     650,   651,   652,   653,   788,   235,   789,   655,   236,   656,
     657,   658,   790,   791,   659,   792,   793,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,    85,     0,     0,    86,    87,    88,    89,
      90,    91,    92,    93,     0,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   932,   104,   105,   106,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,   119,   120,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,   132,   133,     0,     0,   134,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,   141,     0,   142,
     143,   144,     0,     0,   145,     0,   146,     0,   147,     0,
       0,     0,     0,     0,     0,     0,   148,     0,   149,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,   152,     0,   153,   154,   155,
     156,     0,     0,     0,     0,     0,   157,     0,     0,     0,
       0,     0,   158,     0,   159,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   161,   162,     0,     0,     0,     0,
       0,   163,   164,   165,     0,   166,     0,     0,   167,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,   171,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
     176,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,   185,   186,     0,     0,     0,     0,
     187,     0,     0,     0,     0,     0,     0,     0,     0,   188,
       0,     0,   189,   190,   191,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,   193,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,   206,     0,     0,     0,   207,     0,   208,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   210,
     211,     0,   212,   213,     0,     0,   214,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,   216,
     217,     0,   218,   219,     0,   220,     0,     0,     0,   221,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,   228,
       0,   229,     0,     0,     0,   230,     0,     0,   231,     0,
     232,     0,     0,   233,     0,     0,     0,   234,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,   237,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   246,   104,   105,     0,  -124,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   164,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     177,     0,   178,     0,     0,   179,   180,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,   183,     0,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,     0,     0,     0,     0,     0,   192,
       0,     0,     0,     0,   194,     0,     0,   195,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   197,   198,   199,   200,   201,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,  2820,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,    46,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,    51,     0,     0,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,     0,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,    58,     0,     0,     0,     0,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1308,  1912,     0,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    56,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     5,     0,    65,    66,
    1308,  2553,     0,     0,     0,    71,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1308,     0,     0,     0,     0,    71,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,  2755,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,  2756,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,  2757,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,  2758,
       0,     0,     0,     0,     0,     0,  1463,  2759,   704,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   705,   104,
     105,   406,   706,     0,   107,   108,   109,   110,   707,   708,
     112,   113,   114,   115,     0,   116,   709,   710,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,   416,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1397,  1398,  1399,    45,
    1400,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
    1401,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,   135,  1402,   137,  1403,  1404,     0,   434,   435,   436,
     437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,
     443,   444,   445,   446,  1409,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,  1410,  1411,
    1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,
     468,  1417,  1418,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
    1419,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,  1420,   493,   494,  1421,  1422,
     495,     0,   496,  1423,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1424,     0,   504,
       0,   505,   506,   507,   508,   509,   173,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,   174,
     175,     0,   520,   521,   522,  1425,  1426,     0,  1427,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,  1428,   183,   531,   184,     0,   532,   533,   534,
    1429,  1430,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,  1431,   190,  1432,   548,   549,
     550,   551,   552,   553,   554,   192,   555,  1433,   556,   557,
     194,   558,  1434,  1435,   559,  1436,   560,   561,     0,     0,
     562,     0,     0,  1437,   564,   565,     0,     0,   197,   198,
     199,   200,  1438,   566,   567,   568,   569,   570,   571,     0,
     572,  1439,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,  1440,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   211,   599,   600,  1441,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,  1442,   614,   217,   615,   616,   219,   617,  1443,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1444,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,  1445,  1446,     0,     0,   638,  1447,   639,
    1448,  1449,   640,   641,   642,   643,   644,   645,     0,  1450,
     646,   647,   648,   649,  1451,     0,   650,   651,   652,   653,
     654,  1452,     0,   655,   236,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,  1453,
    1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,  1460,  1461,     0,     0,
       0,     0,     0,     0,     0,  1463,  2668,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
       0,  1784,   137,  1785,  1786,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,  1787,  1788,   442,     0,   443,
     444,   445,   446,     0,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
    1789,  1790,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,     0,   493,   494,     0,     0,   495,
       0,   496,  1791,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,  2304,
     513,   514,   515,   516,   517,   518,     0,   519,   174,  2305,
       0,   520,   521,   522,  1425,  1792,     0,  1793,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,     0,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1794,   190,  1795,   548,   549,   550,
     551,   552,   553,   554,     0,   555,     0,   556,   557,   194,
     558,     0,     0,   559,  1796,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,  2306,   198,   199,
     200,     0,   566,   567,   568,   569,   570,   571,     0,   572,
       0,   573,     0,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1797,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,  2307,   615,   616,   219,   617,  1799,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,     0,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1800,  1801,     0,     0,   638,     0,   639,     0,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,     0,
    1802,  2308,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,     0,     0,     0,
       0,     0,     0,     0,     0,   665,   666,   667,     0,     0,
       0,     0,   704,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,  2309,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,  2304,   513,   514,   515,   516,   517,
     518,     0,   519,   174,  2305,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,     0,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,  2306,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  2307,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,  2308,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,     0,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    3099,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,  4047,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,     0,   704,    86,    87,    88,   403,    90,    91,
      92,   404,  1531,   405,    95,     0,  1532,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,  2678,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,  2679,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,  2680,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,  2681,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,   215,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,   223,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,  1324,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,   237,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,  2005,  2627,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,  1462,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,  1548,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,  2190,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
    3138,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,  2679,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,  3741,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,  4412,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,  4413,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,  4414,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,  4413,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
    4414,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,  3989,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,  3996,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  2661,  2662,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433, -2407,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,  4413,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
       0,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,     0,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
    4414,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,     0,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,     0,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,     0,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
       0,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,     0,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,     0,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  2661,  2662,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,  1406,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,  1421,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,  1435,   559,   196,   560,   561,     0,     0,   562,
       0,  1044,   563,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   215,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,   223,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,  1447,   639,  1448,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,  1324,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,   237,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  2510,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,     0,
     434,   435,   436,   437,   438,     0,  1406,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,  1421,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,     0,  1435,   559,   196,   560,
     561,     0,     0,   562,     0,  1044,   563,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,  1447,   639,  1448,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,   235,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  2510,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
    1406,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,  1421,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
    1435,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,  1447,   639,  1448,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,   235,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  3769,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,     0,
       0,     0,   151,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,   182,   183,   531,   184,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
     198,   199,   200,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,   219,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  4225,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,  3120,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
   -1272,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0, -1272,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519, -1272,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524, -1272,
     525,   526,   527,   528,   529,   530,     0,   182, -1272,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189, -1272,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598, -1272,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,     0,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,  1556,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,   416,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,  1927,
     495,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,  1928,     0,
     562,  1929,     0,   563,   564,   565,     0,     0,   197,     0,
       0,     0,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,     0,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,     0,     0,   638,   226,   639,
     227,  1930,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,     0,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,   962,  1595,  3846,     0,
       0,     0,     0,     0,     0,  3847,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,  3504,  3505,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,   130,   131,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,   215,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,   223,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,  1324,   235,     0,   655,  1325,   656,   657,   658,     0,
       0,   659,     0,   237,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    3505,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   215,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,   223,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1324,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,   237,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,   246,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,   215,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,   223,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,  1324,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,   237,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  1528,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  2162,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    3610,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  3735,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,  1158,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   711,   425,   426,   427,   712,
     713,   714,   715,   716,   717,   718,   428,   429,   719,   430,
     133,   431,   432,   433,     0,  1784,   137,  1785,  1786,   720,
     434,   435,   436,   437,   438,   721,   722,   439,   440,  1787,
    1788,   442,   724,   443,   444,   445,   446,     0,   725,   726,
     447,   448,   449,   450,   147,   451,   452,   728,   453,   454,
     455,   456,   457,   458,   729,   459,   460,   461,   150,   462,
       0,   731,   732,   733,   151,   734,   735,   736,   463,   464,
     465,   466,   467,   468,  1789,  1790,   469,   737,   470,   738,
     471,   472,   473,   474,   475,   739,   476,   477,   478,   740,
     741,   479,   480,  1419,   482,   483,   742,   484,   485,   486,
     743,   487,   488,   744,   489,   490,   491,   492,     0,   493,
     494,     0,   745,   495,   746,   496,  1791,   497,   747,   498,
     748,   499,   169,   749,   170,   500,   501,   502,   750,   503,
       0,   751,   504,   752,   505,   506,   507,   508,   509,   173,
     510,   511,   512,   753,   513,   514,   515,   516,   517,   518,
     754,   519,   174,     0,     0,   520,   521,   522,  1425,  1792,
     757,  1793,   758,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,   759,     0,   183,   531,   184,   760,
     532,   533,   534,   761,   762,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1794,   190,
    1795,   548,   549,   550,   551,   552,   553,   554,     0,   555,
     763,   556,   557,   194,   558,   764,     0,   559,  1796,   560,
     561,   765,   766,   562,   767,   768,  3491,   564,   565,   769,
     770,     0,   198,   199,   200,     0,   566,   567,   568,   569,
     570,   571,   771,   572,     0,   573,     0,   574,   575,   576,
     772,   577,   578,   579,   580,   581,   582,   583,  1797,   584,
     585,   586,   773,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   774,   597,   598,   211,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   607,   608,   775,   609,
     610,   611,   612,   613,   776,   614,  2307,   615,   616,   219,
     617,  1799,   777,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,   628,   778,   629,   630,   779,   631,
     632,   633,   634,   635,   636,   780,  1800,  1801,     0,   782,
     638,     0,   639,     0,   783,   640,   641,   642,   643,   644,
     645,     0,   785,   646,   647,   648,   649,   786,   787,   650,
     651,   652,   653,     0,  1802,   789,   655,   236,   656,   657,
     658,   790,   791,   659,   792,   793,   660,   661,   662,   663,
     664,     0,     0,     0,     0,     0,     0,     0,     0,   665,
     666,   667,     0,     0,     0,  1161,  1162,  1163,     0,  3492,
    3493,  1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,  1159,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,  1160,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,  1161,  1162,
    1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
    1234,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,  1235,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,
    1169,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,  1285,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,  1286,     0,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,  1287,     0,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
     197,     0,     0,     0,   201,   566,   567,   568,   569,   570,
     571,     0,   572,   202,   573,   203,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,   205,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   213,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,   217,   615,   616,     0,   617,
     220,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,   224,   225,     0,     0,   638,
     226,   639,   227,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,   235,     0,   655,     0,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
     238,   239,   240,   241,   242,   243,   244,   245,   665,   666,
     667,     0,     0,     0,  1161,  1162,  1163,     0,  1164,  1165,
    1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,  1767,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,  1768,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,  1161,  1162,  1163,
       0,  1164,  1165,  1166,  1167,  1168,  1169,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,     0,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,     0,     0,   562,     0,
       0,   563,   564,   565,     0,     0,   197,     0,     0,     0,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,     0,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,     0,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,     0,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,     0,     0,     0,
    1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,  4214,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,  1161,  1162,  1163,     0,  1164,  1165,  1166,
    1167,  1168,  1169,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,   711,   425,   426,
     427,   712,   713,   714,   715,   716,   717,   718,   428,   429,
     719,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,   720,   434,   435,   436,   437,   438,   721,   722,   439,
     440,   723,   140,   442,   724,   443,   444,   445,   446,   144,
     725,   726,   447,   448,   449,   450,   147,   451,   727,   728,
     453,   454,   455,   456,   457,   458,   729,   459,   460,   461,
     150,   462,   730,   731,   732,   733,   151,   734,   735,   736,
     463,   464,   465,   466,   467,   468,   154,   155,   469,   737,
     470,   738,   471,   472,   473,   474,   475,   739,   476,   477,
     478,   740,   741,   479,   480,   481,   482,   483,   742,   484,
     485,   486,   743,   487,   488,   744,   489,   490,   491,   492,
     164,   493,   494,   166,   745,   495,   746,   496,   168,   497,
     747,   498,   748,   499,   169,   749,   170,   500,   501,   502,
     750,   503,   172,   751,   504,   752,   505,   506,   507,   508,
     509,   173,   510,   511,   512,   753,   513,   514,   515,   516,
     517,   518,   754,   519,   174,   175,   755,   520,   521,   522,
     756,   177,   757,   178,   758,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,   759,   182,   183,   531,
     184,   760,   532,   533,   534,   761,   762,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,   763,   556,   557,   194,   558,   764,   195,   559,
     196,   560,   561,   765,   766,   562,   767,   768,   563,   564,
     565,   769,   770,   197,   198,   199,   200,   201,   566,   567,
     568,   569,   570,   571,   771,   572,   202,   573,   203,   574,
     575,   576,   772,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,   773,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   774,   597,   598,   211,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
     775,   609,   610,   611,   612,   613,   776,   614,   217,   615,
     616,   219,   617,   220,   777,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,   778,   629,   630,
     779,   631,   632,   633,   634,   635,   636,   780,   224,   225,
     781,   782,   638,   226,   639,   227,   783,   640,   641,   642,
     643,   644,   645,   784,   785,   646,   647,   648,   649,   786,
     787,   650,   651,   652,   653,   788,   235,   789,   655,   236,
     656,   657,   658,   790,   791,   659,   792,   793,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,  2153,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,   133,   431,   432,   433,     0,  1784,   137,
    1785,  1786,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,  1787,  1788,   442,     0,   443,   444,   445,   446,
       0,     0,     0,   447,   448,   449,   450,   147,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,   150,   462,     0,     0,     0,     0,   151,     0,     0,
       0,   463,   464,   465,   466,   467,   468,  1789,  1790,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,  1419,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,     0,   493,   494,     0,     0,   495,     0,   496,  1791,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   507,
     508,   509,   173,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,   174,     0,     0,   520,   521,
     522,  1425,  1792,     0,  1793,     0,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,     0,     0,   183,
     531,   184,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,  1794,   190,  1795,   548,   549,   550,   551,   552,   553,
     554,     0,   555,     0,   556,   557,   194,   558,     0,     0,
     559,  1796,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,     0,   198,   199,   200,     0,   566,
     567,   568,   569,   570,   571,     0,   572,     0,   573,     0,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,  1797,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   211,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,  1798,
     615,   616,   219,   617,  1799,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,  1800,
    1801,     0,     0,   638,     0,   639,     0,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,     0,  1802,     0,   655,
     236,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,     0,     0,     0,     0,     0,     0,
       0,     0,   665,   666,   667,     0,    86,    87,    88,   403,
      90,    91,    92,   404,  2255,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,    86,    87,    88,
     403,    90,    91,    92,   404,  1051,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,     0,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,     0,     0,   562,     0,
       0,   563,   564,   565,     0,     0,   197,     0,     0,     0,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,     0,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,     0,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,     0,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,     0,    86,    87,
      88,   403,    90,    91,    92,   404,  4092,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  2140,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,  1927,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,  1928,     0,   562,
    1929,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
    1930,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,   962,  1595,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,  2146,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,  1927,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,  1928,     0,   562,  1929,
       0,   563,   564,   565,     0,     0,   197,     0,     0,     0,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,     0,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,  1930,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,     0,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,   962,  1595,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,  1927,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,  1928,     0,   562,  1929,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,  1930,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,   962,  1595,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,   416,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     417,   951,   419,   420,   421,   422,   423,   424,   952,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   953,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   954,   168,
     497,     0,   498,     0,   955,     0,   956,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,   957,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   958,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   959,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   960,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   961,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,     0,     0,
       0,     0,   962,   963,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     951,   419,   420,   421,   422,   423,   424,   952,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   985,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   954,   168,   497,
       0,   498,     0,   986,     0,   956,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,   957,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   958,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   959,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   960,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   961,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,   962,   963,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,   416,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,  1335,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   496,   168,   497,     0,
     498,     0,   499,     0,   956,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,   957,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,   224,   225,     0,
       0,   638,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
     962,   963,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  1340,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,   956,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,   957,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,   962,
     963,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,   416,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,   689,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
     197,     0,     0,     0,   201,   566,   567,   568,   569,   570,
     571,     0,   572,   202,   573,   203,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,   205,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   213,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,   217,   615,   616,     0,   617,
     220,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,   224,   225,  1500,     0,   638,
     226,   639,   227,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,   235,     0,   655,     0,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
     238,   239,   240,   241,   242,   243,   244,   245,   665,   666,
     667,     0,     0,  1023,  1501,    86,    87,    88,   403,    90,
      91,    92,   404,  1024,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
    1025,   440,  1000,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,  1026,
       0,  1027,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,  1028,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
    1029,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
    1030,   600,   213,   601,   602,   603,  1031,   605,   606,   607,
     608,     0,   609,   610,   611,   612,  1032,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,  1033,
     225,     0,     0,  1034,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,  1004,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,  1035,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   711,
     425,   426,   427,   712,   713,   714,   715,   716,   717,   718,
     428,   429,   719,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,   720,   434,   435,   436,   437,   438,   721,
     722,   439,   440,   723,   140,   442,   724,   443,   444,   445,
     446,   144,   725,   726,   447,   448,   449,   450,   147,   451,
     727,   728,   453,   454,   455,   456,   457,   458,   729,   459,
     460,   461,   150,   462,   730,   731,   732,   733,   151,   734,
     735,   736,   463,   464,   465,   466,   467,   468,   154,   155,
     469,   737,   470,   738,   471,   472,   473,   474,   475,   739,
     476,   477,   478,   740,   741,   479,   480,   481,   482,   483,
     742,   484,   485,   486,   743,   487,   488,   744,   489,   490,
     491,   492,   164,   493,   494,   166,   745,   495,   746,   496,
     168,   497,   747,   498,   748,   499,   169,   749,   170,   500,
     501,   502,   750,   503,   172,   751,   504,   752,   505,   506,
     507,   508,   509,   173,   510,   511,   512,   753,   513,   514,
     515,   516,   517,   518,   754,   519,   174,   175,   755,   520,
     521,   522,   756,   177,   757,   178,   758,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,   759,   182,
     183,   531,   184,   760,   532,   533,   534,   761,   762,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,   763,   556,   557,   194,   558,   764,
     195,   559,   196,   560,   561,   765,   766,   562,   767,   768,
     563,   564,   565,   769,   770,   197,   198,   199,   200,   201,
     566,   567,   568,   569,   570,   571,   771,   572,   202,   573,
     203,   574,   575,   576,   772,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   773,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   774,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   775,   609,   610,   611,   612,   613,   776,   614,
     217,   615,   616,   219,   617,   220,   777,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,   778,
     629,   630,   779,   631,   632,   633,   634,   635,   636,   780,
     224,   225,   781,   782,   638,   226,   639,   227,   783,   640,
     641,   642,   643,   644,   645,   784,   785,   646,   647,   648,
     649,   786,   787,   650,   651,   652,   653,   788,   235,   789,
     655,   236,   656,   657,   658,   790,   791,   659,   792,   793,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,  2962,   422,   423,   424,
     711,   425,   426,   427,   712,   713,   714,   715,   716,   717,
     718,   428,   429,   719,   430,   133,   431,   432,   433,   135,
     136,   137,   138,   139,   720,   434,   435,   436,   437,   438,
     721,   722,   439,   440,   723,   140,   442,   724,   443,   444,
     445,   446,   144,   725,   726,   447,   448,   449,   450,   147,
     451,   727,   728,   453,   454,   455,   456,   457,   458,   729,
     459,   460,   461,   150,   462,   730,   731,   732,   733,   151,
     734,   735,   736,   463,   464,   465,   466,   467,   468,   154,
     155,   469,   737,   470,   738,   471,   472,   473,   474,   475,
     739,   476,   477,   478,   740,   741,   479,   480,   481,  2963,
     483,   742,   484,   485,   486,   743,   487,   488,   744,   489,
     490,   491,   492,   164,   493,   494,   166,   745,   495,   746,
     496,   168,   497,   747,   498,   748,   499,   169,   749,   170,
     500,   501,   502,   750,   503,   172,   751,   504,   752,   505,
     506,   507,   508,   509,   173,   510,   511,   512,   753,   513,
     514,   515,   516,   517,   518,   754,   519,   174,   175,   755,
     520,   521,   522,   756,   177,   757,   178,   758,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,   759,
     182,   183,   531,   184,   760,   532,   533,   534,   761,   762,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,   190,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,   763,   556,   557,   194,   558,
     764,   195,   559,   196,   560,   561,   765,   766,   562,   767,
     768,   563,   564,   565,   769,   770,   197,   198,   199,   200,
     201,   566,   567,   568,   569,   570,   571,   771,   572,   202,
     573,   203,   574,   575,   576,   772,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,   773,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   774,   597,
     598,   211,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,   775,   609,   610,   611,   612,   613,   776,
    2964,   217,   615,   616,   219,   617,   220,   777,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
     778,   629,   630,   779,   631,   632,   633,   634,   635,   636,
     780,   224,   225,   781,   782,   638,   226,   639,   227,   783,
     640,   641,   642,   643,   644,   645,   784,   785,   646,   647,
     648,   649,   786,   787,   650,   651,   652,   653,   788,   235,
     789,   655,   236,   656,   657,   658,   790,   791,   659,   792,
     793,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,   182,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,   704,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   705,   104,
     105,   406,   706,     0,   107,   108,   109,   110,   707,   708,
     112,   113,   114,   115,     0,   116,   709,   710,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,   135,   136,   137,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,     0,     0,
       0,   151,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
     495,     0,   496,   168,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,  1272,   173,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,   174,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,   182,   183,   531,   184,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,   190,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
     194,   558,     0,   195,   559,   196,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,   197,   198,
     199,   200,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   211,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,   219,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,     0,     0,   638,   226,   639,
     227,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,   236,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,     0,
       0,     0,   151,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,  1280,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,   182,   183,   531,   184,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
     198,   199,   200,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,   219,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
     704,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     705,   104,   105,   406,   706,     0,   107,   108,   109,   110,
     707,   708,   112,   113,   114,   115,     0,   116,   709,   710,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,  2304,   513,   514,   515,   516,   517,   518,     0,
     519,   174,  2305,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,     0,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
    2306,   198,   199,   200,     0,   566,   567,   568,   569,   570,
     571,     0,   572,     0,   573,     0,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,  1797,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   211,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,  2307,   615,   616,   219,   617,
    1799,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,  1800,  1801,     0,     0,   638,
       0,   639,     0,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,     0,  1802,  2308,   655,   236,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
       0,     0,     0,     0,     0,     0,     0,     0,   665,   666,
     667,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,  1784,   137,  1785,  1786,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1787,
    1788,   442,     0,   443,   444,   445,   446,     0,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,  1789,  1790,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,     0,   493,
     494,     0,     0,   495,     0,   496,  1791,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,     0,     0,   520,   521,   522,  1425,  1792,
       0,  1793,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,     0,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1794,   190,
    1795,   548,   549,   550,   551,   552,   553,   554,     0,   555,
       0,   556,   557,   194,   558,  2296,     0,   559,  1796,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,     0,   198,   199,   200,     0,   566,   567,   568,   569,
     570,   571,     0,   572,     0,   573,     0,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1797,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,  2307,   615,   616,   219,
     617,  1799,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,   628,     0,   629,   630,  3582,   631,
     632,   633,   634,   635,   636,     0,  1800,  1801,     0,     0,
     638,     0,   639,     0,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,     0,  1802,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,     0,     0,     0,     0,     0,     0,     0,     0,   665,
     666,   667,   704,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,     0,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,  2349,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,     0,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  1798,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,     0,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,     0,  1784,   137,  1785,
    1786,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,  1787,  1788,   442,     0,   443,   444,   445,   446,     0,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,     0,     0,     0,   151,     0,     0,     0,
     463,   464,   465,   466,   467,   468,  1789,  1790,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
       0,   493,   494,     0,     0,   495,     0,   496,  1791,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,     0,     0,   520,   521,   522,
    1425,  1792,     0,  1793,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,     0,   183,   531,
     184,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1794,   190,  1795,   548,   549,   550,   551,   552,   553,   554,
    3429,   555,     0,   556,   557,   194,   558,     0,     0,   559,
    1796,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,     0,   198,   199,   200,     0,   566,   567,
     568,   569,   570,   571,     0,   572,     0,   573,     0,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1797,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,  1798,   615,
     616,   219,   617,  1799,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1800,  1801,
       0,     0,   638,     0,   639,     0,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,     0,  1802,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,     0,     0,     0,     0,     0,     0,     0,
       0,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,   133,   431,   432,   433,     0,  1784,   137,
    1785,  1786,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,  1787,  1788,   442,     0,   443,   444,   445,   446,
       0,     0,     0,   447,   448,   449,   450,   147,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,   150,   462,     0,     0,     0,     0,   151,     0,     0,
       0,   463,   464,   465,   466,   467,   468,  1789,  1790,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,  1419,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,     0,   493,   494,     0,     0,   495,     0,   496,  1791,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   507,
     508,   509,   173,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,   174,     0,     0,   520,   521,
     522,  1425,  1792,     0,  1793,     0,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,     0,     0,   183,
     531,   184,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,  1794,   190,  1795,   548,   549,   550,   551,   552,   553,
     554,     0,   555,     0,   556,   557,   194,   558,     0,     0,
     559,  1796,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,     0,   198,   199,   200,     0,   566,
     567,   568,   569,   570,   571,     0,   572,     0,   573,     0,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,  1797,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   211,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,  1798,
     615,   616,   219,   617,  1799,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,  1800,
    1801,     0,     0,   638,     0,   639,     0,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,     0,  1802,     0,   655,
     236,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,     0,     0,     0,     0,     0,     0,
       0,     0,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,  1784,
     137,  1785,  1786,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1787,  1788,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,  1789,  1790,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
    1791,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,     0,     0,   520,
     521,   522,  1425,  1792,     0,  1793,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1794,   190,  1795,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,     0,
       0,   559,  1796,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,     0,   198,   199,   200,     0,
     566,   567,   568,   569,   570,   571,     0,   572,     0,   573,
       0,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1797,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
    2307,   615,   616,   219,   617,  1799,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1800,  1801,     0,     0,   638,     0,   639,     0,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,     0,  1802,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,     0,     0,     0,     0,     0,
       0,     0,     0,   665,   666,   667,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,     0,
    1784,   137,  1785,  1786,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,  1787,  1788,   442,     0,   443,   444,
     445,   446,     0,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,     0,     0,     0,   151,
       0,     0,     0,   463,   464,   465,   466,   467,   468,  1789,
    1790,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,  1419,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,     0,   493,   494,     0,     0,   495,     0,
     496,  1791,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   507,   508,   509,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,     0,     0,
     520,   521,   522,  1425,  1792,     0,  1793,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
       0,   183,   531,   184,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,  1794,   190,  1795,   548,   549,   550,   551,
     552,   553,   554,     0,   555,     0,   556,   557,   194,   558,
       0,     0,   559,  1796,   560,   561,     0,     0,   562,     0,
       0,   563,   564,   565,     0,     0,     0,   198,   199,   200,
       0,   566,   567,   568,   569,   570,   571,     0,   572,     0,
     573,     0,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,  1797,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   211,   599,   600,     0,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,     0,   615,   616,   219,   617,  1799,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,     0,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,  1800,  1801,     0,     0,   638,     0,   639,     0,     0,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,     0,  1802,
       0,   655,   236,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,     0,     0,     0,     0,
       0,     0,     0,     0,   665,   666,   667,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
       0,     0,   137,     0,     0,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,     0,     0,   442,     0,   443,
     444,   445,   446,     0,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,     0,   493,   494,     0,     0,   495,
       0,   496,     0,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,     0,
       0,   520,   521,   522,     0,     0,     0,     0,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,     0,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,     0,   190,     0,   548,   549,   550,
     551,   552,   553,   554,     0,   555,     0,   556,   557,   194,
     558,     0,     0,   559,     0,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,     0,   198,   199,
     200,     0,   566,   567,   568,   569,   570,   571,     0,   572,
       0,   573,     0,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,     0,   615,   616,   219,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,     0,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,     0,     0,     0,     0,   638,     0,   639,     0,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,     0,
       0,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,     0,     0,     0,
       0,     0,     0,     0,     0,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   711,   425,   426,   427,   712,   713,   714,   715,   716,
     717,   718,   428,   429,   719,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,   720,   434,   435,   436,   437,
     438,   721,   722,   439,   440,     0,   140,   442,   724,   443,
     444,   445,   446,   144,   725,   726,   447,   448,   449,   450,
     147,   451,   727,   728,   453,   454,   455,   456,   457,   458,
     729,   459,   460,   461,   150,   462,     0,   731,   732,   733,
     151,   734,   735,   736,   463,   464,   465,   466,     0,   468,
     154,   155,   469,   737,   470,   738,   471,   472,   473,   474,
     475,   739,   476,   477,   478,   740,   741,   479,   480,   481,
     482,   483,   742,   484,   485,   486,   743,   487,   488,   744,
     489,   490,   491,   492,   164,   493,   494,   166,   745,   495,
     746,   496,   168,   497,   747,   498,   748,   499,   169,   749,
     170,   500,   501,   502,   750,   503,   172,   751,   504,   752,
     505,   506,     0,   508,   509,   173,   510,   511,   512,   753,
     513,   514,   515,   516,   517,   518,   754,   519,   174,   175,
       0,   520,   521,   522,     0,   177,   757,   178,   758,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
     759,   182,   183,   531,   184,   760,   532,   533,   534,   761,
     762,   535,   536,   537,   538,   539,   540,     0,   542,   543,
       0,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,   763,   556,   557,   194,
     558,   764,   195,   559,   196,   560,   561,   765,   766,   562,
     767,   768,   563,   564,   565,   769,   770,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,   771,   572,
     202,   573,   203,   574,   575,   576,   772,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,   773,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   774,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,     0,   608,   775,   609,   610,   611,   612,   613,
     776,   614,   217,   615,   616,   219,   617,   220,   777,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,   778,   629,   630,   779,   631,   632,   633,   634,   635,
     636,   780,   224,   225,     0,   782,   638,   226,   639,   227,
     783,   640,   641,   642,   643,   644,   645,     0,   785,   646,
     647,   648,   649,   786,   787,   650,   651,   652,   653,     0,
     235,   789,   655,   236,   656,   657,   658,   790,   791,   659,
     792,   793,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,     0,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,  1927,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,  1928,     0,   562,
    1929,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
    1930,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  4462,     0,    45,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,   637,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  1111,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  2126,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,  2275,   443,
     444,   445,   446,   144,     0,  2319,   447,   448,   449,   450,
       0,   451,   452,  2276,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
    2320,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,  2278,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,  2279,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,  2280,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,  2275,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,  2276,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
    2320,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,  2278,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,  3083,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,  2279,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,  2280,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,  1013,   423,
     424,   971,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
     972,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  1014,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,   973,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   974,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1907,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   971,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
     972,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  2855,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,   973,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   974,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,  2275,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,  2276,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
    2320,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,  2278,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,  2279,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,  2280,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   687,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,   688,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,   689,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   971,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
     972,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,   973,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   974,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,   888,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   889,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   890,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  1963,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,  1964,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,  1965,   499,     0,     0,
       0,  1966,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,  1967,  1968,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,  1969,
     605,   606,   607,   608,     0,  1970,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,  1971,   631,  1972,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
     972,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,   973,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   974,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,   130,   131,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,  1325,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,  1952,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,  2237,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,  2745,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,  2746,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,  2747,   631,   632,  2748,   634,  2749,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   696,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,   689,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   843,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  1263,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,  2394,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  2395,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,   130,   131,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  2899,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  2900,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  2911,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  2912,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   894,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   935,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   989,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,  1044,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  1503,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,  1859,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,  1952,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,  2237,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
    3120,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
    3133,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,  3175,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  3887,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  3889,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,  3891,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,  4047,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   997,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   999,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,  1000,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1001,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1002,   225,     0,     0,  1003,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  1038,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,  1000,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1039,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1040,   225,     0,     0,  1041,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,  1060,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,  1183,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,  1246,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1277,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1282,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1290,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1292,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1294,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1296,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1299,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1301,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,  1302,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1305,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,  1514,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,  1025,   440,  1000,   140,  1515,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,  1029,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,  1030,   600,   213,   601,   602,   603,  1031,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1507,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1033,   225,     0,     0,  1034,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,  1035,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
    1537,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,     0,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,  1637,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1885,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1887,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,  2002,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  2526,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  2902,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  2904,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,  1025,   440,  1000,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,  1029,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,  1030,   600,   213,   601,   602,   603,  1031,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1507,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1033,   225,     0,     0,  1034,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,  1035,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,  1025,   440,  1000,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,  1029,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,  1030,   600,   213,   601,   602,   603,  1031,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1507,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,  2266,   633,   634,   635,
     636,     0,  1033,   225,     0,     0,  1034,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,  1035,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,  1025,   440,  1000,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,  1029,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,  1030,   600,   213,   601,   602,   603,  2300,
     605,   606,   607,   608,     0,   609,   610,   611,   612,  1507,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1033,   225,     0,     0,  1034,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1004,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,  1035,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,     0,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,     0,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,     0,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115, -2161,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,   127,    35,     0,   398,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     154,   155,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   164,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   177,     0,   178,     0,     0,
     179,   180,     0,   181,     0,     0,     0,     0,     0,     0,
       0,   182,   183,     0,   184,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   189,   190,   191,     0,     0,     0,
       0,     0,     0,     0,   192,     0,     0,     0,     0,   194,
       0,     0,   195,     0,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   197,   198,   199,
     200,   201,     0,     0,     0,     0,     0,     0,     0,     0,
     202,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
   -2162,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
      35,     0,  1106,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,   147,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,   155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   164,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   177,     0,   178,     0,     0,   179,   180,     0,
     181,     0,     0,     0,     0,     0,     0,     0,   182,   183,
       0,   184,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   189,   190,   191,     0,     0,     0,     0,     0,     0,
       0,   192,     0,     0,     0,     0,   194,     0,     0,   195,
       0,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,   198,   199,   200,   201,     0,
       0,     0,     0,     0,     0,     0,     0,   202,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   154,   155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   164,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   177,
       0,   178,     0,     0,   179,   180,     0,   181,     0,     0,
       0,     0,     0,     0,     0,   182,   183,     0,   184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,     0,     0,     0,     0,     0,     0,     0,   192,     0,
       0,     0,     0,   194,     0,     0,   195,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   197,   198,   199,   200,   201,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   235,     0,     0,   236,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,   155,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   164,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   177,     0,   178,     0,
       0,   179,   180,     0,   181,     0,     0,     0,     0,     0,
       0,     0,   182,   183,     0,   184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
       0,     0,     0,     0,     0,   192,     0,     0,     0,     0,
     194,     0,     0,   195,     0,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   197,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245
};

static const short yycheck[] =
{
       2,   117,   210,    78,  1119,    78,    78,    78,   167,   973,
     974,   246,  1281,   351,   978,  1027,   901,  1329,  1379,   152,
    1075,   153,   913,  1360,  1319,     2,   917,   864,   826,   188,
    1288,  1077,  1142,   228,  1174,  1909,   927,  1656,  1245,  1694,
    1870,   149,  1814,  1191,  1184,  1966,   162,  1392,  1148,    89,
    1798,   171,   165,  1678,  1034,  1100,  1534,   702,  1417,  1418,
    1916,     2,  1446,    94,  2510,  1684,   864,  2622,  1728,    78,
     366,  2115,   204,  2348,   132,   366,  2895,  1436,   915,  1734,
    1735,  1558,  3107,  1222,   117,  1847,  1226,    89,  1833,  1833,
     210,  1231,  1589,  1590,  1591,   223,   703,  2962,  1238,  2964,
    1833,   132,  2312,  2313,   232,  1678,  2005,  1247,  1833,  1833,
    1833,  2162,   816,  1119,   230,  2759,   160,   915,   822,  1042,
    2596,   152,   153,  2515,  2516,   339,  3027,   167,  3061,   162,
    2757,   940,   163,  3382,  1273,    78,  3530,  2521,  1722,   148,
     353,    84,  1684,  1905,  3583,  1030,   353,  2173,   188,   853,
     152,  3768,  1646,  3353,  1342,    78,   165,   159,  1320,   216,
    3061,    84,  3593,  1584,  1585,  1643,   167,  3557,  1463,  1311,
    2211,  1153,  1072,   204,    21,  1149,  2168,  1407,  1408,  2454,
    1072,  1114,  1115,  3774,   186,   120,    30,   188,  3041,  3042,
    3043,  3044,  3045,  3046,   117,    10,   108,   230,  3246,    72,
      88,   905,  1432,   127,  2755,  2756,   205,    88,   912,  2250,
    1184,    72,   932,  2254,   134,    72,   810,    75,    76,    77,
      78,  3561,   102,   227,    82,    86,   167,  1568,  3610,    86,
    3612,    72,   113,   117,    84,   154,   143,   246,   127,   162,
      81,   147,   181,   888,   180,    86,    78,   188,   233,   227,
      75,    76,    77,    78,   227,   227,  1220,    82,  2533,    14,
    2535,    75,    76,    77,    78,    93,  4157,   181,    82,  4049,
    4050,    95,   112,   140,   227,    78,    90,   229,   162,   127,
     364,    84,    37,   358,  1329,   358,   358,   358,   117,    99,
      75,    76,    77,    78,   228,  2067,   106,    82,    75,    76,
      77,    78,   188,    78,   334,    82,   174,   230,    78,    84,
     329,  4104,   240,   181,   117,   127,   210,    72,   112,   100,
      75,    76,    77,    78,   266,   209,    81,    82,    83,    84,
     324,    86,   216,   162,   218,   372,    75,    76,    77,    78,
      99,    99,   117,    82,   353,   247,   230,   106,   106,   358,
     117,    90,    72,    99,    99,   109,   181,    22,   424,   162,
      78,    81,  2428,    78,   207,   401,    86,   295,   184,  1206,
    1518,   402,   114,  1759,   198,   186,   341,    85,  1488,  1024,
      78,    71,   210,  3777,   469,   500,    38,   162,    40,    79,
      80,    95,   507,   135,    14,   162,  2437,  1320,  1289,    88,
     314,   230,   227,   469,   470,   370,   209,    72,  1206,    75,
      76,    77,    78,   216,   450,   218,    82,  1801,   502,  1304,
     505,   264,    29,   366,   113,    88,    99,   230,   244,   200,
    1789,  1790,   469,   385,   399,   189,   502,  1796,    75,    76,
      77,    78,   209,   366,  1329,    82,   314,   193,   193,   216,
    4243,   218,   376,    25,   473,   230,   375,   266,   401,   432,
     327,   227,   390,   230,    75,    76,    77,    78,   505,  1855,
      25,    82,  1517,   387,  1365,   505,  1521,  1522,   401,    90,
     261,   247,    75,    76,    77,    78,  3419,   376,   440,    82,
    1381,   334,  1196,   373,   198,  4112,  1765,   134,   434,  1203,
     266,   505,  1393,   502,   637,   385,  3900,   401,   502,  1116,
    1117,  1769,    75,    76,    77,    78,   812,   341,  3419,    82,
     505,   812,  1331,  3376,   502,   432,   358,    90,   376,    75,
      76,    77,    78,   505,  4314,   471,    82,   443,    75,    76,
      77,    78,  1136,   411,    90,    82,   414,  4438,  3942,  1253,
     489,   401,   505,   685,   686,   383,   436,  1787,  1788,  2307,
    1483,  3505,   504,   366,   376,  1795,   452,   502,   502,    75,
      76,    77,    78,   401,  1781,   399,    82,  3959,  1718,   419,
    1720,   505,   502,   456,  2859,  3136,   505,  3927,   358,  1309,
     502,   366,    75,    76,    77,    78,   406,   134,   401,    82,
    1523,  1524,   445,   505,  4221,   452,   637,   432,  2600,  1757,
     498,  3659,    75,    76,    77,    78,   505,   498,  1663,    82,
    4211,  1958,   330,  1762,  1669,   419,   401,  2105,   469,  1514,
    2290,  2109,   493,   494,   502,   637,   493,   494,  1778,   450,
     358,   456,   500,   358,   502,   502,   504,   406,   406,   496,
    4044,   258,   493,   494,   685,   686,   500,   505,  4052,  3512,
     358,   174,   314,  1554,   489,  1710,   370,  3311,  1713,  1714,
    1603,   702,   103,   104,   347,  1575,  2886,  3123,  2888,   504,
    2510,  3127,   266,  1575,   136,   818,   452,  2312,   502,  3316,
     262,  4137,   808,   470,   465,  1677,   505,  2038,    75,    76,
      77,    78,  2694,  4320,   832,    82,   941,   262,   230,  2004,
    2005,   488,   210,  1320,   270,    95,  1816,   502,   118,   324,
    2015,  1766,   328,  2018,   857,   502,  2770,  4158,   942,  3004,
    3005,  2026,  2027,  1707,  3924,  4150,  4126,  1075,   493,   494,
     506,   306,  2783,   222,  2039,  2040,    75,    76,    77,    78,
     183,  1939,   425,    82,   427,  2050,   208,  1945,   890,   181,
    1922,    95,  2788,   502,  4381,     0,   327,   101,   896,  2263,
     306,  1913,   224,   493,   494,   808,   909,  2319,   295,   158,
     185,   489,   490,   491,   218,   493,   494,   495,   496,   497,
     498,  2212,   951,  2214,   953,   226,   955,   228,  2355,    14,
    2030,  2031,   961,   847,   470,   361,   495,   496,   497,   498,
      72,   149,   461,    75,    76,    77,    78,  3027,   198,    81,
      82,   227,   488,   460,    86,   266,   985,   986,   941,   937,
     198,  4277,   495,   496,   497,   498,   502,   229,   107,  4456,
     186,   247,  2399,   243,   174,   227,   848,   247,  4287,   283,
     128,  3061,   190,   232,   176,   176,   984,   888,   136,   890,
     266,    25,   267,   266,   198,   502,  1703,   460,   452,   812,
     356,    35,   394,   390,  2499,    88,   270,    75,    76,    77,
      78,   229,   282,   396,    82,   808,   319,   181,  1852,   812,
     455,   502,   136,   372,   500,  3105,   227,   502,   504,   901,
     902,   423,   354,   401,   935,  1703,  2490,   151,   939,   502,
     266,   951,   181,   953,   260,   955,   247,  3942,   240,   240,
    1048,   961,   506,  2753,   808,  3869,  3870,  3871,  3872,  3873,
     932,   940,   941,  2999,   227,   266,  3002,  3003,   330,   502,
    3006,   502,   227,  1056,  4359,   985,   986,   149,   484,   505,
    3016,  4141,   953,   383,   955,   932,   502,  4403,  1970,  1971,
    4209,   341,   247,  3347,   208,   502,  4360,   361,  1026,   133,
     392,  1028,   120,   295,   295,  1032,   306,   298,   266,   808,
     224,   266,   330,   230,   985,   986,   328,   989,   190,   235,
     370,   932,  1883,  1024,   446,  1026,   502,  1920,   377,   181,
     422,  1892,  2774,   403,   342,   808,   374,   341,   286,   812,
     951,   452,   953,  1904,   955,  1017,   502,  4217,  4218,   502,
     961,   962,   963,  1025,   172,   319,    88,  1029,  1030,  1031,
     461,   399,   120,   808,   158,   457,   370,   812,  3903,   502,
     175,   808,   341,   183,   985,   986,   452,   469,    99,   452,
      88,   113,  1889,    72,   185,   268,    75,    76,    77,    78,
    1100,   153,    81,    82,    83,    84,   414,    86,   390,   390,
     221,   370,   502,  1964,  1114,  1115,  1967,  4412,  1969,  1119,
     502,  1972,   176,    85,   172,   334,    88,  2446,   426,  3733,
     469,  1889,  1688,   439,   145,    88,   452,   149,   262,  3743,
     506,   152,  3729,   195,   450,   266,  1049,   186,   232,   127,
     354,   259,  1114,  1115,  3741,   250,  1925,  1119,   383,   198,
     113,   452,   228,  1100,   503,   502,  1049,   506,   111,  4062,
     383,   182,   314,  1729,  2249,   381,   267,   219,   190,   432,
     342,  4476,  1119,   422,  1028,    71,   240,   394,  1032,    75,
      76,    77,    78,    79,    80,  3601,    82,   410,   306,  1100,
    3606,  4062,   483,  3609,   452,   186,  1870,   452,  1872,   149,
    3646,   259,   334,   502,   314,   506,   423,  1881,  1119,  4379,
    2387,   502,    71,    72,  2229,   450,    75,    76,    77,    78,
      79,    80,    81,    82,  4053,   340,   489,    86,   349,  2036,
     251,   295,   446,   502,   298,  3597,   268,   269,   162,  3419,
     190,   504,  1256,  2873,   412,   413,  1157,   151,   306,  1221,
     489,   506,     5,   305,   426,  1028,   432,  2150,  1463,  1032,
     268,   500,   494,   502,   503,   504,   505,   343,  2036,   260,
     388,   452,    25,  2249,   432,   247,  1049,   181,   353,   158,
     176,  3172,    35,   377,   503,   317,   505,   385,  4117,  2528,
    2885,  1028,  1966,   246,   489,  1032,   268,   434,  2475,  2476,
    2477,  2478,   351,   502,  1049,   268,   230,   173,  2536,   504,
     493,   494,   495,   496,   497,   498,   421,   422,   306,  1329,
     342,   502,   181,  3123,  3345,  1368,   390,  3127,   404,   505,
     388,   247,  1304,  3202,   471,   434,  1308,  1309,   436,  1311,
     218,  2789,  2885,  2790,   240,  1922,  2361,   505,  3063,  3063,
    2661,  2662,  1331,   232,  2369,  2666,  2371,  1329,   330,   434,
    3063,  1308,  1309,  1547,  1311,  4360,  2631,  1633,  3063,  3063,
    3063,   503,  1633,   505,  3619,   469,  3621,  1378,  1561,  1562,
     133,  1564,  1329,  4212,  1561,  1562,   252,  1564,   376,  1368,
     432,  4220,   342,   414,  2705,  2706,   471,  1308,  1309,   295,
    1311,   392,   298,  1375,   426,   283,   265,  4021,  4022,   503,
     314,   399,   506,  2522,  2679,   268,   385,   228,  1329,   483,
    4255,    85,  1401,   173,    88,  3157,  3462,   286,   294,   314,
     296,   385,  3468,  3469,  3470,  3471,  3472,  3473,   502,  2519,
     209,  1420,   176,  2708,   197,   256,  1532,   489,   326,    75,
      76,    77,    78,  3978,   370,   231,    82,  2318,   374,   450,
     271,   493,   494,   495,   496,   497,   498,   436,  3093,   280,
     222,  1450,  1500,  1501,   359,   328,   426,  4266,  2743,   248,
     232,   381,   436,   399,  1463,   493,   494,   495,   496,   497,
     498,   341,   231,  1465,   390,   247,   500,  1583,  1831,  1500,
    1501,   306,   506,  1475,   493,   494,   240,  1517,   506,   262,
     286,  1521,  1522,  1485,  4039,  1848,  4041,   489,   490,   491,
     370,   493,   494,   495,   496,   497,   498,   332,   332,  1532,
     493,   494,   495,   496,   497,   498,   341,   341,   183,   193,
    3956,   195,  1514,   158,   294,  1517,   296,   286,   207,  1521,
    1522,   451,    81,   469,   136,   506,  2863,    86,   128,   218,
    1646,   295,  2891,   222,   298,   180,   193,  3034,   195,   380,
    1517,   186,   469,  1601,  1521,  1522,   146,    75,    76,    77,
      78,   184,  1561,  1562,    82,  1564,  3386,   483,   361,  4203,
     341,   161,   193,  1603,   195,   374,   211,   341,     8,   181,
    1601,    11,    12,   184,   268,   264,  1517,   505,   505,   254,
    1521,  1522,    22,    23,    24,   216,    26,    27,   353,   370,
     399,    31,    32,    33,   283,   469,   370,   379,   401,  2244,
     374,  1603,   954,   508,   493,   494,   958,   959,   960,  1532,
     218,   244,   212,  1646,   222,   260,   968,  2502,  1595,   425,
     455,   427,   341,  1663,    41,   399,   390,    14,   462,  1669,
     314,   505,   193,   244,   195,    85,   330,   326,    88,   314,
     324,  1584,  1585,  1620,  1621,   334,   262,   450,  1532,   370,
      37,   370,  1593,   374,  1595,   216,   425,   463,   427,  3137,
    1583,  1584,  1585,   229,  2549,   295,   186,   324,   298,   434,
    1710,   341,  1613,  1713,  1714,   283,   143,   452,   399,  1620,
    1621,   337,   393,   314,   151,    72,  1663,   425,   319,   427,
    1633,   257,  1669,   324,  2585,   469,    88,  1640,   361,  1583,
     370,  3745,   314,  1532,    14,  3183,   471,   319,   371,   392,
    1633,   422,  1828,    75,    76,    77,    78,  1640,   326,   483,
      82,   113,  1663,  1646,  1726,   360,  1766,    37,  1669,  1532,
    2775,    16,   395,  1710,   174,  3072,  1713,  1714,  3510,   422,
     260,   151,   354,  1978,   209,   273,  1879,   392,   469,   384,
    3405,  3406,   463,   218,   366,   218,   445,  1532,   319,   222,
     390,  3223,  1646,   324,   341,  1532,  1650,  3833,  3834,  1710,
      51,  3601,  1713,  1714,   457,   356,  3606,   422,   227,  3609,
    1583,  1584,  1585,  2883,   174,  3247,   469,  1671,    69,  1766,
    3268,  1999,  2772,   370,  2806,  1828,   316,  3457,   247,   493,
     494,   495,   496,   497,   498,   450,  2510,   438,  1583,  1584,
    1585,   222,   457,  1926,   503,   393,   447,  1646,   268,   502,
     283,   231,   399,  4378,   469,  1766,    75,    76,    77,    78,
    1633,   242,  1834,    82,   446,    72,   325,  1640,   470,   328,
     250,   470,   503,  1646,   422,   506,   497,  1650,  4123,    86,
    3195,   502,  4062,   504,  1982,   222,   488,   502,  1633,   488,
     300,  1870,  1746,   326,  2160,  1640,  3250,  3251,  1671,  2160,
     502,  1646,   392,   502,   389,   242,   286,   438,  1998,  1646,
     330,    71,    72,  1650,    97,   463,   447,  3228,  2725,   323,
    3231,  3232,  3233,  3234,  3235,  3236,  3237,  3238,  3239,  3240,
     186,  3757,   422,   116,  1671,  1828,    75,    76,    77,    78,
     350,  1913,   502,    82,  1916,  1990,  1925,  1990,  1990,  1990,
     500,  1862,   470,   333,   504,  3286,   273,  2725,  2573,  3701,
     450,   505,   425,     7,   427,   509,  1913,   457,   341,  1916,
     488,  3560,  4152,  1746,  1828,    19,    20,  3288,  3289,   469,
    3698,  3576,   150,   328,    34,  2071,    85,   319,   333,    88,
    2851,  2852,  3257,  2854,   432,    39,   120,   370,    42,  1978,
     436,   374,  1913,   328,   260,  1916,   133,   134,   333,  1746,
    1332,  1990,   502,  1335,   113,   387,  1338,   503,  1340,   118,
     506,  1343,   162,   372,    85,  1347,   399,    88,   392,  1828,
     497,   441,  2800,   174,   202,   502,   500,   504,   502,   163,
     504,  2661,  2662,  4079,   105,   425,  2666,   427,   389,   505,
     501,  2023,   424,   509,   505,  1828,   436,  2186,   422,   315,
     316,  3481,  3482,   187,   126,  3485,   446,  3487,  2071,  3398,
     490,   491,   155,   493,   494,   495,   496,   497,   498,  2753,
    3387,  3388,   206,  1828,   250,  2705,  2706,  2170,   228,    85,
    2951,  1828,  2270,   457,  2272,   157,  2075,   469,   470,   223,
     319,   495,   496,   497,    85,  2016,  2017,    88,   276,   277,
     154,   501,   507,  2024,   238,   505,   256,  2028,  2029,    72,
    1176,   289,  1178,  2678,   105,  2680,  2681,   242,  3062,  1185,
     502,   271,  2043,   503,  2045,   505,   392,   500,   502,   502,
     280,   174,    75,    76,    77,    78,   389,   387,   247,    82,
     194,  2053,   214,  2064,  2056,  2066,  3956,    75,    76,    77,
      78,  2133,  2265,   303,    82,   503,   422,   505,    86,   268,
     269,   273,   503,   341,   505,     2,  2186,  2263,  2071,   502,
     319,   504,   508,   245,   424,   505,   506,   103,   104,   503,
    3051,   505,  3053,   124,   450,   319,  3478,  2176,   503,   502,
     505,   457,   162,   327,  2115,    86,   186,   268,   503,   502,
     505,  4102,  3523,   469,   503,   328,   505,  2071,   317,  2229,
    3338,   505,   503,  2233,   505,    75,    76,    77,    78,   469,
     470,   330,    82,   124,    85,   359,   503,    88,   505,  2249,
     380,   114,   158,  2244,   485,  4045,   502,  2160,   181,  3104,
    2353,    78,   270,  2339,   105,   504,   424,    84,   426,  3027,
    2263,  2233,   502,   181,   180,   469,   470,  2160,   228,   330,
     186,   503,  2071,   505,   503,  2186,   505,  2249,   331,  2251,
     260,  2253,  2229,  3308,  3309,   383,   384,   268,  2374,   503,
     117,   505,  4034,  3061,   328,   211,   256,    85,  2071,  2212,
      88,  2214,  2249,   331,  2251,  2510,  2253,   383,   384,  3170,
      85,   271,   374,    88,   376,   432,   378,   105,  2229,  2212,
     280,  2214,   384,   328,  3394,   152,  2071,   485,  2300,   391,
     502,   181,   504,  3194,  2071,   162,  2339,   399,  2249,   503,
    2251,   505,  2253,   303,   260,   407,  3941,    71,    72,   330,
    4150,  2361,   503,   415,   505,    79,    80,   505,   506,  2369,
     136,  2371,    86,   493,   494,   495,   496,   497,   328,   207,
    2263,   114,   503,   503,   505,   151,   331,   503,  3709,   505,
     218,   485,   209,  2461,   222,   486,   487,  2160,  4232,   216,
    4234,   218,  3703,  3704,   493,   494,   495,   496,   497,   498,
     469,   470,   464,   230,   425,   181,   427,   183,  3585,  2263,
     270,   503,   392,   505,  2361,  2160,   503,   268,   505,   503,
     380,   505,  2369,  3688,  2371,   503,   264,   505,   489,   490,
     491,   495,   493,   494,   495,   496,   497,   498,   503,  2212,
     505,  2214,   422,   469,   470,   283,  2339,   399,  2420,  3123,
    2361,    96,   226,  3127,  2762,   503,  2428,   505,  2369,   505,
    2371,   106,   502,  3478,  2263,   503,   503,  2212,   505,  2214,
     450,   425,   503,   427,   505,   124,   392,   457,   254,   330,
     268,  2374,  1383,  1384,   503,  2339,   505,   503,   326,   469,
    2263,   506,   452,   268,    89,   495,   334,   142,  3172,   503,
     508,   505,  2474,  2708,   432,    98,   422,   508,   489,   490,
     491,   156,   493,   494,   495,   496,   497,   498,  2263,   503,
    2374,   505,   502,   262,  2496,   503,  2263,   505,  2807,  2808,
    2502,  2510,   432,  2444,   450,   432,   432,   130,   314,   366,
    2339,   457,   330,   319,   387,   461,  4135,   503,  3855,   505,
     143,   204,   503,   469,   505,   330,   502,   108,   151,  4359,
     432,   503,   155,   505,   124,  3847,  2339,   503,   503,   505,
     505,   503,  2573,   505,   401,  2374,   262,  2549,   354,   268,
     432,   424,   175,  2748,  2749,  1069,   502,  1071,   472,   503,
     366,   505,   504,   503,  2339,   505,   503,   503,   505,   505,
    2686,  2374,  2339,   196,   503,  2691,   505,   445,  3228,   502,
     502,  3231,  3232,  3233,  3234,  3235,  3236,  3237,  3238,  3239,
    3240,   504,   150,  3478,   502,   328,   469,   470,   503,  2374,
     505,   159,   160,   161,   222,   506,   229,  2374,   489,   490,
     491,   281,   493,   494,   495,   496,   497,   498,   503,   452,
     505,  3419,  3128,   328,  3130,   502,  3987,   250,   323,   502,
      75,    76,    77,    78,   503,   273,   505,    82,  3288,  3289,
     446,   503,  3983,   505,   389,   203,  3537,  3538,  2589,   136,
     503,   274,   505,  2686,    75,    76,    77,    78,  2691,   469,
     503,    82,   505,  4288,  3774,   502,  4007,  4008,   503,   108,
     505,   489,   490,   491,   472,   493,   494,   495,   496,   497,
     498,   503,  3386,   505,   489,   490,   491,   502,   493,   494,
     495,   496,   497,   498,   252,   503,   503,   505,   505,  2708,
     114,   114,  3842,  3749,   503,   441,   505,   330,   493,   494,
     495,   496,   497,  2722,   341,   503,   501,   505,    75,    76,
      77,    78,   222,  4018,    95,    82,   503,   503,   505,   505,
     101,   148,  2741,   291,   357,  2775,   181,   503,   357,   505,
    3631,  3632,  3633,   503,  2753,   505,   503,  4402,   505,   307,
     308,   309,   310,   311,  4091,   313,   507,   503,   381,   505,
     452,   212,   385,  2686,   387,   503,   212,   505,  2691,   140,
     393,   502,   212,  2775,    75,    76,    77,    78,   472,   212,
     637,    82,    75,    76,    77,    78,   503,   345,   505,    82,
      75,    76,    77,    78,   503,   505,   505,    82,  2775,   422,
     212,   424,  2686,   212,   503,   428,   505,  2691,    75,    76,
      77,    78,   503,   436,   505,    82,   212,   212,   441,  4180,
     191,   503,   328,   505,   212,   212,   212,   198,   212,  2770,
     201,   328,  2773,   212,  2775,   422,   502,   108,  4179,   281,
     463,   223,   222,   502,   222,   502,  2962,  2963,  2964,   502,
     502,   502,   350,   502,   502,   502,   502,  2686,   502,   502,
     418,   502,  2691,   502,  4225,    95,   502,   502,  4229,  4230,
     502,   101,   502,  3523,   502,   338,   502,   108,   502,   281,
     502,   252,   502,  2686,   505,   502,   444,   502,  2691,  4184,
     502,   502,   164,   451,   266,   268,   454,  3601,   108,   222,
     326,   222,  3606,   495,   262,  3609,  3022,   390,   298,  1224,
     140,  2686,   505,   451,   180,  3752,  2691,   505,   489,  2686,
      14,   505,   502,   502,  2691,   502,   504,  3818,  3819,  4241,
    3821,   432,   391,   432,   328,   306,   432,  3901,   432,   432,
     432,   432,   319,   432,  3060,   143,  2948,   451,  3080,   252,
     432,   808,   328,   432,  3752,   812,   502,  4226,   505,   816,
     341,   191,  3847,   175,   452,   822,  2968,   452,   198,  4227,
     341,   201,   341,   124,   432,   432,   432,   124,   432,   502,
    3113,   332,   432,   432,  3116,   125,   387,  3027,   432,  3022,
     328,   432,   328,   268,   432,   432,   853,  2999,   432,   370,
    3002,  3003,   469,   374,  3006,   460,   108,   502,  3081,   107,
      97,   181,   502,  4308,  3016,   463,   502,   452,   108,  3021,
     289,  3061,   252,  3096,   502,  3027,   462,  3060,   399,   222,
     108,  3033,   273,   173,   504,   388,   466,   894,   212,  2962,
    2963,  2964,   452,  3116,   212,   452,   212,   212,   905,  3080,
    3027,   126,    14,  3703,  3704,   912,   318,   432,  3949,  3061,
     323,  3296,   505,   377,  1379,   457,   227,   465,  3959,   430,
     502,   300,  3081,  3075,   485,   932,   306,   300,  2962,  2963,
    2964,    88,   157,   505,  3061,  3116,  3027,  3096,   399,   430,
     432,  3032,  3033,   227,   502,   434,   502,   241,   489,  3022,
     505,  3103,  3104,  3298,  3299,  3300,  3301,  3116,  3181,   249,
     241,   341,   505,  3054,  3123,   264,   505,   324,  3127,   489,
    3061,   329,   505,    34,    10,   432,   432,   387,  4140,   503,
     150,   387,   452,  2962,  2963,  2964,   503,  3060,  3022,   214,
     370,   503,   272,   503,   374,  3261,   502,  4202,   272,   328,
     502,   335,   319,   432,   294,   319,   296,  4426,   327,  2962,
    2963,  2964,   319,   396,   432,  1022,   306,   370,   505,   399,
     245,  1028,  3181,   370,   370,  1032,  3060,   432,   432,   361,
      95,   108,   268,   268,   268,   268,   101,  2962,  2963,  2964,
     327,   452,  1049,  3022,   452,  2962,  2963,  2964,   823,   268,
     340,  1058,   502,   828,   107,   489,   500,   432,   500,  4046,
     432,   222,   837,   489,   224,   324,   502,   211,   396,  3022,
     108,   328,   328,   496,   239,   140,   239,   222,  3261,  4066,
     108,  3060,   212,   328,   396,   375,   328,   862,   502,   222,
     505,   866,   247,   502,   247,   247,   472,  3022,  4046,    96,
     297,   876,  3956,   505,   233,  3022,   328,  3060,   505,   124,
     503,   503,   227,   938,  4062,   503,   341,   503,  4066,   409,
    3272,   503,   485,  3432,  4165,  3613,   191,   505,   953,   503,
     955,   485,   503,   198,   503,  3060,   201,  3296,   503,   503,
     965,   227,   503,  3060,   503,   370,   432,   503,   503,   374,
     337,   503,  3418,   378,  3420,    90,   466,   502,   502,   384,
     985,   986,   503,  3315,    90,   505,   391,   506,   489,   505,
     503,  4436,   503,   283,   399,   331,  1641,  3443,   328,   328,
     502,   432,   407,  3983,   455,   258,   212,   252,  3261,  1196,
     415,  4045,   319,   502,   502,  4236,  1203,   345,   212,   283,
     449,   432,   345,   292,   292,  4319,  4241,  4007,  4008,   292,
     268,  4065,   432,   268,   432,   432,  4481,  1224,   432,   432,
     432,   432,   268,   268,  4489,   268,  2038,  3261,   268,  3419,
     500,   268,   298,   283,   503,  3418,  1701,  3420,   503,   464,
     332,   306,  3432,   489,   372,   441,  1253,   174,  4102,   502,
     505,   327,   432,   503,   328,   236,   503,   336,   271,   502,
     271,   502,   324,   452,   452,   222,   387,  3419,   387,   387,
     210,   331,  3363,   505,   210,   505,   341,   500,   227,   204,
      88,  3433,  3261,   222,  3436,  2097,  3438,   503,  3478,   462,
     134,   235,  3419,   503,   503,   227,  4150,   502,  1763,   503,
     503,  1308,  1309,   503,  1311,   370,   505,   489,  3261,   374,
    3462,   503,  1319,   489,   489,  1780,  3468,  3469,  3470,  3471,
    3472,  3473,   329,   502,   222,   258,  3478,   441,  3419,  4316,
     441,   432,   432,   432,   399,   432,  3261,   503,   222,  1114,
    1115,  3432,   501,   272,  3261,  3418,   268,  3420,   268,   503,
     108,  3478,   503,  3505,   222,   472,   503,   253,  1823,   505,
     502,   469,  3514,  3515,  3516,  3517,  3493,   502,  4316,   503,
    3443,   469,  1379,   505,   146,   424,   469,    85,   502,  4179,
     505,   432,   502,   271,  3418,   232,  3420,  3478,   396,   502,
     227,    85,   227,   502,    88,   467,   503,   503,  1405,   503,
     467,  3492,  3493,   505,   124,   237,   227,  3630,  3766,  3443,
    3501,   432,   503,  1878,  3505,   469,   503,   441,   503,   113,
     319,  3573,   319,  3514,   118,   489,  1433,    85,   212,   268,
      88,   188,   319,   183,   505,   505,   254,   229,   501,  3418,
     227,  3420,  3601,   452,   199,   465,   452,  3606,   227,   255,
    3609,   469,  3761,  1460,  1461,   113,  1463,   227,   502,   331,
     118,   502,   456,   502,  3443,  3418,   408,  3420,   502,  1476,
     502,  3630,   503,  1480,   503,   468,   503,   344,  3787,   328,
     503,   366,   452,   502,   469,   502,   222,   108,   319,   293,
    3443,   250,   502,  3418,   211,  3420,   174,   136,  4352,   332,
     136,  3418,   384,  3420,   384,  4359,   331,   489,   124,  1334,
    1517,  1336,   206,   502,  1339,   334,  1341,   222,  3443,  1344,
    1345,  1346,   424,   328,  1531,  1532,  3443,   217,   358,   331,
     331,  4385,  1357,   194,    85,   456,   505,   108,   227,   505,
     364,   469,   466,   199,   108,  3636,  1371,   328,  1373,   243,
     328,   469,   502,   247,   383,   503,  1563,   502,   186,   450,
    1567,  1568,   503,   383,   502,    94,   105,   211,  3877,   358,
     358,  3761,   502,  1747,   268,   269,  1583,  1584,  1585,  3845,
    2460,  1522,  2775,  2896,  3418,   243,  2345,  3021,   282,   247,
    4082,  3845,  4241,  3745,  3746,  3564,  4135,  3787,  3894,  4139,
    2858,  2578,  4383,  4045,  2069,  3757,  4425,  4346,  4345,  4392,
     268,   269,  3566,  1849,  2290,  4159,  3443,  2963,  3745,  1835,
    2448,  3074,  4428,   317,   282,  4489,  1633,  3863,  4481,  3862,
    3757,  4485,    95,  1640,  1641,  3060,   330,  3903,   101,  1646,
    3026,  4399,  4068,  1650,  1826,  4327,  4071,   188,  1366,  4208,
    3639,  3574,  2313,  4288,  3745,  4408,   314,  3576,  4483,   317,
    4124,  2170,  3845,   902,  1671,  1926,  3757,  2171,  3558,  3182,
    3761,  1678,   330,  1043,  2786,  2561,  1060,   140,  1553,  2797,
    2206,  3833,  3834,  1570,  3907,  2809,  1571,  3877,  1322,  2803,
    2205,  1573,  2163,  2189,  1701,  3847,  3787,  2753,  3129,  1048,
    3852,  3853,  2510,   896,  3856,  3857,  3957,  3798,  3799,   403,
    3555,  3271,  3803,  3804,  2787,    71,  4182,  3869,  3870,  3871,
    3872,  3873,  3263,    79,    80,  4372,  4376,  4373,   191,    85,
    2800,  2633,    88,  2722,  2720,   198,  2601,   637,   201,  1746,
    2100,  3113,  1260,  2503,  1864,   403,  2233,  4366,  3907,   105,
    1585,   934,   108,   367,  2209,  1579,  1763,   113,  2249,  1378,
    1137,  3913,   118,  2241,  2769,  2242,  1117,  1117,  3366,  3343,
    3367,  3744,  3845,  1780,  1497,  1583,   400,  2253,  3869,  3870,
    3871,  3872,  3873,  2574,  1956,     2,  3877,   964,  3940,   252,
      -1,  1798,  1308,    -1,    -1,    -1,    -1,  3956,    -1,   493,
     494,   495,   496,   497,   498,    -1,    -1,    -1,    -1,    -1,
      -1,  3845,    -1,    -1,    -1,    -1,  1823,    -1,    -1,    -1,
      -1,  1828,    -1,    -1,    -1,    -1,    -1,    -1,  1603,    -1,
    3903,   489,   490,   491,    -1,   493,   494,   495,   496,   497,
     498,    -1,    -1,   306,    -1,    -1,    -1,    -1,    -1,  2661,
    2662,    -1,    -1,    -1,  2666,    -1,   