/* -*-pgsql-c-*- */
/*
 *
 * $Header: /home/t-ishii/repository/pgpool/pool.h,v 1.4 2003/06/27 08:30:36 t-ishii Exp $
 *
 * pgpool: a language independent connection pool server for PostgreSQL 
 * written by Tatsuo Ishii
 *
 * Copyright (c) 2003	Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of the
 * author not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. The author makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * pool.h.: master definition header file
 *
 */

#ifndef POOL_H
#define POOL_H

#include "config.h"
#include <stdio.h>

/* undef this on FreeBSD */
#define NONE_BLOCK

#define POOLMAXPATHLEN 8192

/* configuration file name */
#define POOL_CONF_FILE_NAME "pgpool.conf"

/* pid file directory */
#define DEFAULT_LOGDIR "/tmp"

/* pid file name */
#define PID_FILE_NAME "pgpool.pid"

typedef enum {
    POOL_CONTINUE,
	POOL_IDLE,
    POOL_END,
    POOL_ERROR,
    POOL_FATAL
} POOL_STATUS;

/*
 * configuration paramters
 */
typedef struct {
    int	inetdomain;	/* should we make an INET domain socket too? */
    int	port;	/* port # to bind */
    char	*backend_host_name;	/* backend host name */
    int	backend_port;	/* backend port # */
    char	*secondary_backend_host_name;	/* secondary backend host name */
    int	secondary_backend_port;	/* secondary backend port # */
    int	num_init_children;	/* # of children initially pre-forked */
    int	child_life_time;	/* if idle for this seconds, child exits */
    int	connection_life_time;	/* if idle for this seconds, connection closes */
    int	max_pool;	/* max # of connection pool per child */
    char *logdir;

	/* followings do not exist in the configuration file */
    char	*current_backend_host_name;	/* current backend host name */
    int	current_backend_port;	/* current backend port # */
} POOL_CONFIG;

/*
 * stream connection structure
 */
typedef struct {
	int fd;
	FILE *read_fd;	/* stream read connection */
	FILE *write_fd;	/* stream write connection */
	char *hp;	/* pending data buffer head address */
	int po;		/* pending data offset */
	int bufsz;	/* pending data buffer size */
	int len;	/* pending data length */
	int isbackend;		/* this connection is for backend if non 0 */
} POOL_CONNECTION;

/*
 * connection pool structure
 */
typedef struct {
    char *user;	/* user name */
    char *database;	/* database name */
    int pid;	/* backend pid */
    int key;	/* cancel key */
    POOL_CONNECTION	*con;
} POOL_CONNECTION_POOL;

/*
 * global variables
 */
extern POOL_CONFIG pool_config;	/* configuration values */
extern POOL_CONNECTION_POOL *pool_connection_pool;	/* connection pool */

/*
 * public functions
 */
extern void pool_error(const char *fmt,...);
extern void pool_debug(const char *fmt,...);
extern int pool_get_config(char *confpath);
extern void do_child(int unix_fd, int inet_fd);
extern int pool_init_cp(void);
extern POOL_STATUS pool_process_query(POOL_CONNECTION *frontend,
				      POOL_CONNECTION *backend,
				      int connection_reuse);

extern POOL_CONNECTION *pool_open(int fd);
extern void pool_close(POOL_CONNECTION *cp);
extern int pool_read(POOL_CONNECTION *cp, void *buf, int len);
extern int pool_write(POOL_CONNECTION *cp, void *buf, int len);
extern int pool_flush(POOL_CONNECTION *cp);
extern int pool_write_and_flush(POOL_CONNECTION *cp, void *buf, int len);
extern char *pool_read_string(POOL_CONNECTION *cp, int *len, int line);

extern POOL_CONNECTION_POOL *pool_get_cp(char *user, char *database);

extern POOL_STATUS pool_do_auth(POOL_CONNECTION *frontend, 
				POOL_CONNECTION_POOL *backend);
extern POOL_STATUS pool_send_auth_ok(POOL_CONNECTION *frontend, int pid, int key);

extern int pool_init_cp(void);
extern POOL_CONNECTION_POOL *pool_create_cp(char *user, char *database);
extern POOL_CONNECTION_POOL *pool_get_cp(char *user, char *database);
extern void pool_discard_cp(char *user, char *database);

extern POOL_STATUS ErrorResponse(POOL_CONNECTION *frontend, 
								  POOL_CONNECTION *backend);

void notice_backend_error(void);

#endif /* POOL_H */
