/* -*-pgsql-c-*- */
/*
 * $Header: /home/t-ishii/repository/pgpool/pool_error.c,v 1.5 2004/07/04 03:12:42 t-ishii Exp $
 *
 * pgpool: a language independent connection pool server for PostgreSQL 
 * written by Tatsuo Ishii
 *
 * Copyright (c) 2003, 2004	Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of the
 * author not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. The author makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * pool_error.c: error and debug messages
 *
 */

#include <stdio.h>
#include <stdarg.h>

#include "pool.h"

extern int debug;

void pool_error(const char *fmt,...)
{
	va_list		ap;

	fprintf(stderr, "ERROR: pid %d: ", getpid());
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
}

void pool_debug(const char *fmt,...)
{
	va_list		ap;

	if (!debug)
		return;

	fprintf(stderr, "DEBUG: pid %d: ", getpid());
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
}

void pool_log(const char *fmt,...)
{
	va_list		ap;

	fprintf(stderr, "LOG: pid %d: ", getpid());
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
}
