/* 
 * PHP3 Internationalization support program.
 *
 * Copyright (c) 1999 by the PHP3 internationalization team.
 * All rights reserved.
 *
 * This program is free software. You can use, redistribute and/or modify
 * without fee under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY including implied or express warranty of
 * marchantability or fitness for a particular purpose.
 *
 * Currently, the "PHP3 internationalization team" has no relationship with
 * the "PHP Development Team". But we hope these code will be integrated
 * into the PHP3, and it will be distributed as a part of PHP3.
 *
 * See README_i18n for more detail.
 *
 * Authors:
 *    Hironori Sato <satoh@jpnnet.com>
 *    Shigeru Kanemoto <sgk@happysize.co.jp>
 */

/*
    FIXME Currently, this code supports only "ja_JP" locale.
*/

#ifndef _PHP3_I18N_H
#define _PHP3_I18N_H

#include <stdio.h>	/* FILE */

/* initialize and cleanup */
extern void i18n_init(void);
extern void i18n_cleanup(void);

/* HTTP output stream */
extern int i18n_http_putc(int c);	/* -1 on error */
extern int i18n_set_output_encoding(const char *name);	/* -1 on error */
extern int i18n_get_output_encoding(void);
extern const char* i18n_get_output_charset(void);	/* pointer to static storage */

/* getc from script file */
extern void* i18n_script_input_new(FILE* in);
extern void i18n_script_input_delete(void* filter);
extern int i18n_script_input_getc(void* filter);
extern int i18n_get_script_encoding(void);

/*
 * Convert POST/GET/COOKIE data. Result will be returned by
 * i18n_http_post_result() in a newly emalloced()'ed memory.
 */
extern int i18n_http_post_putc(int c);
extern int i18n_http_post_puts(const char* s);
extern char* i18n_http_post_result(void);
extern int i18n_http_input_encoding(void);
extern int i18n_http_input_identify_encoding(void);

extern int i18n_get_internal_encoding(void);

/* send an email messeage */
extern void i18n_sendmail(
    FILE *sendmail, const char *to, const char *subject,
    const char *message, const char *header);

#endif		/* _PHP3_I18N_H */
/* vi:set sw=4 ts=4: */
