.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "ALTER TABLE" "l" "2002-03-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TABLE \- change the definition of a table
.SH SYNOPSIS
.sp
.nf
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    ADD [ COLUMN ] \fIcolumn\fR \fItype\fR [ \fIcolumn_constraint\fR [ ... ] ]
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    ALTER [ COLUMN ] \fIcolumn\fR { SET DEFAULT \fIvalue\fR | DROP DEFAULT }
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    ALTER [ COLUMN ] \fIcolumn\fR SET STATISTICS \fIinteger\fR
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    RENAME [ COLUMN ] \fIcolumn\fR TO \fInewcolumn\fR
ALTER TABLE \fItable\fR
    RENAME TO \fInew_table\fR
ALTER TABLE \fItable\fR
    ADD \fItable_constraint_definition\fR
ALTER TABLE [ ONLY ] \fItable\fR 
	DROP CONSTRAINT \fIconstraint\fR { RESTRICT | CASCADE }
ALTER TABLE \fItable\fR
	OWNER TO \fInew_owner\fR 
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable \fB\fR
The name of an existing table to alter.
.TP
\fB\fIcolumn \fB\fR
Name of a new or existing column.
.TP
\fB\fItype \fB\fR
Type of the new column.
.TP
\fB\fInewcolumn \fB\fR
New name for an existing column.
.TP
\fB\fInew_table \fB\fR
New name for the table.
.TP
\fB\fItable_constraint_definition \fB\fR
New table constraint for the table
.TP
\fB\fInew_owner \fB\fR
The user name of the new owner of the table.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER\fR
Message returned from column or table renaming.
.TP
\fBERROR\fR
Message returned if table or column is not available.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER TABLE\fR changes the definition of an existing table.
The ADD COLUMN form adds a new column to the table
using the same syntax as CREATE TABLE [\fBcreate_table\fR(l)].
The ALTER COLUMN SET/DROP DEFAULT forms
allow you to set or remove the default for the column. Note that defaults
only apply to subsequent \fBINSERT\fR commands; they do not
cause rows already in the table to change.
The ALTER COLUMN SET STATISTICS form allows you to
set the statistics-gathering target for subsequent
ANALYZE [\fBanalyze\fR(l)] operations.
The RENAME clause causes the name of a table,
column, index, or sequence to change without changing any of the
data. The data will remain of the same type and size after the
command is executed.
The ADD \fItable_constraint_definition\fR clause 
adds a new constraint to the table using the same syntax as CREATE TABLE [\fBcreate_table\fR(l)]. 
The DROP CONSTRAINT \fIconstraint\fR clause 
drops all constraints on the table (and its children) that match \fIconstraint\fR.
The OWNER clause changes the owner of the table to the user \fI new user\fR.
.PP
You must own the table in order to change its schema.
.SS "NOTES"
.PP
The keyword COLUMN is noise and can be omitted.
.PP
In the current implementation of ADD COLUMN,
default and NOT NULL clauses for the new column are not supported.
You can use the SET DEFAULT form
of \fBALTER TABLE\fR to set the default later.
(You may also want to update the already existing rows to the
new default value, using UPDATE [\fBupdate\fR(l)].)
.PP
In DROP CONSTRAINT, the RESTRICT keyword is required, although
dependencies are not yet checked. The CASCADE option is unsupported. 
Currently DROP CONSTRAINT drops only CHECK constraints.
To remove a PRIMARY or UNIQUE constraint, drop the 
relevant index using the DROP INDEX [\fBdrop_index\fR(l)] command.
To remove FOREIGN KEY constraints you need to recreate
and reload the table, using other parameters to the
CREATE TABLE [\fBcreate_table\fR(l)] command.
.PP
For example, to drop all constraints on a table distributors:
.sp
.nf
CREATE TABLE temp AS SELECT * FROM distributors;
DROP TABLE distributors;
CREATE TABLE distributors AS SELECT * FROM temp;
DROP TABLE temp;
    
.sp
.fi
.PP
You must own the table in order to change it.
Changing any part of the schema of a system
catalog is not permitted.
The \fIPostgreSQL User's Guide\fR has further
information on inheritance.
.PP
Refer to \fBCREATE TABLE\fR for a further description
of valid arguments.
.SH "USAGE"
.PP
To add a column of type \fBvarchar\fR to a table:
.sp
.nf
ALTER TABLE distributors ADD COLUMN address VARCHAR(30);
   
.sp
.fi
.PP
To rename an existing column:
.sp
.nf
ALTER TABLE distributors RENAME COLUMN address TO city;
   
.sp
.fi
.PP
To rename an existing table:
.sp
.nf
ALTER TABLE distributors RENAME TO suppliers;
   
.sp
.fi
.PP
To add a check constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT zipchk CHECK (char_length(zipcode) = 5);
   
.sp
.fi
.PP
To remove a check constraint from a table and all its children:
.sp
.nf
ALTER TABLE distributors DROP CONSTRAINT zipchk RESTRICT;
   
.sp
.fi
.PP
To add a foreign key constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT distfk FOREIGN KEY (address) REFERENCES addresses(address) MATCH FULL;
   
.sp
.fi
.PP
To add a (multicolumn) unique constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT dist_id_zipcode_key UNIQUE (dist_id, zipcode);
   
.sp
.fi
.PP
To add an automatically named primary key constraint to a table, noting
that a table can only ever have one primary key:
.sp
.nf
ALTER TABLE distributors ADD PRIMARY KEY (dist_id);
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The ADD COLUMN form is compliant with the exception that
it does not support defaults and NOT NULL constraints, as explained above.
The ALTER COLUMN form is in full compliance.
.PP
SQL92 specifies some additional capabilities for \fBALTER TABLE\fR
statement which are not yet directly supported by PostgreSQL:
.TP
\fB.sp\fR
Removes a column from a table.
Currently, to remove an existing column the table must be
recreated and reloaded:
.sp
.nf
CREATE TABLE temp AS SELECT did, city FROM distributors;    
DROP TABLE distributors;
CREATE TABLE distributors (
    did      DECIMAL(3)  DEFAULT 1,
    name     VARCHAR(40) NOT NULL
);
INSERT INTO distributors SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
.PP
.PP
The clauses to rename tables, columns, indexes, and sequences are
PostgreSQL extensions from SQL92.
