.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE GROUP" "" "2005-01-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE GROUP \- define a new user group

.SH SYNOPSIS
.sp
.nf
CREATE GROUP \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:

     SYSID \fIgid\fR
   | USER  \fIusername\fR [, ...]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE GROUP\fR will create a new group of users.
You must be a database superuser to use this command.
.PP
Note that both users and groups are defined at the database cluster
level, and so are valid in all databases in the cluster.
.PP
Use ALTER GROUP [\fBalter_group\fR(l)]
to change a group's membership, and DROP GROUP [\fBdrop_group\fR(l)] to remove a group.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the group.
.TP
\fB\fIgid\fB\fR
The SYSID clause can be used to choose
the PostgreSQL group ID of the new
group.
This is normally not necessary, but may
be useful if you need to recreate a group referenced in the
permissions of some object.

If this is not specified, the highest assigned group ID plus one
(with a minimum of 100) will be used as default.
.TP
\fB\fIusername\fB\fR
A list of users to include in the group. The users must already exist.
.SH "EXAMPLES"
.PP
Create an empty group:
.sp
.nf
CREATE GROUP staff;
.sp
.fi
.PP
Create a group with members:
.sp
.nf
CREATE GROUP marketing WITH USER jonathan, david;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBCREATE GROUP\fR statement in the SQL
standard. Roles are similar in concept to groups.
.SH "SEE ALSO"
ALTER GROUP [\fBalter_group\fR(l)], DROP GROUP [\fBdrop_group\fR(l)]
