#!/usr/local/bin/perl
#
# Schedule.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Schedule;

@Schedule::ISA = ('cafPage');

# fName => "sched_id", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "sched_id", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "sched_label", fType => "password", fMand => 1, fMin => 6, dMax => 16 },
	{ fName => "sched_status" },
	{ fName => "object_id" },
	{ fName => "sched_min" },
	{ fName => "sched_hour", fType => "string", fMand => 1, },
	{ fName => "sched_mday", fType => "string", fMand => 1, },
	{ fName => "sched_month", fType => "string", fMand => 1, },
	{ fName => "sched_wday", fType => "string", fMand => 1, },
	{ fName => "sched_mode", fType => "string", fMand => 1, },
	{ fName => "tracefile", fType => "string" },
	{ fName => "errorfile", fType => "string" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "sched_id", "like", $self->{search1} ]; }
	unless ($self->{search2}) { $self->{search2} = "online"; }
	if ($self->{search2}) { $cond->[++$icond] = [ "sched_status", "like", $self->{search2} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("wscheduler", $cond);
	my $rowscount = $self->_hiddenvar("_rowscount");
	my $lastrow = $self->_hiddenvar("_lastrow");
	my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $query = $dbh->newquery({sched_id => $self->{search1}, sched_status => $self->{search2} });
	$query->swschedulerlist2();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	foreach my $sched (@{$self->{_list1}}) {
		$sched->{sched_text} = "$sched->{sched_min} $sched->{sched_hour} $sched->{sched_mday} $sched->{sched_month} $sched->{sched_wday}";
	}
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
	# print "<BR>\nlist1count = $self->{list1count}";
}

sub parse_schedschunk {
	my $self  = shift;
	my $chunk = shift;
	my $text = shift; # Value in Crontab style
	my $add   = shift; #0 or 1
	my $low   = shift;
	my $high  = shift;

	my @ret;
	for ($low..$high) {$ret[$_] = -1};
	my ($vmin, $vmax, $interv);
	my @t;

	if (defined($text) and ($text !~ /^\s*$/)) {
		if ($text eq "*") {
			foreach ($low..$high) {$ret[$_] = 1};
		}
		elsif ($text =~ /(\d+)-(\d+)([\/[:digit:]]*)/) {
			$vmin = $1; $vmax = $2; $interv = $3;
			if ($interv =~ /\/(\d+)/) { $interv = $1 }
			else { $interv = 1; }
			for (my $i = $vmin; $i <= $vmax; $i += $interv) { $ret[$i - $add] = 1; }
		}
		else {
			@t = split(/,/, $text);
			foreach (@t) { if ($_ =~ /^\d+$/) { $ret[$_ - $add] = 1 if (($_ >=$low) and ($_ <= $high)); } }
		}
	}
	else {
		$ret[0] = 1;
		 if ("mday.month.wday" =~ /$chunk/) { foreach ($low..$high) {$ret[$_] = 1} }
	}

	\@ret;
}


sub parse_schedules {
	my $self = shift;
	my $sched = $self->{_data};

	$self->{_data}{scheduled_min}   = $self->parse_schedschunk("min",   $self->{_data}{sched_min}, 0, 0, 59);
	$self->{_data}{scheduled_hour}  = $self->parse_schedschunk("hour",  $self->{_data}{sched_hour}, 0, 0, 23);
	$self->{_data}{scheduled_mday}  = $self->parse_schedschunk("mday",  $self->{_data}{sched_mday}, 1, 0, 30);
	$self->{_data}{scheduled_month} = $self->parse_schedschunk("month", $self->{_data}{sched_month}, 1, 0, 11);
	$self->{_data}{scheduled_wday}  = $self->parse_schedschunk("wday",  $self->{_data}{sched_wday}, 0, 0, 6);

}

sub unparse_schedschunk {
	my $self  = shift;
	my $cgi   = shift;
	my $chunk = shift; #min/hour/mday/month/wday
	my $add   = shift; #0 or 1
	my $low   = shift;
	my $high  = shift;


	my $ret = ""; 
	my $sep = "";
	my $count = 0;
	my $interv = 0;
	my $old_val = 0;
	my $vmin = 0;
	my $vmax = 0;
	$chunk .= "_";
	for my $i ($low..$high) {
		if (my $t = $cgi->param("$chunk$i")) {
			if ($interv > -1) {
				if ($count > 0) {
					if ($count > 1) { if (($i - $old_val) != $interv) { $interv = -1; } else { $old_val = $i; } }
					else { $interv = $i - $old_val; $old_val = $i; }
				}
				else {  $old_val = $i; }
			}
			$vmin = $i unless ($count > 0);				
			$vmax = $i;
			$count++;
			$ret .= "$sep" . ($i + $add);
			$sep=",";
		}
	}
	if (($count - $add) == $high) { $ret = "*"; }
	elsif ($ret =~ /^\s*$/) {
		$ret = "0";
		if ("mday.month.wday" =~ /$chunk/) { $ret = "*"; }
	}
	elsif ($interv > 0) { $ret = "$vmin-$vmax"; $ret .= "/$interv" if ($interv > 1); }

#	print "<BR> $chunk => hign $high count $count vmax $vmax";
	$ret;
}

sub unparse_schedules {
	my $self = shift;
	my $cgi = shift;

	$self->{_data}{sched_min} = $self->unparse_schedschunk($cgi, "min", 0, 0, 59);

	$self->{_data}{sched_hour} = $self->unparse_schedschunk($cgi, "hour", 0, 0, 23);

	$self->{_data}{sched_mday} = $self->unparse_schedschunk($cgi, "mday", 1, 0, 30);

	$self->{_data}{sched_month} = $self->unparse_schedschunk($cgi, "month", 1, 0, 11);

	$self->{_data}{sched_wday} = $self->unparse_schedschunk($cgi, "wday", 0, 0, 6);

#	print "<BR><b><code>SCHEDULE TO TEXT = $self->{_data}{sched_min}_$self->{_data}{sched_hour}_$self->{_data}{sched_mday}_$self->{_data}{sched_month}_$self->{_data}{sched_wday}</code></b>";

}
sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail =~ /^v/) {
		my $meth_name = "meth_$actiondetail";
		if ($self->$meth_name($cgi, $dbh, $conf)) {
			if ($actiondetail eq 'vdrop') {
				$self->_hiddenvar ("_actiondetail", 'search');
				return ($self->meth_search($cgi, $dbh, $conf));
			}
			$actiondetail = $self->_hiddenvar ("_actiondetail", 'edit');
		}
		else { $self->{_system}{noselect} = 1; }
		$actiondetail =~ s/^v//;
		$self->_hiddenvar ("_actiondetail", $actiondetail)
	}
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("sched_id", $cgi->param("_objectid")) unless ($self->_datavar("sched_id")); }
	my $row = {};
	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ sched_id => $self->_datavar("sched_id") });
		$query->swschedulerlist2 ();
		$row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	$self->parse_schedules();
	if ($actiondetail eq 'copy') { $self->_datavar("sched_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("sched_id"));
}

sub meth_vnew {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->unparse_schedules($cgi);
	my $qryparams = $self->_getmyfields();

	if (($qryparams->{sched_id} eq "archiver") or ($qryparams->{sched_id} eq "monitor")) {
		$qryparams->{sched_mode} = "daemon";
		$qryparams->{object_id} = -1;
	}
	$qryparams->{sched_mode} = "once" unless($qryparams->{sched_mode});

	my $query = $dbh->newquery($qryparams);
	$query->iwscheduler();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->unparse_schedules($cgi);
	my $qryparams = $self->_getmyfields();

	if (($qryparams->{sched_id} eq "archiver") or ($qryparams->{sched_id} eq "monitor")) {
		$qryparams->{sched_mode} = "daemon";
		$qryparams->{object_id} = -1;
	}
	$qryparams->{sched_mode} = "once" unless($qryparams->{sched_mode});

	my $query = $dbh->newquery($qryparams);
	$query->uwscheduler();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dwscheduler();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}


1;
