#!/usr/local/bin/perl
#
# cafpLFS 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafpLFS;
 
@ISA = ("cafProto");
use strict;
use File::stat;
use Fcntl ':mode';
use connectors::cafProto;

sub _init {
	my $self = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd;
	if (chdir $self->_dir()) {
		chdir $cwd;
	}
	else {
		die "$class chdir " . $self->_dir() . " : $!";
	}
	$self;
}

sub connected {
	shift;
}

sub getfile {
	my $self = shift;
	my $filedesc = shift;
 
	my $class = ref($self);
 
	unless ($self->connected()) { die "$class openfile : Connection failed"; }
 
	my $fname = $filedesc->{fname};
	my $dir = $filedesc->{dir} || $self->_dir();
	my $mode = $filedesc->{mode};
 
	my ($fh, $ioh, $tempf);
 
	if (($mode eq 'r') || ($mode eq 'w') || ($mode eq 'u')) {
		($fh, $tempf) = $self->gettemporaryfile(".lfs", "fh", 1, "lfs");
		$ioh = IO::Handle->new_from_fd(fileno($fh), "w");
		my $cwd = Cwd::getcwd();
		if ($dir) { chdir ($dir) || die "$class getfile : cwd($dir) Failed"; }
 
		if (($mode eq 'r') || ($mode eq 'u')) {
			my $rioh = IO::File->new($fname, "r") || die "$class unable to open $fname $!";
			binmode $rioh;
			$ioh->autoflush(1);
			my $in;
 
			my $nreads;
			my $nwrite = 0;
			while ($nreads = $rioh->read($in, 1024)) {
			$nwrite = $ioh->write($in, $nreads);
			}
			close $rioh;
		}
		$ioh->close();
		close $fh;
		return ($tempf);
	}
	else { die "$class openfile : unsupported mode ($mode)"; }
}

sub moveexternalfile {
	my $self = shift;
	my $source = shift;
	my $dest = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $ret = rename($source, $dest);
	chdir ($cwd);
#        die "$class unable to move $source $!" unless ((! -f $source) && (-f $dest));
	$ret
}

sub deleteexternalfile {
	my $self = shift;
	my $file = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $ret = unlink($file);
	die "$class unable to delete $file $!" unless (! -f $file);
	chdir ($cwd);
	$ret;
}

sub renameexternalfile {
	my $self = shift;
	my $source = shift;
	my $dest = shift;

	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $ret =  rename($source, $dest);
#	die "$class unable to rename $source $!" unless ((! -f $source) && (-f $dest));
	chdir ($cwd);
	$ret;
}

sub copyexternalfile {
	my $self = shift;
	my $direction = shift;
	my $source = shift;
	my $dest = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $rioh = IO::File->new($source, "r") || die "$class unable to open $source $!";
	binmode $rioh;
	my $wioh = IO::File->new($dest, "w") || die "$class unable to open $dest $!";
	binmode $wioh;
	my ($in, $nreads, $nwrite);
	while ($nreads = $rioh->read($in, 1024)) {
		$nwrite = $wioh->write($in, $nreads);
	}
	$rioh->close ();
	$wioh->close ();
	chdir ($cwd);
	1;
}

sub createexternaldir {
	my $self = shift;
	my $dirname = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $ret =  mkdir($dirname);
	chdir ($cwd);
	die "$class unable to create $dirname $!" unless (-d $dirname);
	$ret;

}

sub removeexternaldir {
	my $self = shift;
	my $dirname = shift;
	my $class = ref($self);

	my $cwd = Cwd::getcwd();
	chdir ($self->_dir());
	my $ret = rmdir($dirname);

	die "$class unable to remove $dirname $!" unless (! -d $dirname);
	$ret;
}

sub fullpath {
        my $self = shift;
        my $dir = shift;
 
	my $cwd = Cwd::getcwd();
	my $wd = $self->_dir();
	chdir $wd;
	if ($dir) { chdir $dir; }
        my $currpath = Cwd::getcwd();
        chdir $cwd;
        $currpath;
}

sub dirlisting {
	my $self = shift;
	my $dir = shift || $self->_dir();

	my $dieerror = undef;
	my $cwd = Cwd::getcwd();
	chdir $dir ? $dir : $cwd;

	my @rows;
	my $i = -1;
	if (opendir(DIRH, ".")) {
		my @files = readdir(DIRH);
		foreach my $file (@files) {
			my $sf = stat ($file);
			my $mode = sprintf("%04o", $sf->mode & 0777);
			my $ftype;
			{
				no strict 'subs';
				if ($sf->mode & S_IFDIR) { $ftype = "DIR"; } else { $ftype = "FILE"; }
			}
			my $usrn;
			eval { $usrn = getpwuid($sf->uid); };
			$! = "";
			$usrn = $sf->uid unless ($usrn);
			my $grpn;
			eval { $grpn = getpwuid($sf->gid); };
			$! = "";
			$grpn = $sf->gid unless ($grpn);
			my $mtime = cafUtils->datetime1($sf->mtime);
			push @rows, [ $mode, $sf->nlink, $usrn, $grpn, $sf->size, $mtime, $file, $ftype, undef, $dir ]; 
		}
	}
	else { eval { cafDbg->pushstackdump(1); }; $dieerror = "20001;" . ref($self) . "::listtable can't open directory $dir"; }
	
	chdir $cwd;
	if ($dieerror) { die $dieerror; }
	if ($#rows > -1) { return (\@rows); }
	return (undef);

}
1;
