#!/usr/local/bin/perl
#
# refDBI 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

#Class standard attributs
#
#SEE cafDBI.pl for => database handle
#
#

use 5.005;
use strict;

package refDBI;
 
use connectors::cafDBI;
use connectors::refQry;

@refDBI::ISA = ('cafDBI');

sub Connect {
	my $class = shift;
	my $db    = shift;

	require Data::Dumper;
#	my $dump = Data::Dumper->new([$db], ["db"]);
#	my $ptext = $dump->Dump;


#	print "\n ==> $ptext <==\n";

	die "No Driver ID supplied" unless ($db->{connector}{driverid});
	die "No Protocol ID supplied" unless ($db->{connector}{protocolid});

	my $drvClass = "cafd$db->{connector}{driverid}";
	my $qryClass = "qry$db->{connector}{driverid}";

	eval "require connectors::$drvClass";

	my $e = $@;
	unless ($@) {
		eval "require connectors::$qryClass";
		$e = $@;
	}
	if ($e) { cafDbg->pushstackdump(1); die $e}

	my $self = $drvClass->NewConnection($db);

	$self->{queryclass} = $qryClass->new();
	$self->{queries} = {};
	$self->{db} = $db;
	return $self;
}

sub ExtConnect {
	my $class = shift;
	my $db    = shift;

	require Data::Dumper;
#	my $dump = Data::Dumper->new([$db], ["db"]);
#	my $ptext = $dump->Dump;


#	print "<BR>\n ==> $ptext <==\n";

	die "No Driver ID supplied" unless ($db->{connector}{driverid});
	die "No Protocol ID supplied" unless ($db->{connector}{protocolid});

	my $drvClass = "cafd$db->{connector}{driverid}";

	eval "require connectors::$drvClass";

	my $e = $@;
	if ($e) { cafDbg->pushstackdump(1); die $e}

	my $self = $drvClass->NewConnection($db);

	$self->{queryclass} = cafQry->new();
	$self->{queries} = {};
	$self->{db} = $db;
	return $self;
}

sub Close {
	my $self = shift;

	if ($self->{queries}) {
		foreach my $k (keys %{$self->{querries}}) { $self->finish($self->{queries}{$k}); }
	}
	delete $self->{queries};

	$self->disconnect();
}

sub OpenSession {
	my $class = shift;
	my $db = shift;
	my $usersess = shift;

	my $self = $class->Connect($db);

	$self->startsession($usersess);
	return $self;
}

sub wwwnew {
	my $class = shift;

	my $db = shift;

	my $drv = shift;

	my $usersess = shift;

	my $drvclass = "caf$drv";
	my $qryclass = "refQ$drv";

	eval "require connectors::$drvclass";
	my $e = $@;
	if ($@) { cafDbg->pushstackdump(1); }
	else {
		eval "require connectors::$qryclass";
		$e = $@;
		if ($@) { cafDbg->pushstackdump(1); }
	
	}
	
	die "$e" if ($e);

	push @refDBI::ISA, $drvclass;

	my $self = refDBI->SUPER::new($db);

	$self->{queryclass} = new $qryclass;

	$self->startsession($usersess);
	return $self;
}

sub qnew {
	my $class = shift;
	my $db = shift;

	my $connector = $db->{connector};

#	print "CONN ", join (" - ", %$db), "\n";
	my $drvclass = "caf$connector->{driverid}";
	my $qryclass = "qQ$connector->{driverid}"; # queries utilities
#	$qryclass = "refQPg";

	eval "require connectors::$drvclass";
	my $e = $@;
	if ($@) { cafDbg->pushstackdump(1); }
	else {
		eval "require connectors::$qryclass";
		$e = $@;
		if ($@) { cafDbg->pushstackdump(1); }
	
	}
	
	die "$e" if ($e);

	push @refDBI::ISA, $drvclass;

	my $self = refDBI->SUPER::new($db);
# refDBI->connect($connector);

	$self->{queryclass} = $qryclass->new();

	bless $self, $class;
}

sub newquery {
	shift->{queryclass}->new(@_);
}

sub newqueryfromhash {
	shift->{queryclass}->newfromhash(@_);
}

sub now {
	my $self = shift;
	my $format = shift || "YYYY/MM/DD HH24:MI:SS";

	my $query = $self->{queryclass}->new({ format => $format });
	$query->snow();
	my $now = $self->execfetchrownop($query, 1);
	if ($now) { return $now->[0]; }
	return undef;
}

sub nextseq {
	my $self = shift;

	my $seqname = shift;

	my $query = $self->{queryclass}->new({ seqname => $seqname });

	$query->snextseq();

	my $nextsessrow = $self->execfetchrow($query, 1);

	return $nextsessrow->[0];
}

sub copyfields {
	my $self = shift;
	my $object_id = shift;
	my $copyobject_id = shift;

	my $query = $self->newquery({ parent_id => $copyobject_id });
	$query->sfieldlist();
	my $fields = $self->hexecfetchall($query);

	my $ret = 1;
	foreach my $field (@$fields) {
		my $newfield_id = $self->nextseq("objects");
		$query = $self->newquery({ parent_id => $object_id, object_id => $newfield_id, copyobject_id => $field->{object_id} });
		$query->iobjectcopy();
		$ret = $self->executefinish($query);

		last unless ($ret > 0);
		$query = $self->newquery({ copyobject_id => $field->{object_id}, object_id => $newfield_id });
		$query->ifieldcopy();
		$ret = $self->executefinish($query);

		last unless ($ret > 0);
	}

	return $ret;
}

sub getsubflow {
	my $self = shift;
	my $flowid = shift;
	my $direction = shift;
	my $sflowid = shift;

	my $query = $self->newquery({ parent_id => $flowid, flowdirection => $direction, object_id => $sflowid });

	$query->ssubflowlist();
	$self->hexecfetchall($query);
}

sub updatemyevents {
	my $self = shift;
	my $objectid = shift;
	my $events = shift;

	my $ret;
	my $query = $self->newquery({ object_id => $objectid });
	$query->devents();
	$ret = $self->executefinish($query);
	return undef unless ($ret);
	
	foreach my $event (@$events) {
		if ($event->{object_id_source} != $objectid) {
			$query = $self->newquery($event);
			$query->ievents();
			$ret = $self->executefinish($query);
			return undef unless ($ret > 0);
		}
	}
	return 1;
}

sub updatemyobjects {
	my $self = shift;
	my $objectid = shift;
	my $objects = shift;

	my $ret;
	my $query = $self->newquery({ parent_id => $objectid });
	$query->dotherobject();
	$ret = $self->executefinish($query);
	return undef unless ($ret);
	
	foreach my $obj (@$objects) {
		$query = $self->newquery($obj);
		$query->iotherobject();
		$ret = $self->executefinish($query);
		return undef unless ($ret > 0);
	}
	return 1;
}
		
sub updatemyscripts {
	my $self = shift;
	my $objectid = shift;
	my $scripts = shift;

	my $ret;
	my $query = $self->newquery({ object_id => $objectid });
	$query->dscriptobject();
	$ret = $self->executefinish($query);
	return undef unless ($ret);
	
	foreach my $scr (@$scripts) {
		$query = $self->newquery($scr);
		$query->iscriptobject();
		$ret = $self->executefinish($query);
		return undef unless ($ret > 0);
	}
	return 1;
}
		
sub updatemymapping {
	my $self = shift;
	my $objectid = shift;
	my $mapping = shift;

	my $ret;
	my $query = $self->newquery({ subflow_id => $objectid });
	$query->dmapping();
	$ret = $self->executefinish($query);
	return undef unless ($ret);
	
	foreach my $map (@$mapping) {
		$query = $self->newquery($map);
		$query->imapping();
		$ret = $self->executefinish($query);
		return undef unless ($ret > 0);
	}
	return 1;
}
		
sub updatemysubflows {
	my $self = shift;
	my $subflows = shift;

	my $ret;
	foreach my $dir (('incom', 'outgo')) {
		foreach my $flow (@{$subflows->{$dir}}) {
			my $query;
			if ($flow->{object_id}) {
				$query = $self->newquery($flow);
				$query->uobject();
				if (($ret = $self->executefinish($query)) > 0) {
					$query->usubflow();
					$ret = $self->executefinish($query);
				}
				return undef unless ($ret > 0);
			}
			else {
				$flow->{object_id} = $self->nextseq("objects");
				$query = $self->newquery($flow);
				$query->iobject();
				if (($ret = $self->executefinish($query)) > 0) {
					$query->isubflow();
					$ret = $self->executefinish($query);
				}
				return undef unless ($ret > 0);
			}
		}
	}
	return 1;
}


sub getmyattributes {
	my $self = shift;
	my $attrdef = shift;
	my %attrdef1 = %{$attrdef};
	my %attrdef2 = %{$attrdef};

	my $query1 = $self->newquery(\%attrdef1);
	my $query2 = $self->newquery(\%attrdef2);

	$query1->sgetmyattributes();
	my $attrvalues = $self->hexecfetchall($query1);

	$query2->sattrdeflistprotdriv();
	my $attrdefs = $self->hexecfetchall($query2);

	return undef unless ($#{$attrdefs} >= 0);
#	my $i = 0;
#	L1 : while (ref($attrvalues->[$i])) {
#		my $attrval = $attrvalues->[$i];
#		my $j = 0;
#		L2 : while ($attrdefs->[$j]) {
#			my $attrdef = $attrdefs->[$j];
#			if ($attrdef->{attrdefid} eq $attrval->{attrdefid}) {
#				$attrdef->{attrvalue} = $attrval->{attrvalue};
#				last L2;
#			}
#			$j++;
#		}
#		$i++;
#	}
			
	foreach my $attrval (@{$attrvalues}) {
		foreach my $attrdef (@{$attrdefs}) {
			if ($attrdef->{attrdefid} eq $attrval->{attrdefid}) {
				$attrdef->{attrvalue} = $attrval->{attrvalue};
				last;
			}
		}
	}
	foreach my $attrdef (@{$attrdefs}) {
		if ($attrdef->{attrdefault} eq '--nodefault--') {
			$attrdef->{attrdefault} = undef;
		}
		if ($attrdef->{datatype} eq 'list') {
			my @defaults = split (/;/, $attrdef->{attrdefault});
			$attrdef->{attrdefault} = shift @defaults;
			$attrdef->{defaultlist} = \@defaults;
		}
		$attrdef->{attrvalue} = $attrdef->{attrdefault} unless ($attrdef->{attrvalue});
	}
	$attrdefs;
}

sub updateattributes {
	my $self = shift;
	my $object_id = shift;
	my $attrvalues = shift;

	my $query = $self->newquery({ object_id => $object_id });
	$query->dattributes();
	my $ret = $self->executefinish($query);
	return undef unless ($ret >=0);
	foreach my $attrdefid (keys %{$attrvalues}) {
#		my $query = $self->newquery({ object_id => $object_id, attrdefid => $attrdefid, attrvalue => $attrvalues->{$attrdefid} });
#		$query->uattributes();

#		my $ret = $self->executefinish($query);
#		if ($ret == 0) { $query->iattributes(); $self->executefinish($query); }

		$query = $self->newquery({ object_id => $object_id, attrdefid => $attrdefid, attrvalue => $attrvalues->{$attrdefid} });
		$query->iattributes();
		$ret = $self->executefinish($query);
		last unless ($ret > 0);
	}
	$ret;
}

sub updateenvvars {
	my $self = shift;
	my $object_id = shift;
	my $varvalues = shift;

	my $query = $self->newquery({ object_id => $object_id });
	$query->denvvars();
	my $ret = $self->executefinish($query);
	return undef unless ($ret >=0);
	foreach my $var (@$varvalues) {
		$var->{object_id} = $object_id;
		$query = $self->newquery($var);
		$query->ienvvars();
		$ret = $self->executefinish($query);
		last unless ($ret > 0);
	}
	$ret;
}

# Deploy objects subs 

sub getscripthierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $script;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query);
	}
	unless ($script = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "scripts" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$script = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);

		$query = $self->newquery( { tablename => "pscripts" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		my $parsedtext = $self->hexecfetchrownop($query, 1);
		$ret->{$objid}{data}{parsetext} = $parsedtext->{parsetext};
	}

}#getscripthierarchy

sub getuserhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $user;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query, 1);
	}
	unless ($user = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "users" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$user = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

}#getuserhierarchy

sub getserverhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $server;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query, 1);
	}
	unless ($server = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "server" });
		$query->stablerow([ [ "object_id", "in", [$objid] ] ]);
		$server = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

}#getserverhierarchy

sub getfieldhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $field;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query);
	}
	unless ($field = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "field" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$field = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

}#getfieldhierarchy


sub getconnectorhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $connector;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query, 1);
	}
	unless ($connector = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "connector" });
		$query->stablerow([ [ "object_id", "in", [$objid] ] ]);
		$connector = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

# Search for the slave connector designed for this context
	if ($contextid and ($connector->{ismaster} eq 'master')) {
		my $connector2;
		my $object2;
		$query = $self->newquery( { tablename => "connector" });
		$query->stablerow([ [ "master_id", "in", [$objid] ], [ "contextid", "in", ["'$contextid'"] ], [ "ismaster", "=", "slave" ] ]);
		$connector2 = $self->hexecfetchrownop($query, 1);
		if ($connector2) {
			$query = $self->newquery({ id => $connector2->{object_id} });
			$query->sobjectlist();
			$object2 = $self->hexecfetchrownop($query);

			$connector2->{object_id} = $objid;
			$connector2->{id} = $objid;
			$connector2->{master_id} = undef;
			$connector2->{ismaster} = 'master';
			$object2->{id} = $objid;

			$connector = $connector2;
			$object = $object2;
			$ret->{$objid}{object} = $object;
			$ret->{$objid}{data} = $connector;
		}
	}

	# my $serverid = 
		
	$query = $self->newquery({ object_id => $object->{parent_id} });
	$query->sobjectlist();
	my $server = $self->hexecfetchrownop($query);
	
	if ($server->{type} eq "server") {
		unless ($ret->{$server->{id}}{object} and $ret->{$server->{id}}{data}) {
			$ret->{$server->{id}}{object} = $server unless($ret->{$server->{id}}{object});
			$self->getserverhierarchy($ret, $server->{id}, $contextid);
		}
#		$ret->{$objid}{data}{server} = $ret->{$server->{id}}{data};
	}

#	my $userid =
	$query = $self->newquery({ object_id => $connector->{userid} });
	$query->sobjectlist();
	my $users = $self->hexecfetchrownop($query);
	
	if ($users->{type} eq "users") {
		unless ($ret->{$users->{id}}{object} and $ret->{$users->{id}}{data}) {
			$ret->{$users->{id}}{object} = $users unless($ret->{$users->{id}}{object});
			$self->getuserhierarchy($ret, $users->{id}, $contextid);
		}
#		$ret->{$objid}{data}{_userid} = $ret->{$users->{id}}{data};
	}

	my $attrdef;
	$attrdef->{object_id} = $objid;
	$attrdef->{objtype} = "connector";
	$attrdef->{protocolid} = $connector->{protocolid};
	$attrdef->{driverid} = $connector->{driverid};

	$ret->{$objid}{attr} = $self->getmyattributes($attrdef);
	$ret->{ATTRIBUTES}{$objid} = $self->getmyattributes($attrdef);

	$query = $self->newquery({object_id => $objid});
	$query->sgetmyenvvars();
	$ret->{$objid}{vars} = $self->hexecfetchall($query);
	$ret->{VARS}{$objid} = $self->hexecfetchall($query);


}#getconnectorhierarchy

sub getcontainerhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $container;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query);
	}
	unless ($container = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "container" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$container = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

	$query = $self->newquery({ object_id => $object->{parent_id} });
	$query->sobjectlist();
	my $connector = $self->hexecfetchrownop($query);
	
	if ($connector->{type} eq "connector") {
		unless ($ret->{$connector->{id}}{object} and $ret->{$connector->{id}}{data}) {
			$ret->{$connector->{id}}{object} = $connector unless($ret->{$connector->{id}}{object});
			$self->getconnectorhierarchy($ret, $connector->{id}, $contextid);
		}
	}


	$query = $self->newquery({ parent_id => $objid });
	$query->sobjectlist();
	my $fields = $self->hexecfetchall($query);
	
	foreach my $field (@$fields) {
		if ($field->{type} eq "field") {
			unless ($ret->{$field->{id}}{object} and $ret->{$field->{id}}{data}) {
				$ret->{$field->{id}}{object} = $field unless($ret->{$field->{id}}{object});
				$self->getfieldhierarchy($ret, $field->{id}, $contextid);
			}
		}
	}

	my $attrdef;
	$attrdef->{object_id} = $objid;
	$attrdef->{objtype} = "container";
	$attrdef->{protocolid} = $connector->{protocolid};
	$attrdef->{driverid} = $connector->{driverid};

	$ret->{$objid}{attr} = $self->getmyattributes($attrdef);
	$ret->{ATTRIBUTES}{$objid} = $self->getmyattributes($attrdef);

}#getcontainerhierarchy

sub getsubflowhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	my $object;
	my $subflow;
	unless ($object = $ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$object = $ret->{$objid}{object} = $self->hexecfetchrownop($query);
	}
	unless ($subflow = $ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "subflow" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$subflow = $ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

	$query = $self->newquery({ object_id => $subflow->{container_id} });
	$query->sobjectlist();
	my $container = $self->hexecfetchrownop($query);

	if ($container->{type} eq "container") {
		unless ($ret->{$container->{id}}{object} and $ret->{$container->{id}}{data}) {
			$ret->{$container->{id}}{object} = $container unless ($ret->{$container->{id}}{object});
			$self->getcontainerhierarchy($ret, $container->{id}, $contextid);
		}
	}

   $query = $self->newquery({ subflow_id => $objid });
   $query->smappinglist();
   my $mapping = $self->hexecfetchall($query) || [];

	$ret->{MAPPING}{$objid} = $mapping;
	$ret->{$objid}{mapping} = $mapping;

	$query = $self->newquery({object_id => $objid});
	$query->sscriptobject();
	my $scripts = $self->hexecfetchall($query) || [];

	foreach my $map (@$mapping) { if ($map->{script_id}) { push @$scripts, $map; } }

	foreach my $script (@$scripts) {
		unless ($ret->{$script}{object} and $ret->{$script}{data}) {
			$self->getscripthierarchy($ret, $script->{script_id}, $contextid);
		}
	}

	my $attrdef;
	$attrdef->{object_id} = $objid;
	$attrdef->{objtype} = "subflow";
	$attrdef->{protocolid} = undef;
	$attrdef->{driverid} = undef;

	$ret->{$objid}{attr} = $self->getmyattributes($attrdef);
	$ret->{ATTRIBUTES}{$objid} = $self->getmyattributes($attrdef);

	$query = $self->newquery({object_id => $objid});
	$query->sgetmyenvvars();
	$ret->{$objid}{vars} = $self->hexecfetchall($query);
	$ret->{VARS}{$objid} = $self->hexecfetchall($query);

	$query = $self->newquery({ object_id => $objid });
	$query->seventslist();
	$ret->{EVENTS}{$objid} = $self->hexecfetchall($query);
	$ret->{$objid}{events} = $ret->{EVENTS}{$objid};
}

sub getflowhierarchy {
	my $self = shift;
	my $ret = shift;
	my $objid = shift;
	my $contextid = shift;

	my $query;
	unless ($ret->{$objid}{object}) {
		$query = $self->newquery({id => $objid});
		$query->sobjectlist();
		$ret->{$objid}{object} = $self->hexecfetchrownop($query);
	}
	unless ($ret->{$objid}{data}) {
		$query = $self->newquery( { tablename => "flow" });
		$query->stablerow([ [ "object_id", "=", $objid ] ]);
		$ret->{$objid}{data} = $self->hexecfetchrownop($query, 1);
	}

	$query = $self->newquery({parent_id => $objid});
	$query->sobjectlist();
	my $subflows = $self->hexecfetchall($query);

	foreach my $subflow (@$subflows) {
		if ($subflow->{type} eq "subflow") {
			unless ($ret->{$subflow->{id}}{object} and $ret->{$subflow->{id}}{data}) {
				$ret->{$subflow->{id}}{object} = $subflow unless ($ret->{$subflow->{id}}{object});
				$self->getsubflowhierarchy($ret, $subflow->{id}, $contextid);
			}
		}
	}

	$query = $self->newquery({object_id => $objid});
	$query->sscriptobject();
	my $scripts = $self->hexecfetchall($query);

	foreach my $script (@$scripts) {
		unless ($ret->{$script->{id}}{object} and $ret->{$script->{id}}{data}) {
			$ret->{$script->{id}}{object} = $script unless ($ret->{$script->{id}}{object});
			$self->getscripthierarchy($ret, $script->{id}, $contextid);
		}
	}

	my $attrdef;
	$attrdef->{object_id} = $objid;
	$attrdef->{objtype} = "flow";
	$attrdef->{protocolid} = undef;
	$attrdef->{driverid} = undef;

	$ret->{ATTRIBUTES}{$objid} = $self->getmyattributes($attrdef);
	$ret->{$objid}{attr} = $ret->{ATTRIBUTES}{$objid};

	$query = $self->newquery({object_id => $objid});
	$query->sgetmyenvvars();
	$ret->{VARS}{$objid} = $self->hexecfetchall($query);
	$ret->{$objid}{vars} = $ret->{VARS}{$objid};

	$query = $self->newquery({ object_id => $objid });
	$query->seventslist();
	$ret->{EVENTS}{$objid} = $self->hexecfetchall($query);
	$ret->{$objid}{events} = $ret->{EVENTS}{$objid};
}

sub gethierarchy {
	my $self = shift;
	my $objid = shift;
	my $contextid = shift;

	my $ret;
	my $query = $self->newquery({id => $objid});
	$query->sobjectlist();
	my $objects = $self->hexecfetchall($query);
	

	foreach my $obj (@$objects) {
		$ret->{$obj->{id}}{object} = $obj unless ($ret->{$obj->{id}}{object});
		if ($obj->{type} eq "flow") { $self->getflowhierarchy($ret, $obj->{id}, $contextid); }
		elsif ($obj->{type} eq "subflow") { $self->getsubflowhierarchy($ret, $obj->{id}, $contextid); }
		elsif ($obj->{type} eq "connector") { $self->getconnectorhierarchy($ret, $obj->{id}, undef); }
	}
	my @objids;
	foreach my $objid (keys %$ret) {
		if ($objid !~ /[[:alpha:]]/) { push @objids, $objid; }
	}

	$query = $self->newquery({object_id => \@objids});
	$query->sdeployeduptodate();
	my $uptodate = $self->hexecfetchall($query);
	$ret->{OBJIDS} = \@objids;
	$ret->{UPTODATE} = $uptodate;
	$ret;
}
# END Deploy objects subs

sub dropsubflow {
	my $self = shift;
	my $subflowid = shift;

}

sub dropcontainer {
	my $self = shift;
	my $containerid = shift;

}

sub dropconnector {
	my $self = shift;
	my $connectorid = shift;
}

sub dropscript {
	my $self = shift;
	my $scriptid = shift;
}

sub tablerowscount {
	my $self = shift;
	my $tablename = shift;
	my $cond = shift;
	my $isobject = shift;

	my $query = $self->{queryclass}->new({ tablename => $tablename });

	if ($isobject) { $query->sobjectrowscount($cond); }
	else { $query->stablerowscount($cond); }

	my $rowscount = $self->execfetchrow($query, 1);

	return $rowscount->[0];
}

sub getcolsvalues {
	my $self = shift;
	my $query = shift;
	my $attr  = shift || "sessionvars";

	my $cols = $query->columns();
	my $row = $query->_row();

	my $colsn = $#{$cols};

	for (my $i = 0; $i <= $colsn; $i++) { $self->{$attr}{$cols->[$i]} = $row->[$i]; }
}

sub authenticate {
	my $self = shift;
	my $pusersess = shift;

	return undef unless ($pusersess->{userid});

	my $query = $self->{queryclass}->new({ userid => $pusersess->{userid}, userpass => $pusersess->{userpass} });

	$query->suserauth();

	my $userauth = $self->hexecfetchrow($query, 1);

	unless ($userauth and ($userauth->{userid} eq $pusersess->{userid})) {
		cafDbg->pushstackdump(1);
		die "Invalid user $pusersess->{userid}";
	}
	if (my $ip = $pusersess->{ipaddress}) {
		my @hostPattern = split(/[,;]/, $userauth->{hostsdeny});
		foreach my $pat (@hostPattern) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
			if ($ip =~ /^$pat$/) { die "Access denied for user $pusersess->{userid} from $pusersess->{ipaddress}."; }
		}
		@hostPattern = split(/[,;]/, $userauth->{hostsallow} || '*');
		foreach my $pat (@hostPattern) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
			if ($ip =~ /^$pat$/) { return $self; }
		}
		die "Access denied for user $pusersess->{userid} from $pusersess->{ipaddress}";
	}
#	$self->getcolsvalues($query);

	$self;
}

sub rtnewsession {
	my $self = shift;
	my $pusersess = shift;

	return undef unless ($self->authenticate($pusersess));
	my %usersess = %{$pusersess};

	my $sessionseq = $self->nextseq('sessions');

	$usersess{ sessionseq } = $sessionseq;

	my $query = $self->{queryclass}->new(\%usersess);

	$query->iusersess();

	my $oldAutoC = $self->autocommit();
	$self->autocommit(1);
	my $result = $self->executefinish($query);
	$self->autocommit($oldAutoC);

	if ($result) {
		return ($query->attribute("sessionid"));
	}
	else { return undef; }
}

sub newsession {
	my $self = shift;
	my $pusersess = shift;

	return undef unless ($self->authenticate($pusersess));
	my %usersess = %{$pusersess};

	my $sessionseq = $self->nextseq('sessions');

	$usersess{ sessionseq } = $sessionseq;

	my $query = $self->{queryclass}->new(\%usersess);

	$query->iusersess();

	my $oldAutoC = $self->autocommit();
	$self->autocommit(1);
	my $result = $self->executefinish($query);
	$self->autocommit($oldAutoC);

	if ($result) {
		$self->{sessionvars}->{sessionid} = $query->attribute("sessionid");
		$pusersess->{sessionid} = $query->attribute("sessionid");
		$self->{sessionvars}->{sessionseq} = $sessionseq;
	}

	return undef unless ($result);
	return $result;
}


# create a new session for the specified user or reuse the previous on if exists $usersess->{sessionid};
sub startsession {
	my $self = shift;
	my $pusersess = shift;

	if ($pusersess->{sessionid}) {
		my $query = $self->{queryclass}->new({ sessionid => $pusersess->{sessionid} });
		$query->uusersess();
		my $oldAutoC = $self->autocommit();
		$self->autocommit(1);
		$self->executefinish($query);
		$self->autocommit($oldAutoC);
	}
	else { return undef unless ($self->newsession($pusersess)); }

	my $query = $self->{queryclass}->new({ sessionid => $pusersess->{sessionid} });

	$query->susersess();

	my $usersessrow = $self->execfetchrow($query, 1);

	return undef unless ($usersessrow && $usersessrow->[0]);

	$self->getcolsvalues($query);

	return 1;
}

sub errstr {
	return DBI->errstr;
}

sub err {
	return DBI->err;
}

sub userlabel {
	return shift->{sessionvars}{userlabel};
}

sub connecttime {
	return shift->{sessionvars}{connecttime};
}

sub lastactiontime {
	return shift->{sessionvars}{lastaccess};
}

sub userid {
	return shift->{sessionvars}{userid};
}

sub sessionid {
	my $self = shift;
#	foreach my $k (keys %{$self->{sessionvars}}) {
#		print "$k -> \n"; # , $self->{sessionvars}{$k}, "\n";
#	}
	return $self->{sessionvars}{sessionid};
}

1;
