#!/usr/local/bin/perl
#
# Scripts.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Scripts;

@Scripts::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "parent_id" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },
	{ fName => "object_id" },
	{ fName => "objectlabel" },
	{ fName => "scripttype", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "scripttext" },
	{ fName => "parsed" },
	{ fName => "parsetext" },
	{ fName => "currentuser" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "objects.objectlabel" ], "like", $self->{search1} ];
#		$cond->[++$icond] = [ "scripts.username", "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("scripts", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search2} });
	$query->sscriptslist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
#	$self->_datavar("type", 'scripts');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $self->_datavar("object_id") });
		$query->sscriptslist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $self->{_data}{$field} = $row->{$field}; }
		if ($self->_datavar("type") eq "sql") {
			$query->spscriptslist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->_datavar("_parsedtext", $row->{parsetext});
		}
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_generate {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
#	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	my $actiondetail = $self->_hiddenvar ("_actiondetail", "edit");
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	$self->_getcheckfields ($cgi, $editfields);
#	$self->_datavar("type", 'scripts');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	my $script_id = $self->_hiddenvar("__param__0");
	my $scripttype = $self->_hiddenvar("__param__1");
	my $scriptlang = $self->_hiddenvar("__param__2");
	my $relatedObject = $self->_hiddenvar("__param__3");
	my $scripttext;

	if (! $script_id) {
		$actiondetail = $self->_hiddenvar ("_actiondetail", "new");
		my $query = $dbh->newquery({ object_id => $relatedObject });
		$query->sobjectlist();
		my $object = $dbh->hexecfetchrownop($query, 1);

		if ($relatedObject && ($scriptlang eq 'sql')) {
			my $container;
			my $connector;
			my $datatypes;
			my $fields;
			$query = $dbh->newquery({ object_id => $relatedObject });
			if ($object->{type} eq 'container') {
				$query->scontainerlist();
			}
			elsif ($object->{type} eq 'subflow') {
				$query->ssubflowcontainer();
			}
			$container = $dbh->hexecfetchrownop($query, 1);

			$query = $dbh->newquery({ object_id => $container->{parent_id} });
			$query->sconnectorlist();
			$connector = $dbh->hexecfetchrownop($query, 1);

			$query = $dbh->newquery({ driverid => $container->{driverid} });
			$query->sdatatypelist();
			my $datatypes = $dbh->hexecfetchall($query, 1);

			$query = $dbh->newquery({ parent_id => $container->{object_id} });
			$query->sfieldlist();
			$fields = $dbh->hexecfetchall($query, 1);
			
			my $driver = $connector->{driverid};
			my $drvclass = "cafd$driver";
			eval "require connectors::$drvclass";

			if ($@) { die "unable to load $drvclass $@"; }

			$scripttext = $drvclass->generatequery($scripttype, $connector, $container, $fields, $datatypes, $self->{_translate});
		}
		elsif ($scriptlang eq 'perl') {
			$scripttext = cafUtils->generateperl($scripttype, $object, $self->{_translate});
		}
		else {
			$scripttext = "";
		}
		$self->_datavar("object_id", undef);
		$self->_datavar("scripttext", $scripttext);
		$self->_datavar("scripttype", $scripttype);
		$self->_datavar("type", "$scriptlang");
		$self->_datavar("comments", "Generated by " . ref($self) . " on " . cafUtils->datetime1());
	}
	else {
		my $query = $dbh->newquery({ object_id => $script_id });
		$query->sscriptslist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
		if ($self->_datavar("type") eq "sql") {
			$query->spscriptslist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->_datavar("_parsedtext", $row->{parsetext});
		}
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	my $parsedscript;
	my $parsed;
	my $ptext;


	if ($cgi->param("type") eq 'sql') {
		require Data::Dumper;
		my $parsedscript = cafUtils->parsesql ($self->_datavar("scripttext"));

		my $dump = Data::Dumper->new([$parsedscript], ["parsedtext"]);
		$dump->Indent(1);
		$ptext = $dump->Dump;

		if ($parsedscript->{nerrors} > 0) { $parsed = "invalid"; }
		else { $parsed = "valid"; }
	}
	else { $parsed = "valid"; }
	

	eval {
	$self->_datavar("object_id", $dbh->nextseq("objects"));
	};

	if ($@) { cafDbg->pushstackdump(1); cagDbg->pusherror("999999;" . $@); return undef}
	$self->_datavar("parsed", $parsed);
	$self->_datavar("parsetext", $ptext);
	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	my $ret;
	if ($ret = $dbh->executefinish($query)) {
		$query->iscripts();
		if($ret = $dbh->executefinish($query) > 0) {
			if ($cgi->param("type") eq 'sql') {
				$query->ipscripts();
				$ret = $dbh->executefinish($query);
			}
		}
	}
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	my $parsedscript;
	my $parsed;
	my $ptext;


	if ($cgi->param("type") eq 'sql') {
		require Data::Dumper;
		$parsedscript = cafUtils->parsesql ($self->_datavar("scripttext"));

		my $dump = Data::Dumper->new([$parsedscript], ["parsedtext"]);
		$dump->Indent(1);
		$ptext = $dump->Dump;

		if ($parsedscript->{nerrors} > 0) { $parsed = "invalid"; }
		else { $parsed = "valid"; }
		#my $p = $ptext; $p =~ s/\n/<BR>/g; $self->_systemvar("_INFO", $p);
	}
	else { $parsed = "valid"; }
	
	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));

	
	$self->_datavar("parsed", $parsed);
	$self->_datavar("parsetext", $ptext);
#	if ($parsed eq 'invalid') { $self->_systemvar("_INFO", $ptext); }
	my $query = $dbh->newquery($self->_getmyfields());
	$query->uobject();
	my $ret;
	
	if ($ret = $dbh->executefinish($query) > 0) {
		$query->uscripts();
		if(($ret = $dbh->executefinish($query) > 0) and ($cgi->param("type") eq 'sql')) {
			$query->upscripts();
			$ret = $dbh->executefinish($query);
		}
	}
#	print "SAVED WITH red = $ret<BR>";
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return $ret;
#	$query->uscripts();

#	my $ret = $dbh->executefinish($query);
#	$dbh->commit();
#	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	$query->dscripts();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
