#!/usr/local/bin/perl
#
# cafLDAP 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdLDAP;
 
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdLDAP::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
=cut
hostname[;port][:[root-dn][:[loginrule]]]
tablename1:[basedn]:[basefilter]:dnattrs:[visableattrs]:[insertattrs]:[ldap_options]
tablename2:[basedn]:[basefilter]:dnattrs:[visableattrs]:[insertattrs]:[ldap_options]

EXAMPLE
ldapserver:dc=Acme, dc=com:cn=*,<ROOT>
top:::dc
WidgetDivision:ou=Widgets, :&(objectclass=top)(objectclass=person):cn:cn,sn,ou,title,telephonenumber,description,objectclass,dn:objectclass=top|person|organizationalPerson:ldap_outseparator => ":"
	my %ldapd_attrs = (
		root_dn            => $db->{_ATTRS}{ROOT_DN},
		login_rule         => $db->{_ATTRS}{LOGIN_RULE},
		base_dn            => $db->{_ATTRS}{BASE_DN},
		base_filter        => $db->{_ATTRS}{BASE_FILTER},
		dn_attrs           => $db->{_ATTRS}{DN_ATTRS},
		#visableattrs      => $db->{table}{columns};
		insert_attrs       => $db->{_ATTRS}{INSERT_ATTRS},
		#LDAP OTIONS
		ldap_sizelimit     => $db->{_ATTRS}{LDAP_SIZELIMIT},
		ldap_timelimit     => $db->{_ATTRS}{LDAP_TIMELIMIT},
		ldap_scope         => $db->{_ATTRS}{LDAP_SCOPE},
		ldap_inseparator   => $db->{_ATTRS}{LDAP_INSEPARATOR},
		ldap_outseparator  => $db->{_ATTRS}{LDAP_OUTSEPARATOR},
		ldap_firstonly     => $db->{_ATTRS}{LDAP_FIRSTONLY},
	);
	foreach my $a (keys %ldapd_attrs) {
		if (($ldapd_attrs{$a} !~ /^\\$/) and defined($ldapd_attrs{$a})) { eval "\$ldapd_attrs{$a} = \"$ldapd_attrs{$a}\""; }
	}
	$self->{_LDAP_ATTRS} = \%ldapd_attrs;
=cut
	
	$self->{dbh}       = DBI->connect("dbi:LDAP:" . $db->{name}, $db->{user}{username}, $db->{user}{password});

	my $ldapHome = $db->{_ATTRS}{LDAP_HOME} || $ENV{LDAP_HOME};

	die "ERROR : no ldaphome" unless ($ldapHome && -d $ldapHome);

	$self;
}


sub BuildOneLDBFile {
	my $self = shift;
	my $objHier = shift;
	my $cid = shift;
	my $ldapHome = shift;
	my @contids = @_;

	print "$objHier\n";
	my $connector = $objHier->getobject($cid) || die "ERROR : no connector";
	my $server = $objHier->getobject($connector->{parent_id}) || die "ERROR : no server";
        my $attrList = $objHier->attributelist($cid) || [];
	my %attrHash = map { $_->{attrdefid} => $_->{attrvalue} } @$attrList;


	my $ldapFile = "$ldapHome/$connector->{externalname}.ldb";
	open O, "> $ldapFile" || die "ERROR : can't create ldapfile $ldapFile";
	print "> $ldapFile" || die "ERROR : can't create ldapfile $ldapFile";

#	print O "$connector->{externalname}:$attrHash{LDAP_ROOTDN}:$attrHash{LDAP_LOGINRULE}\n";
	my $host = $server->{host_name} || $server->{host_address} || die "ERROR : invalid server address";
	print O "$host:$attrHash{LDAP_ROOTDN}:$attrHash{LDAP_LOGINRULE}\n";

	foreach my $contid (@contids) {
		my $container = $objHier->getobject($contid) || die "ERROR : no container";
        	$attrList = $objHier->attributelist($contid) || [];
		%attrHash = map { $_->{attrdefid} => $_->{attrvalue} } @$attrList;

		my $fields = $objHier->myfields($contid) || [];
		print O "$container->{externalname}:$attrHash{LDAP_BASEDN}:$attrHash{LDAP_BASEFILTER}:$attrHash{LDAP_DNATTRS}:";

		my $sep="";
		foreach my $f (@{$fields}) {
			print O "$sep$f->{externalname}";
			$sep = ",";
		}
		print O ":$attrHash{LDAP_INSERTATTRS}:";
		$sep = "";
		if ($attrHash{LDAP_INSEPARATOR}) {
			print O "ldap_inseparator => \"$attrHash{LDAP_INSEPARATOR}\"";
			$sep = ",";
		}
		if ($attrHash{LDAP_OUTSEPARATOR}) {
			print O $sep . "ldap_outseparator => \"$attrHash{LDAP_OUTSEPARATOR}\"";
			$sep = ",";
		}
		if ($attrHash{LDAP_FIRSTONLY}) {
			print O $sep . "ldap_firstonly => \"$attrHash{LDAP_FIRSTONLY}\"";
			$sep = ",";
		}
		if ($attrHash{LDAP_SCOPE}) {
			print O $sep . "ldap_scope => \"$attrHash{LDAP_SCOPE}\"";
			$sep = ",";
		}
		if ($attrHash{LDAP_SIZELIMIT}) {
			print O $sep . "ldap_sizelimit => \"$attrHash{LDAP_SIZELIMIT}\"";
			$sep = ",";
		}
		if ($attrHash{LDAP_TIMELIMIT}) {
			print O $sep . "ldap_timelimit => \"$attrHash{LDAP_TIMELIMIT}\"";
			$sep = ",";
		}

		print O "\n";
	}
	close O;
}
	
sub BuildLDBFile {
	my $self = shift;
	my $context = shift;
	my $dbh = shift;
	my $cid = shift;
	my $ldapHome = shift || $ENV{LDAP_HOME};

	die "ERROR : no ldaphome" unless ($ldapHome && -d $ldapHome);

	my @cids;
	my @contids;
	my %ccids;
	my $query = $dbh->newquery();;
	my $objHier = ObjHier->new($dbh, "REPOSITORY", $context);;
	print "$objHier\n";
	if ($cid > 0) { @cids = ( $cid ); }
	else {
		$query = $query->clear({ tablename => 'connector'});
		$query->stablerow([[ 'driverid', '=', 'LDAP' ]], 'object_id');
		my $rows = $dbh->execfetchall($query) || [];
		@cids = map { $_->[0] } @$rows;
	}

	foreach my $cid (@cids) {
		$query->clear({ tablename => 'objects' });
		$query->stablerow([[ 'parent_id', '=', $cid ]], 'id');
		print $cid, " : ", $query->query(), "\n";
		my $rows = $dbh->execfetchall($query) || [];
		my @contids = map { $_->[0] } @$rows;
		foreach my $contid (@contids) {
			$objHier->loadobjecthierarchy('container', $contid);
		}
		$self->BuildOneLDBFile ($objHier, $cid, $ldapHome, @contids) if ($#contids > -1);
	}
}


1;
