#!/usr/local/bin/perl
#
# MError.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use Time::ParseDate;

use strict;
package MError;

@MError::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "objectlabel", },
	{ fName => "parent_id" },
	{ fName => "rt_status" },
	{ fName => "object_id" },
	{ fName => "type"},
	{ fName => "status_date"},
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $currpage = $self->_hiddenvar ("_currpage");
	if (($currpage eq 'sflowl') and ($curraction eq 'search')) { $curraction = 'searchs'; }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	#print "<BR>currpage ", $self->_hiddenvar("_currpage"), " OR ", $cgi->param("_currpage"), " prevpage ", $self->_hiddenvar("_prevpage");
	my $idstr = $cgi->param("_flow_subflow_id") if ($cgi->param("_currpage") eq $self->_hiddenvar("_prevpage"));
	#my $idstr = $cgi->param("_flow_subflow_id");
	$idstr = $cgi->param("_objectid") unless ($idstr);
	$self->_hiddenvar("_flow_subflow_id", $idstr);
#	$idstr =~ s/-/;/g;
#	$idstr =~ s/;;/;-/g;
#	$idstr =~ s/^;/-/;
	my $flow_id = $idstr;
	my $subflow_id = $idstr;
	$flow_id =~ s/^([-[:digit:]]+);.*/$1/;
	$subflow_id =~ s/^[-[:digit:]]+;([-[:digit:]]+)$/$1/;
	$flow_id = undef unless ($flow_id =~ /^[[:digit:]]*$/);
	$subflow_id = undef unless ($subflow_id =~ /^[[:digit:]]*$/);
	$self->_datavar("object_id", $flow_id) unless ($self->_datavar("object_id"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	if ($actiondetail eq "search") {
		$actiondetail = $self->_hiddenvar ("_actiondetail", "bottom");
	}

	if ($flow_id) {
		$self->{search1} = $subflow_id;
	}
	else {
		($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
		$self->{search1} = undef unless ($self->{search1} =~ /^[[:digit:]]*$/);
		($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	}

	my $d = Time::ParseDate::parsedate($cgi->param("search3"), UK => 1);
	$d = undef unless ($d =~ /^[[:digit:]]*$/);
	$self->{search3} = $d;

	my $d = Time::ParseDate::parsedate($cgi->param("search4"), UK => 1);
	$d = undef unless ($d =~ /^[[:digit:]]*$/);
	$self->{search3} = $d;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "object_id", "=", $self->{search1} ]; }

#	if ($self->{search2}) {
#		$cond->[++$icond] = [ [ "objects.name", "objects.objectlabel" ], "like", $self->{search2} ];
#	}

	if ($self->{search3}) { $cond->[++$icond] = [ "wrunerrors.error_date", ">=", $self->{search3} ]; }
	if ($self->{search4}) { $cond->[++$icond] = [ "wrunerrors.error_date", "<=", $self->{search4} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("wrunerrors", $cond);
	
	my $qAtt = {
		object_id => $self->{search1},
		objectlabel => $self->{search2},
		error_date1 => $self->{search3},
		error_date2 => $self->{search4},
	};
	my $query = $dbh->newquery($qAtt);
	$query->swrunerrorslist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	if ($flow_id) {
		my $query = $dbh->newquery({ object_id => $flow_id });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_flow} = $row || {};
	}

	if ($subflow_id and ($flow_id != $subflow_id)) {	
		$query = $dbh->newquery({ object_id => $subflow_id });
		$query->ssubflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_subflow} = $row; # || {};
	}
	else {
		$self->{_subflow} = {object_id => 0};
	}

	my %objects = ();
	foreach my $e (@{$self->{_list1}}) {
		$objects{$e->{object_id}} = 1 if ($e->{object_id} > 0);
	}

	my @objs = keys %objects;

	if ($#objs >= 0) {
		$query = $dbh->newquery({ object_id => \@objs });
		$query->sobjectlist();
		my $objdata = $dbh->hexecfetchall($query);
		foreach my $e (@{$self->{_list1}}) {
			$e->{error_text} = substr($e->{error_text},0, 100);
			foreach my $o (@$objdata) {
				if ($o->{object_id} == $e->{object_id}) {
					if ($o->{type} eq 'flow') { $e->{flow_id} = $o->{object_id};       $e->{subflow_id} = $o->{object_id}; }
					elsif ($o->{type} eq 'subflow') { $e->{flow_id} = $o->{parent_id}; $e->{subflow_id} = $o->{object_id}; }
					last;
				}
			}
		}
	}

	# monitoring refreshing
	$self->_monitorvar("refresh", $cgi->param("refreshinterval"));

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "$idstr") if ($flow_id);
	$self->_setnavinfo("list1");
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	my $flow_id;
	my $subflow_id;
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));
	$self->_hiddenvar ("search4", $cgi->param("search4"));

	my $idstr = $cgi->param("_flow_subflow_id");
	$self->_hiddenvar("_flow_subflow_id", $idstr);
	$self->_hiddenvar("object_id", $cgi->param("_objectid"));
	$self->_hiddenvar("_objectid", $idstr);

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query = $dbh->newquery({ error_id => $self->_hiddenvar("object_id") });
	$query->swrunerrorslist();

	$self->{_data} = $dbh->hexecfetchrow($query, 1);
	$flow_id = $self->{_data}{object_id};

	if ($flow_id) {
		my $query = $dbh->newquery({ object_id => $flow_id });
		$query->sobject ();
		my $row = $dbh->hexecfetchrow($query, 1);
		if ($row->{type} eq 'subflow') {
			$query->ssubflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_subflow} = $row; # || {};

			$query = $dbh->newquery({ object_id => $row->{parent_id} });
			$query->sflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_flow} = $row; # || {};
		}
		elsif ($row->{type} eq 'flow') {
			$query->sflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_flow} = $row; # || {};
		}
	}

}

1;
