#!/usr/local/bin/perl
#
# cafXCEL 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdXCEL;
 
#@ISA = (cafDBI);
use strict;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdXCEL::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
=cut
	my $hDb = DBI->connect(
	        "DBI:Excel:file=dbdtest.xls", undef, undef,
			{xl_vtbl =>
			  {TESTV =>
			      {
				 sheetName => 'TEST_V',
				 ttlRow    => 5,
				 startCol  => 1,
				 colCnt    => 4,
				 datRow    => 6,
				 datLmt    => 4,
			      }
			  }
			});
	my %excel_attrs = (
	);
=cut

#	print "NewConnection : ", join (" - ", %{$db->{_ATTRS}}), "\n";
	my %excel_attrs = (
		fileName => $db->{_ATTRS}{FILENAME} || "\n",
	);


#	foreach my $a (keys %excel_attrs) {
#		if ($excel_attrs{$a} !~ /^\\$/) { eval "$excel_attrs{$a} = \"$excel_attrs{$a}\""; }
#	}

	$self->{_XCEL_ATTRS} = \%excel_attrs;
#	$self->{dbh}       = DBI->connect("dbi:Excel:");
	$self->{dbh}       = undef;
	$self;
}


sub xcelattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_XCEL_ATTRS}{$attrib} = shift; }
	$self->{_XCEL_ATTRS}{$attrib};
}
		
sub xcelinfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_XCELINFO}{$infolabel} = shift; }
	$self->{_XCELINFO}{$infolabel};
}

sub clearxcelinfo {
	my $self = shift;

	$self->{_XCELINFO} = undef;
	delete $self->{_XCELINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "u" }
	elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "u" }
	elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "u" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};

#	print "ORIGINAT ORDER : ", join(" - ", map { uc($_->{name}) } @{$container->{_FIELDS}}), "\n";
#	print "EXAMPLE : $container->{_FIELDS}[0]{name} = $container->{_FIELDS}[0]{fieldorder}\n";
	my @fields = sort { $a->{fieldorder} <=> $b->{fieldorder} } @{$container->{_FIELDS}};
#	print "SORTED   ORDER : ", join(" - ", map { uc($_->{name}) } @fields), "\n";
#	print "EXAMPLE : $fields[0]->{name} = $fields[0]->{fieldorder}\n";

	my @acol_names = map { uc($_->{name}) }  @fields; # @{$container->{_FIELDS}};
	my $i = 0;
	my %hcol_names = map { uc($_->{name}) => $i++ } @fields; # @{$container->{_FIELDS}};

	my $scol_names = join(',', @acol_names);

	my $name = $container->{name};
	my $attrs = $container->{_ATTRS};
	my $xl_attrs = {
		$container->{name} => {
			sheetName => $container->{externalname},
			ttlRow    => $attrs->{TITLESROW},
			startCol  => $attrs->{STARTCOL},
			colCnt    => $attrs->{COLCOUNT},
			datRow    => $attrs->{STARTROW},
			datLmt    => $attrs->{ROWSCOUNT},
			acolnames => \@acol_names,
			hcolnames => \%hcol_names,
		}
	};
	use Data::Dumper;
#	print "CONTAINER ATTRIBUTES : "; print Dumper $attrs;
	my $externalname = $self->xcelattrib("fileName");

	$self->xcelinfo("_NAME", $name);
	$self->xcelinfo("_MODE", $mode);
	$self->xcelinfo("_CMD", $cmd);
	$self->xcelinfo("_EXTERNALNAME", $externalname);
	$self->xcelinfo("_SCOLNAMES", $scol_names);
	$self->xcelinfo("_ACOLNAMES", \@acol_names);
	$self->xcelinfo("_VTBL", $xl_attrs);
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->xcelinfo("_NAME")) {
		$self->preprepare($q);
		my ($cmd, $mode) = ($self->xcelinfo($q, "_CMD"),$self->xcelinfo("_MODE"));

		my %attrs = %{$self->{_XCEL_ATTRS}};
		my $tempfile = $self->getfile({ fname => $self->xcelinfo("_EXTERNALNAME"), mode => $mode });
		$self->xcelinfo("_TEMPFILE", $tempfile);

		$self->xcelinfo("_TEMPFILE", $tempfile);
		$attrs{col_names} = $self->xcelinfo("_ACOLNAMES");
=cut
{xl_vtbl =>
                            {TESTV =>
                                {
                                    sheetName => 'TEST_V',
                                    ttlRow    => 5,
                                    startCol  => 1,
                                    colCnt    => 4,
                                    datRow    => 6,
                                    datLmt    => 4,
                                }
                            }
                        });
       xl_fmt
           This attribute is used for setting the formatter class for parsing.
 
       xl_dir
           This attribute is used only with `data_sources' on setting the directory where Excel files ('*.xls') are searched.
           It defaults to the current directory (".").
 
       xl_vtbl
           assumes specified area as a table.  See sample/tex.pl.
 
       xl_skiphidden
           skip hidden rows(=row height is 0) and hidden columns(=column width is 0).  See sample/thidden.pl.
 
       xl_ignorecase
           set casesensitive or not about table name and columns.  Default is sensitive (maybe as SQL::Statement).  See sam
           ple/thidden.pl.
=cut
#	$dbh->{xcel_tables}->{$self->xcelinfo("_NAME")} = \%attrs;
		
		
		my $dsn = "dbi:Excel:file=" . $tempfile; # $self->xcelinfo("_EXTERNALNAME");
		$self->xcelinfo("_DSN", $dsn);
		my $dbh = $self->dbh(DBI->connect($dsn, undef, undef, { xl_vtbl => $self->xcelinfo("_VTBL"), xl_ignorecase => 1, RaiseError => 1 }));
#		print "Connecting OK \n";
=over
		my $sth = $dbh->prepare("select * from TESTV");
#		print "Preparing \n";
		$sth->execute();
#		print "NAME_lc : ", join (" - ", @{$sth->{NAME_lc}}), "\n";
		my $rows = $sth->fetchall_arrayref();
		$rows = $dbh->selectall_arrayref("select * from TESTV");
		use Data::Dumper;
#		print "FETCHED : ", $dbh->errstr(), "\n";
#		print Dumper $rows;
=cut
	}
	return $self->SUPER::prepare($q);
}

sub finalcommit {
	my $self = shift;

	return 1 unless $self->xcelinfo("_NAME");
	if ($self->xcelinfo("_CMD") ne "select") {
		my $tempfile = $self->xcelinfo("_TEMPFILE");
#print "finalcommit saving\n";
		$self->dbh()->func('save');
		$self->protocommit($tempfile, $self->xcelinfo("_EXTERNALNAME"));
	}
	$self->clearxcelinfo();
}

sub finalrollback {
	my $self = shift;

	return 1 unless $self->xcelinfo("_NAME");
	my $tempfile = $self->xcelinfo("_TEMPFILE");
#print "finalcommit saving\n";
	$self->protorollback($tempfile);
	$self->clearxcelinfo();

	1;
}

sub listtables  {
	my $self = shift;
	my $dir = shift;
	my $pattern = shift;

	my $filename = $self->xcelattrib("fileName");
	my $tempfile;

	return undef unless ($filename);
	return undef unless ($tempfile = $self->getfile({ fname => $filename, mode => "r" }));

	my $dbh = $self->dbh(DBI->connect("dbi:Excel:file=$tempfile")); #$filename"));


	my $lpattern = $pattern;
	$lpattern =~ s/%/.*/g;
	$lpattern =~ s/_/./g;

	my @rows;
#	my $sth = $dbh->func('list_tables'); #table_info();
	my @list = $dbh->func('list_tables');
	my $i = -1;
#	while (my $row = $sth->fetchrow_hashref()) 
#		next unless ($row->{TABLE_NAME} =~ /$lpattern/);
	foreach my $table (@list) {
		next unless ($table =~ /$lpattern/);
		$i++;
		$rows[$i] = {
				externalname => $table, #$row->{col3}, #$row->{TABLE_NAME}, 
				name         => $table, #$row->{col3}, #$row->{TABLE_NAME},
				Type         => "SHEET",
				externaltype   => "SHEET",
				Owner        => undef,
				externalschema => undef,
				Remarks      => undef,
				};
	}

	return \@rows;
}


sub describe {
	return [
		{		name          => "col",
				externalname  => "col0",
				datatypeid    => 'VARCHAR',
				datalength    => 100,
				fieldorder    => 10,
				Remarks       => "Generated by cafdXCEL",
				keyposition   => 1,
		}
	];
}

sub generatequery {
	my $self = shift;

	@cafdXCEL::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

sub disconnect {
	my $self = shift;
	$self->protodisconnect();
}

1;
