package AlterDbObjects;

use strict;
#use File::Spec;

sub new {
	my $class = shift;
	my $dbh = shift;
	my $params = shift;
	my %self = %$params;
	my $self = \%self;
	$self->{dbh} = $dbh;
	$self->{dir} = File::Spec->catdir($self->{dir}, "install", "Pg");

	bless $self, $class;
}

sub destroyme {
	my $self = shift;

	foreach my $member (keys %{$self || {}}) {
		delete $self->{$member};
	}
	return undef;
}

sub readXML {
	my $self = shift;
	my $infile = shift;
	my $content = $self->getfilecontent($infile);

	require XML::Simple;


	my $xs = new XML::Simple();

	my $xml = $xs->XMLin($content);

	$xml;
}

sub getfilecontent {
	my $self = shift;
	my $infile = shift;

	my $content;
	{
		open (I, $infile); #"altertables.txt");
		local $/ = undef;
		$content = <I>;
		close(I);
	}
	$content;
}

sub describe {
	my $self = shift;
	my $tablename = shift;
	my $columnname = uc(shift || ".*");
	my $dbh = $self->{dbh};

	my @rows;
	my %c;
	my $sth = $dbh->column_info(undef, undef, $tablename, "%");
	my $i = -1;

	while (my $row = $sth->fetchrow_hashref()) {
		next unless (uc($row->{COLUMN_NAME}) =~ /^$columnname/);
		unless ($c{$row->{COLUMN_NAME}}) {
			$c{$row->{COLUMN_NAME}}=1;
			$i++;
			$rows[$i] = {  externalname => $row->{COLUMN_NAME},
				name			=> $row->{COLUMN_NAME},
				datatypeid	=> uc ($row->{DATA_TYPE} || $row->{SQL_DATA_TYPE}),
				datalength	=> $row->{COLUMN_SIZE},
				datascale	 => $row->{DECIMAL_DIGITS},
				fieldorder	=> $row->{ORDINAL_POSITION},
				nullable	  => $row->{IS_NULLABLE},
				defaultvalue => $row->{COLUMN_DEF},
				Remarks		=> $row->{REMARKS},
			};
		}
	}
	\@rows;
}

sub otherAlterFieldSQL {
	my $self = shift;
	my $object = shift;
	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);

	my @sql;
	if ($object->{default}) {
		push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName SET DEFAULT $object->{default}";
		push @sql, "UPDATE $object->{objname} set $newName = $object->{default} WHERE $newName is NULL";
	}
	if ($object->{dropdefault}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName DROP DEFAULT"; }
	if ($object->{notnull}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName SET NOT NULL"; }
	if ($object->{dropnotnull}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName DROP NOT NULL"; }
	return @sql;
}

sub dropIndexes {
	my $self = shift;
	my $object = shift;

	my @sql;
	my @idxList;
	if ($object->{dropindexes}) { @idxList = @{$object->{dropindexes}}; }
	if ($object->{alterindexes}) { push @idxList, @{$object->{alterindexes}}; }

	foreach my $idx (@idxList) { push @sql, $self->{dropindexes}{$object->{objname}}{$idx} };

	return @sql;
}

sub createIndexes {
	my $self = shift;
	my $object = shift;

	my @idxList;
	my @sql;
	if ($object->{alterindexes}) { push @idxList, @{$object->{alterindexes}}; }

	foreach my $idx (@idxList) { push @sql, $self->{indexes}{$object->{objname}}{$idx} };

	return @sql;
}

sub addFieldSQL {
	my $self = shift;
	my $object = shift;

	my $newName = $object->{names};
	my $newtype = $object->{datatypes};
	my $rebuildIndexes = $object->{rebuildindexes};
	my $default = $object->{default};

	my @sql;

	my $rows = $self->describe($object->{objname}, $newName);
	return undef if ($rows and $rows->[0]);

	my @otherSql = $self->dropIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	push @sql, "ALTER TABLE $object->{objname} add column $newName $newtype";
	my @otherSql = $self->otherAlterFieldSQL($object);
	push (@sql, @otherSql) if (@otherSql);
	my @otherSql = $self->createIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	return @sql;
}

sub alterFieldSQL {
	my $self = shift;
	my $object = shift;

	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);
	my $oldtype = uc($object->{datatypes}[0]);
	my $newtype = $object->{datatypes}[1];
	my $rebuildIndexes = $object->{rebuildindexes};
	my $default = $object->{default};
	my $randName = "C_" . int(rand(10000));

	my @sql;

	my $rows = $self->describe($object->{objname}, $oldName);
	return undef unless ($rows and (uc($rows->[0]{datatypeid}) =~ /^$oldtype/));

	my @otherSql = $self->dropIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	push @sql, "ALTER TABLE $object->{objname} add column $randName $newtype";
	if ($object->{convert}) { push @sql, "UPDATE $object->{objname} set $randName = $object->{convert}"; }
	push @sql, "ALTER TABLE $object->{objname} DROP column $oldName";
	push @sql, "ALTER TABLE $object->{objname} RENAME column $randName TO $newName";
	my @otherSql = $self->otherAlterFieldSQL($object);
	push (@sql, @otherSql) if (@otherSql);
	my @otherSql = $self->createIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	return @sql;
}

sub renameFieldSQL {
	my $self = shift;
	my $object = shift;
	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);
	my $oldtype = uc($object->{datatypes}[0]);
	my $newtype = $object->{datatypes}[1];
	my $rebuildIndexes = $object->{rebuildindexes};

	my $rows = $self->describe($object->{objname}, $oldName);
	return undef unless ($rows and $rows->[0]);
	my $rows = $self->describe($object->{objname}, $newName);
	return undef if ($rows and $rows->[0]);

	return undef unless ($newName and ($newName ne $oldName));
	my @sql;
	my @otherSql = $self->dropIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	push @sql, "ALTER TABLE $object->{objname} RENAME column $oldName TO $newName";
	my @otherSql = $self->otherAlterFieldSQL($object);
	push (@sql, @otherSql) if (@otherSql);
	my @otherSql = $self->createIndexes($object);
	push (@sql, @otherSql) if (@otherSql);
	return @sql;
}

sub generateSQL {
	my $self = shift;
	my $alterList = shift->{alterdefs} || [];
	my @sqlList;
	require DBI;
	foreach my $object (@$alterList) {
		if ($object->{objtype} eq "table") {
			if ($object->{action} eq "alterfield") {
				my @sql = $self->alterFieldSQL($object);
				push (@sqlList, @sql) if (@sql and ($#sql >= 0));
			}
			elsif ($object->{action} eq "renamefield") {
				my @sql = $self->renameFieldSQL($object);
				push (@sqlList, @sql) if (@sql and ($#sql >= 0));
			}
			elsif ($object->{action} eq "addfield") {
				my @sql = $self->addFieldSQL($object);
				push (@sqlList, @sql) if (@sql and ($#sql >= 0));
			}
		}
	}
	return \@sqlList;
}

sub processSQL {
	my $self = shift;
	my $sqlList = shift || [];

	my $dbh = $self->{dbh};
	foreach my $sql (@$sqlList) {
		eval { $dbh->do($sql); };
		if ($@) { cafDbg->pusherror("MIGRATE DB; $@ During SQL query : <I>$sql</I>"); die ""; }
	}
}

sub dumpobject {
   my $object = shift;
   my $varname = shift || "object";
   use Data::Dumper;
   my $dump = Data::Dumper->new([$object], [$varname]);
   $dump->Indent(1);
   my $ptext = $dump->Dump;
	$ptext =~ s/\n/<BR>\n/g;
   print $ptext;
}

sub go {
	my $self = shift;

	if (opendir(D, $self->{dir})) {
		my @files = readdir(D);
		close D;
		foreach my $f (@files) {
			next unless ($f =~ /updatedb_(.*).xml/);
			my $version = $1;
			next unless ($version ge $self->{version});
			my $file = File::Spec->catfile($self->{dir}, $f);
			my $xml = $self->readXML($file);
			if ($xml) {
				my $sqlList = $self->generateSQL($xml);
				$self->processSQL($sqlList) if ($sqlList);
			}
		}
	}
}

1;
