
#package SOAP::Transport::TCP::Server::ForkOnAccept;
package SOAPTCPWS;

use SOAP::Transport::TCP;

use IO::SessionSet;

use vars qw($AUTOLOAD @ISA);
@ISA = qw(SOAP::Transport::TCP::Server);

sub AcceptFrom {
	my $self = shift;
	my $a = $self->{__CAFETERRA__}{ACCEPTFROMSTR} = shift || '*';
	$a =~ s/\./\\\./g;
	$a =~ s/\*/\\\.\*/g;
	my @a = split (";", $a);
	$self->{__CAFETERRA__}{ACCEPTFROMARR} = \@a;
}

sub CanAccept {
	my $self = shift;
	my $addr = shift;

	return 1 unless ($self->{__CAFETERRA__}{ACCEPTFROMSTR});
	foreach my $pat (@{$self->{__CAFETERRA__}{ACCEPTFROMARR}}) {
		if ($addr =~ /^$pat$/) { return 1; }
	}
	return undef;
}

sub PeerAddress {
	my $self = shift;
	if (@_) { $self->{__CAFETERRA__}{PEERADDRESS} = shift; }
	$self->{__CAFETERRA__}{PEERADDRESS};
}

sub handle {
	my $self = shift->new;
	my $sock = $self->{_socket};
	my $session_set = IO::SessionSet->new($sock);
	my %data;
	while (1) {
		my @ready = $session_set->wait($sock->timeout);
		for my $session (@ready) {
			if (! $self->CanAccept($session->peerhost)) { $session->close; next; }
			my $data;
			if (my $rc = $session->read($data, 4096)) {
				$data{$session} .= $data if $rc > 0;
			} else {
				my $sessiondata = delete $data{$session};
				my $pid = fork();

				# We are going to close the new connection on one of two conditions
				#	1. The fork failed ($pid is undefined)
				#	2. We are the parent ($pid != 0)
				unless(defined $pid && $pid == 0) {
					$session->close;
					next;
				}
				
				$self->PeerAddress ($session->peerhost);
				$session->write($self->SUPER::handle($sessiondata));
				$session->close;
				return;
			}
		}
	}
}

1;
