<?php

require_once "calpp_config.inc";
require_once "$CLP_BASE/authentication.inc";
require_once "$CLP_BASE/db_pgsql_lib.inc";

echo "<h3>db_pgsql_lib.inc functions</h3>";

/*
db_pgsql_lib.inc 
    Show_Sql ($sql, $fmt_table="<table border=0>", $col_head="")
    Retn_Sql_Table ($sql, $fmt_table="<table border=1>", $col_head="")	
    Retn_Sql_Result ($sql)
    Retn_Result($sql)
    Retn_Row_Count($sql)
    Retn_Row ($sql)   
    Exec_Sql ($sql)
    Retn_ID($oid, $table)    
    Retn_Sql_Array($sql)
    Retn_Key_Value_Array($sql)
    Retn_Sql_Single_Col_Array($sql)
    fmt_ind_rs($cur)
*/ 
$sql = "select contact_id, name, qualification from contacts limit 10 offset 10";
echo "<h4>SQL:  $sql</h4>";

// Retn_Sql_Array($sql)
echo "<h4>Retn_Sql_Array(sql):Returns an Array of Rows as arrays</h4>";
$result = Retn_Sql_Array($sql);
while (list($key, $value)=each($result)){
    echo "<table border=1 style=\"border-collapse:collapse\">";
    echo "<tr><td><b>key</b><td><b>value</b>";
    while (list($k, $v)=each($value)){
	echo "<tr><td>$k<td>$v";
    }
    echo "</table>";
}
echo "<hr>";

// Retn_Key_Value_Array ($sql)
echo "<h4>Retn_Key_Value_Array(sql):Returns Array of ID as Key and cats rest of row into value</h4>";
echo "<p>This function is suitable for select boxes in forms, and also generating links";
$result = Retn_Key_Value_Array($sql); 
echo "<table border=1 style=\"border-collapse:collapse\">";
echo "<tr><td><b>key</b><td><b>value</b>";
while (list($key, $value)=each($result)){
    echo "<tr><td>$key<td>$value";
} 
   
echo "</table>";
echo "<hr>";

// Retn_Sql_Single_Col_Array($sql)
echo "<h4>Retn_Sql_Single_Col_Array(sql):Returns the entire result as a single column value array</h4>";
$result = Retn_Sql_Single_Col_Array($sql);
echo "<table border=1 style=\"border-collapse:collapse\">";
echo "<tr><td><b>key</b><td><b>value</b>";
while (list($key, $value)=each($result)){
    echo "<tr><td>$key<td>$value";
} 
   
echo "</table>";
echo "<hr>";

// Retn_Sql_Result ($sql)
echo "<h4>Retn_Sql_Result(sql):cat result of sql</h4>";
$result = Retn_Sql_Result($sql);
echo $result;
echo "<hr>";

// Retn_Result ($sql)
echo "<h4>Retn_Result(sql):return row 0 col 0 of result</h4>";
$result = Retn_Result($sql);
echo $result;
echo "<hr>";

// Retn_Row_Count(sql)
echo "<h4>Retn_Row_Count(sql): Return row count</h4>";
$result = Retn_Row_Count($sql);
echo "<p><b>Retn_Row_Count = </b>$result<hr>";


// Retn_Row(sql)
echo "<h4>Retn_Row(sql): Returns only the first row of result</h4>";
$result = Retn_Row($sql);
echo "<table border=1 style=\"border-collapse:collapse\">";
echo "<tr><td><b>key</b><td><b>value</b>";
while (list($key, $value)=each($result)){
    echo "<tr><td>$key<td>$value";
}
echo "</table>";
echo "<hr>";

// Show_Sql(sql)
echo "<h4>Show_Sql</h4>";
Show_Sql ($sql, $fmt_table="<table border=1 style=\"border-collapse:collapse\">", $col_head="<td>Contact_Id<td>Name<td>Qualification");

// fmt_ind_rs(cur)
echo "<h4>fmt_ind_rs(cur)</h4>";
$cur[]= 0;
$cur[] = 0.0000;
$cur[] = 0.0005;
$cur[] = 0.0049;
$cur[] = 0.0050;
$cur[] = 0.4563;
$cur[] = 2.4563;
$cur[]= 2.23456E4;
for ($i=1; $i<21; $i++){
    $cur[] = str_repeat('9', $i);
}

echo "<table border=1 style=\"border-collapse:collapse\">";
echo "<tr><td>INPUT<td>OUTPUT<td>NEGATIVE INPUT<td>NEGATIVE OUTPUT";
while (list($key, $value)=each($cur)){
    $result = fmt_ind_rs($value);
    $neg_value = "-" . $value;
    $neg_value = (float)$neg_value;
    $neg_result = fmt_ind_rs($neg_value);
    echo "<tr><td align=right>$value<td align=right>$result<td align=right>$neg_value<td align=right>$neg_result";
}
echo "</table>";


echo "<p><b>fmt_ind_rs(cur) todo: </b>handle formatting of currencies greater or lesser than 1E+15";
echo "<hr>";



?>